import{s as Vi,o as qi,n as Bi}from"../chunks/scheduler.37c15a92.js";import{S as _i,i as Wi,g as i,s as n,r as o,A as Qi,h as p,f as t,c as a,j as Zi,u,x as r,k as pa,y as Ni,a as l,v as c,d as m,t as M,w as d}from"../chunks/index.2bf4358c.js";import{T as Xi}from"../chunks/Tip.363c041f.js";import{Y as Ri}from"../chunks/Youtube.1e50a667.js";import{C as J}from"../chunks/CodeBlock.4e987730.js";import{C as Ai}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as mt,E as Li}from"../chunks/getInferenceSnippets.8b9eb92a.js";function Hi(Mt){let y,k=`<strong>Pour aller plus loin</strong> Si vous testez les deux versions des normaliseurs précédents sur une chaîne contenant le caractère unicode <code>u&quot;\\u0085&quot;</code> vous remarquerez sûrement qu’ils ne sont pas exactement équivalents.
Pour ne pas trop compliquer la version avec <code>normalizers.Sequence</code>, nous n’avons pas inclus les Regex que le <code>BertNormalizer</code> requiert quand l’argument <code>clean_text</code> est mis à <code>True</code> ce qui est le comportement par défaut. Mais ne vous inquiétez pas : il est possible d’obtenir exactement la même normalisation sans utiliser le très pratique <code>BertNormalizer</code> en ajoutant deux <code>normalizers.Replace</code> à la séquence de normalisation.`;return{c(){y=i("p"),y.innerHTML=k},l(j){y=p(j,"P",{"data-svelte-h":!0}),r(y)!=="svelte-5i2npl"&&(y.innerHTML=k)},m(j,ut){l(j,y,ut)},p:Bi,d(j){j&&t(y)}}}function Gi(Mt){let y,k,j,ut,b,dt,$,Jt,U,ra="Comme nous l’avons vu dans les sections précédentes, la tokenisation comprend plusieurs étapes :",yt,w,oa="<li>normalisation (tout nettoyage du texte jugé nécessaire, comme la suppression des espaces ou des accents, la normalisation Unicode, etc.),</li> <li>prétokénisation (division de l’entrée en mots),</li> <li>passage de l’entrée dans le modèle (utilisation des mots prétokénisés pour produire une séquence de <em>tokens</em>),</li> <li>post-traitement (ajout des <em>tokens</em> spéciaux du <em>tokenizer</em>, génération du masque d’attention et des identifiants du type de <em>token</em>).</li>",jt,h,ua="Pour mémoire, voici un autre aperçu du processus global :",Tt,T,ca='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline.svg" alt="The tokenization pipeline."/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline-dark.svg" alt="The tokenization pipeline."/>',ft,g,ma='La bibliothèque 🤗 <em>Tokenizers</em> a été construite pour fournir plusieurs options pour chacune de ces étapes. Vous pouvez les mélanger et assortir ensemble. Dans cette section, nous verrons comment nous pouvons construire un <em>tokenizer</em> à partir de zéro, par opposition à entraîner un nouveau <em>tokenizer</em> à partir d’un ancien, comme nous l’avons fait dans <a href="/course/fr/chapter6/2">section 2</a>. Vous serez alors en mesure de construire n’importe quel type de <em>tokenizer</em> auquel vous pouvez penser !',kt,x,bt,z,Ma="Plus précisément, la bibliothèque est construite autour d’une classe centrale <code>Tokenizer</code> avec les blocs de construction regroupés en sous-modules :",$t,v,da='<li><code>normalizers</code> contient tous les types de <code>Normalizer</code> que vous pouvez utiliser (liste complète <a href="https://huggingface.co/docs/tokenizers/api/normalizers" rel="nofollow">ici</a>),</li> <li><code>pre_tokenizers</code> contient tous les types de <code>PreTokenizer</code> que vous pouvez utiliser (liste complète <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">ici</a>),</li> <li><code>models</code> contient les différents types de <code>Model</code> que vous pouvez utiliser, comme <code>BPE</code>, <code>WordPiece</code>, et <code>Unigram</code> (liste complète <a href="https://huggingface.co/docs/tokenizers/api/models" rel="nofollow">ici</a>),</li> <li><code>trainers</code> contient tous les différents types de <code>Trainer</code> que vous pouvez utiliser pour entraîner votre modèle sur un corpus (un par type de modèle ; liste complète <a href="https://huggingface.co/docs/tokenizers/api/trainers" rel="nofollow">ici</a>),</li> <li><code>post_processors</code> contient les différents types de <code>PostProcessor</code> que vous pouvez utiliser (liste complète <a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">ici</a>),</li> <li><code>decoders</code> contient les différents types de <code>Decoder</code> que vous pouvez utiliser pour décoder les sorties de tokenization (liste complète <a href="https://huggingface.co/docs/tokenizers/components#decoders" rel="nofollow">ici</a>).</li>',Ut,I,Ja='Vous pouvez trouver la liste complète des blocs de construction <a href="https://huggingface.co/docs/tokenizers/components" rel="nofollow">ici</a>.',wt,C,ht,Z,ya='Pour entraîner notre nouveau <em>tokenizer</em>, nous utiliserons un petit corpus de texte (pour que les exemples soient rapides). Les étapes pour acquérir ce corpus sont similaires à celles que nous avons suivies au <a href="/course/fr/chapter6/2">début du chapitre</a>, mais cette fois nous utiliserons le jeu de données <a href="https://huggingface.co/datasets/wikitext" rel="nofollow">WikiText-2</a> :',gt,V,xt,q,ja="La fonction <code>get_training_corpus()</code> est un générateur qui donne des batchs de 1 000 textes, que nous utiliserons pour entraîner le <em>tokenizer</em>.",zt,B,Ta="🤗 <em>Tokenizers</em> peut aussi être entraîné directement sur des fichiers texte. Voici comment nous pouvons générer un fichier texte contenant tous les textes de WikiText-2 que nous pourrons ensuite utilisé en local :",vt,_,It,W,fa="Ensuite, nous vous montrerons comment construire vos propres <em>tokenizers</em> pour BERT, GPT-2 et XLNet, bloc par bloc. Cela vous donnera un exemple de chacun des trois principaux algorithmes de tokenisation : <em>WordPiece</em>, BPE et <em>Unigram</em>. Commençons par BERT !",Ct,Q,Zt,N,ka="Pour construire un <em>tokenizer</em> avec la bibliothèque 🤗 <em>Tokenizers</em>, nous commençons par instancier un objet <code>Tokenizer</code> avec un <code>model</code>. Puis nous définissons ses attributs <code>normalizer</code>, <code>pre_tokenizer</code>, <code>post_processor</code> et <code>decoder</code> aux valeurs que nous voulons.",Vt,X,ba="Pour cet exemple, nous allons créer un <code>Tokenizer</code> avec un modèle <em>WordPiece</em> :",qt,R,Bt,A,$a="Nous devons spécifier le <code>unk_token</code> pour que le modèle sache quoi retourner lorsqu’il rencontre des caractères qu’il n’a pas vu auparavant. D’autres arguments que nous pouvons définir ici incluent le <code>vocab</code> de notre modèle (nous allons entraîner le modèle, donc nous n’avons pas besoin de le définir) et <code>max_input_chars_per_word</code>, qui spécifie une longueur maximale pour chaque mot (les mots plus longs que la valeur passée seront séparés).",_t,L,Ua="La première étape de la tokénisation est la normalisation. Puisque BERT est largement utilisé, une fonction <code>BertNormalizer</code> a été créée avec les options classiques que nous pouvons définir pour BERT : <code>lowercase</code> pour mettre le texte en minuscule, <code>strip_accents</code> qui enlève les accents, <code>clean_text</code> pour enlever tous les caractères de contrôle et fusionner des espaces répétés par un seul, et <code>handle_chinese_chars</code> qui place des espaces autour des caractères chinois. Pour reproduire le <em>tokenizer</em> <code>bert-base-uncased</code>, nous pouvons simplement définir ce <em>normalizer</em> :",Wt,H,Qt,G,wa="Cependant, généralement, lorsque vous construisez un nouveau <em>tokenizer</em>, vous n’avez pas accès à un normaliseur aussi pratique déjà implémenté dans la bibliothèque 🤗 <em>Tokenizers</em>. Donc voyons comment créer le normaliseur de BERT manuellement. La bibliothèque fournit un normaliseur <code>Lowercase</code> et un normaliseur <code>StripAccents</code>. Il est possible de composer plusieurs normaliseurs en utilisant une <code>Sequence</code> :",Nt,E,Xt,D,ha="Nous utilisons également un normaliseur Unicode <code>NFD</code>, car sinon <code>StripAccents</code> ne reconnaîtra pas correctement les caractères accentués et ne les supprimera donc pas.",Rt,S,ga="Comme nous l’avons vu précédemment, nous pouvons utiliser la méthode <code>normalize_str()</code> du <code>normalizer</code> pour vérifier les effets qu’il a sur un texte donné :",At,P,Lt,F,Ht,f,Gt,Y,xa="L’étape suivante est la prétokenisation. Encore une fois, il y a un <code>BertPreTokenizer</code> préconstruit que nous pouvons utiliser :",Et,K,Dt,O,za="Ou nous pouvons le construire à partir de zéro :",St,ee,Pt,se,va="Notez que le <code>Whitespace</code> divise sur les espaces et tous les caractères qui ne sont pas des lettres, des chiffres ou le caractère de soulignement. Donc techniquement il divise sur les espaces et la ponctuation :",Ft,te,Yt,le,Kt,ne,Ia="Si vous voulez seulement séparer sur les espaces, vous devez utiliser <code>WhitespaceSplit</code> à la place :",Ot,ae,el,ie,sl,pe,Ca="Comme pour les normaliseurs, vous pouvez utiliser une <code>Sequence</code> pour composer plusieurs prétokenizers :",tl,re,ll,oe,nl,ue,Za="L’étape suivante dans le pipeline de tokénisation est de faire passer les entrées par le modèle. Nous avons déjà spécifié notre modèle dans l’initialisation, mais nous devons encore l’entraîner, ce qui nécessitera un <code>WordPieceTrainer</code>. La principale chose à retenir lors de l’instanciation d’un entraîneur dans 🤗 <em>Tokenizers</em> est que vous devez lui passer tous les <em>tokens</em> spéciaux que vous avez l’intention d’utiliser. Sinon il ne les ajoutera pas au vocabulaire puisqu’ils ne sont pas dans le corpus d’entraînement :",al,ce,il,me,Va="En plus de spécifier la <code>vocab_size</code> et les <code>special_tokens</code>, nous pouvons définir la <code>min_frequency</code> (le nombre de fois qu’un <em>token</em> doit apparaître pour être inclus dans le vocabulaire) ou changer le <code>continuing_subword_prefix</code> (si nous voulons utiliser quelque chose de différent de <code>##</code>).",pl,Me,qa="Pour entraîner notre modèle en utilisant l’itérateur que nous avons défini plus tôt, il suffit d’exécuter cette commande :",rl,de,ol,Je,Ba="Nous pouvons également utiliser des fichiers texte pour entraîner notre <em>tokenizer</em> qui ressemblerait alors à ceci (nous réinitialisons le modèle avec un <code>WordPiece</code> vide au préalable) :",ul,ye,cl,je,_a="Dans les deux cas, nous pouvons ensuite tester le <em>tokenizer</em> sur un texte en appelant la méthode <code>encode()</code> :",ml,Te,Ml,fe,dl,ke,Wa="L’encodage obtenu est un <code>Encoding</code> contenant toutes les sorties nécessaires du <em>tokenizer</em> dans ses différents attributs : <code>ids</code>, <code>type_ids</code>, <code>tokens</code>, <code>offsets</code>, <code>attention_mask</code>, <code>special_tokens_mask</code> et <code>overflowing</code>.",Jl,be,Qa="La dernière étape du pipeline de tokénisation est le post-traitement. Nous devons ajouter le <em>token</em> <code>[CLS]</code> au début et le <em>token</em> <code>[SEP]</code> à la fin (ou après chaque phrase si nous avons une paire de phrases). Nous utiliserons <code>TemplateProcessor</code> pour cela, mais d’abord nous devons connaître les identifiants des <em>tokens</em> <code>[CLS]</code> et <code>[SEP]</code> dans le vocabulaire :",yl,$e,jl,Ue,Tl,we,Na="Pour écrire le gabarit pour <code>TemplateProcessor</code>, nous devons spécifier comment traiter une seule phrase et une paire de phrases. Pour les deux, nous écrivons les <em>tokens</em> spéciaux que nous voulons utiliser. La première (ou unique) phrase est représentée par <code>$A</code>, alors que la deuxième phrase (si on code une paire) est représentée par <code>$B</code>. Pour chacun de ces éléments (<em>tokens</em> spéciaux et phrases), nous spécifions également l’identifiant du <em>token</em> correspondant après un deux-points.",fl,he,Xa="Le gabarit classique de BERT est donc défini comme suit :",kl,ge,bl,xe,Ra="Notez que nous devons transmettre les identifiants des <em>tokens</em> spéciaux afin que le <em>tokenizer</em> puisse les convertir correctement.",$l,ze,Aa="Une fois cela ajouté, revenons à notre exemple précédent donnera :",Ul,ve,wl,Ie,hl,Ce,La="Et sur une paire de phrases, on obtient le bon résultat :",gl,Ze,xl,Ve,zl,qe,Ha="Nous avons presque fini de construire ce <em>tokenizer</em> à partir de zéro. La dernière étape consiste à inclure un décodeur :",vl,Be,Il,_e,Ga="Testons-le sur notre précédent <code>encoding</code> :",Cl,We,Zl,Qe,Vl,Ne,Ea="Génial ! Nous pouvons enregistrer notre <em>tokenizer</em> dans un seul fichier JSON comme ceci :",ql,Xe,Bl,Re,Da="Nous pouvons alors recharger ce fichier dans un objet <code>Tokenizer</code> avec la méthode <code>from_file()</code> :",_l,Ae,Wl,Le,Sa="Pour utiliser ce <em>tokenizer</em> dans 🤗 <em>Transformers</em>, nous devons l’envelopper dans un <code>PreTrainedTokenizerFast</code>. Nous pouvons soit utiliser la classe générique, soit, si notre <em>tokenizer</em> correspond à un modèle existant, utiliser cette classe (ici, <code>BertTokenizerFast</code>). Si vous appliquez cette logique pour construire un tout nouveau <em>tokenizer</em>, vous devrez utiliser la première option.",Ql,He,Pa="Pour envelopper le <em>tokenizer</em> dans un <code>PreTrainedTokenizerFast</code>, nous pouvons soit passer le <em>tokenizer</em> que nous avons construit comme un <code>tokenizer_object</code>, soit passer le fichier de <em>tokenizer</em> que nous avons sauvegardé comme <code>tokenizer_file</code>. Ce qu’il faut retenir, c’est que nous devons définir manuellement tous les <em>tokens</em> spéciaux car cette classe ne peut pas déduire de l’objet <code>tokenizer</code> quel <em>token</em> est le <em>token</em> de masque, quel est le <em>token</em><code>[CLS]</code>, etc :",Nl,Ge,Xl,Ee,Fa="Si vous utilisez une classe de <em>tokenizer</em> spécifique (comme <code>BertTokenizerFast</code>), vous aurez seulement besoin de spécifier les <em>tokens</em> spéciaux qui sont différents de ceux par défaut (ici, aucun) :",Rl,De,Al,Se,Ya="Vous pouvez ensuite utiliser ce <em>tokenizer</em> comme n’importe quel autre <em>tokenizer</em> de 🤗 <em>Transformers</em>. Vous pouvez le sauvegarder avec la méthode <code>save_pretrained()</code> ou le télécharger sur le <em>Hub</em> avec la méthode <code>push_to_hub()</code>.",Ll,Pe,Ka="Maintenant que nous avons vu comment construire un <em>tokenizer WordPiece</em>, faisons de même pour un <em>tokenizer</em> BPE. Nous irons un peu plus vite puisque vous connaissez toutes les étapes. Nous ne soulignerons que les différences.",Hl,Fe,Gl,Ye,Oa="Construisons maintenant un <em>tokenizer</em> BPE. Comme pour le <em>tokenizer</em> BERT, nous commençons par initialiser un <code>Tokenizer</code> avec un modèle BPE :",El,Ke,Dl,Oe,ei="Comme pour BERT, nous pourrions initialiser ce modèle avec un vocabulaire si nous en avions un (nous aurions besoin de passer le <code>vocab</code> et le <code>merges</code> dans ce cas), mais puisque nous allons nous entraîner à partir de zéro, nous n’avons pas besoin de le faire. Nous n’avons pas non plus besoin de spécifier un <code>unk_token</code> parce que le GPT-2 utilise un BPE au niveau de l’octet.",Sl,es,si="GPT-2 n’utilise pas de normaliseur, donc nous sautons cette étape et allons directement à la prétokénisation :",Pl,ss,Fl,ts,ti="L’option que nous avons ajoutée à <code>ByteLevel</code> ici est de ne pas ajouter d’espace en début de phrase (ce qui est le cas par défaut). Nous pouvons jeter un coup d’oeil à la prétokénisation d’un texte d’exemple comme avant :",Yl,ls,Kl,ns,Ol,as,li="Vient ensuite le modèle, qui doit être entraîné. Pour le GPT-2, le seul <em>token</em> spécial est le <em>token</em> de fin de texte :",en,is,sn,ps,ni="Comme avec le <code>WordPieceTrainer</code>, ainsi que le <code>vocab_size</code> et le <code>special_tokens</code>, nous pouvons spécifier la <code>min_frequency</code> si nous le voulons, ou si nous avons un suffixe de fin de mot (comme <code>&lt;/w&gt;</code>), nous pouvons le définir avec <code>end_of_word_suffix</code>.",tn,rs,ai="Ce <em>tokenizer</em> peut aussi être entraîné sur des fichiers texte :",ln,os,nn,us,ii="Regardons la tokenisation d’un exemple de texte :",an,cs,pn,ms,rn,Ms,pi="Nous appliquons le post-traitement au niveau de l’octet pour le <em>tokenizer</em> du GPT-2 comme suit :",on,ds,un,Js,ri="L’option <code>trim_offsets = False</code> indique au post-processeur que nous devons laisser les <em>offsets</em> des <em>tokens</em> qui commencent par ‘Ġ’ tels quels : de cette façon, le début des <em>offsets</em> pointera sur l’espace avant le mot, et non sur le premier caractère du mot (puisque l’espace fait techniquement partie du <em>token</em>). Regardons le résultat avec le texte que nous venons de coder, où <code>&#39;Ġtest&#39;</code> est le <em>token</em> à l’index 4 :",cn,ys,mn,js,Mn,Ts,oi="Enfin, nous ajoutons un décodeur au niveau de l’octet :",dn,fs,Jn,ks,ui="et nous pouvons vérifier qu’il fonctionne correctement :",yn,bs,jn,$s,Tn,Us,ci="Super ! Maintenant que nous avons terminé, nous pouvons sauvegarder le tokenizer comme avant, et l’envelopper dans un <code>PreTrainedTokenizerFast</code> ou un <code>GPT2TokenizerFast</code> si nous voulons l’utiliser dans 🤗 <em>Transformers</em> :",fn,ws,kn,hs,mi="ou :",bn,gs,$n,xs,Mi="Comme dernier exemple, nous allons vous montrer comment construire un <em>tokenizer</em> <em>Unigram</em> à partir de zéro.",Un,zs,wn,vs,di="Construisons maintenant un <em>tokenizer</em> XLNet. Comme pour les <em>tokenizers</em> précédents, nous commençons par initialiser un <code>Tokenizer</code> avec un modèle <em>Unigram</em> :",hn,Is,gn,Cs,Ji="Encore une fois, nous pourrions initialiser ce modèle avec un vocabulaire si nous en avions un.",xn,Zs,yi="Pour la normalisation, XLNet utilise quelques remplacements (qui proviennent de <em>SentencePiece</em>) :",zn,Vs,vn,qs,ji="Il remplace <code>“</code> et <code>”</code> par <code>”</code> et toute séquence de deux espaces ou plus par un seul espace, de plus il supprime les accents.",In,Bs,Ti="Le prétokenizer à utiliser pour tout <em>tokenizer SentencePiece</em> est <code>Metaspace</code> :",Cn,_s,Zn,Ws,fi="Nous pouvons jeter un coup d’oeil à la prétokénisation sur le même exemple de texte que précédemment :",Vn,Qs,qn,Ns,Bn,Xs,ki="Vient ensuite le modèle, qui doit être entraîné. XLNet possède un certain nombre de <em>tokens</em> spéciaux :",_n,Rs,Wn,As,bi="Un argument très important à ne pas oublier pour le <code>UnigramTrainer</code> est le <code>unk_token</code>. Nous pouvons aussi passer d’autres arguments spécifiques à l’algorithme <em>Unigram</em>, comme le <code>shrinking_factor</code> pour chaque étape où nous enlevons des <em>tokens</em> (par défaut 0.75) ou le <code>max_piece_length</code> pour spécifier la longueur maximale d’un <em>token</em> donné (par défaut 16).",Qn,Ls,$i="Ce <em>tokenizer</em> peut aussi être entraîné sur des fichiers texte :",Nn,Hs,Xn,Gs,Ui="Regardons la tokenisation de notre exemple :",Rn,Es,An,Ds,Ln,Ss,wi="Une particularité de XLNet est qu’il place le <em>token</em> <code>&lt;cls&gt;</code> à la fin de la phrase, avec un identifiant de 2 (pour le distinguer des autres <em>tokens</em>). Le résultat est un remplissage à gauche. Nous pouvons traiter tous les <em>tokens</em> spéciaux et les types d’identifiant de <em>token</em> avec un modèle, comme pour BERT. Mais d’abord nous devons obtenir les identifiants des <em>tokens</em> <code>&lt;cls&gt;</code> et <code>&lt;sep&gt;</code> :",Hn,Ps,Gn,Fs,En,Ys,hi="Le modèle ressemble à ceci :",Dn,Ks,Sn,Os,gi="Et nous pouvons tester son fonctionnement en codant une paire de phrases :",Pn,et,Fn,st,Yn,tt,xi="Enfin, nous ajoutons un décodeur <code>Metaspace</code> :",Kn,lt,On,nt,zi="et on en a fini avec ce <em>tokenizer</em> ! On peut le sauvegarder et l’envelopper dans un <code>PreTrainedTokenizerFast</code> ou <code>XLNetTokenizerFast</code> si on veut l’utiliser dans 🤗 <em>Transformers</em>. Une chose à noter lors de l’utilisation de <code>PreTrainedTokenizerFast</code> est qu’en plus des <em>tokens</em> spéciaux, nous devons dire à la bibliothèque 🤗 <em>Transformers</em> de rembourrer à gauche :",ea,at,sa,it,vi="Ou alternativement :",ta,pt,la,rt,Ii="Maintenant que vous avez vu comment les différentes briques sont utilisées pour construire des <em>tokenizers</em> existants, vous devriez être capable d’écrire n’importe quel <em>tokenizer</em> que vous voulez avec la bibliothèque 🤗 <em>Tokenizers</em> et pouvoir l’utiliser dans 🤗 <em>Transformers</em>.",na,ot,aa,ct,ia;return b=new mt({props:{title:"Construction d’un <i> tokenizer </i> , bloc par bloc",local:"construction-dun-i-tokenizer-i--bloc-par-bloc",headingTag:"h1"}}),$=new Ai({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter6/section8.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section8.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter6/section8.ipynb"}]}}),x=new Ri({props:{id:"MR8tZm5ViWU"}}),C=new mt({props:{title:"Acquisition d’un corpus",local:"acquisition-dun-corpus",headingTag:"h2"}}),V=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ3aWtpdGV4dCUyMiUyQyUyMG5hbWUlM0QlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBJTBBZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihkYXRhc2V0KSUyQyUyMDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBkYXRhc2V0JTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIydGV4dCUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, name=<span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> dataset[i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),_=new J({props:{code:"d2l0aCUyMG9wZW4oJTIyd2lraXRleHQtMi50eHQlMjIlMkMlMjAlMjJ3JTIyJTJDJTIwZW5jb2RpbmclM0QlMjJ1dGYtOCUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZGF0YXNldCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShkYXRhc2V0JTVCaSU1RCU1QiUyMnRleHQlMjIlNUQlMjAlMkIlMjAlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)):
        f.write(dataset[i][<span class="hljs-string">&quot;text&quot;</span>] + <span class="hljs-string">&quot;\\n&quot;</span>)`,wrap:!1}}),Q=new mt({props:{title:"Construire un <i> tokenizer WordPiece </i> à partir de zéro",local:"construire-un-i-tokenizer-wordpiece-i-à-partir-de-zéro",headingTag:"h2"}}),R=new J({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwZGVjb2RlcnMlMkMlMEElMjAlMjAlMjAlMjBtb2RlbHMlMkMlMEElMjAlMjAlMjAlMjBub3JtYWxpemVycyUyQyUwQSUyMCUyMCUyMCUyMHByZV90b2tlbml6ZXJzJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29ycyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluZXJzJTJDJTBBJTIwJTIwJTIwJTIwVG9rZW5pemVyJTJDJTBBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMFRva2VuaXplcihtb2RlbHMuV29yZFBpZWNlKHVua190b2tlbiUzRCUyMiU1QlVOSyU1RCUyMikp",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> (
    decoders,
    models,
    normalizers,
    pre_tokenizers,
    processors,
    trainers,
    Tokenizer,
)

tokenizer = Tokenizer(models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>))`,wrap:!1}}),H=new J({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5CZXJ0Tm9ybWFsaXplcihsb3dlcmNhc2UlM0RUcnVlKQ==",highlighted:'tokenizer.normalizer = normalizers.BertNormalizer(lowercase=<span class="hljs-literal">True</span>)',wrap:!1}}),E=new J({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5TZXF1ZW5jZSglMEElMjAlMjAlMjAlMjAlNUJub3JtYWxpemVycy5ORkQoKSUyQyUyMG5vcm1hbGl6ZXJzLkxvd2VyY2FzZSgpJTJDJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklNUQlMEEp",highlighted:`tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [normalizers.NFD(), normalizers.Lowercase(), normalizers.StripAccents()]
)`,wrap:!1}}),P=new J({props:{code:"cHJpbnQodG9rZW5pemVyLm5vcm1hbGl6ZXIubm9ybWFsaXplX3N0ciglMjJIJUMzJUE5bGwlQzMlQjIlMjBoJUMzJUI0dyUyMGFyZSUyMCVDMyVCQyUzRiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(tokenizer.normalizer.normalize_str(<span class="hljs-string">&quot;Héllò hôw are ü?&quot;</span>))',wrap:!1}}),F=new J({props:{code:"aGVsbG8lMjBob3clMjBhcmUlMjB1JTNG",highlighted:"hello how are u?",wrap:!1}}),f=new Xi({props:{$$slots:{default:[Hi]},$$scope:{ctx:Mt}}}),K=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CZXJ0UHJlVG9rZW5pemVyKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.BertPreTokenizer()",wrap:!1}}),ee=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5XaGl0ZXNwYWNlKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Whitespace()",wrap:!1}}),te=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBteSUyMHByZS10b2tlbml6ZXIuJTIyKQ==",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)',wrap:!1}}),le=new J({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),ae=new J({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTBBcHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKCUyMkxldCdzJTIwdGVzdCUyMG15JTIwcHJlLXRva2VuaXplci4lMjIp",highlighted:`pre_tokenizer = pre_tokenizers.WhitespaceSplit()
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),ie=new J({props:{code:"JTVCKCUyMkxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJ3Rlc3QnJTJDJTIwKDYlMkMlMjAxMCkpJTJDJTIwKCdteSclMkMlMjAoMTElMkMlMjAxMykpJTJDJTIwKCdwcmUtdG9rZW5pemVyLiclMkMlMjAoMTQlMkMlMjAyOCkpJTVE",highlighted:'[(<span class="hljs-string">&quot;Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre-tokenizer.&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">28</span>))]',wrap:!1}}),re=new J({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLlNlcXVlbmNlKCUwQSUyMCUyMCUyMCUyMCU1QnByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTJDJTIwcHJlX3Rva2VuaXplcnMuUHVuY3R1YXRpb24oKSU1RCUwQSklMEFwcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIoJTIyTGV0J3MlMjB0ZXN0JTIwbXklMjBwcmUtdG9rZW5pemVyLiUyMik=",highlighted:`pre_tokenizer = pre_tokenizers.<span class="hljs-type">Sequence</span>(
    [pre_tokenizers.WhitespaceSplit(), pre_tokenizers.Punctuation()]
)
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),oe=new J({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),ce=new J({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlNUJVTkslNUQlMjIlMkMlMjAlMjIlNUJQQUQlNUQlMjIlMkMlMjAlMjIlNUJDTFMlNUQlMjIlMkMlMjAlMjIlNUJTRVAlNUQlMjIlMkMlMjAlMjIlNUJNQVNLJTVEJTIyJTVEJTBBdHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLldvcmRQaWVjZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2Vucyk=",highlighted:`special_tokens = [<span class="hljs-string">&quot;[UNK]&quot;</span>, <span class="hljs-string">&quot;[PAD]&quot;</span>, <span class="hljs-string">&quot;[CLS]&quot;</span>, <span class="hljs-string">&quot;[SEP]&quot;</span>, <span class="hljs-string">&quot;[MASK]&quot;</span>]
trainer = trainers.WordPieceTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens)`,wrap:!1}}),de=new J({props:{code:"dG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:"tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)",wrap:!1}}),ye=new J({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLldvcmRQaWVjZSh1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>)
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Te=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),fe=new J({props:{code:"JTVCJ2xldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJ3Rlc3QnJTJDJTIwJ3RoaXMnJTJDJTIwJ3RvayclMkMlMjAnJTIzJTIzZW5pJyUyQyUyMCclMjMlMjN6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),$e=new J({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiU1QkNMUyU1RCUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTVCU0VQJTVEJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[CLS]&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[SEP]&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),Ue=new J({props:{code:"KDIlMkMlMjAzKQ==",highlighted:'(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>)',wrap:!1}}),ge=new J({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWlyJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjAlMjRCJTNBMSUyMCU1QlNFUCU1RCUzQTElMjIlMkMlMEElMjAlMjAlMjAlMjBzcGVjaWFsX3Rva2VucyUzRCU1QiglMjIlNUJDTFMlNUQlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTJDJTIwKCUyMiU1QlNFUCU1RCUyMiUyQyUyMHNlcF90b2tlbl9pZCklNUQlMkMlMEEp",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0&quot;</span>,
    pair=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0 $B:1 [SEP]:1&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;[CLS]&quot;</span>, cls_token_id), (<span class="hljs-string">&quot;[SEP]&quot;</span>, sep_token_id)],
)`,wrap:!1}}),ve=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ie=new J({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLiclMkMlMjAnJTVCU0VQJTVEJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]',wrap:!1}}),Ze=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),Ve=new J({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLi4uJyUyQyUyMCclNUJTRVAlNUQnJTJDJTIwJ29uJyUyQyUyMCdhJyUyQyUyMCdwYWlyJyUyQyUyMCdvZiclMkMlMjAnc2VudGVuY2VzJyUyQyUyMCcuJyUyQyUyMCclNUJTRVAlNUQnJTVEJTBBJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVE",highlighted:`[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;...&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;pair&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;sentences&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),Be=new J({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5Xb3JkUGllY2UocHJlZml4JTNEJTIyJTIzJTIzJTIyKQ==",highlighted:'tokenizer.decoder = decoders.WordPiece(prefix=<span class="hljs-string">&quot;##&quot;</span>)',wrap:!1}}),We=new J({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),Qe=new J({props:{code:"JTIybGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4uLiUyMG9uJTIwYSUyMHBhaXIlMjBvZiUyMHNlbnRlbmNlcy4lMjIlMjAlMjMlMjBUZXN0b25zJTIwY2UlMjB0b2tlbml6ZXIuLi4lMjBzdXIlMjB1bmUlMjBwYWlyZSUyMGRlJTIwcGhyYXNlcy4=",highlighted:'<span class="hljs-string">&quot;let&#x27;s test this tokenizer... on a pair of sentences.&quot;</span> <span class="hljs-comment"># Testons ce tokenizer... sur une paire de phrases.</span>',wrap:!1}}),Xe=new J({props:{code:"dG9rZW5pemVyLnNhdmUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'tokenizer.save(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Ae=new J({props:{code:"bmV3X3Rva2VuaXplciUyMCUzRCUyMFRva2VuaXplci5mcm9tX2ZpbGUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'new_tokenizer = Tokenizer.from_file(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Ge=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwdG9rZW5pemVyX2ZpbGUlM0QlMjJ0b2tlbml6ZXIuanNvbiUyMiUyQyUyMCUyMyUyMFZvdXMlMjBwb3V2ZXolMjBjaGFyZ2VyJTIwJUMzJUEwJTIwcGFydGlyJTIwZHUlMjBmaWNoaWVyJTIwZHUlMjB0b2tlbml6ZXIlMkMlMjBhbHRlcm5hdGl2ZW1lbnQlMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlNUJQQUQlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlNUJDTFMlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlNUJTRVAlNUQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTVCTUFTSyU1RCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    <span class="hljs-comment"># tokenizer_file=&quot;tokenizer.json&quot;, # Vous pouvez charger à partir du fichier du tokenizer, alternativement</span>
    unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>,
    pad_token=<span class="hljs-string">&quot;[PAD]&quot;</span>,
    cls_token=<span class="hljs-string">&quot;[CLS]&quot;</span>,
    sep_token=<span class="hljs-string">&quot;[SEP]&quot;</span>,
    mask_token=<span class="hljs-string">&quot;[MASK]&quot;</span>,
)`,wrap:!1}}),De=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizerFast

wrapped_tokenizer = BertTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Fe=new mt({props:{title:"Construire un <i> tokenizer </i> BPE à partir de zéro",local:"construire-un-i-tokenizer-i-bpe-à-partir-de-zéro",headingTag:"h2"}}),Ke=new J({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5CUEUoKSk=",highlighted:"tokenizer = Tokenizer(models.BPE())",wrap:!1}}),ss=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CeXRlTGV2ZWwoYWRkX3ByZWZpeF9zcGFjZSUzREZhbHNlKQ==",highlighted:'tokenizer.pre_tokenizer = pre_tokenizers.ByteLevel(add_prefix_space=<span class="hljs-literal">False</span>)',wrap:!1}}),ls=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBwcmUtdG9rZW5pemF0aW9uISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test pre-tokenization!&quot;</span>)',wrap:!1}}),ns=new J({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJ3MlMjIlMkMlMjAoMyUyQyUyMDUpKSUyQyUyMCgnJUM0JUEwdGVzdCclMkMlMjAoNSUyQyUyMDEwKSklMkMlMjAoJyVDNCVBMHByZSclMkMlMjAoMTAlMkMlMjAxNCkpJTJDJTIwKCctJyUyQyUyMCgxNCUyQyUyMDE1KSklMkMlMEElMjAoJ3Rva2VuaXphdGlvbiclMkMlMjAoMTUlMkMlMjAyNykpJTJDJTIwKCchJyUyQyUyMCgyNyUyQyUyMDI4KSklNUQ=",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;s&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;Ġtest&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;Ġpre&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">15</span>)),
 (<span class="hljs-string">&#x27;tokenization&#x27;</span>, (<span class="hljs-number">15</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;!&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),is=new J({props:{code:"dHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLkJwZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQpJTBBdG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`trainer = trainers.BpeTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=[<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>])
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),os=new J({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLkJQRSgpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.BPE()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),cs=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),ms=new J({props:{code:"JTVCJ0wnJTJDJTIwJ2V0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAnJUM0JUEwdGVzdCclMkMlMjAnJUM0JUEwdGhpcyclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2tlbiclMkMlMjAnaXplciclMkMlMjAnLiclNUQ=",highlighted:'[<span class="hljs-string">&#x27;L&#x27;</span>, <span class="hljs-string">&#x27;et&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;Ġtest&#x27;</span>, <span class="hljs-string">&#x27;Ġthis&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),ds=new J({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5CeXRlTGV2ZWwodHJpbV9vZmZzZXRzJTNERmFsc2Up",highlighted:'tokenizer.post_processor = processors.ByteLevel(trim_offsets=<span class="hljs-literal">False</span>)',wrap:!1}}),ys=new J({props:{code:"c2VudGVuY2UlMjAlM0QlMjAlMjJMZXQncyUyMHRlc3QlMjB0aGlzJTIwdG9rZW5pemVyLiUyMiUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyLmVuY29kZShzZW50ZW5jZSklMEFzdGFydCUyQyUyMGVuZCUyMCUzRCUyMGVuY29kaW5nLm9mZnNldHMlNUI0JTVEJTBBc2VudGVuY2UlNUJzdGFydCUzQWVuZCU1RA==",highlighted:`sentence = <span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>
encoding = tokenizer.encode(sentence)
start, end = encoding.offsets[<span class="hljs-number">4</span>]
sentence[start:end]`,wrap:!1}}),js=new J({props:{code:"JyUyMHRlc3Qn",highlighted:'<span class="hljs-string">&#x27; test&#x27;</span>',wrap:!1}}),fs=new J({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5CeXRlTGV2ZWwoKQ==",highlighted:"tokenizer.decoder = decoders.ByteLevel()",wrap:!1}}),bs=new J({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),$s=new J({props:{code:"JTIyTGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4lMjIlMjAlMjMlMjBUZXN0b25zJTIwY2UlMjB0b2tlbml6ZXI=",highlighted:'<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span> <span class="hljs-comment"># Testons ce tokenizer</span>',wrap:!1}}),ws=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwZW9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
)`,wrap:!1}}),gs=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2TokenizerFast

wrapped_tokenizer = GPT2TokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),zs=new mt({props:{title:"Construire un <i> tokenizer Unigram </i> à partir de zéro",local:"construire-un-i-tokenizer-unigram-i-à-partir-de-zéro",headingTag:"h2"}}),Is=new J({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5VbmlncmFtKCkp",highlighted:"tokenizer = Tokenizer(models.Unigram())",wrap:!1}}),Vs=new J({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjBSZWdleCUwQSUwQXRva2VuaXplci5ub3JtYWxpemVyJTIwJTNEJTIwbm9ybWFsaXplcnMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuUmVwbGFjZSglMjIlNjAlNjAlMjIlMkMlMjAnJTIyJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKCUyMicnJTIyJTJDJTIwJyUyMicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuTkZLRCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKFJlZ2V4KCUyMiUyMCU3QjIlMkMlN0QlMjIpJTJDJTIwJTIyJTIwJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> Regex

tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [
        normalizers.Replace(<span class="hljs-string">&quot;\`\`&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.Replace(<span class="hljs-string">&quot;&#x27;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.NFKD(),
        normalizers.StripAccents(),
        normalizers.Replace(Regex(<span class="hljs-string">&quot; {2,}&quot;</span>), <span class="hljs-string">&quot; &quot;</span>),
    ]
)`,wrap:!1}}),_s=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Metaspace()",wrap:!1}}),Qs=new J({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjB0aGUlMjBwcmUtdG9rZW5pemVyISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test the pre-tokenizer!&quot;</span>)',wrap:!1}}),Ns=new J({props:{code:"JTVCKCUyMiVFMiU5NiU4MUxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJyVFMiU5NiU4MXRlc3QnJTJDJTIwKDUlMkMlMjAxMCkpJTJDJTIwKCclRTIlOTYlODF0aGUnJTJDJTIwKDEwJTJDJTIwMTQpKSUyQyUyMCgnJUUyJTk2JTgxcHJlLXRva2VuaXplciEnJTJDJTIwKDE0JTJDJTIwMjkpKSU1RA==",highlighted:'[(<span class="hljs-string">&quot;▁Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;▁test&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;▁the&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;▁pre-tokenizer!&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">29</span>))]',wrap:!1}}),Rs=new J({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlM0NjbHMlM0UlMjIlMkMlMjAlMjIlM0NzZXAlM0UlMjIlMkMlMjAlMjIlM0N1bmslM0UlMjIlMkMlMjAlMjIlM0NwYWQlM0UlMjIlMkMlMjAlMjIlM0NtYXNrJTNFJTIyJTJDJTIwJTIyJTNDcyUzRSUyMiUyQyUyMCUyMiUzQyUyRnMlM0UlMjIlNUQlMEF0cmFpbmVyJTIwJTNEJTIwdHJhaW5lcnMuVW5pZ3JhbVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2VucyUyQyUyMHVua190b2tlbiUzRCUyMiUzQ3VuayUzRSUyMiUwQSklMEF0b2tlbml6ZXIudHJhaW5fZnJvbV9pdGVyYXRvcihnZXRfdHJhaW5pbmdfY29ycHVzKCklMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`special_tokens = [<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;s&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>]
trainer = trainers.UnigramTrainer(
    vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens, unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>
)
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),Hs=new J({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLlVuaWdyYW0oKSUwQXRva2VuaXplci50cmFpbiglNUIlMjJ3aWtpdGV4dC0yLnR4dCUyMiU1RCUyQyUyMHRyYWluZXIlM0R0cmFpbmVyKQ==",highlighted:`tokenizer.model = models.Unigram()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Es=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ds=new J({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),Ps=new J({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiUzQ2NscyUzRSUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTNDc2VwJTNFJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),Fs=new J({props:{code:"MCUyMDE=",highlighted:'<span class="hljs-number">0</span> <span class="hljs-number">1</span>',wrap:!1}}),Ks=new J({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEJTIyJTI0QSUzQTAlMjAlM0NzZXAlM0UlM0EwJTIwJTNDY2xzJTNFJTNBMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhaXIlM0QlMjIlMjRBJTNBMCUyMCUzQ3NlcCUzRSUzQTAlMjAlMjRCJTNBMSUyMCUzQ3NlcCUzRSUzQTElMjAlM0NjbHMlM0UlM0EyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIoJTIyJTNDc2VwJTNFJTIyJTJDJTIwc2VwX3Rva2VuX2lkKSUyQyUyMCglMjIlM0NjbHMlM0UlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTVEJTJDJTBBKQ==",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 &lt;cls&gt;:2&quot;</span>,
    pair=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 $B:1 &lt;sep&gt;:1 &lt;cls&gt;:2&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, sep_token_id), (<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, cls_token_id)],
)`,wrap:!1}}),et=new J({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMhJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences!&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),st=new J({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdvbiclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdhJyUyQyUyMCclRTIlOTYlODFwYWlyJyUyQyUyMCUwQSUyMCUyMCclRTIlOTYlODFvZiclMkMlMjAnJUUyJTk2JTgxc2VudGVuY2UnJTJDJTIwJ3MnJTJDJTIwJyEnJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJTNDY2xzJTNFJyU1RCUwQSU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAyJTVE",highlighted:`[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;▁pair&#x27;</span>, 
  <span class="hljs-string">&#x27;▁of&#x27;</span>, <span class="hljs-string">&#x27;▁sentence&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;!&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;cls&gt;&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),lt=new J({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.decoder = decoders.Metaspace()",wrap:!1}}),at=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDcyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMGVvc190b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlM0N1bmslM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlM0NwYWQlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlM0NjbHMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlM0NzZXAlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTNDbWFzayUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;s&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>,
    unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>,
    pad_token=<span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>,
    cls_token=<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>,
    sep_token=<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>,
    mask_token=<span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>,
    padding_side=<span class="hljs-string">&quot;left&quot;</span>,
)`,wrap:!1}}),pt=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFhMTmV0VG9rZW5pemVyRmFzdCUwQSUwQXdyYXBwZWRfdG9rZW5pemVyJTIwJTNEJTIwWExOZXRUb2tlbml6ZXJGYXN0KHRva2VuaXplcl9vYmplY3QlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLNetTokenizerFast

wrapped_tokenizer = XLNetTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),ot=new Li({props:{source:"https://github.com/huggingface/course/blob/main/chapters/fr/chapter6/8.mdx"}}),{c(){y=i("meta"),k=n(),j=i("p"),ut=n(),o(b.$$.fragment),dt=n(),o($.$$.fragment),Jt=n(),U=i("p"),U.textContent=ra,yt=n(),w=i("ul"),w.innerHTML=oa,jt=n(),h=i("p"),h.textContent=ua,Tt=n(),T=i("div"),T.innerHTML=ca,ft=n(),g=i("p"),g.innerHTML=ma,kt=n(),o(x.$$.fragment),bt=n(),z=i("p"),z.innerHTML=Ma,$t=n(),v=i("ul"),v.innerHTML=da,Ut=n(),I=i("p"),I.innerHTML=Ja,wt=n(),o(C.$$.fragment),ht=n(),Z=i("p"),Z.innerHTML=ya,gt=n(),o(V.$$.fragment),xt=n(),q=i("p"),q.innerHTML=ja,zt=n(),B=i("p"),B.innerHTML=Ta,vt=n(),o(_.$$.fragment),It=n(),W=i("p"),W.innerHTML=fa,Ct=n(),o(Q.$$.fragment),Zt=n(),N=i("p"),N.innerHTML=ka,Vt=n(),X=i("p"),X.innerHTML=ba,qt=n(),o(R.$$.fragment),Bt=n(),A=i("p"),A.innerHTML=$a,_t=n(),L=i("p"),L.innerHTML=Ua,Wt=n(),o(H.$$.fragment),Qt=n(),G=i("p"),G.innerHTML=wa,Nt=n(),o(E.$$.fragment),Xt=n(),D=i("p"),D.innerHTML=ha,Rt=n(),S=i("p"),S.innerHTML=ga,At=n(),o(P.$$.fragment),Lt=n(),o(F.$$.fragment),Ht=n(),o(f.$$.fragment),Gt=n(),Y=i("p"),Y.innerHTML=xa,Et=n(),o(K.$$.fragment),Dt=n(),O=i("p"),O.textContent=za,St=n(),o(ee.$$.fragment),Pt=n(),se=i("p"),se.innerHTML=va,Ft=n(),o(te.$$.fragment),Yt=n(),o(le.$$.fragment),Kt=n(),ne=i("p"),ne.innerHTML=Ia,Ot=n(),o(ae.$$.fragment),el=n(),o(ie.$$.fragment),sl=n(),pe=i("p"),pe.innerHTML=Ca,tl=n(),o(re.$$.fragment),ll=n(),o(oe.$$.fragment),nl=n(),ue=i("p"),ue.innerHTML=Za,al=n(),o(ce.$$.fragment),il=n(),me=i("p"),me.innerHTML=Va,pl=n(),Me=i("p"),Me.textContent=qa,rl=n(),o(de.$$.fragment),ol=n(),Je=i("p"),Je.innerHTML=Ba,ul=n(),o(ye.$$.fragment),cl=n(),je=i("p"),je.innerHTML=_a,ml=n(),o(Te.$$.fragment),Ml=n(),o(fe.$$.fragment),dl=n(),ke=i("p"),ke.innerHTML=Wa,Jl=n(),be=i("p"),be.innerHTML=Qa,yl=n(),o($e.$$.fragment),jl=n(),o(Ue.$$.fragment),Tl=n(),we=i("p"),we.innerHTML=Na,fl=n(),he=i("p"),he.textContent=Xa,kl=n(),o(ge.$$.fragment),bl=n(),xe=i("p"),xe.innerHTML=Ra,$l=n(),ze=i("p"),ze.textContent=Aa,Ul=n(),o(ve.$$.fragment),wl=n(),o(Ie.$$.fragment),hl=n(),Ce=i("p"),Ce.textContent=La,gl=n(),o(Ze.$$.fragment),xl=n(),o(Ve.$$.fragment),zl=n(),qe=i("p"),qe.innerHTML=Ha,vl=n(),o(Be.$$.fragment),Il=n(),_e=i("p"),_e.innerHTML=Ga,Cl=n(),o(We.$$.fragment),Zl=n(),o(Qe.$$.fragment),Vl=n(),Ne=i("p"),Ne.innerHTML=Ea,ql=n(),o(Xe.$$.fragment),Bl=n(),Re=i("p"),Re.innerHTML=Da,_l=n(),o(Ae.$$.fragment),Wl=n(),Le=i("p"),Le.innerHTML=Sa,Ql=n(),He=i("p"),He.innerHTML=Pa,Nl=n(),o(Ge.$$.fragment),Xl=n(),Ee=i("p"),Ee.innerHTML=Fa,Rl=n(),o(De.$$.fragment),Al=n(),Se=i("p"),Se.innerHTML=Ya,Ll=n(),Pe=i("p"),Pe.innerHTML=Ka,Hl=n(),o(Fe.$$.fragment),Gl=n(),Ye=i("p"),Ye.innerHTML=Oa,El=n(),o(Ke.$$.fragment),Dl=n(),Oe=i("p"),Oe.innerHTML=ei,Sl=n(),es=i("p"),es.textContent=si,Pl=n(),o(ss.$$.fragment),Fl=n(),ts=i("p"),ts.innerHTML=ti,Yl=n(),o(ls.$$.fragment),Kl=n(),o(ns.$$.fragment),Ol=n(),as=i("p"),as.innerHTML=li,en=n(),o(is.$$.fragment),sn=n(),ps=i("p"),ps.innerHTML=ni,tn=n(),rs=i("p"),rs.innerHTML=ai,ln=n(),o(os.$$.fragment),nn=n(),us=i("p"),us.textContent=ii,an=n(),o(cs.$$.fragment),pn=n(),o(ms.$$.fragment),rn=n(),Ms=i("p"),Ms.innerHTML=pi,on=n(),o(ds.$$.fragment),un=n(),Js=i("p"),Js.innerHTML=ri,cn=n(),o(ys.$$.fragment),mn=n(),o(js.$$.fragment),Mn=n(),Ts=i("p"),Ts.textContent=oi,dn=n(),o(fs.$$.fragment),Jn=n(),ks=i("p"),ks.textContent=ui,yn=n(),o(bs.$$.fragment),jn=n(),o($s.$$.fragment),Tn=n(),Us=i("p"),Us.innerHTML=ci,fn=n(),o(ws.$$.fragment),kn=n(),hs=i("p"),hs.textContent=mi,bn=n(),o(gs.$$.fragment),$n=n(),xs=i("p"),xs.innerHTML=Mi,Un=n(),o(zs.$$.fragment),wn=n(),vs=i("p"),vs.innerHTML=di,hn=n(),o(Is.$$.fragment),gn=n(),Cs=i("p"),Cs.textContent=Ji,xn=n(),Zs=i("p"),Zs.innerHTML=yi,zn=n(),o(Vs.$$.fragment),vn=n(),qs=i("p"),qs.innerHTML=ji,In=n(),Bs=i("p"),Bs.innerHTML=Ti,Cn=n(),o(_s.$$.fragment),Zn=n(),Ws=i("p"),Ws.textContent=fi,Vn=n(),o(Qs.$$.fragment),qn=n(),o(Ns.$$.fragment),Bn=n(),Xs=i("p"),Xs.innerHTML=ki,_n=n(),o(Rs.$$.fragment),Wn=n(),As=i("p"),As.innerHTML=bi,Qn=n(),Ls=i("p"),Ls.innerHTML=$i,Nn=n(),o(Hs.$$.fragment),Xn=n(),Gs=i("p"),Gs.textContent=Ui,Rn=n(),o(Es.$$.fragment),An=n(),o(Ds.$$.fragment),Ln=n(),Ss=i("p"),Ss.innerHTML=wi,Hn=n(),o(Ps.$$.fragment),Gn=n(),o(Fs.$$.fragment),En=n(),Ys=i("p"),Ys.textContent=hi,Dn=n(),o(Ks.$$.fragment),Sn=n(),Os=i("p"),Os.textContent=gi,Pn=n(),o(et.$$.fragment),Fn=n(),o(st.$$.fragment),Yn=n(),tt=i("p"),tt.innerHTML=xi,Kn=n(),o(lt.$$.fragment),On=n(),nt=i("p"),nt.innerHTML=zi,ea=n(),o(at.$$.fragment),sa=n(),it=i("p"),it.textContent=vi,ta=n(),o(pt.$$.fragment),la=n(),rt=i("p"),rt.innerHTML=Ii,na=n(),o(ot.$$.fragment),aa=n(),ct=i("p"),this.h()},l(e){const s=Qi("svelte-u9bgzb",document.head);y=p(s,"META",{name:!0,content:!0}),s.forEach(t),k=a(e),j=p(e,"P",{}),Zi(j).forEach(t),ut=a(e),u(b.$$.fragment,e),dt=a(e),u($.$$.fragment,e),Jt=a(e),U=p(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-oyei3k"&&(U.textContent=ra),yt=a(e),w=p(e,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-5anut5"&&(w.innerHTML=oa),jt=a(e),h=p(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1f3bknh"&&(h.textContent=ua),Tt=a(e),T=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-oxfng3"&&(T.innerHTML=ca),ft=a(e),g=p(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1kynzbk"&&(g.innerHTML=ma),kt=a(e),u(x.$$.fragment,e),bt=a(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-5p1dxj"&&(z.innerHTML=Ma),$t=a(e),v=p(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-1j4jxyk"&&(v.innerHTML=da),Ut=a(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1pt23pv"&&(I.innerHTML=Ja),wt=a(e),u(C.$$.fragment,e),ht=a(e),Z=p(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-17c1e08"&&(Z.innerHTML=ya),gt=a(e),u(V.$$.fragment,e),xt=a(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1b2mrqy"&&(q.innerHTML=ja),zt=a(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1iw8f3y"&&(B.innerHTML=Ta),vt=a(e),u(_.$$.fragment,e),It=a(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1nye8ho"&&(W.innerHTML=fa),Ct=a(e),u(Q.$$.fragment,e),Zt=a(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1qlbya"&&(N.innerHTML=ka),Vt=a(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1bcasjg"&&(X.innerHTML=ba),qt=a(e),u(R.$$.fragment,e),Bt=a(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1i725qn"&&(A.innerHTML=$a),_t=a(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-17fukp3"&&(L.innerHTML=Ua),Wt=a(e),u(H.$$.fragment,e),Qt=a(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1fejf0b"&&(G.innerHTML=wa),Nt=a(e),u(E.$$.fragment,e),Xt=a(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-okx1fu"&&(D.innerHTML=ha),Rt=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1gwij1w"&&(S.innerHTML=ga),At=a(e),u(P.$$.fragment,e),Lt=a(e),u(F.$$.fragment,e),Ht=a(e),u(f.$$.fragment,e),Gt=a(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-19f16tj"&&(Y.innerHTML=xa),Et=a(e),u(K.$$.fragment,e),Dt=a(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-159e3ir"&&(O.textContent=za),St=a(e),u(ee.$$.fragment,e),Pt=a(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-y4t8zr"&&(se.innerHTML=va),Ft=a(e),u(te.$$.fragment,e),Yt=a(e),u(le.$$.fragment,e),Kt=a(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-fvtgu0"&&(ne.innerHTML=Ia),Ot=a(e),u(ae.$$.fragment,e),el=a(e),u(ie.$$.fragment,e),sl=a(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-cs3b0n"&&(pe.innerHTML=Ca),tl=a(e),u(re.$$.fragment,e),ll=a(e),u(oe.$$.fragment,e),nl=a(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-zfspxd"&&(ue.innerHTML=Za),al=a(e),u(ce.$$.fragment,e),il=a(e),me=p(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1arwrfz"&&(me.innerHTML=Va),pl=a(e),Me=p(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-5lxhpv"&&(Me.textContent=qa),rl=a(e),u(de.$$.fragment,e),ol=a(e),Je=p(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-xg4lg6"&&(Je.innerHTML=Ba),ul=a(e),u(ye.$$.fragment,e),cl=a(e),je=p(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1i0wlz3"&&(je.innerHTML=_a),ml=a(e),u(Te.$$.fragment,e),Ml=a(e),u(fe.$$.fragment,e),dl=a(e),ke=p(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1s495vi"&&(ke.innerHTML=Wa),Jl=a(e),be=p(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-eg12gz"&&(be.innerHTML=Qa),yl=a(e),u($e.$$.fragment,e),jl=a(e),u(Ue.$$.fragment,e),Tl=a(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1kio2jq"&&(we.innerHTML=Na),fl=a(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-zo512q"&&(he.textContent=Xa),kl=a(e),u(ge.$$.fragment,e),bl=a(e),xe=p(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1sagyrz"&&(xe.innerHTML=Ra),$l=a(e),ze=p(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-e0zi7j"&&(ze.textContent=Aa),Ul=a(e),u(ve.$$.fragment,e),wl=a(e),u(Ie.$$.fragment,e),hl=a(e),Ce=p(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-4c2egr"&&(Ce.textContent=La),gl=a(e),u(Ze.$$.fragment,e),xl=a(e),u(Ve.$$.fragment,e),zl=a(e),qe=p(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-qsb42a"&&(qe.innerHTML=Ha),vl=a(e),u(Be.$$.fragment,e),Il=a(e),_e=p(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-116zp44"&&(_e.innerHTML=Ga),Cl=a(e),u(We.$$.fragment,e),Zl=a(e),u(Qe.$$.fragment,e),Vl=a(e),Ne=p(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-67o763"&&(Ne.innerHTML=Ea),ql=a(e),u(Xe.$$.fragment,e),Bl=a(e),Re=p(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-kfjmjn"&&(Re.innerHTML=Da),_l=a(e),u(Ae.$$.fragment,e),Wl=a(e),Le=p(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-ychh5o"&&(Le.innerHTML=Sa),Ql=a(e),He=p(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-vdya8f"&&(He.innerHTML=Pa),Nl=a(e),u(Ge.$$.fragment,e),Xl=a(e),Ee=p(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-awkqmq"&&(Ee.innerHTML=Fa),Rl=a(e),u(De.$$.fragment,e),Al=a(e),Se=p(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1ndzyah"&&(Se.innerHTML=Ya),Ll=a(e),Pe=p(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1rarvjc"&&(Pe.innerHTML=Ka),Hl=a(e),u(Fe.$$.fragment,e),Gl=a(e),Ye=p(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-ix9zak"&&(Ye.innerHTML=Oa),El=a(e),u(Ke.$$.fragment,e),Dl=a(e),Oe=p(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-d2bplb"&&(Oe.innerHTML=ei),Sl=a(e),es=p(e,"P",{"data-svelte-h":!0}),r(es)!=="svelte-lcqq2e"&&(es.textContent=si),Pl=a(e),u(ss.$$.fragment,e),Fl=a(e),ts=p(e,"P",{"data-svelte-h":!0}),r(ts)!=="svelte-pjtgp6"&&(ts.innerHTML=ti),Yl=a(e),u(ls.$$.fragment,e),Kl=a(e),u(ns.$$.fragment,e),Ol=a(e),as=p(e,"P",{"data-svelte-h":!0}),r(as)!=="svelte-thl8v2"&&(as.innerHTML=li),en=a(e),u(is.$$.fragment,e),sn=a(e),ps=p(e,"P",{"data-svelte-h":!0}),r(ps)!=="svelte-zu5iz"&&(ps.innerHTML=ni),tn=a(e),rs=p(e,"P",{"data-svelte-h":!0}),r(rs)!=="svelte-z3sga0"&&(rs.innerHTML=ai),ln=a(e),u(os.$$.fragment,e),nn=a(e),us=p(e,"P",{"data-svelte-h":!0}),r(us)!=="svelte-18twlvh"&&(us.textContent=ii),an=a(e),u(cs.$$.fragment,e),pn=a(e),u(ms.$$.fragment,e),rn=a(e),Ms=p(e,"P",{"data-svelte-h":!0}),r(Ms)!=="svelte-16mr1f9"&&(Ms.innerHTML=pi),on=a(e),u(ds.$$.fragment,e),un=a(e),Js=p(e,"P",{"data-svelte-h":!0}),r(Js)!=="svelte-m9lq9f"&&(Js.innerHTML=ri),cn=a(e),u(ys.$$.fragment,e),mn=a(e),u(js.$$.fragment,e),Mn=a(e),Ts=p(e,"P",{"data-svelte-h":!0}),r(Ts)!=="svelte-1lij06j"&&(Ts.textContent=oi),dn=a(e),u(fs.$$.fragment,e),Jn=a(e),ks=p(e,"P",{"data-svelte-h":!0}),r(ks)!=="svelte-4071k0"&&(ks.textContent=ui),yn=a(e),u(bs.$$.fragment,e),jn=a(e),u($s.$$.fragment,e),Tn=a(e),Us=p(e,"P",{"data-svelte-h":!0}),r(Us)!=="svelte-y86eft"&&(Us.innerHTML=ci),fn=a(e),u(ws.$$.fragment,e),kn=a(e),hs=p(e,"P",{"data-svelte-h":!0}),r(hs)!=="svelte-13b090a"&&(hs.textContent=mi),bn=a(e),u(gs.$$.fragment,e),$n=a(e),xs=p(e,"P",{"data-svelte-h":!0}),r(xs)!=="svelte-1w4hpgt"&&(xs.innerHTML=Mi),Un=a(e),u(zs.$$.fragment,e),wn=a(e),vs=p(e,"P",{"data-svelte-h":!0}),r(vs)!=="svelte-58ts27"&&(vs.innerHTML=di),hn=a(e),u(Is.$$.fragment,e),gn=a(e),Cs=p(e,"P",{"data-svelte-h":!0}),r(Cs)!=="svelte-14pp70f"&&(Cs.textContent=Ji),xn=a(e),Zs=p(e,"P",{"data-svelte-h":!0}),r(Zs)!=="svelte-st1rcn"&&(Zs.innerHTML=yi),zn=a(e),u(Vs.$$.fragment,e),vn=a(e),qs=p(e,"P",{"data-svelte-h":!0}),r(qs)!=="svelte-13xok8v"&&(qs.innerHTML=ji),In=a(e),Bs=p(e,"P",{"data-svelte-h":!0}),r(Bs)!=="svelte-167wifx"&&(Bs.innerHTML=Ti),Cn=a(e),u(_s.$$.fragment,e),Zn=a(e),Ws=p(e,"P",{"data-svelte-h":!0}),r(Ws)!=="svelte-1o14whc"&&(Ws.textContent=fi),Vn=a(e),u(Qs.$$.fragment,e),qn=a(e),u(Ns.$$.fragment,e),Bn=a(e),Xs=p(e,"P",{"data-svelte-h":!0}),r(Xs)!=="svelte-13jka1z"&&(Xs.innerHTML=ki),_n=a(e),u(Rs.$$.fragment,e),Wn=a(e),As=p(e,"P",{"data-svelte-h":!0}),r(As)!=="svelte-3xrd6e"&&(As.innerHTML=bi),Qn=a(e),Ls=p(e,"P",{"data-svelte-h":!0}),r(Ls)!=="svelte-z3sga0"&&(Ls.innerHTML=$i),Nn=a(e),u(Hs.$$.fragment,e),Xn=a(e),Gs=p(e,"P",{"data-svelte-h":!0}),r(Gs)!=="svelte-1y9tqut"&&(Gs.textContent=Ui),Rn=a(e),u(Es.$$.fragment,e),An=a(e),u(Ds.$$.fragment,e),Ln=a(e),Ss=p(e,"P",{"data-svelte-h":!0}),r(Ss)!=="svelte-1fjzee2"&&(Ss.innerHTML=wi),Hn=a(e),u(Ps.$$.fragment,e),Gn=a(e),u(Fs.$$.fragment,e),En=a(e),Ys=p(e,"P",{"data-svelte-h":!0}),r(Ys)!=="svelte-1g309vi"&&(Ys.textContent=hi),Dn=a(e),u(Ks.$$.fragment,e),Sn=a(e),Os=p(e,"P",{"data-svelte-h":!0}),r(Os)!=="svelte-w6fgfg"&&(Os.textContent=gi),Pn=a(e),u(et.$$.fragment,e),Fn=a(e),u(st.$$.fragment,e),Yn=a(e),tt=p(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-ztu276"&&(tt.innerHTML=xi),Kn=a(e),u(lt.$$.fragment,e),On=a(e),nt=p(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1wp6ni3"&&(nt.innerHTML=zi),ea=a(e),u(at.$$.fragment,e),sa=a(e),it=p(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-rruroj"&&(it.textContent=vi),ta=a(e),u(pt.$$.fragment,e),la=a(e),rt=p(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-j719xk"&&(rt.innerHTML=Ii),na=a(e),u(ot.$$.fragment,e),aa=a(e),ct=p(e,"P",{}),Zi(ct).forEach(t),this.h()},h(){pa(y,"name","hf:doc:metadata"),pa(y,"content",Ei),pa(T,"class","flex justify-center")},m(e,s){Ni(document.head,y),l(e,k,s),l(e,j,s),l(e,ut,s),c(b,e,s),l(e,dt,s),c($,e,s),l(e,Jt,s),l(e,U,s),l(e,yt,s),l(e,w,s),l(e,jt,s),l(e,h,s),l(e,Tt,s),l(e,T,s),l(e,ft,s),l(e,g,s),l(e,kt,s),c(x,e,s),l(e,bt,s),l(e,z,s),l(e,$t,s),l(e,v,s),l(e,Ut,s),l(e,I,s),l(e,wt,s),c(C,e,s),l(e,ht,s),l(e,Z,s),l(e,gt,s),c(V,e,s),l(e,xt,s),l(e,q,s),l(e,zt,s),l(e,B,s),l(e,vt,s),c(_,e,s),l(e,It,s),l(e,W,s),l(e,Ct,s),c(Q,e,s),l(e,Zt,s),l(e,N,s),l(e,Vt,s),l(e,X,s),l(e,qt,s),c(R,e,s),l(e,Bt,s),l(e,A,s),l(e,_t,s),l(e,L,s),l(e,Wt,s),c(H,e,s),l(e,Qt,s),l(e,G,s),l(e,Nt,s),c(E,e,s),l(e,Xt,s),l(e,D,s),l(e,Rt,s),l(e,S,s),l(e,At,s),c(P,e,s),l(e,Lt,s),c(F,e,s),l(e,Ht,s),c(f,e,s),l(e,Gt,s),l(e,Y,s),l(e,Et,s),c(K,e,s),l(e,Dt,s),l(e,O,s),l(e,St,s),c(ee,e,s),l(e,Pt,s),l(e,se,s),l(e,Ft,s),c(te,e,s),l(e,Yt,s),c(le,e,s),l(e,Kt,s),l(e,ne,s),l(e,Ot,s),c(ae,e,s),l(e,el,s),c(ie,e,s),l(e,sl,s),l(e,pe,s),l(e,tl,s),c(re,e,s),l(e,ll,s),c(oe,e,s),l(e,nl,s),l(e,ue,s),l(e,al,s),c(ce,e,s),l(e,il,s),l(e,me,s),l(e,pl,s),l(e,Me,s),l(e,rl,s),c(de,e,s),l(e,ol,s),l(e,Je,s),l(e,ul,s),c(ye,e,s),l(e,cl,s),l(e,je,s),l(e,ml,s),c(Te,e,s),l(e,Ml,s),c(fe,e,s),l(e,dl,s),l(e,ke,s),l(e,Jl,s),l(e,be,s),l(e,yl,s),c($e,e,s),l(e,jl,s),c(Ue,e,s),l(e,Tl,s),l(e,we,s),l(e,fl,s),l(e,he,s),l(e,kl,s),c(ge,e,s),l(e,bl,s),l(e,xe,s),l(e,$l,s),l(e,ze,s),l(e,Ul,s),c(ve,e,s),l(e,wl,s),c(Ie,e,s),l(e,hl,s),l(e,Ce,s),l(e,gl,s),c(Ze,e,s),l(e,xl,s),c(Ve,e,s),l(e,zl,s),l(e,qe,s),l(e,vl,s),c(Be,e,s),l(e,Il,s),l(e,_e,s),l(e,Cl,s),c(We,e,s),l(e,Zl,s),c(Qe,e,s),l(e,Vl,s),l(e,Ne,s),l(e,ql,s),c(Xe,e,s),l(e,Bl,s),l(e,Re,s),l(e,_l,s),c(Ae,e,s),l(e,Wl,s),l(e,Le,s),l(e,Ql,s),l(e,He,s),l(e,Nl,s),c(Ge,e,s),l(e,Xl,s),l(e,Ee,s),l(e,Rl,s),c(De,e,s),l(e,Al,s),l(e,Se,s),l(e,Ll,s),l(e,Pe,s),l(e,Hl,s),c(Fe,e,s),l(e,Gl,s),l(e,Ye,s),l(e,El,s),c(Ke,e,s),l(e,Dl,s),l(e,Oe,s),l(e,Sl,s),l(e,es,s),l(e,Pl,s),c(ss,e,s),l(e,Fl,s),l(e,ts,s),l(e,Yl,s),c(ls,e,s),l(e,Kl,s),c(ns,e,s),l(e,Ol,s),l(e,as,s),l(e,en,s),c(is,e,s),l(e,sn,s),l(e,ps,s),l(e,tn,s),l(e,rs,s),l(e,ln,s),c(os,e,s),l(e,nn,s),l(e,us,s),l(e,an,s),c(cs,e,s),l(e,pn,s),c(ms,e,s),l(e,rn,s),l(e,Ms,s),l(e,on,s),c(ds,e,s),l(e,un,s),l(e,Js,s),l(e,cn,s),c(ys,e,s),l(e,mn,s),c(js,e,s),l(e,Mn,s),l(e,Ts,s),l(e,dn,s),c(fs,e,s),l(e,Jn,s),l(e,ks,s),l(e,yn,s),c(bs,e,s),l(e,jn,s),c($s,e,s),l(e,Tn,s),l(e,Us,s),l(e,fn,s),c(ws,e,s),l(e,kn,s),l(e,hs,s),l(e,bn,s),c(gs,e,s),l(e,$n,s),l(e,xs,s),l(e,Un,s),c(zs,e,s),l(e,wn,s),l(e,vs,s),l(e,hn,s),c(Is,e,s),l(e,gn,s),l(e,Cs,s),l(e,xn,s),l(e,Zs,s),l(e,zn,s),c(Vs,e,s),l(e,vn,s),l(e,qs,s),l(e,In,s),l(e,Bs,s),l(e,Cn,s),c(_s,e,s),l(e,Zn,s),l(e,Ws,s),l(e,Vn,s),c(Qs,e,s),l(e,qn,s),c(Ns,e,s),l(e,Bn,s),l(e,Xs,s),l(e,_n,s),c(Rs,e,s),l(e,Wn,s),l(e,As,s),l(e,Qn,s),l(e,Ls,s),l(e,Nn,s),c(Hs,e,s),l(e,Xn,s),l(e,Gs,s),l(e,Rn,s),c(Es,e,s),l(e,An,s),c(Ds,e,s),l(e,Ln,s),l(e,Ss,s),l(e,Hn,s),c(Ps,e,s),l(e,Gn,s),c(Fs,e,s),l(e,En,s),l(e,Ys,s),l(e,Dn,s),c(Ks,e,s),l(e,Sn,s),l(e,Os,s),l(e,Pn,s),c(et,e,s),l(e,Fn,s),c(st,e,s),l(e,Yn,s),l(e,tt,s),l(e,Kn,s),c(lt,e,s),l(e,On,s),l(e,nt,s),l(e,ea,s),c(at,e,s),l(e,sa,s),l(e,it,s),l(e,ta,s),c(pt,e,s),l(e,la,s),l(e,rt,s),l(e,na,s),c(ot,e,s),l(e,aa,s),l(e,ct,s),ia=!0},p(e,[s]){const Ci={};s&2&&(Ci.$$scope={dirty:s,ctx:e}),f.$set(Ci)},i(e){ia||(m(b.$$.fragment,e),m($.$$.fragment,e),m(x.$$.fragment,e),m(C.$$.fragment,e),m(V.$$.fragment,e),m(_.$$.fragment,e),m(Q.$$.fragment,e),m(R.$$.fragment,e),m(H.$$.fragment,e),m(E.$$.fragment,e),m(P.$$.fragment,e),m(F.$$.fragment,e),m(f.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(de.$$.fragment,e),m(ye.$$.fragment,e),m(Te.$$.fragment,e),m(fe.$$.fragment,e),m($e.$$.fragment,e),m(Ue.$$.fragment,e),m(ge.$$.fragment,e),m(ve.$$.fragment,e),m(Ie.$$.fragment,e),m(Ze.$$.fragment,e),m(Ve.$$.fragment,e),m(Be.$$.fragment,e),m(We.$$.fragment,e),m(Qe.$$.fragment,e),m(Xe.$$.fragment,e),m(Ae.$$.fragment,e),m(Ge.$$.fragment,e),m(De.$$.fragment,e),m(Fe.$$.fragment,e),m(Ke.$$.fragment,e),m(ss.$$.fragment,e),m(ls.$$.fragment,e),m(ns.$$.fragment,e),m(is.$$.fragment,e),m(os.$$.fragment,e),m(cs.$$.fragment,e),m(ms.$$.fragment,e),m(ds.$$.fragment,e),m(ys.$$.fragment,e),m(js.$$.fragment,e),m(fs.$$.fragment,e),m(bs.$$.fragment,e),m($s.$$.fragment,e),m(ws.$$.fragment,e),m(gs.$$.fragment,e),m(zs.$$.fragment,e),m(Is.$$.fragment,e),m(Vs.$$.fragment,e),m(_s.$$.fragment,e),m(Qs.$$.fragment,e),m(Ns.$$.fragment,e),m(Rs.$$.fragment,e),m(Hs.$$.fragment,e),m(Es.$$.fragment,e),m(Ds.$$.fragment,e),m(Ps.$$.fragment,e),m(Fs.$$.fragment,e),m(Ks.$$.fragment,e),m(et.$$.fragment,e),m(st.$$.fragment,e),m(lt.$$.fragment,e),m(at.$$.fragment,e),m(pt.$$.fragment,e),m(ot.$$.fragment,e),ia=!0)},o(e){M(b.$$.fragment,e),M($.$$.fragment,e),M(x.$$.fragment,e),M(C.$$.fragment,e),M(V.$$.fragment,e),M(_.$$.fragment,e),M(Q.$$.fragment,e),M(R.$$.fragment,e),M(H.$$.fragment,e),M(E.$$.fragment,e),M(P.$$.fragment,e),M(F.$$.fragment,e),M(f.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(le.$$.fragment,e),M(ae.$$.fragment,e),M(ie.$$.fragment,e),M(re.$$.fragment,e),M(oe.$$.fragment,e),M(ce.$$.fragment,e),M(de.$$.fragment,e),M(ye.$$.fragment,e),M(Te.$$.fragment,e),M(fe.$$.fragment,e),M($e.$$.fragment,e),M(Ue.$$.fragment,e),M(ge.$$.fragment,e),M(ve.$$.fragment,e),M(Ie.$$.fragment,e),M(Ze.$$.fragment,e),M(Ve.$$.fragment,e),M(Be.$$.fragment,e),M(We.$$.fragment,e),M(Qe.$$.fragment,e),M(Xe.$$.fragment,e),M(Ae.$$.fragment,e),M(Ge.$$.fragment,e),M(De.$$.fragment,e),M(Fe.$$.fragment,e),M(Ke.$$.fragment,e),M(ss.$$.fragment,e),M(ls.$$.fragment,e),M(ns.$$.fragment,e),M(is.$$.fragment,e),M(os.$$.fragment,e),M(cs.$$.fragment,e),M(ms.$$.fragment,e),M(ds.$$.fragment,e),M(ys.$$.fragment,e),M(js.$$.fragment,e),M(fs.$$.fragment,e),M(bs.$$.fragment,e),M($s.$$.fragment,e),M(ws.$$.fragment,e),M(gs.$$.fragment,e),M(zs.$$.fragment,e),M(Is.$$.fragment,e),M(Vs.$$.fragment,e),M(_s.$$.fragment,e),M(Qs.$$.fragment,e),M(Ns.$$.fragment,e),M(Rs.$$.fragment,e),M(Hs.$$.fragment,e),M(Es.$$.fragment,e),M(Ds.$$.fragment,e),M(Ps.$$.fragment,e),M(Fs.$$.fragment,e),M(Ks.$$.fragment,e),M(et.$$.fragment,e),M(st.$$.fragment,e),M(lt.$$.fragment,e),M(at.$$.fragment,e),M(pt.$$.fragment,e),M(ot.$$.fragment,e),ia=!1},d(e){e&&(t(k),t(j),t(ut),t(dt),t(Jt),t(U),t(yt),t(w),t(jt),t(h),t(Tt),t(T),t(ft),t(g),t(kt),t(bt),t(z),t($t),t(v),t(Ut),t(I),t(wt),t(ht),t(Z),t(gt),t(xt),t(q),t(zt),t(B),t(vt),t(It),t(W),t(Ct),t(Zt),t(N),t(Vt),t(X),t(qt),t(Bt),t(A),t(_t),t(L),t(Wt),t(Qt),t(G),t(Nt),t(Xt),t(D),t(Rt),t(S),t(At),t(Lt),t(Ht),t(Gt),t(Y),t(Et),t(Dt),t(O),t(St),t(Pt),t(se),t(Ft),t(Yt),t(Kt),t(ne),t(Ot),t(el),t(sl),t(pe),t(tl),t(ll),t(nl),t(ue),t(al),t(il),t(me),t(pl),t(Me),t(rl),t(ol),t(Je),t(ul),t(cl),t(je),t(ml),t(Ml),t(dl),t(ke),t(Jl),t(be),t(yl),t(jl),t(Tl),t(we),t(fl),t(he),t(kl),t(bl),t(xe),t($l),t(ze),t(Ul),t(wl),t(hl),t(Ce),t(gl),t(xl),t(zl),t(qe),t(vl),t(Il),t(_e),t(Cl),t(Zl),t(Vl),t(Ne),t(ql),t(Bl),t(Re),t(_l),t(Wl),t(Le),t(Ql),t(He),t(Nl),t(Xl),t(Ee),t(Rl),t(Al),t(Se),t(Ll),t(Pe),t(Hl),t(Gl),t(Ye),t(El),t(Dl),t(Oe),t(Sl),t(es),t(Pl),t(Fl),t(ts),t(Yl),t(Kl),t(Ol),t(as),t(en),t(sn),t(ps),t(tn),t(rs),t(ln),t(nn),t(us),t(an),t(pn),t(rn),t(Ms),t(on),t(un),t(Js),t(cn),t(mn),t(Mn),t(Ts),t(dn),t(Jn),t(ks),t(yn),t(jn),t(Tn),t(Us),t(fn),t(kn),t(hs),t(bn),t($n),t(xs),t(Un),t(wn),t(vs),t(hn),t(gn),t(Cs),t(xn),t(Zs),t(zn),t(vn),t(qs),t(In),t(Bs),t(Cn),t(Zn),t(Ws),t(Vn),t(qn),t(Bn),t(Xs),t(_n),t(Wn),t(As),t(Qn),t(Ls),t(Nn),t(Xn),t(Gs),t(Rn),t(An),t(Ln),t(Ss),t(Hn),t(Gn),t(En),t(Ys),t(Dn),t(Sn),t(Os),t(Pn),t(Fn),t(Yn),t(tt),t(Kn),t(On),t(nt),t(ea),t(sa),t(it),t(ta),t(la),t(rt),t(na),t(aa),t(ct)),t(y),d(b,e),d($,e),d(x,e),d(C,e),d(V,e),d(_,e),d(Q,e),d(R,e),d(H,e),d(E,e),d(P,e),d(F,e),d(f,e),d(K,e),d(ee,e),d(te,e),d(le,e),d(ae,e),d(ie,e),d(re,e),d(oe,e),d(ce,e),d(de,e),d(ye,e),d(Te,e),d(fe,e),d($e,e),d(Ue,e),d(ge,e),d(ve,e),d(Ie,e),d(Ze,e),d(Ve,e),d(Be,e),d(We,e),d(Qe,e),d(Xe,e),d(Ae,e),d(Ge,e),d(De,e),d(Fe,e),d(Ke,e),d(ss,e),d(ls,e),d(ns,e),d(is,e),d(os,e),d(cs,e),d(ms,e),d(ds,e),d(ys,e),d(js,e),d(fs,e),d(bs,e),d($s,e),d(ws,e),d(gs,e),d(zs,e),d(Is,e),d(Vs,e),d(_s,e),d(Qs,e),d(Ns,e),d(Rs,e),d(Hs,e),d(Es,e),d(Ds,e),d(Ps,e),d(Fs,e),d(Ks,e),d(et,e),d(st,e),d(lt,e),d(at,e),d(pt,e),d(ot,e)}}}const Ei='{"title":"Construction d’un <i> tokenizer </i> , bloc par bloc","local":"construction-dun-i-tokenizer-i--bloc-par-bloc","sections":[{"title":"Acquisition d’un corpus","local":"acquisition-dun-corpus","sections":[],"depth":2},{"title":"Construire un <i> tokenizer WordPiece </i> à partir de zéro","local":"construire-un-i-tokenizer-wordpiece-i-à-partir-de-zéro","sections":[],"depth":2},{"title":"Construire un <i> tokenizer </i> BPE à partir de zéro","local":"construire-un-i-tokenizer-i-bpe-à-partir-de-zéro","sections":[],"depth":2},{"title":"Construire un <i> tokenizer Unigram </i> à partir de zéro","local":"construire-un-i-tokenizer-unigram-i-à-partir-de-zéro","sections":[],"depth":2}],"depth":1}';function Di(Mt){return qi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sp extends _i{constructor(y){super(),Wi(this,y,Di,Gi,Vi,{})}}export{sp as component};
