import{s as te,n as ae,o as ne}from"../chunks/scheduler.b108d059.js";import{S as ie,i as oe,g as i,s as a,r as M,A as re,h as o,f as s,c as n,j as ee,u as m,x as r,k as se,y as Me,a as t,v as p,d as u,t as c,w as y}from"../chunks/index.008de539.js";import{C as Wl}from"../chunks/CodeBlock.3968c746.js";import{H as w,E as me}from"../chunks/EditOnGithub.d1c48e3d.js";function pe(Gl){let j,K,P,O,U,ll,b,El="This page explains how scores are normalized on the Open LLM Leaderboard for the six presented benchmarks. We can categorize all tasks into those with subtasks, those without subtasks, and generative evaluation.",el,h,sl,d,Sl="Normalization is the process of adjusting values measured on different scales to a common scale, making it possible to compare scores across different tasks. For the Open LLM Leaderboard, we normalize scores to:",tl,J,Nl="<li>Account for the varying difficulty and random guess baselines of different tasks.</li> <li>Provide a consistent scale (0-100) for all tasks, enabling fair comparisons.</li> <li>Ensure that improvements over random guessing are appropriately reflected in the scores.</li>",al,T,nl,f,Zl="The basic normalization process involves two steps:",il,C,Bl="<li>Subtracting the random baseline score (lower bound).</li> <li>Scaling the result to a range of 0-100.</li>",ol,v,Xl="We use the following normalization function:",rl,z,Ml,_,ml,I,Ql="For tasks without subtasks (e.g., GPQA, MMLU-PRO), the normalization process is straightforward:",pl,g,Yl="<li>Determine the lower bound (random guess baseline).</li> <li>Apply the normalization function.</li> <li>Scale to a percentage.</li>",ul,A,cl,$,Vl="GPQA has 4 <code>num_choices</code>, so the lower bound is 0.25 (1/<code>num_choices</code> = 1/4 = 0.25).",yl,k,jl,x,wl,W,Fl="For tasks with subtasks (e.g., MUSR, BBH), we follow these steps:",Ul,G,ql="<li>Calculate the lower bound for each subtask.</li> <li>Normalize each subtask score.</li> <li>Average the normalized subtask scores.</li>",bl,E,hl,S,Rl="MUSR has three subtasks with different numbers of choices:",dl,N,Ll="<li>MUSR murder mysteries, num_choices = 2, lower_bound = 0.5</li> <li>MUSR object placement, num_choices = 5, lower_bound = 0.2</li> <li>MUSR team allocation, num_choices = 3, lower_bound = 0.33</li>",Jl,Z,Tl,B,fl,X,Hl="Generative evaluations like MATH and IFEval require a different approach:",Cl,Q,Pl="<li><strong>MATH:</strong> Uses exact match accuracy. The lower bound is effectively 0, as random guessing is unlikely to produce a correct answer.</li> <li><strong>IFEval:</strong><ul><li>For instance-level evaluation (<code>ifeval_inst</code>), we use strict accuracy.</li> <li>For prompt-level evaluation (<code>ifeval_prompt</code>), we also use strict accuracy.</li> <li>The lower bound for both is 0, as random generation is unlikely to produce correct answers.</li></ul></li>",vl,Y,Dl="For these tasks, the normalization process in the code is as follows:",zl,V,_l,F,Kl="This approach ensures that even for generative tasks, we can provide normalized scores that are comparable across different evaluations.",Il,q,gl,R,Ol='For more detailed information and examples, please refer to our <a href="https://huggingface.co/spaces/open-llm-leaderboard/blog" rel="nofollow">blog post</a> on scores normalization.',Al,L,le='If you have any questions or need clarification, please start a new discussion on <a href="https://huggingface.co/spaces/open-llm-leaderboard/open_llm_leaderboard/discussions" rel="nofollow">the Leaderboard page</a>.',$l,H,kl,D,xl;return U=new w({props:{title:"Scores Normalization",local:"scores-normalization",headingTag:"h1"}}),h=new w({props:{title:"What is Normalization?",local:"what-is-normalization",headingTag:"h2"}}),T=new w({props:{title:"General Normalization Process",local:"general-normalization-process",headingTag:"h2"}}),z=new Wl({props:{code:"ZGVmJTIwbm9ybWFsaXplX3dpdGhpbl9yYW5nZSh2YWx1ZSUyQyUyMGxvd2VyX2JvdW5kJTJDJTIwaGlnaGVyX2JvdW5kKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCh2YWx1ZSUyMC0lMjBsb3dlcl9ib3VuZCklMjAlMkYlMjAoaGlnaGVyX2JvdW5kJTIwLSUyMGxvd2VyX2JvdW5kKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">normalize_within_range</span>(<span class="hljs-params">value, lower_bound, higher_bound</span>):
    <span class="hljs-keyword">return</span> (value - lower_bound) / (higher_bound - lower_bound)`,wrap:!1}}),_=new w({props:{title:"Normalizing Tasks without Subtasks",local:"normalizing-tasks-without-subtasks",headingTag:"h2"}}),A=new w({props:{title:"Example: Normalizing GPQA Scores",local:"example-normalizing-gpqa-scores",headingTag:"h3"}}),k=new Wl({props:{code:"cmF3X3Njb3JlJTIwJTNEJTIwMC42JTIwJTIwJTIzJTIwRXhhbXBsZSUyMHJhdyUyMHNjb3JlJTBBbG93ZXJfYm91bmQlMjAlM0QlMjAwLjI1JTBBaGlnaGVyX2JvdW5kJTIwJTNEJTIwMS4wJTBBJTBBaWYlMjByYXdfc2NvcmUlMjAlM0MlMjBsb3dlcl9ib3VuZCUzQSUwQSUyMCUyMCUyMCUyMG5vcm1hbGl6ZWRfc2NvcmUlMjAlM0QlMjAwJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMG5vcm1hbGl6ZWRfc2NvcmUlMjAlM0QlMjBub3JtYWxpemVfd2l0aGluX3JhbmdlKHJhd19zY29yZSUyQyUyMGxvd2VyX2JvdW5kJTJDJTIwaGlnaGVyX2JvdW5kKSUyMColMjAxMDAlMEElMEFwcmludChmJTIyTm9ybWFsaXplZCUyMEdQUUElMjBzY29yZSUzQSUyMCU3Qm5vcm1hbGl6ZWRfc2NvcmUlM0EuMmYlN0QlMjIpJTBBJTIzJTIwT3V0cHV0JTNBJTIwTm9ybWFsaXplZCUyMEdQUUElMjBzY29yZSUzQSUyMDQ2LjY3",highlighted:`raw_score = <span class="hljs-number">0.6</span>  <span class="hljs-comment"># Example raw score</span>
lower_bound = <span class="hljs-number">0.25</span>
higher_bound = <span class="hljs-number">1.0</span>

<span class="hljs-keyword">if</span> raw_score &lt; lower_bound:
    normalized_score = <span class="hljs-number">0</span>
<span class="hljs-keyword">else</span>:
    normalized_score = normalize_within_range(raw_score, lower_bound, higher_bound) * <span class="hljs-number">100</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Normalized GPQA score: <span class="hljs-subst">{normalized_score:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
<span class="hljs-comment"># Output: Normalized GPQA score: 46.67</span>`,wrap:!1}}),x=new w({props:{title:"Normalizing Tasks with Subtasks",local:"normalizing-tasks-with-subtasks",headingTag:"h2"}}),E=new w({props:{title:"Example: Normalizing MUSR Scores",local:"example-normalizing-musr-scores",headingTag:"h3"}}),Z=new Wl({props:{code:"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",highlighted:`subtasks = [
    {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;murder_mysteries&quot;</span>, <span class="hljs-string">&quot;raw_score&quot;</span>: <span class="hljs-number">0.7</span>, <span class="hljs-string">&quot;lower_bound&quot;</span>: <span class="hljs-number">0.5</span>},
    {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;object_placement&quot;</span>, <span class="hljs-string">&quot;raw_score&quot;</span>: <span class="hljs-number">0.4</span>, <span class="hljs-string">&quot;lower_bound&quot;</span>: <span class="hljs-number">0.2</span>},
    {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;team_allocation&quot;</span>, <span class="hljs-string">&quot;raw_score&quot;</span>: <span class="hljs-number">0.6</span>, <span class="hljs-string">&quot;lower_bound&quot;</span>: <span class="hljs-number">0.333</span>}
]

normalized_scores = []

<span class="hljs-keyword">for</span> subtask <span class="hljs-keyword">in</span> subtasks:
    <span class="hljs-keyword">if</span> subtask[<span class="hljs-string">&quot;raw_score&quot;</span>] &lt; subtask[<span class="hljs-string">&quot;lower_bound&quot;</span>]:
        normalized_score = <span class="hljs-number">0</span>
    <span class="hljs-keyword">else</span>:
        normalized_score = normalize_within_range(
            subtask[<span class="hljs-string">&quot;raw_score&quot;</span>], 
            subtask[<span class="hljs-string">&quot;lower_bound&quot;</span>], 
            <span class="hljs-number">1.0</span>
        ) * <span class="hljs-number">100</span>
    normalized_scores.append(normalized_score)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{subtask[<span class="hljs-string">&#x27;name&#x27;</span>]}</span> normalized score: <span class="hljs-subst">{normalized_score:<span class="hljs-number">.2</span>f}</span>&quot;</span>)

overall_normalized_score = <span class="hljs-built_in">sum</span>(normalized_scores) / <span class="hljs-built_in">len</span>(normalized_scores)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Overall normalized MUSR score: <span class="hljs-subst">{overall_normalized_score:<span class="hljs-number">.2</span>f}</span>&quot;</span>)

<span class="hljs-comment"># Output:</span>
<span class="hljs-comment"># murder_mysteries normalized score: 40.00</span>
<span class="hljs-comment"># object_placement normalized score: 25.00</span>
<span class="hljs-comment"># team_allocation normalized score: 40.00</span>
<span class="hljs-comment"># Overall normalized MUSR score: 35.00</span>`,wrap:!1}}),B=new w({props:{title:"Generative Evaluations",local:"generative-evaluations",headingTag:"h2"}}),V=new Wl({props:{code:"Zm9yJTIwc3VidGFzayUyMGluJTIwc3VidGFza3MlM0ElMEElMjAlMjAlMjAlMjBzdWJ0YXNrX3ZhbCUyMCUzRCUyMHN1YnRhc2sudmFsdWUlMEElMjAlMjAlMjAlMjB2YWx1ZSUyMCUzRCUyMGRhdGElNUIlMjJyZXN1bHRzJTIyJTVEJTVCc3VidGFza192YWwuYmVuY2htYXJrJTVEJTVCc3VidGFza192YWwubWV0cmljJTVEJTBBJTIwJTIwJTIwJTIwaGlnaGVyX2JvdW5kJTIwJTNEJTIwMSUwQSUyMCUyMCUyMCUyMGxvd2VyX2JvdW5kJTIwJTNEJTIwaGlnaGVyX2JvdW5kJTIwJTJGJTIwc3VidGFza192YWwubnVtX2Nob2ljZXMlMjBpZiUyMHN1YnRhc2tfdmFsLm51bV9jaG9pY2VzJTIwJTNFJTIwMCUyMGVsc2UlMjAwJTBBJTIwJTIwJTIwJTIwaWYlMjB2YWx1ZSUyMCUzQyUyMGxvd2VyX2JvdW5kJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplZF9zY29yZSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplZF9zY29yZSUyMCUzRCUyMG5vcm1hbGl6ZV93aXRoaW5fcmFuZ2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmFsdWUlM0R2YWx1ZSUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvd2VyX2JvdW5kJTNEbG93ZXJfYm91bmQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoaWdoZXJfYm91bmQlM0RoaWdoZXJfYm91bmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwbm9ybWFsaXplZF9zY29yZXMuYXBwZW5kKG5vcm1hbGl6ZWRfc2NvcmUlMjAqJTIwMTAwKQ==",highlighted:`<span class="hljs-keyword">for</span> subtask <span class="hljs-keyword">in</span> subtasks:
    subtask_val = subtask.value
    value = data[<span class="hljs-string">&quot;results&quot;</span>][subtask_val.benchmark][subtask_val.metric]
    higher_bound = <span class="hljs-number">1</span>
    lower_bound = higher_bound / subtask_val.num_choices <span class="hljs-keyword">if</span> subtask_val.num_choices &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-number">0</span>
    <span class="hljs-keyword">if</span> value &lt; lower_bound:
        normalized_score = <span class="hljs-number">0</span>
    <span class="hljs-keyword">else</span>:
        normalized_score = normalize_within_range(
            value=value, 
            lower_bound=lower_bound,
            higher_bound=higher_bound
        )
    normalized_scores.append(normalized_score * <span class="hljs-number">100</span>)`,wrap:!1}}),q=new w({props:{title:"Further Information",local:"further-information",headingTag:"h2"}}),H=new me({props:{source:"https://github.com/huggingface/leaderboards/blob/main/docs/source/en/open_llm_leaderboard/normalization.md"}}),{c(){j=i("meta"),K=a(),P=i("p"),O=a(),M(U.$$.fragment),ll=a(),b=i("p"),b.textContent=El,el=a(),M(h.$$.fragment),sl=a(),d=i("p"),d.textContent=Sl,tl=a(),J=i("ol"),J.innerHTML=Nl,al=a(),M(T.$$.fragment),nl=a(),f=i("p"),f.textContent=Zl,il=a(),C=i("ol"),C.innerHTML=Bl,ol=a(),v=i("p"),v.textContent=Xl,rl=a(),M(z.$$.fragment),Ml=a(),M(_.$$.fragment),ml=a(),I=i("p"),I.textContent=Ql,pl=a(),g=i("ul"),g.innerHTML=Yl,ul=a(),M(A.$$.fragment),cl=a(),$=i("p"),$.innerHTML=Vl,yl=a(),M(k.$$.fragment),jl=a(),M(x.$$.fragment),wl=a(),W=i("p"),W.textContent=Fl,Ul=a(),G=i("ul"),G.innerHTML=ql,bl=a(),M(E.$$.fragment),hl=a(),S=i("p"),S.textContent=Rl,dl=a(),N=i("ul"),N.innerHTML=Ll,Jl=a(),M(Z.$$.fragment),Tl=a(),M(B.$$.fragment),fl=a(),X=i("p"),X.textContent=Hl,Cl=a(),Q=i("ol"),Q.innerHTML=Pl,vl=a(),Y=i("p"),Y.textContent=Dl,zl=a(),M(V.$$.fragment),_l=a(),F=i("p"),F.textContent=Kl,Il=a(),M(q.$$.fragment),gl=a(),R=i("p"),R.innerHTML=Ol,Al=a(),L=i("p"),L.innerHTML=le,$l=a(),M(H.$$.fragment),kl=a(),D=i("p"),this.h()},l(l){const e=re("svelte-u9bgzb",document.head);j=o(e,"META",{name:!0,content:!0}),e.forEach(s),K=n(l),P=o(l,"P",{}),ee(P).forEach(s),O=n(l),m(U.$$.fragment,l),ll=n(l),b=o(l,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1o7378m"&&(b.textContent=El),el=n(l),m(h.$$.fragment,l),sl=n(l),d=o(l,"P",{"data-svelte-h":!0}),r(d)!=="svelte-1g21ee8"&&(d.textContent=Sl),tl=n(l),J=o(l,"OL",{"data-svelte-h":!0}),r(J)!=="svelte-zj6h40"&&(J.innerHTML=Nl),al=n(l),m(T.$$.fragment,l),nl=n(l),f=o(l,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1homifm"&&(f.textContent=Zl),il=n(l),C=o(l,"OL",{"data-svelte-h":!0}),r(C)!=="svelte-1noqtti"&&(C.innerHTML=Bl),ol=n(l),v=o(l,"P",{"data-svelte-h":!0}),r(v)!=="svelte-uv3qwg"&&(v.textContent=Xl),rl=n(l),m(z.$$.fragment,l),Ml=n(l),m(_.$$.fragment,l),ml=n(l),I=o(l,"P",{"data-svelte-h":!0}),r(I)!=="svelte-ukmwwm"&&(I.textContent=Ql),pl=n(l),g=o(l,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-199eldc"&&(g.innerHTML=Yl),ul=n(l),m(A.$$.fragment,l),cl=n(l),$=o(l,"P",{"data-svelte-h":!0}),r($)!=="svelte-1n8wkts"&&($.innerHTML=Vl),yl=n(l),m(k.$$.fragment,l),jl=n(l),m(x.$$.fragment,l),wl=n(l),W=o(l,"P",{"data-svelte-h":!0}),r(W)!=="svelte-3f8l62"&&(W.textContent=Fl),Ul=n(l),G=o(l,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-cnj190"&&(G.innerHTML=ql),bl=n(l),m(E.$$.fragment,l),hl=n(l),S=o(l,"P",{"data-svelte-h":!0}),r(S)!=="svelte-hgykxj"&&(S.textContent=Rl),dl=n(l),N=o(l,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-2hbeeh"&&(N.innerHTML=Ll),Jl=n(l),m(Z.$$.fragment,l),Tl=n(l),m(B.$$.fragment,l),fl=n(l),X=o(l,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1yp6rl7"&&(X.textContent=Hl),Cl=n(l),Q=o(l,"OL",{"data-svelte-h":!0}),r(Q)!=="svelte-1lwzczp"&&(Q.innerHTML=Pl),vl=n(l),Y=o(l,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1lm3jm4"&&(Y.textContent=Dl),zl=n(l),m(V.$$.fragment,l),_l=n(l),F=o(l,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1k8dio0"&&(F.textContent=Kl),Il=n(l),m(q.$$.fragment,l),gl=n(l),R=o(l,"P",{"data-svelte-h":!0}),r(R)!=="svelte-12yyx1q"&&(R.innerHTML=Ol),Al=n(l),L=o(l,"P",{"data-svelte-h":!0}),r(L)!=="svelte-n94pcj"&&(L.innerHTML=le),$l=n(l),m(H.$$.fragment,l),kl=n(l),D=o(l,"P",{}),ee(D).forEach(s),this.h()},h(){se(j,"name","hf:doc:metadata"),se(j,"content",ue)},m(l,e){Me(document.head,j),t(l,K,e),t(l,P,e),t(l,O,e),p(U,l,e),t(l,ll,e),t(l,b,e),t(l,el,e),p(h,l,e),t(l,sl,e),t(l,d,e),t(l,tl,e),t(l,J,e),t(l,al,e),p(T,l,e),t(l,nl,e),t(l,f,e),t(l,il,e),t(l,C,e),t(l,ol,e),t(l,v,e),t(l,rl,e),p(z,l,e),t(l,Ml,e),p(_,l,e),t(l,ml,e),t(l,I,e),t(l,pl,e),t(l,g,e),t(l,ul,e),p(A,l,e),t(l,cl,e),t(l,$,e),t(l,yl,e),p(k,l,e),t(l,jl,e),p(x,l,e),t(l,wl,e),t(l,W,e),t(l,Ul,e),t(l,G,e),t(l,bl,e),p(E,l,e),t(l,hl,e),t(l,S,e),t(l,dl,e),t(l,N,e),t(l,Jl,e),p(Z,l,e),t(l,Tl,e),p(B,l,e),t(l,fl,e),t(l,X,e),t(l,Cl,e),t(l,Q,e),t(l,vl,e),t(l,Y,e),t(l,zl,e),p(V,l,e),t(l,_l,e),t(l,F,e),t(l,Il,e),p(q,l,e),t(l,gl,e),t(l,R,e),t(l,Al,e),t(l,L,e),t(l,$l,e),p(H,l,e),t(l,kl,e),t(l,D,e),xl=!0},p:ae,i(l){xl||(u(U.$$.fragment,l),u(h.$$.fragment,l),u(T.$$.fragment,l),u(z.$$.fragment,l),u(_.$$.fragment,l),u(A.$$.fragment,l),u(k.$$.fragment,l),u(x.$$.fragment,l),u(E.$$.fragment,l),u(Z.$$.fragment,l),u(B.$$.fragment,l),u(V.$$.fragment,l),u(q.$$.fragment,l),u(H.$$.fragment,l),xl=!0)},o(l){c(U.$$.fragment,l),c(h.$$.fragment,l),c(T.$$.fragment,l),c(z.$$.fragment,l),c(_.$$.fragment,l),c(A.$$.fragment,l),c(k.$$.fragment,l),c(x.$$.fragment,l),c(E.$$.fragment,l),c(Z.$$.fragment,l),c(B.$$.fragment,l),c(V.$$.fragment,l),c(q.$$.fragment,l),c(H.$$.fragment,l),xl=!1},d(l){l&&(s(K),s(P),s(O),s(ll),s(b),s(el),s(sl),s(d),s(tl),s(J),s(al),s(nl),s(f),s(il),s(C),s(ol),s(v),s(rl),s(Ml),s(ml),s(I),s(pl),s(g),s(ul),s(cl),s($),s(yl),s(jl),s(wl),s(W),s(Ul),s(G),s(bl),s(hl),s(S),s(dl),s(N),s(Jl),s(Tl),s(fl),s(X),s(Cl),s(Q),s(vl),s(Y),s(zl),s(_l),s(F),s(Il),s(gl),s(R),s(Al),s(L),s($l),s(kl),s(D)),s(j),y(U,l),y(h,l),y(T,l),y(z,l),y(_,l),y(A,l),y(k,l),y(x,l),y(E,l),y(Z,l),y(B,l),y(V,l),y(q,l),y(H,l)}}}const ue='{"title":"Scores Normalization","local":"scores-normalization","sections":[{"title":"What is Normalization?","local":"what-is-normalization","sections":[],"depth":2},{"title":"General Normalization Process","local":"general-normalization-process","sections":[],"depth":2},{"title":"Normalizing Tasks without Subtasks","local":"normalizing-tasks-without-subtasks","sections":[{"title":"Example: Normalizing GPQA Scores","local":"example-normalizing-gpqa-scores","sections":[],"depth":3}],"depth":2},{"title":"Normalizing Tasks with Subtasks","local":"normalizing-tasks-with-subtasks","sections":[{"title":"Example: Normalizing MUSR Scores","local":"example-normalizing-musr-scores","sections":[],"depth":3}],"depth":2},{"title":"Generative Evaluations","local":"generative-evaluations","sections":[],"depth":2},{"title":"Further Information","local":"further-information","sections":[],"depth":2}],"depth":1}';function ce(Gl){return ne(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class be extends ie{constructor(j){super(),oe(this,j,ce,pe,te,{})}}export{be as component};
