import{s as Gt,o as Zt,n as Xe}from"../chunks/scheduler.37c15a92.js";import{S as kt,i as Vt,g as M,s as l,r as p,A as Wt,h as y,f as t,c as n,j as xt,u as o,x as J,k as Bt,y as Rt,a,v as r,d,t as h,w as c}from"../chunks/index.2bf4358c.js";import{T as Re}from"../chunks/Tip.363c041f.js";import{Y as Xt}from"../chunks/Youtube.1e50a667.js";import{C as u}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Ct}from"../chunks/CourseFloatingBanner.15ba07e6.js";import{H as Ls,E as Et}from"../chunks/EditOnGithub.8916dc7c.js";function Nt(w){let i,T='✎ By default, 🤗 Datasets will decompress the files needed to load a dataset. If you want to preserve hard drive space, you can pass <code>DownloadConfig(delete_extracted=True)</code> to the <code>download_config</code> argument of <code>load_dataset()</code>. See the <a href="https://huggingface.co/docs/datasets/package_reference/builder_classes#datasets.DownloadConfig" rel="nofollow">documentation</a> for more details.';return{c(){i=M("p"),i.innerHTML=T},l(m){i=y(m,"P",{"data-svelte-h":!0}),J(i)!=="svelte-1j3uv2u"&&(i.innerHTML=T)},m(m,f){a(m,i,f)},p:Xe,d(m){m&&t(i)}}}function vt(w){let i,T='✏️ <strong>Try it out!</strong> Pick one of the <a href="https://batbot.ai/datasets/EleutherAI_ThePile_v1/pile_preliminary_components/" rel="nofollow">subsets</a> from the Pile that is larger than your laptop or desktop’s RAM, load it with 🤗 Datasets, and measure the amount of RAM used. Note that to get an accurate measurement, you’ll want to do this in a new process. You can find the decompressed sizes of each subset in Table 1 of <a href="https://arxiv.org/abs/2101.00027" rel="nofollow">the Pile paper</a>.';return{c(){i=M("p"),i.innerHTML=T},l(m){i=y(m,"P",{"data-svelte-h":!0}),J(i)!=="svelte-ksqeo6"&&(i.innerHTML=T)},m(m,f){a(m,i,f)},p:Xe,d(m){m&&t(i)}}}function _t(w){let i,T='💡 In Jupyter notebooks you can also time cells using the <a href="https://ipython.readthedocs.io/en/stable/interactive/magics.html#magic-timeit" rel="nofollow"><code>%%timeit</code> magic function</a>.';return{c(){i=M("p"),i.innerHTML=T},l(m){i=y(m,"P",{"data-svelte-h":!0}),J(i)!=="svelte-8b0mae"&&(i.innerHTML=T)},m(m,f){a(m,i,f)},p:Xe,d(m){m&&t(i)}}}function zt(w){let i,T="💡 To speed up tokenization with streaming you can pass <code>batched=True</code>, as we saw in the last section. It will process the examples batch by batch; the default batch size is 1,000 and can be specified with the <code>batch_size</code> argument.";return{c(){i=M("p"),i.innerHTML=T},l(m){i=y(m,"P",{"data-svelte-h":!0}),J(i)!=="svelte-81vf72"&&(i.innerHTML=T)},m(m,f){a(m,i,f)},p:Xe,d(m){m&&t(i)}}}function Qt(w){let i,T='✏️ <strong>Try it out!</strong> Use one of the large Common Crawl corpora like <a href="https://huggingface.co/datasets/mc4" rel="nofollow"><code>mc4</code></a> or <a href="https://huggingface.co/datasets/oscar" rel="nofollow"><code>oscar</code></a> to create a streaming multilingual dataset that represents the spoken proportions of languages in a country of your choice. For example, the four national languages in Switzerland are German, French, Italian, and Romansh, so you could try creating a Swiss corpus by sampling the Oscar subsets according to their spoken proportion.';return{c(){i=M("p"),i.innerHTML=T},l(m){i=y(m,"P",{"data-svelte-h":!0}),J(i)!=="svelte-1e4y0rz"&&(i.innerHTML=T)},m(m,f){a(m,i,f)},p:Xe,d(m){m&&t(i)}}}function Ft(w){let i,T,m,f,$,Ce,x,Ee,B,Ps="Nowadays it is not uncommon to find yourself working with multi-gigabyte datasets, especially if you’re planning to pretrain a transformer like BERT or GPT-2 from scratch. In these cases, even <em>loading</em> the data can be a challenge. For example, the WebText corpus used to pretrain GPT-2 consists of over 8 million documents and 40 GB of text — loading this into your laptop’s RAM is likely to give it a heart attack!",Ne,G,qs="Fortunately, 🤗 Datasets has been designed to overcome these limitations. It frees you from memory management problems by treating datasets as <em>memory-mapped</em> files, and from hard drive limits by <em>streaming</em> the entries in a corpus.",ve,Z,_e,k,Os='In this section we’ll explore these features of 🤗 Datasets with a huge 825 GB corpus known as <a href="https://pile.eleuther.ai" rel="nofollow">the Pile</a>. Let’s get started!',ze,V,Qe,W,Ks='The Pile is an English text corpus that was created by <a href="https://www.eleuther.ai" rel="nofollow">EleutherAI</a> for training large-scale language models. It includes a diverse range of datasets, spanning scientific articles, GitHub code repositories, and filtered web text. The training corpus is available in <a href="https://batbot.ai/datasets/EleutherAI_ThePile_v1/pile/" rel="nofollow">14 GB chunks</a>, and you can also download several of the <a href="https://batbot.ai/datasets/EleutherAI_ThePile_v1/pile_preliminary_components/" rel="nofollow">individual components</a>. Let’s start by taking a look at the PubMed Abstracts dataset, which is a corpus of abstracts from 15 million biomedical publications on <a href="https://pubmed.ncbi.nlm.nih.gov/" rel="nofollow">PubMed</a>. The dataset is in <a href="https://jsonlines.org" rel="nofollow">JSON Lines format</a> and is compressed using the <code>zstandard</code> library, so first we need to install that:',Fe,R,He,X,et='Next, we can load the dataset using the method for remote files that we learned in <a href="/course/chapter5/2">section 2</a>:',Ye,C,Ae,E,Se,N,st="We can see that there are 15,518,009 rows and 2 columns in our dataset — that’s a lot!",De,b,Le,v,tt="Let’s inspect the contents of the first example:",Pe,_,qe,z,Oe,Q,at="Okay, this looks like the abstract from a medical article. Now let’s see how much RAM we’ve used to load the dataset!",Ke,F,es,H,lt='A simple way to measure memory usage in Python is with the <a href="https://psutil.readthedocs.io/en/latest/" rel="nofollow"><code>psutil</code></a> library, which can be installed with <code>pip</code> as follows:',ss,Y,ts,A,nt="It provides a <code>Process</code> class that allows us to check the memory usage of the current process as follows:",as,S,ls,D,ns,L,it="Here the <code>rss</code> attribute refers to the <em>resident set size</em>, which is the fraction of memory that a process occupies in RAM. This measurement also includes the memory used by the Python interpreter and the libraries we’ve loaded, so the actual amount of memory used to load the dataset is a bit smaller. For comparison, let’s see how large the dataset is on disk, using the <code>dataset_size</code> attribute. Since the result is expressed in bytes like before, we need to manually convert it to gigabytes:",is,P,ps,q,os,O,pt="Nice — despite it being almost 20 GB large, we’re able to load and access the dataset with much less RAM!",rs,j,ds,K,ot='If you’re familiar with Pandas, this result might come as a surprise because of Wes Kinney’s famous <a href="https://wesmckinney.com/blog/apache-arrow-pandas-internals/" rel="nofollow">rule of thumb</a> that you typically need 5 to 10 times as much RAM as the size of your dataset. So how does 🤗 Datasets solve this memory management problem? 🤗 Datasets treats each dataset as a <a href="https://en.wikipedia.org/wiki/Memory-mapped_file" rel="nofollow">memory-mapped file</a>, which provides a mapping between RAM and filesystem storage that allows the library to access and operate on elements of the dataset without needing to fully load it into memory.',hs,ee,rt='Memory-mapped files can also be shared across multiple processes, which enables methods like <code>Dataset.map()</code> to be parallelized without needing to move or copy the dataset. Under the hood, these capabilities are all realized by the <a href="https://arrow.apache.org" rel="nofollow">Apache Arrow</a> memory format and <a href="https://arrow.apache.org/docs/python/index.html" rel="nofollow"><code>pyarrow</code></a> library, which make the data loading and processing lightning fast. (For more details about Apache Arrow and comparisons to Pandas, check out <a href="https://towardsdatascience.com/apache-arrow-read-dataframe-with-zero-memory-69634092b1a" rel="nofollow">Dejan Simic’s blog post</a>.) To see this in action, let’s run a little speed test by iterating over all the elements in the PubMed Abstracts dataset:',cs,se,ms,te,Ms,ae,dt="Here we’ve used Python’s <code>timeit</code> module to measure the execution time taken by <code>code_snippet</code>. You’ll typically be able to iterate over a dataset at speed of a few tenths of a GB/s to several GB/s. This works great for the vast majority of applications, but sometimes you’ll have to work with a dataset that is too large to even store on your laptop’s hard drive. For example, if we tried to download the Pile in its entirety, we’d need 825 GB of free disk space! To handle these cases, 🤗 Datasets provides a streaming feature that allows us to download and access elements on the fly, without needing to download the whole dataset. Let’s take a look at how this works.",ys,U,Js,le,us,ne,ht="To enable dataset streaming you just need to pass the <code>streaming=True</code> argument to the <code>load_dataset()</code> function. For example, let’s load the PubMed Abstracts dataset again, but in streaming mode:",Ts,ie,fs,pe,ct="Instead of the familiar <code>Dataset</code> that we’ve encountered elsewhere in this chapter, the object returned with <code>streaming=True</code> is an <code>IterableDataset</code>. As the name suggests, to access the elements of an <code>IterableDataset</code> we need to iterate over it. We can access the first element of our streamed dataset as follows:",ws,oe,bs,re,js,de,mt='The elements from a streamed dataset can be processed on the fly using <code>IterableDataset.map()</code>, which is useful during training if you need to tokenize the inputs. The process is exactly the same as the one we used to tokenize our dataset in <a href="/course/chapter3">Chapter 3</a>, with the only difference being that outputs are returned one by one:',Us,he,gs,ce,Is,g,$s,me,Mt="You can also shuffle a streamed dataset using <code>IterableDataset.shuffle()</code>, but unlike <code>Dataset.shuffle()</code> this only shuffles the elements in a predefined <code>buffer_size</code>:",xs,Me,Bs,ye,Gs,Je,yt="In this example, we selected a random example from the first 10,000 examples in the buffer. Once an example is accessed, its spot in the buffer is filled with the next example in the corpus (i.e., the 10,001st example in the case above). You can also select elements from a streamed dataset using the <code>IterableDataset.take()</code> and <code>IterableDataset.skip()</code> functions, which act in a similar way to <code>Dataset.select()</code>. For example, to select the first 5 examples in the PubMed Abstracts dataset we can do the following:",Zs,ue,ks,Te,Vs,fe,Jt="Similarly, you can use the <code>IterableDataset.skip()</code> function to create training and validation splits from a shuffled dataset as follows:",Ws,we,Rs,be,ut="Let’s round out our exploration of dataset streaming with a common application: combining multiple datasets together to create a single corpus. 🤗 Datasets provides an <code>interleave_datasets()</code> function that converts a list of <code>IterableDataset</code> objects into a single <code>IterableDataset</code>, where the elements of the new dataset are obtained by alternating among the source examples. This function is especially useful when you’re trying to combine large datasets, so as an example let’s stream the FreeLaw subset of the Pile, which is a 51 GB dataset of legal opinions from US courts:",Xs,je,Cs,Ue,Es,ge,Tt="This dataset is large enough to stress the RAM of most laptops, yet we’ve been able to load and access it without breaking a sweat! Let’s now combine the examples from the FreeLaw and PubMed Abstracts datasets with the <code>interleave_datasets()</code> function:",Ns,Ie,vs,$e,_s,xe,ft="Here we’ve used the <code>islice()</code> function from Python’s <code>itertools</code> module to select the first two examples from the combined dataset, and we can see that they match the first examples from each of the two source datasets.",zs,Be,wt="Finally, if you want to stream the Pile in its 825 GB entirety, you can grab all the prepared files as follows:",Qs,Ge,Fs,Ze,Hs,I,Ys,ke,bt="You now have all the tools you need to load and process datasets of all shapes and sizes — but unless you’re exceptionally lucky, there will come a point in your NLP journey where you’ll have to actually create a dataset to solve the problem at hand. That’s the topic of the next section!",As,Ve,Ss,We,Ds;return $=new Ls({props:{title:"Big data? 🤗 Datasets to the rescue!",local:"big-data-datasets-to-the-rescue",headingTag:"h1"}}),x=new Ct({props:{chapter:5,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter5/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter5/section4.ipynb"}]}}),Z=new Xt({props:{id:"JwISwTCPPWo"}}),V=new Ls({props:{title:"What is the Pile?",local:"what-is-the-pile",headingTag:"h2"}}),R=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjB6c3RhbmRhcmQ=",highlighted:"!pip install zstandard",wrap:!1}}),C=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwVGhpcyUyMHRha2VzJTIwYSUyMGZldyUyMG1pbnV0ZXMlMjB0byUyMHJ1biUyQyUyMHNvJTIwZ28lMjBncmFiJTIwYSUyMHRlYSUyMG9yJTIwY29mZmVlJTIwd2hpbGUlMjB5b3UlMjB3YWl0JTIwJTNBKSUwQWRhdGFfZmlsZXMlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZxdWFsaXMyMDA2JTJGUFVCTUVEX3RpdGxlX2Fic3RyYWN0c18yMDIwX2Jhc2VsaW5lJTJGcmVzb2x2ZSUyRm1haW4lMkZQVUJNRURfdGl0bGVfYWJzdHJhY3RzXzIwMjBfYmFzZWxpbmUuanNvbmwuenN0JTIyJTBBcHVibWVkX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyanNvbiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFwdWJtZWRfZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># This takes a few minutes to run, so go grab a tea or coffee while you wait :)</span>
data_files = <span class="hljs-string">&quot;https://huggingface.co/datasets/qualis2006/PUBMED_title_abstracts_2020_baseline/resolve/main/PUBMED_title_abstracts_2020_baseline.jsonl.zst&quot;</span>
pubmed_dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>)
pubmed_dataset`,wrap:!1}}),E=new u({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidtZXRhJyUyQyUyMCd0ZXh0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwMTU1MTgwMDklMEElN0Qp",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;meta&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>],
    num_rows: <span class="hljs-number">15518009</span>
})`,wrap:!1}}),b=new Re({props:{$$slots:{default:[Nt]},$$scope:{ctx:w}}}),_=new u({props:{code:"cHVibWVkX2RhdGFzZXQlNUIwJTVE",highlighted:'pubmed_dataset[<span class="hljs-number">0</span>]',wrap:!1}}),z=new u({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24uJTVDblRvJTIwZGV0ZXJtaW5lJTIwdGhlJTIwcHJldmFsZW5jZSUyMG9mJTIwaHlwb3hhZW1pYSUyMGluJTIwY2hpbGRyZW4lMjBhZ2VkJTIwdW5kZXIlMjA1JTIweWVhcnMlMjBzdWZmZXJpbmclMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb25zJTIwKEFMUkkpJTJDJTIwdGhlJTIwcmlzayUyMGZhY3RvcnMlMjBmb3IlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHVuZGVyJTIwNSUyMHllYXJzJTIwb2YlMjBhZ2UlMjB3aXRoJTIwQUxSSSUyQyUyMGFuZCUyMHRoZSUyMGFzc29jaWF0aW9uJTIwb2YlMjBoeXBveGFlbWlhJTIwd2l0aCUyMGFuJTIwaW5jcmVhc2VkJTIwcmlzayUyMG9mJTIwZHlpbmclMjBpbiUyMGNoaWxkcmVuJTIwb2YlMjB0aGUlMjBzYW1lJTIwYWdlJTIwLi4uJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection.\\nTo determine the prevalence of hypoxaemia in children aged under 5 years suffering acute lower respiratory infections (ALRI), the risk factors for hypoxaemia in children under 5 years of age with ALRI, and the association of hypoxaemia with an increased risk of dying in children of the same age ...&#x27;</span>}`,wrap:!1}}),F=new Ls({props:{title:"The magic of memory mapping",local:"the-magic-of-memory-mapping",headingTag:"h2"}}),Y=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjBwc3V0aWw=",highlighted:"!pip install psutil",wrap:!1}}),S=new u({props:{code:"aW1wb3J0JTIwcHN1dGlsJTBBJTBBJTIzJTIwUHJvY2Vzcy5tZW1vcnlfaW5mbyUyMGlzJTIwZXhwcmVzc2VkJTIwaW4lMjBieXRlcyUyQyUyMHNvJTIwY29udmVydCUyMHRvJTIwbWVnYWJ5dGVzJTBBcHJpbnQoZiUyMlJBTSUyMHVzZWQlM0ElMjAlN0Jwc3V0aWwuUHJvY2VzcygpLm1lbW9yeV9pbmZvKCkucnNzJTIwJTJGJTIwKDEwMjQlMjAqJTIwMTAyNCklM0EuMmYlN0QlMjBNQiUyMik=",highlighted:`<span class="hljs-keyword">import</span> psutil

<span class="hljs-comment"># Process.memory_info is expressed in bytes, so convert to megabytes</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;RAM used: <span class="hljs-subst">{psutil.Process().memory_info().rss / (<span class="hljs-number">1024</span> * <span class="hljs-number">1024</span>):<span class="hljs-number">.2</span>f}</span> MB&quot;</span>)`,wrap:!1}}),D=new u({props:{code:"UkFNJTIwdXNlZCUzQSUyMDU2NzguMzMlMjBNQg==",highlighted:'RAM used: <span class="hljs-number">5678.33</span> MB',wrap:!1}}),P=new u({props:{code:"cHJpbnQoZiUyMkRhdGFzZXQlMjBzaXplJTIwaW4lMjBieXRlcyUzQSUyMCU3QnB1Ym1lZF9kYXRhc2V0LmRhdGFzZXRfc2l6ZSU3RCUyMiklMEFzaXplX2diJTIwJTNEJTIwcHVibWVkX2RhdGFzZXQuZGF0YXNldF9zaXplJTIwJTJGJTIwKDEwMjQqKjMpJTBBcHJpbnQoZiUyMkRhdGFzZXQlMjBzaXplJTIwKGNhY2hlJTIwZmlsZSklMjAlM0ElMjAlN0JzaXplX2diJTNBLjJmJTdEJTIwR0IlMjIp",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Dataset size in bytes: <span class="hljs-subst">{pubmed_dataset.dataset_size}</span>&quot;</span>)
size_gb = pubmed_dataset.dataset_size / (<span class="hljs-number">1024</span>**<span class="hljs-number">3</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Dataset size (cache file) : <span class="hljs-subst">{size_gb:<span class="hljs-number">.2</span>f}</span> GB&quot;</span>)`,wrap:!1}}),q=new u({props:{code:"RGF0YXNldCUyMHNpemUlMjBpbiUyMGJ5dGVzJTIwJTNBJTIwMjA5Nzk0MzcwNTElMEFEYXRhc2V0JTIwc2l6ZSUyMChjYWNoZSUyMGZpbGUpJTIwJTNBJTIwMTkuNTQlMjBHQg==",highlighted:`Dataset size <span class="hljs-keyword">in</span> <span class="hljs-built_in">bytes</span> : <span class="hljs-number">20979437051</span>
Dataset size (cache file) : <span class="hljs-number">19.54</span> GB`,wrap:!1}}),j=new Re({props:{$$slots:{default:[vt]},$$scope:{ctx:w}}}),se=new u({props:{code:"aW1wb3J0JTIwdGltZWl0JTBBJTBBY29kZV9zbmlwcGV0JTIwJTNEJTIwJTIyJTIyJTIyYmF0Y2hfc2l6ZSUyMCUzRCUyMDEwMDAlMEElMEFmb3IlMjBpZHglMjBpbiUyMHJhbmdlKDAlMkMlMjBsZW4ocHVibWVkX2RhdGFzZXQpJTJDJTIwYmF0Y2hfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBfJTIwJTNEJTIwcHVibWVkX2RhdGFzZXQlNUJpZHglM0FpZHglMjAlMkIlMjBiYXRjaF9zaXplJTVEJTBBJTIyJTIyJTIyJTBBJTBBdGltZSUyMCUzRCUyMHRpbWVpdC50aW1laXQoc3RtdCUzRGNvZGVfc25pcHBldCUyQyUyMG51bWJlciUzRDElMkMlMjBnbG9iYWxzJTNEZ2xvYmFscygpKSUwQXByaW50KCUwQSUyMCUyMCUyMCUyMGYlMjJJdGVyYXRlZCUyMG92ZXIlMjAlN0JsZW4ocHVibWVkX2RhdGFzZXQpJTdEJTIwZXhhbXBsZXMlMjAoYWJvdXQlMjAlN0JzaXplX2diJTNBLjFmJTdEJTIwR0IpJTIwaW4lMjAlMjIlMEElMjAlMjAlMjAlMjBmJTIyJTdCdGltZSUzQS4xZiU3RHMlMkMlMjBpLmUuJTIwJTdCc2l6ZV9nYiUyRnRpbWUlM0EuM2YlN0QlMjBHQiUyRnMlMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> timeit

code_snippet = <span class="hljs-string">&quot;&quot;&quot;batch_size = 1000

for idx in range(0, len(pubmed_dataset), batch_size):
    _ = pubmed_dataset[idx:idx + batch_size]
&quot;&quot;&quot;</span>

time = timeit.timeit(stmt=code_snippet, number=<span class="hljs-number">1</span>, <span class="hljs-built_in">globals</span>=<span class="hljs-built_in">globals</span>())
<span class="hljs-built_in">print</span>(
    <span class="hljs-string">f&quot;Iterated over <span class="hljs-subst">{<span class="hljs-built_in">len</span>(pubmed_dataset)}</span> examples (about <span class="hljs-subst">{size_gb:<span class="hljs-number">.1</span>f}</span> GB) in &quot;</span>
    <span class="hljs-string">f&quot;<span class="hljs-subst">{time:<span class="hljs-number">.1</span>f}</span>s, i.e. <span class="hljs-subst">{size_gb/time:<span class="hljs-number">.3</span>f}</span> GB/s&quot;</span>
)`,wrap:!1}}),te=new u({props:{code:"J0l0ZXJhdGVkJTIwb3ZlciUyMDE1NTE4MDA5JTIwZXhhbXBsZXMlMjAoYWJvdXQlMjAxOS41JTIwR0IpJTIwaW4lMjA2NC4ycyUyQyUyMGkuZS4lMjAwLjMwNCUyMEdCJTJGcyc=",highlighted:'<span class="hljs-string">&#x27;Iterated over 15518009 examples (about 19.5 GB) in 64.2s, i.e. 0.304 GB/s&#x27;</span>',wrap:!1}}),U=new Re({props:{$$slots:{default:[_t]},$$scope:{ctx:w}}}),le=new Ls({props:{title:"Streaming datasets",local:"streaming-datasets",headingTag:"h2"}}),ie=new u({props:{code:"cHVibWVkX2RhdGFzZXRfc3RyZWFtZWQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIyanNvbiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUlMEEp",highlighted:`pubmed_dataset_streamed = load_dataset(
    <span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>
)`,wrap:!1}}),oe=new u({props:{code:"bmV4dChpdGVyKHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkKSk=",highlighted:'<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(pubmed_dataset_streamed))',wrap:!1}}),re=new u({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24uJTVDblRvJTIwZGV0ZXJtaW5lJTIwdGhlJTIwcHJldmFsZW5jZSUyMG9mJTIwaHlwb3hhZW1pYSUyMGluJTIwY2hpbGRyZW4lMjBhZ2VkJTIwdW5kZXIlMjA1JTIweWVhcnMlMjBzdWZmZXJpbmclMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb25zJTIwKEFMUkkpJTJDJTIwdGhlJTIwcmlzayUyMGZhY3RvcnMlMjBmb3IlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHVuZGVyJTIwNSUyMHllYXJzJTIwb2YlMjBhZ2UlMjB3aXRoJTIwQUxSSSUyQyUyMGFuZCUyMHRoZSUyMGFzc29jaWF0aW9uJTIwb2YlMjBoeXBveGFlbWlhJTIwd2l0aCUyMGFuJTIwaW5jcmVhc2VkJTIwcmlzayUyMG9mJTIwZHlpbmclMjBpbiUyMGNoaWxkcmVuJTIwb2YlMjB0aGUlMjBzYW1lJTIwYWdlJTIwLi4uJyU3RA==",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection.\\nTo determine the prevalence of hypoxaemia in children aged under 5 years suffering acute lower respiratory infections (ALRI), the risk factors for hypoxaemia in children under 5 years of age with ALRI, and the association of hypoxaemia with an increased risk of dying in children of the same age ...&#x27;</span>}`,wrap:!1}}),he=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldCUyMCUzRCUyMHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkLm1hcChsYW1iZGElMjB4JTNBJTIwdG9rZW5pemVyKHglNUIlMjJ0ZXh0JTIyJTVEKSklMEFuZXh0KGl0ZXIodG9rZW5pemVkX2RhdGFzZXQpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>)
tokenized_dataset = pubmed_dataset_streamed.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: tokenizer(x[<span class="hljs-string">&quot;text&quot;</span>]))
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(tokenized_dataset))`,wrap:!1}}),ce=new u({props:{code:"JTdCJ2lucHV0X2lkcyclM0ElMjAlNUIxMDElMkMlMjA0OTU4JTJDJTIwNTE3OCUyQyUyMDQzMjglMkMlMjA2Nzc5JTJDJTIwLi4uJTVEJTJDJTIwJ2F0dGVudGlvbl9tYXNrJyUzQSUyMCU1QjElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwLi4uJTVEJTdE",highlighted:'{<span class="hljs-string">&#x27;input_ids&#x27;</span>: [<span class="hljs-number">101</span>, <span class="hljs-number">4958</span>, <span class="hljs-number">5178</span>, <span class="hljs-number">4328</span>, <span class="hljs-number">6779</span>, ...], <span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, ...]}',wrap:!1}}),g=new Re({props:{$$slots:{default:[zt]},$$scope:{ctx:w}}}),Me=new u({props:{code:"c2h1ZmZsZWRfZGF0YXNldCUyMCUzRCUyMHB1Ym1lZF9kYXRhc2V0X3N0cmVhbWVkLnNodWZmbGUoYnVmZmVyX3NpemUlM0QxMF8wMDAlMkMlMjBzZWVkJTNENDIpJTBBbmV4dChpdGVyKHNodWZmbGVkX2RhdGFzZXQpKQ==",highlighted:`shuffled_dataset = pubmed_dataset_streamed.shuffle(buffer_size=<span class="hljs-number">10_000</span>, seed=<span class="hljs-number">42</span>)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(shuffled_dataset))`,wrap:!1}}),ye=new u({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MTA3OTklMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAndGV4dCclM0ElMjAnUmFuZG9taXplZCUyMHN0dWR5JTIwb2YlMjBkb3NlJTIwb3IlMjBzY2hlZHVsZSUyMG1vZGlmaWNhdGlvbiUyMG9mJTIwZ3JhbnVsb2N5dGUlMjBjb2xvbnktc3RpbXVsYXRpbmclMjBmYWN0b3IlMjBpbiUyMHBsYXRpbnVtLWJhc2VkJTIwY2hlbW90aGVyYXB5JTIwZm9yJTIwZWxkZXJseSUyMHBhdGllbnRzJTIwd2l0aCUyMGx1bmclMjBjYW5jZXIlMjAuLi4nJTdE",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11410799</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Randomized study of dose or schedule modification of granulocyte colony-stimulating factor in platinum-based chemotherapy for elderly patients with lung cancer ...&#x27;</span>}`,wrap:!1}}),ue=new u({props:{code:"ZGF0YXNldF9oZWFkJTIwJTNEJTIwcHVibWVkX2RhdGFzZXRfc3RyZWFtZWQudGFrZSg1KSUwQWxpc3QoZGF0YXNldF9oZWFkKQ==",highlighted:`dataset_head = pubmed_dataset_streamed.take(<span class="hljs-number">5</span>)
<span class="hljs-built_in">list</span>(dataset_head)`,wrap:!1}}),Te=new u({props:{code:"JTVCJTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAlMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24lMjAuLi4nJTdEJTJDJTBBJTIwJTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzUlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAlMjAndGV4dCclM0ElMjAnQ2xpbmljYWwlMjBzaWducyUyMG9mJTIwaHlwb3hhZW1pYSUyMGluJTIwY2hpbGRyZW4lMjB3aXRoJTIwYWN1dGUlMjBsb3dlciUyMHJlc3BpcmF0b3J5JTIwaW5mZWN0aW9uJTNBJTIwaW5kaWNhdG9ycyUyMG9mJTIwb3h5Z2VuJTIwdGhlcmFweSUyMC4uLiclN0QlMkMlMEElMjAlN0InbWV0YSclM0ElMjAlN0IncG1pZCclM0ElMjAxMTQwOTU3NiUyQyUyMCdsYW5ndWFnZSclM0ElMjAnZW5nJyU3RCUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCUyMkh5cG94YWVtaWElMjBpbiUyMGNoaWxkcmVuJTIwd2l0aCUyMHNldmVyZSUyMHBuZXVtb25pYSUyMGluJTIwUGFwdWElMjBOZXclMjBHdWluZWElMjAuLi4lMjIlN0QlMkMlMEElMjAlN0InbWV0YSclM0ElMjAlN0IncG1pZCclM0ElMjAxMTQwOTU3NyUyQyUyMCdsYW5ndWFnZSclM0ElMjAnZW5nJyU3RCUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCdPeHlnZW4lMjBjb25jZW50cmF0b3JzJTIwYW5kJTIwY3lsaW5kZXJzJTIwLi4uJyU3RCUyQyUwQSUyMCU3QidtZXRhJyUzQSUyMCU3QidwbWlkJyUzQSUyMDExNDA5NTc4JTJDJTIwJ2xhbmd1YWdlJyUzQSUyMCdlbmcnJTdEJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJ094eWdlbiUyMHN1cHBseSUyMGluJTIwcnVyYWwlMjBhZnJpY2ElM0ElMjBhJTIwcGVyc29uYWwlMjBleHBlcmllbmNlJTIwLi4uJyU3RCU1RA==",highlighted:`[{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409575</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Clinical signs of hypoxaemia in children with acute lower respiratory infection: indicators of oxygen therapy ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409576</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&quot;Hypoxaemia in children with severe pneumonia in Papua New Guinea ...&quot;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409577</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Oxygen concentrators and cylinders ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409578</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Oxygen supply in rural africa: a personal experience ...&#x27;</span>}]`,wrap:!1}}),we=new u({props:{code:"JTIzJTIwU2tpcCUyMHRoZSUyMGZpcnN0JTIwMSUyQzAwMCUyMGV4YW1wbGVzJTIwYW5kJTIwaW5jbHVkZSUyMHRoZSUyMHJlc3QlMjBpbiUyMHRoZSUyMHRyYWluaW5nJTIwc2V0JTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMHNodWZmbGVkX2RhdGFzZXQuc2tpcCgxMDAwKSUwQSUyMyUyMFRha2UlMjB0aGUlMjBmaXJzdCUyMDElMkMwMDAlMjBleGFtcGxlcyUyMGZvciUyMHRoZSUyMHZhbGlkYXRpb24lMjBzZXQlMEF2YWxpZGF0aW9uX2RhdGFzZXQlMjAlM0QlMjBzaHVmZmxlZF9kYXRhc2V0LnRha2UoMTAwMCk=",highlighted:`<span class="hljs-comment"># Skip the first 1,000 examples and include the rest in the training set</span>
train_dataset = shuffled_dataset.skip(<span class="hljs-number">1000</span>)
<span class="hljs-comment"># Take the first 1,000 examples for the validation set</span>
validation_dataset = shuffled_dataset.take(<span class="hljs-number">1000</span>)`,wrap:!1}}),je=new u({props:{code:"bGF3X2RhdGFzZXRfc3RyZWFtZWQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIyanNvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfZmlsZXMlM0QlMjJodHRwcyUzQSUyRiUyRmJhdGJvdC5haSUyRmRhdGFzZXRzJTJGRWxldXRoZXJBSV9UaGVQaWxlX3YxJTJGcGlsZV9wcmVsaW1pbmFyeV9jb21wb25lbnRzJTJGRnJlZUxhd19PcGluaW9ucy5qc29ubC56c3QuJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN0cmVhbWluZyUzRFRydWUlMkMlMEEpJTBBbmV4dChpdGVyKGxhd19kYXRhc2V0X3N0cmVhbWVkKSk=",highlighted:`law_dataset_streamed = load_dataset(
    <span class="hljs-string">&quot;json&quot;</span>,
    data_files=<span class="hljs-string">&quot;https://batbot.ai/datasets/EleutherAI_ThePile_v1/pile_preliminary_components/FreeLaw_Opinions.jsonl.zst.&quot;</span>,
    split=<span class="hljs-string">&quot;train&quot;</span>,
    streaming=<span class="hljs-literal">True</span>,
)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(law_dataset_streamed))`,wrap:!1}}),Ue=new u({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ2Nhc2VfSUQnJTNBJTIwJzExMDkyMS5qc29uJyUyQyUwQSUyMCUyMCdjYXNlX2p1cmlzZGljdGlvbiclM0ElMjAnc2NvdHVzLnRhci5neiclMkMlMEElMjAlMjAnZGF0ZV9jcmVhdGVkJyUzQSUyMCcyMDEwLTA0LTI4VDE3JTNBMTIlM0E0OVonJTdEJTJDJTBBJTIwJ3RleHQnJTNBJTIwJyU1Q240NjElMjBVLlMuJTIwMjM4JTIwKDE5ODMpJTVDbk9MSU0lMjBFVCUyMEFMLiU1Q252LiU1Q25XQUtJTkVLT05BJTVDbk5vLiUyMDgxLTE1ODEuJTVDblN1cHJlbWUlMjBDb3VydCUyMG9mJTIwVW5pdGVkJTIwU3RhdGVzLiU1Q25Bcmd1ZWQlMjBKYW51YXJ5JTIwMTklMkMlMjAxOTgzLiU1Q25EZWNpZGVkJTIwQXByaWwlMjAyNiUyQyUyMDE5ODMuJTVDbkNFUlRJT1JBUkklMjBUTyUyMFRIRSUyMFVOSVRFRCUyMFNUQVRFUyUyMENPVVJUJTIwT0YlMjBBUFBFQUxTJTIwRk9SJTIwVEhFJTIwTklOVEglMjBDSVJDVUlUJTVDbioyMzklMjBNaWNoYWVsJTIwQS4lMjBMaWxseSUyQyUyMEZpcnN0JTIwRGVwdXR5JTIwQXR0b3JuZXklMjBHZW5lcmFsJTIwb2YlMjBIYXdhaWklMkMlMjBhcmd1ZWQlMjB0aGUlMjBjYXVzZSUyMGZvciUyMHBldGl0aW9uZXJzLiUyMFdpdGglMjBoaW0lMjBvbiUyMHRoZSUyMGJyaWVmJTIwd2FzJTIwSmFtZXMlMjBILiUyMERhbm5lbmJlcmclMkMlMjBEZXB1dHklMjBBdHRvcm5leSUyMEdlbmVyYWwuLi4nJTdE",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;case_ID&#x27;</span>: <span class="hljs-string">&#x27;110921.json&#x27;</span>,
  <span class="hljs-string">&#x27;case_jurisdiction&#x27;</span>: <span class="hljs-string">&#x27;scotus.tar.gz&#x27;</span>,
  <span class="hljs-string">&#x27;date_created&#x27;</span>: <span class="hljs-string">&#x27;2010-04-28T17:12:49Z&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;\\n461 U.S. 238 (1983)\\nOLIM ET AL.\\nv.\\nWAKINEKONA\\nNo. 81-1581.\\nSupreme Court of United States.\\nArgued January 19, 1983.\\nDecided April 26, 1983.\\nCERTIORARI TO THE UNITED STATES COURT OF APPEALS FOR THE NINTH CIRCUIT\\n*239 Michael A. Lilly, First Deputy Attorney General of Hawaii, argued the cause for petitioners. With him on the brief was James H. Dannenberg, Deputy Attorney General...&#x27;</span>}`,wrap:!1}}),Ie=new u({props:{code:"ZnJvbSUyMGl0ZXJ0b29scyUyMGltcG9ydCUyMGlzbGljZSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGludGVybGVhdmVfZGF0YXNldHMlMEElMEFjb21iaW5lZF9kYXRhc2V0JTIwJTNEJTIwaW50ZXJsZWF2ZV9kYXRhc2V0cyglNUJwdWJtZWRfZGF0YXNldF9zdHJlYW1lZCUyQyUyMGxhd19kYXRhc2V0X3N0cmVhbWVkJTVEKSUwQWxpc3QoaXNsaWNlKGNvbWJpbmVkX2RhdGFzZXQlMkMlMjAyKSk=",highlighted:`<span class="hljs-keyword">from</span> itertools <span class="hljs-keyword">import</span> islice
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> interleave_datasets

combined_dataset = interleave_datasets([pubmed_dataset_streamed, law_dataset_streamed])
<span class="hljs-built_in">list</span>(islice(combined_dataset, <span class="hljs-number">2</span>))`,wrap:!1}}),$e=new u({props:{code:"JTVCJTdCJ21ldGEnJTNBJTIwJTdCJ3BtaWQnJTNBJTIwMTE0MDk1NzQlMkMlMjAnbGFuZ3VhZ2UnJTNBJTIwJ2VuZyclN0QlMkMlMEElMjAlMjAndGV4dCclM0ElMjAnRXBpZGVtaW9sb2d5JTIwb2YlMjBoeXBveGFlbWlhJTIwaW4lMjBjaGlsZHJlbiUyMHdpdGglMjBhY3V0ZSUyMGxvd2VyJTIwcmVzcGlyYXRvcnklMjBpbmZlY3Rpb24lMjAuLi4nJTdEJTJDJTBBJTIwJTdCJ21ldGEnJTNBJTIwJTdCJ2Nhc2VfSUQnJTNBJTIwJzExMDkyMS5qc29uJyUyQyUwQSUyMCUyMCUyMCdjYXNlX2p1cmlzZGljdGlvbiclM0ElMjAnc2NvdHVzLnRhci5neiclMkMlMEElMjAlMjAlMjAnZGF0ZV9jcmVhdGVkJyUzQSUyMCcyMDEwLTA0LTI4VDE3JTNBMTIlM0E0OVonJTdEJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyU1Q240NjElMjBVLlMuJTIwMjM4JTIwKDE5ODMpJTVDbk9MSU0lMjBFVCUyMEFMLiU1Q252LiU1Q25XQUtJTkVLT05BJTVDbk5vLiUyMDgxLTE1ODEuJTVDblN1cHJlbWUlMjBDb3VydCUyMG9mJTIwVW5pdGVkJTIwU3RhdGVzLiU1Q25Bcmd1ZWQlMjBKYW51YXJ5JTIwMTklMkMlMjAxOTgzLiU1Q25EZWNpZGVkJTIwQXByaWwlMjAyNiUyQyUyMDE5ODMuJTVDbkNFUlRJT1JBUkklMjBUTyUyMFRIRSUyMFVOSVRFRCUyMFNUQVRFUyUyMENPVVJUJTIwT0YlMjBBUFBFQUxTJTIwRk9SJTIwVEhFJTIwTklOVEglMjBDSVJDVUlUJTVDbioyMzklMjBNaWNoYWVsJTIwQS4lMjBMaWxseSUyQyUyMEZpcnN0JTIwRGVwdXR5JTIwQXR0b3JuZXklMjBHZW5lcmFsJTIwb2YlMjBIYXdhaWklMkMlMjBhcmd1ZWQlMjB0aGUlMjBjYXVzZSUyMGZvciUyMHBldGl0aW9uZXJzLiUyMFdpdGglMjBoaW0lMjBvbiUyMHRoZSUyMGJyaWVmJTIwd2FzJTIwSmFtZXMlMjBILiUyMERhbm5lbmJlcmclMkMlMjBEZXB1dHklMjBBdHRvcm5leSUyMEdlbmVyYWwuLi4nJTdEJTVE",highlighted:`[{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pmid&#x27;</span>: <span class="hljs-number">11409574</span>, <span class="hljs-string">&#x27;language&#x27;</span>: <span class="hljs-string">&#x27;eng&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Epidemiology of hypoxaemia in children with acute lower respiratory infection ...&#x27;</span>},
 {<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;case_ID&#x27;</span>: <span class="hljs-string">&#x27;110921.json&#x27;</span>,
   <span class="hljs-string">&#x27;case_jurisdiction&#x27;</span>: <span class="hljs-string">&#x27;scotus.tar.gz&#x27;</span>,
   <span class="hljs-string">&#x27;date_created&#x27;</span>: <span class="hljs-string">&#x27;2010-04-28T17:12:49Z&#x27;</span>},
  <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;\\n461 U.S. 238 (1983)\\nOLIM ET AL.\\nv.\\nWAKINEKONA\\nNo. 81-1581.\\nSupreme Court of United States.\\nArgued January 19, 1983.\\nDecided April 26, 1983.\\nCERTIORARI TO THE UNITED STATES COURT OF APPEALS FOR THE NINTH CIRCUIT\\n*239 Michael A. Lilly, First Deputy Attorney General of Hawaii, argued the cause for petitioners. With him on the brief was James H. Dannenberg, Deputy Attorney General...&#x27;</span>}]`,wrap:!1}}),Ge=new u({props:{code:"YmFzZV91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmJhdGJvdC5haSUyRmRhdGFzZXRzJTJGRWxldXRoZXJBSV9UaGVQaWxlX3YxJTJGcGlsZSUyRiUyMiUwQWRhdGFfZmlsZXMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJ0cmFpbiUyMiUzQSUyMCU1QmJhc2VfdXJsJTIwJTJCJTIwJTIydHJhaW4lMkYlMjIlMjAlMkIlMjBmJTIyJTdCaWR4JTNBMDJkJTdELmpzb25sLnpzdCUyMiUyMGZvciUyMGlkeCUyMGluJTIwcmFuZ2UoMzApJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIydmFsaWRhdGlvbiUyMiUzQSUyMGJhc2VfdXJsJTIwJTJCJTIwJTIydmFsLmpzb25sLnpzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnRlc3QlMjIlM0ElMjBiYXNlX3VybCUyMCUyQiUyMCUyMnRlc3QuanNvbmwuenN0JTIyJTJDJTBBJTdEJTBBcGlsZV9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmpzb24lMjIlMkMlMjBkYXRhX2ZpbGVzJTNEZGF0YV9maWxlcyUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBbmV4dChpdGVyKHBpbGVfZGF0YXNldCU1QiUyMnRyYWluJTIyJTVEKSk=",highlighted:`base_url = <span class="hljs-string">&quot;https://batbot.ai/datasets/EleutherAI_ThePile_v1/pile/&quot;</span>
data_files = {
    <span class="hljs-string">&quot;train&quot;</span>: [base_url + <span class="hljs-string">&quot;train/&quot;</span> + <span class="hljs-string">f&quot;<span class="hljs-subst">{idx:02d}</span>.jsonl.zst&quot;</span> <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">30</span>)],
    <span class="hljs-string">&quot;validation&quot;</span>: base_url + <span class="hljs-string">&quot;val.jsonl.zst&quot;</span>,
    <span class="hljs-string">&quot;test&quot;</span>: base_url + <span class="hljs-string">&quot;test.jsonl.zst&quot;</span>,
}
pile_dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=data_files, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(pile_dataset[<span class="hljs-string">&quot;train&quot;</span>]))`,wrap:!1}}),Ze=new u({props:{code:"JTdCJ21ldGEnJTNBJTIwJTdCJ3BpbGVfc2V0X25hbWUnJTNBJTIwJ1BpbGUtQ0MnJTdEJTJDJTBBJTIwJ3RleHQnJTNBJTIwJ0l0JTIwaXMlMjBkb25lJTJDJTIwYW5kJTIwc3VibWl0dGVkLiUyMFlvdSUyMGNhbiUyMHBsYXklMjAlRTIlODAlOUNTdXJ2aXZhbCUyMG9mJTIwdGhlJTIwVGFzdGllc3QlRTIlODAlOUQlMjBvbiUyMEFuZHJvaWQlMkMlMjBhbmQlMjBvbiUyMHRoZSUyMHdlYi4uLiclN0Q=",highlighted:`{<span class="hljs-string">&#x27;meta&#x27;</span>: {<span class="hljs-string">&#x27;pile_set_name&#x27;</span>: <span class="hljs-string">&#x27;Pile-CC&#x27;</span>},
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;It is done, and submitted. You can play “Survival of the Tastiest” on Android, and on the web...&#x27;</span>}`,wrap:!1}}),I=new Re({props:{$$slots:{default:[Qt]},$$scope:{ctx:w}}}),Ve=new Et({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter5/4.mdx"}}),{c(){i=M("meta"),T=l(),m=M("p"),f=l(),p($.$$.fragment),Ce=l(),p(x.$$.fragment),Ee=l(),B=M("p"),B.innerHTML=Ps,Ne=l(),G=M("p"),G.innerHTML=qs,ve=l(),p(Z.$$.fragment),_e=l(),k=M("p"),k.innerHTML=Os,ze=l(),p(V.$$.fragment),Qe=l(),W=M("p"),W.innerHTML=Ks,Fe=l(),p(R.$$.fragment),He=l(),X=M("p"),X.innerHTML=et,Ye=l(),p(C.$$.fragment),Ae=l(),p(E.$$.fragment),Se=l(),N=M("p"),N.textContent=st,De=l(),p(b.$$.fragment),Le=l(),v=M("p"),v.textContent=tt,Pe=l(),p(_.$$.fragment),qe=l(),p(z.$$.fragment),Oe=l(),Q=M("p"),Q.textContent=at,Ke=l(),p(F.$$.fragment),es=l(),H=M("p"),H.innerHTML=lt,ss=l(),p(Y.$$.fragment),ts=l(),A=M("p"),A.innerHTML=nt,as=l(),p(S.$$.fragment),ls=l(),p(D.$$.fragment),ns=l(),L=M("p"),L.innerHTML=it,is=l(),p(P.$$.fragment),ps=l(),p(q.$$.fragment),os=l(),O=M("p"),O.textContent=pt,rs=l(),p(j.$$.fragment),ds=l(),K=M("p"),K.innerHTML=ot,hs=l(),ee=M("p"),ee.innerHTML=rt,cs=l(),p(se.$$.fragment),ms=l(),p(te.$$.fragment),Ms=l(),ae=M("p"),ae.innerHTML=dt,ys=l(),p(U.$$.fragment),Js=l(),p(le.$$.fragment),us=l(),ne=M("p"),ne.innerHTML=ht,Ts=l(),p(ie.$$.fragment),fs=l(),pe=M("p"),pe.innerHTML=ct,ws=l(),p(oe.$$.fragment),bs=l(),p(re.$$.fragment),js=l(),de=M("p"),de.innerHTML=mt,Us=l(),p(he.$$.fragment),gs=l(),p(ce.$$.fragment),Is=l(),p(g.$$.fragment),$s=l(),me=M("p"),me.innerHTML=Mt,xs=l(),p(Me.$$.fragment),Bs=l(),p(ye.$$.fragment),Gs=l(),Je=M("p"),Je.innerHTML=yt,Zs=l(),p(ue.$$.fragment),ks=l(),p(Te.$$.fragment),Vs=l(),fe=M("p"),fe.innerHTML=Jt,Ws=l(),p(we.$$.fragment),Rs=l(),be=M("p"),be.innerHTML=ut,Xs=l(),p(je.$$.fragment),Cs=l(),p(Ue.$$.fragment),Es=l(),ge=M("p"),ge.innerHTML=Tt,Ns=l(),p(Ie.$$.fragment),vs=l(),p($e.$$.fragment),_s=l(),xe=M("p"),xe.innerHTML=ft,zs=l(),Be=M("p"),Be.textContent=wt,Qs=l(),p(Ge.$$.fragment),Fs=l(),p(Ze.$$.fragment),Hs=l(),p(I.$$.fragment),Ys=l(),ke=M("p"),ke.textContent=bt,As=l(),p(Ve.$$.fragment),Ss=l(),We=M("p"),this.h()},l(e){const s=Wt("svelte-u9bgzb",document.head);i=y(s,"META",{name:!0,content:!0}),s.forEach(t),T=n(e),m=y(e,"P",{}),xt(m).forEach(t),f=n(e),o($.$$.fragment,e),Ce=n(e),o(x.$$.fragment,e),Ee=n(e),B=y(e,"P",{"data-svelte-h":!0}),J(B)!=="svelte-kyt5th"&&(B.innerHTML=Ps),Ne=n(e),G=y(e,"P",{"data-svelte-h":!0}),J(G)!=="svelte-101a1li"&&(G.innerHTML=qs),ve=n(e),o(Z.$$.fragment,e),_e=n(e),k=y(e,"P",{"data-svelte-h":!0}),J(k)!=="svelte-akmr9k"&&(k.innerHTML=Os),ze=n(e),o(V.$$.fragment,e),Qe=n(e),W=y(e,"P",{"data-svelte-h":!0}),J(W)!=="svelte-131i2bo"&&(W.innerHTML=Ks),Fe=n(e),o(R.$$.fragment,e),He=n(e),X=y(e,"P",{"data-svelte-h":!0}),J(X)!=="svelte-16qj1dd"&&(X.innerHTML=et),Ye=n(e),o(C.$$.fragment,e),Ae=n(e),o(E.$$.fragment,e),Se=n(e),N=y(e,"P",{"data-svelte-h":!0}),J(N)!=="svelte-cbv5ht"&&(N.textContent=st),De=n(e),o(b.$$.fragment,e),Le=n(e),v=y(e,"P",{"data-svelte-h":!0}),J(v)!=="svelte-1w1s5mw"&&(v.textContent=tt),Pe=n(e),o(_.$$.fragment,e),qe=n(e),o(z.$$.fragment,e),Oe=n(e),Q=y(e,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-jeugzh"&&(Q.textContent=at),Ke=n(e),o(F.$$.fragment,e),es=n(e),H=y(e,"P",{"data-svelte-h":!0}),J(H)!=="svelte-1ym3qey"&&(H.innerHTML=lt),ss=n(e),o(Y.$$.fragment,e),ts=n(e),A=y(e,"P",{"data-svelte-h":!0}),J(A)!=="svelte-703q8t"&&(A.innerHTML=nt),as=n(e),o(S.$$.fragment,e),ls=n(e),o(D.$$.fragment,e),ns=n(e),L=y(e,"P",{"data-svelte-h":!0}),J(L)!=="svelte-1g80mam"&&(L.innerHTML=it),is=n(e),o(P.$$.fragment,e),ps=n(e),o(q.$$.fragment,e),os=n(e),O=y(e,"P",{"data-svelte-h":!0}),J(O)!=="svelte-e299qv"&&(O.textContent=pt),rs=n(e),o(j.$$.fragment,e),ds=n(e),K=y(e,"P",{"data-svelte-h":!0}),J(K)!=="svelte-19s0dv4"&&(K.innerHTML=ot),hs=n(e),ee=y(e,"P",{"data-svelte-h":!0}),J(ee)!=="svelte-rzk2et"&&(ee.innerHTML=rt),cs=n(e),o(se.$$.fragment,e),ms=n(e),o(te.$$.fragment,e),Ms=n(e),ae=y(e,"P",{"data-svelte-h":!0}),J(ae)!=="svelte-ozqcdp"&&(ae.innerHTML=dt),ys=n(e),o(U.$$.fragment,e),Js=n(e),o(le.$$.fragment,e),us=n(e),ne=y(e,"P",{"data-svelte-h":!0}),J(ne)!=="svelte-2xtgtq"&&(ne.innerHTML=ht),Ts=n(e),o(ie.$$.fragment,e),fs=n(e),pe=y(e,"P",{"data-svelte-h":!0}),J(pe)!=="svelte-xqykn4"&&(pe.innerHTML=ct),ws=n(e),o(oe.$$.fragment,e),bs=n(e),o(re.$$.fragment,e),js=n(e),de=y(e,"P",{"data-svelte-h":!0}),J(de)!=="svelte-vmgfpy"&&(de.innerHTML=mt),Us=n(e),o(he.$$.fragment,e),gs=n(e),o(ce.$$.fragment,e),Is=n(e),o(g.$$.fragment,e),$s=n(e),me=y(e,"P",{"data-svelte-h":!0}),J(me)!=="svelte-128fecr"&&(me.innerHTML=Mt),xs=n(e),o(Me.$$.fragment,e),Bs=n(e),o(ye.$$.fragment,e),Gs=n(e),Je=y(e,"P",{"data-svelte-h":!0}),J(Je)!=="svelte-13vs8h4"&&(Je.innerHTML=yt),Zs=n(e),o(ue.$$.fragment,e),ks=n(e),o(Te.$$.fragment,e),Vs=n(e),fe=y(e,"P",{"data-svelte-h":!0}),J(fe)!=="svelte-88ekky"&&(fe.innerHTML=Jt),Ws=n(e),o(we.$$.fragment,e),Rs=n(e),be=y(e,"P",{"data-svelte-h":!0}),J(be)!=="svelte-iuph5y"&&(be.innerHTML=ut),Xs=n(e),o(je.$$.fragment,e),Cs=n(e),o(Ue.$$.fragment,e),Es=n(e),ge=y(e,"P",{"data-svelte-h":!0}),J(ge)!=="svelte-cn8r79"&&(ge.innerHTML=Tt),Ns=n(e),o(Ie.$$.fragment,e),vs=n(e),o($e.$$.fragment,e),_s=n(e),xe=y(e,"P",{"data-svelte-h":!0}),J(xe)!=="svelte-a5vxnl"&&(xe.innerHTML=ft),zs=n(e),Be=y(e,"P",{"data-svelte-h":!0}),J(Be)!=="svelte-1j6091b"&&(Be.textContent=wt),Qs=n(e),o(Ge.$$.fragment,e),Fs=n(e),o(Ze.$$.fragment,e),Hs=n(e),o(I.$$.fragment,e),Ys=n(e),ke=y(e,"P",{"data-svelte-h":!0}),J(ke)!=="svelte-9015n6"&&(ke.textContent=bt),As=n(e),o(Ve.$$.fragment,e),Ss=n(e),We=y(e,"P",{}),xt(We).forEach(t),this.h()},h(){Bt(i,"name","hf:doc:metadata"),Bt(i,"content",Ht)},m(e,s){Rt(document.head,i),a(e,T,s),a(e,m,s),a(e,f,s),r($,e,s),a(e,Ce,s),r(x,e,s),a(e,Ee,s),a(e,B,s),a(e,Ne,s),a(e,G,s),a(e,ve,s),r(Z,e,s),a(e,_e,s),a(e,k,s),a(e,ze,s),r(V,e,s),a(e,Qe,s),a(e,W,s),a(e,Fe,s),r(R,e,s),a(e,He,s),a(e,X,s),a(e,Ye,s),r(C,e,s),a(e,Ae,s),r(E,e,s),a(e,Se,s),a(e,N,s),a(e,De,s),r(b,e,s),a(e,Le,s),a(e,v,s),a(e,Pe,s),r(_,e,s),a(e,qe,s),r(z,e,s),a(e,Oe,s),a(e,Q,s),a(e,Ke,s),r(F,e,s),a(e,es,s),a(e,H,s),a(e,ss,s),r(Y,e,s),a(e,ts,s),a(e,A,s),a(e,as,s),r(S,e,s),a(e,ls,s),r(D,e,s),a(e,ns,s),a(e,L,s),a(e,is,s),r(P,e,s),a(e,ps,s),r(q,e,s),a(e,os,s),a(e,O,s),a(e,rs,s),r(j,e,s),a(e,ds,s),a(e,K,s),a(e,hs,s),a(e,ee,s),a(e,cs,s),r(se,e,s),a(e,ms,s),r(te,e,s),a(e,Ms,s),a(e,ae,s),a(e,ys,s),r(U,e,s),a(e,Js,s),r(le,e,s),a(e,us,s),a(e,ne,s),a(e,Ts,s),r(ie,e,s),a(e,fs,s),a(e,pe,s),a(e,ws,s),r(oe,e,s),a(e,bs,s),r(re,e,s),a(e,js,s),a(e,de,s),a(e,Us,s),r(he,e,s),a(e,gs,s),r(ce,e,s),a(e,Is,s),r(g,e,s),a(e,$s,s),a(e,me,s),a(e,xs,s),r(Me,e,s),a(e,Bs,s),r(ye,e,s),a(e,Gs,s),a(e,Je,s),a(e,Zs,s),r(ue,e,s),a(e,ks,s),r(Te,e,s),a(e,Vs,s),a(e,fe,s),a(e,Ws,s),r(we,e,s),a(e,Rs,s),a(e,be,s),a(e,Xs,s),r(je,e,s),a(e,Cs,s),r(Ue,e,s),a(e,Es,s),a(e,ge,s),a(e,Ns,s),r(Ie,e,s),a(e,vs,s),r($e,e,s),a(e,_s,s),a(e,xe,s),a(e,zs,s),a(e,Be,s),a(e,Qs,s),r(Ge,e,s),a(e,Fs,s),r(Ze,e,s),a(e,Hs,s),r(I,e,s),a(e,Ys,s),a(e,ke,s),a(e,As,s),r(Ve,e,s),a(e,Ss,s),a(e,We,s),Ds=!0},p(e,[s]){const jt={};s&2&&(jt.$$scope={dirty:s,ctx:e}),b.$set(jt);const Ut={};s&2&&(Ut.$$scope={dirty:s,ctx:e}),j.$set(Ut);const gt={};s&2&&(gt.$$scope={dirty:s,ctx:e}),U.$set(gt);const It={};s&2&&(It.$$scope={dirty:s,ctx:e}),g.$set(It);const $t={};s&2&&($t.$$scope={dirty:s,ctx:e}),I.$set($t)},i(e){Ds||(d($.$$.fragment,e),d(x.$$.fragment,e),d(Z.$$.fragment,e),d(V.$$.fragment,e),d(R.$$.fragment,e),d(C.$$.fragment,e),d(E.$$.fragment,e),d(b.$$.fragment,e),d(_.$$.fragment,e),d(z.$$.fragment,e),d(F.$$.fragment,e),d(Y.$$.fragment,e),d(S.$$.fragment,e),d(D.$$.fragment,e),d(P.$$.fragment,e),d(q.$$.fragment,e),d(j.$$.fragment,e),d(se.$$.fragment,e),d(te.$$.fragment,e),d(U.$$.fragment,e),d(le.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(he.$$.fragment,e),d(ce.$$.fragment,e),d(g.$$.fragment,e),d(Me.$$.fragment,e),d(ye.$$.fragment,e),d(ue.$$.fragment,e),d(Te.$$.fragment,e),d(we.$$.fragment,e),d(je.$$.fragment,e),d(Ue.$$.fragment,e),d(Ie.$$.fragment,e),d($e.$$.fragment,e),d(Ge.$$.fragment,e),d(Ze.$$.fragment,e),d(I.$$.fragment,e),d(Ve.$$.fragment,e),Ds=!0)},o(e){h($.$$.fragment,e),h(x.$$.fragment,e),h(Z.$$.fragment,e),h(V.$$.fragment,e),h(R.$$.fragment,e),h(C.$$.fragment,e),h(E.$$.fragment,e),h(b.$$.fragment,e),h(_.$$.fragment,e),h(z.$$.fragment,e),h(F.$$.fragment,e),h(Y.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(P.$$.fragment,e),h(q.$$.fragment,e),h(j.$$.fragment,e),h(se.$$.fragment,e),h(te.$$.fragment,e),h(U.$$.fragment,e),h(le.$$.fragment,e),h(ie.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(he.$$.fragment,e),h(ce.$$.fragment,e),h(g.$$.fragment,e),h(Me.$$.fragment,e),h(ye.$$.fragment,e),h(ue.$$.fragment,e),h(Te.$$.fragment,e),h(we.$$.fragment,e),h(je.$$.fragment,e),h(Ue.$$.fragment,e),h(Ie.$$.fragment,e),h($e.$$.fragment,e),h(Ge.$$.fragment,e),h(Ze.$$.fragment,e),h(I.$$.fragment,e),h(Ve.$$.fragment,e),Ds=!1},d(e){e&&(t(T),t(m),t(f),t(Ce),t(Ee),t(B),t(Ne),t(G),t(ve),t(_e),t(k),t(ze),t(Qe),t(W),t(Fe),t(He),t(X),t(Ye),t(Ae),t(Se),t(N),t(De),t(Le),t(v),t(Pe),t(qe),t(Oe),t(Q),t(Ke),t(es),t(H),t(ss),t(ts),t(A),t(as),t(ls),t(ns),t(L),t(is),t(ps),t(os),t(O),t(rs),t(ds),t(K),t(hs),t(ee),t(cs),t(ms),t(Ms),t(ae),t(ys),t(Js),t(us),t(ne),t(Ts),t(fs),t(pe),t(ws),t(bs),t(js),t(de),t(Us),t(gs),t(Is),t($s),t(me),t(xs),t(Bs),t(Gs),t(Je),t(Zs),t(ks),t(Vs),t(fe),t(Ws),t(Rs),t(be),t(Xs),t(Cs),t(Es),t(ge),t(Ns),t(vs),t(_s),t(xe),t(zs),t(Be),t(Qs),t(Fs),t(Hs),t(Ys),t(ke),t(As),t(Ss),t(We)),t(i),c($,e),c(x,e),c(Z,e),c(V,e),c(R,e),c(C,e),c(E,e),c(b,e),c(_,e),c(z,e),c(F,e),c(Y,e),c(S,e),c(D,e),c(P,e),c(q,e),c(j,e),c(se,e),c(te,e),c(U,e),c(le,e),c(ie,e),c(oe,e),c(re,e),c(he,e),c(ce,e),c(g,e),c(Me,e),c(ye,e),c(ue,e),c(Te,e),c(we,e),c(je,e),c(Ue,e),c(Ie,e),c($e,e),c(Ge,e),c(Ze,e),c(I,e),c(Ve,e)}}}const Ht='{"title":"Big data? 🤗 Datasets to the rescue!","local":"big-data-datasets-to-the-rescue","sections":[{"title":"What is the Pile?","local":"what-is-the-pile","sections":[],"depth":2},{"title":"The magic of memory mapping","local":"the-magic-of-memory-mapping","sections":[],"depth":2},{"title":"Streaming datasets","local":"streaming-datasets","sections":[],"depth":2}],"depth":1}';function Yt(w){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kt extends kt{constructor(i){super(),Vt(this,i,Yt,Ft,Gt,{})}}export{Kt as component};
