import{s as Bs,n as As,o as ks}from"../chunks/scheduler.37c15a92.js";import{S as Gs,i as zs,g as w,s as a,r as i,A as _s,h as f,f as e,c as n,j as bs,u as p,x as fl,k as Zs,y as Ws,a as t,v as M,d as m,t as r,w as o}from"../chunks/index.2bf4358c.js";import{C as c}from"../chunks/CodeBlock.4f5fc1ad.js";import{H as y}from"../chunks/Heading.8ada512a.js";import{E as Vs}from"../chunks/EditOnGithub.9958bcdc.js";function Es(hs){let T,Jl,Tl,hl,j,Ul,J,Us="In this chapter, we’ll explore various techniques and strategies for optimizing local inference with Large Language Models. We’ll cover topics like quantization, caching, attention optimizations, and hardware utilization.",ul,h,dl,U,$l,u,us="Quantization reduces model size and memory usage by converting weights to lower precision formats.",gl,d,Il,$,Cl,g,bl,I,Zl,C,Bl,b,Al,Z,ds="Flash Attention reduces memory usage and increases speed by optimizing attention computation.",kl,B,Gl,A,zl,k,$s="Reduces memory usage for long sequences by using local attention windows.",_l,G,Wl,z,Vl,_,El,W,Xl,V,Ql,E,Yl,X,Nl,Q,Sl,Y,gs="Offload parts of the model to CPU when GPU memory is limited.",Rl,N,Fl,S,Hl,R,xl,F,vl,H,ql,x,Kl,v,Ll,q,Pl,K,Dl,L,Ol,P,ls,D,ss,O,es,ll,ts,sl,as,el,ns,tl,is,al,ps,nl,Ms,il,ms,pl,rs,Ml,os,ml,ys,rl,cs,ol,Is="<li><p><strong>Model Selection</strong></p> <ul><li>Choose appropriate model size</li> <li>Consider hardware constraints</li> <li>Balance quality and speed</li></ul></li> <li><p><strong>Memory Management</strong></p> <ul><li>Monitor memory usage</li> <li>Use appropriate quantization</li> <li>Implement caching strategies</li></ul></li> <li><p><strong>Performance Optimization</strong></p> <ul><li>Enable hardware optimizations</li> <li>Use batching when possible</li> <li>Monitor and profile performance</li></ul></li>",ws,yl,fs,cl,Cs='<li><a href="https://huggingface.co/docs/transformers/perf_train_gpu_one" rel="nofollow">Hugging Face Performance Optimization Guide</a></li> <li><a href="https://pytorch.org/docs/stable/notes/cuda.html" rel="nofollow">PyTorch Memory Management</a></li> <li><a href="https://arxiv.org/abs/2205.14135" rel="nofollow">Flash Attention Paper</a></li> <li><a href="https://huggingface.co/docs/transformers/main/en/perf_infer_gpu_one" rel="nofollow">Quantization Guide</a></li> <li><a href="https://pytorch.org/tutorials/intermediate/model_parallel_tutorial.html" rel="nofollow">Model Parallelism Tutorial</a></li>',Ts,wl,js,jl,Js;return j=new y({props:{title:"Optimizing Local Inference",local:"optimizing-local-inference",headingTag:"h1"}}),h=new y({props:{title:"Model Optimization Techniques",local:"model-optimization-techniques",headingTag:"h2"}}),U=new y({props:{title:"1. Quantization",local:"1-quantization",headingTag:"h3"}}),d=new y({props:{title:"4-bit Quantization",local:"4-bit-quantization",headingTag:"h4"}}),$=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBJTIzJTIwQ29uZmlndXJlJTIwNC1iaXQlMjBxdWFudGl6YXRpb24lMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEJTIyZmxvYXQxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMEEpJTBBJTBBJTIzJTIwTG9hZCUyMHF1YW50aXplZCUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIySHVnZ2luZ0ZhY2VUQiUyRlNtb2xMTTItMS43Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

<span class="hljs-comment"># Configure 4-bit quantization</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=<span class="hljs-string">&quot;float16&quot;</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>
)

<span class="hljs-comment"># Load quantized model</span>
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>,
    quantization_config=quantization_config,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),g=new y({props:{title:"8-bit Quantization",local:"8-bit-quantization",headingTag:"h4"}}),I=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBJTIzJTIwTG9hZCUyMG1vZGVsJTIwaW4lMjA4LWJpdCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0yLTEuN0ItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-comment"># Load model in 8-bit</span>
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),C=new y({props:{title:"2. Attention Optimizations",local:"2-attention-optimizations",headingTag:"h3"}}),b=new y({props:{title:"Flash Attention",local:"flash-attention",headingTag:"h4"}}),B=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIySHVnZ2luZ0ZhY2VUQiUyRlNtb2xMTTItMS43Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9mbGFzaF9hdHRlbnRpb25fMiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),A=new y({props:{title:"Sliding Window Attention",local:"sliding-window-attention",headingTag:"h4"}}),G=new c({props:{code:"Y29uZmlnJTIwJTNEJTIwQXV0b0NvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VUQiUyRlNtb2xMTTItMS43Qi1JbnN0cnVjdCUyMiklMEFjb25maWcuc2xpZGluZ193aW5kb3clMjAlM0QlMjA0MDk2JTIwJTIwJTIzJTIwU2V0JTIwd2luZG93JTIwc2l6ZSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0yLTEuN0ItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBjb25maWclM0Rjb25maWclMEEp",highlighted:`config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>)
config.sliding_window = <span class="hljs-number">4096</span>  <span class="hljs-comment"># Set window size</span>
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>,
    config=config
)`,wrap:!1}}),z=new y({props:{title:"Memory Management",local:"memory-management",headingTag:"h2"}}),_=new y({props:{title:"1. GPU Memory Optimization",local:"1-gpu-memory-optimization",headingTag:"h3"}}),W=new y({props:{title:"Memory Tracking",local:"memory-tracking",headingTag:"h4"}}),V=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBwcmludF9ncHVfbWVtb3J5KCklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyQWxsb2NhdGVkJTNBJTIwJTdCdG9yY2guY3VkYS5tZW1vcnlfYWxsb2NhdGVkKCklMjAlMkYlMjAxMDI0KioyJTNBLjJmJTdETUIlMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkNhY2hlZCUzQSUyMCU3QnRvcmNoLmN1ZGEubWVtb3J5X3Jlc2VydmVkKCklMjAlMkYlMjAxMDI0KioyJTNBLjJmJTdETUIlMjIpJTBBJTIwJTIwJTIwJTIwJTBBJTIzJTIwTW9uaXRvciUyMG1lbW9yeSUyMHVzYWdlJTBBcHJpbnRfZ3B1X21lbW9yeSgpJTBBdG9yY2guY3VkYS5lbXB0eV9jYWNoZSgpJTIwJTIwJTIzJTIwQ2xlYXIlMjB1bnVzZWQlMjBtZW1vcnklMEFwcmludF9ncHVfbWVtb3J5KCk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_gpu_memory</span>():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Allocated: <span class="hljs-subst">{torch.cuda.memory_allocated() / <span class="hljs-number">1024</span>**<span class="hljs-number">2</span>:<span class="hljs-number">.2</span>f}</span>MB&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Cached: <span class="hljs-subst">{torch.cuda.memory_reserved() / <span class="hljs-number">1024</span>**<span class="hljs-number">2</span>:<span class="hljs-number">.2</span>f}</span>MB&quot;</span>)
    
<span class="hljs-comment"># Monitor memory usage</span>
print_gpu_memory()
torch.cuda.empty_cache()  <span class="hljs-comment"># Clear unused memory</span>
print_gpu_memory()`,wrap:!1}}),E=new y({props:{title:"Gradient Checkpointing",local:"gradient-checkpointing",headingTag:"h4"}}),X=new c({props:{code:"bW9kZWwuZ3JhZGllbnRfY2hlY2twb2ludGluZ19lbmFibGUoKSUyMCUyMCUyMyUyMEVuYWJsZSUyMGdyYWRpZW50JTIwY2hlY2twb2ludGluZw==",highlighted:'model.gradient_checkpointing_enable()  <span class="hljs-comment"># Enable gradient checkpointing</span>',wrap:!1}}),Q=new y({props:{title:"2. CPU Offloading",local:"2-cpu-offloading",headingTag:"h3"}}),N=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBJTIzJTIwQ29uZmlndXJlJTIwQ1BVJTIwb2ZmbG9hZGluZyUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkh1Z2dpbmdGYWNlVEIlMkZTbW9sTE0yLTEuN0ItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMG9mZmxvYWRfZm9sZGVyJTNEJTIyb2ZmbG9hZCUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-comment"># Configure CPU offloading</span>
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;HuggingFaceTB/SmolLM2-1.7B-Instruct&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    offload_folder=<span class="hljs-string">&quot;offload&quot;</span>
)`,wrap:!1}}),S=new y({props:{title:"Inference Optimization",local:"inference-optimization",headingTag:"h2"}}),R=new y({props:{title:"1. Batching",local:"1-batching",headingTag:"h3"}}),F=new y({props:{title:"Static Batching",local:"static-batching",headingTag:"h4"}}),H=new c({props:{code:"ZGVmJTIwYmF0Y2hfaW5mZXJlbmNlKHByb21wdHMlMkMlMjBiYXRjaF9zaXplJTNENCklM0ElMEElMjAlMjAlMjAlMjByZXN1bHRzJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihwcm9tcHRzKSUyQyUyMGJhdGNoX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjBwcm9tcHRzJTVCaSUzQWklMjAlMkIlMjBiYXRjaF9zaXplJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGJhdGNoJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWNvZGVkJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3VsdHMuZXh0ZW5kKGRlY29kZWQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzdWx0cw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">batch_inference</span>(<span class="hljs-params">prompts, batch_size=<span class="hljs-number">4</span></span>):
    results = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(prompts), batch_size):
        batch = prompts[i:i + batch_size]
        inputs = tokenizer(batch, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
        outputs = model.generate(**inputs)
        decoded = tokenizer.batch_decode(outputs)
        results.extend(decoded)
    <span class="hljs-keyword">return</span> results`,wrap:!1}}),x=new y({props:{title:"Dynamic Batching",local:"dynamic-batching",headingTag:"h4"}}),v=new c({props:{code:"Y2xhc3MlMjBEeW5hbWljQmF0Y2hlciUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBtb2RlbCUyQyUyMHRva2VuaXplciUyQyUyMG1heF9iYXRjaF9zaXplJTNEOCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm1vZGVsJTIwJTNEJTIwbW9kZWwlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnRva2VuaXplciUyMCUzRCUyMHRva2VuaXplciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubWF4X2JhdGNoX3NpemUlMjAlM0QlMjBtYXhfYmF0Y2hfc2l6ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYucXVldWUlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBhc3luYyUyMGRlZiUyMGFkZF9yZXF1ZXN0KHNlbGYlMkMlMjBwcm9tcHQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5xdWV1ZS5hcHBlbmQocHJvbXB0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKHNlbGYucXVldWUpJTIwJTNFJTNEJTIwc2VsZi5tYXhfYmF0Y2hfc2l6ZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGF3YWl0JTIwc2VsZi5wcm9jZXNzX2JhdGNoKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBOb25l",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">DynamicBatcher</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model, tokenizer, max_batch_size=<span class="hljs-number">8</span></span>):
        self.model = model
        self.tokenizer = tokenizer
        self.max_batch_size = max_batch_size
        self.queue = []
        
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">add_request</span>(<span class="hljs-params">self, prompt</span>):
        self.queue.append(prompt)
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(self.queue) &gt;= self.max_batch_size:
            <span class="hljs-keyword">return</span> <span class="hljs-keyword">await</span> self.process_batch()
        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>`,wrap:!1}}),q=new y({props:{title:"2. Caching",local:"2-caching",headingTag:"h3"}}),K=new y({props:{title:"KV Cache Management",local:"kv-cache-management",headingTag:"h4"}}),L=new c({props:{code:"Y2xhc3MlMjBLVkNhY2hlJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMG1heF9zaXplJTNEMTAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmNhY2hlJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tYXhfc2l6ZSUyMCUzRCUyMG1heF9zaXplJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwZGVmJTIwZ2V0KHNlbGYlMkMlMjBrZXlfdG9rZW5zKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGtleSUyMCUzRCUyMHR1cGxlKGtleV90b2tlbnMudG9saXN0KCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5jYWNoZS5nZXQoa2V5KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMGRlZiUyMHB1dChzZWxmJTJDJTIwa2V5X3Rva2VucyUyQyUyMHZhbHVlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKHNlbGYuY2FjaGUpJTIwJTNFJTNEJTIwc2VsZi5tYXhfc2l6ZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2FjaGUucG9wKG5leHQoaXRlcihzZWxmLmNhY2hlKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwa2V5JTIwJTNEJTIwdHVwbGUoa2V5X3Rva2Vucy50b2xpc3QoKSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmNhY2hlJTVCa2V5JTVEJTIwJTNEJTIwdmFsdWU=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">KVCache</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, max_size=<span class="hljs-number">1000</span></span>):
        self.cache = {}
        self.max_size = max_size
        
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get</span>(<span class="hljs-params">self, key_tokens</span>):
        key = <span class="hljs-built_in">tuple</span>(key_tokens.tolist())
        <span class="hljs-keyword">return</span> self.cache.get(key)
        
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">put</span>(<span class="hljs-params">self, key_tokens, value</span>):
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(self.cache) &gt;= self.max_size:
            self.cache.pop(<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(self.cache)))
        key = <span class="hljs-built_in">tuple</span>(key_tokens.tolist())
        self.cache[key] = value`,wrap:!1}}),P=new y({props:{title:"Hardware Utilization",local:"hardware-utilization",headingTag:"h2"}}),D=new y({props:{title:"1. Multi-GPU Support",local:"1-multi-gpu-support",headingTag:"h3"}}),O=new y({props:{title:"Model Parallelism",local:"model-parallelism",headingTag:"h4"}}),ll=new c({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBkaXNwYXRjaF9tb2RlbCUwQSUwQSUyMyUyMERpc3RyaWJ1dGUlMjBtb2RlbCUyMGFjcm9zcyUyMEdQVXMlMEFtb2RlbCUyMCUzRCUyMGRpc3BhdGNoX21vZGVsKG1vZGVsJTJDJTIwZGV2aWNlX21hcCUzRCUyMmJhbGFuY2VkJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> dispatch_model

<span class="hljs-comment"># Distribute model across GPUs</span>
model = dispatch_model(model, device_map=<span class="hljs-string">&quot;balanced&quot;</span>)`,wrap:!1}}),sl=new y({props:{title:"Data Parallelism",local:"data-parallelism",headingTag:"h4"}}),el=new c({props:{code:"aW1wb3J0JTIwdG9yY2gubm4lMjBhcyUyMG5uJTBBJTBBJTIzJTIwV3JhcCUyMG1vZGVsJTIwZm9yJTIwZGF0YSUyMHBhcmFsbGVsJTIwcHJvY2Vzc2luZyUwQWlmJTIwdG9yY2guY3VkYS5kZXZpY2VfY291bnQoKSUyMCUzRSUyMDElM0ElMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5uLkRhdGFQYXJhbGxlbChtb2RlbCk=",highlighted:`<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

<span class="hljs-comment"># Wrap model for data parallel processing</span>
<span class="hljs-keyword">if</span> torch.cuda.device_count() &gt; <span class="hljs-number">1</span>:
    model = nn.DataParallel(model)`,wrap:!1}}),tl=new y({props:{title:"2. CPU Threading",local:"2-cpu-threading",headingTag:"h3"}}),al=new c({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMjMlMjBTZXQlMjBudW1iZXIlMjBvZiUyMHRocmVhZHMlMjBmb3IlMjBDUFUlMjBvcGVyYXRpb25zJTBBdG9yY2guc2V0X251bV90aHJlYWRzKDgp",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># Set number of threads for CPU operations</span>
torch.set_num_threads(<span class="hljs-number">8</span>)`,wrap:!1}}),nl=new y({props:{title:"Performance Monitoring",local:"performance-monitoring",headingTag:"h2"}}),il=new y({props:{title:"1. Latency Tracking",local:"1-latency-tracking",headingTag:"h3"}}),pl=new c({props:{code:"aW1wb3J0JTIwdGltZSUwQSUwQWNsYXNzJTIwTGF0ZW5jeVRyYWNrZXIlM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYudGltZXMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBkZWYlMjBfX2VudGVyX18oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnN0YXJ0JTIwJTNEJTIwdGltZS5wZXJmX2NvdW50ZXIoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBkZWYlMjBfX2V4aXRfXyhzZWxmJTJDJTIwKmFyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi50aW1lcy5hcHBlbmQodGltZS5wZXJmX2NvdW50ZXIoKSUyMC0lMjBzZWxmLnN0YXJ0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwZGVmJTIwYXZlcmFnZShzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHN1bShzZWxmLnRpbWVzKSUyMCUyRiUyMGxlbihzZWxmLnRpbWVzKQ==",highlighted:`<span class="hljs-keyword">import</span> time

<span class="hljs-keyword">class</span> <span class="hljs-title class_">LatencyTracker</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        self.times = []
        
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__enter__</span>(<span class="hljs-params">self</span>):
        self.start = time.perf_counter()
        <span class="hljs-keyword">return</span> self
        
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__exit__</span>(<span class="hljs-params">self, *args</span>):
        self.times.append(time.perf_counter() - self.start)
        
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">average</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(self.times) / <span class="hljs-built_in">len</span>(self.times)`,wrap:!1}}),Ml=new y({props:{title:"2. Throughput Monitoring",local:"2-throughput-monitoring",headingTag:"h3"}}),ml=new c({props:{code:"Y2xhc3MlMjBUaHJvdWdocHV0TW9uaXRvciUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjB3aW5kb3dfc2l6ZSUzRDEwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLndpbmRvd19zaXplJTIwJTNEJTIwd2luZG93X3NpemUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnRpbWVzdGFtcHMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBkZWYlMjBhZGRfcmVxdWVzdChzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYudGltZXN0YW1wcy5hcHBlbmQodGltZS50aW1lKCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc2VsZi50aW1lc3RhbXBzKSUyMCUzRSUyMHNlbGYud2luZG93X3NpemUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnRpbWVzdGFtcHMucG9wKDApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjByZXF1ZXN0c19wZXJfc2Vjb25kKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc2VsZi50aW1lc3RhbXBzKSUyMCUzQyUyMDIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGltZV9kaWZmJTIwJTNEJTIwc2VsZi50aW1lc3RhbXBzJTVCLTElNUQlMjAtJTIwc2VsZi50aW1lc3RhbXBzJTVCMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGxlbihzZWxmLnRpbWVzdGFtcHMpJTIwJTJGJTIwdGltZV9kaWZm",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">ThroughputMonitor</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, window_size=<span class="hljs-number">100</span></span>):
        self.window_size = window_size
        self.timestamps = []
        
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">add_request</span>(<span class="hljs-params">self</span>):
        self.timestamps.append(time.time())
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(self.timestamps) &gt; self.window_size:
            self.timestamps.pop(<span class="hljs-number">0</span>)
            
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">requests_per_second</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(self.timestamps) &lt; <span class="hljs-number">2</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-number">0</span>
        time_diff = self.timestamps[-<span class="hljs-number">1</span>] - self.timestamps[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">len</span>(self.timestamps) / time_diff`,wrap:!1}}),rl=new y({props:{title:"Best Practices",local:"best-practices",headingTag:"h2"}}),yl=new y({props:{title:"Resources",local:"resources",headingTag:"h2"}}),wl=new Vs({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter12/8.mdx"}}),{c(){T=w("meta"),Jl=a(),Tl=w("p"),hl=a(),i(j.$$.fragment),Ul=a(),J=w("p"),J.textContent=Us,ul=a(),i(h.$$.fragment),dl=a(),i(U.$$.fragment),$l=a(),u=w("p"),u.textContent=us,gl=a(),i(d.$$.fragment),Il=a(),i($.$$.fragment),Cl=a(),i(g.$$.fragment),bl=a(),i(I.$$.fragment),Zl=a(),i(C.$$.fragment),Bl=a(),i(b.$$.fragment),Al=a(),Z=w("p"),Z.textContent=ds,kl=a(),i(B.$$.fragment),Gl=a(),i(A.$$.fragment),zl=a(),k=w("p"),k.textContent=$s,_l=a(),i(G.$$.fragment),Wl=a(),i(z.$$.fragment),Vl=a(),i(_.$$.fragment),El=a(),i(W.$$.fragment),Xl=a(),i(V.$$.fragment),Ql=a(),i(E.$$.fragment),Yl=a(),i(X.$$.fragment),Nl=a(),i(Q.$$.fragment),Sl=a(),Y=w("p"),Y.textContent=gs,Rl=a(),i(N.$$.fragment),Fl=a(),i(S.$$.fragment),Hl=a(),i(R.$$.fragment),xl=a(),i(F.$$.fragment),vl=a(),i(H.$$.fragment),ql=a(),i(x.$$.fragment),Kl=a(),i(v.$$.fragment),Ll=a(),i(q.$$.fragment),Pl=a(),i(K.$$.fragment),Dl=a(),i(L.$$.fragment),Ol=a(),i(P.$$.fragment),ls=a(),i(D.$$.fragment),ss=a(),i(O.$$.fragment),es=a(),i(ll.$$.fragment),ts=a(),i(sl.$$.fragment),as=a(),i(el.$$.fragment),ns=a(),i(tl.$$.fragment),is=a(),i(al.$$.fragment),ps=a(),i(nl.$$.fragment),Ms=a(),i(il.$$.fragment),ms=a(),i(pl.$$.fragment),rs=a(),i(Ml.$$.fragment),os=a(),i(ml.$$.fragment),ys=a(),i(rl.$$.fragment),cs=a(),ol=w("ol"),ol.innerHTML=Is,ws=a(),i(yl.$$.fragment),fs=a(),cl=w("ul"),cl.innerHTML=Cs,Ts=a(),i(wl.$$.fragment),js=a(),jl=w("p"),this.h()},l(l){const s=_s("svelte-u9bgzb",document.head);T=f(s,"META",{name:!0,content:!0}),s.forEach(e),Jl=n(l),Tl=f(l,"P",{}),bs(Tl).forEach(e),hl=n(l),p(j.$$.fragment,l),Ul=n(l),J=f(l,"P",{"data-svelte-h":!0}),fl(J)!=="svelte-151wzky"&&(J.textContent=Us),ul=n(l),p(h.$$.fragment,l),dl=n(l),p(U.$$.fragment,l),$l=n(l),u=f(l,"P",{"data-svelte-h":!0}),fl(u)!=="svelte-1jn9yge"&&(u.textContent=us),gl=n(l),p(d.$$.fragment,l),Il=n(l),p($.$$.fragment,l),Cl=n(l),p(g.$$.fragment,l),bl=n(l),p(I.$$.fragment,l),Zl=n(l),p(C.$$.fragment,l),Bl=n(l),p(b.$$.fragment,l),Al=n(l),Z=f(l,"P",{"data-svelte-h":!0}),fl(Z)!=="svelte-12ku9we"&&(Z.textContent=ds),kl=n(l),p(B.$$.fragment,l),Gl=n(l),p(A.$$.fragment,l),zl=n(l),k=f(l,"P",{"data-svelte-h":!0}),fl(k)!=="svelte-mec3bz"&&(k.textContent=$s),_l=n(l),p(G.$$.fragment,l),Wl=n(l),p(z.$$.fragment,l),Vl=n(l),p(_.$$.fragment,l),El=n(l),p(W.$$.fragment,l),Xl=n(l),p(V.$$.fragment,l),Ql=n(l),p(E.$$.fragment,l),Yl=n(l),p(X.$$.fragment,l),Nl=n(l),p(Q.$$.fragment,l),Sl=n(l),Y=f(l,"P",{"data-svelte-h":!0}),fl(Y)!=="svelte-1h379t8"&&(Y.textContent=gs),Rl=n(l),p(N.$$.fragment,l),Fl=n(l),p(S.$$.fragment,l),Hl=n(l),p(R.$$.fragment,l),xl=n(l),p(F.$$.fragment,l),vl=n(l),p(H.$$.fragment,l),ql=n(l),p(x.$$.fragment,l),Kl=n(l),p(v.$$.fragment,l),Ll=n(l),p(q.$$.fragment,l),Pl=n(l),p(K.$$.fragment,l),Dl=n(l),p(L.$$.fragment,l),Ol=n(l),p(P.$$.fragment,l),ls=n(l),p(D.$$.fragment,l),ss=n(l),p(O.$$.fragment,l),es=n(l),p(ll.$$.fragment,l),ts=n(l),p(sl.$$.fragment,l),as=n(l),p(el.$$.fragment,l),ns=n(l),p(tl.$$.fragment,l),is=n(l),p(al.$$.fragment,l),ps=n(l),p(nl.$$.fragment,l),Ms=n(l),p(il.$$.fragment,l),ms=n(l),p(pl.$$.fragment,l),rs=n(l),p(Ml.$$.fragment,l),os=n(l),p(ml.$$.fragment,l),ys=n(l),p(rl.$$.fragment,l),cs=n(l),ol=f(l,"OL",{"data-svelte-h":!0}),fl(ol)!=="svelte-j979v4"&&(ol.innerHTML=Is),ws=n(l),p(yl.$$.fragment,l),fs=n(l),cl=f(l,"UL",{"data-svelte-h":!0}),fl(cl)!=="svelte-t58ykz"&&(cl.innerHTML=Cs),Ts=n(l),p(wl.$$.fragment,l),js=n(l),jl=f(l,"P",{}),bs(jl).forEach(e),this.h()},h(){Zs(T,"name","hf:doc:metadata"),Zs(T,"content",Xs)},m(l,s){Ws(document.head,T),t(l,Jl,s),t(l,Tl,s),t(l,hl,s),M(j,l,s),t(l,Ul,s),t(l,J,s),t(l,ul,s),M(h,l,s),t(l,dl,s),M(U,l,s),t(l,$l,s),t(l,u,s),t(l,gl,s),M(d,l,s),t(l,Il,s),M($,l,s),t(l,Cl,s),M(g,l,s),t(l,bl,s),M(I,l,s),t(l,Zl,s),M(C,l,s),t(l,Bl,s),M(b,l,s),t(l,Al,s),t(l,Z,s),t(l,kl,s),M(B,l,s),t(l,Gl,s),M(A,l,s),t(l,zl,s),t(l,k,s),t(l,_l,s),M(G,l,s),t(l,Wl,s),M(z,l,s),t(l,Vl,s),M(_,l,s),t(l,El,s),M(W,l,s),t(l,Xl,s),M(V,l,s),t(l,Ql,s),M(E,l,s),t(l,Yl,s),M(X,l,s),t(l,Nl,s),M(Q,l,s),t(l,Sl,s),t(l,Y,s),t(l,Rl,s),M(N,l,s),t(l,Fl,s),M(S,l,s),t(l,Hl,s),M(R,l,s),t(l,xl,s),M(F,l,s),t(l,vl,s),M(H,l,s),t(l,ql,s),M(x,l,s),t(l,Kl,s),M(v,l,s),t(l,Ll,s),M(q,l,s),t(l,Pl,s),M(K,l,s),t(l,Dl,s),M(L,l,s),t(l,Ol,s),M(P,l,s),t(l,ls,s),M(D,l,s),t(l,ss,s),M(O,l,s),t(l,es,s),M(ll,l,s),t(l,ts,s),M(sl,l,s),t(l,as,s),M(el,l,s),t(l,ns,s),M(tl,l,s),t(l,is,s),M(al,l,s),t(l,ps,s),M(nl,l,s),t(l,Ms,s),M(il,l,s),t(l,ms,s),M(pl,l,s),t(l,rs,s),M(Ml,l,s),t(l,os,s),M(ml,l,s),t(l,ys,s),M(rl,l,s),t(l,cs,s),t(l,ol,s),t(l,ws,s),M(yl,l,s),t(l,fs,s),t(l,cl,s),t(l,Ts,s),M(wl,l,s),t(l,js,s),t(l,jl,s),Js=!0},p:As,i(l){Js||(m(j.$$.fragment,l),m(h.$$.fragment,l),m(U.$$.fragment,l),m(d.$$.fragment,l),m($.$$.fragment,l),m(g.$$.fragment,l),m(I.$$.fragment,l),m(C.$$.fragment,l),m(b.$$.fragment,l),m(B.$$.fragment,l),m(A.$$.fragment,l),m(G.$$.fragment,l),m(z.$$.fragment,l),m(_.$$.fragment,l),m(W.$$.fragment,l),m(V.$$.fragment,l),m(E.$$.fragment,l),m(X.$$.fragment,l),m(Q.$$.fragment,l),m(N.$$.fragment,l),m(S.$$.fragment,l),m(R.$$.fragment,l),m(F.$$.fragment,l),m(H.$$.fragment,l),m(x.$$.fragment,l),m(v.$$.fragment,l),m(q.$$.fragment,l),m(K.$$.fragment,l),m(L.$$.fragment,l),m(P.$$.fragment,l),m(D.$$.fragment,l),m(O.$$.fragment,l),m(ll.$$.fragment,l),m(sl.$$.fragment,l),m(el.$$.fragment,l),m(tl.$$.fragment,l),m(al.$$.fragment,l),m(nl.$$.fragment,l),m(il.$$.fragment,l),m(pl.$$.fragment,l),m(Ml.$$.fragment,l),m(ml.$$.fragment,l),m(rl.$$.fragment,l),m(yl.$$.fragment,l),m(wl.$$.fragment,l),Js=!0)},o(l){r(j.$$.fragment,l),r(h.$$.fragment,l),r(U.$$.fragment,l),r(d.$$.fragment,l),r($.$$.fragment,l),r(g.$$.fragment,l),r(I.$$.fragment,l),r(C.$$.fragment,l),r(b.$$.fragment,l),r(B.$$.fragment,l),r(A.$$.fragment,l),r(G.$$.fragment,l),r(z.$$.fragment,l),r(_.$$.fragment,l),r(W.$$.fragment,l),r(V.$$.fragment,l),r(E.$$.fragment,l),r(X.$$.fragment,l),r(Q.$$.fragment,l),r(N.$$.fragment,l),r(S.$$.fragment,l),r(R.$$.fragment,l),r(F.$$.fragment,l),r(H.$$.fragment,l),r(x.$$.fragment,l),r(v.$$.fragment,l),r(q.$$.fragment,l),r(K.$$.fragment,l),r(L.$$.fragment,l),r(P.$$.fragment,l),r(D.$$.fragment,l),r(O.$$.fragment,l),r(ll.$$.fragment,l),r(sl.$$.fragment,l),r(el.$$.fragment,l),r(tl.$$.fragment,l),r(al.$$.fragment,l),r(nl.$$.fragment,l),r(il.$$.fragment,l),r(pl.$$.fragment,l),r(Ml.$$.fragment,l),r(ml.$$.fragment,l),r(rl.$$.fragment,l),r(yl.$$.fragment,l),r(wl.$$.fragment,l),Js=!1},d(l){l&&(e(Jl),e(Tl),e(hl),e(Ul),e(J),e(ul),e(dl),e($l),e(u),e(gl),e(Il),e(Cl),e(bl),e(Zl),e(Bl),e(Al),e(Z),e(kl),e(Gl),e(zl),e(k),e(_l),e(Wl),e(Vl),e(El),e(Xl),e(Ql),e(Yl),e(Nl),e(Sl),e(Y),e(Rl),e(Fl),e(Hl),e(xl),e(vl),e(ql),e(Kl),e(Ll),e(Pl),e(Dl),e(Ol),e(ls),e(ss),e(es),e(ts),e(as),e(ns),e(is),e(ps),e(Ms),e(ms),e(rs),e(os),e(ys),e(cs),e(ol),e(ws),e(fs),e(cl),e(Ts),e(js),e(jl)),e(T),o(j,l),o(h,l),o(U,l),o(d,l),o($,l),o(g,l),o(I,l),o(C,l),o(b,l),o(B,l),o(A,l),o(G,l),o(z,l),o(_,l),o(W,l),o(V,l),o(E,l),o(X,l),o(Q,l),o(N,l),o(S,l),o(R,l),o(F,l),o(H,l),o(x,l),o(v,l),o(q,l),o(K,l),o(L,l),o(P,l),o(D,l),o(O,l),o(ll,l),o(sl,l),o(el,l),o(tl,l),o(al,l),o(nl,l),o(il,l),o(pl,l),o(Ml,l),o(ml,l),o(rl,l),o(yl,l),o(wl,l)}}}const Xs='{"title":"Optimizing Local Inference","local":"optimizing-local-inference","sections":[{"title":"Model Optimization Techniques","local":"model-optimization-techniques","sections":[{"title":"1. Quantization","local":"1-quantization","sections":[{"title":"4-bit Quantization","local":"4-bit-quantization","sections":[],"depth":4},{"title":"8-bit Quantization","local":"8-bit-quantization","sections":[],"depth":4}],"depth":3},{"title":"2. Attention Optimizations","local":"2-attention-optimizations","sections":[{"title":"Flash Attention","local":"flash-attention","sections":[],"depth":4},{"title":"Sliding Window Attention","local":"sliding-window-attention","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Memory Management","local":"memory-management","sections":[{"title":"1. GPU Memory Optimization","local":"1-gpu-memory-optimization","sections":[{"title":"Memory Tracking","local":"memory-tracking","sections":[],"depth":4},{"title":"Gradient Checkpointing","local":"gradient-checkpointing","sections":[],"depth":4}],"depth":3},{"title":"2. CPU Offloading","local":"2-cpu-offloading","sections":[],"depth":3}],"depth":2},{"title":"Inference Optimization","local":"inference-optimization","sections":[{"title":"1. Batching","local":"1-batching","sections":[{"title":"Static Batching","local":"static-batching","sections":[],"depth":4},{"title":"Dynamic Batching","local":"dynamic-batching","sections":[],"depth":4}],"depth":3},{"title":"2. Caching","local":"2-caching","sections":[{"title":"KV Cache Management","local":"kv-cache-management","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Hardware Utilization","local":"hardware-utilization","sections":[{"title":"1. Multi-GPU Support","local":"1-multi-gpu-support","sections":[{"title":"Model Parallelism","local":"model-parallelism","sections":[],"depth":4},{"title":"Data Parallelism","local":"data-parallelism","sections":[],"depth":4}],"depth":3},{"title":"2. CPU Threading","local":"2-cpu-threading","sections":[],"depth":3}],"depth":2},{"title":"Performance Monitoring","local":"performance-monitoring","sections":[{"title":"1. Latency Tracking","local":"1-latency-tracking","sections":[],"depth":3},{"title":"2. Throughput Monitoring","local":"2-throughput-monitoring","sections":[],"depth":3}],"depth":2},{"title":"Best Practices","local":"best-practices","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Qs(hs){return ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends Gs{constructor(T){super(),zs(this,T,Qs,Es,Bs,{})}}export{Hs as component};
