import{s as Ke,n as Oe,o as sa}from"../chunks/scheduler.9991993c.js";import{S as la,i as ta,g as p,s as a,r as y,A as ea,h as M,f as t,c as n,j as De,u as m,x as i,k as Pe,y as aa,a as e,v as c,d as o,t as J,w as U}from"../chunks/index.7fc9a5e7.js";import{C as j}from"../chunks/CodeBlock.e11cba92.js";import{H as T,E as na}from"../chunks/EditOnGithub.84ab7f0e.js";function pa(Pt){let r,Ml,nl,il,d,yl,h,ml,u,Kt=`LLM 的一个常见应用场景是聊天。在聊天上下文中，不再是连续的文本字符串构成的语句（不同于标准的语言模型），
聊天模型由一条或多条消息组成的对话组成，每条消息都有一个“用户”或“助手”等 <strong>角色</strong>，还包括消息文本。`,cl,g,Ot=`与<code>Tokenizer</code>类似，不同的模型对聊天的输入格式要求也不同。这就是我们添加<strong>聊天模板</strong>作为一个功能的原因。
聊天模板是<code>Tokenizer</code>的一部分。用来把问答的对话内容转换为模型的输入<code>prompt</code>。`,ol,w,se=`让我们通过一个快速的示例来具体说明，使用<code>BlenderBot</code>模型。
BlenderBot有一个非常简单的默认模板，主要是在对话轮之间添加空格：`,Jl,I,Ul,f,le=`注意，整个聊天对话内容被压缩成了一整个字符串。如果我们使用默认设置的<code>tokenize=True</code>，那么该字符串也将被tokenized处理。
不过，为了看到更复杂的模板实际运行，让我们使用<code>mistralai/Mistral-7B-Instruct-v0.1</code>模型。`,jl,C,Tl,b,te=`可以看到，这一次tokenizer已经添加了[INST]和[/INST]来表示用户消息的开始和结束。
Mistral-instruct是有使用这些token进行训练的，但BlenderBot没有。`,rl,G,dl,x,ee=`正如您在上面的示例中所看到的，聊天模板非常容易使用。只需构建一系列带有<code>role</code>和<code>content</code>键的消息，
然后将其传递给<a href="/docs/transformers/pr_30962/zh/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>方法。
另外，在将聊天模板用作模型预测的输入时，还建议使用<code>add_generation_prompt=True</code>来添加<a href="#%E4%BB%80%E4%B9%88%E6%98%AFgeneration-prompts">generation prompt</a>。`,hl,Z,ae="这是一个准备<code>model.generate()</code>的示例，使用<code>Zephyr</code>模型：",ul,N,gl,$,ne="这将生成Zephyr期望的输入格式的字符串。它看起来像这样：",wl,Q,Il,B,pe="现在我们已经按照<code>Zephyr</code>的要求传入prompt了，我们可以使用模型来生成对用户问题的回复：",fl,k,Cl,W,Me="输出结果是：",bl,z,Gl,v,ie="啊，原来这么容易！",xl,_,Zl,V,ye='有的，<a href="/docs/transformers/pr_30962/zh/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>。这个<code>pipeline</code>的设计是为了方便使用聊天模型。让我们再试一次 Zephyr 的例子，但这次使用<code>pipeline</code>：',Nl,S,$l,R,Ql,A,me='<a href="/docs/transformers/pr_30962/zh/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>将负责处理所有的<code>tokenized</code>并调用<code>apply_chat_template</code>，一旦模型有了聊天模板，您只需要初始化pipeline并传递消息列表！',Bl,q,kl,H,ce=`您可能已经注意到<code>apply_chat_template</code>方法有一个<code>add_generation_prompt</code>参数。
这个参数告诉模板添加模型开始答复的标记。例如，考虑以下对话：`,Wl,X,zl,F,oe="这是<code>add_generation_prompt=False</code>的结果，使用ChatML模板：",vl,E,_l,Y,Je="下面这是<code>add_generation_prompt=True</code>的结果：",Vl,L,Sl,D,Ue=`这一次我们添加了模型开始答复的标记。这可以确保模型生成文本时只会给出答复，而不会做出意外的行为，比如继续用户的消息。
记住，聊天模型只是语言模型，它们被训练来继续文本，而聊天对它们来说只是一种特殊的文本！
你需要用适当的控制标记来引导它们，让它们知道自己应该做什么。`,Rl,P,je=`并非所有模型都需要生成提示。一些模型，如BlenderBot和LLaMA，在模型回复之前没有任何特殊标记。
在这些情况下，<code>add_generation_prompt</code>参数将不起作用。<code>add_generation_prompt</code>参数取决于你所使用的模板。`,Al,K,ql,O,Te=`可以！我们建议您将聊天模板应用为数据集的预处理步骤。之后，您可以像进行任何其他语言模型训练任务一样继续。
在训练时，通常应该设置<code>add_generation_prompt=False</code>，因为添加的助手标记在训练过程中并不会有帮助。
让我们看一个例子：`,Hl,ss,Xl,ls,re="结果是：",Fl,ts,El,es,de="这样，后面你可以使用<code>formatted_chat</code>列，跟标准语言建模任务中一样训练即可。",Yl,as,Ll,ns,he=`模型的聊天模板存储在<code>tokenizer.chat_template</code>属性上。如果没有设置，则将使用该模型的默认模板。
让我们来看看<code>BlenderBot</code>的模板：`,Dl,ps,Pl,Ms,ue=`这看着有点复杂。让我们添加一些换行和缩进，使其更易读。
请注意，默认情况下忽略每个块后的第一个换行以及块之前的任何前导空格，
使用Jinja的<code>trim_blocks</code>和<code>lstrip_blocks</code>标签。
这里，请注意空格的使用。我们强烈建议您仔细检查模板是否打印了多余的空格！`,Kl,is,Ol,ys,ge=`如果你之前不了解<a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja template</a>。
Jinja是一种模板语言，允许你编写简单的代码来生成文本。
在许多方面，代码和语法类似于Python。在纯Python中，这个模板看起来会像这样：`,st,ms,lt,cs,we="这里使用Jinja模板处理如下三步：",tt,os,Ie="<li>对于每条消息，如果消息是用户消息，则在其前面添加一个空格，否则不打印任何内容</li> <li>添加消息内容</li> <li>如果消息不是最后一条，请在其后添加两个空格。在最后一条消息之后，打印<code>EOS</code>。</li>",et,Js,fe=`这是一个简单的模板，它不添加任何控制tokens，也不支持<code>system</code>消息（常用于指导模型在后续对话中如何表现）。
但 Jinja 给了你很大的灵活性来做这些事情！让我们看一个 Jinja 模板，
它可以实现类似于LLaMA的prompt输入（请注意，真正的LLaMA模板包括<code>system</code>消息，请不要在实际代码中使用这个简单模板！）`,at,Us,nt,js,Ce=`这里稍微看一下，就能明白这个模板的作用：它根据每条消息的“角色”添加对应的消息。
<code>user</code>、<code>assistant</code>、<code>system</code>的消息需要分别处理，因为它们代表不同的角色输入。`,pt,Ts,Mt,rs,it,ds,be=`很简单，你只需编写一个jinja模板并设置<code>tokenizer.chat_template</code>。你也可以从一个现有模板开始，只需要简单编辑便可以！
例如，我们可以采用上面的LLaMA模板，并在助手消息中添加”[ASST]“和”[/ASST]“：`,yt,hs,mt,us,Ge=`现在，只需设置<code>tokenizer.chat_template</code>属性。下次使用<a href="/docs/transformers/pr_30962/zh/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>时，它将使用您的新模板！
此属性将保存在<code>tokenizer_config.json</code>文件中，因此您可以使用<a href="/docs/transformers/pr_30962/zh/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a>将新模板上传到 Hub，
这样每个人都可以使用你模型的模板！`,ct,gs,ot,ws,xe=`由于<a href="/docs/transformers/pr_30962/zh/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>方法是由<a href="/docs/transformers/pr_30962/zh/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>类调用，
因此一旦你设置了聊天模板，您的模型将自动与<a href="/docs/transformers/pr_30962/zh/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>兼容。`,Jt,Is,Ut,fs,Ze=`在引入聊天模板（chat_template）之前，聊天prompt是在模型中通过硬编码处理的。为了向前兼容，我们保留了这种硬编码处理聊天prompt的方法。
如果一个模型没有设置聊天模板，但其模型有默认模板，<code>TextGenerationPipeline</code>类和<code>apply_chat_template</code>等方法将使用该模型的聊天模板。
您可以通过检查<code>tokenizer.default_chat_template</code>属性来查找<code>tokenizer</code>的默认模板。`,jt,Cs,Ne=`这是我们纯粹为了向前兼容性而做的事情，以避免破坏任何现有的工作流程。即使默认的聊天模板适用于您的模型，
我们强烈建议通过显式设置<code>chat_template</code>属性来覆盖默认模板，以便向用户清楚地表明您的模型已经正确的配置了聊天模板，
并且为了未来防范默认模板被修改或弃用的情况。`,Tt,bs,rt,Gs,$e=`在为已经训练过的聊天模型设置模板时，您应确保模板与模型在训练期间看到的消息格式完全匹配，否则可能会导致性能下降。
即使您继续对模型进行训练，也应保持聊天模板不变，这样可能会获得最佳性能。
这与<code>tokenization</code>非常类似，在推断时，你选用跟训练时一样的<code>tokenization</code>，通常会获得最佳性能。`,dt,xs,Qe=`如果您从头开始训练模型，或者在微调基础语言模型进行聊天时，您有很大的自由选择适当的模板！
LLMs足够聪明，可以学会处理许多不同的输入格式。我们为没有特定类别模板的模型提供一个默认模板，该模板遵循
<code>ChatML</code> format格式要求，对于许多用例来说，
这是一个很好的、灵活的选择。`,ht,Zs,Be="默认模板看起来像这样：",ut,Ns,gt,$s,ke=`如果您喜欢这个模板，下面是一行代码的模板形式，它可以直接复制到您的代码中。这一行代码还包括了[generation prompts](#什么是”generation prompts”?)，
但请注意它不会添加<code>BOS</code>或<code>EOS</code>token。
如果您的模型需要这些token，它们不会被<code>apply_chat_template</code>自动添加，换句话说，文本的默认处理参数是<code>add_special_tokens=False</code>。
这是为了避免模板和<code>add_special_tokens</code>逻辑产生冲突，如果您的模型需要特殊tokens，请确保将它们添加到模板中！`,wt,Qs,It,Bs,We="该模板将每条消息包装在<code>&lt;|im_start|&gt;</code>和<code>&lt;|im_end|&gt;</code>tokens里面，并将角色简单地写为字符串，这样可以灵活地训练角色。输出如下：",ft,ks,Ct,Ws,ze=`<code>user</code>，<code>system</code>和<code>assistant</code>是对话助手模型的标准角色，如果您的模型要与<a href="/docs/transformers/pr_30962/zh/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>兼容，我们建议你使用这些角色。
但您可以不局限于这些角色，模板非常灵活，任何字符串都可以成为角色。`,bt,zs,Gt,vs,ve=`如果您有任何聊天模型，您应该设置它们的<code>tokenizer.chat_template</code>属性，并使用<a href="/docs/transformers/pr_30962/zh/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>测试，
然后将更新后的<code>tokenizer</code>推送到 Hub。
即使您不是模型所有者，如果您正在使用一个空的聊天模板或者仍在使用默认的聊天模板，
请发起一个<a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a>，以便正确设置该属性！`,xt,_s,_e=`一旦属性设置完成，就完成了！<code>tokenizer.apply_chat_template</code>现在将在该模型中正常工作，
这意味着它也会自动支持在诸如<code>TextGenerationPipeline</code>的地方！`,Zt,Vs,Ve=`通过确保模型具有这一属性，我们可以确保整个社区都能充分利用开源模型的全部功能。
格式不匹配已经困扰这个领域并悄悄地损害了性能太久了，是时候结束它们了！`,Nt,Ss,$t,Rs,Se="如果你对Jinja不熟悉，我们通常发现编写聊天模板的最简单方法是先编写一个简短的Python脚本，按照你想要的方式格式化消息，然后将该脚本转换为模板。",Qt,As,Re=`请记住，模板处理程序将接收对话历史作为名为<code>messages</code>的变量。每条<code>message</code>都是一个带有两个键<code>role</code>和<code>content</code>的字典。
您可以在模板中像在Python中一样访问<code>messages</code>，这意味着您可以使用<code>{% for message in messages %}</code>进行循环，
或者例如使用<code>{{ messages[0] }}</code>访问单个消息。`,Bt,qs,Ae="您也可以使用以下提示将您的代码转换为Jinja：",kt,Hs,Wt,Xs,qe="在Jinja中，for循环看起来像这样：",zt,Fs,vt,Es,He="请注意，<code>{{ expression block }}</code>中的内容将被打印到输出。您可以在表达式块中使用像<code>+</code>这样的运算符来组合字符串。",_t,Ys,Vt,Ls,Xe="Jinja中的if语句如下所示：",St,Ds,Rt,Ps,Fe="注意Jinja使用<code>{% endfor %}</code>和<code>{% endif %}</code>来表示<code>for</code>和<code>if</code>的结束。",At,Ks,qt,Os,Ee=`在您的模板中，您将可以访问<code>messages</code>列表，但您还可以访问其他几个特殊变量。
这些包括特殊<code>token</code>，如<code>bos_token</code>和<code>eos_token</code>，以及我们上面讨论过的<code>add_generation_prompt</code>变量。
您还可以使用<code>loop</code>变量来访问有关当前循环迭代的信息，例如使用<code>{% if loop.last %}</code>来检查当前消息是否是对话中的最后一条消息。`,Ht,sl,Ye="以下是一个示例，如果<code>add_generation_prompt=True</code>需要在对话结束时添加<code>generate_prompt</code>：",Xt,ll,Ft,tl,Et,el,Le=`我们已经尽可能尝试让Jinja忽略除<code>{{ expressions }}</code>之外的空格。
然而，请注意Jinja是一个通用的模板引擎，它可能会将同一行文本块之间的空格视为重要，并将其打印到输出中。
我们<strong>强烈</strong>建议在上传模板之前检查一下，确保模板没有在不应该的地方打印额外的空格！`,Yt,al,Lt,pl,Dt;return d=new T({props:{title:"聊天模型的模板",local:"聊天模型的模板",headingTag:"h1"}}),h=new T({props:{title:"介绍",local:"介绍",headingTag:"h2"}}),I=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQWNoYXQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVEJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdCUyQyUyMHRva2VuaXplJTNERmFsc2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot; Hello, how are you?  I&#x27;m doing great. How can I help you today?   I&#x27;d like to show off how chat templating works!&lt;/s&gt;&quot;</span>`,wrap:!1}}),C=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjElMjIpJTBBJTBBY2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ20lMjBkb2luZyUyMGdyZWF0LiUyMEhvdyUyMGNhbiUyMEklMjBoZWxwJTIweW91JTIwdG9kYXklM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ2QlMjBsaWtlJTIwdG8lMjBzaG93JTIwb2ZmJTIwaG93JTIwY2hhdCUyMHRlbXBsYXRpbmclMjB3b3JrcyElMjIlN0QlMkMlMEElNUQlMEElMEF0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST]I&#x27;m doing great. How can I help you today?&lt;/s&gt; [INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),G=new T({props:{title:"我如何使用聊天模板？",local:"我如何使用聊天模板",headingTag:"h2"}}),N=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTIwJTIwJTIzJTIwWW91JTIwbWF5JTIwd2FudCUyMHRvJTIwdXNlJTIwYmZsb2F0MTYlMjBhbmQlMkZvciUyMG1vdmUlMjB0byUyMEdQVSUyMGhlcmUlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSUyMCU1RCUwQXRva2VuaXplZF9jaGF0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHRva2VuaXplZF9jaGF0JTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint)  <span class="hljs-comment"># You may want to use bfloat16 and/or move to GPU here</span>

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
 ]
tokenized_chat = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(tokenized_chat[<span class="hljs-number">0</span>]))`,wrap:!1}}),Q=new j({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRQ==",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;`,wrap:!1}}),k=new j({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHRva2VuaXplZF9jaGF0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTIwJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`outputs = model.generate(tokenized_chat, max_new_tokens=<span class="hljs-number">128</span>) 
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),z=new j({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQU1hdGV5JTJDJTIwSSdtJTIwYWZyYWlkJTIwSSUyMG11c3QlMjBpbmZvcm0lMjB5ZSUyMHRoYXQlMjBodW1hbnMlMjBjYW5ub3QlMjBlYXQlMjBoZWxpY29wdGVycy4lMjBIZWxpY29wdGVycyUyMGFyZSUyMG5vdCUyMGZvb2QlMkMlMjB0aGV5JTIwYXJlJTIwZmx5aW5nJTIwbWFjaGluZXMuJTIwRm9vZCUyMGlzJTIwbWVhbnQlMjB0byUyMGJlJTIwZWF0ZW4lMkMlMjBsaWtlJTIwYSUyMGhlYXJ0eSUyMHBsYXRlJTIwbyclMjBncm9nJTJDJTIwYSUyMHNhdm9yeSUyMGJvd2wlMjBvJyUyMHN0ZXclMkMlMjBvciUyMGElMjBkZWxpY2lvdXMlMjBsb2FmJTIwbyclMjBicmVhZC4lMjBCdXQlMjBoZWxpY29wdGVycyUyQyUyMHRoZXklMjBiZSUyMGZvciUyMHRyYW5zcG9ydGluJyUyMGFuZCUyMG1vdmluJyUyMGFyb3VuZCUyQyUyMG5vdCUyMGZvciUyMGVhdGluJy4lMjBTbyUyQyUyMEknZCUyMHNheSUyMG5vbmUlMkMlMjBtZSUyMGhlYXJ0aWVzLiUyME5vbmUlMjBhdCUyMGFsbC4=",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;
Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.`,wrap:!1}}),_=new T({props:{title:"有自动化的聊天 pipeline 吗？",local:"有自动化的聊天-pipeline-吗",headingTag:"h2"}}),S=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiklMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSU1RCUwQXByaW50KHBpcGUobWVzc2FnZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1NiklNUInZ2VuZXJhdGVkX3RleHQnJTVEJTVCLTElNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
]
<span class="hljs-built_in">print</span>(pipe(messages, max_new_tokens=<span class="hljs-number">256</span>)[<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>])`,wrap:!1}}),R=new j({props:{code:"JTdCJ3JvbGUnJTNBJTIwJ2Fzc2lzdGFudCclMkMlMjAnY29udGVudCclM0ElMjAlMjJNYXRleSUyQyUyMEknbSUyMGFmcmFpZCUyMEklMjBtdXN0JTIwaW5mb3JtJTIweWUlMjB0aGF0JTIwaHVtYW5zJTIwY2Fubm90JTIwZWF0JTIwaGVsaWNvcHRlcnMuJTIwSGVsaWNvcHRlcnMlMjBhcmUlMjBub3QlMjBmb29kJTJDJTIwdGhleSUyMGFyZSUyMGZseWluZyUyMG1hY2hpbmVzLiUyMEZvb2QlMjBpcyUyMG1lYW50JTIwdG8lMjBiZSUyMGVhdGVuJTJDJTIwbGlrZSUyMGElMjBoZWFydHklMjBwbGF0ZSUyMG8nJTIwZ3JvZyUyQyUyMGElMjBzYXZvcnklMjBib3dsJTIwbyclMjBzdGV3JTJDJTIwb3IlMjBhJTIwZGVsaWNpb3VzJTIwbG9hZiUyMG8nJTIwYnJlYWQuJTIwQnV0JTIwaGVsaWNvcHRlcnMlMkMlMjB0aGV5JTIwYmUlMjBmb3IlMjB0cmFuc3BvcnRpbiclMjBhbmQlMjBtb3ZpbiclMjBhcm91bmQlMkMlMjBub3QlMjBmb3IlMjBlYXRpbicuJTIwU28lMkMlMjBJJ2QlMjBzYXklMjBub25lJTJDJTIwbWUlMjBoZWFydGllcy4lMjBOb25lJTIwYXQlMjBhbGwuJTIyJTdE",highlighted:"{&#x27;role&#x27;: &#x27;assistant&#x27;, &#x27;content&#x27;: &quot;Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.&quot;}",wrap:!1}}),q=new T({props:{title:"什么是”generation prompts”?",local:"什么是generation-prompts",headingTag:"h2"}}),X=new j({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),E=new j({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),L=new j({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),K=new T({props:{title:"我可以在训练中使用聊天模板吗？",local:"我可以在训练中使用聊天模板吗",headingTag:"h2"}}),ss=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQSUwQWNoYXQxJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMHRoZSUyMG1vb24lMjBvciUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwc3VuLiUyMiU3RCUwQSU1RCUwQWNoYXQyJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMGElMjB2aXJ1cyUyMG9yJTIwYSUyMGJhY3Rlcml1bSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQSUyMGJhY3Rlcml1bS4lMjIlN0QlMEElNUQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyY2hhdCUyMiUzQSUyMCU1QmNoYXQxJTJDJTIwY2hhdDIlNUQlN0QpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjAlN0IlMjJmb3JtYXR0ZWRfY2hhdCUyMiUzQSUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKHglNUIlMjJjaGF0JTIyJTVEJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzREZhbHNlKSU3RCklMEFwcmludChkYXRhc2V0JTVCJ2Zvcm1hdHRlZF9jaGF0JyU1RCU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)

chat1 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, the moon or the sun?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The sun.&quot;</span>}
]
chat2 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, a virus or a bacterium?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A bacterium.&quot;</span>}
]

dataset = Dataset.from_dict({<span class="hljs-string">&quot;chat&quot;</span>: [chat1, chat2]})
dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;formatted_chat&quot;</span>: tokenizer.apply_chat_template(x[<span class="hljs-string">&quot;chat&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)})
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-string">&#x27;formatted_chat&#x27;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),ts=new j({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQVdoaWNoJTIwaXMlMjBiaWdnZXIlMkMlMjB0aGUlMjBtb29uJTIwb3IlMjB0aGUlMjBzdW4lM0YlM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBVGhlJTIwc3VuLiUzQyUyRnMlM0U=",highlighted:`&lt;|user|&gt;
Which is bigger, the moon or the sun?&lt;/s&gt;
&lt;|assistant|&gt;
The sun.&lt;/s&gt;`,wrap:!1}}),as=new T({props:{title:"高级：聊天模板是如何工作的？",local:"高级聊天模板是如何工作的",headingTag:"h2"}}),ps=new j({props:{code:"JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQXRva2VuaXplci5jaGF0X3RlbXBsYXRl",highlighted:`
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.chat_template
<span class="hljs-string">&quot;{% for message in messages %}{% if message[&#x27;role&#x27;] == &#x27;user&#x27; %}{{ &#x27; &#x27; }}{% endif %}{{ message[&#x27;content&#x27;] }}{% if not loop.last %}{{ &#x27;  &#x27; }}{% endif %}{% endfor %}{{ eos_token }}&quot;</span>`,wrap:!1}}),is=new j({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGlmJTIwbm90JTIwbG9vcC5sYXN0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUyMCUyMCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiU3QiUyMGVvc190b2tlbiUyMCU3RCU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not loop.last <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;  &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ eos_token }}</span>`,wrap:!1}}),ms=new j({props:{code:"Zm9yJTIwaWR4JTJDJTIwbWVzc2FnZSUyMGluJTIwZW51bWVyYXRlKG1lc3NhZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCclMjAnKSUwQSUyMCUyMCUyMCUyMHByaW50KG1lc3NhZ2UlNUInY29udGVudCclNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpZHglMjAlM0QlM0QlMjBsZW4obWVzc2FnZXMpJTIwLSUyMDElM0ElMjAlMjAlMjMlMjBDaGVjayUyMGZvciUyMHRoZSUyMGxhc3QlMjBtZXNzYWdlJTIwaW4lMjB0aGUlMjBjb252ZXJzYXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCgnJTIwJTIwJyklMEFwcmludChlb3NfdG9rZW4p",highlighted:`<span class="hljs-keyword">for</span> idx, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
    <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27; &#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> idx == <span class="hljs-built_in">len</span>(messages) - <span class="hljs-number">1</span>:  <span class="hljs-comment"># Check for the last message in the conversation</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;  &#x27;</span>)
<span class="hljs-built_in">print</span>(eos_token)`,wrap:!1}}),Us=new j({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1JTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3QiUyMCclM0MlM0NTWVMlM0UlM0UlNUMlNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Ts=new T({props:{title:"高级：编辑聊天模板",local:"高级编辑聊天模板",headingTag:"h2"}}),rs=new T({props:{title:"如何创建聊天模板？",local:"如何创建聊天模板",headingTag:"h3"}}),hs=new j({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdzeXN0ZW0nJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RC5zdHJpcCgpJTIwJTJCJTIwJyU1QyU1Q24lM0MlM0MlMkZTWVMlM0UlM0UlNUMlNUNuJTVDJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyU1QkFTU1QlNUQlMjAnJTIwJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclMjAlNUIlMkZBU1NUJTVEJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),gs=new j({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),Is=new T({props:{title:"“默认”模板是什么？",local:"默认模板是什么",headingTag:"h3"}}),bs=new T({props:{title:"我应该使用哪个模板？",local:"我应该使用哪个模板",headingTag:"h3"}}),Ns=new j({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0InJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Qs=new j({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTIy",highlighted:'<span class="language-xml">tokenizer.chat_template = &quot;</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not add_generation_prompt is defined <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">set</span> add_generation_prompt = false <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> add_generation_prompt <span class="hljs-template-tag">%}</span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;|im_start|&gt;assistant\\n&#x27;</span> }}</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">&quot;</span>',wrap:!1}}),ks=new j({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;system
You are a helpful chatbot that will do its best not to say anything so stupid that people tweet about it.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
How are you?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
I&#x27;m doing great!&lt;|im_end|&gt;`,wrap:!1}}),zs=new T({props:{title:"如何添加聊天模板？",local:"如何添加聊天模板",headingTag:"h3"}}),Ss=new T({props:{title:"高级：模板写作技巧",local:"高级模板写作技巧",headingTag:"h2"}}),Hs=new T({props:{title:"For循环",local:"for循环",headingTag:"h3"}}),Fs=new j({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElN0IlN0IlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[&#x27;content&#x27;] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),Ys=new T({props:{title:"If语句",local:"if语句",headingTag:"h3"}}),Ds=new j({props:{code:"JTdCJTI1JTIwaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ3VzZXInJTIwJTI1JTdEJTBBJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSU3QiUyNSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Ks=new T({props:{title:"特殊变量",local:"特殊变量",headingTag:"h3"}}),ll=new j({props:{code:"JTdCJTI1JTIwaWYlMjBsb29wLmxhc3QlMjBhbmQlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlMEElN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnQXNzaXN0YW50JTNBJTVDbiclMjAlN0QlN0QlMEElN0IlMjUlMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">if</span></span> loop.last and add_generation_prompt %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ bos_token + &#x27;Assistant:\\n&#x27; }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span>`,wrap:!1}}),tl=new T({props:{title:"空格的注意事项",local:"空格的注意事项",headingTag:"h3"}}),al=new na({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/zh/chat_templating.md"}}),{c(){r=p("meta"),Ml=a(),nl=p("p"),il=a(),y(d.$$.fragment),yl=a(),y(h.$$.fragment),ml=a(),u=p("p"),u.innerHTML=Kt,cl=a(),g=p("p"),g.innerHTML=Ot,ol=a(),w=p("p"),w.innerHTML=se,Jl=a(),y(I.$$.fragment),Ul=a(),f=p("p"),f.innerHTML=le,jl=a(),y(C.$$.fragment),Tl=a(),b=p("p"),b.textContent=te,rl=a(),y(G.$$.fragment),dl=a(),x=p("p"),x.innerHTML=ee,hl=a(),Z=p("p"),Z.innerHTML=ae,ul=a(),y(N.$$.fragment),gl=a(),$=p("p"),$.textContent=ne,wl=a(),y(Q.$$.fragment),Il=a(),B=p("p"),B.innerHTML=pe,fl=a(),y(k.$$.fragment),Cl=a(),W=p("p"),W.textContent=Me,bl=a(),y(z.$$.fragment),Gl=a(),v=p("p"),v.textContent=ie,xl=a(),y(_.$$.fragment),Zl=a(),V=p("p"),V.innerHTML=ye,Nl=a(),y(S.$$.fragment),$l=a(),y(R.$$.fragment),Ql=a(),A=p("p"),A.innerHTML=me,Bl=a(),y(q.$$.fragment),kl=a(),H=p("p"),H.innerHTML=ce,Wl=a(),y(X.$$.fragment),zl=a(),F=p("p"),F.innerHTML=oe,vl=a(),y(E.$$.fragment),_l=a(),Y=p("p"),Y.innerHTML=Je,Vl=a(),y(L.$$.fragment),Sl=a(),D=p("p"),D.textContent=Ue,Rl=a(),P=p("p"),P.innerHTML=je,Al=a(),y(K.$$.fragment),ql=a(),O=p("p"),O.innerHTML=Te,Hl=a(),y(ss.$$.fragment),Xl=a(),ls=p("p"),ls.textContent=re,Fl=a(),y(ts.$$.fragment),El=a(),es=p("p"),es.innerHTML=de,Yl=a(),y(as.$$.fragment),Ll=a(),ns=p("p"),ns.innerHTML=he,Dl=a(),y(ps.$$.fragment),Pl=a(),Ms=p("p"),Ms.innerHTML=ue,Kl=a(),y(is.$$.fragment),Ol=a(),ys=p("p"),ys.innerHTML=ge,st=a(),y(ms.$$.fragment),lt=a(),cs=p("p"),cs.textContent=we,tt=a(),os=p("ol"),os.innerHTML=Ie,et=a(),Js=p("p"),Js.innerHTML=fe,at=a(),y(Us.$$.fragment),nt=a(),js=p("p"),js.innerHTML=Ce,pt=a(),y(Ts.$$.fragment),Mt=a(),y(rs.$$.fragment),it=a(),ds=p("p"),ds.innerHTML=be,yt=a(),y(hs.$$.fragment),mt=a(),us=p("p"),us.innerHTML=Ge,ct=a(),y(gs.$$.fragment),ot=a(),ws=p("p"),ws.innerHTML=xe,Jt=a(),y(Is.$$.fragment),Ut=a(),fs=p("p"),fs.innerHTML=Ze,jt=a(),Cs=p("p"),Cs.innerHTML=Ne,Tt=a(),y(bs.$$.fragment),rt=a(),Gs=p("p"),Gs.innerHTML=$e,dt=a(),xs=p("p"),xs.innerHTML=Qe,ht=a(),Zs=p("p"),Zs.textContent=Be,ut=a(),y(Ns.$$.fragment),gt=a(),$s=p("p"),$s.innerHTML=ke,wt=a(),y(Qs.$$.fragment),It=a(),Bs=p("p"),Bs.innerHTML=We,ft=a(),y(ks.$$.fragment),Ct=a(),Ws=p("p"),Ws.innerHTML=ze,bt=a(),y(zs.$$.fragment),Gt=a(),vs=p("p"),vs.innerHTML=ve,xt=a(),_s=p("p"),_s.innerHTML=_e,Zt=a(),Vs=p("p"),Vs.textContent=Ve,Nt=a(),y(Ss.$$.fragment),$t=a(),Rs=p("p"),Rs.textContent=Se,Qt=a(),As=p("p"),As.innerHTML=Re,Bt=a(),qs=p("p"),qs.textContent=Ae,kt=a(),y(Hs.$$.fragment),Wt=a(),Xs=p("p"),Xs.textContent=qe,zt=a(),y(Fs.$$.fragment),vt=a(),Es=p("p"),Es.innerHTML=He,_t=a(),y(Ys.$$.fragment),Vt=a(),Ls=p("p"),Ls.textContent=Xe,St=a(),y(Ds.$$.fragment),Rt=a(),Ps=p("p"),Ps.innerHTML=Fe,At=a(),y(Ks.$$.fragment),qt=a(),Os=p("p"),Os.innerHTML=Ee,Ht=a(),sl=p("p"),sl.innerHTML=Ye,Xt=a(),y(ll.$$.fragment),Ft=a(),y(tl.$$.fragment),Et=a(),el=p("p"),el.innerHTML=Le,Yt=a(),y(al.$$.fragment),Lt=a(),pl=p("p"),this.h()},l(s){const l=ea("svelte-u9bgzb",document.head);r=M(l,"META",{name:!0,content:!0}),l.forEach(t),Ml=n(s),nl=M(s,"P",{}),De(nl).forEach(t),il=n(s),m(d.$$.fragment,s),yl=n(s),m(h.$$.fragment,s),ml=n(s),u=M(s,"P",{"data-svelte-h":!0}),i(u)!=="svelte-12gr1zf"&&(u.innerHTML=Kt),cl=n(s),g=M(s,"P",{"data-svelte-h":!0}),i(g)!=="svelte-jqg83q"&&(g.innerHTML=Ot),ol=n(s),w=M(s,"P",{"data-svelte-h":!0}),i(w)!=="svelte-1hl9y7g"&&(w.innerHTML=se),Jl=n(s),m(I.$$.fragment,s),Ul=n(s),f=M(s,"P",{"data-svelte-h":!0}),i(f)!=="svelte-2gdq6c"&&(f.innerHTML=le),jl=n(s),m(C.$$.fragment,s),Tl=n(s),b=M(s,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1uu5txi"&&(b.textContent=te),rl=n(s),m(G.$$.fragment,s),dl=n(s),x=M(s,"P",{"data-svelte-h":!0}),i(x)!=="svelte-q6p6fc"&&(x.innerHTML=ee),hl=n(s),Z=M(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-18wsdqk"&&(Z.innerHTML=ae),ul=n(s),m(N.$$.fragment,s),gl=n(s),$=M(s,"P",{"data-svelte-h":!0}),i($)!=="svelte-szjh6z"&&($.textContent=ne),wl=n(s),m(Q.$$.fragment,s),Il=n(s),B=M(s,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1mnwvlc"&&(B.innerHTML=pe),fl=n(s),m(k.$$.fragment,s),Cl=n(s),W=M(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-z7s6bp"&&(W.textContent=Me),bl=n(s),m(z.$$.fragment,s),Gl=n(s),v=M(s,"P",{"data-svelte-h":!0}),i(v)!=="svelte-6li582"&&(v.textContent=ie),xl=n(s),m(_.$$.fragment,s),Zl=n(s),V=M(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-8qgomw"&&(V.innerHTML=ye),Nl=n(s),m(S.$$.fragment,s),$l=n(s),m(R.$$.fragment,s),Ql=n(s),A=M(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1udna2o"&&(A.innerHTML=me),Bl=n(s),m(q.$$.fragment,s),kl=n(s),H=M(s,"P",{"data-svelte-h":!0}),i(H)!=="svelte-iu4par"&&(H.innerHTML=ce),Wl=n(s),m(X.$$.fragment,s),zl=n(s),F=M(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-n9il4r"&&(F.innerHTML=oe),vl=n(s),m(E.$$.fragment,s),_l=n(s),Y=M(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-53qjqh"&&(Y.innerHTML=Je),Vl=n(s),m(L.$$.fragment,s),Sl=n(s),D=M(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-d7wbjj"&&(D.textContent=Ue),Rl=n(s),P=M(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1w6qwu1"&&(P.innerHTML=je),Al=n(s),m(K.$$.fragment,s),ql=n(s),O=M(s,"P",{"data-svelte-h":!0}),i(O)!=="svelte-b1lzbk"&&(O.innerHTML=Te),Hl=n(s),m(ss.$$.fragment,s),Xl=n(s),ls=M(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-1j2yk26"&&(ls.textContent=re),Fl=n(s),m(ts.$$.fragment,s),El=n(s),es=M(s,"P",{"data-svelte-h":!0}),i(es)!=="svelte-g2qoag"&&(es.innerHTML=de),Yl=n(s),m(as.$$.fragment,s),Ll=n(s),ns=M(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-faviix"&&(ns.innerHTML=he),Dl=n(s),m(ps.$$.fragment,s),Pl=n(s),Ms=M(s,"P",{"data-svelte-h":!0}),i(Ms)!=="svelte-1ur5734"&&(Ms.innerHTML=ue),Kl=n(s),m(is.$$.fragment,s),Ol=n(s),ys=M(s,"P",{"data-svelte-h":!0}),i(ys)!=="svelte-1xg0oyk"&&(ys.innerHTML=ge),st=n(s),m(ms.$$.fragment,s),lt=n(s),cs=M(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-126w0pj"&&(cs.textContent=we),tt=n(s),os=M(s,"OL",{"data-svelte-h":!0}),i(os)!=="svelte-1i1qfyx"&&(os.innerHTML=Ie),et=n(s),Js=M(s,"P",{"data-svelte-h":!0}),i(Js)!=="svelte-1f8rf5v"&&(Js.innerHTML=fe),at=n(s),m(Us.$$.fragment,s),nt=n(s),js=M(s,"P",{"data-svelte-h":!0}),i(js)!=="svelte-16pwtdq"&&(js.innerHTML=Ce),pt=n(s),m(Ts.$$.fragment,s),Mt=n(s),m(rs.$$.fragment,s),it=n(s),ds=M(s,"P",{"data-svelte-h":!0}),i(ds)!=="svelte-qjomqd"&&(ds.innerHTML=be),yt=n(s),m(hs.$$.fragment,s),mt=n(s),us=M(s,"P",{"data-svelte-h":!0}),i(us)!=="svelte-leokak"&&(us.innerHTML=Ge),ct=n(s),m(gs.$$.fragment,s),ot=n(s),ws=M(s,"P",{"data-svelte-h":!0}),i(ws)!=="svelte-b5hfjq"&&(ws.innerHTML=xe),Jt=n(s),m(Is.$$.fragment,s),Ut=n(s),fs=M(s,"P",{"data-svelte-h":!0}),i(fs)!=="svelte-p3sf7i"&&(fs.innerHTML=Ze),jt=n(s),Cs=M(s,"P",{"data-svelte-h":!0}),i(Cs)!=="svelte-uaicwn"&&(Cs.innerHTML=Ne),Tt=n(s),m(bs.$$.fragment,s),rt=n(s),Gs=M(s,"P",{"data-svelte-h":!0}),i(Gs)!=="svelte-1h7775y"&&(Gs.innerHTML=$e),dt=n(s),xs=M(s,"P",{"data-svelte-h":!0}),i(xs)!=="svelte-1ewfwsy"&&(xs.innerHTML=Qe),ht=n(s),Zs=M(s,"P",{"data-svelte-h":!0}),i(Zs)!=="svelte-1t3g01w"&&(Zs.textContent=Be),ut=n(s),m(Ns.$$.fragment,s),gt=n(s),$s=M(s,"P",{"data-svelte-h":!0}),i($s)!=="svelte-1t0o56l"&&($s.innerHTML=ke),wt=n(s),m(Qs.$$.fragment,s),It=n(s),Bs=M(s,"P",{"data-svelte-h":!0}),i(Bs)!=="svelte-11rufda"&&(Bs.innerHTML=We),ft=n(s),m(ks.$$.fragment,s),Ct=n(s),Ws=M(s,"P",{"data-svelte-h":!0}),i(Ws)!=="svelte-arkdxn"&&(Ws.innerHTML=ze),bt=n(s),m(zs.$$.fragment,s),Gt=n(s),vs=M(s,"P",{"data-svelte-h":!0}),i(vs)!=="svelte-6edzmu"&&(vs.innerHTML=ve),xt=n(s),_s=M(s,"P",{"data-svelte-h":!0}),i(_s)!=="svelte-13qjuka"&&(_s.innerHTML=_e),Zt=n(s),Vs=M(s,"P",{"data-svelte-h":!0}),i(Vs)!=="svelte-1qxn4vk"&&(Vs.textContent=Ve),Nt=n(s),m(Ss.$$.fragment,s),$t=n(s),Rs=M(s,"P",{"data-svelte-h":!0}),i(Rs)!=="svelte-t1396b"&&(Rs.textContent=Se),Qt=n(s),As=M(s,"P",{"data-svelte-h":!0}),i(As)!=="svelte-59uiu8"&&(As.innerHTML=Re),Bt=n(s),qs=M(s,"P",{"data-svelte-h":!0}),i(qs)!=="svelte-1aooy9k"&&(qs.textContent=Ae),kt=n(s),m(Hs.$$.fragment,s),Wt=n(s),Xs=M(s,"P",{"data-svelte-h":!0}),i(Xs)!=="svelte-1qr6npj"&&(Xs.textContent=qe),zt=n(s),m(Fs.$$.fragment,s),vt=n(s),Es=M(s,"P",{"data-svelte-h":!0}),i(Es)!=="svelte-1necxra"&&(Es.innerHTML=He),_t=n(s),m(Ys.$$.fragment,s),Vt=n(s),Ls=M(s,"P",{"data-svelte-h":!0}),i(Ls)!=="svelte-1ioywy7"&&(Ls.textContent=Xe),St=n(s),m(Ds.$$.fragment,s),Rt=n(s),Ps=M(s,"P",{"data-svelte-h":!0}),i(Ps)!=="svelte-6wil9x"&&(Ps.innerHTML=Fe),At=n(s),m(Ks.$$.fragment,s),qt=n(s),Os=M(s,"P",{"data-svelte-h":!0}),i(Os)!=="svelte-y2yvc0"&&(Os.innerHTML=Ee),Ht=n(s),sl=M(s,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-mdpqzu"&&(sl.innerHTML=Ye),Xt=n(s),m(ll.$$.fragment,s),Ft=n(s),m(tl.$$.fragment,s),Et=n(s),el=M(s,"P",{"data-svelte-h":!0}),i(el)!=="svelte-u83arb"&&(el.innerHTML=Le),Yt=n(s),m(al.$$.fragment,s),Lt=n(s),pl=M(s,"P",{}),De(pl).forEach(t),this.h()},h(){Pe(r,"name","hf:doc:metadata"),Pe(r,"content",Ma)},m(s,l){aa(document.head,r),e(s,Ml,l),e(s,nl,l),e(s,il,l),c(d,s,l),e(s,yl,l),c(h,s,l),e(s,ml,l),e(s,u,l),e(s,cl,l),e(s,g,l),e(s,ol,l),e(s,w,l),e(s,Jl,l),c(I,s,l),e(s,Ul,l),e(s,f,l),e(s,jl,l),c(C,s,l),e(s,Tl,l),e(s,b,l),e(s,rl,l),c(G,s,l),e(s,dl,l),e(s,x,l),e(s,hl,l),e(s,Z,l),e(s,ul,l),c(N,s,l),e(s,gl,l),e(s,$,l),e(s,wl,l),c(Q,s,l),e(s,Il,l),e(s,B,l),e(s,fl,l),c(k,s,l),e(s,Cl,l),e(s,W,l),e(s,bl,l),c(z,s,l),e(s,Gl,l),e(s,v,l),e(s,xl,l),c(_,s,l),e(s,Zl,l),e(s,V,l),e(s,Nl,l),c(S,s,l),e(s,$l,l),c(R,s,l),e(s,Ql,l),e(s,A,l),e(s,Bl,l),c(q,s,l),e(s,kl,l),e(s,H,l),e(s,Wl,l),c(X,s,l),e(s,zl,l),e(s,F,l),e(s,vl,l),c(E,s,l),e(s,_l,l),e(s,Y,l),e(s,Vl,l),c(L,s,l),e(s,Sl,l),e(s,D,l),e(s,Rl,l),e(s,P,l),e(s,Al,l),c(K,s,l),e(s,ql,l),e(s,O,l),e(s,Hl,l),c(ss,s,l),e(s,Xl,l),e(s,ls,l),e(s,Fl,l),c(ts,s,l),e(s,El,l),e(s,es,l),e(s,Yl,l),c(as,s,l),e(s,Ll,l),e(s,ns,l),e(s,Dl,l),c(ps,s,l),e(s,Pl,l),e(s,Ms,l),e(s,Kl,l),c(is,s,l),e(s,Ol,l),e(s,ys,l),e(s,st,l),c(ms,s,l),e(s,lt,l),e(s,cs,l),e(s,tt,l),e(s,os,l),e(s,et,l),e(s,Js,l),e(s,at,l),c(Us,s,l),e(s,nt,l),e(s,js,l),e(s,pt,l),c(Ts,s,l),e(s,Mt,l),c(rs,s,l),e(s,it,l),e(s,ds,l),e(s,yt,l),c(hs,s,l),e(s,mt,l),e(s,us,l),e(s,ct,l),c(gs,s,l),e(s,ot,l),e(s,ws,l),e(s,Jt,l),c(Is,s,l),e(s,Ut,l),e(s,fs,l),e(s,jt,l),e(s,Cs,l),e(s,Tt,l),c(bs,s,l),e(s,rt,l),e(s,Gs,l),e(s,dt,l),e(s,xs,l),e(s,ht,l),e(s,Zs,l),e(s,ut,l),c(Ns,s,l),e(s,gt,l),e(s,$s,l),e(s,wt,l),c(Qs,s,l),e(s,It,l),e(s,Bs,l),e(s,ft,l),c(ks,s,l),e(s,Ct,l),e(s,Ws,l),e(s,bt,l),c(zs,s,l),e(s,Gt,l),e(s,vs,l),e(s,xt,l),e(s,_s,l),e(s,Zt,l),e(s,Vs,l),e(s,Nt,l),c(Ss,s,l),e(s,$t,l),e(s,Rs,l),e(s,Qt,l),e(s,As,l),e(s,Bt,l),e(s,qs,l),e(s,kt,l),c(Hs,s,l),e(s,Wt,l),e(s,Xs,l),e(s,zt,l),c(Fs,s,l),e(s,vt,l),e(s,Es,l),e(s,_t,l),c(Ys,s,l),e(s,Vt,l),e(s,Ls,l),e(s,St,l),c(Ds,s,l),e(s,Rt,l),e(s,Ps,l),e(s,At,l),c(Ks,s,l),e(s,qt,l),e(s,Os,l),e(s,Ht,l),e(s,sl,l),e(s,Xt,l),c(ll,s,l),e(s,Ft,l),c(tl,s,l),e(s,Et,l),e(s,el,l),e(s,Yt,l),c(al,s,l),e(s,Lt,l),e(s,pl,l),Dt=!0},p:Oe,i(s){Dt||(o(d.$$.fragment,s),o(h.$$.fragment,s),o(I.$$.fragment,s),o(C.$$.fragment,s),o(G.$$.fragment,s),o(N.$$.fragment,s),o(Q.$$.fragment,s),o(k.$$.fragment,s),o(z.$$.fragment,s),o(_.$$.fragment,s),o(S.$$.fragment,s),o(R.$$.fragment,s),o(q.$$.fragment,s),o(X.$$.fragment,s),o(E.$$.fragment,s),o(L.$$.fragment,s),o(K.$$.fragment,s),o(ss.$$.fragment,s),o(ts.$$.fragment,s),o(as.$$.fragment,s),o(ps.$$.fragment,s),o(is.$$.fragment,s),o(ms.$$.fragment,s),o(Us.$$.fragment,s),o(Ts.$$.fragment,s),o(rs.$$.fragment,s),o(hs.$$.fragment,s),o(gs.$$.fragment,s),o(Is.$$.fragment,s),o(bs.$$.fragment,s),o(Ns.$$.fragment,s),o(Qs.$$.fragment,s),o(ks.$$.fragment,s),o(zs.$$.fragment,s),o(Ss.$$.fragment,s),o(Hs.$$.fragment,s),o(Fs.$$.fragment,s),o(Ys.$$.fragment,s),o(Ds.$$.fragment,s),o(Ks.$$.fragment,s),o(ll.$$.fragment,s),o(tl.$$.fragment,s),o(al.$$.fragment,s),Dt=!0)},o(s){J(d.$$.fragment,s),J(h.$$.fragment,s),J(I.$$.fragment,s),J(C.$$.fragment,s),J(G.$$.fragment,s),J(N.$$.fragment,s),J(Q.$$.fragment,s),J(k.$$.fragment,s),J(z.$$.fragment,s),J(_.$$.fragment,s),J(S.$$.fragment,s),J(R.$$.fragment,s),J(q.$$.fragment,s),J(X.$$.fragment,s),J(E.$$.fragment,s),J(L.$$.fragment,s),J(K.$$.fragment,s),J(ss.$$.fragment,s),J(ts.$$.fragment,s),J(as.$$.fragment,s),J(ps.$$.fragment,s),J(is.$$.fragment,s),J(ms.$$.fragment,s),J(Us.$$.fragment,s),J(Ts.$$.fragment,s),J(rs.$$.fragment,s),J(hs.$$.fragment,s),J(gs.$$.fragment,s),J(Is.$$.fragment,s),J(bs.$$.fragment,s),J(Ns.$$.fragment,s),J(Qs.$$.fragment,s),J(ks.$$.fragment,s),J(zs.$$.fragment,s),J(Ss.$$.fragment,s),J(Hs.$$.fragment,s),J(Fs.$$.fragment,s),J(Ys.$$.fragment,s),J(Ds.$$.fragment,s),J(Ks.$$.fragment,s),J(ll.$$.fragment,s),J(tl.$$.fragment,s),J(al.$$.fragment,s),Dt=!1},d(s){s&&(t(Ml),t(nl),t(il),t(yl),t(ml),t(u),t(cl),t(g),t(ol),t(w),t(Jl),t(Ul),t(f),t(jl),t(Tl),t(b),t(rl),t(dl),t(x),t(hl),t(Z),t(ul),t(gl),t($),t(wl),t(Il),t(B),t(fl),t(Cl),t(W),t(bl),t(Gl),t(v),t(xl),t(Zl),t(V),t(Nl),t($l),t(Ql),t(A),t(Bl),t(kl),t(H),t(Wl),t(zl),t(F),t(vl),t(_l),t(Y),t(Vl),t(Sl),t(D),t(Rl),t(P),t(Al),t(ql),t(O),t(Hl),t(Xl),t(ls),t(Fl),t(El),t(es),t(Yl),t(Ll),t(ns),t(Dl),t(Pl),t(Ms),t(Kl),t(Ol),t(ys),t(st),t(lt),t(cs),t(tt),t(os),t(et),t(Js),t(at),t(nt),t(js),t(pt),t(Mt),t(it),t(ds),t(yt),t(mt),t(us),t(ct),t(ot),t(ws),t(Jt),t(Ut),t(fs),t(jt),t(Cs),t(Tt),t(rt),t(Gs),t(dt),t(xs),t(ht),t(Zs),t(ut),t(gt),t($s),t(wt),t(It),t(Bs),t(ft),t(Ct),t(Ws),t(bt),t(Gt),t(vs),t(xt),t(_s),t(Zt),t(Vs),t(Nt),t($t),t(Rs),t(Qt),t(As),t(Bt),t(qs),t(kt),t(Wt),t(Xs),t(zt),t(vt),t(Es),t(_t),t(Vt),t(Ls),t(St),t(Rt),t(Ps),t(At),t(qt),t(Os),t(Ht),t(sl),t(Xt),t(Ft),t(Et),t(el),t(Yt),t(Lt),t(pl)),t(r),U(d,s),U(h,s),U(I,s),U(C,s),U(G,s),U(N,s),U(Q,s),U(k,s),U(z,s),U(_,s),U(S,s),U(R,s),U(q,s),U(X,s),U(E,s),U(L,s),U(K,s),U(ss,s),U(ts,s),U(as,s),U(ps,s),U(is,s),U(ms,s),U(Us,s),U(Ts,s),U(rs,s),U(hs,s),U(gs,s),U(Is,s),U(bs,s),U(Ns,s),U(Qs,s),U(ks,s),U(zs,s),U(Ss,s),U(Hs,s),U(Fs,s),U(Ys,s),U(Ds,s),U(Ks,s),U(ll,s),U(tl,s),U(al,s)}}}const Ma='{"title":"聊天模型的模板","local":"聊天模型的模板","sections":[{"title":"介绍","local":"介绍","sections":[],"depth":2},{"title":"我如何使用聊天模板？","local":"我如何使用聊天模板","sections":[],"depth":2},{"title":"有自动化的聊天 pipeline 吗？","local":"有自动化的聊天-pipeline-吗","sections":[],"depth":2},{"title":"什么是”generation prompts”?","local":"什么是generation-prompts","sections":[],"depth":2},{"title":"我可以在训练中使用聊天模板吗？","local":"我可以在训练中使用聊天模板吗","sections":[],"depth":2},{"title":"高级：聊天模板是如何工作的？","local":"高级聊天模板是如何工作的","sections":[],"depth":2},{"title":"高级：编辑聊天模板","local":"高级编辑聊天模板","sections":[{"title":"如何创建聊天模板？","local":"如何创建聊天模板","sections":[],"depth":3},{"title":"“默认”模板是什么？","local":"默认模板是什么","sections":[],"depth":3},{"title":"我应该使用哪个模板？","local":"我应该使用哪个模板","sections":[],"depth":3},{"title":"如何添加聊天模板？","local":"如何添加聊天模板","sections":[],"depth":3}],"depth":2},{"title":"高级：模板写作技巧","local":"高级模板写作技巧","sections":[{"title":"For循环","local":"for循环","sections":[],"depth":3},{"title":"If语句","local":"if语句","sections":[],"depth":3},{"title":"特殊变量","local":"特殊变量","sections":[],"depth":3},{"title":"空格的注意事项","local":"空格的注意事项","sections":[],"depth":3}],"depth":2}],"depth":1}';function ia(Pt){return sa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ja extends la{constructor(r){super(),ta(this,r,ia,pa,Ke,{})}}export{Ja as component};
