import{s as p3,o as m3,n as x}from"../chunks/scheduler.25b97de1.js";import{S as g3,i as h3,g as o,s as r,r as m,A as u3,h as l,f as n,c as a,j as T,u as g,x as b,k as M,y as t,a as p,v as h,d as u,t as f,w as _}from"../chunks/index.d9030fc9.js";import{T as Vr}from"../chunks/Tip.baa67368.js";import{D as v}from"../chunks/Docstring.ffac8efa.js";import{C as U}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Z}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as ye,E as f3}from"../chunks/EditOnGithub.91d95064.js";function _3(j){let c,$=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/en/model_doc/bark" rel="nofollow">Bark</a>’s fine submodel. See the model documentation
for examples.`;return{c(){c=o("p"),c.innerHTML=$},l(y){c=l(y,"P",{"data-svelte-h":!0}),b(c)!=="svelte-nbt45a"&&(c.innerHTML=$)},m(y,d){p(y,c,d)},p:x,d(y){y&&n(c)}}}function b3(j){let c,$=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/main/en/model_doc/musicgen" rel="nofollow">MusicGen</a>`;return{c(){c=o("p"),c.innerHTML=$},l(y){c=l(y,"P",{"data-svelte-h":!0}),b(c)!=="svelte-1uojnuk"&&(c.innerHTML=$)},m(y,d){p(y,c,d)},p:x,d(y){y&&n(c)}}}function y3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMHBvcCUyMHRyYWNrJTIwd2l0aCUyMGJhc3N5JTIwZHJ1bXMlMjBhbmQlMjBzeW50aCUyMiUyQyUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGxvdWQlMjBndWl0YXJzJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function T3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkFsaWNlJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMFdoYXQlMjBkbyUyMHlvdSUyMGxvdmUlM0YlNUNuQm9iJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwZ3JlZWR5JTIwZGVjb2RpbmclMkMlMjB3ZSUyMHNlZSUyMEJvYiUyMHJlcGVhdGluZyUyMEFsaWNlJ3MlMjBvcGluaW9uLiUyMElmJTIwQm9iJTIwd2FzJTIwYSUyMGNoYXRib3QlMkMlMjBpdCUyMHdvdWxkJTIwYmUlMjBhJTIwcG9vciUyMG9uZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhpcyUyMGxvZ2l0cyUyMHByb2Nlc3NvciUyQyUyMHdlJTIwY2FuJTIwcHJldmVudCUyMEJvYiUyMGZyb20lMjByZXBlYXRpbmclMjBBbGljZSdzJTIwb3Bpbmlvbi4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX25vX3JlcGVhdF9uZ3JhbV9zaXplJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice: I love cats. What do you love?\\nBob:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With greedy decoding, we see Bob repeating Alice&#x27;s opinion. If Bob was a chatbot, it would be a poor one.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: I love cats. What do you

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With this logits processor, we can prevent Bob from repeating Alice&#x27;s opinion.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, encoder_no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: My cats are very cute.`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function M3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkFsaWNlJTIwYW5kJTIwQm9iLiUyMFRoZSUyMHRoaXJkJTIwbWVtYmVyJ3MlMjBuYW1lJTIwd2FzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhlJTIwJTYwZW5jb2Rlcl9yZXBldGl0aW9uX3BlbmFsdHklNjAlMjBhcmd1bWVudCUyMHdlJTIwY2FuJTIwdHJpZ2dlciUyMHRoaXMlMjBsb2dpdHMlMjBwcm9jZXNzb3IlMjBpbiUyMCU2MGdlbmVyYXRlJTYwJTJDJTIwd2hpY2glMjBjYW4lMEElMjMlMjBwcm9tb3RlJTIwdGhlJTIwdXNlJTIwb2YlMjBwcm9tcHQlMjB0b2tlbnMlMjAoJTIyQm9iJTIyJTIwaW4lMjB0aGlzJTIwZXhhbXBsZSklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX3JlcGV0aXRpb25fcGVuYWx0eSUzRDEuMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob. The third member&#x27;s name was&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob. The third membe<span class="hljs-string">r&#x27;s name was not mentioned.

&gt;&gt;&gt; # With the \`encoder_repetition_penalty\` argument we can trigger this logits processor in \`generate\`, which can
&gt;&gt;&gt; # promote the use of prompt tokens (&quot;Bob&quot; in this example)
&gt;&gt;&gt; gen_out = model.generate(**inputs, encoder_repetition_penalty=1.2)
&gt;&gt;&gt; print(tokenizer.batch_decode(gen_out, skip_special_tokens=True)[0])
Alice and Bob. The third member&#x27;</span>s name was Bob. The third membe<span class="hljs-string">r&#x27;s name was Bob.</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function v3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGVwc2lsb24lMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdG8lMjBoaWdoLXByb2JhYmlsaXR5JTIwdG9rZW5zLiUyME5vdGUlMjB0aGF0JTIwdGhpcyUyMGlzJTIwc2ltaWxhciUyMHRvJTBBJTIzJTIwVG9wJTIwUCUyMHNhbXBsaW5nJTJDJTIwd2hpY2glMjByZXN0cmljdHMlMjB0b2tlbnMlMjBiYXNlZCUyMG9uJTIwdGhlaXIlMjBjdW11bGF0aXZlJTIwcHJvYmFiaWxpdHkuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGVwc2lsb25fY3V0b2ZmJTYwJTIwdmFsdWVzJTIwYmV0d2VlbiUyMDNlLTQlMjBhbmQlMjA5ZS00JTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMGVwc2lsb25fY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With epsilon sampling, the output gets restricted to high-probability tokens. Note that this is similar to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Top P sampling, which restricts tokens based on their cumulative probability.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`epsilon_cutoff\` values between 3e-4 and 9e-4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, epsilon_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function w3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMGV0YSUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwZ2V0cyUyMHJlc3RyaWN0ZWQlMjB0byUyMGhpZ2gtcHJvYmFiaWxpdHklMjB0b2tlbnMuJTIwWW91JTIwY2FuJTIwc2VlJTIwaXQlMjBhcyUyMGElMjBkeW5hbWljJTIwZm9ybSUyMG9mJTBBJTIzJTIwZXBzaWxvbiUyMHNhbXBsaW5nJTIwdGhhdCUyMGFkYXB0cyUyMGl0cyUyMGN1dG9mZiUyMHByb2JhYmlsaXR5JTIwYmFzZWQlMjBvbiUyMHRoZSUyMGVudHJvcHklMjAoaGlnaCUyMGVudHJvcHklMjAlM0QlMjBsb3dlciUyMGN1dG9mZikuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwVGhlJTIwcGFwZXIlMjByZWNvbWVuZHMlMjB1c2luZyUyMCU2MGV0YV9jdXRvZmYlNjAlMjB2YWx1ZXMlMjBiZXR3ZWVuJTIwM2UtNCUyMHRvJTIwNGUtMyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBldGFfY3V0b2ZmJTNEMC4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With eta sampling, the output gets restricted to high-probability tokens. You can see it as a dynamic form of</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># epsilon sampling that adapts its cutoff probability based on the entropy (high entropy = lower cutoff).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`eta_cutoff\` values between 3e-4 to 4e-3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, eta_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function k3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Just wanted to let you know, I&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s consider that we want short sentences, so we limit \`max_length=30\`. However, we observe that the answer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># tends to end abruptly.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.9</span>, max_length=<span class="hljs-number">30</span>, pad_token_id=<span class="hljs-number">50256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span> Although

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To promote the appearance of the EOS token at the right time, we add the \`exponential_decay_length_penalty =</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (start_index, decay_factor)\`. Instead of cutting at max_tokens, the output comes to an end before and usually</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with more meaning. What happens is that starting from \`start_index\` the EOS token score will be increased</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># by \`decay_factor\` exponentially. However, if you set a high decay factor, you may also end up with abruptly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># ending sequences.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.6</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network
which&lt;|endoftext|&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With a small decay factor, you will have a higher chance of getting a meaningful sequence.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.01</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span>&lt;|endoftext|&gt;`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function $3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUcmFuc2xhdGUlMjBmcm9tJTIwRW5nbGlzaCUyMHRvJTIwR2VybWFuJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwaXQlMjBjb250aW51ZXMlMjBnZW5lcmF0aW5nJTIwYWNjb3JkaW5nJTIwdG8lMjB0aGUlMjBtb2RlbCdzJTIwbG9naXRzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCklMEElMEElMjMlMjBXZSUyMGNhbiUyMHVzZSUyMCU2MGZvcmNlZF9ib3NfdG9rZW5faWQlNjAlMjB0byUyMGZvcmNlJTIwdGhlJTIwc3RhcnQlMjBvZiUyMGdlbmVyYXRpb24lMjB3aXRoJTIwYW4lMjBlbmNvZGVyLWRlY29kZXIlMjBtb2RlbCUwQSUyMyUyMChpbmNsdWRpbmclMjBmb3JjaW5nJTIwaXQlMjB0byUyMGVuZCUyMHN0cmFpZ2h0JTIwYXdheSUyMHdpdGglMjBhbiUyMEVPUyUyMHRva2VuKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBmb3JjZWRfYm9zX3Rva2VuX2lkJTNEdG9rZW5pemVyLmVvc190b2tlbl9pZCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Translate from English to German: I love cats.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt; Ich liebe Kitty.&lt;/s&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can use \`forced_bos_token_id\` to force the start of generation with an encoder-decoder model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (including forcing it to end straight away with an EOS token)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_bos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt;&lt;/s&gt;`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function j3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJBJTIwc2VxdWVuY2UlM0ElMjAxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEJ5JTIwZGVmYXVsdCUyQyUyMGl0JTIwY29udGludWVzJTIwZ2VuZXJhdGluZyUyMGFjY29yZGluZyUyMHRvJTIwdGhlJTIwbW9kZWwncyUyMGxvZ2l0cyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQpJTBBJTBBJTIzJTIwJTYwZm9yY2VkX2Vvc190b2tlbl9pZCU2MCUyMGVuc3VyZXMlMjB0aGUlMjBnZW5lcmF0aW9uJTIwZW5kcyUyMHdpdGglMjBhJTIwRU9TJTIwdG9rZW4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwJTJDJTIwZm9yY2VkX2Vvc190b2tlbl9pZCUzRHRva2VuaXplci5lb3NfdG9rZW5faWQpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`forced_eos_token_id\` ensures the generation ends with a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_eos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>,&lt;|endoftext|&gt;`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function x3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google-t5/t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A long text about the solar system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The Solar System is a gravitationally bound system comprising the Sun and the objects that orbit it, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;either directly or indirectly. Of the objects that orbit the Sun directly, the largest are the eight &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;planets, with the remainder being smaller objects, such as the five dwarf planets and small Solar System &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;bodies. The Solar System formed 4.6 billion years ago from the gravitational collapse of a giant &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;interstellar molecular cloud.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;summarize: &quot;</span> + text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    diversity_penalty=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summaries_diverse = tokenizer.batch_decode(outputs_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate non-diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_non_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_non_diverse = tokenizer.batch_decode(outputs_non_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`diversity_penalty\`, the resulting beams are much more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summary_non_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the Solar System formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summaries_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets. the rest of the objects are smaller objects, such as the five dwarf planets and small solar system bodies.&#x27;</span>]`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function J3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydCUyRmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTJDJTIwMyUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwdGhlJTIwc2NvcmVzJTIwYXJlJTIwbm90JTIwbm9ybWFsaXplZCUyMC0tJTIwdGhlJTIwc3VtJTIwb2YlMjB0aGVpciUyMGV4cG9uZW50aWFscyUyMGlzJTIwTk9UJTIwYSUyMG5vcm1hbGl6ZWQlMjBwcm9iYWJpbGl0eSUwQSUyMyUyMGRpc3RyaWJ1dGlvbiUyQyUyMHN1bW1pbmclMjB0byUyMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSklMEFwcmludCh0b3JjaC5hbGxjbG9zZSh0b3JjaC5zdW0odG9yY2guZXhwKG91dHB1dHMuc2NvcmVzJTVCLTElNUQpKSUyQyUyMHRvcmNoLlRlbnNvcigoMS4wMDAlMkMpKSUyQyUyMHJ0b2wlM0QxZS00KSklMEElMEElMjMlMjBOb3JtYWxpemluZyUyMHRoZW0lMjBtYXklMjBoYXZlJTIwYSUyMHBvc2l0aXZlJTIwaW1wYWN0JTIwb24lMjBiZWFtJTIwbWV0aG9kcyUyQyUyMG9yJTIwd2hlbiUyMHVzaW5nJTIwdGhlJTIwc2NvcmVzJTIwb24lMjB5b3VyJTIwYXBwbGljYXRpb24lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZW5vcm1hbGl6ZV9sb2dpdHMlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQodG9yY2guYWxsY2xvc2UodG9yY2guc3VtKHRvcmNoLmV4cChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEKSklMkMlMjB0b3JjaC5UZW5zb3IoKDEuMDAwJTJDKSklMkMlMjBydG9sJTNEMWUtNCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the scores are not normalized -- the sum of their exponentials is NOT a normalized probability</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># distribution, summing to 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.allclose(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])), torch.Tensor((<span class="hljs-number">1.000</span>,)), rtol=<span class="hljs-number">1e-4</span>))
<span class="hljs-literal">False</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Normalizing them may have a positive impact on beam methods, or when using the scores on your application</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, renormalize_logits=<span class="hljs-literal">True</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.allclose(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])), torch.Tensor((<span class="hljs-number">1.000</span>,)), rtol=<span class="hljs-number">1e-4</span>))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function U3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBudW1iZXIlM0ElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbGVuZ3RoJTYwJTIwdG8lMjBhJTIwdmFsdWUlMjBzbWFsbGVyJTIwdGhhbiUyMHRoZSUyMHVuY29udHJvbGxlZCUyMG91dHB1dCUyMGxlbmd0aCUyMGhhcyUyMG5vJTIwaW1wYWN0JTBBZ2VuX291dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX2xlbmd0aCUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBzZXR0aW5nJTIwYSUyMGxhcmdlciUyMCU2MG1pbl9sZW5ndGglNjAlMjB3aWxsJTIwZm9yY2UlMjB0aGUlMjBtb2RlbCUyMHRvJTIwZ2VuZXJhdGUlMjBiZXlvbmQlMjBpdHMlMjBuYXR1cmFsJTIwZW5kaW5nJTIwcG9pbnQlMkMlMjB3aGljaCUyMGlzJTIwbm90JTBBJTIzJTIwbmVjZXNzYXJpbHklMjBpbmNvcnJlY3QlMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtaW5fbGVuZ3RoJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A number:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_length\` to a value smaller than the uncontrolled output length has no impact</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting a larger \`min_length\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand, nine hundred <span class="hljs-keyword">and</span> ninety-four`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function Z3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBudW1iZXIlM0ElMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbmV3X3Rva2VucyU2MCUyMHdpbGwlMjBmb3JjZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBnZW5lcmF0ZSUyMGJleW9uZCUyMGl0cyUyMG5hdHVyYWwlMjBlbmRpbmclMjBwb2ludCUyQyUyMHdoaWNoJTIwaXMlMjBub3QlMEElMjMlMjBuZWNlc3NhcmlseSUyMGluY29ycmVjdCUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1pbl9uZXdfdG9rZW5zJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;A number:&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_new_tokens\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_new_tokens=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function C3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MG1pbl9wJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMEElMjMlMjBQcm8lMjB0aXAlM0ElMjBJbiUyMHByYWN0aWNlJTJDJTIwTExNcyUyMHVzZSUyMCU2MG1pbl9wJTYwJTIwaW4lMjB0aGUlMjAwLjAxLTAuMiUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBtaW5fcCUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`min_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`min_p\` in the 0.01-0.2 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, min_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function W3(j){let c,$=`In order to get the token ids of the words that should not appear in the generated text, make sure to set
<code>add_prefix_space=True</code> when initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code> argument is only supported for some slow tokenizers,
as fast tokenizers’ prefixing behaviours come from <code>pre tokenizers</code>. Read more
<a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){c=o("p"),c.innerHTML=$},l(y){c=l(y,"P",{"data-svelte-h":!0}),b(c)!=="svelte-15bvr1j"&&(c.innerHTML=$)},m(y,d){p(y,c,d)},p:x,d(y){y&&n(c)}}}function B3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;In a word, the cake is a&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a mess.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s take the bad words out. Please note that the tokenizer is initialized differently</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_list</span>(<span class="hljs-params">word_list</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Converts a sequence of words into a list of tokens&quot;</span>
<span class="hljs-meta">... </span>    tokens_list = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_list:
<span class="hljs-meta">... </span>        tokenized_word = tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        tokens_list.append(tokenized_word)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokens_list


<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = get_tokens_as_list(word_list=[<span class="hljs-string">&quot;mess&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, bad_words_ids=bad_words_ids, pad_token_id=tokenizer.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a surprise.`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function I3(j){let c,$=`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city’s name appears only once in the entire text.
<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">Reference</a>`;return{c(){c=o("p"),c.innerHTML=$},l(y){c=l(y,"P",{"data-svelte-h":!0}),b(c)!=="svelte-5zfsi9"&&(c.innerHTML=$)},m(y,d){p(y,c,d)},p:x,d(y){y&&n(c)}}}function z3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQlMkZkaXN0aWxncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyMEklMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjBOb3clMjBsZXQncyUyMGFkZCUyMG5ncmFtJTIwc2l6ZSUyMHVzaW5nJTIwJTYwbm9fcmVwZWF0X25ncmFtX3NpemUlNjAuJTIwVGhpcyUyMHN0b3BzJTIwdGhlJTIwcmVwZXRpdGlvbnMlMjAoJTIySSVFMiU4MCU5OW0lMjIpJTIwaW4lMjB0aGUlMjBvdXRwdXQuJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBub19yZXBlYXRfbmdyYW1fc2l6ZSUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXQlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today I&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I’m going to be able to do it.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s add ngram size using \`no_repeat_ngram_size\`. This stops the repetitions (&quot;I’m&quot;) in the output.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I can get a better understanding of the nature of this issue`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function V3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice and Bob&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob are friends

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can contrain it with \`prefix_allowed_tokens_fn\` to force a certain behavior based on a prefix.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For instance, we can force an entire entity to be generated when its beginning is detected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>entity = tokenizer(<span class="hljs-string">&quot; Bob Marley&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids[<span class="hljs-number">0</span>]  <span class="hljs-comment"># 3 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prefix_allowed_tokens_fn</span>(<span class="hljs-params">batch_id, input_ids</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Attempts to generate &#x27;Bob Marley&#x27; when &#x27;Bob&#x27; is detected.
<span class="hljs-meta">... </span>    In this case, \`batch_id\` is not used, but you can set rules for each batch member.
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">0</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> [entity[<span class="hljs-number">1</span>].item()]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">elif</span> input_ids[-<span class="hljs-number">2</span>] == entity[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">1</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> [entity[<span class="hljs-number">2</span>].item()]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(tokenizer.vocab_size))  <span class="hljs-comment"># If no match, allow all tokens</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, prefix_allowed_tokens_fn=prefix_allowed_tokens_fn)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob Marley`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function G3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwZm9yJTIwaXQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIySSdtJTIwbm90JTIwZ29pbmclMjB0byUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwVGhpcyUyMHNob3dzJTIwYSUyMG5vcm1hbCUyMGdlbmVyYXRlJTIwd2l0aG91dCUyMGFueSUyMHNwZWNpZmljJTIwcGFyYW1ldGVycyUwQXN1bW1hcnlfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShzdW1tYXJ5X2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwVGhpcyUyMGdlbmVyYXRlcyUyMGElMjBwZW5hbHR5JTIwZm9yJTIwcmVwZWF0ZWQlMjB0b2tlbnMlMEFwZW5hbGl6ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShwZW5hbGl6ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing the model and tokenizer for it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I&#x27;m not going to&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This shows a normal generate without any specific parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>m going to be able to do that

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This generates a penalty for repeated tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>penalized_ids = model.generate(**inputs, repetition_penalty=<span class="hljs-number">1.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(penalized_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>ll just have to go out <span class="hljs-keyword">and</span> play`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function F3(j){let c,$=`In order to get the token ids of the sequences that you want to bias, make sure to set <code>add_prefix_space=True</code> when
initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The
<code>add_prefix_space</code> argument is only supported for some slow tokenizers, as fast tokenizers’ prefixing behaviours
come from <code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){c=o("p"),c.innerHTML=$},l(y){c=l(y,"P",{"data-svelte-h":!0}),b(c)!=="svelte-16cusgy"&&(c.innerHTML=$)},m(y,d){p(y,c,d)},p:x,d(y){y&&n(c)}}}function X3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;The full name of Donald is Donald&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Trump Jr

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s control generation through a bias. Please note that the tokenizer is initialized differently!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens</span>(<span class="hljs-params">word</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we add a negative bias without beam search, it may become &quot;stuck&quot; in a prefix without good continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = [get_tokens(<span class="hljs-string">&quot;Trump&quot;</span>), -<span class="hljs-number">10.0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Donald,

<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Rumsfeld,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also add a positive bias to nudge the model towards specific tokens or continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = [get_tokens(<span class="hljs-string">&quot;Donald Duck&quot;</span>), <span class="hljs-number">10.0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Duck.`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function R3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMCU2MGJlZ2luX3N1cHByZXNzX3Rva2VucyU2MCUyMHNldCUyMGJ5JTIwZGVmYXVsdCUyMCglM0QlMjAlNjAlNUIyMjAlMkMlMjA1MDI1NiU1RCU2MCkuJTIwNTAyNTYlMjBpcyUyMHRoZSUyMEVPUyUyMHRva2VuJTJDJTIwc28lMjB0aGlzJTIwbWVhbnMlMEElMjMlMjBpdCUyMGNhbid0JTIwZ2VuZXJhdGUlMjBhbmQlMjBFT1MlMjB0b2tlbiUyMGluJTIwdGhlJTIwZmlyc3QlMjBpdGVyYXRpb24lMkMlMjBidXQlMjBpdCUyMGNhbiUyMGluJTIwdGhlJTIwb3RoZXJzLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlKSUwQXByaW50KG91dHB1dHMuc2NvcmVzJTVCMCU1RCU1QjAlMkMlMjA1MDI1NiU1RCklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEJTVCMCUyQyUyMDUwMjU2JTVEKSUyMCUyMCUyMyUyMGluJTIwb3RoZXIlMjBwbGFjZXMlMjB3ZSUyMGNhbiUyMHNlZSUyMHNvbWUlMjBwcm9iYWJpbGl0eSUyMG1hc3MlMjBmb3IlMjBFT1MlMEElMEElMjMlMjBJZiUyMHdlJTIwZGlzYWJsZSUyMCU2MGJlZ2luX3N1cHByZXNzX3Rva2VucyU2MCUyQyUyMHdlJTIwY2FuJTIwZ2VuZXJhdGUlMjBFT1MlMjBpbiUyMHRoZSUyMGZpcnN0JTIwaXRlcmF0aW9uLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwYmVnaW5fc3VwcHJlc3NfdG9rZW5zJTNETm9uZSUwQSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjAlNUQlNUIwJTJDJTIwNTAyNTYlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has \`begin_suppress_tokens\` set by default (= \`[220, 50256]\`). 50256 is the EOS token, so this means</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># it can&#x27;t generate and EOS token in the first iteration, but it can in the others.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(-inf)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[-<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])  <span class="hljs-comment"># in other places we can see some probability mass for EOS</span>
tensor(<span class="hljs-number">29.9010</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`begin_suppress_tokens\`, we can generate EOS in the first iteration.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, begin_suppress_tokens=<span class="hljs-literal">None</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(<span class="hljs-number">11.2027</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function L3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMGElMjBsb25nJTIwbGlzdCUyMG9mJTIwc3VwcHJlc3NlZCUyMHRva2Vucy4lMjBGb3IlMjBpbnN0YW5jZSUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMkMlMjB0aGUlMjB0b2tlbiUyMDElMjBpcyUyMHN1cHByZXNzZWQlMjBieSUyMGRlZmF1bHQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQob3V0cHV0cy5zY29yZXMlNUIxJTVEJTVCMCUyQyUyMDElNUQpJTIwJTIwJTIzJTIwMSUyMChhbmQlMjBub3QlMjAwKSUyMGlzJTIwdGhlJTIwZmlyc3QlMjBmcmVlbHklMjBnZW5lcmF0ZWQlMjB0b2tlbiUwQSUwQSUyMyUyMElmJTIwd2UlMjBkaXNhYmxlJTIwJTYwc3VwcHJlc3NfdG9rZW5zJTYwJTJDJTIwd2UlMjBjYW4lMjBnZW5lcmF0ZSUyMGl0LiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwc3VwcHJlc3NfdG9rZW5zJTNETm9uZSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjElNUQlNUIwJTJDJTIwMSU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has a long list of suppressed tokens. For instance, in this case, the token 1 is suppressed by default.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])  <span class="hljs-comment"># 1 (and not 0) is the first freely generated token</span>
tensor(-inf)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`suppress_tokens\`, we can generate it.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, suppress_tokens=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
tensor(<span class="hljs-number">6.0678</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function S3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2dvb2dsZSUyRmdlbW1hLTItMmInJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCgnZ29vZ2xlJTJGZ2VtbWEtMi0yYicpJTBBJTBBJTIzJTIwU3ludGhJRCUyMFRleHQlMjBjb25maWd1cmF0aW9uJTBBd2F0ZXJtYXJraW5nX2NvbmZpZyUyMCUzRCUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGtleXMlM0QlNUI2NTQlMkMlMjA0MDAlMkMlMjA4MzYlMkMlMjAxMjMlMkMlMjAzNDAlMkMlMjA0NDMlMkMlMjA1OTclMkMlMjAxNjAlMkMlMjA1NyU1RCUyQyUwQSUyMCUyMCUyMCUyMG5ncmFtX2xlbiUzRDUlMkMlMEEpJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMHdpdGglMjB3YXRlcm1hcmtpbmclMEF0b2tlbml6ZWRfcHJvbXB0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQW91dHB1dF9zZXF1ZW5jZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKnRva2VuaXplZF9wcm9tcHRzJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRHdhdGVybWFya2luZ19jb25maWclMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUwQSklMEF3YXRlcm1hcmtlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRfc2VxdWVuY2VzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, SynthIDTextWatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># SynthID Text configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = SynthIDTextWatermarkingConfig(
<span class="hljs-meta">... </span>    keys=[<span class="hljs-number">654</span>, <span class="hljs-number">400</span>, <span class="hljs-number">836</span>, <span class="hljs-number">123</span>, <span class="hljs-number">340</span>, <span class="hljs-number">443</span>, <span class="hljs-number">597</span>, <span class="hljs-number">160</span>, <span class="hljs-number">57</span>],
<span class="hljs-meta">... </span>    ngram_len=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generation with watermarking</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_prompts = tokenizer([<span class="hljs-string">&quot;Once upon a time, &quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_sequences = model.generate(
<span class="hljs-meta">... </span>    **tokenized_prompts, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">10</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarked_text = tokenizer.batch_decode(output_sequences, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function N3(j){let c,$=`Make sure that <code>do_sample=True</code> is included in the <code>generate</code> arguments otherwise the temperature value won’t have
any effect.`;return{c(){c=o("p"),c.innerHTML=$},l(y){c=l(y,"P",{"data-svelte-h":!0}),b(c)!=="svelte-1byeoum"&&(c.innerHTML=$)},m(y,d){p(y,c,d)},p:x,d(y){y&&n(c)}}}function H3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwc2V0X3NlZWQlMEElMEFzZXRfc2VlZCgwKSUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsLmNvbmZpZy5wYWRfdG9rZW5faWQlMjAlM0QlMjBtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkh1Z2dpbmclMjBGYWNlJTIwQ29tcGFueSUyMGlzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwdGVtcGVyYXR1cmUlM0QxLjAlMkMlMjB0aGUlMjBkZWZhdWx0JTJDJTIwd2UlMjBjb25zaXN0ZW50bHklMjBnZXQlMjByYW5kb20lMjBvdXRwdXRzJTIwZHVlJTIwdG8lMjByYW5kb20lMjBzYW1wbGluZy4lMEFnZW5lcmF0ZV9rd2FyZ3MlMjAlM0QlMjAlN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEwJTJDJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUyMCUyMnRlbXBlcmF0dXJlJTIyJTNBJTIwMS4wJTJDJTIwJTIybnVtX3JldHVybl9zZXF1ZW5jZXMlMjIlM0ElMjAyJTdEJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwKipnZW5lcmF0ZV9rd2FyZ3MpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKSUwQSUwQSUyMyUyMEhvd2V2ZXIlMkMlMjB3aXRoJTIwdGVtcGVyYXR1cmUlMjBjbG9zZSUyMHRvJTIwMCUyQyUyMGl0JTIwYXBwcm94aW1hdGVzJTIwZ3JlZWR5JTIwZGVjb2RpbmclMjBzdHJhdGVnaWVzJTIwKGludmFyaWFudCklMEFnZW5lcmF0ZV9rd2FyZ3MlNUIlMjJ0ZW1wZXJhdHVyZSUyMiU1RCUyMCUzRCUyMDAuMDAwMSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMCoqZ2VuZXJhdGVfa3dhcmdzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># for reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With temperature=1.0, the default, we consistently get random outputs due to random sampling.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">2</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is one of these companies that is going to take a&#x27;</span>,
<span class="hljs-string">&quot;Hugging Face Company is a brand created by Brian A. O&#x27;Neil&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># However, with temperature close to 0, it approximates greedy decoding strategies (invariant)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = <span class="hljs-number">0.0001</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>]`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function E3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2l0aCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjB1bmV4cGVjdGVkJTIwLS0lMjBzb21ldGltZXMlMjB0b28lMjB1bmV4cGVjdGVkLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwJTYwdG9wX2slNjAlMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdGhlJTIwayUyMG1vc3QlMjBsaWtlbHklMjB0b2tlbnMuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwSW4lMjBwcmFjdGljZSUyQyUyMExMTXMlMjB1c2UlMjAlNjB0b3BfayU2MCUyMGluJTIwdGhlJTIwNS01MCUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfayUzRDIpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: A, B, C, D&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E — S — O, P — R

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_k\` sampling, the output gets restricted the k most likely tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_k\` in the 5-50 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E, F, G, H, I`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function q3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MHRvcF9wJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMEElMjMlMjBQcm8lMjB0aXAlM0ElMjBJbiUyMHByYWN0aWNlJTJDJTIwTExNcyUyMHVzZSUyMCU2MHRvcF9wJTYwJTIwaW4lMjB0aGUlMjAwLjktMC45NSUyMHJhbmdlLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjB0b3BfcCUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> | &lt; <span class="hljs-number">4</span> (left-hand pointer) ;
&lt;BLANKLINE&gt;
&lt;BLANKLINE&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_p\` in the 0.9-0.95 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function D3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRmJsb29tei01NjBtJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyMSUyQyUyMDIlMkMlMjAzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXZSUyMGNhbiUyMHNlZSUyMHRoYXQlMjBncmVlZHklMjBkZWNvZGluZyUyMHByb2R1Y2VzJTIwYSUyMHNlcXVlbmNlJTIwb2YlMjBudW1iZXJzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwRm9yJTIwdGhpcyUyMHBhcnRpY3VsYXIlMjBzZWVkJTJDJTIwd2UlMjBjYW4lMjBzZWUlMjB0aGF0JTIwc2FtcGxpbmclMjBwcm9kdWNlcyUyMG5lYXJseSUyMHRoZSUyMHNhbWUlMjBsb3ctaW5mb3JtYXRpb24lMjAoJTNEJTIwbG93JTIwZW50cm9weSklMEElMjMlMjBzZXF1ZW5jZSUwQXNldF9zZWVkKDE4KSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwJTYwdHlwaWNhbF9wJTYwJTIwc2V0JTJDJTIwdGhlJTIwbW9zdCUyMG9idmlvdXMlMjBzZXF1ZW5jZSUyMGlzJTIwbm8lMjBsb25nZXIlMjBwcm9kdWNlZCUyQyUyMHdoaWNoJTIwbWF5JTIwYmUlMjBnb29kJTIwZm9yJTIweW91ciUyMHByb2JsZW0lMEFzZXRfc2VlZCgxOCklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdHlwaWNhbF9wJTNEMC4xJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUlMEEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzLnNlcXVlbmNlcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2UlMjBjYW4lMjBzZWUlMjB0aGF0JTIwdGhlJTIwdG9rZW4lMjBjb3JyZXNwb25kaW5nJTIwdG8lMjAlMjI0JTIyJTIwKHRva2VuJTIwOTM0KSUyMGluJTIwdGhlJTIwc2Vjb25kJTIwcG9zaXRpb24lMkMlMjB0aGUlMjBtb3N0JTIwbGlrZWx5JTIwdG9rZW4lMEElMjMlMjBhcyUyMHNlZW4lMjB3aXRoJTIwZ3JlZWR5JTIwZGVjb2RpbmclMkMlMjB3YXMlMjBlbnRpcmVseSUyMGJsb2NrZWQlMjBvdXQlMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjElNUQlNUIwJTJDJTIwOTM0JTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that greedy decoding produces a sequence of numbers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>, <span class="hljs-number">10</span>,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For this particular seed, we can see that sampling produces nearly the same low-information (= low entropy)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sequence</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span> <span class="hljs-keyword">and</span> <span class="hljs-number">10</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`typical_p\` set, the most obvious sequence is no longer produced, which may be good for your problem</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, do_sample=<span class="hljs-literal">True</span>, typical_p=<span class="hljs-number">0.1</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.sequences, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> <span class="hljs-keyword">and</span> <span class="hljs-number">5</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that the token corresponding to &quot;4&quot; (token 934) in the second position, the most likely token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># as seen with greedy decoding, was entirely blocked out</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">934</span>])
tensor(-inf)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function Q3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJUb2RheSUyQyUyMGElMjBkcmFnb24lMjBmbGV3JTIwb3ZlciUyMFBhcmlzJTJDJTIwRnJhbmNlJTJDJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDEuNSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEElMEElMjMlMjB3aXRoJTIwYSUyMG5lZ2F0aXZlJTIwcHJvbXB0JTBBbmVnX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwdmVyeSUyMGhhcHB5JTIwZXZlbnQlMjBoYXBwZW5lZCUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QyJTJDJTIwbmVnYXRpdmVfcHJvbXB0X2lkcyUzRG5lZ19pbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwd2l0aCUyMGElMjBwb3NpdGl2ZSUyMHByb21wdCUwQW5lZ19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMHZlcnklMjBoYXBweSUyMGV2ZW50JTIwaGFwcGVuZWQlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMCUyQyUyMG5lZ2F0aXZlX3Byb21wdF9pZHMlM0RuZWdfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today, a dragon flew over Paris, France,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">1.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 50 people and injuring more than 100&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a negative prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">2</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 130 people. French media reported that&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a positive prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">0</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Today, a dragon flew over Paris, France, and I&#x27;m very happy to be here. I&quot;</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function Y3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBHZW5lcmF0aW9uQ29uZmlnJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIzJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfZmVhdHVyZXMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfZmVhdHVyZXMlMEElMEElMjNEaXNwbGF5aW5nJTIwdGltZXN0YW1wcyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlM0RpbnB1dF9mZWF0dXJlcyUyQyUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwZGVjb2RlX3dpdGhfdGltZXN0YW1wcyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKSUwQSUwQSUwQSUyM05vJTIwdGltZXN0YW1wcyUyMCUyNiUyMGNoYW5nZSUyMEVPUyUzQSUwQSUyM1RoaXMlMjBhbGxvd3MlMjB0aGUlMjB1c2VyJTIwdG8lMjBzZWxlY3QlMjBhJTIwc3BlY2lmaWMlMjB0b2tlbiUyMHRvJTIwdGVybWluYXRlJTIwdGhlJTIwc2VxdWVuY2UlMjBvbiUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMjBpdCdzJTIwdGhlJTIwd29yZCUyMCUyMmNhbiUyMig0NjApJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZW9zX3Rva2VuX2lkJTIwJTNEJTIwNDYwJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyUzRGlucHV0X2ZlYXR1cmVzJTJDcmV0dXJuX3RpbWVzdGFtcHMlM0RGYWxzZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration, GenerationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">3</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_features = inputs.input_features

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment">#Displaying timestamps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, decode_with_timestamps=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription: &lt;|startoftranscript|&gt;&lt;|<span class="hljs-number">0.00</span>|&gt; He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all, and can&lt;|6.44|&gt;&lt;|6.44|&gt; discover in it but little of rocky Ithaca.&lt;|9.44|&gt;&lt;|endoftext|&gt;


&gt;&gt;&gt; #No timestamps &amp; change EOS:
&gt;&gt;&gt; #This allows the user to select a specific token to terminate the sequence on, in this case it&#x27;</span>s the word <span class="hljs-string">&quot;can&quot;</span>(<span class="hljs-number">460</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.eos_token_id = <span class="hljs-number">460</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features,return_timestamps=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription:  He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all and can</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function P3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFdhdGVybWFya2luZ0NvbmZpZyUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBbGljZSUyMGFuZCUyMEJvYiUyMGFyZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwbm9ybWFsJTIwZ2VuZXJhdGlvbiUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMG1heF9sZW5ndGglM0QyMCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHdhdGVybWFya2VkJTIwZ2VuZXJhdGlvbiUwQXdhdGVybWFya2luZ19jb25maWclMjAlM0QlMjBXYXRlcm1hcmtpbmdDb25maWcoYmlhcyUzRDIuNSUyQyUyMGNvbnRleHRfd2lkdGglM0QyJTJDJTIwc2VlZGluZ19zY2hlbWUlM0QlMjJzZWxmaGFzaCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjB3YXRlcm1hcmtpbmdfY29uZmlnJTNEd2F0ZXJtYXJraW5nX2NvbmZpZyUyQyUyMG1heF9sZW5ndGglM0QyMCUyQyUyMGRvX3NhbXBsZSUzREZhbHNlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHRvJTIwZGV0ZWN0JTIwd2F0ZXJtYXJrZWQlMjB0ZXh0JTIwdXNlJTIwdGhlJTIwV2F0ZXJtYXJrRGV0ZWN0b3IlMjBjbGFzcyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBXYXRlcm1hcmtEZXRlY3RvciUwQWRldGVjdG9yJTIwJTNEJTIwV2F0ZXJtYXJrRGV0ZWN0b3IobW9kZWxfY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwZGV2aWNlJTNEJTIyY3B1JTIyJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRCUyMHdhdGVybWFya2luZ19jb25maWcpJTBBZGV0ZWN0aW9uX3ByZWRzJTIwJTNEJTIwZGV0ZWN0b3Iob3V0KSUwQWRldGVjdGlvbl9wcmVkcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, WatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob are&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># normal generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_length=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Alice and Bob are both in the same room.\\n\\n&quot;I\\&#x27;m not sure if you\\&#x27;re&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># watermarked generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = WatermarkingConfig(bias=<span class="hljs-number">2.5</span>, context_width=<span class="hljs-number">2</span>, seeding_scheme=<span class="hljs-string">&quot;selfhash&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], watermarking_config=watermarking_config, max_length=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Alice and Bob are both still alive and well and the story is pretty much a one-hour adventure&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to detect watermarked text use the WatermarkDetector class</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WatermarkDetector
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = WatermarkDetector(model_config=model.config, device=<span class="hljs-string">&quot;cpu&quot;</span>, watermarking_config= watermarking_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_preds = detector(out)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_preds
array([ <span class="hljs-literal">True</span>])`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function A3(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0yJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnBoaS0yJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUaGUlMjBiaWdnZXN0JTIwc3RhdGVzJTIwaW4lMjB0aGUlMjBVU0ElMjBieSUyMGxhbmQlMjBhcmVhJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBQYXNzaW5nJTIwb25lJTIwb3IlMjBtb3JlJTIwc3RvcCUyMHN0cmluZ3MlMjB3aWxsJTIwaGFsdCUyMGdlbmVyYXRpb24lMjBhZnRlciUyMHRob3NlJTIwc3RyaW5ncyUyMGFyZSUyMGVtaXR0ZWQlMEElMjMlMjBOb3RlJTIwdGhhdCUyMGdlbmVyYXRpbmclMjB3aXRoJTIwc3RvcCUyMHN0cmluZ3MlMjByZXF1aXJlcyUyMHlvdSUyMHRvJTIwcGFzcyUyMHRoZSUyMHRva2VuaXplciUyMHRvbyUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHN0b3Bfc3RyaW5ncyUzRCU1QiUyMlRleGFzJTIyJTVEJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuX291dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/phi-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The biggest states in the USA by land area:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The biggest states <span class="hljs-keyword">in</span> the USA by land area:
- Alaska
- Texas
- California

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Passing one or more stop strings will halt generation after those strings are emitted</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that generating with stop strings requires you to pass the tokenizer too</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, stop_strings=[<span class="hljs-string">&quot;Texas&quot;</span>], tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The biggest states <span class="hljs-keyword">in</span> the USA by land area:
- Alaska
- Texas`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function O3(j){let c,$;return c=new U({props:{code:"Y29tcGxldGVkJTIwJTNEJTIwRmFsc2UlMEF3aGlsZSUyMG5vdCUyMGNvbXBsZXRlZCUzQSUwQSUyMCUyMCUyMCUyMF8lMkMlMjBjb21wbGV0ZWQlMjAlM0QlMjBjb25zdHJhaW50LnVwZGF0ZShjb25zdHJhaW50LmFkdmFuY2UoKSk=",highlighted:`completed = <span class="hljs-literal">False</span>
<span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> completed:
    _, completed = constraint.update(constraint.advance())`,wrap:!1}}),{c(){m(c.$$.fragment)},l(y){g(c.$$.fragment,y)},m(y,d){h(c,y,d),$=!0},p:x,i(y){$||(u(c.$$.fragment,y),$=!0)},o(y){f(c.$$.fragment,y),$=!1},d(y){_(c,y)}}}function K3(j){let c,$="The API for the streamer classes is still under development and may change in the future.";return{c(){c=o("p"),c.textContent=$},l(y){c=l(y,"P",{"data-svelte-h":!0}),b(c)!=="svelte-gv2g1g"&&(c.textContent=$)},m(y,d){p(y,c,d)},p:x,d(y){y&&n(c)}}}function eZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0U3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMERlc3BpdGUlMjByZXR1cm5pbmclMjB0aGUlMjB1c3VhbCUyMG91dHB1dCUyQyUyMHRoZSUyMHN0cmVhbWVyJTIwd2lsbCUyMGFsc28lMjBwcmludCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjB0byUyMHN0ZG91dC4lMEFfJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function tZ(j){let c,$="The API for the streamer classes is still under development and may change in the future.";return{c(){c=o("p"),c.textContent=$},l(y){c=l(y,"P",{"data-svelte-h":!0}),b(c)!=="svelte-gv2g1g"&&(c.textContent=$)},m(y,d){p(y,c,d)},p:x,d(y){y&&n(c)}}}function sZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRJdGVyYXRvclN0cmVhbWVyJTBBZnJvbSUyMHRocmVhZGluZyUyMGltcG9ydCUyMFRocmVhZCUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRvayglNUIlMjJBbiUyMGluY3JlYXNpbmclMjBzZXF1ZW5jZSUzQSUyMG9uZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBc3RyZWFtZXIlMjAlM0QlMjBUZXh0SXRlcmF0b3JTdHJlYW1lcih0b2spJTBBJTBBJTIzJTIwUnVuJTIwdGhlJTIwZ2VuZXJhdGlvbiUyMGluJTIwYSUyMHNlcGFyYXRlJTIwdGhyZWFkJTJDJTIwc28lMjB0aGF0JTIwd2UlMjBjYW4lMjBmZXRjaCUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMjBpbiUyMGElMjBub24tYmxvY2tpbmclMjB3YXkuJTBBZ2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjBkaWN0KGlucHV0cyUyQyUyMHN0cmVhbWVyJTNEc3RyZWFtZXIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKSUwQXRocmVhZCUyMCUzRCUyMFRocmVhZCh0YXJnZXQlM0Rtb2RlbC5nZW5lcmF0ZSUyQyUyMGt3YXJncyUzRGdlbmVyYXRpb25fa3dhcmdzKSUwQXRocmVhZC5zdGFydCgpJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjAlMjIlMjIlMEFmb3IlMjBuZXdfdGV4dCUyMGluJTIwc3RyZWFtZXIlM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfdGV4dCUyMCUyQiUzRCUyMG5ld190ZXh0JTBBZ2VuZXJhdGVkX3RleHQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextIteratorStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread.start()
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>    generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,&#x27;</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function nZ(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMER5bmFtaWNDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBRd2VuMiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMER5bmFtaWNDYWNoZSgpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFvdXRwdXRzLnBhc3Rfa2V5X3ZhbHVlcyUyMCUyMyUyMGFjY2VzcyUyMGNhY2hlJTIwZmlsbGVkJTIwd2l0aCUyMGtleSUyRnZhbHVlcyUyMGZyb20lMjBnZW5lcmF0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, DynamicCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
DynamicCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-11lpom8"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function rZ(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"JTIzJTIwUnVuJTIwcGlwJTIwaW5zdGFsbCUyMHF1YW50byUyMGZpcnN0JTIwaWYlMjB5b3UlMjBkb24ndCUyMGhhdmUlMjBpdCUyMHlldCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBRdWFudG9RdWFudGl6ZWRDYWNoZSUyQyUyMFF1YW50aXplZENhY2hlQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMFF3ZW4yJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBQcmVwYXJlJTIwYSUyMGNhY2hlJTIwY2xhc3MlMjBhbmQlMjBwYXNzJTIwaXQlMjB0byUyMG1vZGVsJ3MlMjBmb3J3YXJkJTBBY2FjaGVfY29uZmlnJTIwJTNEJTIwUXVhbnRpemVkQ2FjaGVDb25maWcobmJpdHMlM0Q0KSUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFF1YW50b1F1YW50aXplZENhY2hlKGNhY2hlX2NvbmZpZyUzRGNhY2hlX2NvbmZpZyklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKSUwQW91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run pip install quanto first if you don&#x27;t have it yet</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, QuantoQuantizedCache, QuantizedCacheConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache_config = QuantizedCacheConfig(nbits=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = QuantoQuantizedCache(cache_config=cache_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
QuantoQuantizedCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-11lpom8"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function aZ(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"JTIzJTIwUnVuJTIwcGlwJTIwaW5zdGFsbCUyMGhxcSUyMGZpcnN0JTIwaWYlMjB5b3UlMjBkb24ndCUyMGhhdmUlMjBpdCUyMHlldCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBIUVFRdWFudGl6ZWRDYWNoZSUyQyUyMFF1YW50aXplZENhY2hlQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMFF3ZW4yJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBQcmVwYXJlJTIwYSUyMGNhY2hlJTIwY2xhc3MlMjBhbmQlMjBwYXNzJTIwaXQlMjB0byUyMG1vZGVsJ3MlMjBmb3J3YXJkJTBBY2FjaGVfY29uZmlnJTIwJTNEJTIwUXVhbnRpemVkQ2FjaGVDb25maWcobmJpdHMlM0Q0JTJDJTIwYXhpc19rZXklM0QxJTJDJTIwYXhpc192YWx1ZSUzRDEpJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwSFFRUXVhbnRpemVkQ2FjaGUoY2FjaGVfY29uZmlnJTNEY2FjaGVfY29uZmlnKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXMlMjAlMjMlMjBhY2Nlc3MlMjBjYWNoZSUyMGZpbGxlZCUyMHdpdGglMjBrZXklMkZ2YWx1ZXMlMjBmcm9tJTIwZ2VuZXJhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run pip install hqq first if you don&#x27;t have it yet</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, HQQQuantizedCache, QuantizedCacheConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache_config = QuantizedCacheConfig(nbits=<span class="hljs-number">4</span>, axis_key=<span class="hljs-number">1</span>, axis_value=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = HQQQuantizedCache(cache_config=cache_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
HQQQuantizedCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-11lpom8"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function oZ(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFNpbmtDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi0wLjVCLUluc3RydWN0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBRd2VuMiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFNpbmtDYWNoZSh3aW5kb3dfbGVuZ3RoJTNEMjU2JTJDJTIwbnVtX3NpbmtfdG9rZW5zJTNENCklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlM0RwYXN0X2tleV92YWx1ZXMlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKSUwQW91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SinkCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Qwen2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = SinkCache(window_length=<span class="hljs-number">256</span>, num_sink_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
SinkCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-11lpom8"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function lZ(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFN0YXRpY0NhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBMbGFtYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQSUyMyUyMExlYXZlJTIwZW1wdHklMjBzcGFjZSUyMGZvciUyMDEwJTIwbmV3JTIwdG9rZW5zJTJDJTIwd2hpY2glMjBjYW4lMjBiZSUyMHVzZWQlMjB3aGVuJTIwY2FsbGluZyUyMGZvcndhcmQlMjBpdGVyYXRpdmVseSUyMDEwJTIwdGltZXMlMjB0byUyMGdlbmVyYXRlJTBBbWF4X2dlbmVyYXRlZF9sZW5ndGglMjAlM0QlMjBpbnB1dHMuaW5wdXRfaWRzLnNoYXBlJTVCMSU1RCUyMCUyQiUyMDEwJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwU3RhdGljQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBtYXhfY2FjaGVfbGVuJTNEbWF4X2dlbmVyYXRlZF9sZW5ndGglMkMlMjBkZXZpY2UlM0Rtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRG1vZGVsLmR0eXBlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXMlMjAlMjMlMjBhY2Nlc3MlMjBjYWNoZSUyMGZpbGxlZCUyMHdpdGglMjBrZXklMkZ2YWx1ZXMlMjBmcm9tJTIwZ2VuZXJhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, StaticCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Llama&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = StaticCache(config=model.config, batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
StaticCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-11lpom8"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function cZ(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyME9mZmxvYWRlZFN0YXRpY0NhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMEdQVDIlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFByZXBhcmUlMjBhJTIwY2FjaGUlMjBjbGFzcyUyMGFuZCUyMHBhc3MlMjBpdCUyMHRvJTIwbW9kZWwncyUyMGZvcndhcmQlMEElMjMlMjBMZWF2ZSUyMGVtcHR5JTIwc3BhY2UlMjBmb3IlMjAxMCUyMG5ldyUyMHRva2VucyUyQyUyMHdoaWNoJTIwY2FuJTIwYmUlMjB1c2VkJTIwd2hlbiUyMGNhbGxpbmclMjBmb3J3YXJkJTIwaXRlcmF0aXZlbHklMjAxMCUyMHRpbWVzJTIwdG8lMjBnZW5lcmF0ZSUwQW1heF9nZW5lcmF0ZWRfbGVuZ3RoJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1QjElNUQlMjAlMkIlMjAxMCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyME9mZmxvYWRlZFN0YXRpY0NhY2hlKGNvbmZpZyUzRG1vZGVsLmNvbmZpZyUyQyUyMG1heF9iYXRjaF9zaXplJTNEMSUyQyUyMG1heF9jYWNoZV9sZW4lM0RtYXhfZ2VuZXJhdGVkX2xlbmd0aCUyQyUyMGRldmljZSUzRG1vZGVsLmRldmljZSUyQyUyMGR0eXBlJTNEbW9kZWwuZHR5cGUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFwYXN0X2t2X2xlbmd0aCUyMCUzRCUyMG91dHB1dHMucGFzdF9rZXlfdmFsdWVzJTIwJTIzJTIwYWNjZXNzJTIwY2FjaGUlMjBmaWxsZWQlMjB3aXRoJTIwa2V5JTJGdmFsdWVzJTIwZnJvbSUyMGdlbmVyYXRpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, OffloadedStaticCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is GPT2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = OffloadedStaticCache(config=model.config, max_batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>past_kv_length = outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-11lpom8"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function iZ(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMEh5YnJpZENhY2hlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZ2VtbWEtMi0yYiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZnZW1tYS0yLTJiJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBHZW1tYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQSUyMyUyMExlYXZlJTIwZW1wdHklMjBzcGFjZSUyMGZvciUyMDEwJTIwbmV3JTIwdG9rZW5zJTJDJTIwd2hpY2glMjBjYW4lMjBiZSUyMHVzZWQlMjB3aGVuJTIwY2FsbGluZyUyMGZvcndhcmQlMjBpdGVyYXRpdmVseSUyMDEwJTIwdGltZXMlMjB0byUyMGdlbmVyYXRlJTBBbWF4X2dlbmVyYXRlZF9sZW5ndGglMjAlM0QlMjBpbnB1dHMuaW5wdXRfaWRzLnNoYXBlJTVCMSU1RCUyMCUyQiUyMDEwJTBBcGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwSHlicmlkQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBtYXhfY2FjaGVfbGVuJTNEbWF4X2dlbmVyYXRlZF9sZW5ndGglMkMlMjBkZXZpY2UlM0Rtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRG1vZGVsLmR0eXBlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXMlMjAlMjMlMjBhY2Nlc3MlMjBjYWNoZSUyMGZpbGxlZCUyMHdpdGglMjBrZXklMkZ2YWx1ZXMlMjBmcm9tJTIwZ2VuZXJhdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, HybridCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2-2b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2-2b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Gemma&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = HybridCache(config=model.config, batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
HybridCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-11lpom8"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function dZ(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFNsaWRpbmdXaW5kb3dDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItSW5zdHJ1Y3QtdjAuMyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjMlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyME1pc3RyYWwlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFByZXBhcmUlMjBhJTIwY2FjaGUlMjBjbGFzcyUyMGFuZCUyMHBhc3MlMjBpdCUyMHRvJTIwbW9kZWwncyUyMGZvcndhcmQlMEElMjMlMjBMZWF2ZSUyMGVtcHR5JTIwc3BhY2UlMjBmb3IlMjAxMCUyMG5ldyUyMHRva2VucyUyQyUyMHdoaWNoJTIwY2FuJTIwYmUlMjB1c2VkJTIwd2hlbiUyMGNhbGxpbmclMjBmb3J3YXJkJTIwaXRlcmF0aXZlbHklMjAxMCUyMHRpbWVzJTIwdG8lMjBnZW5lcmF0ZSUwQW1heF9nZW5lcmF0ZWRfbGVuZ3RoJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1QjElNUQlMjAlMkIlMjAxMCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMFNsaWRpbmdXaW5kb3dDYWNoZShjb25maWclM0Rtb2RlbC5jb25maWclMkMlMjBiYXRjaF9zaXplJTNEMSUyQyUyMG1heF9jYWNoZV9sZW4lM0RtYXhfZ2VuZXJhdGVkX2xlbmd0aCUyQyUyMGRldmljZSUzRG1vZGVsLmRldmljZSUyQyUyMGR0eXBlJTNEbW9kZWwuZHR5cGUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFvdXRwdXRzLnBhc3Rfa2V5X3ZhbHVlcyUyMCUyMyUyMGFjY2VzcyUyMGNhY2hlJTIwZmlsbGVkJTIwd2l0aCUyMGtleSUyRnZhbHVlcyUyMGZyb20lMjBnZW5lcmF0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, SlidingWindowCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.3&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.3&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Mistral&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Leave empty space for 10 new tokens, which can be used when calling forward iteratively 10 times to generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>max_generated_length = inputs.input_ids.shape[<span class="hljs-number">1</span>] + <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = SlidingWindowCache(config=model.config, batch_size=<span class="hljs-number">1</span>, max_cache_len=max_generated_length, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
SlidingWindowCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-11lpom8"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function pZ(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMER5bmFtaWNDYWNoZSUyQyUyMEVuY29kZXJEZWNvZGVyQ2FjaGUlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRndoaXNwZXItc21hbGwlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGF1ZGlvJTNEWU9VUi1BVURJTyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGNhY2hlJTIwY2xhc3NlcyUyMGZvciUyMGVuY29kZXIlMjBhbmQlMjBkZWNvZGVyJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXNlbGZfYXR0ZW50aW9uX2NhY2hlJTIwJTNEJTIwRHluYW1pY0NhY2hlKCklMEFjcm9zc19hdHRlbnRpb25fY2FjaGUlMjAlM0QlMjBEeW5hbWljQ2FjaGUoKSUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyMEVuY29kZXJEZWNvZGVyQ2FjaGUoc2VsZl9hdHRlbnRpb25fY2FjaGUlMkMlMjBjcm9zc19hdHRlbnRpb25fY2FjaGUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSklMEFvdXRwdXRzLnBhc3Rfa2V5X3ZhbHVlcyUyMCUyMyUyMGFjY2VzcyUyMGNhY2hlJTIwZmlsbGVkJTIwd2l0aCUyMGtleSUyRnZhbHVlcyUyMGZyb20lMjBnZW5lcmF0aW9u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForCausalLM, DynamicCache, EncoderDecoderCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(audio=YOUR-AUDIO, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare cache classes for encoder and decoder and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>self_attention_cache = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>cross_attention_cache = DynamicCache()
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = EncoderDecoderCache(self_attention_cache, cross_attention_cache)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values <span class="hljs-comment"># access cache filled with key/values from generation</span>
EncoderDecoderCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-11lpom8"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function mZ(j){let c,$="Example:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNYW1iYUZvckNhdXNhbExNJTJDJTIwTWFtYmFDYWNoZSUwQSUwQW1vZGVsJTIwJTNEJTIwTWFtYmFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhdGUtc3BhY2VzJTJGbWFtYmEtMTMwbS1oZiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdGF0ZS1zcGFjZXMlMkZtYW1iYS0xMzBtLWhmJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTNEJTIyTXklMjBuYW1lJTIwaXMlMjBNYW1iYSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwUHJlcGFyZSUyMGElMjBjYWNoZSUyMGNsYXNzJTIwYW5kJTIwcGFzcyUyMGl0JTIwdG8lMjBtb2RlbCdzJTIwZm9yd2FyZCUwQXBhc3Rfa2V5X3ZhbHVlcyUyMCUzRCUyME1hbWJhQ2FjaGUoY29uZmlnJTNEbW9kZWwuY29uZmlnJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBkZXZpY2UlM0Rtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRG1vZGVsLmR0eXBlKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHBhc3Rfa2V5X3ZhbHVlcyUzRHBhc3Rfa2V5X3ZhbHVlcyUyQyUyMHVzZV9jYWNoZSUzRFRydWUpJTBBb3V0cHV0cy5wYXN0X2tleV92YWx1ZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MambaForCausalLM, MambaCache

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MambaForCausalLM.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;state-spaces/mamba-130m-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text=<span class="hljs-string">&quot;My name is Mamba&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare a cache class and pass it to model&#x27;s forward</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_key_values = MambaCache(config=model.config, batch_size=<span class="hljs-number">1</span>, device=model.device, dtype=model.dtype)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs.past_key_values
MambaCache()`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-11lpom8"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function gZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMFdhdGVybWFya0RldGVjdG9yJTJDJTIwV2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXRvay5wYWRfdG9rZW5faWQlMjAlM0QlMjB0b2suZW9zX3Rva2VuX2lkJTBBdG9rLnBhZGRpbmdfc2lkZSUyMCUzRCUyMCUyMmxlZnQlMjIlMEElMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyVGhpcyUyMGlzJTIwdGhlJTIwYmVnaW5uaW5nJTIwb2YlMjBhJTIwbG9uZyUyMHN0b3J5JTIyJTJDJTIwJTIyQWxpY2UlMjBhbmQlMjBCb2IlMjBhcmUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfbGVuJTIwJTNEJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCLTElNUQlMEElMEElMjMlMjBmaXJzdCUyMGdlbmVyYXRlJTIwdGV4dCUyMHdpdGglMjB3YXRlcm1hcmslMjBhbmQlMjB3aXRob3V0JTBBd2F0ZXJtYXJraW5nX2NvbmZpZyUyMCUzRCUyMFdhdGVybWFya2luZ0NvbmZpZyhiaWFzJTNEMi41JTJDJTIwc2VlZGluZ19zY2hlbWUlM0QlMjJzZWxmaGFzaCUyMiklMEFvdXRfd2F0ZXJtYXJrZWQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHdhdGVybWFya2luZ19jb25maWclM0R3YXRlcm1hcmtpbmdfY29uZmlnJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UlMkMlMjBtYXhfbGVuZ3RoJTNEMjApJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9sZW5ndGglM0QyMCklMEElMEElMjMlMjBub3clMjB3ZSUyMGNhbiUyMGluc3RhbnRpYXRlJTIwdGhlJTIwZGV0ZWN0b3IlMjBhbmQlMjBjaGVjayUyMHRoZSUyMGdlbmVyYXRlZCUyMHRleHQlMEFkZXRlY3RvciUyMCUzRCUyMFdhdGVybWFya0RldGVjdG9yKG1vZGVsX2NvbmZpZyUzRG1vZGVsLmNvbmZpZyUyQyUyMGRldmljZSUzRCUyMmNwdSUyMiUyQyUyMHdhdGVybWFya2luZ19jb25maWclM0R3YXRlcm1hcmtpbmdfY29uZmlnKSUwQWRldGVjdGlvbl9vdXRfd2F0ZXJtYXJrZWQlMjAlM0QlMjBkZXRlY3RvcihvdXRfd2F0ZXJtYXJrZWQlMkMlMjByZXR1cm5fZGljdCUzRFRydWUpJTBBZGV0ZWN0aW9uX291dCUyMCUzRCUyMGRldGVjdG9yKG91dCUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSklMEFkZXRlY3Rpb25fb3V0X3dhdGVybWFya2VkLnByZWRpY3Rpb24lMEElMEFkZXRlY3Rpb25fb3V0LnByZWRpY3Rpb24=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, WatermarkDetector, WatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;openai-community/gpt2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.pad_token_id = tok.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>tok.padding_side = <span class="hljs-string">&quot;left&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;This is the beginning of a long story&quot;</span>, <span class="hljs-string">&quot;Alice and Bob are&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_len = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># first generate text with watermark and without</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = WatermarkingConfig(bias=<span class="hljs-number">2.5</span>, seeding_scheme=<span class="hljs-string">&quot;selfhash&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out_watermarked = model.generate(**inputs, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_length=<span class="hljs-number">20</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now we can instantiate the detector and check the generated text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = WatermarkDetector(model_config=model.config, device=<span class="hljs-string">&quot;cpu&quot;</span>, watermarking_config=watermarking_config)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out_watermarked = detector(out_watermarked, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out = detector(out, return_dict=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out_watermarked.prediction
array([ <span class="hljs-literal">True</span>,  <span class="hljs-literal">True</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>detection_out.prediction
array([<span class="hljs-literal">False</span>,  <span class="hljs-literal">False</span>])`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function hZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2dvb2dsZSUyRmdlbW1hLTItMmInJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCgnZ29vZ2xlJTJGZ2VtbWEtMi0yYicpJTBBJTBBJTIzJTIwU3ludGhJRCUyMFRleHQlMjBjb25maWd1cmF0aW9uJTBBd2F0ZXJtYXJraW5nX2NvbmZpZyUyMCUzRCUyMFN5bnRoSURUZXh0V2F0ZXJtYXJraW5nQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGtleXMlM0QlNUI2NTQlMkMlMjA0MDAlMkMlMjA4MzYlMkMlMjAxMjMlMkMlMjAzNDAlMkMlMjA0NDMlMkMlMjA1OTclMkMlMjAxNjAlMkMlMjA1NyU1RCUyQyUwQSUyMCUyMCUyMCUyMG5ncmFtX2xlbiUzRDUlMkMlMEEpJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMHdpdGglMjB3YXRlcm1hcmtpbmclMEF0b2tlbml6ZWRfcHJvbXB0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJPbmNlJTIwdXBvbiUyMGElMjB0aW1lJTJDJTIwJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQW91dHB1dF9zZXF1ZW5jZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAqKnRva2VuaXplZF9wcm9tcHRzJTJDJTIwd2F0ZXJtYXJraW5nX2NvbmZpZyUzRHdhdGVybWFya2luZ19jb25maWclMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUwQSklMEF3YXRlcm1hcmtlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRfc2VxdWVuY2VzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, SynthIDTextWatermarkingConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&#x27;google/gemma-2-2b&#x27;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># SynthID Text configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarking_config = SynthIDTextWatermarkingConfig(
<span class="hljs-meta">... </span>    keys=[<span class="hljs-number">654</span>, <span class="hljs-number">400</span>, <span class="hljs-number">836</span>, <span class="hljs-number">123</span>, <span class="hljs-number">340</span>, <span class="hljs-number">443</span>, <span class="hljs-number">597</span>, <span class="hljs-number">160</span>, <span class="hljs-number">57</span>],
<span class="hljs-meta">... </span>    ngram_len=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generation with watermarking</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_prompts = tokenizer([<span class="hljs-string">&quot;Once upon a time, &quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output_sequences = model.generate(
<span class="hljs-meta">... </span>    **tokenized_prompts, watermarking_config=watermarking_config, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">10</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>watermarked_text = tokenizer.batch_decode(output_sequences, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function uZ(j){let c,$="Examples:",y,d,w;return d=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBBdXRvVG9rZW5pemVyJTJDJTIwQmF5ZXNpYW5EZXRlY3Rvck1vZGVsJTJDJTIwU3ludGhJRFRleHRXYXRlcm1hcmtMb2dpdHNQcm9jZXNzb3IlMkMlMjBTeW50aElEVGV4dFdhdGVybWFya0RldGVjdG9yJTBBKSUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBkZXRlY3Rvci4lMjBTZWUlMjBleGFtcGxlcyUyRnJlc2VhcmNoX3Byb2plY3RzJTJGc3ludGhpZF90ZXh0JTIwZm9yJTIwdHJhaW5pbmclMjBhJTIwZGV0ZWN0b3IuJTBBZGV0ZWN0b3JfbW9kZWwlMjAlM0QlMjBCYXllc2lhbkRldGVjdG9yTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmpvYW9nYW50ZSUyRmR1bW15X3N5bnRoaWRfZGV0ZWN0b3IlMjIpJTBBbG9naXRzX3Byb2Nlc3NvciUyMCUzRCUyMFN5bnRoSURUZXh0V2F0ZXJtYXJrTG9naXRzUHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCoqZGV0ZWN0b3JfbW9kZWwuY29uZmlnLndhdGVybWFya2luZ19jb25maWclMkMlMjBkZXZpY2UlM0QlMjJjcHUlMjIlMEEpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoZGV0ZWN0b3JfbW9kZWwuY29uZmlnLm1vZGVsX25hbWUpJTBBZGV0ZWN0b3IlMjAlM0QlMjBTeW50aElEVGV4dFdhdGVybWFya0RldGVjdG9yKGRldGVjdG9yX21vZGVsJTJDJTIwbG9naXRzX3Byb2Nlc3NvciUyQyUyMHRva2VuaXplciklMEElMEElMjMlMjBUZXN0JTIwd2hldGhlciUyMGElMjBjZXJ0YWluJTIwc3RyaW5nJTIwaXMlMjB3YXRlcm1hcmtlZCUwQXRlc3RfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjBpbnB1dCUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaXNfd2F0ZXJtYXJrZWQlMjAlM0QlMjBkZXRlY3Rvcih0ZXN0X2lucHV0LmlucHV0X2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer, BayesianDetectorModel, SynthIDTextWatermarkLogitsProcessor, SynthIDTextWatermarkDetector
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the detector. See examples/research_projects/synthid_text for training a detector.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>detector_model = BayesianDetectorModel.from_pretrained(<span class="hljs-string">&quot;joaogante/dummy_synthid_detector&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = SynthIDTextWatermarkLogitsProcessor(
<span class="hljs-meta">... </span>    **detector_model.config.watermarking_config, device=<span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(detector_model.config.model_name)
<span class="hljs-meta">&gt;&gt;&gt; </span>detector = SynthIDTextWatermarkDetector(detector_model, logits_processor, tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Test whether a certain string is watermarked</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>test_input = tokenizer([<span class="hljs-string">&quot;This is a test input&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>is_watermarked = detector(test_input.input_ids)`,wrap:!1}}),{c(){c=o("p"),c.textContent=$,y=r(),m(d.$$.fragment)},l(s){c=l(s,"P",{"data-svelte-h":!0}),b(c)!=="svelte-kvfsh7"&&(c.textContent=$),y=a(s),g(d.$$.fragment,s)},m(s,k){p(s,c,k),p(s,y,k),h(d,s,k),w=!0},p:x,i(s){w||(u(d.$$.fragment,s),w=!0)},o(s){f(d.$$.fragment,s),w=!1},d(s){s&&(n(c),n(y)),_(d,s)}}}function fZ(j){let c,$,y,d,w,s,k,V1='This page lists all the utility functions used by <a href="/docs/transformers/pr_30530/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>.',zf,Gr,Vf,Fr,G1=`The output of <a href="/docs/transformers/pr_30530/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> is an instance of a subclass of
<a href="/docs/transformers/pr_30530/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>. This output is a data structure containing all the information returned
by <a href="/docs/transformers/pr_30530/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, but that can also be used as tuple or dictionary.`,Gf,Xr,F1="Here’s an example:",Ff,Rr,Xf,Lr,X1=`The <code>generation_output</code> object is a <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput">GenerateDecoderOnlyOutput</a>, as we can
see in the documentation of that class below, it means it has the following attributes:`,Rf,Sr,R1="<li><code>sequences</code>: the generated sequences of tokens</li> <li><code>scores</code> (optional): the prediction scores of the language modelling head, for each generation step</li> <li><code>hidden_states</code> (optional): the hidden states of the model, for each generation step</li> <li><code>attentions</code> (optional): the attention weights of the model, for each generation step</li>",Lf,Nr,L1=`Here we have the <code>scores</code> since we passed along <code>output_scores=True</code>, but we don’t have <code>hidden_states</code> and
<code>attentions</code> because we didn’t pass <code>output_hidden_states=True</code> or <code>output_attentions=True</code>.`,Sf,Hr,S1=`You can access each attribute as you would usually do, and if that attribute has not been returned by the model, you
will get <code>None</code>. Here for instance <code>generation_output.scores</code> are all the generated prediction scores of the
language modeling head, and <code>generation_output.attentions</code> is <code>None</code>.`,Nf,Er,N1=`When using our <code>generation_output</code> object as a tuple, it only keeps the attributes that don’t have <code>None</code> values.
Here, for instance, it has two elements, <code>loss</code> then <code>logits</code>, so`,Hf,qr,Ef,Dr,H1="will return the tuple <code>(generation_output.sequences, generation_output.scores)</code> for instance.",qf,Qr,E1=`When using our <code>generation_output</code> object as a dictionary, it only keeps the attributes that don’t have <code>None</code>
values. Here, for instance, it has two keys that are <code>sequences</code> and <code>scores</code>.`,Df,Yr,q1="We document here all output types.",Qf,Pr,Yf,ms,Ar,pT,td,D1="Outputs of decoder-only generation models, when using non-beam methods.",Pf,gs,Or,mT,sd,Q1="Outputs of encoder-decoder generation models, when using non-beam methods.",Af,hs,Kr,gT,nd,Y1="Outputs of decoder-only generation models, when using beam methods.",Of,us,ea,hT,rd,P1="Outputs of encoder-decoder generation models, when using beam methods.",Kf,ta,e_,fs,sa,uT,ad,A1=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,t_,_s,na,fT,od,O1="Base class for outputs of decoder-only generation models using greedy search.",s_,bs,ra,_T,ld,K1=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,n_,ys,aa,bT,cd,e$="Base class for outputs of decoder-only generation models using sampling.",r_,Ts,oa,yT,id,t$=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,a_,Ms,la,TT,dd,s$="Base class for outputs of decoder-only generation models using beam search.",o_,vs,ca,MT,pd,n$=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,l_,ws,ia,vT,md,r$="Base class for outputs of decoder-only generation models using beam sample.",c_,ks,da,wT,gd,a$=`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,i_,$s,pa,kT,hd,o$="Base class for outputs of decoder-only generation models using contrastive search.",d_,ma,p_,et,ga,$T,ud,l$="Flax Base class for outputs of decoder-only generation models using sampling.",jT,Is,ha,xT,fd,c$="“Returns a new object replacing the specified fields with new values.",m_,tt,ua,JT,_d,i$="Flax Base class for outputs of decoder-only generation models using greedy search.",UT,zs,fa,ZT,bd,d$="“Returns a new object replacing the specified fields with new values.",g_,st,_a,CT,yd,p$="Flax Base class for outputs of decoder-only generation models using greedy search.",WT,Vs,ba,BT,Td,m$="“Returns a new object replacing the specified fields with new values.",h_,ya,u_,Ta,g$=`A <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> can be used to modify the prediction scores of a language model head for
generation.`,f_,Ma,__,ke,va,IT,Md,h$='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing alternated generation between the two codebooks of Bark.',zT,Gs,VT,vd,wa,b_,S,ka,GT,wd,u$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or ‘null’ prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the <code>guidance_scale</code>.`,FT,kd,f$='See <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">the paper</a> for more information.',XT,Fs,RT,Xs,LT,$d,$a,y_,se,ja,ST,jd,_$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.NoRepeatNGramLogitsProcessor">NoRepeatNGramLogitsProcessor</a>, but applied exclusively to prevent
the repetition of n-grams present in the prompt.`,NT,xd,b$=`It was designed to promote chattiness in a language model, by preventing the generation of n-grams present in
previous conversation rounds.`,HT,Rs,ET,Jd,xa,T_,ne,Ja,qT,Ud,y$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.RepetitionPenaltyLogitsProcessor">RepetitionPenaltyLogitsProcessor</a>, but with an <em>inverse</em> penalty
that is applied to the tokens present in the prompt. In other words, a penalty above 1.0 increases the odds of
selecting tokens that were present in the prompt.`,DT,Zd,T$=`It was designed to avoid hallucination in input-grounded tasks, like summarization. Although originally intended
for encoder-decoder models, it can also be used with decoder-only models like LLMs.`,QT,Ls,YT,Cd,Ua,M_,$e,Za,PT,Wd,M$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs epsilon-sampling, i.e. restricting to tokens with <code>prob &gt;= epsilon</code>. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more information.`,AT,Ss,OT,Bd,Ca,v_,je,Wa,KT,Id,v$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, <code>eta</code>, which is calculated based on a combination of the hyperparameter <code>epsilon</code> and the entropy of
the token probabilities, i.e. <code>eta := min(epsilon, sqrt(epsilon * e^-entropy(probabilities)))</code>. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation
Sampling as Language Model Desmoothing</a> for more information. Note: <code>do_sample</code>
must be set to <code>True</code> for this <code>LogitsProcessor</code> to work.`,eM,Ns,tM,zd,Ba,w_,xe,Ia,sM,Vd,w$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that exponentially increases the score of the <code>eos_token_id</code> after <code>start_index</code> has been
reached. This allows generating shorter sequences without having a hard cutoff, allowing the <code>eos_token</code> to be
predicted in a meaningful position.`,nM,Hs,rM,Gd,za,k_,Je,Va,aM,Fd,k$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the first generated token. Used with encoder-decoder
models.`,oM,Es,lM,Xd,Ga,$_,Ue,Fa,cM,Rd,$$='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',iM,qs,dM,Ld,Xa,j_,N,Ra,pM,Sd,j$='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces diverse beam search.',mM,Nd,x$=`Note that this logits processor is only effective for <code>PreTrainedModel.group_beam_search</code>. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam
Search: Decoding Diverse Solutions from Neural Sequence Models</a> for more
details.`,gM,Hd,J$=`Traditional beam search often generates very similar sequences across different beams.
<code>HammingDiversityLogitsProcessor</code> addresses this by penalizing beams that generate tokens already chosen by other
beams in the same time step.`,hM,Ds,uM,Ed,La,x_,Ze,Sa,fM,qd,U$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that removes all <code>nan</code> and <code>inf</code> values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`,_M,Dd,Z$=`This logits processor has no <code>generate</code> example, as there shouldn’t be a correct combination of flags that warrants
its use.`,bM,Qd,Na,J_,Ce,Ha,yM,Yd,C$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for normalizing the scores using log-softmax. It’s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn’t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`,TM,Qs,MM,Pd,Ea,U_,nt,qa,vM,Ad,W$="Abstract base class for all logit processors that can be applied during generation.",wM,Od,Da,Z_,rt,Qa,kM,Kd,B$=`This class can be used to create a list of <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> to the
inputs.`,$M,ep,Ya,C_,We,Pa,jM,tp,I$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length by setting EOS probability to 0. Note that, for decoder-only models
like most LLMs, the length includes the prompt.`,xM,Ys,JM,sp,Aa,W_,Be,Oa,UM,np,z$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Contrarily to <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.MinLengthLogitsProcessor">MinLengthLogitsProcessor</a>, this processor ignores the prompt.`,ZM,Ps,CM,rp,Ka,B_,H,eo,WM,ap,V$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs min-p, i.e. keeps all tokens that are above a minimum probability, scaled by the
probability of the most likely token. As a result, the filter becomes more agressive in the presence of
high-probability tokens, which is a sign of a confident output that we shouldn’t deviate from.`,BM,op,G$=`Often used together with <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a>. Used as an alternative to <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,IM,lp,F$='Created by @menhguin and @kalomaze (github handles). Code adapted from <a href="https://github.com/oobabooga/text-generation-webui/pull/4449/files" rel="nofollow">this external PR</a>',zM,As,VM,cp,to,I_,re,so,GM,ip,X$='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces that specified sequences will never be selected.',FM,Os,XM,Ks,RM,dp,no,z_,ae,ro,LM,pp,R$=`N-grams are groups of “n” consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: “She runs fast”, the bi-grams (n=2) would be (“she”, “runs”) and (“runs”, “fast”). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores. Note that, for decoder-only models like most LLMs, the
prompt is also considered to obtain the n-grams.
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,SM,en,NM,tn,HM,mp,ao,V_,Ie,oo,EM,gp,L$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity Retrieval</a> for more information.`,qM,sn,DM,hp,lo,G_,oe,co,QM,up,S$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that prevents the repetition of previous tokens through a penalty. This penalty is applied at
most once per token. Note that, for decoder-only models like most LLMs, the considered tokens include the prompt.`,YM,fp,N$=`In the original <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">paper</a>, the authors suggest the use of a penalty of around
1.2 to achieve a good balance between truthful generation and lack of repetition. To penalize and reduce
repetition, use <code>penalty</code> values above 1.0, where a higher value penalizes more strongly. To reward and encourage
repetition, use <code>penalty</code> values between 0.0 and 1.0, where a lower value rewards more strongly.`,PM,nn,AM,_p,io,F_,le,po,OM,bp,H$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`,KM,rn,ev,an,tv,yp,mo,X_,ze,go,sv,Tp,E$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.SuppressTokensAtBeginLogitsProcessor">SuppressTokensAtBeginLogitsProcessor</a> supresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are
not generated at the begining. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,nv,on,rv,Mp,ho,R_,Ve,uo,av,vp,q$=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so
that they are not generated. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,ov,ln,lv,wp,fo,L_,G,_o,cv,kp,D$=`Logits processor that implements watermarking techniques for text generation models.
This class facilitates the application of SynthID text watermarking, a method for embedding imperceptible signals
into generated text to aid in detecting synthetic content. It operates by subtly manipulating the probabilities of
token selection during text generation in a manner that can be reliably recovered later for verification.`,iv,$p,Q$="Key Features:",dv,jp,Y$=`<li><p><strong>State Management:</strong> Maintains internal state to track token sequences and generate watermarking keys
dynamically.</p></li> <li><p><strong>Key Generation:</strong> Computes hashes based on token sequences and watermarking parameters to create unique keys
for each position.</p></li> <li><p><strong>G-Value Sampling:</strong> Employs a pre-computed sampling table to sample watermarking values (g-values) based on
the generated keys.</p></li> <li><p><strong>Score Adjustment:</strong> Applies calculated g-values to modify token probabilities during generation, embedding the
watermark.</p></li> <li><p><strong>Context Repetition Handling:</strong> Incorporates logic to avoid watermarking tokens in repeated contexts,
preserving naturalness.</p></li> <li><p><strong>EOS Token Masking:</strong> Supports masking end-of-sentence tokens to prevent their inclusion in watermarking
calculations.</p></li> <li><p><strong>Utility Functions:</strong> Provides functions to compute g-values directly, check for context repetition, create
EOS token masks, and estimate expected mean g-values.</p></li>`,pv,xp,P$='Refer to paper url: <a href="https://www.nature.com/articles/s41586-024-08025-4" rel="nofollow">https://www.nature.com/articles/s41586-024-08025-4</a> for more details around this.',mv,cn,gv,Jp,bo,S_,ce,yo,hv,Up,A$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens. Often used together with <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,uv,dn,fv,pn,_v,Zp,To,N_,Ge,Mo,bv,Cp,O$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs top-k, i.e. restricting to the k highest probability elements. Often used
together with <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a>.`,yv,mn,Tv,Wp,vo,H_,Fe,wo,Mv,Bp,K$=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.
Often used together with <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,vv,gn,wv,Ip,ko,E_,ie,$o,kv,zp,ej=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that performs typical decoding. Inspired on how humans use language, it prioritizes tokens
whose log probability is close to the entropy of the token probability distribution. This means that the most
likely tokens may be discarded in the process.`,$v,Vp,tj='See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information.',jv,hn,xv,Gp,jo,q_,de,xo,Jv,Fp,sj=`Logits processor for Classifier-Free Guidance (CFG). The processors computes a weighted average across scores
from prompt conditional and prompt unconditional (or negative) logits, parameterized by the <code>guidance_scale</code>.
The unconditional scores are computed internally by prompting <code>model</code> with the <code>unconditional_ids</code> branch.`,Uv,Xp,nj='See <a href="https://arxiv.org/abs/2306.17806" rel="nofollow">the paper</a> for more information.',Zv,un,Cv,Rp,Jo,D_,pe,Uo,Wv,Lp,rj=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that modifies the logits for the generation of timestamps in the transcription. When the input
tokens are at a specific threshold, the processor sets the scores to negative infinity. The processor makes sure
that timestamp tokens appear in pairs, by masking out the logits that would break this pairing pattern. This is
done to maintain the consistency and structure of generated timestamps. It also ensures that when the predicted
probability of sampling any of the timestamp token is greater than any individual non-timestamp token, those
non-timestamp logits are set to negative infinity. This is done to ensure the generation of timestamps over other
potential tokens.`,Bv,Sp,aj='See <a href="https://arxiv.org/abs/2212.04356" rel="nofollow">the paper</a> for more information.',Iv,fn,zv,Np,Zo,Q_,E,Co,Vv,Hp,oj=`Logits processor for watermarking generated text. The processor modifies model output scores by adding a small bias to
randomized set of “green” tokens before generating the next token. “Green” tokens selection process depends on the
<code>seeding_scheme</code> used. The code was based on the <a href="https://github.com/jwkirchenbauer/lm-watermarking/tree/main" rel="nofollow">original repo</a>.`,Gv,Ep,lj='The text generated by this <code>LogitsProcessor</code> can be detected using <code>WatermarkDetector</code>. See <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.WatermarkDetector.__call__"><strong>call</strong>()</a> for details,',Fv,qp,cj='See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">the paper</a> for more information.',Xv,_n,Rv,Dp,Wo,Y_,Bo,P_,at,Io,Lv,Qp,ij='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the first generated token.',Sv,Yp,zo,A_,ot,Vo,Nv,Pp,dj='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',Hv,Ap,Go,O_,lt,Fo,Ev,Op,pj=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>0</code> and all other tokens to
<code>-inf</code> so that they are sampled at their corresponding index.`,qv,Kp,Xo,K_,ct,Ro,Dv,em,mj="Abstract base class for all logit processors that can be applied during generation.",Qv,bn,Lo,Yv,tm,gj="TF method for processing logits.",eb,it,So,Pv,sm,hj=`This class can be used to create a list of <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to the
inputs.`,Av,nm,No,tb,dt,Ho,Ov,rm,uj="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Kv,yn,Eo,ew,am,fj="TF method for warping logits.",sb,pt,qo,tw,om,_j='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',sw,lm,Do,nb,mt,Qo,nw,cm,bj='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces that specified sequences will never be sampled.',rw,im,Yo,rb,gt,Po,aw,dm,yj=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces no repetition of n-grams. See
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,ow,pm,Ao,ab,ht,Oo,lw,mm,Tj='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing an exponential penalty on repeated sequences.',cw,gm,Ko,ob,ut,el,iw,hm,Mj=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TFSuppressTokensAtBeginLogitsProcessor">TFSuppressTokensAtBeginLogitsProcessor</a> suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the begining of the generation.`,dw,um,tl,lb,ft,sl,pw,fm,vj=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,mw,_m,nl,cb,_t,rl,gw,bm,wj='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> for temperature (exponential scaling output probability distribution).',hw,ym,al,ib,bt,ol,uw,Tm,kj='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',fw,Mm,ll,db,yt,cl,_w,vm,$j='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to &lt;= prob_cut_off.',bw,wm,il,pb,dl,mb,Tt,pl,yw,km,jj='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the first generated token.',Tw,$m,ml,gb,Mt,gl,Mw,jm,xj='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',vw,xm,hl,hb,vt,ul,ww,Jm,Jj=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to <code>-inf</code> so that they are sampled at their corresponding index.`,kw,Um,fl,ub,wt,_l,$w,Zm,Uj="Abstract base class for all logit processors that can be applied during generation.",jw,Tn,bl,xw,Cm,Zj="Flax method for processing logits.",fb,kt,yl,Jw,Wm,Cj=`This class can be used to create a list of <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to subsequently process
a <code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to the inputs.`,Uw,Bm,Tl,_b,$t,Ml,Zw,Im,Wj="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Cw,Mn,vl,Ww,zm,Bj="Flax method for warping logits.",bb,jt,wl,Bw,Vm,Ij='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',Iw,Gm,kl,yb,xt,$l,zw,Fm,zj=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> supressing a list of tokens as soon as the <code>generate</code> function starts generating using
<code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are not sampled at the
begining of the generation.`,Vw,Xm,jl,Tb,Jt,xl,Gw,Rm,Vj=`<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> suppressing a list of tokens at each decoding step. The processor will set their log probs
to be <code>-inf</code> so they are not sampled.`,Fw,Lm,Jl,Mb,Ut,Ul,Xw,Sm,Gj='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> for temperature (exponential scaling output probability distribution).',Rw,Nm,Zl,vb,Zt,Cl,Lw,Hm,Fj='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',Sw,Em,Wl,wb,Ct,Bl,Nw,qm,Xj='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',Hw,Dm,Il,kb,Wt,zl,Ew,Qm,Rj=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,qw,Ym,Vl,$b,Gl,jb,Fl,Lj='A <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a> can be used to change when to stop generation (other than EOS token). Please note that this is exclusively available to our PyTorch implementations.',xb,Xe,Xl,Dw,Pm,Sj="Abstract base class for all stopping criteria that can be applied during generation.",Qw,Am,Nj="If your stopping criteria depends on the <code>scores</code> input, make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.",Yw,Om,Rl,Jb,js,Ll,Pw,Km,Sl,Ub,Bt,Nl,Aw,eg,Hj=`This class can be used to stop generation whenever the full generated number of tokens exceeds <code>max_length</code>. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`,Ow,tg,Hl,Zb,It,El,Kw,sg,Ej=`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
<code>initial_time</code>.`,e0,ng,ql,Cb,J,Dl,t0,rg,qj=`This class can be used to stop generation whenever specific string sequences are generated. It preprocesses
the strings together with the tokenizer vocab to find positions where tokens can validly complete the stop strings.`,s0,ag,Dj=`Generation is stopped as soon as a token is generated that completes any of the stop strings.
We want to catch any instance in which the stop string would be present in the decoded output, which means
we must also catch cases with “overhangs” off one or both ends. To make this more concrete, for the stop string
“stop”, any of the following token sequences would trigger the match:`,n0,og,Qj="<li>[“st”, “op”]</li> <li>[“stop”]</li> <li>[“st”, “opera”]</li> <li>[“sto”, “pper”]</li> <li>[“las”, “topper”]</li> <li>[“s”, “to”, “pped”]</li>",r0,lg,Yj=`Note that a match will only be triggered if the stop string is at the end of the generated sequence. In other
words, these sequences will not trigger a match:`,a0,cg,Pj="<li>[“stop”, “at”]</li> <li>[“st”, “op”, “at”]</li> <li>[“st”, “opera”, “tion”]</li>",o0,ig,Aj=`The reason these are not a match is that the stop string does not overlap with the final token. If you can remove
one or more tokens from the end of the sequence without destroying the stop string, then this criterion will not
match that stop string. This is by design; because this check is run after each token is generated, we can’t miss a
valid stop string if one is generated, but we don’t want to halt generation just because the stop string exists
somewhere in the past input_ids.`,l0,dg,Oj=`How is the match actually performed, though? We do it in quite a confusing way, because we want the entire match
process to be compilable with Torch or XLA, which means we cannot use standard string methods. However, it is possible,
with some work, to do string matching with pure tensor operations. We’ll begin by describing the algorithm we use
with standard string operations, and then at the end we’ll explain how this is converted to pure tensor operations.`,c0,pg,Kj=`The key to the algorithm is an observation: Because the stop string must overlap with the end of the token sequence, we can start at
the end of the sequence and work backwards. Specifically, we check that there is an overlap between the start of
the final token and the end of the stop_string, or to put it another way, stop_string[-i:] == token[:i] for
some i > 0. If you look at the positive examples above, you’ll see the last token in all of them fulfills this
property:`,i0,mg,ex="<li>[“st”, “op”] (overlap is “op”, overlap length == 2)</li> <li>[“stop”]  (overlap is “stop”, overlap length == 4)</li> <li>[“st”, “opera”]  (overlap is “op”, overlap length == 2)</li> <li>[“sto”, “pper”]  (overlap is “p”, overlap length == 1)</li> <li>[“las”, “topper”]  (overlap is “top”, overlap length == 3)</li> <li>[“s”, “to”, “pped”]  (overlap is “p”, overlap length == 1)</li>",d0,gg,tx=`It’s impossible to construct a matching sequence that does not have this property (feel free to verify this
yourself). However, although this overlap between the start of the final token and the end of the stop string is
necessary for a match, it is not sufficient. We also need to check that the rest of the token sequence is
consistent with the stop string.`,p0,hg,sx=`How do we do that? Let’s use [“s”, “to”, “pped”] as an example. We know that the final token, “pped”, has an
overlap of 1 with the stop string, “stop”. We then go back to the previous token, “to”. Since we have already
matched 1 character from the stop string, the remainder to check is “sto”. We check that the next token “to”
matches the end of the remainder, which it does. We have now matched 3 characters from the stop string, and the
remainder to match is “s”. We go back to the previous token again, which is also “s”. This is a match, and so
we have matched the entire stop string.`,m0,ug,nx=`How does it work when the tokens run off the start of the stop string, though? Let’s consider the example of
[“las”, “topper”]. The final token, “topper”, has an overlap of 3 with the stop string, “stop”. Therefore,
the remaining stop string to match is “s”. We go back to the previous token, “las”. Because the remainder to
match is just “s”, with length 1, we consider only the final 1 character from the token, which is “s”. This
matches the stop string, and so the entire string is matched.`,g0,fg,rx=`How do we compute these matches with tensor operations, though? Simply: we efficiently precompute the necessary
information for all tokens! For every token, we compute:`,h0,_g,ax="<li>Its overlap with the end of the stop string, if any</li> <li>The positions inside the stop string where the token matches, including matches that run off the start.</li> <li>The total length of the token</li>",u0,bg,ox=`For example, for the token “pped”, we would compute an end overlap of 1, no internal matching positions,
and a length of 4. For the token “to”, we would compute no end overlap, a single internal matching position
of 1 (counting from the end), and a length of 2. For the token “s”, we would compute no end overlap,
a single internal matching position of 3 (again counting from the end) and a length of 1.`,f0,yg,lx=`As long as we have this information, we can execute the algorithm above without any string comparison
operations. We simply perform the following steps:`,_0,Tg,cx="<li>Check if the final token has an end-overlap with the start string</li> <li>Continue backwards, keeping track of how much of the stop string we’ve matched so far</li> <li>At each point, check if the next token has the current position as one of its valid positions</li> <li>Continue until either a match fails, or we completely match the whole stop string</li>",b0,Mg,ix=`Again, consider [“s”, “to”, “pped”] as an example. “pped” has an end overlap of 1, so we can begin a match.
We have matched 1 character so far, so we check that the next token “to”, has 1 as a valid position (again,
counting from the end). It does, so we add the length of “to” to our position tracker. We have now matched
3 characters, so we check that the next token “s” has 3 as a valid position. It does, so we add its length
to the position tracker. The position tracker is now 4, which is the length of the stop string. We have matched the
entire stop string.`,y0,vg,dx=`In the second case, [“las”, “topper”], “topper” has an end overlap of 3, so we can begin a match. We have
matched 3 characters so far, so we check that the next token “las” has 3 as a valid position. It does, because we
allow tokens to match positions that run off the start of the stop string. We add its length to the position
tracker. The position tracker is now 6, which is greater than the length of the stop string! Don’t panic, though -
this also counts as a match of the stop string. We have matched the entire stop string.`,T0,vn,M0,wg,Ql,Wb,zt,Yl,v0,kg,px=`This class can be used to stop generation whenever the “end-of-sequence” token is generated.
By default, it uses the <code>model.generation_config.eos_token_id</code>.`,w0,$g,Pl,Bb,Al,Ib,Ol,mx='A <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.Constraint">Constraint</a> can be used to force the generation to include specific tokens or sequences in the output. Please note that this is exclusively available to our PyTorch implementations.',zb,W,Kl,k0,jg,gx=`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`,$0,xg,hx="All classes that inherit Constraint must follow the requirement that",j0,wn,x0,Jg,ux="will always terminate (halt).",J0,kn,ec,U0,Ug,fx="When called, returns the token(s) that would take this constraint one step closer to being fulfilled.",Z0,$n,tc,C0,Zg,_x="Creates a new instance of this constraint.",W0,jn,sc,B0,Cg,bx="Reads in a token and returns whether it creates progress.",I0,xn,nc,z0,Wg,yx="Returns the number of remaining steps of <code>advance()</code> in order to complete this constraint.",V0,Jn,rc,G0,Bg,Tx=`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`,F0,Un,ac,X0,Ig,Mx="Tests whether this constraint has been properly defined.",R0,Kt,oc,L0,zg,vx=`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes <code>does_advance(self, token_id: int)</code>.`,S0,Vg,wx=`This isn’t to test whether a certain token will advance the progress; it’s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`,Vb,xs,lc,N0,Gg,kx='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.Constraint">Constraint</a> enforcing that an ordered sequence of tokens is included in the output.',Gb,Js,cc,H0,Fg,$x='A special <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.Constraint">Constraint</a> that is fulfilled by fulfilling just one of several constraints.',Fb,Re,ic,E0,Xg,jx="A class for beam scorers to track its progress through a list of constraints.",q0,K,dc,D0,Rg,xx=`The list of tokens to generate such that we can make progress.
By “list” we don’t mean the list of token that will fully fulfill a constraint.`,Q0,Lg,Jx=`Given constraints <code>c_i = {t_ij | j == # of tokens}</code>, If we’re not in the middle of progressing through a
specific constraint <code>c_i</code>, we return:`,Y0,Sg,Ux="<code>[t_k1 for k in indices of unfulfilled constraints]</code>",P0,Ng,Zx=`If we are in the middle of a constraint, then we return:
<code>[t_ij]</code>, where <code>i</code> is the index of the inprogress constraint, <code>j</code> is the next step for the constraint.`,A0,Hg,Cx=`Though we don’t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that’s the only one we’ll return.`,O0,Zn,pc,K0,Eg,Wx="token_ids: the tokens generated thus far to reset the state of the progress through constraints.",Xb,mc,Rb,Le,gc,e2,qg,Bx=`Abstract base class for all beam scorers that are used for <code>~PreTrainedModel.beam_search</code> and
<code>~PreTrainedModel.beam_sample</code>.`,t2,Dg,hc,s2,Qg,uc,Lb,q,fc,n2,Yg,Ix='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing standard beam search decoding.',r2,Pg,zx=`Adapted in part from <a href="https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529" rel="nofollow">Facebook’s XLM beam search
code</a>.`,a2,Ag,Vx=`Reference for the diverse beam search algorithm and implementation <a href="https://github.com/ashwinkalyan/dbs/blob/master/dbs/beam_utils.lua" rel="nofollow">Ashwin Kalyan’s DBS
implementation</a>`,o2,Og,_c,l2,Kg,bc,Sb,Se,yc,c2,eh,Gx='<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing constrained beam search decoding.',i2,th,Tc,d2,sh,Mc,Nb,vc,Hb,F,wc,p2,nh,Fx="Simple text streamer that prints the token(s) to stdout as soon as entire words are formed.",m2,Cn,g2,Wn,h2,Bn,kc,u2,rh,Xx="Flushes any remaining cache and prints a newline to stdout.",f2,In,$c,_2,ah,Rx="Prints the new text to stdout. If the stream is ending, also prints a newline.",b2,zn,jc,y2,oh,Lx="Receives tokens, decodes them, and prints them to stdout as soon as they form entire words.",Eb,me,xc,T2,lh,Sx=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from acessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`,M2,Vn,v2,Gn,w2,Fn,Jc,k2,ch,Nx="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",qb,Uc,Db,Vt,Zc,$2,ih,Hx="Base, abstract class for all caches. The actual data structure is specific to each subclass.",j2,Xn,Cc,x2,dh,Ex="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",Qb,Gt,Wc,J2,ph,qx="Base class for cache configs",U2,Rn,Bc,Z2,mh,Dx=`Updates attributes of this class instance with attributes from <code>kwargs</code> if they match existing attributes,
returning all the unused kwargs.`,Yb,Ft,Ic,C2,gh,Qx="Configuration class for quantized cache settings.",W2,Ln,zc,B2,hh,Yx="Validates if the arguments passed are correct",Pb,I,Vc,I2,uh,Px="A cache that grows dynamically as more tokens are generated. This is the default for generative models.",z2,fh,Ax=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,V2,Sn,G2,Nn,Gc,F2,_h,Ox="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",X2,Hn,Fc,R2,bh,Kx="Returns the sequence length of the cached states. A layer index can be optionally passed.",L2,En,Xc,S2,yh,eJ="Reorders the cache for beam search, given the selected beam indices.",N2,qn,Rc,H2,Th,tJ=`Converts the <code>DynamicCache</code> instance into the its equivalent in the legacy cache format. Used for
backward compatibility.`,E2,Dn,Lc,q2,Mh,sJ=`Converts a cache in the legacy cache format into an equivalent <code>DynamicCache</code>. Used for
backward compatibility.`,Ab,D,Sc,D2,vh,nJ=`A quantizer cache similar to what is described in the <a href="https://arxiv.org/abs/2402.02750" rel="nofollow">KIVI: A Tuning-Free Asymmetric 2bit Quantization for KV Cache paper</a>.
It allows the model to generate longer sequence length without allocating too much memory for Key and Value cache by applying quantization.`,Q2,wh,rJ=`The cache has two types of storage, one for original precision and one for the quantized cache. A <code>residual length</code> is set as a maximum capacity for the
original precision cache. When the length goes beyond maximum capacity, the original precision cache is discarded and moved into the quantized cache. The
quantization is done per-channel with a set <code>q_group_size</code> for both Keys and Values, in contrast to what was described in the paper.`,Y2,kh,aJ=`It stores Keys and Values a list of quantized tensors (tuples in case we need to store metadata), one for each layer. Additionally, it stores the Key and
Value in original precision states as a list of tensors, one for each layer. The size of each tensor
is <code>[batch_size, num_heads, seq_len - residual_length, head_dim]</code>`,P2,$h,Nc,A2,Qn,Hc,O2,jh,oJ="Returns the sequence length of the cached states. A layer index can be optionally passed.",Ob,Xt,Ec,K2,xh,lJ="Quantized Cache class that uses <code>quanto</code> as a backend to perform quantization. Current implementation supports <code>int2</code> and <code>int4</code> dtypes only.",ek,Yn,Kb,Rt,qc,tk,Jh,cJ="Quantized Cache class that uses <code>HQQ</code> as a backend to perform quantization. Current implementation supports <code>int2</code>, <code>int4</code>, <code>int8</code> dtypes.",sk,Pn,ey,X,Dc,nk,Uh,iJ=`A cache that as described in the <a href="https://arxiv.org/abs/2309.17453" rel="nofollow">Attention Sinks paper</a>. It allows the model to
generate beyond the length of its context window, without losing fluency in the conversation. As it discards past
tokens, the model will lose the ability to generate tokens that depend on the context that was discarded.`,rk,Zh,dJ=`It stores the Key and Value states as a list of tensors, one for each layer. The expected shape for each tensor is
<code>[batch_size, num_heads, seq_len, head_dim]</code>.`,ak,An,ok,On,Qc,lk,Ch,pJ="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",ck,Kn,Yc,ik,Wh,mJ="Returns the sequence length of the cached states. A layer index can be optionally passed.",dk,er,Pc,pk,Bh,gJ="Reorders the cache for beam search, given the selected beam indices.",ty,Q,Ac,mk,Ih,hJ=`A drop-in replacement for DynamicCache that conserves GPU memory at the expense of more CPU memory.
Useful for generating from models with very long context.`,gk,zh,uJ=`In addition to the default CUDA stream, where all forward() computations happen,
this class uses another stream, the prefetch stream, which it creates itself.
Since scheduling of operations on separate streams happens independently, this class uses
the prefetch stream to asynchronously prefetch the KV cache of layer k+1 when layer k is executing.
The movement of the layer k-1 cache to the CPU is handled by the default stream as a simple way to
ensure the eviction is scheduled after all computations on that cache are finished.`,hk,tr,Oc,uk,Vh,fJ="Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.",fk,sr,Kc,_k,Gh,_J="Starts prefetching the next layer cache",bk,nr,ei,yk,Fh,bJ="Moves the previous layer cache to the CPU",sy,Y,ti,Tk,Xh,yJ="Static Cache class to be used with <code>torch.compile(model)</code> and <code>torch.export()</code>.",Mk,rr,vk,ar,si,wk,Rh,TJ=`Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.
It is VERY important to index using a tensor, otherwise you introduce a copy to the device.`,kk,or,ni,$k,Lh,MJ="Returns the sequence length of the cached states that were seen by the model.",jk,lr,ri,xk,Sh,vJ="Resets the cache values while preserving the objects",ny,P,ai,Jk,Nh,wJ=`Static cache class to be used with <code>torch.compile(model)</code> that offloads to the CPU or
another device.`,Uk,cr,Zk,ir,oi,Ck,Hh,kJ=`Updates the cache with the new <code>key_states</code> and <code>value_states</code> for the layer <code>layer_idx</code>.
It is VERY important to index using a tensor, otherwise you introduce a copy to the device.`,Wk,dr,li,Bk,Eh,$J="Returns the sequence length of the cached states that were seen by the model.",Ik,pr,ci,zk,qh,jJ="Resets the cache values while preserving the objects.",ry,A,ii,Vk,Dh,xJ=`Hybrid Cache class to be used with <code>torch.compile</code> for Gemma2 models that alternate between a local sliding window attention
and global attention in every other layer. Under the hood, Hybrid Cache leverages [“SlidingWindowCache”] for sliding window attention
and [“StaticCache”] for global attention. For more information, see the documentation of each subcomponeent cache class.`,Gk,mr,Fk,Qh,di,Xk,Yh,pi,Rk,gr,mi,Lk,Ph,JJ="Resets the cache values while preserving the objects",ay,z,gi,Sk,Ah,UJ=`Sliding Window Cache class to be used with <code>torch.compile</code> for models like Mistral that support sliding window attention.
Every time when we try to update the cache, we compute the <code>indices</code> based on <code>cache_position &gt;= self.config.sliding_window - 1</code>,
if true(which means the cache can not hold all the old key value states and new states together because of the sliding window constraint),
we need to do a cycle shift based on <code>indices</code> to replace the oldest states by the new key value states passed in.`,Nk,Oh,ZJ="The <code>to_shift</code> is only true once we are above sliding_window. Thus with <code>sliding_window==64</code>:",Hk,Kh,CJ=`indices = (slicing + to_shift[-1].int()-1) % self.config.sliding_window
tensor([ 1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
55, 56, 57, 58, 59, 60, 61, 62, 63,  0])`,Ek,eu,WJ="We overwrite the cache using these, then we always write at cache_position (clamped to <code>sliding_window</code>)",qk,hr,Dk,tu,hi,Qk,su,ui,oy,V,fi,Yk,nu,BJ=`Base, abstract class for all encoder-decoder caches. Can be used to hold combinations of self-attention and
cross-attention caches.`,Pk,ur,Ak,fr,_i,Ok,ru,IJ="Returns the sequence length of the cached states. A layer index can be optionally passed.",Kk,_r,bi,e1,au,zJ="Converts the <code>EncoderDecoderCache</code> instance into  its equivalent in the legacy cache format.",t1,br,yi,s1,ou,VJ="Converts a cache in the legacy cache format into an equivalent <code>EncoderDecoderCache</code>.",n1,lu,Ti,r1,yr,Mi,a1,cu,GJ="Reorders the cache for beam search, given the selected beam indices.",ly,O,vi,o1,iu,FJ="Cache for mamba model which does not have attention mechanism and key value states.",l1,Tr,c1,du,wi,i1,pu,ki,d1,mu,$i,cy,ji,iy,ge,xi,p1,gu,XJ=`Class that holds arguments for watermark generation and should be passed into <code>GenerationConfig</code> during <code>generate</code>.
See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">this paper</a> for more details on the arguments.`,m1,hu,RJ="Accepts the following keys:",g1,uu,LJ=`<li>greenlist_ratio (<code>float</code>):
Used for watermarking. The ratio of “green” tokens used to the vocabulary size. Defaults to 0.25.</li> <li>bias (<code>float</code>):
Used with watermarking. The bias added to the selected “green” tokens’ logits. Defaults to 2.0.</li> <li>hashing_key (<code>int</code>):
Hashing key used for watermarking. Defaults to 15485863 (the millionth prime).</li> <li>seeding_scheme (<code>str</code>):
Algorithm to use for watermarking. Accepts values:<ul><li>“lefthash” (default): “green” tokens selection depend on the last token (Algorithm 2 from the paper)</li> <li>“selfhash”: “green” tokens selection depends on the current token itself (Algorithm 3 from the paper)
The downside of this scheme is that it considers all possible next tokens and can be slower than “lefthash”.</li></ul></li> <li>context_width(<code>int</code>):
The context length of previous tokens to use in seeding. Higher context length makes watermarking more robust.</li>`,h1,Mr,Ji,u1,fu,SJ="Call self as a function.",dy,he,Ui,f1,_u,NJ=`Detector for detection of watermark generated text. The detector needs to be given the exact same settings that were
given during text generation to replicate the watermark greenlist generation and so detect the watermark. This includes
the correct device that was used during text generation, the correct watermarking arguments and the correct tokenizer vocab size.
The code was based on the <a href="https://github.com/jwkirchenbauer/lm-watermarking/tree/main" rel="nofollow">original repo</a>.`,_1,bu,HJ='See <a href="https://arxiv.org/abs/2306.04634" rel="nofollow">the paper</a> for more information.',b1,vr,y1,wr,Zi,T1,yu,EJ="ma",py,Lt,Ci,M1,Tu,qJ=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.BayesianDetectorModel">BayesianDetectorModel</a>. It is used to
instantiate a Bayesian Detector model according to the specified arguments.`,v1,Mu,DJ=`Configuration objects inherit from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_30530/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,my,R,Wi,w1,vu,QJ="Bayesian classifier for watermark detection.",k1,wu,YJ=`This detector uses Bayes’ rule to compute a watermarking score, which is the sigmoid of the log of ratio of the
posterior probabilities P(watermarked|g_values) and P(unwatermarked|g_values). Please see the section on
BayesianScore in the paper for further details.
Paper URL: <a href="https://www.nature.com/articles/s41586-024-08025-4" rel="nofollow">https://www.nature.com/articles/s41586-024-08025-4</a>`,$1,ku,PJ=`Note that this detector only works with non-distortionary Tournament-based watermarking using the Bernoulli(0.5)
g-value distribution.`,j1,$u,AJ=`This model inherits from <a href="/docs/transformers/pr_30530/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,x1,ju,OJ=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,J1,kr,Bi,U1,xu,KJ="Computes the watermarked posterior P(watermarked|g_values).",gy,St,Ii,Z1,Ju,eU=`Class that holds arguments for watermark generation and should be passed into <code>GenerationConfig</code> during <code>generate</code>.
See <a href="https://www.nature.com/articles/s41586-024-08025-4" rel="nofollow">this paper</a> for more details on the arguments.`,C1,$r,hy,ue,zi,W1,Uu,tU="SynthID text watermark detector class.",B1,Zu,sU=`This class has to be initialized with the trained bayesian detector module check script
in examples/synthid_text/detector_training.py for example in training/saving/loading this
detector module. The folder also showcases example use case of this detector.`,I1,jr,z1,Cu,Vi,uy,Gi,fy,bf,_y;return w=new ye({props:{title:"Utilities for Generation",local:"utilities-for-generation",headingTag:"h1"}}),Gr=new ye({props:{title:"Generate Outputs",local:"generate-outputs",headingTag:"h2"}}),Rr=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBHUFQyTE1IZWFkTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiklMEFtb2RlbCUyMCUzRCUyMEdQVDJMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjBhbmQlMjAlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbmVyYXRpb25fb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, GPT2LMHeadModel

tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute and &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generation_output = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)`,wrap:!1}}),qr=new U({props:{code:"Z2VuZXJhdGlvbl9vdXRwdXQlNUIlM0EyJTVE",highlighted:'generation_output[:<span class="hljs-number">2</span>]',wrap:!1}}),Pr=new ye({props:{title:"PyTorch",local:"transformers.generation.GenerateDecoderOnlyOutput",headingTag:"h3"}}),Ar=new v({props:{name:"class transformers.generation.GenerateDecoderOnlyOutput",anchor:"transformers.generation.GenerateDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"logits",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[typing.Tuple[torch.FloatTensor]]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/utils.py#L119"}}),Or=new v({props:{name:"class transformers.generation.GenerateEncoderDecoderOutput",anchor:"transformers.generation.GenerateEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"logits",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[typing.Tuple[torch.FloatTensor]]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/utils.py#L155"}}),Kr=new v({props:{name:"class transformers.generation.GenerateBeamDecoderOnlyOutput",anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"logits",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[typing.Tuple[torch.FloatTensor]]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/utils.py#L203"}}),ea=new v({props:{name:"class transformers.generation.GenerateBeamEncoderDecoderOutput",anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"logits",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[typing.Tuple[torch.FloatTensor]]]] = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.logits",description:`<strong>logits</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_logits=True</code>) &#x2014;
Unprocessed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"logits"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code>) &#x2014;
Returns the model cache, used to speed up decoding. Different models have a different cache format, check
the model&#x2019;s documentation. Usually, a <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.Cache">Cache</a> instance.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/utils.py#L247"}}),ta=new ye({props:{title:"TensorFlow",local:"transformers.generation.TFGreedySearchEncoderDecoderOutput",headingTag:"h3"}}),sa=new v({props:{name:"class transformers.generation.TFGreedySearchEncoderDecoderOutput",anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_utils.py#L85"}}),na=new v({props:{name:"class transformers.generation.TFGreedySearchDecoderOnlyOutput",anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_utils.py#L57"}}),ra=new v({props:{name:"class transformers.generation.TFSampleEncoderDecoderOutput",anchor:"transformers.generation.TFSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_utils.py#L155"}}),aa=new v({props:{name:"class transformers.generation.TFSampleDecoderOnlyOutput",anchor:"transformers.generation.TFSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_utils.py#L127"}}),oa=new v({props:{name:"class transformers.generation.TFBeamSearchEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. <code>Tuple of </code>tf.Tensor<code>with up to</code>max_new_tokens<code>elements (one element for each generated token), with each tensor of shape</code>(batch_size*num_beams, config.vocab_size)\`.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_utils.py#L232"}}),la=new v({props:{name:"class transformers.generation.TFBeamSearchDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_utils.py#L197"}}),ca=new v({props:{name:"class transformers.generation.TFBeamSampleEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_utils.py#L317"}}),ia=new v({props:{name:"class transformers.generation.TFBeamSampleDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.tensor.Tensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_utils.py#L282"}}),da=new v({props:{name:"class transformers.generation.TFContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_attentions",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"decoder_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"decoder_hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_utils.py#L393"}}),pa=new v({props:{name:"class transformers.generation.TFContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": typing.Optional[typing.Tuple[tensorflow.python.framework.tensor.Tensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[typing.Tuple[tensorflow.python.framework.tensor.Tensor]]] = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_utils.py#L366"}}),ma=new ye({props:{title:"FLAX",local:"transformers.generation.FlaxSampleOutput",headingTag:"h3"}}),ga=new v({props:{name:"class transformers.generation.FlaxSampleOutput",anchor:"transformers.generation.FlaxSampleOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxSampleOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_utils.py#L69"}}),ha=new v({props:{name:"replace",anchor:"transformers.generation.FlaxSampleOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/flax/struct.py#L111"}}),ua=new v({props:{name:"class transformers.generation.FlaxGreedySearchOutput",anchor:"transformers.generation.FlaxGreedySearchOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxGreedySearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_utils.py#L55"}}),fa=new v({props:{name:"replace",anchor:"transformers.generation.FlaxGreedySearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/flax/struct.py#L111"}}),_a=new v({props:{name:"class transformers.generation.FlaxBeamSearchOutput",anchor:"transformers.generation.FlaxBeamSearchOutput",parameters:[{name:"sequences",val:": Array = None"},{name:"scores",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxBeamSearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"},{anchor:"transformers.generation.FlaxBeamSearchOutput.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size,)</code>) &#x2014;
The scores (log probabilities) of the generated sequences.`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_utils.py#L83"}}),ba=new v({props:{name:"replace",anchor:"transformers.generation.FlaxBeamSearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/flax/struct.py#L111"}}),ya=new ye({props:{title:"LogitsProcessor",local:"logitsprocessor",headingTag:"h2"}}),Ma=new ye({props:{title:"PyTorch",local:"transformers.AlternatingCodebooksLogitsProcessor",headingTag:"h3"}}),va=new v({props:{name:"class transformers.AlternatingCodebooksLogitsProcessor",anchor:"transformers.AlternatingCodebooksLogitsProcessor",parameters:[{name:"input_start_len",val:": int"},{name:"semantic_vocab_size",val:": int"},{name:"codebook_size",val:": int"}],parametersDescription:[{anchor:"transformers.AlternatingCodebooksLogitsProcessor.input_start_len",description:`<strong>input_start_len</strong> (<code>int</code>) &#x2014;
The length of the initial input sequence.`,name:"input_start_len"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.semantic_vocab_size",description:`<strong>semantic_vocab_size</strong> (<code>int</code>) &#x2014;
Vocabulary size of the semantic part, i.e number of tokens associated to the semantic vocabulary.`,name:"semantic_vocab_size"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>) &#x2014;
Number of tokens associated to the codebook.`,name:"codebook_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L2131"}}),Gs=new Vr({props:{warning:!0,$$slots:{default:[_3]},$$scope:{ctx:j}}}),wa=new v({props:{name:"__call__",anchor:"transformers.AlternatingCodebooksLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L2160"}}),ka=new v({props:{name:"class transformers.ClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:""}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (float) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L2067"}}),Fs=new Vr({props:{warning:!0,$$slots:{default:[b3]},$$scope:{ctx:j}}}),Xs=new Z({props:{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[y3]},$$scope:{ctx:j}}}),$a=new v({props:{name:"__call__",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L2115",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ja=new v({props:{name:"class transformers.EncoderNoRepeatNGramLogitsProcessor",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor",parameters:[{name:"encoder_ngram_size",val:": int"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_ngram_size",description:`<strong>encoder_ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur within the encoder input ids.`,name:"encoder_ngram_size"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>int</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L981"}}),Rs=new Z({props:{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.example",$$slots:{default:[T3]},$$scope:{ctx:j}}}),xa=new v({props:{name:"__call__",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1030",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ja=new v({props:{name:"class transformers.EncoderRepetitionPenaltyLogitsProcessor",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 rewards prompt tokens. Between 0.0
and 1.0 penalizes prompt tokens.`,name:"penalty"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The encoder_input_ids that should be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L362"}}),Ls=new Z({props:{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.example",$$slots:{default:[M3]},$$scope:{ctx:j}}}),Ua=new v({props:{name:"__call__",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L406",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Za=new v({props:{name:"class transformers.EpsilonLogitsWarper",anchor:"transformers.EpsilonLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
If set to &gt; 0, only the most tokens with probabilities <code>epsilon</code> or higher are kept for generation.`,name:"epsilon"},{anchor:"transformers.EpsilonLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.EpsilonLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L702"}}),Ss=new Z({props:{anchor:"transformers.EpsilonLogitsWarper.example",$$slots:{default:[v3]},$$scope:{ctx:j}}}),Ca=new v({props:{name:"__call__",anchor:"transformers.EpsilonLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EpsilonLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L757",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Wa=new v({props:{name:"class transformers.EtaLogitsWarper",anchor:"transformers.EtaLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
A float value in the range (0, 1). Hyperparameter used to calculate the dynamic cutoff value, <code>eta</code>. The
suggested values from the paper ranges from 3e-4 to 4e-3 depending on the size of the model.`,name:"epsilon"},{anchor:"transformers.EtaLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All values that are found to be below the dynamic cutoff value, <code>eta</code>, are set to this float value. This
parameter is useful when logits need to be modified for very low probability tokens that should be excluded
from generation entirely.`,name:"filter_value"},{anchor:"transformers.EtaLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Specifies the minimum number of tokens that must be kept for generation, regardless of their probabilities.
For example, if <code>min_tokens_to_keep</code> is set to 1, at least one token will always be kept for generation,
even if all tokens have probabilities below the cutoff <code>eta</code>.`,name:"min_tokens_to_keep"},{anchor:"transformers.EtaLogitsWarper.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L771"}}),Ns=new Z({props:{anchor:"transformers.EtaLogitsWarper.example",$$slots:{default:[w3]},$$scope:{ctx:j}}}),Ba=new v({props:{name:"__call__",anchor:"transformers.EtaLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EtaLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L840",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ia=new v({props:{name:"class transformers.ExponentialDecayLengthPenalty",anchor:"transformers.ExponentialDecayLengthPenalty",parameters:[{name:"exponential_decay_length_penalty",val:": typing.Tuple[int, float]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"},{name:"input_ids_seq_length",val:": int"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>) &#x2014;
This tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty
starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.ExponentialDecayLengthPenalty.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.ExponentialDecayLengthPenalty.input_ids_seq_length",description:`<strong>input_ids_seq_length</strong> (<code>int</code>) &#x2014;
The length of the input sequence.`,name:"input_ids_seq_length"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1643"}}),Hs=new Z({props:{anchor:"transformers.ExponentialDecayLengthPenalty.example",$$slots:{default:[k3]},$$scope:{ctx:j}}}),za=new v({props:{name:"__call__",anchor:"transformers.ExponentialDecayLengthPenalty.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1729",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Va=new v({props:{name:"class transformers.ForcedBOSTokenLogitsProcessor",anchor:"transformers.ForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1521"}}),Es=new Z({props:{anchor:"transformers.ForcedBOSTokenLogitsProcessor.example",$$slots:{default:[$3]},$$scope:{ctx:j}}}),Ga=new v({props:{name:"__call__",anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1556",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Fa=new v({props:{name:"class transformers.ForcedEOSTokenLogitsProcessor",anchor:"transformers.ForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1566"}}),qs=new Z({props:{anchor:"transformers.ForcedEOSTokenLogitsProcessor.example",$$slots:{default:[j3]},$$scope:{ctx:j}}}),Xa=new v({props:{name:"__call__",anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1612",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ra=new v({props:{name:"class transformers.HammingDiversityLogitsProcessor",anchor:"transformers.HammingDiversityLogitsProcessor",parameters:[{name:"diversity_penalty",val:": float"},{name:"num_beams",val:": int"},{name:"num_beam_groups",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. A higher <code>diversity_penalty</code> will enforce greater diversity among the beams. Adjusting
this value can help strike a balance between diversity and natural likelihood.`,name:"diversity_penalty"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1385"}}),Ds=new Z({props:{anchor:"transformers.HammingDiversityLogitsProcessor.example",$$slots:{default:[x3]},$$scope:{ctx:j}}}),La=new v({props:{name:"__call__",anchor:"transformers.HammingDiversityLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"current_tokens",val:": LongTensor"},{name:"beam_group_idx",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.current_tokens",description:`<strong>current_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the tokens selected by the other
beam groups in the current generation step.`,name:"current_tokens"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.beam_group_idx",description:`<strong>beam_group_idx</strong> (<code>int</code>) &#x2014;
The index of the beam group currently being processed.`,name:"beam_group_idx"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1472",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Sa=new v({props:{name:"class transformers.InfNanRemoveLogitsProcessor",anchor:"transformers.InfNanRemoveLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1622"}}),Na=new v({props:{name:"__call__",anchor:"transformers.InfNanRemoveLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1631",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ha=new v({props:{name:"class transformers.LogitNormalization",anchor:"transformers.LogitNormalization",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1744"}}),Qs=new Z({props:{anchor:"transformers.LogitNormalization.example",$$slots:{default:[J3]},$$scope:{ctx:j}}}),Ea=new v({props:{name:"__call__",anchor:"transformers.LogitNormalization.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitNormalization.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitNormalization.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1775",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),qa=new v({props:{name:"class transformers.LogitsProcessor",anchor:"transformers.LogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L45"}}),Da=new v({props:{name:"__call__",anchor:"transformers.LogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Qa=new v({props:{name:"class transformers.LogitsProcessorList",anchor:"transformers.LogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L71"}}),Ya=new v({props:{name:"__call__",anchor:"transformers.LogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.LogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional kwargs that are specific to a logits processor.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L78",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Pa=new v({props:{name:"class transformers.MinLengthLogitsProcessor",anchor:"transformers.MinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.MinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.MinLengthLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L109"}}),Ys=new Z({props:{anchor:"transformers.MinLengthLogitsProcessor.example",$$slots:{default:[U3]},$$scope:{ctx:j}}}),Aa=new v({props:{name:"__call__",anchor:"transformers.MinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L160",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Oa=new v({props:{name:"class transformers.MinNewTokensLengthLogitsProcessor",anchor:"transformers.MinNewTokensLengthLogitsProcessor",parameters:[{name:"prompt_length_to_skip",val:": int"},{name:"min_new_tokens",val:": int"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"},{name:"device",val:": str = 'cpu'"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.prompt_length_to_skip",description:`<strong>prompt_length_to_skip</strong> (<code>int</code>) &#x2014;
The input tokens length. Not a valid argument when used with <code>generate</code> as it will automatically assign the
input length.`,name:"prompt_length_to_skip"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>) &#x2014;
The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_new_tokens"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device to allocate the tensors.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L170"}}),Ps=new Z({props:{anchor:"transformers.MinNewTokensLengthLogitsProcessor.example",$$slots:{default:[Z3]},$$scope:{ctx:j}}}),Ka=new v({props:{name:"__call__",anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L230",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),eo=new v({props:{name:"class transformers.MinPLogitsWarper",anchor:"transformers.MinPLogitsWarper",parameters:[{name:"min_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.MinPLogitsWarper.min_p",description:`<strong>min_p</strong> (<code>float</code>) &#x2014;
Minimum token probability, which will be scaled by the probability of the most likely token. It must be a
value between 0 and 1. Typical values are in the 0.01-0.2 range, comparably selective as setting <code>top_p</code> in
the 0.99-0.8 range (use the opposite of normal <code>top_p</code> values).`,name:"min_p"},{anchor:"transformers.MinPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.MinPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L537"}}),As=new Z({props:{anchor:"transformers.MinPLogitsWarper.example",$$slots:{default:[C3]},$$scope:{ctx:j}}}),to=new v({props:{name:"__call__",anchor:"transformers.MinPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L594"}}),so=new v({props:{name:"class transformers.NoBadWordsLogitsProcessor",anchor:"transformers.NoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated.`,name:"bad_words_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>, <em>optional</em>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1225"}}),Os=new Vr({props:{$$slots:{default:[W3]},$$scope:{ctx:j}}}),Ks=new Z({props:{anchor:"transformers.NoBadWordsLogitsProcessor.example",$$slots:{default:[B3]},$$scope:{ctx:j}}}),no=new v({props:{name:"__call__",anchor:"transformers.NoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1123",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ro=new v({props:{name:"class transformers.NoRepeatNGramLogitsProcessor",anchor:"transformers.NoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L922"}}),en=new Vr({props:{$$slots:{default:[I3]},$$scope:{ctx:j}}}),tn=new Z({props:{anchor:"transformers.NoRepeatNGramLogitsProcessor.example",$$slots:{default:[z3]},$$scope:{ctx:j}}}),ao=new v({props:{name:"__call__",anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L969",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),oo=new v({props:{name:"class transformers.PrefixConstrainedLogitsProcessor",anchor:"transformers.PrefixConstrainedLogitsProcessor",parameters:[{name:"prefix_allowed_tokens_fn",val:": typing.Callable[[int, torch.Tensor], typing.List[int]]"},{name:"num_beams",val:": int"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>) &#x2014;
This function constraints the beam search to allowed tokens only at each step. This function takes 2
arguments <code>inputs_ids</code> and the batch ID <code>batch_id</code>. It has to return a list with the allowed tokens for the
next generation step conditioned on the previously generated tokens <code>inputs_ids</code> and the batch ID
<code>batch_id</code>.`,name:"prefix_allowed_tokens_fn"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1316"}}),sn=new Z({props:{anchor:"transformers.PrefixConstrainedLogitsProcessor.example",$$slots:{default:[V3]},$$scope:{ctx:j}}}),lo=new v({props:{name:"__call__",anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1367",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),co=new v({props:{name:"class transformers.RepetitionPenaltyLogitsProcessor",anchor:"transformers.RepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 penalizes previously generated
tokens. Between 0.0 and 1.0 rewards previously generated tokens.`,name:"penalty"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L308"}}),nn=new Z({props:{anchor:"transformers.RepetitionPenaltyLogitsProcessor.example",$$slots:{default:[G3]},$$scope:{ctx:j}}}),io=new v({props:{name:"__call__",anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L351",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),po=new v({props:{name:"class transformers.SequenceBiasLogitsProcessor",anchor:"transformers.SequenceBiasLogitsProcessor",parameters:[{name:"sequence_bias",val:": typing.List[typing.List[typing.Union[typing.List[int], float]]]"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.sequence_bias",description:`<strong>sequence_bias</strong> (<code>List[List[Union[List[int], float]]]</code>) &#x2014;
List of lists that maps a sequence of tokens to its bias term (e.g. <code>[[[10, 45], -2.0], [[64], -7.5]]</code>). Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. If a sequence has a length of 1, its bias
will always be applied. Otherwise, the bias will only be applied if the sequence in question is about to be
completed (in the token selection step after this processor is applied).`,name:"sequence_bias"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1050"}}),rn=new Vr({props:{$$slots:{default:[F3]},$$scope:{ctx:j}}}),an=new Z({props:{anchor:"transformers.SequenceBiasLogitsProcessor.example",$$slots:{default:[X3]},$$scope:{ctx:j}}}),mo=new v({props:{name:"__call__",anchor:"transformers.SequenceBiasLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1123",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),go=new v({props:{name:"class transformers.SuppressTokensAtBeginLogitsProcessor",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""},{name:"device",val:": str = 'cpu'"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1781"}}),on=new Z({props:{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.example",$$slots:{default:[R3]},$$scope:{ctx:j}}}),ho=new v({props:{name:"__call__",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1823",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),uo=new v({props:{name:"class transformers.SuppressTokensLogitsProcessor",anchor:"transformers.SuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""},{name:"device",val:": str = 'cpu'"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1834"}}),ln=new Z({props:{anchor:"transformers.SuppressTokensLogitsProcessor.example",$$slots:{default:[L3]},$$scope:{ctx:j}}}),fo=new v({props:{name:"__call__",anchor:"transformers.SuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1866",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),_o=new v({props:{name:"class transformers.SynthIDTextWatermarkLogitsProcessor",anchor:"transformers.SynthIDTextWatermarkLogitsProcessor",parameters:[{name:"ngram_len",val:": int"},{name:"keys",val:": typing.List[int]"},{name:"sampling_table_size",val:": int"},{name:"sampling_table_seed",val:": int"},{name:"context_history_size",val:": int"},{name:"device",val:": device"},{name:"skip_first_ngram_calls",val:": bool = False"},{name:"debug_mode",val:": bool = False"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.ngram_len",description:`<strong>ngram_len</strong> (<code>int</code>) &#x2014;
Ngram length.`,name:"ngram_len"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.keys",description:`<strong>keys</strong> (<code>List[int]</code>) &#x2014;
A sequence of watermarking keys, one for each depth.`,name:"keys"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.sampling_table_size",description:`<strong>sampling_table_size</strong> (<code>int</code>) &#x2014;
Size of the sampling table.`,name:"sampling_table_size"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.sampling_table_seed",description:`<strong>sampling_table_seed</strong> (<code>int</code>) &#x2014;
Random seed to generate the sampling table.`,name:"sampling_table_seed"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.context_history_size",description:`<strong>context_history_size</strong> (<code>int</code>) &#x2014;
Size of the tensor to keep track of seen contexts.`,name:"context_history_size"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Device to use.`,name:"device"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.skip_first_ngram_calls",description:`<strong>skip_first_ngram_calls</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip first ngram calls.`,name:"skip_first_ngram_calls"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.debug_mode",description:`<strong>debug_mode</strong> (<code>bool</code>, optional, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Logits are modified to uniform one got before watermarking modification is applied. This is to test the
implementation.`,name:"debug_mode"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L2514"}}),cn=new Z({props:{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.example",$$slots:{default:[S3]},$$scope:{ctx:j}}}),bo=new v({props:{name:"__call__",anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SynthIDTextWatermarkLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L2652",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),yo=new v({props:{name:"class transformers.TemperatureLogitsWarper",anchor:"transformers.TemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
Strictly positive float value used to modulate the logits distribution. A value smaller than <code>1</code> decreases
randomness (and vice versa), with <code>0</code> being equivalent to shifting all probability mass to the most likely
token.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L242"}}),dn=new Vr({props:{$$slots:{default:[N3]},$$scope:{ctx:j}}}),pn=new Z({props:{anchor:"transformers.TemperatureLogitsWarper.example",$$slots:{default:[H3]},$$scope:{ctx:j}}}),To=new v({props:{name:"__call__",anchor:"transformers.TemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TemperatureLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L302",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Mo=new v({props:{name:"class transformers.TopKLogitsWarper",anchor:"transformers.TopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L484"}}),mn=new Z({props:{anchor:"transformers.TopKLogitsWarper.example",$$slots:{default:[E3]},$$scope:{ctx:j}}}),vo=new v({props:{name:"__call__",anchor:"transformers.TopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopKLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L528",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),wo=new v({props:{name:"class transformers.TopPLogitsWarper",anchor:"transformers.TopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L417"}}),gn=new Z({props:{anchor:"transformers.TopPLogitsWarper.example",$$slots:{default:[q3]},$$scope:{ctx:j}}}),ko=new v({props:{name:"__call__",anchor:"transformers.TopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopPLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L468",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$o=new v({props:{name:"class transformers.TypicalLogitsWarper",anchor:"transformers.TypicalLogitsWarper",parameters:[{name:"mass",val:": float = 0.9"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.mass",description:`<strong>mass</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Value of typical_p between 0 and 1 inclusive, defaults to 0.9.`,name:"mass"},{anchor:"transformers.TypicalLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TypicalLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L614"}}),hn=new Z({props:{anchor:"transformers.TypicalLogitsWarper.example",$$slots:{default:[D3]},$$scope:{ctx:j}}}),jo=new v({props:{name:"__call__",anchor:"transformers.TypicalLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TypicalLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L678",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xo=new v({props:{name:"class transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:": float"},{name:"model",val:""},{name:"unconditional_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"unconditional_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale != 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality. A value smaller than 1 has the opposite effect, while
making the negative prompt provided with negative_prompt_ids (if any) act as a positive prompt.`,name:"guidance_scale"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model computing the unconditional scores. Supposedly the same as the one computing the conditional
scores. Both models must use the same tokenizer.`,name:"model"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_ids",description:`<strong>unconditional_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary for the unconditional branch. If unset, will default to
the last token of the prompt.`,name:"unconditional_ids"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_attention_mask",description:`<strong>unconditional_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention mask for unconditional_ids.`,name:"unconditional_attention_mask"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to cache key/values during the negative prompt forward pass.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L2176"}}),un=new Z({props:{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[Q3]},$$scope:{ctx:j}}}),Jo=new v({props:{name:"__call__",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L2282"}}),Uo=new v({props:{name:"class transformers.WhisperTimeStampLogitsProcessor",anchor:"transformers.WhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"begin_index",val:": typing.Optional[int] = None"},{name:"_detect_timestamp_from_logprob",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.begin_index",description:"<strong>begin_index</strong> (<code>Optional</code>, <em>optional</em>) &#x2014; Token index of the first token that is generated by the model.",name:"begin_index"},{anchor:"transformers.WhisperTimeStampLogitsProcessor._detect_timestamp_from_logprob",description:"<strong>_detect_timestamp_from_logprob</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether timestamps can be predicted from logprobs over all timestamps.",name:"_detect_timestamp_from_logprob"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1874"}}),fn=new Z({props:{anchor:"transformers.WhisperTimeStampLogitsProcessor.example",$$slots:{default:[Y3]},$$scope:{ctx:j}}}),Zo=new v({props:{name:"__call__",anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L1959",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Co=new v({props:{name:"class transformers.WatermarkLogitsProcessor",anchor:"transformers.WatermarkLogitsProcessor",parameters:[{name:"vocab_size",val:""},{name:"device",val:""},{name:"greenlist_ratio",val:": float = 0.25"},{name:"bias",val:": float = 2.0"},{name:"hashing_key",val:": int = 15485863"},{name:"seeding_scheme",val:": str = 'lefthash'"},{name:"context_width",val:": int = 1"}],parametersDescription:[{anchor:"transformers.WatermarkLogitsProcessor.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>) &#x2014;
The model tokenizer&#x2019;s vocab_size. Used to calculate &#x201C;green&#x201D; tokens ratio.`,name:"vocab_size"},{anchor:"transformers.WatermarkLogitsProcessor.device",description:`<strong>device</strong> (<code>str</code>) &#x2014;
The device where model is allocated.`,name:"device"},{anchor:"transformers.WatermarkLogitsProcessor.greenlist_ratio",description:`<strong>greenlist_ratio</strong> (<code>float</code>, optional, <em>optional</em>, defaults to 0.25) &#x2014;
The ratio of &#x201C;green&#x201D; tokens used to the vocabulary size. Defaults to 0.25.`,name:"greenlist_ratio"},{anchor:"transformers.WatermarkLogitsProcessor.bias",description:`<strong>bias</strong> (<code>float</code>, optional, <em>optional</em>, defaults to 2.0) &#x2014;
The bias added to the selected &#x201C;green&#x201D; tokens&#x2019; logits. Consider lowering the
<code>bias</code> if the text generation quality degrades. Recommended values are in the
range of [0.5, 2.0]. Defaults to 2.0.`,name:"bias"},{anchor:"transformers.WatermarkLogitsProcessor.hashing_key",description:`<strong>hashing_key</strong> (<code>int</code>, optional, <em>optional</em>, defaults to 15485863) &#x2014;
Key used for hashing. If you deploy this watermark, we advise using another private key.
Defaults to 15485863 (the millionth prime).`,name:"hashing_key"},{anchor:"transformers.WatermarkLogitsProcessor.seeding_scheme",description:`<strong>seeding_scheme</strong> (<code>str</code>, optional, <em>optional</em>, defaults to <code>&quot;lefthash&quot;</code>) &#x2014;
The seeding scheme used for selecting &#x201C;green&#x201D; tokens. Accepts values:<ul>
<li>&#x201C;lefthash&#x201D; (default): &#x201C;green&#x201D; tokens selection depend on the last token (Algorithm 2 from paper)</li>
<li>&#x201C;selfhash&#x201D;: &#x201C;green&#x201D; tokens selection depends on the current token itself (Algorithm 3 from paper)
The downside of this scheme is that it considers all possible next tokens and can be slower than &#x201C;lefthash&#x201D;.
The context length of previous tokens to use in seeding. Higher context length makes watermarking more robust.</li>
</ul>`,name:"seeding_scheme"},{anchor:"transformers.WatermarkLogitsProcessor.context_width",description:`<strong>context_width</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of previous tokens to use when setting the seed.`,name:"context_width"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L2341"}}),_n=new Z({props:{anchor:"transformers.WatermarkLogitsProcessor.example",$$slots:{default:[P3]},$$scope:{ctx:j}}}),Wo=new v({props:{name:"__call__",anchor:"transformers.WatermarkLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WatermarkLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WatermarkLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/logits_process.py#L2463",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Bo=new ye({props:{title:"TensorFlow",local:"transformers.TFForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),Io=new v({props:{name:"class transformers.TFForcedBOSTokenLogitsProcessor",anchor:"transformers.TFForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L448"}}),zo=new v({props:{name:"__call__",anchor:"transformers.TFForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L462"}}),Vo=new v({props:{name:"class transformers.TFForcedEOSTokenLogitsProcessor",anchor:"transformers.TFForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L478"}}),Go=new v({props:{name:"__call__",anchor:"transformers.TFForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L495"}}),Fo=new v({props:{name:"class transformers.TFForceTokensLogitsProcessor",anchor:"transformers.TFForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": typing.List[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L563"}}),Xo=new v({props:{name:"__call__",anchor:"transformers.TFForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L579"}}),Ro=new v({props:{name:"class transformers.TFLogitsProcessor",anchor:"transformers.TFLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L53"}}),Lo=new v({props:{name:"__call__",anchor:"transformers.TFLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessor.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L56",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),So=new v({props:{name:"class transformers.TFLogitsProcessorList",anchor:"transformers.TFLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L75"}}),No=new v({props:{name:"__call__",anchor:"transformers.TFLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessorList.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L82",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ho=new v({props:{name:"class transformers.TFLogitsWarper",anchor:"transformers.TFLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L64"}}),Eo=new v({props:{name:"__call__",anchor:"transformers.TFLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsWarper.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L67",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),qo=new v({props:{name:"class transformers.TFMinLengthLogitsProcessor",anchor:"transformers.TFMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.TFMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L202"}}),Do=new v({props:{name:"__call__",anchor:"transformers.TFMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L228"}}),Qo=new v({props:{name:"class transformers.TFNoBadWordsLogitsProcessor",anchor:"transformers.TFNoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": typing.List[typing.List[int]]"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated. In order to get the tokens of the words
that should not appear in the generated text, make sure to set <code>add_prefix_space=True</code> when initializing
the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code>
argument is only supported for some slow tokenizers, as fast tokenizers&#x2019; prefixing behaviours come from
<code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`,name:"bad_words_ids"},{anchor:"transformers.TFNoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L288"}}),Yo=new v({props:{name:"__call__",anchor:"transformers.TFNoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L367"}}),Po=new v({props:{name:"class transformers.TFNoRepeatNGramLogitsProcessor",anchor:"transformers.TFNoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L388"}}),Ao=new v({props:{name:"__call__",anchor:"transformers.TFNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L427"}}),Oo=new v({props:{name:"class transformers.TFRepetitionPenaltyLogitsProcessor",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L238"}}),Ko=new v({props:{name:"__call__",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L280"}}),el=new v({props:{name:"class transformers.TFSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L511"}}),tl=new v({props:{name:"__call__",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L522"}}),sl=new v({props:{name:"class transformers.TFSuppressTokensLogitsProcessor",anchor:"transformers.TFSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L541"}}),nl=new v({props:{name:"__call__",anchor:"transformers.TFSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L548"}}),rl=new v({props:{name:"class transformers.TFTemperatureLogitsWarper",anchor:"transformers.TFTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TFTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L98"}}),al=new v({props:{name:"__call__",anchor:"transformers.TFTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L113"}}),ol=new v({props:{name:"class transformers.TFTopKLogitsWarper",anchor:"transformers.TFTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L118"}}),ll=new v({props:{name:"__call__",anchor:"transformers.TFTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L138"}}),cl=new v({props:{name:"class transformers.TFTopPLogitsWarper",anchor:"transformers.TFTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TFTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L146"}}),il=new v({props:{name:"__call__",anchor:"transformers.TFTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/tf_logits_process.py#L170"}}),dl=new ye({props:{title:"FLAX",local:"transformers.FlaxForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),pl=new v({props:{name:"class transformers.FlaxForcedBOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L195"}}),ml=new v({props:{name:"__call__",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L207"}}),gl=new v({props:{name:"class transformers.FlaxForcedEOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L217"}}),hl=new v({props:{name:"__call__",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L232"}}),ul=new v({props:{name:"class transformers.FlaxForceTokensLogitsProcessor",anchor:"transformers.FlaxForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:""}],parametersDescription:[{anchor:"transformers.FlaxForceTokensLogitsProcessor.force_token_map",description:`<strong>force_token_map</strong> (<code>list</code>) &#x2014;
Map giving token ids and indices where they will be forced to be sampled.`,name:"force_token_map"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L316"}}),fl=new v({props:{name:"__call__",anchor:"transformers.FlaxForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L338"}}),_l=new v({props:{name:"class transformers.FlaxLogitsProcessor",anchor:"transformers.FlaxLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L51"}}),bl=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L54",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),yl=new v({props:{name:"class transformers.FlaxLogitsProcessorList",anchor:"transformers.FlaxLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L73"}}),Tl=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L80",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ml=new v({props:{name:"class transformers.FlaxLogitsWarper",anchor:"transformers.FlaxLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L62"}}),vl=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L65",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),wl=new v({props:{name:"class transformers.FlaxMinLengthLogitsProcessor",anchor:"transformers.FlaxMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.FlaxMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L242"}}),kl=new v({props:{name:"__call__",anchor:"transformers.FlaxMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L263"}}),$l=new v({props:{name:"class transformers.FlaxSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong> (<code>List[int]</code>) &#x2014;
Tokens to not sample.`,name:"begin_suppress_tokens"},{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
Index where the tokens are suppressed.`,name:"begin_index"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L272"}}),jl=new v({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L289"}}),xl=new v({props:{name:"class transformers.FlaxSuppressTokensLogitsProcessor",anchor:"transformers.FlaxSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:": list"}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensLogitsProcessor.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>list</code>) &#x2014;
Tokens to not sample.`,name:"suppress_tokens"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L297"}}),Jl=new v({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L310"}}),Ul=new v({props:{name:"class transformers.FlaxTemperatureLogitsWarper",anchor:"transformers.FlaxTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.FlaxTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L96"}}),Zl=new v({props:{name:"__call__",anchor:"transformers.FlaxTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L111"}}),Cl=new v({props:{name:"class transformers.FlaxTopKLogitsWarper",anchor:"transformers.FlaxTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L160"}}),Wl=new v({props:{name:"__call__",anchor:"transformers.FlaxTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L180"}}),Bl=new v({props:{name:"class transformers.FlaxTopPLogitsWarper",anchor:"transformers.FlaxTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L116"}}),Il=new v({props:{name:"__call__",anchor:"transformers.FlaxTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L140"}}),zl=new v({props:{name:"class transformers.FlaxWhisperTimeStampLogitsProcessor",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"model_config",val:""},{name:"decoder_input_length",val:""}],parametersDescription:[{anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L364"}}),Vl=new v({props:{name:"__call__",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/flax_logits_process.py#L398"}}),Gl=new ye({props:{title:"StoppingCriteria",local:"transformers.StoppingCriteria",headingTag:"h2"}}),Xl=new v({props:{name:"class transformers.StoppingCriteria",anchor:"transformers.StoppingCriteria",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/stopping_criteria.py#L46"}}),Rl=new v({props:{name:"__call__",anchor:"transformers.StoppingCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/stopping_criteria.py#L53",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Ll=new v({props:{name:"class transformers.StoppingCriteriaList",anchor:"transformers.StoppingCriteriaList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/stopping_criteria.py#L491"}}),Sl=new v({props:{name:"__call__",anchor:"transformers.StoppingCriteriaList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteriaList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteriaList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteriaList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/stopping_criteria.py#L492",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Nl=new v({props:{name:"class transformers.MaxLengthCriteria",anchor:"transformers.MaxLengthCriteria",parameters:[{name:"max_length",val:": int"},{name:"max_position_embeddings",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length that the output sequence can have in number of tokens.`,name:"max_length"},{anchor:"transformers.MaxLengthCriteria.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum model length, as defined by the model&#x2019;s <code>config.max_position_embeddings</code> attribute.`,name:"max_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/stopping_criteria.py#L58"}}),Hl=new v({props:{name:"__call__",anchor:"transformers.MaxLengthCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxLengthCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxLengthCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/stopping_criteria.py#L74",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),El=new v({props:{name:"class transformers.MaxTimeCriteria",anchor:"transformers.MaxTimeCriteria",parameters:[{name:"max_time",val:": float"},{name:"initial_timestamp",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.max_time",description:`<strong>max_time</strong> (<code>float</code>) &#x2014;
The maximum allowed time in seconds for the generation.`,name:"max_time"},{anchor:"transformers.MaxTimeCriteria.initial_time",description:`<strong>initial_time</strong> (<code>float</code>, <em>optional</em>, defaults to <code>time.time()</code>) &#x2014;
The start of the generation allowed time.`,name:"initial_time"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/stopping_criteria.py#L87"}}),ql=new v({props:{name:"__call__",anchor:"transformers.MaxTimeCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxTimeCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxTimeCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/stopping_criteria.py#L104",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Dl=new v({props:{name:"class transformers.StopStringCriteria",anchor:"transformers.StopStringCriteria",parameters:[{name:"tokenizer",val:": PreTrainedTokenizerBase"},{name:"stop_strings",val:": typing.Union[str, typing.List[str]]"}],parametersDescription:[{anchor:"transformers.StopStringCriteria.tokenizer",description:`<strong>tokenizer</strong> (<code>PreTrainedTokenizer</code>) &#x2014;
The model&#x2019;s associated tokenizer (necessary to extract vocab and tokenize the termination sequences)`,name:"tokenizer"},{anchor:"transformers.StopStringCriteria.stop_strings",description:`<strong>stop_strings</strong> (<code>Union[str, List[str]]</code>) &#x2014;
A list of strings that should end generation. If a string is passed, it will be treated like a
list with a single element.`,name:"stop_strings"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/stopping_criteria.py#L110"}}),vn=new Z({props:{anchor:"transformers.StopStringCriteria.example",$$slots:{default:[A3]},$$scope:{ctx:j}}}),Ql=new v({props:{name:"__call__",anchor:"transformers.StopStringCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StopStringCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StopStringCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StopStringCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/stopping_criteria.py#L387",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Yl=new v({props:{name:"class transformers.EosTokenCriteria",anchor:"transformers.EosTokenCriteria",parameters:[{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor]"}],parametersDescription:[{anchor:"transformers.EosTokenCriteria.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int], torch.Tensor]</code>) &#x2014;
The id(s) of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/stopping_criteria.py#L446"}}),Pl=new v({props:{name:"__call__",anchor:"transformers.EosTokenCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.EosTokenCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_30530/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EosTokenCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.EosTokenCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/stopping_criteria.py#L463",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.BoolTensor</code>. (<code>torch.BoolTensor</code> of shape <code>(batch_size, 1)</code>), where <code>True</code> indicates we stop generation
for a particular row, <code>True</code> indicates we should continue.</p>
`}}),Al=new ye({props:{title:"Constraints",local:"transformers.Constraint",headingTag:"h2"}}),Kl=new v({props:{name:"class transformers.Constraint",anchor:"transformers.Constraint",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_constraints.py#L5"}}),wn=new Z({props:{anchor:"transformers.Constraint.example",$$slots:{default:[O3]},$$scope:{ctx:j}}}),ec=new v({props:{name:"advance",anchor:"transformers.Constraint.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_constraints.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>A single token ID (int) that advances the constraint, or</li>
<li>A list of token IDs that could advance the constraint</li>
<li>None if the constraint is completed or cannot be advanced</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>token_ids (Union[int, List[int], None])</p>
`}}),tc=new v({props:{name:"copy",anchor:"transformers.Constraint.copy",parameters:[{name:"stateful",val:" = False"}],parametersDescription:[{anchor:"transformers.Constraint.copy.stateful(bool)",description:"<strong>stateful(<code>bool</code>)</strong> &#x2014; Whether to not only copy the constraint for new instance, but also its state.",name:"stateful(bool)"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_constraints.py#L116",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same constraint as the one being called from.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>constraint(<code>Constraint</code>)</p>
`}}),sc=new v({props:{name:"does_advance",anchor:"transformers.Constraint.does_advance",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_constraints.py#L63"}}),nc=new v({props:{name:"remaining",anchor:"transformers.Constraint.remaining",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_constraints.py#L107"}}),rc=new v({props:{name:"reset",anchor:"transformers.Constraint.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_constraints.py#L97"}}),ac=new v({props:{name:"test",anchor:"transformers.Constraint.test",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_constraints.py#L24"}}),oc=new v({props:{name:"update",anchor:"transformers.Constraint.update",parameters:[{name:"token_id",val:": int"}],parametersDescription:[{anchor:"transformers.Constraint.update.token_id(int)",description:`<strong>token_id(<code>int</code>)</strong> &#x2014;
The id of a newly generated token in the beam search.`,name:"token_id(int)"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_constraints.py#L72",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether this constraint has become one step closer to being fulfuilled.
completed(<code>bool</code>):
Whether this constraint has been completely fulfilled by this token being generated.
reset (<code>bool</code>):
Whether this constraint has reset its progress by this token being generated.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stepped(<code>bool</code>)</p>
`}}),lc=new v({props:{name:"class transformers.PhrasalConstraint",anchor:"transformers.PhrasalConstraint",parameters:[{name:"token_ids",val:": typing.List[int]"}],parametersDescription:[{anchor:"transformers.PhrasalConstraint.token_ids",description:`<strong>token_ids</strong> (<code>List[int]</code>) &#x2014;
The id of the token that must be generated by the output.`,name:"token_ids"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_constraints.py#L132"}}),cc=new v({props:{name:"class transformers.DisjunctiveConstraint",anchor:"transformers.DisjunctiveConstraint",parameters:[{name:"nested_token_ids",val:": typing.List[typing.List[int]]"}],parametersDescription:[{anchor:"transformers.DisjunctiveConstraint.nested_token_ids",description:`<strong>nested_token_ids</strong> (<code>List[List[int]]</code>) &#x2014;
A list of words, where each word is a list of ids. This constraint is fulfilled by generating just one from
the list of words.`,name:"nested_token_ids"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_constraints.py#L264"}}),ic=new v({props:{name:"class transformers.ConstraintListState",anchor:"transformers.ConstraintListState",parameters:[{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"}],parametersDescription:[{anchor:"transformers.ConstraintListState.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.Constraint">Constraint</a> objects that must be fulfilled by the beam scorer.`,name:"constraints"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_constraints.py#L354"}}),dc=new v({props:{name:"advance",anchor:"transformers.ConstraintListState.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_constraints.py#L386"}}),pc=new v({props:{name:"reset",anchor:"transformers.ConstraintListState.reset",parameters:[{name:"token_ids",val:": typing.Optional[typing.List[int]]"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_constraints.py#L421"}}),mc=new ye({props:{title:"BeamSearch",local:"transformers.BeamScorer",headingTag:"h2"}}),gc=new v({props:{name:"class transformers.BeamScorer",anchor:"transformers.BeamScorer",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_search.py#L91"}}),hc=new v({props:{name:"process",anchor:"transformers.BeamScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/pr_30530/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.BeamScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.BeamScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.BeamScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.BeamScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.BeamScorer.process.group_index",description:`<strong>group_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the group of beams. Used with <code>~PreTrainedModel.group_beam_search</code>.`,name:"group_index"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_search.py#L97",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of all
non-finished beams.</li>
<li><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be added
to the non-finished beam_hypotheses.</li>
<li><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),uc=new v({props:{name:"finalize",anchor:"transformers.BeamScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.finalize.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/pr_30530/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.finalize.final_beam_scores",description:`<strong>final_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The final scores of all non-finished beams.`,name:"final_beam_scores"},{anchor:"transformers.BeamScorer.finalize.final_beam_tokens",description:`<strong>final_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The last tokens to be added to the non-finished beam_hypotheses.`,name:"final_beam_tokens"},{anchor:"transformers.BeamScorer.finalize.final_beam_indices",description:`<strong>final_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The beam indices indicating to which beam the <code>final_beam_tokens</code> shall be added.`,name:"final_beam_indices"},{anchor:"transformers.BeamScorer.finalize.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.finalize.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_search.py#L109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated sequences.
The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter if all batches finished early
due to the <code>eos_token_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code> of shape <code>(batch_size * num_return_sequences, sequence_length)</code></p>
`}}),fc=new v({props:{name:"class transformers.BeamSearchScorer",anchor:"transformers.BeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[bool, str, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.BeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.BeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.BeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.BeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.BeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.BeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.BeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.BeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_search.py#L123"}}),_c=new v({props:{name:"process",anchor:"transformers.BeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"pad_token_id",val:": typing.Union[int, torch.Tensor, NoneType] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"group_index",val:": typing.Optional[int] = 0"},{name:"decoder_prompt_len",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_search.py#L215"}}),bc=new v({props:{name:"finalize",anchor:"transformers.BeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Union[int, torch.Tensor, NoneType] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_prompt_len",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_search.py#L320"}}),yc=new v({props:{name:"class transformers.ConstrainedBeamSearchScorer",anchor:"transformers.ConstrainedBeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"constraints",val:": typing.List[transformers.generation.beam_constraints.Constraint]"},{name:"device",val:": device"},{name:"length_penalty",val:": typing.Optional[float] = 1.0"},{name:"do_early_stopping",val:": typing.Union[bool, str, NoneType] = False"},{name:"num_beam_hyps_to_keep",val:": typing.Optional[int] = 1"},{name:"num_beam_groups",val:": typing.Optional[int] = 1"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.ConstrainedBeamSearchScorer.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of positive constraints represented as <code>Constraint</code> objects that must be fulfilled in the generation
output. For more information, the documentation of <a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.Constraint">Constraint</a> should be read.`,name:"constraints"},{anchor:"transformers.ConstrainedBeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.ConstrainedBeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.ConstrainedBeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.ConstrainedBeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_search.py#L419"}}),Tc=new v({props:{name:"process",anchor:"transformers.ConstrainedBeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"scores_for_all_vocab",val:": FloatTensor"},{name:"pad_token_id",val:": typing.Union[int, torch.Tensor, NoneType] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_prompt_len",val:": typing.Optional[int] = 0"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/pr_30530/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/pr_30530/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.scores_for_all_vocab",description:`<strong>scores_for_all_vocab</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
The scores of all tokens in the vocabulary for each of the beam hypotheses.`,name:"scores_for_all_vocab"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.decoder_prompt_len",description:`<strong>decoder_prompt_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The length of prompt that is included in the input to decoder.`,name:"decoder_prompt_len"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_search.py#L513",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li>
<p><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of
all
non-finished beams.</p>
</li>
<li>
<p><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be
added
to the non-finished beam_hypotheses.</p>
</li>
<li>
<p><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),Mc=new v({props:{name:"finalize",anchor:"transformers.ConstrainedBeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": typing.Union[int, torch.Tensor, NoneType] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], torch.Tensor, NoneType] = None"},{name:"beam_indices",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_prompt_len",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/beam_search.py#L813"}}),vc=new ye({props:{title:"Streamers",local:"transformers.TextStreamer",headingTag:"h2"}}),wc=new v({props:{name:"class transformers.TextStreamer",anchor:"transformers.TextStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/streamers.py#L38"}}),Cn=new Vr({props:{warning:!0,$$slots:{default:[K3]},$$scope:{ctx:j}}}),Wn=new Z({props:{anchor:"transformers.TextStreamer.example",$$slots:{default:[eZ]},$$scope:{ctx:j}}}),kc=new v({props:{name:"end",anchor:"transformers.TextStreamer.end",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/streamers.py#L116"}}),$c=new v({props:{name:"on_finalized_text",anchor:"transformers.TextStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/streamers.py#L130"}}),jc=new v({props:{name:"put",anchor:"transformers.TextStreamer.put",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/streamers.py#L82"}}),xc=new v({props:{name:"class transformers.TextIteratorStreamer",anchor:"transformers.TextIteratorStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": typing.Optional[float] = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.TextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/streamers.py#L159"}}),Vn=new Vr({props:{warning:!0,$$slots:{default:[tZ]},$$scope:{ctx:j}}}),Gn=new Z({props:{anchor:"transformers.TextIteratorStreamer.example",$$slots:{default:[sZ]},$$scope:{ctx:j}}}),Jc=new v({props:{name:"on_finalized_text",anchor:"transformers.TextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/streamers.py#L213"}}),Uc=new ye({props:{title:"Caches",local:"transformers.Cache",headingTag:"h2"}}),Zc=new v({props:{name:"class transformers.Cache",anchor:"transformers.Cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L28"}}),Cc=new v({props:{name:"update",anchor:"transformers.Cache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.Cache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.Cache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.Cache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.Cache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. These are specific to each subclass and allow new types of
cache to be created.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L36",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Wc=new v({props:{name:"class transformers.CacheConfig",anchor:"transformers.CacheConfig",parameters:[{name:"cache_implementation",val:": None"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L115"}}),Bc=new v({props:{name:"update",anchor:"transformers.CacheConfig.update",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CacheConfig.update.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary of attributes to tentatively update this class.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L189",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary containing all the key-value pairs that were not used to update the instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Ic=new v({props:{name:"class transformers.QuantizedCacheConfig",anchor:"transformers.QuantizedCacheConfig",parameters:[{name:"backend",val:": str = 'quanto'"},{name:"nbits",val:": typing.Optional[int] = 4"},{name:"axis_key",val:": typing.Optional[int] = 0"},{name:"axis_value",val:": typing.Optional[int] = 0"},{name:"q_group_size",val:": typing.Optional[int] = 64"},{name:"residual_length",val:": typing.Optional[int] = 128"},{name:"compute_dtype",val:": typing.Optional[torch.dtype] = torch.float16"},{name:"device",val:": typing.Optional[str] = 'cpu'"}],parametersDescription:[{anchor:"transformers.QuantizedCacheConfig.backend",description:`<strong>backend</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;quanto&quot;</code>) &#x2014;
Backend to use when performing quantization, Can be one of [<code>quanto</code>, <code>HQQ</code>]`,name:"backend"},{anchor:"transformers.QuantizedCacheConfig.nbits",description:`<strong>nbits</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of bits, can be 2 or 4 for the <code>quanto</code> backend and one of [1, 2, 3, 4, 8] for the <code>HQQ</code> backend. Defaults to 2.`,name:"nbits"},{anchor:"transformers.QuantizedCacheConfig.axis_key",description:`<strong>axis_key</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Axis over which to perform grouping for the key tensors. Can be [0, -1] for <code>quanto</code> backend and [0, 1] for <code>HQQ</code> backend.`,name:"axis_key"},{anchor:"transformers.QuantizedCacheConfig.axis_value",description:`<strong>axis_value</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Axis over which to perform grouping for the value tensors. Can be [0, -1] for <code>quanto</code> backend and [0, 1] for <code>HQQ</code> backend.`,name:"axis_value"},{anchor:"transformers.QuantizedCacheConfig.q_group_size",description:`<strong>q_group_size</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 64) &#x2014;
Size of the quantization group, should be a divisor of the model&#x2019;s hidden dimension.
Defaults to 64.`,name:"q_group_size"},{anchor:"transformers.QuantizedCacheConfig.residual_length",description:`<strong>residual_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to 128) &#x2014;
Length of the residual cache which will always be stored in original presicion.
Defaults to 128.`,name:"residual_length"},{anchor:"transformers.QuantizedCacheConfig.compute_dtype",description:`<strong>compute_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float16</code>) &#x2014;
The defualt dtype used for computations in the model. Keys and Values will be cast to this dtype after dequantization.`,name:"compute_dtype"},{anchor:"transformers.QuantizedCacheConfig.device",description:`<strong>device</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
Device on which to perform computations, should be same as the model&#x2019;s device.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L212"}}),zc=new v({props:{name:"validate",anchor:"transformers.QuantizedCacheConfig.validate",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L258"}}),Vc=new v({props:{name:"class transformers.DynamicCache",anchor:"transformers.DynamicCache",parameters:[{name:"num_hidden_layers",val:": typing.Optional[int] = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L351"}}),Sn=new Z({props:{anchor:"transformers.DynamicCache.example",$$slots:{default:[nZ]},$$scope:{ctx:j}}}),Gc=new v({props:{name:"update",anchor:"transformers.DynamicCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.DynamicCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.DynamicCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.DynamicCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.DynamicCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. No additional arguments are used in <code>DynamicCache</code>.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L408",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Fc=new v({props:{name:"get_seq_length",anchor:"transformers.DynamicCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L455"}}),Xc=new v({props:{name:"reorder_cache",anchor:"transformers.DynamicCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L93"}}),Rc=new v({props:{name:"to_legacy_cache",anchor:"transformers.DynamicCache.to_legacy_cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L470"}}),Lc=new v({props:{name:"from_legacy_cache",anchor:"transformers.DynamicCache.from_legacy_cache",parameters:[{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"num_hidden_layers",val:": int = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L478"}}),Sc=new v({props:{name:"class transformers.QuantizedCache",anchor:"transformers.QuantizedCache",parameters:[{name:"cache_config",val:": QuantizedCacheConfig"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L665"}}),Nc=new v({props:{name:"update",anchor:"transformers.QuantizedCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L694"}}),Hc=new v({props:{name:"get_seq_length",anchor:"transformers.QuantizedCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L737"}}),Ec=new v({props:{name:"class transformers.QuantoQuantizedCache",anchor:"transformers.QuantoQuantizedCache",parameters:[{name:"cache_config",val:": CacheConfig"}],parametersDescription:[{anchor:"transformers.QuantoQuantizedCache.cache_config",description:`<strong>cache_config</strong> (<code>QuantizedCacheConfig</code>) &#x2014;
A configuration containing all the arguments to be used by the quantizer, including axis, qtype and group size.`,name:"cache_config"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L755"}}),Yn=new Z({props:{anchor:"transformers.QuantoQuantizedCache.example",$$slots:{default:[rZ]},$$scope:{ctx:j}}}),qc=new v({props:{name:"class transformers.HQQQuantizedCache",anchor:"transformers.HQQQuantizedCache",parameters:[{name:"cache_config",val:": CacheConfig"}],parametersDescription:[{anchor:"transformers.HQQQuantizedCache.cache_config",description:`<strong>cache_config</strong> (<code>QuantizedCacheConfig</code>) &#x2014;
A configuration containing all the arguments to be used by the quantizer, including axis, qtype and group size.`,name:"cache_config"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L842"}}),Pn=new Z({props:{anchor:"transformers.HQQQuantizedCache.example",$$slots:{default:[aZ]},$$scope:{ctx:j}}}),Dc=new v({props:{name:"class transformers.SinkCache",anchor:"transformers.SinkCache",parameters:[{name:"window_length",val:": int"},{name:"num_sink_tokens",val:": int"}],parametersDescription:[{anchor:"transformers.SinkCache.window_length",description:`<strong>window_length</strong> (<code>int</code>) &#x2014;
The length of the context window.`,name:"window_length"},{anchor:"transformers.SinkCache.num_sink_tokens",description:`<strong>num_sink_tokens</strong> (<code>int</code>) &#x2014;
The number of sink tokens. See the original paper for more information.`,name:"num_sink_tokens"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L904"}}),An=new Z({props:{anchor:"transformers.SinkCache.example",$$slots:{default:[oZ]},$$scope:{ctx:j}}}),Qc=new v({props:{name:"update",anchor:"transformers.SinkCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.SinkCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.SinkCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.SinkCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.SinkCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The following arguments can be used in <code>SinkCache</code>: <code>sin</code>,
<code>cos</code> and <code>partial_rotation_size</code>. These arguments are used with models using RoPE, to recompute the
rotation as the tokens are shifted.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L996",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Yc=new v({props:{name:"get_seq_length",anchor:"transformers.SinkCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L984"}}),Pc=new v({props:{name:"reorder_cache",anchor:"transformers.SinkCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L93"}}),Ac=new v({props:{name:"class transformers.OffloadedCache",anchor:"transformers.OffloadedCache",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L551"}}),Oc=new v({props:{name:"update",anchor:"transformers.OffloadedCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.OffloadedCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.OffloadedCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.OffloadedCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.OffloadedCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. No additional arguments are used in <code>OffloadedCache</code>.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L618",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),Kc=new v({props:{name:"prefetch_layer",anchor:"transformers.OffloadedCache.prefetch_layer",parameters:[{name:"layer_idx",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L572"}}),ei=new v({props:{name:"evict_previous_layer",anchor:"transformers.OffloadedCache.evict_previous_layer",parameters:[{name:"layer_idx",val:": int"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L581"}}),ti=new v({props:{name:"class transformers.StaticCache",anchor:"transformers.StaticCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"max_cache_len",val:": int = None"},{name:"device",val:": device = None"},{name:"dtype",val:": dtype = torch.float32"},{name:"max_batch_size",val:": typing.Optional[int] = None"},{name:"layer_device_map",val:": typing.Optional[typing.Dict[int, typing.Union[str, torch.device, int]]] = None"}],parametersDescription:[{anchor:"transformers.StaticCache.config",description:`<strong>config</strong> (<code>PretrainedConfig</code>) &#x2014;
The configuration file defining the shape-related attributes required to initialize the static cache.`,name:"config"},{anchor:"transformers.StaticCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used. If you are manually setting the batch size, make sure to take into account the number of beams if you are running beam search`,name:"batch_size"},{anchor:"transformers.StaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.StaticCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"},{anchor:"transformers.StaticCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.StaticCache.layer_device_map(`Dict[int,",description:"<strong>layer_device_map(`Dict[int,</strong> Union[str, torch.device, int]]]<code>, </code>optional<code>) -- Mapping between the layers and its device. This is required when you are manually initializing the cache and the model is splitted between differents gpus. You can know which layers mapped to which device by checking the associated device_map: </code>model.hf_device_map`.",name:"layer_device_map(`Dict[int,"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1091"}}),rr=new Z({props:{anchor:"transformers.StaticCache.example",$$slots:{default:[lZ]},$$scope:{ctx:j}}}),si=new v({props:{name:"update",anchor:"transformers.StaticCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.StaticCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.StaticCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.StaticCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.StaticCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <code>optional</code>) &#x2014;
Additional arguments for the cache subclass. The <code>StaticCache</code> needs the <code>cache_position</code> input
to know how where to write in the cache.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1190",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),ni=new v({props:{name:"get_seq_length",anchor:"transformers.StaticCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1238"}}),ri=new v({props:{name:"reset",anchor:"transformers.StaticCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1248"}}),ai=new v({props:{name:"class transformers.OffloadedStaticCache",anchor:"transformers.OffloadedStaticCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"max_batch_size",val:": int"},{name:"max_cache_len",val:": typing.Optional[int]"},{name:"device",val:": typing.Union[str, torch.device]"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"},{name:"offload_device",val:": typing.Union[str, torch.device] = device(type='cpu')"}],parametersDescription:[{anchor:"transformers.OffloadedStaticCache.config",description:`<strong>config</strong> (\`PretrainedConfig) &#x2014;
The configuration file defining the shape-related attributes required to initialize
the static cache.`,name:"config"},{anchor:"transformers.OffloadedStaticCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which the model will be used.`,name:"max_batch_size"},{anchor:"transformers.OffloadedStaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.OffloadedStaticCache.device",description:`<strong>device</strong> (<code>Union[str, torch.device]</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the
layer device.`,name:"device"},{anchor:"transformers.OffloadedStaticCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
The default <code>dtype</code> to use when initializing the cache.`,name:"dtype"},{anchor:"transformers.OffloadedStaticCache.offload_device",description:`<strong>offload_device</strong> (<code>Union[str, torch.device]</code>, <em>optional</em>, defaults to <code>cpu</code>) &#x2014;
The device to offload to. Defaults to CPU.`,name:"offload_device"},{anchor:"transformers.OffloadedStaticCache.key_cache",description:`<strong>key_cache</strong> (<code>List[torch.Tensor]</code>) &#x2014;
Off-loaded key cache tensors. First one will be on device, where-as the others are
off-loaded.`,name:"key_cache"},{anchor:"transformers.OffloadedStaticCache.value_cache",description:`<strong>value_cache</strong> (<code>List[torch.Tensor]</code>) &#x2014;
Off-loaded value cache tensors. First one will be on device, where-as the others are
off-loaded.`,name:"value_cache"},{anchor:"transformers.OffloadedStaticCache.max_batch_size",description:`<strong>max_batch_size</strong> (<code>int</code>) &#x2014;
The maximum batch size with which this cache can be used.`,name:"max_batch_size"},{anchor:"transformers.OffloadedStaticCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which this cache can be used.`,name:"max_cache_len"},{anchor:"transformers.OffloadedStaticCache.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
The device on which the cache is used.`,name:"device"},{anchor:"transformers.OffloadedStaticCache.offload_device",description:`<strong>offload_device</strong> (<code>torch.device</code>) &#x2014;
The device used to offload to.`,name:"offload_device"},{anchor:"transformers.OffloadedStaticCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>) &#x2014;
The <code>dtype</code> used to initializing the cache.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1868"}}),cr=new Z({props:{anchor:"transformers.OffloadedStaticCache.example",$$slots:{default:[cZ]},$$scope:{ctx:j}}}),oi=new v({props:{name:"update",anchor:"transformers.OffloadedStaticCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"transformers.OffloadedStaticCache.update.key_states",description:`<strong>key_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new key states to cache.`,name:"key_states"},{anchor:"transformers.OffloadedStaticCache.update.value_states",description:`<strong>value_states</strong> (<code>torch.Tensor</code>) &#x2014;
The new value states to cache.`,name:"value_states"},{anchor:"transformers.OffloadedStaticCache.update.layer_idx",description:`<strong>layer_idx</strong> (<code>int</code>) &#x2014;
The index of the layer to cache the states for.`,name:"layer_idx"},{anchor:"transformers.OffloadedStaticCache.update.cache_kwargs",description:`<strong>cache_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional arguments for the cache subclass. The <code>OffloadedStaticCache</code> needs the
<code>cache_position</code> input to know how where to write in the cache.`,name:"cache_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1980",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple containing the updated key and value states.</p>
`}}),li=new v({props:{name:"get_seq_length",anchor:"transformers.OffloadedStaticCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L2063"}}),ci=new v({props:{name:"reset",anchor:"transformers.OffloadedStaticCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L2074"}}),ii=new v({props:{name:"class transformers.HybridCache",anchor:"transformers.HybridCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"max_cache_len",val:": int = None"},{name:"device",val:": typing.Union[torch.device, str] = 'cpu'"},{name:"dtype",val:": dtype = torch.float32"},{name:"max_batch_size",val:": typing.Optional[int] = None"},{name:"layer_device_map",val:": typing.Optional[typing.Dict[int, typing.Union[str, torch.device, int]]] = None"}],parametersDescription:[{anchor:"transformers.HybridCache.config",description:"<strong>config</strong> (`PretrainedConfig) &#x2014;\nThe configuration file defining the shape-related attributes required to initialize the static cache.",name:"config"},{anchor:"transformers.HybridCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used.`,name:"batch_size"},{anchor:"transformers.HybridCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.HybridCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;cpu&quot;</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"},{anchor:"transformers.HybridCache.dtype",description:`<strong>dtype</strong> (torch.dtype, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.HybridCache.layer_device_map(`Dict[int,",description:"<strong>layer_device_map(`Dict[int,</strong> Union[str, torch.device, int]]]<code>, </code>optional<code>) -- Mapping between the layers and its device. This is required when you are manually initializing the cache and the model is splitted between differents gpus. You can know which layers mapped to which device by checking the associated device_map: </code>model.hf_device_map`.",name:"layer_device_map(`Dict[int,"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1573"}}),mr=new Z({props:{anchor:"transformers.HybridCache.example",$$slots:{default:[iZ]},$$scope:{ctx:j}}}),di=new v({props:{name:"update",anchor:"transformers.HybridCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1712"}}),pi=new v({props:{name:"get_seq_length",anchor:"transformers.HybridCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1741"}}),mi=new v({props:{name:"reset",anchor:"transformers.HybridCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1752"}}),gi=new v({props:{name:"class transformers.SlidingWindowCache",anchor:"transformers.SlidingWindowCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"max_cache_len",val:": int = None"},{name:"device",val:": device = None"},{name:"dtype",val:": dtype = torch.float32"},{name:"max_batch_size",val:": typing.Optional[int] = None"},{name:"layer_device_map",val:": typing.Optional[typing.Dict[int, typing.Union[str, torch.device, int]]] = None"}],parametersDescription:[{anchor:"transformers.SlidingWindowCache.config",description:`<strong>config</strong> (<code>PretrainedConfig</code>) &#x2014;
The configuration file defining the shape-related attributes required to initialize the static cache.`,name:"config"},{anchor:"transformers.SlidingWindowCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used.`,name:"batch_size"},{anchor:"transformers.SlidingWindowCache.max_cache_len",description:`<strong>max_cache_len</strong> (<code>int</code>) &#x2014;
The maximum sequence length with which the model will be used.`,name:"max_cache_len"},{anchor:"transformers.SlidingWindowCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"},{anchor:"transformers.SlidingWindowCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.SlidingWindowCache.layer_device_map(`Dict[int,",description:"<strong>layer_device_map(`Dict[int,</strong> Union[str, torch.device, int]]]<code>, </code>optional<code>) -- Mapping between the layers and its device. This is required when you are manually initializing the cache and the model is splitted between differents gpus. You can know which layers mapped to which device by checking the associated device_map: </code>model.hf_device_map`.",name:"layer_device_map(`Dict[int,"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1256"}}),hr=new Z({props:{anchor:"transformers.SlidingWindowCache.example",$$slots:{default:[dZ]},$$scope:{ctx:j}}}),hi=new v({props:{name:"update",anchor:"transformers.SlidingWindowCache.update",parameters:[{name:"key_states",val:": Tensor"},{name:"value_states",val:": Tensor"},{name:"layer_idx",val:": int"},{name:"cache_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1339"}}),ui=new v({props:{name:"reset",anchor:"transformers.SlidingWindowCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1389"}}),fi=new v({props:{name:"class transformers.EncoderDecoderCache",anchor:"transformers.EncoderDecoderCache",parameters:[{name:"self_attention_cache",val:": Cache"},{name:"cross_attention_cache",val:": Cache"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1396"}}),ur=new Z({props:{anchor:"transformers.EncoderDecoderCache.example",$$slots:{default:[pZ]},$$scope:{ctx:j}}}),_i=new v({props:{name:"get_seq_length",anchor:"transformers.EncoderDecoderCache.get_seq_length",parameters:[{name:"layer_idx",val:": typing.Optional[int] = 0"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1484"}}),bi=new v({props:{name:"to_legacy_cache",anchor:"transformers.EncoderDecoderCache.to_legacy_cache",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1453"}}),yi=new v({props:{name:"from_legacy_cache",anchor:"transformers.EncoderDecoderCache.from_legacy_cache",parameters:[{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1465"}}),Ti=new v({props:{name:"reset",anchor:"transformers.EncoderDecoderCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1489"}}),Mi=new v({props:{name:"reorder_cache",anchor:"transformers.EncoderDecoderCache.reorder_cache",parameters:[{name:"beam_idx",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1504"}}),vi=new v({props:{name:"class transformers.MambaCache",anchor:"transformers.MambaCache",parameters:[{name:"config",val:": PretrainedConfig"},{name:"batch_size",val:": int = None"},{name:"dtype",val:": dtype = torch.float16"},{name:"device",val:": typing.Union[torch.device, str, NoneType] = None"},{name:"max_batch_size",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"transformers.MambaCache.config",description:"<strong>config</strong> (`PretrainedConfig) &#x2014;\nThe configuration file defining the shape-related attributes required to initialize the static cache.",name:"config"},{anchor:"transformers.MambaCache.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
The batch size with which the model will be used. Note that a new instance must be instantiated if a
smaller batch size is used.`,name:"batch_size"},{anchor:"transformers.MambaCache.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float16</code>) &#x2014;
The default <code>dtype</code> to use when initializing the layer.`,name:"dtype"},{anchor:"transformers.MambaCache.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code>, <em>optional</em>) &#x2014;
The device on which the cache should be initialized. Should be the same as the layer.`,name:"device"},{anchor:"transformers.MambaCache.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>):
The default <code>dtype</code> used to initializing the cache.`,name:"dtype"},{anchor:"transformers.MambaCache.intermediate_size",description:`<strong>intermediate_size</strong> &#x2014; (<code>int</code>):
Model&#x2019;s intermediate_size taken from config.`,name:"intermediate_size"},{anchor:"transformers.MambaCache.ssm_state_size",description:`<strong>ssm_state_size</strong> &#x2014; (<code>int</code>):
Model&#x2019;s state_size taken from config.`,name:"ssm_state_size"},{anchor:"transformers.MambaCache.conv_kernel_size",description:`<strong>conv_kernel_size</strong> &#x2014; (<code>int</code>):
Model&#x2019;s convolution kernel size taken from config`,name:"conv_kernel_size"},{anchor:"transformers.MambaCache.conv_states",description:`<strong>conv_states</strong> &#x2014; (<code>torch.Tensor</code>):
A tensor of shape <code>[layer_idx, batch_size, intermediate_size, conv_kernel_size]</code> that holds convolutional states.`,name:"conv_states"},{anchor:"transformers.MambaCache.ssm_states",description:`<strong>ssm_states</strong> &#x2014; (<code>torch.Tensor</code>):
A tensor of shape <code>[layer_idx, batch_size, intermediate_size, ssm_state_size]</code> that holds ssm states`,name:"ssm_states"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1760"}}),Tr=new Z({props:{anchor:"transformers.MambaCache.example",$$slots:{default:[mZ]},$$scope:{ctx:j}}}),wi=new v({props:{name:"update_conv_state",anchor:"transformers.MambaCache.update_conv_state",parameters:[{name:"layer_idx",val:": int"},{name:"new_conv_state",val:": Tensor"},{name:"cache_position",val:": LongTensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1847"}}),ki=new v({props:{name:"update_ssm_state",anchor:"transformers.MambaCache.update_ssm_state",parameters:[{name:"layer_idx",val:": int"},{name:"new_ssm_state",val:": Tensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1859"}}),$i=new v({props:{name:"reset",anchor:"transformers.MambaCache.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/cache_utils.py#L1863"}}),ji=new ye({props:{title:"Watermark Utils",local:"transformers.WatermarkingConfig",headingTag:"h2"}}),xi=new v({props:{name:"class transformers.WatermarkingConfig",anchor:"transformers.WatermarkingConfig",parameters:[{name:"greenlist_ratio",val:": typing.Optional[float] = 0.25"},{name:"bias",val:": typing.Optional[float] = 2.0"},{name:"hashing_key",val:": typing.Optional[int] = 15485863"},{name:"seeding_scheme",val:": typing.Optional[str] = 'lefthash'"},{name:"context_width",val:": typing.Optional[int] = 1"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/configuration_utils.py#L1383"}}),Ji=new v({props:{name:"__call__",anchor:"transformers.WatermarkingConfig.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Ui=new v({props:{name:"class transformers.WatermarkDetector",anchor:"transformers.WatermarkDetector",parameters:[{name:"model_config",val:": PretrainedConfig"},{name:"device",val:": str"},{name:"watermarking_config",val:": typing.Union[transformers.generation.configuration_utils.WatermarkingConfig, typing.Dict]"},{name:"ignore_repeated_ngrams",val:": bool = False"},{name:"max_cache_size",val:": int = 128"}],parametersDescription:[{anchor:"transformers.WatermarkDetector.model_config",description:`<strong>model_config</strong> (<code>PretrainedConfig</code>) &#x2014;
The model config that will be used to get model specific arguments used when generating.`,name:"model_config"},{anchor:"transformers.WatermarkDetector.device",description:`<strong>device</strong> (<code>str</code>) &#x2014;
The device which was used during watermarked text generation.`,name:"device"},{anchor:"transformers.WatermarkDetector.watermarking_config",description:`<strong>watermarking_config</strong> (Union[<code>WatermarkingConfig</code>, <code>Dict</code>]) &#x2014;
The exact same watermarking config and arguments used when generating text.`,name:"watermarking_config"},{anchor:"transformers.WatermarkDetector.ignore_repeated_ngrams",description:`<strong>ignore_repeated_ngrams</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to count every unique ngram only once or not.`,name:"ignore_repeated_ngrams"},{anchor:"transformers.WatermarkDetector.max_cache_size",description:`<strong>max_cache_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The max size to be used for LRU caching of seeding/sampling algorithms called for every token.`,name:"max_cache_size"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/watermarking.py#L73"}}),vr=new Z({props:{anchor:"transformers.WatermarkDetector.example",$$slots:{default:[gZ]},$$scope:{ctx:j}}}),Zi=new v({props:{name:"__call__",anchor:"transformers.WatermarkDetector.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"z_threshold",val:": float = 3.0"},{name:"return_dict",val:": bool = False"}],parametersDescription:[{anchor:"transformers.WatermarkDetector.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The watermark generated text. It is advised to remove the prompt, which can affect the detection.`,name:"input_ids"},{anchor:"transformers.WatermarkDetector.__call__.z_threshold",description:`<strong>z_threshold</strong> (<code>Dict</code>, <em>optional</em>, defaults to <code>3.0</code>) &#x2014;
Changing this threshold will change the sensitivity of the detector. Higher z threshold gives less
sensitivity and vice versa for lower z threshold.`,name:"z_threshold"},{anchor:"transformers.WatermarkDetector.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>,  <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return <code>~generation.WatermarkDetectorOutput</code> or not. If not it will return boolean predictions,`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/watermarking.py#L193",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>WatermarkDetectorOutput</code>
if <code>return_dict=True</code> otherwise a <code>np.array</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>WatermarkDetectorOutput</code> or <code>np.array</code></p>
`}}),Ci=new v({props:{name:"class transformers.BayesianDetectorConfig",anchor:"transformers.BayesianDetectorConfig",parameters:[{name:"watermarking_depth",val:": int = None"},{name:"base_rate",val:": float = 0.5"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BayesianDetectorConfig.watermarking_depth",description:`<strong>watermarking_depth</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of tournament layers.`,name:"watermarking_depth"},{anchor:"transformers.BayesianDetectorConfig.base_rate",description:`<strong>base_rate</strong> (<code>float1</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Prior probability P(w) that a text is watermarked.`,name:"base_rate"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/watermarking.py#L245"}}),Wi=new v({props:{name:"class transformers.BayesianDetectorModel",anchor:"transformers.BayesianDetectorModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.BayesianDetectorModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.BayesianDetectorConfig">BayesianDetectorConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_30530/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/watermarking.py#L352"}}),Bi=new v({props:{name:"forward",anchor:"transformers.BayesianDetectorModel.forward",parameters:[{name:"g_values",val:": Tensor"},{name:"mask",val:": Tensor"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"loss_batch_weight",val:" = 1"},{name:"return_dict",val:" = False"}],parametersDescription:[{anchor:"transformers.BayesianDetectorModel.forward.g_values",description:`<strong>g_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, seq_len, watermarking_depth, ...)</code>) &#x2014;
g-values (with values 0 or 1)`,name:"g_values"},{anchor:"transformers.BayesianDetectorModel.forward.mask",description:`<strong>mask</strong> &#x2014;
A binary array shape [batch_size, seq_len] indicating which g-values should be used. g-values with mask
value 0 are discarded.`,name:"mask"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/watermarking.py#L438",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>p(watermarked | g_values), of shape [batch_size].</p>
`}}),Ii=new v({props:{name:"class transformers.SynthIDTextWatermarkingConfig",anchor:"transformers.SynthIDTextWatermarkingConfig",parameters:[{name:"ngram_len",val:": int"},{name:"keys",val:": typing.List[int]"},{name:"context_history_size",val:": int = 1024"},{name:"sampling_table_seed",val:": int = 0"},{name:"sampling_table_size",val:": int = 65536"},{name:"skip_first_ngram_calls",val:": bool = False"},{name:"debug_mode",val:": bool = False"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkingConfig.ngram_len",description:`<strong>ngram_len</strong> (<code>int</code>) &#x2014;
Ngram length.`,name:"ngram_len"},{anchor:"transformers.SynthIDTextWatermarkingConfig.keys",description:`<strong>keys</strong> (<code>List[int]</code>) &#x2014;
A sequence of watermarking keys, one for each depth.`,name:"keys"},{anchor:"transformers.SynthIDTextWatermarkingConfig.context_history_size",description:`<strong>context_history_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Size of the tensor to keep track of seen contexts.`,name:"context_history_size"},{anchor:"transformers.SynthIDTextWatermarkingConfig.sampling_table_seed",description:`<strong>sampling_table_seed</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Random seed to generate the sampling table.`,name:"sampling_table_seed"},{anchor:"transformers.SynthIDTextWatermarkingConfig.sampling_table_size",description:`<strong>sampling_table_size</strong> (<code>int</code>, <em>optional</em>, defaults to 65536) &#x2014;
Size of the sampling table.`,name:"sampling_table_size"},{anchor:"transformers.SynthIDTextWatermarkingConfig.skip_first_ngram_calls",description:`<strong>skip_first_ngram_calls</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip first ngram calls.`,name:"skip_first_ngram_calls"},{anchor:"transformers.SynthIDTextWatermarkingConfig.debug_mode",description:`<strong>debug_mode</strong> (<code>bool</code>, optional, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Logits are modified to uniform one got before watermarking modification is applied. This is to test the
implementation.`,name:"debug_mode"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/configuration_utils.py#L1461"}}),$r=new Z({props:{anchor:"transformers.SynthIDTextWatermarkingConfig.example",$$slots:{default:[hZ]},$$scope:{ctx:j}}}),zi=new v({props:{name:"class transformers.SynthIDTextWatermarkDetector",anchor:"transformers.SynthIDTextWatermarkDetector",parameters:[{name:"detector_module",val:": BayesianDetectorModel"},{name:"logits_processor",val:": SynthIDTextWatermarkLogitsProcessor"},{name:"tokenizer",val:": typing.Any"}],parametersDescription:[{anchor:"transformers.SynthIDTextWatermarkDetector.detector_module",description:`<strong>detector_module</strong> (<a href="/docs/transformers/pr_30530/en/internal/generation_utils#transformers.BayesianDetectorModel">BayesianDetectorModel</a>) &#x2014;
Bayesian detector module object initialized with parameters.
Check examples/research_projects/synthid_text/detector_training.py for usage.`,name:"detector_module"},{anchor:"transformers.SynthIDTextWatermarkDetector.logits_processor",description:`<strong>logits_processor</strong> (<code>SynthIDTextWatermarkLogitsProcessor</code>) &#x2014;
The logits processor used for watermarking.`,name:"logits_processor"},{anchor:"transformers.SynthIDTextWatermarkDetector.tokenizer",description:`<strong>tokenizer</strong> (<code>Any</code>) &#x2014;
The tokenizer used for the model.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/watermarking.py#L482"}}),jr=new Z({props:{anchor:"transformers.SynthIDTextWatermarkDetector.example",$$slots:{default:[uZ]},$$scope:{ctx:j}}}),Vi=new v({props:{name:"__call__",anchor:"transformers.SynthIDTextWatermarkDetector.__call__",parameters:[{name:"tokenized_outputs",val:": Tensor"}],source:"https://github.com/huggingface/transformers/blob/vr_30530/src/transformers/generation/watermarking.py#L529"}}),Gi=new f3({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/internal/generation_utils.md"}}),{c(){c=o("meta"),$=r(),y=o("p"),d=r(),m(w.$$.fragment),s=r(),k=o("p"),k.innerHTML=V1,zf=r(),m(Gr.$$.fragment),Vf=r(),Fr=o("p"),Fr.innerHTML=G1,Gf=r(),Xr=o("p"),Xr.textContent=F1,Ff=r(),m(Rr.$$.fragment),Xf=r(),Lr=o("p"),Lr.innerHTML=X1,Rf=r(),Sr=o("ul"),Sr.innerHTML=R1,Lf=r(),Nr=o("p"),Nr.innerHTML=L1,Sf=r(),Hr=o("p"),Hr.innerHTML=S1,Nf=r(),Er=o("p"),Er.innerHTML=N1,Hf=r(),m(qr.$$.fragment),Ef=r(),Dr=o("p"),Dr.innerHTML=H1,qf=r(),Qr=o("p"),Qr.innerHTML=E1,Df=r(),Yr=o("p"),Yr.textContent=q1,Qf=r(),m(Pr.$$.fragment),Yf=r(),ms=o("div"),m(Ar.$$.fragment),pT=r(),td=o("p"),td.textContent=D1,Pf=r(),gs=o("div"),m(Or.$$.fragment),mT=r(),sd=o("p"),sd.textContent=Q1,Af=r(),hs=o("div"),m(Kr.$$.fragment),gT=r(),nd=o("p"),nd.textContent=Y1,Of=r(),us=o("div"),m(ea.$$.fragment),hT=r(),rd=o("p"),rd.textContent=P1,Kf=r(),m(ta.$$.fragment),e_=r(),fs=o("div"),m(sa.$$.fragment),uT=r(),ad=o("p"),ad.textContent=A1,t_=r(),_s=o("div"),m(na.$$.fragment),fT=r(),od=o("p"),od.textContent=O1,s_=r(),bs=o("div"),m(ra.$$.fragment),_T=r(),ld=o("p"),ld.textContent=K1,n_=r(),ys=o("div"),m(aa.$$.fragment),bT=r(),cd=o("p"),cd.textContent=e$,r_=r(),Ts=o("div"),m(oa.$$.fragment),yT=r(),id=o("p"),id.textContent=t$,a_=r(),Ms=o("div"),m(la.$$.fragment),TT=r(),dd=o("p"),dd.textContent=s$,o_=r(),vs=o("div"),m(ca.$$.fragment),MT=r(),pd=o("p"),pd.textContent=n$,l_=r(),ws=o("div"),m(ia.$$.fragment),vT=r(),md=o("p"),md.textContent=r$,c_=r(),ks=o("div"),m(da.$$.fragment),wT=r(),gd=o("p"),gd.textContent=a$,i_=r(),$s=o("div"),m(pa.$$.fragment),kT=r(),hd=o("p"),hd.textContent=o$,d_=r(),m(ma.$$.fragment),p_=r(),et=o("div"),m(ga.$$.fragment),$T=r(),ud=o("p"),ud.textContent=l$,jT=r(),Is=o("div"),m(ha.$$.fragment),xT=r(),fd=o("p"),fd.textContent=c$,m_=r(),tt=o("div"),m(ua.$$.fragment),JT=r(),_d=o("p"),_d.textContent=i$,UT=r(),zs=o("div"),m(fa.$$.fragment),ZT=r(),bd=o("p"),bd.textContent=d$,g_=r(),st=o("div"),m(_a.$$.fragment),CT=r(),yd=o("p"),yd.textContent=p$,WT=r(),Vs=o("div"),m(ba.$$.fragment),BT=r(),Td=o("p"),Td.textContent=m$,h_=r(),m(ya.$$.fragment),u_=r(),Ta=o("p"),Ta.innerHTML=g$,f_=r(),m(Ma.$$.fragment),__=r(),ke=o("div"),m(va.$$.fragment),IT=r(),Md=o("p"),Md.innerHTML=h$,zT=r(),m(Gs.$$.fragment),VT=r(),vd=o("div"),m(wa.$$.fragment),b_=r(),S=o("div"),m(ka.$$.fragment),GT=r(),wd=o("p"),wd.innerHTML=u$,FT=r(),kd=o("p"),kd.innerHTML=f$,XT=r(),m(Fs.$$.fragment),RT=r(),m(Xs.$$.fragment),LT=r(),$d=o("div"),m($a.$$.fragment),y_=r(),se=o("div"),m(ja.$$.fragment),ST=r(),jd=o("p"),jd.innerHTML=_$,NT=r(),xd=o("p"),xd.textContent=b$,HT=r(),m(Rs.$$.fragment),ET=r(),Jd=o("div"),m(xa.$$.fragment),T_=r(),ne=o("div"),m(Ja.$$.fragment),qT=r(),Ud=o("p"),Ud.innerHTML=y$,DT=r(),Zd=o("p"),Zd.textContent=T$,QT=r(),m(Ls.$$.fragment),YT=r(),Cd=o("div"),m(Ua.$$.fragment),M_=r(),$e=o("div"),m(Za.$$.fragment),PT=r(),Wd=o("p"),Wd.innerHTML=M$,AT=r(),m(Ss.$$.fragment),OT=r(),Bd=o("div"),m(Ca.$$.fragment),v_=r(),je=o("div"),m(Wa.$$.fragment),KT=r(),Id=o("p"),Id.innerHTML=v$,eM=r(),m(Ns.$$.fragment),tM=r(),zd=o("div"),m(Ba.$$.fragment),w_=r(),xe=o("div"),m(Ia.$$.fragment),sM=r(),Vd=o("p"),Vd.innerHTML=w$,nM=r(),m(Hs.$$.fragment),rM=r(),Gd=o("div"),m(za.$$.fragment),k_=r(),Je=o("div"),m(Va.$$.fragment),aM=r(),Fd=o("p"),Fd.innerHTML=k$,oM=r(),m(Es.$$.fragment),lM=r(),Xd=o("div"),m(Ga.$$.fragment),$_=r(),Ue=o("div"),m(Fa.$$.fragment),cM=r(),Rd=o("p"),Rd.innerHTML=$$,iM=r(),m(qs.$$.fragment),dM=r(),Ld=o("div"),m(Xa.$$.fragment),j_=r(),N=o("div"),m(Ra.$$.fragment),pM=r(),Sd=o("p"),Sd.innerHTML=j$,mM=r(),Nd=o("p"),Nd.innerHTML=x$,gM=r(),Hd=o("p"),Hd.innerHTML=J$,hM=r(),m(Ds.$$.fragment),uM=r(),Ed=o("div"),m(La.$$.fragment),x_=r(),Ze=o("div"),m(Sa.$$.fragment),fM=r(),qd=o("p"),qd.innerHTML=U$,_M=r(),Dd=o("p"),Dd.innerHTML=Z$,bM=r(),Qd=o("div"),m(Na.$$.fragment),J_=r(),Ce=o("div"),m(Ha.$$.fragment),yM=r(),Yd=o("p"),Yd.innerHTML=C$,TM=r(),m(Qs.$$.fragment),MM=r(),Pd=o("div"),m(Ea.$$.fragment),U_=r(),nt=o("div"),m(qa.$$.fragment),vM=r(),Ad=o("p"),Ad.textContent=W$,wM=r(),Od=o("div"),m(Da.$$.fragment),Z_=r(),rt=o("div"),m(Qa.$$.fragment),kM=r(),Kd=o("p"),Kd.innerHTML=B$,$M=r(),ep=o("div"),m(Ya.$$.fragment),C_=r(),We=o("div"),m(Pa.$$.fragment),jM=r(),tp=o("p"),tp.innerHTML=I$,xM=r(),m(Ys.$$.fragment),JM=r(),sp=o("div"),m(Aa.$$.fragment),W_=r(),Be=o("div"),m(Oa.$$.fragment),UM=r(),np=o("p"),np.innerHTML=z$,ZM=r(),m(Ps.$$.fragment),CM=r(),rp=o("div"),m(Ka.$$.fragment),B_=r(),H=o("div"),m(eo.$$.fragment),WM=r(),ap=o("p"),ap.innerHTML=V$,BM=r(),op=o("p"),op.innerHTML=G$,IM=r(),lp=o("p"),lp.innerHTML=F$,zM=r(),m(As.$$.fragment),VM=r(),cp=o("div"),m(to.$$.fragment),I_=r(),re=o("div"),m(so.$$.fragment),GM=r(),ip=o("p"),ip.innerHTML=X$,FM=r(),m(Os.$$.fragment),XM=r(),m(Ks.$$.fragment),RM=r(),dp=o("div"),m(no.$$.fragment),z_=r(),ae=o("div"),m(ro.$$.fragment),LM=r(),pp=o("p"),pp.innerHTML=R$,SM=r(),m(en.$$.fragment),NM=r(),m(tn.$$.fragment),HM=r(),mp=o("div"),m(ao.$$.fragment),V_=r(),Ie=o("div"),m(oo.$$.fragment),EM=r(),gp=o("p"),gp.innerHTML=L$,qM=r(),m(sn.$$.fragment),DM=r(),hp=o("div"),m(lo.$$.fragment),G_=r(),oe=o("div"),m(co.$$.fragment),QM=r(),up=o("p"),up.innerHTML=S$,YM=r(),fp=o("p"),fp.innerHTML=N$,PM=r(),m(nn.$$.fragment),AM=r(),_p=o("div"),m(io.$$.fragment),F_=r(),le=o("div"),m(po.$$.fragment),OM=r(),bp=o("p"),bp.innerHTML=H$,KM=r(),m(rn.$$.fragment),ev=r(),m(an.$$.fragment),tv=r(),yp=o("div"),m(mo.$$.fragment),X_=r(),ze=o("div"),m(go.$$.fragment),sv=r(),Tp=o("p"),Tp.innerHTML=E$,nv=r(),m(on.$$.fragment),rv=r(),Mp=o("div"),m(ho.$$.fragment),R_=r(),Ve=o("div"),m(uo.$$.fragment),av=r(),vp=o("p"),vp.innerHTML=q$,ov=r(),m(ln.$$.fragment),lv=r(),wp=o("div"),m(fo.$$.fragment),L_=r(),G=o("div"),m(_o.$$.fragment),cv=r(),kp=o("p"),kp.textContent=D$,iv=r(),$p=o("p"),$p.textContent=Q$,dv=r(),jp=o("ul"),jp.innerHTML=Y$,pv=r(),xp=o("p"),xp.innerHTML=P$,mv=r(),m(cn.$$.fragment),gv=r(),Jp=o("div"),m(bo.$$.fragment),S_=r(),ce=o("div"),m(yo.$$.fragment),hv=r(),Up=o("p"),Up.innerHTML=A$,uv=r(),m(dn.$$.fragment),fv=r(),m(pn.$$.fragment),_v=r(),Zp=o("div"),m(To.$$.fragment),N_=r(),Ge=o("div"),m(Mo.$$.fragment),bv=r(),Cp=o("p"),Cp.innerHTML=O$,yv=r(),m(mn.$$.fragment),Tv=r(),Wp=o("div"),m(vo.$$.fragment),H_=r(),Fe=o("div"),m(wo.$$.fragment),Mv=r(),Bp=o("p"),Bp.innerHTML=K$,vv=r(),m(gn.$$.fragment),wv=r(),Ip=o("div"),m(ko.$$.fragment),E_=r(),ie=o("div"),m($o.$$.fragment),kv=r(),zp=o("p"),zp.innerHTML=ej,$v=r(),Vp=o("p"),Vp.innerHTML=tj,jv=r(),m(hn.$$.fragment),xv=r(),Gp=o("div"),m(jo.$$.fragment),q_=r(),de=o("div"),m(xo.$$.fragment),Jv=r(),Fp=o("p"),Fp.innerHTML=sj,Uv=r(),Xp=o("p"),Xp.innerHTML=nj,Zv=r(),m(un.$$.fragment),Cv=r(),Rp=o("div"),m(Jo.$$.fragment),D_=r(),pe=o("div"),m(Uo.$$.fragment),Wv=r(),Lp=o("p"),Lp.innerHTML=rj,Bv=r(),Sp=o("p"),Sp.innerHTML=aj,Iv=r(),m(fn.$$.fragment),zv=r(),Np=o("div"),m(Zo.$$.fragment),Q_=r(),E=o("div"),m(Co.$$.fragment),Vv=r(),Hp=o("p"),Hp.innerHTML=oj,Gv=r(),Ep=o("p"),Ep.innerHTML=lj,Fv=r(),qp=o("p"),qp.innerHTML=cj,Xv=r(),m(_n.$$.fragment),Rv=r(),Dp=o("div"),m(Wo.$$.fragment),Y_=r(),m(Bo.$$.fragment),P_=r(),at=o("div"),m(Io.$$.fragment),Lv=r(),Qp=o("p"),Qp.innerHTML=ij,Sv=r(),Yp=o("div"),m(zo.$$.fragment),A_=r(),ot=o("div"),m(Vo.$$.fragment),Nv=r(),Pp=o("p"),Pp.innerHTML=dj,Hv=r(),Ap=o("div"),m(Go.$$.fragment),O_=r(),lt=o("div"),m(Fo.$$.fragment),Ev=r(),Op=o("p"),Op.innerHTML=pj,qv=r(),Kp=o("div"),m(Xo.$$.fragment),K_=r(),ct=o("div"),m(Ro.$$.fragment),Dv=r(),em=o("p"),em.textContent=mj,Qv=r(),bn=o("div"),m(Lo.$$.fragment),Yv=r(),tm=o("p"),tm.textContent=gj,eb=r(),it=o("div"),m(So.$$.fragment),Pv=r(),sm=o("p"),sm.innerHTML=hj,Av=r(),nm=o("div"),m(No.$$.fragment),tb=r(),dt=o("div"),m(Ho.$$.fragment),Ov=r(),rm=o("p"),rm.textContent=uj,Kv=r(),yn=o("div"),m(Eo.$$.fragment),ew=r(),am=o("p"),am.textContent=fj,sb=r(),pt=o("div"),m(qo.$$.fragment),tw=r(),om=o("p"),om.innerHTML=_j,sw=r(),lm=o("div"),m(Do.$$.fragment),nb=r(),mt=o("div"),m(Qo.$$.fragment),nw=r(),cm=o("p"),cm.innerHTML=bj,rw=r(),im=o("div"),m(Yo.$$.fragment),rb=r(),gt=o("div"),m(Po.$$.fragment),aw=r(),dm=o("p"),dm.innerHTML=yj,ow=r(),pm=o("div"),m(Ao.$$.fragment),ab=r(),ht=o("div"),m(Oo.$$.fragment),lw=r(),mm=o("p"),mm.innerHTML=Tj,cw=r(),gm=o("div"),m(Ko.$$.fragment),ob=r(),ut=o("div"),m(el.$$.fragment),iw=r(),hm=o("p"),hm.innerHTML=Mj,dw=r(),um=o("div"),m(tl.$$.fragment),lb=r(),ft=o("div"),m(sl.$$.fragment),pw=r(),fm=o("p"),fm.innerHTML=vj,mw=r(),_m=o("div"),m(nl.$$.fragment),cb=r(),_t=o("div"),m(rl.$$.fragment),gw=r(),bm=o("p"),bm.innerHTML=wj,hw=r(),ym=o("div"),m(al.$$.fragment),ib=r(),bt=o("div"),m(ol.$$.fragment),uw=r(),Tm=o("p"),Tm.innerHTML=kj,fw=r(),Mm=o("div"),m(ll.$$.fragment),db=r(),yt=o("div"),m(cl.$$.fragment),_w=r(),vm=o("p"),vm.innerHTML=$j,bw=r(),wm=o("div"),m(il.$$.fragment),pb=r(),m(dl.$$.fragment),mb=r(),Tt=o("div"),m(pl.$$.fragment),yw=r(),km=o("p"),km.innerHTML=jj,Tw=r(),$m=o("div"),m(ml.$$.fragment),gb=r(),Mt=o("div"),m(gl.$$.fragment),Mw=r(),jm=o("p"),jm.innerHTML=xj,vw=r(),xm=o("div"),m(hl.$$.fragment),hb=r(),vt=o("div"),m(ul.$$.fragment),ww=r(),Jm=o("p"),Jm.innerHTML=Jj,kw=r(),Um=o("div"),m(fl.$$.fragment),ub=r(),wt=o("div"),m(_l.$$.fragment),$w=r(),Zm=o("p"),Zm.textContent=Uj,jw=r(),Tn=o("div"),m(bl.$$.fragment),xw=r(),Cm=o("p"),Cm.textContent=Zj,fb=r(),kt=o("div"),m(yl.$$.fragment),Jw=r(),Wm=o("p"),Wm.innerHTML=Cj,Uw=r(),Bm=o("div"),m(Tl.$$.fragment),_b=r(),$t=o("div"),m(Ml.$$.fragment),Zw=r(),Im=o("p"),Im.textContent=Wj,Cw=r(),Mn=o("div"),m(vl.$$.fragment),Ww=r(),zm=o("p"),zm.textContent=Bj,bb=r(),jt=o("div"),m(wl.$$.fragment),Bw=r(),Vm=o("p"),Vm.innerHTML=Ij,Iw=r(),Gm=o("div"),m(kl.$$.fragment),yb=r(),xt=o("div"),m($l.$$.fragment),zw=r(),Fm=o("p"),Fm.innerHTML=zj,Vw=r(),Xm=o("div"),m(jl.$$.fragment),Tb=r(),Jt=o("div"),m(xl.$$.fragment),Gw=r(),Rm=o("p"),Rm.innerHTML=Vj,Fw=r(),Lm=o("div"),m(Jl.$$.fragment),Mb=r(),Ut=o("div"),m(Ul.$$.fragment),Xw=r(),Sm=o("p"),Sm.innerHTML=Gj,Rw=r(),Nm=o("div"),m(Zl.$$.fragment),vb=r(),Zt=o("div"),m(Cl.$$.fragment),Lw=r(),Hm=o("p"),Hm.innerHTML=Fj,Sw=r(),Em=o("div"),m(Wl.$$.fragment),wb=r(),Ct=o("div"),m(Bl.$$.fragment),Nw=r(),qm=o("p"),qm.innerHTML=Xj,Hw=r(),Dm=o("div"),m(Il.$$.fragment),kb=r(),Wt=o("div"),m(zl.$$.fragment),Ew=r(),Qm=o("p"),Qm.innerHTML=Rj,qw=r(),Ym=o("div"),m(Vl.$$.fragment),$b=r(),m(Gl.$$.fragment),jb=r(),Fl=o("p"),Fl.innerHTML=Lj,xb=r(),Xe=o("div"),m(Xl.$$.fragment),Dw=r(),Pm=o("p"),Pm.textContent=Sj,Qw=r(),Am=o("p"),Am.innerHTML=Nj,Yw=r(),Om=o("div"),m(Rl.$$.fragment),Jb=r(),js=o("div"),m(Ll.$$.fragment),Pw=r(),Km=o("div"),m(Sl.$$.fragment),Ub=r(),Bt=o("div"),m(Nl.$$.fragment),Aw=r(),eg=o("p"),eg.innerHTML=Hj,Ow=r(),tg=o("div"),m(Hl.$$.fragment),Zb=r(),It=o("div"),m(El.$$.fragment),Kw=r(),sg=o("p"),sg.innerHTML=Ej,e0=r(),ng=o("div"),m(ql.$$.fragment),Cb=r(),J=o("div"),m(Dl.$$.fragment),t0=r(),rg=o("p"),rg.textContent=qj,s0=r(),ag=o("p"),ag.textContent=Dj,n0=r(),og=o("ul"),og.innerHTML=Qj,r0=r(),lg=o("p"),lg.textContent=Yj,a0=r(),cg=o("ul"),cg.innerHTML=Pj,o0=r(),ig=o("p"),ig.textContent=Aj,l0=r(),dg=o("p"),dg.textContent=Oj,c0=r(),pg=o("p"),pg.textContent=Kj,i0=r(),mg=o("ul"),mg.innerHTML=ex,d0=r(),gg=o("p"),gg.textContent=tx,p0=r(),hg=o("p"),hg.textContent=sx,m0=r(),ug=o("p"),ug.textContent=nx,g0=r(),fg=o("p"),fg.textContent=rx,h0=r(),_g=o("ul"),_g.innerHTML=ax,u0=r(),bg=o("p"),bg.textContent=ox,f0=r(),yg=o("p"),yg.textContent=lx,_0=r(),Tg=o("ul"),Tg.innerHTML=cx,b0=r(),Mg=o("p"),Mg.textContent=ix,y0=r(),vg=o("p"),vg.textContent=dx,T0=r(),m(vn.$$.fragment),M0=r(),wg=o("div"),m(Ql.$$.fragment),Wb=r(),zt=o("div"),m(Yl.$$.fragment),v0=r(),kg=o("p"),kg.innerHTML=px,w0=r(),$g=o("div"),m(Pl.$$.fragment),Bb=r(),m(Al.$$.fragment),Ib=r(),Ol=o("p"),Ol.innerHTML=mx,zb=r(),W=o("div"),m(Kl.$$.fragment),k0=r(),jg=o("p"),jg.textContent=gx,$0=r(),xg=o("p"),xg.textContent=hx,j0=r(),m(wn.$$.fragment),x0=r(),Jg=o("p"),Jg.textContent=ux,J0=r(),kn=o("div"),m(ec.$$.fragment),U0=r(),Ug=o("p"),Ug.textContent=fx,Z0=r(),$n=o("div"),m(tc.$$.fragment),C0=r(),Zg=o("p"),Zg.textContent=_x,W0=r(),jn=o("div"),m(sc.$$.fragment),B0=r(),Cg=o("p"),Cg.textContent=bx,I0=r(),xn=o("div"),m(nc.$$.fragment),z0=r(),Wg=o("p"),Wg.innerHTML=yx,V0=r(),Jn=o("div"),m(rc.$$.fragment),G0=r(),Bg=o("p"),Bg.textContent=Tx,F0=r(),Un=o("div"),m(ac.$$.fragment),X0=r(),Ig=o("p"),Ig.textContent=Mx,R0=r(),Kt=o("div"),m(oc.$$.fragment),L0=r(),zg=o("p"),zg.innerHTML=vx,S0=r(),Vg=o("p"),Vg.textContent=wx,Vb=r(),xs=o("div"),m(lc.$$.fragment),N0=r(),Gg=o("p"),Gg.innerHTML=kx,Gb=r(),Js=o("div"),m(cc.$$.fragment),H0=r(),Fg=o("p"),Fg.innerHTML=$x,Fb=r(),Re=o("div"),m(ic.$$.fragment),E0=r(),Xg=o("p"),Xg.textContent=jx,q0=r(),K=o("div"),m(dc.$$.fragment),D0=r(),Rg=o("p"),Rg.textContent=xx,Q0=r(),Lg=o("p"),Lg.innerHTML=Jx,Y0=r(),Sg=o("p"),Sg.innerHTML=Ux,P0=r(),Ng=o("p"),Ng.innerHTML=Zx,A0=r(),Hg=o("p"),Hg.textContent=Cx,O0=r(),Zn=o("div"),m(pc.$$.fragment),K0=r(),Eg=o("p"),Eg.textContent=Wx,Xb=r(),m(mc.$$.fragment),Rb=r(),Le=o("div"),m(gc.$$.fragment),e2=r(),qg=o("p"),qg.innerHTML=Bx,t2=r(),Dg=o("div"),m(hc.$$.fragment),s2=r(),Qg=o("div"),m(uc.$$.fragment),Lb=r(),q=o("div"),m(fc.$$.fragment),n2=r(),Yg=o("p"),Yg.innerHTML=Ix,r2=r(),Pg=o("p"),Pg.innerHTML=zx,a2=r(),Ag=o("p"),Ag.innerHTML=Vx,o2=r(),Og=o("div"),m(_c.$$.fragment),l2=r(),Kg=o("div"),m(bc.$$.fragment),Sb=r(),Se=o("div"),m(yc.$$.fragment),c2=r(),eh=o("p"),eh.innerHTML=Gx,i2=r(),th=o("div"),m(Tc.$$.fragment),d2=r(),sh=o("div"),m(Mc.$$.fragment),Nb=r(),m(vc.$$.fragment),Hb=r(),F=o("div"),m(wc.$$.fragment),p2=r(),nh=o("p"),nh.textContent=Fx,m2=r(),m(Cn.$$.fragment),g2=r(),m(Wn.$$.fragment),h2=r(),Bn=o("div"),m(kc.$$.fragment),u2=r(),rh=o("p"),rh.textContent=Xx,f2=r(),In=o("div"),m($c.$$.fragment),_2=r(),ah=o("p"),ah.textContent=Rx,b2=r(),zn=o("div"),m(jc.$$.fragment),y2=r(),oh=o("p"),oh.textContent=Lx,Eb=r(),me=o("div"),m(xc.$$.fragment),T2=r(),lh=o("p"),lh.textContent=Sx,M2=r(),m(Vn.$$.fragment),v2=r(),m(Gn.$$.fragment),w2=r(),Fn=o("div"),m(Jc.$$.fragment),k2=r(),ch=o("p"),ch.textContent=Nx,qb=r(),m(Uc.$$.fragment),Db=r(),Vt=o("div"),m(Zc.$$.fragment),$2=r(),ih=o("p"),ih.textContent=Hx,j2=r(),Xn=o("div"),m(Cc.$$.fragment),x2=r(),dh=o("p"),dh.innerHTML=Ex,Qb=r(),Gt=o("div"),m(Wc.$$.fragment),J2=r(),ph=o("p"),ph.textContent=qx,U2=r(),Rn=o("div"),m(Bc.$$.fragment),Z2=r(),mh=o("p"),mh.innerHTML=Dx,Yb=r(),Ft=o("div"),m(Ic.$$.fragment),C2=r(),gh=o("p"),gh.textContent=Qx,W2=r(),Ln=o("div"),m(zc.$$.fragment),B2=r(),hh=o("p"),hh.textContent=Yx,Pb=r(),I=o("div"),m(Vc.$$.fragment),I2=r(),uh=o("p"),uh.textContent=Px,z2=r(),fh=o("p"),fh.innerHTML=Ax,V2=r(),m(Sn.$$.fragment),G2=r(),Nn=o("div"),m(Gc.$$.fragment),F2=r(),_h=o("p"),_h.innerHTML=Ox,X2=r(),Hn=o("div"),m(Fc.$$.fragment),R2=r(),bh=o("p"),bh.textContent=Kx,L2=r(),En=o("div"),m(Xc.$$.fragment),S2=r(),yh=o("p"),yh.textContent=eJ,N2=r(),qn=o("div"),m(Rc.$$.fragment),H2=r(),Th=o("p"),Th.innerHTML=tJ,E2=r(),Dn=o("div"),m(Lc.$$.fragment),q2=r(),Mh=o("p"),Mh.innerHTML=sJ,Ab=r(),D=o("div"),m(Sc.$$.fragment),D2=r(),vh=o("p"),vh.innerHTML=nJ,Q2=r(),wh=o("p"),wh.innerHTML=rJ,Y2=r(),kh=o("p"),kh.innerHTML=aJ,P2=r(),$h=o("div"),m(Nc.$$.fragment),A2=r(),Qn=o("div"),m(Hc.$$.fragment),O2=r(),jh=o("p"),jh.textContent=oJ,Ob=r(),Xt=o("div"),m(Ec.$$.fragment),K2=r(),xh=o("p"),xh.innerHTML=lJ,ek=r(),m(Yn.$$.fragment),Kb=r(),Rt=o("div"),m(qc.$$.fragment),tk=r(),Jh=o("p"),Jh.innerHTML=cJ,sk=r(),m(Pn.$$.fragment),ey=r(),X=o("div"),m(Dc.$$.fragment),nk=r(),Uh=o("p"),Uh.innerHTML=iJ,rk=r(),Zh=o("p"),Zh.innerHTML=dJ,ak=r(),m(An.$$.fragment),ok=r(),On=o("div"),m(Qc.$$.fragment),lk=r(),Ch=o("p"),Ch.innerHTML=pJ,ck=r(),Kn=o("div"),m(Yc.$$.fragment),ik=r(),Wh=o("p"),Wh.textContent=mJ,dk=r(),er=o("div"),m(Pc.$$.fragment),pk=r(),Bh=o("p"),Bh.textContent=gJ,ty=r(),Q=o("div"),m(Ac.$$.fragment),mk=r(),Ih=o("p"),Ih.textContent=hJ,gk=r(),zh=o("p"),zh.textContent=uJ,hk=r(),tr=o("div"),m(Oc.$$.fragment),uk=r(),Vh=o("p"),Vh.innerHTML=fJ,fk=r(),sr=o("div"),m(Kc.$$.fragment),_k=r(),Gh=o("p"),Gh.textContent=_J,bk=r(),nr=o("div"),m(ei.$$.fragment),yk=r(),Fh=o("p"),Fh.textContent=bJ,sy=r(),Y=o("div"),m(ti.$$.fragment),Tk=r(),Xh=o("p"),Xh.innerHTML=yJ,Mk=r(),m(rr.$$.fragment),vk=r(),ar=o("div"),m(si.$$.fragment),wk=r(),Rh=o("p"),Rh.innerHTML=TJ,kk=r(),or=o("div"),m(ni.$$.fragment),$k=r(),Lh=o("p"),Lh.textContent=MJ,jk=r(),lr=o("div"),m(ri.$$.fragment),xk=r(),Sh=o("p"),Sh.textContent=vJ,ny=r(),P=o("div"),m(ai.$$.fragment),Jk=r(),Nh=o("p"),Nh.innerHTML=wJ,Uk=r(),m(cr.$$.fragment),Zk=r(),ir=o("div"),m(oi.$$.fragment),Ck=r(),Hh=o("p"),Hh.innerHTML=kJ,Wk=r(),dr=o("div"),m(li.$$.fragment),Bk=r(),Eh=o("p"),Eh.textContent=$J,Ik=r(),pr=o("div"),m(ci.$$.fragment),zk=r(),qh=o("p"),qh.textContent=jJ,ry=r(),A=o("div"),m(ii.$$.fragment),Vk=r(),Dh=o("p"),Dh.innerHTML=xJ,Gk=r(),m(mr.$$.fragment),Fk=r(),Qh=o("div"),m(di.$$.fragment),Xk=r(),Yh=o("div"),m(pi.$$.fragment),Rk=r(),gr=o("div"),m(mi.$$.fragment),Lk=r(),Ph=o("p"),Ph.textContent=JJ,ay=r(),z=o("div"),m(gi.$$.fragment),Sk=r(),Ah=o("p"),Ah.innerHTML=UJ,Nk=r(),Oh=o("p"),Oh.innerHTML=ZJ,Hk=r(),Kh=o("p"),Kh.textContent=CJ,Ek=r(),eu=o("p"),eu.innerHTML=WJ,qk=r(),m(hr.$$.fragment),Dk=r(),tu=o("div"),m(hi.$$.fragment),Qk=r(),su=o("div"),m(ui.$$.fragment),oy=r(),V=o("div"),m(fi.$$.fragment),Yk=r(),nu=o("p"),nu.textContent=BJ,Pk=r(),m(ur.$$.fragment),Ak=r(),fr=o("div"),m(_i.$$.fragment),Ok=r(),ru=o("p"),ru.textContent=IJ,Kk=r(),_r=o("div"),m(bi.$$.fragment),e1=r(),au=o("p"),au.innerHTML=zJ,t1=r(),br=o("div"),m(yi.$$.fragment),s1=r(),ou=o("p"),ou.innerHTML=VJ,n1=r(),lu=o("div"),m(Ti.$$.fragment),r1=r(),yr=o("div"),m(Mi.$$.fragment),a1=r(),cu=o("p"),cu.textContent=GJ,ly=r(),O=o("div"),m(vi.$$.fragment),o1=r(),iu=o("p"),iu.textContent=FJ,l1=r(),m(Tr.$$.fragment),c1=r(),du=o("div"),m(wi.$$.fragment),i1=r(),pu=o("div"),m(ki.$$.fragment),d1=r(),mu=o("div"),m($i.$$.fragment),cy=r(),m(ji.$$.fragment),iy=r(),ge=o("div"),m(xi.$$.fragment),p1=r(),gu=o("p"),gu.innerHTML=XJ,m1=r(),hu=o("p"),hu.textContent=RJ,g1=r(),uu=o("ul"),uu.innerHTML=LJ,h1=r(),Mr=o("div"),m(Ji.$$.fragment),u1=r(),fu=o("p"),fu.textContent=SJ,dy=r(),he=o("div"),m(Ui.$$.fragment),f1=r(),_u=o("p"),_u.innerHTML=NJ,_1=r(),bu=o("p"),bu.innerHTML=HJ,b1=r(),m(vr.$$.fragment),y1=r(),wr=o("div"),m(Zi.$$.fragment),T1=r(),yu=o("p"),yu.textContent=EJ,py=r(),Lt=o("div"),m(Ci.$$.fragment),M1=r(),Tu=o("p"),Tu.innerHTML=qJ,v1=r(),Mu=o("p"),Mu.innerHTML=DJ,my=r(),R=o("div"),m(Wi.$$.fragment),w1=r(),vu=o("p"),vu.textContent=QJ,k1=r(),wu=o("p"),wu.innerHTML=YJ,$1=r(),ku=o("p"),ku.textContent=PJ,j1=r(),$u=o("p"),$u.innerHTML=AJ,x1=r(),ju=o("p"),ju.innerHTML=OJ,J1=r(),kr=o("div"),m(Bi.$$.fragment),U1=r(),xu=o("p"),xu.textContent=KJ,gy=r(),St=o("div"),m(Ii.$$.fragment),Z1=r(),Ju=o("p"),Ju.innerHTML=eU,C1=r(),m($r.$$.fragment),hy=r(),ue=o("div"),m(zi.$$.fragment),W1=r(),Uu=o("p"),Uu.textContent=tU,B1=r(),Zu=o("p"),Zu.textContent=sU,I1=r(),m(jr.$$.fragment),z1=r(),Cu=o("div"),m(Vi.$$.fragment),uy=r(),m(Gi.$$.fragment),fy=r(),bf=o("p"),this.h()},l(e){const i=u3("svelte-u9bgzb",document.head);c=l(i,"META",{name:!0,content:!0}),i.forEach(n),$=a(e),y=l(e,"P",{}),T(y).forEach(n),d=a(e),g(w.$$.fragment,e),s=a(e),k=l(e,"P",{"data-svelte-h":!0}),b(k)!=="svelte-1n1ljkt"&&(k.innerHTML=V1),zf=a(e),g(Gr.$$.fragment,e),Vf=a(e),Fr=l(e,"P",{"data-svelte-h":!0}),b(Fr)!=="svelte-86bzbr"&&(Fr.innerHTML=G1),Gf=a(e),Xr=l(e,"P",{"data-svelte-h":!0}),b(Xr)!=="svelte-wwwyth"&&(Xr.textContent=F1),Ff=a(e),g(Rr.$$.fragment,e),Xf=a(e),Lr=l(e,"P",{"data-svelte-h":!0}),b(Lr)!=="svelte-1b06rwa"&&(Lr.innerHTML=X1),Rf=a(e),Sr=l(e,"UL",{"data-svelte-h":!0}),b(Sr)!=="svelte-1arpy9m"&&(Sr.innerHTML=R1),Lf=a(e),Nr=l(e,"P",{"data-svelte-h":!0}),b(Nr)!=="svelte-xh59rv"&&(Nr.innerHTML=L1),Sf=a(e),Hr=l(e,"P",{"data-svelte-h":!0}),b(Hr)!=="svelte-rqavqw"&&(Hr.innerHTML=S1),Nf=a(e),Er=l(e,"P",{"data-svelte-h":!0}),b(Er)!=="svelte-qr02he"&&(Er.innerHTML=N1),Hf=a(e),g(qr.$$.fragment,e),Ef=a(e),Dr=l(e,"P",{"data-svelte-h":!0}),b(Dr)!=="svelte-114v74y"&&(Dr.innerHTML=H1),qf=a(e),Qr=l(e,"P",{"data-svelte-h":!0}),b(Qr)!=="svelte-13knclg"&&(Qr.innerHTML=E1),Df=a(e),Yr=l(e,"P",{"data-svelte-h":!0}),b(Yr)!=="svelte-gz8gow"&&(Yr.textContent=q1),Qf=a(e),g(Pr.$$.fragment,e),Yf=a(e),ms=l(e,"DIV",{class:!0});var Fi=T(ms);g(Ar.$$.fragment,Fi),pT=a(Fi),td=l(Fi,"P",{"data-svelte-h":!0}),b(td)!=="svelte-k7oes3"&&(td.textContent=D1),Fi.forEach(n),Pf=a(e),gs=l(e,"DIV",{class:!0});var Xi=T(gs);g(Or.$$.fragment,Xi),mT=a(Xi),sd=l(Xi,"P",{"data-svelte-h":!0}),b(sd)!=="svelte-111f3sj"&&(sd.textContent=Q1),Xi.forEach(n),Af=a(e),hs=l(e,"DIV",{class:!0});var Ri=T(hs);g(Kr.$$.fragment,Ri),gT=a(Ri),nd=l(Ri,"P",{"data-svelte-h":!0}),b(nd)!=="svelte-1j3b9cp"&&(nd.textContent=Y1),Ri.forEach(n),Of=a(e),us=l(e,"DIV",{class:!0});var Li=T(us);g(ea.$$.fragment,Li),hT=a(Li),rd=l(Li,"P",{"data-svelte-h":!0}),b(rd)!=="svelte-16r5px1"&&(rd.textContent=P1),Li.forEach(n),Kf=a(e),g(ta.$$.fragment,e),e_=a(e),fs=l(e,"DIV",{class:!0});var Si=T(fs);g(sa.$$.fragment,Si),uT=a(Si),ad=l(Si,"P",{"data-svelte-h":!0}),b(ad)!=="svelte-1bnrp61"&&(ad.textContent=A1),Si.forEach(n),t_=a(e),_s=l(e,"DIV",{class:!0});var Ni=T(_s);g(na.$$.fragment,Ni),fT=a(Ni),od=l(Ni,"P",{"data-svelte-h":!0}),b(od)!=="svelte-fenhkk"&&(od.textContent=O1),Ni.forEach(n),s_=a(e),bs=l(e,"DIV",{class:!0});var Hi=T(bs);g(ra.$$.fragment,Hi),_T=a(Hi),ld=l(Hi,"P",{"data-svelte-h":!0}),b(ld)!=="svelte-1dqtgq4"&&(ld.textContent=K1),Hi.forEach(n),n_=a(e),ys=l(e,"DIV",{class:!0});var Ei=T(ys);g(aa.$$.fragment,Ei),bT=a(Ei),cd=l(Ei,"P",{"data-svelte-h":!0}),b(cd)!=="svelte-10orfv5"&&(cd.textContent=e$),Ei.forEach(n),r_=a(e),Ts=l(e,"DIV",{class:!0});var qi=T(Ts);g(oa.$$.fragment,qi),yT=a(qi),id=l(qi,"P",{"data-svelte-h":!0}),b(id)!=="svelte-jg8udg"&&(id.textContent=t$),qi.forEach(n),a_=a(e),Ms=l(e,"DIV",{class:!0});var Di=T(Ms);g(la.$$.fragment,Di),TT=a(Di),dd=l(Di,"P",{"data-svelte-h":!0}),b(dd)!=="svelte-1i40667"&&(dd.textContent=s$),Di.forEach(n),o_=a(e),vs=l(e,"DIV",{class:!0});var Qi=T(vs);g(ca.$$.fragment,Qi),MT=a(Qi),pd=l(Qi,"P",{"data-svelte-h":!0}),b(pd)!=="svelte-n5fi8x"&&(pd.textContent=n$),Qi.forEach(n),l_=a(e),ws=l(e,"DIV",{class:!0});var Yi=T(ws);g(ia.$$.fragment,Yi),vT=a(Yi),md=l(Yi,"P",{"data-svelte-h":!0}),b(md)!=="svelte-h5pj3l"&&(md.textContent=r$),Yi.forEach(n),c_=a(e),ks=l(e,"DIV",{class:!0});var Pi=T(ks);g(da.$$.fragment,Pi),wT=a(Pi),gd=l(Pi,"P",{"data-svelte-h":!0}),b(gd)!=="svelte-b9zq6n"&&(gd.textContent=a$),Pi.forEach(n),i_=a(e),$s=l(e,"DIV",{class:!0});var Ai=T($s);g(pa.$$.fragment,Ai),kT=a(Ai),hd=l(Ai,"P",{"data-svelte-h":!0}),b(hd)!=="svelte-pru3ks"&&(hd.textContent=o$),Ai.forEach(n),d_=a(e),g(ma.$$.fragment,e),p_=a(e),et=l(e,"DIV",{class:!0});var Us=T(et);g(ga.$$.fragment,Us),$T=a(Us),ud=l(Us,"P",{"data-svelte-h":!0}),b(ud)!=="svelte-qoov36"&&(ud.textContent=l$),jT=a(Us),Is=l(Us,"DIV",{class:!0});var Oi=T(Is);g(ha.$$.fragment,Oi),xT=a(Oi),fd=l(Oi,"P",{"data-svelte-h":!0}),b(fd)!=="svelte-5ihtpa"&&(fd.textContent=c$),Oi.forEach(n),Us.forEach(n),m_=a(e),tt=l(e,"DIV",{class:!0});var Zs=T(tt);g(ua.$$.fragment,Zs),JT=a(Zs),_d=l(Zs,"P",{"data-svelte-h":!0}),b(_d)!=="svelte-1tz7qrd"&&(_d.textContent=i$),UT=a(Zs),zs=l(Zs,"DIV",{class:!0});var Ki=T(zs);g(fa.$$.fragment,Ki),ZT=a(Ki),bd=l(Ki,"P",{"data-svelte-h":!0}),b(bd)!=="svelte-5ihtpa"&&(bd.textContent=d$),Ki.forEach(n),Zs.forEach(n),g_=a(e),st=l(e,"DIV",{class:!0});var Cs=T(st);g(_a.$$.fragment,Cs),CT=a(Cs),yd=l(Cs,"P",{"data-svelte-h":!0}),b(yd)!=="svelte-1tz7qrd"&&(yd.textContent=p$),WT=a(Cs),Vs=l(Cs,"DIV",{class:!0});var ed=T(Vs);g(ba.$$.fragment,ed),BT=a(ed),Td=l(ed,"P",{"data-svelte-h":!0}),b(Td)!=="svelte-5ihtpa"&&(Td.textContent=m$),ed.forEach(n),Cs.forEach(n),h_=a(e),g(ya.$$.fragment,e),u_=a(e),Ta=l(e,"P",{"data-svelte-h":!0}),b(Ta)!=="svelte-17d2owa"&&(Ta.innerHTML=g$),f_=a(e),g(Ma.$$.fragment,e),__=a(e),ke=l(e,"DIV",{class:!0});var Nt=T(ke);g(va.$$.fragment,Nt),IT=a(Nt),Md=l(Nt,"P",{"data-svelte-h":!0}),b(Md)!=="svelte-6sd27t"&&(Md.innerHTML=h$),zT=a(Nt),g(Gs.$$.fragment,Nt),VT=a(Nt),vd=l(Nt,"DIV",{class:!0});var yf=T(vd);g(wa.$$.fragment,yf),yf.forEach(n),Nt.forEach(n),b_=a(e),S=l(e,"DIV",{class:!0});var fe=T(S);g(ka.$$.fragment,fe),GT=a(fe),wd=l(fe,"P",{"data-svelte-h":!0}),b(wd)!=="svelte-u401d2"&&(wd.innerHTML=u$),FT=a(fe),kd=l(fe,"P",{"data-svelte-h":!0}),b(kd)!=="svelte-lu7kru"&&(kd.innerHTML=f$),XT=a(fe),g(Fs.$$.fragment,fe),RT=a(fe),g(Xs.$$.fragment,fe),LT=a(fe),$d=l(fe,"DIV",{class:!0});var Tf=T($d);g($a.$$.fragment,Tf),Tf.forEach(n),fe.forEach(n),y_=a(e),se=l(e,"DIV",{class:!0});var Ne=T(se);g(ja.$$.fragment,Ne),ST=a(Ne),jd=l(Ne,"P",{"data-svelte-h":!0}),b(jd)!=="svelte-1pjrevv"&&(jd.innerHTML=_$),NT=a(Ne),xd=l(Ne,"P",{"data-svelte-h":!0}),b(xd)!=="svelte-mpy00q"&&(xd.textContent=b$),HT=a(Ne),g(Rs.$$.fragment,Ne),ET=a(Ne),Jd=l(Ne,"DIV",{class:!0});var Mf=T(Jd);g(xa.$$.fragment,Mf),Mf.forEach(n),Ne.forEach(n),T_=a(e),ne=l(e,"DIV",{class:!0});var He=T(ne);g(Ja.$$.fragment,He),qT=a(He),Ud=l(He,"P",{"data-svelte-h":!0}),b(Ud)!=="svelte-1g9krqh"&&(Ud.innerHTML=y$),DT=a(He),Zd=l(He,"P",{"data-svelte-h":!0}),b(Zd)!=="svelte-3qpgm7"&&(Zd.textContent=T$),QT=a(He),g(Ls.$$.fragment,He),YT=a(He),Cd=l(He,"DIV",{class:!0});var vf=T(Cd);g(Ua.$$.fragment,vf),vf.forEach(n),He.forEach(n),M_=a(e),$e=l(e,"DIV",{class:!0});var Ht=T($e);g(Za.$$.fragment,Ht),PT=a(Ht),Wd=l(Ht,"P",{"data-svelte-h":!0}),b(Wd)!=="svelte-19hmiyt"&&(Wd.innerHTML=M$),AT=a(Ht),g(Ss.$$.fragment,Ht),OT=a(Ht),Bd=l(Ht,"DIV",{class:!0});var wf=T(Bd);g(Ca.$$.fragment,wf),wf.forEach(n),Ht.forEach(n),v_=a(e),je=l(e,"DIV",{class:!0});var Et=T(je);g(Wa.$$.fragment,Et),KT=a(Et),Id=l(Et,"P",{"data-svelte-h":!0}),b(Id)!=="svelte-1lh4she"&&(Id.innerHTML=v$),eM=a(Et),g(Ns.$$.fragment,Et),tM=a(Et),zd=l(Et,"DIV",{class:!0});var kf=T(zd);g(Ba.$$.fragment,kf),kf.forEach(n),Et.forEach(n),w_=a(e),xe=l(e,"DIV",{class:!0});var qt=T(xe);g(Ia.$$.fragment,qt),sM=a(qt),Vd=l(qt,"P",{"data-svelte-h":!0}),b(Vd)!=="svelte-18ztxgk"&&(Vd.innerHTML=w$),nM=a(qt),g(Hs.$$.fragment,qt),rM=a(qt),Gd=l(qt,"DIV",{class:!0});var $f=T(Gd);g(za.$$.fragment,$f),$f.forEach(n),qt.forEach(n),k_=a(e),Je=l(e,"DIV",{class:!0});var Dt=T(Je);g(Va.$$.fragment,Dt),aM=a(Dt),Fd=l(Dt,"P",{"data-svelte-h":!0}),b(Fd)!=="svelte-1flvqm8"&&(Fd.innerHTML=k$),oM=a(Dt),g(Es.$$.fragment,Dt),lM=a(Dt),Xd=l(Dt,"DIV",{class:!0});var jf=T(Xd);g(Ga.$$.fragment,jf),jf.forEach(n),Dt.forEach(n),$_=a(e),Ue=l(e,"DIV",{class:!0});var Qt=T(Ue);g(Fa.$$.fragment,Qt),cM=a(Qt),Rd=l(Qt,"P",{"data-svelte-h":!0}),b(Rd)!=="svelte-2lzjo4"&&(Rd.innerHTML=$$),iM=a(Qt),g(qs.$$.fragment,Qt),dM=a(Qt),Ld=l(Qt,"DIV",{class:!0});var xf=T(Ld);g(Xa.$$.fragment,xf),xf.forEach(n),Qt.forEach(n),j_=a(e),N=l(e,"DIV",{class:!0});var _e=T(N);g(Ra.$$.fragment,_e),pM=a(_e),Sd=l(_e,"P",{"data-svelte-h":!0}),b(Sd)!=="svelte-1t5sfpu"&&(Sd.innerHTML=j$),mM=a(_e),Nd=l(_e,"P",{"data-svelte-h":!0}),b(Nd)!=="svelte-1b0c3nk"&&(Nd.innerHTML=x$),gM=a(_e),Hd=l(_e,"P",{"data-svelte-h":!0}),b(Hd)!=="svelte-2fpu88"&&(Hd.innerHTML=J$),hM=a(_e),g(Ds.$$.fragment,_e),uM=a(_e),Ed=l(_e,"DIV",{class:!0});var Jf=T(Ed);g(La.$$.fragment,Jf),Jf.forEach(n),_e.forEach(n),x_=a(e),Ze=l(e,"DIV",{class:!0});var Yt=T(Ze);g(Sa.$$.fragment,Yt),fM=a(Yt),qd=l(Yt,"P",{"data-svelte-h":!0}),b(qd)!=="svelte-1df1ma3"&&(qd.innerHTML=U$),_M=a(Yt),Dd=l(Yt,"P",{"data-svelte-h":!0}),b(Dd)!=="svelte-1v3r596"&&(Dd.innerHTML=Z$),bM=a(Yt),Qd=l(Yt,"DIV",{class:!0});var Uf=T(Qd);g(Na.$$.fragment,Uf),Uf.forEach(n),Yt.forEach(n),J_=a(e),Ce=l(e,"DIV",{class:!0});var Pt=T(Ce);g(Ha.$$.fragment,Pt),yM=a(Pt),Yd=l(Pt,"P",{"data-svelte-h":!0}),b(Yd)!=="svelte-16wx9j3"&&(Yd.innerHTML=C$),TM=a(Pt),g(Qs.$$.fragment,Pt),MM=a(Pt),Pd=l(Pt,"DIV",{class:!0});var Zf=T(Pd);g(Ea.$$.fragment,Zf),Zf.forEach(n),Pt.forEach(n),U_=a(e),nt=l(e,"DIV",{class:!0});var Ws=T(nt);g(qa.$$.fragment,Ws),vM=a(Ws),Ad=l(Ws,"P",{"data-svelte-h":!0}),b(Ad)!=="svelte-y1kta5"&&(Ad.textContent=W$),wM=a(Ws),Od=l(Ws,"DIV",{class:!0});var Cf=T(Od);g(Da.$$.fragment,Cf),Cf.forEach(n),Ws.forEach(n),Z_=a(e),rt=l(e,"DIV",{class:!0});var Bs=T(rt);g(Qa.$$.fragment,Bs),kM=a(Bs),Kd=l(Bs,"P",{"data-svelte-h":!0}),b(Kd)!=="svelte-1ge0zar"&&(Kd.innerHTML=B$),$M=a(Bs),ep=l(Bs,"DIV",{class:!0});var Wf=T(ep);g(Ya.$$.fragment,Wf),Wf.forEach(n),Bs.forEach(n),C_=a(e),We=l(e,"DIV",{class:!0});var At=T(We);g(Pa.$$.fragment,At),jM=a(At),tp=l(At,"P",{"data-svelte-h":!0}),b(tp)!=="svelte-18bzf40"&&(tp.innerHTML=I$),xM=a(At),g(Ys.$$.fragment,At),JM=a(At),sp=l(At,"DIV",{class:!0});var Bf=T(sp);g(Aa.$$.fragment,Bf),Bf.forEach(n),At.forEach(n),W_=a(e),Be=l(e,"DIV",{class:!0});var Ot=T(Be);g(Oa.$$.fragment,Ot),UM=a(Ot),np=l(Ot,"P",{"data-svelte-h":!0}),b(np)!=="svelte-1heazi7"&&(np.innerHTML=z$),ZM=a(Ot),g(Ps.$$.fragment,Ot),CM=a(Ot),rp=l(Ot,"DIV",{class:!0});var If=T(rp);g(Ka.$$.fragment,If),If.forEach(n),Ot.forEach(n),B_=a(e),H=l(e,"DIV",{class:!0});var be=T(H);g(eo.$$.fragment,be),WM=a(be),ap=l(be,"P",{"data-svelte-h":!0}),b(ap)!=="svelte-17aqptr"&&(ap.innerHTML=V$),BM=a(be),op=l(be,"P",{"data-svelte-h":!0}),b(op)!=="svelte-15e1du1"&&(op.innerHTML=G$),IM=a(be),lp=l(be,"P",{"data-svelte-h":!0}),b(lp)!=="svelte-1fvwhfn"&&(lp.innerHTML=F$),zM=a(be),g(As.$$.fragment,be),VM=a(be),cp=l(be,"DIV",{class:!0});var nU=T(cp);g(to.$$.fragment,nU),nU.forEach(n),be.forEach(n),I_=a(e),re=l(e,"DIV",{class:!0});var es=T(re);g(so.$$.fragment,es),GM=a(es),ip=l(es,"P",{"data-svelte-h":!0}),b(ip)!=="svelte-fizl34"&&(ip.innerHTML=X$),FM=a(es),g(Os.$$.fragment,es),XM=a(es),g(Ks.$$.fragment,es),RM=a(es),dp=l(es,"DIV",{class:!0});var rU=T(dp);g(no.$$.fragment,rU),rU.forEach(n),es.forEach(n),z_=a(e),ae=l(e,"DIV",{class:!0});var ts=T(ae);g(ro.$$.fragment,ts),LM=a(ts),pp=l(ts,"P",{"data-svelte-h":!0}),b(pp)!=="svelte-9quxbj"&&(pp.innerHTML=R$),SM=a(ts),g(en.$$.fragment,ts),NM=a(ts),g(tn.$$.fragment,ts),HM=a(ts),mp=l(ts,"DIV",{class:!0});var aU=T(mp);g(ao.$$.fragment,aU),aU.forEach(n),ts.forEach(n),V_=a(e),Ie=l(e,"DIV",{class:!0});var xr=T(Ie);g(oo.$$.fragment,xr),EM=a(xr),gp=l(xr,"P",{"data-svelte-h":!0}),b(gp)!=="svelte-ldy5uw"&&(gp.innerHTML=L$),qM=a(xr),g(sn.$$.fragment,xr),DM=a(xr),hp=l(xr,"DIV",{class:!0});var oU=T(hp);g(lo.$$.fragment,oU),oU.forEach(n),xr.forEach(n),G_=a(e),oe=l(e,"DIV",{class:!0});var ss=T(oe);g(co.$$.fragment,ss),QM=a(ss),up=l(ss,"P",{"data-svelte-h":!0}),b(up)!=="svelte-1v1tqeg"&&(up.innerHTML=S$),YM=a(ss),fp=l(ss,"P",{"data-svelte-h":!0}),b(fp)!=="svelte-qhda5i"&&(fp.innerHTML=N$),PM=a(ss),g(nn.$$.fragment,ss),AM=a(ss),_p=l(ss,"DIV",{class:!0});var lU=T(_p);g(io.$$.fragment,lU),lU.forEach(n),ss.forEach(n),F_=a(e),le=l(e,"DIV",{class:!0});var ns=T(le);g(po.$$.fragment,ns),OM=a(ns),bp=l(ns,"P",{"data-svelte-h":!0}),b(bp)!=="svelte-kghbn"&&(bp.innerHTML=H$),KM=a(ns),g(rn.$$.fragment,ns),ev=a(ns),g(an.$$.fragment,ns),tv=a(ns),yp=l(ns,"DIV",{class:!0});var cU=T(yp);g(mo.$$.fragment,cU),cU.forEach(n),ns.forEach(n),X_=a(e),ze=l(e,"DIV",{class:!0});var Jr=T(ze);g(go.$$.fragment,Jr),sv=a(Jr),Tp=l(Jr,"P",{"data-svelte-h":!0}),b(Tp)!=="svelte-q8pd4f"&&(Tp.innerHTML=E$),nv=a(Jr),g(on.$$.fragment,Jr),rv=a(Jr),Mp=l(Jr,"DIV",{class:!0});var iU=T(Mp);g(ho.$$.fragment,iU),iU.forEach(n),Jr.forEach(n),R_=a(e),Ve=l(e,"DIV",{class:!0});var Ur=T(Ve);g(uo.$$.fragment,Ur),av=a(Ur),vp=l(Ur,"P",{"data-svelte-h":!0}),b(vp)!=="svelte-kp6ubc"&&(vp.innerHTML=q$),ov=a(Ur),g(ln.$$.fragment,Ur),lv=a(Ur),wp=l(Ur,"DIV",{class:!0});var dU=T(wp);g(fo.$$.fragment,dU),dU.forEach(n),Ur.forEach(n),L_=a(e),G=l(e,"DIV",{class:!0});var Te=T(G);g(_o.$$.fragment,Te),cv=a(Te),kp=l(Te,"P",{"data-svelte-h":!0}),b(kp)!=="svelte-1rvhp9l"&&(kp.textContent=D$),iv=a(Te),$p=l(Te,"P",{"data-svelte-h":!0}),b($p)!=="svelte-1adc5s0"&&($p.textContent=Q$),dv=a(Te),jp=l(Te,"UL",{"data-svelte-h":!0}),b(jp)!=="svelte-eq22a7"&&(jp.innerHTML=Y$),pv=a(Te),xp=l(Te,"P",{"data-svelte-h":!0}),b(xp)!=="svelte-1mgc9mo"&&(xp.innerHTML=P$),mv=a(Te),g(cn.$$.fragment,Te),gv=a(Te),Jp=l(Te,"DIV",{class:!0});var pU=T(Jp);g(bo.$$.fragment,pU),pU.forEach(n),Te.forEach(n),S_=a(e),ce=l(e,"DIV",{class:!0});var rs=T(ce);g(yo.$$.fragment,rs),hv=a(rs),Up=l(rs,"P",{"data-svelte-h":!0}),b(Up)!=="svelte-5fjm0w"&&(Up.innerHTML=A$),uv=a(rs),g(dn.$$.fragment,rs),fv=a(rs),g(pn.$$.fragment,rs),_v=a(rs),Zp=l(rs,"DIV",{class:!0});var mU=T(Zp);g(To.$$.fragment,mU),mU.forEach(n),rs.forEach(n),N_=a(e),Ge=l(e,"DIV",{class:!0});var Zr=T(Ge);g(Mo.$$.fragment,Zr),bv=a(Zr),Cp=l(Zr,"P",{"data-svelte-h":!0}),b(Cp)!=="svelte-v3iz6e"&&(Cp.innerHTML=O$),yv=a(Zr),g(mn.$$.fragment,Zr),Tv=a(Zr),Wp=l(Zr,"DIV",{class:!0});var gU=T(Wp);g(vo.$$.fragment,gU),gU.forEach(n),Zr.forEach(n),H_=a(e),Fe=l(e,"DIV",{class:!0});var Cr=T(Fe);g(wo.$$.fragment,Cr),Mv=a(Cr),Bp=l(Cr,"P",{"data-svelte-h":!0}),b(Bp)!=="svelte-12y16w2"&&(Bp.innerHTML=K$),vv=a(Cr),g(gn.$$.fragment,Cr),wv=a(Cr),Ip=l(Cr,"DIV",{class:!0});var hU=T(Ip);g(ko.$$.fragment,hU),hU.forEach(n),Cr.forEach(n),E_=a(e),ie=l(e,"DIV",{class:!0});var as=T(ie);g($o.$$.fragment,as),kv=a(as),zp=l(as,"P",{"data-svelte-h":!0}),b(zp)!=="svelte-iernu7"&&(zp.innerHTML=ej),$v=a(as),Vp=l(as,"P",{"data-svelte-h":!0}),b(Vp)!=="svelte-1qmimno"&&(Vp.innerHTML=tj),jv=a(as),g(hn.$$.fragment,as),xv=a(as),Gp=l(as,"DIV",{class:!0});var uU=T(Gp);g(jo.$$.fragment,uU),uU.forEach(n),as.forEach(n),q_=a(e),de=l(e,"DIV",{class:!0});var os=T(de);g(xo.$$.fragment,os),Jv=a(os),Fp=l(os,"P",{"data-svelte-h":!0}),b(Fp)!=="svelte-1dewsn6"&&(Fp.innerHTML=sj),Uv=a(os),Xp=l(os,"P",{"data-svelte-h":!0}),b(Xp)!=="svelte-5qs7tv"&&(Xp.innerHTML=nj),Zv=a(os),g(un.$$.fragment,os),Cv=a(os),Rp=l(os,"DIV",{class:!0});var fU=T(Rp);g(Jo.$$.fragment,fU),fU.forEach(n),os.forEach(n),D_=a(e),pe=l(e,"DIV",{class:!0});var ls=T(pe);g(Uo.$$.fragment,ls),Wv=a(ls),Lp=l(ls,"P",{"data-svelte-h":!0}),b(Lp)!=="svelte-3hjxoq"&&(Lp.innerHTML=rj),Bv=a(ls),Sp=l(ls,"P",{"data-svelte-h":!0}),b(Sp)!=="svelte-qmmn5t"&&(Sp.innerHTML=aj),Iv=a(ls),g(fn.$$.fragment,ls),zv=a(ls),Np=l(ls,"DIV",{class:!0});var _U=T(Np);g(Zo.$$.fragment,_U),_U.forEach(n),ls.forEach(n),Q_=a(e),E=l(e,"DIV",{class:!0});var Ee=T(E);g(Co.$$.fragment,Ee),Vv=a(Ee),Hp=l(Ee,"P",{"data-svelte-h":!0}),b(Hp)!=="svelte-1722u08"&&(Hp.innerHTML=oj),Gv=a(Ee),Ep=l(Ee,"P",{"data-svelte-h":!0}),b(Ep)!=="svelte-1omrr7m"&&(Ep.innerHTML=lj),Fv=a(Ee),qp=l(Ee,"P",{"data-svelte-h":!0}),b(qp)!=="svelte-y9hsik"&&(qp.innerHTML=cj),Xv=a(Ee),g(_n.$$.fragment,Ee),Rv=a(Ee),Dp=l(Ee,"DIV",{class:!0});var bU=T(Dp);g(Wo.$$.fragment,bU),bU.forEach(n),Ee.forEach(n),Y_=a(e),g(Bo.$$.fragment,e),P_=a(e),at=l(e,"DIV",{class:!0});var Wu=T(at);g(Io.$$.fragment,Wu),Lv=a(Wu),Qp=l(Wu,"P",{"data-svelte-h":!0}),b(Qp)!=="svelte-vn72mg"&&(Qp.innerHTML=ij),Sv=a(Wu),Yp=l(Wu,"DIV",{class:!0});var yU=T(Yp);g(zo.$$.fragment,yU),yU.forEach(n),Wu.forEach(n),A_=a(e),ot=l(e,"DIV",{class:!0});var Bu=T(ot);g(Vo.$$.fragment,Bu),Nv=a(Bu),Pp=l(Bu,"P",{"data-svelte-h":!0}),b(Pp)!=="svelte-5m2hkk"&&(Pp.innerHTML=dj),Hv=a(Bu),Ap=l(Bu,"DIV",{class:!0});var TU=T(Ap);g(Go.$$.fragment,TU),TU.forEach(n),Bu.forEach(n),O_=a(e),lt=l(e,"DIV",{class:!0});var Iu=T(lt);g(Fo.$$.fragment,Iu),Ev=a(Iu),Op=l(Iu,"P",{"data-svelte-h":!0}),b(Op)!=="svelte-1557waw"&&(Op.innerHTML=pj),qv=a(Iu),Kp=l(Iu,"DIV",{class:!0});var MU=T(Kp);g(Xo.$$.fragment,MU),MU.forEach(n),Iu.forEach(n),K_=a(e),ct=l(e,"DIV",{class:!0});var zu=T(ct);g(Ro.$$.fragment,zu),Dv=a(zu),em=l(zu,"P",{"data-svelte-h":!0}),b(em)!=="svelte-y1kta5"&&(em.textContent=mj),Qv=a(zu),bn=l(zu,"DIV",{class:!0});var by=T(bn);g(Lo.$$.fragment,by),Yv=a(by),tm=l(by,"P",{"data-svelte-h":!0}),b(tm)!=="svelte-5aspnb"&&(tm.textContent=gj),by.forEach(n),zu.forEach(n),eb=a(e),it=l(e,"DIV",{class:!0});var Vu=T(it);g(So.$$.fragment,Vu),Pv=a(Vu),sm=l(Vu,"P",{"data-svelte-h":!0}),b(sm)!=="svelte-1j11gur"&&(sm.innerHTML=hj),Av=a(Vu),nm=l(Vu,"DIV",{class:!0});var vU=T(nm);g(No.$$.fragment,vU),vU.forEach(n),Vu.forEach(n),tb=a(e),dt=l(e,"DIV",{class:!0});var Gu=T(dt);g(Ho.$$.fragment,Gu),Ov=a(Gu),rm=l(Gu,"P",{"data-svelte-h":!0}),b(rm)!=="svelte-th82mu"&&(rm.textContent=uj),Kv=a(Gu),yn=l(Gu,"DIV",{class:!0});var yy=T(yn);g(Eo.$$.fragment,yy),ew=a(yy),am=l(yy,"P",{"data-svelte-h":!0}),b(am)!=="svelte-hcoglc"&&(am.textContent=fj),yy.forEach(n),Gu.forEach(n),sb=a(e),pt=l(e,"DIV",{class:!0});var Fu=T(pt);g(qo.$$.fragment,Fu),tw=a(Fu),om=l(Fu,"P",{"data-svelte-h":!0}),b(om)!=="svelte-89mrc0"&&(om.innerHTML=_j),sw=a(Fu),lm=l(Fu,"DIV",{class:!0});var wU=T(lm);g(Do.$$.fragment,wU),wU.forEach(n),Fu.forEach(n),nb=a(e),mt=l(e,"DIV",{class:!0});var Xu=T(mt);g(Qo.$$.fragment,Xu),nw=a(Xu),cm=l(Xu,"P",{"data-svelte-h":!0}),b(cm)!=="svelte-14vc3up"&&(cm.innerHTML=bj),rw=a(Xu),im=l(Xu,"DIV",{class:!0});var kU=T(im);g(Yo.$$.fragment,kU),kU.forEach(n),Xu.forEach(n),rb=a(e),gt=l(e,"DIV",{class:!0});var Ru=T(gt);g(Po.$$.fragment,Ru),aw=a(Ru),dm=l(Ru,"P",{"data-svelte-h":!0}),b(dm)!=="svelte-1fb8uyp"&&(dm.innerHTML=yj),ow=a(Ru),pm=l(Ru,"DIV",{class:!0});var $U=T(pm);g(Ao.$$.fragment,$U),$U.forEach(n),Ru.forEach(n),ab=a(e),ht=l(e,"DIV",{class:!0});var Lu=T(ht);g(Oo.$$.fragment,Lu),lw=a(Lu),mm=l(Lu,"P",{"data-svelte-h":!0}),b(mm)!=="svelte-1ah9z24"&&(mm.innerHTML=Tj),cw=a(Lu),gm=l(Lu,"DIV",{class:!0});var jU=T(gm);g(Ko.$$.fragment,jU),jU.forEach(n),Lu.forEach(n),ob=a(e),ut=l(e,"DIV",{class:!0});var Su=T(ut);g(el.$$.fragment,Su),iw=a(Su),hm=l(Su,"P",{"data-svelte-h":!0}),b(hm)!=="svelte-13nx65f"&&(hm.innerHTML=Mj),dw=a(Su),um=l(Su,"DIV",{class:!0});var xU=T(um);g(tl.$$.fragment,xU),xU.forEach(n),Su.forEach(n),lb=a(e),ft=l(e,"DIV",{class:!0});var Nu=T(ft);g(sl.$$.fragment,Nu),pw=a(Nu),fm=l(Nu,"P",{"data-svelte-h":!0}),b(fm)!=="svelte-a554sd"&&(fm.innerHTML=vj),mw=a(Nu),_m=l(Nu,"DIV",{class:!0});var JU=T(_m);g(nl.$$.fragment,JU),JU.forEach(n),Nu.forEach(n),cb=a(e),_t=l(e,"DIV",{class:!0});var Hu=T(_t);g(rl.$$.fragment,Hu),gw=a(Hu),bm=l(Hu,"P",{"data-svelte-h":!0}),b(bm)!=="svelte-1udfsdn"&&(bm.innerHTML=wj),hw=a(Hu),ym=l(Hu,"DIV",{class:!0});var UU=T(ym);g(al.$$.fragment,UU),UU.forEach(n),Hu.forEach(n),ib=a(e),bt=l(e,"DIV",{class:!0});var Eu=T(bt);g(ol.$$.fragment,Eu),uw=a(Eu),Tm=l(Eu,"P",{"data-svelte-h":!0}),b(Tm)!=="svelte-1kcfu6"&&(Tm.innerHTML=kj),fw=a(Eu),Mm=l(Eu,"DIV",{class:!0});var ZU=T(Mm);g(ll.$$.fragment,ZU),ZU.forEach(n),Eu.forEach(n),db=a(e),yt=l(e,"DIV",{class:!0});var qu=T(yt);g(cl.$$.fragment,qu),_w=a(qu),vm=l(qu,"P",{"data-svelte-h":!0}),b(vm)!=="svelte-1455ac8"&&(vm.innerHTML=$j),bw=a(qu),wm=l(qu,"DIV",{class:!0});var CU=T(wm);g(il.$$.fragment,CU),CU.forEach(n),qu.forEach(n),pb=a(e),g(dl.$$.fragment,e),mb=a(e),Tt=l(e,"DIV",{class:!0});var Du=T(Tt);g(pl.$$.fragment,Du),yw=a(Du),km=l(Du,"P",{"data-svelte-h":!0}),b(km)!=="svelte-gwq9sw"&&(km.innerHTML=jj),Tw=a(Du),$m=l(Du,"DIV",{class:!0});var WU=T($m);g(ml.$$.fragment,WU),WU.forEach(n),Du.forEach(n),gb=a(e),Mt=l(e,"DIV",{class:!0});var Qu=T(Mt);g(gl.$$.fragment,Qu),Mw=a(Qu),jm=l(Qu,"P",{"data-svelte-h":!0}),b(jm)!=="svelte-194313w"&&(jm.innerHTML=xj),vw=a(Qu),xm=l(Qu,"DIV",{class:!0});var BU=T(xm);g(hl.$$.fragment,BU),BU.forEach(n),Qu.forEach(n),hb=a(e),vt=l(e,"DIV",{class:!0});var Yu=T(vt);g(ul.$$.fragment,Yu),ww=a(Yu),Jm=l(Yu,"P",{"data-svelte-h":!0}),b(Jm)!=="svelte-1esbrkt"&&(Jm.innerHTML=Jj),kw=a(Yu),Um=l(Yu,"DIV",{class:!0});var IU=T(Um);g(fl.$$.fragment,IU),IU.forEach(n),Yu.forEach(n),ub=a(e),wt=l(e,"DIV",{class:!0});var Pu=T(wt);g(_l.$$.fragment,Pu),$w=a(Pu),Zm=l(Pu,"P",{"data-svelte-h":!0}),b(Zm)!=="svelte-y1kta5"&&(Zm.textContent=Uj),jw=a(Pu),Tn=l(Pu,"DIV",{class:!0});var Ty=T(Tn);g(bl.$$.fragment,Ty),xw=a(Ty),Cm=l(Ty,"P",{"data-svelte-h":!0}),b(Cm)!=="svelte-1l17mwc"&&(Cm.textContent=Zj),Ty.forEach(n),Pu.forEach(n),fb=a(e),kt=l(e,"DIV",{class:!0});var Au=T(kt);g(yl.$$.fragment,Au),Jw=a(Au),Wm=l(Au,"P",{"data-svelte-h":!0}),b(Wm)!=="svelte-ni4ppv"&&(Wm.innerHTML=Cj),Uw=a(Au),Bm=l(Au,"DIV",{class:!0});var zU=T(Bm);g(Tl.$$.fragment,zU),zU.forEach(n),Au.forEach(n),_b=a(e),$t=l(e,"DIV",{class:!0});var Ou=T($t);g(Ml.$$.fragment,Ou),Zw=a(Ou),Im=l(Ou,"P",{"data-svelte-h":!0}),b(Im)!=="svelte-th82mu"&&(Im.textContent=Wj),Cw=a(Ou),Mn=l(Ou,"DIV",{class:!0});var My=T(Mn);g(vl.$$.fragment,My),Ww=a(My),zm=l(My,"P",{"data-svelte-h":!0}),b(zm)!=="svelte-1tcb5cf"&&(zm.textContent=Bj),My.forEach(n),Ou.forEach(n),bb=a(e),jt=l(e,"DIV",{class:!0});var Ku=T(jt);g(wl.$$.fragment,Ku),Bw=a(Ku),Vm=l(Ku,"P",{"data-svelte-h":!0}),b(Vm)!=="svelte-3sdtlk"&&(Vm.innerHTML=Ij),Iw=a(Ku),Gm=l(Ku,"DIV",{class:!0});var VU=T(Gm);g(kl.$$.fragment,VU),VU.forEach(n),Ku.forEach(n),yb=a(e),xt=l(e,"DIV",{class:!0});var ef=T(xt);g($l.$$.fragment,ef),zw=a(ef),Fm=l(ef,"P",{"data-svelte-h":!0}),b(Fm)!=="svelte-uekkj0"&&(Fm.innerHTML=zj),Vw=a(ef),Xm=l(ef,"DIV",{class:!0});var GU=T(Xm);g(jl.$$.fragment,GU),GU.forEach(n),ef.forEach(n),Tb=a(e),Jt=l(e,"DIV",{class:!0});var tf=T(Jt);g(xl.$$.fragment,tf),Gw=a(tf),Rm=l(tf,"P",{"data-svelte-h":!0}),b(Rm)!=="svelte-1j0qf5e"&&(Rm.innerHTML=Vj),Fw=a(tf),Lm=l(tf,"DIV",{class:!0});var FU=T(Lm);g(Jl.$$.fragment,FU),FU.forEach(n),tf.forEach(n),Mb=a(e),Ut=l(e,"DIV",{class:!0});var sf=T(Ut);g(Ul.$$.fragment,sf),Xw=a(sf),Sm=l(sf,"P",{"data-svelte-h":!0}),b(Sm)!=="svelte-1fmjned"&&(Sm.innerHTML=Gj),Rw=a(sf),Nm=l(sf,"DIV",{class:!0});var XU=T(Nm);g(Zl.$$.fragment,XU),XU.forEach(n),sf.forEach(n),vb=a(e),Zt=l(e,"DIV",{class:!0});var nf=T(Zt);g(Cl.$$.fragment,nf),Lw=a(nf),Hm=l(nf,"P",{"data-svelte-h":!0}),b(Hm)!=="svelte-du1x2s"&&(Hm.innerHTML=Fj),Sw=a(nf),Em=l(nf,"DIV",{class:!0});var RU=T(Em);g(Wl.$$.fragment,RU),RU.forEach(n),nf.forEach(n),wb=a(e),Ct=l(e,"DIV",{class:!0});var rf=T(Ct);g(Bl.$$.fragment,rf),Nw=a(rf),qm=l(rf,"P",{"data-svelte-h":!0}),b(qm)!=="svelte-vmaple"&&(qm.innerHTML=Xj),Hw=a(rf),Dm=l(rf,"DIV",{class:!0});var LU=T(Dm);g(Il.$$.fragment,LU),LU.forEach(n),rf.forEach(n),kb=a(e),Wt=l(e,"DIV",{class:!0});var af=T(Wt);g(zl.$$.fragment,af),Ew=a(af),Qm=l(af,"P",{"data-svelte-h":!0}),b(Qm)!=="svelte-1sygpwz"&&(Qm.innerHTML=Rj),qw=a(af),Ym=l(af,"DIV",{class:!0});var SU=T(Ym);g(Vl.$$.fragment,SU),SU.forEach(n),af.forEach(n),$b=a(e),g(Gl.$$.fragment,e),jb=a(e),Fl=l(e,"P",{"data-svelte-h":!0}),b(Fl)!=="svelte-7k1rm8"&&(Fl.innerHTML=Lj),xb=a(e),Xe=l(e,"DIV",{class:!0});var Wr=T(Xe);g(Xl.$$.fragment,Wr),Dw=a(Wr),Pm=l(Wr,"P",{"data-svelte-h":!0}),b(Pm)!=="svelte-rfvu1k"&&(Pm.textContent=Sj),Qw=a(Wr),Am=l(Wr,"P",{"data-svelte-h":!0}),b(Am)!=="svelte-e1lytz"&&(Am.innerHTML=Nj),Yw=a(Wr),Om=l(Wr,"DIV",{class:!0});var NU=T(Om);g(Rl.$$.fragment,NU),NU.forEach(n),Wr.forEach(n),Jb=a(e),js=l(e,"DIV",{class:!0});var vy=T(js);g(Ll.$$.fragment,vy),Pw=a(vy),Km=l(vy,"DIV",{class:!0});var HU=T(Km);g(Sl.$$.fragment,HU),HU.forEach(n),vy.forEach(n),Ub=a(e),Bt=l(e,"DIV",{class:!0});var of=T(Bt);g(Nl.$$.fragment,of),Aw=a(of),eg=l(of,"P",{"data-svelte-h":!0}),b(eg)!=="svelte-4hfu96"&&(eg.innerHTML=Hj),Ow=a(of),tg=l(of,"DIV",{class:!0});var EU=T(tg);g(Hl.$$.fragment,EU),EU.forEach(n),of.forEach(n),Zb=a(e),It=l(e,"DIV",{class:!0});var lf=T(It);g(El.$$.fragment,lf),Kw=a(lf),sg=l(lf,"P",{"data-svelte-h":!0}),b(sg)!=="svelte-q5v59n"&&(sg.innerHTML=Ej),e0=a(lf),ng=l(lf,"DIV",{class:!0});var qU=T(ng);g(ql.$$.fragment,qU),qU.forEach(n),lf.forEach(n),Cb=a(e),J=l(e,"DIV",{class:!0});var C=T(J);g(Dl.$$.fragment,C),t0=a(C),rg=l(C,"P",{"data-svelte-h":!0}),b(rg)!=="svelte-1rue44"&&(rg.textContent=qj),s0=a(C),ag=l(C,"P",{"data-svelte-h":!0}),b(ag)!=="svelte-we1k7h"&&(ag.textContent=Dj),n0=a(C),og=l(C,"UL",{"data-svelte-h":!0}),b(og)!=="svelte-1f6ppg"&&(og.innerHTML=Qj),r0=a(C),lg=l(C,"P",{"data-svelte-h":!0}),b(lg)!=="svelte-1uu68ip"&&(lg.textContent=Yj),a0=a(C),cg=l(C,"UL",{"data-svelte-h":!0}),b(cg)!=="svelte-izl8df"&&(cg.innerHTML=Pj),o0=a(C),ig=l(C,"P",{"data-svelte-h":!0}),b(ig)!=="svelte-hoqys0"&&(ig.textContent=Aj),l0=a(C),dg=l(C,"P",{"data-svelte-h":!0}),b(dg)!=="svelte-1a9fclk"&&(dg.textContent=Oj),c0=a(C),pg=l(C,"P",{"data-svelte-h":!0}),b(pg)!=="svelte-15ntb9y"&&(pg.textContent=Kj),i0=a(C),mg=l(C,"UL",{"data-svelte-h":!0}),b(mg)!=="svelte-vv46ly"&&(mg.innerHTML=ex),d0=a(C),gg=l(C,"P",{"data-svelte-h":!0}),b(gg)!=="svelte-1owyk1q"&&(gg.textContent=tx),p0=a(C),hg=l(C,"P",{"data-svelte-h":!0}),b(hg)!=="svelte-wt8oc0"&&(hg.textContent=sx),m0=a(C),ug=l(C,"P",{"data-svelte-h":!0}),b(ug)!=="svelte-ws21yj"&&(ug.textContent=nx),g0=a(C),fg=l(C,"P",{"data-svelte-h":!0}),b(fg)!=="svelte-l6qxzs"&&(fg.textContent=rx),h0=a(C),_g=l(C,"UL",{"data-svelte-h":!0}),b(_g)!=="svelte-p67cyh"&&(_g.innerHTML=ax),u0=a(C),bg=l(C,"P",{"data-svelte-h":!0}),b(bg)!=="svelte-1fg1xi2"&&(bg.textContent=ox),f0=a(C),yg=l(C,"P",{"data-svelte-h":!0}),b(yg)!=="svelte-1e0ripw"&&(yg.textContent=lx),_0=a(C),Tg=l(C,"UL",{"data-svelte-h":!0}),b(Tg)!=="svelte-1v088e0"&&(Tg.innerHTML=cx),b0=a(C),Mg=l(C,"P",{"data-svelte-h":!0}),b(Mg)!=="svelte-be7vix"&&(Mg.textContent=ix),y0=a(C),vg=l(C,"P",{"data-svelte-h":!0}),b(vg)!=="svelte-1xhdoom"&&(vg.textContent=dx),T0=a(C),g(vn.$$.fragment,C),M0=a(C),wg=l(C,"DIV",{class:!0});var DU=T(wg);g(Ql.$$.fragment,DU),DU.forEach(n),C.forEach(n),Wb=a(e),zt=l(e,"DIV",{class:!0});var cf=T(zt);g(Yl.$$.fragment,cf),v0=a(cf),kg=l(cf,"P",{"data-svelte-h":!0}),b(kg)!=="svelte-1t19wr8"&&(kg.innerHTML=px),w0=a(cf),$g=l(cf,"DIV",{class:!0});var QU=T($g);g(Pl.$$.fragment,QU),QU.forEach(n),cf.forEach(n),Bb=a(e),g(Al.$$.fragment,e),Ib=a(e),Ol=l(e,"P",{"data-svelte-h":!0}),b(Ol)!=="svelte-4qr0rq"&&(Ol.innerHTML=mx),zb=a(e),W=l(e,"DIV",{class:!0});var B=T(W);g(Kl.$$.fragment,B),k0=a(B),jg=l(B,"P",{"data-svelte-h":!0}),b(jg)!=="svelte-1kh5y5v"&&(jg.textContent=gx),$0=a(B),xg=l(B,"P",{"data-svelte-h":!0}),b(xg)!=="svelte-1ygkifj"&&(xg.textContent=hx),j0=a(B),g(wn.$$.fragment,B),x0=a(B),Jg=l(B,"P",{"data-svelte-h":!0}),b(Jg)!=="svelte-7kbd1a"&&(Jg.textContent=ux),J0=a(B),kn=l(B,"DIV",{class:!0});var wy=T(kn);g(ec.$$.fragment,wy),U0=a(wy),Ug=l(wy,"P",{"data-svelte-h":!0}),b(Ug)!=="svelte-163x237"&&(Ug.textContent=fx),wy.forEach(n),Z0=a(B),$n=l(B,"DIV",{class:!0});var ky=T($n);g(tc.$$.fragment,ky),C0=a(ky),Zg=l(ky,"P",{"data-svelte-h":!0}),b(Zg)!=="svelte-dtkk01"&&(Zg.textContent=_x),ky.forEach(n),W0=a(B),jn=l(B,"DIV",{class:!0});var $y=T(jn);g(sc.$$.fragment,$y),B0=a($y),Cg=l($y,"P",{"data-svelte-h":!0}),b(Cg)!=="svelte-11pa7k0"&&(Cg.textContent=bx),$y.forEach(n),I0=a(B),xn=l(B,"DIV",{class:!0});var jy=T(xn);g(nc.$$.fragment,jy),z0=a(jy),Wg=l(jy,"P",{"data-svelte-h":!0}),b(Wg)!=="svelte-57vcuk"&&(Wg.innerHTML=yx),jy.forEach(n),V0=a(B),Jn=l(B,"DIV",{class:!0});var xy=T(Jn);g(rc.$$.fragment,xy),G0=a(xy),Bg=l(xy,"P",{"data-svelte-h":!0}),b(Bg)!=="svelte-e342dt"&&(Bg.textContent=Tx),xy.forEach(n),F0=a(B),Un=l(B,"DIV",{class:!0});var Jy=T(Un);g(ac.$$.fragment,Jy),X0=a(Jy),Ig=l(Jy,"P",{"data-svelte-h":!0}),b(Ig)!=="svelte-vbd5xj"&&(Ig.textContent=Mx),Jy.forEach(n),R0=a(B),Kt=l(B,"DIV",{class:!0});var df=T(Kt);g(oc.$$.fragment,df),L0=a(df),zg=l(df,"P",{"data-svelte-h":!0}),b(zg)!=="svelte-1c2dshy"&&(zg.innerHTML=vx),S0=a(df),Vg=l(df,"P",{"data-svelte-h":!0}),b(Vg)!=="svelte-1qvu1un"&&(Vg.textContent=wx),df.forEach(n),B.forEach(n),Vb=a(e),xs=l(e,"DIV",{class:!0});var Uy=T(xs);g(lc.$$.fragment,Uy),N0=a(Uy),Gg=l(Uy,"P",{"data-svelte-h":!0}),b(Gg)!=="svelte-1jnxd8i"&&(Gg.innerHTML=kx),Uy.forEach(n),Gb=a(e),Js=l(e,"DIV",{class:!0});var Zy=T(Js);g(cc.$$.fragment,Zy),H0=a(Zy),Fg=l(Zy,"P",{"data-svelte-h":!0}),b(Fg)!=="svelte-1de929l"&&(Fg.innerHTML=$x),Zy.forEach(n),Fb=a(e),Re=l(e,"DIV",{class:!0});var Br=T(Re);g(ic.$$.fragment,Br),E0=a(Br),Xg=l(Br,"P",{"data-svelte-h":!0}),b(Xg)!=="svelte-rxlesw"&&(Xg.textContent=jx),q0=a(Br),K=l(Br,"DIV",{class:!0});var qe=T(K);g(dc.$$.fragment,qe),D0=a(qe),Rg=l(qe,"P",{"data-svelte-h":!0}),b(Rg)!=="svelte-15hhlou"&&(Rg.textContent=xx),Q0=a(qe),Lg=l(qe,"P",{"data-svelte-h":!0}),b(Lg)!=="svelte-e6h4hs"&&(Lg.innerHTML=Jx),Y0=a(qe),Sg=l(qe,"P",{"data-svelte-h":!0}),b(Sg)!=="svelte-1w36vm3"&&(Sg.innerHTML=Ux),P0=a(qe),Ng=l(qe,"P",{"data-svelte-h":!0}),b(Ng)!=="svelte-1niq0qw"&&(Ng.innerHTML=Zx),A0=a(qe),Hg=l(qe,"P",{"data-svelte-h":!0}),b(Hg)!=="svelte-af4g6f"&&(Hg.textContent=Cx),qe.forEach(n),O0=a(Br),Zn=l(Br,"DIV",{class:!0});var Cy=T(Zn);g(pc.$$.fragment,Cy),K0=a(Cy),Eg=l(Cy,"P",{"data-svelte-h":!0}),b(Eg)!=="svelte-eab6jp"&&(Eg.textContent=Wx),Cy.forEach(n),Br.forEach(n),Xb=a(e),g(mc.$$.fragment,e),Rb=a(e),Le=l(e,"DIV",{class:!0});var Ir=T(Le);g(gc.$$.fragment,Ir),e2=a(Ir),qg=l(Ir,"P",{"data-svelte-h":!0}),b(qg)!=="svelte-1fikjzl"&&(qg.innerHTML=Bx),t2=a(Ir),Dg=l(Ir,"DIV",{class:!0});var YU=T(Dg);g(hc.$$.fragment,YU),YU.forEach(n),s2=a(Ir),Qg=l(Ir,"DIV",{class:!0});var PU=T(Qg);g(uc.$$.fragment,PU),PU.forEach(n),Ir.forEach(n),Lb=a(e),q=l(e,"DIV",{class:!0});var De=T(q);g(fc.$$.fragment,De),n2=a(De),Yg=l(De,"P",{"data-svelte-h":!0}),b(Yg)!=="svelte-g38j55"&&(Yg.innerHTML=Ix),r2=a(De),Pg=l(De,"P",{"data-svelte-h":!0}),b(Pg)!=="svelte-19qrwo1"&&(Pg.innerHTML=zx),a2=a(De),Ag=l(De,"P",{"data-svelte-h":!0}),b(Ag)!=="svelte-l79sbt"&&(Ag.innerHTML=Vx),o2=a(De),Og=l(De,"DIV",{class:!0});var AU=T(Og);g(_c.$$.fragment,AU),AU.forEach(n),l2=a(De),Kg=l(De,"DIV",{class:!0});var OU=T(Kg);g(bc.$$.fragment,OU),OU.forEach(n),De.forEach(n),Sb=a(e),Se=l(e,"DIV",{class:!0});var zr=T(Se);g(yc.$$.fragment,zr),c2=a(zr),eh=l(zr,"P",{"data-svelte-h":!0}),b(eh)!=="svelte-1fhf036"&&(eh.innerHTML=Gx),i2=a(zr),th=l(zr,"DIV",{class:!0});var KU=T(th);g(Tc.$$.fragment,KU),KU.forEach(n),d2=a(zr),sh=l(zr,"DIV",{class:!0});var e3=T(sh);g(Mc.$$.fragment,e3),e3.forEach(n),zr.forEach(n),Nb=a(e),g(vc.$$.fragment,e),Hb=a(e),F=l(e,"DIV",{class:!0});var Me=T(F);g(wc.$$.fragment,Me),p2=a(Me),nh=l(Me,"P",{"data-svelte-h":!0}),b(nh)!=="svelte-5jvlz5"&&(nh.textContent=Fx),m2=a(Me),g(Cn.$$.fragment,Me),g2=a(Me),g(Wn.$$.fragment,Me),h2=a(Me),Bn=l(Me,"DIV",{class:!0});var Wy=T(Bn);g(kc.$$.fragment,Wy),u2=a(Wy),rh=l(Wy,"P",{"data-svelte-h":!0}),b(rh)!=="svelte-10d94rs"&&(rh.textContent=Xx),Wy.forEach(n),f2=a(Me),In=l(Me,"DIV",{class:!0});var By=T(In);g($c.$$.fragment,By),_2=a(By),ah=l(By,"P",{"data-svelte-h":!0}),b(ah)!=="svelte-tm945r"&&(ah.textContent=Rx),By.forEach(n),b2=a(Me),zn=l(Me,"DIV",{class:!0});var Iy=T(zn);g(jc.$$.fragment,Iy),y2=a(Iy),oh=l(Iy,"P",{"data-svelte-h":!0}),b(oh)!=="svelte-1i1356p"&&(oh.textContent=Lx),Iy.forEach(n),Me.forEach(n),Eb=a(e),me=l(e,"DIV",{class:!0});var cs=T(me);g(xc.$$.fragment,cs),T2=a(cs),lh=l(cs,"P",{"data-svelte-h":!0}),b(lh)!=="svelte-190fodr"&&(lh.textContent=Sx),M2=a(cs),g(Vn.$$.fragment,cs),v2=a(cs),g(Gn.$$.fragment,cs),w2=a(cs),Fn=l(cs,"DIV",{class:!0});var zy=T(Fn);g(Jc.$$.fragment,zy),k2=a(zy),ch=l(zy,"P",{"data-svelte-h":!0}),b(ch)!=="svelte-16i5iz"&&(ch.textContent=Nx),zy.forEach(n),cs.forEach(n),qb=a(e),g(Uc.$$.fragment,e),Db=a(e),Vt=l(e,"DIV",{class:!0});var pf=T(Vt);g(Zc.$$.fragment,pf),$2=a(pf),ih=l(pf,"P",{"data-svelte-h":!0}),b(ih)!=="svelte-15qehu2"&&(ih.textContent=Hx),j2=a(pf),Xn=l(pf,"DIV",{class:!0});var Vy=T(Xn);g(Cc.$$.fragment,Vy),x2=a(Vy),dh=l(Vy,"P",{"data-svelte-h":!0}),b(dh)!=="svelte-dfcv5s"&&(dh.innerHTML=Ex),Vy.forEach(n),pf.forEach(n),Qb=a(e),Gt=l(e,"DIV",{class:!0});var mf=T(Gt);g(Wc.$$.fragment,mf),J2=a(mf),ph=l(mf,"P",{"data-svelte-h":!0}),b(ph)!=="svelte-1sqibp"&&(ph.textContent=qx),U2=a(mf),Rn=l(mf,"DIV",{class:!0});var Gy=T(Rn);g(Bc.$$.fragment,Gy),Z2=a(Gy),mh=l(Gy,"P",{"data-svelte-h":!0}),b(mh)!=="svelte-n0rwld"&&(mh.innerHTML=Dx),Gy.forEach(n),mf.forEach(n),Yb=a(e),Ft=l(e,"DIV",{class:!0});var gf=T(Ft);g(Ic.$$.fragment,gf),C2=a(gf),gh=l(gf,"P",{"data-svelte-h":!0}),b(gh)!=="svelte-157zylv"&&(gh.textContent=Qx),W2=a(gf),Ln=l(gf,"DIV",{class:!0});var Fy=T(Ln);g(zc.$$.fragment,Fy),B2=a(Fy),hh=l(Fy,"P",{"data-svelte-h":!0}),b(hh)!=="svelte-15juztn"&&(hh.textContent=Yx),Fy.forEach(n),gf.forEach(n),Pb=a(e),I=l(e,"DIV",{class:!0});var L=T(I);g(Vc.$$.fragment,L),I2=a(L),uh=l(L,"P",{"data-svelte-h":!0}),b(uh)!=="svelte-11w7j52"&&(uh.textContent=Px),z2=a(L),fh=l(L,"P",{"data-svelte-h":!0}),b(fh)!=="svelte-1f9j82e"&&(fh.innerHTML=Ax),V2=a(L),g(Sn.$$.fragment,L),G2=a(L),Nn=l(L,"DIV",{class:!0});var Xy=T(Nn);g(Gc.$$.fragment,Xy),F2=a(Xy),_h=l(Xy,"P",{"data-svelte-h":!0}),b(_h)!=="svelte-dfcv5s"&&(_h.innerHTML=Ox),Xy.forEach(n),X2=a(L),Hn=l(L,"DIV",{class:!0});var Ry=T(Hn);g(Fc.$$.fragment,Ry),R2=a(Ry),bh=l(Ry,"P",{"data-svelte-h":!0}),b(bh)!=="svelte-1nftdf9"&&(bh.textContent=Kx),Ry.forEach(n),L2=a(L),En=l(L,"DIV",{class:!0});var Ly=T(En);g(Xc.$$.fragment,Ly),S2=a(Ly),yh=l(Ly,"P",{"data-svelte-h":!0}),b(yh)!=="svelte-114iuj0"&&(yh.textContent=eJ),Ly.forEach(n),N2=a(L),qn=l(L,"DIV",{class:!0});var Sy=T(qn);g(Rc.$$.fragment,Sy),H2=a(Sy),Th=l(Sy,"P",{"data-svelte-h":!0}),b(Th)!=="svelte-dst59w"&&(Th.innerHTML=tJ),Sy.forEach(n),E2=a(L),Dn=l(L,"DIV",{class:!0});var Ny=T(Dn);g(Lc.$$.fragment,Ny),q2=a(Ny),Mh=l(Ny,"P",{"data-svelte-h":!0}),b(Mh)!=="svelte-15y4kd1"&&(Mh.innerHTML=sJ),Ny.forEach(n),L.forEach(n),Ab=a(e),D=l(e,"DIV",{class:!0});var Qe=T(D);g(Sc.$$.fragment,Qe),D2=a(Qe),vh=l(Qe,"P",{"data-svelte-h":!0}),b(vh)!=="svelte-1x0oesy"&&(vh.innerHTML=nJ),Q2=a(Qe),wh=l(Qe,"P",{"data-svelte-h":!0}),b(wh)!=="svelte-2ai6qp"&&(wh.innerHTML=rJ),Y2=a(Qe),kh=l(Qe,"P",{"data-svelte-h":!0}),b(kh)!=="svelte-18fduhd"&&(kh.innerHTML=aJ),P2=a(Qe),$h=l(Qe,"DIV",{class:!0});var t3=T($h);g(Nc.$$.fragment,t3),t3.forEach(n),A2=a(Qe),Qn=l(Qe,"DIV",{class:!0});var Hy=T(Qn);g(Hc.$$.fragment,Hy),O2=a(Hy),jh=l(Hy,"P",{"data-svelte-h":!0}),b(jh)!=="svelte-1nftdf9"&&(jh.textContent=oJ),Hy.forEach(n),Qe.forEach(n),Ob=a(e),Xt=l(e,"DIV",{class:!0});var hf=T(Xt);g(Ec.$$.fragment,hf),K2=a(hf),xh=l(hf,"P",{"data-svelte-h":!0}),b(xh)!=="svelte-pjm1pe"&&(xh.innerHTML=lJ),ek=a(hf),g(Yn.$$.fragment,hf),hf.forEach(n),Kb=a(e),Rt=l(e,"DIV",{class:!0});var uf=T(Rt);g(qc.$$.fragment,uf),tk=a(uf),Jh=l(uf,"P",{"data-svelte-h":!0}),b(Jh)!=="svelte-api7s7"&&(Jh.innerHTML=cJ),sk=a(uf),g(Pn.$$.fragment,uf),uf.forEach(n),ey=a(e),X=l(e,"DIV",{class:!0});var ve=T(X);g(Dc.$$.fragment,ve),nk=a(ve),Uh=l(ve,"P",{"data-svelte-h":!0}),b(Uh)!=="svelte-ldcea6"&&(Uh.innerHTML=iJ),rk=a(ve),Zh=l(ve,"P",{"data-svelte-h":!0}),b(Zh)!=="svelte-1f9j82e"&&(Zh.innerHTML=dJ),ak=a(ve),g(An.$$.fragment,ve),ok=a(ve),On=l(ve,"DIV",{class:!0});var Ey=T(On);g(Qc.$$.fragment,Ey),lk=a(Ey),Ch=l(Ey,"P",{"data-svelte-h":!0}),b(Ch)!=="svelte-dfcv5s"&&(Ch.innerHTML=pJ),Ey.forEach(n),ck=a(ve),Kn=l(ve,"DIV",{class:!0});var qy=T(Kn);g(Yc.$$.fragment,qy),ik=a(qy),Wh=l(qy,"P",{"data-svelte-h":!0}),b(Wh)!=="svelte-1nftdf9"&&(Wh.textContent=mJ),qy.forEach(n),dk=a(ve),er=l(ve,"DIV",{class:!0});var Dy=T(er);g(Pc.$$.fragment,Dy),pk=a(Dy),Bh=l(Dy,"P",{"data-svelte-h":!0}),b(Bh)!=="svelte-114iuj0"&&(Bh.textContent=gJ),Dy.forEach(n),ve.forEach(n),ty=a(e),Q=l(e,"DIV",{class:!0});var Ye=T(Q);g(Ac.$$.fragment,Ye),mk=a(Ye),Ih=l(Ye,"P",{"data-svelte-h":!0}),b(Ih)!=="svelte-8o3e5p"&&(Ih.textContent=hJ),gk=a(Ye),zh=l(Ye,"P",{"data-svelte-h":!0}),b(zh)!=="svelte-1cyjk9y"&&(zh.textContent=uJ),hk=a(Ye),tr=l(Ye,"DIV",{class:!0});var Qy=T(tr);g(Oc.$$.fragment,Qy),uk=a(Qy),Vh=l(Qy,"P",{"data-svelte-h":!0}),b(Vh)!=="svelte-dfcv5s"&&(Vh.innerHTML=fJ),Qy.forEach(n),fk=a(Ye),sr=l(Ye,"DIV",{class:!0});var Yy=T(sr);g(Kc.$$.fragment,Yy),_k=a(Yy),Gh=l(Yy,"P",{"data-svelte-h":!0}),b(Gh)!=="svelte-t93z5n"&&(Gh.textContent=_J),Yy.forEach(n),bk=a(Ye),nr=l(Ye,"DIV",{class:!0});var Py=T(nr);g(ei.$$.fragment,Py),yk=a(Py),Fh=l(Py,"P",{"data-svelte-h":!0}),b(Fh)!=="svelte-1rjgo2n"&&(Fh.textContent=bJ),Py.forEach(n),Ye.forEach(n),sy=a(e),Y=l(e,"DIV",{class:!0});var Pe=T(Y);g(ti.$$.fragment,Pe),Tk=a(Pe),Xh=l(Pe,"P",{"data-svelte-h":!0}),b(Xh)!=="svelte-1atvuc"&&(Xh.innerHTML=yJ),Mk=a(Pe),g(rr.$$.fragment,Pe),vk=a(Pe),ar=l(Pe,"DIV",{class:!0});var Ay=T(ar);g(si.$$.fragment,Ay),wk=a(Ay),Rh=l(Ay,"P",{"data-svelte-h":!0}),b(Rh)!=="svelte-vi6d54"&&(Rh.innerHTML=TJ),Ay.forEach(n),kk=a(Pe),or=l(Pe,"DIV",{class:!0});var Oy=T(or);g(ni.$$.fragment,Oy),$k=a(Oy),Lh=l(Oy,"P",{"data-svelte-h":!0}),b(Lh)!=="svelte-14hqs6n"&&(Lh.textContent=MJ),Oy.forEach(n),jk=a(Pe),lr=l(Pe,"DIV",{class:!0});var Ky=T(lr);g(ri.$$.fragment,Ky),xk=a(Ky),Sh=l(Ky,"P",{"data-svelte-h":!0}),b(Sh)!=="svelte-135okg0"&&(Sh.textContent=vJ),Ky.forEach(n),Pe.forEach(n),ny=a(e),P=l(e,"DIV",{class:!0});var Ae=T(P);g(ai.$$.fragment,Ae),Jk=a(Ae),Nh=l(Ae,"P",{"data-svelte-h":!0}),b(Nh)!=="svelte-t1noj8"&&(Nh.innerHTML=wJ),Uk=a(Ae),g(cr.$$.fragment,Ae),Zk=a(Ae),ir=l(Ae,"DIV",{class:!0});var eT=T(ir);g(oi.$$.fragment,eT),Ck=a(eT),Hh=l(eT,"P",{"data-svelte-h":!0}),b(Hh)!=="svelte-vi6d54"&&(Hh.innerHTML=kJ),eT.forEach(n),Wk=a(Ae),dr=l(Ae,"DIV",{class:!0});var tT=T(dr);g(li.$$.fragment,tT),Bk=a(tT),Eh=l(tT,"P",{"data-svelte-h":!0}),b(Eh)!=="svelte-14hqs6n"&&(Eh.textContent=$J),tT.forEach(n),Ik=a(Ae),pr=l(Ae,"DIV",{class:!0});var sT=T(pr);g(ci.$$.fragment,sT),zk=a(sT),qh=l(sT,"P",{"data-svelte-h":!0}),b(qh)!=="svelte-oxae9u"&&(qh.textContent=jJ),sT.forEach(n),Ae.forEach(n),ry=a(e),A=l(e,"DIV",{class:!0});var Oe=T(A);g(ii.$$.fragment,Oe),Vk=a(Oe),Dh=l(Oe,"P",{"data-svelte-h":!0}),b(Dh)!=="svelte-oxdq12"&&(Dh.innerHTML=xJ),Gk=a(Oe),g(mr.$$.fragment,Oe),Fk=a(Oe),Qh=l(Oe,"DIV",{class:!0});var s3=T(Qh);g(di.$$.fragment,s3),s3.forEach(n),Xk=a(Oe),Yh=l(Oe,"DIV",{class:!0});var n3=T(Yh);g(pi.$$.fragment,n3),n3.forEach(n),Rk=a(Oe),gr=l(Oe,"DIV",{class:!0});var nT=T(gr);g(mi.$$.fragment,nT),Lk=a(nT),Ph=l(nT,"P",{"data-svelte-h":!0}),b(Ph)!=="svelte-135okg0"&&(Ph.textContent=JJ),nT.forEach(n),Oe.forEach(n),ay=a(e),z=l(e,"DIV",{class:!0});var ee=T(z);g(gi.$$.fragment,ee),Sk=a(ee),Ah=l(ee,"P",{"data-svelte-h":!0}),b(Ah)!=="svelte-16jubgm"&&(Ah.innerHTML=UJ),Nk=a(ee),Oh=l(ee,"P",{"data-svelte-h":!0}),b(Oh)!=="svelte-437xch"&&(Oh.innerHTML=ZJ),Hk=a(ee),Kh=l(ee,"P",{"data-svelte-h":!0}),b(Kh)!=="svelte-1qvpx79"&&(Kh.textContent=CJ),Ek=a(ee),eu=l(ee,"P",{"data-svelte-h":!0}),b(eu)!=="svelte-dhmy5x"&&(eu.innerHTML=WJ),qk=a(ee),g(hr.$$.fragment,ee),Dk=a(ee),tu=l(ee,"DIV",{class:!0});var r3=T(tu);g(hi.$$.fragment,r3),r3.forEach(n),Qk=a(ee),su=l(ee,"DIV",{class:!0});var a3=T(su);g(ui.$$.fragment,a3),a3.forEach(n),ee.forEach(n),oy=a(e),V=l(e,"DIV",{class:!0});var te=T(V);g(fi.$$.fragment,te),Yk=a(te),nu=l(te,"P",{"data-svelte-h":!0}),b(nu)!=="svelte-biazxg"&&(nu.textContent=BJ),Pk=a(te),g(ur.$$.fragment,te),Ak=a(te),fr=l(te,"DIV",{class:!0});var rT=T(fr);g(_i.$$.fragment,rT),Ok=a(rT),ru=l(rT,"P",{"data-svelte-h":!0}),b(ru)!=="svelte-1nftdf9"&&(ru.textContent=IJ),rT.forEach(n),Kk=a(te),_r=l(te,"DIV",{class:!0});var aT=T(_r);g(bi.$$.fragment,aT),e1=a(aT),au=l(aT,"P",{"data-svelte-h":!0}),b(au)!=="svelte-qvnpmr"&&(au.innerHTML=zJ),aT.forEach(n),t1=a(te),br=l(te,"DIV",{class:!0});var oT=T(br);g(yi.$$.fragment,oT),s1=a(oT),ou=l(oT,"P",{"data-svelte-h":!0}),b(ou)!=="svelte-1tx1mox"&&(ou.innerHTML=VJ),oT.forEach(n),n1=a(te),lu=l(te,"DIV",{class:!0});var o3=T(lu);g(Ti.$$.fragment,o3),o3.forEach(n),r1=a(te),yr=l(te,"DIV",{class:!0});var lT=T(yr);g(Mi.$$.fragment,lT),a1=a(lT),cu=l(lT,"P",{"data-svelte-h":!0}),b(cu)!=="svelte-114iuj0"&&(cu.textContent=GJ),lT.forEach(n),te.forEach(n),ly=a(e),O=l(e,"DIV",{class:!0});var Ke=T(O);g(vi.$$.fragment,Ke),o1=a(Ke),iu=l(Ke,"P",{"data-svelte-h":!0}),b(iu)!=="svelte-plgsbf"&&(iu.textContent=FJ),l1=a(Ke),g(Tr.$$.fragment,Ke),c1=a(Ke),du=l(Ke,"DIV",{class:!0});var l3=T(du);g(wi.$$.fragment,l3),l3.forEach(n),i1=a(Ke),pu=l(Ke,"DIV",{class:!0});var c3=T(pu);g(ki.$$.fragment,c3),c3.forEach(n),d1=a(Ke),mu=l(Ke,"DIV",{class:!0});var i3=T(mu);g($i.$$.fragment,i3),i3.forEach(n),Ke.forEach(n),cy=a(e),g(ji.$$.fragment,e),iy=a(e),ge=l(e,"DIV",{class:!0});var is=T(ge);g(xi.$$.fragment,is),p1=a(is),gu=l(is,"P",{"data-svelte-h":!0}),b(gu)!=="svelte-8pa9bo"&&(gu.innerHTML=XJ),m1=a(is),hu=l(is,"P",{"data-svelte-h":!0}),b(hu)!=="svelte-1wzt57b"&&(hu.textContent=RJ),g1=a(is),uu=l(is,"UL",{"data-svelte-h":!0}),b(uu)!=="svelte-vgskhd"&&(uu.innerHTML=LJ),h1=a(is),Mr=l(is,"DIV",{class:!0});var cT=T(Mr);g(Ji.$$.fragment,cT),u1=a(cT),fu=l(cT,"P",{"data-svelte-h":!0}),b(fu)!=="svelte-1eed40t"&&(fu.textContent=SJ),cT.forEach(n),is.forEach(n),dy=a(e),he=l(e,"DIV",{class:!0});var ds=T(he);g(Ui.$$.fragment,ds),f1=a(ds),_u=l(ds,"P",{"data-svelte-h":!0}),b(_u)!=="svelte-17osgxw"&&(_u.innerHTML=NJ),_1=a(ds),bu=l(ds,"P",{"data-svelte-h":!0}),b(bu)!=="svelte-y9hsik"&&(bu.innerHTML=HJ),b1=a(ds),g(vr.$$.fragment,ds),y1=a(ds),wr=l(ds,"DIV",{class:!0});var iT=T(wr);g(Zi.$$.fragment,iT),T1=a(iT),yu=l(iT,"P",{"data-svelte-h":!0}),b(yu)!=="svelte-8xv78e"&&(yu.textContent=EJ),iT.forEach(n),ds.forEach(n),py=a(e),Lt=l(e,"DIV",{class:!0});var ff=T(Lt);g(Ci.$$.fragment,ff),M1=a(ff),Tu=l(ff,"P",{"data-svelte-h":!0}),b(Tu)!=="svelte-vzpvds"&&(Tu.innerHTML=qJ),v1=a(ff),Mu=l(ff,"P",{"data-svelte-h":!0}),b(Mu)!=="svelte-l1blo3"&&(Mu.innerHTML=DJ),ff.forEach(n),my=a(e),R=l(e,"DIV",{class:!0});var we=T(R);g(Wi.$$.fragment,we),w1=a(we),vu=l(we,"P",{"data-svelte-h":!0}),b(vu)!=="svelte-ti06z9"&&(vu.textContent=QJ),k1=a(we),wu=l(we,"P",{"data-svelte-h":!0}),b(wu)!=="svelte-vwtjd"&&(wu.innerHTML=YJ),$1=a(we),ku=l(we,"P",{"data-svelte-h":!0}),b(ku)!=="svelte-m9ljkx"&&(ku.textContent=PJ),j1=a(we),$u=l(we,"P",{"data-svelte-h":!0}),b($u)!=="svelte-19piw51"&&($u.innerHTML=AJ),x1=a(we),ju=l(we,"P",{"data-svelte-h":!0}),b(ju)!=="svelte-hswkmf"&&(ju.innerHTML=OJ),J1=a(we),kr=l(we,"DIV",{class:!0});var dT=T(kr);g(Bi.$$.fragment,dT),U1=a(dT),xu=l(dT,"P",{"data-svelte-h":!0}),b(xu)!=="svelte-1pf58kz"&&(xu.textContent=KJ),dT.forEach(n),we.forEach(n),gy=a(e),St=l(e,"DIV",{class:!0});var _f=T(St);g(Ii.$$.fragment,_f),Z1=a(_f),Ju=l(_f,"P",{"data-svelte-h":!0}),b(Ju)!=="svelte-1hdm2wz"&&(Ju.innerHTML=eU),C1=a(_f),g($r.$$.fragment,_f),_f.forEach(n),hy=a(e),ue=l(e,"DIV",{class:!0});var ps=T(ue);g(zi.$$.fragment,ps),W1=a(ps),Uu=l(ps,"P",{"data-svelte-h":!0}),b(Uu)!=="svelte-8dvois"&&(Uu.textContent=tU),B1=a(ps),Zu=l(ps,"P",{"data-svelte-h":!0}),b(Zu)!=="svelte-1xpqz8m"&&(Zu.textContent=sU),I1=a(ps),g(jr.$$.fragment,ps),z1=a(ps),Cu=l(ps,"DIV",{class:!0});var d3=T(Cu);g(Vi.$$.fragment,d3),d3.forEach(n),ps.forEach(n),uy=a(e),g(Gi.$$.fragment,e),fy=a(e),bf=l(e,"P",{}),T(bf).forEach(n),this.h()},h(){M(c,"name","hf:doc:metadata"),M(c,"content",_Z),M(ms,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(us,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ys,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ts,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ms,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ws,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ks,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Is,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ld,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ed,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Od,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ep,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(sp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(cp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ip,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Np,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Yp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ap,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kp,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(im,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(um,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ym,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Um,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Lm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Em,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dm,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ym,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Om,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Km,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(js,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ng,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(It,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Js,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Og,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kg,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(th,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(sh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(In,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(En,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($h,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(On,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Kn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(er,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(sr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ar,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(or,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ir,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(dr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Yh,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(gr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(su,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_r,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(br,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(lu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(du,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(St,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cu,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,c),p(e,$,i),p(e,y,i),p(e,d,i),h(w,e,i),p(e,s,i),p(e,k,i),p(e,zf,i),h(Gr,e,i),p(e,Vf,i),p(e,Fr,i),p(e,Gf,i),p(e,Xr,i),p(e,Ff,i),h(Rr,e,i),p(e,Xf,i),p(e,Lr,i),p(e,Rf,i),p(e,Sr,i),p(e,Lf,i),p(e,Nr,i),p(e,Sf,i),p(e,Hr,i),p(e,Nf,i),p(e,Er,i),p(e,Hf,i),h(qr,e,i),p(e,Ef,i),p(e,Dr,i),p(e,qf,i),p(e,Qr,i),p(e,Df,i),p(e,Yr,i),p(e,Qf,i),h(Pr,e,i),p(e,Yf,i),p(e,ms,i),h(Ar,ms,null),t(ms,pT),t(ms,td),p(e,Pf,i),p(e,gs,i),h(Or,gs,null),t(gs,mT),t(gs,sd),p(e,Af,i),p(e,hs,i),h(Kr,hs,null),t(hs,gT),t(hs,nd),p(e,Of,i),p(e,us,i),h(ea,us,null),t(us,hT),t(us,rd),p(e,Kf,i),h(ta,e,i),p(e,e_,i),p(e,fs,i),h(sa,fs,null),t(fs,uT),t(fs,ad),p(e,t_,i),p(e,_s,i),h(na,_s,null),t(_s,fT),t(_s,od),p(e,s_,i),p(e,bs,i),h(ra,bs,null),t(bs,_T),t(bs,ld),p(e,n_,i),p(e,ys,i),h(aa,ys,null),t(ys,bT),t(ys,cd),p(e,r_,i),p(e,Ts,i),h(oa,Ts,null),t(Ts,yT),t(Ts,id),p(e,a_,i),p(e,Ms,i),h(la,Ms,null),t(Ms,TT),t(Ms,dd),p(e,o_,i),p(e,vs,i),h(ca,vs,null),t(vs,MT),t(vs,pd),p(e,l_,i),p(e,ws,i),h(ia,ws,null),t(ws,vT),t(ws,md),p(e,c_,i),p(e,ks,i),h(da,ks,null),t(ks,wT),t(ks,gd),p(e,i_,i),p(e,$s,i),h(pa,$s,null),t($s,kT),t($s,hd),p(e,d_,i),h(ma,e,i),p(e,p_,i),p(e,et,i),h(ga,et,null),t(et,$T),t(et,ud),t(et,jT),t(et,Is),h(ha,Is,null),t(Is,xT),t(Is,fd),p(e,m_,i),p(e,tt,i),h(ua,tt,null),t(tt,JT),t(tt,_d),t(tt,UT),t(tt,zs),h(fa,zs,null),t(zs,ZT),t(zs,bd),p(e,g_,i),p(e,st,i),h(_a,st,null),t(st,CT),t(st,yd),t(st,WT),t(st,Vs),h(ba,Vs,null),t(Vs,BT),t(Vs,Td),p(e,h_,i),h(ya,e,i),p(e,u_,i),p(e,Ta,i),p(e,f_,i),h(Ma,e,i),p(e,__,i),p(e,ke,i),h(va,ke,null),t(ke,IT),t(ke,Md),t(ke,zT),h(Gs,ke,null),t(ke,VT),t(ke,vd),h(wa,vd,null),p(e,b_,i),p(e,S,i),h(ka,S,null),t(S,GT),t(S,wd),t(S,FT),t(S,kd),t(S,XT),h(Fs,S,null),t(S,RT),h(Xs,S,null),t(S,LT),t(S,$d),h($a,$d,null),p(e,y_,i),p(e,se,i),h(ja,se,null),t(se,ST),t(se,jd),t(se,NT),t(se,xd),t(se,HT),h(Rs,se,null),t(se,ET),t(se,Jd),h(xa,Jd,null),p(e,T_,i),p(e,ne,i),h(Ja,ne,null),t(ne,qT),t(ne,Ud),t(ne,DT),t(ne,Zd),t(ne,QT),h(Ls,ne,null),t(ne,YT),t(ne,Cd),h(Ua,Cd,null),p(e,M_,i),p(e,$e,i),h(Za,$e,null),t($e,PT),t($e,Wd),t($e,AT),h(Ss,$e,null),t($e,OT),t($e,Bd),h(Ca,Bd,null),p(e,v_,i),p(e,je,i),h(Wa,je,null),t(je,KT),t(je,Id),t(je,eM),h(Ns,je,null),t(je,tM),t(je,zd),h(Ba,zd,null),p(e,w_,i),p(e,xe,i),h(Ia,xe,null),t(xe,sM),t(xe,Vd),t(xe,nM),h(Hs,xe,null),t(xe,rM),t(xe,Gd),h(za,Gd,null),p(e,k_,i),p(e,Je,i),h(Va,Je,null),t(Je,aM),t(Je,Fd),t(Je,oM),h(Es,Je,null),t(Je,lM),t(Je,Xd),h(Ga,Xd,null),p(e,$_,i),p(e,Ue,i),h(Fa,Ue,null),t(Ue,cM),t(Ue,Rd),t(Ue,iM),h(qs,Ue,null),t(Ue,dM),t(Ue,Ld),h(Xa,Ld,null),p(e,j_,i),p(e,N,i),h(Ra,N,null),t(N,pM),t(N,Sd),t(N,mM),t(N,Nd),t(N,gM),t(N,Hd),t(N,hM),h(Ds,N,null),t(N,uM),t(N,Ed),h(La,Ed,null),p(e,x_,i),p(e,Ze,i),h(Sa,Ze,null),t(Ze,fM),t(Ze,qd),t(Ze,_M),t(Ze,Dd),t(Ze,bM),t(Ze,Qd),h(Na,Qd,null),p(e,J_,i),p(e,Ce,i),h(Ha,Ce,null),t(Ce,yM),t(Ce,Yd),t(Ce,TM),h(Qs,Ce,null),t(Ce,MM),t(Ce,Pd),h(Ea,Pd,null),p(e,U_,i),p(e,nt,i),h(qa,nt,null),t(nt,vM),t(nt,Ad),t(nt,wM),t(nt,Od),h(Da,Od,null),p(e,Z_,i),p(e,rt,i),h(Qa,rt,null),t(rt,kM),t(rt,Kd),t(rt,$M),t(rt,ep),h(Ya,ep,null),p(e,C_,i),p(e,We,i),h(Pa,We,null),t(We,jM),t(We,tp),t(We,xM),h(Ys,We,null),t(We,JM),t(We,sp),h(Aa,sp,null),p(e,W_,i),p(e,Be,i),h(Oa,Be,null),t(Be,UM),t(Be,np),t(Be,ZM),h(Ps,Be,null),t(Be,CM),t(Be,rp),h(Ka,rp,null),p(e,B_,i),p(e,H,i),h(eo,H,null),t(H,WM),t(H,ap),t(H,BM),t(H,op),t(H,IM),t(H,lp),t(H,zM),h(As,H,null),t(H,VM),t(H,cp),h(to,cp,null),p(e,I_,i),p(e,re,i),h(so,re,null),t(re,GM),t(re,ip),t(re,FM),h(Os,re,null),t(re,XM),h(Ks,re,null),t(re,RM),t(re,dp),h(no,dp,null),p(e,z_,i),p(e,ae,i),h(ro,ae,null),t(ae,LM),t(ae,pp),t(ae,SM),h(en,ae,null),t(ae,NM),h(tn,ae,null),t(ae,HM),t(ae,mp),h(ao,mp,null),p(e,V_,i),p(e,Ie,i),h(oo,Ie,null),t(Ie,EM),t(Ie,gp),t(Ie,qM),h(sn,Ie,null),t(Ie,DM),t(Ie,hp),h(lo,hp,null),p(e,G_,i),p(e,oe,i),h(co,oe,null),t(oe,QM),t(oe,up),t(oe,YM),t(oe,fp),t(oe,PM),h(nn,oe,null),t(oe,AM),t(oe,_p),h(io,_p,null),p(e,F_,i),p(e,le,i),h(po,le,null),t(le,OM),t(le,bp),t(le,KM),h(rn,le,null),t(le,ev),h(an,le,null),t(le,tv),t(le,yp),h(mo,yp,null),p(e,X_,i),p(e,ze,i),h(go,ze,null),t(ze,sv),t(ze,Tp),t(ze,nv),h(on,ze,null),t(ze,rv),t(ze,Mp),h(ho,Mp,null),p(e,R_,i),p(e,Ve,i),h(uo,Ve,null),t(Ve,av),t(Ve,vp),t(Ve,ov),h(ln,Ve,null),t(Ve,lv),t(Ve,wp),h(fo,wp,null),p(e,L_,i),p(e,G,i),h(_o,G,null),t(G,cv),t(G,kp),t(G,iv),t(G,$p),t(G,dv),t(G,jp),t(G,pv),t(G,xp),t(G,mv),h(cn,G,null),t(G,gv),t(G,Jp),h(bo,Jp,null),p(e,S_,i),p(e,ce,i),h(yo,ce,null),t(ce,hv),t(ce,Up),t(ce,uv),h(dn,ce,null),t(ce,fv),h(pn,ce,null),t(ce,_v),t(ce,Zp),h(To,Zp,null),p(e,N_,i),p(e,Ge,i),h(Mo,Ge,null),t(Ge,bv),t(Ge,Cp),t(Ge,yv),h(mn,Ge,null),t(Ge,Tv),t(Ge,Wp),h(vo,Wp,null),p(e,H_,i),p(e,Fe,i),h(wo,Fe,null),t(Fe,Mv),t(Fe,Bp),t(Fe,vv),h(gn,Fe,null),t(Fe,wv),t(Fe,Ip),h(ko,Ip,null),p(e,E_,i),p(e,ie,i),h($o,ie,null),t(ie,kv),t(ie,zp),t(ie,$v),t(ie,Vp),t(ie,jv),h(hn,ie,null),t(ie,xv),t(ie,Gp),h(jo,Gp,null),p(e,q_,i),p(e,de,i),h(xo,de,null),t(de,Jv),t(de,Fp),t(de,Uv),t(de,Xp),t(de,Zv),h(un,de,null),t(de,Cv),t(de,Rp),h(Jo,Rp,null),p(e,D_,i),p(e,pe,i),h(Uo,pe,null),t(pe,Wv),t(pe,Lp),t(pe,Bv),t(pe,Sp),t(pe,Iv),h(fn,pe,null),t(pe,zv),t(pe,Np),h(Zo,Np,null),p(e,Q_,i),p(e,E,i),h(Co,E,null),t(E,Vv),t(E,Hp),t(E,Gv),t(E,Ep),t(E,Fv),t(E,qp),t(E,Xv),h(_n,E,null),t(E,Rv),t(E,Dp),h(Wo,Dp,null),p(e,Y_,i),h(Bo,e,i),p(e,P_,i),p(e,at,i),h(Io,at,null),t(at,Lv),t(at,Qp),t(at,Sv),t(at,Yp),h(zo,Yp,null),p(e,A_,i),p(e,ot,i),h(Vo,ot,null),t(ot,Nv),t(ot,Pp),t(ot,Hv),t(ot,Ap),h(Go,Ap,null),p(e,O_,i),p(e,lt,i),h(Fo,lt,null),t(lt,Ev),t(lt,Op),t(lt,qv),t(lt,Kp),h(Xo,Kp,null),p(e,K_,i),p(e,ct,i),h(Ro,ct,null),t(ct,Dv),t(ct,em),t(ct,Qv),t(ct,bn),h(Lo,bn,null),t(bn,Yv),t(bn,tm),p(e,eb,i),p(e,it,i),h(So,it,null),t(it,Pv),t(it,sm),t(it,Av),t(it,nm),h(No,nm,null),p(e,tb,i),p(e,dt,i),h(Ho,dt,null),t(dt,Ov),t(dt,rm),t(dt,Kv),t(dt,yn),h(Eo,yn,null),t(yn,ew),t(yn,am),p(e,sb,i),p(e,pt,i),h(qo,pt,null),t(pt,tw),t(pt,om),t(pt,sw),t(pt,lm),h(Do,lm,null),p(e,nb,i),p(e,mt,i),h(Qo,mt,null),t(mt,nw),t(mt,cm),t(mt,rw),t(mt,im),h(Yo,im,null),p(e,rb,i),p(e,gt,i),h(Po,gt,null),t(gt,aw),t(gt,dm),t(gt,ow),t(gt,pm),h(Ao,pm,null),p(e,ab,i),p(e,ht,i),h(Oo,ht,null),t(ht,lw),t(ht,mm),t(ht,cw),t(ht,gm),h(Ko,gm,null),p(e,ob,i),p(e,ut,i),h(el,ut,null),t(ut,iw),t(ut,hm),t(ut,dw),t(ut,um),h(tl,um,null),p(e,lb,i),p(e,ft,i),h(sl,ft,null),t(ft,pw),t(ft,fm),t(ft,mw),t(ft,_m),h(nl,_m,null),p(e,cb,i),p(e,_t,i),h(rl,_t,null),t(_t,gw),t(_t,bm),t(_t,hw),t(_t,ym),h(al,ym,null),p(e,ib,i),p(e,bt,i),h(ol,bt,null),t(bt,uw),t(bt,Tm),t(bt,fw),t(bt,Mm),h(ll,Mm,null),p(e,db,i),p(e,yt,i),h(cl,yt,null),t(yt,_w),t(yt,vm),t(yt,bw),t(yt,wm),h(il,wm,null),p(e,pb,i),h(dl,e,i),p(e,mb,i),p(e,Tt,i),h(pl,Tt,null),t(Tt,yw),t(Tt,km),t(Tt,Tw),t(Tt,$m),h(ml,$m,null),p(e,gb,i),p(e,Mt,i),h(gl,Mt,null),t(Mt,Mw),t(Mt,jm),t(Mt,vw),t(Mt,xm),h(hl,xm,null),p(e,hb,i),p(e,vt,i),h(ul,vt,null),t(vt,ww),t(vt,Jm),t(vt,kw),t(vt,Um),h(fl,Um,null),p(e,ub,i),p(e,wt,i),h(_l,wt,null),t(wt,$w),t(wt,Zm),t(wt,jw),t(wt,Tn),h(bl,Tn,null),t(Tn,xw),t(Tn,Cm),p(e,fb,i),p(e,kt,i),h(yl,kt,null),t(kt,Jw),t(kt,Wm),t(kt,Uw),t(kt,Bm),h(Tl,Bm,null),p(e,_b,i),p(e,$t,i),h(Ml,$t,null),t($t,Zw),t($t,Im),t($t,Cw),t($t,Mn),h(vl,Mn,null),t(Mn,Ww),t(Mn,zm),p(e,bb,i),p(e,jt,i),h(wl,jt,null),t(jt,Bw),t(jt,Vm),t(jt,Iw),t(jt,Gm),h(kl,Gm,null),p(e,yb,i),p(e,xt,i),h($l,xt,null),t(xt,zw),t(xt,Fm),t(xt,Vw),t(xt,Xm),h(jl,Xm,null),p(e,Tb,i),p(e,Jt,i),h(xl,Jt,null),t(Jt,Gw),t(Jt,Rm),t(Jt,Fw),t(Jt,Lm),h(Jl,Lm,null),p(e,Mb,i),p(e,Ut,i),h(Ul,Ut,null),t(Ut,Xw),t(Ut,Sm),t(Ut,Rw),t(Ut,Nm),h(Zl,Nm,null),p(e,vb,i),p(e,Zt,i),h(Cl,Zt,null),t(Zt,Lw),t(Zt,Hm),t(Zt,Sw),t(Zt,Em),h(Wl,Em,null),p(e,wb,i),p(e,Ct,i),h(Bl,Ct,null),t(Ct,Nw),t(Ct,qm),t(Ct,Hw),t(Ct,Dm),h(Il,Dm,null),p(e,kb,i),p(e,Wt,i),h(zl,Wt,null),t(Wt,Ew),t(Wt,Qm),t(Wt,qw),t(Wt,Ym),h(Vl,Ym,null),p(e,$b,i),h(Gl,e,i),p(e,jb,i),p(e,Fl,i),p(e,xb,i),p(e,Xe,i),h(Xl,Xe,null),t(Xe,Dw),t(Xe,Pm),t(Xe,Qw),t(Xe,Am),t(Xe,Yw),t(Xe,Om),h(Rl,Om,null),p(e,Jb,i),p(e,js,i),h(Ll,js,null),t(js,Pw),t(js,Km),h(Sl,Km,null),p(e,Ub,i),p(e,Bt,i),h(Nl,Bt,null),t(Bt,Aw),t(Bt,eg),t(Bt,Ow),t(Bt,tg),h(Hl,tg,null),p(e,Zb,i),p(e,It,i),h(El,It,null),t(It,Kw),t(It,sg),t(It,e0),t(It,ng),h(ql,ng,null),p(e,Cb,i),p(e,J,i),h(Dl,J,null),t(J,t0),t(J,rg),t(J,s0),t(J,ag),t(J,n0),t(J,og),t(J,r0),t(J,lg),t(J,a0),t(J,cg),t(J,o0),t(J,ig),t(J,l0),t(J,dg),t(J,c0),t(J,pg),t(J,i0),t(J,mg),t(J,d0),t(J,gg),t(J,p0),t(J,hg),t(J,m0),t(J,ug),t(J,g0),t(J,fg),t(J,h0),t(J,_g),t(J,u0),t(J,bg),t(J,f0),t(J,yg),t(J,_0),t(J,Tg),t(J,b0),t(J,Mg),t(J,y0),t(J,vg),t(J,T0),h(vn,J,null),t(J,M0),t(J,wg),h(Ql,wg,null),p(e,Wb,i),p(e,zt,i),h(Yl,zt,null),t(zt,v0),t(zt,kg),t(zt,w0),t(zt,$g),h(Pl,$g,null),p(e,Bb,i),h(Al,e,i),p(e,Ib,i),p(e,Ol,i),p(e,zb,i),p(e,W,i),h(Kl,W,null),t(W,k0),t(W,jg),t(W,$0),t(W,xg),t(W,j0),h(wn,W,null),t(W,x0),t(W,Jg),t(W,J0),t(W,kn),h(ec,kn,null),t(kn,U0),t(kn,Ug),t(W,Z0),t(W,$n),h(tc,$n,null),t($n,C0),t($n,Zg),t(W,W0),t(W,jn),h(sc,jn,null),t(jn,B0),t(jn,Cg),t(W,I0),t(W,xn),h(nc,xn,null),t(xn,z0),t(xn,Wg),t(W,V0),t(W,Jn),h(rc,Jn,null),t(Jn,G0),t(Jn,Bg),t(W,F0),t(W,Un),h(ac,Un,null),t(Un,X0),t(Un,Ig),t(W,R0),t(W,Kt),h(oc,Kt,null),t(Kt,L0),t(Kt,zg),t(Kt,S0),t(Kt,Vg),p(e,Vb,i),p(e,xs,i),h(lc,xs,null),t(xs,N0),t(xs,Gg),p(e,Gb,i),p(e,Js,i),h(cc,Js,null),t(Js,H0),t(Js,Fg),p(e,Fb,i),p(e,Re,i),h(ic,Re,null),t(Re,E0),t(Re,Xg),t(Re,q0),t(Re,K),h(dc,K,null),t(K,D0),t(K,Rg),t(K,Q0),t(K,Lg),t(K,Y0),t(K,Sg),t(K,P0),t(K,Ng),t(K,A0),t(K,Hg),t(Re,O0),t(Re,Zn),h(pc,Zn,null),t(Zn,K0),t(Zn,Eg),p(e,Xb,i),h(mc,e,i),p(e,Rb,i),p(e,Le,i),h(gc,Le,null),t(Le,e2),t(Le,qg),t(Le,t2),t(Le,Dg),h(hc,Dg,null),t(Le,s2),t(Le,Qg),h(uc,Qg,null),p(e,Lb,i),p(e,q,i),h(fc,q,null),t(q,n2),t(q,Yg),t(q,r2),t(q,Pg),t(q,a2),t(q,Ag),t(q,o2),t(q,Og),h(_c,Og,null),t(q,l2),t(q,Kg),h(bc,Kg,null),p(e,Sb,i),p(e,Se,i),h(yc,Se,null),t(Se,c2),t(Se,eh),t(Se,i2),t(Se,th),h(Tc,th,null),t(Se,d2),t(Se,sh),h(Mc,sh,null),p(e,Nb,i),h(vc,e,i),p(e,Hb,i),p(e,F,i),h(wc,F,null),t(F,p2),t(F,nh),t(F,m2),h(Cn,F,null),t(F,g2),h(Wn,F,null),t(F,h2),t(F,Bn),h(kc,Bn,null),t(Bn,u2),t(Bn,rh),t(F,f2),t(F,In),h($c,In,null),t(In,_2),t(In,ah),t(F,b2),t(F,zn),h(jc,zn,null),t(zn,y2),t(zn,oh),p(e,Eb,i),p(e,me,i),h(xc,me,null),t(me,T2),t(me,lh),t(me,M2),h(Vn,me,null),t(me,v2),h(Gn,me,null),t(me,w2),t(me,Fn),h(Jc,Fn,null),t(Fn,k2),t(Fn,ch),p(e,qb,i),h(Uc,e,i),p(e,Db,i),p(e,Vt,i),h(Zc,Vt,null),t(Vt,$2),t(Vt,ih),t(Vt,j2),t(Vt,Xn),h(Cc,Xn,null),t(Xn,x2),t(Xn,dh),p(e,Qb,i),p(e,Gt,i),h(Wc,Gt,null),t(Gt,J2),t(Gt,ph),t(Gt,U2),t(Gt,Rn),h(Bc,Rn,null),t(Rn,Z2),t(Rn,mh),p(e,Yb,i),p(e,Ft,i),h(Ic,Ft,null),t(Ft,C2),t(Ft,gh),t(Ft,W2),t(Ft,Ln),h(zc,Ln,null),t(Ln,B2),t(Ln,hh),p(e,Pb,i),p(e,I,i),h(Vc,I,null),t(I,I2),t(I,uh),t(I,z2),t(I,fh),t(I,V2),h(Sn,I,null),t(I,G2),t(I,Nn),h(Gc,Nn,null),t(Nn,F2),t(Nn,_h),t(I,X2),t(I,Hn),h(Fc,Hn,null),t(Hn,R2),t(Hn,bh),t(I,L2),t(I,En),h(Xc,En,null),t(En,S2),t(En,yh),t(I,N2),t(I,qn),h(Rc,qn,null),t(qn,H2),t(qn,Th),t(I,E2),t(I,Dn),h(Lc,Dn,null),t(Dn,q2),t(Dn,Mh),p(e,Ab,i),p(e,D,i),h(Sc,D,null),t(D,D2),t(D,vh),t(D,Q2),t(D,wh),t(D,Y2),t(D,kh),t(D,P2),t(D,$h),h(Nc,$h,null),t(D,A2),t(D,Qn),h(Hc,Qn,null),t(Qn,O2),t(Qn,jh),p(e,Ob,i),p(e,Xt,i),h(Ec,Xt,null),t(Xt,K2),t(Xt,xh),t(Xt,ek),h(Yn,Xt,null),p(e,Kb,i),p(e,Rt,i),h(qc,Rt,null),t(Rt,tk),t(Rt,Jh),t(Rt,sk),h(Pn,Rt,null),p(e,ey,i),p(e,X,i),h(Dc,X,null),t(X,nk),t(X,Uh),t(X,rk),t(X,Zh),t(X,ak),h(An,X,null),t(X,ok),t(X,On),h(Qc,On,null),t(On,lk),t(On,Ch),t(X,ck),t(X,Kn),h(Yc,Kn,null),t(Kn,ik),t(Kn,Wh),t(X,dk),t(X,er),h(Pc,er,null),t(er,pk),t(er,Bh),p(e,ty,i),p(e,Q,i),h(Ac,Q,null),t(Q,mk),t(Q,Ih),t(Q,gk),t(Q,zh),t(Q,hk),t(Q,tr),h(Oc,tr,null),t(tr,uk),t(tr,Vh),t(Q,fk),t(Q,sr),h(Kc,sr,null),t(sr,_k),t(sr,Gh),t(Q,bk),t(Q,nr),h(ei,nr,null),t(nr,yk),t(nr,Fh),p(e,sy,i),p(e,Y,i),h(ti,Y,null),t(Y,Tk),t(Y,Xh),t(Y,Mk),h(rr,Y,null),t(Y,vk),t(Y,ar),h(si,ar,null),t(ar,wk),t(ar,Rh),t(Y,kk),t(Y,or),h(ni,or,null),t(or,$k),t(or,Lh),t(Y,jk),t(Y,lr),h(ri,lr,null),t(lr,xk),t(lr,Sh),p(e,ny,i),p(e,P,i),h(ai,P,null),t(P,Jk),t(P,Nh),t(P,Uk),h(cr,P,null),t(P,Zk),t(P,ir),h(oi,ir,null),t(ir,Ck),t(ir,Hh),t(P,Wk),t(P,dr),h(li,dr,null),t(dr,Bk),t(dr,Eh),t(P,Ik),t(P,pr),h(ci,pr,null),t(pr,zk),t(pr,qh),p(e,ry,i),p(e,A,i),h(ii,A,null),t(A,Vk),t(A,Dh),t(A,Gk),h(mr,A,null),t(A,Fk),t(A,Qh),h(di,Qh,null),t(A,Xk),t(A,Yh),h(pi,Yh,null),t(A,Rk),t(A,gr),h(mi,gr,null),t(gr,Lk),t(gr,Ph),p(e,ay,i),p(e,z,i),h(gi,z,null),t(z,Sk),t(z,Ah),t(z,Nk),t(z,Oh),t(z,Hk),t(z,Kh),t(z,Ek),t(z,eu),t(z,qk),h(hr,z,null),t(z,Dk),t(z,tu),h(hi,tu,null),t(z,Qk),t(z,su),h(ui,su,null),p(e,oy,i),p(e,V,i),h(fi,V,null),t(V,Yk),t(V,nu),t(V,Pk),h(ur,V,null),t(V,Ak),t(V,fr),h(_i,fr,null),t(fr,Ok),t(fr,ru),t(V,Kk),t(V,_r),h(bi,_r,null),t(_r,e1),t(_r,au),t(V,t1),t(V,br),h(yi,br,null),t(br,s1),t(br,ou),t(V,n1),t(V,lu),h(Ti,lu,null),t(V,r1),t(V,yr),h(Mi,yr,null),t(yr,a1),t(yr,cu),p(e,ly,i),p(e,O,i),h(vi,O,null),t(O,o1),t(O,iu),t(O,l1),h(Tr,O,null),t(O,c1),t(O,du),h(wi,du,null),t(O,i1),t(O,pu),h(ki,pu,null),t(O,d1),t(O,mu),h($i,mu,null),p(e,cy,i),h(ji,e,i),p(e,iy,i),p(e,ge,i),h(xi,ge,null),t(ge,p1),t(ge,gu),t(ge,m1),t(ge,hu),t(ge,g1),t(ge,uu),t(ge,h1),t(ge,Mr),h(Ji,Mr,null),t(Mr,u1),t(Mr,fu),p(e,dy,i),p(e,he,i),h(Ui,he,null),t(he,f1),t(he,_u),t(he,_1),t(he,bu),t(he,b1),h(vr,he,null),t(he,y1),t(he,wr),h(Zi,wr,null),t(wr,T1),t(wr,yu),p(e,py,i),p(e,Lt,i),h(Ci,Lt,null),t(Lt,M1),t(Lt,Tu),t(Lt,v1),t(Lt,Mu),p(e,my,i),p(e,R,i),h(Wi,R,null),t(R,w1),t(R,vu),t(R,k1),t(R,wu),t(R,$1),t(R,ku),t(R,j1),t(R,$u),t(R,x1),t(R,ju),t(R,J1),t(R,kr),h(Bi,kr,null),t(kr,U1),t(kr,xu),p(e,gy,i),p(e,St,i),h(Ii,St,null),t(St,Z1),t(St,Ju),t(St,C1),h($r,St,null),p(e,hy,i),p(e,ue,i),h(zi,ue,null),t(ue,W1),t(ue,Uu),t(ue,B1),t(ue,Zu),t(ue,I1),h(jr,ue,null),t(ue,z1),t(ue,Cu),h(Vi,Cu,null),p(e,uy,i),h(Gi,e,i),p(e,fy,i),p(e,bf,i),_y=!0},p(e,[i]){const Fi={};i&2&&(Fi.$$scope={dirty:i,ctx:e}),Gs.$set(Fi);const Xi={};i&2&&(Xi.$$scope={dirty:i,ctx:e}),Fs.$set(Xi);const Ri={};i&2&&(Ri.$$scope={dirty:i,ctx:e}),Xs.$set(Ri);const Li={};i&2&&(Li.$$scope={dirty:i,ctx:e}),Rs.$set(Li);const Si={};i&2&&(Si.$$scope={dirty:i,ctx:e}),Ls.$set(Si);const Ni={};i&2&&(Ni.$$scope={dirty:i,ctx:e}),Ss.$set(Ni);const Hi={};i&2&&(Hi.$$scope={dirty:i,ctx:e}),Ns.$set(Hi);const Ei={};i&2&&(Ei.$$scope={dirty:i,ctx:e}),Hs.$set(Ei);const qi={};i&2&&(qi.$$scope={dirty:i,ctx:e}),Es.$set(qi);const Di={};i&2&&(Di.$$scope={dirty:i,ctx:e}),qs.$set(Di);const Qi={};i&2&&(Qi.$$scope={dirty:i,ctx:e}),Ds.$set(Qi);const Yi={};i&2&&(Yi.$$scope={dirty:i,ctx:e}),Qs.$set(Yi);const Pi={};i&2&&(Pi.$$scope={dirty:i,ctx:e}),Ys.$set(Pi);const Ai={};i&2&&(Ai.$$scope={dirty:i,ctx:e}),Ps.$set(Ai);const Us={};i&2&&(Us.$$scope={dirty:i,ctx:e}),As.$set(Us);const Oi={};i&2&&(Oi.$$scope={dirty:i,ctx:e}),Os.$set(Oi);const Zs={};i&2&&(Zs.$$scope={dirty:i,ctx:e}),Ks.$set(Zs);const Ki={};i&2&&(Ki.$$scope={dirty:i,ctx:e}),en.$set(Ki);const Cs={};i&2&&(Cs.$$scope={dirty:i,ctx:e}),tn.$set(Cs);const ed={};i&2&&(ed.$$scope={dirty:i,ctx:e}),sn.$set(ed);const Nt={};i&2&&(Nt.$$scope={dirty:i,ctx:e}),nn.$set(Nt);const yf={};i&2&&(yf.$$scope={dirty:i,ctx:e}),rn.$set(yf);const fe={};i&2&&(fe.$$scope={dirty:i,ctx:e}),an.$set(fe);const Tf={};i&2&&(Tf.$$scope={dirty:i,ctx:e}),on.$set(Tf);const Ne={};i&2&&(Ne.$$scope={dirty:i,ctx:e}),ln.$set(Ne);const Mf={};i&2&&(Mf.$$scope={dirty:i,ctx:e}),cn.$set(Mf);const He={};i&2&&(He.$$scope={dirty:i,ctx:e}),dn.$set(He);const vf={};i&2&&(vf.$$scope={dirty:i,ctx:e}),pn.$set(vf);const Ht={};i&2&&(Ht.$$scope={dirty:i,ctx:e}),mn.$set(Ht);const wf={};i&2&&(wf.$$scope={dirty:i,ctx:e}),gn.$set(wf);const Et={};i&2&&(Et.$$scope={dirty:i,ctx:e}),hn.$set(Et);const kf={};i&2&&(kf.$$scope={dirty:i,ctx:e}),un.$set(kf);const qt={};i&2&&(qt.$$scope={dirty:i,ctx:e}),fn.$set(qt);const $f={};i&2&&($f.$$scope={dirty:i,ctx:e}),_n.$set($f);const Dt={};i&2&&(Dt.$$scope={dirty:i,ctx:e}),vn.$set(Dt);const jf={};i&2&&(jf.$$scope={dirty:i,ctx:e}),wn.$set(jf);const Qt={};i&2&&(Qt.$$scope={dirty:i,ctx:e}),Cn.$set(Qt);const xf={};i&2&&(xf.$$scope={dirty:i,ctx:e}),Wn.$set(xf);const _e={};i&2&&(_e.$$scope={dirty:i,ctx:e}),Vn.$set(_e);const Jf={};i&2&&(Jf.$$scope={dirty:i,ctx:e}),Gn.$set(Jf);const Yt={};i&2&&(Yt.$$scope={dirty:i,ctx:e}),Sn.$set(Yt);const Uf={};i&2&&(Uf.$$scope={dirty:i,ctx:e}),Yn.$set(Uf);const Pt={};i&2&&(Pt.$$scope={dirty:i,ctx:e}),Pn.$set(Pt);const Zf={};i&2&&(Zf.$$scope={dirty:i,ctx:e}),An.$set(Zf);const Ws={};i&2&&(Ws.$$scope={dirty:i,ctx:e}),rr.$set(Ws);const Cf={};i&2&&(Cf.$$scope={dirty:i,ctx:e}),cr.$set(Cf);const Bs={};i&2&&(Bs.$$scope={dirty:i,ctx:e}),mr.$set(Bs);const Wf={};i&2&&(Wf.$$scope={dirty:i,ctx:e}),hr.$set(Wf);const At={};i&2&&(At.$$scope={dirty:i,ctx:e}),ur.$set(At);const Bf={};i&2&&(Bf.$$scope={dirty:i,ctx:e}),Tr.$set(Bf);const Ot={};i&2&&(Ot.$$scope={dirty:i,ctx:e}),vr.$set(Ot);const If={};i&2&&(If.$$scope={dirty:i,ctx:e}),$r.$set(If);const be={};i&2&&(be.$$scope={dirty:i,ctx:e}),jr.$set(be)},i(e){_y||(u(w.$$.fragment,e),u(Gr.$$.fragment,e),u(Rr.$$.fragment,e),u(qr.$$.fragment,e),u(Pr.$$.fragment,e),u(Ar.$$.fragment,e),u(Or.$$.fragment,e),u(Kr.$$.fragment,e),u(ea.$$.fragment,e),u(ta.$$.fragment,e),u(sa.$$.fragment,e),u(na.$$.fragment,e),u(ra.$$.fragment,e),u(aa.$$.fragment,e),u(oa.$$.fragment,e),u(la.$$.fragment,e),u(ca.$$.fragment,e),u(ia.$$.fragment,e),u(da.$$.fragment,e),u(pa.$$.fragment,e),u(ma.$$.fragment,e),u(ga.$$.fragment,e),u(ha.$$.fragment,e),u(ua.$$.fragment,e),u(fa.$$.fragment,e),u(_a.$$.fragment,e),u(ba.$$.fragment,e),u(ya.$$.fragment,e),u(Ma.$$.fragment,e),u(va.$$.fragment,e),u(Gs.$$.fragment,e),u(wa.$$.fragment,e),u(ka.$$.fragment,e),u(Fs.$$.fragment,e),u(Xs.$$.fragment,e),u($a.$$.fragment,e),u(ja.$$.fragment,e),u(Rs.$$.fragment,e),u(xa.$$.fragment,e),u(Ja.$$.fragment,e),u(Ls.$$.fragment,e),u(Ua.$$.fragment,e),u(Za.$$.fragment,e),u(Ss.$$.fragment,e),u(Ca.$$.fragment,e),u(Wa.$$.fragment,e),u(Ns.$$.fragment,e),u(Ba.$$.fragment,e),u(Ia.$$.fragment,e),u(Hs.$$.fragment,e),u(za.$$.fragment,e),u(Va.$$.fragment,e),u(Es.$$.fragment,e),u(Ga.$$.fragment,e),u(Fa.$$.fragment,e),u(qs.$$.fragment,e),u(Xa.$$.fragment,e),u(Ra.$$.fragment,e),u(Ds.$$.fragment,e),u(La.$$.fragment,e),u(Sa.$$.fragment,e),u(Na.$$.fragment,e),u(Ha.$$.fragment,e),u(Qs.$$.fragment,e),u(Ea.$$.fragment,e),u(qa.$$.fragment,e),u(Da.$$.fragment,e),u(Qa.$$.fragment,e),u(Ya.$$.fragment,e),u(Pa.$$.fragment,e),u(Ys.$$.fragment,e),u(Aa.$$.fragment,e),u(Oa.$$.fragment,e),u(Ps.$$.fragment,e),u(Ka.$$.fragment,e),u(eo.$$.fragment,e),u(As.$$.fragment,e),u(to.$$.fragment,e),u(so.$$.fragment,e),u(Os.$$.fragment,e),u(Ks.$$.fragment,e),u(no.$$.fragment,e),u(ro.$$.fragment,e),u(en.$$.fragment,e),u(tn.$$.fragment,e),u(ao.$$.fragment,e),u(oo.$$.fragment,e),u(sn.$$.fragment,e),u(lo.$$.fragment,e),u(co.$$.fragment,e),u(nn.$$.fragment,e),u(io.$$.fragment,e),u(po.$$.fragment,e),u(rn.$$.fragment,e),u(an.$$.fragment,e),u(mo.$$.fragment,e),u(go.$$.fragment,e),u(on.$$.fragment,e),u(ho.$$.fragment,e),u(uo.$$.fragment,e),u(ln.$$.fragment,e),u(fo.$$.fragment,e),u(_o.$$.fragment,e),u(cn.$$.fragment,e),u(bo.$$.fragment,e),u(yo.$$.fragment,e),u(dn.$$.fragment,e),u(pn.$$.fragment,e),u(To.$$.fragment,e),u(Mo.$$.fragment,e),u(mn.$$.fragment,e),u(vo.$$.fragment,e),u(wo.$$.fragment,e),u(gn.$$.fragment,e),u(ko.$$.fragment,e),u($o.$$.fragment,e),u(hn.$$.fragment,e),u(jo.$$.fragment,e),u(xo.$$.fragment,e),u(un.$$.fragment,e),u(Jo.$$.fragment,e),u(Uo.$$.fragment,e),u(fn.$$.fragment,e),u(Zo.$$.fragment,e),u(Co.$$.fragment,e),u(_n.$$.fragment,e),u(Wo.$$.fragment,e),u(Bo.$$.fragment,e),u(Io.$$.fragment,e),u(zo.$$.fragment,e),u(Vo.$$.fragment,e),u(Go.$$.fragment,e),u(Fo.$$.fragment,e),u(Xo.$$.fragment,e),u(Ro.$$.fragment,e),u(Lo.$$.fragment,e),u(So.$$.fragment,e),u(No.$$.fragment,e),u(Ho.$$.fragment,e),u(Eo.$$.fragment,e),u(qo.$$.fragment,e),u(Do.$$.fragment,e),u(Qo.$$.fragment,e),u(Yo.$$.fragment,e),u(Po.$$.fragment,e),u(Ao.$$.fragment,e),u(Oo.$$.fragment,e),u(Ko.$$.fragment,e),u(el.$$.fragment,e),u(tl.$$.fragment,e),u(sl.$$.fragment,e),u(nl.$$.fragment,e),u(rl.$$.fragment,e),u(al.$$.fragment,e),u(ol.$$.fragment,e),u(ll.$$.fragment,e),u(cl.$$.fragment,e),u(il.$$.fragment,e),u(dl.$$.fragment,e),u(pl.$$.fragment,e),u(ml.$$.fragment,e),u(gl.$$.fragment,e),u(hl.$$.fragment,e),u(ul.$$.fragment,e),u(fl.$$.fragment,e),u(_l.$$.fragment,e),u(bl.$$.fragment,e),u(yl.$$.fragment,e),u(Tl.$$.fragment,e),u(Ml.$$.fragment,e),u(vl.$$.fragment,e),u(wl.$$.fragment,e),u(kl.$$.fragment,e),u($l.$$.fragment,e),u(jl.$$.fragment,e),u(xl.$$.fragment,e),u(Jl.$$.fragment,e),u(Ul.$$.fragment,e),u(Zl.$$.fragment,e),u(Cl.$$.fragment,e),u(Wl.$$.fragment,e),u(Bl.$$.fragment,e),u(Il.$$.fragment,e),u(zl.$$.fragment,e),u(Vl.$$.fragment,e),u(Gl.$$.fragment,e),u(Xl.$$.fragment,e),u(Rl.$$.fragment,e),u(Ll.$$.fragment,e),u(Sl.$$.fragment,e),u(Nl.$$.fragment,e),u(Hl.$$.fragment,e),u(El.$$.fragment,e),u(ql.$$.fragment,e),u(Dl.$$.fragment,e),u(vn.$$.fragment,e),u(Ql.$$.fragment,e),u(Yl.$$.fragment,e),u(Pl.$$.fragment,e),u(Al.$$.fragment,e),u(Kl.$$.fragment,e),u(wn.$$.fragment,e),u(ec.$$.fragment,e),u(tc.$$.fragment,e),u(sc.$$.fragment,e),u(nc.$$.fragment,e),u(rc.$$.fragment,e),u(ac.$$.fragment,e),u(oc.$$.fragment,e),u(lc.$$.fragment,e),u(cc.$$.fragment,e),u(ic.$$.fragment,e),u(dc.$$.fragment,e),u(pc.$$.fragment,e),u(mc.$$.fragment,e),u(gc.$$.fragment,e),u(hc.$$.fragment,e),u(uc.$$.fragment,e),u(fc.$$.fragment,e),u(_c.$$.fragment,e),u(bc.$$.fragment,e),u(yc.$$.fragment,e),u(Tc.$$.fragment,e),u(Mc.$$.fragment,e),u(vc.$$.fragment,e),u(wc.$$.fragment,e),u(Cn.$$.fragment,e),u(Wn.$$.fragment,e),u(kc.$$.fragment,e),u($c.$$.fragment,e),u(jc.$$.fragment,e),u(xc.$$.fragment,e),u(Vn.$$.fragment,e),u(Gn.$$.fragment,e),u(Jc.$$.fragment,e),u(Uc.$$.fragment,e),u(Zc.$$.fragment,e),u(Cc.$$.fragment,e),u(Wc.$$.fragment,e),u(Bc.$$.fragment,e),u(Ic.$$.fragment,e),u(zc.$$.fragment,e),u(Vc.$$.fragment,e),u(Sn.$$.fragment,e),u(Gc.$$.fragment,e),u(Fc.$$.fragment,e),u(Xc.$$.fragment,e),u(Rc.$$.fragment,e),u(Lc.$$.fragment,e),u(Sc.$$.fragment,e),u(Nc.$$.fragment,e),u(Hc.$$.fragment,e),u(Ec.$$.fragment,e),u(Yn.$$.fragment,e),u(qc.$$.fragment,e),u(Pn.$$.fragment,e),u(Dc.$$.fragment,e),u(An.$$.fragment,e),u(Qc.$$.fragment,e),u(Yc.$$.fragment,e),u(Pc.$$.fragment,e),u(Ac.$$.fragment,e),u(Oc.$$.fragment,e),u(Kc.$$.fragment,e),u(ei.$$.fragment,e),u(ti.$$.fragment,e),u(rr.$$.fragment,e),u(si.$$.fragment,e),u(ni.$$.fragment,e),u(ri.$$.fragment,e),u(ai.$$.fragment,e),u(cr.$$.fragment,e),u(oi.$$.fragment,e),u(li.$$.fragment,e),u(ci.$$.fragment,e),u(ii.$$.fragment,e),u(mr.$$.fragment,e),u(di.$$.fragment,e),u(pi.$$.fragment,e),u(mi.$$.fragment,e),u(gi.$$.fragment,e),u(hr.$$.fragment,e),u(hi.$$.fragment,e),u(ui.$$.fragment,e),u(fi.$$.fragment,e),u(ur.$$.fragment,e),u(_i.$$.fragment,e),u(bi.$$.fragment,e),u(yi.$$.fragment,e),u(Ti.$$.fragment,e),u(Mi.$$.fragment,e),u(vi.$$.fragment,e),u(Tr.$$.fragment,e),u(wi.$$.fragment,e),u(ki.$$.fragment,e),u($i.$$.fragment,e),u(ji.$$.fragment,e),u(xi.$$.fragment,e),u(Ji.$$.fragment,e),u(Ui.$$.fragment,e),u(vr.$$.fragment,e),u(Zi.$$.fragment,e),u(Ci.$$.fragment,e),u(Wi.$$.fragment,e),u(Bi.$$.fragment,e),u(Ii.$$.fragment,e),u($r.$$.fragment,e),u(zi.$$.fragment,e),u(jr.$$.fragment,e),u(Vi.$$.fragment,e),u(Gi.$$.fragment,e),_y=!0)},o(e){f(w.$$.fragment,e),f(Gr.$$.fragment,e),f(Rr.$$.fragment,e),f(qr.$$.fragment,e),f(Pr.$$.fragment,e),f(Ar.$$.fragment,e),f(Or.$$.fragment,e),f(Kr.$$.fragment,e),f(ea.$$.fragment,e),f(ta.$$.fragment,e),f(sa.$$.fragment,e),f(na.$$.fragment,e),f(ra.$$.fragment,e),f(aa.$$.fragment,e),f(oa.$$.fragment,e),f(la.$$.fragment,e),f(ca.$$.fragment,e),f(ia.$$.fragment,e),f(da.$$.fragment,e),f(pa.$$.fragment,e),f(ma.$$.fragment,e),f(ga.$$.fragment,e),f(ha.$$.fragment,e),f(ua.$$.fragment,e),f(fa.$$.fragment,e),f(_a.$$.fragment,e),f(ba.$$.fragment,e),f(ya.$$.fragment,e),f(Ma.$$.fragment,e),f(va.$$.fragment,e),f(Gs.$$.fragment,e),f(wa.$$.fragment,e),f(ka.$$.fragment,e),f(Fs.$$.fragment,e),f(Xs.$$.fragment,e),f($a.$$.fragment,e),f(ja.$$.fragment,e),f(Rs.$$.fragment,e),f(xa.$$.fragment,e),f(Ja.$$.fragment,e),f(Ls.$$.fragment,e),f(Ua.$$.fragment,e),f(Za.$$.fragment,e),f(Ss.$$.fragment,e),f(Ca.$$.fragment,e),f(Wa.$$.fragment,e),f(Ns.$$.fragment,e),f(Ba.$$.fragment,e),f(Ia.$$.fragment,e),f(Hs.$$.fragment,e),f(za.$$.fragment,e),f(Va.$$.fragment,e),f(Es.$$.fragment,e),f(Ga.$$.fragment,e),f(Fa.$$.fragment,e),f(qs.$$.fragment,e),f(Xa.$$.fragment,e),f(Ra.$$.fragment,e),f(Ds.$$.fragment,e),f(La.$$.fragment,e),f(Sa.$$.fragment,e),f(Na.$$.fragment,e),f(Ha.$$.fragment,e),f(Qs.$$.fragment,e),f(Ea.$$.fragment,e),f(qa.$$.fragment,e),f(Da.$$.fragment,e),f(Qa.$$.fragment,e),f(Ya.$$.fragment,e),f(Pa.$$.fragment,e),f(Ys.$$.fragment,e),f(Aa.$$.fragment,e),f(Oa.$$.fragment,e),f(Ps.$$.fragment,e),f(Ka.$$.fragment,e),f(eo.$$.fragment,e),f(As.$$.fragment,e),f(to.$$.fragment,e),f(so.$$.fragment,e),f(Os.$$.fragment,e),f(Ks.$$.fragment,e),f(no.$$.fragment,e),f(ro.$$.fragment,e),f(en.$$.fragment,e),f(tn.$$.fragment,e),f(ao.$$.fragment,e),f(oo.$$.fragment,e),f(sn.$$.fragment,e),f(lo.$$.fragment,e),f(co.$$.fragment,e),f(nn.$$.fragment,e),f(io.$$.fragment,e),f(po.$$.fragment,e),f(rn.$$.fragment,e),f(an.$$.fragment,e),f(mo.$$.fragment,e),f(go.$$.fragment,e),f(on.$$.fragment,e),f(ho.$$.fragment,e),f(uo.$$.fragment,e),f(ln.$$.fragment,e),f(fo.$$.fragment,e),f(_o.$$.fragment,e),f(cn.$$.fragment,e),f(bo.$$.fragment,e),f(yo.$$.fragment,e),f(dn.$$.fragment,e),f(pn.$$.fragment,e),f(To.$$.fragment,e),f(Mo.$$.fragment,e),f(mn.$$.fragment,e),f(vo.$$.fragment,e),f(wo.$$.fragment,e),f(gn.$$.fragment,e),f(ko.$$.fragment,e),f($o.$$.fragment,e),f(hn.$$.fragment,e),f(jo.$$.fragment,e),f(xo.$$.fragment,e),f(un.$$.fragment,e),f(Jo.$$.fragment,e),f(Uo.$$.fragment,e),f(fn.$$.fragment,e),f(Zo.$$.fragment,e),f(Co.$$.fragment,e),f(_n.$$.fragment,e),f(Wo.$$.fragment,e),f(Bo.$$.fragment,e),f(Io.$$.fragment,e),f(zo.$$.fragment,e),f(Vo.$$.fragment,e),f(Go.$$.fragment,e),f(Fo.$$.fragment,e),f(Xo.$$.fragment,e),f(Ro.$$.fragment,e),f(Lo.$$.fragment,e),f(So.$$.fragment,e),f(No.$$.fragment,e),f(Ho.$$.fragment,e),f(Eo.$$.fragment,e),f(qo.$$.fragment,e),f(Do.$$.fragment,e),f(Qo.$$.fragment,e),f(Yo.$$.fragment,e),f(Po.$$.fragment,e),f(Ao.$$.fragment,e),f(Oo.$$.fragment,e),f(Ko.$$.fragment,e),f(el.$$.fragment,e),f(tl.$$.fragment,e),f(sl.$$.fragment,e),f(nl.$$.fragment,e),f(rl.$$.fragment,e),f(al.$$.fragment,e),f(ol.$$.fragment,e),f(ll.$$.fragment,e),f(cl.$$.fragment,e),f(il.$$.fragment,e),f(dl.$$.fragment,e),f(pl.$$.fragment,e),f(ml.$$.fragment,e),f(gl.$$.fragment,e),f(hl.$$.fragment,e),f(ul.$$.fragment,e),f(fl.$$.fragment,e),f(_l.$$.fragment,e),f(bl.$$.fragment,e),f(yl.$$.fragment,e),f(Tl.$$.fragment,e),f(Ml.$$.fragment,e),f(vl.$$.fragment,e),f(wl.$$.fragment,e),f(kl.$$.fragment,e),f($l.$$.fragment,e),f(jl.$$.fragment,e),f(xl.$$.fragment,e),f(Jl.$$.fragment,e),f(Ul.$$.fragment,e),f(Zl.$$.fragment,e),f(Cl.$$.fragment,e),f(Wl.$$.fragment,e),f(Bl.$$.fragment,e),f(Il.$$.fragment,e),f(zl.$$.fragment,e),f(Vl.$$.fragment,e),f(Gl.$$.fragment,e),f(Xl.$$.fragment,e),f(Rl.$$.fragment,e),f(Ll.$$.fragment,e),f(Sl.$$.fragment,e),f(Nl.$$.fragment,e),f(Hl.$$.fragment,e),f(El.$$.fragment,e),f(ql.$$.fragment,e),f(Dl.$$.fragment,e),f(vn.$$.fragment,e),f(Ql.$$.fragment,e),f(Yl.$$.fragment,e),f(Pl.$$.fragment,e),f(Al.$$.fragment,e),f(Kl.$$.fragment,e),f(wn.$$.fragment,e),f(ec.$$.fragment,e),f(tc.$$.fragment,e),f(sc.$$.fragment,e),f(nc.$$.fragment,e),f(rc.$$.fragment,e),f(ac.$$.fragment,e),f(oc.$$.fragment,e),f(lc.$$.fragment,e),f(cc.$$.fragment,e),f(ic.$$.fragment,e),f(dc.$$.fragment,e),f(pc.$$.fragment,e),f(mc.$$.fragment,e),f(gc.$$.fragment,e),f(hc.$$.fragment,e),f(uc.$$.fragment,e),f(fc.$$.fragment,e),f(_c.$$.fragment,e),f(bc.$$.fragment,e),f(yc.$$.fragment,e),f(Tc.$$.fragment,e),f(Mc.$$.fragment,e),f(vc.$$.fragment,e),f(wc.$$.fragment,e),f(Cn.$$.fragment,e),f(Wn.$$.fragment,e),f(kc.$$.fragment,e),f($c.$$.fragment,e),f(jc.$$.fragment,e),f(xc.$$.fragment,e),f(Vn.$$.fragment,e),f(Gn.$$.fragment,e),f(Jc.$$.fragment,e),f(Uc.$$.fragment,e),f(Zc.$$.fragment,e),f(Cc.$$.fragment,e),f(Wc.$$.fragment,e),f(Bc.$$.fragment,e),f(Ic.$$.fragment,e),f(zc.$$.fragment,e),f(Vc.$$.fragment,e),f(Sn.$$.fragment,e),f(Gc.$$.fragment,e),f(Fc.$$.fragment,e),f(Xc.$$.fragment,e),f(Rc.$$.fragment,e),f(Lc.$$.fragment,e),f(Sc.$$.fragment,e),f(Nc.$$.fragment,e),f(Hc.$$.fragment,e),f(Ec.$$.fragment,e),f(Yn.$$.fragment,e),f(qc.$$.fragment,e),f(Pn.$$.fragment,e),f(Dc.$$.fragment,e),f(An.$$.fragment,e),f(Qc.$$.fragment,e),f(Yc.$$.fragment,e),f(Pc.$$.fragment,e),f(Ac.$$.fragment,e),f(Oc.$$.fragment,e),f(Kc.$$.fragment,e),f(ei.$$.fragment,e),f(ti.$$.fragment,e),f(rr.$$.fragment,e),f(si.$$.fragment,e),f(ni.$$.fragment,e),f(ri.$$.fragment,e),f(ai.$$.fragment,e),f(cr.$$.fragment,e),f(oi.$$.fragment,e),f(li.$$.fragment,e),f(ci.$$.fragment,e),f(ii.$$.fragment,e),f(mr.$$.fragment,e),f(di.$$.fragment,e),f(pi.$$.fragment,e),f(mi.$$.fragment,e),f(gi.$$.fragment,e),f(hr.$$.fragment,e),f(hi.$$.fragment,e),f(ui.$$.fragment,e),f(fi.$$.fragment,e),f(ur.$$.fragment,e),f(_i.$$.fragment,e),f(bi.$$.fragment,e),f(yi.$$.fragment,e),f(Ti.$$.fragment,e),f(Mi.$$.fragment,e),f(vi.$$.fragment,e),f(Tr.$$.fragment,e),f(wi.$$.fragment,e),f(ki.$$.fragment,e),f($i.$$.fragment,e),f(ji.$$.fragment,e),f(xi.$$.fragment,e),f(Ji.$$.fragment,e),f(Ui.$$.fragment,e),f(vr.$$.fragment,e),f(Zi.$$.fragment,e),f(Ci.$$.fragment,e),f(Wi.$$.fragment,e),f(Bi.$$.fragment,e),f(Ii.$$.fragment,e),f($r.$$.fragment,e),f(zi.$$.fragment,e),f(jr.$$.fragment,e),f(Vi.$$.fragment,e),f(Gi.$$.fragment,e),_y=!1},d(e){e&&(n($),n(y),n(d),n(s),n(k),n(zf),n(Vf),n(Fr),n(Gf),n(Xr),n(Ff),n(Xf),n(Lr),n(Rf),n(Sr),n(Lf),n(Nr),n(Sf),n(Hr),n(Nf),n(Er),n(Hf),n(Ef),n(Dr),n(qf),n(Qr),n(Df),n(Yr),n(Qf),n(Yf),n(ms),n(Pf),n(gs),n(Af),n(hs),n(Of),n(us),n(Kf),n(e_),n(fs),n(t_),n(_s),n(s_),n(bs),n(n_),n(ys),n(r_),n(Ts),n(a_),n(Ms),n(o_),n(vs),n(l_),n(ws),n(c_),n(ks),n(i_),n($s),n(d_),n(p_),n(et),n(m_),n(tt),n(g_),n(st),n(h_),n(u_),n(Ta),n(f_),n(__),n(ke),n(b_),n(S),n(y_),n(se),n(T_),n(ne),n(M_),n($e),n(v_),n(je),n(w_),n(xe),n(k_),n(Je),n($_),n(Ue),n(j_),n(N),n(x_),n(Ze),n(J_),n(Ce),n(U_),n(nt),n(Z_),n(rt),n(C_),n(We),n(W_),n(Be),n(B_),n(H),n(I_),n(re),n(z_),n(ae),n(V_),n(Ie),n(G_),n(oe),n(F_),n(le),n(X_),n(ze),n(R_),n(Ve),n(L_),n(G),n(S_),n(ce),n(N_),n(Ge),n(H_),n(Fe),n(E_),n(ie),n(q_),n(de),n(D_),n(pe),n(Q_),n(E),n(Y_),n(P_),n(at),n(A_),n(ot),n(O_),n(lt),n(K_),n(ct),n(eb),n(it),n(tb),n(dt),n(sb),n(pt),n(nb),n(mt),n(rb),n(gt),n(ab),n(ht),n(ob),n(ut),n(lb),n(ft),n(cb),n(_t),n(ib),n(bt),n(db),n(yt),n(pb),n(mb),n(Tt),n(gb),n(Mt),n(hb),n(vt),n(ub),n(wt),n(fb),n(kt),n(_b),n($t),n(bb),n(jt),n(yb),n(xt),n(Tb),n(Jt),n(Mb),n(Ut),n(vb),n(Zt),n(wb),n(Ct),n(kb),n(Wt),n($b),n(jb),n(Fl),n(xb),n(Xe),n(Jb),n(js),n(Ub),n(Bt),n(Zb),n(It),n(Cb),n(J),n(Wb),n(zt),n(Bb),n(Ib),n(Ol),n(zb),n(W),n(Vb),n(xs),n(Gb),n(Js),n(Fb),n(Re),n(Xb),n(Rb),n(Le),n(Lb),n(q),n(Sb),n(Se),n(Nb),n(Hb),n(F),n(Eb),n(me),n(qb),n(Db),n(Vt),n(Qb),n(Gt),n(Yb),n(Ft),n(Pb),n(I),n(Ab),n(D),n(Ob),n(Xt),n(Kb),n(Rt),n(ey),n(X),n(ty),n(Q),n(sy),n(Y),n(ny),n(P),n(ry),n(A),n(ay),n(z),n(oy),n(V),n(ly),n(O),n(cy),n(iy),n(ge),n(dy),n(he),n(py),n(Lt),n(my),n(R),n(gy),n(St),n(hy),n(ue),n(uy),n(fy),n(bf)),n(c),_(w,e),_(Gr,e),_(Rr,e),_(qr,e),_(Pr,e),_(Ar),_(Or),_(Kr),_(ea),_(ta,e),_(sa),_(na),_(ra),_(aa),_(oa),_(la),_(ca),_(ia),_(da),_(pa),_(ma,e),_(ga),_(ha),_(ua),_(fa),_(_a),_(ba),_(ya,e),_(Ma,e),_(va),_(Gs),_(wa),_(ka),_(Fs),_(Xs),_($a),_(ja),_(Rs),_(xa),_(Ja),_(Ls),_(Ua),_(Za),_(Ss),_(Ca),_(Wa),_(Ns),_(Ba),_(Ia),_(Hs),_(za),_(Va),_(Es),_(Ga),_(Fa),_(qs),_(Xa),_(Ra),_(Ds),_(La),_(Sa),_(Na),_(Ha),_(Qs),_(Ea),_(qa),_(Da),_(Qa),_(Ya),_(Pa),_(Ys),_(Aa),_(Oa),_(Ps),_(Ka),_(eo),_(As),_(to),_(so),_(Os),_(Ks),_(no),_(ro),_(en),_(tn),_(ao),_(oo),_(sn),_(lo),_(co),_(nn),_(io),_(po),_(rn),_(an),_(mo),_(go),_(on),_(ho),_(uo),_(ln),_(fo),_(_o),_(cn),_(bo),_(yo),_(dn),_(pn),_(To),_(Mo),_(mn),_(vo),_(wo),_(gn),_(ko),_($o),_(hn),_(jo),_(xo),_(un),_(Jo),_(Uo),_(fn),_(Zo),_(Co),_(_n),_(Wo),_(Bo,e),_(Io),_(zo),_(Vo),_(Go),_(Fo),_(Xo),_(Ro),_(Lo),_(So),_(No),_(Ho),_(Eo),_(qo),_(Do),_(Qo),_(Yo),_(Po),_(Ao),_(Oo),_(Ko),_(el),_(tl),_(sl),_(nl),_(rl),_(al),_(ol),_(ll),_(cl),_(il),_(dl,e),_(pl),_(ml),_(gl),_(hl),_(ul),_(fl),_(_l),_(bl),_(yl),_(Tl),_(Ml),_(vl),_(wl),_(kl),_($l),_(jl),_(xl),_(Jl),_(Ul),_(Zl),_(Cl),_(Wl),_(Bl),_(Il),_(zl),_(Vl),_(Gl,e),_(Xl),_(Rl),_(Ll),_(Sl),_(Nl),_(Hl),_(El),_(ql),_(Dl),_(vn),_(Ql),_(Yl),_(Pl),_(Al,e),_(Kl),_(wn),_(ec),_(tc),_(sc),_(nc),_(rc),_(ac),_(oc),_(lc),_(cc),_(ic),_(dc),_(pc),_(mc,e),_(gc),_(hc),_(uc),_(fc),_(_c),_(bc),_(yc),_(Tc),_(Mc),_(vc,e),_(wc),_(Cn),_(Wn),_(kc),_($c),_(jc),_(xc),_(Vn),_(Gn),_(Jc),_(Uc,e),_(Zc),_(Cc),_(Wc),_(Bc),_(Ic),_(zc),_(Vc),_(Sn),_(Gc),_(Fc),_(Xc),_(Rc),_(Lc),_(Sc),_(Nc),_(Hc),_(Ec),_(Yn),_(qc),_(Pn),_(Dc),_(An),_(Qc),_(Yc),_(Pc),_(Ac),_(Oc),_(Kc),_(ei),_(ti),_(rr),_(si),_(ni),_(ri),_(ai),_(cr),_(oi),_(li),_(ci),_(ii),_(mr),_(di),_(pi),_(mi),_(gi),_(hr),_(hi),_(ui),_(fi),_(ur),_(_i),_(bi),_(yi),_(Ti),_(Mi),_(vi),_(Tr),_(wi),_(ki),_($i),_(ji,e),_(xi),_(Ji),_(Ui),_(vr),_(Zi),_(Ci),_(Wi),_(Bi),_(Ii),_($r),_(zi),_(jr),_(Vi),_(Gi,e)}}}const _Z='{"title":"Utilities for Generation","local":"utilities-for-generation","sections":[{"title":"Generate Outputs","local":"generate-outputs","sections":[{"title":"PyTorch","local":"transformers.generation.GenerateDecoderOnlyOutput","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.generation.TFGreedySearchEncoderDecoderOutput","sections":[],"depth":3},{"title":"FLAX","local":"transformers.generation.FlaxSampleOutput","sections":[],"depth":3}],"depth":2},{"title":"LogitsProcessor","local":"logitsprocessor","sections":[{"title":"PyTorch","local":"transformers.AlternatingCodebooksLogitsProcessor","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.TFForcedBOSTokenLogitsProcessor","sections":[],"depth":3},{"title":"FLAX","local":"transformers.FlaxForcedBOSTokenLogitsProcessor","sections":[],"depth":3}],"depth":2},{"title":"StoppingCriteria","local":"transformers.StoppingCriteria","sections":[],"depth":2},{"title":"Constraints","local":"transformers.Constraint","sections":[],"depth":2},{"title":"BeamSearch","local":"transformers.BeamScorer","sections":[],"depth":2},{"title":"Streamers","local":"transformers.TextStreamer","sections":[],"depth":2},{"title":"Caches","local":"transformers.Cache","sections":[],"depth":2},{"title":"Watermark Utils","local":"transformers.WatermarkingConfig","sections":[],"depth":2}],"depth":1}';function bZ(j){return m3(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jZ extends g3{constructor(c){super(),h3(this,c,bZ,fZ,p3,{})}}export{jZ as component};
