import{s as et,o as st,n as tt}from"../chunks/scheduler.aec39e6a.js";import{S as nt,i as at,e as i,s as a,c as r,h as lt,a as o,d as t,b as l,f as Ks,g as M,j as p,k as Os,l as it,m as n,n as d,t as c,o as m,p as u}from"../chunks/index.4ee0a2d0.js";import{T as ot}from"../chunks/Tip.e2132029.js";import{C as pt,H as Te,E as rt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8184f5a3.js";import{C as y}from"../chunks/CodeBlock.db6247f1.js";function Mt(we){let h,w='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/hub-docs/tree/main/notebooks/sagemaker-sdk/fine-tune-embedding-models/sagemaker-notebook.ipynb" rel="nofollow">here</a>!';return{c(){h=i("p"),h.innerHTML=w},l(J){h=o(J,"P",{"data-svelte-h":!0}),p(h)!=="svelte-as3ump"&&(h.innerHTML=w)},m(J,ye){n(J,h,ye)},p:tt,d(J){J&&t(h)}}}function dt(we){let h,w,J,ye,j,je,g,ge,U,js='Embedding models are crucial for successful RAG applications, but they’re often trained on general knowledge, which limits their effectiveness for company or domain specific adoption. Customizing embedding for your domain specific data can significantly boost the retrieval performance of your RAG Application. With the new release of <a href="https://huggingface.co/blog/train-sentence-transformers" rel="nofollow">Sentence Transformers 3</a> and the <a href="https://huggingface.co/blog/sagemaker-huggingface-embedding" rel="nofollow">Hugging Face Embedding Container</a>, it’s easier than ever to fine-tune and deploy embedding models.',Ue,b,gs='In this example, we’ll show you how to fine-tune and deploy a custom embedding model on Amazon SageMaker using the new Hugging Face Embedding Container. We’ll use the <a href="https://huggingface.co/blog/train-sentence-transformers" rel="nofollow">Sentence Transformers 3</a> library to fine-tune a model on a custom dataset and deploy it on Amazon SageMaker for inference. We will fine-tune <a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow">BAAI/bge-base-en-v1.5</a> for financial RAG applications using a synthetic dataset from the <a href="https://stocklight.com/stocks/us/nasdaq-nvda/nvidia/annual-reports/nasdaq-nvda-2023-10K-23668751.pdf" rel="nofollow">2023_10 NVIDIA SEC Filing</a>.',be,f,Us='<li><a href="#2-setup-development-environment">Setup development environment</a></li> <li><a href="#3-create-and-prepare-the-dataset">Create and prepare the dataset</a></li> <li><a href="#3-fine-tune-embedding-model-on-amazon-sagemaker">Fine-tune Embedding model on Amazon SageMaker</a></li> <li><a href="#4-deploy--test-fine-tuned-embedding-model-on-amazon-sagemaker">Deploy &amp; Test fine-tuned Embedding Model on Amazon SageMaker</a></li>',fe,I,bs="<strong>What is new with Sentence Transformers 3?</strong>",Ie,Z,fs="Sentence Transformers v3 introduces a new trainer that makes it easier to fine-tune and train embedding models. This update includes enhanced components like diverse datasets, updated loss functions, and a streamlined training process, improving the efficiency and flexibility of model development.",Ze,C,Is="<strong>What is the Hugging Face Embedding Container?</strong>",Ce,W,Zs='The Hugging Face Embedding Container is a new purpose-built Inference Container to easily deploy Embedding Models in a secure and managed environment. The DLC is powered by <a href="https://github.com/huggingface/text-embeddings-inference" rel="nofollow">Text Embedding Inference (TEI)</a> a blazing fast and memory efficient solution for deploying and serving Embedding Models. TEI enables high-performance extraction for the most popular models, including FlagEmbedding, Ember, GTE and E5. TEI implements many features such as:',We,G,Cs="<em>Note: This blog was created and validated on <code>ml.g5.xlarge</code> for training and <code>ml.c6i.2xlarge</code> for inference instance.</em>",Ge,B,Be,k,Ws="Our first step is to install Hugging Face Libraries we need on the client to correctly prepare our dataset and start our training/evaluations jobs.",ke,v,ve,R,Gs='If you are going to use Sagemaker in a local environment. You need access to an IAM Role with the required permissions for Sagemaker. You can find <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">here</a> more about it.',Re,X,Xe,z,ze,H,Bs="An embedding dataset typically consists of text pairs (question, answer/context) or triplets that represent relationships or similarities between sentences. The dataset format you choose or have available will also impact the loss function you can use. Common formats for embedding datasets:",He,V,ks="<li><strong>Positive Pair</strong>: Text Pairs of related sentences (query, context | query, answer), suitable for tasks like similarity or semantic search, example datasets: <code>sentence-transformers/sentence-compression</code>, <code>sentence-transformers/natural-questions</code>.</li> <li><strong>Triplets</strong>: Text triplets consisting of (anchor, positive, negative), example datasets <code>sentence-transformers/quora-duplicates</code>, <code>nirantk/triplets</code>.</li> <li><strong>Pair with Similarity Score</strong>: Sentence pairs with a similarity score indicating how related they are, example datasets: <code>sentence-transformers/stsb</code>, <code>PhilipMay/stsb_multi_mt</code></li>",Ve,_,vs='Learn more at <a href="https://sbert.net/docs/sentence_transformer/dataset_overview.html" rel="nofollow">Dataset Overview</a>.',_e,Y,Rs='We are going to use <a href="https://huggingface.co/datasets/philschmid/finanical-rag-embedding-dataset" rel="nofollow">philschmid/finanical-rag-embedding-dataset</a>, which includes 7,000 positive text pairs of questions and corresponding context from the <a href="https://stocklight.com/stocks/us/nasdaq-nvda/nvidia/annual-reports/nasdaq-nvda-2023-10K-23668751.pdf" rel="nofollow">2023_10 NVIDIA SEC Filing</a>.',Ye,N,Xs="The dataset has the following format",Ne,S,Se,E,zs='We are going to use the <a href="https://huggingface.co/docs/datasets/filesystems" rel="nofollow">FileSystem integration</a> to upload our dataset to S3. We are using the <code>sess.default_bucket()</code>, adjust this if you want to store the dataset in a different S3 bucket. We will use the S3 path later in our training script.',Ee,F,Fe,Q,Qe,A,Hs=`We are now ready to fine-tune our model. We will use the <a href="https://www.sbert.net/docs/package_reference/sentence_transformer/trainer.html" rel="nofollow">SentenceTransformerTrainer</a> from <code>sentence-transformers</code> to fine-tune our model. The <code>SentenceTransformerTrainer</code> makes it straightfoward to supervise fine-tune open Embedding Models, as it is a subclass of the <code>Trainer</code> from the <code>transformers</code>. We prepared a script <a href="assets/run_mnr.py">run_mnr.py</a> which will loads the dataset from disk, prepare the model, tokenizer and start the training.
The <code>SentenceTransformerTrainer</code> makes it straightfoward to supervise fine-tune open Embedding supporting:`,Ae,$,Vs="<li><strong>Integrated Components</strong>: Combines datasets, loss functions, and evaluators into a unified training framework.</li> <li><strong>Flexible Data Handling</strong>: Supports various data formats and easy integration with Hugging Face datasets.</li> <li><strong>Versatile Loss Functions</strong>: Offers multiple loss functions for different training tasks.</li> <li><strong>Multi-Dataset Training</strong>: Facilitates simultaneous training with multiple datasets and different loss functions.</li> <li><strong>Seamless Integration</strong>: Easy saving, loading, and sharing of models within the Hugging Face ecosystem.</li>",$e,x,_s="In order to create a sagemaker training job we need an <code>HuggingFace</code> Estimator. The Estimator handles end-to-end Amazon SageMaker training and deployment tasks. The Estimator manages the infrastructure use. Amazon SagMaker takes care of starting and managing all the required ec2 instances for us, provides the correct huggingface container, uploads the provided scripts and downloads the data from our S3 bucket into the container at <code>/opt/ml/input/data</code>. Then, it starts the training job by running.",xe,q,Ys="Note: Make sure that you include the <code>requirements.txt</code> in the <code>source_dir</code> if you are using a custom training script. We recommend to just clone the whole repository.",qe,L,Ns="Lets first define our trainings parameter. Those are passed as cli arguments to our training script. We are going to use the <code>BAAI/bge-base-en-v1.5</code> model, which is a pre-trained model on a large corpus of English text. We will use the <code>MultipleNegativesRankingLoss</code> in combination with the <code>MatryoshkaLoss</code>. This approach allows us to leverage the efficiency and flexibility of Matryoshka embeddings, enabling different embedding dimensions to be utilized without significant performance trade-offs. The <code>MultipleNegativesRankingLoss</code> is a great loss function if you only have positive pairs as it adds in batch negative samples to the loss function to have per sample n-1 negative samples.",Le,P,Pe,D,Ss="We can now start our training job, with the <code>.fit()</code> method passing our S3 path to the training script.",De,K,Ke,O,Es="In our example the training BGE Base with Flash Attention 2 (SDPA) for 3 epochs with a dataset of 6,3k train samples and 700 eval samples took 645 seconds (~10minutes) on a <code>ml.g5.xlarge</code> (1.2575 $/h) or ~$5.",Oe,ee,es,se,Fs='We are going to use the <a href="https://huggingface.co/blog/sagemaker-huggingface-embedding#what-is-the-hugging-face-embedding-container" rel="nofollow">Hugging Face Embedding Container</a> a purpose-built Inference  Container to easily deploy Embedding Models in a secure and managed environment. The DLC is powered by Text Embedding Inference (TEI) a blazing fast and memory efficient solution for deploying and serving Embedding Models.',ss,te,Qs="To retrieve the new Hugging Face Embedding Container in Amazon SageMaker, we can use the <code>get_huggingface_llm_image_uri</code> method provided by the sagemaker SDK. This method allows us to retrieve the URI for the desired Hugging Face Embedding Container. Important to note is that TEI has 2 different versions for cpu and gpu, so we create a helper function to retrieve the correct image uri based on the instance type.",ts,ne,ns,ae,As="We can now create a <code>HuggingFaceModel</code> using the container uri and the S3 path to our model. We also need to set our TEI configuration.",as,le,ls,ie,$s="After we have created the <code>HuggingFaceModel</code> we can deploy it to Amazon SageMaker using the deploy method. We will deploy the model with the <code>ml.c6i.2xlarge</code> instance type.",is,oe,os,pe,xs="SageMaker will now create our endpoint and deploy the model to it. This can take ~5 minutes. After our endpoint is deployed we can run inference on it. We will use the <code>predict</code> method from the predictor to run inference on our endpoint.",ps,re,rs,Me,qs="We trained our model with the Matryoshka Loss means that the semantic meaning is frontloaded. To use the different mathryshoka dimension we need to manually truncate our embeddings manually. Below is an example on how you would truncate the embeddings to 256 dimension, which is 1/3 of the original size. If we check our training logs we can see that the NDCG metric for 768 is <code>0.823</code> and for 256 <code>0.818</code> meaning we preserve &gt; 99% accuracy.",Ms,de,ds,ce,Ls="Awesome! 🚀 Now that we can generate embeddings and integrate your endpoint into your RAG application.",cs,me,Ps="To clean up, we can delete the model and endpoint.",ms,ue,us,hs,ys,T,Js,he,Ts,Je,ws;return j=new pt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new Te({props:{title:"Fine-tune and deploy embedding models with Amazon SageMaker",local:"fine-tune-and-deploy-embedding-models-with-amazon-sagemaker",headingTag:"h1"}}),B=new Te({props:{title:"1. Setup Development Environment",local:"1-setup-development-environment",headingTag:"h2"}}),v=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlMjAlMjJkYXRhc2V0cyU1QnMzJTVEJTNEJTNEMi4xOC4wJTIyJTIwJTIyc2FnZW1ha2VyJTNFJTNEMi4xOTAuMCUyMiUyMCUyMmh1Z2dpbmdmYWNlX2h1YiU1QmNsaSU1RCUyMiUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:'!pip install transformers <span class="hljs-string">&quot;datasets[s3]==2.18.0&quot;</span> <span class="hljs-string">&quot;sagemaker&gt;=2.190.0&quot;</span> <span class="hljs-string">&quot;huggingface_hub[cli]&quot;</span> --upgrade --quiet',wrap:!1}}),X=new y({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oKSUwQSUyMyUyMHNhZ2VtYWtlciUyMHNlc3Npb24lMjBidWNrZXQlMjAtJTNFJTIwdXNlZCUyMGZvciUyMHVwbG9hZGluZyUyMGRhdGElMkMlMjBtb2RlbHMlMjBhbmQlMjBsb2dzJTBBJTIzJTIwc2FnZW1ha2VyJTIwd2lsbCUyMGF1dG9tYXRpY2FsbHklMjBjcmVhdGUlMjB0aGlzJTIwYnVja2V0JTIwaWYlMjBpdCUyMG5vdCUyMGV4aXN0cyUwQXNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUzRE5vbmUlMEFpZiUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMGlzJTIwTm9uZSUyMGFuZCUyMHNlc3MlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzZXQlMjB0byUyMGRlZmF1bHQlMjBidWNrZXQlMjBpZiUyMGElMjBidWNrZXQlMjBuYW1lJTIwaXMlMjBub3QlMjBnaXZlbiUwQSUyMCUyMCUyMCUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyMHNlc3MuZGVmYXVsdF9idWNrZXQoKSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMHJvbGUlMjAlM0QlMjBzYWdlbWFrZXIuZ2V0X2V4ZWN1dGlvbl9yb2xlKCklMEFleGNlcHQlMjBWYWx1ZUVycm9yJTNBJTBBJTIwJTIwJTIwJTIwaWFtJTIwJTNEJTIwYm90bzMuY2xpZW50KCdpYW0nKSUwQSUyMCUyMCUyMCUyMHJvbGUlMjAlM0QlMjBpYW0uZ2V0X3JvbGUoUm9sZU5hbWUlM0Qnc2FnZW1ha2VyX2V4ZWN1dGlvbl9yb2xlJyklNUInUm9sZSclNUQlNUInQXJuJyU1RCUwQSUwQXNlc3MlMjAlM0QlMjBzYWdlbWFrZXIuU2Vzc2lvbihkZWZhdWx0X2J1Y2tldCUzRHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCklMEElMEFwcmludChmJTIyc2FnZW1ha2VyJTIwcm9sZSUyMGFybiUzQSUyMCU3QnJvbGUlN0QlMjIpJTBBcHJpbnQoZiUyMnNhZ2VtYWtlciUyMGJ1Y2tldCUzQSUyMCU3QnNlc3MuZGVmYXVsdF9idWNrZXQoKSU3RCUyMiklMEFwcmludChmJTIyc2FnZW1ha2VyJTIwc2Vzc2lvbiUyMHJlZ2lvbiUzQSUyMCU3QnNlc3MuYm90b19yZWdpb25fbmFtZSU3RCUyMik=",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3
sess = sagemaker.Session()
<span class="hljs-comment"># sagemaker session bucket -&gt; used for uploading data, models and logs</span>
<span class="hljs-comment"># sagemaker will automatically create this bucket if it not exists</span>
sagemaker_session_bucket=<span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># set to default bucket if a bucket name is not given</span>
    sagemaker_session_bucket = sess.default_bucket()

<span class="hljs-keyword">try</span>:
    role = sagemaker.get_execution_role()
<span class="hljs-keyword">except</span> ValueError:
    iam = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
    role = iam.get_role(RoleName=<span class="hljs-string">&#x27;sagemaker_execution_role&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]

sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker role arn: <span class="hljs-subst">{role}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker bucket: <span class="hljs-subst">{sess.default_bucket()}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker session region: <span class="hljs-subst">{sess.boto_region_name}</span>&quot;</span>)`,wrap:!1}}),z=new Te({props:{title:"2. Create and prepare the dataset",local:"2-create-and-prepare-the-dataset",headingTag:"h2"}}),S=new y({props:{code:"JTdCJTIycXVlc3Rpb24lMjIlM0ElMjAlMjIlM0NxdWVzdGlvbiUzRSUyMiUyQyUyMCUyMmNvbnRleHQlMjIlM0ElMjAlMjIlM0NyZWxldmFudCUyMGNvbnRleHQlMjB0byUyMGFuc3dlciUzRSUyMiU3RCUwQSU3QiUyMnF1ZXN0aW9uJTIyJTNBJTIwJTIyJTNDcXVlc3Rpb24lM0UlMjIlMkMlMjAlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTNDcmVsZXZhbnQlMjBjb250ZXh0JTIwdG8lMjBhbnN3ZXIlM0UlMjIlN0QlMEElN0IlMjJxdWVzdGlvbiUyMiUzQSUyMCUyMiUzQ3F1ZXN0aW9uJTNFJTIyJTJDJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMiUzQ3JlbGV2YW50JTIwY29udGV4dCUyMHRvJTIwYW5zd2VyJTNFJTIyJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;question&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;question&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;context&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;relevant context to answer&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;question&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;question&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;context&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;relevant context to answer&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;question&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;question&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;context&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;relevant context to answer&gt;&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),F=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Load dataset from the hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;philschmid/finanical-rag-embedding-dataset&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
input_path = <span class="hljs-string">f&#x27;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/datasets/rag-embedding&#x27;</span>

<span class="hljs-comment"># rename columns</span>
dataset = dataset.rename_column(<span class="hljs-string">&quot;question&quot;</span>, <span class="hljs-string">&quot;anchor&quot;</span>)
dataset = dataset.rename_column(<span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>)

<span class="hljs-comment"># Add an id column to the dataset</span>
dataset = dataset.add_column(<span class="hljs-string">&quot;id&quot;</span>, <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)))

<span class="hljs-comment"># split dataset into a 10% test set</span>
dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)

<span class="hljs-comment"># save train_dataset to s3 using our SageMaker session</span>

<span class="hljs-comment"># save datasets to s3</span>
dataset[<span class="hljs-string">&quot;train&quot;</span>].to_json(<span class="hljs-string">f&quot;<span class="hljs-subst">{input_path}</span>/train/dataset.json&quot;</span>, orient=<span class="hljs-string">&quot;records&quot;</span>)
train_dataset_s3_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{input_path}</span>/train/dataset.json&quot;</span>
dataset[<span class="hljs-string">&quot;test&quot;</span>].to_json(<span class="hljs-string">f&quot;<span class="hljs-subst">{input_path}</span>/test/dataset.json&quot;</span>, orient=<span class="hljs-string">&quot;records&quot;</span>)
test_dataset_s3_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{input_path}</span>/test/dataset.json&quot;</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Training data uploaded to:&quot;</span>)
<span class="hljs-built_in">print</span>(train_dataset_s3_path)
<span class="hljs-built_in">print</span>(test_dataset_s3_path)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;https://s3.console.aws.amazon.com/s3/buckets/<span class="hljs-subst">{sess.default_bucket()}</span>/?region=<span class="hljs-subst">{sess.boto_region_name}</span>&amp;prefix=<span class="hljs-subst">{input_path.split(<span class="hljs-string">&#x27;/&#x27;</span>, <span class="hljs-number">3</span>)[-<span class="hljs-number">1</span>]}</span>/&quot;</span>)`,wrap:!1}}),Q=new Te({props:{title:"3. Fine-tune Embedding model on Amazon SageMaker",local:"3-fine-tune-embedding-model-on-amazon-sagemaker",headingTag:"h2"}}),P=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace

<span class="hljs-comment"># define Training Job Name </span>
job_name = <span class="hljs-string">f&#x27;bge-base-exp1&#x27;</span>

<span class="hljs-comment"># define hyperparameters, which are passed into the training job</span>
training_arguments = {
  <span class="hljs-string">&quot;model_id&quot;</span>: <span class="hljs-string">&quot;BAAI/bge-base-en-v1.5&quot;</span>, <span class="hljs-comment"># model id from the hub</span>
  <span class="hljs-string">&quot;train_dataset_path&quot;</span>: <span class="hljs-string">&quot;/opt/ml/input/data/train/&quot;</span>, <span class="hljs-comment"># path inside the container where the training data is stored</span>
  <span class="hljs-string">&quot;test_dataset_path&quot;</span>: <span class="hljs-string">&quot;/opt/ml/input/data/test/&quot;</span>, <span class="hljs-comment"># path inside the container where the test data is stored</span>
  <span class="hljs-string">&quot;num_train_epochs&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-comment"># number of training epochs</span>
  <span class="hljs-string">&quot;learning_rate&quot;</span>: <span class="hljs-number">2e-5</span>, <span class="hljs-comment"># learning rate</span>
}

<span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
    entry_point          = <span class="hljs-string">&#x27;run_mnr.py&#x27;</span>,      <span class="hljs-comment"># train script</span>
    source_dir           = <span class="hljs-string">&#x27;scripts&#x27;</span>,         <span class="hljs-comment"># directory which includes all the files needed for training</span>
    instance_type        = <span class="hljs-string">&#x27;ml.g5.xlarge&#x27;</span>,    <span class="hljs-comment"># instances type used for the training job</span>
    instance_count       = <span class="hljs-number">1</span>,                 <span class="hljs-comment"># the number of instances used for training</span>
    max_run              = <span class="hljs-number">2</span>*<span class="hljs-number">24</span>*<span class="hljs-number">60</span>*<span class="hljs-number">60</span>,        <span class="hljs-comment"># maximum runtime in seconds (days * hours * minutes * seconds)</span>
    base_job_name        = job_name,          <span class="hljs-comment"># the name of the training job</span>
    role                 = role,              <span class="hljs-comment"># Iam role used in training job to access AWS ressources, e.g. S3</span>
    transformers_version = <span class="hljs-string">&#x27;4.36.0&#x27;</span>,          <span class="hljs-comment"># the transformers version used in the training job</span>
    pytorch_version      = <span class="hljs-string">&#x27;2.1.0&#x27;</span>,           <span class="hljs-comment"># the pytorch_version version used in the training job</span>
    py_version           = <span class="hljs-string">&#x27;py310&#x27;</span>,           <span class="hljs-comment"># the python version used in the training job</span>
    hyperparameters      =  training_arguments,
    disable_output_compression = <span class="hljs-literal">True</span>,        <span class="hljs-comment"># not compress output to save training time and cost</span>
    environment  = {
        <span class="hljs-string">&quot;HUGGINGFACE_HUB_CACHE&quot;</span>: <span class="hljs-string">&quot;/tmp/.cache&quot;</span>, <span class="hljs-comment"># set env variable to cache models in /tmp</span>
    }, 
)`,wrap:!1}}),K=new y({props:{code:"JTIzJTIwZGVmaW5lJTIwYSUyMGRhdGElMjBpbnB1dCUyMGRpY3RvbmFyeSUyMHdpdGglMjBvdXIlMjB1cGxvYWRlZCUyMHMzJTIwdXJpcyUwQWRhdGElMjAlM0QlMjAlN0IlMEElMjAlMjAndHJhaW4nJTNBJTIwdHJhaW5fZGF0YXNldF9zM19wYXRoJTJDJTBBJTIwJTIwJ3Rlc3QnJTNBJTIwdGVzdF9kYXRhc2V0X3MzX3BhdGglMkMlMEElMjAlMjAlN0QlMEElMEElMjMlMjBzdGFydGluZyUyMHRoZSUyMHRyYWluJTIwam9iJTIwd2l0aCUyMG91ciUyMHVwbG9hZGVkJTIwZGF0YXNldHMlMjBhcyUyMGlucHV0JTBBaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLmZpdChkYXRhJTJDJTIwd2FpdCUzRFRydWUp",highlighted:`<span class="hljs-comment"># define a data input dictonary with our uploaded s3 uris</span>
data = {
  <span class="hljs-string">&#x27;train&#x27;</span>: train_dataset_s3_path,
  <span class="hljs-string">&#x27;test&#x27;</span>: test_dataset_s3_path,
  }

<span class="hljs-comment"># starting the train job with our uploaded datasets as input</span>
huggingface_estimator.fit(data, wait=<span class="hljs-literal">True</span>)`,wrap:!1}}),ee=new Te({props:{title:"4. Deploy & Test fine-tuned Embedding Model on Amazon SageMaker",local:"4-deploy--test-fine-tuned-embedding-model-on-amazon-sagemaker",headingTag:"h2"}}),ne=new y({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMGdldF9odWdnaW5nZmFjZV9sbG1faW1hZ2VfdXJpJTBBJTBBJTIzJTIwcmV0cmlldmUlMjB0aGUlMjBpbWFnZSUyMHVyaSUyMGJhc2VkJTIwb24lMjBpbnN0YW5jZSUyMHR5cGUlMEFkZWYlMjBnZXRfaW1hZ2VfdXJpKGluc3RhbmNlX3R5cGUpJTNBJTBBJTIwJTIwa2V5JTIwJTNEJTIwJTIyaHVnZ2luZ2ZhY2UtdGVpJTIyJTIwaWYlMjBpbnN0YW5jZV90eXBlLnN0YXJ0c3dpdGgoJTIybWwuZyUyMiklMjBvciUyMGluc3RhbmNlX3R5cGUuc3RhcnRzd2l0aCglMjJtbC5wJTIyKSUyMGVsc2UlMjAlMjJodWdnaW5nZmFjZS10ZWktY3B1JTIyJTBBJTIwJTIwcmV0dXJuJTIwZ2V0X2h1Z2dpbmdmYWNlX2xsbV9pbWFnZV91cmkoa2V5JTJDJTIwdmVyc2lvbiUzRCUyMjEuNC4wJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> get_huggingface_llm_image_uri

<span class="hljs-comment"># retrieve the image uri based on instance type</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_image_uri</span>(<span class="hljs-params">instance_type</span>):
  key = <span class="hljs-string">&quot;huggingface-tei&quot;</span> <span class="hljs-keyword">if</span> instance_type.startswith(<span class="hljs-string">&quot;ml.g&quot;</span>) <span class="hljs-keyword">or</span> instance_type.startswith(<span class="hljs-string">&quot;ml.p&quot;</span>) <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;huggingface-tei-cpu&quot;</span>
  <span class="hljs-keyword">return</span> get_huggingface_llm_image_uri(key, version=<span class="hljs-string">&quot;1.4.0&quot;</span>)`,wrap:!1}}),le=new y({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlTW9kZWwlMEElMEElMjMlMjBzYWdlbWFrZXIlMjBjb25maWclMEFpbnN0YW5jZV90eXBlJTIwJTNEJTIwJTIybWwuYzZpLjJ4bGFyZ2UlMjIlMEElMEElMjMlMjBjcmVhdGUlMjBIdWdnaW5nRmFjZU1vZGVsJTIwd2l0aCUyMHRoZSUyMGltYWdlJTIwdXJpJTBBZW1iX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VNb2RlbCglMEElMjAlMjByb2xlJTNEcm9sZSUyQyUwQSUyMCUyMGltYWdlX3VyaSUzRGdldF9pbWFnZV91cmkoaW5zdGFuY2VfdHlwZSklMkMlMEElMjAlMjBtb2RlbF9kYXRhJTNEaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLm1vZGVsX2RhdGElMkMlMEElMjAlMjBlbnYlM0QlN0InSEZfTU9ERUxfSUQnJTNBJTIwJTIyJTJGb3B0JTJGbWwlMkZtb2RlbCUyMiU3RCUyMCUyMCUyMCUyMCUyMCUyMyUyMFBhdGglMjB0byUyMHRoZSUyMG1vZGVsJTIwaW4lMjB0aGUlMjBjb250YWluZXIlMEEp",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># sagemaker config</span>
instance_type = <span class="hljs-string">&quot;ml.c6i.2xlarge&quot;</span>

<span class="hljs-comment"># create HuggingFaceModel with the image uri</span>
emb_model = HuggingFaceModel(
  role=role,
  image_uri=get_image_uri(instance_type),
  model_data=huggingface_estimator.model_data,
  env={<span class="hljs-string">&#x27;HF_MODEL_ID&#x27;</span>: <span class="hljs-string">&quot;/opt/ml/model&quot;</span>}     <span class="hljs-comment"># Path to the model in the container</span>
)`,wrap:!1}}),oe=new y({props:{code:"JTIzJTIwRGVwbG95JTIwbW9kZWwlMjB0byUyMGFuJTIwZW5kcG9pbnQlMEFlbWIlMjAlM0QlMjBlbWJfbW9kZWwuZGVwbG95KCUwQSUyMCUyMGluaXRpYWxfaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBJTIwJTIwaW5zdGFuY2VfdHlwZSUzRGluc3RhbmNlX3R5cGUlMkMlMEEp",highlighted:`<span class="hljs-comment"># Deploy model to an endpoint</span>
emb = emb_model.deploy(
  initial_instance_count=<span class="hljs-number">1</span>,
  instance_type=instance_type,
)`,wrap:!1}}),re=new y({props:{code:"ZGF0YSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMCUyMnRoZSUyMG1lc21lcml6aW5nJTIwcGVyZm9ybWFuY2VzJTIwb2YlMjB0aGUlMjBsZWFkcyUyMGtlZXAlMjB0aGUlMjBmaWxtJTIwZ3JvdW5kZWQlMjBhbmQlMjBrZWVwJTIwdGhlJTIwYXVkaWVuY2UlMjByaXZldGVkJTIwLiUyMiUyQyUwQSU3RCUwQSUyMCUwQXJlcyUyMCUzRCUyMGVtYi5wcmVkaWN0KGRhdGElM0RkYXRhKSUwQSUyMCUwQSUyMCUwQSUyMyUyMHByaW50JTIwc29tZSUyMHJlc3VsdHMlMEFwcmludChmJTIybGVuZ3RoJTIwb2YlMjBlbWJlZGRpbmdzJTNBJTIwJTdCbGVuKHJlcyU1QjAlNUQpJTdEJTIyKSUwQXByaW50KGYlMjJmaXJzdCUyMDEwJTIwZWxlbWVudHMlMjBvZiUyMGVtYmVkZGluZ3MlM0ElMjAlN0JyZXMlNUIwJTVEJTVCJTNBMTAlNUQlN0QlMjIp",highlighted:`data = {
  <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;the mesmerizing performances of the leads keep the film grounded and keep the audience riveted .&quot;</span>,
}
 
res = emb.predict(data=data)
 
 
<span class="hljs-comment"># print some results</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;length of embeddings: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(res[<span class="hljs-number">0</span>])}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;first 10 elements of embeddings: <span class="hljs-subst">{res[<span class="hljs-number">0</span>][:<span class="hljs-number">10</span>]}</span>&quot;</span>)`,wrap:!1}}),de=new y({props:{code:"ZGF0YSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMCUyMnRoZSUyMG1lc21lcml6aW5nJTIwcGVyZm9ybWFuY2VzJTIwb2YlMjB0aGUlMjBsZWFkcyUyMGtlZXAlMjB0aGUlMjBmaWxtJTIwZ3JvdW5kZWQlMjBhbmQlMjBrZWVwJTIwdGhlJTIwYXVkaWVuY2UlMjByaXZldGVkJTIwLiUyMiUyQyUwQSU3RCUwQSUyMCUwQXJlcyUyMCUzRCUyMGVtYi5wcmVkaWN0KGRhdGElM0RkYXRhKSUwQSUyMCUwQSUyMyUyMHRydW5jYXRlJTIwZW1iZWRkaW5ncyUyMHRvJTIwbWF0cnlvc2hrYSUyMGRpbWVuc2lvbnMlMEFkaW0lMjAlM0QlMjAyNTYlMEFyZXMlMjAlM0QlMjByZXMlNUIwJTVEJTVCMCUzQWRpbSU1RCUwQSUyMCUwQSUyMyUyMHByaW50JTIwc29tZSUyMHJlc3VsdHMlMEFwcmludChmJTIybGVuZ3RoJTIwb2YlMjBlbWJlZGRpbmdzJTNBJTIwJTdCbGVuKHJlcyklN0QlMjIp",highlighted:`data = {
  <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;the mesmerizing performances of the leads keep the film grounded and keep the audience riveted .&quot;</span>,
}
 
res = emb.predict(data=data)
 
<span class="hljs-comment"># truncate embeddings to matryoshka dimensions</span>
dim = <span class="hljs-number">256</span>
res = res[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>:dim]
 
<span class="hljs-comment"># print some results</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;length of embeddings: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(res)}</span>&quot;</span>)`,wrap:!1}}),ue=new y({props:{code:"ZW1iLmRlbGV0ZV9tb2RlbCgpJTBBZW1iLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:`emb.delete_model()
emb.delete_endpoint()`,wrap:!1}}),T=new ot({props:{$$slots:{default:[Mt]},$$scope:{ctx:we}}}),he=new rt({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/examples/sagemaker-sdk-fine-tune-embedding-models.mdx"}}),{c(){h=i("meta"),w=a(),J=i("p"),ye=a(),r(j.$$.fragment),je=a(),r(g.$$.fragment),ge=a(),U=i("p"),U.innerHTML=js,Ue=a(),b=i("p"),b.innerHTML=gs,be=a(),f=i("ol"),f.innerHTML=Us,fe=a(),I=i("p"),I.innerHTML=bs,Ie=a(),Z=i("p"),Z.textContent=fs,Ze=a(),C=i("p"),C.innerHTML=Is,Ce=a(),W=i("p"),W.innerHTML=Zs,We=a(),G=i("p"),G.innerHTML=Cs,Ge=a(),r(B.$$.fragment),Be=a(),k=i("p"),k.textContent=Ws,ke=a(),r(v.$$.fragment),ve=a(),R=i("p"),R.innerHTML=Gs,Re=a(),r(X.$$.fragment),Xe=a(),r(z.$$.fragment),ze=a(),H=i("p"),H.textContent=Bs,He=a(),V=i("ul"),V.innerHTML=ks,Ve=a(),_=i("p"),_.innerHTML=vs,_e=a(),Y=i("p"),Y.innerHTML=Rs,Ye=a(),N=i("p"),N.textContent=Xs,Ne=a(),r(S.$$.fragment),Se=a(),E=i("p"),E.innerHTML=zs,Ee=a(),r(F.$$.fragment),Fe=a(),r(Q.$$.fragment),Qe=a(),A=i("p"),A.innerHTML=Hs,Ae=a(),$=i("ul"),$.innerHTML=Vs,$e=a(),x=i("p"),x.innerHTML=_s,xe=a(),q=i("p"),q.innerHTML=Ys,qe=a(),L=i("p"),L.innerHTML=Ns,Le=a(),r(P.$$.fragment),Pe=a(),D=i("p"),D.innerHTML=Ss,De=a(),r(K.$$.fragment),Ke=a(),O=i("p"),O.innerHTML=Es,Oe=a(),r(ee.$$.fragment),es=a(),se=i("p"),se.innerHTML=Fs,ss=a(),te=i("p"),te.innerHTML=Qs,ts=a(),r(ne.$$.fragment),ns=a(),ae=i("p"),ae.innerHTML=As,as=a(),r(le.$$.fragment),ls=a(),ie=i("p"),ie.innerHTML=$s,is=a(),r(oe.$$.fragment),os=a(),pe=i("p"),pe.innerHTML=xs,ps=a(),r(re.$$.fragment),rs=a(),Me=i("p"),Me.innerHTML=qs,Ms=a(),r(de.$$.fragment),ds=a(),ce=i("p"),ce.textContent=Ls,cs=a(),me=i("p"),me.textContent=Ps,ms=a(),r(ue.$$.fragment),us=a(),hs=i("hr"),ys=a(),r(T.$$.fragment),Js=a(),r(he.$$.fragment),Ts=a(),Je=i("p"),this.h()},l(e){const s=lt("svelte-u9bgzb",document.head);h=o(s,"META",{name:!0,content:!0}),s.forEach(t),w=l(e),J=o(e,"P",{}),Ks(J).forEach(t),ye=l(e),M(j.$$.fragment,e),je=l(e),M(g.$$.fragment,e),ge=l(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-hjugkj"&&(U.innerHTML=js),Ue=l(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1rdpwjk"&&(b.innerHTML=gs),be=l(e),f=o(e,"OL",{"data-svelte-h":!0}),p(f)!=="svelte-jw6fjl"&&(f.innerHTML=Us),fe=l(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-z40gay"&&(I.innerHTML=bs),Ie=l(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-qpk058"&&(Z.textContent=fs),Ze=l(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-9kfhp3"&&(C.innerHTML=Is),Ce=l(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1dotmv1"&&(W.innerHTML=Zs),We=l(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1awmlx3"&&(G.innerHTML=Cs),Ge=l(e),M(B.$$.fragment,e),Be=l(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1ajxiw0"&&(k.textContent=Ws),ke=l(e),M(v.$$.fragment,e),ve=l(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-s0u97w"&&(R.innerHTML=Gs),Re=l(e),M(X.$$.fragment,e),Xe=l(e),M(z.$$.fragment,e),ze=l(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-16i0yfq"&&(H.textContent=Bs),He=l(e),V=o(e,"UL",{"data-svelte-h":!0}),p(V)!=="svelte-1hfoafx"&&(V.innerHTML=ks),Ve=l(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-qoe0pu"&&(_.innerHTML=vs),_e=l(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-qdb1uz"&&(Y.innerHTML=Rs),Ye=l(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1b5uozi"&&(N.textContent=Xs),Ne=l(e),M(S.$$.fragment,e),Se=l(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1kr3vm9"&&(E.innerHTML=zs),Ee=l(e),M(F.$$.fragment,e),Fe=l(e),M(Q.$$.fragment,e),Qe=l(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1eaaz3g"&&(A.innerHTML=Hs),Ae=l(e),$=o(e,"UL",{"data-svelte-h":!0}),p($)!=="svelte-1kxt6cj"&&($.innerHTML=Vs),$e=l(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-16cenvv"&&(x.innerHTML=_s),xe=l(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-6mgwni"&&(q.innerHTML=Ys),qe=l(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-br5gpt"&&(L.innerHTML=Ns),Le=l(e),M(P.$$.fragment,e),Pe=l(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-18e42pb"&&(D.innerHTML=Ss),De=l(e),M(K.$$.fragment,e),Ke=l(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1esotj9"&&(O.innerHTML=Es),Oe=l(e),M(ee.$$.fragment,e),es=l(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-18uw3dz"&&(se.innerHTML=Fs),ss=l(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1ei5h4z"&&(te.innerHTML=Qs),ts=l(e),M(ne.$$.fragment,e),ns=l(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1b88wn2"&&(ae.innerHTML=As),as=l(e),M(le.$$.fragment,e),ls=l(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1gpwlux"&&(ie.innerHTML=$s),is=l(e),M(oe.$$.fragment,e),os=l(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1670aas"&&(pe.innerHTML=xs),ps=l(e),M(re.$$.fragment,e),rs=l(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-n8rhlf"&&(Me.innerHTML=qs),Ms=l(e),M(de.$$.fragment,e),ds=l(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-ezaoag"&&(ce.textContent=Ls),cs=l(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-100mxno"&&(me.textContent=Ps),ms=l(e),M(ue.$$.fragment,e),us=l(e),hs=o(e,"HR",{}),ys=l(e),M(T.$$.fragment,e),Js=l(e),M(he.$$.fragment,e),Ts=l(e),Je=o(e,"P",{}),Ks(Je).forEach(t),this.h()},h(){Os(h,"name","hf:doc:metadata"),Os(h,"content",ct)},m(e,s){it(document.head,h),n(e,w,s),n(e,J,s),n(e,ye,s),d(j,e,s),n(e,je,s),d(g,e,s),n(e,ge,s),n(e,U,s),n(e,Ue,s),n(e,b,s),n(e,be,s),n(e,f,s),n(e,fe,s),n(e,I,s),n(e,Ie,s),n(e,Z,s),n(e,Ze,s),n(e,C,s),n(e,Ce,s),n(e,W,s),n(e,We,s),n(e,G,s),n(e,Ge,s),d(B,e,s),n(e,Be,s),n(e,k,s),n(e,ke,s),d(v,e,s),n(e,ve,s),n(e,R,s),n(e,Re,s),d(X,e,s),n(e,Xe,s),d(z,e,s),n(e,ze,s),n(e,H,s),n(e,He,s),n(e,V,s),n(e,Ve,s),n(e,_,s),n(e,_e,s),n(e,Y,s),n(e,Ye,s),n(e,N,s),n(e,Ne,s),d(S,e,s),n(e,Se,s),n(e,E,s),n(e,Ee,s),d(F,e,s),n(e,Fe,s),d(Q,e,s),n(e,Qe,s),n(e,A,s),n(e,Ae,s),n(e,$,s),n(e,$e,s),n(e,x,s),n(e,xe,s),n(e,q,s),n(e,qe,s),n(e,L,s),n(e,Le,s),d(P,e,s),n(e,Pe,s),n(e,D,s),n(e,De,s),d(K,e,s),n(e,Ke,s),n(e,O,s),n(e,Oe,s),d(ee,e,s),n(e,es,s),n(e,se,s),n(e,ss,s),n(e,te,s),n(e,ts,s),d(ne,e,s),n(e,ns,s),n(e,ae,s),n(e,as,s),d(le,e,s),n(e,ls,s),n(e,ie,s),n(e,is,s),d(oe,e,s),n(e,os,s),n(e,pe,s),n(e,ps,s),d(re,e,s),n(e,rs,s),n(e,Me,s),n(e,Ms,s),d(de,e,s),n(e,ds,s),n(e,ce,s),n(e,cs,s),n(e,me,s),n(e,ms,s),d(ue,e,s),n(e,us,s),n(e,hs,s),n(e,ys,s),d(T,e,s),n(e,Js,s),d(he,e,s),n(e,Ts,s),n(e,Je,s),ws=!0},p(e,[s]){const Ds={};s&2&&(Ds.$$scope={dirty:s,ctx:e}),T.$set(Ds)},i(e){ws||(c(j.$$.fragment,e),c(g.$$.fragment,e),c(B.$$.fragment,e),c(v.$$.fragment,e),c(X.$$.fragment,e),c(z.$$.fragment,e),c(S.$$.fragment,e),c(F.$$.fragment,e),c(Q.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(ne.$$.fragment,e),c(le.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(de.$$.fragment,e),c(ue.$$.fragment,e),c(T.$$.fragment,e),c(he.$$.fragment,e),ws=!0)},o(e){m(j.$$.fragment,e),m(g.$$.fragment,e),m(B.$$.fragment,e),m(v.$$.fragment,e),m(X.$$.fragment,e),m(z.$$.fragment,e),m(S.$$.fragment,e),m(F.$$.fragment,e),m(Q.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),m(le.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(de.$$.fragment,e),m(ue.$$.fragment,e),m(T.$$.fragment,e),m(he.$$.fragment,e),ws=!1},d(e){e&&(t(w),t(J),t(ye),t(je),t(ge),t(U),t(Ue),t(b),t(be),t(f),t(fe),t(I),t(Ie),t(Z),t(Ze),t(C),t(Ce),t(W),t(We),t(G),t(Ge),t(Be),t(k),t(ke),t(ve),t(R),t(Re),t(Xe),t(ze),t(H),t(He),t(V),t(Ve),t(_),t(_e),t(Y),t(Ye),t(N),t(Ne),t(Se),t(E),t(Ee),t(Fe),t(Qe),t(A),t(Ae),t($),t($e),t(x),t(xe),t(q),t(qe),t(L),t(Le),t(Pe),t(D),t(De),t(Ke),t(O),t(Oe),t(es),t(se),t(ss),t(te),t(ts),t(ns),t(ae),t(as),t(ls),t(ie),t(is),t(os),t(pe),t(ps),t(rs),t(Me),t(Ms),t(ds),t(ce),t(cs),t(me),t(ms),t(us),t(hs),t(ys),t(Js),t(Ts),t(Je)),t(h),u(j,e),u(g,e),u(B,e),u(v,e),u(X,e),u(z,e),u(S,e),u(F,e),u(Q,e),u(P,e),u(K,e),u(ee,e),u(ne,e),u(le,e),u(oe,e),u(re,e),u(de,e),u(ue,e),u(T,e),u(he,e)}}}const ct='{"title":"Fine-tune and deploy embedding models with Amazon SageMaker","local":"fine-tune-and-deploy-embedding-models-with-amazon-sagemaker","sections":[{"title":"1. Setup Development Environment","local":"1-setup-development-environment","sections":[],"depth":2},{"title":"2. Create and prepare the dataset","local":"2-create-and-prepare-the-dataset","sections":[],"depth":2},{"title":"3. Fine-tune Embedding model on Amazon SageMaker","local":"3-fine-tune-embedding-model-on-amazon-sagemaker","sections":[],"depth":2},{"title":"4. Deploy & Test fine-tuned Embedding Model on Amazon SageMaker","local":"4-deploy--test-fine-tuned-embedding-model-on-amazon-sagemaker","sections":[],"depth":2}],"depth":1}';function mt(we){return st(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wt extends nt{constructor(h){super(),at(this,h,mt,dt,et,{})}}export{wt as component};
