import{s as at,f as it,n as ot,o as pt}from"../chunks/scheduler.37c15a92.js";import{S as rt,i as ct,g as i,s as n,r,A as mt,h as o,f as s,c as a,j as nt,u as c,x as p,k as Re,y as Mt,a as l,v as m,d as M,t as u,w as y}from"../chunks/index.7cb9c9b8.js";import{C as L}from"../chunks/CodeBlock.a6d3f852.js";import{H as K,E as ut}from"../chunks/EditOnGithub.858acfec.js";function yt(Ae){let J,O,D,ee,d,te,h,Se,se,T,Xe="DIAMBRA Competition Platform allows you to submit your agents and compete with other coders around the globe in epic video games tournaments!",le,w,Ye="It features a public global leaderboard where users are ranked by the best score achieved by their agents in the different environments. It also offers you the possibility to unlock cool achievements depending on the performances of your agent. Submitted agents are evaluated and their episodes are streamed on DIAMBRA Twitch channel.",ne,b,Fe="All the details explaining how to perform a submission are described in the next sections.",ae,j,ie,U,Ne="The central element of a submission is the agent python script. An example is provided in the next code block. Its structure is always composed by two main parts: the preparation step, where the agent and the environment setup is completed, and the interaction loop, where the classical agent-environment interaction happens.",oe,g,Ee="After a first call to the reset method, you start iterating alternating action selection and environment stepping, resetting the environment when the episode is done.",pe,I,ze="There is one thing that is worth noticing: since your submission needs to be the same no matter how many episodes are needed to evaluate it, you need to implement the while loop in a way that it keeps iterating indefinitely (<code>while True:</code>) and only exits (the <code>break</code> statement) when the value <code>info[&quot;env_done&quot;]</code> is true. This value is set by the evaluation procedure and used to let the agent know that it completed. In this way, the same script can be used to run evaluations made of 3, 5, 10 or whatever number of episodes are needed, without changing a single line in the agent script.",re,f,ce,B,me,Z,Qe="The basic process to submit an agent consists in the following steps:",Me,C,$e="<li>Write a python script in which your agent interact with the environment exactly as if you were performing evaluation in your local machine</li> <li>Store your trained agent’s scripts and weights (if any) in a private repository and create a personal access token to the repository (in our examples we will use Hugging Face repository).</li> <li>Submit the agent using DIAMBRA Command Line Interface specifying your private repository files path, your secret token and one of the public pre-built dependencies images DIAMBRA provides</li>",ue,W,ye,v,He='To get the feeling of how an agent submission works, you can leverage DIAMBRA pre-built agents. In <a href="https://github.com/diambra/agents" rel="nofollow">DIAMBRA Agents repo</a>, together with different source code examples, DIAMBRA also provides <a href="https://github.com/orgs/diambra/packages?repo_name=agents" rel="nofollow">pre-built docker images (packages)</a> for some of them.',Je,k,xe='For example, <a href="https://github.com/diambra/agents/pkgs/container/agent-random-1" rel="nofollow">here</a> you find the pre-built docker image for the random agent correspondent to <a href="https://github.com/diambra/agents/blob/main/basic/random_1/agent.py" rel="nofollow">this</a> source code. As indicated by the python script settings, this random agent will play using a “Random” character in the game of choice, or in a random game if none is provided.',de,G,qe="Using this pre-built docker image you can easily perform your first submission ever on DIAMBRA platform, and appear in the official online leaderboard by simply typing in your preferred shell the following command:",he,_,Te,V,Le="After running the command, you will receive a submission confirmation, its identification number as well as the url where to see the results, something similar to the following:",we,R,be,A,je,S,De='After finishing model training as explained in the <a href="https://huggingface.co/learn/deep-rl-course/unitbonus3/training" rel="nofollow">Reinforcement Learning Training</a> section, you can create your agent script for submission as the one reported in the next code block, which will make use of the same configuration file used for training it.',Ue,X,ge,Y,Pe="Here are the steps needed to finalize the submission:",Ie,F,Ke='<li>Store your agent files (e.g. scripts, config files and weights) in a private model</li> <li>Create your personal access token (<a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">official docs here</a>):<ul><li>Log into the Hugging Face platform with your credentials.</li> <li>Click on your profile image and go to “Settings”.</li> <li>On the left side bar menu, click the “Access Token” option.</li> <li>Click on “New token” to create a new token, give it a name and assign it the “Read” permissions</li> <li>Give your token a name, select the necessary scopes (e.g., “repo” for accessing private repositories), and click “Generate token.”</li> <li>Store the generated token in your local machine (<a href="https://huggingface.co/docs/huggingface_hub/en/quick-start#login-command" rel="nofollow">official docs here</a>):<ul><li>Install the Hugging Face hub library: <code>pip install -U huggingface_hub</code></li> <li>From the terminal run the <code>login()</code> command: <code>huggingface-cli login</code>, which will tell you if you are already logged in and prompt you for your token. The token is then validated and saved in your <code>HF_HOME</code> directory (defaults to <code>~/.cache/huggingface/token</code>).</li></ul></li></ul></li> <li>Submit your AI agent:<ul><li>Choose the appropriate dependencies docker image for your submission. We provide <a href="https://github.com/orgs/diambra/packages?repo_name=arena" rel="nofollow">different pre-built ones</a> giving access to various common third party libraries</li> <li>Submit your agent via DIAMBRA CLI as shown below</li></ul></li>',fe,N,Oe="Assuming your agent uses Stable Baselines 3 as described so far, the <code>arena-stable-baselines3-on3.10-bullseye</code> dependencies image needs to be specified as a base. You have to create a file named <code>submission-manifest.yaml</code> with the following content:",Be,E,Ze,z,et="Replace <code>username</code> and <code>repository_name.git#ref=branch_name</code> with the appropriate values, and change <code>image</code> and <code>command</code> fields according to your specific use case.",Ce,Q,tt="Then, submit your agent using the manifest file:",We,$,ve,H,st='This will automatically retrieve the Hugging Face token you saved earlier and will create a new submission on <a href="https://diambra.ai" rel="nofollow">DIAMBRA Competition Platform</a>.',ke,x,lt="You will be able to see it on your dashboard just logging in with your credentials, and watch it being streamed on Twitch!",Ge,q,_e,P,Ve;return d=new K({props:{title:"DIAMBRA Competition Platform",local:"diambra-competition-platform",headingTag:"h1"}}),j=new K({props:{title:"Basic Agent Script",local:"basic-agent-script",headingTag:"h2"}}),f=new L({props:{code:"JTIzISUyRnVzciUyRmJpbiUyRmVudiUyMHB5dGhvbjMlMEFpbXBvcnQlMjBkaWFtYnJhLmFyZW5hJTBBZnJvbSUyMGRpYW1icmEuYXJlbmElMjBpbXBvcnQlMjBTcGFjZVR5cGVzJTJDJTIwUm9sZXMlMkMlMjBFbnZpcm9ubWVudFNldHRpbmdzJTBBJTBBJTIzJTIwU2V0dGluZ3MlMEFzZXR0aW5ncyUyMCUzRCUyMEVudmlyb25tZW50U2V0dGluZ3MoKSUwQXNldHRpbmdzLnN0ZXBfcmF0aW8lMjAlM0QlMjA2JTBBc2V0dGluZ3MuZnJhbWVfc2hhcGUlMjAlM0QlMjAoMTI4JTJDJTIwMTI4JTJDJTIwMSklMEFzZXR0aW5ncy5yb2xlJTIwJTNEJTIwUm9sZXMuUDIlMEFzZXR0aW5ncy5kaWZmaWN1bHR5JTIwJTNEJTIwNCUwQXNldHRpbmdzLmFjdGlvbl9zcGFjZSUyMCUzRCUyMFNwYWNlVHlwZXMuTVVMVElfRElTQ1JFVEUlMEElMEFlbnYlMjAlM0QlMjBkaWFtYnJhLmFyZW5hLm1ha2UoJTIyc2ZpaWkzbiUyMiUyQyUyMHNldHRpbmdzKSUwQW9ic2VydmF0aW9uJTJDJTIwaW5mbyUyMCUzRCUyMGVudi5yZXNldCgpJTBBJTBBd2hpbGUlMjBUcnVlJTNBJTBBJTIwJTIwJTIwJTIwYWN0aW9uJTIwJTNEJTIwZW52LmFjdGlvbl9zcGFjZS5zYW1wbGUoKSUwQSUyMCUyMCUyMCUyMG9ic2VydmF0aW9uJTJDJTIwcmV3YXJkJTJDJTIwdGVybWluYXRlZCUyQyUyMHRydW5jYXRlZCUyQyUyMGluZm8lMjAlM0QlMjBlbnYuc3RlcChhY3Rpb24pJTBBJTBBJTIwJTIwJTIwJTIwaWYlMjB0ZXJtaW5hdGVkJTIwb3IlMjB0cnVuY2F0ZWQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvYnNlcnZhdGlvbiUyQyUyMGluZm8lMjAlM0QlMjBlbnYucmVzZXQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaW5mbyU1QiUyMmVudl9kb25lJTIyJTVEJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWslMEElMEElMjMlMjBDbG9zZSUyMHRoZSUyMGVudmlyb25tZW50JTBBZW52LmNsb3NlKCk=",highlighted:`<span class="hljs-comment">#!/usr/bin/env python3</span>
<span class="hljs-keyword">import</span> diambra.arena
<span class="hljs-keyword">from</span> diambra.arena <span class="hljs-keyword">import</span> SpaceTypes, Roles, EnvironmentSettings

<span class="hljs-comment"># Settings</span>
settings = EnvironmentSettings()
settings.step_ratio = <span class="hljs-number">6</span>
settings.frame_shape = (<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">1</span>)
settings.role = Roles.P2
settings.difficulty = <span class="hljs-number">4</span>
settings.action_space = SpaceTypes.MULTI_DISCRETE

env = diambra.arena.make(<span class="hljs-string">&quot;sfiii3n&quot;</span>, settings)
observation, info = env.reset()

<span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
    action = env.action_space.sample()
    observation, reward, terminated, truncated, info = env.step(action)

    <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
        observation, info = env.reset()
        <span class="hljs-keyword">if</span> info[<span class="hljs-string">&quot;env_done&quot;</span>]:
            <span class="hljs-keyword">break</span>

<span class="hljs-comment"># Close the environment</span>
env.close()`,wrap:!1}}),B=new K({props:{title:"How To Submit An Agent",local:"how-to-submit-an-agent",headingTag:"h2"}}),W=new K({props:{title:"Submit Pre-Built Agents",local:"submit-pre-built-agents",headingTag:"h3"}}),_=new L({props:{code:"ZGlhbWJyYSUyMGFnZW50JTIwc3VibWl0JTIwZGlhbWJyYSUyRmFnZW50LXJhbmRvbS0xJTNBbWFpbiUyMC0tZ2FtZUlkJTIwc2ZpaWkzbg==",highlighted:"diambra agent submit diambra/agent-random-1:main --gameId sfiii3n",wrap:!1}}),R=new L({props:{code:"ZGlhbWJyYSUyMGFnZW50JTIwc3VibWl0JTIwZGlhbWJyYSUyRmFnZW50LXJhbmRvbS0xJTNBbWFpbiUyMC0tZ2FtZUlkJTIwc2ZpaWkzbiUwQSVGMCU5RiU5NiVBNSVFRiVCOCU4RiUyMCUyMCgxNzgpJTIwQWdlbnQlMjBzdWJtaXR0ZWQlM0ElMjBodHRwcyUzQSUyRiUyRmRpYW1icmEuYWklMkZzdWJtaXNzaW9uJTJGMTc4",highlighted:`diambra <span class="hljs-built_in">agent</span> submit diambra/<span class="hljs-built_in">agent</span>-<span class="hljs-built_in">random</span>-<span class="hljs-number">1</span>:main --gameId sfiii3n
🖥️  (<span class="hljs-number">178</span>) <span class="hljs-built_in">Agent</span> submitted: https:<span class="hljs-comment">//diambra.ai/submission/178</span>`,wrap:!1}}),A=new K({props:{title:"Submit Your Own Agent",local:"submit-your-own-agent",headingTag:"h3"}}),X=new L({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB5YW1sJTBBaW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMGFyZ3BhcnNlJTBBZnJvbSUyMGRpYW1icmEuYXJlbmElMjBpbXBvcnQlMjBSb2xlcyUyQyUyMFNwYWNlVHlwZXMlMkMlMjBsb2FkX3NldHRpbmdzX2ZsYXRfZGljdCUwQWZyb20lMjBkaWFtYnJhLmFyZW5hLnN0YWJsZV9iYXNlbGluZXMzLm1ha2Vfc2IzX2VudiUyMGltcG9ydCUyMG1ha2Vfc2IzX2VudiUyQyUyMEVudmlyb25tZW50U2V0dGluZ3MlMkMlMjBXcmFwcGVyc1NldHRpbmdzJTBBZnJvbSUyMHN0YWJsZV9iYXNlbGluZXMzJTIwaW1wb3J0JTIwUFBPJTBBJTBBZGVmJTIwbWFpbihjZmdfZmlsZSUyQyUyMHRyYWluZWRfbW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmVhZCUyMHRoZSUyMGNmZyUyMGZpbGUlMEElMjAlMjAlMjAlMjB5YW1sX2ZpbGUlMjAlM0QlMjBvcGVuKGNmZ19maWxlKSUwQSUyMCUyMCUyMCUyMHBhcmFtcyUyMCUzRCUyMHlhbWwubG9hZCh5YW1sX2ZpbGUlMkMlMjBMb2FkZXIlM0R5YW1sLkZ1bGxMb2FkZXIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyQ29uZmlnJTIwcGFyYW1ldGVycyUyMCUzRCUyMCUyMiUyQyUyMGpzb24uZHVtcHMocGFyYW1zJTJDJTIwc29ydF9rZXlzJTNEVHJ1ZSUyQyUyMGluZGVudCUzRDQpKSUwQSUyMCUyMCUyMCUyMHlhbWxfZmlsZS5jbG9zZSgpJTBBJTBBJTIwJTIwJTIwJTIwYmFzZV9wYXRoJTIwJTNEJTIwb3MucGF0aC5kaXJuYW1lKG9zLnBhdGguYWJzcGF0aChfX2ZpbGVfXykpJTBBJTIwJTIwJTIwJTIwbW9kZWxfZm9sZGVyJTIwJTNEJTIwb3MucGF0aC5qb2luKGJhc2VfcGF0aCUyQyUyMHBhcmFtcyU1QiUyMmZvbGRlcnMlMjIlNUQlNUIlMjJwYXJlbnRfZGlyJTIyJTVEJTJDJTIwcGFyYW1zJTVCJTIyc2V0dGluZ3MlMjIlNUQlNUIlMjJnYW1lX2lkJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFyYW1zJTVCJTIyZm9sZGVycyUyMiU1RCU1QiUyMm1vZGVsX25hbWUlMjIlNUQlMkMlMjAlMjJtb2RlbCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBTZXR0aW5ncyUwQSUyMCUyMCUyMCUyMHBhcmFtcyU1QiUyMnNldHRpbmdzJTIyJTVEJTVCJTIyYWN0aW9uX3NwYWNlJTIyJTVEJTIwJTNEJTIwU3BhY2VUeXBlcy5ESVNDUkVURSUyMGlmJTIwcGFyYW1zJTVCJTIyc2V0dGluZ3MlMjIlNUQlNUIlMjJhY3Rpb25fc3BhY2UlMjIlNUQlMjAlM0QlM0QlMjAlMjJkaXNjcmV0ZSUyMiUyMGVsc2UlMjBTcGFjZVR5cGVzLk1VTFRJX0RJU0NSRVRFJTBBJTIwJTIwJTIwJTIwc2V0dGluZ3MlMjAlM0QlMjBsb2FkX3NldHRpbmdzX2ZsYXRfZGljdChFbnZpcm9ubWVudFNldHRpbmdzJTJDJTIwcGFyYW1zJTVCJTIyc2V0dGluZ3MlMjIlNUQpJTBBJTIwJTIwJTIwJTIwc2V0dGluZ3Mucm9sZSUyMCUzRCUyMFJvbGVzLlAxJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwV3JhcHBlcnMlMjBTZXR0aW5ncyUwQSUyMCUyMCUyMCUyMHdyYXBwZXJzX3NldHRpbmdzJTIwJTNEJTIwbG9hZF9zZXR0aW5nc19mbGF0X2RpY3QoV3JhcHBlcnNTZXR0aW5ncyUyQyUyMHBhcmFtcyU1QiUyMndyYXBwZXJzX3NldHRpbmdzJTIyJTVEKSUwQSUyMCUyMCUyMCUyMHdyYXBwZXJzX3NldHRpbmdzLm5vcm1hbGl6ZV9yZXdhcmQlMjAlM0QlMjBGYWxzZSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMENyZWF0ZSUyMGVudmlyb25tZW50JTBBJTIwJTIwJTIwJTIwZW52JTJDJTIwbnVtX2VudnMlMjAlM0QlMjBtYWtlX3NiM19lbnYoc2V0dGluZ3MuZ2FtZV9pZCUyQyUyMHNldHRpbmdzJTJDJTIwd3JhcHBlcnNfc2V0dGluZ3MlMkMlMjBub192ZWMlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkFjdGl2YXRlZCUyMCU3QiU3RCUyMGVudmlyb25tZW50KHMpJTIyLmZvcm1hdChudW1fZW52cykpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwTG9hZCUyMHRoZSUyMHRyYWluZWQlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMG1vZGVsX3BhdGglMjAlM0QlMjBvcy5wYXRoLmpvaW4obW9kZWxfZm9sZGVyJTJDJTIwdHJhaW5lZF9tb2RlbCklMEElMjAlMjAlMjAlMjBhZ2VudCUyMCUzRCUyMFBQTy5sb2FkKG1vZGVsX3BhdGgpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUHJpbnQlMjBwb2xpY3klMjBuZXR3b3JrJTIwYXJjaGl0ZWN0dXJlJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyUG9saWN5JTIwYXJjaGl0ZWN0dXJlJTNBJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGFnZW50LnBvbGljeSklMEElMEElMjAlMjAlMjAlMjBvYnMlMkMlMjBpbmZvJTIwJTNEJTIwZW52LnJlc2V0KCklMEElMEElMjAlMjAlMjAlMjB3aGlsZSUyMFRydWUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY3Rpb24lMkMlMjBfJTIwJTNEJTIwYWdlbnQucHJlZGljdChvYnMlMkMlMjBkZXRlcm1pbmlzdGljJTNERmFsc2UpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb2JzJTJDJTIwcmV3YXJkJTJDJTIwdGVybWluYXRlZCUyQyUyMHRydW5jYXRlZCUyQyUyMGluZm8lMjAlM0QlMjBlbnYuc3RlcChhY3Rpb24udG9saXN0KCkpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjB0ZXJtaW5hdGVkJTIwb3IlMjB0cnVuY2F0ZWQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvYnMlMkMlMjBpbmZvJTIwJTNEJTIwZW52LnJlc2V0KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGluZm8lNUIlMjJlbnZfZG9uZSUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ2xvc2UlMjB0aGUlMjBlbnZpcm9ubWVudCUwQSUyMCUyMCUyMCUyMGVudi5jbG9zZSgpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmV0dXJuJTIwc3VjY2VzcyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMDAlMEElMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBwYXJzZXIlMjAlM0QlMjBhcmdwYXJzZS5Bcmd1bWVudFBhcnNlcigpJTBBJTIwJTIwJTIwJTIwcGFyc2VyLmFkZF9hcmd1bWVudCglMjItLWNmZ0ZpbGUlMjIlMkMlMjB0eXBlJTNEc3RyJTJDJTIwcmVxdWlyZWQlM0RUcnVlJTJDJTIwaGVscCUzRCUyMkNvbmZpZ3VyYXRpb24lMjBmaWxlJTIyKSUwQSUyMCUyMCUyMCUyMHBhcnNlci5hZGRfYXJndW1lbnQoJTIyLS10cmFpbmVkTW9kZWwlMjIlMkMlMjB0eXBlJTNEc3RyJTJDJTIwZGVmYXVsdCUzRCUyMm1vZGVsJTIyJTJDJTIwaGVscCUzRCUyMk1vZGVsJTIwY2hlY2twb2ludCUyMiklMEElMjAlMjAlMjAlMjBvcHQlMjAlM0QlMjBwYXJzZXIucGFyc2VfYXJncygpJTBBJTIwJTIwJTIwJTIwcHJpbnQob3B0KSUwQSUwQSUyMCUyMCUyMCUyMG1haW4ob3B0LmNmZ0ZpbGUlMkMlMjBvcHQudHJhaW5lZE1vZGVsKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> argparse
<span class="hljs-keyword">from</span> diambra.arena <span class="hljs-keyword">import</span> Roles, SpaceTypes, load_settings_flat_dict
<span class="hljs-keyword">from</span> diambra.arena.stable_baselines3.make_sb3_env <span class="hljs-keyword">import</span> make_sb3_env, EnvironmentSettings, WrappersSettings
<span class="hljs-keyword">from</span> stable_baselines3 <span class="hljs-keyword">import</span> PPO

<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>(<span class="hljs-params">cfg_file, trained_model</span>):
    <span class="hljs-comment"># Read the cfg file</span>
    yaml_file = <span class="hljs-built_in">open</span>(cfg_file)
    params = yaml.load(yaml_file, Loader=yaml.FullLoader)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Config parameters = &quot;</span>, json.dumps(params, sort_keys=<span class="hljs-literal">True</span>, indent=<span class="hljs-number">4</span>))
    yaml_file.close()

    base_path = os.path.dirname(os.path.abspath(__file__))
    model_folder = os.path.join(base_path, params[<span class="hljs-string">&quot;folders&quot;</span>][<span class="hljs-string">&quot;parent_dir&quot;</span>], params[<span class="hljs-string">&quot;settings&quot;</span>][<span class="hljs-string">&quot;game_id&quot;</span>],
                                params[<span class="hljs-string">&quot;folders&quot;</span>][<span class="hljs-string">&quot;model_name&quot;</span>], <span class="hljs-string">&quot;model&quot;</span>)

    <span class="hljs-comment"># Settings</span>
    params[<span class="hljs-string">&quot;settings&quot;</span>][<span class="hljs-string">&quot;action_space&quot;</span>] = SpaceTypes.DISCRETE <span class="hljs-keyword">if</span> params[<span class="hljs-string">&quot;settings&quot;</span>][<span class="hljs-string">&quot;action_space&quot;</span>] == <span class="hljs-string">&quot;discrete&quot;</span> <span class="hljs-keyword">else</span> SpaceTypes.MULTI_DISCRETE
    settings = load_settings_flat_dict(EnvironmentSettings, params[<span class="hljs-string">&quot;settings&quot;</span>])
    settings.role = Roles.P1

    <span class="hljs-comment"># Wrappers Settings</span>
    wrappers_settings = load_settings_flat_dict(WrappersSettings, params[<span class="hljs-string">&quot;wrappers_settings&quot;</span>])
    wrappers_settings.normalize_reward = <span class="hljs-literal">False</span>

    <span class="hljs-comment"># Create environment</span>
    env, num_envs = make_sb3_env(settings.game_id, settings, wrappers_settings, no_vec=<span class="hljs-literal">True</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Activated {} environment(s)&quot;</span>.<span class="hljs-built_in">format</span>(num_envs))

    <span class="hljs-comment"># Load the trained agent</span>
    model_path = os.path.join(model_folder, trained_model)
    agent = PPO.load(model_path)

    <span class="hljs-comment"># Print policy network architecture</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Policy architecture:&quot;</span>)
    <span class="hljs-built_in">print</span>(agent.policy)

    obs, info = env.reset()

    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
        action, _ = agent.predict(obs, deterministic=<span class="hljs-literal">False</span>)

        obs, reward, terminated, truncated, info = env.step(action.tolist())

        <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
            obs, info = env.reset()
            <span class="hljs-keyword">if</span> info[<span class="hljs-string">&quot;env_done&quot;</span>]:
                <span class="hljs-keyword">break</span>

    <span class="hljs-comment"># Close the environment</span>
    env.close()

    <span class="hljs-comment"># Return success</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">0</span>

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    parser = argparse.ArgumentParser()
    parser.add_argument(<span class="hljs-string">&quot;--cfgFile&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>, required=<span class="hljs-literal">True</span>, <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;Configuration file&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--trainedModel&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>, default=<span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;Model checkpoint&quot;</span>)
    opt = parser.parse_args()
    <span class="hljs-built_in">print</span>(opt)

    main(opt.cfgFile, opt.trainedModel)`,wrap:!1}}),E=new L({props:{code:"bW9kZSUzQSUyMEFJdnNDT00lMEFpbWFnZSUzQSUyMGRpYW1icmElMkZhcmVuYS1zdGFibGUtYmFzZWxpbmVzMy1vbjMuMTAtYnVsbHNleWUlM0FtYWluJTBBY29tbWFuZCUzQSUwQSUyMCUyMC0lMjBweXRob24lMEElMjAlMjAtJTIwJTIyJTJGc291cmNlcyUyRmFnZW50LnB5JTIyJTBBJTIwJTIwLSUyMCUyMiUyRnNvdXJjZXMlMkZjb25maWcuY2ZnJTIyJTBBJTIwJTIwLSUyMCUyMiUyRnNvdXJjZXMlMkZtb2RlbHMlMkZtb2RlbC56aXAlMjIlMEFzb3VyY2VzJTNBJTBBJTIwJTIwLiUzQSUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGdXNlcm5hbWUlM0ElN0IlN0IuU2VjcmV0cy5oZl90b2tlbiU3RCU3RCU0MGh1Z2dpbmdmYWNlLmNvJTJGdXNlcm5hbWUlMkZyZXBvc2l0b3J5X25hbWUuZ2l0JTIzcmVmJTNEYnJhbmNoX25hbWU=",highlighted:`<span class="hljs-attr">mode:</span> <span class="hljs-string">AIvsCOM</span>
<span class="hljs-attr">image:</span> <span class="hljs-string">diambra/arena-stable-baselines3-on3.10-bullseye:main</span>
<span class="hljs-attr">command:</span>
  <span class="hljs-bullet">-</span> <span class="hljs-string">python</span>
  <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;/sources/agent.py&quot;</span>
  <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;/sources/config.cfg&quot;</span>
  <span class="hljs-bullet">-</span> <span class="hljs-string">&quot;/sources/models/model.zip&quot;</span>
<span class="hljs-attr">sources:</span>
  <span class="hljs-string">.:</span> <span class="hljs-string">git+https://username:{{.Secrets.hf_token}}@huggingface.co/username/repository_name.git#ref=branch_name</span>`,wrap:!1}}),$=new L({props:{code:"ZGlhbWJyYSUyMGFnZW50JTIwc3VibWl0JTIwLS1zdWJtaXNzaW9uLnNlY3JldHMtZnJvbSUzRGh1Z2dpbmdmYWNlJTIwLS1zdWJtaXNzaW9uLm1hbmlmZXN0JTIwc3VibWlzc2lvbi1tYW5pZmVzdC55YW1s",highlighted:"diambra agent submit --submission.secrets-from=huggingface --submission.manifest submission-manifest.yaml",wrap:!1}}),q=new ut({props:{source:"https://github.com/huggingface/deep-rl-class/blob/main/units/en/unitbonus3/agent-submission.mdx"}}),{c(){J=i("meta"),O=n(),D=i("p"),ee=n(),r(d.$$.fragment),te=n(),h=i("img"),se=n(),T=i("p"),T.textContent=Xe,le=n(),w=i("p"),w.textContent=Ye,ne=n(),b=i("p"),b.textContent=Fe,ae=n(),r(j.$$.fragment),ie=n(),U=i("p"),U.textContent=Ne,oe=n(),g=i("p"),g.textContent=Ee,pe=n(),I=i("p"),I.innerHTML=ze,re=n(),r(f.$$.fragment),ce=n(),r(B.$$.fragment),me=n(),Z=i("p"),Z.textContent=Qe,Me=n(),C=i("ol"),C.innerHTML=$e,ue=n(),r(W.$$.fragment),ye=n(),v=i("p"),v.innerHTML=He,Je=n(),k=i("p"),k.innerHTML=xe,de=n(),G=i("p"),G.textContent=qe,he=n(),r(_.$$.fragment),Te=n(),V=i("p"),V.textContent=Le,we=n(),r(R.$$.fragment),be=n(),r(A.$$.fragment),je=n(),S=i("p"),S.innerHTML=De,Ue=n(),r(X.$$.fragment),ge=n(),Y=i("p"),Y.textContent=Pe,Ie=n(),F=i("ol"),F.innerHTML=Ke,fe=n(),N=i("p"),N.innerHTML=Oe,Be=n(),r(E.$$.fragment),Ze=n(),z=i("p"),z.innerHTML=et,Ce=n(),Q=i("p"),Q.textContent=tt,We=n(),r($.$$.fragment),ve=n(),H=i("p"),H.innerHTML=st,ke=n(),x=i("p"),x.textContent=lt,Ge=n(),r(q.$$.fragment),_e=n(),P=i("p"),this.h()},l(e){const t=mt("svelte-u9bgzb",document.head);J=o(t,"META",{name:!0,content:!0}),t.forEach(s),O=a(e),D=o(e,"P",{}),nt(D).forEach(s),ee=a(e),c(d.$$.fragment,e),te=a(e),h=o(e,"IMG",{src:!0,alt:!0}),se=a(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1avxdkp"&&(T.textContent=Xe),le=a(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1rf1vqa"&&(w.textContent=Ye),ne=a(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-6moheu"&&(b.textContent=Fe),ae=a(e),c(j.$$.fragment,e),ie=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-v9k1sj"&&(U.textContent=Ne),oe=a(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-n00xvb"&&(g.textContent=Ee),pe=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1t118ta"&&(I.innerHTML=ze),re=a(e),c(f.$$.fragment,e),ce=a(e),c(B.$$.fragment,e),me=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-h19ec3"&&(Z.textContent=Qe),Me=a(e),C=o(e,"OL",{"data-svelte-h":!0}),p(C)!=="svelte-1egkya8"&&(C.innerHTML=$e),ue=a(e),c(W.$$.fragment,e),ye=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-hzrrn2"&&(v.innerHTML=He),Je=a(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-8m6fe7"&&(k.innerHTML=xe),de=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1q6h87s"&&(G.textContent=qe),he=a(e),c(_.$$.fragment,e),Te=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1snqyu6"&&(V.textContent=Le),we=a(e),c(R.$$.fragment,e),be=a(e),c(A.$$.fragment,e),je=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-jpybla"&&(S.innerHTML=De),Ue=a(e),c(X.$$.fragment,e),ge=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1qoekjt"&&(Y.textContent=Pe),Ie=a(e),F=o(e,"OL",{"data-svelte-h":!0}),p(F)!=="svelte-je8yh1"&&(F.innerHTML=Ke),fe=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1s6z56c"&&(N.innerHTML=Oe),Be=a(e),c(E.$$.fragment,e),Ze=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1ms2e16"&&(z.innerHTML=et),Ce=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-76syy3"&&(Q.textContent=tt),We=a(e),c($.$$.fragment,e),ve=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-17xsp3s"&&(H.innerHTML=st),ke=a(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-dpc1au"&&(x.textContent=lt),Ge=a(e),c(q.$$.fragment,e),_e=a(e),P=o(e,"P",{}),nt(P).forEach(s),this.h()},h(){Re(J,"name","hf:doc:metadata"),Re(J,"content",Jt),it(h.src,Se="https://raw.githubusercontent.com/diambra/.github/master/img/platform.jpg")||Re(h,"src",Se),Re(h,"alt","Unit bonus 3 thumbnail")},m(e,t){Mt(document.head,J),l(e,O,t),l(e,D,t),l(e,ee,t),m(d,e,t),l(e,te,t),l(e,h,t),l(e,se,t),l(e,T,t),l(e,le,t),l(e,w,t),l(e,ne,t),l(e,b,t),l(e,ae,t),m(j,e,t),l(e,ie,t),l(e,U,t),l(e,oe,t),l(e,g,t),l(e,pe,t),l(e,I,t),l(e,re,t),m(f,e,t),l(e,ce,t),m(B,e,t),l(e,me,t),l(e,Z,t),l(e,Me,t),l(e,C,t),l(e,ue,t),m(W,e,t),l(e,ye,t),l(e,v,t),l(e,Je,t),l(e,k,t),l(e,de,t),l(e,G,t),l(e,he,t),m(_,e,t),l(e,Te,t),l(e,V,t),l(e,we,t),m(R,e,t),l(e,be,t),m(A,e,t),l(e,je,t),l(e,S,t),l(e,Ue,t),m(X,e,t),l(e,ge,t),l(e,Y,t),l(e,Ie,t),l(e,F,t),l(e,fe,t),l(e,N,t),l(e,Be,t),m(E,e,t),l(e,Ze,t),l(e,z,t),l(e,Ce,t),l(e,Q,t),l(e,We,t),m($,e,t),l(e,ve,t),l(e,H,t),l(e,ke,t),l(e,x,t),l(e,Ge,t),m(q,e,t),l(e,_e,t),l(e,P,t),Ve=!0},p:ot,i(e){Ve||(M(d.$$.fragment,e),M(j.$$.fragment,e),M(f.$$.fragment,e),M(B.$$.fragment,e),M(W.$$.fragment,e),M(_.$$.fragment,e),M(R.$$.fragment,e),M(A.$$.fragment,e),M(X.$$.fragment,e),M(E.$$.fragment,e),M($.$$.fragment,e),M(q.$$.fragment,e),Ve=!0)},o(e){u(d.$$.fragment,e),u(j.$$.fragment,e),u(f.$$.fragment,e),u(B.$$.fragment,e),u(W.$$.fragment,e),u(_.$$.fragment,e),u(R.$$.fragment,e),u(A.$$.fragment,e),u(X.$$.fragment,e),u(E.$$.fragment,e),u($.$$.fragment,e),u(q.$$.fragment,e),Ve=!1},d(e){e&&(s(O),s(D),s(ee),s(te),s(h),s(se),s(T),s(le),s(w),s(ne),s(b),s(ae),s(ie),s(U),s(oe),s(g),s(pe),s(I),s(re),s(ce),s(me),s(Z),s(Me),s(C),s(ue),s(ye),s(v),s(Je),s(k),s(de),s(G),s(he),s(Te),s(V),s(we),s(be),s(je),s(S),s(Ue),s(ge),s(Y),s(Ie),s(F),s(fe),s(N),s(Be),s(Ze),s(z),s(Ce),s(Q),s(We),s(ve),s(H),s(ke),s(x),s(Ge),s(_e),s(P)),s(J),y(d,e),y(j,e),y(f,e),y(B,e),y(W,e),y(_,e),y(R,e),y(A,e),y(X,e),y(E,e),y($,e),y(q,e)}}}const Jt='{"title":"DIAMBRA Competition Platform","local":"diambra-competition-platform","sections":[{"title":"Basic Agent Script","local":"basic-agent-script","sections":[],"depth":2},{"title":"How To Submit An Agent","local":"how-to-submit-an-agent","sections":[{"title":"Submit Pre-Built Agents","local":"submit-pre-built-agents","sections":[],"depth":3},{"title":"Submit Your Own Agent","local":"submit-your-own-agent","sections":[],"depth":3}],"depth":2}],"depth":1}';function dt(Ae){return pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jt extends rt{constructor(J){super(),ct(this,J,dt,yt,at,{})}}export{jt as component};
