import{s as ks,n as Ws,o as Bs}from"../chunks/scheduler.85c25b89.js";import{S as xs,i as Ns,g as p,s as a,r as i,A as Es,h as m,f as l,c as n,j as Zs,u as o,x as h,k as $s,y as Gs,a as e,v as r,d as M,t as c,w as J}from"../chunks/index.c9837788.js";import{C as v}from"../chunks/CodeBlock.52fa569e.js";import{H as S,E as Rs}from"../chunks/EditOnGithub.b65eee75.js";function As(ws){let w,Y,V,H,T,X,j,Ts='<strong>Residual Networks</strong>, or <strong>ResNets</strong>, learn residual functions with reference to the layer inputs, instead of learning unreferenced functions. Instead of hoping each few stacked layers directly fit a desired underlying mapping, residual nets let these layers fit a residual mapping. They stack <a href="https://paperswithcode.com/method/residual-block" rel="nofollow">residual blocks</a> ontop of each other to form network: e.g. a ResNet-50 has fifty layers using these blocks.',z,g,js='The weights from this model were ported from <a href="https://cv.gluon.ai/model_zoo/classification.html" rel="nofollow">Gluon</a>.',F,y,D,d,gs="To load a pretrained model:",L,u,q,b,ys="To load and preprocess the image:",P,f,K,U,ds="To get the model predictions:",O,I,ss,C,us="To get the top-5 predictions class names:",ts,Z,ls,$,bs="Replace the model name with the variant you want to use, e.g. <code>gluon_resnet101_v1b</code>. You can find the IDs in the model summaries at the top of this page.",es,k,fs='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',as,W,ns,B,Us="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ps,x,ms,N,Is=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,is,E,os,G,Cs='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',rs,R,Ms,A,cs,Q,Js,_,hs;return T=new S({props:{title:"(Gluon) ResNet",local:"gluon-resnet",headingTag:"h1"}}),y=new S({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new v({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2dsdW9uX3Jlc25ldDEwMV92MWInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_resnet101_v1b&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new v({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new v({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new S({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),x=new v({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZ2x1b25fcmVzbmV0MTAxX3YxYiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_resnet101_v1b&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),E=new S({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),R=new S({props:{title:"Citation",local:"citation",headingTag:"h2"}}),A=new v({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZIZVpSUzE1JTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCS2FpbWluZyUyMEhlJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwWGlhbmd5dSUyMFpoYW5nJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwU2hhb3FpbmclMjBSZW4lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBKaWFuJTIwU3VuJTdEJTJDJTBBJTIwJTIwdGl0bGUlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JEZWVwJTIwUmVzaWR1YWwlMjBMZWFybmluZyUyMGZvciUyMEltYWdlJTIwUmVjb2duaXRpb24lN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE1MTIuMDMzODUlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxNSU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxNTEyLjAzMzg1JTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTUxMi4wMzM4NSU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3QldlZCUyQyUyMDE3JTIwQXByJTIwMjAxOSUyMDE3JTNBMjMlM0E0NSUyMCUyQjAyMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGSGVaUlMxNS5iaWIlN0QlMkMlMEElMjAlMjBiaWJzb3VyY2UlMjAlM0QlMjAlN0JkYmxwJTIwY29tcHV0ZXIlMjBzY2llbmNlJTIwYmlibGlvZ3JhcGh5JTJDJTIwaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyU3RCUwQSU3RA==",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>HeZRS15,
  author    = {Kaiming He and
               Xiangyu Zhang and
               Shaoqing Ren and
               Jian Sun},
  title     = {Deep Residual Learning <span class="hljs-keyword">for</span> Image Recognition},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1512.03385</span>},
  year      = {<span class="hljs-number">2015</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1512.03385</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1512.03385</span>},
  timestamp = {Wed, <span class="hljs-number">17</span> Apr <span class="hljs-number">2019</span> <span class="hljs-number">17</span>:<span class="hljs-number">23</span>:<span class="hljs-number">45</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>HeZRS15.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),Q=new Rs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/gloun-resnet.mdx"}}),{c(){w=p("meta"),Y=a(),V=p("p"),H=a(),i(T.$$.fragment),X=a(),j=p("p"),j.innerHTML=Ts,z=a(),g=p("p"),g.innerHTML=js,F=a(),i(y.$$.fragment),D=a(),d=p("p"),d.textContent=gs,L=a(),i(u.$$.fragment),q=a(),b=p("p"),b.textContent=ys,P=a(),i(f.$$.fragment),K=a(),U=p("p"),U.textContent=ds,O=a(),i(I.$$.fragment),ss=a(),C=p("p"),C.textContent=us,ts=a(),i(Z.$$.fragment),ls=a(),$=p("p"),$.innerHTML=bs,es=a(),k=p("p"),k.innerHTML=fs,as=a(),i(W.$$.fragment),ns=a(),B=p("p"),B.textContent=Us,ps=a(),i(x.$$.fragment),ms=a(),N=p("p"),N.innerHTML=Is,is=a(),i(E.$$.fragment),os=a(),G=p("p"),G.innerHTML=Cs,rs=a(),i(R.$$.fragment),Ms=a(),i(A.$$.fragment),cs=a(),i(Q.$$.fragment),Js=a(),_=p("p"),this.h()},l(s){const t=Es("svelte-u9bgzb",document.head);w=m(t,"META",{name:!0,content:!0}),t.forEach(l),Y=n(s),V=m(s,"P",{}),Zs(V).forEach(l),H=n(s),o(T.$$.fragment,s),X=n(s),j=m(s,"P",{"data-svelte-h":!0}),h(j)!=="svelte-p6ybkz"&&(j.innerHTML=Ts),z=n(s),g=m(s,"P",{"data-svelte-h":!0}),h(g)!=="svelte-1vag5uc"&&(g.innerHTML=js),F=n(s),o(y.$$.fragment,s),D=n(s),d=m(s,"P",{"data-svelte-h":!0}),h(d)!=="svelte-18ywhxh"&&(d.textContent=gs),L=n(s),o(u.$$.fragment,s),q=n(s),b=m(s,"P",{"data-svelte-h":!0}),h(b)!=="svelte-1c2ipa8"&&(b.textContent=ys),P=n(s),o(f.$$.fragment,s),K=n(s),U=m(s,"P",{"data-svelte-h":!0}),h(U)!=="svelte-1n9qsq1"&&(U.textContent=ds),O=n(s),o(I.$$.fragment,s),ss=n(s),C=m(s,"P",{"data-svelte-h":!0}),h(C)!=="svelte-19cnvx1"&&(C.textContent=us),ts=n(s),o(Z.$$.fragment,s),ls=n(s),$=m(s,"P",{"data-svelte-h":!0}),h($)!=="svelte-frqp5b"&&($.innerHTML=bs),es=n(s),k=m(s,"P",{"data-svelte-h":!0}),h(k)!=="svelte-1wmi3ea"&&(k.innerHTML=fs),as=n(s),o(W.$$.fragment,s),ns=n(s),B=m(s,"P",{"data-svelte-h":!0}),h(B)!=="svelte-9sr7nh"&&(B.textContent=Us),ps=n(s),o(x.$$.fragment,s),ms=n(s),N=m(s,"P",{"data-svelte-h":!0}),h(N)!=="svelte-1kguc51"&&(N.innerHTML=Is),is=n(s),o(E.$$.fragment,s),os=n(s),G=m(s,"P",{"data-svelte-h":!0}),h(G)!=="svelte-1n0coha"&&(G.innerHTML=Cs),rs=n(s),o(R.$$.fragment,s),Ms=n(s),o(A.$$.fragment,s),cs=n(s),o(Q.$$.fragment,s),Js=n(s),_=m(s,"P",{}),Zs(_).forEach(l),this.h()},h(){$s(w,"name","hf:doc:metadata"),$s(w,"content",Qs)},m(s,t){Gs(document.head,w),e(s,Y,t),e(s,V,t),e(s,H,t),r(T,s,t),e(s,X,t),e(s,j,t),e(s,z,t),e(s,g,t),e(s,F,t),r(y,s,t),e(s,D,t),e(s,d,t),e(s,L,t),r(u,s,t),e(s,q,t),e(s,b,t),e(s,P,t),r(f,s,t),e(s,K,t),e(s,U,t),e(s,O,t),r(I,s,t),e(s,ss,t),e(s,C,t),e(s,ts,t),r(Z,s,t),e(s,ls,t),e(s,$,t),e(s,es,t),e(s,k,t),e(s,as,t),r(W,s,t),e(s,ns,t),e(s,B,t),e(s,ps,t),r(x,s,t),e(s,ms,t),e(s,N,t),e(s,is,t),r(E,s,t),e(s,os,t),e(s,G,t),e(s,rs,t),r(R,s,t),e(s,Ms,t),r(A,s,t),e(s,cs,t),r(Q,s,t),e(s,Js,t),e(s,_,t),hs=!0},p:Ws,i(s){hs||(M(T.$$.fragment,s),M(y.$$.fragment,s),M(u.$$.fragment,s),M(f.$$.fragment,s),M(I.$$.fragment,s),M(Z.$$.fragment,s),M(W.$$.fragment,s),M(x.$$.fragment,s),M(E.$$.fragment,s),M(R.$$.fragment,s),M(A.$$.fragment,s),M(Q.$$.fragment,s),hs=!0)},o(s){c(T.$$.fragment,s),c(y.$$.fragment,s),c(u.$$.fragment,s),c(f.$$.fragment,s),c(I.$$.fragment,s),c(Z.$$.fragment,s),c(W.$$.fragment,s),c(x.$$.fragment,s),c(E.$$.fragment,s),c(R.$$.fragment,s),c(A.$$.fragment,s),c(Q.$$.fragment,s),hs=!1},d(s){s&&(l(Y),l(V),l(H),l(X),l(j),l(z),l(g),l(F),l(D),l(d),l(L),l(q),l(b),l(P),l(K),l(U),l(O),l(ss),l(C),l(ts),l(ls),l($),l(es),l(k),l(as),l(ns),l(B),l(ps),l(ms),l(N),l(is),l(os),l(G),l(rs),l(Ms),l(cs),l(Js),l(_)),l(w),J(T,s),J(y,s),J(u,s),J(f,s),J(I,s),J(Z,s),J(W,s),J(x,s),J(E,s),J(R,s),J(A,s),J(Q,s)}}}const Qs='{"title":"(Gluon) ResNet","local":"gluon-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function vs(ws){return Bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends xs{constructor(w){super(),Ns(this,w,vs,As,ks,{})}}export{Hs as component};
