import{s as en,n as nn,o as an}from"../chunks/scheduler.a2b4ca8e.js";import{S as ln,i as sn,g as i,s as l,r as p,A as on,h as o,f as n,c as s,j as Oe,u as c,x as r,k as tn,y as rn,a,v as m,d,t as u,w as M}from"../chunks/index.d2f673cc.js";import{C as h}from"../chunks/CodeBlock.792343a6.js";import{H as ht}from"../chunks/Heading.675d4c1e.js";function pn(we){let y,yt,ut,wt,w,Tt,T,Te='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/text-classification/notebook.ipynb" rel="nofollow">here</a></em>.',ft,f,fe='This tutorial will help you to get started with <a href="https://aws.amazon.com/machine-learning/trainium/?nc1=h_ls" rel="nofollow">AWS Trainium</a> and Hugging Face Transformers. It will cover how to set up a Trainium instance on AWS, load &amp; fine-tune a transformers model for text-classification',Ut,U,Ue="You will learn how to:",Jt,J,Je='<li><a href="#1-setup-aws-environment">Setup AWS environment</a></li> <li><a href="#2-load-and-process-the-dataset">Load and process the dataset</a></li> <li><a href="#3-fine-tune-bert-using-hugging-face-transformers">Fine-tune BERT using Hugging Face Transformers and Optimum Neuron</a></li>',gt,g,ge='Before we can start, make sure you have a <a href="https://huggingface.co/join" rel="nofollow">Hugging Face Account</a> to save artifacts and experiments.',bt,b,Ct,C,be='<a href="https://aws.amazon.com/de/ec2/instance-types/trn1/" rel="nofollow">AWS Trainium (Trn1)</a> is a purpose-built EC2 for deep learning (DL) training workloads. Trainium is the successor of <a href="https://aws.amazon.com/ec2/instance-types/inf1/?nc1=h_ls" rel="nofollow">AWS Inferentia</a> focused on high-performance training workloads claiming up to 50% cost-to-train savings over comparable GPU-based instances.',jt,j,Ce="Trainium has been optimized for training natural language processing, computer vision, and recommender models used. The accelerator supports a wide range of data types, including FP32, TF32, BF16, FP16, UINT8, and configurable FP8.",It,I,je='The biggest Trainium instance, the <code>trn1.32xlarge</code> comes with over 500GB of memory, making it easy to fine-tune ~10B parameter models on a single instance. Below you will find an overview of the available instance types. More details <a href="https://aws.amazon.com/de/ec2/instance-types/trn1/#Product_details" rel="nofollow">here</a>:',vt,v,Ie="<thead><tr><th>instance size</th> <th>accelerators</th> <th>accelerator memory</th> <th>vCPU</th> <th>CPU Memory</th> <th>price per hour</th></tr></thead> <tbody><tr><td>trn1.2xlarge</td> <td>1</td> <td>32</td> <td>8</td> <td>32</td> <td>$1.34</td></tr> <tr><td>trn1.32xlarge</td> <td>16</td> <td>512</td> <td>128</td> <td>512</td> <td>$21.50</td></tr> <tr><td>trn1n.32xlarge (2x bandwidth)</td> <td>16</td> <td>512</td> <td>128</td> <td>512</td> <td>$24.78</td></tr></tbody>",Wt,Bt,_t,W,ve="Now we know what Trainium offers, let’s get started. 🚀",Gt,B,We="<em>Note: This tutorial was created on a trn1.2xlarge AWS EC2 Instance.</em>",Zt,_,kt,G,Be='In this example, we will use the <code>trn1.2xlarge</code> instance on AWS with 1 Accelerator, including two Neuron Cores and the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a>.',Ft,Z,_e='This blog post doesn’t cover how to create the instance in detail. You can check out my previous blog about <a href="https://www.philschmid.de/setup-aws-trainium" rel="nofollow">“Setting up AWS Trainium for Hugging Face Transformers”</a>, which includes a step-by-step guide on setting up the environment.',Rt,k,Ge="Once the instance is up and running, we can ssh into it. But instead of developing inside a terminal we want to use a <code>Jupyter</code> environment, which we can use for preparing our dataset and launching the training. For this, we need to add a port for forwarding in the <code>ssh</code> command, which will tunnel our localhost traffic to the Trainium instance.",Xt,F,$t,R,Ze="We can now start our <strong><code>jupyter</code></strong> server.",xt,X,Ht,$,ke="You should see a familiar <strong><code>jupyter</code></strong> output with a URL to the notebook.",Qt,x,Fe="<strong><code>http://localhost:8080/?token=8c1739aff1755bd7958c4cfccc8d08cb5da5234f61f129a9</code></strong>",Yt,H,Re="We can click on it, and a <strong><code>jupyter</code></strong> environment opens in our local browser.",Vt,Q,Xe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/optimum/neuron/tutorial-fine-tune-bert-jupyter.png" alt="jupyter.webp"/>',zt,Y,$e="We are going to use the Jupyter environment only for preparing the dataset and then <code>torchrun</code> for launching our training script on both neuron cores for distributed training. Lets create a new notebook and get started.",At,V,Nt,z,xe='We are training a Text Classification model on the <a href="https://huggingface.co/datasets/philschmid/emotion" rel="nofollow">emotion</a> dataset to keep the example straightforward. The <code>emotion</code> is a dataset of English Twitter messages with six basic emotions: anger, fear, joy, love, sadness, and surprise.',St,A,He='We will use the <code>load_dataset()</code> method from the <a href="https://huggingface.co/docs/datasets/index" rel="nofollow">🤗 Datasets</a> library to load the <code>emotion</code>.',Lt,N,Et,S,Qe="Let’s check out an example of the dataset.",Pt,L,qt,E,Ye='We must convert our “Natural Language” to token IDs to train our model. This is done by a Tokenizer, which tokenizes the inputs (including converting the tokens to their corresponding IDs in the pre-trained vocabulary). if you want to learn more about this, out <a href="https://huggingface.co/course/chapter6/1?fw=pt" rel="nofollow">chapter 6</a> of the <a href="https://huggingface.co/course/chapter1/1" rel="nofollow">Hugging Face Course</a>.',Dt,P,Ve="Our Neuron Accelerator expects a fixed shape of inputs. We need to truncate or pad all samples to the same length.",Kt,q,Ot,D,te,K,ze='Normally you would use the <a href="https://huggingface.co/docs/transformers/v4.19.4/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> and <a href="https://huggingface.co/docs/transformers/v4.19.4/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> to fine-tune PyTorch-based transformer models.',ee,O,Ae='But together with AWS, we have developed a <a href="https://huggingface.co/docs/optimum-neuron/package_reference/trainer" rel="nofollow">NeuronTrainer</a> to improve performance, robustness, and safety when training on Trainium or Inferentia2 instances. The <code>NeuronTrainer</code> also comes with a <a href="https://www.notion.so/Getting-started-with-AWS-Trainium-and-Hugging-Face-Transformers-8428c72556194aed9c393de101229dcf" rel="nofollow">model cache</a>, which allows us to use precompiled models and configuration from Hugging Face Hub to skip the compilation step, which would be needed at the beginning of training. This can reduce the training time by ~3x.',ne,tt,Ne="The <code>NeuronTrainer</code> is part of the <code>optimum-neuron</code> library and can be used as a 1-to-1 replacement for the <code>Trainer</code>. You only have to adjust the import in your training script.",ae,et,le,nt,Se='We prepared a simple <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/text-classification/scripts/train.py" rel="nofollow">train.py</a> training script based on the <a href="https://www.philschmid.de/getting-started-pytorch-2-0-transformers#3-fine-tune--evaluate-bert-model-with-the-hugging-face-trainer" rel="nofollow">“Getting started with Pytorch 2.0 and Hugging Face Transformers”</a> blog post with the <code>NeuronTrainer</code>. Below is an excerpt',se,at,ie,lt,Le='We can load the training script into our environment using the <code>wget</code> command or manually copy it into the notebook from <a href="https://github.com/huggingface/optimum-neuron/blob/notebooks/text-classification/scripts/train.py" rel="nofollow">here</a>.',oe,st,re,it,Ee="We will use <code>torchrun</code> to launch our training script on both neuron cores for distributed training. <code>torchrun</code> is a tool that automatically distributes a PyTorch model across multiple accelerators. We can pass the number of accelerators as <code>nproc_per_node</code> arguments alongside our hyperparameters.",pe,ot,Pe="We’ll use the following command to launch training:",ce,rt,me,pt,qe="<em><strong>Note</strong>: If you see bad, bad accuracy, you might want to deactivate <code>bf16</code> for now.</em>",de,ct,De="After 9 minutes the training was completed and achieved an excellent f1 score of <code>0.914</code>.",ue,mt,Me,dt,Ke="Last but not least, terminate the EC2 instance to avoid unnecessary charges. Looking at the price-performance, our training only cost <strong><code>20ct</code></strong> (<strong><code>1.34$/h * 0.15h = 0.20$</code></strong>)",he,Mt,ye;return w=new ht({props:{title:"Fine-tune BERT for Text Classification on AWS Trainium",local:"fine-tune-bert-for-text-classification-on-aws-trainium",headingTag:"h1"}}),b=new ht({props:{title:"Quick intro: AWS Trainium",local:"quick-intro-aws-trainium",headingTag:"h2"}}),_=new ht({props:{title:"1. Setup AWS environment",local:"1-setup-aws-environment",headingTag:"h2"}}),F=new h({props:{code:"UFVCTElDX0ROUyUzRCUyMiUyMiUyMCUyMyUyMElQJTIwYWRkcmVzcyUyQyUyMGUuZy4lMjBlYzItMy04MC0uLi4uJTBBS0VZX1BBVEglM0QlMjIlMjIlMjAlMjMlMjBsb2NhbCUyMHBhdGglMjB0byUyMGtleSUyQyUyMGUuZy4lMjBzc2glMkZ0cm4ucGVtJTBBJTBBc3NoJTIwLUwlMjA4MDgwJTNBbG9jYWxob3N0JTNBODA4MCUyMC1pJTIwJTI0JTdCS0VZX05BTUUlN0QucGVtJTIwdWJ1bnR1JTQwJTI0UFVCTElDX0ROUw==",highlighted:`PUBLIC_DNS=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># IP address, e.g. ec2-3-80-....</span>
KEY_PATH=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># local path to key, e.g. ssh/trn.pem</span>

ssh -L 8080:localhost:8080 -i <span class="hljs-variable">\${KEY_NAME}</span>.pem ubuntu@<span class="hljs-variable">$PUBLIC_DNS</span>`,wrap:!1}}),X=new h({props:{code:"cHl0aG9uJTIwLW0lMjBub3RlYm9vayUyMC0tYWxsb3ctcm9vdCUyMC0tcG9ydCUzRDgwODA=",highlighted:"python -m notebook --allow-root --port=8080",wrap:!1}}),V=new ht({props:{title:"2. Load and process the dataset",local:"2-load-and-process-the-dataset",headingTag:"h2"}}),N=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBJTIzJTIwRGF0YXNldCUyMGlkJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldCUwQWRhdGFzZXRfaWQlMjAlM0QlMjAlMjJwaGlsc2NobWlkJTJGZW1vdGlvbiUyMiUwQSUwQSUyMyUyMExvYWQlMjByYXclMjBkYXRhc2V0JTBBcmF3X2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoZGF0YXNldF9pZCklMEElMEFwcmludChmJTIyVHJhaW4lMjBkYXRhc2V0JTIwc2l6ZSUzQSUyMCU3QmxlbihyYXdfZGF0YXNldCU1Qid0cmFpbiclNUQpJTdEJTIyKSUwQXByaW50KGYlMjJUZXN0JTIwZGF0YXNldCUyMHNpemUlM0ElMjAlN0JsZW4ocmF3X2RhdGFzZXQlNUIndGVzdCclNUQpJTdEJTIyKSUwQSUwQSUyMyUyMFRyYWluJTIwZGF0YXNldCUyMHNpemUlM0ElMjAxNjAwMCUwQSUyMyUyMFRlc3QlMjBkYXRhc2V0JTIwc2l6ZSUzQSUyMDIwMDA=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Dataset id from huggingface.co/dataset</span>
dataset_id = <span class="hljs-string">&quot;philschmid/emotion&quot;</span>

<span class="hljs-comment"># Load raw dataset</span>
raw_dataset = load_dataset(dataset_id)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Train dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(raw_dataset[<span class="hljs-string">&#x27;train&#x27;</span>])}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Test dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(raw_dataset[<span class="hljs-string">&#x27;test&#x27;</span>])}</span>&quot;</span>)

<span class="hljs-comment"># Train dataset size: 16000</span>
<span class="hljs-comment"># Test dataset size: 2000</span>`,wrap:!1}}),L=new h({props:{code:"ZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRyYW5nZSUwQSUwQXJhbmRvbV9pZCUyMCUzRCUyMHJhbmRyYW5nZShsZW4ocmF3X2RhdGFzZXQlNUIndHJhaW4nJTVEKSklMEFyYXdfZGF0YXNldCU1Qid0cmFpbiclNUQlNUJyYW5kb21faWQlNUQlMEElMjMlMjAlN0IndGV4dCclM0ElMjAnaSUyMGZlZWwlMjBpc29sYXRlZCUyMGFuZCUyMGFsb25lJTIwaW4lMjBteSUyMHRyYWRlJyUyQyUyMCdsYWJlbCclM0ElMjAwJTdE",highlighted:`<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randrange

random_id = randrange(<span class="hljs-built_in">len</span>(raw_dataset[<span class="hljs-string">&#x27;train&#x27;</span>]))
raw_dataset[<span class="hljs-string">&#x27;train&#x27;</span>][random_id]
<span class="hljs-comment"># {&#x27;text&#x27;: &#x27;i feel isolated and alone in my trade&#x27;, &#x27;label&#x27;: 0}</span>`,wrap:!1}}),q=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFpbXBvcnQlMjBvcyUwQSUyMyUyME1vZGVsJTIwaWQlMjB0byUyMGxvYWQlMjB0aGUlMjB0b2tlbml6ZXIlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTBBc2F2ZV9kYXRhc2V0X3BhdGglMjAlM0QlMjAlMjJsbV9kYXRhc2V0JTIyJTBBJTIzJTIwTG9hZCUyMFRva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUwQSUyMyUyMFRva2VuaXplJTIwaGVscGVyJTIwZnVuY3Rpb24lMEFkZWYlMjB0b2tlbml6ZShiYXRjaCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIoYmF0Y2glNUIndGV4dCclNUQlMkMlMjBwYWRkaW5nJTNEJ21heF9sZW5ndGgnJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkNyZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFRva2VuaXplJTIwZGF0YXNldCUwQXJhd19kYXRhc2V0JTIwJTNEJTIwJTIwcmF3X2RhdGFzZXQucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMjAlMjMlMjB0byUyMG1hdGNoJTIwVHJhaW5lciUwQXRva2VuaXplZF9kYXRhc2V0JTIwJTNEJTIwcmF3X2RhdGFzZXQubWFwKHRva2VuaXplJTJDJTIwYmF0Y2hlZCUzRFRydWUlMkMlMjByZW1vdmVfY29sdW1ucyUzRCU1QiUyMnRleHQlMjIlNUQpJTBBdG9rZW5pemVkX2RhdGFzZXQlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldC53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiklMEElMEElMjMlMjBzYXZlJTIwZGF0YXNldCUyMHRvJTIwZGlzayUwQXRva2VuaXplZF9kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQuc2F2ZV90b19kaXNrKG9zLnBhdGguam9pbihzYXZlX2RhdGFzZXRfcGF0aCUyQyUyMnRyYWluJTIyKSklMEF0b2tlbml6ZWRfZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQuc2F2ZV90b19kaXNrKG9zLnBhdGguam9pbihzYXZlX2RhdGFzZXRfcGF0aCUyQyUyMmV2YWwlMjIpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">import</span> os
<span class="hljs-comment"># Model id to load the tokenizer</span>
model_id = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
save_dataset_path = <span class="hljs-string">&quot;lm_dataset&quot;</span>
<span class="hljs-comment"># Load Tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-comment"># Tokenize helper function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">batch</span>):
    <span class="hljs-keyword">return</span> tokenizer(batch[<span class="hljs-string">&#x27;text&#x27;</span>], padding=<span class="hljs-string">&#x27;max_length&#x27;</span>, truncation=<span class="hljs-literal">True</span>,return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-comment"># Tokenize dataset</span>
raw_dataset =  raw_dataset.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>) <span class="hljs-comment"># to match Trainer</span>
tokenized_dataset = raw_dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">True</span>, remove_columns=[<span class="hljs-string">&quot;text&quot;</span>])
tokenized_dataset = tokenized_dataset.with_format(<span class="hljs-string">&quot;torch&quot;</span>)

<span class="hljs-comment"># save dataset to disk</span>
tokenized_dataset[<span class="hljs-string">&quot;train&quot;</span>].save_to_disk(os.path.join(save_dataset_path,<span class="hljs-string">&quot;train&quot;</span>))
tokenized_dataset[<span class="hljs-string">&quot;test&quot;</span>].save_to_disk(os.path.join(save_dataset_path,<span class="hljs-string">&quot;eval&quot;</span>))`,wrap:!1}}),D=new ht({props:{title:"3. Fine-tune BERT using Hugging Face Transformers",local:"3-fine-tune-bert-using-hugging-face-transformers",headingTag:"h2"}}),et=new h({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUcmFpbmVyJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMEElMkIlMjBmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25UcmFpbmVyJTIwYXMlMjBUcmFpbmVyJTBBJTJCJTIwZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5pbmdBcmd1bWVudHMlMjBhcyUyMFRyYWluaW5nQXJndW1lbnRz",highlighted:`<span class="hljs-deletion">- from transformers import Trainer, TrainingArguments</span>
<span class="hljs-addition">+ from optimum.neuron import NeuronTrainer as Trainer</span>
<span class="hljs-addition">+ from optimum.neuron import NeuronTrainingArguments as TrainingArguments</span>`,wrap:!1}}),at=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5lciUyMGFzJTIwVHJhaW5lciUwQSUwQWRlZiUyMHBhcnNlX2FyZ3MoKSUzQSUwQSUwOS4uLiUwQSUwQWRlZiUyMHRyYWluaW5nX2Z1bmN0aW9uKGFyZ3MpJTNBJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwbG9hZCUyMGRhdGFzZXQlMjBmcm9tJTIwZGlzayUyMGFuZCUyMHRva2VuaXplciUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2Zyb21fZGlzayhvcy5wYXRoLmpvaW4oYXJncy5kYXRhc2V0X3BhdGglMkMlMjAlMjJ0cmFpbiUyMikpJTBBJTA5JTA5Li4uJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRG93bmxvYWQlMjB0aGUlMjBtb2RlbCUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyRm1vZGVscyUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJncy5tb2RlbF9pZCUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUwOSUwOSUwOS4uLiUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBDcmVhdGUlMjBUcmFpbmVyJTIwaW5zdGFuY2UlMEElMjAlMjAlMjAlMjB0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGV2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBTdGFydCUyMHRyYWluaW5nJTBBJTIwJTIwJTIwJTIwdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainer <span class="hljs-keyword">as</span> Trainer

<span class="hljs-keyword">def</span> <span class="hljs-title function_">parse_args</span>():
	...

<span class="hljs-keyword">def</span> <span class="hljs-title function_">training_function</span>(<span class="hljs-params">args</span>):

    <span class="hljs-comment"># load dataset from disk and tokenizer</span>
    train_dataset = load_from_disk(os.path.join(args.dataset_path, <span class="hljs-string">&quot;train&quot;</span>))
		...

    <span class="hljs-comment"># Download the model from huggingface.co/models</span>
    model = AutoModelForSequenceClassification.from_pretrained(
        args.model_id, num_labels=num_labels, label2id=label2id, id2label=id2label
    )

    training_args = TrainingArguments(
			...
    )

    <span class="hljs-comment"># Create Trainer instance</span>
    trainer = Trainer(
        model=model,
        args=training_args,
        train_dataset=train_dataset,
        eval_dataset=eval_dataset,
        compute_metrics=compute_metrics,
    )

    <span class="hljs-comment"># Start training</span>
    trainer.train()`,wrap:!1}}),st=new h({props:{code:"IXdnZXQlMjBodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZodWdnaW5nZmFjZSUyRm9wdGltdW0tbmV1cm9uJTJGbWFpbiUyRm5vdGVib29rcyUyRnRleHQtY2xhc3NpZmljYXRpb24lMkZzY3JpcHRzJTJGdHJhaW4ucHk=",highlighted:"!wget https://raw.githubusercontent.com/huggingface/optimum-neuron/main/notebooks/text-classification/scripts/train.py",wrap:!1}}),rt=new h({props:{code:"IXRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDIlMjB0cmFpbi5weSUyMCU1QyUwQSUyMC0tbW9kZWxfaWQlMjBiZXJ0LWJhc2UtdW5jYXNlZCUyMCU1QyUwQSUyMC0tZGF0YXNldF9wYXRoJTIwbG1fZGF0YXNldCUyMCU1QyUwQSUyMC0tbHIlMjA1ZS01JTIwJTVDJTBBJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAxNiUyMCU1QyUwQSUyMC0tYmYxNiUyMFRydWUlMjAlNUMlMEElMjAtLWVwb2NocyUyMDM=",highlighted:`!torchrun --nproc_per_node=2 train.py \\
 --model_id bert-base-uncased \\
 --dataset_path lm_dataset \\
 --lr 5e-5 \\
 --per_device_train_batch_size 16 \\
 --bf16 True \\
 --epochs 3`,wrap:!1}}),mt=new h({props:{code:"KioqKiolMjB0cmFpbiUyMG1ldHJpY3MlMjAqKioqKiUwQSUyMCUyMGVwb2NoJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMy4wJTBBJTIwJTIwdHJhaW5fcnVudGltZSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCUyMCUyMCUyMDAlM0EwOCUzQTMwJTBBJTIwJTIwdHJhaW5fc2FtcGxlcyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCUyMCUyMCUyMCUyMCUyMDE2MDAwJTBBJTIwJTIwdHJhaW5fc2FtcGxlc19wZXJfc2Vjb25kJTIwJTNEJTIwJTIwJTIwJTIwJTIwOTYuMzM3JTBBJTBBKioqKiolMjBldmFsJTIwbWV0cmljcyUyMCoqKioqJTBBJTIwJTIwZXZhbF9mMSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCUyMCUyMCUyMCUyMCUyMDAuOTE0JTBBJTIwJTIwZXZhbF9ydW50aW1lJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTIwJTIwJTIwMCUzQTAwJTNBMDg=",highlighted:`***** train metrics *****
  epoch                    =        3.0
  train_runtime            =    0:08:30
  train_samples            =      16000
  train_samples_per_second =     96.337

***** <span class="hljs-built_in">eval</span> metrics *****
  eval_f1                  =      0.914
  eval_runtime             =    0:00:08`,wrap:!1}}),{c(){y=i("meta"),yt=l(),ut=i("p"),wt=l(),p(w.$$.fragment),Tt=l(),T=i("p"),T.innerHTML=Te,ft=l(),f=i("p"),f.innerHTML=fe,Ut=l(),U=i("p"),U.textContent=Ue,Jt=l(),J=i("ol"),J.innerHTML=Je,gt=l(),g=i("p"),g.innerHTML=ge,bt=l(),p(b.$$.fragment),Ct=l(),C=i("p"),C.innerHTML=be,jt=l(),j=i("p"),j.textContent=Ce,It=l(),I=i("p"),I.innerHTML=je,vt=l(),v=i("table"),v.innerHTML=Ie,Wt=l(),Bt=i("hr"),_t=l(),W=i("p"),W.textContent=ve,Gt=l(),B=i("p"),B.innerHTML=We,Zt=l(),p(_.$$.fragment),kt=l(),G=i("p"),G.innerHTML=Be,Ft=l(),Z=i("p"),Z.innerHTML=_e,Rt=l(),k=i("p"),k.innerHTML=Ge,Xt=l(),p(F.$$.fragment),$t=l(),R=i("p"),R.innerHTML=Ze,xt=l(),p(X.$$.fragment),Ht=l(),$=i("p"),$.innerHTML=ke,Qt=l(),x=i("p"),x.innerHTML=Fe,Yt=l(),H=i("p"),H.innerHTML=Re,Vt=l(),Q=i("p"),Q.innerHTML=Xe,zt=l(),Y=i("p"),Y.innerHTML=$e,At=l(),p(V.$$.fragment),Nt=l(),z=i("p"),z.innerHTML=xe,St=l(),A=i("p"),A.innerHTML=He,Lt=l(),p(N.$$.fragment),Et=l(),S=i("p"),S.textContent=Qe,Pt=l(),p(L.$$.fragment),qt=l(),E=i("p"),E.innerHTML=Ye,Dt=l(),P=i("p"),P.textContent=Ve,Kt=l(),p(q.$$.fragment),Ot=l(),p(D.$$.fragment),te=l(),K=i("p"),K.innerHTML=ze,ee=l(),O=i("p"),O.innerHTML=Ae,ne=l(),tt=i("p"),tt.innerHTML=Ne,ae=l(),p(et.$$.fragment),le=l(),nt=i("p"),nt.innerHTML=Se,se=l(),p(at.$$.fragment),ie=l(),lt=i("p"),lt.innerHTML=Le,oe=l(),p(st.$$.fragment),re=l(),it=i("p"),it.innerHTML=Ee,pe=l(),ot=i("p"),ot.textContent=Pe,ce=l(),p(rt.$$.fragment),me=l(),pt=i("p"),pt.innerHTML=qe,de=l(),ct=i("p"),ct.innerHTML=De,ue=l(),p(mt.$$.fragment),Me=l(),dt=i("p"),dt.innerHTML=Ke,he=l(),Mt=i("p"),this.h()},l(t){const e=on("svelte-u9bgzb",document.head);y=o(e,"META",{name:!0,content:!0}),e.forEach(n),yt=s(t),ut=o(t,"P",{}),Oe(ut).forEach(n),wt=s(t),c(w.$$.fragment,t),Tt=s(t),T=o(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-zlj320"&&(T.innerHTML=Te),ft=s(t),f=o(t,"P",{"data-svelte-h":!0}),r(f)!=="svelte-fq2j94"&&(f.innerHTML=fe),Ut=s(t),U=o(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1hahfn0"&&(U.textContent=Ue),Jt=s(t),J=o(t,"OL",{"data-svelte-h":!0}),r(J)!=="svelte-i2dg6s"&&(J.innerHTML=Je),gt=s(t),g=o(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1dtnb6s"&&(g.innerHTML=ge),bt=s(t),c(b.$$.fragment,t),Ct=s(t),C=o(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-i1bq8"&&(C.innerHTML=be),jt=s(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1xmmjdv"&&(j.textContent=Ce),It=s(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-f3jgz1"&&(I.innerHTML=je),vt=s(t),v=o(t,"TABLE",{"data-svelte-h":!0}),r(v)!=="svelte-1ch8aud"&&(v.innerHTML=Ie),Wt=s(t),Bt=o(t,"HR",{}),_t=s(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-6n93f4"&&(W.textContent=ve),Gt=s(t),B=o(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-xlynlq"&&(B.innerHTML=We),Zt=s(t),c(_.$$.fragment,t),kt=s(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-6ygvsn"&&(G.innerHTML=Be),Ft=s(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1p685c9"&&(Z.innerHTML=_e),Rt=s(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1w4fiht"&&(k.innerHTML=Ge),Xt=s(t),c(F.$$.fragment,t),$t=s(t),R=o(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-cmik5i"&&(R.innerHTML=Ze),xt=s(t),c(X.$$.fragment,t),Ht=s(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-si97e0"&&($.innerHTML=ke),Qt=s(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-7s5jat"&&(x.innerHTML=Fe),Yt=s(t),H=o(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-yorl3n"&&(H.innerHTML=Re),Vt=s(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-krn90s"&&(Q.innerHTML=Xe),zt=s(t),Y=o(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1op3czr"&&(Y.innerHTML=$e),At=s(t),c(V.$$.fragment,t),Nt=s(t),z=o(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-nodub0"&&(z.innerHTML=xe),St=s(t),A=o(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1ab0i1h"&&(A.innerHTML=He),Lt=s(t),c(N.$$.fragment,t),Et=s(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-udg7sq"&&(S.textContent=Qe),Pt=s(t),c(L.$$.fragment,t),qt=s(t),E=o(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1vv5g70"&&(E.innerHTML=Ye),Dt=s(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1iixhur"&&(P.textContent=Ve),Kt=s(t),c(q.$$.fragment,t),Ot=s(t),c(D.$$.fragment,t),te=s(t),K=o(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-spmis1"&&(K.innerHTML=ze),ee=s(t),O=o(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1ctxk4j"&&(O.innerHTML=Ae),ne=s(t),tt=o(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-c0yi33"&&(tt.innerHTML=Ne),ae=s(t),c(et.$$.fragment,t),le=s(t),nt=o(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-5i5vsb"&&(nt.innerHTML=Se),se=s(t),c(at.$$.fragment,t),ie=s(t),lt=o(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-z4rrh7"&&(lt.innerHTML=Le),oe=s(t),c(st.$$.fragment,t),re=s(t),it=o(t,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1tr68b8"&&(it.innerHTML=Ee),pe=s(t),ot=o(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-folbj9"&&(ot.textContent=Pe),ce=s(t),c(rt.$$.fragment,t),me=s(t),pt=o(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-161fdea"&&(pt.innerHTML=qe),de=s(t),ct=o(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-dotc0h"&&(ct.innerHTML=De),ue=s(t),c(mt.$$.fragment,t),Me=s(t),dt=o(t,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1iox2bz"&&(dt.innerHTML=Ke),he=s(t),Mt=o(t,"P",{}),Oe(Mt).forEach(n),this.h()},h(){tn(y,"name","hf:doc:metadata"),tn(y,"content",cn)},m(t,e){rn(document.head,y),a(t,yt,e),a(t,ut,e),a(t,wt,e),m(w,t,e),a(t,Tt,e),a(t,T,e),a(t,ft,e),a(t,f,e),a(t,Ut,e),a(t,U,e),a(t,Jt,e),a(t,J,e),a(t,gt,e),a(t,g,e),a(t,bt,e),m(b,t,e),a(t,Ct,e),a(t,C,e),a(t,jt,e),a(t,j,e),a(t,It,e),a(t,I,e),a(t,vt,e),a(t,v,e),a(t,Wt,e),a(t,Bt,e),a(t,_t,e),a(t,W,e),a(t,Gt,e),a(t,B,e),a(t,Zt,e),m(_,t,e),a(t,kt,e),a(t,G,e),a(t,Ft,e),a(t,Z,e),a(t,Rt,e),a(t,k,e),a(t,Xt,e),m(F,t,e),a(t,$t,e),a(t,R,e),a(t,xt,e),m(X,t,e),a(t,Ht,e),a(t,$,e),a(t,Qt,e),a(t,x,e),a(t,Yt,e),a(t,H,e),a(t,Vt,e),a(t,Q,e),a(t,zt,e),a(t,Y,e),a(t,At,e),m(V,t,e),a(t,Nt,e),a(t,z,e),a(t,St,e),a(t,A,e),a(t,Lt,e),m(N,t,e),a(t,Et,e),a(t,S,e),a(t,Pt,e),m(L,t,e),a(t,qt,e),a(t,E,e),a(t,Dt,e),a(t,P,e),a(t,Kt,e),m(q,t,e),a(t,Ot,e),m(D,t,e),a(t,te,e),a(t,K,e),a(t,ee,e),a(t,O,e),a(t,ne,e),a(t,tt,e),a(t,ae,e),m(et,t,e),a(t,le,e),a(t,nt,e),a(t,se,e),m(at,t,e),a(t,ie,e),a(t,lt,e),a(t,oe,e),m(st,t,e),a(t,re,e),a(t,it,e),a(t,pe,e),a(t,ot,e),a(t,ce,e),m(rt,t,e),a(t,me,e),a(t,pt,e),a(t,de,e),a(t,ct,e),a(t,ue,e),m(mt,t,e),a(t,Me,e),a(t,dt,e),a(t,he,e),a(t,Mt,e),ye=!0},p:nn,i(t){ye||(d(w.$$.fragment,t),d(b.$$.fragment,t),d(_.$$.fragment,t),d(F.$$.fragment,t),d(X.$$.fragment,t),d(V.$$.fragment,t),d(N.$$.fragment,t),d(L.$$.fragment,t),d(q.$$.fragment,t),d(D.$$.fragment,t),d(et.$$.fragment,t),d(at.$$.fragment,t),d(st.$$.fragment,t),d(rt.$$.fragment,t),d(mt.$$.fragment,t),ye=!0)},o(t){u(w.$$.fragment,t),u(b.$$.fragment,t),u(_.$$.fragment,t),u(F.$$.fragment,t),u(X.$$.fragment,t),u(V.$$.fragment,t),u(N.$$.fragment,t),u(L.$$.fragment,t),u(q.$$.fragment,t),u(D.$$.fragment,t),u(et.$$.fragment,t),u(at.$$.fragment,t),u(st.$$.fragment,t),u(rt.$$.fragment,t),u(mt.$$.fragment,t),ye=!1},d(t){t&&(n(yt),n(ut),n(wt),n(Tt),n(T),n(ft),n(f),n(Ut),n(U),n(Jt),n(J),n(gt),n(g),n(bt),n(Ct),n(C),n(jt),n(j),n(It),n(I),n(vt),n(v),n(Wt),n(Bt),n(_t),n(W),n(Gt),n(B),n(Zt),n(kt),n(G),n(Ft),n(Z),n(Rt),n(k),n(Xt),n($t),n(R),n(xt),n(Ht),n($),n(Qt),n(x),n(Yt),n(H),n(Vt),n(Q),n(zt),n(Y),n(At),n(Nt),n(z),n(St),n(A),n(Lt),n(Et),n(S),n(Pt),n(qt),n(E),n(Dt),n(P),n(Kt),n(Ot),n(te),n(K),n(ee),n(O),n(ne),n(tt),n(ae),n(le),n(nt),n(se),n(ie),n(lt),n(oe),n(re),n(it),n(pe),n(ot),n(ce),n(me),n(pt),n(de),n(ct),n(ue),n(Me),n(dt),n(he),n(Mt)),n(y),M(w,t),M(b,t),M(_,t),M(F,t),M(X,t),M(V,t),M(N,t),M(L,t),M(q,t),M(D,t),M(et,t),M(at,t),M(st,t),M(rt,t),M(mt,t)}}}const cn='{"title":"Fine-tune BERT for Text Classification on AWS Trainium","local":"fine-tune-bert-for-text-classification-on-aws-trainium","sections":[{"title":"Quick intro: AWS Trainium","local":"quick-intro-aws-trainium","sections":[],"depth":2},{"title":"1. Setup AWS environment","local":"1-setup-aws-environment","sections":[],"depth":2},{"title":"2. Load and process the dataset","local":"2-load-and-process-the-dataset","sections":[],"depth":2},{"title":"3. Fine-tune BERT using Hugging Face Transformers","local":"3-fine-tune-bert-using-hugging-face-transformers","sections":[],"depth":2}],"depth":1}';function mn(we){return an(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yn extends ln{constructor(y){super(),sn(this,y,mn,pn,en,{})}}export{yn as component};
