import{s as ka,f as Na,n as Qa,o as Sa}from"../chunks/scheduler.37c15a92.js";import{S as za,i as Fa,g as M,s as e,r as j,A as xa,h as p,f as a,c as n,j as Ya,u as J,x as i,k as Ls,y as Ha,a as t,v as c,d as r,t as y,w as o}from"../chunks/index.7cb9c9b8.js";import{C as w}from"../chunks/CodeBlock.a6d3f852.js";import{H as T,E as qa}from"../chunks/EditOnGithub.858acfec.js";function $a(Ds){let m,_l,vl,Xl,U,El,h,Ks,Vl,u,Ps="For training our model, we will rely on already implemented RL algorithms, leveraging state-of-the-art Reinforcement Learning libraries. There are multiple advantages in doing so: these libraries provide high quality algorithms, efficiently implemented and continuously tested, they allow to focus efforts on higher level aspects such as policy network architecture, features selection, and hyper-parameters tuning, they provide native solutions to parallelize environment execution, and, in some cases, they even support distributed training using multiple GPUs in a single workstation or in cluster contexts.",Rl,d,Os='DIAMBRA Arena natively supports three of the most important RL libraries: <a href="https://stable-baselines3.readthedocs.io/en/master/" rel="nofollow">Stable Baselines 3</a>, <a href="https://docs.ray.io/en/latest/rllib/index.html" rel="nofollow">Ray RLlib</a> and <a href="https://github.com/Eclectic-Sheep/sheeprl/tree/main" rel="nofollow">SheepRL</a>.',Yl,I,kl,b,la="The classical way to create an agent able to play a game is to hand-code the rules governing its behavior. These rules can vary from very simple heuristics to very complex behavioral trees, but they all have in common the need of an expert coder that knows the game and is able to distill the key elements of it to craft the scripted bot.",Nl,B,sa='The following are two examples of (very simple) scripted agents interfaced with our environments, and they are available here: <a href="https://github.com/diambra/agents/tree/main/basic" rel="nofollow">DIAMBRA Agents - Basic</a>.',Ql,A,Sl,C,aa="This agent simply performs the “No-Action” action at every step. By convention it is the action with index 0, and it needs to be a single value for <code>Discrete</code> action spaces, and a tuple of 0s for <code>MultiDiscrete</code> ones, as shown in the snippet below.",zl,Z,Fl,g,xl,f,ta="This agent simply performs a random action at every step. In this case, the sampling method takes care of generating an action that is consistent with the environment action space.",Hl,W,ql,v,ea="You can run these simple agents on the environment to start building confidence with respect to how it works, and to start understanding the different moving parts, for example inspecting the observation space returned in the different phases.",$l,G,na="More complex scripts can be built in similar ways, for example continuously performing user-defined combos moves, or adding some more complex choice mechanics. But this would still require to decide the tactics in advance, properly translating knowledge into code. A different approach would be to leverage Reinforcement Learning, so that the agent will improve leveraging its own experience.",Ll,_,Dl,X,Ma="An alternative approach to scripted agents is to leverage Reinforcement Learning to create a model that improves over time by leveraging its experience.",Kl,E,pa="In this tutorial we will show step-by-step how to training a deep neural network using A2C and PPO algorithms from Stable Baselines 3.",Pl,V,Ol,R,ia="We highly recommend using virtual environments to isolate your python installs, especially to avoid conflicts in dependencies. In what follows we use Conda but any other tool should work too.",ls,Y,ja="Create and activate a new dedicated virtual environment:",ss,k,as,N,Ja="Install DIAMBRA Arena with Stable Baselines 3 interface:",ts,Q,es,S,ca='This should be enough to prepare your system to execute the scripts presented here below. You can refer to the official <a href="https://stable-baselines3.readthedocs.io/en/master/guide/install.html" rel="nofollow">Stable Baselines 3 documentation</a> or reach out on <a href="https://diambra.ai/discord" rel="nofollow">DIAMBRA Discord Server</a> for specific needs.',ns,z,ra='All the examples presented below are available here: <a href="https://github.com/diambra/agents/tree/main/stable_baselines3" rel="nofollow">DIAMBRA Agents - Stable Baselines 3</a>. They have been created following the high level approach found on <a href="https://stable-baselines3.readthedocs.io/en/master/guide/examples.html" rel="nofollow">Stable Baselines 3 examples</a> page, thus allowing to easily extend them and to understand how they interface with the different components.',Ms,F,ya="These examples aims at demonstrating the core functionalities and high level aspects, providing a base for the user to build upon, exploring aspects like policy network architecture, algorithm hyperparameter tuning, observation space tweaking, rewards wrapping and other similar ones.",ps,x,is,H,oa="For all the examples there are two main things to note about the observation space.",js,q,wa="First, the normalization wrapper is applied on all elements but the image frame, as Stable Baselines 3 automatically normalizes images and expects their pixels to be in the range [0 - 255].",Js,$,Ta='Second, the library also has a specific constraint on dictionary observation spaces: they cannot be nested. For this reason we provide a <a href="https://docs.diambra.ai/wrappers/#flatten-and-filter-observation" rel="nofollow">flattening wrapper</a> that creates a shallow, not nested, dictionary from the original observation space, allowing in addition to filter it by keys.',cs,L,ma="Stable Baselines 3 automatically defines the network architecture, properly matching the input type. In some of the examples the architecture is printed to the console output, allowing to clearly identify all the different contributions.",rs,D,ys,K,Ua="This example demonstrates how to:",os,P,ha="<li>Leverage DIAMBRA Arena native Stable Baselines 3 interface to create the environment</li> <li>Interface the environment with one of Stable Baselines 3’s algorithms</li> <li>Train the algorithm</li> <li>Run the trained agent in the environment for one episode</li>",ws,O,ua="It uses the A2C algorithm, with a <code>MultiInputPolicy</code> policy network to properly process the dictionary observation space as input. For demonstration purposes, the algorithm is trained for only 200 steps, so the resulting agent will be far from optimal.",Ts,ll,ms,sl,da="How to run it:",Us,al,hs,tl,us,el,Ia="In addition to what seen in the previous example, this one demonstrates how to:",ds,nl,ba="<li>Save a trained agent</li> <li>Load a saved agent</li> <li>Evaluate an agent on a given number of episodes</li>",Is,Ml,Ba="The same conditions of the previous example for algorithm, policy and training steps are used in this one too.",bs,pl,Bs,il,Aa="How to run it:",As,jl,Cs,Jl,Zs,cl,Ca="In addition to what seen in previous examples, this one demonstrates how to:",gs,rl,Za="<li>Run training using parallel environments</li> <li>Print out the policy network architecture</li>",fs,yl,ga="In this example, the PPO algorithm is used, with the same <code>MultiInputPolicy</code> seen before. The policy architecture is also printed to the console output, allowing to visualize how inputs are processed and “translated” to actions probabilities.",Ws,ol,fa="This example also runs multiple environments, automatically detecting the number of instances created by DIAMBRA CLI when running the script.",vs,wl,Gs,Tl,Wa="How to run it:",_s,ml,Xs,Ul,Es,hl,Vs,ul,va="In addition to what seen in previous examples, this one demonstrates how to:",Rs,dl,Ga="<li>Build a complete training script to be used with Stable Baselines via a config file</li> <li>How to properly handle hyper-parameters scheduling via callbacks</li> <li>How to use callbacks for auto-saving</li> <li>How to control some policy network models and optimizer parameters</li>",Ys,Il,_a="This example show exactly how we trained our own models on these environments. It should be considered a starting point from where to explore and experiment, the following are just a few options among the most obvious ones:",ks,bl,Xa="<li>Tweak hyper-parameters for the chosen algorithm</li> <li>Evolve the policy network architecture</li> <li>Test different algorithms, both on and off-policy</li> <li>Try to leverage behavioral cloning / imitation learning</li> <li>Modify the reward function to guide learning in other directions</li>",Ns,Bl,Qs,Al,Ea="How to run it:",Ss,Cl,zs,Zl,Va="and the configuration file to be used with this training script is reported below:",Fs,gl,xs,fl,Ra="Finally, after the agent training is completed, besides running it locally in your own machine, you may want to submit it to <strong>DIAMBRA Competition Platform to compete with other coders around the globe in epic video games tournaments!</strong> The next section provides a step by step guide to do exactly that.",Hs,Wl,qs,Gl,$s;return U=new T({props:{title:"Reinforcement Learning Training",local:"reinforcement-learning-training",headingTag:"h1"}}),I=new T({props:{title:"Creating Scripted Agents",local:"creating-scripted-agents",headingTag:"h2"}}),A=new T({props:{title:"No-Action Agent",local:"no-action-agent",headingTag:"h3"}}),Z=new w({props:{code:"aW1wb3J0JTIwZGlhbWJyYS5hcmVuYSUwQWZyb20lMjBkaWFtYnJhLmFyZW5hJTIwaW1wb3J0JTIwU3BhY2VUeXBlcyUyQyUyMFJvbGVzJTJDJTIwRW52aXJvbm1lbnRTZXR0aW5ncyUwQSUwQSUyMyUyMFNldHRpbmdzJTBBc2V0dGluZ3MlMjAlM0QlMjBFbnZpcm9ubWVudFNldHRpbmdzKCklMEFzZXR0aW5ncy5zdGVwX3JhdGlvJTIwJTNEJTIwNiUwQXNldHRpbmdzLmZyYW1lX3NoYXBlJTIwJTNEJTIwKDEyOCUyQyUyMDEyOCUyQyUyMDEpJTBBc2V0dGluZ3Mucm9sZSUyMCUzRCUyMFJvbGVzLlAyJTBBc2V0dGluZ3MuZGlmZmljdWx0eSUyMCUzRCUyMDQlMEFzZXR0aW5ncy5hY3Rpb25fc3BhY2UlMjAlM0QlMjBTcGFjZVR5cGVzLk1VTFRJX0RJU0NSRVRFJTBBJTBBZW52JTIwJTNEJTIwZGlhbWJyYS5hcmVuYS5tYWtlKCUyMnNmaWlpM24lMjIlMkMlMjBzZXR0aW5ncyklMEFvYnNlcnZhdGlvbiUyQyUyMGluZm8lMjAlM0QlMjBlbnYucmVzZXQoKSUwQSUwQXdoaWxlJTIwVHJ1ZSUzQSUwQSUyMCUyMCUyMCUyMGFjdGlvbiUyMCUzRCUyMGVudi5nZXRfbm9fb3BfYWN0aW9uKCklMEElMjAlMjAlMjAlMjBvYnNlcnZhdGlvbiUyQyUyMHJld2FyZCUyQyUyMHRlcm1pbmF0ZWQlMkMlMjB0cnVuY2F0ZWQlMkMlMjBpbmZvJTIwJTNEJTIwZW52LnN0ZXAoYWN0aW9uKSUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwdGVybWluYXRlZCUyMG9yJTIwdHJ1bmNhdGVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWslMEElMEElMjMlMjBDbG9zZSUyMHRoZSUyMGVudmlyb25tZW50JTBBZW52LmNsb3NlKCk=",highlighted:`<span class="hljs-keyword">import</span> diambra.arena
<span class="hljs-keyword">from</span> diambra.arena <span class="hljs-keyword">import</span> SpaceTypes, Roles, EnvironmentSettings

<span class="hljs-comment"># Settings</span>
settings = EnvironmentSettings()
settings.step_ratio = <span class="hljs-number">6</span>
settings.frame_shape = (<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">1</span>)
settings.role = Roles.P2
settings.difficulty = <span class="hljs-number">4</span>
settings.action_space = SpaceTypes.MULTI_DISCRETE

env = diambra.arena.make(<span class="hljs-string">&quot;sfiii3n&quot;</span>, settings)
observation, info = env.reset()

<span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
    action = env.get_no_op_action()
    observation, reward, terminated, truncated, info = env.step(action)

    <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
        <span class="hljs-keyword">break</span>

<span class="hljs-comment"># Close the environment</span>
env.close()`,wrap:!1}}),g=new T({props:{title:"Random Agent",local:"random-agent",headingTag:"h3"}}),W=new w({props:{code:"aW1wb3J0JTIwZGlhbWJyYS5hcmVuYSUwQWZyb20lMjBkaWFtYnJhLmFyZW5hJTIwaW1wb3J0JTIwU3BhY2VUeXBlcyUyQyUyMFJvbGVzJTJDJTIwRW52aXJvbm1lbnRTZXR0aW5ncyUwQSUwQSUyMyUyMFNldHRpbmdzJTBBc2V0dGluZ3MlMjAlM0QlMjBFbnZpcm9ubWVudFNldHRpbmdzKCklMEFzZXR0aW5ncy5zdGVwX3JhdGlvJTIwJTNEJTIwNiUwQXNldHRpbmdzLmZyYW1lX3NoYXBlJTIwJTNEJTIwKDEyOCUyQyUyMDEyOCUyQyUyMDEpJTBBc2V0dGluZ3Mucm9sZSUyMCUzRCUyMFJvbGVzLlAyJTBBc2V0dGluZ3MuZGlmZmljdWx0eSUyMCUzRCUyMDQlMEFzZXR0aW5ncy5hY3Rpb25fc3BhY2UlMjAlM0QlMjBTcGFjZVR5cGVzLk1VTFRJX0RJU0NSRVRFJTBBJTBBZW52JTIwJTNEJTIwZGlhbWJyYS5hcmVuYS5tYWtlKCUyMnNmaWlpM24lMjIlMkMlMjBzZXR0aW5ncyklMEFvYnNlcnZhdGlvbiUyQyUyMGluZm8lMjAlM0QlMjBlbnYucmVzZXQoKSUwQSUwQXdoaWxlJTIwVHJ1ZSUzQSUwQSUyMCUyMCUyMCUyMGFjdGlvbiUyMCUzRCUyMGVudi5hY3Rpb25fc3BhY2Uuc2FtcGxlKCklMEElMjAlMjAlMjAlMjBvYnNlcnZhdGlvbiUyQyUyMHJld2FyZCUyQyUyMHRlcm1pbmF0ZWQlMkMlMjB0cnVuY2F0ZWQlMkMlMjBpbmZvJTIwJTNEJTIwZW52LnN0ZXAoYWN0aW9uKSUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwdGVybWluYXRlZCUyMG9yJTIwdHJ1bmNhdGVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWslMEElMEElMjMlMjBDbG9zZSUyMHRoZSUyMGVudmlyb25tZW50JTBBZW52LmNsb3NlKCk=",highlighted:`<span class="hljs-keyword">import</span> diambra.arena
<span class="hljs-keyword">from</span> diambra.arena <span class="hljs-keyword">import</span> SpaceTypes, Roles, EnvironmentSettings

<span class="hljs-comment"># Settings</span>
settings = EnvironmentSettings()
settings.step_ratio = <span class="hljs-number">6</span>
settings.frame_shape = (<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">1</span>)
settings.role = Roles.P2
settings.difficulty = <span class="hljs-number">4</span>
settings.action_space = SpaceTypes.MULTI_DISCRETE

env = diambra.arena.make(<span class="hljs-string">&quot;sfiii3n&quot;</span>, settings)
observation, info = env.reset()

<span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
    action = env.action_space.sample()
    observation, reward, terminated, truncated, info = env.step(action)

    <span class="hljs-keyword">if</span> terminated <span class="hljs-keyword">or</span> truncated:
        <span class="hljs-keyword">break</span>

<span class="hljs-comment"># Close the environment</span>
env.close()`,wrap:!1}}),_=new T({props:{title:"Training DeepRL Agents",local:"training-deeprl-agents",headingTag:"h2"}}),V=new T({props:{title:"Getting Ready",local:"getting-ready",headingTag:"h3"}}),k=new w({props:{code:"Y29uZGElMjBjcmVhdGUlMjAtbiUyMGRpYW1icmEtYXJlbmEtc2IzJTIwcHl0aG9uJTNEMy44JTBBY29uZGElMjBhY3RpdmF0ZSUyMGRpYW1icmEtYXJlbmEtc2Iz",highlighted:`conda create -n diambra-arena-sb3 python=3.8
conda activate diambra-arena-sb3`,wrap:!1}}),Q=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpYW1icmEtYXJlbmElNUJzdGFibGUtYmFzZWxpbmVzMyU1RA==",highlighted:"pip install diambra-arena[stable-baselines3]",wrap:!1}}),x=new T({props:{title:"Basic",local:"basic",headingTag:"h3"}}),D=new T({props:{title:"Basic Example",local:"basic-example",headingTag:"h4"}}),ll=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diambra.arena.stable_baselines3.make_sb3_env <span class="hljs-keyword">import</span> make_sb3_env, EnvironmentSettings, WrappersSettings
<span class="hljs-keyword">from</span> stable_baselines3 <span class="hljs-keyword">import</span> A2C

<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    <span class="hljs-comment"># Settings</span>
    settings = EnvironmentSettings()
    settings.frame_shape = (<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">1</span>)
    settings.characters = (<span class="hljs-string">&quot;Ryu&quot;</span>)

    <span class="hljs-comment"># Wrappers Settings</span>
    wrappers_settings = WrappersSettings()
    wrappers_settings.normalize_reward = <span class="hljs-literal">True</span>
    wrappers_settings.stack_frames = <span class="hljs-number">5</span>
    wrappers_settings.add_last_action = <span class="hljs-literal">True</span>
    wrappers_settings.stack_actions = <span class="hljs-number">12</span>
    wrappers_settings.scale = <span class="hljs-literal">True</span>
    wrappers_settings.exclude_image_scaling = <span class="hljs-literal">True</span>
    wrappers_settings.role_relative = <span class="hljs-literal">True</span>
    wrappers_settings.flatten = <span class="hljs-literal">True</span>
    wrappers_settings.filter_keys = [<span class="hljs-string">&quot;action&quot;</span>, <span class="hljs-string">&quot;own_health&quot;</span>, <span class="hljs-string">&quot;opp_health&quot;</span>, <span class="hljs-string">&quot;own_side&quot;</span>, <span class="hljs-string">&quot;opp_side&quot;</span>, <span class="hljs-string">&quot;opp_character&quot;</span>, <span class="hljs-string">&quot;stage&quot;</span>, <span class="hljs-string">&quot;timer&quot;</span>]

    <span class="hljs-comment"># Create environment</span>
    env, num_envs = make_sb3_env(<span class="hljs-string">&quot;sfiii3n&quot;</span>, settings, wrappers_settings)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Activated {} environment(s)&quot;</span>.<span class="hljs-built_in">format</span>(num_envs))

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nStarting training ...\\n&quot;</span>)
    agent = A2C(<span class="hljs-string">&quot;MultiInputPolicy&quot;</span>, env, verbose=<span class="hljs-number">1</span>)
    agent.learn(total_timesteps=<span class="hljs-number">200</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n .. training completed.&quot;</span>)

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nStarting trained agent execution ...\\n&quot;</span>)
    observation = env.reset()
    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
        env.render()

        action, _state = agent.predict(observation, deterministic=<span class="hljs-literal">True</span>)
        observation, reward, done, info = env.step(action)

        <span class="hljs-keyword">if</span> done:
            observation = env.reset()
            <span class="hljs-keyword">break</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n... trained agent execution completed.\\n&quot;</span>)

    <span class="hljs-comment"># Close the environment</span>
    env.close()

    <span class="hljs-comment"># Return success</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">0</span>

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),al=new w({props:{code:"ZGlhbWJyYSUyMHJ1biUyMHB5dGhvbiUyMGJhc2ljLnB5",highlighted:"diambra run python basic.py",wrap:!1}}),tl=new T({props:{title:"Saving, loading and evaluating",local:"saving-loading-and-evaluating",headingTag:"h4"}}),pl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diambra.arena.stable_baselines3.make_sb3_env <span class="hljs-keyword">import</span> make_sb3_env, EnvironmentSettings, WrappersSettings
<span class="hljs-keyword">from</span> stable_baselines3 <span class="hljs-keyword">import</span> A2C
<span class="hljs-keyword">from</span> stable_baselines3.common.evaluation <span class="hljs-keyword">import</span> evaluate_policy

<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    <span class="hljs-comment"># Settings</span>
    settings = EnvironmentSettings()
    settings.frame_shape = (<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">1</span>)
    settings.characters = (<span class="hljs-string">&quot;Ryu&quot;</span>)

    <span class="hljs-comment"># Wrappers Settings</span>
    wrappers_settings = WrappersSettings()
    wrappers_settings.normalize_reward = <span class="hljs-literal">True</span>
    wrappers_settings.stack_frames = <span class="hljs-number">5</span>
    wrappers_settings.add_last_action = <span class="hljs-literal">True</span>
    wrappers_settings.stack_actions = <span class="hljs-number">12</span>
    wrappers_settings.scale = <span class="hljs-literal">True</span>
    wrappers_settings.exclude_image_scaling = <span class="hljs-literal">True</span>
    wrappers_settings.role_relative = <span class="hljs-literal">True</span>
    wrappers_settings.flatten = <span class="hljs-literal">True</span>
    wrappers_settings.filter_keys = [<span class="hljs-string">&quot;action&quot;</span>, <span class="hljs-string">&quot;own_health&quot;</span>, <span class="hljs-string">&quot;opp_health&quot;</span>, <span class="hljs-string">&quot;own_side&quot;</span>, <span class="hljs-string">&quot;opp_side&quot;</span>, <span class="hljs-string">&quot;opp_character&quot;</span>, <span class="hljs-string">&quot;stage&quot;</span>, <span class="hljs-string">&quot;timer&quot;</span>]

    <span class="hljs-comment"># Create environment</span>
    env, num_envs = make_sb3_env(<span class="hljs-string">&quot;sfiii3n&quot;</span>, settings, wrappers_settings)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Activated {} environment(s)&quot;</span>.<span class="hljs-built_in">format</span>(num_envs))

    <span class="hljs-comment"># Instantiate the agent</span>
    agent = A2C(<span class="hljs-string">&quot;MultiInputPolicy&quot;</span>, env, verbose=<span class="hljs-number">1</span>)
    <span class="hljs-comment"># Train the agent</span>
    agent.learn(total_timesteps=<span class="hljs-number">200</span>)
    <span class="hljs-comment"># Save the agent</span>
    agent.save(<span class="hljs-string">&quot;a2c_sfiii3n&quot;</span>)
    <span class="hljs-keyword">del</span> agent  <span class="hljs-comment"># delete trained agent to demonstrate loading</span>

    <span class="hljs-comment"># Load the trained agent</span>
    <span class="hljs-comment"># <span class="hljs-doctag">NOTE:</span> if you have loading issue, you can pass \`print_system_info=True\`</span>
    <span class="hljs-comment"># to compare the system on which the agent was trained vs the current one</span>
    <span class="hljs-comment"># agent = A2C.load(&quot;a2c_sfiii3n&quot;, env=env, print_system_info=True)</span>
    agent = A2C.load(<span class="hljs-string">&quot;a2c_sfiii3n&quot;</span>, env=env)

    <span class="hljs-comment"># Evaluate the agent</span>
    <span class="hljs-comment"># <span class="hljs-doctag">NOTE:</span> If you use wrappers with your environment that modify rewards,</span>
    <span class="hljs-comment">#       this will be reflected here. To evaluate with original rewards,</span>
    <span class="hljs-comment">#       wrap environment in a &quot;Monitor&quot; wrapper before other wrappers.</span>
    mean_reward, std_reward = evaluate_policy(agent, agent.get_env(), n_eval_episodes=<span class="hljs-number">3</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Reward: {} (avg) ± {} (std)&quot;</span>.<span class="hljs-built_in">format</span>(mean_reward, std_reward))

    <span class="hljs-comment"># Run trained agent</span>
    observation = env.reset()
    cumulative_reward = <span class="hljs-number">0</span>
    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
        env.render()

        action, _state = agent.predict(observation, deterministic=<span class="hljs-literal">True</span>)
        observation, reward, done, info = env.step(action)

        cumulative_reward += reward
        <span class="hljs-keyword">if</span> (reward != <span class="hljs-number">0</span>):
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Cumulative reward =&quot;</span>, cumulative_reward)

        <span class="hljs-keyword">if</span> done:
            observation = env.reset()
            <span class="hljs-keyword">break</span>

    <span class="hljs-comment"># Close the environment</span>
    env.close()

    <span class="hljs-comment"># Return success</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">0</span>

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),jl=new w({props:{code:"ZGlhbWJyYSUyMHJ1biUyMHB5dGhvbiUyMHNhdmluZ19sb2FkaW5nX2V2YWx1YXRpbmcucHk=",highlighted:"diambra run python saving_loading_evaluating.py",wrap:!1}}),Jl=new T({props:{title:"Parallel Environments",local:"parallel-environments",headingTag:"h4"}}),wl=new w({props:{code:"ZnJvbSUyMGRpYW1icmEuYXJlbmEuc3RhYmxlX2Jhc2VsaW5lczMubWFrZV9zYjNfZW52JTIwaW1wb3J0JTIwbWFrZV9zYjNfZW52JTJDJTIwRW52aXJvbm1lbnRTZXR0aW5ncyUyQyUyMFdyYXBwZXJzU2V0dGluZ3MlMEFmcm9tJTIwc3RhYmxlX2Jhc2VsaW5lczMlMjBpbXBvcnQlMjBQUE8lMEElMEFkZWYlMjBtYWluKCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBTZXR0aW5ncyUwQSUyMCUyMCUyMCUyMHNldHRpbmdzJTIwJTNEJTIwRW52aXJvbm1lbnRTZXR0aW5ncygpJTBBJTIwJTIwJTIwJTIwc2V0dGluZ3MuZnJhbWVfc2hhcGUlMjAlM0QlMjAoMTI4JTJDJTIwMTI4JTJDJTIwMSklMEElMjAlMjAlMjAlMjBzZXR0aW5ncy5jaGFyYWN0ZXJzJTIwJTNEJTIwKCUyMlJ5dSUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBXcmFwcGVycyUyMFNldHRpbmdzJTBBJTIwJTIwJTIwJTIwd3JhcHBlcnNfc2V0dGluZ3MlMjAlM0QlMjBXcmFwcGVyc1NldHRpbmdzKCklMEElMjAlMjAlMjAlMjB3cmFwcGVyc19zZXR0aW5ncy5ub3JtYWxpemVfcmV3YXJkJTIwJTNEJTIwVHJ1ZSUwQSUyMCUyMCUyMCUyMHdyYXBwZXJzX3NldHRpbmdzLnN0YWNrX2ZyYW1lcyUyMCUzRCUyMDUlMEElMjAlMjAlMjAlMjB3cmFwcGVyc19zZXR0aW5ncy5hZGRfbGFzdF9hY3Rpb24lMjAlM0QlMjBUcnVlJTBBJTIwJTIwJTIwJTIwd3JhcHBlcnNfc2V0dGluZ3Muc3RhY2tfYWN0aW9ucyUyMCUzRCUyMDEyJTBBJTIwJTIwJTIwJTIwd3JhcHBlcnNfc2V0dGluZ3Muc2NhbGUlMjAlM0QlMjBUcnVlJTBBJTIwJTIwJTIwJTIwd3JhcHBlcnNfc2V0dGluZ3MuZXhjbHVkZV9pbWFnZV9zY2FsaW5nJTIwJTNEJTIwVHJ1ZSUwQSUyMCUyMCUyMCUyMHdyYXBwZXJzX3NldHRpbmdzLnJvbGVfcmVsYXRpdmUlMjAlM0QlMjBUcnVlJTBBJTIwJTIwJTIwJTIwd3JhcHBlcnNfc2V0dGluZ3MuZmxhdHRlbiUyMCUzRCUyMFRydWUlMEElMjAlMjAlMjAlMjB3cmFwcGVyc19zZXR0aW5ncy5maWx0ZXJfa2V5cyUyMCUzRCUyMCU1QiUyMmFjdGlvbiUyMiUyQyUyMCUyMm93bl9oZWFsdGglMjIlMkMlMjAlMjJvcHBfaGVhbHRoJTIyJTJDJTIwJTIyb3duX3NpZGUlMjIlMkMlMjAlMjJvcHBfc2lkZSUyMiUyQyUyMCUyMm9wcF9jaGFyYWN0ZXIlMjIlMkMlMjAlMjJzdGFnZSUyMiUyQyUyMCUyMnRpbWVyJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ3JlYXRlJTIwZW52aXJvbm1lbnQlMEElMjAlMjAlMjAlMjBlbnYlMkMlMjBudW1fZW52cyUyMCUzRCUyMG1ha2Vfc2IzX2VudiglMjJzZmlpaTNuJTIyJTJDJTIwc2V0dGluZ3MlMkMlMjB3cmFwcGVyc19zZXR0aW5ncyklMEElMjAlMjAlMjAlMjBwcmludCglMjJBY3RpdmF0ZWQlMjAlN0IlN0QlMjBlbnZpcm9ubWVudChzKSUyMi5mb3JtYXQobnVtX2VudnMpKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEluc3RhbnRpYXRlJTIwdGhlJTIwYWdlbnQlMEElMjAlMjAlMjAlMjBhZ2VudCUyMCUzRCUyMFBQTyglMjJNdWx0aUlucHV0UG9saWN5JTIyJTJDJTIwZW52JTJDJTIwdmVyYm9zZSUzRDEpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUHJpbnQlMjBwb2xpY3klMjBuZXR3b3JrJTIwYXJjaGl0ZWN0dXJlJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyUG9saWN5JTIwYXJjaGl0ZWN0dXJlJTNBJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGFnZW50LnBvbGljeSklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBUcmFpbiUyMHRoZSUyMGFnZW50JTBBJTIwJTIwJTIwJTIwYWdlbnQubGVhcm4odG90YWxfdGltZXN0ZXBzJTNEMjAwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFJ1biUyMHRyYWluZWQlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMG9ic2VydmF0aW9uJTIwJTNEJTIwZW52LnJlc2V0KCklMEElMjAlMjAlMjAlMjBjdW11bGF0aXZlX3Jld2FyZCUyMCUzRCUyMCU1QjAuMCUyMGZvciUyMF8lMjBpbiUyMHJhbmdlKG51bV9lbnZzKSU1RCUwQSUyMCUyMCUyMCUyMHdoaWxlJTIwVHJ1ZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjdGlvbiUyQyUyMF9zdGF0ZSUyMCUzRCUyMGFnZW50LnByZWRpY3Qob2JzZXJ2YXRpb24lMkMlMjBkZXRlcm1pbmlzdGljJTNEVHJ1ZSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvYnNlcnZhdGlvbiUyQyUyMHJld2FyZCUyQyUyMGRvbmUlMkMlMjBpbmZvJTIwJTNEJTIwZW52LnN0ZXAoYWN0aW9uKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGN1bXVsYXRpdmVfcmV3YXJkJTIwJTJCJTNEJTIwcmV3YXJkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBhbnkoeCUyMCElM0QlMjAwJTIwZm9yJTIweCUyMGluJTIwcmV3YXJkKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMkN1bXVsYXRpdmUlMjByZXdhcmQocyklMjAlM0QlMjIlMkMlMjBjdW11bGF0aXZlX3Jld2FyZCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGRvbmUuYW55KCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvYnNlcnZhdGlvbiUyMCUzRCUyMGVudi5yZXNldCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWslMEElMEElMjAlMjAlMjAlMjAlMjMlMjBDbG9zZSUyMHRoZSUyMGVudmlyb25tZW50JTBBJTIwJTIwJTIwJTIwZW52LmNsb3NlKCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBSZXR1cm4lMjBzdWNjZXNzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwMCUwQSUwQWlmJTIwX19uYW1lX18lMjAlM0QlM0QlMjAlMjJfX21haW5fXyUyMiUzQSUwQSUyMCUyMCUyMCUyMG1haW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> diambra.arena.stable_baselines3.make_sb3_env <span class="hljs-keyword">import</span> make_sb3_env, EnvironmentSettings, WrappersSettings
<span class="hljs-keyword">from</span> stable_baselines3 <span class="hljs-keyword">import</span> PPO

<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    <span class="hljs-comment"># Settings</span>
    settings = EnvironmentSettings()
    settings.frame_shape = (<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">1</span>)
    settings.characters = (<span class="hljs-string">&quot;Ryu&quot;</span>)

    <span class="hljs-comment"># Wrappers Settings</span>
    wrappers_settings = WrappersSettings()
    wrappers_settings.normalize_reward = <span class="hljs-literal">True</span>
    wrappers_settings.stack_frames = <span class="hljs-number">5</span>
    wrappers_settings.add_last_action = <span class="hljs-literal">True</span>
    wrappers_settings.stack_actions = <span class="hljs-number">12</span>
    wrappers_settings.scale = <span class="hljs-literal">True</span>
    wrappers_settings.exclude_image_scaling = <span class="hljs-literal">True</span>
    wrappers_settings.role_relative = <span class="hljs-literal">True</span>
    wrappers_settings.flatten = <span class="hljs-literal">True</span>
    wrappers_settings.filter_keys = [<span class="hljs-string">&quot;action&quot;</span>, <span class="hljs-string">&quot;own_health&quot;</span>, <span class="hljs-string">&quot;opp_health&quot;</span>, <span class="hljs-string">&quot;own_side&quot;</span>, <span class="hljs-string">&quot;opp_side&quot;</span>, <span class="hljs-string">&quot;opp_character&quot;</span>, <span class="hljs-string">&quot;stage&quot;</span>, <span class="hljs-string">&quot;timer&quot;</span>]

    <span class="hljs-comment"># Create environment</span>
    env, num_envs = make_sb3_env(<span class="hljs-string">&quot;sfiii3n&quot;</span>, settings, wrappers_settings)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Activated {} environment(s)&quot;</span>.<span class="hljs-built_in">format</span>(num_envs))

    <span class="hljs-comment"># Instantiate the agent</span>
    agent = PPO(<span class="hljs-string">&quot;MultiInputPolicy&quot;</span>, env, verbose=<span class="hljs-number">1</span>)

    <span class="hljs-comment"># Print policy network architecture</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Policy architecture:&quot;</span>)
    <span class="hljs-built_in">print</span>(agent.policy)

    <span class="hljs-comment"># Train the agent</span>
    agent.learn(total_timesteps=<span class="hljs-number">200</span>)

    <span class="hljs-comment"># Run trained agent</span>
    observation = env.reset()
    cumulative_reward = [<span class="hljs-number">0.0</span> <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_envs)]
    <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
        action, _state = agent.predict(observation, deterministic=<span class="hljs-literal">True</span>)

        observation, reward, done, info = env.step(action)
        cumulative_reward += reward
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">any</span>(x != <span class="hljs-number">0</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> reward):
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Cumulative reward(s) =&quot;</span>, cumulative_reward)

        <span class="hljs-keyword">if</span> done.<span class="hljs-built_in">any</span>():
            observation = env.reset()
            <span class="hljs-keyword">break</span>

    <span class="hljs-comment"># Close the environment</span>
    env.close()

    <span class="hljs-comment"># Return success</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">0</span>

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),ml=new w({props:{code:"ZGlhbWJyYSUyMHJ1biUyMC1zJTNEMiUyMHB5dGhvbiUyMHBhcmFsbGVsX2VudnMucHk=",highlighted:"diambra run -s=2 python parallel_envs.py",wrap:!1}}),Ul=new T({props:{title:"Advanced",local:"advanced",headingTag:"h3"}}),hl=new T({props:{title:"Complete Training Script",local:"complete-training-script",headingTag:"h4"}}),Bl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> argparse
<span class="hljs-keyword">from</span> diambra.arena <span class="hljs-keyword">import</span> load_settings_flat_dict, SpaceTypes
<span class="hljs-keyword">from</span> diambra.arena.stable_baselines3.make_sb3_env <span class="hljs-keyword">import</span> make_sb3_env, EnvironmentSettings, WrappersSettings
<span class="hljs-keyword">from</span> diambra.arena.stable_baselines3.sb3_utils <span class="hljs-keyword">import</span> linear_schedule, AutoSave
<span class="hljs-keyword">from</span> stable_baselines3 <span class="hljs-keyword">import</span> PPO

<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>(<span class="hljs-params">cfg_file</span>):
    <span class="hljs-comment"># Read the cfg file</span>
    yaml_file = <span class="hljs-built_in">open</span>(cfg_file)
    params = yaml.load(yaml_file, Loader=yaml.FullLoader)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Config parameters = &quot;</span>, json.dumps(params, sort_keys=<span class="hljs-literal">True</span>, indent=<span class="hljs-number">4</span>))
    yaml_file.close()

    base_path = os.path.dirname(os.path.abspath(__file__))
    model_folder = os.path.join(base_path, params[<span class="hljs-string">&quot;folders&quot;</span>][<span class="hljs-string">&quot;parent_dir&quot;</span>], params[<span class="hljs-string">&quot;settings&quot;</span>][<span class="hljs-string">&quot;game_id&quot;</span>],
                                params[<span class="hljs-string">&quot;folders&quot;</span>][<span class="hljs-string">&quot;model_name&quot;</span>], <span class="hljs-string">&quot;model&quot;</span>)
    tensor_board_folder = os.path.join(base_path, params[<span class="hljs-string">&quot;folders&quot;</span>][<span class="hljs-string">&quot;parent_dir&quot;</span>], params[<span class="hljs-string">&quot;settings&quot;</span>][<span class="hljs-string">&quot;game_id&quot;</span>],
                                        params[<span class="hljs-string">&quot;folders&quot;</span>][<span class="hljs-string">&quot;model_name&quot;</span>], <span class="hljs-string">&quot;tb&quot;</span>)

    os.makedirs(model_folder, exist_ok=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># Settings</span>
    params[<span class="hljs-string">&quot;settings&quot;</span>][<span class="hljs-string">&quot;action_space&quot;</span>] = SpaceTypes.DISCRETE <span class="hljs-keyword">if</span> params[<span class="hljs-string">&quot;settings&quot;</span>][<span class="hljs-string">&quot;action_space&quot;</span>] == <span class="hljs-string">&quot;discrete&quot;</span> <span class="hljs-keyword">else</span> SpaceTypes.MULTI_DISCRETE
    settings = load_settings_flat_dict(EnvironmentSettings, params[<span class="hljs-string">&quot;settings&quot;</span>])

    <span class="hljs-comment"># Wrappers Settings</span>
    wrappers_settings = load_settings_flat_dict(WrappersSettings, params[<span class="hljs-string">&quot;wrappers_settings&quot;</span>])

    <span class="hljs-comment"># Create environment</span>
    env, num_envs = make_sb3_env(settings.game_id, settings, wrappers_settings)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Activated {} environment(s)&quot;</span>.<span class="hljs-built_in">format</span>(num_envs))

    <span class="hljs-comment"># Policy param</span>
    policy_kwargs = params[<span class="hljs-string">&quot;policy_kwargs&quot;</span>]

    <span class="hljs-comment"># PPO settings</span>
    ppo_settings = params[<span class="hljs-string">&quot;ppo_settings&quot;</span>]
    gamma = ppo_settings[<span class="hljs-string">&quot;gamma&quot;</span>]
    model_checkpoint = ppo_settings[<span class="hljs-string">&quot;model_checkpoint&quot;</span>]

    learning_rate = linear_schedule(ppo_settings[<span class="hljs-string">&quot;learning_rate&quot;</span>][<span class="hljs-number">0</span>], ppo_settings[<span class="hljs-string">&quot;learning_rate&quot;</span>][<span class="hljs-number">1</span>])
    clip_range = linear_schedule(ppo_settings[<span class="hljs-string">&quot;clip_range&quot;</span>][<span class="hljs-number">0</span>], ppo_settings[<span class="hljs-string">&quot;clip_range&quot;</span>][<span class="hljs-number">1</span>])
    clip_range_vf = clip_range
    batch_size = ppo_settings[<span class="hljs-string">&quot;batch_size&quot;</span>]
    n_epochs = ppo_settings[<span class="hljs-string">&quot;n_epochs&quot;</span>]
    n_steps = ppo_settings[<span class="hljs-string">&quot;n_steps&quot;</span>]

    <span class="hljs-keyword">if</span> model_checkpoint == <span class="hljs-string">&quot;0&quot;</span>:
        <span class="hljs-comment"># Initialize the agent</span>
        agent = PPO(<span class="hljs-string">&quot;MultiInputPolicy&quot;</span>, env, verbose=<span class="hljs-number">1</span>,
                    gamma=gamma, batch_size=batch_size,
                    n_epochs=n_epochs, n_steps=n_steps,
                    learning_rate=learning_rate, clip_range=clip_range,
                    clip_range_vf=clip_range_vf, policy_kwargs=policy_kwargs,
                    tensorboard_log=tensor_board_folder)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-comment"># Load the trained agent</span>
        agent = PPO.load(os.path.join(model_folder, model_checkpoint), env=env,
                         gamma=gamma, learning_rate=learning_rate, clip_range=clip_range,
                         clip_range_vf=clip_range_vf, policy_kwargs=policy_kwargs,
                         tensorboard_log=tensor_board_folder)


    <span class="hljs-comment"># Print policy network architecture</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Policy architecture:&quot;</span>)
    <span class="hljs-built_in">print</span>(agent.policy)

    <span class="hljs-comment"># Create the callback: autosave every USER DEF steps</span>
    autosave_freq = ppo_settings[<span class="hljs-string">&quot;autosave_freq&quot;</span>]
    auto_save_callback = AutoSave(check_freq=autosave_freq, num_envs=num_envs,
                                  save_path=model_folder, filename_prefix=model_checkpoint + <span class="hljs-string">&quot;_&quot;</span>)

    <span class="hljs-comment"># Train the agent</span>
    time_steps = ppo_settings[<span class="hljs-string">&quot;time_steps&quot;</span>]
    agent.learn(total_timesteps=time_steps, callback=auto_save_callback)

    <span class="hljs-comment"># Save the agent</span>
    new_model_checkpoint = <span class="hljs-built_in">str</span>(<span class="hljs-built_in">int</span>(model_checkpoint) + time_steps)
    model_path = os.path.join(model_folder, new_model_checkpoint)
    agent.save(model_path)

    <span class="hljs-comment"># Close the environment</span>
    env.close()

    <span class="hljs-comment"># Return success</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">0</span>

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    parser = argparse.ArgumentParser()
    parser.add_argument(<span class="hljs-string">&quot;--cfgFile&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>, required=<span class="hljs-literal">True</span>, <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;Configuration file&quot;</span>)
    opt = parser.parse_args()
    <span class="hljs-built_in">print</span>(opt)

    main(opt.cfgFile)`,wrap:!1}}),Cl=new w({props:{code:"ZGlhbWJyYSUyMHJ1biUyMHB5dGhvbiUyMHRyYWluaW5nLnB5JTIwLS1jZmdGaWxlJTIwJTJGYWJzb2x1dGUlMkZwYXRoJTJGdG8lMkZjb25maWcueWFtbA==",highlighted:"diambra run python training.py --cfgFile /absolute/path/to/config.yaml",wrap:!1}}),gl=new w({props:{code:"Zm9sZGVycyUzQSUwQSUyMCUyMHBhcmVudF9kaXIlM0ElMjAlMjIuJTJGcmVzdWx0cyUyRiUyMiUwQSUyMCUyMG1vZGVsX25hbWUlM0ElMjAlMjJzcjZfMTI4eDRfZGFzX25jJTIyJTBBJTBBc2V0dGluZ3MlM0ElMEElMjAlMjBnYW1lX2lkJTNBJTIwJTIyc2ZpaWkzbiUyMiUwQSUyMCUyMHN0ZXBfcmF0aW8lM0ElMjA2JTBBJTIwJTIwZnJhbWVfc2hhcGUlM0ElMjAhIXB5dGhvbiUyRnR1cGxlJTIwJTVCMTI4JTJDJTIwMTI4JTJDJTIwMSU1RCUwQSUyMCUyMGNvbnRpbnVlX2dhbWUlM0ElMjAwLjAlMEElMjAlMjBhY3Rpb25fc3BhY2UlM0ElMjAlMjJkaXNjcmV0ZSUyMiUwQSUyMCUyMGNoYXJhY3RlcnMlM0ElMjAlMjJSeXUlMjIlMEElMjAlMjBkaWZmaWN1bHR5JTNBJTIwNiUwQSUyMCUyMG91dGZpdHMlM0ElMjAyJTBBJTBBd3JhcHBlcnNfc2V0dGluZ3MlM0ElMEElMjAlMjBub3JtYWxpemVfcmV3YXJkJTNBJTIwdHJ1ZSUwQSUyMCUyMG5vX2F0dGFja19idXR0b25zX2NvbWJpbmF0aW9ucyUzQSUyMHRydWUlMEElMjAlMjBzdGFja19mcmFtZXMlM0ElMjA0JTBBJTIwJTIwZGlsYXRpb24lM0ElMjAxJTBBJTIwJTIwYWRkX2xhc3RfYWN0aW9uJTNBJTIwdHJ1ZSUwQSUyMCUyMHN0YWNrX2FjdGlvbnMlM0ElMjAxMiUwQSUyMCUyMHNjYWxlJTNBJTIwdHJ1ZSUwQSUyMCUyMGV4Y2x1ZGVfaW1hZ2Vfc2NhbGluZyUzQSUyMHRydWUlMEElMjAlMjByb2xlX3JlbGF0aXZlJTNBJTIwdHJ1ZSUwQSUyMCUyMGZsYXR0ZW4lM0ElMjB0cnVlJTBBJTIwJTIwZmlsdGVyX2tleXMlM0ElMjAlNUIlMjJhY3Rpb24lMjIlMkMlMjAlMjJvd25faGVhbHRoJTIyJTJDJTIwJTIyb3BwX2hlYWx0aCUyMiUyQyUyMCUyMm93bl9zaWRlJTIyJTJDJTIwJTIyb3BwX3NpZGUlMjIlMkMlMjAlMjJvcHBfY2hhcmFjdGVyJTIyJTJDJTIwJTIyc3RhZ2UlMjIlMkMlMjAlMjJ0aW1lciUyMiU1RCUwQSUwQXBvbGljeV9rd2FyZ3MlM0ElMEElMjAlMjAlMjNuZXRfYXJjaCUzQSUyMCU1QiU3QiUyMHBpJTNBJTIwJTVCNjQlMkMlMjA2NCU1RCUyQyUyMHZmJTNBJTIwJTVCMzIlMkMlMjAzMiU1RCUyMCU3RCU1RCUwQSUyMCUyMG5ldF9hcmNoJTNBJTIwJTVCNjQlMkMlMjA2NCU1RCUwQSUwQXBwb19zZXR0aW5ncyUzQSUwQSUyMCUyMGdhbW1hJTNBJTIwMC45NCUwQSUyMCUyMG1vZGVsX2NoZWNrcG9pbnQlM0ElMjAlMjIwJTIyJTBBJTIwJTIwbGVhcm5pbmdfcmF0ZSUzQSUyMCU1QjIuNWUtNCUyQyUyMDIuNWUtNiU1RCUyMCUyMyUyMFRvJTIwc3RhcnQlMEElMjAlMjBjbGlwX3JhbmdlJTNBJTIwJTVCMC4xNSUyQyUyMDAuMDI1JTVEJTIwJTIzJTIwVG8lMjBzdGFydCUwQSUyMCUyMCUyM2xlYXJuaW5nX3JhdGUlM0ElMjAlNUI1LjBlLTUlMkMlMjAyLjVlLTYlNUQlMjAlMjMlMjBGaW5lJTIwVHVuaW5nJTBBJTIwJTIwJTIzY2xpcF9yYW5nZSUzQSUyMCU1QjAuMDc1JTJDJTIwMC4wMjUlNUQlMjAlMjMlMjBGaW5lJTIwVHVuaW5nJTBBJTIwJTIwYmF0Y2hfc2l6ZSUzQSUyMDI1NiUyMCUyMzglMjAlMjNubWluaWJhdGNoZXMlMjBnYXZlJTIwZGlmZmVyZW50JTIwYmF0Y2glMjBzaXplJTIwZGVwZW5kaW5nJTIwb24lMjB0aGUlMjBudW1iZXIlMjBvZiUyMGVudmlyb25tZW50cyUzQSUyMGJhdGNoX3NpemUlMjAlM0QlMjAobl9zdGVwcyUyMColMjBuX2VudnMpJTIwJTJGJTJGJTIwbm1pbmliYXRjaGVzJTBBJTIwJTIwbl9lcG9jaHMlM0ElMjA0JTBBJTIwJTIwbl9zdGVwcyUzQSUyMDEyOCUwQSUyMCUyMGF1dG9zYXZlX2ZyZXElM0ElMjAyNTYlMEElMjAlMjB0aW1lX3N0ZXBzJTNBJTIwNTEy",highlighted:`<span class="hljs-attr">folders:</span>
  <span class="hljs-attr">parent_dir:</span> <span class="hljs-string">&quot;./results/&quot;</span>
  <span class="hljs-attr">model_name:</span> <span class="hljs-string">&quot;sr6_128x4_das_nc&quot;</span>

<span class="hljs-attr">settings:</span>
  <span class="hljs-attr">game_id:</span> <span class="hljs-string">&quot;sfiii3n&quot;</span>
  <span class="hljs-attr">step_ratio:</span> <span class="hljs-number">6</span>
  <span class="hljs-attr">frame_shape:</span> <span class="hljs-type">!!python/tuple</span> [<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">1</span>]
  <span class="hljs-attr">continue_game:</span> <span class="hljs-number">0.0</span>
  <span class="hljs-attr">action_space:</span> <span class="hljs-string">&quot;discrete&quot;</span>
  <span class="hljs-attr">characters:</span> <span class="hljs-string">&quot;Ryu&quot;</span>
  <span class="hljs-attr">difficulty:</span> <span class="hljs-number">6</span>
  <span class="hljs-attr">outfits:</span> <span class="hljs-number">2</span>

<span class="hljs-attr">wrappers_settings:</span>
  <span class="hljs-attr">normalize_reward:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">no_attack_buttons_combinations:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">stack_frames:</span> <span class="hljs-number">4</span>
  <span class="hljs-attr">dilation:</span> <span class="hljs-number">1</span>
  <span class="hljs-attr">add_last_action:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">stack_actions:</span> <span class="hljs-number">12</span>
  <span class="hljs-attr">scale:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">exclude_image_scaling:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">role_relative:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">flatten:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">filter_keys:</span> [<span class="hljs-string">&quot;action&quot;</span>, <span class="hljs-string">&quot;own_health&quot;</span>, <span class="hljs-string">&quot;opp_health&quot;</span>, <span class="hljs-string">&quot;own_side&quot;</span>, <span class="hljs-string">&quot;opp_side&quot;</span>, <span class="hljs-string">&quot;opp_character&quot;</span>, <span class="hljs-string">&quot;stage&quot;</span>, <span class="hljs-string">&quot;timer&quot;</span>]

<span class="hljs-attr">policy_kwargs:</span>
  <span class="hljs-comment">#net_arch: [{ pi: [64, 64], vf: [32, 32] }]</span>
  <span class="hljs-attr">net_arch:</span> [<span class="hljs-number">64</span>, <span class="hljs-number">64</span>]

<span class="hljs-attr">ppo_settings:</span>
  <span class="hljs-attr">gamma:</span> <span class="hljs-number">0.94</span>
  <span class="hljs-attr">model_checkpoint:</span> <span class="hljs-string">&quot;0&quot;</span>
  <span class="hljs-attr">learning_rate:</span> [<span class="hljs-number">2.5e-4</span>, <span class="hljs-number">2.5e-6</span>] <span class="hljs-comment"># To start</span>
  <span class="hljs-attr">clip_range:</span> [<span class="hljs-number">0.15</span>, <span class="hljs-number">0.025</span>] <span class="hljs-comment"># To start</span>
  <span class="hljs-comment">#learning_rate: [5.0e-5, 2.5e-6] # Fine Tuning</span>
  <span class="hljs-comment">#clip_range: [0.075, 0.025] # Fine Tuning</span>
  <span class="hljs-attr">batch_size:</span> <span class="hljs-number">256</span> <span class="hljs-comment">#8 #nminibatches gave different batch size depending on the number of environments: batch_size = (n_steps * n_envs) // nminibatches</span>
  <span class="hljs-attr">n_epochs:</span> <span class="hljs-number">4</span>
  <span class="hljs-attr">n_steps:</span> <span class="hljs-number">128</span>
  <span class="hljs-attr">autosave_freq:</span> <span class="hljs-number">256</span>
  <span class="hljs-attr">time_steps:</span> <span class="hljs-number">512</span>`,wrap:!1}}),Wl=new qa({props:{source:"https://github.com/huggingface/deep-rl-class/blob/main/units/en/unitbonus3/training.mdx"}}),{c(){m=M("meta"),_l=e(),vl=M("p"),Xl=e(),j(U.$$.fragment),El=e(),h=M("img"),Vl=e(),u=M("p"),u.textContent=Ps,Rl=e(),d=M("p"),d.innerHTML=Os,Yl=e(),j(I.$$.fragment),kl=e(),b=M("p"),b.textContent=la,Nl=e(),B=M("p"),B.innerHTML=sa,Ql=e(),j(A.$$.fragment),Sl=e(),C=M("p"),C.innerHTML=aa,zl=e(),j(Z.$$.fragment),Fl=e(),j(g.$$.fragment),xl=e(),f=M("p"),f.textContent=ta,Hl=e(),j(W.$$.fragment),ql=e(),v=M("p"),v.textContent=ea,$l=e(),G=M("p"),G.textContent=na,Ll=e(),j(_.$$.fragment),Dl=e(),X=M("p"),X.textContent=Ma,Kl=e(),E=M("p"),E.textContent=pa,Pl=e(),j(V.$$.fragment),Ol=e(),R=M("p"),R.textContent=ia,ls=e(),Y=M("p"),Y.textContent=ja,ss=e(),j(k.$$.fragment),as=e(),N=M("p"),N.textContent=Ja,ts=e(),j(Q.$$.fragment),es=e(),S=M("p"),S.innerHTML=ca,ns=e(),z=M("p"),z.innerHTML=ra,Ms=e(),F=M("p"),F.textContent=ya,ps=e(),j(x.$$.fragment),is=e(),H=M("p"),H.textContent=oa,js=e(),q=M("p"),q.textContent=wa,Js=e(),$=M("p"),$.innerHTML=Ta,cs=e(),L=M("p"),L.textContent=ma,rs=e(),j(D.$$.fragment),ys=e(),K=M("p"),K.textContent=Ua,os=e(),P=M("ul"),P.innerHTML=ha,ws=e(),O=M("p"),O.innerHTML=ua,Ts=e(),j(ll.$$.fragment),ms=e(),sl=M("p"),sl.textContent=da,Us=e(),j(al.$$.fragment),hs=e(),j(tl.$$.fragment),us=e(),el=M("p"),el.textContent=Ia,ds=e(),nl=M("ul"),nl.innerHTML=ba,Is=e(),Ml=M("p"),Ml.textContent=Ba,bs=e(),j(pl.$$.fragment),Bs=e(),il=M("p"),il.textContent=Aa,As=e(),j(jl.$$.fragment),Cs=e(),j(Jl.$$.fragment),Zs=e(),cl=M("p"),cl.textContent=Ca,gs=e(),rl=M("ul"),rl.innerHTML=Za,fs=e(),yl=M("p"),yl.innerHTML=ga,Ws=e(),ol=M("p"),ol.textContent=fa,vs=e(),j(wl.$$.fragment),Gs=e(),Tl=M("p"),Tl.textContent=Wa,_s=e(),j(ml.$$.fragment),Xs=e(),j(Ul.$$.fragment),Es=e(),j(hl.$$.fragment),Vs=e(),ul=M("p"),ul.textContent=va,Rs=e(),dl=M("ul"),dl.innerHTML=Ga,Ys=e(),Il=M("p"),Il.textContent=_a,ks=e(),bl=M("ul"),bl.innerHTML=Xa,Ns=e(),j(Bl.$$.fragment),Qs=e(),Al=M("p"),Al.textContent=Ea,Ss=e(),j(Cl.$$.fragment),zs=e(),Zl=M("p"),Zl.textContent=Va,Fs=e(),j(gl.$$.fragment),xs=e(),fl=M("p"),fl.innerHTML=Ra,Hs=e(),j(Wl.$$.fragment),qs=e(),Gl=M("p"),this.h()},l(l){const s=xa("svelte-u9bgzb",document.head);m=p(s,"META",{name:!0,content:!0}),s.forEach(a),_l=n(l),vl=p(l,"P",{}),Ya(vl).forEach(a),Xl=n(l),J(U.$$.fragment,l),El=n(l),h=p(l,"IMG",{src:!0,alt:!0}),Vl=n(l),u=p(l,"P",{"data-svelte-h":!0}),i(u)!=="svelte-owashs"&&(u.textContent=Ps),Rl=n(l),d=p(l,"P",{"data-svelte-h":!0}),i(d)!=="svelte-1xb9n3g"&&(d.innerHTML=Os),Yl=n(l),J(I.$$.fragment,l),kl=n(l),b=p(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-9g79q4"&&(b.textContent=la),Nl=n(l),B=p(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-14t2dlf"&&(B.innerHTML=sa),Ql=n(l),J(A.$$.fragment,l),Sl=n(l),C=p(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1oenxms"&&(C.innerHTML=aa),zl=n(l),J(Z.$$.fragment,l),Fl=n(l),J(g.$$.fragment,l),xl=n(l),f=p(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1tjvn7b"&&(f.textContent=ta),Hl=n(l),J(W.$$.fragment,l),ql=n(l),v=p(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1fby91n"&&(v.textContent=ea),$l=n(l),G=p(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-92bv3"&&(G.textContent=na),Ll=n(l),J(_.$$.fragment,l),Dl=n(l),X=p(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-wv1lol"&&(X.textContent=Ma),Kl=n(l),E=p(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1mcl5i6"&&(E.textContent=pa),Pl=n(l),J(V.$$.fragment,l),Ol=n(l),R=p(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1lzykdb"&&(R.textContent=ia),ls=n(l),Y=p(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-ovael2"&&(Y.textContent=ja),ss=n(l),J(k.$$.fragment,l),as=n(l),N=p(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1lfy5yf"&&(N.textContent=Ja),ts=n(l),J(Q.$$.fragment,l),es=n(l),S=p(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1wk2ykj"&&(S.innerHTML=ca),ns=n(l),z=p(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-9db1t0"&&(z.innerHTML=ra),Ms=n(l),F=p(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-13m3wb0"&&(F.textContent=ya),ps=n(l),J(x.$$.fragment,l),is=n(l),H=p(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1hjd7mf"&&(H.textContent=oa),js=n(l),q=p(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-p5u6t2"&&(q.textContent=wa),Js=n(l),$=p(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-7b564"&&($.innerHTML=Ta),cs=n(l),L=p(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-740v88"&&(L.textContent=ma),rs=n(l),J(D.$$.fragment,l),ys=n(l),K=p(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-748lue"&&(K.textContent=Ua),os=n(l),P=p(l,"UL",{"data-svelte-h":!0}),i(P)!=="svelte-17crx4k"&&(P.innerHTML=ha),ws=n(l),O=p(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-giq31x"&&(O.innerHTML=ua),Ts=n(l),J(ll.$$.fragment,l),ms=n(l),sl=p(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-18srs95"&&(sl.textContent=da),Us=n(l),J(al.$$.fragment,l),hs=n(l),J(tl.$$.fragment,l),us=n(l),el=p(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-1wnf768"&&(el.textContent=Ia),ds=n(l),nl=p(l,"UL",{"data-svelte-h":!0}),i(nl)!=="svelte-795hwk"&&(nl.innerHTML=ba),Is=n(l),Ml=p(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-1mckvlq"&&(Ml.textContent=Ba),bs=n(l),J(pl.$$.fragment,l),Bs=n(l),il=p(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-18srs95"&&(il.textContent=Aa),As=n(l),J(jl.$$.fragment,l),Cs=n(l),J(Jl.$$.fragment,l),Zs=n(l),cl=p(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-1k3ca7y"&&(cl.textContent=Ca),gs=n(l),rl=p(l,"UL",{"data-svelte-h":!0}),i(rl)!=="svelte-17ck2vr"&&(rl.innerHTML=Za),fs=n(l),yl=p(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-bfpiy7"&&(yl.innerHTML=ga),Ws=n(l),ol=p(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-113v6y6"&&(ol.textContent=fa),vs=n(l),J(wl.$$.fragment,l),Gs=n(l),Tl=p(l,"P",{"data-svelte-h":!0}),i(Tl)!=="svelte-18srs95"&&(Tl.textContent=Wa),_s=n(l),J(ml.$$.fragment,l),Xs=n(l),J(Ul.$$.fragment,l),Es=n(l),J(hl.$$.fragment,l),Vs=n(l),ul=p(l,"P",{"data-svelte-h":!0}),i(ul)!=="svelte-1k3ca7y"&&(ul.textContent=va),Rs=n(l),dl=p(l,"UL",{"data-svelte-h":!0}),i(dl)!=="svelte-1n0q0q8"&&(dl.innerHTML=Ga),Ys=n(l),Il=p(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-skt7rm"&&(Il.textContent=_a),ks=n(l),bl=p(l,"UL",{"data-svelte-h":!0}),i(bl)!=="svelte-1bg2xnd"&&(bl.innerHTML=Xa),Ns=n(l),J(Bl.$$.fragment,l),Qs=n(l),Al=p(l,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-18srs95"&&(Al.textContent=Ea),Ss=n(l),J(Cl.$$.fragment,l),zs=n(l),Zl=p(l,"P",{"data-svelte-h":!0}),i(Zl)!=="svelte-1atov14"&&(Zl.textContent=Va),Fs=n(l),J(gl.$$.fragment,l),xs=n(l),fl=p(l,"P",{"data-svelte-h":!0}),i(fl)!=="svelte-3guhfw"&&(fl.innerHTML=Ra),Hs=n(l),J(Wl.$$.fragment,l),qs=n(l),Gl=p(l,"P",{}),Ya(Gl).forEach(a),this.h()},h(){Ls(m,"name","hf:doc:metadata"),Ls(m,"content",La),Na(h.src,Ks="https://github.com/diambra/agents/blob/main/img/agents.jpg?raw=true")||Ls(h,"src",Ks),Ls(h,"alt","DIAMBRA Agents")},m(l,s){Ha(document.head,m),t(l,_l,s),t(l,vl,s),t(l,Xl,s),c(U,l,s),t(l,El,s),t(l,h,s),t(l,Vl,s),t(l,u,s),t(l,Rl,s),t(l,d,s),t(l,Yl,s),c(I,l,s),t(l,kl,s),t(l,b,s),t(l,Nl,s),t(l,B,s),t(l,Ql,s),c(A,l,s),t(l,Sl,s),t(l,C,s),t(l,zl,s),c(Z,l,s),t(l,Fl,s),c(g,l,s),t(l,xl,s),t(l,f,s),t(l,Hl,s),c(W,l,s),t(l,ql,s),t(l,v,s),t(l,$l,s),t(l,G,s),t(l,Ll,s),c(_,l,s),t(l,Dl,s),t(l,X,s),t(l,Kl,s),t(l,E,s),t(l,Pl,s),c(V,l,s),t(l,Ol,s),t(l,R,s),t(l,ls,s),t(l,Y,s),t(l,ss,s),c(k,l,s),t(l,as,s),t(l,N,s),t(l,ts,s),c(Q,l,s),t(l,es,s),t(l,S,s),t(l,ns,s),t(l,z,s),t(l,Ms,s),t(l,F,s),t(l,ps,s),c(x,l,s),t(l,is,s),t(l,H,s),t(l,js,s),t(l,q,s),t(l,Js,s),t(l,$,s),t(l,cs,s),t(l,L,s),t(l,rs,s),c(D,l,s),t(l,ys,s),t(l,K,s),t(l,os,s),t(l,P,s),t(l,ws,s),t(l,O,s),t(l,Ts,s),c(ll,l,s),t(l,ms,s),t(l,sl,s),t(l,Us,s),c(al,l,s),t(l,hs,s),c(tl,l,s),t(l,us,s),t(l,el,s),t(l,ds,s),t(l,nl,s),t(l,Is,s),t(l,Ml,s),t(l,bs,s),c(pl,l,s),t(l,Bs,s),t(l,il,s),t(l,As,s),c(jl,l,s),t(l,Cs,s),c(Jl,l,s),t(l,Zs,s),t(l,cl,s),t(l,gs,s),t(l,rl,s),t(l,fs,s),t(l,yl,s),t(l,Ws,s),t(l,ol,s),t(l,vs,s),c(wl,l,s),t(l,Gs,s),t(l,Tl,s),t(l,_s,s),c(ml,l,s),t(l,Xs,s),c(Ul,l,s),t(l,Es,s),c(hl,l,s),t(l,Vs,s),t(l,ul,s),t(l,Rs,s),t(l,dl,s),t(l,Ys,s),t(l,Il,s),t(l,ks,s),t(l,bl,s),t(l,Ns,s),c(Bl,l,s),t(l,Qs,s),t(l,Al,s),t(l,Ss,s),c(Cl,l,s),t(l,zs,s),t(l,Zl,s),t(l,Fs,s),c(gl,l,s),t(l,xs,s),t(l,fl,s),t(l,Hs,s),c(Wl,l,s),t(l,qs,s),t(l,Gl,s),$s=!0},p:Qa,i(l){$s||(r(U.$$.fragment,l),r(I.$$.fragment,l),r(A.$$.fragment,l),r(Z.$$.fragment,l),r(g.$$.fragment,l),r(W.$$.fragment,l),r(_.$$.fragment,l),r(V.$$.fragment,l),r(k.$$.fragment,l),r(Q.$$.fragment,l),r(x.$$.fragment,l),r(D.$$.fragment,l),r(ll.$$.fragment,l),r(al.$$.fragment,l),r(tl.$$.fragment,l),r(pl.$$.fragment,l),r(jl.$$.fragment,l),r(Jl.$$.fragment,l),r(wl.$$.fragment,l),r(ml.$$.fragment,l),r(Ul.$$.fragment,l),r(hl.$$.fragment,l),r(Bl.$$.fragment,l),r(Cl.$$.fragment,l),r(gl.$$.fragment,l),r(Wl.$$.fragment,l),$s=!0)},o(l){y(U.$$.fragment,l),y(I.$$.fragment,l),y(A.$$.fragment,l),y(Z.$$.fragment,l),y(g.$$.fragment,l),y(W.$$.fragment,l),y(_.$$.fragment,l),y(V.$$.fragment,l),y(k.$$.fragment,l),y(Q.$$.fragment,l),y(x.$$.fragment,l),y(D.$$.fragment,l),y(ll.$$.fragment,l),y(al.$$.fragment,l),y(tl.$$.fragment,l),y(pl.$$.fragment,l),y(jl.$$.fragment,l),y(Jl.$$.fragment,l),y(wl.$$.fragment,l),y(ml.$$.fragment,l),y(Ul.$$.fragment,l),y(hl.$$.fragment,l),y(Bl.$$.fragment,l),y(Cl.$$.fragment,l),y(gl.$$.fragment,l),y(Wl.$$.fragment,l),$s=!1},d(l){l&&(a(_l),a(vl),a(Xl),a(El),a(h),a(Vl),a(u),a(Rl),a(d),a(Yl),a(kl),a(b),a(Nl),a(B),a(Ql),a(Sl),a(C),a(zl),a(Fl),a(xl),a(f),a(Hl),a(ql),a(v),a($l),a(G),a(Ll),a(Dl),a(X),a(Kl),a(E),a(Pl),a(Ol),a(R),a(ls),a(Y),a(ss),a(as),a(N),a(ts),a(es),a(S),a(ns),a(z),a(Ms),a(F),a(ps),a(is),a(H),a(js),a(q),a(Js),a($),a(cs),a(L),a(rs),a(ys),a(K),a(os),a(P),a(ws),a(O),a(Ts),a(ms),a(sl),a(Us),a(hs),a(us),a(el),a(ds),a(nl),a(Is),a(Ml),a(bs),a(Bs),a(il),a(As),a(Cs),a(Zs),a(cl),a(gs),a(rl),a(fs),a(yl),a(Ws),a(ol),a(vs),a(Gs),a(Tl),a(_s),a(Xs),a(Es),a(Vs),a(ul),a(Rs),a(dl),a(Ys),a(Il),a(ks),a(bl),a(Ns),a(Qs),a(Al),a(Ss),a(zs),a(Zl),a(Fs),a(xs),a(fl),a(Hs),a(qs),a(Gl)),a(m),o(U,l),o(I,l),o(A,l),o(Z,l),o(g,l),o(W,l),o(_,l),o(V,l),o(k,l),o(Q,l),o(x,l),o(D,l),o(ll,l),o(al,l),o(tl,l),o(pl,l),o(jl,l),o(Jl,l),o(wl,l),o(ml,l),o(Ul,l),o(hl,l),o(Bl,l),o(Cl,l),o(gl,l),o(Wl,l)}}}const La='{"title":"Reinforcement Learning Training","local":"reinforcement-learning-training","sections":[{"title":"Creating Scripted Agents","local":"creating-scripted-agents","sections":[{"title":"No-Action Agent","local":"no-action-agent","sections":[],"depth":3},{"title":"Random Agent","local":"random-agent","sections":[],"depth":3}],"depth":2},{"title":"Training DeepRL Agents","local":"training-deeprl-agents","sections":[{"title":"Getting Ready","local":"getting-ready","sections":[],"depth":3},{"title":"Basic","local":"basic","sections":[{"title":"Basic Example","local":"basic-example","sections":[],"depth":4},{"title":"Saving, loading and evaluating","local":"saving-loading-and-evaluating","sections":[],"depth":4},{"title":"Parallel Environments","local":"parallel-environments","sections":[],"depth":4}],"depth":3},{"title":"Advanced","local":"advanced","sections":[{"title":"Complete Training Script","local":"complete-training-script","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function Da(Ds){return Sa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class st extends za{constructor(m){super(),Fa(this,m,Da,$a,ka,{})}}export{st as component};
