import{s as Za,o as Na}from"../chunks/scheduler.f6b352c8.js";import{S as Ea,i as Ya,g as r,s as o,r as d,A as Va,h as n,f as s,c as l,j as Wa,u as i,x as m,k as ma,y as Ha,a as t,v as p,d as u,t as M,w as c,m as Fa,n as Xa}from"../chunks/index.7f38e934.js";import{T as Qa}from"../chunks/Tip.ae532637.js";import{C as y}from"../chunks/CodeBlock.3ee8293b.js";import{H as na,E as Sa}from"../chunks/getInferenceSnippets.fe140833.js";function La(ue){let j;return{c(){j=Fa("💡 Algumas informações sobre a reamostragem (resampling): Se um sinal de áudio foi amostrado a 8 kHz, de modo que possui 8000 amostras coletadas por segundo, sabemos que o áudio não contém frequências acima de 4 kHz. Isso é garantido pelo teorema de Nyquist. Com base nisso, podemos assumir que entre as amostras de um sinal contínuo, especificamente os pontos que existem entre elas, e não foram coletados, devido a amostragem, formam uma curva suave. Então, aumentar a taxa de amostragem para um valor mais alto é apenas uma questão de calcular valores de amostra adicionais que vão entre os existentes, formando essa curva suave. No entanto, diminuir a amostragem (downsampling) requer primeiro filtrar quaisquer frequências que seriam maiores que o novo limite de Nyquist, antes de estimar os novos pontos de amostra (pois diminuindo a amostragem, a frequência máxima também diminuiria). Em outras palavras, você não pode diminuir a amostragem por um fator de 2x simplesmente descartando todas as outras amostras - isso criará distorções no sinal chamadas de alias. Fazer a reamostragem corretamente é complicado e é melhor deixar para bibliotecas bem testadas como librosa ou 🤗 Datasets.")},l(f){j=Xa(f,"💡 Algumas informações sobre a reamostragem (resampling): Se um sinal de áudio foi amostrado a 8 kHz, de modo que possui 8000 amostras coletadas por segundo, sabemos que o áudio não contém frequências acima de 4 kHz. Isso é garantido pelo teorema de Nyquist. Com base nisso, podemos assumir que entre as amostras de um sinal contínuo, especificamente os pontos que existem entre elas, e não foram coletados, devido a amostragem, formam uma curva suave. Então, aumentar a taxa de amostragem para um valor mais alto é apenas uma questão de calcular valores de amostra adicionais que vão entre os existentes, formando essa curva suave. No entanto, diminuir a amostragem (downsampling) requer primeiro filtrar quaisquer frequências que seriam maiores que o novo limite de Nyquist, antes de estimar os novos pontos de amostra (pois diminuindo a amostragem, a frequência máxima também diminuiria). Em outras palavras, você não pode diminuir a amostragem por um fator de 2x simplesmente descartando todas as outras amostras - isso criará distorções no sinal chamadas de alias. Fazer a reamostragem corretamente é complicado e é melhor deixar para bibliotecas bem testadas como librosa ou 🤗 Datasets.")},m(f,U){t(f,j,U)},d(f){f&&s(j)}}}function Pa(ue){let j,f,U,Me,h,ce,w,da="Carregar um dataset com 🤗 Datasets é parte da brincadeira. Se você planeja usá-lo para treinar um modelo, ou para executar inferência, você precisará pré-processar os dados primeiro. Geralmente, isso se resume nas seguintes etapas:",je,b,ia="<li>Reamostragem (resampling) dos dados de áudio</li> <li>Filtragem do dataset</li> <li>Conversão dos dados de áudio para a formato esperado pelo modelo</li>",ye,g,fe,I,pa="A função <code>load_dataset</code> baixa exemplos de áudio com a taxa de amostragem na qual foram publicados. Esta não é sempre a taxa de amostragem esperada por um modelo que você planeja treinar, ou usar para inferência. Se houver uma diferença entre as taxas de amostragem, você pode reamostrar (resample) o áudio para a taxa de amostragem esperada pelo modelo.",Je,C,ua="A maioria dos modelos pré-treinados disponíveis foram treinados em datasets de áudio com uma taxa de amostragem de 16 kHz. Quando exploramos o dataset MINDS-14, você pode ter notado que ele é amostrado a 8 kHz, o que significa que provavelmente precisaremos aumentar a amostragem.",Te,A,Ma="Para fazer isso, use o método <code>cast_column</code> de 🤗 Datasets. Esta operação não altera o arquivo de áudio baixado, mas indica aos datasets para reamostrar os exemplos de áudio sob demanda a medida que forem carregados. O seguinte código definirá a taxa de amostragem para 16kHz:",Ue,v,he,x,ca="Recarregue o primeiro exemplo de áudio no dataset MINDS-14, e verifique se ele foi reamostrado para a <code>taxa de amostragem</code> desejada:",we,$,be,q,ja="<strong>Saída:</strong>",ge,_,Ie,z,ya="Repare que os valores do array também estão diferentes agora. Isso ocorre porque agora temos o dobro do número de valores de amplitude para cada um que tínhamos antes.",Ce,J,Ae,k,ve,B,fa="Talvez você precise filtrar os dados com base em alguns critérios. Um dos casos comuns envolve limitar os exemplos de áudio a uma certa duração. Por exemplo, podemos querer ignorar quaisquer exemplos mais longos que 20s para prevenir erros de falta de memória ao treinar um modelo.",xe,G,Ja="Podemos fazer isso usando o método <code>filter</code> da 🤗 Datasets e passando uma função com a lógica de filtragem para ele. Vamos começar escrevendo uma função que indica quais exemplos manter e quais descartar. Esta função, <code>is_audio_length_in_range</code>, retorna <code>True</code> se a duração for menor 20s, e <code>False</code> se for maior.",$e,R,qe,W,Ta="A função de filtragem pode ser aplicada a uma coluna do dataset, mas não temos uma coluna com a duração da do áudio neste dataset. No entanto, podemos criar uma, filtrar com base nos valores dessa coluna e, em seguida, removê-la.",_e,Z,ze,N,Ua="<strong>Saída:</strong>",ke,E,Be,Y,ha="Perceba que o dataset foi filtrado de 654 exemplos para 624 (num_rows).",Ge,V,Re,H,wa="Um dos aspectos mais desafiadores de trabalhar com datasets de áudio é preparar os dados no formato correto para o treinamento do modelo. Como você viu, os dados de áudio brutos vêm como um array de valores de amostras (do sinal original). No entanto, modelos pré-treinados, seja para usá-los em inferência, seja para ajustá-los (fine tuning) ao seu projeto, esperam que os dados brutos sejam convertidos em características (features) de entrada. Os requisitos para as características de entrada podem variar de um modelo para outro - eles dependem da arquitetura do modelo e dos dados com os quais foi pré-treinado. A boa notícia é que, para cada modelo de áudio suportado, 🤗 Transformers oferece uma classe de extrator de características (feature extractor) que pode converter dados de áudio brutos nas características de entrada que o modelo espera.",We,F,ba='Então, o que um extrator de características faz com os dados de áudio brutos? Vamos dar uma olhada extrator de características chamado <a href="https://huggingface.co/papers/2212.04356" rel="nofollow">Whisper</a> para entender algumas transformações comuns de extração de características. Whisper é um modelo pré-treinado para reconhecimento automático de fala (ASR) publicado em setembro de 2022 por Alec Radford et al. da OpenAI.',Ze,X,ga="Primeiro, o extrator de características do Whisper preenche/corta um grupo (batch) de exemplos de áudio de forma que todos os exemplos tenham uma duração de 30s. Exemplos mais curtos que isso são complementados com zeros no final, até formar 30s de duração (zeros em um sinal de áudio correspondem a silêncio ou nada de sinal). Exemplos que tem mais de 30s são cortados nos 30s. Uma vez que todos os elementos no grupo são padronizados para uma duração fixa, não há necessidade de uma máscara de atenção (attention mask). O Whisper é único neste aspecto, a maioria dos outros modelos de áudio requer uma máscara de atenção que detalha onde as sequências foram preenchidas, e assim onde elas devem ser ignoradas no mecanismo de auto-atenção (self-attention). O Whisper é treinado para operar sem uma máscara de atenção e inferir do próprio sinal onde ele deve ignorar.",Ne,Q,Ia="A segunda operação que o extrator de características do Whisper realiza é converter os arrays de áudio padronizados em espectrogramas log-mel. Lembre que esses espectrogramas descrevem como as frequências de um sinal mudam ao longo do tempo, expressas na escala mel e medidas em decibéis (a parte do log) para tornar as frequências e amplitudes mais representativas da audição humana.",Ee,S,Ca="Todas essas transformações podem ser aplicadas aos seus dados de áudio brutos com algumas poucas linhas de código. Vamos colocar a mão na massa e carregar o extrator de características a partir do checkpoint pré-treinado do Whisper e deixá-lo pronto para usar nos nossos dados de áudio:",Ye,L,Ve,P,Aa="Então, você pode escrever uma função para pré-processar um exemplo de áudio, passando ele para o <code>feature_extractor</code>.",He,D,Fe,O,va="Podemos aplicar a função de preparação de dados a todos os nossos exemplos de treinamento usando o método <code>map</code> de 🤗 Datasets:",Xe,K,Qe,ee,xa="<strong>Saída:</strong>",Se,ae,Le,se,$a="Sem muito esforço, agora temos espectrogramas log-mel no campo <code>input_features</code> do dataset.",Pe,te,qa="Vamos visualizá-lo em dos exemplos do dataset <code>minds</code>:",De,oe,Oe,T,_a='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/log_mel_whisper.png" alt="Gráfico de espectrograma log mel"/>',Ke,le,za="Agora você pode ver como fica um input de áudio para o modelo Whisper após o pré-processamento.",ea,re,ka='A classe de extrator de características do modelo cuida de transformar os dados de áudio brutos para o formato que o modelo espera. No entanto, muitas tarefas envolvendo áudio são multimodais, como, por exemplo, o reconhecimento de fala. Nestes casos, 🤗 Transformers também oferece tokenizadores (tokenizers) específicos do modelo para processar as entradas de texto. Para se aprofundar em tokenizadores, consulte nosso <a href="https://huggingface.co/course/chapter2/4" rel="nofollow">curso de NLP</a>.',aa,ne,Ba="Você pode carregar o extrator de características e o tokenizador do Whisper (e outros modelos multimodais) separadamente, ou você pode carregar ambos por meio de algo chamado de processor (processador). Para simplificar ainda mais, use <code>AutoProcessor</code> para carregar o extrator de características e processador de um modelo a partir de um checkpoint, assim:",sa,me,ta,de,Ga='Aqui mostramos os passos fundamentais de preparação dos dados. Claro, dados personalizados podem exigir pré-processamento mais complexo. Neste caso, você pode estender a função <code>prepare_dataset</code> para realizar qualquer tipo de transformação de dados personalizada. Com 🤗 Datasets, se você pode escrever sua personalização como uma função Python, então você pode <a href="https://huggingface.co/docs/datasets/audio_process" rel="nofollow">aplicá-la</a> ao seu dataset!',oa,ie,la,pe,ra;return h=new na({props:{title:"Pré-processamento de um dataset de áudio",local:"pré-processamento-de-um-dataset-de-áudio",headingTag:"h1"}}),g=new na({props:{title:"Reamostragem dos dados de áudio",local:"reamostragem-dos-dados-de-áudio",headingTag:"h2"}}),v=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`,wrap:!1}}),$=new y({props:{code:"bWluZHMlNUIwJTVE",highlighted:'minds[<span class="hljs-number">0</span>]',wrap:!1}}),_=new y({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyLjA2MzQyNDNlLTA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45NDM3ODM3ZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIuMjQxOTM0MGUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA5LjM4NTI4NjJlLTA0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS4xMzAyNDUyZS0wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDcuMTUzMTQyOWUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDE2MDAwJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSU3RA==",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [
                <span class="hljs-number">2.0634243e-05</span>,
                <span class="hljs-number">1.9437837e-04</span>,
                <span class="hljs-number">2.2419340e-04</span>,
                ...,
                <span class="hljs-number">9.3852862e-04</span>,
                <span class="hljs-number">1.1302452e-03</span>,
                <span class="hljs-number">7.1531429e-04</span>,
            ],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
}`,wrap:!1}}),J=new Qa({props:{$$slots:{default:[La]},$$scope:{ctx:ue}}}),k=new na({props:{title:"Filtragem do dataset",local:"filtragem-do-dataset",headingTag:"h2"}}),R=new y({props:{code:"TUFYX0RVUkFUSU9OX0lOX1NFQ09ORFMlMjAlM0QlMjAyMC4wJTBBJTBBJTBBZGVmJTIwaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlKGlucHV0X2xlbmd0aCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dF9sZW5ndGglMjAlM0MlMjBNQVhfRFVSQVRJT05fSU5fU0VDT05EUw==",highlighted:`MAX_DURATION_IN_SECONDS = <span class="hljs-number">20.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_length_in_range</span>(<span class="hljs-params">input_length</span>):
    <span class="hljs-keyword">return</span> input_length &lt; MAX_DURATION_IN_SECONDS`,wrap:!1}}),Z=new y({props:{code:"JTIzJTIwdXNlJTIwbGlicm9zYSUyMHBhcmElMjBvYnRlciUyMGElMjBkdXJhJUMzJUE3JUMzJUEzbyUyMGRvJTIwJUMzJUExdWRpbyUwQW5ld19jb2x1bW4lMjAlM0QlMjAlNUJsaWJyb3NhLmdldF9kdXJhdGlvbihwYXRoJTNEeCklMjBmb3IlMjB4JTIwaW4lMjBtaW5kcyU1QiUyMnBhdGglMjIlNUQlNUQlMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmFkZF9jb2x1bW4oJTIyZHVyYXRpb24lMjIlMkMlMjBuZXdfY29sdW1uKSUwQSUwQSUyMyUyMHVzZSUyMG8lMjBtJUMzJUE5dG9kbyUyMCU2MGZpbHRlciU2MCUyMGRlJTIwJUYwJTlGJUE0JTk3JTIwRGF0YXNldHMlMjBwYXJhJTIwYXBsaWNhciUyMGElMjBmdW4lQzMlQTclQzMlQTNvJTIwZGUlMjBmaWx0cmFnZW0lMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmZpbHRlcihpc19hdWRpb19sZW5ndGhfaW5fcmFuZ2UlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyZHVyYXRpb24lMjIlNUQpJTBBJTBBJTIzJTIwcmVtb3ZhJTIwYSUyMGNvbHVuYSUyMGF1eGlsaWFyJTIwdGVtcG9yJUMzJUExcmlhJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyglNUIlMjJkdXJhdGlvbiUyMiU1RCklMEFtaW5kcw==",highlighted:`<span class="hljs-comment"># use librosa para obter a duração do áudio</span>
new_column = [librosa.get_duration(path=x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> minds[<span class="hljs-string">&quot;path&quot;</span>]]
minds = minds.add_column(<span class="hljs-string">&quot;duration&quot;</span>, new_column)

<span class="hljs-comment"># use o método \`filter\` de 🤗 Datasets para aplicar a função de filtragem</span>
minds = minds.<span class="hljs-built_in">filter</span>(is_audio_length_in_range, input_columns=[<span class="hljs-string">&quot;duration&quot;</span>])

<span class="hljs-comment"># remova a coluna auxiliar temporária</span>
minds = minds.remove_columns([<span class="hljs-string">&quot;duration&quot;</span>])
minds`,wrap:!1}}),E=new y({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDYyNCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 624})</span>',wrap:!1}}),V=new na({props:{title:"Pré-processamento dos dados de áudio",local:"pré-processamento-dos-dados-de-áudio",headingTag:"h2"}}),L=new y({props:{code:"JTIzJTIwSW5zdGFsZSUyMGNvbSUyMG8lMjBjb21hbmRvJTNBJTIwcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUwQSUyMyUyMFZvYyVDMyVBQSUyMHBvZGUlMjBhY2Vzc2FyJTIwYSUyMHAlQzMlQTFnaW5hJTIwaW5jaWFsJTIwZG9zJTIwVHJhbnNmb3JtZXJzJTIwcGFyYSUyMGluc3RydSVDMyVBNyVDMyVCNWVzJTIwZGUlMjBpbnN0YWxhJUMzJUE3JUMzJUEzbyElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwV2hpc3BlckZlYXR1cmVFeHRyYWN0b3IlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMFdoaXNwZXJGZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-comment"># Instale com o comando: pip install transformers</span>
<span class="hljs-comment"># Você pode acessar a página incial dos Transformers para instruções de instalação!</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperFeatureExtractor

feature_extractor = WhisperFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),D=new y({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    features = feature_extractor(
        audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], padding=<span class="hljs-literal">True</span>
    )
    <span class="hljs-keyword">return</span> features`,wrap:!1}}),K=new y({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5tYXAocHJlcGFyZV9kYXRhc2V0KSUwQW1pbmRz",highlighted:`minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset)
minds`,wrap:!1}}),ae=new y({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNjI0JTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">624</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),oe=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWlucHV0X2ZlYXR1cmVzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTBBJTBBcGx0LmZpZ3VyZSgpLnNldF9maWd3aWR0aCgxMiklMEFsaWJyb3NhLmRpc3BsYXkuc3BlY3Nob3coJTBBJTIwJTIwJTIwJTIwbnAuYXNhcnJheShpbnB1dF9mZWF0dXJlcyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIweF9heGlzJTNEJTIydGltZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHlfYXhpcyUzRCUyMm1lbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNyJTNEZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMGhvcF9sZW5ndGglM0RmZWF0dXJlX2V4dHJhY3Rvci5ob3BfbGVuZ3RoJTJDJTBBKSUwQXBsdC5jb2xvcmJhcigp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

example = minds[<span class="hljs-number">0</span>]
input_features = example[<span class="hljs-string">&quot;input_features&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(
    np.asarray(input_features[<span class="hljs-number">0</span>]),
    x_axis=<span class="hljs-string">&quot;time&quot;</span>,
    y_axis=<span class="hljs-string">&quot;mel&quot;</span>,
    sr=feature_extractor.sampling_rate,
    hop_length=feature_extractor.hop_length,
)
plt.colorbar()`,wrap:!1}}),me=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),ie=new Sa({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/pt-BR/chapter1/preprocessing.mdx"}}),{c(){j=r("meta"),f=o(),U=r("p"),Me=o(),d(h.$$.fragment),ce=o(),w=r("p"),w.textContent=da,je=o(),b=r("ul"),b.innerHTML=ia,ye=o(),d(g.$$.fragment),fe=o(),I=r("p"),I.innerHTML=pa,Je=o(),C=r("p"),C.textContent=ua,Te=o(),A=r("p"),A.innerHTML=Ma,Ue=o(),d(v.$$.fragment),he=o(),x=r("p"),x.innerHTML=ca,we=o(),d($.$$.fragment),be=o(),q=r("p"),q.innerHTML=ja,ge=o(),d(_.$$.fragment),Ie=o(),z=r("p"),z.textContent=ya,Ce=o(),d(J.$$.fragment),Ae=o(),d(k.$$.fragment),ve=o(),B=r("p"),B.textContent=fa,xe=o(),G=r("p"),G.innerHTML=Ja,$e=o(),d(R.$$.fragment),qe=o(),W=r("p"),W.textContent=Ta,_e=o(),d(Z.$$.fragment),ze=o(),N=r("p"),N.innerHTML=Ua,ke=o(),d(E.$$.fragment),Be=o(),Y=r("p"),Y.textContent=ha,Ge=o(),d(V.$$.fragment),Re=o(),H=r("p"),H.textContent=wa,We=o(),F=r("p"),F.innerHTML=ba,Ze=o(),X=r("p"),X.textContent=ga,Ne=o(),Q=r("p"),Q.textContent=Ia,Ee=o(),S=r("p"),S.textContent=Ca,Ye=o(),d(L.$$.fragment),Ve=o(),P=r("p"),P.innerHTML=Aa,He=o(),d(D.$$.fragment),Fe=o(),O=r("p"),O.innerHTML=va,Xe=o(),d(K.$$.fragment),Qe=o(),ee=r("p"),ee.innerHTML=xa,Se=o(),d(ae.$$.fragment),Le=o(),se=r("p"),se.innerHTML=$a,Pe=o(),te=r("p"),te.innerHTML=qa,De=o(),d(oe.$$.fragment),Oe=o(),T=r("div"),T.innerHTML=_a,Ke=o(),le=r("p"),le.textContent=za,ea=o(),re=r("p"),re.innerHTML=ka,aa=o(),ne=r("p"),ne.innerHTML=Ba,sa=o(),d(me.$$.fragment),ta=o(),de=r("p"),de.innerHTML=Ga,oa=o(),d(ie.$$.fragment),la=o(),pe=r("p"),this.h()},l(e){const a=Va("svelte-u9bgzb",document.head);j=n(a,"META",{name:!0,content:!0}),a.forEach(s),f=l(e),U=n(e,"P",{}),Wa(U).forEach(s),Me=l(e),i(h.$$.fragment,e),ce=l(e),w=n(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-lvwhhl"&&(w.textContent=da),je=l(e),b=n(e,"UL",{"data-svelte-h":!0}),m(b)!=="svelte-1b4cyan"&&(b.innerHTML=ia),ye=l(e),i(g.$$.fragment,e),fe=l(e),I=n(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1u9skk8"&&(I.innerHTML=pa),Je=l(e),C=n(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-marfpr"&&(C.textContent=ua),Te=l(e),A=n(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1o1bxi6"&&(A.innerHTML=Ma),Ue=l(e),i(v.$$.fragment,e),he=l(e),x=n(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-13lb6so"&&(x.innerHTML=ca),we=l(e),i($.$$.fragment,e),be=l(e),q=n(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1usoza3"&&(q.innerHTML=ja),ge=l(e),i(_.$$.fragment,e),Ie=l(e),z=n(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1fk04pf"&&(z.textContent=ya),Ce=l(e),i(J.$$.fragment,e),Ae=l(e),i(k.$$.fragment,e),ve=l(e),B=n(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-eo5ip5"&&(B.textContent=fa),xe=l(e),G=n(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-yl0fth"&&(G.innerHTML=Ja),$e=l(e),i(R.$$.fragment,e),qe=l(e),W=n(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-2zshoe"&&(W.textContent=Ta),_e=l(e),i(Z.$$.fragment,e),ze=l(e),N=n(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1usoza3"&&(N.innerHTML=Ua),ke=l(e),i(E.$$.fragment,e),Be=l(e),Y=n(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1hcj7t1"&&(Y.textContent=ha),Ge=l(e),i(V.$$.fragment,e),Re=l(e),H=n(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-42caqy"&&(H.textContent=wa),We=l(e),F=n(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-hy1g44"&&(F.innerHTML=ba),Ze=l(e),X=n(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1o0fi04"&&(X.textContent=ga),Ne=l(e),Q=n(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-s2y5v4"&&(Q.textContent=Ia),Ee=l(e),S=n(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1rwn9ln"&&(S.textContent=Ca),Ye=l(e),i(L.$$.fragment,e),Ve=l(e),P=n(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-cupw90"&&(P.innerHTML=Aa),He=l(e),i(D.$$.fragment,e),Fe=l(e),O=n(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1b4t3v9"&&(O.innerHTML=va),Xe=l(e),i(K.$$.fragment,e),Qe=l(e),ee=n(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-1usoza3"&&(ee.innerHTML=xa),Se=l(e),i(ae.$$.fragment,e),Le=l(e),se=n(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-ien326"&&(se.innerHTML=$a),Pe=l(e),te=n(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1n38tby"&&(te.innerHTML=qa),De=l(e),i(oe.$$.fragment,e),Oe=l(e),T=n(e,"DIV",{class:!0,"data-svelte-h":!0}),m(T)!=="svelte-x6says"&&(T.innerHTML=_a),Ke=l(e),le=n(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-mpjv2n"&&(le.textContent=za),ea=l(e),re=n(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-1g71by9"&&(re.innerHTML=ka),aa=l(e),ne=n(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-1jkytzh"&&(ne.innerHTML=Ba),sa=l(e),i(me.$$.fragment,e),ta=l(e),de=n(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-qmlpls"&&(de.innerHTML=Ga),oa=l(e),i(ie.$$.fragment,e),la=l(e),pe=n(e,"P",{}),Wa(pe).forEach(s),this.h()},h(){ma(j,"name","hf:doc:metadata"),ma(j,"content",Da),ma(T,"class","flex justify-center")},m(e,a){Ha(document.head,j),t(e,f,a),t(e,U,a),t(e,Me,a),p(h,e,a),t(e,ce,a),t(e,w,a),t(e,je,a),t(e,b,a),t(e,ye,a),p(g,e,a),t(e,fe,a),t(e,I,a),t(e,Je,a),t(e,C,a),t(e,Te,a),t(e,A,a),t(e,Ue,a),p(v,e,a),t(e,he,a),t(e,x,a),t(e,we,a),p($,e,a),t(e,be,a),t(e,q,a),t(e,ge,a),p(_,e,a),t(e,Ie,a),t(e,z,a),t(e,Ce,a),p(J,e,a),t(e,Ae,a),p(k,e,a),t(e,ve,a),t(e,B,a),t(e,xe,a),t(e,G,a),t(e,$e,a),p(R,e,a),t(e,qe,a),t(e,W,a),t(e,_e,a),p(Z,e,a),t(e,ze,a),t(e,N,a),t(e,ke,a),p(E,e,a),t(e,Be,a),t(e,Y,a),t(e,Ge,a),p(V,e,a),t(e,Re,a),t(e,H,a),t(e,We,a),t(e,F,a),t(e,Ze,a),t(e,X,a),t(e,Ne,a),t(e,Q,a),t(e,Ee,a),t(e,S,a),t(e,Ye,a),p(L,e,a),t(e,Ve,a),t(e,P,a),t(e,He,a),p(D,e,a),t(e,Fe,a),t(e,O,a),t(e,Xe,a),p(K,e,a),t(e,Qe,a),t(e,ee,a),t(e,Se,a),p(ae,e,a),t(e,Le,a),t(e,se,a),t(e,Pe,a),t(e,te,a),t(e,De,a),p(oe,e,a),t(e,Oe,a),t(e,T,a),t(e,Ke,a),t(e,le,a),t(e,ea,a),t(e,re,a),t(e,aa,a),t(e,ne,a),t(e,sa,a),p(me,e,a),t(e,ta,a),t(e,de,a),t(e,oa,a),p(ie,e,a),t(e,la,a),t(e,pe,a),ra=!0},p(e,[a]){const Ra={};a&2&&(Ra.$$scope={dirty:a,ctx:e}),J.$set(Ra)},i(e){ra||(u(h.$$.fragment,e),u(g.$$.fragment,e),u(v.$$.fragment,e),u($.$$.fragment,e),u(_.$$.fragment,e),u(J.$$.fragment,e),u(k.$$.fragment,e),u(R.$$.fragment,e),u(Z.$$.fragment,e),u(E.$$.fragment,e),u(V.$$.fragment,e),u(L.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(me.$$.fragment,e),u(ie.$$.fragment,e),ra=!0)},o(e){M(h.$$.fragment,e),M(g.$$.fragment,e),M(v.$$.fragment,e),M($.$$.fragment,e),M(_.$$.fragment,e),M(J.$$.fragment,e),M(k.$$.fragment,e),M(R.$$.fragment,e),M(Z.$$.fragment,e),M(E.$$.fragment,e),M(V.$$.fragment,e),M(L.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),M(ae.$$.fragment,e),M(oe.$$.fragment,e),M(me.$$.fragment,e),M(ie.$$.fragment,e),ra=!1},d(e){e&&(s(f),s(U),s(Me),s(ce),s(w),s(je),s(b),s(ye),s(fe),s(I),s(Je),s(C),s(Te),s(A),s(Ue),s(he),s(x),s(we),s(be),s(q),s(ge),s(Ie),s(z),s(Ce),s(Ae),s(ve),s(B),s(xe),s(G),s($e),s(qe),s(W),s(_e),s(ze),s(N),s(ke),s(Be),s(Y),s(Ge),s(Re),s(H),s(We),s(F),s(Ze),s(X),s(Ne),s(Q),s(Ee),s(S),s(Ye),s(Ve),s(P),s(He),s(Fe),s(O),s(Xe),s(Qe),s(ee),s(Se),s(Le),s(se),s(Pe),s(te),s(De),s(Oe),s(T),s(Ke),s(le),s(ea),s(re),s(aa),s(ne),s(sa),s(ta),s(de),s(oa),s(la),s(pe)),s(j),c(h,e),c(g,e),c(v,e),c($,e),c(_,e),c(J,e),c(k,e),c(R,e),c(Z,e),c(E,e),c(V,e),c(L,e),c(D,e),c(K,e),c(ae,e),c(oe,e),c(me,e),c(ie,e)}}}const Da='{"title":"Pré-processamento de um dataset de áudio","local":"pré-processamento-de-um-dataset-de-áudio","sections":[{"title":"Reamostragem dos dados de áudio","local":"reamostragem-dos-dados-de-áudio","sections":[],"depth":2},{"title":"Filtragem do dataset","local":"filtragem-do-dataset","sections":[],"depth":2},{"title":"Pré-processamento dos dados de áudio","local":"pré-processamento-dos-dados-de-áudio","sections":[],"depth":2}],"depth":1}';function Oa(ue){return Na(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class os extends Ea{constructor(j){super(),Ya(this,j,Oa,Pa,Za,{})}}export{os as component};
