import{s as fn,o as Jn,n as Jl}from"../chunks/scheduler.a2b4ca8e.js";import{S as jn,i as Un,g as i,s,r as m,A as bn,h as o,f as l,c as a,j as wn,u,x as r,k as wl,y as gn,a as n,v as M,d as c,t as d,w as h}from"../chunks/index.d2f673cc.js";import{T as fl}from"../chunks/Tip.a902c250.js";import{C as y}from"../chunks/CodeBlock.792343a6.js";import{H as f}from"../chunks/Heading.675d4c1e.js";function In(j){let p,w="While we will use <code>Llama-3 70B</code> in this tutorial, it is completely possible to use other models, simply by swtiching the <code>model_id</code>.";return{c(){p=i("p"),p.innerHTML=w},l(T){p=o(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1pbcdba"&&(p.innerHTML=w)},m(T,J){n(T,p,J)},p:Jl,d(T){T&&l(p)}}}function Cn(j){let p,w='If you want to know more about distributed training you can take a look at the <a href="https://huggingface.co/docs/optimum-neuron/guides/distributed_training" rel="nofollow">documentation</a>.';return{c(){p=i("p"),p.innerHTML=w},l(T){p=o(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-yp02re"&&(p.innerHTML=w)},m(T,J){n(T,p,J)},p:Jl,d(T){T&&l(p)}}}function _n(j){let p,w="Make sure to run this precompilation phase for around 10 training steps. It is usually enough to accumulate and compile all the graphs that will be needed during the actual training.";return{c(){p=i("p"),p.textContent=w},l(T){p=o(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1k7qt99"&&(p.textContent=w)},m(T,J){n(T,p,J)},p:Jl,d(T){T&&l(p)}}}function Bn(j){let p,w,T,J,_,ze,B,jl="[[open-in-collab]]",Ye,v,Ul='<em>Note: The complete script for this tutorial can be downloaded <a href="https://github.com/huggingface/optimum-neuron/blob/main/docs/source/training_tutorials/sft_lora_finetune_llm.py" rel="nofollow">here</a>.</em>',qe,$,bl='This tutorial will teach you how to fine-tune open source LLMs like <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B" rel="nofollow">Llama 3</a> on AWS Trainium. In our example, we are going to leverage the <a href="https://huggingface.co/docs/optimum-neuron/index" rel="nofollow">Optimum Neuron</a>, <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">Transformers</a> and <a href="https://huggingface.co/docs/datasets/index" rel="nofollow">Datasets</a> libraries.',De,Z,gl="You will learn how to:",Pe,W,Il='<li><a href="#1-setup-aws-environment">Setup AWS Environment</a></li> <li><a href="#2-load-and-prepare-the-dataset">Load and process the dataset</a></li> <li><a href="#3-fine-tune-llama-using-lora-on-aws-trainium-with-the-neuronsfttrainer">Fine-tune Llama using LoRA on AWS Trainium with the <code>NeuronSFTTrainer</code></a></li> <li><a href="#4-launch-training">Launch Training</a></li> <li><a href="#5-evaluate-and-test-fine-tuned-llama-model">Evaluate and test fine-tuned Llama model</a></li>',Oe,U,Ke,A,et,k,Cl="Before starting this tutorial, you will need to setup your environment:",tt,x,_l='<li>Create an AWS Trainium instance. <strong>You will need a <code>trn1.32xlarge</code>, which contains 16 Neuron Devices.</strong> You can follow this <a href="https://huggingface.co/docs/optimum-neuron/guides/setup_aws_instance" rel="nofollow">guide</a> to create one.</li> <li>Make sure you are logged in on the Hugging Face Hub:</li>',lt,S,nt,b,Bl="<li>Check that you have access to the model. Some open source models are gated, meaning that users need to apply to the model owner to be able to use the model weights. Here we will be training Llama-3 70B, for which there are two possibilities:</li>",st,G,vl='<li>The official gated repo: <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B" rel="nofollow"><code>meta-llama/Meta-Llama-3-70B</code></a></li> <li>The non-official un-gated repo: <a href="https://huggingface.co/NousResearch/Meta-Llama-3-70B" rel="nofollow"><code>NousResearch/Meta-Llama-3-70B</code></a></li>',at,g,$l='<li>Clone the Optimum Neuron repository, <strong>which contains the <a href="https://github.com/huggingface/optimum-neuron/blob/main/docs/source/training_tutorials/sft_lora_finetune_llm.py" rel="nofollow">complete script</a> described in this tutorial:</strong></li>',it,X,ot,V,rt,E,Zl='For this tutorial, we will use <a href="https://huggingface.co/datasets/databricks/databricks-dolly-15k" rel="nofollow">Dolly</a>, an open source dataset of instruction-following records on categories outlined in the <a href="https://arxiv.org/abs/2203.02155" rel="nofollow">InstructGPT paper</a>, including brainstorming, classification, closed QA, generation, information extraction, open QA, and summarization.',pt,H,Wl="Example:",mt,N,ut,R,Al="We can use the <code>load_dataset()</code> method from the 🤗 Datasets library to load the <code>dolly</code> dataset very easily.",Mt,L,ct,Q,kl="To instruct fine-tune our model we need to:",dt,F,xl=`<li>Convert our structured examples into collection of tasks described via instructions</li> <li>(Optional) Pack multiple examples to one sequence for more efficient training. In other words, we are stacking multiple examples into one example,
and split them with the EOS token.</li>`,ht,z,Sl="We could do this manually, but we will use the <code>NeuronSFTTrainer</code> instead.",Tt,Y,yt,q,Gl='Normally you would use the <strong><a href="https://huggingface.co/docs/trl/main/en/sft_trainer#trl.SFTConfig" rel="nofollow">SFTConfig</a></strong> and <strong><a href="https://huggingface.co/docs/trl/main/en/sft_trainer" rel="nofollow">SFTTrainer</a></strong> classes to perform supervised fine-tuning of PyTorch-based transformer models.',wt,D,Xl="Instead, here we will be using the <code>NeuronSFTConfig</code> and <code>NeuronSFTTrainer</code>. These classes replicate the ones from the <code>trl</code> library while making sure they work properly on Neuron cores.",ft,P,Jt,O,Vl=`There are multiple ways to give a dataset to the <code>NeuronSFTTrainer</code>, and one of them consists in providing a formatting function.
For <code>dolly</code> without packing the examples it looks as follows:`,jt,K,Ut,ee,bt,te,El="Since Llama-3 70B is a big model it will not fit on a single <code>trn1.32xlarge</code> instance, even with distributed training. To actually fine-tune a 70B model using only one Trainium instance we need to use both LoRA and distributed training.",gt,I,It,le,Hl=`Here, we will use tensor parallelism in conjuction with LoRA.
Our training code will look as follows:`,Ct,ne,_t,se,Nl="The key points here are:",Bt,ae,Rl="<li>We use the <code>lazy_load_for_parallelism</code> context manager to lazily load the model. This will not load the full model weights on each worker, but instead only load the required weights (sharded or full). <strong>This is much more memory efficient, and often mandatory to use.</strong></li> <li>We define a <code>LoraConfig</code> that specifies which layers should have adapters, and the hyperparameters for theses adapters.</li> <li>We create a <code>NeuronSFTConfig</code> from regular <code>NeuronTrainingArguments</code>. Here we specify that we do not want to pack our examples, and that the max sequence length should be <code>1024</code>, meaning that every example will be either padded or truncated to a length of <code>1024</code>.</li> <li>We use the <code>NeuronSFTTrainer</code> to perform training. It will take the lazily loaded model, along with <code>lora_config</code>, <code>sft_config</code> and <code>format_dolly</code> and prepare the dataset and model for supervised fine-tuning.</li>",vt,ie,$t,oe,Ll='We prepared a script called <a href="https://github.com/huggingface/optimum-neuron/blob/main/docs/source/training_tutorials/lora_finetune_llm.py" rel="nofollow">sft_lora_finetune_llm.py</a> summing up everything mentioned in this tutorial.',Zt,re,Ql="PyTorch Neuron uses <code>torch_xla</code>. It evaluates operations lazily during execution of the training loops, which means it builds a symbolic graph in the background and the graph is executed on the hardware only when the tensor is printed, transfered to CPU, or <code>xm.mark_step()</code> is called. During execution, multiple graphs can be built depending on control-flow and it can take time to compile each graph sequentially. To alleviate that, the Neuron SDK provides <code>neuron_parallel_compile</code>, a tool which performs a fast trial run that builds all the graphs and compile them in parallel. This step is usually called precompilation.",Wt,pe,At,me,Fl="When training models on AWS Trainium we first need to compile our model with our training arguments.",kt,ue,zl='To overcome this, we added a <a href="https://huggingface.co/docs/optimum-neuron/guides/cache_system" rel="nofollow">model cache repository</a>, which allows us to use precompiled models from the Hugging Face Hub to skip the compilation step. But be careful: every change in the model configuration might lead to a new compilation, which could result in some cache misses.',xt,Me,Yl='<em>Note: If your model configuration is not cached please open an issue on <a href="https://github.com/huggingface/optimum-neuron/issues" rel="nofollow">Github</a>, we are happy to include it.</em>',St,ce,ql="The compilation command simply consists in calling your script as an input to the <code>neuron_parallel_compile</code> utility:",Gt,de,Xt,he,Vt,C,Et,Te,Dl="<em>Note: Compiling without a cache can take a while. It will also create dummy files in the <code>dolly_llama_sharded</code> during compilation you will have to remove them afterwards. We also need to add <code>MALLOC_ARENA_MAX=64</code> to limit the CPU allocation to avoid potential crashes, don’t remove it for now.</em>",Ht,ye,Nt,we,Rt,fe,Pl="After compilation is done we can start our actual training with a similar command, we just need to remove the use of <code>neuron_parallel_compile</code>.",Lt,Je,Ol="We will use <code>torchrun</code> to launch our training script. <code>torchrun</code> is a tool that automatically distributes a PyTorch model across multiple accelerators. We can pass the number of accelerators as <code>nproc_per_node</code> arguments alongside our hyperparameters.",Qt,je,Kl="The difference to the compilation command is that we changed from <code>max_steps=10</code> to <code>num_train_epochs=3</code>.",Ft,Ue,en="Launch the training, with the following command.",zt,be,Yt,ge,qt,Ie,tn="That’s it, we successfully trained Llama-3 70B on AWS Trainium!",Dt,Ce,ln="But before we can share and test our model we need to consolidate our model. Since we used tensor parallelism during training, we saved sharded versions of the checkpoints. We need to consolidate them now.",Pt,_e,Ot,Be,nn="The Optimum CLI provides a way of doing that very easily via the <code>optimum neuron consolidate [sharded_checkpoint] [output_dir]</code> command:",Kt,ve,el,$e,tl,Ze,sn="As for training, to be able to run inference on AWS Trainium or AWS Inferentia2 we need to compile our model. In this case, we will use our Trainium instance for the inference test, but we recommend customer to switch to Inferentia2 for inference.",ll,We,an="Optimum Neuron implements similar to Transformers AutoModel classes for easy inference use. We will use the <code>NeuronModelForCausalLM</code> class to load our vanilla transformers checkpoint and convert it to neuron.",nl,Ae,sl,ke,on="<em>Note: Inference compilation can take ~25minutes. Luckily, you need to only run this onces. Since you can save the model afterwards. If you are going to run on Inferentia2 you need to recompile again. The compilation is parameter and hardware specific.</em>",al,xe,il,Se,rn="We can now test inference, but have to make sure we format our input to our prompt format we used for fine-tuning. Therefore we created a helper method, which accepts a <code>dict</code> with our <code>instruction</code> and optionally a <code>context</code>.",ol,Ge,rl,Xe,pn="Let’s test inference. First we test without a context.",pl,Ve,mn="<em>Note: Inference is not expected to be super fast on AWS Trainium using 2 cores. For Inference we recommend using Inferentia2.</em>",ml,Ee,ul,He,un="<p>AWS stands for Amazon Web Services. AWS is a suite of remote computing services offered by Amazon. The most widely used of these include Amazon Elastic Compute Cloud (Amazon EC2), which provides resizable compute capacity in the cloud; Amazon Simple Storage Service (Amazon S3), which is an object storage service; and Amazon Elastic Block Store (Amazon EBS), which is designed to provide high performance, durable block storage volumes for use with AWS instances. AWS also provides other services, such as AWS Identity and Access Management (IAM), a service that enables organizations to control access to their AWS resources, and AWS Key Management Service (AWS KMS), which helps customers create and control the use of encryption keys.</p>",Ml,Ne,Mn="That looks correct. Now, lets add some context, e.g. as you would do for RAG applications:",cl,Re,dl,Le,cn="<p>You can use the Optimum Neuron interface to train models on AWS Trainium.</p>",hl,Qe,dn="Awesome, our model also correctly uses the provided context. We are done. Congrats on fine-tuning Llama on AWS Trainium.",Tl,Fe,yl;return _=new f({props:{title:"Supervised Fine-Tuning of Llama 3 70B on one AWS Trainium instance",local:"supervised-fine-tuning-of-llama-3-70b-on-one-aws-trainium-instance",headingTag:"h1"}}),U=new fl({props:{$$slots:{default:[In]},$$scope:{ctx:j}}}),A=new f({props:{title:"1. Setup AWS Environment",local:"1-setup-aws-environment",headingTag:"h2"}}),S=new y({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4lMjAtLXRva2VuJTIwWU9VUl9UT0tFTg==",highlighted:"huggingface-cli login --token YOUR_TOKEN",wrap:!1}}),X=new y({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRm9wdGltdW0tbmV1cm9uLmdpdA==",highlighted:'git <span class="hljs-built_in">clone</span> https://github.com/huggingface/optimum-neuron.git',wrap:!1}}),V=new f({props:{title:"2. Load and prepare the dataset",local:"2-load-and-prepare-the-dataset",headingTag:"h2"}}),N=new y({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB3b3JsZCUyMG9mJTIwd2FyY3JhZnQlMjIlMkMlMEElMjAlMjAlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTIyJTJDJTBBJTIwJTIwJTIycmVzcG9uc2UlMjIlM0ElMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV29ybGQlMjBvZiUyMHdhcmNyYWZ0JTIwaXMlMjBhJTIwbWFzc2l2ZSUyMG9ubGluZSUyMG11bHRpJTIwcGxheWVyJTIwcm9sZSUyMHBsYXlpbmclMjBnYW1lLiUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkl0JTIwd2FzJTIwcmVsZWFzZWQlMjBpbiUyMDIwMDQlMjBieSUyMGJsaXphcnJlJTIwZW50ZXJ0YWlubWVudCUyMiUwQSUyMCUyMCUyMCUyMCklMEElN0Q=",highlighted:`{
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What is world of warcraft&quot;</span>,
  <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;&quot;</span>,
  <span class="hljs-string">&quot;response&quot;</span>: (
        <span class="hljs-string">&quot;World of warcraft is a massive online multi player role playing game. &quot;</span>
        <span class="hljs-string">&quot;It was released in 2004 by blizarre entertainment&quot;</span>
    )
}`,wrap:!1}}),L=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRyYW5nZSUwQSUwQSUyMyUyMExvYWQlMjBkYXRhc2V0JTIwZnJvbSUyMHRoZSUyMGh1YiUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZGF0YWJyaWNrcyUyRmRhdGFicmlja3MtZG9sbHktMTVrJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEFwcmludChmJTIyZGF0YXNldCUyMHNpemUlM0ElMjAlN0JsZW4oZGF0YXNldCklN0QlMjIpJTBBcHJpbnQoZGF0YXNldCU1QnJhbmRyYW5nZShsZW4oZGF0YXNldCkpJTVEKSUwQSUyMyUyMGRhdGFzZXQlMjBzaXplJTNBJTIwMTUwMTE=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randrange

<span class="hljs-comment"># Load dataset from the hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;databricks/databricks-dolly-15k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset)}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(dataset[randrange(<span class="hljs-built_in">len</span>(dataset))])
<span class="hljs-comment"># dataset size: 15011</span>`,wrap:!1}}),Y=new f({props:{title:"3. Supervised Fine-Tuning of Llama on AWS Trainium with the NeuronSFTTrainer",local:"3-supervised-fine-tuning-of-llama-on-aws-trainium-with-the-neuronsfttrainer",headingTag:"h2"}}),P=new f({props:{title:"Formatting our dataset",local:"formatting-our-dataset",headingTag:"h3"}}),K=new y({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5KGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0JTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKGV4YW1wbGVzJTVCJTIyaW5zdHJ1Y3Rpb24lMjIlNUQpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluc3RydWN0aW9uJTIwJTNEJTIwZiUyMiUyMyUyMyUyMyUyMEluc3RydWN0aW9uJTVDbiU3QmV4YW1wbGVzJTVCJ2luc3RydWN0aW9uJyU1RCU1QmklNUQlN0QlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb250ZXh0JTIwJTNEJTIwZiUyMiUyMyUyMyUyMyUyMENvbnRleHQlNUNuJTdCZXhhbXBsZXMlNUInY29udGV4dCclNUQlNUJpJTVEJTdEJTIyJTIwaWYlMjBsZW4oZXhhbXBsZXMlNUIlMjJjb250ZXh0JTIyJTVEJTVCaSU1RCklMjAlM0UlMjAwJTIwZWxzZSUyME5vbmUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBBbnN3ZXIlNUNuJTdCZXhhbXBsZXMlNUIncmVzcG9uc2UnJTVEJTVCaSU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMiU1Q24lNUNuJTIyLmpvaW4oJTVCaSUyMGZvciUyMGklMjBpbiUyMCU1Qmluc3RydWN0aW9uJTJDJTIwY29udGV4dCUyQyUyMHJlc3BvbnNlJTVEJTIwaWYlMjBpJTIwaXMlMjBub3QlMjBOb25lJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dF90ZXh0LmFwcGVuZChwcm9tcHQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwb3V0cHV0X3RleHQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly</span>(<span class="hljs-params">examples</span>):
    output_text = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(examples[<span class="hljs-string">&quot;instruction&quot;</span>])):
        instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{examples[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>&quot;</span>
        context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{examples[<span class="hljs-string">&#x27;context&#x27;</span>][i]}</span>&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(examples[<span class="hljs-string">&quot;context&quot;</span>][i]) &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
        response = <span class="hljs-string">f&quot;### Answer\\n<span class="hljs-subst">{examples[<span class="hljs-string">&#x27;response&#x27;</span>][i]}</span>&quot;</span>
        prompt = <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> [instruction, context, response] <span class="hljs-keyword">if</span> i <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>])
        output_text.append(prompt)
    <span class="hljs-keyword">return</span> output_text`,wrap:!1}}),ee=new f({props:{title:"Preparing the model",local:"preparing-the-model",headingTag:"h3"}}),I=new fl({props:{$$slots:{default:[Cn]},$$scope:{ctx:j}}}),ne=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronSFTConfig, NeuronSFTTrainer
<span class="hljs-keyword">from</span> optimum.neuron.distributed <span class="hljs-keyword">import</span> lazy_load_for_parallelism

<span class="hljs-comment"># Define the tensor_parallel_size</span>
tensor_parallel_size = <span class="hljs-number">2</span>

dataset = load_dataset(<span class="hljs-string">&quot;databricks/databricks-dolly-15k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model_id = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)
tokenizer.pad_token = tokenizer.eos_token

<span class="hljs-keyword">with</span> lazy_load_for_parallelism(tensor_parallel_size=tensor_parallel_size):
    model = AutoModelForCausalLM.from_pretrained(model_id)

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    target_modules=[
        <span class="hljs-string">&quot;q_proj&quot;</span>,
        <span class="hljs-string">&quot;gate_proj&quot;</span>,
        <span class="hljs-string">&quot;v_proj&quot;</span>,
        <span class="hljs-string">&quot;o_proj&quot;</span>,
        <span class="hljs-string">&quot;k_proj&quot;</span>,
        <span class="hljs-string">&quot;up_proj&quot;</span>,
        <span class="hljs-string">&quot;down_proj&quot;</span>
    ],
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

<span class="hljs-comment"># training_args is an instance of NeuronTrainingArguments</span>
args = training_args.to_dict()
sft_config = NeuronSFTConfig(
    max_seq_length=<span class="hljs-number">1024</span>,
    packing=<span class="hljs-literal">False</span>,
    **args,
)

trainer = NeuronSFTTrainer(
    args=sft_config,
    model=model,
    peft_config=config,
    tokenizer=tokenizer,
    train_dataset=dataset,
    formatting_func=format_dolly,
)

<span class="hljs-comment"># Start training</span>
trainer.train()

trainer.save_model()  <span class="hljs-comment"># Saves the tokenizer too for easy upload</span>`,wrap:!1}}),ie=new f({props:{title:"4. Launch Training",local:"4-launch-training",headingTag:"h2"}}),pe=new f({props:{title:"Precompilation",local:"precompilation",headingTag:"h3"}}),de=new f({props:{title:"TODO: change the hyperparameters",local:"todo-change-the-hyperparameters",headingTag:"h3"}}),he=new y({props:{code:"TUFMTE9DX0FSRU5BX01BWCUzRDY0JTIwWExBX1VTRV9CRjE2JTNEMSUyMG5ldXJvbl9wYXJhbGxlbF9jb21waWxlJTIwdG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMzIlMjBzZnRfbG9yYV9maW5ldHVuZV9sbG0ucHklMjAlNUMlMEElMjAtLW1vZGVsX2lkJTIwbWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEIlMjAlNUMlMEElMjAtLWJmMTYlMjBUcnVlJTIwJTVDJTBBJTIwLS1sZWFybmluZ19yYXRlJTIwNWUtNSUyMCU1QyUwQSUyMC0tb3V0cHV0X2RpciUyMGRvbGx5X2xsYW1hJTIwJTVDJTBBJTIwLS1vdmVyd3JpdGVfb3V0cHV0X2RpciUyMFRydWUlMjAlNUMlMEElMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMDE2JTIwJTVDJTBBJTIwLS1ncmFkaWVudF9jaGVja3BvaW50aW5nJTIwVHJ1ZSUyMCU1QyUwQSUyMC0tdGVuc29yX3BhcmFsbGVsX3NpemUlMjA4JTIwJTVDJTBBJTIwLS1tYXhfc3RlcHMlMjAxMCUyMCU1QyUwQSUyMC0tbG9nZ2luZ19zdGVwcyUyMDEw",highlighted:`MALLOC_ARENA_MAX=64 XLA_USE_BF16=1 neuron_parallel_compile torchrun --nproc_per_node=32 sft_lora_finetune_llm.py \\
 --model_id meta-llama/Meta-Llama-3-70B \\
 --bf16 True \\
 --learning_rate 5e-5 \\
 --output_dir dolly_llama \\
 --overwrite_output_dir True \\
 --per_device_train_batch_size 1 \\
 --gradient_accumulation_steps 16 \\
 --gradient_checkpointing True \\
 --tensor_parallel_size 8 \\
 --max_steps 10 \\
 --logging_steps 10`,wrap:!1}}),C=new fl({props:{$$slots:{default:[_n]},$$scope:{ctx:j}}}),ye=new y({props:{code:"JTIzJTIwcmVtb3ZlJTIwZHVtbXklMjBhcnRpZmFjdHMlMjB3aGljaCUyMGFyZSUyMGNyZWF0ZWQlMjBieSUyMHRoZSUyMHByZWNvbXBpbGF0aW9uJTIwY29tbWFuZCUwQXJtJTIwLXJmJTIwZG9sbHlfbGxhbWE=",highlighted:`<span class="hljs-comment"># remove dummy artifacts which are created by the precompilation command</span>
<span class="hljs-built_in">rm</span> -rf dolly_llama`,wrap:!1}}),we=new f({props:{title:"Actual Training",local:"actual-training",headingTag:"h3"}}),be=new f({props:{title:"TODO: change the hyperparameters",local:"todo-change-the-hyperparameters",headingTag:"h3"}}),ge=new y({props:{code:"TUFMTE9DX0FSRU5BX01BWCUzRDY0JTIwWExBX1VTRV9CRjE2JTNEMSUyMHRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDMyJTIwc2Z0X2xvcmFfZmluZXR1bmVfbGxtLnB5JTIwJTVDJTBBJTIwLS1tb2RlbF9pZCUyMG1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtNzBCJTIwJTVDJTBBJTIwLS1iZjE2JTIwVHJ1ZSUyMCU1QyUwQSUyMC0tbGVhcm5pbmdfcmF0ZSUyMDVlLTUlMjAlNUMlMEElMjAtLW91dHB1dF9kaXIlMjBkb2xseV9sbGFtYSUyMCU1QyUwQSUyMC0tb3ZlcndyaXRlX291dHB1dF9kaXIlMjBUcnVlJTIwJTVDJTBBJTIwLS1za2lwX2NhY2hlX3B1c2glMjBUcnVlJTIwJTVDJTBBJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAxJTIwJTVDJTBBJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAxNiUyMCU1QyUwQSUyMC0tZ3JhZGllbnRfY2hlY2twb2ludGluZyUyMFRydWUlMjAlNUMlMEElMjAtLXRlbnNvcl9wYXJhbGxlbF9zaXplJTIwOCUyMCU1QyUwQSUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDMlMjAlNUMlMEElMjAtLWxvZ2dpbmdfc3RlcHMlMjAxMA==",highlighted:`MALLOC_ARENA_MAX=64 XLA_USE_BF16=1 torchrun --nproc_per_node=32 sft_lora_finetune_llm.py \\
 --model_id meta-llama/Meta-Llama-3-70B \\
 --bf16 True \\
 --learning_rate 5e-5 \\
 --output_dir dolly_llama \\
 --overwrite_output_dir True \\
 --skip_cache_push True \\
 --per_device_train_batch_size 1 \\
 --gradient_accumulation_steps 16 \\
 --gradient_checkpointing True \\
 --tensor_parallel_size 8 \\
 --num_train_epochs 3 \\
 --logging_steps 10`,wrap:!1}}),_e=new f({props:{title:"Consolidate the Checkpoint",local:"consolidate-the-checkpoint",headingTag:"h3"}}),ve=new y({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMGRvbGx5X2xsYW1hJTIwZG9sbHlfbGxhbWE=",highlighted:"optimum-cli neuron consolidate dolly_llama dolly_llama",wrap:!1}}),$e=new f({props:{title:"5. Evaluate and test fine-tuned Llama model",local:"5-evaluate-and-test-fine-tuned-llama-model",headingTag:"h2"}}),Ae=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMm51bV9jb3JlcyUyMiUzQSUyMDIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCdmcDE2JyU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyc2VxdWVuY2VfbGVuZ3RoJTIyJTNBJTIwMjA0OCU3RCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRvbGx5X2xsYW1hJTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZG9sbHlfbGxhbWElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKipjb21waWxlcl9hcmdzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKippbnB1dF9zaGFwZXMp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCausalLM
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

compiler_args = {<span class="hljs-string">&quot;num_cores&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&#x27;fp16&#x27;</span>}
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">2048</span>}

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;dolly_llama&quot;</span>)
model = NeuronModelForCausalLM.from_pretrained(
        <span class="hljs-string">&quot;dolly_llama&quot;</span>,
        export=<span class="hljs-literal">True</span>,
        **compiler_args,
        **input_shapes)`,wrap:!1}}),xe=new y({props:{code:"JTIzJTIwQ09NTUVOVCUyMElOJTIwaWYlMjB5b3UlMjB3YW50JTIwdG8lMjBzYXZlJTIwdGhlJTIwY29tcGlsZWQlMjBtb2RlbCUwQSUyMyUyMG1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJjb21waWxlZF9kb2xseV9sbGFtYSUyMik=",highlighted:`<span class="hljs-comment"># COMMENT IN if you want to save the compiled model</span>
<span class="hljs-comment"># model.save_pretrained(&quot;compiled_dolly_llama&quot;)</span>`,wrap:!1}}),Ge=new y({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5X2luZmVyZW5jZShzYW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwaW5zdHJ1Y3Rpb24lMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwSW5zdHJ1Y3Rpb24lNUNuJTdCc2FtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMGNvbnRleHQlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQ29udGV4dCU1Q24lN0JzYW1wbGUlNUInY29udGV4dCclNUQlN0QlMjIlMjBpZiUyMCUyMmNvbnRleHQlMjIlMjBpbiUyMHNhbXBsZSUyMGVsc2UlMjBOb25lJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQW5zd2VyJTVDbiUyMiUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMiU1Q24lNUNuJTIyLmpvaW4oJTVCaSUyMGZvciUyMGklMjBpbiUyMCU1Qmluc3RydWN0aW9uJTJDJTIwY29udGV4dCUyQyUyMHJlc3BvbnNlJTVEJTIwaWYlMjBpJTIwaXMlMjBub3QlMjBOb25lJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByb21wdCUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlKHNhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjBmb3JtYXRfZG9sbHlfaW5mZXJlbmNlKHNhbXBsZSklMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuOSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcF9rJTNENTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b3BfcCUzRDAuOSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSU1Qmxlbihwcm9tcHQpJTNBJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly_inference</span>(<span class="hljs-params">sample</span>):
    instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>&quot;</span>
    context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;context&quot;</span> <span class="hljs-keyword">in</span> sample <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    response = <span class="hljs-string">f&quot;### Answer\\n&quot;</span>
    prompt = <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> [instruction, context, response] <span class="hljs-keyword">if</span> i <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>])
    <span class="hljs-keyword">return</span> prompt


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">sample</span>):
    prompt = format_dolly_inference(sample)
    inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    outputs = model.generate(
        **inputs,
        max_new_tokens=<span class="hljs-number">512</span>,
        do_sample=<span class="hljs-literal">True</span>,
        temperature=<span class="hljs-number">0.9</span>,
        top_k=<span class="hljs-number">50</span>,
        top_p=<span class="hljs-number">0.9</span>
    )
    <span class="hljs-keyword">return</span> tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-built_in">len</span>(prompt):]`,wrap:!1}}),Ee=new y({props:{code:"cHJvbXB0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJDYW4lMjB5b3UlMjB0ZWxsJTIwbWUlMjBzb21ldGhpbmclMjBhYm91dCUyMEFXUyUzRiUyMiUwQSU3RCUwQXJlcyUyMCUzRCUyMGdlbmVyYXRlKHByb21wdCklMEElMEFwcmludChyZXMp",highlighted:`prompt = {
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;Can you tell me something about AWS?&quot;</span>
}
res = generate(prompt)

<span class="hljs-built_in">print</span>(res)`,wrap:!1}}),Re=new y({props:{code:"cHJvbXB0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJIb3clMjBjYW4lMjBJJTIwdHJhaW4lMjBtb2RlbHMlMjBvbiUyMEFXUyUyMFRyYWluaXVtJTNGJTIyJTJDJTBBJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMiVGMCU5RiVBNCU5NyUyME9wdGltdW0lMjBOZXVyb24lMjBpcyUyMHRoZSUyMGludGVyZmFjZSUyMGJldHdlZW4lMjB0aGUlMjAlRjAlOUYlQTQlOTclMjBUcmFuc2Zvcm1lcnMlMjBsaWJyYXJ5JTIwYW5kJTIwQVdTJTIwQWNjZWxlcmF0b3JzJTIwaW5jbHVkaW5nJTIwJTVCQVdTJTIwVHJhaW5pdW0lNUQoaHR0cHMlM0ElMkYlMkZhd3MuYW1hem9uLmNvbSUyRm1hY2hpbmUtbGVhcm5pbmclMkZ0cmFpbml1bSUyRiUzRm5jMSUzRGhfbHMpJTIwYW5kJTIwJTVCQVdTJTIwSW5mZXJlbnRpYSU1RChodHRwcyUzQSUyRiUyRmF3cy5hbWF6b24uY29tJTJGbWFjaGluZS1sZWFybmluZyUyRmluZmVyZW50aWElMkYlM0ZuYzElM0RoX2xzKS4lMjBJdCUyMHByb3ZpZGVzJTIwYSUyMHNldCUyMG9mJTIwdG9vbHMlMjBlbmFibGluZyUyMGVhc3klMjBtb2RlbCUyMGxvYWRpbmclMkMlMjB0cmFpbmluZyUyMGFuZCUyMGluZmVyZW5jZSUyMG9uJTIwc2luZ2xlLSUyMGFuZCUyMG11bHRpLUFjY2VsZXJhdG9yJTIwc2V0dGluZ3MlMjBmb3IlMjBkaWZmZXJlbnQlMjBkb3duc3RyZWFtJTIwdGFza3MuJTIyJTBBJTdEJTBBcmVzJTIwJTNEJTIwZ2VuZXJhdGUocHJvbXB0KSUwQSUwQXByaW50KHJlcyk=",highlighted:`prompt = {
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;How can I train models on AWS Trainium?&quot;</span>,
  <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;🤗 Optimum Neuron is the interface between the 🤗 Transformers library and AWS Accelerators including [AWS Trainium](https://aws.amazon.com/machine-learning/trainium/?nc1=h_ls) and [AWS Inferentia](https://aws.amazon.com/machine-learning/inferentia/?nc1=h_ls). It provides a set of tools enabling easy model loading, training and inference on single- and multi-Accelerator settings for different downstream tasks.&quot;</span>
}
res = generate(prompt)

<span class="hljs-built_in">print</span>(res)`,wrap:!1}}),{c(){p=i("meta"),w=s(),T=i("p"),J=s(),m(_.$$.fragment),ze=s(),B=i("p"),B.textContent=jl,Ye=s(),v=i("p"),v.innerHTML=Ul,qe=s(),$=i("p"),$.innerHTML=bl,De=s(),Z=i("p"),Z.textContent=gl,Pe=s(),W=i("ol"),W.innerHTML=Il,Oe=s(),m(U.$$.fragment),Ke=s(),m(A.$$.fragment),et=s(),k=i("p"),k.textContent=Cl,tt=s(),x=i("ol"),x.innerHTML=_l,lt=s(),m(S.$$.fragment),nt=s(),b=i("ol"),b.innerHTML=Bl,st=s(),G=i("ul"),G.innerHTML=vl,at=s(),g=i("ol"),g.innerHTML=$l,it=s(),m(X.$$.fragment),ot=s(),m(V.$$.fragment),rt=s(),E=i("p"),E.innerHTML=Zl,pt=s(),H=i("p"),H.textContent=Wl,mt=s(),m(N.$$.fragment),ut=s(),R=i("p"),R.innerHTML=Al,Mt=s(),m(L.$$.fragment),ct=s(),Q=i("p"),Q.textContent=kl,dt=s(),F=i("ol"),F.innerHTML=xl,ht=s(),z=i("p"),z.innerHTML=Sl,Tt=s(),m(Y.$$.fragment),yt=s(),q=i("p"),q.innerHTML=Gl,wt=s(),D=i("p"),D.innerHTML=Xl,ft=s(),m(P.$$.fragment),Jt=s(),O=i("p"),O.innerHTML=Vl,jt=s(),m(K.$$.fragment),Ut=s(),m(ee.$$.fragment),bt=s(),te=i("p"),te.innerHTML=El,gt=s(),m(I.$$.fragment),It=s(),le=i("p"),le.textContent=Hl,Ct=s(),m(ne.$$.fragment),_t=s(),se=i("p"),se.textContent=Nl,Bt=s(),ae=i("ul"),ae.innerHTML=Rl,vt=s(),m(ie.$$.fragment),$t=s(),oe=i("p"),oe.innerHTML=Ll,Zt=s(),re=i("p"),re.innerHTML=Ql,Wt=s(),m(pe.$$.fragment),At=s(),me=i("p"),me.textContent=Fl,kt=s(),ue=i("p"),ue.innerHTML=zl,xt=s(),Me=i("p"),Me.innerHTML=Yl,St=s(),ce=i("p"),ce.innerHTML=ql,Gt=s(),m(de.$$.fragment),Xt=s(),m(he.$$.fragment),Vt=s(),m(C.$$.fragment),Et=s(),Te=i("p"),Te.innerHTML=Dl,Ht=s(),m(ye.$$.fragment),Nt=s(),m(we.$$.fragment),Rt=s(),fe=i("p"),fe.innerHTML=Pl,Lt=s(),Je=i("p"),Je.innerHTML=Ol,Qt=s(),je=i("p"),je.innerHTML=Kl,Ft=s(),Ue=i("p"),Ue.textContent=en,zt=s(),m(be.$$.fragment),Yt=s(),m(ge.$$.fragment),qt=s(),Ie=i("p"),Ie.textContent=tn,Dt=s(),Ce=i("p"),Ce.textContent=ln,Pt=s(),m(_e.$$.fragment),Ot=s(),Be=i("p"),Be.innerHTML=nn,Kt=s(),m(ve.$$.fragment),el=s(),m($e.$$.fragment),tl=s(),Ze=i("p"),Ze.textContent=sn,ll=s(),We=i("p"),We.innerHTML=an,nl=s(),m(Ae.$$.fragment),sl=s(),ke=i("p"),ke.innerHTML=on,al=s(),m(xe.$$.fragment),il=s(),Se=i("p"),Se.innerHTML=rn,ol=s(),m(Ge.$$.fragment),rl=s(),Xe=i("p"),Xe.textContent=pn,pl=s(),Ve=i("p"),Ve.innerHTML=mn,ml=s(),m(Ee.$$.fragment),ul=s(),He=i("blockquote"),He.innerHTML=un,Ml=s(),Ne=i("p"),Ne.textContent=Mn,cl=s(),m(Re.$$.fragment),dl=s(),Le=i("blockquote"),Le.innerHTML=cn,hl=s(),Qe=i("p"),Qe.textContent=dn,Tl=s(),Fe=i("p"),this.h()},l(e){const t=bn("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),w=a(e),T=o(e,"P",{}),wn(T).forEach(l),J=a(e),u(_.$$.fragment,e),ze=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-eibare"&&(B.textContent=jl),Ye=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-uoutuw"&&(v.innerHTML=Ul),qe=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1nxren4"&&($.innerHTML=bl),De=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1hahfn0"&&(Z.textContent=gl),Pe=a(e),W=o(e,"OL",{"data-svelte-h":!0}),r(W)!=="svelte-1fyd2c7"&&(W.innerHTML=Il),Oe=a(e),u(U.$$.fragment,e),Ke=a(e),u(A.$$.fragment,e),et=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-w52dpm"&&(k.textContent=Cl),tt=a(e),x=o(e,"OL",{"data-svelte-h":!0}),r(x)!=="svelte-15ega2l"&&(x.innerHTML=_l),lt=a(e),u(S.$$.fragment,e),nt=a(e),b=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(b)!=="svelte-w9kotu"&&(b.innerHTML=Bl),st=a(e),G=o(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-k05qsa"&&(G.innerHTML=vl),at=a(e),g=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(g)!=="svelte-qhor5j"&&(g.innerHTML=$l),it=a(e),u(X.$$.fragment,e),ot=a(e),u(V.$$.fragment,e),rt=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-s6kf7j"&&(E.innerHTML=Zl),pt=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-11lpom8"&&(H.textContent=Wl),mt=a(e),u(N.$$.fragment,e),ut=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1snwaj0"&&(R.innerHTML=Al),Mt=a(e),u(L.$$.fragment,e),ct=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1993zti"&&(Q.textContent=kl),dt=a(e),F=o(e,"OL",{"data-svelte-h":!0}),r(F)!=="svelte-1ho1mgn"&&(F.innerHTML=xl),ht=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1u9ozqi"&&(z.innerHTML=Sl),Tt=a(e),u(Y.$$.fragment,e),yt=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-uhn59v"&&(q.innerHTML=Gl),wt=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1js0azg"&&(D.innerHTML=Xl),ft=a(e),u(P.$$.fragment,e),Jt=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1w3fqpa"&&(O.innerHTML=Vl),jt=a(e),u(K.$$.fragment,e),Ut=a(e),u(ee.$$.fragment,e),bt=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-mblgk8"&&(te.innerHTML=El),gt=a(e),u(I.$$.fragment,e),It=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1bmdyu9"&&(le.textContent=Hl),Ct=a(e),u(ne.$$.fragment,e),_t=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-t16ze3"&&(se.textContent=Nl),Bt=a(e),ae=o(e,"UL",{"data-svelte-h":!0}),r(ae)!=="svelte-e6qxb9"&&(ae.innerHTML=Rl),vt=a(e),u(ie.$$.fragment,e),$t=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-2j4b1j"&&(oe.innerHTML=Ll),Zt=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-18s1pmt"&&(re.innerHTML=Ql),Wt=a(e),u(pe.$$.fragment,e),At=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1u0hmu2"&&(me.textContent=Fl),kt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1gsk3gh"&&(ue.innerHTML=zl),xt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-jypm7b"&&(Me.innerHTML=Yl),St=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-t9z3bd"&&(ce.innerHTML=ql),Gt=a(e),u(de.$$.fragment,e),Xt=a(e),u(he.$$.fragment,e),Vt=a(e),u(C.$$.fragment,e),Et=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-136s4kc"&&(Te.innerHTML=Dl),Ht=a(e),u(ye.$$.fragment,e),Nt=a(e),u(we.$$.fragment,e),Rt=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1yiqpri"&&(fe.innerHTML=Pl),Lt=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1anw499"&&(Je.innerHTML=Ol),Qt=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-ctfnvw"&&(je.innerHTML=Kl),Ft=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-17lv8z9"&&(Ue.textContent=en),zt=a(e),u(be.$$.fragment,e),Yt=a(e),u(ge.$$.fragment,e),qt=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-9y8mko"&&(Ie.textContent=tn),Dt=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1wuuxgn"&&(Ce.textContent=ln),Pt=a(e),u(_e.$$.fragment,e),Ot=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-66io75"&&(Be.innerHTML=nn),Kt=a(e),u(ve.$$.fragment,e),el=a(e),u($e.$$.fragment,e),tl=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-emhotm"&&(Ze.textContent=sn),ll=a(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1pgrxrm"&&(We.innerHTML=an),nl=a(e),u(Ae.$$.fragment,e),sl=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1sinvz7"&&(ke.innerHTML=on),al=a(e),u(xe.$$.fragment,e),il=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-jx2yqv"&&(Se.innerHTML=rn),ol=a(e),u(Ge.$$.fragment,e),rl=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1ytr5g6"&&(Xe.textContent=pn),pl=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1j8w2o0"&&(Ve.innerHTML=mn),ml=a(e),u(Ee.$$.fragment,e),ul=a(e),He=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(He)!=="svelte-6l4k0q"&&(He.innerHTML=un),Ml=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-ovzcvi"&&(Ne.textContent=Mn),cl=a(e),u(Re.$$.fragment,e),dl=a(e),Le=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Le)!=="svelte-15xrtpx"&&(Le.innerHTML=cn),hl=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-q9f4rf"&&(Qe.textContent=dn),Tl=a(e),Fe=o(e,"P",{}),wn(Fe).forEach(l),this.h()},h(){wl(p,"name","hf:doc:metadata"),wl(p,"content",vn),wl(b,"start","3"),wl(g,"start","4")},m(e,t){gn(document.head,p),n(e,w,t),n(e,T,t),n(e,J,t),M(_,e,t),n(e,ze,t),n(e,B,t),n(e,Ye,t),n(e,v,t),n(e,qe,t),n(e,$,t),n(e,De,t),n(e,Z,t),n(e,Pe,t),n(e,W,t),n(e,Oe,t),M(U,e,t),n(e,Ke,t),M(A,e,t),n(e,et,t),n(e,k,t),n(e,tt,t),n(e,x,t),n(e,lt,t),M(S,e,t),n(e,nt,t),n(e,b,t),n(e,st,t),n(e,G,t),n(e,at,t),n(e,g,t),n(e,it,t),M(X,e,t),n(e,ot,t),M(V,e,t),n(e,rt,t),n(e,E,t),n(e,pt,t),n(e,H,t),n(e,mt,t),M(N,e,t),n(e,ut,t),n(e,R,t),n(e,Mt,t),M(L,e,t),n(e,ct,t),n(e,Q,t),n(e,dt,t),n(e,F,t),n(e,ht,t),n(e,z,t),n(e,Tt,t),M(Y,e,t),n(e,yt,t),n(e,q,t),n(e,wt,t),n(e,D,t),n(e,ft,t),M(P,e,t),n(e,Jt,t),n(e,O,t),n(e,jt,t),M(K,e,t),n(e,Ut,t),M(ee,e,t),n(e,bt,t),n(e,te,t),n(e,gt,t),M(I,e,t),n(e,It,t),n(e,le,t),n(e,Ct,t),M(ne,e,t),n(e,_t,t),n(e,se,t),n(e,Bt,t),n(e,ae,t),n(e,vt,t),M(ie,e,t),n(e,$t,t),n(e,oe,t),n(e,Zt,t),n(e,re,t),n(e,Wt,t),M(pe,e,t),n(e,At,t),n(e,me,t),n(e,kt,t),n(e,ue,t),n(e,xt,t),n(e,Me,t),n(e,St,t),n(e,ce,t),n(e,Gt,t),M(de,e,t),n(e,Xt,t),M(he,e,t),n(e,Vt,t),M(C,e,t),n(e,Et,t),n(e,Te,t),n(e,Ht,t),M(ye,e,t),n(e,Nt,t),M(we,e,t),n(e,Rt,t),n(e,fe,t),n(e,Lt,t),n(e,Je,t),n(e,Qt,t),n(e,je,t),n(e,Ft,t),n(e,Ue,t),n(e,zt,t),M(be,e,t),n(e,Yt,t),M(ge,e,t),n(e,qt,t),n(e,Ie,t),n(e,Dt,t),n(e,Ce,t),n(e,Pt,t),M(_e,e,t),n(e,Ot,t),n(e,Be,t),n(e,Kt,t),M(ve,e,t),n(e,el,t),M($e,e,t),n(e,tl,t),n(e,Ze,t),n(e,ll,t),n(e,We,t),n(e,nl,t),M(Ae,e,t),n(e,sl,t),n(e,ke,t),n(e,al,t),M(xe,e,t),n(e,il,t),n(e,Se,t),n(e,ol,t),M(Ge,e,t),n(e,rl,t),n(e,Xe,t),n(e,pl,t),n(e,Ve,t),n(e,ml,t),M(Ee,e,t),n(e,ul,t),n(e,He,t),n(e,Ml,t),n(e,Ne,t),n(e,cl,t),M(Re,e,t),n(e,dl,t),n(e,Le,t),n(e,hl,t),n(e,Qe,t),n(e,Tl,t),n(e,Fe,t),yl=!0},p(e,[t]){const hn={};t&2&&(hn.$$scope={dirty:t,ctx:e}),U.$set(hn);const Tn={};t&2&&(Tn.$$scope={dirty:t,ctx:e}),I.$set(Tn);const yn={};t&2&&(yn.$$scope={dirty:t,ctx:e}),C.$set(yn)},i(e){yl||(c(_.$$.fragment,e),c(U.$$.fragment,e),c(A.$$.fragment,e),c(S.$$.fragment,e),c(X.$$.fragment,e),c(V.$$.fragment,e),c(N.$$.fragment,e),c(L.$$.fragment,e),c(Y.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(I.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(de.$$.fragment,e),c(he.$$.fragment,e),c(C.$$.fragment,e),c(ye.$$.fragment,e),c(we.$$.fragment,e),c(be.$$.fragment,e),c(ge.$$.fragment,e),c(_e.$$.fragment,e),c(ve.$$.fragment,e),c($e.$$.fragment,e),c(Ae.$$.fragment,e),c(xe.$$.fragment,e),c(Ge.$$.fragment,e),c(Ee.$$.fragment,e),c(Re.$$.fragment,e),yl=!0)},o(e){d(_.$$.fragment,e),d(U.$$.fragment,e),d(A.$$.fragment,e),d(S.$$.fragment,e),d(X.$$.fragment,e),d(V.$$.fragment,e),d(N.$$.fragment,e),d(L.$$.fragment,e),d(Y.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(I.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(de.$$.fragment,e),d(he.$$.fragment,e),d(C.$$.fragment,e),d(ye.$$.fragment,e),d(we.$$.fragment,e),d(be.$$.fragment,e),d(ge.$$.fragment,e),d(_e.$$.fragment,e),d(ve.$$.fragment,e),d($e.$$.fragment,e),d(Ae.$$.fragment,e),d(xe.$$.fragment,e),d(Ge.$$.fragment,e),d(Ee.$$.fragment,e),d(Re.$$.fragment,e),yl=!1},d(e){e&&(l(w),l(T),l(J),l(ze),l(B),l(Ye),l(v),l(qe),l($),l(De),l(Z),l(Pe),l(W),l(Oe),l(Ke),l(et),l(k),l(tt),l(x),l(lt),l(nt),l(b),l(st),l(G),l(at),l(g),l(it),l(ot),l(rt),l(E),l(pt),l(H),l(mt),l(ut),l(R),l(Mt),l(ct),l(Q),l(dt),l(F),l(ht),l(z),l(Tt),l(yt),l(q),l(wt),l(D),l(ft),l(Jt),l(O),l(jt),l(Ut),l(bt),l(te),l(gt),l(It),l(le),l(Ct),l(_t),l(se),l(Bt),l(ae),l(vt),l($t),l(oe),l(Zt),l(re),l(Wt),l(At),l(me),l(kt),l(ue),l(xt),l(Me),l(St),l(ce),l(Gt),l(Xt),l(Vt),l(Et),l(Te),l(Ht),l(Nt),l(Rt),l(fe),l(Lt),l(Je),l(Qt),l(je),l(Ft),l(Ue),l(zt),l(Yt),l(qt),l(Ie),l(Dt),l(Ce),l(Pt),l(Ot),l(Be),l(Kt),l(el),l(tl),l(Ze),l(ll),l(We),l(nl),l(sl),l(ke),l(al),l(il),l(Se),l(ol),l(rl),l(Xe),l(pl),l(Ve),l(ml),l(ul),l(He),l(Ml),l(Ne),l(cl),l(dl),l(Le),l(hl),l(Qe),l(Tl),l(Fe)),l(p),h(_,e),h(U,e),h(A,e),h(S,e),h(X,e),h(V,e),h(N,e),h(L,e),h(Y,e),h(P,e),h(K,e),h(ee,e),h(I,e),h(ne,e),h(ie,e),h(pe,e),h(de,e),h(he,e),h(C,e),h(ye,e),h(we,e),h(be,e),h(ge,e),h(_e,e),h(ve,e),h($e,e),h(Ae,e),h(xe,e),h(Ge,e),h(Ee,e),h(Re,e)}}}const vn='{"title":"Supervised Fine-Tuning of Llama 3 70B on one AWS Trainium instance","local":"supervised-fine-tuning-of-llama-3-70b-on-one-aws-trainium-instance","sections":[{"title":"1. Setup AWS Environment","local":"1-setup-aws-environment","sections":[],"depth":2},{"title":"2. Load and prepare the dataset","local":"2-load-and-prepare-the-dataset","sections":[],"depth":2},{"title":"3. Supervised Fine-Tuning of Llama on AWS Trainium with the NeuronSFTTrainer","local":"3-supervised-fine-tuning-of-llama-on-aws-trainium-with-the-neuronsfttrainer","sections":[{"title":"Formatting our dataset","local":"formatting-our-dataset","sections":[],"depth":3},{"title":"Preparing the model","local":"preparing-the-model","sections":[],"depth":3}],"depth":2},{"title":"4. Launch Training","local":"4-launch-training","sections":[{"title":"Precompilation","local":"precompilation","sections":[],"depth":3},{"title":"TODO: change the hyperparameters","local":"todo-change-the-hyperparameters","sections":[],"depth":3},{"title":"Actual Training","local":"actual-training","sections":[],"depth":3},{"title":"TODO: change the hyperparameters","local":"todo-change-the-hyperparameters","sections":[],"depth":3},{"title":"Consolidate the Checkpoint","local":"consolidate-the-checkpoint","sections":[],"depth":3}],"depth":2},{"title":"5. Evaluate and test fine-tuned Llama model","local":"5-evaluate-and-test-fine-tuned-llama-model","sections":[],"depth":2}],"depth":1}';function $n(j){return Jn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sn extends jn{constructor(p){super(),Un(this,p,$n,Bn,fn,{})}}export{Sn as component};
