import{s as bs,o as Cs,n as bl}from"../chunks/scheduler.a2b4ca8e.js";import{S as Is,i as gs,g as i,s as a,r as M,A as Bs,h as o,f as l,c as n,j as fs,u as m,x as p,k as jl,y as Ws,a as s,v as c,d as u,t as d,w as h}from"../chunks/index.d2f673cc.js";import{T as fl}from"../chunks/Tip.a902c250.js";import{C as j}from"../chunks/CodeBlock.792343a6.js";import{H as g}from"../chunks/Heading.675d4c1e.js";function ks(I){let r,f=`While we will use <code>Llama-3 8B</code> in this tutorial, it is completely possible to use other models, simply by swtiching the <code>model_id</code>.
For instance, it is possible to fine-tune:`,y,w,b='<li>Mistral models, such as  <a href="https://huggingface.co/mistralai/Mistral-7B-Instruct-v0.2" rel="nofollow">Mistral 7b (<code>mistralai/Mistral-7B-Instruct-v0.3</code>)</a></li> <li>Llama-2 models, such as <a href="https://huggingface.co/meta-llama/Llama-2-7b-hf" rel="nofollow">Llama-2 7b (<code>meta-llama/Llama-2-7b-hf</code>)</a></li>',T,U,qe="And many others!";return{c(){r=i("p"),r.innerHTML=f,y=a(),w=i("ul"),w.innerHTML=b,T=a(),U=i("p"),U.textContent=qe},l(J){r=o(J,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1f24nyx"&&(r.innerHTML=f),y=n(J),w=o(J,"UL",{"data-svelte-h":!0}),p(w)!=="svelte-1fsabqd"&&(w.innerHTML=b),T=n(J),U=o(J,"P",{"data-svelte-h":!0}),p(U)!=="svelte-yii95m"&&(U.textContent=qe)},m(J,C){s(J,r,C),s(J,y,C),s(J,w,C),s(J,T,C),s(J,U,C)},p:bl,d(J){J&&(l(r),l(y),l(w),l(T),l(U))}}}function Gs(I){let r,f='If you want to know more about distributed training you can take a look at the <a href="https://huggingface.co/docs/optimum-neuron/guides/distributed_training" rel="nofollow">documentation</a>.';return{c(){r=i("p"),r.innerHTML=f},l(y){r=o(y,"P",{"data-svelte-h":!0}),p(r)!=="svelte-yp02re"&&(r.innerHTML=f)},m(y,w){s(y,r,w)},p:bl,d(y){y&&l(r)}}}function Zs(I){let r,f='This script is a minimalistic version of our official example training script to run causal language modeling fine-tuning, called <a href="https://github.com/huggingface/optimum-neuron/blob/main/examples/language-modeling/run_clm.py" rel="nofollow">run_clm.py</a>. For the sake of this tutorial, we tried to get rid of anything that is not necessary, and added the formatting step necessary for fine-tuning, but if you want to do more custom things, maybe the solution is already implemented in <code>run_clm.py</code>!',y,w,b="Also, these scripts are more designed as templates than final scripts. Feel free to take <code>finetune_llm.py</code> or <code>run_clm.py</code> and adapt them to your own needs!";return{c(){r=i("p"),r.innerHTML=f,y=a(),w=i("p"),w.innerHTML=b},l(T){r=o(T,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1hrw5ii"&&(r.innerHTML=f),y=n(T),w=o(T,"P",{"data-svelte-h":!0}),p(w)!=="svelte-1k8wfq8"&&(w.innerHTML=b)},m(T,U){s(T,r,U),s(T,y,U),s(T,w,U)},p:bl,d(T){T&&(l(r),l(y),l(w))}}}function _s(I){let r,f="Make sure to run this precompilation phase for around 10 training steps. It is usually enough to accumulate and compile all the graphs that will be needed during the actual training.";return{c(){r=i("p"),r.textContent=f},l(y){r=o(y,"P",{"data-svelte-h":!0}),p(r)!=="svelte-1k7qt99"&&(r.textContent=f)},m(y,w){s(y,r,w)},p:bl,d(y){y&&l(r)}}}function vs(I){let r,f,y,w,b,T,U,qe="[[open-in-collab]]",J,C,Cl='<em>Note: The complete script for this tutorial can be downloaded <a href="https://github.com/huggingface/optimum-neuron/blob/main/docs/source/training_tutorials/finetune_llm.py" rel="nofollow">here</a>.</em>',De,v,Il='This tutorial will teach you how to fine-tune open source LLMs like <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B" rel="nofollow">Llama 3</a> on AWS Trainium. In our example, we are going to leverage the <a href="https://huggingface.co/docs/optimum-neuron/index" rel="nofollow">Optimum Neuron</a>, <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">Transformers</a> and <a href="https://huggingface.co/docs/datasets/index" rel="nofollow">Datasets</a> libraries.',Ke,X,gl="You will learn how to:",Oe,x,Bl='<li><a href="#1-setup-aws-environment">Setup AWS Environment</a></li> <li><a href="#2-load-and-prepare-the-dataset">Load and process the dataset</a></li> <li><a href="#3-fine-tune-llama-on-aws-trainium-using-the-neurontrainer">Fine-tune Llama on AWS Trainium using the <code>NeuronTrainer</code></a></li> <li><a href="#4-launch-training">Launch Training</a></li> <li><a href="#5-evaluate-and-test-fine-tuned-llama-model">Evaluate and test fine-tuned Llama model</a></li>',et,B,tt,$,lt,R,Wl="Before starting this tutorial, you will need to setup your environment:",st,V,kl='<li>Create an AWS Trainium instance. <strong>You will need a <code>trn1.32xlarge</code>, which contains 16 Neuron Devices.</strong> You can follow this <a href="https://huggingface.co/docs/optimum-neuron/guides/setup_aws_instance" rel="nofollow">guide</a> to create one.</li> <li>Make sure you are logged in on the Hugging Face Hub:</li>',at,A,nt,W,Gl="<li>Check that you have access to the model. Some open source models are gated, meaning that users need to apply to the model owner to be able to use the model weights. Here we will be training Llama-3 8B, for which there are two possibilities:</li>",it,H,Zl='<li>The official gated repo: <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B" rel="nofollow"><code>meta-llama/Meta-Llama-3-8B</code></a></li> <li>The non-official un-gated repo: <a href="https://huggingface.co/NousResearch/Meta-Llama-3-8B" rel="nofollow"><code>NousResearch/Meta-Llama-3-8B</code></a></li>',ot,k,_l='<li>Clone the Optimum Neuron repository, <strong>which contains the <a href="https://github.com/huggingface/optimum-neuron/blob/main/docs/source/training_tutorials/finetune_llm.py" rel="nofollow">complete script</a> described in this tutorial:</strong></li>',pt,S,rt,Y,Mt,N,vl='For this tutorial, we will use <a href="https://huggingface.co/datasets/databricks/databricks-dolly-15k" rel="nofollow">Dolly</a>, an open source dataset of instruction-following records on categories outlined in the <a href="https://arxiv.org/abs/2203.02155" rel="nofollow">InstructGPT paper</a>, including brainstorming, classification, closed QA, generation, information extraction, open QA, and summarization.',mt,z,Xl="Example:",ct,Q,ut,E,xl="We can use the <code>load_dataset()</code> method from the 🤗 Datasets library to load the <code>dolly</code> dataset very easily.",dt,F,ht,L,$l="To instruct tune our model we need to convert our structured examples into a collection of tasks described via instructions. We define a <code>format_dolly</code> that takes a raw sample and returns a string with our format instruction.",yt,q,wt,P,Rl="In addition to formatting our samples, we also want to pack multiple samples to one sequence to have a more efficient training. In other words, we are stacking multiple samples to one sequence and split them with an EOS Token. Packing/stacking samples can be done during training or before.",Tt,D,Vl="The following function <code>pack_dataset</code> takes a <code>dataset</code> and a <code>chunk_length</code> and returns a packed dataset:",Ut,K,Jt,O,Al="To summarize to prepare our dataset we will:",jt,ee,Hl="<li>Format our samples using the template method and add an EOS token at the end of each sample</li> <li>Tokenize our dataset to convert it from text to tokens</li> <li>Pack our dataset to 2048 tokens</li>",ft,te,bt,le,Ct,se,Sl='Normally you would use the <strong><a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a></strong> and <strong><a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a></strong> classes to fine-tune PyTorch-based transformer models.',It,ae,Yl="But together with AWS, we have developed the [~<code>optimum.neuron.NeuronTrainer</code>] to improve performance, robustness, and ease-of-use when training on Trainium instances. It can be used as a 1-to-1 replacement for the <code>Trainer</code>.",gt,ne,Nl="Since Llama-3 8B is a big model it will not fit on a single Neuron core, we need distributed training. In Optimum Neuron we support:",Bt,ie,zl='<li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/frameworks/torch/torch-neuronx/tutorials/training/zero1_gpt2.html" rel="nofollow">ZeRO-1</a>: It is an optimization of data-parallelism which consists in sharding the optimizer state (which usually represents half or more of the memory needed on the device) over the data-parallel ranks.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/tensor_parallelism_overview.html" rel="nofollow">Tensor Parallelism</a>: It is a technique which consists in sharding each of your model matrix-multiplications along a given axis (row or column) on multiple devices. It also known as intra-layer model parallelism. The number of devices to shard your parameters on is called the <code>tensor_parallel_size</code>.</li> <li><a href="https://arxiv.org/pdf/2205.05198.pdf" rel="nofollow">Sequence parallelism</a>: It is an optimization over Tensor Parallelism which shards the activations on the sequence axis outside of the tensor parallel regions. It is useful because it saves memory by sharding the activations.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/pipeline_parallelism_overview.html" rel="nofollow">Pipeline Parallelism</a>: It consists in sharding the model block layers on multiple devices. It is also known as inter-layer model parallelism. The number of devices to shard your layers on is called the <code>pipeline_parallel_size</code>.</li>',Wt,G,kt,oe,Ql=`Here, since we want to fine-tune an 8B model, we will not need to use pipeline parallelism.
Our training code will look as follows:`,Gt,pe,Zt,re,El="The key points here are:",_t,Me,Fl="<li>We use the <code>lazy_load_for_parallelism</code> context manager to lazily load the model. This will not load the full model weights on each worker, but instead only load the required weights (sharded or full). <strong>This is much more memory efficient, and often mandatory to use.</strong></li> <li>We use the [~<code>optimum.neuron.NeuronTrainer</code>] to perform training. It will take the lazily loaded model, along with the <code>training_args</code>, which are an instance of [~<code>optimum.neuron.NeuronTrainingArguments</code>], and will handle all the parallelization and training on the Neuron cores.</li>",vt,me,Xt,ce,Ll='We prepared a script called <a href="https://github.com/huggingface/optimum-neuron/blob/main/docs/source/training_tutorials/finetune_llm.py" rel="nofollow">finetune_llm.py</a> summing up everything mentioned in this tutorial.',xt,Z,$t,ue,ql="PyTorch Neuron uses <code>torch_xla</code>. It evaluates operations lazily during execution of the training loops, which means it builds a symbolic graph in the background and the graph is executed on the hardware only when the tensor is printed, transfered to CPU, or <code>xm.mark_step()</code> is called. During execution, multiple graphs can be build depending on control-flow and it can take time to compile each graph sequentially. To alleviate that, the Neuron SDK provides <code>neuron_parallel_compile</code>, a tool which performs a fast trial run that builds all the graphs and compile them in parallel. This step is usually called precompilation.",Rt,de,Vt,he,Pl="When training models on AWS Trainium we first need to compile our model with our training arguments.",At,ye,Dl='To overcome this, we added a <a href="https://huggingface.co/docs/optimum-neuron/guides/cache_system" rel="nofollow">model cache repository</a>, which allows us to use precompiled models from the Hugging Face Hub to skip the compilation step. But be careful: every change in the model configuration might lead to a new compilation, which could result in some cache misses.',Ht,we,Kl='<em>Note: If your model configuration is not cached please open an issue on <a href="https://github.com/huggingface/optimum-neuron/issues" rel="nofollow">Github</a>, we are happy to include it.</em>',St,Te,Ol="The compilation command simply consists in calling your script as an input to the <code>neuron_parallel_compile</code> utility:",Yt,Ue,Nt,_,zt,Je,es="<em>Note: Compiling without a cache can take a while. It will also create dummy files in the <code>dolly_llama_sharded</code> during compilation you will have to remove them afterwards. We also need to add <code>MALLOC_ARENA_MAX=64</code> to limit the CPU allocation to avoid potential crashes, don’t remove it for now.</em>",Qt,je,Et,fe,Ft,be,ts="After compilation is done we can start our actual training with a similar command, we just need to remove the use of <code>neuron_parallel_compile</code>.",Lt,Ce,ls="We will use <code>torchrun</code> to launch our training script. <code>torchrun</code> is a tool that automatically distributes a PyTorch model across multiple accelerators. We can pass the number of accelerators as <code>nproc_per_node</code> arguments alongside our hyperparameters.",qt,Ie,ss="The difference to the compilation command is that we changed from <code>max_steps=10</code> to <code>num_train_epochs=3</code>.",Pt,ge,as="Launch the training, with the following command.",Dt,Be,Kt,We,ns="That’s it, we successfully trained Llama-3 8B on AWS Trainium!",Ot,ke,is="But before we can share and test our model we need to consolidate our model. Since we used Tensor Parallelism during training, we saved sharded versions of the checkpoints. We need to consolidate them now.",el,Ge,tl,Ze,os="The Optimum CLI provides a way of doing that very easily via the <code>optimum neuron consolidate [sharded_checkpoint] [output_dir]</code> command:",ll,_e,sl,ve,al,Xe,ps="As for training, to be able to run inference on AWS Trainium or AWS Inferentia2 we need to compile our model. In this case, we will use our Trainium instance for the inference test, but we recommend customer to switch to Inferentia2 for inference.",nl,xe,rs="Optimum Neuron implements similar to Transformers AutoModel classes for easy inference use. We will use the <code>NeuronModelForCausalLM</code> class to load our vanilla transformers checkpoint and convert it to neuron.",il,$e,ol,Re,Ms="<em>Note: Inference compilation can take ~25minutes. Luckily, you need to only run this onces. Since you can save the model afterwards. If you are going to run on Inferentia2 you need to recompile again. The compilation is parameter and hardware specific.</em>",pl,Ve,rl,Ae,ms="We can now test inference, but have to make sure we format our input to our prompt format we used for fine-tuning. Therefore we created a helper method, which accepts a <code>dict</code> with our <code>instruction</code> and optionally a <code>context</code>.",Ml,He,ml,Se,cs="Let’s test inference. First we test without a context.",cl,Ye,us="<em>Note: Inference is not expected to be super fast on AWS Trainium using 2 cores. For Inference we recommend using Inferentia2.</em>",ul,Ne,dl,ze,ds="<p>AWS stands for Amazon Web Services. AWS is a suite of remote computing services offered by Amazon. The most widely used of these include Amazon Elastic Compute Cloud (Amazon EC2), which provides resizable compute capacity in the cloud; Amazon Simple Storage Service (Amazon S3), which is an object storage service; and Amazon Elastic Block Store (Amazon EBS), which is designed to provide high performance, durable block storage volumes for use with AWS instances. AWS also provides other services, such as AWS Identity and Access Management (IAM), a service that enables organizations to control access to their AWS resources, and AWS Key Management Service (AWS KMS), which helps customers create and control the use of encryption keys.</p>",hl,Qe,hs="That looks correct. Now, lets add some context, e.g. as you would do for RAG applications:",yl,Ee,wl,Fe,ys="<p>You can use the Optimum Neuron interface to train models on AWS Trainium.</p>",Tl,Le,ws="Awesome, our model also correctly uses the provided context. We are done. Congrats on fine-tuning Llama on AWS Trainium.",Ul,Pe,Jl;return b=new g({props:{title:"Fine-tune and Test Llama-3 8B on AWS Trainium",local:"fine-tune-and-test-llama-3-8b-on-aws-trainium",headingTag:"h1"}}),B=new fl({props:{$$slots:{default:[ks]},$$scope:{ctx:I}}}),$=new g({props:{title:"1. Setup AWS Environment",local:"1-setup-aws-environment",headingTag:"h2"}}),A=new j({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4lMjAtLXRva2VuJTIwWU9VUl9UT0tFTg==",highlighted:"huggingface-cli login --token YOUR_TOKEN",wrap:!1}}),S=new j({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRm9wdGltdW0tbmV1cm9uLmdpdA==",highlighted:'git <span class="hljs-built_in">clone</span> https://github.com/huggingface/optimum-neuron.git',wrap:!1}}),Y=new g({props:{title:"2. Load and prepare the dataset",local:"2-load-and-prepare-the-dataset",headingTag:"h2"}}),Q=new j({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB3b3JsZCUyMG9mJTIwd2FyY3JhZnQlMjIlMkMlMEElMjAlMjAlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTIyJTJDJTBBJTIwJTIwJTIycmVzcG9uc2UlMjIlM0ElMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV29ybGQlMjBvZiUyMHdhcmNyYWZ0JTIwaXMlMjBhJTIwbWFzc2l2ZSUyMG9ubGluZSUyMG11bHRpJTIwcGxheWVyJTIwcm9sZSUyMHBsYXlpbmclMjBnYW1lLiUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkl0JTIwd2FzJTIwcmVsZWFzZWQlMjBpbiUyMDIwMDQlMjBieSUyMGJsaXphcnJlJTIwZW50ZXJ0YWlubWVudCUyMiUwQSUyMCUyMCUyMCUyMCklMEElN0Q=",highlighted:`{
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What is world of warcraft&quot;</span>,
  <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;&quot;</span>,
  <span class="hljs-string">&quot;response&quot;</span>: (
        <span class="hljs-string">&quot;World of warcraft is a massive online multi player role playing game. &quot;</span>
        <span class="hljs-string">&quot;It was released in 2004 by blizarre entertainment&quot;</span>
    )
}`,wrap:!1}}),F=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRyYW5nZSUwQSUwQSUyMyUyMExvYWQlMjBkYXRhc2V0JTIwZnJvbSUyMHRoZSUyMGh1YiUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZGF0YWJyaWNrcyUyRmRhdGFicmlja3MtZG9sbHktMTVrJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEFwcmludChmJTIyZGF0YXNldCUyMHNpemUlM0ElMjAlN0JsZW4oZGF0YXNldCklN0QlMjIpJTBBcHJpbnQoZGF0YXNldCU1QnJhbmRyYW5nZShsZW4oZGF0YXNldCkpJTVEKSUwQSUyMyUyMGRhdGFzZXQlMjBzaXplJTNBJTIwMTUwMTE=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randrange

<span class="hljs-comment"># Load dataset from the hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;databricks/databricks-dolly-15k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset)}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(dataset[randrange(<span class="hljs-built_in">len</span>(dataset))])
<span class="hljs-comment"># dataset size: 15011</span>`,wrap:!1}}),q=new j({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5KHNhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBpbnN0cnVjdGlvbiUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiU1Q24lN0JzYW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwY29udGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBDb250ZXh0JTVDbiU3QnNhbXBsZSU1Qidjb250ZXh0JyU1RCU3RCUyMiUyMGlmJTIwbGVuKHNhbXBsZSU1QiUyMmNvbnRleHQlMjIlNUQpJTIwJTNFJTIwMCUyMGVsc2UlMjBOb25lJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQW5zd2VyJTVDbiU3QnNhbXBsZSU1QidyZXNwb25zZSclNUQlN0QlMjIlMEElMjAlMjAlMjAlMjAlMjMlMjBqb2luJTIwYWxsJTIwdGhlJTIwcGFydHMlMjB0b2dldGhlciUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMiU1Q24lNUNuJTIyLmpvaW4oJTVCaSUyMGZvciUyMGklMjBpbiUyMCU1Qmluc3RydWN0aW9uJTJDJTIwY29udGV4dCUyQyUyMHJlc3BvbnNlJTVEJTIwaWYlMjBpJTIwaXMlMjBub3QlMjBOb25lJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByb21wdA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly</span>(<span class="hljs-params">sample</span>):
    instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>&quot;</span>
    context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;context&quot;</span>]) &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    response = <span class="hljs-string">f&quot;### Answer\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;response&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-comment"># join all the parts together</span>
    prompt = <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> [instruction, context, response] <span class="hljs-keyword">if</span> i <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>])
    <span class="hljs-keyword">return</span> prompt`,wrap:!1}}),K=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial
<span class="hljs-keyword">from</span> itertools <span class="hljs-keyword">import</span> chain

<span class="hljs-comment"># empty list to save remainder from batches to use in next batch</span>
remainder = {<span class="hljs-string">&quot;input_ids&quot;</span>: [], <span class="hljs-string">&quot;attention_mask&quot;</span>: [], <span class="hljs-string">&quot;token_type_ids&quot;</span>: []}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">pack_dataset</span>(<span class="hljs-params">dataset, chunk_length=<span class="hljs-number">2048</span></span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Chunking dataset into chunks of <span class="hljs-subst">{chunk_length}</span> tokens.&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">chunk</span>(<span class="hljs-params">sample, chunk_length=chunk_length</span>):
        <span class="hljs-comment"># define global remainder variable to save remainder from batches to use in next batch</span>
        <span class="hljs-keyword">global</span> remainder
        <span class="hljs-comment"># Concatenate all texts and add remainder from previous batch</span>
        concatenated_examples = {k: <span class="hljs-built_in">list</span>(chain(*sample[k])) <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> sample.keys()}
        concatenated_examples = {k: remainder[k] + concatenated_examples[k] <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> concatenated_examples.keys()}
        <span class="hljs-comment"># get total number of tokens for batch</span>
        batch_total_length = <span class="hljs-built_in">len</span>(concatenated_examples[<span class="hljs-built_in">list</span>(sample.keys())[<span class="hljs-number">0</span>]])

        <span class="hljs-comment"># get max number of chunks for batch</span>
        <span class="hljs-keyword">if</span> batch_total_length &gt;= chunk_length:
            batch_chunk_length = (batch_total_length // chunk_length) * chunk_length

        <span class="hljs-comment"># Split by chunks of max_len.</span>
        result = {
            k: [t[i : i + chunk_length] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, batch_chunk_length, chunk_length)]
            <span class="hljs-keyword">for</span> k, t <span class="hljs-keyword">in</span> concatenated_examples.items()
        }
        <span class="hljs-comment"># add remainder to global variable for next batch</span>
        remainder = {k: concatenated_examples[k][batch_chunk_length:] <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> concatenated_examples.keys()}
        <span class="hljs-comment"># prepare labels</span>
        result[<span class="hljs-string">&quot;labels&quot;</span>] = result[<span class="hljs-string">&quot;input_ids&quot;</span>].copy()
        <span class="hljs-keyword">return</span> result

    <span class="hljs-comment"># tokenize and chunk dataset</span>
    lm_dataset = dataset.<span class="hljs-built_in">map</span>(
        partial(chunk, chunk_length=chunk_length),
        batched=<span class="hljs-literal">True</span>,
    )
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Total number of samples: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(lm_dataset)}</span>&quot;</span>)
    <span class="hljs-keyword">return</span> lm_dataset`,wrap:!1}}),te=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwcmFuZG9tJTIwaW1wb3J0JTIwcmFuZGludCUwQSUwQSUyMyUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwbW9kZWwlMjBpZCUyMCUwQSUyMyUyMG1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04QiUyMiUyMCUyMyUyMGdhdGVkJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJOb3VzUmVzZWFyY2glMkZNZXRhLUxsYW1hLTMtOEIlMjIlMjAlMjMlMjB1bmdhdGVkJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBJTIzJTIwdGVtcGxhdGUlMjBkYXRhc2V0JTIwdG8lMjBhZGQlMjBwcm9tcHQlMjB0byUyMGVhY2glMjBzYW1wbGUlMEFkZWYlMjB0ZW1wbGF0ZV9kYXRhc2V0KHNhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEJTIwJTNEJTIwZiUyMiU3QmZvcm1hdF9kb2xseShzYW1wbGUpJTdEJTdCdG9rZW5pemVyLmVvc190b2tlbiU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNhbXBsZSUwQSUwQSUyMyUyMGFwcGx5JTIwcHJvbXB0JTIwdGVtcGxhdGUlMjBwZXIlMjBzYW1wbGUlMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAodGVtcGxhdGVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEbGlzdChkYXRhc2V0LmZlYXR1cmVzKSklMEElMEElMjMlMjBwcmludCUyMHJhbmRvbSUyMHNhbXBsZSUwQXByaW50KGRhdGFzZXQlNUJyYW5kaW50KDAlMkMlMjBsZW4oZGF0YXNldCkpJTVEJTVCJTIydGV4dCUyMiU1RCklMEElMEElMjMlMjB0b2tlbml6ZSUyMGRhdGFzZXQlMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoJTBBJTIwJTIwJTIwJTIwbGFtYmRhJTIwc2FtcGxlJTNBJTIwdG9rZW5pemVyKHNhbXBsZSU1QiUyMnRleHQlMjIlNUQpJTJDJTIwYmF0Y2hlZCUzRFRydWUlMkMlMjByZW1vdmVfY29sdW1ucyUzRGxpc3QoZGF0YXNldC5mZWF0dXJlcyklMEEpJTBBJTBBJTIzJTIwY2h1bmslMjBkYXRhc2V0JTBBbG1fZGF0YXNldCUyMCUzRCUyMHBhY2tfZGF0YXNldChkYXRhc2V0JTJDJTIwY2h1bmtfbGVuZ3RoJTNEMjA0OCklMjAlMjMlMjBXZSUyMHVzZSUyMDIwNDglMjBhcyUyMHRoZSUyMG1heGltdW0lMjBsZW5ndGglMjBmb3IlMjBwYWNraW5n",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randint

<span class="hljs-comment"># Hugging Face Hub model id </span>
<span class="hljs-comment"># model_id = &quot;meta-llama/Meta-Llama-3-8B&quot; # gated</span>
model_id = <span class="hljs-string">&quot;NousResearch/Meta-Llama-3-8B&quot;</span> <span class="hljs-comment"># ungated</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-comment"># template dataset to add prompt to each sample</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">template_dataset</span>(<span class="hljs-params">sample</span>):
    sample[<span class="hljs-string">&quot;text&quot;</span>] = <span class="hljs-string">f&quot;<span class="hljs-subst">{format_dolly(sample)}</span><span class="hljs-subst">{tokenizer.eos_token}</span>&quot;</span>
    <span class="hljs-keyword">return</span> sample

<span class="hljs-comment"># apply prompt template per sample</span>
dataset = dataset.<span class="hljs-built_in">map</span>(template_dataset, remove_columns=<span class="hljs-built_in">list</span>(dataset.features))

<span class="hljs-comment"># print random sample</span>
<span class="hljs-built_in">print</span>(dataset[randint(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset))][<span class="hljs-string">&quot;text&quot;</span>])

<span class="hljs-comment"># tokenize dataset</span>
dataset = dataset.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> sample: tokenizer(sample[<span class="hljs-string">&quot;text&quot;</span>]), batched=<span class="hljs-literal">True</span>, remove_columns=<span class="hljs-built_in">list</span>(dataset.features)
)

<span class="hljs-comment"># chunk dataset</span>
lm_dataset = pack_dataset(dataset, chunk_length=<span class="hljs-number">2048</span>) <span class="hljs-comment"># We use 2048 as the maximum length for packing</span>`,wrap:!1}}),le=new g({props:{title:"3. Fine-tune Llama on AWS Trainium using the NeuronTrainer",local:"3-fine-tune-llama-on-aws-trainium-using-the-neurontrainer",headingTag:"h2"}}),G=new fl({props:{$$slots:{default:[Gs]},$$scope:{ctx:I}}}),pe=new j({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5lciUyMGFzJTIwVHJhaW5lciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbi5kaXN0cmlidXRlZCUyMGltcG9ydCUyMGxhenlfbG9hZF9mb3JfcGFyYWxsZWxpc20lMEElMEElMjMlMjBEZWZpbmUlMjB0aGUlMjB0ZW5zb3JfcGFyYWxsZWxfc2l6ZSUwQXRlbnNvcl9wYXJhbGxlbF9zaXplJTIwJTNEJTIwOCUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBIdWdnaW5nJTIwZmFjZSUyMEh1YiUyMCUwQXdpdGglMjBsYXp5X2xvYWRfZm9yX3BhcmFsbGVsaXNtKHRlbnNvcl9wYXJhbGxlbF9zaXplJTNEdGVuc29yX3BhcmFsbGVsX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEZGVmYXVsdF9kYXRhX2NvbGxhdG9yJTJDJTIwJTIwJTIzJTIwbm8lMjBzcGVjaWFsJTIwY29sbGF0b3IlMjBuZWVkZWQlMjBzaW5jZSUyMHdlJTIwc3RhY2tlZCUyMHRoZSUyMGRhdGFzZXQlMEEpJTBBJTBBJTIzJTIwU3RhcnQlMjB0cmFpbmluZyUwQXRyYWluZXIudHJhaW4oKSUwQSUwQXRyYWluZXIuc2F2ZV9tb2RlbCgpJTIwJTIwJTIzJTIwc2F2ZXMlMjB0aGUlMjB0b2tlbml6ZXIlMjB0b28lMjBmb3IlMjBlYXN5JTIwdXBsb2Fk",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainer <span class="hljs-keyword">as</span> Trainer
<span class="hljs-keyword">from</span> optimum.neuron.distributed <span class="hljs-keyword">import</span> lazy_load_for_parallelism

<span class="hljs-comment"># Define the tensor_parallel_size</span>
tensor_parallel_size = <span class="hljs-number">8</span>

<span class="hljs-comment"># Load model from the Hugging face Hub </span>
<span class="hljs-keyword">with</span> lazy_load_for_parallelism(tensor_parallel_size=tensor_parallel_size):
    model = AutoModelForCausalLM.from_pretrained(model_id)

trainer = Trainer(
    model=model,
    tokenizer=tokenizer,
    args=training_args,
    train_dataset=dataset,
    data_collator=default_data_collator,  <span class="hljs-comment"># no special collator needed since we stacked the dataset</span>
)

<span class="hljs-comment"># Start training</span>
trainer.train()

trainer.save_model()  <span class="hljs-comment"># saves the tokenizer too for easy upload</span>`,wrap:!1}}),me=new g({props:{title:"4. Launch Training",local:"4-launch-training",headingTag:"h2"}}),Z=new fl({props:{$$slots:{default:[Zs]},$$scope:{ctx:I}}}),de=new g({props:{title:"Precompilation",local:"precompilation",headingTag:"h3"}}),Ue=new j({props:{code:"TUFMTE9DX0FSRU5BX01BWCUzRDY0JTIwWExBX1VTRV9CRjE2JTNEMSUyMG5ldXJvbl9wYXJhbGxlbF9jb21waWxlJTIwdG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMzIlMjBmaW5ldHVuZV9sbG0ucHklMjAlNUMlMEElMjAtLW1vZGVsX2lkJTIwbWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItaGYlMjAlNUMlMEElMjAtLWJmMTYlMjBUcnVlJTIwJTVDJTBBJTIwLS1sZWFybmluZ19yYXRlJTIwNWUtNSUyMCU1QyUwQSUyMC0tb3V0cHV0X2RpciUyMGRvbGx5X2xsYW1hJTIwJTVDJTBBJTIwLS1vdmVyd3JpdGVfb3V0cHV0X2RpciUyMFRydWUlMjAlNUMlMEElMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMDE2JTIwJTVDJTBBJTIwLS1ncmFkaWVudF9jaGVja3BvaW50aW5nJTIwVHJ1ZSUyMCU1QyUwQSUyMC0tdGVuc29yX3BhcmFsbGVsX3NpemUlMjA4JTIwJTVDJTBBJTIwLS1tYXhfc3RlcHMlMjAxMCUyMCU1QyUwQSUyMC0tbG9nZ2luZ19zdGVwcyUyMDEw",highlighted:`MALLOC_ARENA_MAX=64 XLA_USE_BF16=1 neuron_parallel_compile torchrun --nproc_per_node=32 finetune_llm.py \\
 --model_id meta-llama/Llama-2-7b-hf \\
 --bf16 True \\
 --learning_rate 5e-5 \\
 --output_dir dolly_llama \\
 --overwrite_output_dir True \\
 --per_device_train_batch_size 1 \\
 --gradient_accumulation_steps 16 \\
 --gradient_checkpointing True \\
 --tensor_parallel_size 8 \\
 --max_steps 10 \\
 --logging_steps 10`,wrap:!1}}),_=new fl({props:{$$slots:{default:[_s]},$$scope:{ctx:I}}}),je=new j({props:{code:"JTIzJTIwcmVtb3ZlJTIwZHVtbXklMjBhcnRpZmFjdHMlMjB3aGljaCUyMGFyZSUyMGNyZWF0ZWQlMjBieSUyMHRoZSUyMHByZWNvbXBpbGF0aW9uJTIwY29tbWFuZCUwQXJtJTIwLXJmJTIwZG9sbHlfbGxhbWE=",highlighted:`<span class="hljs-comment"># remove dummy artifacts which are created by the precompilation command</span>
<span class="hljs-built_in">rm</span> -rf dolly_llama`,wrap:!1}}),fe=new g({props:{title:"Actual Training",local:"actual-training",headingTag:"h3"}}),Be=new j({props:{code:"TUFMTE9DX0FSRU5BX01BWCUzRDY0JTIwWExBX1VTRV9CRjE2JTNEMSUyMHRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDMyJTIwZmluZXR1bmVfbGxtLnB5JTIwJTVDJTBBJTIwLS1tb2RlbF9pZCUyMG1ldGEtbGxhbWElMkZMbGFtYS0yLTdiLWhmJTIwJTVDJTBBJTIwLS1iZjE2JTIwVHJ1ZSUyMCU1QyUwQSUyMC0tbGVhcm5pbmdfcmF0ZSUyMDVlLTUlMjAlNUMlMEElMjAtLW91dHB1dF9kaXIlMjBkb2xseV9sbGFtYSUyMCU1QyUwQSUyMC0tb3ZlcndyaXRlX291dHB1dF9kaXIlMjBUcnVlJTIwJTVDJTBBJTIwLS1za2lwX2NhY2hlX3B1c2glMjBUcnVlJTIwJTVDJTBBJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAxJTIwJTVDJTBBJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAxNiUyMCU1QyUwQSUyMC0tZ3JhZGllbnRfY2hlY2twb2ludGluZyUyMFRydWUlMjAlNUMlMEElMjAtLXRlbnNvcl9wYXJhbGxlbF9zaXplJTIwOCUyMCU1QyUwQSUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDMlMjAlNUMlMEElMjAtLWxvZ2dpbmdfc3RlcHMlMjAxMA==",highlighted:`MALLOC_ARENA_MAX=64 XLA_USE_BF16=1 torchrun --nproc_per_node=32 finetune_llm.py \\
 --model_id meta-llama/Llama-2-7b-hf \\
 --bf16 True \\
 --learning_rate 5e-5 \\
 --output_dir dolly_llama \\
 --overwrite_output_dir True \\
 --skip_cache_push True \\
 --per_device_train_batch_size 1 \\
 --gradient_accumulation_steps 16 \\
 --gradient_checkpointing True \\
 --tensor_parallel_size 8 \\
 --num_train_epochs 3 \\
 --logging_steps 10`,wrap:!1}}),Ge=new g({props:{title:"Consolidate the Checkpoint",local:"consolidate-the-checkpoint",headingTag:"h3"}}),_e=new j({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMGRvbGx5X2xsYW1hJTIwZG9sbHlfbGxhbWE=",highlighted:"optimum-cli neuron consolidate dolly_llama dolly_llama",wrap:!1}}),ve=new g({props:{title:"5. Evaluate and test fine-tuned Llama model",local:"5-evaluate-and-test-fine-tuned-llama-model",headingTag:"h2"}}),$e=new j({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMm51bV9jb3JlcyUyMiUzQSUyMDIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCdmcDE2JyU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyc2VxdWVuY2VfbGVuZ3RoJTIyJTNBJTIwMjA0OCU3RCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRvbGx5X2xsYW1hJTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZG9sbHlfbGxhbWElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKipjb21waWxlcl9hcmdzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKippbnB1dF9zaGFwZXMp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCausalLM
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

compiler_args = {<span class="hljs-string">&quot;num_cores&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&#x27;fp16&#x27;</span>}
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">2048</span>}

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;dolly_llama&quot;</span>)
model = NeuronModelForCausalLM.from_pretrained(
        <span class="hljs-string">&quot;dolly_llama&quot;</span>,
        export=<span class="hljs-literal">True</span>,
        **compiler_args,
        **input_shapes)`,wrap:!1}}),Ve=new j({props:{code:"JTIzJTIwQ09NTUVOVCUyMElOJTIwaWYlMjB5b3UlMjB3YW50JTIwdG8lMjBzYXZlJTIwdGhlJTIwY29tcGlsZWQlMjBtb2RlbCUwQSUyMyUyMG1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJjb21waWxlZF9kb2xseV9sbGFtYSUyMik=",highlighted:`<span class="hljs-comment"># COMMENT IN if you want to save the compiled model</span>
<span class="hljs-comment"># model.save_pretrained(&quot;compiled_dolly_llama&quot;)</span>`,wrap:!1}}),He=new j({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5X2luZmVyZW5jZShzYW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwaW5zdHJ1Y3Rpb24lMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwSW5zdHJ1Y3Rpb24lNUNuJTdCc2FtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMGNvbnRleHQlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQ29udGV4dCU1Q24lN0JzYW1wbGUlNUInY29udGV4dCclNUQlN0QlMjIlMjBpZiUyMCUyMmNvbnRleHQlMjIlMjBpbiUyMHNhbXBsZSUyMGVsc2UlMjBOb25lJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQW5zd2VyJTVDbiUyMiUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMiU1Q24lNUNuJTIyLmpvaW4oJTVCaSUyMGZvciUyMGklMjBpbiUyMCU1Qmluc3RydWN0aW9uJTJDJTIwY29udGV4dCUyQyUyMHJlc3BvbnNlJTVEJTIwaWYlMjBpJTIwaXMlMjBub3QlMjBOb25lJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByb21wdCUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlKHNhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjBmb3JtYXRfZG9sbHlfaW5mZXJlbmNlKHNhbXBsZSklMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuOSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcF9rJTNENTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b3BfcCUzRDAuOSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSU1Qmxlbihwcm9tcHQpJTNBJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly_inference</span>(<span class="hljs-params">sample</span>):
    instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>&quot;</span>
    context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;context&quot;</span> <span class="hljs-keyword">in</span> sample <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    response = <span class="hljs-string">f&quot;### Answer\\n&quot;</span>
    prompt = <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> [instruction, context, response] <span class="hljs-keyword">if</span> i <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>])
    <span class="hljs-keyword">return</span> prompt


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">sample</span>):
    prompt = format_dolly_inference(sample)
    inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    outputs = model.generate(
        **inputs,
        max_new_tokens=<span class="hljs-number">512</span>,
        do_sample=<span class="hljs-literal">True</span>,
        temperature=<span class="hljs-number">0.9</span>,
        top_k=<span class="hljs-number">50</span>,
        top_p=<span class="hljs-number">0.9</span>
    )
    <span class="hljs-keyword">return</span> tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-built_in">len</span>(prompt):]`,wrap:!1}}),Ne=new j({props:{code:"cHJvbXB0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJDYW4lMjB5b3UlMjB0ZWxsJTIwbWUlMjBzb21ldGhpbmclMjBhYm91dCUyMEFXUyUzRiUyMiUwQSU3RCUwQXJlcyUyMCUzRCUyMGdlbmVyYXRlKHByb21wdCklMEElMEFwcmludChyZXMp",highlighted:`prompt = {
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;Can you tell me something about AWS?&quot;</span>
}
res = generate(prompt)

<span class="hljs-built_in">print</span>(res)`,wrap:!1}}),Ee=new j({props:{code:"cHJvbXB0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJIb3clMjBjYW4lMjBJJTIwdHJhaW4lMjBtb2RlbHMlMjBvbiUyMEFXUyUyMFRyYWluaXVtJTNGJTIyJTJDJTBBJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMiVGMCU5RiVBNCU5NyUyME9wdGltdW0lMjBOZXVyb24lMjBpcyUyMHRoZSUyMGludGVyZmFjZSUyMGJldHdlZW4lMjB0aGUlMjAlRjAlOUYlQTQlOTclMjBUcmFuc2Zvcm1lcnMlMjBsaWJyYXJ5JTIwYW5kJTIwQVdTJTIwQWNjZWxlcmF0b3JzJTIwaW5jbHVkaW5nJTIwJTVCQVdTJTIwVHJhaW5pdW0lNUQoaHR0cHMlM0ElMkYlMkZhd3MuYW1hem9uLmNvbSUyRm1hY2hpbmUtbGVhcm5pbmclMkZ0cmFpbml1bSUyRiUzRm5jMSUzRGhfbHMpJTIwYW5kJTIwJTVCQVdTJTIwSW5mZXJlbnRpYSU1RChodHRwcyUzQSUyRiUyRmF3cy5hbWF6b24uY29tJTJGbWFjaGluZS1sZWFybmluZyUyRmluZmVyZW50aWElMkYlM0ZuYzElM0RoX2xzKS4lMjBJdCUyMHByb3ZpZGVzJTIwYSUyMHNldCUyMG9mJTIwdG9vbHMlMjBlbmFibGluZyUyMGVhc3klMjBtb2RlbCUyMGxvYWRpbmclMkMlMjB0cmFpbmluZyUyMGFuZCUyMGluZmVyZW5jZSUyMG9uJTIwc2luZ2xlLSUyMGFuZCUyMG11bHRpLUFjY2VsZXJhdG9yJTIwc2V0dGluZ3MlMjBmb3IlMjBkaWZmZXJlbnQlMjBkb3duc3RyZWFtJTIwdGFza3MuJTIyJTBBJTdEJTBBcmVzJTIwJTNEJTIwZ2VuZXJhdGUocHJvbXB0KSUwQSUwQXByaW50KHJlcyk=",highlighted:`prompt = {
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;How can I train models on AWS Trainium?&quot;</span>,
  <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;🤗 Optimum Neuron is the interface between the 🤗 Transformers library and AWS Accelerators including [AWS Trainium](https://aws.amazon.com/machine-learning/trainium/?nc1=h_ls) and [AWS Inferentia](https://aws.amazon.com/machine-learning/inferentia/?nc1=h_ls). It provides a set of tools enabling easy model loading, training and inference on single- and multi-Accelerator settings for different downstream tasks.&quot;</span>
}
res = generate(prompt)

<span class="hljs-built_in">print</span>(res)`,wrap:!1}}),{c(){r=i("meta"),f=a(),y=i("p"),w=a(),M(b.$$.fragment),T=a(),U=i("p"),U.textContent=qe,J=a(),C=i("p"),C.innerHTML=Cl,De=a(),v=i("p"),v.innerHTML=Il,Ke=a(),X=i("p"),X.textContent=gl,Oe=a(),x=i("ol"),x.innerHTML=Bl,et=a(),M(B.$$.fragment),tt=a(),M($.$$.fragment),lt=a(),R=i("p"),R.textContent=Wl,st=a(),V=i("ol"),V.innerHTML=kl,at=a(),M(A.$$.fragment),nt=a(),W=i("ol"),W.innerHTML=Gl,it=a(),H=i("ul"),H.innerHTML=Zl,ot=a(),k=i("ol"),k.innerHTML=_l,pt=a(),M(S.$$.fragment),rt=a(),M(Y.$$.fragment),Mt=a(),N=i("p"),N.innerHTML=vl,mt=a(),z=i("p"),z.textContent=Xl,ct=a(),M(Q.$$.fragment),ut=a(),E=i("p"),E.innerHTML=xl,dt=a(),M(F.$$.fragment),ht=a(),L=i("p"),L.innerHTML=$l,yt=a(),M(q.$$.fragment),wt=a(),P=i("p"),P.textContent=Rl,Tt=a(),D=i("p"),D.innerHTML=Vl,Ut=a(),M(K.$$.fragment),Jt=a(),O=i("p"),O.textContent=Al,jt=a(),ee=i("ol"),ee.innerHTML=Hl,ft=a(),M(te.$$.fragment),bt=a(),M(le.$$.fragment),Ct=a(),se=i("p"),se.innerHTML=Sl,It=a(),ae=i("p"),ae.innerHTML=Yl,gt=a(),ne=i("p"),ne.textContent=Nl,Bt=a(),ie=i("ol"),ie.innerHTML=zl,Wt=a(),M(G.$$.fragment),kt=a(),oe=i("p"),oe.textContent=Ql,Gt=a(),M(pe.$$.fragment),Zt=a(),re=i("p"),re.textContent=El,_t=a(),Me=i("ul"),Me.innerHTML=Fl,vt=a(),M(me.$$.fragment),Xt=a(),ce=i("p"),ce.innerHTML=Ll,xt=a(),M(Z.$$.fragment),$t=a(),ue=i("p"),ue.innerHTML=ql,Rt=a(),M(de.$$.fragment),Vt=a(),he=i("p"),he.textContent=Pl,At=a(),ye=i("p"),ye.innerHTML=Dl,Ht=a(),we=i("p"),we.innerHTML=Kl,St=a(),Te=i("p"),Te.innerHTML=Ol,Yt=a(),M(Ue.$$.fragment),Nt=a(),M(_.$$.fragment),zt=a(),Je=i("p"),Je.innerHTML=es,Qt=a(),M(je.$$.fragment),Et=a(),M(fe.$$.fragment),Ft=a(),be=i("p"),be.innerHTML=ts,Lt=a(),Ce=i("p"),Ce.innerHTML=ls,qt=a(),Ie=i("p"),Ie.innerHTML=ss,Pt=a(),ge=i("p"),ge.textContent=as,Dt=a(),M(Be.$$.fragment),Kt=a(),We=i("p"),We.textContent=ns,Ot=a(),ke=i("p"),ke.textContent=is,el=a(),M(Ge.$$.fragment),tl=a(),Ze=i("p"),Ze.innerHTML=os,ll=a(),M(_e.$$.fragment),sl=a(),M(ve.$$.fragment),al=a(),Xe=i("p"),Xe.textContent=ps,nl=a(),xe=i("p"),xe.innerHTML=rs,il=a(),M($e.$$.fragment),ol=a(),Re=i("p"),Re.innerHTML=Ms,pl=a(),M(Ve.$$.fragment),rl=a(),Ae=i("p"),Ae.innerHTML=ms,Ml=a(),M(He.$$.fragment),ml=a(),Se=i("p"),Se.textContent=cs,cl=a(),Ye=i("p"),Ye.innerHTML=us,ul=a(),M(Ne.$$.fragment),dl=a(),ze=i("blockquote"),ze.innerHTML=ds,hl=a(),Qe=i("p"),Qe.textContent=hs,yl=a(),M(Ee.$$.fragment),wl=a(),Fe=i("blockquote"),Fe.innerHTML=ys,Tl=a(),Le=i("p"),Le.textContent=ws,Ul=a(),Pe=i("p"),this.h()},l(e){const t=Bs("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(l),f=n(e),y=o(e,"P",{}),fs(y).forEach(l),w=n(e),m(b.$$.fragment,e),T=n(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-eibare"&&(U.textContent=qe),J=n(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1dtzs79"&&(C.innerHTML=Cl),De=n(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1w2bqvx"&&(v.innerHTML=Il),Ke=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1hahfn0"&&(X.textContent=gl),Oe=n(e),x=o(e,"OL",{"data-svelte-h":!0}),p(x)!=="svelte-1yf8yg7"&&(x.innerHTML=Bl),et=n(e),m(B.$$.fragment,e),tt=n(e),m($.$$.fragment,e),lt=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-w52dpm"&&(R.textContent=Wl),st=n(e),V=o(e,"OL",{"data-svelte-h":!0}),p(V)!=="svelte-15ega2l"&&(V.innerHTML=kl),at=n(e),m(A.$$.fragment,e),nt=n(e),W=o(e,"OL",{start:!0,"data-svelte-h":!0}),p(W)!=="svelte-ksb30n"&&(W.innerHTML=Gl),it=n(e),H=o(e,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-1qiwkz0"&&(H.innerHTML=Zl),ot=n(e),k=o(e,"OL",{start:!0,"data-svelte-h":!0}),p(k)!=="svelte-ch5yfe"&&(k.innerHTML=_l),pt=n(e),m(S.$$.fragment,e),rt=n(e),m(Y.$$.fragment,e),Mt=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-s6kf7j"&&(N.innerHTML=vl),mt=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-11lpom8"&&(z.textContent=Xl),ct=n(e),m(Q.$$.fragment,e),ut=n(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1snwaj0"&&(E.innerHTML=xl),dt=n(e),m(F.$$.fragment,e),ht=n(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-voh434"&&(L.innerHTML=$l),yt=n(e),m(q.$$.fragment,e),wt=n(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1qw7fs2"&&(P.textContent=Rl),Tt=n(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1tlab3t"&&(D.innerHTML=Vl),Ut=n(e),m(K.$$.fragment,e),Jt=n(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-vnokz2"&&(O.textContent=Al),jt=n(e),ee=o(e,"OL",{"data-svelte-h":!0}),p(ee)!=="svelte-v6jbub"&&(ee.innerHTML=Hl),ft=n(e),m(te.$$.fragment,e),bt=n(e),m(le.$$.fragment,e),Ct=n(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-14g3or9"&&(se.innerHTML=Sl),It=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-b4fdk9"&&(ae.innerHTML=Yl),gt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-lw48ct"&&(ne.textContent=Nl),Bt=n(e),ie=o(e,"OL",{"data-svelte-h":!0}),p(ie)!=="svelte-xm927i"&&(ie.innerHTML=zl),Wt=n(e),m(G.$$.fragment,e),kt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1lnowtd"&&(oe.textContent=Ql),Gt=n(e),m(pe.$$.fragment,e),Zt=n(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-t16ze3"&&(re.textContent=El),_t=n(e),Me=o(e,"UL",{"data-svelte-h":!0}),p(Me)!=="svelte-1ou6zrr"&&(Me.innerHTML=Fl),vt=n(e),m(me.$$.fragment,e),Xt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-618yad"&&(ce.innerHTML=Ll),xt=n(e),m(Z.$$.fragment,e),$t=n(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-bne5rp"&&(ue.innerHTML=ql),Rt=n(e),m(de.$$.fragment,e),Vt=n(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1u0hmu2"&&(he.textContent=Pl),At=n(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1gsk3gh"&&(ye.innerHTML=Dl),Ht=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-jypm7b"&&(we.innerHTML=Kl),St=n(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-t9z3bd"&&(Te.innerHTML=Ol),Yt=n(e),m(Ue.$$.fragment,e),Nt=n(e),m(_.$$.fragment,e),zt=n(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-136s4kc"&&(Je.innerHTML=es),Qt=n(e),m(je.$$.fragment,e),Et=n(e),m(fe.$$.fragment,e),Ft=n(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1yiqpri"&&(be.innerHTML=ts),Lt=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1anw499"&&(Ce.innerHTML=ls),qt=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-ctfnvw"&&(Ie.innerHTML=ss),Pt=n(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-17lv8z9"&&(ge.textContent=as),Dt=n(e),m(Be.$$.fragment,e),Kt=n(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1v2czzn"&&(We.textContent=ns),Ot=n(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-12iaeqv"&&(ke.textContent=is),el=n(e),m(Ge.$$.fragment,e),tl=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-66io75"&&(Ze.innerHTML=os),ll=n(e),m(_e.$$.fragment,e),sl=n(e),m(ve.$$.fragment,e),al=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-emhotm"&&(Xe.textContent=ps),nl=n(e),xe=o(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1pgrxrm"&&(xe.innerHTML=rs),il=n(e),m($e.$$.fragment,e),ol=n(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-1sinvz7"&&(Re.innerHTML=Ms),pl=n(e),m(Ve.$$.fragment,e),rl=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-jx2yqv"&&(Ae.innerHTML=ms),Ml=n(e),m(He.$$.fragment,e),ml=n(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1ytr5g6"&&(Se.textContent=cs),cl=n(e),Ye=o(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1j8w2o0"&&(Ye.innerHTML=us),ul=n(e),m(Ne.$$.fragment,e),dl=n(e),ze=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(ze)!=="svelte-6l4k0q"&&(ze.innerHTML=ds),hl=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-ovzcvi"&&(Qe.textContent=hs),yl=n(e),m(Ee.$$.fragment,e),wl=n(e),Fe=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(Fe)!=="svelte-15xrtpx"&&(Fe.innerHTML=ys),Tl=n(e),Le=o(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-q9f4rf"&&(Le.textContent=ws),Ul=n(e),Pe=o(e,"P",{}),fs(Pe).forEach(l),this.h()},h(){jl(r,"name","hf:doc:metadata"),jl(r,"content",Xs),jl(W,"start","3"),jl(k,"start","4")},m(e,t){Ws(document.head,r),s(e,f,t),s(e,y,t),s(e,w,t),c(b,e,t),s(e,T,t),s(e,U,t),s(e,J,t),s(e,C,t),s(e,De,t),s(e,v,t),s(e,Ke,t),s(e,X,t),s(e,Oe,t),s(e,x,t),s(e,et,t),c(B,e,t),s(e,tt,t),c($,e,t),s(e,lt,t),s(e,R,t),s(e,st,t),s(e,V,t),s(e,at,t),c(A,e,t),s(e,nt,t),s(e,W,t),s(e,it,t),s(e,H,t),s(e,ot,t),s(e,k,t),s(e,pt,t),c(S,e,t),s(e,rt,t),c(Y,e,t),s(e,Mt,t),s(e,N,t),s(e,mt,t),s(e,z,t),s(e,ct,t),c(Q,e,t),s(e,ut,t),s(e,E,t),s(e,dt,t),c(F,e,t),s(e,ht,t),s(e,L,t),s(e,yt,t),c(q,e,t),s(e,wt,t),s(e,P,t),s(e,Tt,t),s(e,D,t),s(e,Ut,t),c(K,e,t),s(e,Jt,t),s(e,O,t),s(e,jt,t),s(e,ee,t),s(e,ft,t),c(te,e,t),s(e,bt,t),c(le,e,t),s(e,Ct,t),s(e,se,t),s(e,It,t),s(e,ae,t),s(e,gt,t),s(e,ne,t),s(e,Bt,t),s(e,ie,t),s(e,Wt,t),c(G,e,t),s(e,kt,t),s(e,oe,t),s(e,Gt,t),c(pe,e,t),s(e,Zt,t),s(e,re,t),s(e,_t,t),s(e,Me,t),s(e,vt,t),c(me,e,t),s(e,Xt,t),s(e,ce,t),s(e,xt,t),c(Z,e,t),s(e,$t,t),s(e,ue,t),s(e,Rt,t),c(de,e,t),s(e,Vt,t),s(e,he,t),s(e,At,t),s(e,ye,t),s(e,Ht,t),s(e,we,t),s(e,St,t),s(e,Te,t),s(e,Yt,t),c(Ue,e,t),s(e,Nt,t),c(_,e,t),s(e,zt,t),s(e,Je,t),s(e,Qt,t),c(je,e,t),s(e,Et,t),c(fe,e,t),s(e,Ft,t),s(e,be,t),s(e,Lt,t),s(e,Ce,t),s(e,qt,t),s(e,Ie,t),s(e,Pt,t),s(e,ge,t),s(e,Dt,t),c(Be,e,t),s(e,Kt,t),s(e,We,t),s(e,Ot,t),s(e,ke,t),s(e,el,t),c(Ge,e,t),s(e,tl,t),s(e,Ze,t),s(e,ll,t),c(_e,e,t),s(e,sl,t),c(ve,e,t),s(e,al,t),s(e,Xe,t),s(e,nl,t),s(e,xe,t),s(e,il,t),c($e,e,t),s(e,ol,t),s(e,Re,t),s(e,pl,t),c(Ve,e,t),s(e,rl,t),s(e,Ae,t),s(e,Ml,t),c(He,e,t),s(e,ml,t),s(e,Se,t),s(e,cl,t),s(e,Ye,t),s(e,ul,t),c(Ne,e,t),s(e,dl,t),s(e,ze,t),s(e,hl,t),s(e,Qe,t),s(e,yl,t),c(Ee,e,t),s(e,wl,t),s(e,Fe,t),s(e,Tl,t),s(e,Le,t),s(e,Ul,t),s(e,Pe,t),Jl=!0},p(e,[t]){const Ts={};t&2&&(Ts.$$scope={dirty:t,ctx:e}),B.$set(Ts);const Us={};t&2&&(Us.$$scope={dirty:t,ctx:e}),G.$set(Us);const Js={};t&2&&(Js.$$scope={dirty:t,ctx:e}),Z.$set(Js);const js={};t&2&&(js.$$scope={dirty:t,ctx:e}),_.$set(js)},i(e){Jl||(u(b.$$.fragment,e),u(B.$$.fragment,e),u($.$$.fragment,e),u(A.$$.fragment,e),u(S.$$.fragment,e),u(Y.$$.fragment,e),u(Q.$$.fragment,e),u(F.$$.fragment,e),u(q.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(G.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(Z.$$.fragment,e),u(de.$$.fragment,e),u(Ue.$$.fragment,e),u(_.$$.fragment,e),u(je.$$.fragment,e),u(fe.$$.fragment,e),u(Be.$$.fragment,e),u(Ge.$$.fragment,e),u(_e.$$.fragment,e),u(ve.$$.fragment,e),u($e.$$.fragment,e),u(Ve.$$.fragment,e),u(He.$$.fragment,e),u(Ne.$$.fragment,e),u(Ee.$$.fragment,e),Jl=!0)},o(e){d(b.$$.fragment,e),d(B.$$.fragment,e),d($.$$.fragment,e),d(A.$$.fragment,e),d(S.$$.fragment,e),d(Y.$$.fragment,e),d(Q.$$.fragment,e),d(F.$$.fragment,e),d(q.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),d(G.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),d(Z.$$.fragment,e),d(de.$$.fragment,e),d(Ue.$$.fragment,e),d(_.$$.fragment,e),d(je.$$.fragment,e),d(fe.$$.fragment,e),d(Be.$$.fragment,e),d(Ge.$$.fragment,e),d(_e.$$.fragment,e),d(ve.$$.fragment,e),d($e.$$.fragment,e),d(Ve.$$.fragment,e),d(He.$$.fragment,e),d(Ne.$$.fragment,e),d(Ee.$$.fragment,e),Jl=!1},d(e){e&&(l(f),l(y),l(w),l(T),l(U),l(J),l(C),l(De),l(v),l(Ke),l(X),l(Oe),l(x),l(et),l(tt),l(lt),l(R),l(st),l(V),l(at),l(nt),l(W),l(it),l(H),l(ot),l(k),l(pt),l(rt),l(Mt),l(N),l(mt),l(z),l(ct),l(ut),l(E),l(dt),l(ht),l(L),l(yt),l(wt),l(P),l(Tt),l(D),l(Ut),l(Jt),l(O),l(jt),l(ee),l(ft),l(bt),l(Ct),l(se),l(It),l(ae),l(gt),l(ne),l(Bt),l(ie),l(Wt),l(kt),l(oe),l(Gt),l(Zt),l(re),l(_t),l(Me),l(vt),l(Xt),l(ce),l(xt),l($t),l(ue),l(Rt),l(Vt),l(he),l(At),l(ye),l(Ht),l(we),l(St),l(Te),l(Yt),l(Nt),l(zt),l(Je),l(Qt),l(Et),l(Ft),l(be),l(Lt),l(Ce),l(qt),l(Ie),l(Pt),l(ge),l(Dt),l(Kt),l(We),l(Ot),l(ke),l(el),l(tl),l(Ze),l(ll),l(sl),l(al),l(Xe),l(nl),l(xe),l(il),l(ol),l(Re),l(pl),l(rl),l(Ae),l(Ml),l(ml),l(Se),l(cl),l(Ye),l(ul),l(dl),l(ze),l(hl),l(Qe),l(yl),l(wl),l(Fe),l(Tl),l(Le),l(Ul),l(Pe)),l(r),h(b,e),h(B,e),h($,e),h(A,e),h(S,e),h(Y,e),h(Q,e),h(F,e),h(q,e),h(K,e),h(te,e),h(le,e),h(G,e),h(pe,e),h(me,e),h(Z,e),h(de,e),h(Ue,e),h(_,e),h(je,e),h(fe,e),h(Be,e),h(Ge,e),h(_e,e),h(ve,e),h($e,e),h(Ve,e),h(He,e),h(Ne,e),h(Ee,e)}}}const Xs='{"title":"Fine-tune and Test Llama-3 8B on AWS Trainium","local":"fine-tune-and-test-llama-3-8b-on-aws-trainium","sections":[{"title":"1. Setup AWS Environment","local":"1-setup-aws-environment","sections":[],"depth":2},{"title":"2. Load and prepare the dataset","local":"2-load-and-prepare-the-dataset","sections":[],"depth":2},{"title":"3. Fine-tune Llama on AWS Trainium using the NeuronTrainer","local":"3-fine-tune-llama-on-aws-trainium-using-the-neurontrainer","sections":[],"depth":2},{"title":"4. Launch Training","local":"4-launch-training","sections":[{"title":"Precompilation","local":"precompilation","sections":[],"depth":3},{"title":"Actual Training","local":"actual-training","sections":[],"depth":3},{"title":"Consolidate the Checkpoint","local":"consolidate-the-checkpoint","sections":[],"depth":3}],"depth":2},{"title":"5. Evaluate and test fine-tuned Llama model","local":"5-evaluate-and-test-fine-tuned-llama-model","sections":[],"depth":2}],"depth":1}';function xs(I){return Cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ss extends Is{constructor(r){super(),gs(this,r,xs,vs,bs,{})}}export{Ss as component};
