import{s as ht,o as Jt,n as X}from"../chunks/scheduler.8c3d61f6.js";import{S as bt,i as wt,g,s as f,r as U,A as Zt,h as T,f as l,c as M,j as yt,u as j,x as B,k,y as gt,a as s,v as W,d as G,t as v,w as V}from"../chunks/index.da70eac4.js";import{T as Pe}from"../chunks/Tip.1d9b8c37.js";import{C as _}from"../chunks/CodeBlock.00a903b3.js";import{H as x,E as Tt}from"../chunks/EditOnGithub.1e64e623.js";import{H as Le,a as C}from"../chunks/HfOption.c1483eb1.js";function Ut($){let t,J='<a href="https://huggingface.co/collections/THUDM/cogvideo-66c08e62f1685a3ade464cce" rel="nofollow">CogVideoX</a> uses a 3D causal Variational Autoencoder (VAE) to compress videos along the spatial and temporal dimensions, and it includes a stack of expert transformer blocks with a 3D full attention mechanism to better capture visual, semantic, and motion information in the data.',n,r,c='The CogVideoX family also includes models capable of generating videos from images and videos in addition to text. The image-to-video models are indicated by <strong>I2V</strong> in the checkpoint name, and they should be used with the <a href="/docs/diffusers/pr_10037/en/api/pipelines/cogvideox#diffusers.CogVideoXImageToVideoPipeline">CogVideoXImageToVideoPipeline</a>. The regular checkpoints support video-to-video through the <a href="/docs/diffusers/pr_10037/en/api/pipelines/cogvideox#diffusers.CogVideoXVideoToVideoPipeline">CogVideoXVideoToVideoPipeline</a>.',o,m,y='The example below demonstrates how to generate a video from an image and text prompt with <a href="https://huggingface.co/THUDM/CogVideoX-5b-I2V" rel="nofollow">THUDM/CogVideoX-5b-I2V</a>.',p,b,i,h,d='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cogvideox/cogvideox_rocket.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cogvideox/cogvideox_outrocket.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated video</figcaption></div>',w;return b=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQ29nVmlkZW9YSW1hZ2VUb1ZpZGVvUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjB2YXN0JTJDJTIwc2hpbW1lcmluZyUyMG9jZWFuJTIwZmxvd3MlMjBncmFjZWZ1bGx5JTIwdW5kZXIlMjBhJTIwdHdpbGlnaHQlMjBza3klMkMlMjBpdHMlMjB3YXZlcyUyMHVuZHVsYXRpbmclMjBpbiUyMGElMjBtZXNtZXJpemluZyUyMGRhbmNlJTIwb2YlMjBibHVlcyUyMGFuZCUyMGdyZWVucy4lMjBUaGUlMjBzdXJmYWNlJTIwZ2xpbnRzJTIwd2l0aCUyMHRoZSUyMGxhc3QlMjByYXlzJTIwb2YlMjB0aGUlMjBzZXR0aW5nJTIwc3VuJTJDJTIwY2FzdGluZyUyMGdvbGRlbiUyMGhpZ2hsaWdodHMlMjB0aGF0JTIwcmlwcGxlJTIwYWNyb3NzJTIwdGhlJTIwd2F0ZXIuJTIwU2VhZ3VsbHMlMjBzb2FyJTIwYWJvdmUlMkMlMjB0aGVpciUyMGNyaWVzJTIwYmxlbmRpbmclMjB3aXRoJTIwdGhlJTIwZ2VudGxlJTIwcm9hciUyMG9mJTIwdGhlJTIwd2F2ZXMuJTIwVGhlJTIwaG9yaXpvbiUyMHN0cmV0Y2hlcyUyMGluZmluaXRlbHklMkMlMjB3aGVyZSUyMHRoZSUyMG9jZWFuJTIwbWVldHMlMjB0aGUlMjBza3klMjBpbiUyMGElMjBzZWFtbGVzcyUyMGJsZW5kJTIwb2YlMjBodWVzLiUyMENsb3NlLXVwcyUyMHJldmVhbCUyMHRoZSUyMGludHJpY2F0ZSUyMHBhdHRlcm5zJTIwb2YlMjB0aGUlMjB3YXZlcyUyQyUyMGNhcHR1cmluZyUyMHRoZSUyMGZsdWlkaXR5JTIwYW5kJTIwZHluYW1pYyUyMGJlYXV0eSUyMG9mJTIwdGhlJTIwc2VhJTIwaW4lMjBtb3Rpb24uJTIyJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltYWdlJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGY29ndmlkZW94JTJGY29ndmlkZW94X3JvY2tldC5wbmclMjIpJTBBcGlwZSUyMCUzRCUyMENvZ1ZpZGVvWEltYWdlVG9WaWRlb1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJUSFVETSUyRkNvZ1ZpZGVvWC01Yi1JMlYlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQSUyMyUyMHJlZHVjZSUyMG1lbW9yeSUyMHJlcXVpcmVtZW50cyUyMCUwQXBpcGUudmFlLmVuYWJsZV90aWxpbmcoKSUwQXBpcGUudmFlLmVuYWJsZV9zbGljaW5nKCklMEElMEF2aWRlbyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV92aWRlb3NfcGVyX3Byb21wdCUzRDElMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNENDklMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoNDIpJTJDJTBBKS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDgp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> CogVideoXImageToVideoPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_image

prompt = <span class="hljs-string">&quot;A vast, shimmering ocean flows gracefully under a twilight sky, its waves undulating in a mesmerizing dance of blues and greens. The surface glints with the last rays of the setting sun, casting golden highlights that ripple across the water. Seagulls soar above, their cries blending with the gentle roar of the waves. The horizon stretches infinitely, where the ocean meets the sky in a seamless blend of hues. Close-ups reveal the intricate patterns of the waves, capturing the fluidity and dynamic beauty of the sea in motion.&quot;</span>
image = load_image(image=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cogvideox/cogvideox_rocket.png&quot;</span>)
pipe = CogVideoXImageToVideoPipeline.from_pretrained(
    <span class="hljs-string">&quot;THUDM/CogVideoX-5b-I2V&quot;</span>,
    torch_dtype=torch.bfloat16
)

<span class="hljs-comment"># reduce memory requirements </span>
pipe.vae.enable_tiling()
pipe.vae.enable_slicing()

video = pipe(
    prompt=prompt,
    image=image,
    num_videos_per_prompt=<span class="hljs-number">1</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    num_frames=<span class="hljs-number">49</span>,
    guidance_scale=<span class="hljs-number">6</span>,
    generator=torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),{c(){t=g("p"),t.innerHTML=J,n=f(),r=g("p"),r.innerHTML=c,o=f(),m=g("p"),m.innerHTML=y,p=f(),U(b.$$.fragment),i=f(),h=g("div"),h.innerHTML=d,this.h()},l(Z){t=T(Z,"P",{"data-svelte-h":!0}),B(t)!=="svelte-1c0gfm"&&(t.innerHTML=J),n=M(Z),r=T(Z,"P",{"data-svelte-h":!0}),B(r)!=="svelte-12n343e"&&(r.innerHTML=c),o=M(Z),m=T(Z,"P",{"data-svelte-h":!0}),B(m)!=="svelte-1799g9w"&&(m.innerHTML=y),p=M(Z),j(b.$$.fragment,Z),i=M(Z),h=T(Z,"DIV",{class:!0,"data-svelte-h":!0}),B(h)!=="svelte-1u9aiw3"&&(h.innerHTML=d),this.h()},h(){k(h,"class","flex gap-4")},m(Z,a){s(Z,t,a),s(Z,n,a),s(Z,r,a),s(Z,o,a),s(Z,m,a),s(Z,p,a),W(b,Z,a),s(Z,i,a),s(Z,h,a),w=!0},p:X,i(Z){w||(G(b.$$.fragment,Z),w=!0)},o(Z){v(b.$$.fragment,Z),w=!1},d(Z){Z&&(l(t),l(n),l(r),l(o),l(m),l(p),l(i),l(h)),V(b,Z)}}}function jt($){let t,J='HunyuanVideo is a 13B parameter model and requires a lot of memory. Refer to the HunyuanVideo <a href="../api/pipelines/hunyuan_video#quantization">Quantization</a> guide to learn how to quantize the model. CogVideoX and LTX-Video are more lightweight options that can still generate high-quality videos.';return{c(){t=g("p"),t.innerHTML=J},l(n){t=T(n,"P",{"data-svelte-h":!0}),B(t)!=="svelte-1iy1ekz"&&(t.innerHTML=J)},m(n,r){s(n,t,r)},p:X,d(n){n&&l(t)}}}function Wt($){let t,J,n,r='<a href="https://huggingface.co/tencent/HunyuanVideo" rel="nofollow">HunyuanVideo</a> features a dual-stream to single-stream diffusion transformer (DiT) for learning video and text tokens separately, and then subsequently concatenating the video and text tokens to combine their information. A single multimodal large language model (MLLM) serves as the text encoder, and videos are also spatio-temporally compressed with a 3D causal VAE.',c,o,m,y,p='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hunyuan-video-output.gif"/>',b;return t=new Pe({props:{warning:!1,$$slots:{default:[jt]},$$scope:{ctx:$}}}),o=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwSHVueXVhblZpZGVvUGlwZWxpbmUlMkMlMjBIdW55dWFuVmlkZW9UcmFuc2Zvcm1lcjNETW9kZWwlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBIdW55dWFuVmlkZW9UcmFuc2Zvcm1lcjNETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnRlbmNlbnQlMkZIdW55dWFuVmlkZW8lMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBcGlwZSUyMCUzRCUyMEh1bnl1YW5WaWRlb1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJ0ZW5jZW50JTJGSHVueXVhblZpZGVvJTIyJTJDJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lciUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEElMEElMjMlMjByZWR1Y2UlMjBtZW1vcnklMjByZXF1aXJlbWVudHMlMEFwaXBlLnZhZS5lbmFibGVfdGlsaW5nKCklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBdmlkZW8lMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkElMjBjYXQlMjB3YWxrcyUyMG9uJTIwdGhlJTIwZ3Jhc3MlMkMlMjByZWFsaXN0aWMlMjIlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QzMjAlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9mcmFtZXMlM0Q2MSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUwQSkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyh2aWRlbyUyQyUyMCUyMm91dHB1dC5tcDQlMjIlMkMlMjBmcHMlM0QxNSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> HunyuanVideoPipeline, HunyuanVideoTransformer3DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

transformer = HunyuanVideoTransformer3DModel.from_pretrained(
    <span class="hljs-string">&quot;tencent/HunyuanVideo&quot;</span>, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>, torch_dtype=torch.bfloat16
)
pipe = HunyuanVideoPipeline.from_pretrained(
  <span class="hljs-string">&quot;tencent/HunyuanVideo&quot;</span>, transformer=transformer, torch_dtype=torch.float16
)

<span class="hljs-comment"># reduce memory requirements</span>
pipe.vae.enable_tiling()
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

video = pipe(
    prompt=<span class="hljs-string">&quot;A cat walks on the grass, realistic&quot;</span>,
    height=<span class="hljs-number">320</span>,
    width=<span class="hljs-number">512</span>,
    num_frames=<span class="hljs-number">61</span>,
    num_inference_steps=<span class="hljs-number">30</span>,
).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">15</span>)`,wrap:!1}}),{c(){U(t.$$.fragment),J=f(),n=g("p"),n.innerHTML=r,c=f(),U(o.$$.fragment),m=f(),y=g("div"),y.innerHTML=p,this.h()},l(i){j(t.$$.fragment,i),J=M(i),n=T(i,"P",{"data-svelte-h":!0}),B(n)!=="svelte-1modyi0"&&(n.innerHTML=r),c=M(i),j(o.$$.fragment,i),m=M(i),y=T(i,"DIV",{class:!0,"data-svelte-h":!0}),B(y)!=="svelte-1qhd7s8"&&(y.innerHTML=p),this.h()},h(){k(y,"class","flex justify-center")},m(i,h){W(t,i,h),s(i,J,h),s(i,n,h),s(i,c,h),W(o,i,h),s(i,m,h),s(i,y,h),b=!0},p(i,h){const d={};h&2&&(d.$$scope={dirty:h,ctx:i}),t.$set(d)},i(i){b||(G(t.$$.fragment,i),G(o.$$.fragment,i),b=!0)},o(i){v(t.$$.fragment,i),v(o.$$.fragment,i),b=!1},d(i){i&&(l(J),l(n),l(c),l(m),l(y)),V(t,i),V(o,i)}}}function Gt($){let t,J='<a href="https://huggingface.co/Lightricks/LTX-Video" rel="nofollow">LTX-Video (LTXV)</a> is a diffusion transformer (DiT) with a focus on speed. It generates 768x512 resolution videos at 24 frames per second (fps), enabling near real-time generation of high-quality videos. LTXV is relatively lightweight compared to other modern video generation models, making it possible to run on consumer GPUs.',n,r,c,o,m='<img src="https://huggingface.co/Lightricks/LTX-Video/resolve/main/media/ltx-video_example_00014.gif"/>',y;return r=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTFRYUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMExUWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJMaWdodHJpY2tzJTJGTFRYLVZpZGVvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwbWFuJTIwd2Fsa3MlMjB0b3dhcmRzJTIwYSUyMHdpbmRvdyUyQyUyMGxvb2tzJTIwb3V0JTJDJTIwYW5kJTIwdGhlbiUyMHR1cm5zJTIwYXJvdW5kLiUyMEhlJTIwaGFzJTIwc2hvcnQlMkMlMjBkYXJrJTIwaGFpciUyQyUyMGRhcmslMjBza2luJTJDJTIwYW5kJTIwaXMlMjB3ZWFyaW5nJTIwYSUyMGJyb3duJTIwY29hdCUyMG92ZXIlMjBhJTIwcmVkJTIwYW5kJTIwZ3JheSUyMHNjYXJmLiUyMEhlJTIwd2Fsa3MlMjBmcm9tJTIwbGVmdCUyMHRvJTIwcmlnaHQlMjB0b3dhcmRzJTIwYSUyMHdpbmRvdyUyQyUyMGhpcyUyMGdhemUlMjBmaXhlZCUyMG9uJTIwc29tZXRoaW5nJTIwb3V0c2lkZS4lMjBUaGUlMjBjYW1lcmElMjBmb2xsb3dzJTIwaGltJTIwZnJvbSUyMGJlaGluZCUyMGF0JTIwYSUyMG1lZGl1bSUyMGRpc3RhbmNlLiUyMFRoZSUyMHJvb20lMjBpcyUyMGJyaWdodGx5JTIwbGl0JTJDJTIwd2l0aCUyMHdoaXRlJTIwd2FsbHMlMjBhbmQlMjBhJTIwbGFyZ2UlMjB3aW5kb3clMjBjb3ZlcmVkJTIwYnklMjBhJTIwd2hpdGUlMjBjdXJ0YWluLiUyMEFzJTIwaGUlMjBhcHByb2FjaGVzJTIwdGhlJTIwd2luZG93JTJDJTIwaGUlMjB0dXJucyUyMGhpcyUyMGhlYWQlMjBzbGlnaHRseSUyMHRvJTIwdGhlJTIwbGVmdCUyQyUyMHRoZW4lMjBiYWNrJTIwdG8lMjB0aGUlMjByaWdodC4lMjBIZSUyMHRoZW4lMjB0dXJucyUyMGhpcyUyMGVudGlyZSUyMGJvZHklMjB0byUyMHRoZSUyMHJpZ2h0JTJDJTIwZmFjaW5nJTIwdGhlJTIwd2luZG93LiUyMFRoZSUyMGNhbWVyYSUyMHJlbWFpbnMlMjBzdGF0aW9uYXJ5JTIwYXMlMjBoZSUyMHN0YW5kcyUyMGluJTIwZnJvbnQlMjBvZiUyMHRoZSUyMHdpbmRvdy4lMjBUaGUlMjBzY2VuZSUyMGlzJTIwY2FwdHVyZWQlMjBpbiUyMHJlYWwtbGlmZSUyMGZvb3RhZ2UuJTIyJTBBdmlkZW8lMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENzA0JTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENDgwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDE2MSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyh2aWRlbyUyQyUyMCUyMm91dHB1dC5tcDQlMjIlMkMlMjBmcHMlM0QyNCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = LTXPipeline.from_pretrained(<span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>, torch_dtype=torch.bfloat16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A man walks towards a window, looks out, and then turns around. He has short, dark hair, dark skin, and is wearing a brown coat over a red and gray scarf. He walks from left to right towards a window, his gaze fixed on something outside. The camera follows him from behind at a medium distance. The room is brightly lit, with white walls and a large window covered by a white curtain. As he approaches the window, he turns his head slightly to the left, then back to the right. He then turns his entire body to the right, facing the window. The camera remains stationary as he stands in front of the window. The scene is captured in real-life footage.&quot;</span>
video = pipe(
    prompt=prompt,
    width=<span class="hljs-number">704</span>,
    height=<span class="hljs-number">480</span>,
    num_frames=<span class="hljs-number">161</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),{c(){t=g("p"),t.innerHTML=J,n=f(),U(r.$$.fragment),c=f(),o=g("div"),o.innerHTML=m,this.h()},l(p){t=T(p,"P",{"data-svelte-h":!0}),B(t)!=="svelte-1uuybz8"&&(t.innerHTML=J),n=M(p),j(r.$$.fragment,p),c=M(p),o=T(p,"DIV",{class:!0,"data-svelte-h":!0}),B(o)!=="svelte-a92mtr"&&(o.innerHTML=m),this.h()},h(){k(o,"class","flex justify-center")},m(p,b){s(p,t,b),s(p,n,b),W(r,p,b),s(p,c,b),s(p,o,b),y=!0},p:X,i(p){y||(G(r.$$.fragment,p),y=!0)},o(p){v(r.$$.fragment,p),y=!1},d(p){p&&(l(t),l(n),l(c),l(o)),V(r,p)}}}function vt($){let t,J='Mochi-1 is a 10B parameter model and requires a lot of memory. Refer to the Mochi <a href="../api/pipelines/mochi#quantization">Quantization</a> guide to learn how to quantize the model. CogVideoX and LTX-Video are more lightweight options that can still generate high-quality videos.';return{c(){t=g("p"),t.innerHTML=J},l(n){t=T(n,"P",{"data-svelte-h":!0}),B(t)!=="svelte-13cowuc"&&(t.innerHTML=J)},m(n,r){s(n,t,r)},p:X,d(n){n&&l(t)}}}function Vt($){let t,J,n,r='<a href="https://huggingface.co/genmo/mochi-1-preview" rel="nofollow">Mochi-1</a> introduces the Asymmetric Diffusion Transformer (AsymmDiT) and Asymmetric Variational Autoencoder (AsymmVAE) to reduces memory requirements. AsymmVAE causally compresses videos 128x to improve memory efficiency, and AsymmDiT jointly attends to the compressed video tokens and user text tokens. This model is noted for generating videos with high-quality motion dynamics and strong prompt adherence.',c,o,m,y,p='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/mochi-video-output.gif"/>',b;return t=new Pe({props:{warning:!1,$$slots:{default:[vt]},$$scope:{ctx:$}}}),o=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW9jaGlQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMEElMEFwaXBlJTIwJTNEJTIwTW9jaGlQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZ2VubW8lMkZtb2NoaS0xLXByZXZpZXclMjIlMkMlMjB2YXJpYW50JTNEJTIyYmYxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBJTBBJTIzJTIwcmVkdWNlJTIwbWVtb3J5JTIwcmVxdWlyZW1lbnRzJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQXBpcGUuZW5hYmxlX3ZhZV90aWxpbmcoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkNsb3NlLXVwJTIwb2YlMjBhJTIwY2hhbWVsZW9uJ3MlMjBleWUlMkMlMjB3aXRoJTIwaXRzJTIwc2NhbHklMjBza2luJTIwY2hhbmdpbmclMjBjb2xvci4lMjBVbHRyYSUyMGhpZ2glMjByZXNvbHV0aW9uJTIwNGsuJTIyJTBBdmlkZW8lMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9mcmFtZXMlM0Q4NCkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyh2aWRlbyUyQyUyMCUyMm91dHB1dC5tcDQlMjIlMkMlMjBmcHMlM0QzMCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MochiPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = MochiPipeline.from_pretrained(<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>, variant=<span class="hljs-string">&quot;bf16&quot;</span>, torch_dtype=torch.bfloat16)

<span class="hljs-comment"># reduce memory requirements</span>
pipe.enable_model_cpu_offload()
pipe.enable_vae_tiling()

prompt = <span class="hljs-string">&quot;Close-up of a chameleon&#x27;s eye, with its scaly skin changing color. Ultra high resolution 4k.&quot;</span>
video = pipe(prompt, num_frames=<span class="hljs-number">84</span>).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">30</span>)`,wrap:!1}}),{c(){U(t.$$.fragment),J=f(),n=g("p"),n.innerHTML=r,c=f(),U(o.$$.fragment),m=f(),y=g("div"),y.innerHTML=p,this.h()},l(i){j(t.$$.fragment,i),J=M(i),n=T(i,"P",{"data-svelte-h":!0}),B(n)!=="svelte-5yrrbo"&&(n.innerHTML=r),c=M(i),j(o.$$.fragment,i),m=M(i),y=T(i,"DIV",{class:!0,"data-svelte-h":!0}),B(y)!=="svelte-nkq0ps"&&(y.innerHTML=p),this.h()},h(){k(y,"class","flex justify-center")},m(i,h){W(t,i,h),s(i,J,h),s(i,n,h),s(i,c,h),W(o,i,h),s(i,m,h),s(i,y,h),b=!0},p(i,h){const d={};h&2&&(d.$$scope={dirty:h,ctx:i}),t.$set(d)},i(i){b||(G(t.$$.fragment,i),G(o.$$.fragment,i),b=!0)},o(i){v(t.$$.fragment,i),v(o.$$.fragment,i),b=!1},d(i){i&&(l(J),l(n),l(c),l(m),l(y)),V(t,i),V(o,i)}}}function Bt($){let t,J='<a href="https://huggingface.co/stabilityai/stable-video-diffusion-img2vid-xt" rel="nofollow">StableVideoDiffusion (SVD)</a> is based on the Stable Diffusion 2.1 model and it is trained on images, then low-resolution videos, and finally a smaller dataset of high-resolution videos. This model generates a short 2-4 second video from an initial image.',n,r,c,o,m='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/output_rocket.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated video</figcaption></div>',y;return r=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVmlkZW9EaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVWaWRlb0RpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS12aWRlby1kaWZmdXNpb24taW1nMnZpZC14dCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKSUwQSUwQSUyMyUyMHJlZHVjZSUyMG1lbW9yeSUyMHJlcXVpcmVtZW50cyUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnN2ZCUyRnJvY2tldC5wbmclMjIpJTBBaW1hZ2UlMjAlM0QlMjBpbWFnZS5yZXNpemUoKDEwMjQlMkMlMjA1NzYpKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKDQyKSUwQWZyYW1lcyUyMCUzRCUyMHBpcGVsaW5lKGltYWdlJTJDJTIwZGVjb2RlX2NodW5rX3NpemUlM0Q4JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKGZyYW1lcyUyQyUyMCUyMmdlbmVyYXRlZC5tcDQlMjIlMkMlMjBmcHMlM0Q3KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableVideoDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, export_to_video

pipeline = StableVideoDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-video-diffusion-img2vid-xt&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)

<span class="hljs-comment"># reduce memory requirements</span>
pipeline.enable_model_cpu_offload()

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png&quot;</span>)
image = image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>))

generator = torch.manual_seed(<span class="hljs-number">42</span>)
frames = pipeline(image, decode_chunk_size=<span class="hljs-number">8</span>, generator=generator).frames[<span class="hljs-number">0</span>]
export_to_video(frames, <span class="hljs-string">&quot;generated.mp4&quot;</span>, fps=<span class="hljs-number">7</span>)`,wrap:!1}}),{c(){t=g("p"),t.innerHTML=J,n=f(),U(r.$$.fragment),c=f(),o=g("div"),o.innerHTML=m,this.h()},l(p){t=T(p,"P",{"data-svelte-h":!0}),B(t)!=="svelte-ay6xw9"&&(t.innerHTML=J),n=M(p),j(r.$$.fragment,p),c=M(p),o=T(p,"DIV",{class:!0,"data-svelte-h":!0}),B(o)!=="svelte-1oxa21d"&&(o.innerHTML=m),this.h()},h(){k(o,"class","flex gap-4")},m(p,b){s(p,t,b),s(p,n,b),W(r,p,b),s(p,c,b),s(p,o,b),y=!0},p:X,i(p){y||(G(r.$$.fragment,p),y=!0)},o(p){v(r.$$.fragment,p),y=!1},d(p){p&&(l(t),l(n),l(c),l(o)),V(r,p)}}}function It($){let t,J='<a href="https://huggingface.co/guoyww/animatediff" rel="nofollow">AnimateDiff</a> is an adapter model that inserts a motion module into a pretrained diffusion model to animate an image. The adapter is trained on video clips to learn motion which is used to condition the generation process to create a video. It is faster and easier to only train the adapter and it can be loaded into most diffusion models, effectively turning them into “video models”.',n,r,c='Load a <code>MotionAdapter</code> and pass it to the <a href="/docs/diffusers/pr_10037/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a>.',o,m,y,p,b='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff.gif"/>',i;return m=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQW5pbWF0ZURpZmZQaXBlbGluZSUyQyUyMERESU1TY2hlZHVsZXIlMkMlMjBNb3Rpb25BZGFwdGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEElMEFhZGFwdGVyJTIwJTNEJTIwTW90aW9uQWRhcHRlci5mcm9tX3ByZXRyYWluZWQoJTIyZ3VveXd3JTJGYW5pbWF0ZWRpZmYtbW90aW9uLWFkYXB0ZXItdjEtNS0yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lJTIwJTNEJTIwQW5pbWF0ZURpZmZQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZW1pbGlhbkpSJTJGZXBpQ1JlYWxpc20lMjIlMkMlMjBtb3Rpb25fYWRhcHRlciUzRGFkYXB0ZXIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZW1pbGlhbkpSJTJGZXBpQ1JlYWxpc20lMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBjbGlwX3NhbXBsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwdGltZXN0ZXBfc3BhY2luZyUzRCUyMmxpbnNwYWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwYmV0YV9zY2hlZHVsZSUzRCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMHN0ZXBzX29mZnNldCUzRDElMkMlMEEpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwc2NoZWR1bGVyJTBBJTBBJTIzJTIwcmVkdWNlJTIwbWVtb3J5JTIwcmVxdWlyZW1lbnRzJTBBcGlwZWxpbmUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQW91dHB1dCUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkElMjBzcGFjZSUyMHJvY2tldCUyMHdpdGglMjB0cmFpbHMlMjBvZiUyMHNtb2tlJTIwYmVoaW5kJTIwaXQlMjBsYXVuY2hpbmclMjBpbnRvJTIwc3BhY2UlMjBmcm9tJTIwdGhlJTIwZGVzZXJ0JTJDJTIwNGslMkMlMjBoaWdoJTIwcmVzb2x1dGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmJhZCUyMHF1YWxpdHklMkMlMjB3b3JzZSUyMHF1YWxpdHklMkMlMjBsb3clMjByZXNvbHV0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3LjUlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoJTIyY3B1JTIyKS5tYW51YWxfc2VlZCg0OSklMkMlMEEpJTBBZnJhbWVzJTIwJTNEJTIwb3V0cHV0LmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMmFuaW1hdGlvbi5naWYlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
pipeline = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>, motion_adapter=adapter, torch_dtype=torch.float16)
scheduler = DDIMScheduler.from_pretrained(
    <span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipeline.scheduler = scheduler

<span class="hljs-comment"># reduce memory requirements</span>
pipeline.enable_vae_slicing()
pipeline.enable_model_cpu_offload()

output = pipeline(
    prompt=<span class="hljs-string">&quot;A space rocket with trails of smoke behind it launching into space from the desert, 4k, high resolution&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality, low resolution&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">49</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),{c(){t=g("p"),t.innerHTML=J,n=f(),r=g("p"),r.innerHTML=c,o=f(),U(m.$$.fragment),y=f(),p=g("div"),p.innerHTML=b,this.h()},l(h){t=T(h,"P",{"data-svelte-h":!0}),B(t)!=="svelte-15o723c"&&(t.innerHTML=J),n=M(h),r=T(h,"P",{"data-svelte-h":!0}),B(r)!=="svelte-1mk3k64"&&(r.innerHTML=c),o=M(h),j(m.$$.fragment,h),y=M(h),p=T(h,"DIV",{class:!0,"data-svelte-h":!0}),B(p)!=="svelte-1bp1nd0"&&(p.innerHTML=b),this.h()},h(){k(p,"class","flex justify-center")},m(h,d){s(h,t,d),s(h,n,d),s(h,r,d),s(h,o,d),W(m,h,d),s(h,y,d),s(h,p,d),i=!0},p:X,i(h){i||(G(m.$$.fragment,h),i=!0)},o(h){v(m.$$.fragment,h),i=!1},d(h){h&&(l(t),l(n),l(r),l(o),l(y),l(p)),V(m,h)}}}function $t($){let t,J,n,r,c,o,m,y,p,b,i,h;return t=new C({props:{id:"popular-models",option:"CogVideoX",$$slots:{default:[Ut]},$$scope:{ctx:$}}}),n=new C({props:{id:"popular-models",option:"HunyuanVideo",$$slots:{default:[Wt]},$$scope:{ctx:$}}}),c=new C({props:{id:"popular-models",option:"LTX-Video",$$slots:{default:[Gt]},$$scope:{ctx:$}}}),m=new C({props:{id:"popular-models",option:"Mochi-1",$$slots:{default:[Vt]},$$scope:{ctx:$}}}),p=new C({props:{id:"popular-models",option:"StableVideoDiffusion",$$slots:{default:[Bt]},$$scope:{ctx:$}}}),i=new C({props:{id:"popular-models",option:"AnimateDiff",$$slots:{default:[It]},$$scope:{ctx:$}}}),{c(){U(t.$$.fragment),J=f(),U(n.$$.fragment),r=f(),U(c.$$.fragment),o=f(),U(m.$$.fragment),y=f(),U(p.$$.fragment),b=f(),U(i.$$.fragment)},l(d){j(t.$$.fragment,d),J=M(d),j(n.$$.fragment,d),r=M(d),j(c.$$.fragment,d),o=M(d),j(m.$$.fragment,d),y=M(d),j(p.$$.fragment,d),b=M(d),j(i.$$.fragment,d)},m(d,w){W(t,d,w),s(d,J,w),W(n,d,w),s(d,r,w),W(c,d,w),s(d,o,w),W(m,d,w),s(d,y,w),W(p,d,w),s(d,b,w),W(i,d,w),h=!0},p(d,w){const Z={};w&2&&(Z.$$scope={dirty:w,ctx:d}),t.$set(Z);const a={};w&2&&(a.$$scope={dirty:w,ctx:d}),n.$set(a);const I={};w&2&&(I.$$scope={dirty:w,ctx:d}),c.$set(I);const ye={};w&2&&(ye.$$scope={dirty:w,ctx:d}),m.$set(ye);const S={};w&2&&(S.$$scope={dirty:w,ctx:d}),p.$set(S);const R={};w&2&&(R.$$scope={dirty:w,ctx:d}),i.$set(R)},i(d){h||(G(t.$$.fragment,d),G(n.$$.fragment,d),G(c.$$.fragment,d),G(m.$$.fragment,d),G(p.$$.fragment,d),G(i.$$.fragment,d),h=!0)},o(d){v(t.$$.fragment,d),v(n.$$.fragment,d),v(c.$$.fragment,d),v(m.$$.fragment,d),v(p.$$.fragment,d),v(i.$$.fragment,d),h=!1},d(d){d&&(l(J),l(r),l(o),l(y),l(b)),V(t,d),V(n,d),V(c,d),V(m,d),V(p,d),V(i,d)}}}function _t($){let t,J="SVD uses the <code>min_guidance_scale</code> and <code>max_guidance_scale</code> parameters for applying guidance to the first and last frames respectively.";return{c(){t=g("p"),t.innerHTML=J},l(n){t=T(n,"P",{"data-svelte-h":!0}),B(t)!=="svelte-1i6okx6"&&(t.innerHTML=J)},m(n,r){s(n,t,r)},p:X,d(n){n&&l(t)}}}function Xt($){let t,J="Stable Video Diffusion provides additional micro-conditioning for the frame rate with the <code>fps</code> parameter and for motion with the <code>motion_bucket_id</code> parameter. Together, these parameters allow for adjusting the amount of motion in the generated video.",n,r,c='There is also a <code>noise_aug_strength</code> parameter that increases the amount of noise added to the initial image. Varying this parameter affects how similar the generated video and initial image are. A higher <code>noise_aug_strength</code> also increases the amount of motion. To learn more, read the <a href="../using-diffusers/svd#micro-conditioning">Micro-conditioning</a> guide.';return{c(){t=g("p"),t.innerHTML=J,n=f(),r=g("p"),r.innerHTML=c},l(o){t=T(o,"P",{"data-svelte-h":!0}),B(t)!=="svelte-17vrdx1"&&(t.innerHTML=J),n=M(o),r=T(o,"P",{"data-svelte-h":!0}),B(r)!=="svelte-1rvhfxn"&&(r.innerHTML=c)},m(o,m){s(o,t,m),s(o,n,m),s(o,r,m)},p:X,d(o){o&&(l(t),l(n),l(r))}}}function Ct($){let t,J="Text2Video-Zero computes the amount of motion to apply to each frame from randomly sampled latents. You can use the <code>motion_field_strength_x</code> and <code>motion_field_strength_y</code> parameters to control the amount of motion to apply to the x and y-axes of the video. The parameters <code>t0</code> and <code>t1</code> are the timesteps to apply motion to the latents.";return{c(){t=g("p"),t.innerHTML=J},l(n){t=T(n,"P",{"data-svelte-h":!0}),B(t)!=="svelte-mpt4pt"&&(t.innerHTML=J)},m(n,r){s(n,t,r)},p:X,d(n){n&&l(t)}}}function kt($){let t,J,n,r;return t=new C({props:{id:"special-parameters",option:"Stable Video Diffusion",$$slots:{default:[Xt]},$$scope:{ctx:$}}}),n=new C({props:{id:"special-parameters",option:"Text2Video-Zero",$$slots:{default:[Ct]},$$scope:{ctx:$}}}),{c(){U(t.$$.fragment),J=f(),U(n.$$.fragment)},l(c){j(t.$$.fragment,c),J=M(c),j(n.$$.fragment,c)},m(c,o){W(t,c,o),s(c,J,o),W(n,c,o),r=!0},p(c,o){const m={};o&2&&(m.$$scope={dirty:o,ctx:c}),t.$set(m);const y={};o&2&&(y.$$scope={dirty:o,ctx:c}),n.$set(y)},i(c){r||(G(t.$$.fragment,c),G(n.$$.fragment,c),r=!0)},o(c){v(t.$$.fragment,c),v(n.$$.fragment,c),r=!1},d(c){c&&l(J),V(t,c),V(n,c)}}}function Rt($){let t,J="Start by downloading a video and extracting the pose images from it.",n,r,c,o,m='Load a <a href="/docs/diffusers/pr_10037/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> for pose estimation and a checkpoint into the <a href="/docs/diffusers/pr_10037/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a>. Then you’ll use the <a href="/docs/diffusers/pr_10037/en/api/attnprocessor#diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.CrossFrameAttnProcessor">CrossFrameAttnProcessor</a> for the UNet and ControlNet.',y,p,b,i,h="Fix the latents for all the frames, and then pass your prompt and extracted pose images to the model to generate a video.",d,w,Z;return r=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMGltYWdlaW8lMEElMEFmaWxlbmFtZSUyMCUzRCUyMCUyMl9fYXNzZXRzX18lMkZwb3Nlc19za2VsZXRvbl9naWZzJTJGZGFuY2UxX2NvcnIubXA0JTIyJTBBcmVwb19pZCUyMCUzRCUyMCUyMlBBSVIlMkZUZXh0MlZpZGVvLVplcm8lMjIlMEF2aWRlb19wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKHJlcG9fdHlwZSUzRCUyMnNwYWNlJTIyJTJDJTIwcmVwb19pZCUzRHJlcG9faWQlMkMlMjBmaWxlbmFtZSUzRGZpbGVuYW1lKSUwQSUwQXJlYWRlciUyMCUzRCUyMGltYWdlaW8uZ2V0X3JlYWRlcih2aWRlb19wYXRoJTJDJTIwJTIyZmZtcGVnJTIyKSUwQWZyYW1lX2NvdW50JTIwJTNEJTIwOCUwQXBvc2VfaW1hZ2VzJTIwJTNEJTIwJTVCSW1hZ2UuZnJvbWFycmF5KHJlYWRlci5nZXRfZGF0YShpKSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShmcmFtZV9jb3VudCklNUQ=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> imageio

filename = <span class="hljs-string">&quot;__assets__/poses_skeleton_gifs/dance1_corr.mp4&quot;</span>
repo_id = <span class="hljs-string">&quot;PAIR/Text2Video-Zero&quot;</span>
video_path = hf_hub_download(repo_type=<span class="hljs-string">&quot;space&quot;</span>, repo_id=repo_id, filename=filename)

reader = imageio.get_reader(video_path, <span class="hljs-string">&quot;ffmpeg&quot;</span>)
frame_count = <span class="hljs-number">8</span>
pose_images = [Image.fromarray(reader.get_data(i)) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(frame_count)]`,wrap:!1}}),p=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTBBZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMudGV4dF90b192aWRlb19zeW50aGVzaXMucGlwZWxpbmVfdGV4dF90b192aWRlb196ZXJvJTIwaW1wb3J0JTIwQ3Jvc3NGcmFtZUF0dG5Qcm9jZXNzb3IlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmxsbHlhc3ZpZWwlMkZzZC1jb250cm9sbmV0LW9wZW5wb3NlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUyMGNvbnRyb2xuZXQlM0Rjb250cm9sbmV0JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXBpcGVsaW5lLnVuZXQuc2V0X2F0dG5fcHJvY2Vzc29yKENyb3NzRnJhbWVBdHRuUHJvY2Vzc29yKGJhdGNoX3NpemUlM0QyKSklMEFwaXBlbGluZS5jb250cm9sbmV0LnNldF9hdHRuX3Byb2Nlc3NvcihDcm9zc0ZyYW1lQXR0blByb2Nlc3NvcihiYXRjaF9zaXplJTNEMikp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero <span class="hljs-keyword">import</span> CrossFrameAttnProcessor

model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-openpose&quot;</span>, torch_dtype=torch.float16)
pipeline = StableDiffusionControlNetPipeline.from_pretrained(
    model_id, controlnet=controlnet, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.unet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))
pipeline.controlnet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))`,wrap:!1}}),w=new _({props:{code:"bGF0ZW50cyUyMCUzRCUyMHRvcmNoLnJhbmRuKCgxJTJDJTIwNCUyQyUyMDY0JTJDJTIwNjQpJTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUyMiUyQyUyMGR0eXBlJTNEdG9yY2guZmxvYXQxNikucmVwZWF0KGxlbihwb3NlX2ltYWdlcyklMkMlMjAxJTJDJTIwMSUyQyUyMDEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyRGFydGglMjBWYWRlciUyMGRhbmNpbmclMjBpbiUyMGElMjBkZXNlcnQlMjIlMEFyZXN1bHQlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0QlNUJwcm9tcHQlNUQlMjAqJTIwbGVuKHBvc2VfaW1hZ2VzKSUyQyUyMGltYWdlJTNEcG9zZV9pbWFnZXMlMkMlMjBsYXRlbnRzJTNEbGF0ZW50cykuaW1hZ2VzJTBBaW1hZ2Vpby5taW1zYXZlKCUyMnZpZGVvLm1wNCUyMiUyQyUyMHJlc3VsdCUyQyUyMGZwcyUzRDQp",highlighted:`latents = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16).repeat(<span class="hljs-built_in">len</span>(pose_images), <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)

prompt = <span class="hljs-string">&quot;Darth Vader dancing in a desert&quot;</span>
result = pipeline(prompt=[prompt] * <span class="hljs-built_in">len</span>(pose_images), image=pose_images, latents=latents).images
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),{c(){t=g("p"),t.textContent=J,n=f(),U(r.$$.fragment),c=f(),o=g("p"),o.innerHTML=m,y=f(),U(p.$$.fragment),b=f(),i=g("p"),i.textContent=h,d=f(),U(w.$$.fragment)},l(a){t=T(a,"P",{"data-svelte-h":!0}),B(t)!=="svelte-iz4nwy"&&(t.textContent=J),n=M(a),j(r.$$.fragment,a),c=M(a),o=T(a,"P",{"data-svelte-h":!0}),B(o)!=="svelte-creoxh"&&(o.innerHTML=m),y=M(a),j(p.$$.fragment,a),b=M(a),i=T(a,"P",{"data-svelte-h":!0}),B(i)!=="svelte-se6rgz"&&(i.textContent=h),d=M(a),j(w.$$.fragment,a)},m(a,I){s(a,t,I),s(a,n,I),W(r,a,I),s(a,c,I),s(a,o,I),s(a,y,I),W(p,a,I),s(a,b,I),s(a,i,I),s(a,d,I),W(w,a,I),Z=!0},p:X,i(a){Z||(G(r.$$.fragment,a),G(p.$$.fragment,a),G(w.$$.fragment,a),Z=!0)},o(a){v(r.$$.fragment,a),v(p.$$.fragment,a),v(w.$$.fragment,a),Z=!1},d(a){a&&(l(t),l(n),l(c),l(o),l(y),l(b),l(i),l(d)),V(r,a),V(p,a),V(w,a)}}}function xt($){let t,J="Download a video and extract the edges from it.",n,r,c,o,m='Load a <a href="/docs/diffusers/pr_10037/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> for canny edge and a checkpoint into the <a href="/docs/diffusers/pr_10037/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a>. Then you’ll use the <a href="/docs/diffusers/pr_10037/en/api/attnprocessor#diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.CrossFrameAttnProcessor">CrossFrameAttnProcessor</a> for the UNet and ControlNet.',y,p,b,i,h="Fix the latents for all the frames, and then pass your prompt and extracted edge images to the model to generate a video.",d,w,Z;return r=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMGltYWdlaW8lMEElMEFmaWxlbmFtZSUyMCUzRCUyMCUyMl9fYXNzZXRzX18lMkZwb3Nlc19za2VsZXRvbl9naWZzJTJGZGFuY2UxX2NvcnIubXA0JTIyJTBBcmVwb19pZCUyMCUzRCUyMCUyMlBBSVIlMkZUZXh0MlZpZGVvLVplcm8lMjIlMEF2aWRlb19wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKHJlcG9fdHlwZSUzRCUyMnNwYWNlJTIyJTJDJTIwcmVwb19pZCUzRHJlcG9faWQlMkMlMjBmaWxlbmFtZSUzRGZpbGVuYW1lKSUwQSUwQXJlYWRlciUyMCUzRCUyMGltYWdlaW8uZ2V0X3JlYWRlcih2aWRlb19wYXRoJTJDJTIwJTIyZmZtcGVnJTIyKSUwQWZyYW1lX2NvdW50JTIwJTNEJTIwOCUwQXBvc2VfaW1hZ2VzJTIwJTNEJTIwJTVCSW1hZ2UuZnJvbWFycmF5KHJlYWRlci5nZXRfZGF0YShpKSklMjBmb3IlMjBpJTIwaW4lMjByYW5nZShmcmFtZV9jb3VudCklNUQ=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> imageio

filename = <span class="hljs-string">&quot;__assets__/poses_skeleton_gifs/dance1_corr.mp4&quot;</span>
repo_id = <span class="hljs-string">&quot;PAIR/Text2Video-Zero&quot;</span>
video_path = hf_hub_download(repo_type=<span class="hljs-string">&quot;space&quot;</span>, repo_id=repo_id, filename=filename)

reader = imageio.get_reader(video_path, <span class="hljs-string">&quot;ffmpeg&quot;</span>)
frame_count = <span class="hljs-number">8</span>
pose_images = [Image.fromarray(reader.get_data(i)) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(frame_count)]`,wrap:!1}}),p=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTBBZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMudGV4dF90b192aWRlb19zeW50aGVzaXMucGlwZWxpbmVfdGV4dF90b192aWRlb196ZXJvJTIwaW1wb3J0JTIwQ3Jvc3NGcmFtZUF0dG5Qcm9jZXNzb3IlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmxsbHlhc3ZpZWwlMkZzZC1jb250cm9sbmV0LWNhbm55JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUyMGNvbnRyb2xuZXQlM0Rjb250cm9sbmV0JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXBpcGVsaW5lLnVuZXQuc2V0X2F0dG5fcHJvY2Vzc29yKENyb3NzRnJhbWVBdHRuUHJvY2Vzc29yKGJhdGNoX3NpemUlM0QyKSklMEFwaXBlbGluZS5jb250cm9sbmV0LnNldF9hdHRuX3Byb2Nlc3NvcihDcm9zc0ZyYW1lQXR0blByb2Nlc3NvcihiYXRjaF9zaXplJTNEMikp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero <span class="hljs-keyword">import</span> CrossFrameAttnProcessor

model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16)
pipeline = StableDiffusionControlNetPipeline.from_pretrained(
    model_id, controlnet=controlnet, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.unet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))
pipeline.controlnet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">2</span>))`,wrap:!1}}),w=new _({props:{code:"bGF0ZW50cyUyMCUzRCUyMHRvcmNoLnJhbmRuKCgxJTJDJTIwNCUyQyUyMDY0JTJDJTIwNjQpJTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUyMiUyQyUyMGR0eXBlJTNEdG9yY2guZmxvYXQxNikucmVwZWF0KGxlbihwb3NlX2ltYWdlcyklMkMlMjAxJTJDJTIwMSUyQyUyMDEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyRGFydGglMjBWYWRlciUyMGRhbmNpbmclMjBpbiUyMGElMjBkZXNlcnQlMjIlMEFyZXN1bHQlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0QlNUJwcm9tcHQlNUQlMjAqJTIwbGVuKHBvc2VfaW1hZ2VzKSUyQyUyMGltYWdlJTNEcG9zZV9pbWFnZXMlMkMlMjBsYXRlbnRzJTNEbGF0ZW50cykuaW1hZ2VzJTBBaW1hZ2Vpby5taW1zYXZlKCUyMnZpZGVvLm1wNCUyMiUyQyUyMHJlc3VsdCUyQyUyMGZwcyUzRDQp",highlighted:`latents = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16).repeat(<span class="hljs-built_in">len</span>(pose_images), <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)

prompt = <span class="hljs-string">&quot;Darth Vader dancing in a desert&quot;</span>
result = pipeline(prompt=[prompt] * <span class="hljs-built_in">len</span>(pose_images), image=pose_images, latents=latents).images
imageio.mimsave(<span class="hljs-string">&quot;video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),{c(){t=g("p"),t.textContent=J,n=f(),U(r.$$.fragment),c=f(),o=g("p"),o.innerHTML=m,y=f(),U(p.$$.fragment),b=f(),i=g("p"),i.textContent=h,d=f(),U(w.$$.fragment)},l(a){t=T(a,"P",{"data-svelte-h":!0}),B(t)!=="svelte-17hae8i"&&(t.textContent=J),n=M(a),j(r.$$.fragment,a),c=M(a),o=T(a,"P",{"data-svelte-h":!0}),B(o)!=="svelte-b2zqu1"&&(o.innerHTML=m),y=M(a),j(p.$$.fragment,a),b=M(a),i=T(a,"P",{"data-svelte-h":!0}),B(i)!=="svelte-bmckdz"&&(i.textContent=h),d=M(a),j(w.$$.fragment,a)},m(a,I){s(a,t,I),s(a,n,I),W(r,a,I),s(a,c,I),s(a,o,I),s(a,y,I),W(p,a,I),s(a,b,I),s(a,i,I),s(a,d,I),W(w,a,I),Z=!0},p:X,i(a){Z||(G(r.$$.fragment,a),G(p.$$.fragment,a),G(w.$$.fragment,a),Z=!0)},o(a){v(r.$$.fragment,a),v(p.$$.fragment,a),v(w.$$.fragment,a),Z=!1},d(a){a&&(l(t),l(n),l(c),l(o),l(y),l(b),l(i),l(d)),V(r,a),V(p,a),V(w,a)}}}function Yt($){let t,J="InstructPix2Pix allows you to use text to describe the changes you want to make to the video. Start by downloading and reading a video.",n,r,c,o,m='Load the <a href="/docs/diffusers/pr_10037/en/api/pipelines/pix2pix#diffusers.StableDiffusionInstructPix2PixPipeline">StableDiffusionInstructPix2PixPipeline</a> and set the <a href="/docs/diffusers/pr_10037/en/api/attnprocessor#diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.CrossFrameAttnProcessor">CrossFrameAttnProcessor</a> for the UNet.',y,p,b,i,h="Pass a prompt describing the change you want to apply to the video.",d,w,Z;return r=new _({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMGltYWdlaW8lMEElMEFmaWxlbmFtZSUyMCUzRCUyMCUyMl9fYXNzZXRzX18lMkZwaXgycGl4JTIwdmlkZW8lMkZjYW1lbC5tcDQlMjIlMEFyZXBvX2lkJTIwJTNEJTIwJTIyUEFJUiUyRlRleHQyVmlkZW8tWmVybyUyMiUwQXZpZGVvX3BhdGglMjAlM0QlMjBoZl9odWJfZG93bmxvYWQocmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMjByZXBvX2lkJTNEcmVwb19pZCUyQyUyMGZpbGVuYW1lJTNEZmlsZW5hbWUpJTBBJTBBcmVhZGVyJTIwJTNEJTIwaW1hZ2Vpby5nZXRfcmVhZGVyKHZpZGVvX3BhdGglMkMlMjAlMjJmZm1wZWclMjIpJTBBZnJhbWVfY291bnQlMjAlM0QlMjA4JTBBdmlkZW8lMjAlM0QlMjAlNUJJbWFnZS5mcm9tYXJyYXkocmVhZGVyLmdldF9kYXRhKGkpKSUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGZyYW1lX2NvdW50KSU1RA==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> imageio

filename = <span class="hljs-string">&quot;__assets__/pix2pix video/camel.mp4&quot;</span>
repo_id = <span class="hljs-string">&quot;PAIR/Text2Video-Zero&quot;</span>
video_path = hf_hub_download(repo_type=<span class="hljs-string">&quot;space&quot;</span>, repo_id=repo_id, filename=filename)

reader = imageio.get_reader(video_path, <span class="hljs-string">&quot;ffmpeg&quot;</span>)
frame_count = <span class="hljs-number">8</span>
video = [Image.fromarray(reader.get_data(i)) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(frame_count)]`,wrap:!1}}),p=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnBpcGVsaW5lcy50ZXh0X3RvX3ZpZGVvX3N5bnRoZXNpcy5waXBlbGluZV90ZXh0X3RvX3ZpZGVvX3plcm8lMjBpbXBvcnQlMjBDcm9zc0ZyYW1lQXR0blByb2Nlc3NvciUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnRpbWJyb29rcyUyRmluc3RydWN0LXBpeDJwaXglMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUudW5ldC5zZXRfYXR0bl9wcm9jZXNzb3IoQ3Jvc3NGcmFtZUF0dG5Qcm9jZXNzb3IoYmF0Y2hfc2l6ZSUzRDMpKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline
<span class="hljs-keyword">from</span> diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero <span class="hljs-keyword">import</span> CrossFrameAttnProcessor

pipeline = StableDiffusionInstructPix2PixPipeline.from_pretrained(<span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.unet.set_attn_processor(CrossFrameAttnProcessor(batch_size=<span class="hljs-number">3</span>))`,wrap:!1}}),w=new _({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIybWFrZSUyMGl0JTIwVmFuJTIwR29naCUyMFN0YXJyeSUyME5pZ2h0JTIwc3R5bGUlMjIlMEFyZXN1bHQlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlM0QlNUJwcm9tcHQlNUQlMjAqJTIwbGVuKHZpZGVvKSUyQyUyMGltYWdlJTNEdmlkZW8pLmltYWdlcyUwQWltYWdlaW8ubWltc2F2ZSglMjJlZGl0ZWRfdmlkZW8ubXA0JTIyJTJDJTIwcmVzdWx0JTJDJTIwZnBzJTNENCk=",highlighted:`prompt = <span class="hljs-string">&quot;make it Van Gogh Starry Night style&quot;</span>
result = pipeline(prompt=[prompt] * <span class="hljs-built_in">len</span>(video), image=video).images
imageio.mimsave(<span class="hljs-string">&quot;edited_video.mp4&quot;</span>, result, fps=<span class="hljs-number">4</span>)`,wrap:!1}}),{c(){t=g("p"),t.textContent=J,n=f(),U(r.$$.fragment),c=f(),o=g("p"),o.innerHTML=m,y=f(),U(p.$$.fragment),b=f(),i=g("p"),i.textContent=h,d=f(),U(w.$$.fragment)},l(a){t=T(a,"P",{"data-svelte-h":!0}),B(t)!=="svelte-189mnmt"&&(t.textContent=J),n=M(a),j(r.$$.fragment,a),c=M(a),o=T(a,"P",{"data-svelte-h":!0}),B(o)!=="svelte-1o8r9is"&&(o.innerHTML=m),y=M(a),j(p.$$.fragment,a),b=M(a),i=T(a,"P",{"data-svelte-h":!0}),B(i)!=="svelte-1iedrpu"&&(i.textContent=h),d=M(a),j(w.$$.fragment,a)},m(a,I){s(a,t,I),s(a,n,I),W(r,a,I),s(a,c,I),s(a,o,I),s(a,y,I),W(p,a,I),s(a,b,I),s(a,i,I),s(a,d,I),W(w,a,I),Z=!0},p:X,i(a){Z||(G(r.$$.fragment,a),G(p.$$.fragment,a),G(w.$$.fragment,a),Z=!0)},o(a){v(r.$$.fragment,a),v(p.$$.fragment,a),v(w.$$.fragment,a),Z=!1},d(a){a&&(l(t),l(n),l(c),l(o),l(y),l(b),l(i),l(d)),V(r,a),V(p,a),V(w,a)}}}function Nt($){let t,J,n,r,c,o;return t=new C({props:{id:"t2v-zero",option:"pose control",$$slots:{default:[Rt]},$$scope:{ctx:$}}}),n=new C({props:{id:"t2v-zero",option:"edge control",$$slots:{default:[xt]},$$scope:{ctx:$}}}),c=new C({props:{id:"t2v-zero",option:"InstructPix2Pix",$$slots:{default:[Yt]},$$scope:{ctx:$}}}),{c(){U(t.$$.fragment),J=f(),U(n.$$.fragment),r=f(),U(c.$$.fragment)},l(m){j(t.$$.fragment,m),J=M(m),j(n.$$.fragment,m),r=M(m),j(c.$$.fragment,m)},m(m,y){W(t,m,y),s(m,J,y),W(n,m,y),s(m,r,y),W(c,m,y),o=!0},p(m,y){const p={};y&2&&(p.$$scope={dirty:y,ctx:m}),t.$set(p);const b={};y&2&&(b.$$scope={dirty:y,ctx:m}),n.$set(b);const i={};y&2&&(i.$$scope={dirty:y,ctx:m}),c.$set(i)},i(m){o||(G(t.$$.fragment,m),G(n.$$.fragment,m),G(c.$$.fragment,m),o=!0)},o(m){v(t.$$.fragment,m),v(n.$$.fragment,m),v(c.$$.fragment,m),o=!1},d(m){m&&(l(J),l(r)),V(t,m),V(n,m),V(c,m)}}}function Ht($){let t,J,n,r,c,o,m,y="Video generation models include a temporal dimension to bring images, or frames, together to create a video. These models are trained on large-scale datasets of high-quality text-video pairs to learn how to combine the modalities to ensure the generated video is coherent and realistic.",p,b,i='<a href="https://huggingface.co/models?other=video-generation" rel="nofollow">Explore</a> some of the more popular open-source video generation models available from Diffusers below.',h,d,w,Z,a,I,ye="There are a few important parameters you can configure in the pipeline that’ll affect the video generation process and quality. Let’s take a closer look at what these parameters do and how changing them affects the output.",S,R,Je,F,Ke="The <code>num_frames</code> parameter determines how many video frames are generated per second. A frame is an image that is played in a sequence of other frames to create motion or a video. This affects video length because the pipeline generates a certain number of frames per second (check a pipeline’s API reference for the default value). To increase the video duration, you’ll need to increase the <code>num_frames</code> parameter.",be,q,we,Y,Oe='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/num_frames_14.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">num_frames=14</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/num_frames_25.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">num_frames=25</figcaption></div>',Ze,D,ge,A,et="The <code>guidance_scale</code> parameter controls how closely aligned the generated video and text prompt or initial image is. A higher <code>guidance_scale</code> value means your generated video is more aligned with the text prompt or initial image, while a lower <code>guidance_scale</code> value means your generated video is less aligned which could give the model more “creativity” to interpret the conditioning input.",Te,N,Ue,L,je,H,tt='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/i2vgen-xl-example.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale=9.0</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/guidance_scale_1.0.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guidance_scale=1.0</figcaption></div>',We,P,Ge,K,lt="A negative prompt deters the model from generating things you don’t want it to. This parameter is commonly used to improve overall generation quality by removing poor or bad features such as “low resolution” or “bad details”.",ve,O,Ve,Q,st='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff_no_neg.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">no negative prompt</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff_neg.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">negative prompt applied</figcaption></div>',Be,ee,Ie,te,at="There are some pipeline parameters that are unique to each model such as adjusting the motion in a video or adding noise to the initial image.",$e,z,_e,le,Xe,se,nt='Video generation can be controlled similar to how text-to-image, image-to-image, and inpainting can be controlled with a <a href="/docs/diffusers/pr_10037/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a>. The only difference is you need to use the <a href="/docs/diffusers/pr_10037/en/api/attnprocessor#diffusers.pipelines.text_to_video_synthesis.pipeline_text_to_video_zero.CrossFrameAttnProcessor">CrossFrameAttnProcessor</a> so each frame attends to the first frame.',Ce,ae,ke,ne,it='Text2Video-Zero video generation can be conditioned on pose and edge images for even greater control over a subject’s motion in the generated video or to preserve the identity of a subject/object in the video. You can also use Text2Video-Zero with <a href="../api/pipelines/pix2pix">InstructPix2Pix</a> for editing videos with text.',Re,E,xe,ie,Ye,oe,ot="Video generation requires a lot of memory because you’re generating many video frames at once. You can reduce your memory requirements at the expense of some inference speed. Try:",Ne,pe,pt="<li>offloading pipeline components that are no longer needed to the CPU</li> <li>feed-forward chunking runs the feed-forward layer in a loop instead of all at once</li> <li>break up the number of frames the VAE has to decode into chunks instead of decoding them all at once</li>",He,re,Qe,me,rt='If memory is not an issue and you want to optimize for speed, try wrapping the UNet with <a href="../optimization/torch2.0#torchcompile"><code>torch.compile</code></a>.',ze,de,Ee,ce,Se,ue,mt="Quantization helps reduce the memory requirements of very large models by storing model weights in a lower precision data type. However, quantization may have varying impact on video quality depending on the video model.",Fe,fe,dt='Refer to the <a href="../../quantization/overview">Quantization</a> to learn more about supported quantization backends (bitsandbytes, torchao, gguf) and selecting a quantization backend that supports your use case.',qe,Me,De,he,Ae;return c=new x({props:{title:"Video generation",local:"video-generation",headingTag:"h1"}}),d=new Le({props:{id:"popular-models",options:["CogVideoX","HunyuanVideo","LTX-Video","Mochi-1","StableVideoDiffusion","AnimateDiff"],$$slots:{default:[$t]},$$scope:{ctx:$}}}),Z=new x({props:{title:"Configure model parameters",local:"configure-model-parameters",headingTag:"h2"}}),R=new x({props:{title:"Number of frames",local:"number-of-frames",headingTag:"h3"}}),q=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlVmlkZW9EaWZmdXNpb25QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVWaWRlb0RpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS12aWRlby1kaWZmdXNpb24taW1nMnZpZCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTBBKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnN2ZCUyRnJvY2tldC5wbmclMjIpJTBBaW1hZ2UlMjAlM0QlMjBpbWFnZS5yZXNpemUoKDEwMjQlMkMlMjA1NzYpKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKDQyKSUwQWZyYW1lcyUyMCUzRCUyMHBpcGVsaW5lKGltYWdlJTJDJTIwZGVjb2RlX2NodW5rX3NpemUlM0Q4JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwbnVtX2ZyYW1lcyUzRDI1KS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKGZyYW1lcyUyQyUyMCUyMmdlbmVyYXRlZC5tcDQlMjIlMkMlMjBmcHMlM0Q3KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableVideoDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, export_to_video

pipeline = StableVideoDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-video-diffusion-img2vid&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
)
pipeline.enable_model_cpu_offload()

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/svd/rocket.png&quot;</span>)
image = image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">576</span>))

generator = torch.manual_seed(<span class="hljs-number">42</span>)
frames = pipeline(image, decode_chunk_size=<span class="hljs-number">8</span>, generator=generator, num_frames=<span class="hljs-number">25</span>).frames[<span class="hljs-number">0</span>]
export_to_video(frames, <span class="hljs-string">&quot;generated.mp4&quot;</span>, fps=<span class="hljs-number">7</span>)`,wrap:!1}}),D=new x({props:{title:"Guidance scale",local:"guidance-scale",headingTag:"h3"}}),N=new Pe({props:{$$slots:{default:[_t]},$$scope:{ctx:$}}}),L=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwSTJWR2VuWExQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fZ2lmJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwSTJWR2VuWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYWxpLXZpbGFiJTJGaTJ2Z2VuLXhsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFpbWFnZV91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkb2NzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGaTJ2Z2VuX3hsX2ltYWdlcyUyRmltZ18wMDA5LnBuZyUyMiUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZShpbWFnZV91cmwpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMlBhcGVycyUyMHdlcmUlMjBmbG9hdGluZyUyMGluJTIwdGhlJTIwYWlyJTIwb24lMjBhJTIwdGFibGUlMjBpbiUyMHRoZSUyMGxpYnJhcnklMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJEaXN0b3J0ZWQlMkMlMjBkaXNjb250aW51b3VzJTJDJTIwVWdseSUyQyUyMGJsdXJyeSUyQyUyMGxvdyUyMHJlc29sdXRpb24lMkMlMjBtb3Rpb25sZXNzJTJDJTIwc3RhdGljJTJDJTIwZGlzZmlndXJlZCUyQyUyMGRpc2Nvbm5lY3RlZCUyMGxpbWJzJTJDJTIwVWdseSUyMGZhY2VzJTJDJTIwaW5jb21wbGV0ZSUyMGFybXMlMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUwQSUwQWZyYW1lcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDEuMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUwQSkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b19naWYoZnJhbWVzJTJDJTIwJTIyaTJ2LmdpZiUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> I2VGenXLPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif, load_image

pipeline = I2VGenXLPipeline.from_pretrained(<span class="hljs-string">&quot;ali-vilab/i2vgen-xl&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline.enable_model_cpu_offload()

image_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/docs-images/resolve/main/i2vgen_xl_images/img_0009.png&quot;</span>
image = load_image(image_url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

prompt = <span class="hljs-string">&quot;Papers were floating in the air on a table in the library&quot;</span>
negative_prompt = <span class="hljs-string">&quot;Distorted, discontinuous, Ugly, blurry, low resolution, motionless, static, disfigured, disconnected limbs, Ugly faces, incomplete arms&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)

frames = pipeline(
    prompt=prompt,
    image=image,
    num_inference_steps=<span class="hljs-number">50</span>,
    negative_prompt=negative_prompt,
    guidance_scale=<span class="hljs-number">1.0</span>,
    generator=generator
).frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;i2v.gif&quot;</span>)`,wrap:!1}}),P=new x({props:{title:"Negative prompt",local:"negative-prompt",headingTag:"h3"}}),O=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQW5pbWF0ZURpZmZQaXBlbGluZSUyQyUyMERESU1TY2hlZHVsZXIlMkMlMjBNb3Rpb25BZGFwdGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEElMEFhZGFwdGVyJTIwJTNEJTIwTW90aW9uQWRhcHRlci5mcm9tX3ByZXRyYWluZWQoJTIyZ3VveXd3JTJGYW5pbWF0ZWRpZmYtbW90aW9uLWFkYXB0ZXItdjEtNS0yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQW5pbWF0ZURpZmZQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZW1pbGlhbkpSJTJGZXBpQ1JlYWxpc20lMjIlMkMlMjBtb3Rpb25fYWRhcHRlciUzRGFkYXB0ZXIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZW1pbGlhbkpSJTJGZXBpQ1JlYWxpc20lMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBjbGlwX3NhbXBsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwdGltZXN0ZXBfc3BhY2luZyUzRCUyMmxpbnNwYWNlJTIyJTJDJTBBJTIwJTIwJTIwJTIwYmV0YV9zY2hlZHVsZSUzRCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMHN0ZXBzX29mZnNldCUzRDElMkMlMEEpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwc2NoZWR1bGVyJTBBcGlwZWxpbmUuZW5hYmxlX3ZhZV9zbGljaW5nKCklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQW91dHB1dCUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMjM2MCUyMGNhbWVyYSUyMHNob3QlMjBvZiUyMGElMjBzdXNoaSUyMHJvbGwlMjBpbiUyMGElMjByZXN0YXVyYW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyRGlzdG9ydGVkJTJDJTIwZGlzY29udGludW91cyUyQyUyMHVnbHklMkMlMjBibHVycnklMkMlMjBsb3clMjByZXNvbHV0aW9uJTJDJTIwbW90aW9ubGVzcyUyQyUyMHN0YXRpYyUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9mcmFtZXMlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNENy41JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2guR2VuZXJhdG9yKCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMkMlMEEpJTBBZnJhbWVzJTIwJTNEJTIwb3V0cHV0LmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMmFuaW1hdGlvbi5naWYlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)

pipeline = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>, motion_adapter=adapter, torch_dtype=torch.float16)
scheduler = DDIMScheduler.from_pretrained(
    <span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipeline.scheduler = scheduler
pipeline.enable_vae_slicing()
pipeline.enable_model_cpu_offload()

output = pipeline(
    prompt=<span class="hljs-string">&quot;360 camera shot of a sushi roll in a restaurant&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;Distorted, discontinuous, ugly, blurry, low resolution, motionless, static&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),ee=new x({props:{title:"Model-specific parameters",local:"model-specific-parameters",headingTag:"h3"}}),z=new Le({props:{id:"special-parameters",options:["Stable Video Diffusion","Text2Video-Zero"],$$slots:{default:[kt]},$$scope:{ctx:$}}}),le=new x({props:{title:"Control video generation",local:"control-video-generation",headingTag:"h2"}}),ae=new x({props:{title:"Text2Video-Zero",local:"text2video-zero",headingTag:"h3"}}),E=new Le({props:{id:"t2v-zero",options:["pose control","edge control","InstructPix2Pix"],$$slots:{default:[Nt]},$$scope:{ctx:$}}}),ie=new x({props:{title:"Optimize",local:"optimize",headingTag:"h2"}}),re=new _({props:{code:"LSUyMHBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBLSUyMGZyYW1lcyUyMCUzRCUyMHBpcGVsaW5lKGltYWdlJTJDJTIwZGVjb2RlX2NodW5rX3NpemUlM0Q4JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5mcmFtZXMlNUIwJTVEJTBBJTJCJTIwcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMkIlMjBwaXBlbGluZS51bmV0LmVuYWJsZV9mb3J3YXJkX2NodW5raW5nKCklMEElMkIlMjBmcmFtZXMlMjAlM0QlMjBwaXBlbGluZShpbWFnZSUyQyUyMGRlY29kZV9jaHVua19zaXplJTNEMiUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUyMG51bV9mcmFtZXMlM0QyNSkuZnJhbWVzJTVCMCU1RA==",highlighted:`<span class="hljs-deletion">- pipeline.enable_model_cpu_offload()</span>
<span class="hljs-deletion">- frames = pipeline(image, decode_chunk_size=8, generator=generator).frames[0]</span>
<span class="hljs-addition">+ pipeline.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipeline.unet.enable_forward_chunking()</span>
<span class="hljs-addition">+ frames = pipeline(image, decode_chunk_size=2, generator=generator, num_frames=25).frames[0]</span>`,wrap:!1}}),de=new _({props:{code:"LSUyMHBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTJCJTIwcGlwZWxpbmUudG8oJTIyY3VkYSUyMiklMEElMkIlMjBwaXBlbGluZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlbGluZS51bmV0JTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUp",highlighted:`<span class="hljs-deletion">- pipeline.enable_model_cpu_offload()</span>
<span class="hljs-addition">+ pipeline.to(&quot;cuda&quot;)</span>
<span class="hljs-addition">+ pipeline.unet = torch.compile(pipeline.unet, mode=&quot;reduce-overhead&quot;, fullgraph=True)</span>`,wrap:!1}}),ce=new x({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),Me=new Tt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/text-img2vid.md"}}),{c(){t=g("meta"),J=f(),n=g("p"),r=f(),U(c.$$.fragment),o=f(),m=g("p"),m.textContent=y,p=f(),b=g("p"),b.innerHTML=i,h=f(),U(d.$$.fragment),w=f(),U(Z.$$.fragment),a=f(),I=g("p"),I.textContent=ye,S=f(),U(R.$$.fragment),Je=f(),F=g("p"),F.innerHTML=Ke,be=f(),U(q.$$.fragment),we=f(),Y=g("div"),Y.innerHTML=Oe,Ze=f(),U(D.$$.fragment),ge=f(),A=g("p"),A.innerHTML=et,Te=f(),U(N.$$.fragment),Ue=f(),U(L.$$.fragment),je=f(),H=g("div"),H.innerHTML=tt,We=f(),U(P.$$.fragment),Ge=f(),K=g("p"),K.textContent=lt,ve=f(),U(O.$$.fragment),Ve=f(),Q=g("div"),Q.innerHTML=st,Be=f(),U(ee.$$.fragment),Ie=f(),te=g("p"),te.textContent=at,$e=f(),U(z.$$.fragment),_e=f(),U(le.$$.fragment),Xe=f(),se=g("p"),se.innerHTML=nt,Ce=f(),U(ae.$$.fragment),ke=f(),ne=g("p"),ne.innerHTML=it,Re=f(),U(E.$$.fragment),xe=f(),U(ie.$$.fragment),Ye=f(),oe=g("p"),oe.textContent=ot,Ne=f(),pe=g("ol"),pe.innerHTML=pt,He=f(),U(re.$$.fragment),Qe=f(),me=g("p"),me.innerHTML=rt,ze=f(),U(de.$$.fragment),Ee=f(),U(ce.$$.fragment),Se=f(),ue=g("p"),ue.textContent=mt,Fe=f(),fe=g("p"),fe.innerHTML=dt,qe=f(),U(Me.$$.fragment),De=f(),he=g("p"),this.h()},l(e){const u=Zt("svelte-u9bgzb",document.head);t=T(u,"META",{name:!0,content:!0}),u.forEach(l),J=M(e),n=T(e,"P",{}),yt(n).forEach(l),r=M(e),j(c.$$.fragment,e),o=M(e),m=T(e,"P",{"data-svelte-h":!0}),B(m)!=="svelte-152ax7i"&&(m.textContent=y),p=M(e),b=T(e,"P",{"data-svelte-h":!0}),B(b)!=="svelte-omkqh8"&&(b.innerHTML=i),h=M(e),j(d.$$.fragment,e),w=M(e),j(Z.$$.fragment,e),a=M(e),I=T(e,"P",{"data-svelte-h":!0}),B(I)!=="svelte-1bg8xrr"&&(I.textContent=ye),S=M(e),j(R.$$.fragment,e),Je=M(e),F=T(e,"P",{"data-svelte-h":!0}),B(F)!=="svelte-1he7va5"&&(F.innerHTML=Ke),be=M(e),j(q.$$.fragment,e),we=M(e),Y=T(e,"DIV",{class:!0,"data-svelte-h":!0}),B(Y)!=="svelte-1hb15b9"&&(Y.innerHTML=Oe),Ze=M(e),j(D.$$.fragment,e),ge=M(e),A=T(e,"P",{"data-svelte-h":!0}),B(A)!=="svelte-10ah3pm"&&(A.innerHTML=et),Te=M(e),j(N.$$.fragment,e),Ue=M(e),j(L.$$.fragment,e),je=M(e),H=T(e,"DIV",{class:!0,"data-svelte-h":!0}),B(H)!=="svelte-1491ymz"&&(H.innerHTML=tt),We=M(e),j(P.$$.fragment,e),Ge=M(e),K=T(e,"P",{"data-svelte-h":!0}),B(K)!=="svelte-xdqe9k"&&(K.textContent=lt),ve=M(e),j(O.$$.fragment,e),Ve=M(e),Q=T(e,"DIV",{class:!0,"data-svelte-h":!0}),B(Q)!=="svelte-139sag9"&&(Q.innerHTML=st),Be=M(e),j(ee.$$.fragment,e),Ie=M(e),te=T(e,"P",{"data-svelte-h":!0}),B(te)!=="svelte-1d2wgj6"&&(te.textContent=at),$e=M(e),j(z.$$.fragment,e),_e=M(e),j(le.$$.fragment,e),Xe=M(e),se=T(e,"P",{"data-svelte-h":!0}),B(se)!=="svelte-13yclge"&&(se.innerHTML=nt),Ce=M(e),j(ae.$$.fragment,e),ke=M(e),ne=T(e,"P",{"data-svelte-h":!0}),B(ne)!=="svelte-w25jvx"&&(ne.innerHTML=it),Re=M(e),j(E.$$.fragment,e),xe=M(e),j(ie.$$.fragment,e),Ye=M(e),oe=T(e,"P",{"data-svelte-h":!0}),B(oe)!=="svelte-i4oodb"&&(oe.textContent=ot),Ne=M(e),pe=T(e,"OL",{"data-svelte-h":!0}),B(pe)!=="svelte-4xypfn"&&(pe.innerHTML=pt),He=M(e),j(re.$$.fragment,e),Qe=M(e),me=T(e,"P",{"data-svelte-h":!0}),B(me)!=="svelte-1dynxrt"&&(me.innerHTML=rt),ze=M(e),j(de.$$.fragment,e),Ee=M(e),j(ce.$$.fragment,e),Se=M(e),ue=T(e,"P",{"data-svelte-h":!0}),B(ue)!=="svelte-1ou2pxc"&&(ue.textContent=mt),Fe=M(e),fe=T(e,"P",{"data-svelte-h":!0}),B(fe)!=="svelte-1cvnbkg"&&(fe.innerHTML=dt),qe=M(e),j(Me.$$.fragment,e),De=M(e),he=T(e,"P",{}),yt(he).forEach(l),this.h()},h(){k(t,"name","hf:doc:metadata"),k(t,"content",Qt),k(Y,"class","flex gap-4"),k(H,"class","flex gap-4"),k(Q,"class","flex gap-4")},m(e,u){gt(document.head,t),s(e,J,u),s(e,n,u),s(e,r,u),W(c,e,u),s(e,o,u),s(e,m,u),s(e,p,u),s(e,b,u),s(e,h,u),W(d,e,u),s(e,w,u),W(Z,e,u),s(e,a,u),s(e,I,u),s(e,S,u),W(R,e,u),s(e,Je,u),s(e,F,u),s(e,be,u),W(q,e,u),s(e,we,u),s(e,Y,u),s(e,Ze,u),W(D,e,u),s(e,ge,u),s(e,A,u),s(e,Te,u),W(N,e,u),s(e,Ue,u),W(L,e,u),s(e,je,u),s(e,H,u),s(e,We,u),W(P,e,u),s(e,Ge,u),s(e,K,u),s(e,ve,u),W(O,e,u),s(e,Ve,u),s(e,Q,u),s(e,Be,u),W(ee,e,u),s(e,Ie,u),s(e,te,u),s(e,$e,u),W(z,e,u),s(e,_e,u),W(le,e,u),s(e,Xe,u),s(e,se,u),s(e,Ce,u),W(ae,e,u),s(e,ke,u),s(e,ne,u),s(e,Re,u),W(E,e,u),s(e,xe,u),W(ie,e,u),s(e,Ye,u),s(e,oe,u),s(e,Ne,u),s(e,pe,u),s(e,He,u),W(re,e,u),s(e,Qe,u),s(e,me,u),s(e,ze,u),W(de,e,u),s(e,Ee,u),W(ce,e,u),s(e,Se,u),s(e,ue,u),s(e,Fe,u),s(e,fe,u),s(e,qe,u),W(Me,e,u),s(e,De,u),s(e,he,u),Ae=!0},p(e,[u]){const ct={};u&2&&(ct.$$scope={dirty:u,ctx:e}),d.$set(ct);const ut={};u&2&&(ut.$$scope={dirty:u,ctx:e}),N.$set(ut);const ft={};u&2&&(ft.$$scope={dirty:u,ctx:e}),z.$set(ft);const Mt={};u&2&&(Mt.$$scope={dirty:u,ctx:e}),E.$set(Mt)},i(e){Ae||(G(c.$$.fragment,e),G(d.$$.fragment,e),G(Z.$$.fragment,e),G(R.$$.fragment,e),G(q.$$.fragment,e),G(D.$$.fragment,e),G(N.$$.fragment,e),G(L.$$.fragment,e),G(P.$$.fragment,e),G(O.$$.fragment,e),G(ee.$$.fragment,e),G(z.$$.fragment,e),G(le.$$.fragment,e),G(ae.$$.fragment,e),G(E.$$.fragment,e),G(ie.$$.fragment,e),G(re.$$.fragment,e),G(de.$$.fragment,e),G(ce.$$.fragment,e),G(Me.$$.fragment,e),Ae=!0)},o(e){v(c.$$.fragment,e),v(d.$$.fragment,e),v(Z.$$.fragment,e),v(R.$$.fragment,e),v(q.$$.fragment,e),v(D.$$.fragment,e),v(N.$$.fragment,e),v(L.$$.fragment,e),v(P.$$.fragment,e),v(O.$$.fragment,e),v(ee.$$.fragment,e),v(z.$$.fragment,e),v(le.$$.fragment,e),v(ae.$$.fragment,e),v(E.$$.fragment,e),v(ie.$$.fragment,e),v(re.$$.fragment,e),v(de.$$.fragment,e),v(ce.$$.fragment,e),v(Me.$$.fragment,e),Ae=!1},d(e){e&&(l(J),l(n),l(r),l(o),l(m),l(p),l(b),l(h),l(w),l(a),l(I),l(S),l(Je),l(F),l(be),l(we),l(Y),l(Ze),l(ge),l(A),l(Te),l(Ue),l(je),l(H),l(We),l(Ge),l(K),l(ve),l(Ve),l(Q),l(Be),l(Ie),l(te),l($e),l(_e),l(Xe),l(se),l(Ce),l(ke),l(ne),l(Re),l(xe),l(Ye),l(oe),l(Ne),l(pe),l(He),l(Qe),l(me),l(ze),l(Ee),l(Se),l(ue),l(Fe),l(fe),l(qe),l(De),l(he)),l(t),V(c,e),V(d,e),V(Z,e),V(R,e),V(q,e),V(D,e),V(N,e),V(L,e),V(P,e),V(O,e),V(ee,e),V(z,e),V(le,e),V(ae,e),V(E,e),V(ie,e),V(re,e),V(de,e),V(ce,e),V(Me,e)}}}const Qt='{"title":"Video generation","local":"video-generation","sections":[{"title":"Configure model parameters","local":"configure-model-parameters","sections":[{"title":"Number of frames","local":"number-of-frames","sections":[],"depth":3},{"title":"Guidance scale","local":"guidance-scale","sections":[],"depth":3},{"title":"Negative prompt","local":"negative-prompt","sections":[],"depth":3},{"title":"Model-specific parameters","local":"model-specific-parameters","sections":[],"depth":3}],"depth":2},{"title":"Control video generation","local":"control-video-generation","sections":[{"title":"Text2Video-Zero","local":"text2video-zero","sections":[],"depth":3}],"depth":2},{"title":"Optimize","local":"optimize","sections":[],"depth":2},{"title":"Quantization","local":"quantization","sections":[],"depth":2}],"depth":1}';function zt($){return Jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Lt extends bt{constructor(t){super(),wt(this,t,zt,Ht,ht,{})}}export{Lt as component};
