import{s as Sn,o as In,n as xt}from"../chunks/scheduler.8c3d61f6.js";import{S as kn,i as Cn,g as s,s as o,r as m,A as Jn,h as r,f as t,c as i,j as T,u as g,x as c,k as P,y as a,a as l,v as u,d as f,t as _,w as h}from"../chunks/index.da70eac4.js";import{T as Pn}from"../chunks/Tip.1d9b8c37.js";import{D as k}from"../chunks/Docstring.6b390b9a.js";import{C as Ot}from"../chunks/CodeBlock.00a903b3.js";import{E as $n}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as We,E as Un}from"../chunks/EditOnGithub.1e64e623.js";function Gn(C){let p,$='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){p=s("p"),p.innerHTML=$},l(b){p=r(b,"P",{"data-svelte-h":!0}),c(p)!=="svelte-1qn15hi"&&(p.innerHTML=$)},m(b,v){l(b,p,v)},p:xt,d(b){b&&t(p)}}}function Ln(C){let p,$='Make sure to pass the <code>variant</code> argument for downloaded checkpoints to use lower disk space. Set it to <code>&quot;fp16&quot;</code> for models with recommended dtype as <code>torch.float16</code>, and <code>&quot;bf16&quot;</code> for models with recommended dtype as <code>torch.bfloat16</code>. By default, <code>torch.float32</code> weights are downloaded, which use twice the amount of disk storage. Additionally, <code>torch.float32</code> weights can be downcasted on-the-fly by specifying the <code>torch_dtype</code> argument. Read about it in the <a href="https://huggingface.co/docs/diffusers/v0.31.0/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained" rel="nofollow">docs</a>.';return{c(){p=s("p"),p.innerHTML=$},l(b){p=r(b,"P",{"data-svelte-h":!0}),c(p)!=="svelte-1k3bkk9"&&(p.innerHTML=$)},m(b,v){l(b,p,v)},p:xt,d(b){b&&t(p)}}}function An(C){let p,$="Examples:",b,v,M;return v=new Ot({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU2FuYVBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFNhbmFQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyRWZmaWNpZW50LUxhcmdlLU1vZGVsJTJGU2FuYV8xNjAwTV8xMDI0cHhfQkYxNl9kaWZmdXNlcnMlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MzIlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUudGV4dF9lbmNvZGVyLnRvKHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudHJhbnNmb3JtZXIlMjAlM0QlMjBwaXBlLnRyYW5zZm9ybWVyLnRvKHRvcmNoLmJmbG9hdDE2KSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0QnYSUyMGN5YmVycHVuayUyMGNhdCUyMHdpdGglMjBhJTIwbmVvbiUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMCUyMlNhbmElMjInKSU1QjAlNUQlMEFpbWFnZSU1QjAlNUQuc2F2ZSglMjJvdXRwdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SanaPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = SanaPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Efficient-Large-Model/Sana_1600M_1024px_BF16_diffusers&quot;</span>, torch_dtype=torch.float32
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.text_encoder.to(torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.transformer = pipe.transformer.to(torch.bfloat16)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=<span class="hljs-string">&#x27;a cyberpunk cat with a neon sign that says &quot;Sana&quot;&#x27;</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),{c(){p=s("p"),p.textContent=$,b=o(),m(v.$$.fragment)},l(d){p=r(d,"P",{"data-svelte-h":!0}),c(p)!=="svelte-kvfsh7"&&(p.textContent=$),b=i(d),g(v.$$.fragment,d)},m(d,I){l(d,p,I),l(d,b,I),u(v,d,I),M=!0},p:xt,i(d){M||(f(v.$$.fragment,d),M=!0)},o(d){_(v.$$.fragment,d),M=!1},d(d){d&&(t(p),t(b)),h(v,d)}}}function En(C){let p,$="Examples:",b,v,M;return v=new Ot({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU2FuYVBBR1BpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMFNhbmFQQUdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyRWZmaWNpZW50LUxhcmdlLU1vZGVsJTJGU2FuYV8xNjAwTV8xMDI0cHhfQkYxNl9kaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWdfYXBwbGllZF9sYXllcnMlM0QlNUIlMjJ0cmFuc2Zvcm1lcl9ibG9ja3MuOCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQzMiUyQyUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcGlwZS50ZXh0X2VuY29kZXIudG8odG9yY2guYmZsb2F0MTYpJTBBcGlwZS50cmFuc2Zvcm1lciUyMCUzRCUyMHBpcGUudHJhbnNmb3JtZXIudG8odG9yY2guYmZsb2F0MTYpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRCdhJTIwY3liZXJwdW5rJTIwY2F0JTIwd2l0aCUyMGElMjBuZW9uJTIwc2lnbiUyMHRoYXQlMjBzYXlzJTIwJTIyU2FuYSUyMicpJTVCMCU1RCUwQWltYWdlJTVCMCU1RC5zYXZlKCUyMm91dHB1dC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> SanaPAGPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = SanaPAGPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Efficient-Large-Model/Sana_1600M_1024px_BF16_diffusers&quot;</span>,
<span class="hljs-meta">... </span>    pag_applied_layers=[<span class="hljs-string">&quot;transformer_blocks.8&quot;</span>],
<span class="hljs-meta">... </span>    torch_dtype=torch.float32,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.text_encoder.to(torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.transformer = pipe.transformer.to(torch.bfloat16)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=<span class="hljs-string">&#x27;a cyberpunk cat with a neon sign that says &quot;Sana&quot;&#x27;</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),{c(){p=s("p"),p.textContent=$,b=o(),m(v.$$.fragment)},l(d){p=r(d,"P",{"data-svelte-h":!0}),c(p)!=="svelte-kvfsh7"&&(p.textContent=$),b=i(d),g(v.$$.fragment,d)},m(d,I){l(d,p,I),l(d,b,I),u(v,d,I),M=!0},p:xt,i(d){M||(f(v.$$.fragment,d),M=!0)},o(d){_(v.$$.fragment,d),M=!1},d(d){d&&(t(p),t(b)),h(v,d)}}}function jn(C){let p,$,b,v,M,d,I,Kt='<a href="https://huggingface.co/papers/2410.10629" rel="nofollow">SANA: Efficient High-Resolution Image Synthesis with Linear Diffusion Transformers</a> from NVIDIA and MIT HAN Lab, by Enze Xie, Junsong Chen, Junyu Chen, Han Cai, Haotian Tang, Yujun Lin, Zhekai Zhang, Muyang Li, Ligeng Zhu, Yao Lu, Song Han.',He,X,en="The abstract from the paper is:",Re,Y,tn="<em>We introduce Sana, a text-to-image framework that can efficiently generate images up to 4096×4096 resolution. Sana can synthesize high-resolution, high-quality images with strong text-image alignment at a remarkably fast speed, deployable on laptop GPU. Core designs include: (1) Deep compression autoencoder: unlike traditional AEs, which compress images only 8×, we trained an AE that can compress images 32×, effectively reducing the number of latent tokens. (2) Linear DiT: we replace all vanilla attention in DiT with linear attention, which is more efficient at high resolutions without sacrificing quality. (3) Decoder-only text encoder: we replaced T5 with modern decoder-only small LLM as the text encoder and designed complex human instruction with in-context learning to enhance the image-text alignment. (4) Efficient training and sampling: we propose Flow-DPM-Solver to reduce sampling steps, with efficient caption labeling and selection to accelerate convergence. As a result, Sana-0.6B is very competitive with modern giant diffusion model (e.g. Flux-12B), being 20 times smaller and 100+ times faster in measured throughput. Moreover, Sana-0.6B can be deployed on a 16GB laptop GPU, taking less than 1 second to generate a 1024×1024 resolution image. Sana enables content creation at low cost. Code and model will be publicly released.</em>",De,A,ze,Q,nn='This pipeline was contributed by <a href="https://github.com/lawrence-cj" rel="nofollow">lawrence-cj</a> and <a href="https://github.com/chenjy2003" rel="nofollow">chenjy2003</a>. The original codebase can be found <a href="https://github.com/NVlabs/Sana" rel="nofollow">here</a>. The original weights can be found under <a href="https://huggingface.co/Efficient-Large-Model" rel="nofollow">hf.co/Efficient-Large-Model</a>.',Xe,O,an="Available models:",Ye,K,on='<thead><tr><th align="center">Model</th> <th align="center">Recommended dtype</th></tr></thead> <tbody><tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_1600M_1024px_BF16_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_1600M_1024px_BF16_diffusers</code></a></td> <td align="center"><code>torch.bfloat16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_1600M_1024px_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_1600M_1024px_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_1600M_1024px_MultiLing_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_1600M_1024px_MultiLing_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_1600M_512px_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_1600M_512px_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_1600M_512px_MultiLing_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_1600M_512px_MultiLing_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_600M_1024px_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_600M_1024px_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Efficient-Large-Model/Sana_600M_512px_diffusers" rel="nofollow"><code>Efficient-Large-Model/Sana_600M_512px_diffusers</code></a></td> <td align="center"><code>torch.float16</code></td></tr></tbody>',Qe,ee,sn='Refer to <a href="https://huggingface.co/collections/Efficient-Large-Model/sana-673efba2a57ed99843f11f9e" rel="nofollow">this</a> collection for more information.',Oe,te,rn="Note: The recommended dtype mentioned is for the transformer weights. The text encoder and VAE weights must stay in <code>torch.bfloat16</code> or <code>torch.float32</code> for the model to work correctly. Please refer to the inference example below to see how to load the model with the recommended dtype.",Ke,E,et,ne,tt,ae,ln="Quantization helps reduce the memory requirements of very large models by storing model weights in a lower precision data type. However, quantization may have varying impact on video quality depending on the video model.",nt,oe,pn='Refer to the <a href="../../quantization/overview">Quantization</a> overview to learn more about supported quantization backends and selecting a quantization backend that supports your use case. The example below demonstrates how to load a quantized <a href="/docs/diffusers/pr_10037/en/api/pipelines/sana#diffusers.SanaPipeline">SanaPipeline</a> for inference with bitsandbytes.',at,ie,ot,se,it,y,re,Mt,Se,dn='Pipeline for text-to-image generation using <a href="https://huggingface.co/papers/2410.10629" rel="nofollow">Sana</a>.',Tt,J,le,Pt,Ie,cn="Function invoked when calling the pipeline for generation.",$t,j,St,Z,pe,It,ke,mn=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,kt,B,de,Ct,Ce,gn=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Jt,q,ce,Ut,Je,un=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Gt,N,me,Lt,Ue,fn=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,At,V,ge,Et,Ge,_n="Encodes the prompt into text encoder hidden states.",st,ue,rt,w,fe,jt,Le,hn=`Pipeline for text-to-image generation using <a href="https://huggingface.co/papers/2410.10629" rel="nofollow">Sana</a>. This pipeline
supports the use of <a href="https://huggingface.co/docs/diffusers/main/en/using-diffusers/pag" rel="nofollow">Perturbed Attention Guidance
(PAG)</a>.`,Zt,U,_e,Bt,Ae,bn="Function invoked when calling the pipeline for generation.",qt,F,Nt,W,he,Vt,Ee,vn=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ft,H,be,Wt,je,yn=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ht,R,ve,Rt,Ze,wn=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Dt,D,ye,zt,Be,xn=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Xt,z,we,Yt,qe,Mn="Encodes the prompt into text encoder hidden states.",lt,xe,pt,G,Me,Qt,Ne,Tn="Output class for Sana pipelines.",dt,Te,ct,Fe,mt;return M=new We({props:{title:"SanaPipeline",local:"sanapipeline",headingTag:"h1"}}),A=new Pn({props:{$$slots:{default:[Gn]},$$scope:{ctx:C}}}),E=new Pn({props:{$$slots:{default:[Ln]},$$scope:{ctx:C}}}),ne=new We({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),ie=new Ot({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWclMkMlMjBTYW5hVHJhbnNmb3JtZXIyRE1vZGVsJTJDJTIwU2FuYVBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTJDJTIwQXV0b01vZGVsJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBdGV4dF9lbmNvZGVyXzhiaXQlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkVmZmljaWVudC1MYXJnZS1Nb2RlbCUyRlNhbmFfMTYwME1fMTAyNHB4X2RpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2RlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBdHJhbnNmb3JtZXJfOGJpdCUyMCUzRCUyMFNhbmFUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkVmZmljaWVudC1MYXJnZS1Nb2RlbCUyRlNhbmFfMTYwME1fMTAyNHB4X2RpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFwaXBlbGluZSUyMCUzRCUyMFNhbmFQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyRWZmaWNpZW50LUxhcmdlLU1vZGVsJTJGU2FuYV8xNjAwTV8xMDI0cHhfZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyJTNEdGV4dF9lbmNvZGVyXzhiaXQlMkMlMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1lciUzRHRyYW5zZm9ybWVyXzhiaXQlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYmFsYW5jZWQlMjIlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHRpbnklMjBhc3Ryb25hdXQlMjBoYXRjaGluZyUyMGZyb20lMjBhbiUyMGVnZyUyMG9uJTIwdGhlJTIwbW9vbiUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJzYW5hLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig, SanaTransformer2DModel, SanaPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> BitsAndBytesConfig, AutoModel

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
text_encoder_8bit = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;Efficient-Large-Model/Sana_1600M_1024px_diffusers&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
transformer_8bit = SanaTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;Efficient-Large-Model/Sana_1600M_1024px_diffusers&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

pipeline = SanaPipeline.from_pretrained(
    <span class="hljs-string">&quot;Efficient-Large-Model/Sana_1600M_1024px_diffusers&quot;</span>,
    text_encoder=text_encoder_8bit,
    transformer=transformer_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
)

prompt = <span class="hljs-string">&quot;a tiny astronaut hatching from an egg on the moon&quot;</span>
image = pipeline(prompt).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sana.png&quot;</span>)`,wrap:!1}}),se=new We({props:{title:"SanaPipeline",local:"diffusers.SanaPipeline",headingTag:"h2"}}),re=new k({props:{name:"class diffusers.SanaPipeline",anchor:"diffusers.SanaPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": AutoModelForCausalLM"},{name:"vae",val:": AutoencoderDC"},{name:"transformer",val:": SanaTransformer2DModel"},{name:"scheduler",val:": DPMSolverMultistepScheduler"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/sana/pipeline_sana.py#L188"}}),le=new k({props:{name:"__call__",anchor:"diffusers.SanaPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": str = ''"},{name:"num_inference_steps",val:": int = 20"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"guidance_scale",val:": float = 4.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"height",val:": int = 1024"},{name:"width",val:": int = 1024"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"clean_caption",val:": bool = False"},{name:"use_resolution_binning",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 300"},{name:"complex_human_instruction",val:`: typing.List[str] = ["Given a user prompt, generate an 'Enhanced prompt' that provides detailed visual descriptions suitable for image generation. Evaluate the level of detail in the user prompt:", '- If the prompt is simple, focus on adding specifics about colors, shapes, sizes, textures, and spatial relationships to create vivid and concrete scenes.', '- If the prompt is already detailed, refine and enhance the existing details slightly without overcomplicating.', 'Here are examples of how to transform or refine prompts:', '- User Prompt: A cat sleeping -> Enhanced: A small, fluffy white cat curled up in a round shape, sleeping peacefully on a warm sunny windowsill, surrounded by pots of blooming red flowers.', '- User Prompt: A busy city street -> Enhanced: A bustling city street scene at dusk, featuring glowing street lamps, a diverse crowd of people in colorful clothing, and a double-decker bus passing by towering glass skyscrapers.', 'Please generate only the enhanced description for the prompt below and avoid including any additional commentary or evaluations:', 'User Prompt: ']`}],parametersDescription:[{anchor:"diffusers.SanaPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.SanaPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SanaPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.SanaPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.SanaPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.SanaPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.SanaPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.SanaPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.SanaPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.SanaPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/pr_10037/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.SanaPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.SanaPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.SanaPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SanaPipeline.__call__.prompt_attention_mask",description:"<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014; Pre-generated attention mask for text embeddings.",name:"prompt_attention_mask"},{anchor:"diffusers.SanaPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SanaPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.SanaPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.SanaPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.IFPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.SanaPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.SanaPipeline.__call__.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the caption before creating embeddings. Requires <code>beautifulsoup4</code> and <code>ftfy</code> to
be installed. If the dependencies are not installed, the embeddings will be created from the raw
prompt.`,name:"clean_caption"},{anchor:"diffusers.SanaPipeline.__call__.use_resolution_binning",description:`<strong>use_resolution_binning</strong> (<code>bool</code> defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, the requested height and width are first mapped to the closest resolutions using
<code>ASPECT_RATIO_1024_BIN</code>. After the produced latents are decoded into images, they are resized back to
the requested resolution. Useful for generating non-square images.`,name:"use_resolution_binning"},{anchor:"diffusers.SanaPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.SanaPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.SanaPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code> defaults to <code>300</code>) &#x2014;
Maximum sequence length to use with the <code>prompt</code>.`,name:"max_sequence_length"},{anchor:"diffusers.SanaPipeline.__call__.complex_human_instruction",description:`<strong>complex_human_instruction</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Instructions for complex human attention:
<a href="https://github.com/NVlabs/Sana/blob/main/configs/sana_app_config/Sana_1600M_app.yaml#L55" rel="nofollow">https://github.com/NVlabs/Sana/blob/main/configs/sana_app_config/Sana_1600M_app.yaml#L55</a>.`,name:"complex_human_instruction"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/sana/pipeline_sana.py#L672",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_10037/en/api/pipelines/sana#diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput"
>SanaPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10037/en/api/pipelines/sana#diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput"
>SanaPipelineOutput</a> or <code>tuple</code></p>
`}}),j=new $n({props:{anchor:"diffusers.SanaPipeline.__call__.example",$$slots:{default:[An]},$$scope:{ctx:C}}}),pe=new k({props:{name:"disable_vae_slicing",anchor:"diffusers.SanaPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/sana/pipeline_sana.py#L228"}}),de=new k({props:{name:"disable_vae_tiling",anchor:"diffusers.SanaPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/sana/pipeline_sana.py#L243"}}),ce=new k({props:{name:"enable_vae_slicing",anchor:"diffusers.SanaPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/sana/pipeline_sana.py#L221"}}),me=new k({props:{name:"enable_vae_tiling",anchor:"diffusers.SanaPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/sana/pipeline_sana.py#L235"}}),ge=new k({props:{name:"encode_prompt",anchor:"diffusers.SanaPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": str = ''"},{name:"num_images_per_prompt",val:": int = 1"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"clean_caption",val:": bool = False"},{name:"max_sequence_length",val:": int = 300"},{name:"complex_human_instruction",val:": typing.Optional[typing.List[str]] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.SanaPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.SanaPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. If not defined, one has to pass <code>negative_prompt_embeds</code>
instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is less than <code>1</code>). For
PixArt-Alpha, this should be &quot;&quot;.`,name:"negative_prompt"},{anchor:"diffusers.SanaPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.SanaPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.SanaPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device to place the resulting embeddings on`,name:"device"},{anchor:"diffusers.SanaPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SanaPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For Sana, it&#x2019;s should be the embeddings of the &quot;&quot; string.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SanaPipeline.encode_prompt.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the function will preprocess and clean the provided caption before encoding.`,name:"clean_caption"},{anchor:"diffusers.SanaPipeline.encode_prompt.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code>, defaults to 300) &#x2014; Maximum sequence length to use for the prompt.",name:"max_sequence_length"},{anchor:"diffusers.SanaPipeline.encode_prompt.complex_human_instruction",description:`<strong>complex_human_instruction</strong> (<code>list[str]</code>, defaults to <code>complex_human_instruction</code>) &#x2014;
If <code>complex_human_instruction</code> is not empty, the function will use the complex Human instruction for
the prompt.`,name:"complex_human_instruction"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/sana/pipeline_sana.py#L250"}}),ue=new We({props:{title:"SanaPAGPipeline",local:"diffusers.SanaPAGPipeline",headingTag:"h2"}}),fe=new k({props:{name:"class diffusers.SanaPAGPipeline",anchor:"diffusers.SanaPAGPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": AutoModelForCausalLM"},{name:"vae",val:": AutoencoderDC"},{name:"transformer",val:": SanaTransformer2DModel"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"pag_applied_layers",val:": typing.Union[str, typing.List[str]] = 'transformer_blocks.0'"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/pag/pipeline_pag_sana.py#L145"}}),_e=new k({props:{name:"__call__",anchor:"diffusers.SanaPAGPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": str = ''"},{name:"num_inference_steps",val:": int = 20"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"guidance_scale",val:": float = 4.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"height",val:": int = 1024"},{name:"width",val:": int = 1024"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"clean_caption",val:": bool = True"},{name:"use_resolution_binning",val:": bool = True"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 300"},{name:"complex_human_instruction",val:`: typing.List[str] = ["Given a user prompt, generate an 'Enhanced prompt' that provides detailed visual descriptions suitable for image generation. Evaluate the level of detail in the user prompt:", '- If the prompt is simple, focus on adding specifics about colors, shapes, sizes, textures, and spatial relationships to create vivid and concrete scenes.', '- If the prompt is already detailed, refine and enhance the existing details slightly without overcomplicating.', 'Here are examples of how to transform or refine prompts:', '- User Prompt: A cat sleeping -> Enhanced: A small, fluffy white cat curled up in a round shape, sleeping peacefully on a warm sunny windowsill, surrounded by pots of blooming red flowers.', '- User Prompt: A busy city street -> Enhanced: A bustling city street scene at dusk, featuring glowing street lamps, a diverse crowd of people in colorful clothing, and a double-decker bus passing by towering glass skyscrapers.', 'Please generate only the enhanced description for the prompt below and avoid including any additional commentary or evaluations:', 'User Prompt: ']`},{name:"pag_scale",val:": float = 3.0"},{name:"pag_adaptive_scale",val:": float = 0.0"}],parametersDescription:[{anchor:"diffusers.SanaPAGPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.SanaPAGPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.SanaPAGPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.SanaPAGPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.SanaPAGPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.SanaPAGPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.SanaPAGPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.SanaPAGPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.SanaPAGPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.SanaPAGPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/pr_10037/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.SanaPAGPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.SanaPAGPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.SanaPAGPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SanaPAGPipeline.__call__.prompt_attention_mask",description:"<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014; Pre-generated attention mask for text embeddings.",name:"prompt_attention_mask"},{anchor:"diffusers.SanaPAGPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SanaPAGPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.SanaPAGPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.SanaPAGPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.IFPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.SanaPAGPipeline.__call__.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the caption before creating embeddings. Requires <code>beautifulsoup4</code> and <code>ftfy</code> to
be installed. If the dependencies are not installed, the embeddings will be created from the raw
prompt.`,name:"clean_caption"},{anchor:"diffusers.SanaPAGPipeline.__call__.use_resolution_binning",description:`<strong>use_resolution_binning</strong> (<code>bool</code> defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, the requested height and width are first mapped to the closest resolutions using
<code>ASPECT_RATIO_1024_BIN</code>. After the produced latents are decoded into images, they are resized back to
the requested resolution. Useful for generating non-square images.`,name:"use_resolution_binning"},{anchor:"diffusers.SanaPAGPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.SanaPAGPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.SanaPAGPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 300) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"},{anchor:"diffusers.SanaPAGPipeline.__call__.complex_human_instruction",description:`<strong>complex_human_instruction</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Instructions for complex human attention:
<a href="https://github.com/NVlabs/Sana/blob/main/configs/sana_app_config/Sana_1600M_app.yaml#L55" rel="nofollow">https://github.com/NVlabs/Sana/blob/main/configs/sana_app_config/Sana_1600M_app.yaml#L55</a>.`,name:"complex_human_instruction"},{anchor:"diffusers.SanaPAGPipeline.__call__.pag_scale",description:`<strong>pag_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
The scale factor for the perturbed attention guidance. If it is set to 0.0, the perturbed attention
guidance will not be used.`,name:"pag_scale"},{anchor:"diffusers.SanaPAGPipeline.__call__.pag_adaptive_scale",description:`<strong>pag_adaptive_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The adaptive scale factor for the perturbed attention guidance. If it is set to 0.0, <code>pag_scale</code> is
used.`,name:"pag_adaptive_scale"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/pag/pipeline_pag_sana.py#L620",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/pr_10037/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_10037/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),F=new $n({props:{anchor:"diffusers.SanaPAGPipeline.__call__.example",$$slots:{default:[En]},$$scope:{ctx:C}}}),he=new k({props:{name:"disable_vae_slicing",anchor:"diffusers.SanaPAGPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/pag/pipeline_pag_sana.py#L193"}}),be=new k({props:{name:"disable_vae_tiling",anchor:"diffusers.SanaPAGPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/pag/pipeline_pag_sana.py#L208"}}),ve=new k({props:{name:"enable_vae_slicing",anchor:"diffusers.SanaPAGPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/pag/pipeline_pag_sana.py#L186"}}),ye=new k({props:{name:"enable_vae_tiling",anchor:"diffusers.SanaPAGPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/pag/pipeline_pag_sana.py#L200"}}),we=new k({props:{name:"encode_prompt",anchor:"diffusers.SanaPAGPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": str = ''"},{name:"num_images_per_prompt",val:": int = 1"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"clean_caption",val:": bool = False"},{name:"max_sequence_length",val:": int = 300"},{name:"complex_human_instruction",val:": typing.Optional[typing.List[str]] = None"}],parametersDescription:[{anchor:"diffusers.SanaPAGPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. If not defined, one has to pass <code>negative_prompt_embeds</code>
instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is less than <code>1</code>). For
PixArt-Alpha, this should be &quot;&quot;.`,name:"negative_prompt"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device to place the resulting embeddings on`,name:"device"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For Sana, it&#x2019;s should be the embeddings of the &quot;&quot; string.`,name:"negative_prompt_embeds"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.clean_caption",description:`<strong>clean_caption</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the function will preprocess and clean the provided caption before encoding.`,name:"clean_caption"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code>, defaults to 300) &#x2014; Maximum sequence length to use for the prompt.",name:"max_sequence_length"},{anchor:"diffusers.SanaPAGPipeline.encode_prompt.complex_human_instruction",description:`<strong>complex_human_instruction</strong> (<code>list[str]</code>, defaults to <code>complex_human_instruction</code>) &#x2014;
If <code>complex_human_instruction</code> is not empty, the function will use the complex Human instruction for
the prompt.`,name:"complex_human_instruction"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/pag/pipeline_pag_sana.py#L215"}}),xe=new We({props:{title:"SanaPipelineOutput",local:"diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput",headingTag:"h2"}}),Me=new k({props:{name:"class diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput",anchor:"diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or numpy array of shape <code>(batch_size, height, width, num_channels)</code>. PIL images or numpy array present the denoised images of the diffusion pipeline.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/vr_10037/src/diffusers/pipelines/sana/pipeline_output.py#L10"}}),Te=new Un({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/sana.md"}}),{c(){p=s("meta"),$=o(),b=s("p"),v=o(),m(M.$$.fragment),d=o(),I=s("p"),I.innerHTML=Kt,He=o(),X=s("p"),X.textContent=en,Re=o(),Y=s("p"),Y.innerHTML=tn,De=o(),m(A.$$.fragment),ze=o(),Q=s("p"),Q.innerHTML=nn,Xe=o(),O=s("p"),O.textContent=an,Ye=o(),K=s("table"),K.innerHTML=on,Qe=o(),ee=s("p"),ee.innerHTML=sn,Oe=o(),te=s("p"),te.innerHTML=rn,Ke=o(),m(E.$$.fragment),et=o(),m(ne.$$.fragment),tt=o(),ae=s("p"),ae.textContent=ln,nt=o(),oe=s("p"),oe.innerHTML=pn,at=o(),m(ie.$$.fragment),ot=o(),m(se.$$.fragment),it=o(),y=s("div"),m(re.$$.fragment),Mt=o(),Se=s("p"),Se.innerHTML=dn,Tt=o(),J=s("div"),m(le.$$.fragment),Pt=o(),Ie=s("p"),Ie.textContent=cn,$t=o(),m(j.$$.fragment),St=o(),Z=s("div"),m(pe.$$.fragment),It=o(),ke=s("p"),ke.innerHTML=mn,kt=o(),B=s("div"),m(de.$$.fragment),Ct=o(),Ce=s("p"),Ce.innerHTML=gn,Jt=o(),q=s("div"),m(ce.$$.fragment),Ut=o(),Je=s("p"),Je.textContent=un,Gt=o(),N=s("div"),m(me.$$.fragment),Lt=o(),Ue=s("p"),Ue.textContent=fn,At=o(),V=s("div"),m(ge.$$.fragment),Et=o(),Ge=s("p"),Ge.textContent=_n,st=o(),m(ue.$$.fragment),rt=o(),w=s("div"),m(fe.$$.fragment),jt=o(),Le=s("p"),Le.innerHTML=hn,Zt=o(),U=s("div"),m(_e.$$.fragment),Bt=o(),Ae=s("p"),Ae.textContent=bn,qt=o(),m(F.$$.fragment),Nt=o(),W=s("div"),m(he.$$.fragment),Vt=o(),Ee=s("p"),Ee.innerHTML=vn,Ft=o(),H=s("div"),m(be.$$.fragment),Wt=o(),je=s("p"),je.innerHTML=yn,Ht=o(),R=s("div"),m(ve.$$.fragment),Rt=o(),Ze=s("p"),Ze.textContent=wn,Dt=o(),D=s("div"),m(ye.$$.fragment),zt=o(),Be=s("p"),Be.textContent=xn,Xt=o(),z=s("div"),m(we.$$.fragment),Yt=o(),qe=s("p"),qe.textContent=Mn,lt=o(),m(xe.$$.fragment),pt=o(),G=s("div"),m(Me.$$.fragment),Qt=o(),Ne=s("p"),Ne.textContent=Tn,dt=o(),m(Te.$$.fragment),ct=o(),Fe=s("p"),this.h()},l(e){const n=Jn("svelte-u9bgzb",document.head);p=r(n,"META",{name:!0,content:!0}),n.forEach(t),$=i(e),b=r(e,"P",{}),T(b).forEach(t),v=i(e),g(M.$$.fragment,e),d=i(e),I=r(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-h8aibn"&&(I.innerHTML=Kt),He=i(e),X=r(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1cwsb16"&&(X.textContent=en),Re=i(e),Y=r(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1uh3w7a"&&(Y.innerHTML=tn),De=i(e),g(A.$$.fragment,e),ze=i(e),Q=r(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-1eg28j8"&&(Q.innerHTML=nn),Xe=i(e),O=r(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1bob28v"&&(O.textContent=an),Ye=i(e),K=r(e,"TABLE",{"data-svelte-h":!0}),c(K)!=="svelte-dcodwq"&&(K.innerHTML=on),Qe=i(e),ee=r(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1swlfqd"&&(ee.innerHTML=sn),Oe=i(e),te=r(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-okwwje"&&(te.innerHTML=rn),Ke=i(e),g(E.$$.fragment,e),et=i(e),g(ne.$$.fragment,e),tt=i(e),ae=r(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-1ou2pxc"&&(ae.textContent=ln),nt=i(e),oe=r(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-7lbppi"&&(oe.innerHTML=pn),at=i(e),g(ie.$$.fragment,e),ot=i(e),g(se.$$.fragment,e),it=i(e),y=r(e,"DIV",{class:!0});var x=T(y);g(re.$$.fragment,x),Mt=i(x),Se=r(x,"P",{"data-svelte-h":!0}),c(Se)!=="svelte-1ot17tf"&&(Se.innerHTML=dn),Tt=i(x),J=r(x,"DIV",{class:!0});var L=T(J);g(le.$$.fragment,L),Pt=i(L),Ie=r(L,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-v78lg8"&&(Ie.textContent=cn),$t=i(L),g(j.$$.fragment,L),L.forEach(t),St=i(x),Z=r(x,"DIV",{class:!0});var Pe=T(Z);g(pe.$$.fragment,Pe),It=i(Pe),ke=r(Pe,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-1s3c06i"&&(ke.innerHTML=mn),Pe.forEach(t),kt=i(x),B=r(x,"DIV",{class:!0});var $e=T(B);g(de.$$.fragment,$e),Ct=i($e),Ce=r($e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-pkn4ui"&&(Ce.innerHTML=gn),$e.forEach(t),Jt=i(x),q=r(x,"DIV",{class:!0});var gt=T(q);g(ce.$$.fragment,gt),Ut=i(gt),Je=r(gt,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-14bnrb6"&&(Je.textContent=un),gt.forEach(t),Gt=i(x),N=r(x,"DIV",{class:!0});var ut=T(N);g(me.$$.fragment,ut),Lt=i(ut),Ue=r(ut,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-1xwrf7t"&&(Ue.textContent=fn),ut.forEach(t),At=i(x),V=r(x,"DIV",{class:!0});var ft=T(V);g(ge.$$.fragment,ft),Et=i(ft),Ge=r(ft,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-16q0ax1"&&(Ge.textContent=_n),ft.forEach(t),x.forEach(t),st=i(e),g(ue.$$.fragment,e),rt=i(e),w=r(e,"DIV",{class:!0});var S=T(w);g(fe.$$.fragment,S),jt=i(S),Le=r(S,"P",{"data-svelte-h":!0}),c(Le)!=="svelte-vrq74s"&&(Le.innerHTML=hn),Zt=i(S),U=r(S,"DIV",{class:!0});var Ve=T(U);g(_e.$$.fragment,Ve),Bt=i(Ve),Ae=r(Ve,"P",{"data-svelte-h":!0}),c(Ae)!=="svelte-v78lg8"&&(Ae.textContent=bn),qt=i(Ve),g(F.$$.fragment,Ve),Ve.forEach(t),Nt=i(S),W=r(S,"DIV",{class:!0});var _t=T(W);g(he.$$.fragment,_t),Vt=i(_t),Ee=r(_t,"P",{"data-svelte-h":!0}),c(Ee)!=="svelte-1s3c06i"&&(Ee.innerHTML=vn),_t.forEach(t),Ft=i(S),H=r(S,"DIV",{class:!0});var ht=T(H);g(be.$$.fragment,ht),Wt=i(ht),je=r(ht,"P",{"data-svelte-h":!0}),c(je)!=="svelte-pkn4ui"&&(je.innerHTML=yn),ht.forEach(t),Ht=i(S),R=r(S,"DIV",{class:!0});var bt=T(R);g(ve.$$.fragment,bt),Rt=i(bt),Ze=r(bt,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-14bnrb6"&&(Ze.textContent=wn),bt.forEach(t),Dt=i(S),D=r(S,"DIV",{class:!0});var vt=T(D);g(ye.$$.fragment,vt),zt=i(vt),Be=r(vt,"P",{"data-svelte-h":!0}),c(Be)!=="svelte-1xwrf7t"&&(Be.textContent=xn),vt.forEach(t),Xt=i(S),z=r(S,"DIV",{class:!0});var yt=T(z);g(we.$$.fragment,yt),Yt=i(yt),qe=r(yt,"P",{"data-svelte-h":!0}),c(qe)!=="svelte-16q0ax1"&&(qe.textContent=Mn),yt.forEach(t),S.forEach(t),lt=i(e),g(xe.$$.fragment,e),pt=i(e),G=r(e,"DIV",{class:!0});var wt=T(G);g(Me.$$.fragment,wt),Qt=i(wt),Ne=r(wt,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-1h3n85u"&&(Ne.textContent=Tn),wt.forEach(t),dt=i(e),g(Te.$$.fragment,e),ct=i(e),Fe=r(e,"P",{}),T(Fe).forEach(t),this.h()},h(){P(p,"name","hf:doc:metadata"),P(p,"content",Zn),P(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),P(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){a(document.head,p),l(e,$,n),l(e,b,n),l(e,v,n),u(M,e,n),l(e,d,n),l(e,I,n),l(e,He,n),l(e,X,n),l(e,Re,n),l(e,Y,n),l(e,De,n),u(A,e,n),l(e,ze,n),l(e,Q,n),l(e,Xe,n),l(e,O,n),l(e,Ye,n),l(e,K,n),l(e,Qe,n),l(e,ee,n),l(e,Oe,n),l(e,te,n),l(e,Ke,n),u(E,e,n),l(e,et,n),u(ne,e,n),l(e,tt,n),l(e,ae,n),l(e,nt,n),l(e,oe,n),l(e,at,n),u(ie,e,n),l(e,ot,n),u(se,e,n),l(e,it,n),l(e,y,n),u(re,y,null),a(y,Mt),a(y,Se),a(y,Tt),a(y,J),u(le,J,null),a(J,Pt),a(J,Ie),a(J,$t),u(j,J,null),a(y,St),a(y,Z),u(pe,Z,null),a(Z,It),a(Z,ke),a(y,kt),a(y,B),u(de,B,null),a(B,Ct),a(B,Ce),a(y,Jt),a(y,q),u(ce,q,null),a(q,Ut),a(q,Je),a(y,Gt),a(y,N),u(me,N,null),a(N,Lt),a(N,Ue),a(y,At),a(y,V),u(ge,V,null),a(V,Et),a(V,Ge),l(e,st,n),u(ue,e,n),l(e,rt,n),l(e,w,n),u(fe,w,null),a(w,jt),a(w,Le),a(w,Zt),a(w,U),u(_e,U,null),a(U,Bt),a(U,Ae),a(U,qt),u(F,U,null),a(w,Nt),a(w,W),u(he,W,null),a(W,Vt),a(W,Ee),a(w,Ft),a(w,H),u(be,H,null),a(H,Wt),a(H,je),a(w,Ht),a(w,R),u(ve,R,null),a(R,Rt),a(R,Ze),a(w,Dt),a(w,D),u(ye,D,null),a(D,zt),a(D,Be),a(w,Xt),a(w,z),u(we,z,null),a(z,Yt),a(z,qe),l(e,lt,n),u(xe,e,n),l(e,pt,n),l(e,G,n),u(Me,G,null),a(G,Qt),a(G,Ne),l(e,dt,n),u(Te,e,n),l(e,ct,n),l(e,Fe,n),mt=!0},p(e,[n]){const x={};n&2&&(x.$$scope={dirty:n,ctx:e}),A.$set(x);const L={};n&2&&(L.$$scope={dirty:n,ctx:e}),E.$set(L);const Pe={};n&2&&(Pe.$$scope={dirty:n,ctx:e}),j.$set(Pe);const $e={};n&2&&($e.$$scope={dirty:n,ctx:e}),F.$set($e)},i(e){mt||(f(M.$$.fragment,e),f(A.$$.fragment,e),f(E.$$.fragment,e),f(ne.$$.fragment,e),f(ie.$$.fragment,e),f(se.$$.fragment,e),f(re.$$.fragment,e),f(le.$$.fragment,e),f(j.$$.fragment,e),f(pe.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(me.$$.fragment,e),f(ge.$$.fragment,e),f(ue.$$.fragment,e),f(fe.$$.fragment,e),f(_e.$$.fragment,e),f(F.$$.fragment,e),f(he.$$.fragment,e),f(be.$$.fragment,e),f(ve.$$.fragment,e),f(ye.$$.fragment,e),f(we.$$.fragment,e),f(xe.$$.fragment,e),f(Me.$$.fragment,e),f(Te.$$.fragment,e),mt=!0)},o(e){_(M.$$.fragment,e),_(A.$$.fragment,e),_(E.$$.fragment,e),_(ne.$$.fragment,e),_(ie.$$.fragment,e),_(se.$$.fragment,e),_(re.$$.fragment,e),_(le.$$.fragment,e),_(j.$$.fragment,e),_(pe.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(ge.$$.fragment,e),_(ue.$$.fragment,e),_(fe.$$.fragment,e),_(_e.$$.fragment,e),_(F.$$.fragment,e),_(he.$$.fragment,e),_(be.$$.fragment,e),_(ve.$$.fragment,e),_(ye.$$.fragment,e),_(we.$$.fragment,e),_(xe.$$.fragment,e),_(Me.$$.fragment,e),_(Te.$$.fragment,e),mt=!1},d(e){e&&(t($),t(b),t(v),t(d),t(I),t(He),t(X),t(Re),t(Y),t(De),t(ze),t(Q),t(Xe),t(O),t(Ye),t(K),t(Qe),t(ee),t(Oe),t(te),t(Ke),t(et),t(tt),t(ae),t(nt),t(oe),t(at),t(ot),t(it),t(y),t(st),t(rt),t(w),t(lt),t(pt),t(G),t(dt),t(ct),t(Fe)),t(p),h(M,e),h(A,e),h(E,e),h(ne,e),h(ie,e),h(se,e),h(re),h(le),h(j),h(pe),h(de),h(ce),h(me),h(ge),h(ue,e),h(fe),h(_e),h(F),h(he),h(be),h(ve),h(ye),h(we),h(xe,e),h(Me),h(Te,e)}}}const Zn='{"title":"SanaPipeline","local":"sanapipeline","sections":[{"title":"Quantization","local":"quantization","sections":[],"depth":2},{"title":"SanaPipeline","local":"diffusers.SanaPipeline","sections":[],"depth":2},{"title":"SanaPAGPipeline","local":"diffusers.SanaPAGPipeline","sections":[],"depth":2},{"title":"SanaPipelineOutput","local":"diffusers.pipelines.sana.pipeline_output.SanaPipelineOutput","sections":[],"depth":2}],"depth":1}';function Bn(C){return In(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dn extends kn{constructor(p){super(),Cn(this,p,Bn,jn,Sn,{})}}export{Dn as component};
