import{s as qe,n as Ee,o as Qe}from"../chunks/scheduler.defa9a21.js";import{S as Se,i as We,g as s,s as i,r as c,A as Ne,h as r,f as a,c as l,j as Ye,u as p,x as o,k as Ie,y as Ke,a as n,v as m,d,t as u,w as h}from"../chunks/index.fe795e71.js";import{C as ve}from"../chunks/CodeBlock.42404125.js";import{H as I,E as Oe}from"../chunks/EditOnGithub.0f575778.js";function De(je){let f,Q,q,S,g,W,w,Ue='🤗 Accelerate provides integrations to train on lower precision methods using specified supported hardware through the <code>TransformersEngine</code> and <code>MS-AMP</code> packages. This documentation will help guide you through what hardware is supported, how to configure your <a href="/docs/accelerate/pr_2935/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> to leverage the low precision methods, and what you can expect when training.',N,y,K,M,_e='To explore more of the nitty-gritty in training in FP8 with PyTorch and 🤗 Accelerate, check out the <a href="../concept_guides/low_precision_training.md">concept_guide</a> on why this can be difficult. But essentially rather than training in BF16, some (or all) aspects of training a model can be performed using 8 bits instead of 16. The challenge is doing so without degrading final performance.',O,T,Pe="This is only enabled on specific NVIDIA hardware, namely:",D,b,Ce="<li>Anything after the 3000 series consumer graphics cards (such as the 4090)</li> <li>Hopper-based GPU architectures (such as the <code>H100</code> and <code>H200</code>)</li>",ee,$,ke="What this will result in is some gain in the memory used (as we’ve cut the needed memory in half for some parts of training) and an increase in throughput <em>should</em> be seen as well for larger models that can replace certain layers with FP8-enabled ones.",te,J,ae,v,xe="Currently two different backends for FP8 are supported (<code>TransformersEngine</code> and <code>MS-AMP</code>), each with different capabilities and configurations.",ne,j,Ae='To use either, the same core API is used. Just pass <code>mixed_precision=&quot;fp8&quot;</code> to either the <a href="/docs/accelerate/pr_2935/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>, during <code>accelerate config</code> when prompted about mixed precision, or as part of your <code>config.yaml</code> file in the <code>mixed_precision</code> key:',ie,U,le,_,ze='By default, if <code>MS-AMP</code> is available in your environment, 🤗 Accelerate will automatically utilize it as a backend. To specify it yourself (and customize other parts of the FP8 mixed precision setup), you can utilize the <a href="/docs/accelerate/pr_2935/en/package_reference/kwargs#accelerate.utils.FP8RecipeKwargs">utils.FP8RecipeKwargs</a>:',se,P,re,C,oe,k,Be="Of the two, <code>MS-AMP</code> is traditionally the easier one to configure as there is only a single argument: the optimization level.",ce,x,Ge="Currently two levels of optimization are supported in the 🤗 Accelerate integration, <code>&quot;O1&quot;</code> and <code>&quot;O2&quot;</code> (using the letter ‘o’, not zero).",pe,A,Fe="<li><code>&quot;O1&quot;</code> will cast the weight gradients and <code>all_reduce</code> communications to happen in 8-bit, while the rest are done in 16 bit. This reduces the general GPU memory usage and speeds up communication bandwidths.</li> <li><code>&quot;O2&quot;</code> will also cast first-order optimizer states into 8 bit, while the second order states are in FP16. (Currently just the <code>Adam</code> optimizer is supported). This tries its best to minimize final accuracy degradation and will save the highest potential memory.</li>",me,z,Re="To specify an optimization level, pass it to the <code>FP8KwargsHandler</code> by setting the <code>optimization_level</code> argument:",de,B,ue,G,he,F,He='TransformersEngine has much more available for customizing how and what FP8 calculations are performed. A full list of supported arguments and what they mean are available in <a href="https://docs.nvidia.com/deeplearning/transformer-engine/user-guide/api/common.html" rel="nofollow">NVIDIA’s documentation</a>, however they are restated as part of <code>FP8KwargsHandler</code>’s docstring for your convenience.',fe,R,Le="🤗 Accelerate tries to set sensible defaults, but exploring and tweaking the various parameters yourself can lead to better performance potentially.",ge,H,Ve="To use it, specify <code>backend=&quot;te&quot;</code> and modify any of the arguments you want as part of your kwarg handler:",we,L,ye,V,Me,Z,Ze="To learn more about training in FP8 please check out the following resources:",Te,X,Xe='<li><a href="../concept_guides/low_precision_training.md">Our concept guide</a> detailing into more about both TransformersEngine and MS-AMP</li> <li><a href="https://docs.nvidia.com/deeplearning/transformer-engine/user-guide/api/common.html" rel="nofollow">The <code>transformers-engine</code> documentation</a></li> <li><a href="https://azure.github.io/MS-AMP/docs/" rel="nofollow">The <code>MS-AMP</code> documentation</a></li>',be,Y,$e,E,Je;return g=new I({props:{title:"Low Precision Training Methods",local:"low-precision-training-methods",headingTag:"h1"}}),y=new I({props:{title:"What training on FP8 means",local:"what-training-on-fp8-means",headingTag:"h2"}}),J=new I({props:{title:"Configuring the Accelerator",local:"configuring-the-accelerator",headingTag:"h2"}}),U=new ve({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnA4JTIyKQ==",highlighted:`from accelerate import Accelerator
<span class="hljs-attribute">accelerator</span> <span class="hljs-operator">=</span> Accelerator(mixed_precision<span class="hljs-operator">=</span><span class="hljs-string">&quot;fp8&quot;</span>)`,wrap:!1}}),P=new ve({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwRlA4UmVjaXBlS3dhcmdzJTBBa3dhcmdzJTIwJTNEJTIwJTVCRlA4UmVjaXBlS3dhcmdzKGJhY2tlbmQlM0QlMjJtc2FtcCUyMiklNUQlMEElMjMlMjBPciUyMHRvJTIwc3BlY2lmeSUyMHRoZSUyMGJhY2tlbmQlMjBhcyUyMCU2MFRyYW5zZm9ybWVyc0VuZ2luZSU2MCUyMGV2ZW4lMjBpZiUyME1TLUFNUCUyMGlzJTIwaW5zdGFsbGVkJTBBJTIzJTIwa3dhcmdzJTIwJTNEJTIwJTVCRlA4UmVjaXBlS3dhcmdzKGJhY2tlbmQlM0QlMjJ0ZSUyMiklNUQlMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKG1peGVkX3ByZWNpc2lvbiUzRCUyMmZwOCUyMiUyQyUyMGt3YXJnX2hhbmRsZXJzJTNEa3dhcmdzKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import FP8RecipeKwargs
kwargs = [FP8RecipeKwargs(<span class="hljs-attribute">backend</span>=<span class="hljs-string">&quot;msamp&quot;</span>)]
<span class="hljs-comment"># Or to specify the backend as \`TransformersEngine\` even if MS-AMP is installed</span>
<span class="hljs-comment"># kwargs = [FP8RecipeKwargs(backend=&quot;te&quot;)]</span>
accelerator = Accelerator(<span class="hljs-attribute">mixed_precision</span>=<span class="hljs-string">&quot;fp8&quot;</span>, <span class="hljs-attribute">kwarg_handlers</span>=kwargs)`,wrap:!1}}),C=new I({props:{title:"Configuring MS-AMP",local:"configuring-ms-amp",headingTag:"h2"}}),B=new ve({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwRlA4UmVjaXBlS3dhcmdzJTBBa3dhcmdzJTIwJTNEJTIwJTVCRlA4UmVjaXBlS3dhcmdzKGJhY2tlbmQlM0QlMjJtc2FtcCUyMiUyQyUyMG9wdGltaXphdGlvbl9sZXZlbCUzRCUyMk8yJTIyKSU1RCUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnA4JTIyJTJDJTIwa3dhcmdfaGFuZGxlcnMlM0Rrd2FyZ3Mp",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import FP8RecipeKwargs
kwargs = [FP8RecipeKwargs(<span class="hljs-attribute">backend</span>=<span class="hljs-string">&quot;msamp&quot;</span>, <span class="hljs-attribute">optimization_level</span>=<span class="hljs-string">&quot;O2&quot;</span>)]
accelerator = Accelerator(<span class="hljs-attribute">mixed_precision</span>=<span class="hljs-string">&quot;fp8&quot;</span>, <span class="hljs-attribute">kwarg_handlers</span>=kwargs)`,wrap:!1}}),G=new I({props:{title:"Configuring TransformersEngine",local:"configuring-transformersengine",headingTag:"h2"}}),L=new ve({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwRlA4UmVjaXBlS3dhcmdzJTBBa3dhcmdzJTIwJTNEJTIwJTVCRlA4UmVjaXBlS3dhcmdzKGJhY2tlbmQlM0QlMjJ0ZSUyMiUyQyUyMC4uLiklNUQlMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKG1peGVkX3ByZWNpc2lvbiUzRCUyMmZwOCUyMiUyQyUyMGt3YXJnX2hhbmRsZXJzJTNEa3dhcmdzKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import FP8RecipeKwargs
kwargs = [FP8RecipeKwargs(<span class="hljs-attribute">backend</span>=<span class="hljs-string">&quot;te&quot;</span>, <span class="hljs-built_in">..</span>.)]
accelerator = Accelerator(<span class="hljs-attribute">mixed_precision</span>=<span class="hljs-string">&quot;fp8&quot;</span>, <span class="hljs-attribute">kwarg_handlers</span>=kwargs)`,wrap:!1}}),V=new I({props:{title:"Further Reading",local:"further-reading",headingTag:"h2"}}),Y=new Oe({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/usage_guides/low_precision_training.md"}}),{c(){f=s("meta"),Q=i(),q=s("p"),S=i(),c(g.$$.fragment),W=i(),w=s("p"),w.innerHTML=Ue,N=i(),c(y.$$.fragment),K=i(),M=s("p"),M.innerHTML=_e,O=i(),T=s("p"),T.textContent=Pe,D=i(),b=s("ul"),b.innerHTML=Ce,ee=i(),$=s("p"),$.innerHTML=ke,te=i(),c(J.$$.fragment),ae=i(),v=s("p"),v.innerHTML=xe,ne=i(),j=s("p"),j.innerHTML=Ae,ie=i(),c(U.$$.fragment),le=i(),_=s("p"),_.innerHTML=ze,se=i(),c(P.$$.fragment),re=i(),c(C.$$.fragment),oe=i(),k=s("p"),k.innerHTML=Be,ce=i(),x=s("p"),x.innerHTML=Ge,pe=i(),A=s("ul"),A.innerHTML=Fe,me=i(),z=s("p"),z.innerHTML=Re,de=i(),c(B.$$.fragment),ue=i(),c(G.$$.fragment),he=i(),F=s("p"),F.innerHTML=He,fe=i(),R=s("p"),R.textContent=Le,ge=i(),H=s("p"),H.innerHTML=Ve,we=i(),c(L.$$.fragment),ye=i(),c(V.$$.fragment),Me=i(),Z=s("p"),Z.textContent=Ze,Te=i(),X=s("ul"),X.innerHTML=Xe,be=i(),c(Y.$$.fragment),$e=i(),E=s("p"),this.h()},l(e){const t=Ne("svelte-u9bgzb",document.head);f=r(t,"META",{name:!0,content:!0}),t.forEach(a),Q=l(e),q=r(e,"P",{}),Ye(q).forEach(a),S=l(e),p(g.$$.fragment,e),W=l(e),w=r(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1tfloed"&&(w.innerHTML=Ue),N=l(e),p(y.$$.fragment,e),K=l(e),M=r(e,"P",{"data-svelte-h":!0}),o(M)!=="svelte-1hhkoyk"&&(M.innerHTML=_e),O=l(e),T=r(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-10cwb11"&&(T.textContent=Pe),D=l(e),b=r(e,"UL",{"data-svelte-h":!0}),o(b)!=="svelte-5d1df8"&&(b.innerHTML=Ce),ee=l(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1j45xey"&&($.innerHTML=ke),te=l(e),p(J.$$.fragment,e),ae=l(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-ewzxpg"&&(v.innerHTML=xe),ne=l(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-b77u4l"&&(j.innerHTML=Ae),ie=l(e),p(U.$$.fragment,e),le=l(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-rxqfs4"&&(_.innerHTML=ze),se=l(e),p(P.$$.fragment,e),re=l(e),p(C.$$.fragment,e),oe=l(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-13jlsqr"&&(k.innerHTML=Be),ce=l(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-11lh24s"&&(x.innerHTML=Ge),pe=l(e),A=r(e,"UL",{"data-svelte-h":!0}),o(A)!=="svelte-ha185h"&&(A.innerHTML=Fe),me=l(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-wx6vs8"&&(z.innerHTML=Re),de=l(e),p(B.$$.fragment,e),ue=l(e),p(G.$$.fragment,e),he=l(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-ngle0n"&&(F.innerHTML=He),fe=l(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-18df25g"&&(R.textContent=Le),ge=l(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-8khoko"&&(H.innerHTML=Ve),we=l(e),p(L.$$.fragment,e),ye=l(e),p(V.$$.fragment,e),Me=l(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-t5s4ol"&&(Z.textContent=Ze),Te=l(e),X=r(e,"UL",{"data-svelte-h":!0}),o(X)!=="svelte-lri330"&&(X.innerHTML=Xe),be=l(e),p(Y.$$.fragment,e),$e=l(e),E=r(e,"P",{}),Ye(E).forEach(a),this.h()},h(){Ie(f,"name","hf:doc:metadata"),Ie(f,"content",et)},m(e,t){Ke(document.head,f),n(e,Q,t),n(e,q,t),n(e,S,t),m(g,e,t),n(e,W,t),n(e,w,t),n(e,N,t),m(y,e,t),n(e,K,t),n(e,M,t),n(e,O,t),n(e,T,t),n(e,D,t),n(e,b,t),n(e,ee,t),n(e,$,t),n(e,te,t),m(J,e,t),n(e,ae,t),n(e,v,t),n(e,ne,t),n(e,j,t),n(e,ie,t),m(U,e,t),n(e,le,t),n(e,_,t),n(e,se,t),m(P,e,t),n(e,re,t),m(C,e,t),n(e,oe,t),n(e,k,t),n(e,ce,t),n(e,x,t),n(e,pe,t),n(e,A,t),n(e,me,t),n(e,z,t),n(e,de,t),m(B,e,t),n(e,ue,t),m(G,e,t),n(e,he,t),n(e,F,t),n(e,fe,t),n(e,R,t),n(e,ge,t),n(e,H,t),n(e,we,t),m(L,e,t),n(e,ye,t),m(V,e,t),n(e,Me,t),n(e,Z,t),n(e,Te,t),n(e,X,t),n(e,be,t),m(Y,e,t),n(e,$e,t),n(e,E,t),Je=!0},p:Ee,i(e){Je||(d(g.$$.fragment,e),d(y.$$.fragment,e),d(J.$$.fragment,e),d(U.$$.fragment,e),d(P.$$.fragment,e),d(C.$$.fragment,e),d(B.$$.fragment,e),d(G.$$.fragment,e),d(L.$$.fragment,e),d(V.$$.fragment,e),d(Y.$$.fragment,e),Je=!0)},o(e){u(g.$$.fragment,e),u(y.$$.fragment,e),u(J.$$.fragment,e),u(U.$$.fragment,e),u(P.$$.fragment,e),u(C.$$.fragment,e),u(B.$$.fragment,e),u(G.$$.fragment,e),u(L.$$.fragment,e),u(V.$$.fragment,e),u(Y.$$.fragment,e),Je=!1},d(e){e&&(a(Q),a(q),a(S),a(W),a(w),a(N),a(K),a(M),a(O),a(T),a(D),a(b),a(ee),a($),a(te),a(ae),a(v),a(ne),a(j),a(ie),a(le),a(_),a(se),a(re),a(oe),a(k),a(ce),a(x),a(pe),a(A),a(me),a(z),a(de),a(ue),a(he),a(F),a(fe),a(R),a(ge),a(H),a(we),a(ye),a(Me),a(Z),a(Te),a(X),a(be),a($e),a(E)),a(f),h(g,e),h(y,e),h(J,e),h(U,e),h(P,e),h(C,e),h(B,e),h(G,e),h(L,e),h(V,e),h(Y,e)}}}const et='{"title":"Low Precision Training Methods","local":"low-precision-training-methods","sections":[{"title":"What training on FP8 means","local":"what-training-on-fp8-means","sections":[],"depth":2},{"title":"Configuring the Accelerator","local":"configuring-the-accelerator","sections":[],"depth":2},{"title":"Configuring MS-AMP","local":"configuring-ms-amp","sections":[],"depth":2},{"title":"Configuring TransformersEngine","local":"configuring-transformersengine","sections":[],"depth":2},{"title":"Further Reading","local":"further-reading","sections":[],"depth":2}],"depth":1}';function tt(je){return Qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class st extends Se{constructor(f){super(),We(this,f,tt,De,qe,{})}}export{st as component};
