import{s as Oe,o as el,n as Xe}from"../chunks/scheduler.defa9a21.js";import{S as ll,i as tl,g as p,s as n,r as M,A as al,h as r,f as t,c,j as Pe,u as d,x as J,k as qe,y as sl,a,v as m,d as u,t as w,w as y}from"../chunks/index.fe795e71.js";import{T as Ve}from"../chunks/Tip.179eb360.js";import{C as f}from"../chunks/CodeBlock.42404125.js";import{H as ee,E as nl}from"../chunks/EditOnGithub.0f575778.js";function cl(U){let s,j='In its current state, this code is not going to perform gradient accumulation efficiently due to a process called gradient synchronization. Read more about that in the <a href="../concept_guides/gradient_synchronization">Concepts tutorial</a>!';return{c(){s=p("p"),s.innerHTML=j},l(i){s=r(i,"P",{"data-svelte-h":!0}),J(s)!=="svelte-s0dec7"&&(s.innerHTML=j)},m(i,h){a(i,s,h)},p:Xe,d(i){i&&t(s)}}}function il(U){let s,j=`Typically with gradient accumulation, you would need to adjust the number of steps to reflect the change in total batches you are
training on. 🤗 Accelerate automagically does this for you by default. Behind the scenes we instantiate a <code>GradientAccumulationPlugin</code> configured to do this.`;return{c(){s=p("p"),s.innerHTML=j},l(i){s=r(i,"P",{"data-svelte-h":!0}),J(s)!=="svelte-1niv7yj"&&(s.innerHTML=j)},m(i,h){a(i,s,h)},p:Xe,d(i){i&&t(s)}}}function pl(U){let s,j='The <a href="/docs/accelerate/main/en/package_reference/state#accelerate.state.GradientState">state.GradientState</a> is sync’d with the active dataloader being iterated upon. As such it assumes naively that when we have reached the end of the dataloader everything will sync and a step will be performed. To disable this, set <code>sync_with_dataloader</code> to be <code>False</code> in the <code>GradientAccumulationPlugin</code>:',i,h,b;return h=new f({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwR3JhZGllbnRBY2N1bXVsYXRpb25QbHVnaW4lMEElMEFwbHVnaW4lMjAlM0QlMjBHcmFkaWVudEFjY3VtdWxhdGlvblBsdWdpbihzeW5jX3dpdGhfZGF0YWxvYWRlciUzREZhbHNlKSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoLi4uJTJDJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3BsdWdpbiUzRHBsdWdpbik=",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import GradientAccumulationPlugin

plugin = GradientAccumulationPlugin(<span class="hljs-attribute">sync_with_dataloader</span>=<span class="hljs-literal">False</span>)
accelerator = Accelerator(<span class="hljs-built_in">..</span>., <span class="hljs-attribute">gradient_accumulation_plugin</span>=plugin)`,wrap:!1}}),{c(){s=p("p"),s.innerHTML=j,i=n(),M(h.$$.fragment)},l(o){s=r(o,"P",{"data-svelte-h":!0}),J(s)!=="svelte-lg50r9"&&(s.innerHTML=j),i=c(o),d(h.$$.fragment,o)},m(o,T){a(o,s,T),a(o,i,T),m(h,o,T),b=!0},p:Xe,i(o){b||(u(h.$$.fragment,o),b=!0)},o(o){w(h.$$.fragment,o),b=!1},d(o){o&&(t(s),t(i)),y(h,o)}}}function rl(U){let s,j="It’s important that <strong>only one forward/backward</strong> should be done inside the context manager <code>with accelerator.accumulate(model)</code>.";return{c(){s=p("p"),s.innerHTML=j},l(i){s=r(i,"P",{"data-svelte-h":!0}),J(s)!=="svelte-1kw2co7"&&(s.innerHTML=j)},m(i,h){a(i,s,h)},p:Xe,d(i){i&&t(s)}}}function ol(U){let s,j,i,h,b,o,T,Ye=`Gradient accumulation is a technique where you can train on bigger batch sizes than
your machine would normally be able to fit into memory. This is done by accumulating gradients over
several batches, and only stepping the optimizer after a certain number of batches have been performed.`,le,W,ve=`While technically standard gradient accumulation code would work fine in a distributed setup, it is not the most efficient
method for doing so and you may experience considerable slowdowns!`,te,B,Ae=`In this tutorial you will see how to quickly setup gradient accumulation and perform it with the utilities provided in 🤗 Accelerate,
which can total to adding just one new line of code!`,ae,Z,ke="This example will use a very simplistic PyTorch training loop that performs gradient accumulation every two batches:",se,$,ne,V,ce,X,Re="First the code shown earlier will be converted to utilize 🤗 Accelerate without the special gradient accumulation helper:",ie,Y,pe,I,re,v,oe,A,_e=`All that is left now is to let 🤗 Accelerate handle the gradient accumulation for us. To do so you should pass in a <code>gradient_accumulation_steps</code> parameter to <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>, dictating the number
of steps to perform before each call to <code>step()</code> and how to automatically adjust the loss during the call to <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a>:`,Me,k,de,R,Qe=`Alternatively, you can pass in a <code>gradient_accumulation_plugin</code> parameter to the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> object’s <code>__init__</code>, which will allow you to further customize the gradient accumulation behavior.
Read more about that in the <a href="../package_reference/accelerator#accelerate.utils.GradientAccumulationPlugin">GradientAccumulationPlugin</a> docs.`,me,_,ze=`From here you can use the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> context manager from inside your training loop to automatically perform the gradient accumulation for you!
You just wrap it around the entire training part of our code:`,ue,Q,we,z,Ne="You can remove all the special checks for the step number and the loss adjustment:",ye,N,he,x,xe='As you can see the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> is able to keep track of the batch number you are on and it will automatically know whether to step through the prepared optimizer and how to adjust the loss.',Je,G,je,C,be,F,Te,S,Fe="Below is the finished implementation for performing gradient accumulation with 🤗 Accelerate",Ue,E,fe,g,Ie,H,Se='To learn more about what magic this wraps around, read the <a href="../concept_guides/gradient_synchronization">Gradient Synchronization concept guide</a>',Ge,K,Ce,L,Ee="Here is a self-contained example that you can run to see gradient accumulation in action with 🤗 Accelerate:",ge,D,We,P,Be,q,Ze,O,$e;return b=new ee({props:{title:"Performing gradient accumulation with 🤗 Accelerate",local:"performing-gradient-accumulation-with--accelerate",headingTag:"h1"}}),$=new f({props:{code:"ZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsLnRvKGRldmljZSklMEElMEFncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlM0QlMjAyJTBBJTBBZm9yJTIwaW5kZXglMkMlMjBiYXRjaCUyMGluJTIwZW51bWVyYXRlKHRyYWluaW5nX2RhdGFsb2FkZXIpJTNBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwaW5wdXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjB0YXJnZXRzJTIwJTNEJTIwdGFyZ2V0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zcyUyMCUyRiUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUwQSUyMCUyMCUyMCUyMGxvc3MuYmFja3dhcmQoKSUwQSUyMCUyMCUyMCUyMGlmJTIwKGluZGV4JTIwJTJCJTIwMSklMjAlMjUlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCk=",highlighted:`device = <span class="hljs-string">&quot;cuda&quot;</span>
model.to(device)

gradient_accumulation_steps = <span class="hljs-number">2</span>

<span class="hljs-keyword">for</span> index, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(training_dataloader):
    inputs, targets = batch
    inputs = inputs.to(device)
    targets = targets.to(device)
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    loss = loss / gradient_accumulation_steps
    loss.backward()
    <span class="hljs-keyword">if</span> (index + <span class="hljs-number">1</span>) % gradient_accumulation_steps == <span class="hljs-number">0</span>:
        optimizer.step()
        scheduler.step()
        optimizer.zero_grad()`,wrap:!1}}),V=new ee({props:{title:"Converting it to 🤗 Accelerate",local:"converting-it-to--accelerate",headingTag:"h2"}}),Y=new f({props:{code:"JTJCJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyQiUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQSUyQiUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTJCJTIwJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBJTJCJTIwKSUwQSUwQSUyMCUyMGZvciUyMGluZGV4JTJDJTIwYmF0Y2glMjBpbiUyMGVudW1lcmF0ZSh0cmFpbmluZ19kYXRhbG9hZGVyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQS0lMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBpbnB1dHMudG8oZGV2aWNlKSUwQS0lMjAlMjAlMjAlMjAlMjB0YXJnZXRzJTIwJTNEJTIwdGFyZ2V0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zcyUyMCUyRiUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUwQSUyQiUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjAoaW5kZXglMkIxKSUyMCUyNSUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
<span class="hljs-addition">+ accelerator = Accelerator()</span>

<span class="hljs-addition">+ model, optimizer, training_dataloader, scheduler = accelerator.prepare(</span>
<span class="hljs-addition">+     model, optimizer, training_dataloader, scheduler</span>
<span class="hljs-addition">+ )</span>

  for index, batch in enumerate(training_dataloader):
      inputs, targets = batch
<span class="hljs-deletion">-     inputs = inputs.to(device)</span>
<span class="hljs-deletion">-     targets = targets.to(device)</span>
      outputs = model(inputs)
      loss = loss_function(outputs, targets)
      loss = loss / gradient_accumulation_steps
<span class="hljs-addition">+     accelerator.backward(loss)</span>
      if (index+1) % gradient_accumulation_steps == 0:
          optimizer.step()
          scheduler.step()
          optimizer.zero_grad()`,wrap:!1}}),I=new Ve({props:{warning:!0,$$slots:{default:[cl]},$$scope:{ctx:U}}}),v=new ee({props:{title:"Letting 🤗 Accelerate handle gradient accumulation",local:"letting--accelerate-handle-gradient-accumulation",headingTag:"h2"}}),k=new f({props:{code:"JTIwJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQS0lMjBhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKCklMEElMkIlMjBhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIp",highlighted:`  from accelerate import Accelerator
<span class="hljs-deletion">- accelerator = Accelerator()</span>
<span class="hljs-addition">+ accelerator = Accelerator(gradient_accumulation_steps=2)</span>`,wrap:!1}}),Q=new f({props:{code:"LSUyMGZvciUyMGluZGV4JTJDJTIwYmF0Y2glMjBpbiUyMGVudW1lcmF0ZSh0cmFpbmluZ19kYXRhbG9hZGVyKSUzQSUwQSUyQiUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTJCJTIwJTIwJTIwJTIwJTIwd2l0aCUyMGFjY2VsZXJhdG9yLmFjY3VtdWxhdGUobW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyk=",highlighted:`<span class="hljs-deletion">- for index, batch in enumerate(training_dataloader):</span>
<span class="hljs-addition">+ for batch in training_dataloader:</span>
<span class="hljs-addition">+     with accelerator.accumulate(model):</span>
          inputs, targets = batch
          outputs = model(inputs)`,wrap:!1}}),N=new f({props:{code:"LSUyMGxvc3MlMjAlM0QlMjBsb3NzJTIwJTJGJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTBBJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEEtJTIwaWYlMjAoaW5kZXglMkIxKSUyMCUyNSUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-deletion">- loss = loss / gradient_accumulation_steps</span>
  accelerator.backward(loss)
<span class="hljs-deletion">- if (index+1) % gradient_accumulation_steps == 0:</span>
  optimizer.step()
  scheduler.step()
  optimizer.zero_grad()`,wrap:!1}}),G=new Ve({props:{$$slots:{default:[il]},$$scope:{ctx:U}}}),C=new Ve({props:{warning:!0,$$slots:{default:[pl]},$$scope:{ctx:U}}}),F=new ee({props:{title:"The finished code",local:"the-finished-code",headingTag:"h2"}}),E=new f({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEMiklMEFtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluaW5nX2RhdGFsb2FkZXIlMkMlMjBzY2hlZHVsZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUwQSklMEFmb3IlMjBiYXRjaCUyMGluJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMHdpdGglMjBhY2NlbGVyYXRvci5hY2N1bXVsYXRlKG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGxvc3NfZnVuY3Rpb24ob3V0cHV0cyUyQyUyMHRhcmdldHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
accelerator = Accelerator(gradient_accumulation_steps=<span class="hljs-number">2</span>)
model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    <span class="hljs-keyword">with</span> accelerator.accumulate(model):
        inputs, targets = batch
        outputs = model(inputs)
        loss = loss_function(outputs, targets)
        accelerator.backward(loss)
        optimizer.step()
        scheduler.step()
        optimizer.zero_grad()`,wrap:!1}}),g=new Ve({props:{warning:!0,$$slots:{default:[rl]},$$scope:{ctx:U}}}),K=new ee({props:{title:"Self-contained example",local:"self-contained-example",headingTag:"h2"}}),D=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> copy
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> set_seed
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> TensorDataset, DataLoader

<span class="hljs-comment"># seed</span>
set_seed(<span class="hljs-number">0</span>)

<span class="hljs-comment"># define toy inputs and labels</span>
x = torch.tensor([<span class="hljs-number">1.</span>, <span class="hljs-number">2.</span>, <span class="hljs-number">3.</span>, <span class="hljs-number">4.</span>, <span class="hljs-number">5.</span>, <span class="hljs-number">6.</span>, <span class="hljs-number">7.</span>, <span class="hljs-number">8.</span>])
y = torch.tensor([<span class="hljs-number">2.</span>, <span class="hljs-number">4.</span>, <span class="hljs-number">6.</span>, <span class="hljs-number">8.</span>, <span class="hljs-number">10.</span>, <span class="hljs-number">12.</span>, <span class="hljs-number">14.</span>, <span class="hljs-number">16.</span>])
gradient_accumulation_steps = <span class="hljs-number">4</span>
batch_size = <span class="hljs-built_in">len</span>(x) // gradient_accumulation_steps

<span class="hljs-comment"># define dataset and dataloader</span>
dataset = TensorDataset(x, y)
dataloader = DataLoader(dataset, batch_size=batch_size)

<span class="hljs-comment"># define model, optimizer and loss function</span>
model = torch.zeros((<span class="hljs-number">1</span>, <span class="hljs-number">1</span>), requires_grad=<span class="hljs-literal">True</span>)
model_clone = copy.deepcopy(model)
criterion = torch.nn.MSELoss()
model_optimizer = torch.optim.SGD([model], lr=<span class="hljs-number">0.02</span>)
accelerator = Accelerator(gradient_accumulation_steps=gradient_accumulation_steps)
model, model_optimizer, dataloader = accelerator.prepare(model, model_optimizer, dataloader)
model_clone_optimizer = torch.optim.SGD([model_clone], lr=<span class="hljs-number">0.02</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;initial model weight is <span class="hljs-subst">{model.mean().item():<span class="hljs-number">.5</span>f}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;initial model weight is <span class="hljs-subst">{model_clone.mean().item():<span class="hljs-number">.5</span>f}</span>&quot;</span>)
<span class="hljs-keyword">for</span> i, (inputs, labels) <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataloader):
    <span class="hljs-keyword">with</span> accelerator.accumulate(model):
        inputs = inputs.view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>)
        <span class="hljs-built_in">print</span>(i, inputs.flatten())
        labels = labels.view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>)
        outputs = inputs @ model
        loss = criterion(outputs, labels)
        accelerator.backward(loss)
        model_optimizer.step()
        model_optimizer.zero_grad()
loss = criterion(x.view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>) @ model_clone, y.view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>))
model_clone_optimizer.zero_grad()
loss.backward()
model_clone_optimizer.step()
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;w/ accumulation, the final model weight is <span class="hljs-subst">{model.mean().item():<span class="hljs-number">.5</span>f}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;w/o accumulation, the final model weight is <span class="hljs-subst">{model_clone.mean().item():<span class="hljs-number">.5</span>f}</span>&quot;</span>)`,wrap:!1}}),P=new f({props:{code:"aW5pdGlhbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjAwLjAwMDAwJTBBaW5pdGlhbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjAwLjAwMDAwJTBBMCUyMHRlbnNvciglNUIxLiUyQyUyMDIuJTVEKSUwQTElMjB0ZW5zb3IoJTVCMy4lMkMlMjA0LiU1RCklMEEyJTIwdGVuc29yKCU1QjUuJTJDJTIwNi4lNUQpJTBBMyUyMHRlbnNvciglNUI3LiUyQyUyMDguJTVEKSUwQXclMkYlMjBhY2N1bXVsYXRpb24lMkMlMjB0aGUlMjBmaW5hbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjAyLjA0MDAwJTBBdyUyRm8lMjBhY2N1bXVsYXRpb24lMkMlMjB0aGUlMjBmaW5hbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjAyLjA0MDAw",highlighted:`<span class="hljs-attribute">initial</span> model weight is <span class="hljs-number">0</span>.<span class="hljs-number">00000</span>
<span class="hljs-attribute">initial</span> model weight is <span class="hljs-number">0</span>.<span class="hljs-number">00000</span>
<span class="hljs-attribute">0</span> tensor([<span class="hljs-number">1</span>., <span class="hljs-number">2</span>.])
<span class="hljs-attribute">1</span> tensor([<span class="hljs-number">3</span>., <span class="hljs-number">4</span>.])
<span class="hljs-attribute">2</span> tensor([<span class="hljs-number">5</span>., <span class="hljs-number">6</span>.])
<span class="hljs-attribute">3</span> tensor([<span class="hljs-number">7</span>., <span class="hljs-number">8</span>.])
<span class="hljs-attribute">w</span>/ accumulation, the final model weight is <span class="hljs-number">2</span>.<span class="hljs-number">04000</span>
<span class="hljs-attribute">w</span>/o accumulation, the final model weight is <span class="hljs-number">2</span>.<span class="hljs-number">04000</span>`,wrap:!1}}),q=new nl({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/usage_guides/gradient_accumulation.md"}}),{c(){s=p("meta"),j=n(),i=p("p"),h=n(),M(b.$$.fragment),o=n(),T=p("p"),T.textContent=Ye,le=n(),W=p("p"),W.textContent=ve,te=n(),B=p("p"),B.textContent=Ae,ae=n(),Z=p("p"),Z.textContent=ke,se=n(),M($.$$.fragment),ne=n(),M(V.$$.fragment),ce=n(),X=p("p"),X.textContent=Re,ie=n(),M(Y.$$.fragment),pe=n(),M(I.$$.fragment),re=n(),M(v.$$.fragment),oe=n(),A=p("p"),A.innerHTML=_e,Me=n(),M(k.$$.fragment),de=n(),R=p("p"),R.innerHTML=Qe,me=n(),_=p("p"),_.innerHTML=ze,ue=n(),M(Q.$$.fragment),we=n(),z=p("p"),z.textContent=Ne,ye=n(),M(N.$$.fragment),he=n(),x=p("p"),x.innerHTML=xe,Je=n(),M(G.$$.fragment),je=n(),M(C.$$.fragment),be=n(),M(F.$$.fragment),Te=n(),S=p("p"),S.textContent=Fe,Ue=n(),M(E.$$.fragment),fe=n(),M(g.$$.fragment),Ie=n(),H=p("p"),H.innerHTML=Se,Ge=n(),M(K.$$.fragment),Ce=n(),L=p("p"),L.textContent=Ee,ge=n(),M(D.$$.fragment),We=n(),M(P.$$.fragment),Be=n(),M(q.$$.fragment),Ze=n(),O=p("p"),this.h()},l(e){const l=al("svelte-u9bgzb",document.head);s=r(l,"META",{name:!0,content:!0}),l.forEach(t),j=c(e),i=r(e,"P",{}),Pe(i).forEach(t),h=c(e),d(b.$$.fragment,e),o=c(e),T=r(e,"P",{"data-svelte-h":!0}),J(T)!=="svelte-1762c2w"&&(T.textContent=Ye),le=c(e),W=r(e,"P",{"data-svelte-h":!0}),J(W)!=="svelte-1u2vc4p"&&(W.textContent=ve),te=c(e),B=r(e,"P",{"data-svelte-h":!0}),J(B)!=="svelte-elnr4k"&&(B.textContent=Ae),ae=c(e),Z=r(e,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-n9bxrd"&&(Z.textContent=ke),se=c(e),d($.$$.fragment,e),ne=c(e),d(V.$$.fragment,e),ce=c(e),X=r(e,"P",{"data-svelte-h":!0}),J(X)!=="svelte-41b2zq"&&(X.textContent=Re),ie=c(e),d(Y.$$.fragment,e),pe=c(e),d(I.$$.fragment,e),re=c(e),d(v.$$.fragment,e),oe=c(e),A=r(e,"P",{"data-svelte-h":!0}),J(A)!=="svelte-70ndtd"&&(A.innerHTML=_e),Me=c(e),d(k.$$.fragment,e),de=c(e),R=r(e,"P",{"data-svelte-h":!0}),J(R)!=="svelte-j5vx6o"&&(R.innerHTML=Qe),me=c(e),_=r(e,"P",{"data-svelte-h":!0}),J(_)!=="svelte-1yxrf5e"&&(_.innerHTML=ze),ue=c(e),d(Q.$$.fragment,e),we=c(e),z=r(e,"P",{"data-svelte-h":!0}),J(z)!=="svelte-1mcvl9w"&&(z.textContent=Ne),ye=c(e),d(N.$$.fragment,e),he=c(e),x=r(e,"P",{"data-svelte-h":!0}),J(x)!=="svelte-1g13ex2"&&(x.innerHTML=xe),Je=c(e),d(G.$$.fragment,e),je=c(e),d(C.$$.fragment,e),be=c(e),d(F.$$.fragment,e),Te=c(e),S=r(e,"P",{"data-svelte-h":!0}),J(S)!=="svelte-9alw5p"&&(S.textContent=Fe),Ue=c(e),d(E.$$.fragment,e),fe=c(e),d(g.$$.fragment,e),Ie=c(e),H=r(e,"P",{"data-svelte-h":!0}),J(H)!=="svelte-aw0h59"&&(H.innerHTML=Se),Ge=c(e),d(K.$$.fragment,e),Ce=c(e),L=r(e,"P",{"data-svelte-h":!0}),J(L)!=="svelte-1wysb4w"&&(L.textContent=Ee),ge=c(e),d(D.$$.fragment,e),We=c(e),d(P.$$.fragment,e),Be=c(e),d(q.$$.fragment,e),Ze=c(e),O=r(e,"P",{}),Pe(O).forEach(t),this.h()},h(){qe(s,"name","hf:doc:metadata"),qe(s,"content",Ml)},m(e,l){sl(document.head,s),a(e,j,l),a(e,i,l),a(e,h,l),m(b,e,l),a(e,o,l),a(e,T,l),a(e,le,l),a(e,W,l),a(e,te,l),a(e,B,l),a(e,ae,l),a(e,Z,l),a(e,se,l),m($,e,l),a(e,ne,l),m(V,e,l),a(e,ce,l),a(e,X,l),a(e,ie,l),m(Y,e,l),a(e,pe,l),m(I,e,l),a(e,re,l),m(v,e,l),a(e,oe,l),a(e,A,l),a(e,Me,l),m(k,e,l),a(e,de,l),a(e,R,l),a(e,me,l),a(e,_,l),a(e,ue,l),m(Q,e,l),a(e,we,l),a(e,z,l),a(e,ye,l),m(N,e,l),a(e,he,l),a(e,x,l),a(e,Je,l),m(G,e,l),a(e,je,l),m(C,e,l),a(e,be,l),m(F,e,l),a(e,Te,l),a(e,S,l),a(e,Ue,l),m(E,e,l),a(e,fe,l),m(g,e,l),a(e,Ie,l),a(e,H,l),a(e,Ge,l),m(K,e,l),a(e,Ce,l),a(e,L,l),a(e,ge,l),m(D,e,l),a(e,We,l),m(P,e,l),a(e,Be,l),m(q,e,l),a(e,Ze,l),a(e,O,l),$e=!0},p(e,[l]){const He={};l&2&&(He.$$scope={dirty:l,ctx:e}),I.$set(He);const Ke={};l&2&&(Ke.$$scope={dirty:l,ctx:e}),G.$set(Ke);const Le={};l&2&&(Le.$$scope={dirty:l,ctx:e}),C.$set(Le);const De={};l&2&&(De.$$scope={dirty:l,ctx:e}),g.$set(De)},i(e){$e||(u(b.$$.fragment,e),u($.$$.fragment,e),u(V.$$.fragment,e),u(Y.$$.fragment,e),u(I.$$.fragment,e),u(v.$$.fragment,e),u(k.$$.fragment,e),u(Q.$$.fragment,e),u(N.$$.fragment,e),u(G.$$.fragment,e),u(C.$$.fragment,e),u(F.$$.fragment,e),u(E.$$.fragment,e),u(g.$$.fragment,e),u(K.$$.fragment,e),u(D.$$.fragment,e),u(P.$$.fragment,e),u(q.$$.fragment,e),$e=!0)},o(e){w(b.$$.fragment,e),w($.$$.fragment,e),w(V.$$.fragment,e),w(Y.$$.fragment,e),w(I.$$.fragment,e),w(v.$$.fragment,e),w(k.$$.fragment,e),w(Q.$$.fragment,e),w(N.$$.fragment,e),w(G.$$.fragment,e),w(C.$$.fragment,e),w(F.$$.fragment,e),w(E.$$.fragment,e),w(g.$$.fragment,e),w(K.$$.fragment,e),w(D.$$.fragment,e),w(P.$$.fragment,e),w(q.$$.fragment,e),$e=!1},d(e){e&&(t(j),t(i),t(h),t(o),t(T),t(le),t(W),t(te),t(B),t(ae),t(Z),t(se),t(ne),t(ce),t(X),t(ie),t(pe),t(re),t(oe),t(A),t(Me),t(de),t(R),t(me),t(_),t(ue),t(we),t(z),t(ye),t(he),t(x),t(Je),t(je),t(be),t(Te),t(S),t(Ue),t(fe),t(Ie),t(H),t(Ge),t(Ce),t(L),t(ge),t(We),t(Be),t(Ze),t(O)),t(s),y(b,e),y($,e),y(V,e),y(Y,e),y(I,e),y(v,e),y(k,e),y(Q,e),y(N,e),y(G,e),y(C,e),y(F,e),y(E,e),y(g,e),y(K,e),y(D,e),y(P,e),y(q,e)}}}const Ml='{"title":"Performing gradient accumulation with 🤗 Accelerate","local":"performing-gradient-accumulation-with--accelerate","sections":[{"title":"Converting it to 🤗 Accelerate","local":"converting-it-to--accelerate","sections":[],"depth":2},{"title":"Letting 🤗 Accelerate handle gradient accumulation","local":"letting--accelerate-handle-gradient-accumulation","sections":[],"depth":2},{"title":"The finished code","local":"the-finished-code","sections":[],"depth":2},{"title":"Self-contained example","local":"self-contained-example","sections":[],"depth":2}],"depth":1}';function dl(U){return el(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jl extends ll{constructor(s){super(),tl(this,s,dl,ol,Oe,{})}}export{Jl as component};
