import{s as ul,n as Ml,o as cl}from"../chunks/scheduler.f6b352c8.js";import{S as hl,i as ml,g as a,s,r as u,m as Be,A as yl,h as o,f as l,c as i,j as g,u as M,x as r,n as He,k as _e,y as p,a as n,v as c,d as h,t as m,w as y}from"../chunks/index.7f38e934.js";import{C as b}from"../chunks/CodeBlock.3ee8293b.js";import{H as U,E as dl}from"../chunks/index.2061098d.js";function Tl(We){let w,$t,bt,xt,v,St,I,Ze="In this section, we’ll create our sentiment analysis MCP server using Gradio. This server will expose a sentiment analysis tool that can be used by both human users through a web interface and AI models through the MCP protocol.",Bt,$,Ht,x,Ge="Gradio provides a straightforward way to create MCP servers by automatically converting your Python functions into MCP tools. When you set <code>mcp_server=True</code> in <code>launch()</code>, Gradio:",_t,S,Re="<li>Automatically converts your functions into MCP Tools</li> <li>Maps input components to tool argument schemas</li> <li>Determines response formats from output components</li> <li>Sets up JSON-RPC over HTTP+SSE for client-server communication</li> <li>Creates both a web interface and an MCP server endpoint</li>",Wt,B,Zt,H,Ae="First, let’s create a new directory for our project and set up the required dependencies:",Gt,_,Rt,W,At,Z,Ee="<p>Hugging face spaces needs an app.py file to build the space. So the name of the python file has to be app.py</p>",Et,G,Le="Create a new file called <code>app.py</code> with the following code:",Lt,R,kt,A,Qt,E,ke="Let’s break down the key components:",Vt,T,Mt,Qe="<p><strong>Function Definition</strong>:</p> <ul><li>The <code>sentiment_analysis</code> function takes a text input and returns a dictionary</li> <li>It uses TextBlob to analyze the sentiment</li> <li>The docstring is crucial as it helps Gradio generate the MCP tool schema</li> <li>Type hints (<code>str</code> and <code>dict</code>) help define the input/output schema</li></ul>",Te,ct,Ve="<p><strong>Gradio Interface</strong>:</p> <ul><li><code>gr.Interface</code> creates both the web UI and MCP server</li> <li>The function is exposed as an MCP tool automatically</li> <li>Input and output components define the tool’s schema</li> <li>The JSON output component ensures proper serialization</li></ul>",ge,L,ht,qe="<strong>MCP Server</strong>:",Ue,C,mt,Pe="Setting <code>mcp_server=True</code> enables the MCP server",we,yt,Xe="The server will be available at <code>http://localhost:7860/gradio_api/mcp/sse</code>",Ce,dt,je,k,qt,Q,Pt,V,Ne="Start the server by running:",Xt,q,Nt,P,Ye="You should see output indicating that both the web interface and MCP server are running. The web interface will be available at <code>http://localhost:7860</code>, and the MCP server at <code>http://localhost:7860/gradio_api/mcp/sse</code>.",Yt,X,zt,N,ze="You can test the server in two ways:",Ft,Y,Fe="<li><p><strong>Web Interface</strong>:</p> <ul><li>Open <code>http://localhost:7860</code> in your browser</li> <li>Enter some text and click “Submit”</li> <li>You should see the sentiment analysis results</li></ul></li> <li><p><strong>MCP Schema</strong>:</p> <ul><li>Visit <code>http://localhost:7860/gradio_api/mcp/schema</code></li> <li>This shows the MCP tool schema that clients will use</li> <li>You can also find this in the “View API” link in the footer of your Gradio app</li></ul></li>",Ot,z,Dt,d,Tt,Oe="<p><strong>Type Hints and Docstrings</strong>:</p> <ul><li>Always provide type hints for your function parameters and return values</li> <li>Include a docstring with an “Args:” block for each parameter</li> <li>This helps Gradio generate accurate MCP tool schemas</li></ul>",fe,gt,De="<p><strong>String Inputs</strong>:</p> <ul><li>When in doubt, accept input arguments as <code>str</code></li> <li>Convert them to the desired type inside the function</li> <li>This provides better compatibility with MCP clients</li></ul>",Je,F,Ut,Ke="<strong>SSE Support</strong>:",be,O,wt,tl="Some MCP clients don’t support SSE-based MCP Servers",ve,j,Ie,Ct,el="mcp-remote",$e,D,xe,jt,ll="<p><strong>Connection Issues</strong>:</p> <ul><li>If you encounter connection problems, try restarting both the client and server</li> <li>Check that the server is running and accessible</li> <li>Verify that the MCP schema is available at the expected URL</li></ul>",Kt,K,te,tt,nl="To make your server available to others, you can deploy it to Hugging Face Spaces:",ee,et,sl="<li><p>Create a new Space on Hugging Face:</p> <ul><li>Go to huggingface.co/spaces</li> <li>Click “Create new Space”</li> <li>Choose “Gradio” as the SDK</li> <li>Name your space (e.g., “mcp-sentiment”)</li></ul></li> <li><p>Create a <code>requirements.txt</code> file:</p></li>",le,lt,ne,f,il="<li>Push your code to the Space:</li>",se,nt,ie,st,al="Your MCP server will now be available at:",ae,it,oe,at,pe,ot,ol="Now that we have our MCP server running, we’ll create clients to interact with it. In the next sections, we’ll:",re,pt,pl="<li>Create a HuggingFace.js-based client inspired by Tiny Agents</li> <li>Implement a SmolAgents-based Python client</li> <li>Test both clients with our deployed server</li>",ue,rt,rl="Let’s move on to building our first client!",Me,ut,ce,vt,he;return v=new U({props:{title:"Building the Gradio MCP Server",local:"building-the-gradio-mcp-server",headingTag:"h1"}}),$=new U({props:{title:"Introduction to Gradio MCP Integration",local:"introduction-to-gradio-mcp-integration",headingTag:"h2"}}),B=new U({props:{title:"Setting Up the Project",local:"setting-up-the-project",headingTag:"h2"}}),_=new b({props:{code:"bWtkaXIlMjBtY3Atc2VudGltZW50JTBBY2QlMjBtY3Atc2VudGltZW50JTBBcHl0aG9uJTIwLW0lMjB2ZW52JTIwdmVudiUwQXNvdXJjZSUyMHZlbnYlMkZiaW4lMkZhY3RpdmF0ZSUyMCUyMCUyMyUyME9uJTIwV2luZG93cyUzQSUyMHZlbnYlNUNTY3JpcHRzJTVDYWN0aXZhdGUlMEFwaXAlMjBpbnN0YWxsJTIwJTIyZ3JhZGlvJTVCbWNwJTVEJTIyJTIwdGV4dGJsb2I=",highlighted:`<span class="hljs-built_in">mkdir</span> mcp-sentiment
<span class="hljs-built_in">cd</span> mcp-sentiment
python -m venv venv
<span class="hljs-built_in">source</span> venv/bin/activate  <span class="hljs-comment"># On Windows: venv\\Scripts\\activate</span>
pip install <span class="hljs-string">&quot;gradio[mcp]&quot;</span> textblob`,wrap:!1}}),W=new U({props:{title:"Creating the Server",local:"creating-the-server",headingTag:"h2"}}),R=new b({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjB0ZXh0YmxvYiUyMGltcG9ydCUyMFRleHRCbG9iJTBBJTBBZGVmJTIwc2VudGltZW50X2FuYWx5c2lzKHRleHQlM0ElMjBzdHIpJTIwLSUzRSUyMGRpY3QlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBbmFseXplJTIwdGhlJTIwc2VudGltZW50JTIwb2YlMjB0aGUlMjBnaXZlbiUyMHRleHQuJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlMjAoc3RyKSUzQSUyMFRoZSUyMHRleHQlMjB0byUyMGFuYWx5emUlMEElMEElMjAlMjAlMjAlMjBSZXR1cm5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGljdCUzQSUyMEElMjBkaWN0aW9uYXJ5JTIwY29udGFpbmluZyUyMHBvbGFyaXR5JTJDJTIwc3ViamVjdGl2aXR5JTJDJTIwYW5kJTIwYXNzZXNzbWVudCUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGJsb2IlMjAlM0QlMjBUZXh0QmxvYih0ZXh0KSUwQSUyMCUyMCUyMCUyMHNlbnRpbWVudCUyMCUzRCUyMGJsb2Iuc2VudGltZW50JTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycG9sYXJpdHklMjIlM0ElMjByb3VuZChzZW50aW1lbnQucG9sYXJpdHklMkMlMjAyKSUyQyUyMCUyMCUyMyUyMC0xJTIwKG5lZ2F0aXZlKSUyMHRvJTIwMSUyMChwb3NpdGl2ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdWJqZWN0aXZpdHklMjIlM0ElMjByb3VuZChzZW50aW1lbnQuc3ViamVjdGl2aXR5JTJDJTIwMiklMkMlMjAlMjAlMjMlMjAwJTIwKG9iamVjdGl2ZSklMjB0byUyMDElMjAoc3ViamVjdGl2ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhc3Nlc3NtZW50JTIyJTNBJTIwJTIycG9zaXRpdmUlMjIlMjBpZiUyMHNlbnRpbWVudC5wb2xhcml0eSUyMCUzRSUyMDAlMjBlbHNlJTIwJTIybmVnYXRpdmUlMjIlMjBpZiUyMHNlbnRpbWVudC5wb2xhcml0eSUyMCUzQyUyMDAlMjBlbHNlJTIwJTIybmV1dHJhbCUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSUwQSUyMyUyMENyZWF0ZSUyMHRoZSUyMEdyYWRpbyUyMGludGVyZmFjZSUwQWRlbW8lMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RzZW50aW1lbnRfYW5hbHlzaXMlMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5UZXh0Ym94KHBsYWNlaG9sZGVyJTNEJTIyRW50ZXIlMjB0ZXh0JTIwdG8lMjBhbmFseXplLi4uJTIyKSUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0Rnci5KU09OKCklMkMlMEElMjAlMjAlMjAlMjB0aXRsZSUzRCUyMlRleHQlMjBTZW50aW1lbnQlMjBBbmFseXNpcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyQW5hbHl6ZSUyMHRoZSUyMHNlbnRpbWVudCUyMG9mJTIwdGV4dCUyMHVzaW5nJTIwVGV4dEJsb2IlMjIlMEEpJTBBJTBBJTIzJTIwTGF1bmNoJTIwdGhlJTIwaW50ZXJmYWNlJTIwYW5kJTIwTUNQJTIwc2VydmVyJTBBaWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTBBJTIwJTIwJTIwJTIwZGVtby5sYXVuY2gobWNwX3NlcnZlciUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> textblob <span class="hljs-keyword">import</span> TextBlob

<span class="hljs-keyword">def</span> <span class="hljs-title function_">sentiment_analysis</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">dict</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Analyze the sentiment of the given text.

    Args:
        text (str): The text to analyze

    Returns:
        dict: A dictionary containing polarity, subjectivity, and assessment
    &quot;&quot;&quot;</span>
    blob = TextBlob(text)
    sentiment = blob.sentiment
    
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;polarity&quot;</span>: <span class="hljs-built_in">round</span>(sentiment.polarity, <span class="hljs-number">2</span>),  <span class="hljs-comment"># -1 (negative) to 1 (positive)</span>
        <span class="hljs-string">&quot;subjectivity&quot;</span>: <span class="hljs-built_in">round</span>(sentiment.subjectivity, <span class="hljs-number">2</span>),  <span class="hljs-comment"># 0 (objective) to 1 (subjective)</span>
        <span class="hljs-string">&quot;assessment&quot;</span>: <span class="hljs-string">&quot;positive&quot;</span> <span class="hljs-keyword">if</span> sentiment.polarity &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;negative&quot;</span> <span class="hljs-keyword">if</span> sentiment.polarity &lt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;neutral&quot;</span>
    }

<span class="hljs-comment"># Create the Gradio interface</span>
demo = gr.Interface(
    fn=sentiment_analysis,
    inputs=gr.Textbox(placeholder=<span class="hljs-string">&quot;Enter text to analyze...&quot;</span>),
    outputs=gr.JSON(),
    title=<span class="hljs-string">&quot;Text Sentiment Analysis&quot;</span>,
    description=<span class="hljs-string">&quot;Analyze the sentiment of text using TextBlob&quot;</span>
)

<span class="hljs-comment"># Launch the interface and MCP server</span>
<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    demo.launch(mcp_server=<span class="hljs-literal">True</span>)`,wrap:!1}}),A=new U({props:{title:"Understanding the Code",local:"understanding-the-code",headingTag:"h2"}}),k=new b({props:{code:"ZXhwb3J0JTIwR1JBRElPX01DUF9TRVJWRVIlM0RUcnVl",highlighted:'<span class="hljs-built_in">export</span> GRADIO_MCP_SERVER=True',wrap:!1}}),Q=new U({props:{title:"Running the Server",local:"running-the-server",headingTag:"h2"}}),q=new b({props:{code:"cHl0aG9uJTIwYXBwLnB5",highlighted:"python app.py",wrap:!1}}),X=new U({props:{title:"Testing the Server",local:"testing-the-server",headingTag:"h2"}}),z=new U({props:{title:"Troubleshooting Tips",local:"troubleshooting-tips",headingTag:"h2"}}),D=new b({props:{code:"JTdCJTBBJTIwJTIwJTIybWNwU2VydmVycyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmdyYWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbW1hbmQlMjIlM0ElMjAlMjJucHglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJhcmdzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWNwLXJlbW90ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E3ODYwJTJGZ3JhZGlvX2FwaSUyRm1jcCUyRnNzZSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;mcpServers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gradio&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;npx&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;mcp-remote&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-string">&quot;http://localhost:7860/gradio_api/mcp/sse&quot;</span>
      <span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),K=new U({props:{title:"Deploying to Hugging Face Spaces",local:"deploying-to-hugging-face-spaces",headingTag:"h2"}}),lt=new b({props:{code:"Z3JhZGlvJTVCbWNwJTVEJTBBdGV4dGJsb2I=",highlighted:`gradio[mcp]
textblob`,wrap:!1}}),nt=new b({props:{code:"Z2l0JTIwaW5pdCUwQWdpdCUyMGFkZCUyMGFwcC5weSUyMHJlcXVpcmVtZW50cy50eHQlMEFnaXQlMjBjb21taXQlMjAtbSUyMCUyMkluaXRpYWwlMjBjb21taXQlMjIlMEFnaXQlMjByZW1vdGUlMjBhZGQlMjBvcmlnaW4lMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGWU9VUl9VU0VSTkFNRSUyRm1jcC1zZW50aW1lbnQlMEFnaXQlMjBwdXNoJTIwLXUlMjBvcmlnaW4lMjBtYWlu",highlighted:`git init
git add app.py requirements.txt
git commit -m <span class="hljs-string">&quot;Initial commit&quot;</span>
git remote add origin https://huggingface.co/spaces/YOUR_USERNAME/mcp-sentiment
git push -u origin main`,wrap:!1}}),it=new b({props:{code:"aHR0cHMlM0ElMkYlMkZZT1VSX1VTRVJOQU1FLW1jcC1zZW50aW1lbnQuaGYuc3BhY2UlMkZncmFkaW9fYXBpJTJGbWNwJTJGc3Nl",highlighted:'https:<span class="hljs-regexp">//</span>YOUR_USERNAME-mcp-sentiment.hf.space<span class="hljs-regexp">/gradio_api/m</span>cp/sse',wrap:!1}}),at=new U({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),ut=new dl({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit2/gradio-server.mdx"}}),{c(){w=a("meta"),$t=s(),bt=a("p"),xt=s(),u(v.$$.fragment),St=s(),I=a("p"),I.textContent=Ze,Bt=s(),u($.$$.fragment),Ht=s(),x=a("p"),x.innerHTML=Ge,_t=s(),S=a("ol"),S.innerHTML=Re,Wt=s(),u(B.$$.fragment),Zt=s(),H=a("p"),H.textContent=Ae,Gt=s(),u(_.$$.fragment),Rt=s(),u(W.$$.fragment),At=s(),Z=a("blockquote"),Z.innerHTML=Ee,Et=s(),G=a("p"),G.innerHTML=Le,Lt=s(),u(R.$$.fragment),kt=s(),u(A.$$.fragment),Qt=s(),E=a("p"),E.textContent=ke,Vt=s(),T=a("ol"),Mt=a("li"),Mt.innerHTML=Qe,Te=s(),ct=a("li"),ct.innerHTML=Ve,ge=s(),L=a("li"),ht=a("p"),ht.innerHTML=qe,Ue=s(),C=a("ul"),mt=a("li"),mt.innerHTML=Pe,we=s(),yt=a("li"),yt.innerHTML=Xe,Ce=s(),dt=a("li"),je=Be(`You can also enable it using the environment variable:
	`),u(k.$$.fragment),qt=s(),u(Q.$$.fragment),Pt=s(),V=a("p"),V.textContent=Ne,Xt=s(),u(q.$$.fragment),Nt=s(),P=a("p"),P.innerHTML=Ye,Yt=s(),u(X.$$.fragment),zt=s(),N=a("p"),N.textContent=ze,Ft=s(),Y=a("ol"),Y.innerHTML=Fe,Ot=s(),u(z.$$.fragment),Dt=s(),d=a("ol"),Tt=a("li"),Tt.innerHTML=Oe,fe=s(),gt=a("li"),gt.innerHTML=De,Je=s(),F=a("li"),Ut=a("p"),Ut.innerHTML=Ke,be=s(),O=a("ul"),wt=a("li"),wt.textContent=tl,ve=s(),j=a("li"),Ie=Be("In those cases, use "),Ct=a("code"),Ct.textContent=el,$e=Be(`:
	`),u(D.$$.fragment),xe=s(),jt=a("li"),jt.innerHTML=ll,Kt=s(),u(K.$$.fragment),te=s(),tt=a("p"),tt.textContent=nl,ee=s(),et=a("ol"),et.innerHTML=sl,le=s(),u(lt.$$.fragment),ne=s(),f=a("ol"),f.innerHTML=il,se=s(),u(nt.$$.fragment),ie=s(),st=a("p"),st.textContent=al,ae=s(),u(it.$$.fragment),oe=s(),u(at.$$.fragment),pe=s(),ot=a("p"),ot.textContent=ol,re=s(),pt=a("ol"),pt.innerHTML=pl,ue=s(),rt=a("p"),rt.textContent=rl,Me=s(),u(ut.$$.fragment),ce=s(),vt=a("p"),this.h()},l(t){const e=yl("svelte-u9bgzb",document.head);w=o(e,"META",{name:!0,content:!0}),e.forEach(l),$t=i(t),bt=o(t,"P",{}),g(bt).forEach(l),xt=i(t),M(v.$$.fragment,t),St=i(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-15g2s94"&&(I.textContent=Ze),Bt=i(t),M($.$$.fragment,t),Ht=i(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1yi0ix"&&(x.innerHTML=Ge),_t=i(t),S=o(t,"OL",{"data-svelte-h":!0}),r(S)!=="svelte-g4mq16"&&(S.innerHTML=Re),Wt=i(t),M(B.$$.fragment,t),Zt=i(t),H=o(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-mmri3o"&&(H.textContent=Ae),Gt=i(t),M(_.$$.fragment,t),Rt=i(t),M(W.$$.fragment,t),At=i(t),Z=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Z)!=="svelte-jocz8i"&&(Z.innerHTML=Ee),Et=i(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-viak6g"&&(G.innerHTML=Le),Lt=i(t),M(R.$$.fragment,t),kt=i(t),M(A.$$.fragment,t),Qt=i(t),E=o(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-ccttqs"&&(E.textContent=ke),Vt=i(t),T=o(t,"OL",{});var ft=g(T);Mt=o(ft,"LI",{"data-svelte-h":!0}),r(Mt)!=="svelte-1r6ud1j"&&(Mt.innerHTML=Qe),Te=i(ft),ct=o(ft,"LI",{"data-svelte-h":!0}),r(ct)!=="svelte-1zxric"&&(ct.innerHTML=Ve),ge=i(ft),L=o(ft,"LI",{});var me=g(L);ht=o(me,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-9494xm"&&(ht.innerHTML=qe),Ue=i(me),C=o(me,"UL",{});var Jt=g(C);mt=o(Jt,"LI",{"data-svelte-h":!0}),r(mt)!=="svelte-1habxzw"&&(mt.innerHTML=Pe),we=i(Jt),yt=o(Jt,"LI",{"data-svelte-h":!0}),r(yt)!=="svelte-hwrhz1"&&(yt.innerHTML=Xe),Ce=i(Jt),dt=o(Jt,"LI",{});var Se=g(dt);je=He(Se,`You can also enable it using the environment variable:
	`),M(k.$$.fragment,Se),Se.forEach(l),Jt.forEach(l),me.forEach(l),ft.forEach(l),qt=i(t),M(Q.$$.fragment,t),Pt=i(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-tq7guq"&&(V.textContent=Ne),Xt=i(t),M(q.$$.fragment,t),Nt=i(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-16j4roj"&&(P.innerHTML=Ye),Yt=i(t),M(X.$$.fragment,t),zt=i(t),N=o(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1hexqja"&&(N.textContent=ze),Ft=i(t),Y=o(t,"OL",{"data-svelte-h":!0}),r(Y)!=="svelte-1prsps9"&&(Y.innerHTML=Fe),Ot=i(t),M(z.$$.fragment,t),Dt=i(t),d=o(t,"OL",{});var J=g(d);Tt=o(J,"LI",{"data-svelte-h":!0}),r(Tt)!=="svelte-1kjwfqe"&&(Tt.innerHTML=Oe),fe=i(J),gt=o(J,"LI",{"data-svelte-h":!0}),r(gt)!=="svelte-mxigd7"&&(gt.innerHTML=De),Je=i(J),F=o(J,"LI",{});var ye=g(F);Ut=o(ye,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-pauept"&&(Ut.innerHTML=Ke),be=i(ye),O=o(ye,"UL",{});var de=g(O);wt=o(de,"LI",{"data-svelte-h":!0}),r(wt)!=="svelte-18matxo"&&(wt.textContent=tl),ve=i(de),j=o(de,"LI",{});var It=g(j);Ie=He(It,"In those cases, use "),Ct=o(It,"CODE",{"data-svelte-h":!0}),r(Ct)!=="svelte-32a5p1"&&(Ct.textContent=el),$e=He(It,`:
	`),M(D.$$.fragment,It),It.forEach(l),de.forEach(l),ye.forEach(l),xe=i(J),jt=o(J,"LI",{"data-svelte-h":!0}),r(jt)!=="svelte-46q023"&&(jt.innerHTML=ll),J.forEach(l),Kt=i(t),M(K.$$.fragment,t),te=i(t),tt=o(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1itkhgv"&&(tt.textContent=nl),ee=i(t),et=o(t,"OL",{"data-svelte-h":!0}),r(et)!=="svelte-1thxdu2"&&(et.innerHTML=sl),le=i(t),M(lt.$$.fragment,t),ne=i(t),f=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(f)!=="svelte-ok99j"&&(f.innerHTML=il),se=i(t),M(nt.$$.fragment,t),ie=i(t),st=o(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-rjtj0p"&&(st.textContent=al),ae=i(t),M(it.$$.fragment,t),oe=i(t),M(at.$$.fragment,t),pe=i(t),ot=o(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-p1bgao"&&(ot.textContent=ol),re=i(t),pt=o(t,"OL",{"data-svelte-h":!0}),r(pt)!=="svelte-6w66tp"&&(pt.innerHTML=pl),ue=i(t),rt=o(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-19wsvhm"&&(rt.textContent=rl),Me=i(t),M(ut.$$.fragment,t),ce=i(t),vt=o(t,"P",{}),g(vt).forEach(l),this.h()},h(){_e(w,"name","hf:doc:metadata"),_e(w,"content",gl),_e(f,"start","3")},m(t,e){p(document.head,w),n(t,$t,e),n(t,bt,e),n(t,xt,e),c(v,t,e),n(t,St,e),n(t,I,e),n(t,Bt,e),c($,t,e),n(t,Ht,e),n(t,x,e),n(t,_t,e),n(t,S,e),n(t,Wt,e),c(B,t,e),n(t,Zt,e),n(t,H,e),n(t,Gt,e),c(_,t,e),n(t,Rt,e),c(W,t,e),n(t,At,e),n(t,Z,e),n(t,Et,e),n(t,G,e),n(t,Lt,e),c(R,t,e),n(t,kt,e),c(A,t,e),n(t,Qt,e),n(t,E,e),n(t,Vt,e),n(t,T,e),p(T,Mt),p(T,Te),p(T,ct),p(T,ge),p(T,L),p(L,ht),p(L,Ue),p(L,C),p(C,mt),p(C,we),p(C,yt),p(C,Ce),p(C,dt),p(dt,je),c(k,dt,null),n(t,qt,e),c(Q,t,e),n(t,Pt,e),n(t,V,e),n(t,Xt,e),c(q,t,e),n(t,Nt,e),n(t,P,e),n(t,Yt,e),c(X,t,e),n(t,zt,e),n(t,N,e),n(t,Ft,e),n(t,Y,e),n(t,Ot,e),c(z,t,e),n(t,Dt,e),n(t,d,e),p(d,Tt),p(d,fe),p(d,gt),p(d,Je),p(d,F),p(F,Ut),p(F,be),p(F,O),p(O,wt),p(O,ve),p(O,j),p(j,Ie),p(j,Ct),p(j,$e),c(D,j,null),p(d,xe),p(d,jt),n(t,Kt,e),c(K,t,e),n(t,te,e),n(t,tt,e),n(t,ee,e),n(t,et,e),n(t,le,e),c(lt,t,e),n(t,ne,e),n(t,f,e),n(t,se,e),c(nt,t,e),n(t,ie,e),n(t,st,e),n(t,ae,e),c(it,t,e),n(t,oe,e),c(at,t,e),n(t,pe,e),n(t,ot,e),n(t,re,e),n(t,pt,e),n(t,ue,e),n(t,rt,e),n(t,Me,e),c(ut,t,e),n(t,ce,e),n(t,vt,e),he=!0},p:Ml,i(t){he||(h(v.$$.fragment,t),h($.$$.fragment,t),h(B.$$.fragment,t),h(_.$$.fragment,t),h(W.$$.fragment,t),h(R.$$.fragment,t),h(A.$$.fragment,t),h(k.$$.fragment,t),h(Q.$$.fragment,t),h(q.$$.fragment,t),h(X.$$.fragment,t),h(z.$$.fragment,t),h(D.$$.fragment,t),h(K.$$.fragment,t),h(lt.$$.fragment,t),h(nt.$$.fragment,t),h(it.$$.fragment,t),h(at.$$.fragment,t),h(ut.$$.fragment,t),he=!0)},o(t){m(v.$$.fragment,t),m($.$$.fragment,t),m(B.$$.fragment,t),m(_.$$.fragment,t),m(W.$$.fragment,t),m(R.$$.fragment,t),m(A.$$.fragment,t),m(k.$$.fragment,t),m(Q.$$.fragment,t),m(q.$$.fragment,t),m(X.$$.fragment,t),m(z.$$.fragment,t),m(D.$$.fragment,t),m(K.$$.fragment,t),m(lt.$$.fragment,t),m(nt.$$.fragment,t),m(it.$$.fragment,t),m(at.$$.fragment,t),m(ut.$$.fragment,t),he=!1},d(t){t&&(l($t),l(bt),l(xt),l(St),l(I),l(Bt),l(Ht),l(x),l(_t),l(S),l(Wt),l(Zt),l(H),l(Gt),l(Rt),l(At),l(Z),l(Et),l(G),l(Lt),l(kt),l(Qt),l(E),l(Vt),l(T),l(qt),l(Pt),l(V),l(Xt),l(Nt),l(P),l(Yt),l(zt),l(N),l(Ft),l(Y),l(Ot),l(Dt),l(d),l(Kt),l(te),l(tt),l(ee),l(et),l(le),l(ne),l(f),l(se),l(ie),l(st),l(ae),l(oe),l(pe),l(ot),l(re),l(pt),l(ue),l(rt),l(Me),l(ce),l(vt)),l(w),y(v,t),y($,t),y(B,t),y(_,t),y(W,t),y(R,t),y(A,t),y(k),y(Q,t),y(q,t),y(X,t),y(z,t),y(D),y(K,t),y(lt,t),y(nt,t),y(it,t),y(at,t),y(ut,t)}}}const gl='{"title":"Building the Gradio MCP Server","local":"building-the-gradio-mcp-server","sections":[{"title":"Introduction to Gradio MCP Integration","local":"introduction-to-gradio-mcp-integration","sections":[],"depth":2},{"title":"Setting Up the Project","local":"setting-up-the-project","sections":[],"depth":2},{"title":"Creating the Server","local":"creating-the-server","sections":[],"depth":2},{"title":"Understanding the Code","local":"understanding-the-code","sections":[],"depth":2},{"title":"Running the Server","local":"running-the-server","sections":[],"depth":2},{"title":"Testing the Server","local":"testing-the-server","sections":[],"depth":2},{"title":"Troubleshooting Tips","local":"troubleshooting-tips","sections":[],"depth":2},{"title":"Deploying to Hugging Face Spaces","local":"deploying-to-hugging-face-spaces","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Ul(We){return cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jl extends hl{constructor(w){super(),ml(this,w,Ul,Tl,ul,{})}}export{Jl as component};
