import{s as Pl,o as Kl,n as ge}from"../chunks/scheduler.7da89386.js";import{S as Ol,i as en,g as w,s as a,r as M,A as ln,h as f,f as s,c as o,j as S,u as y,x as T,k as X,y as i,a as p,v as d,d as u,t as U,w as h}from"../chunks/index.0b7befd3.js";import{D as V,E as fe}from"../chunks/ExampleCodeBlock.a2c7df44.js";import{C as Je}from"../chunks/CodeBlock.c5b6371f.js";import{H as x,E as nn}from"../chunks/getInferenceSnippets.dcce2733.js";function tn(k){let t,J="Example:",m,r,c;return r=new Je({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEElMEFmcm9tJTIwa2VybmVscyUyMGltcG9ydCUyMHVzZV9rZXJuZWxfZm9yd2FyZF9mcm9tX2h1YiUwQWZyb20lMjBrZXJuZWxzJTIwaW1wb3J0JTIwTW9kZSUyQyUyMGtlcm5lbGl6ZSUwQSUwQSU0MHVzZV9rZXJuZWxfZm9yd2FyZF9mcm9tX2h1YiglMjJNeUN1c3RvbUxheWVyJTIyKSUwQWNsYXNzJTIwTXlDdXN0b21MYXllcihubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGhpZGRlbl9zaXplKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaGlkZGVuX3NpemUlMjAlM0QlMjBoaWRkZW5fc2l6ZSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHglM0ElMjB0b3JjaC5UZW5zb3IpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwb3JpZ2luYWwlMjBpbXBsZW1lbnRhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHglMEElMEFtb2RlbCUyMCUzRCUyME15Q3VzdG9tTGF5ZXIoNzY4KSUwQSUwQSUyMyUyMFRoZSUyMGxheWVyJTIwY2FuJTIwbm93JTIwYmUlMjBrZXJuZWxpemVkJTNBJTBBJTIzJTIwbW9kZWwlMjAlM0QlMjBrZXJuZWxpemUobW9kZWwlMkMlMjBtb2RlJTNETW9kZS5UUkFJTklORyUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_forward_from_hub
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> Mode, kernelize

<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;MyCustomLayer&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCustomLayer</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, hidden_size</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.hidden_size = hidden_size

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>):
        <span class="hljs-comment"># original implementation</span>
        <span class="hljs-keyword">return</span> x

model = MyCustomLayer(<span class="hljs-number">768</span>)

<span class="hljs-comment"># The layer can now be kernelized:</span>
<span class="hljs-comment"># model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE, device=&quot;cuda&quot;)</span>`,wrap:!1}}),{c(){t=w("p"),t.textContent=J,m=a(),M(r.$$.fragment)},l(l){t=f(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-11lpom8"&&(t.textContent=J),m=o(l),y(r.$$.fragment,l)},m(l,g){p(l,t,g),p(l,m,g),d(r,l,g),c=!0},p:ge,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){U(r.$$.fragment,l),c=!1},d(l){l&&(s(t),s(m)),h(r,l)}}}function sn(k){let t,J="Example:",m,r,c;return r=new Je({props:{code:"ZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjByZXBsYWNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViJTBBaW1wb3J0JTIwdG9yY2gubm4lMjBhcyUyMG5uJTBBJTBBcmVwbGFjZV9rZXJuZWxfZm9yd2FyZF9mcm9tX2h1Yihubi5MYXllck5vcm0lMkMlMjAlMjJMYXllck5vcm0lMjIp",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> replace_kernel_forward_from_hub
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

replace_kernel_forward_from_hub(nn.LayerNorm, <span class="hljs-string">&quot;LayerNorm&quot;</span>)`,wrap:!1}}),{c(){t=w("p"),t.textContent=J,m=a(),M(r.$$.fragment)},l(l){t=f(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-11lpom8"&&(t.textContent=J),m=o(l),y(r.$$.fragment,l)},m(l,g){p(l,t,g),p(l,m,g),d(r,l,g),c=!0},p:ge,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){U(r.$$.fragment,l),c=!1},d(l){l&&(s(t),s(m)),h(r,l)}}}function rn(k){let t,J="Example:",m,r,c;return r=new Je({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwdG9yY2gubm4lMjBpbXBvcnQlMjBmdW5jdGlvbmFsJTIwYXMlMjBGJTBBJTBBZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjB1c2Vfa2VybmVsX2ZvcndhcmRfZnJvbV9odWIlMEFmcm9tJTIwa2VybmVscyUyMGltcG9ydCUyMHVzZV9rZXJuZWxfbWFwcGluZyUyQyUyMExheWVyUmVwb3NpdG9yeSUyQyUyMERldmljZSUwQWZyb20lMjBrZXJuZWxzJTIwaW1wb3J0JTIwTW9kZSUyQyUyMGtlcm5lbGl6ZSUwQSUwQSUyMyUyMERlZmluZSUyMGElMjBtYXBwaW5nJTBBbWFwcGluZyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMlNpbHVBbmRNdWwlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjdWRhJTIyJTNBJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlN0QlMEElN0QlMEElMEElNDB1c2Vfa2VybmVsX2ZvcndhcmRfZnJvbV9odWIoJTIyU2lsdUFuZE11bCUyMiklMEFjbGFzcyUyMFNpbHVBbmRNdWwobm4uTW9kdWxlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHglM0ElMjB0b3JjaC5UZW5zb3IpJTIwLSUzRSUyMHRvcmNoLlRlbnNvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGQlMjAlM0QlMjB4LnNoYXBlJTVCLTElNUQlMjAlMkYlMkYlMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwRi5zaWx1KHglNUIuLi4lMkMlMjAlM0FkJTVEKSUyMColMjB4JTVCLi4uJTJDJTIwZCUzQSU1RCUwQSUwQW1vZGVsJTIwJTNEJTIwU2lsdUFuZE11bCgpJTBBJTBBJTIzJTIwVXNlJTIwdGhlJTIwbWFwcGluZyUyMGZvciUyMHRoZSUyMGR1cmF0aW9uJTIwb2YlMjB0aGUlMjBjb250ZXh0LiUwQXdpdGglMjB1c2Vfa2VybmVsX21hcHBpbmcobWFwcGluZyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBrZXJuZWxpemUlMjB1c2VzJTIwdGhlJTIwdGVtcG9yYXJ5JTIwbWFwcGluZyUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwa2VybmVsaXplKG1vZGVsJTJDJTIwbW9kZSUzRE1vZGUuVFJBSU5JTkclMjAlN0MlMjBNb2RlLlRPUkNIX0NPTVBJTEUlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQSUwQSUyMyUyME91dHNpZGUlMjB0aGUlMjBjb250ZXh0JTJDJTIwb3JpZ2luYWwlMjBtYXBwaW5ncyUyMGFyZSUyMHJlc3RvcmVk",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> torch.nn <span class="hljs-keyword">import</span> functional <span class="hljs-keyword">as</span> F

<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_forward_from_hub
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_mapping, LayerRepository, Device
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> Mode, kernelize

<span class="hljs-comment"># Define a mapping</span>
mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        )
    }
}

<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;SiluAndMul&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>) -&gt; torch.Tensor:
        d = x.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        <span class="hljs-keyword">return</span> F.silu(x[..., :d]) * x[..., d:]

model = SiluAndMul()

<span class="hljs-comment"># Use the mapping for the duration of the context.</span>
<span class="hljs-keyword">with</span> use_kernel_mapping(mapping):
    <span class="hljs-comment"># kernelize uses the temporary mapping</span>
    model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE, device=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Outside the context, original mappings are restored</span>`,wrap:!1}}),{c(){t=w("p"),t.textContent=J,m=a(),M(r.$$.fragment)},l(l){t=f(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-11lpom8"&&(t.textContent=J),m=o(l),y(r.$$.fragment,l)},m(l,g){p(l,t,g),p(l,m,g),d(r,l,g),c=!0},p:ge,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){U(r.$$.fragment,l),c=!1},d(l){l&&(s(t),s(m)),h(r,l)}}}function an(k){let t,J="Example:",m,r,c;return r=new Je({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> LayerRepository, register_kernel_mapping, Mode

<span class="hljs-comment"># Simple mapping for a single kernel per device</span>
kernel_layer_mapping = {
    <span class="hljs-string">&quot;LlamaRMSNorm&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;RmsNorm&quot;</span>,
            revision=<span class="hljs-string">&quot;layers&quot;</span>,
        ),
    },
}
register_kernel_mapping(kernel_layer_mapping)

<span class="hljs-comment"># Advanced mapping with mode-specific kernels</span>
advanced_mapping = {
    <span class="hljs-string">&quot;MultiHeadAttention&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: {
            Mode.TRAINING: LayerRepository(
                repo_id=<span class="hljs-string">&quot;username/training-kernels&quot;</span>,
                layer_name=<span class="hljs-string">&quot;TrainingAttention&quot;</span>
            ),
            Mode.INFERENCE: LayerRepository(
                repo_id=<span class="hljs-string">&quot;username/inference-kernels&quot;</span>,
                layer_name=<span class="hljs-string">&quot;FastAttention&quot;</span>
            ),
        }
    }
}
register_kernel_mapping(advanced_mapping)`,wrap:!1}}),{c(){t=w("p"),t.textContent=J,m=a(),M(r.$$.fragment)},l(l){t=f(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-11lpom8"&&(t.textContent=J),m=o(l),y(r.$$.fragment,l)},m(l,g){p(l,t,g),p(l,m,g),d(r,l,g),c=!0},p:ge,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){U(r.$$.fragment,l),c=!1},d(l){l&&(s(t),s(m)),h(r,l)}}}function on(k){let t,J="Example:",m,r,c;return r=new Je({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEElMEFmcm9tJTIwa2VybmVscyUyMGltcG9ydCUyMGtlcm5lbGl6ZSUyQyUyME1vZGUlMkMlMjByZWdpc3Rlcl9rZXJuZWxfbWFwcGluZyUyQyUyMExheWVyUmVwb3NpdG9yeSUwQWZyb20lMjBrZXJuZWxzJTIwaW1wb3J0JTIwdXNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViJTBBJTBBJTQwdXNlX2tlcm5lbF9mb3J3YXJkX2Zyb21faHViKCUyMlNpbHVBbmRNdWwlMjIpJTBBY2xhc3MlMjBTaWx1QW5kTXVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjB4JTNBJTIwdG9yY2guVGVuc29yKSUyMC0lM0UlMjB0b3JjaC5UZW5zb3IlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkJTIwJTNEJTIweC5zaGFwZSU1Qi0xJTVEJTIwJTJGJTJGJTIwMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMEYuc2lsdSh4JTVCLi4uJTJDJTIwJTNBZCU1RCklMjAqJTIweCU1Qi4uLiUyQyUyMGQlM0ElNUQlMEElMEFtYXBwaW5nJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyU2lsdUFuZE11bCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmN1ZGElMjIlM0ElMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RCUwQXJlZ2lzdGVyX2tlcm5lbF9tYXBwaW5nKG1hcHBpbmcpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwYW5kJTIwa2VybmVsaXplJTIwYSUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBubi5TZXF1ZW50aWFsKCUwQSUyMCUyMCUyMCUyMG5uLkxpbmVhcigxMDI0JTJDJTIwMjA0OCUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIpJTJDJTBBJTIwJTIwJTIwJTIwU2lsdUFuZE11bCgpJTJDJTBBKSUwQSUwQSUyMyUyMEtlcm5lbGl6ZSUyMGZvciUyMGluZmVyZW5jZSUwQWtlcm5lbGl6ZWRfbW9kZWwlMjAlM0QlMjBrZXJuZWxpemUobW9kZWwlMkMlMjBtb2RlJTNETW9kZS5UUkFJTklORyUyMCU3QyUyME1vZGUuVE9SQ0hfQ09NUElMRSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn

<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> kernelize, Mode, register_kernel_mapping, LayerRepository
<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> use_kernel_forward_from_hub

<span class="hljs-meta">@use_kernel_forward_from_hub(<span class="hljs-params"><span class="hljs-string">&quot;SiluAndMul&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">SiluAndMul</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x: torch.Tensor</span>) -&gt; torch.Tensor:
        d = x.shape[-<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
        <span class="hljs-keyword">return</span> F.silu(x[..., :d]) * x[..., d:]

mapping = {
    <span class="hljs-string">&quot;SiluAndMul&quot;</span>: {
        <span class="hljs-string">&quot;cuda&quot;</span>: LayerRepository(
            repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
            layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
        )
    }
}
register_kernel_mapping(mapping)

<span class="hljs-comment"># Create and kernelize a model</span>
model = nn.Sequential(
    nn.Linear(<span class="hljs-number">1024</span>, <span class="hljs-number">2048</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>),
    SiluAndMul(),
)

<span class="hljs-comment"># Kernelize for inference</span>
kernelized_model = kernelize(model, mode=Mode.TRAINING | Mode.TORCH_COMPILE)`,wrap:!1}}),{c(){t=w("p"),t.textContent=J,m=a(),M(r.$$.fragment)},l(l){t=f(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-11lpom8"&&(t.textContent=J),m=o(l),y(r.$$.fragment,l)},m(l,g){p(l,t,g),p(l,m,g),d(r,l,g),c=!0},p:ge,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){U(r.$$.fragment,l),c=!1},d(l){l&&(s(t),s(m)),h(r,l)}}}function pn(k){let t,J="Example:",m,r,c;return r=new Je({props:{code:"ZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjBEZXZpY2UlMkMlMjBDVURBUHJvcGVydGllcyUwQSUwQSUyMyUyMEJhc2ljJTIwQ1VEQSUyMGRldmljZSUwQWN1ZGFfZGV2aWNlJTIwJTNEJTIwRGV2aWNlKHR5cGUlM0QlMjJjdWRhJTIyKSUwQSUwQSUyMyUyMENVREElMjBkZXZpY2UlMjB3aXRoJTIwc3BlY2lmaWMlMjBjYXBhYmlsaXR5JTIwcmVxdWlyZW1lbnRzJTBBY3VkYV9kZXZpY2Vfd2l0aF9wcm9wcyUyMCUzRCUyMERldmljZSglMEElMjAlMjAlMjAlMjB0eXBlJTNEJTIyY3VkYSUyMiUyQyUwQSUyMCUyMCUyMCUyMHByb3BlcnRpZXMlM0RDVURBUHJvcGVydGllcyhtaW5fY2FwYWJpbGl0eSUzRDc1JTJDJTIwbWF4X2NhcGFiaWxpdHklM0Q5MCklMEEpJTBBJTBBJTIzJTIwTVBTJTIwZGV2aWNlJTIwZm9yJTIwQXBwbGUlMjBTaWxpY29uJTBBbXBzX2RldmljZSUyMCUzRCUyMERldmljZSh0eXBlJTNEJTIybXBzJTIyKSUwQSUwQSUyMyUyMFhQVSUyMGRldmljZSUyMChlLmcuJTJDJTIwSW50ZWwoUiklMjBEYXRhJTIwQ2VudGVyJTIwR1BVJTIwTWF4JTIwMTU1MCklMEF4cHVfZGV2aWNlJTIwJTNEJTIwRGV2aWNlKHR5cGUlM0QlMjJ4cHUlMjIpJTBBJTBBJTIzJTIwTlBVJTIwZGV2aWNlJTIwKEh1YXdlaSUyMEFzY2VuZCklMEFucHVfZGV2aWNlJTIwJTNEJTIwRGV2aWNlKHR5cGUlM0QlMjJucHUlMjIp",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> Device, CUDAProperties

<span class="hljs-comment"># Basic CUDA device</span>
cuda_device = Device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># CUDA device with specific capability requirements</span>
cuda_device_with_props = Device(
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;cuda&quot;</span>,
    properties=CUDAProperties(min_capability=<span class="hljs-number">75</span>, max_capability=<span class="hljs-number">90</span>)
)

<span class="hljs-comment"># MPS device for Apple Silicon</span>
mps_device = Device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;mps&quot;</span>)

<span class="hljs-comment"># XPU device (e.g., Intel(R) Data Center GPU Max 1550)</span>
xpu_device = Device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;xpu&quot;</span>)

<span class="hljs-comment"># NPU device (Huawei Ascend)</span>
npu_device = Device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;npu&quot;</span>)`,wrap:!1}}),{c(){t=w("p"),t.textContent=J,m=a(),M(r.$$.fragment)},l(l){t=f(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-11lpom8"&&(t.textContent=J),m=o(l),y(r.$$.fragment,l)},m(l,g){p(l,t,g),p(l,m,g),d(r,l,g),c=!0},p:ge,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){U(r.$$.fragment,l),c=!1},d(l){l&&(s(t),s(m)),h(r,l)}}}function cn(k){let t,J="Example:",m,r,c;return r=new Je({props:{code:"ZnJvbSUyMGtlcm5lbHMlMjBpbXBvcnQlMjBMYXllclJlcG9zaXRvcnklMEElMEElMjMlMjBSZWZlcmVuY2UlMjBhJTIwc3BlY2lmaWMlMjBsYXllciUyMGJ5JTIwcmV2aXNpb24lMEFsYXllcl9yZXBvJTIwJTNEJTIwTGF5ZXJSZXBvc2l0b3J5KCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJrZXJuZWxzLWNvbW11bml0eSUyRmFjdGl2YXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBsYXllcl9uYW1lJTNEJTIyU2lsdUFuZE11bCUyMiUyQyUwQSklMEElMEElMjMlMjBSZWZlcmVuY2UlMjBhJTIwbGF5ZXIlMjBieSUyMHZlcnNpb24lMjBjb25zdHJhaW50JTBBbGF5ZXJfcmVwb192ZXJzaW9uZWQlMjAlM0QlMjBMYXllclJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmtlcm5lbHMtY29tbXVuaXR5JTJGYWN0aXZhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGxheWVyX25hbWUlM0QlMjJTaWx1QW5kTXVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdmVyc2lvbiUzRCUyMiUzRSUzRDAuMC4zJTJDJTNDMC4xJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> kernels <span class="hljs-keyword">import</span> LayerRepository

<span class="hljs-comment"># Reference a specific layer by revision</span>
layer_repo = LayerRepository(
    repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
    layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
)

<span class="hljs-comment"># Reference a layer by version constraint</span>
layer_repo_versioned = LayerRepository(
    repo_id=<span class="hljs-string">&quot;kernels-community/activation&quot;</span>,
    layer_name=<span class="hljs-string">&quot;SiluAndMul&quot;</span>,
    version=<span class="hljs-string">&quot;&gt;=0.0.3,&lt;0.1&quot;</span>
)`,wrap:!1}}),{c(){t=w("p"),t.textContent=J,m=a(),M(r.$$.fragment)},l(l){t=f(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-11lpom8"&&(t.textContent=J),m=o(l),y(r.$$.fragment,l)},m(l,g){p(l,t,g),p(l,m,g),d(r,l,g),c=!0},p:ge,i(l){c||(u(r.$$.fragment,l),c=!0)},o(l){U(r.$$.fragment,l),c=!1},d(l){l&&(s(t),s(m)),h(r,l)}}}function mn(k){let t,J,m,r,c,l,g,Ve,P,Qe,j,K,il,Te,El="Decorator factory that makes a layer extensible using the specified layer name.",cl,ke,Gl=`This is a decorator factory that returns a decorator which prepares a layer class to use kernels from the
Hugging Face Hub.`,ml,Q,Ne,O,ze,C,ee,Ml,be,Rl="Function that prepares a layer class to use kernels from the Hugging Face Hub.",yl,je,Wl=`It is recommended to use <a href="/docs/kernels/pr_155/en/api/layers#kernels.use_kernel_forward_from_hub">use_kernel_forward_from_hub()</a> decorator instead.
This function should only be used as a last resort to extend third-party layers,
it is inherently fragile since the member variables and <code>forward</code> signature
of usch a layer can change.`,dl,N,Fe,le,De,ne,Ye,$,te,ul,Ce,Al="Context manager that sets a kernel mapping for the duration of the context.",Ul,$e,Sl=`This function allows temporary kernel mappings to be applied within a specific context, enabling different
kernel configurations for different parts of your code.`,hl,z,Le,se,He,_,re,wl,_e,Xl="Register a global mapping between layer names and their corresponding kernel implementations.",fl,Ie,Vl=`This function allows you to register a mapping between a layer name and the corresponding kernel(s) to use,
depending on the device and mode. This should be used in conjunction with <a href="/docs/kernels/pr_155/en/api/layers#kernels.kernelize">kernelize()</a>.`,gl,F,qe,ae,Pe,oe,Ke,I,pe,Jl,ve,Ql="Replace layer forward methods with optimized kernel implementations.",Tl,Be,Nl=`This function iterates over all modules in the model and replaces the <code>forward</code> method of extensible layers
for which kernels are registered using <a href="/docs/kernels/pr_155/en/api/layers#kernels.register_kernel_mapping">register_kernel_mapping()</a> or <a href="/docs/kernels/pr_155/en/api/layers#kernels.use_kernel_mapping">use_kernel_mapping()</a>.`,kl,D,Oe,ie,el,ce,ll,b,me,bl,xe,zl="Represents a compute device with optional properties.",jl,Ze,Fl=`This class encapsulates device information including device type and optional device-specific properties
like CUDA capabilities.`,Cl,Y,$l,L,Me,_l,Ee,Dl="Create an appropriate repository set for this device type.",nl,ye,tl,v,de,Il,Ge,Yl="Kernelize mode",vl,Re,Ll=`The <code>Mode</code> flag is used by <a href="/docs/kernels/pr_155/en/api/layers#kernels.kernelize">kernelize()</a> to select kernels for the given mode. Mappings can be registered for
specific modes.`,Bl,We,Hl=`Note:
Different modes can be combined. For instance, <code>INFERENCE | TORCH_COMPILE</code> should be used for layers that
are used for inference <em>with</em> <code>torch.compile</code>.`,sl,ue,rl,Z,Ue,xl,Ae,ql="Repository and name of a layer for kernel mapping.",Zl,H,al,he,ol,Xe,pl;return c=new x({props:{title:"Layers API Reference",local:"layers-api-reference",headingTag:"h1"}}),g=new x({props:{title:"Making layers kernel-aware",local:"making-layers-kernel-aware",headingTag:"h2"}}),P=new x({props:{title:"use_kernel_forward_from_hub",local:"kernels.use_kernel_forward_from_hub",headingTag:"h3"}}),K=new V({props:{name:"kernels.use_kernel_forward_from_hub",anchor:"kernels.use_kernel_forward_from_hub",parameters:[{name:"layer_name",val:": str"}],parametersDescription:[{anchor:"kernels.use_kernel_forward_from_hub.layer_name",description:`<strong>layer_name</strong> (<code>str</code>) &#x2014;
The name of the layer to use for kernel lookup in registered mappings.`,name:"layer_name"}],source:"https://github.com/huggingface/kernels/blob/vr_155/src/kernels/layer.py#L988",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A decorator function that can be applied to layer classes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Callable</code></p>
`}}),Q=new fe({props:{anchor:"kernels.use_kernel_forward_from_hub.example",$$slots:{default:[tn]},$$scope:{ctx:k}}}),O=new x({props:{title:"replace_kernel_forward_from_hub",local:"kernels.replace_kernel_forward_from_hub",headingTag:"h3"}}),ee=new V({props:{name:"kernels.replace_kernel_forward_from_hub",anchor:"kernels.replace_kernel_forward_from_hub",parameters:[{name:"layer_name",val:": str"}],source:"https://github.com/huggingface/kernels/blob/vr_155/src/kernels/layer.py#L753"}}),N=new fe({props:{anchor:"kernels.replace_kernel_forward_from_hub.example",$$slots:{default:[sn]},$$scope:{ctx:k}}}),le=new x({props:{title:"Registering kernel mappings",local:"registering-kernel-mappings",headingTag:"h2"}}),ne=new x({props:{title:"use_kernel_mapping",local:"kernels.use_kernel_mapping",headingTag:"h3"}}),te=new V({props:{name:"kernels.use_kernel_mapping",anchor:"kernels.use_kernel_mapping",parameters:[{name:"mapping",val:": Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]"},{name:"inherit_mapping",val:": bool = True"}],parametersDescription:[{anchor:"kernels.use_kernel_mapping.mapping",description:`<strong>mapping</strong> (<code>Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]</code>) &#x2014;
The kernel mapping to apply. Maps layer names to device-specific kernel configurations.`,name:"mapping"},{anchor:"kernels.use_kernel_mapping.inherit_mapping",description:`<strong>inherit_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
When <code>True</code>, the current mapping will be extended by <code>mapping</code> inside the context. When <code>False</code>,
only <code>mapping</code> is used inside the context.`,name:"inherit_mapping"}],source:"https://github.com/huggingface/kernels/blob/vr_155/src/kernels/layer.py#L596",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Context manager that handles the temporary kernel mapping.</p>
`}}),z=new fe({props:{anchor:"kernels.use_kernel_mapping.example",$$slots:{default:[rn]},$$scope:{ctx:k}}}),se=new x({props:{title:"register_kernel_mapping",local:"kernels.register_kernel_mapping",headingTag:"h3"}}),re=new V({props:{name:"kernels.register_kernel_mapping",anchor:"kernels.register_kernel_mapping",parameters:[{name:"mapping",val:": Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]"},{name:"inherit_mapping",val:": bool = True"}],parametersDescription:[{anchor:"kernels.register_kernel_mapping.mapping",description:`<strong>mapping</strong> (<code>Dict[str, Dict[Union[Device, str], Union[LayerRepositoryProtocol, Dict[Mode, LayerRepositoryProtocol]]]]</code>) &#x2014;
The kernel mapping to register globally. Maps layer names to device-specific kernels.
The mapping can specify different kernels for different modes (training, inference, etc.).`,name:"mapping"},{anchor:"kernels.register_kernel_mapping.inherit_mapping",description:`<strong>inherit_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
When <code>True</code>, the current mapping will be extended by <code>mapping</code>. When <code>False</code>, the existing mappings
are erased before adding <code>mapping</code>.`,name:"inherit_mapping"}],source:"https://github.com/huggingface/kernels/blob/vr_155/src/kernels/layer.py#L675"}}),F=new fe({props:{anchor:"kernels.register_kernel_mapping.example",$$slots:{default:[an]},$$scope:{ctx:k}}}),ae=new x({props:{title:"Kernelizing a model",local:"kernelizing-a-model",headingTag:"h2"}}),oe=new x({props:{title:"kernelize",local:"kernels.kernelize",headingTag:"h3"}}),pe=new V({props:{name:"kernels.kernelize",anchor:"kernels.kernelize",parameters:[{name:"model",val:": 'nn.Module'"},{name:"mode",val:": Mode"},{name:"device",val:": Optional[Union[str, 'torch.device']] = None"},{name:"use_fallback",val:": bool = True"}],parametersDescription:[{anchor:"kernels.kernelize.model",description:`<strong>model</strong> (<code>nn.Module</code>) &#x2014;
The PyTorch model to kernelize.`,name:"model"},{anchor:"kernels.kernelize.mode",description:`<strong>mode</strong> (<a href="/docs/kernels/pr_155/en/api/layers#kernels.Mode">Mode</a>) &#x2014; The mode that the kernel is going to be used in. For example,
<code>Mode.TRAINING | Mode.TORCH_COMPILE</code> kernelizes the model for training with
<code>torch.compile</code>.`,name:"mode"},{anchor:"kernels.kernelize.device",description:`<strong>device</strong> (<code>Union[str, torch.device]</code>, <em>optional</em>) &#x2014;
The device type to load kernels for. Supported device types are: &#x201C;cuda&#x201D;, &#x201C;mps&#x201D;, &#x201C;npu&#x201D;, &#x201C;rocm&#x201D;, &#x201C;xpu&#x201D;.
The device type will be inferred from the model parameters when not provided.`,name:"device"},{anchor:"kernels.kernelize.use_fallback",description:`<strong>use_fallback</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use the original forward method of modules when no compatible kernel could be found.
If set to <code>False</code>, an exception will be raised in such cases.`,name:"use_fallback"}],source:"https://github.com/huggingface/kernels/blob/vr_155/src/kernels/layer.py#L822",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The kernelized model with optimized kernel implementations.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>nn.Module</code></p>
`}}),D=new fe({props:{anchor:"kernels.kernelize.example",$$slots:{default:[on]},$$scope:{ctx:k}}}),ie=new x({props:{title:"Classes",local:"classes",headingTag:"h2"}}),ce=new x({props:{title:"Device",local:"kernels.Device",headingTag:"h3"}}),me=new V({props:{name:"class kernels.Device",anchor:"kernels.Device",parameters:[{name:"type",val:": str"},{name:"properties",val:": Optional[CUDAProperties] = None"}],parametersDescription:[{anchor:"kernels.Device.type",description:`<strong>type</strong> (<code>str</code>) &#x2014;
The device type (e.g., &#x201C;cuda&#x201D;, &#x201C;mps&#x201D;, &#x201C;npu&#x201D;, &#x201C;rocm&#x201D;, &#x201C;xpu&#x201D;).`,name:"type"},{anchor:"kernels.Device.properties",description:`<strong>properties</strong> (<code>CUDAProperties</code>, <em>optional</em>) &#x2014;
Device-specific properties. Currently only <code>CUDAProperties</code> is supported for CUDA devices.`,name:"properties"}],source:"https://github.com/huggingface/kernels/blob/vr_155/src/kernels/layer.py#L81"}}),Y=new fe({props:{anchor:"kernels.Device.example",$$slots:{default:[pn]},$$scope:{ctx:k}}}),Me=new V({props:{name:"create_repo",anchor:"kernels.Device.create_repo",parameters:[],source:"https://github.com/huggingface/kernels/blob/vr_155/src/kernels/layer.py#L126"}}),ye=new x({props:{title:"Mode",local:"kernels.Mode",headingTag:"h3"}}),de=new V({props:{name:"class kernels.Mode",anchor:"kernels.Mode",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],parametersDescription:[{anchor:"kernels.Mode.INFERENCE",description:"<strong>INFERENCE</strong> &#x2014; The kernel is used for inference.",name:"INFERENCE"},{anchor:"kernels.Mode.TRAINING",description:"<strong>TRAINING</strong> &#x2014; The kernel is used for training.",name:"TRAINING"},{anchor:"kernels.Mode.TORCH_COMPILE",description:"<strong>TORCH_COMPILE</strong> &#x2014; The kernel is used with <code>torch.compile</code>.",name:"TORCH_COMPILE"},{anchor:"kernels.Mode.FALLBACK",description:"<strong>FALLBACK</strong> &#x2014; In a kernel mapping, this kernel is used when no other mode matches.",name:"FALLBACK"}],source:"https://github.com/huggingface/kernels/blob/vr_155/src/kernels/layer.py#L43"}}),ue=new x({props:{title:"LayerRepository",local:"kernels.LayerRepository",headingTag:"h3"}}),Ue=new V({props:{name:"class kernels.LayerRepository",anchor:"kernels.LayerRepository",parameters:[{name:"repo_id",val:": str"},{name:"layer_name",val:": str"},{name:"revision",val:": Optional[str] = None"},{name:"version",val:": Optional[str] = None"}],parametersDescription:[{anchor:"kernels.LayerRepository.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The Hub repository containing the layer.`,name:"repo_id"},{anchor:"kernels.LayerRepository.layer_name",description:`<strong>layer_name</strong> (<code>str</code>) &#x2014;
The name of the layer within the kernel repository.`,name:"layer_name"},{anchor:"kernels.LayerRepository.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific revision (branch, tag, or commit) to download. Cannot be used together with <code>version</code>.`,name:"revision"},{anchor:"kernels.LayerRepository.version",description:`<strong>version</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The kernel version to download. This can be a Python version specifier, such as <code>&quot;&gt;=1.0.0,&lt;2.0.0&quot;</code>.
Cannot be used together with <code>revision</code>.`,name:"version"}],source:"https://github.com/huggingface/kernels/blob/vr_155/src/kernels/layer.py#L247"}}),H=new fe({props:{anchor:"kernels.LayerRepository.example",$$slots:{default:[cn]},$$scope:{ctx:k}}}),he=new nn({props:{source:"https://github.com/huggingface/kernels/blob/main/docs/source/api/layers.md"}}),{c(){t=w("meta"),J=a(),m=w("p"),r=a(),M(c.$$.fragment),l=a(),M(g.$$.fragment),Ve=a(),M(P.$$.fragment),Qe=a(),j=w("div"),M(K.$$.fragment),il=a(),Te=w("p"),Te.textContent=El,cl=a(),ke=w("p"),ke.textContent=Gl,ml=a(),M(Q.$$.fragment),Ne=a(),M(O.$$.fragment),ze=a(),C=w("div"),M(ee.$$.fragment),Ml=a(),be=w("p"),be.textContent=Rl,yl=a(),je=w("p"),je.innerHTML=Wl,dl=a(),M(N.$$.fragment),Fe=a(),M(le.$$.fragment),De=a(),M(ne.$$.fragment),Ye=a(),$=w("div"),M(te.$$.fragment),ul=a(),Ce=w("p"),Ce.textContent=Al,Ul=a(),$e=w("p"),$e.textContent=Sl,hl=a(),M(z.$$.fragment),Le=a(),M(se.$$.fragment),He=a(),_=w("div"),M(re.$$.fragment),wl=a(),_e=w("p"),_e.textContent=Xl,fl=a(),Ie=w("p"),Ie.innerHTML=Vl,gl=a(),M(F.$$.fragment),qe=a(),M(ae.$$.fragment),Pe=a(),M(oe.$$.fragment),Ke=a(),I=w("div"),M(pe.$$.fragment),Jl=a(),ve=w("p"),ve.textContent=Ql,Tl=a(),Be=w("p"),Be.innerHTML=Nl,kl=a(),M(D.$$.fragment),Oe=a(),M(ie.$$.fragment),el=a(),M(ce.$$.fragment),ll=a(),b=w("div"),M(me.$$.fragment),bl=a(),xe=w("p"),xe.textContent=zl,jl=a(),Ze=w("p"),Ze.textContent=Fl,Cl=a(),M(Y.$$.fragment),$l=a(),L=w("div"),M(Me.$$.fragment),_l=a(),Ee=w("p"),Ee.textContent=Dl,nl=a(),M(ye.$$.fragment),tl=a(),v=w("div"),M(de.$$.fragment),Il=a(),Ge=w("p"),Ge.textContent=Yl,vl=a(),Re=w("p"),Re.innerHTML=Ll,Bl=a(),We=w("p"),We.innerHTML=Hl,sl=a(),M(ue.$$.fragment),rl=a(),Z=w("div"),M(Ue.$$.fragment),xl=a(),Ae=w("p"),Ae.textContent=ql,Zl=a(),M(H.$$.fragment),al=a(),M(he.$$.fragment),ol=a(),Xe=w("p"),this.h()},l(e){const n=ln("svelte-u9bgzb",document.head);t=f(n,"META",{name:!0,content:!0}),n.forEach(s),J=o(e),m=f(e,"P",{}),S(m).forEach(s),r=o(e),y(c.$$.fragment,e),l=o(e),y(g.$$.fragment,e),Ve=o(e),y(P.$$.fragment,e),Qe=o(e),j=f(e,"DIV",{class:!0});var E=S(j);y(K.$$.fragment,E),il=o(E),Te=f(E,"P",{"data-svelte-h":!0}),T(Te)!=="svelte-17ebw3h"&&(Te.textContent=El),cl=o(E),ke=f(E,"P",{"data-svelte-h":!0}),T(ke)!=="svelte-wgdatn"&&(ke.textContent=Gl),ml=o(E),y(Q.$$.fragment,E),E.forEach(s),Ne=o(e),y(O.$$.fragment,e),ze=o(e),C=f(e,"DIV",{class:!0});var G=S(C);y(ee.$$.fragment,G),Ml=o(G),be=f(G,"P",{"data-svelte-h":!0}),T(be)!=="svelte-17bjf1v"&&(be.textContent=Rl),yl=o(G),je=f(G,"P",{"data-svelte-h":!0}),T(je)!=="svelte-jegrb2"&&(je.innerHTML=Wl),dl=o(G),y(N.$$.fragment,G),G.forEach(s),Fe=o(e),y(le.$$.fragment,e),De=o(e),y(ne.$$.fragment,e),Ye=o(e),$=f(e,"DIV",{class:!0});var R=S($);y(te.$$.fragment,R),ul=o(R),Ce=f(R,"P",{"data-svelte-h":!0}),T(Ce)!=="svelte-4v5vcp"&&(Ce.textContent=Al),Ul=o(R),$e=f(R,"P",{"data-svelte-h":!0}),T($e)!=="svelte-124m5et"&&($e.textContent=Sl),hl=o(R),y(z.$$.fragment,R),R.forEach(s),Le=o(e),y(se.$$.fragment,e),He=o(e),_=f(e,"DIV",{class:!0});var W=S(_);y(re.$$.fragment,W),wl=o(W),_e=f(W,"P",{"data-svelte-h":!0}),T(_e)!=="svelte-h5yso0"&&(_e.textContent=Xl),fl=o(W),Ie=f(W,"P",{"data-svelte-h":!0}),T(Ie)!=="svelte-xlvp0i"&&(Ie.innerHTML=Vl),gl=o(W),y(F.$$.fragment,W),W.forEach(s),qe=o(e),y(ae.$$.fragment,e),Pe=o(e),y(oe.$$.fragment,e),Ke=o(e),I=f(e,"DIV",{class:!0});var A=S(I);y(pe.$$.fragment,A),Jl=o(A),ve=f(A,"P",{"data-svelte-h":!0}),T(ve)!=="svelte-11gfrdt"&&(ve.textContent=Ql),Tl=o(A),Be=f(A,"P",{"data-svelte-h":!0}),T(Be)!=="svelte-11cld8h"&&(Be.innerHTML=Nl),kl=o(A),y(D.$$.fragment,A),A.forEach(s),Oe=o(e),y(ie.$$.fragment,e),el=o(e),y(ce.$$.fragment,e),ll=o(e),b=f(e,"DIV",{class:!0});var B=S(b);y(me.$$.fragment,B),bl=o(B),xe=f(B,"P",{"data-svelte-h":!0}),T(xe)!=="svelte-19eu2wi"&&(xe.textContent=zl),jl=o(B),Ze=f(B,"P",{"data-svelte-h":!0}),T(Ze)!=="svelte-9t0i4c"&&(Ze.textContent=Fl),Cl=o(B),y(Y.$$.fragment,B),$l=o(B),L=f(B,"DIV",{class:!0});var we=S(L);y(Me.$$.fragment,we),_l=o(we),Ee=f(we,"P",{"data-svelte-h":!0}),T(Ee)!=="svelte-1naj9x1"&&(Ee.textContent=Dl),we.forEach(s),B.forEach(s),nl=o(e),y(ye.$$.fragment,e),tl=o(e),v=f(e,"DIV",{class:!0});var q=S(v);y(de.$$.fragment,q),Il=o(q),Ge=f(q,"P",{"data-svelte-h":!0}),T(Ge)!=="svelte-wlnf64"&&(Ge.textContent=Yl),vl=o(q),Re=f(q,"P",{"data-svelte-h":!0}),T(Re)!=="svelte-1gsy7du"&&(Re.innerHTML=Ll),Bl=o(q),We=f(q,"P",{"data-svelte-h":!0}),T(We)!=="svelte-x58jtu"&&(We.innerHTML=Hl),q.forEach(s),sl=o(e),y(ue.$$.fragment,e),rl=o(e),Z=f(e,"DIV",{class:!0});var Se=S(Z);y(Ue.$$.fragment,Se),xl=o(Se),Ae=f(Se,"P",{"data-svelte-h":!0}),T(Ae)!=="svelte-1foq575"&&(Ae.textContent=ql),Zl=o(Se),y(H.$$.fragment,Se),Se.forEach(s),al=o(e),y(he.$$.fragment,e),ol=o(e),Xe=f(e,"P",{}),S(Xe).forEach(s),this.h()},h(){X(t,"name","hf:doc:metadata"),X(t,"content",Mn),X(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),X(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),X($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),X(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),X(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),X(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),X(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),X(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),X(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){i(document.head,t),p(e,J,n),p(e,m,n),p(e,r,n),d(c,e,n),p(e,l,n),d(g,e,n),p(e,Ve,n),d(P,e,n),p(e,Qe,n),p(e,j,n),d(K,j,null),i(j,il),i(j,Te),i(j,cl),i(j,ke),i(j,ml),d(Q,j,null),p(e,Ne,n),d(O,e,n),p(e,ze,n),p(e,C,n),d(ee,C,null),i(C,Ml),i(C,be),i(C,yl),i(C,je),i(C,dl),d(N,C,null),p(e,Fe,n),d(le,e,n),p(e,De,n),d(ne,e,n),p(e,Ye,n),p(e,$,n),d(te,$,null),i($,ul),i($,Ce),i($,Ul),i($,$e),i($,hl),d(z,$,null),p(e,Le,n),d(se,e,n),p(e,He,n),p(e,_,n),d(re,_,null),i(_,wl),i(_,_e),i(_,fl),i(_,Ie),i(_,gl),d(F,_,null),p(e,qe,n),d(ae,e,n),p(e,Pe,n),d(oe,e,n),p(e,Ke,n),p(e,I,n),d(pe,I,null),i(I,Jl),i(I,ve),i(I,Tl),i(I,Be),i(I,kl),d(D,I,null),p(e,Oe,n),d(ie,e,n),p(e,el,n),d(ce,e,n),p(e,ll,n),p(e,b,n),d(me,b,null),i(b,bl),i(b,xe),i(b,jl),i(b,Ze),i(b,Cl),d(Y,b,null),i(b,$l),i(b,L),d(Me,L,null),i(L,_l),i(L,Ee),p(e,nl,n),d(ye,e,n),p(e,tl,n),p(e,v,n),d(de,v,null),i(v,Il),i(v,Ge),i(v,vl),i(v,Re),i(v,Bl),i(v,We),p(e,sl,n),d(ue,e,n),p(e,rl,n),p(e,Z,n),d(Ue,Z,null),i(Z,xl),i(Z,Ae),i(Z,Zl),d(H,Z,null),p(e,al,n),d(he,e,n),p(e,ol,n),p(e,Xe,n),pl=!0},p(e,[n]){const E={};n&2&&(E.$$scope={dirty:n,ctx:e}),Q.$set(E);const G={};n&2&&(G.$$scope={dirty:n,ctx:e}),N.$set(G);const R={};n&2&&(R.$$scope={dirty:n,ctx:e}),z.$set(R);const W={};n&2&&(W.$$scope={dirty:n,ctx:e}),F.$set(W);const A={};n&2&&(A.$$scope={dirty:n,ctx:e}),D.$set(A);const B={};n&2&&(B.$$scope={dirty:n,ctx:e}),Y.$set(B);const we={};n&2&&(we.$$scope={dirty:n,ctx:e}),H.$set(we)},i(e){pl||(u(c.$$.fragment,e),u(g.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(Q.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(N.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(te.$$.fragment,e),u(z.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),u(F.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),u(pe.$$.fragment,e),u(D.$$.fragment,e),u(ie.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(Y.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(de.$$.fragment,e),u(ue.$$.fragment,e),u(Ue.$$.fragment,e),u(H.$$.fragment,e),u(he.$$.fragment,e),pl=!0)},o(e){U(c.$$.fragment,e),U(g.$$.fragment,e),U(P.$$.fragment,e),U(K.$$.fragment,e),U(Q.$$.fragment,e),U(O.$$.fragment,e),U(ee.$$.fragment,e),U(N.$$.fragment,e),U(le.$$.fragment,e),U(ne.$$.fragment,e),U(te.$$.fragment,e),U(z.$$.fragment,e),U(se.$$.fragment,e),U(re.$$.fragment,e),U(F.$$.fragment,e),U(ae.$$.fragment,e),U(oe.$$.fragment,e),U(pe.$$.fragment,e),U(D.$$.fragment,e),U(ie.$$.fragment,e),U(ce.$$.fragment,e),U(me.$$.fragment,e),U(Y.$$.fragment,e),U(Me.$$.fragment,e),U(ye.$$.fragment,e),U(de.$$.fragment,e),U(ue.$$.fragment,e),U(Ue.$$.fragment,e),U(H.$$.fragment,e),U(he.$$.fragment,e),pl=!1},d(e){e&&(s(J),s(m),s(r),s(l),s(Ve),s(Qe),s(j),s(Ne),s(ze),s(C),s(Fe),s(De),s(Ye),s($),s(Le),s(He),s(_),s(qe),s(Pe),s(Ke),s(I),s(Oe),s(el),s(ll),s(b),s(nl),s(tl),s(v),s(sl),s(rl),s(Z),s(al),s(ol),s(Xe)),s(t),h(c,e),h(g,e),h(P,e),h(K),h(Q),h(O,e),h(ee),h(N),h(le,e),h(ne,e),h(te),h(z),h(se,e),h(re),h(F),h(ae,e),h(oe,e),h(pe),h(D),h(ie,e),h(ce,e),h(me),h(Y),h(Me),h(ye,e),h(de),h(ue,e),h(Ue),h(H),h(he,e)}}}const Mn='{"title":"Layers API Reference","local":"layers-api-reference","sections":[{"title":"Making layers kernel-aware","local":"making-layers-kernel-aware","sections":[{"title":"use_kernel_forward_from_hub","local":"kernels.use_kernel_forward_from_hub","sections":[],"depth":3},{"title":"replace_kernel_forward_from_hub","local":"kernels.replace_kernel_forward_from_hub","sections":[],"depth":3}],"depth":2},{"title":"Registering kernel mappings","local":"registering-kernel-mappings","sections":[{"title":"use_kernel_mapping","local":"kernels.use_kernel_mapping","sections":[],"depth":3},{"title":"register_kernel_mapping","local":"kernels.register_kernel_mapping","sections":[],"depth":3}],"depth":2},{"title":"Kernelizing a model","local":"kernelizing-a-model","sections":[{"title":"kernelize","local":"kernels.kernelize","sections":[],"depth":3}],"depth":2},{"title":"Classes","local":"classes","sections":[{"title":"Device","local":"kernels.Device","sections":[],"depth":3},{"title":"Mode","local":"kernels.Mode","sections":[],"depth":3},{"title":"LayerRepository","local":"kernels.LayerRepository","sections":[],"depth":3}],"depth":2}],"depth":1}';function yn(k){return Kl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fn extends Ol{constructor(t){super(),en(this,t,yn,mn,Pl,{})}}export{fn as component};
