import{s as Dn,o as On,n as $}from"../chunks/scheduler.b108d059.js";import{S as Kn,i as es,g as r,s as a,r as M,A as ts,h as p,f as l,c as i,j as Yn,u as y,x as u,k as Pn,y as ls,a as n,v as d,d as c,t as m,w as h}from"../chunks/index.008de539.js";import{T as b}from"../chunks/Tip.aeb15ab7.js";import{C as g}from"../chunks/CodeBlock.7b00c886.js";import{H as A,E as ns}from"../chunks/getInferenceSnippets.79dc142e.js";function ss(w){let s,T='Note that this example will go through the Python SDK / Azure CLI programmatic deployment, if you’d rather prefer using the one-click deployment experience, please check <a href="https://huggingface.co/docs/microsoft-azure/guides/one-click-deployment-azure-ml" rel="nofollow">One-click deployments from the Hugging Face Hub on Azure ML</a>. But note that when deploying from the Hugging Face Hub, the endpoint + deployment will be created within Azure ML instead of within Azure AI Foundry, whereas this example focuses on Azure AI Foundry Hub deployments (also made available on Azure ML, but not the other way around).';return{c(){s=r("p"),s.innerHTML=T},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-147duvx"&&(s.innerHTML=T)},m(o,J){n(o,s,J)},p:$,d(o){o&&l(s)}}}function as(w){let s,T="Note that you can select any VLM available on the Hugging Face Hub with the “Deploy to AzureML” option enabled, or directly select any of the LLMs available in either the Azure ML or Azure AI Foundry Hub Model Catalog under the “HuggingFace” collection (note that for Azure AI Foundry the Hugging Face Collection will only be available for Hub-based projects).";return{c(){s=r("p"),s.textContent=T},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-qlklw8"&&(s.textContent=T)},m(o,J){n(o,s,J)},p:$,d(o){o&&l(s)}}}function is(w){let s,T="Note that endpoint names must to be globally unique per region i.e., even if you don’t have any endpoint named that way running under your subscription, if the name is reserved by another Azure customer, then you won’t be able to use the same name. Adding a timestamp or a custom identifier is recommended to prevent running into HTTP 400 validation issues when trying to deploy an endpoint with an already locked / reserved name. Also the endpoint name must be between 3 and 32 characters long.";return{c(){s=r("p"),s.textContent=T},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-zrbum5"&&(s.textContent=T)},m(o,J){n(o,s,J)},p:$,d(o){o&&l(s)}}}function os(w){let s,T="On standard Azure ML deployments you’d need to create the <code>MLClient</code> using the Azure ML Workspace as the <code>workspace_name</code> whereas for Azure AI Foundry, you need to provide the Azure AI Foundry Hub name as the <code>workspace_name</code> instead, and that will deploy the endpoint under the Azure AI Foundry too.";return{c(){s=r("p"),s.innerHTML=T},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-fg1top"&&(s.innerHTML=T)},m(o,J){n(o,s,J)},p:$,d(o){o&&l(s)}}}function rs(w){let s,T='Since for some models and inference engines you need to run those on a GPU-accelerated instance, you may need to request a quota increase for some of the supported instances as per the model you want to deploy. Also, keep into consideration that each model comes with a list of all the supported instances, being the recommended one for each tier the lower instance in terms of available VRAM. Read more about quota increase requests for Azure ML at <a href="https://learn.microsoft.com/en-us/azure/machine-learning/how-to-manage-quotas?view=azureml-api-2" rel="nofollow">Manage and increase quotas and limits for resources with Azure Machine Learning</a>.';return{c(){s=r("p"),s.innerHTML=T},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-3styqc"&&(s.innerHTML=T)},m(o,J){n(o,s,J)},p:$,d(o){o&&l(s)}}}function ps(w){let s,T="In Azure AI Foundry the endpoint will only be listed within the “My assets -> Models + endpoints” tab once the deployment is created, not before as in Azure ML where the endpoint is shown even if it doesn’t contain any active or in-progress deployments.";return{c(){s=r("p"),s.textContent=T},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-13fiegq"&&(s.textContent=T)},m(o,J){n(o,s,J)},p:$,d(o){o&&l(s)}}}function us(w){let s,T="Note that whilst the Azure AI Endpoint creation is relatively fast, the deployment will take longer since it needs to allocate the resources on Azure so expect it to take ~10-15 minutes, but it could as well take longer depending on the instance provisioning and availability.";return{c(){s=r("p"),s.textContent=T},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1q2pvid"&&(s.textContent=T)},m(o,J){n(o,s,J)},p:$,d(o){o&&l(s)}}}function Ms(w){let s,T="Note that below only some of the options are listed, but you can send requests to the deployed endpoint as long as you send the HTTP requests with the <code>azureml-model-deployment</code> header set to the name of the Azure AI Deployment (not the Endpoint), and have the necessary authentication token / key to send requests to the given endpoint; then you can send HTTP request to all the routes that the backend engine is exposing, not only to the scoring route.";return{c(){s=r("p"),s.innerHTML=T},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1fmd54g"&&(s.innerHTML=T)},m(o,J){n(o,s,J)},p:$,d(o){o&&l(s)}}}function ys(w){let s,T='Support for Hugging Face models via <a href="https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/ai/azure-ai-inference" rel="nofollow"><code>azure-ai-inference</code> Python SDK</a> is still a work in progress, but that will be included soon and set as the recommended inference method, stay tuned!';return{c(){s=r("p"),s.innerHTML=T},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1c2r502"&&(s.innerHTML=T)},m(o,J){n(o,s,J)},p:$,d(o){o&&l(s)}}}function ds(w){let s,T="Since in this case you are deploying a Vision Language Model (VLM) with Text Generation Inference (TGI), to leverage the vision capabilities through the <code>/generate</code> endpoint you will need to include either the image URL or the base64 encoding of the image formatted in Markdown as e.g. <code>![](https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png)What is this a picture of?\\n\\n</code> or <code>![](data:image/png;base64,...)What is this a picture of?\\n\\n</code>, respectively.",o,J,I='More information at <a href="https://huggingface.co/docs/text-generation-inference/basic_tutorials/visual_language_models" rel="nofollow">Vision Language Model Inference in TGI</a>.';return{c(){s=r("p"),s.innerHTML=T,o=a(),J=r("p"),J.innerHTML=I},l(f){s=p(f,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1wu310f"&&(s.innerHTML=T),o=i(f),J=p(f,"P",{"data-svelte-h":!0}),u(J)!=="svelte-14zr1cq"&&(J.innerHTML=I)},m(f,j){n(f,s,j),n(f,o,j),n(f,J,j)},p:$,d(f){f&&(l(s),l(o),l(J))}}}function cs(w){let s,T="Note that the Azure ML Python SDK requires a path to a JSON file when invoking the endpoints, meaning that whatever payload you want to send to the endpoint will need to be first converted into a JSON file, whilst that only applies to the requests sent via the Azure ML Python SDK.";return{c(){s=r("p"),s.textContent=T},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-1tlguht"&&(s.textContent=T)},m(o,J){n(o,s,J)},p:$,d(o){o&&l(s)}}}function ms(w){let s,T="Alternatively, you can also build the API URL manually as it follows, since the URIs are globally unique per region, meaning that there will only be one endpoint named the same way within the same region:",o,J,I,f,j="Or just retrieve it from either the Azure AI Foundry or the Azure ML Studio.",W;return J=new g({props:{code:"YXBpX3VybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRiU3Qm9zLmdldGVudignRU5EUE9JTlRfTkFNRScpJTdELiU3Qm9zLmdldGVudignTE9DQVRJT04nKSU3RC5pbmZlcmVuY2UubWwuYXp1cmUuY29tJTJGdjElMjI=",highlighted:'api_url = <span class="hljs-string">f&quot;https://<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;ENDPOINT_NAME&#x27;</span>)}</span>.<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;LOCATION&#x27;</span>)}</span>.inference.ml.azure.com/v1&quot;</span>',wrap:!1}}),{c(){s=r("p"),s.textContent=T,o=a(),M(J.$$.fragment),I=a(),f=r("p"),f.textContent=j},l(U){s=p(U,"P",{"data-svelte-h":!0}),u(s)!=="svelte-ufs9gh"&&(s.textContent=T),o=i(U),y(J.$$.fragment,U),I=i(U),f=p(U,"P",{"data-svelte-h":!0}),u(f)!=="svelte-vz1qru"&&(f.textContent=j)},m(U,C){n(U,s,C),n(U,o,C),d(J,U,C),n(U,I,C),n(U,f,C),W=!0},p:$,i(U){W||(c(J.$$.fragment,U),W=!0)},o(U){m(J.$$.fragment,U),W=!1},d(U){U&&(l(s),l(o),l(I),l(f)),h(J,U)}}}function hs(w){let s,T='Ideally you could deploy the Gradio Chat Interface connected to your Azure ML Managed Online Endpoint as an Azure Container App as described in <a href="https://learn.microsoft.com/en-us/azure/container-apps/tutorial-deploy-from-code?tabs=python" rel="nofollow">Tutorial: Build and deploy from source code to Azure Container Apps</a>. If you’d like us to show you how to do it for Gradio in particular, feel free to <a href="https://github.com/huggingface/Microsoft-Azure/issues/new" rel="nofollow">open an issue requesting it</a>.';return{c(){s=r("p"),s.innerHTML=T},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-ncfpy5"&&(s.innerHTML=T)},m(o,J){n(o,s,J)},p:$,d(o){o&&l(s)}}}function Ts(w){let s,T='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/Microsoft-Azure/tree/main/examples/azure-ai/deploy-vision-language-models/azure-notebook.ipynb" rel="nofollow">here</a>!';return{c(){s=r("p"),s.innerHTML=T},l(o){s=p(o,"P",{"data-svelte-h":!0}),u(s)!=="svelte-ne7d37"&&(s.innerHTML=T)},m(o,J){n(o,s,J)},p:$,d(o){o&&l(s)}}}function Js(w){let s,T,o,J,I,f,j,W="This example showcases how to deploy a Vision Language Model (VLM), i.e., a Large Language Model (LLM) with vision understanding, from the Hugging Face Collection in Azure AI Foundry Hub as an Azure ML Managed Online Endpoints. Additionally, this example also showcases how to run inference with both the Azure Python SDK, OpenAI Python SDK, and even how to locally run a Gradio application for chat completion with images.",U,C,pt,L,xl="TL;DR Azure AI Foundry provides a unified platform for enterprise AI operations, model builders, and application development. Azure Machine Learning is a cloud service for accelerating and managing the machine learning (ML) project lifecycle.",ut,Mt,yt,F,Xl='This example will specifically deploy <a href="https://huggingface.co/Qwen/Qwen2.5-VL-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-VL-32B-Instruct</code></a> from the Hugging Face Hub (or see it on <a href="https://ml.azure.com/models/qwen-qwen2.5-vl-32b-instruct/version/1/catalog/registry/HuggingFace" rel="nofollow">AzureML</a> or on <a href="https://ai.azure.com/explore/models/qwen-qwen2.5-vl-32b-instruct/version/1/registry/HuggingFace" rel="nofollow">Azure AI Foundry</a>) as an Azure ML Managed Online Endpoint on Azure AI Foundry Hub.',dt,S,Yl="Qwen2.5-VL is one of the latest VLMs from Qwen, released after the impact and feedback from the previous Qwen2 VL release, with some key enhancements such as:",ct,H,Pl="<li><strong>Understand things visually</strong>: Qwen2.5-VL is not only proficient in recognizing common objects such as flowers, birds, fish, and insects, but it is highly capable of analyzing texts, charts, icons, graphics, and layouts within images.</li> <li><strong>Being agentic</strong>: Qwen2.5-VL directly plays as a visual agent that can reason and dynamically direct tools, which is capable of computer use and phone use.</li> <li><strong>Understanding long videos and capturing events</strong>: Qwen2.5-VL can comprehend videos of over 1 hour, and this time it has a new ability of capturing event by pinpointing the relevant video segments.</li> <li><strong>Capable of visual localization in different formats</strong>: Qwen2.5-VL can accurately localize objects in an image by generating bounding boxes or points, and it can provide stable JSON outputs for coordinates and attributes.</li> <li><strong>Generating structured outputs</strong>: for data like scans of invoices, forms, tables, etc. Qwen2.5-VL supports structured outputs of their contents, benefiting usages in finance, commerce, etc.</li>",mt,x,Dl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-vision-language-models/qwen2.5-vl-hub.png" alt="Qwen2.5 VL 32B Instruct on the Hugging Face Hub"/>',ht,X,Ol='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-vision-language-models/qwen2.5-vl-azure-ai.png" alt="Qwen2.5 VL 32B Instruct on Azure AI Foundry"/>',Tt,Y,Kl='For more information, make sure to check <a href="https://huggingface.co/Qwen/Qwen2.5-VL-32B-Instruct/blob/main/README.md" rel="nofollow">their model card on the Hugging Face Hub</a>.',Jt,v,wt,P,Ut,D,en='To run the following example, you will need to comply with the following pre-requisites, alternatively, you can also read more about those in the <a href="https://learn.microsoft.com/en-us/azure/machine-learning/quickstart-create-resources?view=azureml-api-2" rel="nofollow">Azure Machine Learning Tutorial: Create resources you need to get started</a>.',ft,O,tn="<li>An Azure account with an active subscription.</li> <li>The Azure CLI installed and logged in.</li> <li>The Azure Machine Learning extension for the Azure CLI.</li> <li>An Azure Resource Group.</li> <li>A project based on an Azure AI Foundry Hub.</li>",gt,K,ln='For more information, please go through the steps in <a href="https://huggingface.co/docs/microsoft-azure/azure-ai/configure" rel="nofollow">Configure Microsoft Azure for Azure AI</a>.',It,ee,jt,te,nn='In this example, the <a href="https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/ml/azure-ai-ml" rel="nofollow">Azure Machine Learning SDK for Python</a> will be used to create the endpoint and the deployment, as well as to invoke the deployed API. Along with it, you will also need to install <code>azure-identity</code> to authenticate with your Azure credentials via Python.',Ct,le,bt,ne,sn='More information at <a href="https://learn.microsoft.com/en-us/python/api/overview/azure/ai-ml-readme?view=azure-python" rel="nofollow">Azure Machine Learning SDK for Python</a>.',$t,se,an="Then, for convenience setting the following environment variables is recommended as those will be used along the example for the Azure ML Client, so make sure to update and set those values accordingly as per your Microsoft Azure account and resources.",At,ae,vt,ie,on="Finally, you also need to define both the endpoint and deployment names, as those will be used throughout the example too:",zt,z,qt,oe,Et,re,Zt,pe,kt,ue,rn="Initially, you need to authenticate into the Azure AI Foundry Hub via Azure ML with the Azure ML Python SDK, which will be later used to deploy <code>Qwen/Qwen2.5-VL-32B-Instruct</code> as an Azure ML Managed Online Endpoint in your Azure AI Foundry Hub.",Bt,q,Qt,Me,Vt,ye,Rt,de,pn="Before creating the Managed Online Endpoint, you need to build the model URI, which is formatted as it follows <code>azureml://registries/&lt;REGISTRY_NAME&gt;/models/&lt;MODEL_ID&gt;/labels/latest</code> (even if the URI contains <code>azureml</code> it’s the same as in Azure AI Foundry, since the model catalog is shared), that means that the <code>REGISTRY_NAME</code> should be set to “HuggingFace” as you intend to deploy a model from the Hugging Face Collection, and the <code>MODEL_ID</code> won’t be the Hugging Face Hub ID, but rather the ID with hyphen replacements for both backslash (/) and underscores (_) with hyphens (-), and then into lower case, as follows:",Nt,ce,_t,me,un='Note that you will need to verify in advance that the URI is valid, and that the given Hugging Face Hub Model ID exists on Azure, since Hugging Face is publishing those models into their collection, meaning that some models may be available on the Hugging Face Hub but not yet on the Azure Model Catalog (you can request adding a model following the guide <a href="https://huggingface.co/docs/microsoft-azure/guides/request-model-addition" rel="nofollow">Request a model addition</a>).',Gt,he,Mn="Alternatively, you can use the following snippet to verify if a model is available on the Azure Model Catalog programmatically:",Wt,Te,Lt,Je,yn='Then you can create the Managed Online Endpoint specifying its name (note that the name must be unique per entire region, not only within a single subscription, resource group, workspace, etc., so it’s a nice practice to add some sort of unique name to it in case multi-region deployments are intended) via the <a href="https://learn.microsoft.com/en-us/python/api/azure-ai-ml/azure.ai.ml.entities.managedonlineendpoint?view=azure-python" rel="nofollow">ManagedOnlineEndpoint Python class</a>.',Ft,we,dn='Also note that by default the <code>ManagedOnlineEndpoint</code> will use the <code>key</code> authentication method, meaning that there will be a primary and secondary key that should be sent within the Authentication headers as a Bearer token; but also the <code>aml_token</code> authentication method can be used, read more about it at <a href="https://learn.microsoft.com/en-us/azure/machine-learning/how-to-authenticate-online-endpoint" rel="nofollow">Authenticate clients for online endpoints</a>.',St,Ue,cn='The deployment, created via the <a href="https://learn.microsoft.com/en-us/python/api/azure-ai-ml/azure.ai.ml.entities.managedonlinedeployment?view=azure-python" rel="nofollow">ManagedOnlineDeployment Python class</a>, will define the actual model deployment that will be exposed via the previously created endpoint. The <code>ManagedOnlineDeployment</code> will expect: the <code>model</code> i.e., the previously created URI <code>azureml://registries/HuggingFace/models/qwen-qwen2.5-vl-32b-instruct/labels/latest</code>, the <code>endpoint_name</code>, and the instance requirements being the <code>instance_type</code> and the <code>instance_count</code>.',Ht,fe,mn='Every model in the Hugging Face Collection is powered by an efficient inference backend, and each of those can run on a wide variety of instance types (as listed in <a href="https://huggingface.co/docs/microsoft-azure/azure-ai/supported-hardware" rel="nofollow">Supported Hardware</a>); in this case, a NVIDIA H100 GPU will be used i.e., <code>Standard_NC40ads_H100_v5</code>.',xt,E,Xt,ge,Yt,Ie,Pt,je,hn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-vision-language-models/azure-ai-endpoint.png" alt="Azure AI Endpoint from Azure AI Foundry"/>',Dt,Z,Ot,Ce,Kt,be,Tn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-vision-language-models/azure-ai-deployment.png" alt="Azure AI Deployment from Azure AI Foundry"/>',el,k,tl,$e,Jn='Once deployed, via either the Azure AI Foundry or the Azure ML Studio you’ll be able to inspect the endpoint details, the real-time logs, how to consume the endpoint, and even use the, still on preview, <a href="https://learn.microsoft.com/en-us/azure/machine-learning/concept-model-monitoring?view=azureml-api-2" rel="nofollow">monitoring feature</a>.',ll,Ae,wn='Find more information about it at <a href="https://learn.microsoft.com/en-us/azure/machine-learning/concept-endpoints-online?view=azureml-api-2#managed-online-endpoints" rel="nofollow">Azure ML Managed Online Endpoints</a>',nl,ve,sl,ze,Un="Finally, now that the Azure AI Endpoint is deployed, you can send requests to it. In this case, since the task of the model is <code>image-text-to-text</code> (also known as <code>chat-completion</code> with image support) you can either use the default scoring endpoint, being <code>/generate</code> which is the standard text generation endpoint without chat capabilities (as leveraging the chat template or having an OpenAI-compatible OpenAPI interface), or alternatively just benefit from the fact that the inference engine in which the model is running on top exposes OpenAI-compatible routes as <code>/v1/chat/completions</code>.",al,B,il,Q,ol,qe,rl,Ee,fn='You can invoke the Azure ML Endpoint on the scoring route, in this case <code>/generate</code> (more information about it in the <code>Qwen/Qwen2.5-VL-32B-Instruct</code> page in either <a href="https://ml.azure.com/models/qwen-qwen2.5-vl-32b-instruct/version/1/catalog/registry/HuggingFace" rel="nofollow">AzureML</a> or <a href="https://ai.azure.com/explore/models/qwen-qwen2.5-vl-32b-instruct/version/1/registry/HuggingFace" rel="nofollow">Azure AI Foundry</a> catalogs), via the Azure Python SDK with the previously instantiated <code>azure.ai.ml.MLClient</code> (or instantiate a new one if working from a different session).',pl,V,ul,Ze,Ml,R,yl,ke,dl,Be,gn="Since the inference engine in which the model is running on top exposes OpenAI-compatible routes, you can also leverage the OpenAI Python SDK to send requests to the deployed Azure AI Endpoint.",cl,Qe,ml,Ve,In="To use the OpenAI Python SDK with Azure ML Managed Online Endpoints, you need to first retrieve:",hl,Re,jn="<li><code>api_url</code> with the <code>/v1</code> route (that contains the <code>v1/chat/completions</code> endpoint that the OpenAI Python SDK will send requests to)</li> <li><code>api_key</code> which is the API Key in Azure AI or the primary key in Azure ML (unless a dedicated Azure ML Token is used instead)</li>",Tl,Ne,Jl,N,wl,_e,Cn="Then you can use the OpenAI Python SDK normally, making sure to include the extra header <code>azureml-model-deployment</code> header that contains the Azure AI / ML Deployment name.",Ul,Ge,bn="Via the OpenAI Python SDK it can either be set within each call to <code>chat.completions.create</code> via the <code>extra_headers</code> parameter as commented below, or via the <code>default_headers</code> parameter when instantiating the <code>OpenAI</code> client (which is the recommended approach since the header needs to be present on each request, so setting it just once is preferred).",fl,We,gl,Le,Il,Fe,$n="Alternatively, you can also just use <code>cURL</code> to send requests to the deployed endpoint, with the <code>api_url</code> and <code>api_key</code> values programmatically retrieved in the OpenAI snippet and now set as environment variables so that <code>cURL</code> can use those, as it follows:",jl,Se,Cl,He,bl,xe,An="You can also just go to the Azure AI Endpoint in either the Azure AI Foundry under “My assets -&gt; Models + endpoints” or in the Azure ML Studio via “Endpoints”, and retrieve both the URL (note that it will default to the <code>/generate</code> endpoint, but to use the OpenAI-compatible layer you need to use the <code>/v1/chat/completions</code> endpoint instead) and the API Key values, as well as the Azure AI / ML Deployment name for the given model, and then send the request as follows after replacing the values:",$l,Xe,Al,Ye,vl,Pe,vn='<a href="https://www.gradio.app/" rel="nofollow">Gradio</a> is the fastest way to demo your machine learning model with a friendly web interface so that anyone can use it. You can also leverage the OpenAI Python SDK to build a simple multimodal (text and images) <code>ChatInterface</code> that you can use within the Jupyter Notebook cell where you are running it.',zl,_,ql,De,El,Oe,zn='See below an example on how to leverage Gradio’s <code>ChatInterface</code>, or find more information about it at <a href="https://www.gradio.app/docs/gradio/chatinterface" rel="nofollow">Gradio ChatInterface Docs</a>.',Zl,Ke,kl,et,qn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/microsoft-azure/azure-ai/deploy-vision-language-models/azure-ml-gradio.png" alt="Gradio Chat Interface with Azure ML Endpoint"/>',Bl,tt,Ql,lt,En="Once you are done using the Azure AI Endpoint / Deployment, you can delete the resources as it follows, meaning that you will stop paying for the instance on which the model is running and all the attached costs will be stopped.",Vl,nt,Rl,st,Nl,at,Zn="Throughout this example you learnt how to create and configure your Azure account for Azure ML and Azure AI Foundry, how to then create a Managed Online Endpoint running an open model from the Hugging Face Collection in the Azure AI Foundry Hub / Azure ML Model Catalog, how to send inference requests to it afterwards with different alternatives, how to build a simple Gradio chat interface around it, and finally, how to stop and release the resources.",_l,it,kn='If you have any doubt, issue or question about this example, feel free to <a href="https://github.com/huggingface/Microsoft-Azure/issues/new" rel="nofollow">open an issue</a> and we’ll do our best to help!',Gl,Wl,Ll,G,Fl,ot,Sl,rt,Hl;return I=new A({props:{title:"Deploy Vision Language Models (VLMs) on Azure AI",local:"deploy-vision-language-models-vlms-on-azure-ai",headingTag:"h1"}}),C=new b({props:{$$slots:{default:[ss]},$$scope:{ctx:w}}}),v=new b({props:{$$slots:{default:[as]},$$scope:{ctx:w}}}),P=new A({props:{title:"Pre-requisites",local:"pre-requisites",headingTag:"h2"}}),ee=new A({props:{title:"Setup and installation",local:"setup-and-installation",headingTag:"h2"}}),le=new g({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGF6dXJlLWFpLW1sJTIwYXp1cmUtaWRlbnRpdHklMjAtLXVwZ3JhZGUlMjAtLXF1aWV0",highlighted:"%pip install azure-ai-ml azure-identity --upgrade --quiet",wrap:!1}}),ae=new g({props:{code:"JTI1ZW52JTIwTE9DQVRJT04lMjBlYXN0dXMlMEElMjVlbnYlMjBTVUJTQ1JJUFRJT05fSUQlMjAlM0NZT1VSX1NVQlNDUklQVElPTl9JRCUzRSUwQSUyNWVudiUyMFJFU09VUkNFX0dST1VQJTIwJTNDWU9VUl9SRVNPVVJDRV9HUk9VUCUzRSUwQSUyNWVudiUyMEFJX0ZPVU5EUllfSFVCX1BST0pFQ1QlMjAlM0NZT1VSX0FJX0ZPVU5EUllfSFVCX1BST0pFQ1QlM0U=",highlighted:`%env LOCATION eastus
%env SUBSCRIPTION_ID &lt;YOUR_SUBSCRIPTION_ID&gt;
%env RESOURCE_GROUP &lt;YOUR_RESOURCE_GROUP&gt;
%env AI_FOUNDRY_HUB_PROJECT &lt;YOUR_AI_FOUNDRY_HUB_PROJECT&gt;`,wrap:!1}}),z=new b({props:{$$slots:{default:[is]},$$scope:{ctx:w}}}),oe=new g({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdXVpZCUyMGltcG9ydCUyMHV1aWQ0JTBBJTBBb3MuZW52aXJvbiU1QiUyMkVORFBPSU5UX05BTUUlMjIlNUQlMjAlM0QlMjBmJTIycXdlbi12bC1lbmRwb2ludC0lN0JzdHIodXVpZDQoKSklNUIlM0E4JTVEJTdEJTIyJTBBb3MuZW52aXJvbiU1QiUyMkRFUExPWU1FTlRfTkFNRSUyMiU1RCUyMCUzRCUyMGYlMjJxd2VuLXZsLWRlcGxveW1lbnQtJTdCc3RyKHV1aWQ0KCkpJTVCJTNBOCU1RCU3RCUyMg==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> uuid <span class="hljs-keyword">import</span> uuid4

os.environ[<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>] = <span class="hljs-string">f&quot;qwen-vl-endpoint-<span class="hljs-subst">{<span class="hljs-built_in">str</span>(uuid4())[:<span class="hljs-number">8</span>]}</span>&quot;</span>
os.environ[<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>] = <span class="hljs-string">f&quot;qwen-vl-deployment-<span class="hljs-subst">{<span class="hljs-built_in">str</span>(uuid4())[:<span class="hljs-number">8</span>]}</span>&quot;</span>`,wrap:!1}}),re=new g({props:{code:"IWVjaG8lMjAlMjRFTkRQT0lOVF9OQU1FJTBBIWVjaG8lMjAlMjRERVBMT1lNRU5UX05BTUU=",highlighted:`!echo $ENDPOINT_NAME
!echo $DEPLOYMENT_NAME`,wrap:!1}}),pe=new A({props:{title:"Authenticate to Azure ML",local:"authenticate-to-azure-ml",headingTag:"h2"}}),q=new b({props:{$$slots:{default:[os]},$$scope:{ctx:w}}}),Me=new g({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwYXp1cmUuYWkubWwlMjBpbXBvcnQlMjBNTENsaWVudCUwQWZyb20lMjBhenVyZS5pZGVudGl0eSUyMGltcG9ydCUyMERlZmF1bHRBenVyZUNyZWRlbnRpYWwlMEElMEFjbGllbnQlMjAlM0QlMjBNTENsaWVudCglMEElMjAlMjAlMjAlMjBjcmVkZW50aWFsJTNERGVmYXVsdEF6dXJlQ3JlZGVudGlhbCgpJTJDJTBBJTIwJTIwJTIwJTIwc3Vic2NyaXB0aW9uX2lkJTNEb3MuZ2V0ZW52KCUyMlNVQlNDUklQVElPTl9JRCUyMiklMkMlMEElMjAlMjAlMjAlMjByZXNvdXJjZV9ncm91cF9uYW1lJTNEb3MuZ2V0ZW52KCUyMlJFU09VUkNFX0dST1VQJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHdvcmtzcGFjZV9uYW1lJTNEb3MuZ2V0ZW52KCUyMkFJX0ZPVU5EUllfSFVCX1BST0pFQ1QlMjIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> azure.ai.ml <span class="hljs-keyword">import</span> MLClient
<span class="hljs-keyword">from</span> azure.identity <span class="hljs-keyword">import</span> DefaultAzureCredential

client = MLClient(
    credential=DefaultAzureCredential(),
    subscription_id=os.getenv(<span class="hljs-string">&quot;SUBSCRIPTION_ID&quot;</span>),
    resource_group_name=os.getenv(<span class="hljs-string">&quot;RESOURCE_GROUP&quot;</span>),
    workspace_name=os.getenv(<span class="hljs-string">&quot;AI_FOUNDRY_HUB_PROJECT&quot;</span>),
)`,wrap:!1}}),ye=new A({props:{title:"Create and Deploy Azure AI Endpoint",local:"create-and-deploy-azure-ai-endpoint",headingTag:"h2"}}),ce=new g({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJRd2VuJTJGUXdlbjIuNS1WTC0zMkItSW5zdHJ1Y3QlMjIlMEElMEFtb2RlbF91cmklMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwZiUyMmF6dXJlbWwlM0ElMkYlMkZyZWdpc3RyaWVzJTJGSHVnZ2luZ0ZhY2UlMkZtb2RlbHMlMkYlN0Jtb2RlbF9pZC5yZXBsYWNlKCclMkYnJTJDJTIwJy0nKS5yZXBsYWNlKCdfJyUyQyUyMCctJykubG93ZXIoKSU3RCUyRmxhYmVscyUyRmxhdGVzdCUyMiUwQSklMEFtb2RlbF91cmk=",highlighted:`model_id = <span class="hljs-string">&quot;Qwen/Qwen2.5-VL-32B-Instruct&quot;</span>

model_uri = (
    <span class="hljs-string">f&quot;azureml://registries/HuggingFace/models/<span class="hljs-subst">{model_id.replace(<span class="hljs-string">&#x27;/&#x27;</span>, <span class="hljs-string">&#x27;-&#x27;</span>).replace(<span class="hljs-string">&#x27;_&#x27;</span>, <span class="hljs-string">&#x27;-&#x27;</span>).lower()}</span>/labels/latest&quot;</span>
)
model_uri`,wrap:!1}}),Te=new g({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldChmJTIyaHR0cHMlM0ElMkYlMkZnZW5lcmF0ZS1henVyZW1sLXVybHMuYXp1cmV3ZWJzaXRlcy5uZXQlMkZhcGklMkZnZW5lcmF0ZSUzRm1vZGVsSWQlM0QlN0Jtb2RlbF9pZCU3RCUyMiklMEFpZiUyMHJlc3BvbnNlLnN0YXR1c19jb2RlJTIwISUzRCUyMDIwMCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiU1QiU3QnJlc3BvbnNlLnN0YXR1c19jb2RlJTNEJTdEJTVEJTIwJTdCbW9kZWxfaWQlM0QlN0QlMjBub3QlMjBhdmFpbGFibGUlMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwQ29sbGVjdGlvbiUyMGluJTIwQXp1cmUlMjBNTCUyME1vZGVsJTIwQ2F0YWxvZyUyMiUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-keyword">import</span> requests

response = requests.get(<span class="hljs-string">f&quot;https://generate-azureml-urls.azurewebsites.net/api/generate?modelId=<span class="hljs-subst">{model_id}</span>&quot;</span>)
<span class="hljs-keyword">if</span> response.status_code != <span class="hljs-number">200</span>:
    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">&quot;[{response.status_code=}] {model_id=} not available on the Hugging Face Collection in Azure ML Model Catalog&quot;</span>
    )`,wrap:!1}}),E=new b({props:{warning:!0,$$slots:{default:[rs]},$$scope:{ctx:w}}}),ge=new g({props:{code:"ZnJvbSUyMGF6dXJlLmFpLm1sLmVudGl0aWVzJTIwaW1wb3J0JTIwTWFuYWdlZE9ubGluZUVuZHBvaW50JTJDJTIwTWFuYWdlZE9ubGluZURlcGxveW1lbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyME1hbmFnZWRPbmxpbmVFbmRwb2ludChuYW1lJTNEb3MuZ2V0ZW52KCUyMkVORFBPSU5UX05BTUUlMjIpKSUwQSUwQWRlcGxveW1lbnQlMjAlM0QlMjBNYW5hZ2VkT25saW5lRGVwbG95bWVudCglMEElMjAlMjAlMjAlMjBuYW1lJTNEb3MuZ2V0ZW52KCUyMkRFUExPWU1FTlRfTkFNRSUyMiklMkMlMEElMjAlMjAlMjAlMjBlbmRwb2ludF9uYW1lJTNEb3MuZ2V0ZW52KCUyMkVORFBPSU5UX05BTUUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbF91cmklMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIyU3RhbmRhcmRfTkM0MGFkc19IMTAwX3Y1JTIyJTJDJTBBJTIwJTIwJTIwJTIwaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> azure.ai.ml.entities <span class="hljs-keyword">import</span> ManagedOnlineEndpoint, ManagedOnlineDeployment

endpoint = ManagedOnlineEndpoint(name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>))

deployment = ManagedOnlineDeployment(
    name=os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>),
    endpoint_name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>),
    model=model_uri,
    instance_type=<span class="hljs-string">&quot;Standard_NC40ads_H100_v5&quot;</span>,
    instance_count=<span class="hljs-number">1</span>,
)`,wrap:!1}}),Ie=new g({props:{code:"Y2xpZW50LmJlZ2luX2NyZWF0ZV9vcl91cGRhdGUoZW5kcG9pbnQpLndhaXQoKQ==",highlighted:"client.begin_create_or_update(endpoint).wait()",wrap:!1}}),Z=new b({props:{$$slots:{default:[ps]},$$scope:{ctx:w}}}),Ce=new g({props:{code:"Y2xpZW50Lm9ubGluZV9kZXBsb3ltZW50cy5iZWdpbl9jcmVhdGVfb3JfdXBkYXRlKGRlcGxveW1lbnQpLndhaXQoKQ==",highlighted:"client.online_deployments.begin_create_or_update(deployment).wait()",wrap:!1}}),k=new b({props:{$$slots:{default:[us]},$$scope:{ctx:w}}}),ve=new A({props:{title:"Send requests to the Azure AI Endpoint",local:"send-requests-to-the-azure-ai-endpoint",headingTag:"h2"}}),B=new b({props:{$$slots:{default:[Ms]},$$scope:{ctx:w}}}),Q=new b({props:{warning:!0,$$slots:{default:[ys]},$$scope:{ctx:w}}}),qe=new A({props:{title:"Azure Python SDK",local:"azure-python-sdk",headingTag:"h3"}}),V=new b({props:{$$slots:{default:[ds]},$$scope:{ctx:w}}}),Ze=new g({props:{code:"aW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMG9zJTBBaW1wb3J0JTIwdGVtcGZpbGUlMEElMEF3aXRoJTIwdGVtcGZpbGUuTmFtZWRUZW1wb3JhcnlGaWxlKG1vZGUlM0QlMjJ3JTJCJTIyJTJDJTIwZGVsZXRlJTNEVHJ1ZSUyQyUyMHN1ZmZpeCUzRCUyMi5qc29uJTIyKSUyMGFzJTIwdG1wJTNBJTBBJTIwJTIwJTIwJTIwanNvbi5kdW1wKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMCUyMiElNUIlNUQoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGdHJhbnNmb3JtZXJzJTJGcmFiYml0LnBuZylXaGF0JTIwaXMlMjB0aGlzJTIwYSUyMHBpY3R1cmUlMjBvZiUzRiU1Q24lNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1ldGVycyUyMiUzQSUyMCU3QiUyMm1heF9uZXdfdG9rZW5zJTIyJTNBJTIwMTI4JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG1wJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMHRtcC5mbHVzaCgpJTBBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQub25saW5lX2VuZHBvaW50cy5pbnZva2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW5kcG9pbnRfbmFtZSUzRG9zLmdldGVudiglMjJFTkRQT0lOVF9OQU1FJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlcGxveW1lbnRfbmFtZSUzRG9zLmdldGVudiglMjJERVBMT1lNRU5UX05BTUUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVxdWVzdF9maWxlJTNEdG1wLm5hbWUlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBcHJpbnQoanNvbi5sb2FkcyhyZXNwb25zZSkp",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> tempfile

<span class="hljs-keyword">with</span> tempfile.NamedTemporaryFile(mode=<span class="hljs-string">&quot;w+&quot;</span>, delete=<span class="hljs-literal">True</span>, suffix=<span class="hljs-string">&quot;.json&quot;</span>) <span class="hljs-keyword">as</span> tmp:
    json.dump(
        {
            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;![](https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png)What is this a picture of?\\n\\n&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">128</span>},
        },
        tmp,
    )

    tmp.flush()

    response = client.online_endpoints.invoke(
        endpoint_name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>),
        deployment_name=os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>),
        request_file=tmp.name,
    )

<span class="hljs-built_in">print</span>(json.loads(response))`,wrap:!1}}),R=new b({props:{$$slots:{default:[cs]},$$scope:{ctx:w}}}),ke=new A({props:{title:"OpenAI Python SDK",local:"openai-python-sdk",headingTag:"h3"}}),Qe=new g({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMG9wZW5haSUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:"%pip install openai --upgrade --quiet",wrap:!1}}),Ne=new g({props:{code:"YXBpX2tleSUyMCUzRCUyMGNsaWVudC5vbmxpbmVfZW5kcG9pbnRzLmdldF9rZXlzKG9zLmdldGVudiglMjJFTkRQT0lOVF9OQU1FJTIyKSkucHJpbWFyeV9rZXklMEFhcGlfdXJsJTIwJTNEJTIwY2xpZW50Lm9ubGluZV9lbmRwb2ludHMuZ2V0KG9zLmdldGVudiglMjJFTkRQT0lOVF9OQU1FJTIyKSkuc2NvcmluZ191cmkucmVwbGFjZSglMjIlMkZnZW5lcmF0ZSUyMiUyQyUyMCUyMiUyRnYxJTIyKQ==",highlighted:`api_key = client.online_endpoints.get_keys(os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).primary_key
api_url = client.online_endpoints.get(os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).scoring_uri.replace(<span class="hljs-string">&quot;/generate&quot;</span>, <span class="hljs-string">&quot;/v1&quot;</span>)`,wrap:!1}}),N=new b({props:{$$slots:{default:[ms]},$$scope:{ctx:w}}}),We=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

openai_client = OpenAI(
    base_url=api_url,
    api_key=api_key,
    default_headers={<span class="hljs-string">&quot;azureml-model-deployment&quot;</span>: os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>)},
)

completion = openai_client.chat.completions.create(
    model=<span class="hljs-string">&quot;Qwen/Qwen2.5-VL-32B-Instruct&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are an assistant that responds like a pirate.&quot;</span>},
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: [
                {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is in this image?&quot;</span>},
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                    <span class="hljs-string">&quot;image_url&quot;</span>: {
                        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png&quot;</span>
                    },
                },
            ],
        },
    ],
    max_tokens=<span class="hljs-number">128</span>,
    <span class="hljs-comment"># extra_headers={&quot;azureml-model-deployment&quot;: os.getenv(&quot;DEPLOYMENT_NAME&quot;)},</span>
)
<span class="hljs-built_in">print</span>(completion)`,wrap:!1}}),Le=new A({props:{title:"cURL",local:"curl",headingTag:"h3"}}),Se=new g({props:{code:"b3MuZW52aXJvbiU1QiUyMkFQSV9VUkwlMjIlNUQlMjAlM0QlMjBhcGlfdXJsJTBBb3MuZW52aXJvbiU1QiUyMkFQSV9LRVklMjIlNUQlMjAlM0QlMjBhcGlfa2V5",highlighted:`os.environ[<span class="hljs-string">&quot;API_URL&quot;</span>] = api_url
os.environ[<span class="hljs-string">&quot;API_KEY&quot;</span>] = api_key`,wrap:!1}}),He=new g({props:{code:"IWN1cmwlMjAtc1MlMjAlMjRBUElfVVJMJTJGY2hhdCUyRmNvbXBsZXRpb25zJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAlMjJBdXRob3JpemF0aW9uJTNBJTIwQmVhcmVyJTIwJTI0QVBJX0tFWSUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC1IJTIwJTIyQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAlMjJhenVyZW1sLW1vZGVsLWRlcGxveW1lbnQlM0ElMjAlMjRERVBMT1lNRU5UX05BTUUlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtZCUyMCclN0IlMjAlNUMlMEElMjJtZXNzYWdlcyUyMiUzQSU1QiUyMCU1QyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjJzeXN0ZW0lMjIlMkMlMjJjb250ZW50JTIyJTNBJTIyWW91JTIwYXJlJTIwYW4lMjBhc3Npc3RhbnQlMjB0aGF0JTIwcmVwbGllcyUyMGxpa2UlMjBhJTIwcGlyYXRlLiUyMiU3RCUyQyUyMCU1QyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjJ1c2VyJTIyJTJDJTIyY29udGVudCUyMiUzQSUyMCU1QiUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjJ0ZXh0JTIyJTJDJTIydGV4dCUyMiUzQSUyMldoYXQlMjBpcyUyMGluJTIwdGhpcyUyMGltYWdlJTNGJTIyJTdEJTJDJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMmltYWdlX3VybCUyMiUyQyUyMmltYWdlX3VybCUyMiUzQSU3QiUyMnVybCUyMiUzQSUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnRyYW5zZm9ybWVycyUyRnJhYmJpdC5wbmclMjIlN0QlN0QlMjAlNUMlMEElMjAlMjAlMjAlMjAlNUQlN0QlMjAlNUMlMEElNUQlMkMlMjAlNUMlMEElMjJtYXhfdG9rZW5zJTIyJTNBMTI4JTIwJTVDJTBBJTdEJyUyMCU3QyUyMGpx",highlighted:`!curl -sS $API_URL/chat/completions \\
    -H <span class="hljs-string">&quot;Authorization: Bearer $API_KEY&quot;</span> \\
    -H <span class="hljs-string">&quot;Content-Type: application/json&quot;</span> \\
    -H <span class="hljs-string">&quot;azureml-model-deployment: $DEPLOYMENT_NAME&quot;</span> \\
    -d <span class="hljs-string">&#x27;{ \\
&quot;messages&quot;:[ \\
    {&quot;role&quot;:&quot;system&quot;,&quot;content&quot;:&quot;You are an assistant that replies like a pirate.&quot;}, \\
    {&quot;role&quot;:&quot;user&quot;,&quot;content&quot;: [ \\
        {&quot;type&quot;:&quot;text&quot;,&quot;text&quot;:&quot;What is in this image?&quot;}, \\
        {&quot;type&quot;:&quot;image_url&quot;,&quot;image_url&quot;:{&quot;url&quot;: &quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png&quot;}} \\
    ]} \\
], \\
&quot;max_tokens&quot;:128 \\
}&#x27;</span> | jq`,wrap:!1}}),Xe=new g({props:{code:"Y3VybCUyMC1zUyUyMCUzQ0FQSV9VUkwlM0UlMkZ2MSUyRmNoYXQlMkZjb21wbGV0aW9ucyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1IJTIwJTIyQXV0aG9yaXphdGlvbiUzQSUyMEJlYXJlciUyMCUzQ1BSSU1BUllfS0VZJTNFJTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAlMjJDb250ZW50LVR5cGUlM0ElMjBhcHBsaWNhdGlvbiUyRmpzb24lMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCUyMmF6dXJlbWwtbW9kZWwtZGVwbG95bWVudCUzQSUyMCUyNERFUExPWU1FTlRfTkFNRSUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUyMCU1QyUwQSUyMm1lc3NhZ2VzJTIyJTNBJTVCJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMnN5c3RlbSUyMiUyQyUyMmNvbnRlbnQlMjIlM0ElMjJZb3UlMjBhcmUlMjBhbiUyMGFzc2lzdGFudCUyMHRoYXQlMjByZXBsaWVzJTIwbGlrZSUyMGElMjBwaXJhdGUuJTIyJTdEJTJDJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMnVzZXIlMjIlMkMlMjJjb250ZW50JTIyJTNBJTIwJTVCJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMnRleHQlMjIlMkMlMjJ0ZXh0JTIyJTNBJTIyV2hhdCUyMGlzJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjIlN0QlMkMlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIyaW1hZ2VfdXJsJTIyJTJDJTIyaW1hZ2VfdXJsJTIyJTNBJTdCJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGdHJhbnNmb3JtZXJzJTJGcmFiYml0LnBuZyUyMiU3RCU3RCUyMCU1QyUwQSUyMCUyMCUyMCUyMCU1RCU3RCUyMCU1QyUwQSU1RCUyQyUyMCU1QyUwQSUyMm1heF90b2tlbnMlMjIlM0ExMjglMjAlNUMlMEElN0QnJTIwJTdDJTIwanE=",highlighted:`curl -sS &lt;API_URL&gt;/v1/chat/completions \\
    -H <span class="hljs-string">&quot;Authorization: Bearer &lt;PRIMARY_KEY&gt;&quot;</span> \\
    -H <span class="hljs-string">&quot;Content-Type: application/json&quot;</span> \\
    -H <span class="hljs-string">&quot;azureml-model-deployment: <span class="hljs-variable">$DEPLOYMENT_NAME</span>&quot;</span> \\
    -d <span class="hljs-string">&#x27;{ \\
&quot;messages&quot;:[ \\
    {&quot;role&quot;:&quot;system&quot;,&quot;content&quot;:&quot;You are an assistant that replies like a pirate.&quot;}, \\
    {&quot;role&quot;:&quot;user&quot;,&quot;content&quot;: [ \\
        {&quot;type&quot;:&quot;text&quot;,&quot;text&quot;:&quot;What is in this image?&quot;}, \\
        {&quot;type&quot;:&quot;image_url&quot;,&quot;image_url&quot;:{&quot;url&quot;: &quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png&quot;}} \\
    ]} \\
], \\
&quot;max_tokens&quot;:128 \\
}&#x27;</span> | jq`,wrap:!1}}),Ye=new A({props:{title:"Gradio",local:"gradio",headingTag:"h3"}}),_=new b({props:{$$slots:{default:[hs]},$$scope:{ctx:w}}}),De=new g({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGdyYWRpbyUyMC0tdXBncmFkZSUyMC0tcXVpZXQ=",highlighted:"%pip install gradio --upgrade --quiet",wrap:!1}}),Ke=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, Iterator, <span class="hljs-type">List</span>, <span class="hljs-type">Literal</span>

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

openai_client = OpenAI(
    base_url=os.getenv(<span class="hljs-string">&quot;API_URL&quot;</span>),
    api_key=os.getenv(<span class="hljs-string">&quot;API_KEY&quot;</span>),
    default_headers={<span class="hljs-string">&quot;azureml-model-deployment&quot;</span>: os.getenv(<span class="hljs-string">&quot;DEPLOYMENT_NAME&quot;</span>)},
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">predict</span>(<span class="hljs-params">
    message: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">str</span> | <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]], history: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;role&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>], <span class="hljs-built_in">str</span>]]
</span>) -&gt; Iterator[<span class="hljs-built_in">str</span>]:
    content = []
    <span class="hljs-keyword">if</span> message[<span class="hljs-string">&quot;text&quot;</span>]:
        content.append({<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: message[<span class="hljs-string">&quot;text&quot;</span>]})

    <span class="hljs-keyword">for</span> file_path <span class="hljs-keyword">in</span> message.get(<span class="hljs-string">&quot;files&quot;</span>, []):
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(file_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> image_file:
            base64_image = base64.b64encode(image_file.read()).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
            content.append(
                {
                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                    <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">f&quot;data:image/png;base64,<span class="hljs-subst">{base64_image}</span>&quot;</span>},
                }
            )

    messages = history.copy()
    messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: content})

    stream = openai_client.chat.completions.create(
        model=<span class="hljs-string">&quot;Qwen/Qwen2.5-VL-32B-Instruct&quot;</span>,
        messages=messages,
        stream=<span class="hljs-literal">True</span>,
    )
    buffer = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> stream:
        <span class="hljs-keyword">if</span> chunk.choices[<span class="hljs-number">0</span>].delta.content:
            buffer += chunk.choices[<span class="hljs-number">0</span>].delta.content
            <span class="hljs-keyword">yield</span> buffer


demo = gr.ChatInterface(
    predict,
    textbox=gr.MultimodalTextbox(label=<span class="hljs-string">&quot;Input&quot;</span>, file_types=[<span class="hljs-string">&quot;.jpg&quot;</span>, <span class="hljs-string">&quot;.png&quot;</span>, <span class="hljs-string">&quot;.jpeg&quot;</span>], file_count=<span class="hljs-string">&quot;multiple&quot;</span>),
    multimodal=<span class="hljs-literal">True</span>,
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
)

demo.launch()`,wrap:!1}}),tt=new A({props:{title:"Release resources",local:"release-resources",headingTag:"h2"}}),nt=new g({props:{code:"Y2xpZW50Lm9ubGluZV9lbmRwb2ludHMuYmVnaW5fZGVsZXRlKG5hbWUlM0Rvcy5nZXRlbnYoJTIyRU5EUE9JTlRfTkFNRSUyMikpLnJlc3VsdCgp",highlighted:'client.online_endpoints.begin_delete(name=os.getenv(<span class="hljs-string">&quot;ENDPOINT_NAME&quot;</span>)).result()',wrap:!1}}),st=new A({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),G=new b({props:{$$slots:{default:[Ts]},$$scope:{ctx:w}}}),ot=new ns({props:{source:"https://github.com/huggingface/Microsoft-Azure/blob/main/docs/source/azure-ai/examples/deploy-vision-language-models.mdx"}}),{c(){s=r("meta"),T=a(),o=r("p"),J=a(),M(I.$$.fragment),f=a(),j=r("p"),j.textContent=W,U=a(),M(C.$$.fragment),pt=a(),L=r("p"),L.textContent=xl,ut=a(),Mt=r("hr"),yt=a(),F=r("p"),F.innerHTML=Xl,dt=a(),S=r("p"),S.textContent=Yl,ct=a(),H=r("ul"),H.innerHTML=Pl,mt=a(),x=r("p"),x.innerHTML=Dl,ht=a(),X=r("p"),X.innerHTML=Ol,Tt=a(),Y=r("p"),Y.innerHTML=Kl,Jt=a(),M(v.$$.fragment),wt=a(),M(P.$$.fragment),Ut=a(),D=r("p"),D.innerHTML=en,ft=a(),O=r("ul"),O.innerHTML=tn,gt=a(),K=r("p"),K.innerHTML=ln,It=a(),M(ee.$$.fragment),jt=a(),te=r("p"),te.innerHTML=nn,Ct=a(),M(le.$$.fragment),bt=a(),ne=r("p"),ne.innerHTML=sn,$t=a(),se=r("p"),se.textContent=an,At=a(),M(ae.$$.fragment),vt=a(),ie=r("p"),ie.textContent=on,zt=a(),M(z.$$.fragment),qt=a(),M(oe.$$.fragment),Et=a(),M(re.$$.fragment),Zt=a(),M(pe.$$.fragment),kt=a(),ue=r("p"),ue.innerHTML=rn,Bt=a(),M(q.$$.fragment),Qt=a(),M(Me.$$.fragment),Vt=a(),M(ye.$$.fragment),Rt=a(),de=r("p"),de.innerHTML=pn,Nt=a(),M(ce.$$.fragment),_t=a(),me=r("p"),me.innerHTML=un,Gt=a(),he=r("p"),he.textContent=Mn,Wt=a(),M(Te.$$.fragment),Lt=a(),Je=r("p"),Je.innerHTML=yn,Ft=a(),we=r("p"),we.innerHTML=dn,St=a(),Ue=r("p"),Ue.innerHTML=cn,Ht=a(),fe=r("p"),fe.innerHTML=mn,xt=a(),M(E.$$.fragment),Xt=a(),M(ge.$$.fragment),Yt=a(),M(Ie.$$.fragment),Pt=a(),je=r("p"),je.innerHTML=hn,Dt=a(),M(Z.$$.fragment),Ot=a(),M(Ce.$$.fragment),Kt=a(),be=r("p"),be.innerHTML=Tn,el=a(),M(k.$$.fragment),tl=a(),$e=r("p"),$e.innerHTML=Jn,ll=a(),Ae=r("p"),Ae.innerHTML=wn,nl=a(),M(ve.$$.fragment),sl=a(),ze=r("p"),ze.innerHTML=Un,al=a(),M(B.$$.fragment),il=a(),M(Q.$$.fragment),ol=a(),M(qe.$$.fragment),rl=a(),Ee=r("p"),Ee.innerHTML=fn,pl=a(),M(V.$$.fragment),ul=a(),M(Ze.$$.fragment),Ml=a(),M(R.$$.fragment),yl=a(),M(ke.$$.fragment),dl=a(),Be=r("p"),Be.textContent=gn,cl=a(),M(Qe.$$.fragment),ml=a(),Ve=r("p"),Ve.textContent=In,hl=a(),Re=r("ul"),Re.innerHTML=jn,Tl=a(),M(Ne.$$.fragment),Jl=a(),M(N.$$.fragment),wl=a(),_e=r("p"),_e.innerHTML=Cn,Ul=a(),Ge=r("p"),Ge.innerHTML=bn,fl=a(),M(We.$$.fragment),gl=a(),M(Le.$$.fragment),Il=a(),Fe=r("p"),Fe.innerHTML=$n,jl=a(),M(Se.$$.fragment),Cl=a(),M(He.$$.fragment),bl=a(),xe=r("p"),xe.innerHTML=An,$l=a(),M(Xe.$$.fragment),Al=a(),M(Ye.$$.fragment),vl=a(),Pe=r("p"),Pe.innerHTML=vn,zl=a(),M(_.$$.fragment),ql=a(),M(De.$$.fragment),El=a(),Oe=r("p"),Oe.innerHTML=zn,Zl=a(),M(Ke.$$.fragment),kl=a(),et=r("p"),et.innerHTML=qn,Bl=a(),M(tt.$$.fragment),Ql=a(),lt=r("p"),lt.textContent=En,Vl=a(),M(nt.$$.fragment),Rl=a(),M(st.$$.fragment),Nl=a(),at=r("p"),at.textContent=Zn,_l=a(),it=r("p"),it.innerHTML=kn,Gl=a(),Wl=r("hr"),Ll=a(),M(G.$$.fragment),Fl=a(),M(ot.$$.fragment),Sl=a(),rt=r("p"),this.h()},l(e){const t=ts("svelte-u9bgzb",document.head);s=p(t,"META",{name:!0,content:!0}),t.forEach(l),T=i(e),o=p(e,"P",{}),Yn(o).forEach(l),J=i(e),y(I.$$.fragment,e),f=i(e),j=p(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-1cviig9"&&(j.textContent=W),U=i(e),y(C.$$.fragment,e),pt=i(e),L=p(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-1iudrmi"&&(L.textContent=xl),ut=i(e),Mt=p(e,"HR",{}),yt=i(e),F=p(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-fy3v7"&&(F.innerHTML=Xl),dt=i(e),S=p(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-1rrsb6c"&&(S.textContent=Yl),ct=i(e),H=p(e,"UL",{"data-svelte-h":!0}),u(H)!=="svelte-w3sn2m"&&(H.innerHTML=Pl),mt=i(e),x=p(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-197tbb9"&&(x.innerHTML=Dl),ht=i(e),X=p(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-afqq08"&&(X.innerHTML=Ol),Tt=i(e),Y=p(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-2kk52z"&&(Y.innerHTML=Kl),Jt=i(e),y(v.$$.fragment,e),wt=i(e),y(P.$$.fragment,e),Ut=i(e),D=p(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-dnkqle"&&(D.innerHTML=en),ft=i(e),O=p(e,"UL",{"data-svelte-h":!0}),u(O)!=="svelte-dlzkka"&&(O.innerHTML=tn),gt=i(e),K=p(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-1myp7ii"&&(K.innerHTML=ln),It=i(e),y(ee.$$.fragment,e),jt=i(e),te=p(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-bexho5"&&(te.innerHTML=nn),Ct=i(e),y(le.$$.fragment,e),bt=i(e),ne=p(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-1v277rw"&&(ne.innerHTML=sn),$t=i(e),se=p(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-11uslf2"&&(se.textContent=an),At=i(e),y(ae.$$.fragment,e),vt=i(e),ie=p(e,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-1wrtw53"&&(ie.textContent=on),zt=i(e),y(z.$$.fragment,e),qt=i(e),y(oe.$$.fragment,e),Et=i(e),y(re.$$.fragment,e),Zt=i(e),y(pe.$$.fragment,e),kt=i(e),ue=p(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-wwwlto"&&(ue.innerHTML=rn),Bt=i(e),y(q.$$.fragment,e),Qt=i(e),y(Me.$$.fragment,e),Vt=i(e),y(ye.$$.fragment,e),Rt=i(e),de=p(e,"P",{"data-svelte-h":!0}),u(de)!=="svelte-thijw5"&&(de.innerHTML=pn),Nt=i(e),y(ce.$$.fragment,e),_t=i(e),me=p(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-1hy4n1w"&&(me.innerHTML=un),Gt=i(e),he=p(e,"P",{"data-svelte-h":!0}),u(he)!=="svelte-1kr526q"&&(he.textContent=Mn),Wt=i(e),y(Te.$$.fragment,e),Lt=i(e),Je=p(e,"P",{"data-svelte-h":!0}),u(Je)!=="svelte-1qpei6p"&&(Je.innerHTML=yn),Ft=i(e),we=p(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-1kte4k3"&&(we.innerHTML=dn),St=i(e),Ue=p(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-m1ny71"&&(Ue.innerHTML=cn),Ht=i(e),fe=p(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-1weda3f"&&(fe.innerHTML=mn),xt=i(e),y(E.$$.fragment,e),Xt=i(e),y(ge.$$.fragment,e),Yt=i(e),y(Ie.$$.fragment,e),Pt=i(e),je=p(e,"P",{"data-svelte-h":!0}),u(je)!=="svelte-ll6zka"&&(je.innerHTML=hn),Dt=i(e),y(Z.$$.fragment,e),Ot=i(e),y(Ce.$$.fragment,e),Kt=i(e),be=p(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-197fgki"&&(be.innerHTML=Tn),el=i(e),y(k.$$.fragment,e),tl=i(e),$e=p(e,"P",{"data-svelte-h":!0}),u($e)!=="svelte-1v1bv0"&&($e.innerHTML=Jn),ll=i(e),Ae=p(e,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-kgt4mo"&&(Ae.innerHTML=wn),nl=i(e),y(ve.$$.fragment,e),sl=i(e),ze=p(e,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-1xx05av"&&(ze.innerHTML=Un),al=i(e),y(B.$$.fragment,e),il=i(e),y(Q.$$.fragment,e),ol=i(e),y(qe.$$.fragment,e),rl=i(e),Ee=p(e,"P",{"data-svelte-h":!0}),u(Ee)!=="svelte-smvyuk"&&(Ee.innerHTML=fn),pl=i(e),y(V.$$.fragment,e),ul=i(e),y(Ze.$$.fragment,e),Ml=i(e),y(R.$$.fragment,e),yl=i(e),y(ke.$$.fragment,e),dl=i(e),Be=p(e,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-1i6es6y"&&(Be.textContent=gn),cl=i(e),y(Qe.$$.fragment,e),ml=i(e),Ve=p(e,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-9zyo13"&&(Ve.textContent=In),hl=i(e),Re=p(e,"UL",{"data-svelte-h":!0}),u(Re)!=="svelte-kvalv2"&&(Re.innerHTML=jn),Tl=i(e),y(Ne.$$.fragment,e),Jl=i(e),y(N.$$.fragment,e),wl=i(e),_e=p(e,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-1t4oej1"&&(_e.innerHTML=Cn),Ul=i(e),Ge=p(e,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-1t8h4hs"&&(Ge.innerHTML=bn),fl=i(e),y(We.$$.fragment,e),gl=i(e),y(Le.$$.fragment,e),Il=i(e),Fe=p(e,"P",{"data-svelte-h":!0}),u(Fe)!=="svelte-6rxgjf"&&(Fe.innerHTML=$n),jl=i(e),y(Se.$$.fragment,e),Cl=i(e),y(He.$$.fragment,e),bl=i(e),xe=p(e,"P",{"data-svelte-h":!0}),u(xe)!=="svelte-1nawfg5"&&(xe.innerHTML=An),$l=i(e),y(Xe.$$.fragment,e),Al=i(e),y(Ye.$$.fragment,e),vl=i(e),Pe=p(e,"P",{"data-svelte-h":!0}),u(Pe)!=="svelte-1mikrss"&&(Pe.innerHTML=vn),zl=i(e),y(_.$$.fragment,e),ql=i(e),y(De.$$.fragment,e),El=i(e),Oe=p(e,"P",{"data-svelte-h":!0}),u(Oe)!=="svelte-1hthzd7"&&(Oe.innerHTML=zn),Zl=i(e),y(Ke.$$.fragment,e),kl=i(e),et=p(e,"P",{"data-svelte-h":!0}),u(et)!=="svelte-163a67e"&&(et.innerHTML=qn),Bl=i(e),y(tt.$$.fragment,e),Ql=i(e),lt=p(e,"P",{"data-svelte-h":!0}),u(lt)!=="svelte-rntoeu"&&(lt.textContent=En),Vl=i(e),y(nt.$$.fragment,e),Rl=i(e),y(st.$$.fragment,e),Nl=i(e),at=p(e,"P",{"data-svelte-h":!0}),u(at)!=="svelte-3vc2n3"&&(at.textContent=Zn),_l=i(e),it=p(e,"P",{"data-svelte-h":!0}),u(it)!=="svelte-1nopug0"&&(it.innerHTML=kn),Gl=i(e),Wl=p(e,"HR",{}),Ll=i(e),y(G.$$.fragment,e),Fl=i(e),y(ot.$$.fragment,e),Sl=i(e),rt=p(e,"P",{}),Yn(rt).forEach(l),this.h()},h(){Pn(s,"name","hf:doc:metadata"),Pn(s,"content",ws)},m(e,t){ls(document.head,s),n(e,T,t),n(e,o,t),n(e,J,t),d(I,e,t),n(e,f,t),n(e,j,t),n(e,U,t),d(C,e,t),n(e,pt,t),n(e,L,t),n(e,ut,t),n(e,Mt,t),n(e,yt,t),n(e,F,t),n(e,dt,t),n(e,S,t),n(e,ct,t),n(e,H,t),n(e,mt,t),n(e,x,t),n(e,ht,t),n(e,X,t),n(e,Tt,t),n(e,Y,t),n(e,Jt,t),d(v,e,t),n(e,wt,t),d(P,e,t),n(e,Ut,t),n(e,D,t),n(e,ft,t),n(e,O,t),n(e,gt,t),n(e,K,t),n(e,It,t),d(ee,e,t),n(e,jt,t),n(e,te,t),n(e,Ct,t),d(le,e,t),n(e,bt,t),n(e,ne,t),n(e,$t,t),n(e,se,t),n(e,At,t),d(ae,e,t),n(e,vt,t),n(e,ie,t),n(e,zt,t),d(z,e,t),n(e,qt,t),d(oe,e,t),n(e,Et,t),d(re,e,t),n(e,Zt,t),d(pe,e,t),n(e,kt,t),n(e,ue,t),n(e,Bt,t),d(q,e,t),n(e,Qt,t),d(Me,e,t),n(e,Vt,t),d(ye,e,t),n(e,Rt,t),n(e,de,t),n(e,Nt,t),d(ce,e,t),n(e,_t,t),n(e,me,t),n(e,Gt,t),n(e,he,t),n(e,Wt,t),d(Te,e,t),n(e,Lt,t),n(e,Je,t),n(e,Ft,t),n(e,we,t),n(e,St,t),n(e,Ue,t),n(e,Ht,t),n(e,fe,t),n(e,xt,t),d(E,e,t),n(e,Xt,t),d(ge,e,t),n(e,Yt,t),d(Ie,e,t),n(e,Pt,t),n(e,je,t),n(e,Dt,t),d(Z,e,t),n(e,Ot,t),d(Ce,e,t),n(e,Kt,t),n(e,be,t),n(e,el,t),d(k,e,t),n(e,tl,t),n(e,$e,t),n(e,ll,t),n(e,Ae,t),n(e,nl,t),d(ve,e,t),n(e,sl,t),n(e,ze,t),n(e,al,t),d(B,e,t),n(e,il,t),d(Q,e,t),n(e,ol,t),d(qe,e,t),n(e,rl,t),n(e,Ee,t),n(e,pl,t),d(V,e,t),n(e,ul,t),d(Ze,e,t),n(e,Ml,t),d(R,e,t),n(e,yl,t),d(ke,e,t),n(e,dl,t),n(e,Be,t),n(e,cl,t),d(Qe,e,t),n(e,ml,t),n(e,Ve,t),n(e,hl,t),n(e,Re,t),n(e,Tl,t),d(Ne,e,t),n(e,Jl,t),d(N,e,t),n(e,wl,t),n(e,_e,t),n(e,Ul,t),n(e,Ge,t),n(e,fl,t),d(We,e,t),n(e,gl,t),d(Le,e,t),n(e,Il,t),n(e,Fe,t),n(e,jl,t),d(Se,e,t),n(e,Cl,t),d(He,e,t),n(e,bl,t),n(e,xe,t),n(e,$l,t),d(Xe,e,t),n(e,Al,t),d(Ye,e,t),n(e,vl,t),n(e,Pe,t),n(e,zl,t),d(_,e,t),n(e,ql,t),d(De,e,t),n(e,El,t),n(e,Oe,t),n(e,Zl,t),d(Ke,e,t),n(e,kl,t),n(e,et,t),n(e,Bl,t),d(tt,e,t),n(e,Ql,t),n(e,lt,t),n(e,Vl,t),d(nt,e,t),n(e,Rl,t),d(st,e,t),n(e,Nl,t),n(e,at,t),n(e,_l,t),n(e,it,t),n(e,Gl,t),n(e,Wl,t),n(e,Ll,t),d(G,e,t),n(e,Fl,t),d(ot,e,t),n(e,Sl,t),n(e,rt,t),Hl=!0},p(e,[t]){const Bn={};t&2&&(Bn.$$scope={dirty:t,ctx:e}),C.$set(Bn);const Qn={};t&2&&(Qn.$$scope={dirty:t,ctx:e}),v.$set(Qn);const Vn={};t&2&&(Vn.$$scope={dirty:t,ctx:e}),z.$set(Vn);const Rn={};t&2&&(Rn.$$scope={dirty:t,ctx:e}),q.$set(Rn);const Nn={};t&2&&(Nn.$$scope={dirty:t,ctx:e}),E.$set(Nn);const _n={};t&2&&(_n.$$scope={dirty:t,ctx:e}),Z.$set(_n);const Gn={};t&2&&(Gn.$$scope={dirty:t,ctx:e}),k.$set(Gn);const Wn={};t&2&&(Wn.$$scope={dirty:t,ctx:e}),B.$set(Wn);const Ln={};t&2&&(Ln.$$scope={dirty:t,ctx:e}),Q.$set(Ln);const Fn={};t&2&&(Fn.$$scope={dirty:t,ctx:e}),V.$set(Fn);const Sn={};t&2&&(Sn.$$scope={dirty:t,ctx:e}),R.$set(Sn);const Hn={};t&2&&(Hn.$$scope={dirty:t,ctx:e}),N.$set(Hn);const xn={};t&2&&(xn.$$scope={dirty:t,ctx:e}),_.$set(xn);const Xn={};t&2&&(Xn.$$scope={dirty:t,ctx:e}),G.$set(Xn)},i(e){Hl||(c(I.$$.fragment,e),c(C.$$.fragment,e),c(v.$$.fragment,e),c(P.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(z.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(pe.$$.fragment,e),c(q.$$.fragment,e),c(Me.$$.fragment,e),c(ye.$$.fragment,e),c(ce.$$.fragment,e),c(Te.$$.fragment,e),c(E.$$.fragment,e),c(ge.$$.fragment,e),c(Ie.$$.fragment,e),c(Z.$$.fragment,e),c(Ce.$$.fragment,e),c(k.$$.fragment,e),c(ve.$$.fragment,e),c(B.$$.fragment,e),c(Q.$$.fragment,e),c(qe.$$.fragment,e),c(V.$$.fragment,e),c(Ze.$$.fragment,e),c(R.$$.fragment,e),c(ke.$$.fragment,e),c(Qe.$$.fragment,e),c(Ne.$$.fragment,e),c(N.$$.fragment,e),c(We.$$.fragment,e),c(Le.$$.fragment,e),c(Se.$$.fragment,e),c(He.$$.fragment,e),c(Xe.$$.fragment,e),c(Ye.$$.fragment,e),c(_.$$.fragment,e),c(De.$$.fragment,e),c(Ke.$$.fragment,e),c(tt.$$.fragment,e),c(nt.$$.fragment,e),c(st.$$.fragment,e),c(G.$$.fragment,e),c(ot.$$.fragment,e),Hl=!0)},o(e){m(I.$$.fragment,e),m(C.$$.fragment,e),m(v.$$.fragment,e),m(P.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(z.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(pe.$$.fragment,e),m(q.$$.fragment,e),m(Me.$$.fragment,e),m(ye.$$.fragment,e),m(ce.$$.fragment,e),m(Te.$$.fragment,e),m(E.$$.fragment,e),m(ge.$$.fragment,e),m(Ie.$$.fragment,e),m(Z.$$.fragment,e),m(Ce.$$.fragment,e),m(k.$$.fragment,e),m(ve.$$.fragment,e),m(B.$$.fragment,e),m(Q.$$.fragment,e),m(qe.$$.fragment,e),m(V.$$.fragment,e),m(Ze.$$.fragment,e),m(R.$$.fragment,e),m(ke.$$.fragment,e),m(Qe.$$.fragment,e),m(Ne.$$.fragment,e),m(N.$$.fragment,e),m(We.$$.fragment,e),m(Le.$$.fragment,e),m(Se.$$.fragment,e),m(He.$$.fragment,e),m(Xe.$$.fragment,e),m(Ye.$$.fragment,e),m(_.$$.fragment,e),m(De.$$.fragment,e),m(Ke.$$.fragment,e),m(tt.$$.fragment,e),m(nt.$$.fragment,e),m(st.$$.fragment,e),m(G.$$.fragment,e),m(ot.$$.fragment,e),Hl=!1},d(e){e&&(l(T),l(o),l(J),l(f),l(j),l(U),l(pt),l(L),l(ut),l(Mt),l(yt),l(F),l(dt),l(S),l(ct),l(H),l(mt),l(x),l(ht),l(X),l(Tt),l(Y),l(Jt),l(wt),l(Ut),l(D),l(ft),l(O),l(gt),l(K),l(It),l(jt),l(te),l(Ct),l(bt),l(ne),l($t),l(se),l(At),l(vt),l(ie),l(zt),l(qt),l(Et),l(Zt),l(kt),l(ue),l(Bt),l(Qt),l(Vt),l(Rt),l(de),l(Nt),l(_t),l(me),l(Gt),l(he),l(Wt),l(Lt),l(Je),l(Ft),l(we),l(St),l(Ue),l(Ht),l(fe),l(xt),l(Xt),l(Yt),l(Pt),l(je),l(Dt),l(Ot),l(Kt),l(be),l(el),l(tl),l($e),l(ll),l(Ae),l(nl),l(sl),l(ze),l(al),l(il),l(ol),l(rl),l(Ee),l(pl),l(ul),l(Ml),l(yl),l(dl),l(Be),l(cl),l(ml),l(Ve),l(hl),l(Re),l(Tl),l(Jl),l(wl),l(_e),l(Ul),l(Ge),l(fl),l(gl),l(Il),l(Fe),l(jl),l(Cl),l(bl),l(xe),l($l),l(Al),l(vl),l(Pe),l(zl),l(ql),l(El),l(Oe),l(Zl),l(kl),l(et),l(Bl),l(Ql),l(lt),l(Vl),l(Rl),l(Nl),l(at),l(_l),l(it),l(Gl),l(Wl),l(Ll),l(Fl),l(Sl),l(rt)),l(s),h(I,e),h(C,e),h(v,e),h(P,e),h(ee,e),h(le,e),h(ae,e),h(z,e),h(oe,e),h(re,e),h(pe,e),h(q,e),h(Me,e),h(ye,e),h(ce,e),h(Te,e),h(E,e),h(ge,e),h(Ie,e),h(Z,e),h(Ce,e),h(k,e),h(ve,e),h(B,e),h(Q,e),h(qe,e),h(V,e),h(Ze,e),h(R,e),h(ke,e),h(Qe,e),h(Ne,e),h(N,e),h(We,e),h(Le,e),h(Se,e),h(He,e),h(Xe,e),h(Ye,e),h(_,e),h(De,e),h(Ke,e),h(tt,e),h(nt,e),h(st,e),h(G,e),h(ot,e)}}}const ws='{"title":"Deploy Vision Language Models (VLMs) on Azure AI","local":"deploy-vision-language-models-vlms-on-azure-ai","sections":[{"title":"Pre-requisites","local":"pre-requisites","sections":[],"depth":2},{"title":"Setup and installation","local":"setup-and-installation","sections":[],"depth":2},{"title":"Authenticate to Azure ML","local":"authenticate-to-azure-ml","sections":[],"depth":2},{"title":"Create and Deploy Azure AI Endpoint","local":"create-and-deploy-azure-ai-endpoint","sections":[],"depth":2},{"title":"Send requests to the Azure AI Endpoint","local":"send-requests-to-the-azure-ai-endpoint","sections":[{"title":"Azure Python SDK","local":"azure-python-sdk","sections":[],"depth":3},{"title":"OpenAI Python SDK","local":"openai-python-sdk","sections":[],"depth":3},{"title":"cURL","local":"curl","sections":[],"depth":3},{"title":"Gradio","local":"gradio","sections":[],"depth":3}],"depth":2},{"title":"Release resources","local":"release-resources","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Us(w){return On(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends Kn{constructor(s){super(),es(this,s,Us,Js,Dn,{})}}export{bs as component};
