import{s as In,o as hn,n as Us}from"../chunks/scheduler.f7e1785c.js";import{S as mn,i as dn,g as o,s as n,r as j,A as bn,h as i,f as l,c as M,j as cn,u as U,x as p,k as un,y as gn,a as e,v as J,d as w,t as T,w as c,m as rn,n as Cn}from"../chunks/index.d8354395.js";import{T as m}from"../chunks/Tip.d2769a7f.js";import{C as h}from"../chunks/CodeBlock.191e5103.js";import{H as I,E as An}from"../chunks/getInferenceSnippets.fb90fd00.js";function fn(r){let a,u="Webhooks are push notifications - the Hugging Face Hub actively sends events to your application rather than you polling for changes. This enables real-time responses to discussions and comments.";return{c(){a=o("p"),a.textContent=u},l(y){a=i(y,"P",{"data-svelte-h":!0}),p(a)!=="svelte-1wqg0tm"&&(a.textContent=u)},m(y,C){e(y,a,C)},p:Us,d(y){y&&l(a)}}}function Bn(r){let a;return{c(){a=rn("The `tag_operations_store` list keeps track of recent webhook processing operations. This is useful for debugging and monitoring, but in production you might want to use a database or limit the size of this list.")},l(u){a=Cn(u,"The `tag_operations_store` list keeps track of recent webhook processing operations. This is useful for debugging and monitoring, but in production you might want to use a database or limit the size of this list.")},m(u,y){e(u,a,y)},d(u){u&&l(a)}}}function kn(r){let a,u="Always validate webhook secrets! Without this check, anyone could send fake webhook requests to your application. The secret acts as a shared password between Hugging Face and your application.";return{c(){a=o("p"),a.textContent=u},l(y){a=i(y,"P",{"data-svelte-h":!0}),p(a)!=="svelte-11ijmwy"&&(a.textContent=u)},m(y,C){e(y,a,C)},p:Us,d(y){y&&l(a)}}}function $n(r){let a,u="Webhook endpoints should respond within 10 seconds, or the sending platform may consider them failed. Using background tasks ensures fast responses while allowing complex processing to happen asynchronously.";return{c(){a=o("p"),a.textContent=u},l(y){a=i(y,"P",{"data-svelte-h":!0}),p(a)!=="svelte-fjgp0w"&&(a.textContent=u)},m(y,C){e(y,a,C)},p:Us,d(y){y&&l(a)}}}function vn(r){let a,u="Storing operation records is crucial for debugging and monitoring. When something goes wrong, you can look at recent operations to understand what happened and why.";return{c(){a=o("p"),a.textContent=u},l(y){a=i(y,"P",{"data-svelte-h":!0}),p(a)!=="svelte-60htf8"&&(a.textContent=u)},m(y,C){e(y,a,C)},p:Us,d(y){y&&l(a)}}}function qn(r){let a,u="Health and monitoring endpoints are crucial for production deployments. They help you quickly identify configuration issues and monitor your application’s activity without digging through logs.";return{c(){a=o("p"),a.textContent=u},l(y){a=i(y,"P",{"data-svelte-h":!0}),p(a)!=="svelte-zpdb66"&&(a.textContent=u)},m(y,C){e(y,a,C)},p:Us,d(y){y&&l(a)}}}function Zn(r){let a,u="Start with one or two test repositories before configuring webhooks for many repositories. This lets you validate your application works correctly before scaling up.";return{c(){a=o("p"),a.textContent=u},l(y){a=i(y,"P",{"data-svelte-h":!0}),p(a)!=="svelte-bh7vmx"&&(a.textContent=u)},m(y,C){e(y,a,C)},p:Us,d(y){y&&l(a)}}}function Qn(r){let a;return{c(){a=rn("Simulation endpoints are incredibly useful during development. They let you test different tag combinations and edge cases without creating actual repository discussions.")},l(u){a=Cn(u,"Simulation endpoints are incredibly useful during development. They let you test different tag combinations and edge cases without creating actual repository discussions.")},m(u,y){e(u,a,y)},d(u){u&&l(a)}}}function Gn(r){let a,u="Always return webhook responses quickly (within 10 seconds) to avoid timeouts. Use background tasks for longer processing operations like MCP tool execution and pull request creation.";return{c(){a=o("p"),a.textContent=u},l(y){a=i(y,"P",{"data-svelte-h":!0}),p(a)!=="svelte-1434cu3"&&(a.textContent=u)},m(y,C){e(y,a,C)},p:Us,d(y){y&&l(a)}}}function Wn(r){let a,u,y,C,q,ws,Z,ne="The webhook listener is the entry point for our Pull Request Agent. It receives real-time events from the Hugging Face Hub when discussions are created or updated, triggering our MCP-powered tagging workflow. In this section, we’ll implement a webhook handler using FastAPI.",Ts,Q,cs,G,Me='Following the <a href="https://raw.githubusercontent.com/huggingface/hub-docs/refs/heads/main/docs/hub/webhooks-guide-discussion-bot.md" rel="nofollow">Hugging Face Webhooks Guide</a>, our webhook listener validates incoming requests and processes discussion events in real-time.',us,W,ae='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/001-discussion-bot/webhook-creation.png" alt="Webhook Creation"/>',rs,E,Cs,N,oe="Understanding the webhook flow is crucial for building a reliable listener:",Is,R,ie="<li><strong>User Action</strong>: Someone creates a comment in a model repository discussion</li> <li><strong>Hub Event</strong>: Hugging Face generates a webhook event</li> <li><strong>Webhook Delivery</strong>: Hub sends POST request to our endpoint</li> <li><strong>Authentication</strong>: We validate the webhook secret</li> <li><strong>Processing</strong>: Extract tags from the comment content</li> <li><strong>Action</strong>: Use MCP tools to create pull requests for new tags</li>",hs,d,ms,_,ds,S,pe="Let’s build our webhook listener step by step, starting with the foundation and building up to the complete processing logic.",bs,V,gs,x,ye="First, let’s set up the basic FastAPI application with all necessary imports and configuration:",As,Y,fs,X,je="These imports give us everything we need to build a robust webhook handler. <code>FastAPI</code> provides the web framework, <code>BackgroundTasks</code> enables async processing, and the typing imports help with data validation.",Bs,H,Ue="Now let’s configure our application:",ks,z,$s,F,Je="This configuration sets up:",vs,P,we="<li><strong>Webhook secret</strong>: For validating incoming webhooks</li> <li><strong>HF token</strong>: For authenticating with the Hub API</li> <li><strong>Operations store</strong>: In-memory storage for monitoring processed operations</li> <li><strong>CORS middleware</strong>: Allows cross-origin requests for the web interface</li>",qs,b,Zs,L,Qs,K,Te='Based on the <a href="https://raw.githubusercontent.com/huggingface/hub-docs/refs/heads/main/docs/hub/webhooks-guide-discussion-bot.md" rel="nofollow">Hugging Face webhook documentation</a>, we need to understand the webhook data structure:',Gs,O,Ws,D,ce="This Pydantic model helps us understand the webhook structure.",Es,tt,ue="The key fields we care about are:",Ns,st,re="<li><code>event.action</code>: Usually “create” for new comments</li> <li><code>event.scope</code>: Usually “discussion.comment” for comment events</li> <li><code>comment.content</code>: The actual comment text</li> <li><code>repo.name</code>: The repository where the comment was made</li>",Rs,lt,_s,et,Ce="Now for the main webhook handler - this is where the important part happens. Let’s break it down into digestible pieces:",Ss,nt,Vs,Mt,Ie="The first step is security validation. We check the <code>X-Webhook-Secret</code> header against our configured secret to ensure the webhook is legitimate.",xs,g,Ys,at,he="Next, let’s parse and validate the webhook data:",Xs,ot,Hs,it,me="This parsing step handles potential JSON errors gracefully and validates that we have the expected event structure.",zs,pt,de="Now for the event filtering logic:",Fs,yt,Ps,jt,be="This filtering ensures we only process the events we care about - new discussion comments. We ignore other events like repository creation, model uploads, etc.",Ls,Ut,ge="We use FastAPI’s <code>background_tasks.add_task()</code> to process the webhook asynchronously. This allows us to return a response quickly (within seconds) while the actual tag processing happens in the background.",Ks,A,Os,Jt,Ds,wt,Ae="Now let’s implement the core comment processing function that does the actual tag extraction and MCP tool usage:",tl,Tt,sl,ct,fe="This initial section extracts all the relevant information from the webhook data. We get both the comment content and discussion title since tags might be mentioned in either place.",ll,ut,Be="Next, we extract and process the tags:",el,rt,nl,Ct,ke="We combine tags from both sources and create an operation record for monitoring. This record tracks the progress of each webhook processing operation.",Ml,f,al,It,$e="Now for the MCP agent integration:",ol,ht,il,mt,ve="This section handles the core business logic:",pl,dt,qe="<li><strong>Validation</strong>: Ensure we have tags to process and an available agent</li> <li><strong>Processing</strong>: For each tag, create a natural language prompt for the agent</li> <li><strong>Recording</strong>: Store all results for monitoring and debugging</li> <li><strong>Error handling</strong>: Gracefully handle errors for individual tags</li>",yl,bt,Ze="The agent prompt is carefully crafted to instruct the AI on exactly what steps to take: check current tags first, then add the new tag if appropriate.",jl,gt,Ul,At,Qe="Besides the webhook handler, we need endpoints for monitoring and debugging. Let’s add these essential endpoints:",Jl,ft,wl,Bt,Ge="The root endpoint provides basic information about your service and its available endpoints.",Tl,kt,cl,$t,We="The health check endpoint validates that all your components are properly configured. This is essential for production monitoring.",ul,vt,rl,qt,Ee="The operations endpoint lets you see recent webhook processing activity, which is invaluable for debugging and monitoring.",Cl,B,Il,Zt,hl,Qt,Ne="Now that we have our webhook listener ready, let’s configure it on the Hugging Face Hub. This is where we connect our application to real repository events.",ml,Gt,dl,Wt,Re='Following the <a href="https://huggingface.co/docs/hub/webhooks-guide-discussion-bot" rel="nofollow">webhook setup guide</a>:',bl,Et,_e='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/001-discussion-bot/webhook-creation.png" alt="Webhook Settings"/>',gl,Nt,Se='Navigate to your <a href="https://huggingface.co/settings/webhooks" rel="nofollow">Hugging Face Settings</a> and configure:',Al,Rt,Ve="<li><strong>Target Repositories</strong>: Specify which repositories to monitor</li> <li><strong>Webhook URL</strong>: Your deployed application endpoint (e.g., <code>https://your-space.hf.space/webhook</code>)</li> <li><strong>Secret</strong>: Use the same secret from your <code>WEBHOOK_SECRET</code> environment variable</li> <li><strong>Events</strong>: Subscribe to “Community (PR &amp; discussions)” events</li>",fl,k,Bl,_t,kl,St,xe="For Hugging Face Spaces deployment, you’ll need to get your direct URL:",$l,Vt,Ye='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/001-discussion-bot/direct-url.png" alt="Direct URL"/>',vl,xt,Xe="The process is:",ql,Yt,He="<li>Click “Embed this Space” in your Space settings</li> <li>Copy the “Direct URL”</li> <li>Append <code>/webhook</code> to create your webhook endpoint</li> <li>Update your webhook configuration with this URL</li>",Zl,Xt,ze="For example, if your Space URL is <code>https://username-space-name.hf.space</code>, your webhook endpoint would be <code>https://username-space-name.hf.space/webhook</code>.",Ql,Ht,Fe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/001-discussion-bot/direct-url.png" alt="Space URL"/>',Gl,zt,Wl,Ft,Pe="Testing is crucial before deploying to production. Let’s walk through different testing approaches:",El,Pt,Nl,Lt,Le="You can test your webhook handler locally using a simple script:",Rl,Kt,_l,Ot,Ke="This script simulates a real webhook request, allowing you to test your handler without waiting for real events.",Sl,Dt,Vl,ts,Oe="You can also add a simulation endpoint to your FastAPI application for easier testing:",xl,ss,Yl,ls,De="This endpoint makes it easy to test different scenarios through your application’s interface.",Xl,$,Hl,es,zl,ns,tn="When everything is working correctly, you should see results like the discussion bot example:",Fl,Ms,sn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/webhooks-guides/001-discussion-bot/discussion-result.png" alt="Discussion Result"/>',Pl,as,ln="This screenshot shows a successful webhook processing where the bot creates a pull request in response to a discussion comment.",Ll,os,Kl,is,en="With our webhook listener implemented, we now have:",Ol,ps,nn="<li><strong>Secure webhook validation</strong> following Hugging Face best practices</li> <li><strong>Real-time event processing</strong> with background task handling</li> <li><strong>MCP integration</strong> for intelligent tag management</li> <li><strong>Monitoring and debugging</strong> capabilities</li>",Dl,ys,Mn="In the next section, we’ll integrate everything into a complete Pull Request Agent that demonstrates the full workflow from webhook to PR creation.",te,v,se,js,le,Js,ee;return q=new I({props:{title:"Webhook Listener",local:"webhook-listener",headingTag:"h1"}}),Q=new I({props:{title:"Understanding Webhook Integration",local:"understanding-webhook-integration",headingTag:"h2"}}),E=new I({props:{title:"Webhook Event Flow",local:"webhook-event-flow",headingTag:"h3"}}),d=new m({props:{$$slots:{default:[fn]},$$scope:{ctx:r}}}),_=new I({props:{title:"FastAPI Webhook Application",local:"fastapi-webhook-application",headingTag:"h2"}}),V=new I({props:{title:"1. Application Setup",local:"1-application-setup",headingTag:"h3"}}),Y=new h({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBqc29uJTBBZnJvbSUyMGRhdGV0aW1lJTIwaW1wb3J0JTIwZGF0ZXRpbWUlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwTGlzdCUyQyUyMERpY3QlMkMlMjBBbnklMkMlMjBPcHRpb25hbCUwQSUwQWZyb20lMjBmYXN0YXBpJTIwaW1wb3J0JTIwRmFzdEFQSSUyQyUyMFJlcXVlc3QlMkMlMjBCYWNrZ3JvdW5kVGFza3MlMEFmcm9tJTIwZmFzdGFwaS5taWRkbGV3YXJlLmNvcnMlMjBpbXBvcnQlMjBDT1JTTWlkZGxld2FyZSUwQWZyb20lMjBweWRhbnRpYyUyMGltcG9ydCUyMEJhc2VNb2RlbA==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> datetime <span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>, <span class="hljs-type">Optional</span>

<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> FastAPI, Request, BackgroundTasks
<span class="hljs-keyword">from</span> fastapi.middleware.cors <span class="hljs-keyword">import</span> CORSMiddleware
<span class="hljs-keyword">from</span> pydantic <span class="hljs-keyword">import</span> BaseModel`,wrap:!1}}),z=new h({props:{code:"JTIzJTIwQ29uZmlndXJhdGlvbiUwQVdFQkhPT0tfU0VDUkVUJTIwJTNEJTIwb3MuZ2V0ZW52KCUyMldFQkhPT0tfU0VDUkVUJTIyKSUwQUhGX1RPS0VOJTIwJTNEJTIwb3MuZ2V0ZW52KCUyMkhGX1RPS0VOJTIyKSUwQSUwQSUyMyUyMFNpbXBsZSUyMHN0b3JhZ2UlMjBmb3IlMjBwcm9jZXNzZWQlMjBvcGVyYXRpb25zJTBBdGFnX29wZXJhdGlvbnNfc3RvcmUlM0ElMjBMaXN0JTVCRGljdCU1QnN0ciUyQyUyMEFueSU1RCU1RCUyMCUzRCUyMCU1QiU1RCUwQSUwQWFwcCUyMCUzRCUyMEZhc3RBUEkodGl0bGUlM0QlMjJIRiUyMFRhZ2dpbmclMjBCb3QlMjIpJTBBYXBwLmFkZF9taWRkbGV3YXJlKENPUlNNaWRkbGV3YXJlJTJDJTIwYWxsb3dfb3JpZ2lucyUzRCU1QiUyMiolMjIlNUQp",highlighted:`<span class="hljs-comment"># Configuration</span>
WEBHOOK_SECRET = os.getenv(<span class="hljs-string">&quot;WEBHOOK_SECRET&quot;</span>)
HF_TOKEN = os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)

<span class="hljs-comment"># Simple storage for processed operations</span>
tag_operations_store: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]] = []

app = FastAPI(title=<span class="hljs-string">&quot;HF Tagging Bot&quot;</span>)
app.add_middleware(CORSMiddleware, allow_origins=[<span class="hljs-string">&quot;*&quot;</span>])`,wrap:!1}}),b=new m({props:{$$slots:{default:[Bn]},$$scope:{ctx:r}}}),L=new I({props:{title:"2. Webhook Data Models",local:"2-webhook-data-models",headingTag:"h3"}}),O=new h({props:{code:"Y2xhc3MlMjBXZWJob29rRXZlbnQoQmFzZU1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMGV2ZW50JTNBJTIwRGljdCU1QnN0ciUyQyUyMHN0ciU1RCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENvbnRhaW5zJTIwYWN0aW9uJTIwYW5kJTIwc2NvcGUlMjBpbmZvcm1hdGlvbiUwQSUyMCUyMCUyMCUyMGNvbW1lbnQlM0ElMjBEaWN0JTVCc3RyJTJDJTIwQW55JTVEJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQ29tbWVudCUyMGNvbnRlbnQlMjBhbmQlMjBtZXRhZGF0YSUwQSUyMCUyMCUyMCUyMGRpc2N1c3Npb24lM0ElMjBEaWN0JTVCc3RyJTJDJTIwQW55JTVEJTIwJTIwJTIwJTIwJTIwJTIzJTIwRGlzY3Vzc2lvbiUyMGluZm9ybWF0aW9uJTBBJTIwJTIwJTIwJTIwcmVwbyUzQSUyMERpY3QlNUJzdHIlMkMlMjBzdHIlNUQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBSZXBvc2l0b3J5JTIwZGV0YWlscw==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">WebhookEvent</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
    event: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">str</span>]          <span class="hljs-comment"># Contains action and scope information</span>
    comment: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]        <span class="hljs-comment"># Comment content and metadata</span>
    discussion: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]     <span class="hljs-comment"># Discussion information</span>
    repo: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">str</span>]           <span class="hljs-comment"># Repository details</span>`,wrap:!1}}),lt=new I({props:{title:"3. Core Webhook Handler",local:"3-core-webhook-handler",headingTag:"h3"}}),nt=new h({props:{code:"JTQwYXBwLnBvc3QoJTIyJTJGd2ViaG9vayUyMiklMEFhc3luYyUyMGRlZiUyMHdlYmhvb2tfaGFuZGxlcihyZXF1ZXN0JTNBJTIwUmVxdWVzdCUyQyUyMGJhY2tncm91bmRfdGFza3MlM0ElMjBCYWNrZ3JvdW5kVGFza3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwSGFuZGxlJTIwaW5jb21pbmclMjB3ZWJob29rcyUyMGZyb20lMjBIdWdnaW5nJTIwRmFjZSUyMEh1YiUwQSUyMCUyMCUyMCUyMEZvbGxvd2luZyUyMHRoZSUyMHBhdHRlcm4lMjBmcm9tJTNBJTIwaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGaHVnZ2luZ2ZhY2UlMkZodWItZG9jcyUyRnJlZnMlMkZoZWFkcyUyRm1haW4lMkZkb2NzJTJGaHViJTJGd2ViaG9va3MtZ3VpZGUtZGlzY3Vzc2lvbi1ib3QubWQlMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBwcmludCglMjIlRjAlOUYlOTQlOTQlMjBXZWJob29rJTIwcmVjZWl2ZWQhJTIyKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFN0ZXAlMjAxJTNBJTIwVmFsaWRhdGUlMjB3ZWJob29rJTIwc2VjcmV0JTIwKHNlY3VyaXR5KSUwQSUyMCUyMCUyMCUyMHdlYmhvb2tfc2VjcmV0JTIwJTNEJTIwcmVxdWVzdC5oZWFkZXJzLmdldCglMjJYLVdlYmhvb2stU2VjcmV0JTIyKSUwQSUyMCUyMCUyMCUyMGlmJTIwd2ViaG9va19zZWNyZXQlMjAhJTNEJTIwV0VCSE9PS19TRUNSRVQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCglMjIlRTIlOUQlOEMlMjBJbnZhbGlkJTIwd2ViaG9vayUyMHNlY3JldCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJlcnJvciUyMiUzQSUyMCUyMmluY29ycmVjdCUyMHNlY3JldCUyMiU3RCUyQyUyMDQwMA==",highlighted:`<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/webhook&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">webhook_handler</span>(<span class="hljs-params">request: Request, background_tasks: BackgroundTasks</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Handle incoming webhooks from Hugging Face Hub
    Following the pattern from: https://raw.githubusercontent.com/huggingface/hub-docs/refs/heads/main/docs/hub/webhooks-guide-discussion-bot.md
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🔔 Webhook received!&quot;</span>)
    
    <span class="hljs-comment"># Step 1: Validate webhook secret (security)</span>
    webhook_secret = request.headers.get(<span class="hljs-string">&quot;X-Webhook-Secret&quot;</span>)
    <span class="hljs-keyword">if</span> webhook_secret != WEBHOOK_SECRET:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;❌ Invalid webhook secret&quot;</span>)
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-string">&quot;incorrect secret&quot;</span>}, <span class="hljs-number">400</span>`,wrap:!1}}),g=new m({props:{$$slots:{default:[kn]},$$scope:{ctx:r}}}),ot=new h({props:{code:"JTIwJTIwJTIwJTIwJTIzJTIwU3RlcCUyMDIlM0ElMjBQYXJzZSUyMHdlYmhvb2slMjBkYXRhJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2ViaG9va19kYXRhJTIwJTNEJTIwYXdhaXQlMjByZXF1ZXN0Lmpzb24oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjIlRjAlOUYlOTMlQTUlMjBXZWJob29rJTIwZGF0YSUzQSUyMCU3Qmpzb24uZHVtcHMod2ViaG9va19kYXRhJTJDJTIwaW5kZW50JTNEMiklN0QlMjIpJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwRXhjZXB0aW9uJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVFMiU5RCU4QyUyMEVycm9yJTIwcGFyc2luZyUyMHdlYmhvb2slMjBkYXRhJTNBJTIwJTdCc3RyKGUpJTdEJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmVycm9yJTIyJTNBJTIwJTIyaW52YWxpZCUyMEpTT04lMjIlN0QlMkMlMjA0MDAlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBTdGVwJTIwMyUzQSUyMFZhbGlkYXRlJTIwZXZlbnQlMjBzdHJ1Y3R1cmUlMEElMjAlMjAlMjAlMjBldmVudCUyMCUzRCUyMHdlYmhvb2tfZGF0YS5nZXQoJTIyZXZlbnQlMjIlMkMlMjAlN0IlN0QpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBldmVudCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMiVFMiU5RCU4QyUyME5vJTIwZXZlbnQlMjBkYXRhJTIwaW4lMjB3ZWJob29rJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmVycm9yJTIyJTNBJTIwJTIybWlzc2luZyUyMGV2ZW50JTIwZGF0YSUyMiU3RCUyQyUyMDQwMA==",highlighted:`    <span class="hljs-comment"># Step 2: Parse webhook data</span>
    <span class="hljs-keyword">try</span>:
        webhook_data = <span class="hljs-keyword">await</span> request.json()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📥 Webhook data: <span class="hljs-subst">{json.dumps(webhook_data, indent=<span class="hljs-number">2</span>)}</span>&quot;</span>)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ Error parsing webhook data: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-string">&quot;invalid JSON&quot;</span>}, <span class="hljs-number">400</span>
    
    <span class="hljs-comment"># Step 3: Validate event structure</span>
    event = webhook_data.get(<span class="hljs-string">&quot;event&quot;</span>, {})
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> event:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;❌ No event data in webhook&quot;</span>)
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-string">&quot;missing event data&quot;</span>}, <span class="hljs-number">400</span>`,wrap:!1}}),yt=new h({props:{code:"JTIwJTIwJTIwJTIwJTIzJTIwU3RlcCUyMDQlM0ElMjBDaGVjayUyMGlmJTIwdGhpcyUyMGlzJTIwYSUyMGRpc2N1c3Npb24lMjBjb21tZW50JTIwY3JlYXRpb24lMEElMjAlMjAlMjAlMjAlMjMlMjBGb2xsb3dpbmclMjB0aGUlMjB3ZWJob29rJTIwZ3VpZGUlMjBwYXR0ZXJuJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXZlbnQuZ2V0KCUyMmFjdGlvbiUyMiklMjAlM0QlM0QlMjAlMjJjcmVhdGUlMjIlMjBhbmQlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBldmVudC5nZXQoJTIyc2NvcGUlMjIpJTIwJTNEJTNEJTIwJTIyZGlzY3Vzc2lvbi5jb21tZW50JTIyJTBBJTIwJTIwJTIwJTIwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMiVFMiU5QyU4NSUyMFZhbGlkJTIwZGlzY3Vzc2lvbiUyMGNvbW1lbnQlMjBjcmVhdGlvbiUyMGV2ZW50JTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjBpbiUyMGJhY2tncm91bmQlMjB0byUyMHJldHVybiUyMHF1aWNrbHklMjB0byUyMEh1YiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhY2tncm91bmRfdGFza3MuYWRkX3Rhc2socHJvY2Vzc193ZWJob29rX2NvbW1lbnQlMkMlMjB3ZWJob29rX2RhdGEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhdHVzJTIyJTNBJTIwJTIyYWNjZXB0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXNzYWdlJTIyJTNBJTIwJTIyQ29tbWVudCUyMHByb2Nlc3NpbmclMjBzdGFydGVkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGltZXN0YW1wJTIyJTNBJTIwZGF0ZXRpbWUubm93KCkuaXNvZm9ybWF0KCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVFMiU4NCVCOSVFRiVCOCU4RiUyMElnbm9yaW5nJTIwZXZlbnQlM0ElMjBhY3Rpb24lM0QlN0JldmVudC5nZXQoJ2FjdGlvbicpJTdEJTJDJTIwc2NvcGUlM0QlN0JldmVudC5nZXQoJ3Njb3BlJyklN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhdHVzJTIyJTNBJTIwJTIyaWdub3JlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlYXNvbiUyMiUzQSUyMCUyMk5vdCUyMGElMjBkaXNjdXNzaW9uJTIwY29tbWVudCUyMGNyZWF0aW9uJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdE",highlighted:`    <span class="hljs-comment"># Step 4: Check if this is a discussion comment creation</span>
    <span class="hljs-comment"># Following the webhook guide pattern:</span>
    <span class="hljs-keyword">if</span> (
        event.get(<span class="hljs-string">&quot;action&quot;</span>) == <span class="hljs-string">&quot;create&quot;</span> <span class="hljs-keyword">and</span> 
        event.get(<span class="hljs-string">&quot;scope&quot;</span>) == <span class="hljs-string">&quot;discussion.comment&quot;</span>
    ):
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;✅ Valid discussion comment creation event&quot;</span>)
        
        <span class="hljs-comment"># Process in background to return quickly to Hub</span>
        background_tasks.add_task(process_webhook_comment, webhook_data)
        
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;accepted&quot;</span>,
            <span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">&quot;Comment processing started&quot;</span>,
            <span class="hljs-string">&quot;timestamp&quot;</span>: datetime.now().isoformat()
        }
    <span class="hljs-keyword">else</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;ℹ️ Ignoring event: action=<span class="hljs-subst">{event.get(<span class="hljs-string">&#x27;action&#x27;</span>)}</span>, scope=<span class="hljs-subst">{event.get(<span class="hljs-string">&#x27;scope&#x27;</span>)}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> {
            <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;ignored&quot;</span>,
            <span class="hljs-string">&quot;reason&quot;</span>: <span class="hljs-string">&quot;Not a discussion comment creation&quot;</span>
        }`,wrap:!1}}),A=new m({props:{$$slots:{default:[$n]},$$scope:{ctx:r}}}),Jt=new I({props:{title:"4. Comment Processing Logic",local:"4-comment-processing-logic",headingTag:"h3"}}),Tt=new h({props:{code:"YXN5bmMlMjBkZWYlMjBwcm9jZXNzX3dlYmhvb2tfY29tbWVudCh3ZWJob29rX2RhdGElM0ElMjBEaWN0JTVCc3RyJTJDJTIwQW55JTVEKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMFByb2Nlc3MlMjB3ZWJob29rJTIwY29tbWVudCUyMHRvJTIwZGV0ZWN0JTIwYW5kJTIwYWRkJTIwdGFncyUwQSUyMCUyMCUyMCUyMEludGVncmF0ZXMlMjB3aXRoJTIwb3VyJTIwTUNQJTIwY2xpZW50JTIwZm9yJTIwSHViJTIwaW50ZXJhY3Rpb25zJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJUYwJTlGJThGJUI3JUVGJUI4JThGJTIwU3RhcnRpbmclMjBwcm9jZXNzX3dlYmhvb2tfY29tbWVudC4uLiUyMiklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBFeHRyYWN0JTIwY29tbWVudCUyMGFuZCUyMHJlcG9zaXRvcnklMjBpbmZvcm1hdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbW1lbnRfY29udGVudCUyMCUzRCUyMHdlYmhvb2tfZGF0YSU1QiUyMmNvbW1lbnQlMjIlNUQlNUIlMjJjb250ZW50JTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGlzY3Vzc2lvbl90aXRsZSUyMCUzRCUyMHdlYmhvb2tfZGF0YSU1QiUyMmRpc2N1c3Npb24lMjIlNUQlNUIlMjJ0aXRsZSUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9fbmFtZSUyMCUzRCUyMHdlYmhvb2tfZGF0YSU1QiUyMnJlcG8lMjIlNUQlNUIlMjJuYW1lJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGlzY3Vzc2lvbl9udW0lMjAlM0QlMjB3ZWJob29rX2RhdGElNUIlMjJkaXNjdXNzaW9uJTIyJTVEJTVCJTIybnVtJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29tbWVudF9hdXRob3IlMjAlM0QlMjB3ZWJob29rX2RhdGElNUIlMjJjb21tZW50JTIyJTVEJTVCJTIyYXV0aG9yJTIyJTVELmdldCglMjJpZCUyMiUyQyUyMCUyMnVua25vd24lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVGMCU5RiU5MyU5RCUyMENvbW1lbnQlMjBmcm9tJTIwJTdCY29tbWVudF9hdXRob3IlN0QlM0ElMjAlN0Jjb21tZW50X2NvbnRlbnQlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVGMCU5RiU5MyVCMCUyMERpc2N1c3Npb24lM0ElMjAlN0JkaXNjdXNzaW9uX3RpdGxlJTdEJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjIlRjAlOUYlOTMlQTYlMjBSZXBvc2l0b3J5JTNBJTIwJTdCcmVwb19uYW1lJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">process_webhook_comment</span>(<span class="hljs-params">webhook_data: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Process webhook comment to detect and add tags
    Integrates with our MCP client for Hub interactions
    &quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;🏷️ Starting process_webhook_comment...&quot;</span>)
    
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Extract comment and repository information</span>
        comment_content = webhook_data[<span class="hljs-string">&quot;comment&quot;</span>][<span class="hljs-string">&quot;content&quot;</span>]
        discussion_title = webhook_data[<span class="hljs-string">&quot;discussion&quot;</span>][<span class="hljs-string">&quot;title&quot;</span>]
        repo_name = webhook_data[<span class="hljs-string">&quot;repo&quot;</span>][<span class="hljs-string">&quot;name&quot;</span>]
        discussion_num = webhook_data[<span class="hljs-string">&quot;discussion&quot;</span>][<span class="hljs-string">&quot;num&quot;</span>]
        comment_author = webhook_data[<span class="hljs-string">&quot;comment&quot;</span>][<span class="hljs-string">&quot;author&quot;</span>].get(<span class="hljs-string">&quot;id&quot;</span>, <span class="hljs-string">&quot;unknown&quot;</span>)
        
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📝 Comment from <span class="hljs-subst">{comment_author}</span>: <span class="hljs-subst">{comment_content}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📰 Discussion: <span class="hljs-subst">{discussion_title}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📦 Repository: <span class="hljs-subst">{repo_name}</span>&quot;</span>)`,wrap:!1}}),rt=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRXh0cmFjdCUyMHBvdGVudGlhbCUyMHRhZ3MlMjBmcm9tJTIwY29tbWVudCUyMGFuZCUyMHRpdGxlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29tbWVudF90YWdzJTIwJTNEJTIwZXh0cmFjdF90YWdzX2Zyb21fdGV4dChjb21tZW50X2NvbnRlbnQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGVfdGFncyUyMCUzRCUyMGV4dHJhY3RfdGFnc19mcm9tX3RleHQoZGlzY3Vzc2lvbl90aXRsZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbGxfdGFncyUyMCUzRCUyMGxpc3Qoc2V0KGNvbW1lbnRfdGFncyUyMCUyQiUyMHRpdGxlX3RhZ3MpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjIlRjAlOUYlOTQlOEQlMjBGb3VuZCUyMHRhZ3MlM0ElMjAlN0JhbGxfdGFncyU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTdG9yZSUyMG9wZXJhdGlvbiUyMGZvciUyMG1vbml0b3JpbmclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcGVyYXRpb24lMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0aW1lc3RhbXAlMjIlM0ElMjBkYXRldGltZS5ub3coKS5pc29mb3JtYXQoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcG9fbmFtZSUyMiUzQSUyMHJlcG9fbmFtZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRpc2N1c3Npb25fbnVtJTIyJTNBJTIwZGlzY3Vzc2lvbl9udW0lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb21tZW50X2F1dGhvciUyMiUzQSUyMGNvbW1lbnRfYXV0aG9yJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZXh0cmFjdGVkX3RhZ3MlMjIlM0ElMjBhbGxfdGFncyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbW1lbnRfcHJldmlldyUyMiUzQSUyMGNvbW1lbnRfY29udGVudCU1QiUzQTEwMCU1RCUyMCUyQiUyMCUyMi4uLiUyMiUyMGlmJTIwbGVuKGNvbW1lbnRfY29udGVudCklMjAlM0UlMjAxMDAlMjBlbHNlJTIwY29tbWVudF9jb250ZW50JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhdHVzJTIyJTNBJTIwJTIycHJvY2Vzc2luZyUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhZ19vcGVyYXRpb25zX3N0b3JlLmFwcGVuZChvcGVyYXRpb24p",highlighted:`        <span class="hljs-comment"># Extract potential tags from comment and title</span>
        comment_tags = extract_tags_from_text(comment_content)
        title_tags = extract_tags_from_text(discussion_title)
        all_tags = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(comment_tags + title_tags))
        
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔍 Found tags: <span class="hljs-subst">{all_tags}</span>&quot;</span>)
        
        <span class="hljs-comment"># Store operation for monitoring</span>
        operation = {
            <span class="hljs-string">&quot;timestamp&quot;</span>: datetime.now().isoformat(),
            <span class="hljs-string">&quot;repo_name&quot;</span>: repo_name,
            <span class="hljs-string">&quot;discussion_num&quot;</span>: discussion_num,
            <span class="hljs-string">&quot;comment_author&quot;</span>: comment_author,
            <span class="hljs-string">&quot;extracted_tags&quot;</span>: all_tags,
            <span class="hljs-string">&quot;comment_preview&quot;</span>: comment_content[:<span class="hljs-number">100</span>] + <span class="hljs-string">&quot;...&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(comment_content) &gt; <span class="hljs-number">100</span> <span class="hljs-keyword">else</span> comment_content,
            <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;processing&quot;</span>
        }
        tag_operations_store.append(operation)`,wrap:!1}}),f=new m({props:{$$slots:{default:[vn]},$$scope:{ctx:r}}}),ht=new h({props:{code:"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",highlighted:`        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> all_tags:
            operation[<span class="hljs-string">&quot;status&quot;</span>] = <span class="hljs-string">&quot;no_tags&quot;</span>
            operation[<span class="hljs-string">&quot;message&quot;</span>] = <span class="hljs-string">&quot;No recognizable tags found&quot;</span>
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;❌ No tags found to process&quot;</span>)
            <span class="hljs-keyword">return</span>
        
        <span class="hljs-comment"># Get MCP agent for tag processing</span>
        agent = <span class="hljs-keyword">await</span> get_agent()
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> agent:
            operation[<span class="hljs-string">&quot;status&quot;</span>] = <span class="hljs-string">&quot;error&quot;</span>
            operation[<span class="hljs-string">&quot;message&quot;</span>] = <span class="hljs-string">&quot;Agent not configured (missing HF_TOKEN)&quot;</span>
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;❌ No agent available&quot;</span>)
            <span class="hljs-keyword">return</span>
        
        <span class="hljs-comment"># Process each extracted tag</span>
        operation[<span class="hljs-string">&quot;results&quot;</span>] = []
        <span class="hljs-keyword">for</span> tag <span class="hljs-keyword">in</span> all_tags:
            <span class="hljs-keyword">try</span>:
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🤖 Processing tag &#x27;<span class="hljs-subst">{tag}</span>&#x27; for repo &#x27;<span class="hljs-subst">{repo_name}</span>&#x27;&quot;</span>)
                
                <span class="hljs-comment"># Create prompt for agent to handle tag processing</span>
                prompt = <span class="hljs-string">f&quot;&quot;&quot;
                Analyze the repository &#x27;<span class="hljs-subst">{repo_name}</span>&#x27; and determine if the tag &#x27;<span class="hljs-subst">{tag}</span>&#x27; should be added.
                
                First, check the current tags using get_current_tags.
                If &#x27;<span class="hljs-subst">{tag}</span>&#x27; is not already present and it&#x27;s a valid tag, add it using add_new_tag.
                
                Repository: <span class="hljs-subst">{repo_name}</span>
                Tag to process: <span class="hljs-subst">{tag}</span>
                
                Provide a clear summary of what was done.
                &quot;&quot;&quot;</span>
                
                response = <span class="hljs-keyword">await</span> agent.run(prompt)
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🤖 Agent response for &#x27;<span class="hljs-subst">{tag}</span>&#x27;: <span class="hljs-subst">{response}</span>&quot;</span>)
                
                <span class="hljs-comment"># Parse response and store result</span>
                tag_result = {
                    <span class="hljs-string">&quot;tag&quot;</span>: tag,
                    <span class="hljs-string">&quot;response&quot;</span>: response,
                    <span class="hljs-string">&quot;timestamp&quot;</span>: datetime.now().isoformat()
                }
                operation[<span class="hljs-string">&quot;results&quot;</span>].append(tag_result)
                
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                error_msg = <span class="hljs-string">f&quot;❌ Error processing tag &#x27;<span class="hljs-subst">{tag}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
                <span class="hljs-built_in">print</span>(error_msg)
                operation[<span class="hljs-string">&quot;results&quot;</span>].append({
                    <span class="hljs-string">&quot;tag&quot;</span>: tag,
                    <span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-built_in">str</span>(e),
                    <span class="hljs-string">&quot;timestamp&quot;</span>: datetime.now().isoformat()
                })
        
        operation[<span class="hljs-string">&quot;status&quot;</span>] = <span class="hljs-string">&quot;completed&quot;</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ Completed processing <span class="hljs-subst">{<span class="hljs-built_in">len</span>(all_tags)}</span> tags&quot;</span>)`,wrap:!1}}),gt=new I({props:{title:"5. Health and Monitoring Endpoints",local:"5-health-and-monitoring-endpoints",headingTag:"h3"}}),ft=new h({props:{code:"JTQwYXBwLmdldCglMjIlMkYlMjIpJTBBYXN5bmMlMjBkZWYlMjByb290KCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJSb290JTIwZW5kcG9pbnQlMjB3aXRoJTIwYmFzaWMlMjBpbmZvcm1hdGlvbiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJIRiUyMFRhZ2dpbmclMjBCb3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGF0dXMlMjIlM0ElMjAlMjJydW5uaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJXZWJob29rJTIwbGlzdGVuZXIlMjBmb3IlMjBhdXRvbWF0aWMlMjBtb2RlbCUyMHRhZ2dpbmclMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmRwb2ludHMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ3ZWJob29rJTIyJTNBJTIwJTIyJTJGd2ViaG9vayUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlYWx0aCUyMiUzQSUyMCUyMiUyRmhlYWx0aCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm9wZXJhdGlvbnMlMjIlM0ElMjAlMjIlMkZvcGVyYXRpb25zJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdE",highlighted:`<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">root</span>():
    <span class="hljs-string">&quot;&quot;&quot;Root endpoint with basic information&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;HF Tagging Bot&quot;</span>,
        <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;running&quot;</span>,
        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Webhook listener for automatic model tagging&quot;</span>,
        <span class="hljs-string">&quot;endpoints&quot;</span>: {
            <span class="hljs-string">&quot;webhook&quot;</span>: <span class="hljs-string">&quot;/webhook&quot;</span>,
            <span class="hljs-string">&quot;health&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
            <span class="hljs-string">&quot;operations&quot;</span>: <span class="hljs-string">&quot;/operations&quot;</span>
        }
    }`,wrap:!1}}),kt=new h({props:{code:"JTQwYXBwLmdldCglMjIlMkZoZWFsdGglMjIpJTBBYXN5bmMlMjBkZWYlMjBoZWFsdGhfY2hlY2soKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkhlYWx0aCUyMGNoZWNrJTIwZW5kcG9pbnQlMjBmb3IlMjBtb25pdG9yaW5nJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBhd2FpdCUyMGdldF9hZ2VudCgpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhdHVzJTIyJTNBJTIwJTIyaGVhbHRoeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRpbWVzdGFtcCUyMiUzQSUyMGRhdGV0aW1lLm5vdygpLmlzb2Zvcm1hdCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29tcG9uZW50cyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMndlYmhvb2tfc2VjcmV0JTIyJTNBJTIwJTIyY29uZmlndXJlZCUyMiUyMGlmJTIwV0VCSE9PS19TRUNSRVQlMjBlbHNlJTIwJTIybWlzc2luZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhmX3Rva2VuJTIyJTNBJTIwJTIyY29uZmlndXJlZCUyMiUyMGlmJTIwSEZfVE9LRU4lMjBlbHNlJTIwJTIybWlzc2luZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1jcF9hZ2VudCUyMiUzQSUyMCUyMnJlYWR5JTIyJTIwaWYlMjBhZ2VudCUyMGVsc2UlMjAlMjJub3RfcmVhZHklMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0Q=",highlighted:`<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/health&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">health_check</span>():
    <span class="hljs-string">&quot;&quot;&quot;Health check endpoint for monitoring&quot;&quot;&quot;</span>
    agent = <span class="hljs-keyword">await</span> get_agent()
    
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;healthy&quot;</span>,
        <span class="hljs-string">&quot;timestamp&quot;</span>: datetime.now().isoformat(),
        <span class="hljs-string">&quot;components&quot;</span>: {
            <span class="hljs-string">&quot;webhook_secret&quot;</span>: <span class="hljs-string">&quot;configured&quot;</span> <span class="hljs-keyword">if</span> WEBHOOK_SECRET <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;missing&quot;</span>,
            <span class="hljs-string">&quot;hf_token&quot;</span>: <span class="hljs-string">&quot;configured&quot;</span> <span class="hljs-keyword">if</span> HF_TOKEN <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;missing&quot;</span>,
            <span class="hljs-string">&quot;mcp_agent&quot;</span>: <span class="hljs-string">&quot;ready&quot;</span> <span class="hljs-keyword">if</span> agent <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;not_ready&quot;</span>
        }
    }`,wrap:!1}}),vt=new h({props:{code:"JTQwYXBwLmdldCglMjIlMkZvcGVyYXRpb25zJTIyKSUwQWFzeW5jJTIwZGVmJTIwZ2V0X29wZXJhdGlvbnMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkdldCUyMHJlY2VudCUyMHRhZyUyMG9wZXJhdGlvbnMlMjBmb3IlMjBtb25pdG9yaW5nJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmV0dXJuJTIwbGFzdCUyMDUwJTIwb3BlcmF0aW9ucyUwQSUyMCUyMCUyMCUyMHJlY2VudF9vcHMlMjAlM0QlMjB0YWdfb3BlcmF0aW9uc19zdG9yZSU1Qi01MCUzQSU1RCUyMGlmJTIwdGFnX29wZXJhdGlvbnNfc3RvcmUlMjBlbHNlJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydG90YWxfb3BlcmF0aW9ucyUyMiUzQSUyMGxlbih0YWdfb3BlcmF0aW9uc19zdG9yZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZWNlbnRfb3BlcmF0aW9ucyUyMiUzQSUyMHJlY2VudF9vcHMlMEElMjAlMjAlMjAlMjAlN0Q=",highlighted:`<span class="hljs-meta">@app.get(<span class="hljs-params"><span class="hljs-string">&quot;/operations&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_operations</span>():
    <span class="hljs-string">&quot;&quot;&quot;Get recent tag operations for monitoring&quot;&quot;&quot;</span>
    <span class="hljs-comment"># Return last 50 operations</span>
    recent_ops = tag_operations_store[-<span class="hljs-number">50</span>:] <span class="hljs-keyword">if</span> tag_operations_store <span class="hljs-keyword">else</span> []
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;total_operations&quot;</span>: <span class="hljs-built_in">len</span>(tag_operations_store),
        <span class="hljs-string">&quot;recent_operations&quot;</span>: recent_ops
    }`,wrap:!1}}),B=new m({props:{$$slots:{default:[qn]},$$scope:{ctx:r}}}),Zt=new I({props:{title:"Webhook Configuration on Hugging Face Hub",local:"webhook-configuration-on-hugging-face-hub",headingTag:"h2"}}),Gt=new I({props:{title:"1. Create Webhook in Settings",local:"1-create-webhook-in-settings",headingTag:"h3"}}),k=new m({props:{$$slots:{default:[Zn]},$$scope:{ctx:r}}}),_t=new I({props:{title:"2. Space URL Configuration",local:"2-space-url-configuration",headingTag:"h3"}}),zt=new I({props:{title:"Testing the Webhook Listener",local:"testing-the-webhook-listener",headingTag:"h2"}}),Pt=new I({props:{title:"1. Local Testing",local:"1-local-testing",headingTag:"h3"}}),Kt=new h({props:{code:"JTIzJTIwdGVzdF93ZWJob29rX2xvY2FsLnB5JTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBqc29uJTBBJTBBJTIzJTIwVGVzdCUyMGRhdGElMjBtYXRjaGluZyUyMHdlYmhvb2slMjBmb3JtYXQlMEF0ZXN0X3dlYmhvb2tfZGF0YSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmV2ZW50JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWN0aW9uJTIyJTNBJTIwJTIyY3JlYXRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2NvcGUlMjIlM0ElMjAlMjJkaXNjdXNzaW9uLmNvbW1lbnQlMjIlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJjb21tZW50JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMlRoaXMlMjBtb2RlbCUyMG5lZWRzJTIwdGFncyUzQSUyMHB5dG9yY2glMkMlMjB0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdXRob3IlMjIlM0ElMjAlN0IlMjJpZCUyMiUzQSUyMCUyMnRlc3QtdXNlciUyMiU3RCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmRpc2N1c3Npb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0aXRsZSUyMiUzQSUyMCUyMk1pc3NpbmclMjB0YWdzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybnVtJTIyJTNBJTIwMSUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlcG8lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIydGVzdC11c2VyJTJGdGVzdC1tb2RlbCUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSU3RCUwQSUwQSUyMyUyMFNlbmQlMjB0ZXN0JTIwd2ViaG9vayUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMucG9zdCglMEElMjAlMjAlMjAlMjAlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBODAwMCUyRndlYmhvb2slMjIlMkMlMEElMjAlMjAlMjAlMjBqc29uJTNEdGVzdF93ZWJob29rX2RhdGElMkMlMEElMjAlMjAlMjAlMjBoZWFkZXJzJTNEJTdCJTIyWC1XZWJob29rLVNlY3JldCUyMiUzQSUyMCUyMnlvdXItdGVzdC1zZWNyZXQlMjIlN0QlMEEpJTBBJTBBcHJpbnQoZiUyMlN0YXR1cyUzQSUyMCU3QnJlc3BvbnNlLnN0YXR1c19jb2RlJTdEJTIyKSUwQXByaW50KGYlMjJSZXNwb25zZSUzQSUyMCU3QnJlc3BvbnNlLmpzb24oKSU3RCUyMik=",highlighted:`<span class="hljs-comment"># test_webhook_local.py</span>
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> json

<span class="hljs-comment"># Test data matching webhook format</span>
test_webhook_data = {
    <span class="hljs-string">&quot;event&quot;</span>: {
        <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;create&quot;</span>,
        <span class="hljs-string">&quot;scope&quot;</span>: <span class="hljs-string">&quot;discussion.comment&quot;</span>
    },
    <span class="hljs-string">&quot;comment&quot;</span>: {
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;This model needs tags: pytorch, transformers&quot;</span>,
        <span class="hljs-string">&quot;author&quot;</span>: {<span class="hljs-string">&quot;id&quot;</span>: <span class="hljs-string">&quot;test-user&quot;</span>}
    },
    <span class="hljs-string">&quot;discussion&quot;</span>: {
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Missing tags&quot;</span>,
        <span class="hljs-string">&quot;num&quot;</span>: <span class="hljs-number">1</span>
    },
    <span class="hljs-string">&quot;repo&quot;</span>: {
        <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;test-user/test-model&quot;</span>
    }
}

<span class="hljs-comment"># Send test webhook</span>
response = requests.post(
    <span class="hljs-string">&quot;http://localhost:8000/webhook&quot;</span>,
    json=test_webhook_data,
    headers={<span class="hljs-string">&quot;X-Webhook-Secret&quot;</span>: <span class="hljs-string">&quot;your-test-secret&quot;</span>}
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Status: <span class="hljs-subst">{response.status_code}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Response: <span class="hljs-subst">{response.json()}</span>&quot;</span>)`,wrap:!1}}),Dt=new I({props:{title:"2. Simulation Endpoint for Development",local:"2-simulation-endpoint-for-development",headingTag:"h3"}}),ss=new h({props:{code:"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",highlighted:`<span class="hljs-meta">@app.post(<span class="hljs-params"><span class="hljs-string">&quot;/simulate_webhook&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">simulate_webhook</span>(<span class="hljs-params">
    repo_name: <span class="hljs-built_in">str</span>, 
    discussion_title: <span class="hljs-built_in">str</span>, 
    comment_content: <span class="hljs-built_in">str</span>
</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Simulate webhook for testing purposes&quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Create mock webhook data</span>
    mock_webhook_data = {
        <span class="hljs-string">&quot;event&quot;</span>: {
            <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;create&quot;</span>,
            <span class="hljs-string">&quot;scope&quot;</span>: <span class="hljs-string">&quot;discussion.comment&quot;</span>
        },
        <span class="hljs-string">&quot;comment&quot;</span>: {
            <span class="hljs-string">&quot;content&quot;</span>: comment_content,
            <span class="hljs-string">&quot;author&quot;</span>: {<span class="hljs-string">&quot;id&quot;</span>: <span class="hljs-string">&quot;test-user&quot;</span>}
        },
        <span class="hljs-string">&quot;discussion&quot;</span>: {
            <span class="hljs-string">&quot;title&quot;</span>: discussion_title,
            <span class="hljs-string">&quot;num&quot;</span>: <span class="hljs-number">999</span>
        },
        <span class="hljs-string">&quot;repo&quot;</span>: {
            <span class="hljs-string">&quot;name&quot;</span>: repo_name
        }
    }
    
    <span class="hljs-comment"># Process the simulated webhook</span>
    <span class="hljs-keyword">await</span> process_webhook_comment(mock_webhook_data)
    
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Simulated webhook processed for <span class="hljs-subst">{repo_name}</span>&quot;</span>`,wrap:!1}}),$=new m({props:{$$slots:{default:[Qn]},$$scope:{ctx:r}}}),es=new I({props:{title:"Expected Webhook Result",local:"expected-webhook-result",headingTag:"h2"}}),os=new I({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),v=new m({props:{$$slots:{default:[Gn]},$$scope:{ctx:r}}}),js=new An({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit3_1/webhook-listener.mdx"}}),{c(){a=o("meta"),u=n(),y=o("p"),C=n(),j(q.$$.fragment),ws=n(),Z=o("p"),Z.textContent=ne,Ts=n(),j(Q.$$.fragment),cs=n(),G=o("p"),G.innerHTML=Me,us=n(),W=o("p"),W.innerHTML=ae,rs=n(),j(E.$$.fragment),Cs=n(),N=o("p"),N.textContent=oe,Is=n(),R=o("ol"),R.innerHTML=ie,hs=n(),j(d.$$.fragment),ms=n(),j(_.$$.fragment),ds=n(),S=o("p"),S.textContent=pe,bs=n(),j(V.$$.fragment),gs=n(),x=o("p"),x.textContent=ye,As=n(),j(Y.$$.fragment),fs=n(),X=o("p"),X.innerHTML=je,Bs=n(),H=o("p"),H.textContent=Ue,ks=n(),j(z.$$.fragment),$s=n(),F=o("p"),F.textContent=Je,vs=n(),P=o("ul"),P.innerHTML=we,qs=n(),j(b.$$.fragment),Zs=n(),j(L.$$.fragment),Qs=n(),K=o("p"),K.innerHTML=Te,Gs=n(),j(O.$$.fragment),Ws=n(),D=o("p"),D.textContent=ce,Es=n(),tt=o("p"),tt.textContent=ue,Ns=n(),st=o("ul"),st.innerHTML=re,Rs=n(),j(lt.$$.fragment),_s=n(),et=o("p"),et.textContent=Ce,Ss=n(),j(nt.$$.fragment),Vs=n(),Mt=o("p"),Mt.innerHTML=Ie,xs=n(),j(g.$$.fragment),Ys=n(),at=o("p"),at.textContent=he,Xs=n(),j(ot.$$.fragment),Hs=n(),it=o("p"),it.textContent=me,zs=n(),pt=o("p"),pt.textContent=de,Fs=n(),j(yt.$$.fragment),Ps=n(),jt=o("p"),jt.textContent=be,Ls=n(),Ut=o("p"),Ut.innerHTML=ge,Ks=n(),j(A.$$.fragment),Os=n(),j(Jt.$$.fragment),Ds=n(),wt=o("p"),wt.textContent=Ae,tl=n(),j(Tt.$$.fragment),sl=n(),ct=o("p"),ct.textContent=fe,ll=n(),ut=o("p"),ut.textContent=Be,el=n(),j(rt.$$.fragment),nl=n(),Ct=o("p"),Ct.textContent=ke,Ml=n(),j(f.$$.fragment),al=n(),It=o("p"),It.textContent=$e,ol=n(),j(ht.$$.fragment),il=n(),mt=o("p"),mt.textContent=ve,pl=n(),dt=o("ol"),dt.innerHTML=qe,yl=n(),bt=o("p"),bt.textContent=Ze,jl=n(),j(gt.$$.fragment),Ul=n(),At=o("p"),At.textContent=Qe,Jl=n(),j(ft.$$.fragment),wl=n(),Bt=o("p"),Bt.textContent=Ge,Tl=n(),j(kt.$$.fragment),cl=n(),$t=o("p"),$t.textContent=We,ul=n(),j(vt.$$.fragment),rl=n(),qt=o("p"),qt.textContent=Ee,Cl=n(),j(B.$$.fragment),Il=n(),j(Zt.$$.fragment),hl=n(),Qt=o("p"),Qt.textContent=Ne,ml=n(),j(Gt.$$.fragment),dl=n(),Wt=o("p"),Wt.innerHTML=Re,bl=n(),Et=o("p"),Et.innerHTML=_e,gl=n(),Nt=o("p"),Nt.innerHTML=Se,Al=n(),Rt=o("ol"),Rt.innerHTML=Ve,fl=n(),j(k.$$.fragment),Bl=n(),j(_t.$$.fragment),kl=n(),St=o("p"),St.textContent=xe,$l=n(),Vt=o("p"),Vt.innerHTML=Ye,vl=n(),xt=o("p"),xt.textContent=Xe,ql=n(),Yt=o("ol"),Yt.innerHTML=He,Zl=n(),Xt=o("p"),Xt.innerHTML=ze,Ql=n(),Ht=o("p"),Ht.innerHTML=Fe,Gl=n(),j(zt.$$.fragment),Wl=n(),Ft=o("p"),Ft.textContent=Pe,El=n(),j(Pt.$$.fragment),Nl=n(),Lt=o("p"),Lt.textContent=Le,Rl=n(),j(Kt.$$.fragment),_l=n(),Ot=o("p"),Ot.textContent=Ke,Sl=n(),j(Dt.$$.fragment),Vl=n(),ts=o("p"),ts.textContent=Oe,xl=n(),j(ss.$$.fragment),Yl=n(),ls=o("p"),ls.textContent=De,Xl=n(),j($.$$.fragment),Hl=n(),j(es.$$.fragment),zl=n(),ns=o("p"),ns.textContent=tn,Fl=n(),Ms=o("p"),Ms.innerHTML=sn,Pl=n(),as=o("p"),as.textContent=ln,Ll=n(),j(os.$$.fragment),Kl=n(),is=o("p"),is.textContent=en,Ol=n(),ps=o("ol"),ps.innerHTML=nn,Dl=n(),ys=o("p"),ys.textContent=Mn,te=n(),j(v.$$.fragment),se=n(),j(js.$$.fragment),le=n(),Js=o("p"),this.h()},l(t){const s=bn("svelte-u9bgzb",document.head);a=i(s,"META",{name:!0,content:!0}),s.forEach(l),u=M(t),y=i(t,"P",{}),cn(y).forEach(l),C=M(t),U(q.$$.fragment,t),ws=M(t),Z=i(t,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1eub5er"&&(Z.textContent=ne),Ts=M(t),U(Q.$$.fragment,t),cs=M(t),G=i(t,"P",{"data-svelte-h":!0}),p(G)!=="svelte-zs6gis"&&(G.innerHTML=Me),us=M(t),W=i(t,"P",{"data-svelte-h":!0}),p(W)!=="svelte-2dzniq"&&(W.innerHTML=ae),rs=M(t),U(E.$$.fragment,t),Cs=M(t),N=i(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1uwf7f3"&&(N.textContent=oe),Is=M(t),R=i(t,"OL",{"data-svelte-h":!0}),p(R)!=="svelte-1la2ai8"&&(R.innerHTML=ie),hs=M(t),U(d.$$.fragment,t),ms=M(t),U(_.$$.fragment,t),ds=M(t),S=i(t,"P",{"data-svelte-h":!0}),p(S)!=="svelte-30xlox"&&(S.textContent=pe),bs=M(t),U(V.$$.fragment,t),gs=M(t),x=i(t,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1yn5m8w"&&(x.textContent=ye),As=M(t),U(Y.$$.fragment,t),fs=M(t),X=i(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-zzzhss"&&(X.innerHTML=je),Bs=M(t),H=i(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-jud5zz"&&(H.textContent=Ue),ks=M(t),U(z.$$.fragment,t),$s=M(t),F=i(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-10dhypi"&&(F.textContent=Je),vs=M(t),P=i(t,"UL",{"data-svelte-h":!0}),p(P)!=="svelte-1m8npcg"&&(P.innerHTML=we),qs=M(t),U(b.$$.fragment,t),Zs=M(t),U(L.$$.fragment,t),Qs=M(t),K=i(t,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1gq8l98"&&(K.innerHTML=Te),Gs=M(t),U(O.$$.fragment,t),Ws=M(t),D=i(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-11rd4l8"&&(D.textContent=ce),Es=M(t),tt=i(t,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-7jxndb"&&(tt.textContent=ue),Ns=M(t),st=i(t,"UL",{"data-svelte-h":!0}),p(st)!=="svelte-yb9adx"&&(st.innerHTML=re),Rs=M(t),U(lt.$$.fragment,t),_s=M(t),et=i(t,"P",{"data-svelte-h":!0}),p(et)!=="svelte-8wi0lp"&&(et.textContent=Ce),Ss=M(t),U(nt.$$.fragment,t),Vs=M(t),Mt=i(t,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-gioszz"&&(Mt.innerHTML=Ie),xs=M(t),U(g.$$.fragment,t),Ys=M(t),at=i(t,"P",{"data-svelte-h":!0}),p(at)!=="svelte-1cgryry"&&(at.textContent=he),Xs=M(t),U(ot.$$.fragment,t),Hs=M(t),it=i(t,"P",{"data-svelte-h":!0}),p(it)!=="svelte-fw492h"&&(it.textContent=me),zs=M(t),pt=i(t,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-1886e9a"&&(pt.textContent=de),Fs=M(t),U(yt.$$.fragment,t),Ps=M(t),jt=i(t,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-1f6564z"&&(jt.textContent=be),Ls=M(t),Ut=i(t,"P",{"data-svelte-h":!0}),p(Ut)!=="svelte-hn7yve"&&(Ut.innerHTML=ge),Ks=M(t),U(A.$$.fragment,t),Os=M(t),U(Jt.$$.fragment,t),Ds=M(t),wt=i(t,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-1noq05c"&&(wt.textContent=Ae),tl=M(t),U(Tt.$$.fragment,t),sl=M(t),ct=i(t,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-olpz7c"&&(ct.textContent=fe),ll=M(t),ut=i(t,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-th5ate"&&(ut.textContent=Be),el=M(t),U(rt.$$.fragment,t),nl=M(t),Ct=i(t,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-6ke5ju"&&(Ct.textContent=ke),Ml=M(t),U(f.$$.fragment,t),al=M(t),It=i(t,"P",{"data-svelte-h":!0}),p(It)!=="svelte-7cat8p"&&(It.textContent=$e),ol=M(t),U(ht.$$.fragment,t),il=M(t),mt=i(t,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-evqnic"&&(mt.textContent=ve),pl=M(t),dt=i(t,"OL",{"data-svelte-h":!0}),p(dt)!=="svelte-18uz71w"&&(dt.innerHTML=qe),yl=M(t),bt=i(t,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-j0txlt"&&(bt.textContent=Ze),jl=M(t),U(gt.$$.fragment,t),Ul=M(t),At=i(t,"P",{"data-svelte-h":!0}),p(At)!=="svelte-1lqb59s"&&(At.textContent=Qe),Jl=M(t),U(ft.$$.fragment,t),wl=M(t),Bt=i(t,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-a05cab"&&(Bt.textContent=Ge),Tl=M(t),U(kt.$$.fragment,t),cl=M(t),$t=i(t,"P",{"data-svelte-h":!0}),p($t)!=="svelte-byt3a9"&&($t.textContent=We),ul=M(t),U(vt.$$.fragment,t),rl=M(t),qt=i(t,"P",{"data-svelte-h":!0}),p(qt)!=="svelte-naqt2m"&&(qt.textContent=Ee),Cl=M(t),U(B.$$.fragment,t),Il=M(t),U(Zt.$$.fragment,t),hl=M(t),Qt=i(t,"P",{"data-svelte-h":!0}),p(Qt)!=="svelte-1g1oryt"&&(Qt.textContent=Ne),ml=M(t),U(Gt.$$.fragment,t),dl=M(t),Wt=i(t,"P",{"data-svelte-h":!0}),p(Wt)!=="svelte-5kl7kx"&&(Wt.innerHTML=Re),bl=M(t),Et=i(t,"P",{"data-svelte-h":!0}),p(Et)!=="svelte-1d7h7y6"&&(Et.innerHTML=_e),gl=M(t),Nt=i(t,"P",{"data-svelte-h":!0}),p(Nt)!=="svelte-1na9glc"&&(Nt.innerHTML=Se),Al=M(t),Rt=i(t,"OL",{"data-svelte-h":!0}),p(Rt)!=="svelte-bjboxn"&&(Rt.innerHTML=Ve),fl=M(t),U(k.$$.fragment,t),Bl=M(t),U(_t.$$.fragment,t),kl=M(t),St=i(t,"P",{"data-svelte-h":!0}),p(St)!=="svelte-1hzpj89"&&(St.textContent=xe),$l=M(t),Vt=i(t,"P",{"data-svelte-h":!0}),p(Vt)!=="svelte-sqnb9c"&&(Vt.innerHTML=Ye),vl=M(t),xt=i(t,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-17xbyqk"&&(xt.textContent=Xe),ql=M(t),Yt=i(t,"OL",{"data-svelte-h":!0}),p(Yt)!=="svelte-1nylw4h"&&(Yt.innerHTML=He),Zl=M(t),Xt=i(t,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-2jg831"&&(Xt.innerHTML=ze),Ql=M(t),Ht=i(t,"P",{"data-svelte-h":!0}),p(Ht)!=="svelte-1kndn4n"&&(Ht.innerHTML=Fe),Gl=M(t),U(zt.$$.fragment,t),Wl=M(t),Ft=i(t,"P",{"data-svelte-h":!0}),p(Ft)!=="svelte-30xatb"&&(Ft.textContent=Pe),El=M(t),U(Pt.$$.fragment,t),Nl=M(t),Lt=i(t,"P",{"data-svelte-h":!0}),p(Lt)!=="svelte-7r07br"&&(Lt.textContent=Le),Rl=M(t),U(Kt.$$.fragment,t),_l=M(t),Ot=i(t,"P",{"data-svelte-h":!0}),p(Ot)!=="svelte-1f6yjhi"&&(Ot.textContent=Ke),Sl=M(t),U(Dt.$$.fragment,t),Vl=M(t),ts=i(t,"P",{"data-svelte-h":!0}),p(ts)!=="svelte-z9njw6"&&(ts.textContent=Oe),xl=M(t),U(ss.$$.fragment,t),Yl=M(t),ls=i(t,"P",{"data-svelte-h":!0}),p(ls)!=="svelte-1h392h7"&&(ls.textContent=De),Xl=M(t),U($.$$.fragment,t),Hl=M(t),U(es.$$.fragment,t),zl=M(t),ns=i(t,"P",{"data-svelte-h":!0}),p(ns)!=="svelte-141mla5"&&(ns.textContent=tn),Fl=M(t),Ms=i(t,"P",{"data-svelte-h":!0}),p(Ms)!=="svelte-18qs3uu"&&(Ms.innerHTML=sn),Pl=M(t),as=i(t,"P",{"data-svelte-h":!0}),p(as)!=="svelte-sir06v"&&(as.textContent=ln),Ll=M(t),U(os.$$.fragment,t),Kl=M(t),is=i(t,"P",{"data-svelte-h":!0}),p(is)!=="svelte-jm8el5"&&(is.textContent=en),Ol=M(t),ps=i(t,"OL",{"data-svelte-h":!0}),p(ps)!=="svelte-oytvxt"&&(ps.innerHTML=nn),Dl=M(t),ys=i(t,"P",{"data-svelte-h":!0}),p(ys)!=="svelte-1y29lx8"&&(ys.textContent=Mn),te=M(t),U(v.$$.fragment,t),se=M(t),U(js.$$.fragment,t),le=M(t),Js=i(t,"P",{}),cn(Js).forEach(l),this.h()},h(){un(a,"name","hf:doc:metadata"),un(a,"content",En)},m(t,s){gn(document.head,a),e(t,u,s),e(t,y,s),e(t,C,s),J(q,t,s),e(t,ws,s),e(t,Z,s),e(t,Ts,s),J(Q,t,s),e(t,cs,s),e(t,G,s),e(t,us,s),e(t,W,s),e(t,rs,s),J(E,t,s),e(t,Cs,s),e(t,N,s),e(t,Is,s),e(t,R,s),e(t,hs,s),J(d,t,s),e(t,ms,s),J(_,t,s),e(t,ds,s),e(t,S,s),e(t,bs,s),J(V,t,s),e(t,gs,s),e(t,x,s),e(t,As,s),J(Y,t,s),e(t,fs,s),e(t,X,s),e(t,Bs,s),e(t,H,s),e(t,ks,s),J(z,t,s),e(t,$s,s),e(t,F,s),e(t,vs,s),e(t,P,s),e(t,qs,s),J(b,t,s),e(t,Zs,s),J(L,t,s),e(t,Qs,s),e(t,K,s),e(t,Gs,s),J(O,t,s),e(t,Ws,s),e(t,D,s),e(t,Es,s),e(t,tt,s),e(t,Ns,s),e(t,st,s),e(t,Rs,s),J(lt,t,s),e(t,_s,s),e(t,et,s),e(t,Ss,s),J(nt,t,s),e(t,Vs,s),e(t,Mt,s),e(t,xs,s),J(g,t,s),e(t,Ys,s),e(t,at,s),e(t,Xs,s),J(ot,t,s),e(t,Hs,s),e(t,it,s),e(t,zs,s),e(t,pt,s),e(t,Fs,s),J(yt,t,s),e(t,Ps,s),e(t,jt,s),e(t,Ls,s),e(t,Ut,s),e(t,Ks,s),J(A,t,s),e(t,Os,s),J(Jt,t,s),e(t,Ds,s),e(t,wt,s),e(t,tl,s),J(Tt,t,s),e(t,sl,s),e(t,ct,s),e(t,ll,s),e(t,ut,s),e(t,el,s),J(rt,t,s),e(t,nl,s),e(t,Ct,s),e(t,Ml,s),J(f,t,s),e(t,al,s),e(t,It,s),e(t,ol,s),J(ht,t,s),e(t,il,s),e(t,mt,s),e(t,pl,s),e(t,dt,s),e(t,yl,s),e(t,bt,s),e(t,jl,s),J(gt,t,s),e(t,Ul,s),e(t,At,s),e(t,Jl,s),J(ft,t,s),e(t,wl,s),e(t,Bt,s),e(t,Tl,s),J(kt,t,s),e(t,cl,s),e(t,$t,s),e(t,ul,s),J(vt,t,s),e(t,rl,s),e(t,qt,s),e(t,Cl,s),J(B,t,s),e(t,Il,s),J(Zt,t,s),e(t,hl,s),e(t,Qt,s),e(t,ml,s),J(Gt,t,s),e(t,dl,s),e(t,Wt,s),e(t,bl,s),e(t,Et,s),e(t,gl,s),e(t,Nt,s),e(t,Al,s),e(t,Rt,s),e(t,fl,s),J(k,t,s),e(t,Bl,s),J(_t,t,s),e(t,kl,s),e(t,St,s),e(t,$l,s),e(t,Vt,s),e(t,vl,s),e(t,xt,s),e(t,ql,s),e(t,Yt,s),e(t,Zl,s),e(t,Xt,s),e(t,Ql,s),e(t,Ht,s),e(t,Gl,s),J(zt,t,s),e(t,Wl,s),e(t,Ft,s),e(t,El,s),J(Pt,t,s),e(t,Nl,s),e(t,Lt,s),e(t,Rl,s),J(Kt,t,s),e(t,_l,s),e(t,Ot,s),e(t,Sl,s),J(Dt,t,s),e(t,Vl,s),e(t,ts,s),e(t,xl,s),J(ss,t,s),e(t,Yl,s),e(t,ls,s),e(t,Xl,s),J($,t,s),e(t,Hl,s),J(es,t,s),e(t,zl,s),e(t,ns,s),e(t,Fl,s),e(t,Ms,s),e(t,Pl,s),e(t,as,s),e(t,Ll,s),J(os,t,s),e(t,Kl,s),e(t,is,s),e(t,Ol,s),e(t,ps,s),e(t,Dl,s),e(t,ys,s),e(t,te,s),J(v,t,s),e(t,se,s),J(js,t,s),e(t,le,s),e(t,Js,s),ee=!0},p(t,[s]){const an={};s&2&&(an.$$scope={dirty:s,ctx:t}),d.$set(an);const on={};s&2&&(on.$$scope={dirty:s,ctx:t}),b.$set(on);const pn={};s&2&&(pn.$$scope={dirty:s,ctx:t}),g.$set(pn);const yn={};s&2&&(yn.$$scope={dirty:s,ctx:t}),A.$set(yn);const jn={};s&2&&(jn.$$scope={dirty:s,ctx:t}),f.$set(jn);const Un={};s&2&&(Un.$$scope={dirty:s,ctx:t}),B.$set(Un);const Jn={};s&2&&(Jn.$$scope={dirty:s,ctx:t}),k.$set(Jn);const wn={};s&2&&(wn.$$scope={dirty:s,ctx:t}),$.$set(wn);const Tn={};s&2&&(Tn.$$scope={dirty:s,ctx:t}),v.$set(Tn)},i(t){ee||(w(q.$$.fragment,t),w(Q.$$.fragment,t),w(E.$$.fragment,t),w(d.$$.fragment,t),w(_.$$.fragment,t),w(V.$$.fragment,t),w(Y.$$.fragment,t),w(z.$$.fragment,t),w(b.$$.fragment,t),w(L.$$.fragment,t),w(O.$$.fragment,t),w(lt.$$.fragment,t),w(nt.$$.fragment,t),w(g.$$.fragment,t),w(ot.$$.fragment,t),w(yt.$$.fragment,t),w(A.$$.fragment,t),w(Jt.$$.fragment,t),w(Tt.$$.fragment,t),w(rt.$$.fragment,t),w(f.$$.fragment,t),w(ht.$$.fragment,t),w(gt.$$.fragment,t),w(ft.$$.fragment,t),w(kt.$$.fragment,t),w(vt.$$.fragment,t),w(B.$$.fragment,t),w(Zt.$$.fragment,t),w(Gt.$$.fragment,t),w(k.$$.fragment,t),w(_t.$$.fragment,t),w(zt.$$.fragment,t),w(Pt.$$.fragment,t),w(Kt.$$.fragment,t),w(Dt.$$.fragment,t),w(ss.$$.fragment,t),w($.$$.fragment,t),w(es.$$.fragment,t),w(os.$$.fragment,t),w(v.$$.fragment,t),w(js.$$.fragment,t),ee=!0)},o(t){T(q.$$.fragment,t),T(Q.$$.fragment,t),T(E.$$.fragment,t),T(d.$$.fragment,t),T(_.$$.fragment,t),T(V.$$.fragment,t),T(Y.$$.fragment,t),T(z.$$.fragment,t),T(b.$$.fragment,t),T(L.$$.fragment,t),T(O.$$.fragment,t),T(lt.$$.fragment,t),T(nt.$$.fragment,t),T(g.$$.fragment,t),T(ot.$$.fragment,t),T(yt.$$.fragment,t),T(A.$$.fragment,t),T(Jt.$$.fragment,t),T(Tt.$$.fragment,t),T(rt.$$.fragment,t),T(f.$$.fragment,t),T(ht.$$.fragment,t),T(gt.$$.fragment,t),T(ft.$$.fragment,t),T(kt.$$.fragment,t),T(vt.$$.fragment,t),T(B.$$.fragment,t),T(Zt.$$.fragment,t),T(Gt.$$.fragment,t),T(k.$$.fragment,t),T(_t.$$.fragment,t),T(zt.$$.fragment,t),T(Pt.$$.fragment,t),T(Kt.$$.fragment,t),T(Dt.$$.fragment,t),T(ss.$$.fragment,t),T($.$$.fragment,t),T(es.$$.fragment,t),T(os.$$.fragment,t),T(v.$$.fragment,t),T(js.$$.fragment,t),ee=!1},d(t){t&&(l(u),l(y),l(C),l(ws),l(Z),l(Ts),l(cs),l(G),l(us),l(W),l(rs),l(Cs),l(N),l(Is),l(R),l(hs),l(ms),l(ds),l(S),l(bs),l(gs),l(x),l(As),l(fs),l(X),l(Bs),l(H),l(ks),l($s),l(F),l(vs),l(P),l(qs),l(Zs),l(Qs),l(K),l(Gs),l(Ws),l(D),l(Es),l(tt),l(Ns),l(st),l(Rs),l(_s),l(et),l(Ss),l(Vs),l(Mt),l(xs),l(Ys),l(at),l(Xs),l(Hs),l(it),l(zs),l(pt),l(Fs),l(Ps),l(jt),l(Ls),l(Ut),l(Ks),l(Os),l(Ds),l(wt),l(tl),l(sl),l(ct),l(ll),l(ut),l(el),l(nl),l(Ct),l(Ml),l(al),l(It),l(ol),l(il),l(mt),l(pl),l(dt),l(yl),l(bt),l(jl),l(Ul),l(At),l(Jl),l(wl),l(Bt),l(Tl),l(cl),l($t),l(ul),l(rl),l(qt),l(Cl),l(Il),l(hl),l(Qt),l(ml),l(dl),l(Wt),l(bl),l(Et),l(gl),l(Nt),l(Al),l(Rt),l(fl),l(Bl),l(kl),l(St),l($l),l(Vt),l(vl),l(xt),l(ql),l(Yt),l(Zl),l(Xt),l(Ql),l(Ht),l(Gl),l(Wl),l(Ft),l(El),l(Nl),l(Lt),l(Rl),l(_l),l(Ot),l(Sl),l(Vl),l(ts),l(xl),l(Yl),l(ls),l(Xl),l(Hl),l(zl),l(ns),l(Fl),l(Ms),l(Pl),l(as),l(Ll),l(Kl),l(is),l(Ol),l(ps),l(Dl),l(ys),l(te),l(se),l(le),l(Js)),l(a),c(q,t),c(Q,t),c(E,t),c(d,t),c(_,t),c(V,t),c(Y,t),c(z,t),c(b,t),c(L,t),c(O,t),c(lt,t),c(nt,t),c(g,t),c(ot,t),c(yt,t),c(A,t),c(Jt,t),c(Tt,t),c(rt,t),c(f,t),c(ht,t),c(gt,t),c(ft,t),c(kt,t),c(vt,t),c(B,t),c(Zt,t),c(Gt,t),c(k,t),c(_t,t),c(zt,t),c(Pt,t),c(Kt,t),c(Dt,t),c(ss,t),c($,t),c(es,t),c(os,t),c(v,t),c(js,t)}}}const En='{"title":"Webhook Listener","local":"webhook-listener","sections":[{"title":"Understanding Webhook Integration","local":"understanding-webhook-integration","sections":[{"title":"Webhook Event Flow","local":"webhook-event-flow","sections":[],"depth":3}],"depth":2},{"title":"FastAPI Webhook Application","local":"fastapi-webhook-application","sections":[{"title":"1. Application Setup","local":"1-application-setup","sections":[],"depth":3},{"title":"2. Webhook Data Models","local":"2-webhook-data-models","sections":[],"depth":3},{"title":"3. Core Webhook Handler","local":"3-core-webhook-handler","sections":[],"depth":3},{"title":"4. Comment Processing Logic","local":"4-comment-processing-logic","sections":[],"depth":3},{"title":"5. Health and Monitoring Endpoints","local":"5-health-and-monitoring-endpoints","sections":[],"depth":3}],"depth":2},{"title":"Webhook Configuration on Hugging Face Hub","local":"webhook-configuration-on-hugging-face-hub","sections":[{"title":"1. Create Webhook in Settings","local":"1-create-webhook-in-settings","sections":[],"depth":3},{"title":"2. Space URL Configuration","local":"2-space-url-configuration","sections":[],"depth":3}],"depth":2},{"title":"Testing the Webhook Listener","local":"testing-the-webhook-listener","sections":[{"title":"1. Local Testing","local":"1-local-testing","sections":[],"depth":3},{"title":"2. Simulation Endpoint for Development","local":"2-simulation-endpoint-for-development","sections":[],"depth":3}],"depth":2},{"title":"Expected Webhook Result","local":"expected-webhook-result","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Nn(r){return hn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yn extends mn{constructor(a){super(),dn(this,a,Nn,Wn,In,{})}}export{Yn as component};
