import{s as Ve,o as Qe,n as Se}from"../chunks/scheduler.7da89386.js";import{S as We,i as ze,g as i,s as a,r as y,A as xe,h as M,f as l,c as n,j as $e,u as m,x as p,k as Ne,y as Xe,a as s,v as u,d as r,t as d,w as T}from"../chunks/index.0b7befd3.js";import{T as Re}from"../chunks/Tip.1e71740f.js";import{C as X}from"../chunks/CodeBlock.ce33a881.js";import{H as Ee,E as Ye}from"../chunks/EditOnGithub.0cb2bc8e.js";function He(Y){let o,w='You can find examples of custom tasks in the <a href="https://github.com/huggingface/lighteval/tree/main/community_tasks">community_task</a> directory.';return{c(){o=i("p"),o.innerHTML=w},l(c){o=M(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1t4f4pd"&&(o.innerHTML=w)},m(c,U){s(c,o,U)},p:Se,d(c){c&&l(o)}}}function Fe(Y){let o,w=`To contribute your custom metric to the lighteval repo, you would first need
to install the required dev dependencies by running <code>pip install -e .[dev]</code>
and then run <code>pre-commit install</code> to install the pre-commit hooks.`;return{c(){o=i("p"),o.innerHTML=w},l(c){o=M(c,"P",{"data-svelte-h":!0}),p(o)!=="svelte-l65q4m"&&(o.innerHTML=w)},m(c,U){s(c,o,U)},p:Se,d(c){c&&l(o)}}}function qe(Y){let o,w,c,U,j,F,f,Je=`To add a new task, first either open an issue, to determine whether it will be
integrated in the core evaluations of lighteval, in the extended tasks, or the
community tasks, and add its dataset on the hub.`,q,I,he=`<li>Core evaluations are evaluations that only require standard logic in their
metrics and processing, and that we will add to our test suite to ensure non
regression through time. They already see high usage in the community.</li> <li>Extended evaluations are evaluations that require custom logic in their
metrics (complex normalisation, an LLM as a judge, …), that we added to
facilitate the life of users. They already see high usage in the community.</li> <li>Community evaluations are submissions by the community of new tasks.</li>`,L,C,je="A popular community evaluation can move to become an extended or core evaluation over time.",D,J,P,b,K,h,O,_,fe="First, create a python file under the <code>community_tasks</code> directory.",ee,B,Ie=`You need to define a prompt function that will convert a line from your
dataset to a document to be used for evaluation.`,te,k,le,g,Ce=`Then, you need to choose a metric: you can either use an existing one (defined
in <code>lighteval.metrics.metrics.Metrics</code>) or <a href="adding-a-new-metric">create a custom one</a>).`,se,v,ae,G,be=`Then, you need to define your task using <a href="/docs/lighteval/pr_419/en/package_reference/tasks#lighteval.tasks.lighteval_task.LightevalTaskConfig">LightevalTaskConfig</a>.
You can define a task with or without subsets.
To define a task with no subsets:`,ne,A,oe,Z,_e=`If you want to create a task with multiple subset, add them to the
<code>SAMPLE_SUBSETS</code> list and create a task for each subset.`,ie,$,Me,N,Be="Here is a list of the parameters and their meaning:",ce,R,ke=`<li><code>name</code> (str), your evaluation name</li> <li><code>suite</code> (list), the suite(s) to which your evaluation should belong. This
field allows us to compare different task implementations and is used as a
task selection to differentiate the versions to launch. At the moment, you’ll
find the keywords [“helm”, “bigbench”, “original”, “lighteval”, “community”,
“custom”]; for core evals, please choose <code>lighteval</code>.</li> <li><code>prompt_function</code> (Callable), the prompt function you defined in the step
above</li> <li><code>hf_repo</code> (str), the path to your evaluation dataset on the hub</li> <li><code>hf_subset</code> (str), the specific subset you want to use for your evaluation
(note: when the dataset has no subset, fill this field with <code>&quot;default&quot;</code>, not
with <code>None</code> or <code>&quot;&quot;</code>)</li> <li><code>hf_avail_splits</code> (list), all the splits available for your dataset (train,
valid or validation, test, other…)</li> <li><code>evaluation_splits</code> (list), the splits you want to use for evaluation</li> <li><code>few_shots_split</code> (str, can be <code>null</code>), the specific split from which you
want to select samples for your few-shot examples. It should be different
from the sets included in <code>evaluation_splits</code></li> <li><code>few_shots_select</code> (str, can be <code>null</code>), the method that you will use to
select items for your few-shot examples. Can be <code>null</code>, or one of:<ul><li><code>balanced</code> select examples from the <code>few_shots_split</code> with balanced
labels, to avoid skewing the few shot examples (hence the model
generations) toward one specific label</li> <li><code>random</code> selects examples at random from the <code>few_shots_split</code></li> <li><code>random_sampling</code> selects new examples at random from the
<code>few_shots_split</code> for every new item, but if a sampled item is equal to
the current one, it is removed from the available samples</li> <li><code>random_sampling_from_train</code> selects new examples at random from the
<code>few_shots_split</code> for every new item, but if a sampled item is equal to
the current one, it is kept! Only use this if you know what you are
doing.</li> <li><code>sequential</code> selects the first <code>n</code> examples of the <code>few_shots_split</code></li></ul></li> <li><code>generation_size</code> (int), the maximum number of tokens allowed for a
generative evaluation. If your evaluation is a log likelihood evaluation
(multi-choice), this value should be -1</li> <li><code>stop_sequence</code> (list), a list of strings acting as end of sentence tokens
for your generation</li> <li><code>metric</code> (list), the metrics you want to use for your evaluation (see next
section for a detailed explanation)</li> <li><code>output_regex</code> (str), A regex string that will be used to filter your
generation. (Generative metrics will only select tokens that are between the
first and the second sequence matched by the regex. For example, for a regex
matching <code>\\n</code> and a generation <code>\\nModel generation output\\nSome other text</code>
the metric will only be fed with <code>Model generation output</code>)</li> <li><code>frozen</code> (bool), for now, is set to False, but we will steadily pass all
stable tasks to True.</li> <li><code>trust_dataset</code> (bool), set to True if you trust the dataset.</li>`,pe,E,ge="Then you need to add your task to the <code>TASKS_TABLE</code> list.",ye,S,me,V,ve="Finally, you need to add a module logic to convert your task to a dict for lighteval.",ue,Q,re,W,Ge="Once your file is created you can then run the evaluation with the following command:",de,z,Te,x,we,H,Ue;return j=new Ee({props:{title:"Adding a Custom Task",local:"adding-a-custom-task",headingTag:"h1"}}),J=new Re({props:{warning:!1,$$slots:{default:[He]},$$scope:{ctx:Y}}}),b=new Ee({props:{title:"Step by step creation of a custom task",local:"step-by-step-creation-of-a-custom-task",headingTag:"h2"}}),h=new Re({props:{warning:!0,$$slots:{default:[Fe]},$$scope:{ctx:Y}}}),k=new X({props:{code:"JTIzJTIwRGVmaW5lJTIwYXMlMjBtYW55JTIwYXMlMjB5b3UlMjBuZWVkJTIwZm9yJTIweW91ciUyMGRpZmZlcmVudCUyMHRhc2tzJTBBZGVmJTIwcHJvbXB0X2ZuKGxpbmUlMkMlMjB0YXNrX25hbWUlM0ElMjBzdHIlMjAlM0QlMjBOb25lKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkRlZmluZXMlMjBob3clMjB0byUyMGdvJTIwZnJvbSUyMGElMjBkYXRhc2V0JTIwbGluZSUyMHRvJTIwYSUyMGRvYyUyMG9iamVjdC4lMEElMjAlMjAlMjAlMjBGb2xsb3clMjBleGFtcGxlcyUyMGluJTIwc3JjJTJGbGlnaHRldmFsJTJGdGFza3MlMkZkZWZhdWx0X3Byb21wdHMucHklMkMlMjBvciUyMGdldCUyMG1vcmUlMjBpbmZvJTBBJTIwJTIwJTIwJTIwYWJvdXQlMjB3aGF0JTIwdGhpcyUyMGZ1bmN0aW9uJTIwc2hvdWxkJTIwZG8lMjBpbiUyMHRoZSUyMFJFQURNRS4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBEb2MoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFza19uYW1lJTNEdGFza19uYW1lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlcnklM0RsaW5lJTVCJTIycXVlc3Rpb24lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjaG9pY2VzJTNEJTVCZiUyMiUyMCU3QmMlN0QlMjIlMjBmb3IlMjBjJTIwaW4lMjBsaW5lJTVCJTIyY2hvaWNlcyUyMiU1RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdvbGRfaW5kZXglM0RsaW5lJTVCJTIyZ29sZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluc3RydWN0aW9uJTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-comment"># Define as many as you need for your different tasks</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">prompt_fn</span>(<span class="hljs-params">line, task_name: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;Defines how to go from a dataset line to a doc object.
    Follow examples in src/lighteval/tasks/default_prompts.py, or get more info
    about what this function should do in the README.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> Doc(
        task_name=task_name,
        query=line[<span class="hljs-string">&quot;question&quot;</span>],
        choices=[<span class="hljs-string">f&quot; <span class="hljs-subst">{c}</span>&quot;</span> <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> line[<span class="hljs-string">&quot;choices&quot;</span>]],
        gold_index=line[<span class="hljs-string">&quot;gold&quot;</span>],
        instruction=<span class="hljs-string">&quot;&quot;</span>,
    )`,wrap:!1}}),v=new X({props:{code:"Y3VzdG9tX21ldHJpYyUyMCUzRCUyMFNhbXBsZUxldmVsTWV0cmljKCUwQSUyMCUyMCUyMCUyMG1ldHJpY19uYW1lJTNEJTIybXlfY3VzdG9tX21ldHJpY19uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwaGlnaGVyX2lzX2JldHRlciUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBjYXRlZ29yeSUzRE1ldHJpY0NhdGVnb3J5LklHTk9SRUQlMkMlMEElMjAlMjAlMjAlMjB1c2VfY2FzZSUzRE1ldHJpY1VzZUNhc2UuTk9ORSUyQyUwQSUyMCUyMCUyMCUyMHNhbXBsZV9sZXZlbF9mbiUzRGxhbWJkYSUyMHglM0ElMjB4JTJDJTIwJTIwJTIzJTIwaG93JTIwdG8lMjBjb21wdXRlJTIwc2NvcmUlMjBmb3IlMjBvbmUlMjBzYW1wbGUlMEElMjAlMjAlMjAlMjBjb3JwdXNfbGV2ZWxfZm4lM0RucC5tZWFuJTJDJTIwJTIwJTIzJTIwSG93JTIwdG8lMjBhZ2dyZWFndGUlMjB0aGUlMjBzYW1wbGVzJTIwbWV0cmljcyUwQSk=",highlighted:`custom_metric = SampleLevelMetric(
    metric_name=<span class="hljs-string">&quot;my_custom_metric_name&quot;</span>,
    higher_is_better=<span class="hljs-literal">True</span>,
    category=MetricCategory.IGNORED,
    use_case=MetricUseCase.NONE,
    sample_level_fn=<span class="hljs-keyword">lambda</span> x: x,  <span class="hljs-comment"># how to compute score for one sample</span>
    corpus_level_fn=np.mean,  <span class="hljs-comment"># How to aggreagte the samples metrics</span>
)`,wrap:!1}}),A=new X({props:{code:"JTIzJTIwVGhpcyUyMGlzJTIwaG93JTIweW91JTIwY3JlYXRlJTIwYSUyMHNpbXBsZSUyMHRhc2slMjAobGlrZSUyMGhlbGxhc3dhZyklMjB3aGljaCUyMGhhcyUyMG9uZSUyMHNpbmdsZSUyMHN1YnNldCUwQSUyMyUyMGF0dGFjaGVkJTIwdG8lMjBpdCUyQyUyMGFuZCUyMG9uZSUyMGV2YWx1YXRpb24lMjBwb3NzaWJsZS4lMEF0YXNrJTIwJTNEJTIwTGlnaHRldmFsVGFza0NvbmZpZyglMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIybXlvdGhlcnRhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHRfZnVuY3Rpb24lM0Rwcm9tcHRfZm4lMkMlMjAlMjAlMjMlMjBtdXN0JTIwYmUlMjBkZWZpbmVkJTIwaW4lMjB0aGUlMjBmaWxlJTIwb3IlMjBpbXBvcnRlZCUyMGZyb20lMjBzcmMlMkZsaWdodGV2YWwlMkZ0YXNrcyUyRnRhc2tzX3Byb21wdF9mb3JtYXR0aW5nLnB5JTBBJTIwJTIwJTIwJTIwc3VpdGUlM0QlNUIlMjJjb21tdW5pdHklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBoZl9yZXBvJTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwaGZfc3Vic2V0JTNEJTIyZGVmYXVsdCUyMiUyQyUwQSUyMCUyMCUyMCUyMGhmX2F2YWlsX3NwbGl0cyUzRCU1QiU1RCUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3BsaXRzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwZmV3X3Nob3RzX3NwbGl0JTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMGZld19zaG90c19zZWxlY3QlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljJTNEJTVCJTVEJTJDJTIwJTIwJTIzJTIwc2VsZWN0JTIweW91ciUyMG1ldHJpYyUyMGluJTIwTWV0cmljcyUwQSk=",highlighted:`<span class="hljs-comment"># This is how you create a simple task (like hellaswag) which has one single subset</span>
<span class="hljs-comment"># attached to it, and one evaluation possible.</span>
task = LightevalTaskConfig(
    name=<span class="hljs-string">&quot;myothertask&quot;</span>,
    prompt_function=prompt_fn,  <span class="hljs-comment"># must be defined in the file or imported from src/lighteval/tasks/tasks_prompt_formatting.py</span>
    suite=[<span class="hljs-string">&quot;community&quot;</span>],
    hf_repo=<span class="hljs-string">&quot;&quot;</span>,
    hf_subset=<span class="hljs-string">&quot;default&quot;</span>,
    hf_avail_splits=[],
    evaluation_splits=[],
    few_shots_split=<span class="hljs-literal">None</span>,
    few_shots_select=<span class="hljs-literal">None</span>,
    metric=[],  <span class="hljs-comment"># select your metric in Metrics</span>
)`,wrap:!1}}),$=new X({props:{code:"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",highlighted:`SAMPLE_SUBSETS = []  <span class="hljs-comment"># list of all the subsets to use for this eval</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">CustomSubsetTask</span>(<span class="hljs-title class_ inherited__">LightevalTaskConfig</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        name,
        hf_subset,
    </span>):
        <span class="hljs-built_in">super</span>().__init__(
            name=name,
            hf_subset=hf_subset,
            prompt_function=prompt_fn,  <span class="hljs-comment"># must be defined in the file or imported from src/lighteval/tasks/tasks_prompt_formatting.py</span>
            hf_repo=<span class="hljs-string">&quot;&quot;</span>,
            metric=[custom_metric],  <span class="hljs-comment"># select your metric in Metrics or use your custom_metric</span>
            hf_avail_splits=[],
            evaluation_splits=[],
            few_shots_split=<span class="hljs-literal">None</span>,
            few_shots_select=<span class="hljs-literal">None</span>,
            suite=[<span class="hljs-string">&quot;community&quot;</span>],
            generation_size=-<span class="hljs-number">1</span>,
            stop_sequence=<span class="hljs-literal">None</span>,
            output_regex=<span class="hljs-literal">None</span>,
            frozen=<span class="hljs-literal">False</span>,
        )
SUBSET_TASKS = [CustomSubsetTask(name=<span class="hljs-string">f&quot;mytask:<span class="hljs-subst">{subset}</span>&quot;</span>, hf_subset=subset) <span class="hljs-keyword">for</span> subset <span class="hljs-keyword">in</span> SAMPLE_SUBSETS]`,wrap:!1}}),S=new X({props:{code:"JTIzJTIwU1RPUkUlMjBZT1VSJTIwRVZBTFMlMEElMEElMjMlMjB0YXNrcyUyMHdpdGglMjBzdWJzZXQlM0ElMEFUQVNLU19UQUJMRSUyMCUzRCUyMFNVQlNFVF9UQVNLUyUwQSUwQSUyMyUyMHRhc2tzJTIwd2l0aG91dCUyMHN1YnNldCUzQSUwQSUyMyUyMFRBU0tTX1RBQkxFJTIwJTNEJTIwJTVCdGFzayU1RA==",highlighted:`<span class="hljs-comment"># STORE YOUR EVALS</span>

<span class="hljs-comment"># tasks with subset:</span>
TASKS_TABLE = SUBSET_TASKS

<span class="hljs-comment"># tasks without subset:</span>
<span class="hljs-comment"># TASKS_TABLE = [task]</span>`,wrap:!1}}),Q=new X({props:{code:"JTIzJTIwTU9EVUxFJTIwTE9HSUMlMEElMjMlMjBZb3UlMjBzaG91bGQlMjBub3QlMjBuZWVkJTIwdG8lMjB0b3VjaCUyMHRoaXMlMEElMjMlMjBDb252ZXJ0JTIwdG8lMjBkaWN0JTIwZm9yJTIwbGlnaHRldmFsJTBBaWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQodC5uYW1lJTIwZm9yJTIwdCUyMGluJTIwVEFTS1NfVEFCTEUpJTBBJTIwJTIwJTIwJTIwcHJpbnQobGVuKFRBU0tTX1RBQkxFKSk=",highlighted:`<span class="hljs-comment"># MODULE LOGIC</span>
<span class="hljs-comment"># You should not need to touch this</span>
<span class="hljs-comment"># Convert to dict for lighteval</span>
<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    <span class="hljs-built_in">print</span>(t.name <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> TASKS_TABLE)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(TASKS_TABLE))`,wrap:!1}}),z=new X({props:{code:"bGlnaHRldmFsJTIwYWNjZWxlcmF0ZSUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMnByZXRyYWluZWQlM0RIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjJjb21tdW5pdHklN0MlN0JjdXN0b21fdGFzayU3RCU3QyU3QmZld3Nob3RzJTdEJTdDJTdCdHJ1bmNhdGVfZmV3X3Nob3QlN0QlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWN1c3RvbS10YXNrcyUyMCU3QnBhdGhfdG9feW91cl9jdXN0b21fdGFza19maWxlJTdE",highlighted:`lighteval accelerate \\
    <span class="hljs-string">&quot;pretrained=HuggingFaceH4/zephyr-7b-beta&quot;</span> \\
    <span class="hljs-string">&quot;community|{custom_task}|{fewshots}|{truncate_few_shot}&quot;</span> \\
    --custom-tasks {path_to_your_custom_task_file}`,wrap:!1}}),x=new Ye({props:{source:"https://github.com/huggingface/lighteval/blob/main/docs/source/adding-a-custom-task.mdx"}}),{c(){o=i("meta"),w=a(),c=i("p"),U=a(),y(j.$$.fragment),F=a(),f=i("p"),f.textContent=Je,q=a(),I=i("ul"),I.innerHTML=he,L=a(),C=i("p"),C.textContent=je,D=a(),y(J.$$.fragment),P=a(),y(b.$$.fragment),K=a(),y(h.$$.fragment),O=a(),_=i("p"),_.innerHTML=fe,ee=a(),B=i("p"),B.textContent=Ie,te=a(),y(k.$$.fragment),le=a(),g=i("p"),g.innerHTML=Ce,se=a(),y(v.$$.fragment),ae=a(),G=i("p"),G.innerHTML=be,ne=a(),y(A.$$.fragment),oe=a(),Z=i("p"),Z.innerHTML=_e,ie=a(),y($.$$.fragment),Me=a(),N=i("p"),N.textContent=Be,ce=a(),R=i("ul"),R.innerHTML=ke,pe=a(),E=i("p"),E.innerHTML=ge,ye=a(),y(S.$$.fragment),me=a(),V=i("p"),V.textContent=ve,ue=a(),y(Q.$$.fragment),re=a(),W=i("p"),W.textContent=Ge,de=a(),y(z.$$.fragment),Te=a(),y(x.$$.fragment),we=a(),H=i("p"),this.h()},l(e){const t=xe("svelte-u9bgzb",document.head);o=M(t,"META",{name:!0,content:!0}),t.forEach(l),w=n(e),c=M(e,"P",{}),$e(c).forEach(l),U=n(e),m(j.$$.fragment,e),F=n(e),f=M(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-15bwdkb"&&(f.textContent=Je),q=n(e),I=M(e,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-18vxpvw"&&(I.innerHTML=he),L=n(e),C=M(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-c3h151"&&(C.textContent=je),D=n(e),m(J.$$.fragment,e),P=n(e),m(b.$$.fragment,e),K=n(e),m(h.$$.fragment,e),O=n(e),_=M(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-4w3uiu"&&(_.innerHTML=fe),ee=n(e),B=M(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-dnqoqp"&&(B.textContent=Ie),te=n(e),m(k.$$.fragment,e),le=n(e),g=M(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-16x99kz"&&(g.innerHTML=Ce),se=n(e),m(v.$$.fragment,e),ae=n(e),G=M(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1sv3d9x"&&(G.innerHTML=be),ne=n(e),m(A.$$.fragment,e),oe=n(e),Z=M(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1r4bpbw"&&(Z.innerHTML=_e),ie=n(e),m($.$$.fragment,e),Me=n(e),N=M(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-th00fz"&&(N.textContent=Be),ce=n(e),R=M(e,"UL",{"data-svelte-h":!0}),p(R)!=="svelte-50y4aj"&&(R.innerHTML=ke),pe=n(e),E=M(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-7umcxy"&&(E.innerHTML=ge),ye=n(e),m(S.$$.fragment,e),me=n(e),V=M(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-8yc5ri"&&(V.textContent=ve),ue=n(e),m(Q.$$.fragment,e),re=n(e),W=M(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-41yve7"&&(W.textContent=Ge),de=n(e),m(z.$$.fragment,e),Te=n(e),m(x.$$.fragment,e),we=n(e),H=M(e,"P",{}),$e(H).forEach(l),this.h()},h(){Ne(o,"name","hf:doc:metadata"),Ne(o,"content",Le)},m(e,t){Xe(document.head,o),s(e,w,t),s(e,c,t),s(e,U,t),u(j,e,t),s(e,F,t),s(e,f,t),s(e,q,t),s(e,I,t),s(e,L,t),s(e,C,t),s(e,D,t),u(J,e,t),s(e,P,t),u(b,e,t),s(e,K,t),u(h,e,t),s(e,O,t),s(e,_,t),s(e,ee,t),s(e,B,t),s(e,te,t),u(k,e,t),s(e,le,t),s(e,g,t),s(e,se,t),u(v,e,t),s(e,ae,t),s(e,G,t),s(e,ne,t),u(A,e,t),s(e,oe,t),s(e,Z,t),s(e,ie,t),u($,e,t),s(e,Me,t),s(e,N,t),s(e,ce,t),s(e,R,t),s(e,pe,t),s(e,E,t),s(e,ye,t),u(S,e,t),s(e,me,t),s(e,V,t),s(e,ue,t),u(Q,e,t),s(e,re,t),s(e,W,t),s(e,de,t),u(z,e,t),s(e,Te,t),u(x,e,t),s(e,we,t),s(e,H,t),Ue=!0},p(e,[t]){const Ae={};t&2&&(Ae.$$scope={dirty:t,ctx:e}),J.$set(Ae);const Ze={};t&2&&(Ze.$$scope={dirty:t,ctx:e}),h.$set(Ze)},i(e){Ue||(r(j.$$.fragment,e),r(J.$$.fragment,e),r(b.$$.fragment,e),r(h.$$.fragment,e),r(k.$$.fragment,e),r(v.$$.fragment,e),r(A.$$.fragment,e),r($.$$.fragment,e),r(S.$$.fragment,e),r(Q.$$.fragment,e),r(z.$$.fragment,e),r(x.$$.fragment,e),Ue=!0)},o(e){d(j.$$.fragment,e),d(J.$$.fragment,e),d(b.$$.fragment,e),d(h.$$.fragment,e),d(k.$$.fragment,e),d(v.$$.fragment,e),d(A.$$.fragment,e),d($.$$.fragment,e),d(S.$$.fragment,e),d(Q.$$.fragment,e),d(z.$$.fragment,e),d(x.$$.fragment,e),Ue=!1},d(e){e&&(l(w),l(c),l(U),l(F),l(f),l(q),l(I),l(L),l(C),l(D),l(P),l(K),l(O),l(_),l(ee),l(B),l(te),l(le),l(g),l(se),l(ae),l(G),l(ne),l(oe),l(Z),l(ie),l(Me),l(N),l(ce),l(R),l(pe),l(E),l(ye),l(me),l(V),l(ue),l(re),l(W),l(de),l(Te),l(we),l(H)),l(o),T(j,e),T(J,e),T(b,e),T(h,e),T(k,e),T(v,e),T(A,e),T($,e),T(S,e),T(Q,e),T(z,e),T(x,e)}}}const Le='{"title":"Adding a Custom Task","local":"adding-a-custom-task","sections":[{"title":"Step by step creation of a custom task","local":"step-by-step-creation-of-a-custom-task","sections":[],"depth":2}],"depth":1}';function De(Y){return Qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class lt extends We{constructor(o){super(),ze(this,o,De,qe,Ve,{})}}export{lt as component};
