import{s as ea,o as sa}from"../chunks/scheduler.f7e1785c.js";import{S as ta,i as la,g as i,s as n,r as u,A as na,h as r,f as t,c as a,j as Ln,u as p,x as o,k as Pn,y as aa,a as l,v as c,d as m,t as d,w as M,m as Kn,n as On}from"../chunks/index.9f8f0838.js";import{T as Dn}from"../chunks/Tip.4575d9cf.js";import{C as y}from"../chunks/CodeBlock.4baef5d7.js";import{H as j,E as ia}from"../chunks/getInferenceSnippets.ad8e59bc.js";function ra(vs){let J;return{c(){J=Kn('Vous pouvez changer l\'identifiant de langue de `"dv"` pour un identifiant de langue de votre choix. Pour voir toutes les langues possibles dans Common Voice 13, consultez la carte du jeu de données sur le *Hub* : https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0')},l(T){J=On(T,'Vous pouvez changer l\'identifiant de langue de `"dv"` pour un identifiant de langue de votre choix. Pour voir toutes les langues possibles dans Common Voice 13, consultez la carte du jeu de données sur le *Hub* : https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0')},m(T,U){l(T,J,U)},d(T){T&&t(J)}}}function oa(vs){let J;return{c(){J=Kn("Si vous ne voulez pas télécharger les *checkpoints* du modèle vers le *Hub*, mettez `push_to_hub=False`.")},l(T){J=On(T,"Si vous ne voulez pas télécharger les *checkpoints* du modèle vers le *Hub*, mettez `push_to_hub=False`.")},m(T,U){l(T,J,U)},d(T){T&&t(J)}}}function ua(vs){let J,T,U,Is,w,Cs,b,ql="Dans cette section, nous allons couvrir un guide étape par étape pour <em>finetuner</em> Whisper pour la reconnaissance automatique de la parole sur le jeu de données Common Voice 13. Nous utiliserons la version ”<em>small</em>” du modèle et un jeu de données relativement léger, vous permettant d’exécuter le <em>finetuning</em> assez rapidement sur n’importe quel GPU de plus de 16 Go avec de faibles besoins en espace disque, comme le GPU T4 de 16 Go fourni dans le volet gratuit de Google Colab.",Zs,v,Gl="Si vous disposez d’un GPU plus petit ou si vous rencontrez des problèmes de mémoire pendant l’entraînement, vous pouvez suivre les suggestions fournies pour réduire l’utilisation de la mémoire. À l’inverse, si vous avez accès à un GPU plus puissant, vous pouvez modifier les arguments d’entraînement pour maximiser votre capacité de traitement. Ce guide est donc accessible quelles que soient les spécifications de votre GPU !",_s,g,xl=`De même, ce guide porte plus précisément sur le <em>finetuning</em> sur la langue Dhivehi mais les étapes couvertes ici se généralisent à n’importe quelle langue du jeu de données Common Voice, et plus généralement à n’importe quel jeu de données d’ASR disponible sur le <em>Hub</em>.
Vous pouvez modifier le code pour passer rapidement à la langue de votre choix et <em>finetuner</em> un modèle Whisper dans votre langue maternelle 🌍.`,Ws,I,Bl="Commençons et donnons le coup d’envoi de notre pipeline de <em>finetuning</em> !",$s,C,qs,Z,kl=`Nous vous conseillons vivement de télécharger les <em>checkpoints</em> du modèle directement sur le <a href="https://huggingface.co/" rel="nofollow"><em>Hub</em></a>.
Le <em>Hub</em> offre les avantages suivants :`,Gs,_,Xl="<li>Un contrôle de version intégré : vous pouvez être sûr qu’aucun <em>checkpoint</em> n’est perdu pendant l’entraînement.</li> <li>Tensorboard : suivi des mesures importantes au cours de l’entraînement.</li> <li>Cartes de modèle : documenter ce que fait un modèle et ses cas d’utilisation prévus.</li> <li>Communauté : un moyen facile de partager et de collaborer avec la communauté ! 🤗</li>",xs,W,zl=`Lier le <em>notebook</em> au <em>Hub</em> est très simple, il suffit d’entrer votre <em>token</em> d’authentification au <em>Hub</em> lorsque l’on vous y invite.
Votre <em>token</em> d’authentification est trouvable <a href="https://huggingface.co/settings/tokens" rel="nofollow">ici</a>.`,Bs,$,ks,q,Vl="<strong>Sortie :</strong>",Xs,G,zs,x,Vs,B,Nl='<a href="https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0" rel="nofollow">Common Voice 13</a> contient environ dix heures de données Dhivehi étiquetées, dont trois sont des données de test. Il s’agit de très peu de données pour un <em>finetuning</em>, nous nous appuierons donc sur la connaissance multilingue acquise par Whisper pendant le pré-entraînement.',Ns,k,Hl="En utilisant les 🤗 <em>Datasets</em>, le téléchargement et la préparation des données sont extrêmement simples. Nous pouvons télécharger et préparer les ensembles de Common Voice 13 en une seule ligne de code. Puisque le Dhivehi est très pauvre en ressources, nous combinerons les splits <code>train</code> et <code>validation</code> pour obtenir environ sept heures de données d’entraînement. Nous utiliserons les trois heures de données <code>test</code> comme notre ensemble de test :",Hs,X,As,z,Al="<strong>Sortie :</strong>",Es,V,Rs,h,Qs,N,El=`La plupart des jeux de données d’ASR ne fournissent que des échantillons audio en entrée (<code>audio</code>) et le texte transcrit correspondant (<code>sentence</code>).
Common Voice contient des métadonnées supplémentaires, telles que <code>accent</code> et <code>locale</code>, que nous pouvons ignorer pour l’ASR.
En gardant le <em>notebook</em> aussi général que possible, nous ne considérons que l’audio d’entrée et le texte transcrit en écartant les informations de métadonnées supplémentaires :`,Ys,H,Fs,A,Ss,E,Rl="Le pipeline d’ASR peut être décomposé en trois étapes :",Ls,R,Ql="<li>L’extracteur de caractéristiques qui pré-traite les entrées audio brutes en spectrogrammes log-mél.</li> <li>Le modèle qui effectue l’association séquence-séquence</li> <li>Le tokenizer qui post-traite les <em>tokens</em> prédits en texte.</li>",Ps,Q,Yl=`Dans 🤗 <em>Transformers</em>, le modèle Whisper est associé à un extracteur de caractéristiques et à un tokenizer, appelés respectivement <a href="https://huggingface.co/docs/transformers/main/model_doc/whisper#transformers.WhisperFeatureExtractor" rel="nofollow">WhisperFeatureExtractor</a> et <a href="https://huggingface.co/docs/transformers/main/model_doc/whisper#transformers.WhisperTokenizer" rel="nofollow">WhisperTokenizer</a>.
Pour nous simplifier la vie, ces deux objets sont regroupés dans une seule classe, appelée <a href="https://huggingface.co/docs/transformers/model_doc/whisper#transformers.WhisperProcessor" rel="nofollow">WhisperProcessor</a>.
Nous pouvons appeler le WhisperProcessor pour effectuer à la fois le prétraitement audio et le post-traitement des <em>tokens</em> de texte. Ce faisant, nous n’avons besoin de suivre que deux objets pendant l’entraîningment : le processeur et le modèle.`,Ds,Y,Fl=`Lors d’un <em>finetuné</em> multilingue, nous devons définir la <code>&quot;language&quot;</code> et la <code>&quot;task&quot;</code> lors de l’instanciation du processeur.
La <code>&quot;language&quot;</code> doit être fixée à la langue audio source, et la tâche à <code>&quot;translate&quot;</code> pour la reconnaissance vocale ou à <code>&quot;translate&quot;</code> pour la traduction vocale. Ces arguments modifient le comportement du <em>tokens</em>, et doivent être définis correctement pour s’assurer que les étiquettes cibles sont encodées correctement.`,Ks,F,Sl="Nous pouvons voir toutes les langues possibles supportées par Whisper en important la liste des langues :",Os,S,et,L,Ll=`Si vous parcourez cette liste, vous remarquerez que de nombreuses langues sont présentes, mais que le dhivehi est l’une des rares à ne pas l’être !
Cela signifie que Whisper n’a pas été pré-entraîné sur le dhivehi. Cependant, cela ne signifie pas que nous ne pouvons pas <em>finetuner</em> Whisper sur cette langue.
En faisant cela, nous allons entraîner Whisper dans une nouvelle langue, une langue non supportée par le <em>checkpoint</em> pré-entraîné. C’est plutôt cool, non ?`,st,P,Pl="Lorsque vous le <em>finetunez</em> sur une nouvelle langue, Whisper fait un bon travail en tirant parti de sa connaissance des 96 autres langues sur lesquelles il a été pré-entraîné. En général, toutes les langues modernes seront linguistiquement similaires à au moins l’une des 96 langues que Whisper connaît déjà, nous nous inscrivons donc dans ce paradigme de représentation des connaissances interlinguistiques.",tt,D,Dl=`Ce que nous devons faire pour cette nouvelle langue, est de trouver la langue <strong>la plus similaire</strong> sur laquelle Whisper a été pré-entraîné. L’article de Wikipédia sur le dhivehi indique que cette langue est étroitement liée à la langue cinghalaise du Sri Lanka.
Si nous vérifions à nouveau les codes de langue, nous pouvons voir que le cinghalais est présent dans le jeu de langues de Whisper, nous pouvons donc en toute sécurité mettre notre argument de langue à <code>&quot;sinhalese&quot;</code>.`,lt,K,Kl="Nous allons charger notre processeur à partir du <em>checkpoint</em> pré-entraîné, en fixant la langue à <code>&quot;sinhalese&quot;</code> et la tâche à <code>&quot;transcribe&quot;</code> comme expliqué ci-dessus :",nt,O,at,ee,Ol="Il est utile de rappeler que dans la plupart des cas, vous constaterez que la langue sur laquelle vous souhaitez effectuer un <em>finetuning</em> se trouve dans l’ensemble des langues de pré-entraînement, auquel cas vous pouvez simplement définir cette langue directement comme langue audio source ! Notez que ces deux arguments doivent être omis pour le <em>finetuning</em> en anglais où il n’y a qu’une seule option pour la langue (<code>&quot;English&quot;</code>) et la tâche (<code>&quot;transcribe&quot;</code>).",it,se,rt,te,en="Jetons un coup d’oeil aux caractéristiques du jeu de données. Portez une attention particulière à la colonne <code>&quot;audio&quot;</code>, elle détaille le taux d’échantillonnage de nos entrées audio :",ot,le,ut,ne,sn="<strong>Sortie :</strong>",pt,ae,ct,ie,tn="Puisque notre audio d’entrée est échantillonné à 48kHz, nous devons le sous-échantillonner à 16kHz avant de le passer à l’extracteur de caractéristiques de Whisper qui est la fréquence d’échantillonnage attendue par le modèle.",mt,re,ln='Nous allons régler les entrées audio à la bonne fréquence d’échantillonnage en utilisant la méthode <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.cast_column" rel="nofollow"><code>cast_column</code></a> du jeu de données. Cette opération ne modifie pas l’audio sur place, mais signale aux jeux de données de rééchantillonner les échantillons audio à la volée lorsqu’ils sont chargés :',dt,oe,Mt,ue,nn="Nous pouvons maintenant écrire une fonction pour préparer nos données pour le modèle :",yt,pe,an="<li>Nous chargeons et rééchantillonnons les données audio échantillon par échantillon en appelant <code>sample[&quot;audio&quot;]</code>. Comme expliqué ci-dessus, 🤗 <em>Datasets</em> effectue toutes les opérations de rééchantillonnage nécessaires à la volée.</li> <li>Nous utilisons l’extracteur de caractéristiques pour calculer les caractéristiques d’entrée du spectrogramme log-mel à partir de notre tableau audio unidimensionnel.</li> <li>Nous encodons les transcriptions en identifiants d’étiquettes à l’aide d’un <em>tokenizer</em>.</li>",Jt,ce,Tt,me,rn="Nous pouvons appliquer la fonction de préparation des données à tous nos exemples d’entraînement en utilisant la méthode <code>.map</code> de 🤗 <em>Datasets</em>. Nous allons supprimer les colonnes des données d’entraînement brutes (l’audio et le texte), en ne laissant que les colonnes renvoyées par la fonction <code>prepare_dataset</code> :",jt,de,Ut,Me,on="Enfin, nous filtrons toutes les données d’entraînement contenant des échantillons audio de plus de 30 secondes. Ces échantillons seraient sinon tronqués par l’extracteur de caractéristiques de Whisper, ce qui pourrait affecter la stabilité de l’entraînement. Nous définissons une fonction qui renvoie <code>True</code> pour les échantillons de moins de 30 secondes, et <code>False</code> pour ceux qui sont plus longs :",ht,ye,ft,Je,un="Nous appliquons notre fonction de filtrage à tous les échantillons de notre jeu de données d’entraînement par le biais de la méthode <code>.filter</code> de 🤗 <em>Datasets</em> :",wt,Te,bt,je,pn="Vérifions la quantité de données d’entraînement que nous avons supprimée grâce à cette étape de filtrage :",vt,Ue,gt,he,cn="<strong>Sortie :</strong>",It,fe,Ct,we,mn=`Dans ce cas, nous avons en fait le même nombre d’échantillons que précédemment, donc il n’y a pas d’échantillons de plus de 30s.
Cela pourrait ne pas être le cas si vous changez de langue, il est donc préférable de garder cette étape de filtrage en place pour plus de robustesse. Nos données sont maintenant prêtes à être entraînées ! Continuons et regardons comment nous pouvons utiliser ces données pour le <em>finetuning</em>.`,Zt,be,_t,ve,dn=`Maintenant que nous avons préparé nos données, nous sommes prêts à plonger dans le pipeline d’entraînement.
<a href="https://huggingface.co/transformers/master/main_classes/trainer.html?highlight=trainer" rel="nofollow">Trainer</a>
va faire le gros du travail à notre place. Tout ce que nous avons à faire est de :`,Wt,ge,Mn="<li><p>Définir un assembleur de données qui prend nos données prétraitées et prépare des tenseurs PyTorch adaptés au modèle.</p></li> <li><p>Métriques d’évaluation : lors de l’évaluation, nous voulons évaluer le modèle en utilisant la métrique du taux d’erreur au niveau du mot (WER). Nous devons définir une fonction <code>compute_metrics</code> qui gère ce calcul.</p></li> <li><p>Charger un <em>checkpoint</em> pré-entraîné et le configurer correctement pour l’entraînement.</p></li> <li><p>Définir les arguments d’entraînement : ils seront utilisés par le Trainer pour construire le plannificateur d’entraînement.</p></li>",$t,Ie,yn="Une fois le modèle <em>finetuné</em>, nous l’évaluerons sur les données de test pour vérifier que nous l’avons correctement entraîné à transcrire la parole en Dhivehi.",qt,Ce,Gt,Ze,Jn="L’assembleur de données pour un modèle audio séquence-à-séquence est unique dans le sens où il traite les <code>input_features</code> et les <code>labels</code> indépendamment : les <code>input_features</code> doivent être traitées par l’extracteur de caractéristiques et les <code>labels</code> par le tokenizer.",xt,_e,Tn="Les <code>input_features</code> sont déjà rembourrées à 30s et converties en un spectrogramme log-Mel de dimension fixe, donc tout ce que nous avons à faire est de les convertir en tenseurs PyTorch batchés. Nous le faisons en utilisant la méthode <code>.pad</code> de l’extracteur de caractéristiques avec <code>return_tensors=pt</code>. Notez qu’aucun rembourrage supplémentaire n’est appliqué ici puisque les entrées sont de dimension fixe, les <code>input_features</code> sont simplement converties en tenseurs PyTorch.",Bt,We,jn="D’un autre côté, les <code>labels</code> ne sont pas rembourrés. Les séquences sont d’abord remplacées par la longueur maximale du batch à l’aide de la méthode <code>.pad</code> du <em>tokenizer</em>. Les <em>tokens</em> de remplissage sont ensuite remplacés par <code>-100</code> de sorte que ces tokens ne sont <strong>pas</strong> pris en compte lors du calcul de la perte. Nous coupons ensuite le début du <em>token</em> de transcription du début de la séquence d’étiquettes comme nous l’ajouterons plus tard pendant l’entraînement.",kt,$e,Un="Nous pouvons utiliser le <code>WhisperProcessor</code> que nous avons défini plus tôt pour effectuer à la fois les opérations de l’extracteur de caractéristiques et du <em>tokenizer</em> :",Xt,qe,zt,Ge,hn="Nous pouvons maintenant initialiser l’assembleur de données que nous venons de définir :",Vt,xe,Nt,Be,fn="En avant !",Ht,ke,At,Xe,wn='Ensuite, nous définissons la métrique d’évaluation que nous utiliserons sur notre ensemble d’évaluation. Nous utiliserons le taux d’erreur au niveaud du mot (WER) introduit dans la section <a href="%C3%A9valuation">évaluation</a>, la métrique “de-facto” pour évaluer les systèmes d’ASR.',Et,ze,bn="Nous chargerons la métrique WER à partir d’ 🤗 <em>Evaluate</em> :",Rt,Ve,Qt,Ne,vn="Il suffit ensuite de définir une fonction qui prend les prédictions de notre modèle et renvoie la métrique WER. Cette fonction, appelée <code>compute_metrics</code>, remplace d’abord <code>-100</code> par le <code>pad_token_id</code> dans <code>label_ids</code> (annulant l’étape que nous avons appliquée dans l’assembleur de données pour ignorer correctement les <em>tokens</em> rembourrés dans la perte). Il décode ensuite les identifiants prédits et les identifiants d’étiquettes en chaînes de caractères. Enfin, il calcule le WER entre les prédictions et les étiquettes de référence. Ici, nous avons la possibilité d’évaluer les transcriptions et les prédictions “normalisées”, dont la ponctuation et la casse ont été supprimées. Nous vous recommandons de procéder ainsi pour bénéficier de l’amélioration du WER obtenue par la normalisation des transcriptions.",Yt,He,Ft,Ae,St,Ee,gn="Chargeons maintenant le <em>checkpoint</em> pré-entraîné de Whisper small. Encore une fois, ceci est trivial grâce à l’utilisation de 🤗 <em>Transformers</em> !",Lt,Re,Pt,Qe,In='Nous allons mettre <code>use_cache</code> à <code>False</code> pour l’entraînement puisque nous utilisons [<em>gradient checkpointing</em>] (<a href="https://huggingface.co/docs/transformers/v4.18.0/en/performance#gradient-checkpointing" rel="nofollow">https://huggingface.co/docs/transformers/v4.18.0/en/performance#gradient-checkpointing</a>) et que les deux sont incompatibles. Nous allons aussi surcharger deux arguments de génération pour contrôler le comportement du modèle pendant l’inférence : nous allons forcer la langue et les <em>tokens</em> de tâche pendant la génération en définissant les arguments <code>language</code> et <code>task</code>, et aussi réactiver le cache pour la génération afin d’accélérer le temps d’inférence :',Dt,Ye,Kt,Fe,Ot,Se,Cn=`Dans la dernière étape, nous définissons tous les paramètres liés à l’entraînement. Ici, nous fixons le nombre d’étapes d’entraînement à 500.
Cela représente suffisamment d’étapes pour voir une grande amélioration du WER par rapport au modèle pré-entraîné, tout en s’assurant que le <em>finetuning</em> peut être exécuté en environ 45 minutes sur un niveau gratuit de Google Colab. Pour plus de détails sur les arguments d’entraînement, reportez-vous à la documentation de [Seq2SeqTrainingArguments] (<a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.Seq2SeqTrainingArguments" rel="nofollow">https://huggingface.co/docs/transformers/main_classes/trainer#transformers.Seq2SeqTrainingArguments</a>).`,el,Le,sl,f,tl,Pe,Zn="Nous pouvons transmettre les arguments d’entraînement au <em>Trainer</em> avec notre modèle, notre jeu de données, notre assembleur de données et la fonction <code>compute_metrics</code> :",ll,De,nl,Ke,_n="Et voilà, nous sommes prêts à entraîner !",al,Oe,il,es,Wn="Pour lancer l’entraînement, il suffit d’exécuter :",rl,ss,ol,ts,$n='L’entraînement prendra environ 45 minutes en fonction de votre GPU ou de celui alloué par Google Colab. En fonction de votre GPU, il est possible que vous rencontriez une erreur CUDA <code>&quot;out-of-memory&quot;</code> lorsque vous commencez à entraîner. Dans ce cas, vous pouvez réduire le <code>per_device_train_batch_size</code> par incréments d’un facteur 2 et utiliser <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.Seq2SeqTrainingArguments.gradient_accumulation_steps" rel="nofollow"><code>gradient_accumulation_steps</code></a> pour compenser.',ul,ls,qn="<strong>Sortie :</strong>",pl,ns,Gn='<thead><tr><th align="center">Training Loss</th> <th align="center">Epoch</th> <th align="center">Step</th> <th align="center">Validation Loss</th> <th align="center">Wer Ortho</th> <th align="center">Wer</th></tr></thead> <tbody><tr><td align="center">0.136</td> <td align="center">1.63</td> <td align="center">500</td> <td align="center">0.1727</td> <td align="center">63.8972</td> <td align="center">14.0661</td></tr></tbody>',cl,as,xn="Notre WER final est de 14,1 % ce qui n’est pas mal pour sept heures de données d’entraînement et seulement 500 étapes d’entraînement ! Cela représente une amélioration de 112 % par rapport au modèle pré-entraîné ! Cela signifie que nous avons pris un modèle qui n’avait aucune connaissance du dhivehi et que nous l’avons <em>finetuné</em> pour reconnaître l’dhivehi avec une précision adéquate en moins d’une heure 🤯.",ml,is,Bn='La grande question est de savoir comment cela se compare à d’autres systèmes ASR. Pour cela, nous pouvons consulter le [classement autoevaluate] (<a href="https://huggingface.co/spaces/autoevaluate/leaderboards?dataset=mozilla-foundation%2Fcommon_voice_13_0&amp;only_verified=0&amp;task=automatic-speech-recognition&amp;config=dv&amp;split=test&amp;metric=wer" rel="nofollow">https://huggingface.co/spaces/autoevaluate/leaderboards?dataset=mozilla-foundation%2Fcommon_voice_13_0&amp;only_verified=0&amp;task=automatic-speech-recognition&amp;config=dv&amp;split=test&amp;metric=wer</a>) qui catégorise les modèles par langue et par jeu de données, et les classe ensuite en fonction de leur WER.',dl,rs,kn='En regardant le classement, nous voyons que notre modèle entraîné pour 500 étapes bat de manière convaincante le <em>checkpoint</em> <a href="https://huggingface.co/openai/whisper-small" rel="nofollow">Whisper Small</a> pré-entraîné que nous avons évalué dans la section précédente. Bon travail 👏',Ml,os,Xn=`Nous voyons qu’il y a quelques <em>checkpoints</em> qui font mieux que celui que nous avons entraîné. La beauté du <em>Hub</em> est qu’il s’agit d’une plateforme <em>collaborative</em>. Si nous n’avons pas le temps ou les ressources pour effectuer un entraînement plus long nous-mêmes, nous pouvons charger un <em>checkpoint</em> que quelqu’un d’autre dans la communauté a entraîné et a eu la gentillesse de partager (en s’assurant de le remercier pour cela !).
Vous pourrez charger ces <em>checkpoints</em> exactement de la même manière que les pré-entraînés en utilisant la classe <code>pipeline</code> comme nous l’avons fait précédemment ! Ainsi, rien ne vous empêche de sélectionner le meilleur modèle du leaderboard pour l’utiliser dans le cadre de votre tâche !`,yl,us,zn="Nous pouvons automatiquement soumettre notre <em>checkpoint</em> au classement lorsque nous envoyons les résultats de l’entraînement au <em>Hub</em>. Nous devons simplement définir les arguments de mot-clé appropriés (kwargs). Vous pouvez modifier ces valeurs pour qu’elles correspondent à votre jeu de données, à votre langue et au nom de votre modèle en conséquence :",Jl,ps,Tl,cs,Vn="Les résultats de l’entraînement peuvent maintenant être téléchargés vers le <em>Hub</em>. Pour ce faire, exécutez la commande <code>push_to_hub</code> :",jl,ms,Ul,ds,Nn="Ceci sauvegardera les logs d’entraînement et les poids des modèles sous <code>&quot;votre-nom-d&#39;utilisateur/le-nom-que-vous-avez-choisi&quot;</code>. Pour cet exemple, regardez le téléchargement à <code>sanchit-gandhi/whisper-small-dv</code>.",hl,Ms,Hn=`Bien que le modèle <em>finetuné</em> donne des résultats satisfaisants sur les données de test de Common Voice 13, il n’est en aucun cas optimal.
Le but de ce guide est de démontrer comment <em>finetuner</em> un modèle ASR en utilisant le <em>Trainer</em> pour la reconnaissance automatique de la parole multilingue.`,fl,ys,An="Si vous avez accès à votre propre GPU ou si vous êtes abonné à un plan payant de Google Colab, vous pouvez augmenter <code>max_pas</code> à 4000 pas pour améliorer davantage le WER en entraînant plus de pas. Entraîner 4000 pas prendra environ 3 à 5 heures en fonction de votre GPU et donnera des résultats WER inférieurs d’environ 3 % à l’entraînement de 500 pas. Si vous décidez d’entraîner sur 4000 pas, nous vous recommandons également de changer le planificateur de taux d’apprentissage pour un plan <em>linéaire</em> (set <code>lr_scheduler_type=&quot;linear&quot;</code>), car cela permettra d’augmenter les performances sur de longues périodes d’entraînement.",wl,Js,En="Les résultats pourraient probablement être améliorés en optimisant les hyperparamètres d’entraînement, tels que <em>learning rate</em> et <em>dropout</em>, et en utilisant un <em>checkpoint</em> pré-entraîné plus grand (<code>medium</code> ou <code>large</code>). Nous laissons cet exercice au lecteur.",bl,Ts,vl,js,Rn='Vous pouvez maintenant partager ce modèle avec n’importe qui en utilisant le lien sur le <em>Hub</em>. Ils peuvent le charger avec l’identifiant <code>&quot;votre-nom-d&#39;utilisateur/le-nom-que-vous-avez-choisi&quot;</code> directement dans l’objet <code>pipeline()</code>. Par exemple, pour charger le <em>checkpoint</em> <em>finetuné</em> <a href="https://huggingface.co/sanchit-gandhi/whisper-small-dv" rel="nofollow">“sanchit-gandhi/whisper-small-dv”</a> :',gl,Us,Il,hs,Cl,fs,Qn="Dans cette section, nous avons couvert un guide étape par étape sur le <em>finetuning</em> du modèle Whisper pour la reconnaissance vocale en utilisants 🤗 <em>Jeux de données</em>, 🤗 <em>Transformers</em> et le <em>Hub</em>. Nous avons d’abord chargé le sous-ensemble Dhivehi du jeu de données Common Voice 13 et l’avons prétraité en calculant des spectrogrammes log-mel et en tokenisant le texte. Nous avons ensuite défini un assembleur de données, une métrique d’évaluation et des arguments d’entraînement, avant d’utiliser le <em>Trainer</em> pour entraîner et évaluer notre modèle. Nous avons terminé en téléchargeant le modèle <em>finetuné</em> sur le <em>Hub</em>, et nous avons montré comment le partager et l’utiliser avec la classe <code>pipeline()</code>.",Zl,ws,Yn=`Si vous avez suivi jusqu’à ce point, vous devriez maintenant avoir un <em>checkpoint</em> <em>finetuné</em> pour la reconnaissance automatique de la parole, bien joué ! 🥳
Plus important encore, vous êtes équipé de tous les outils nécessaires pour <em>finetuner</em> le modèle Whisper sur n’importe quel jeu de données ou domaine de reconnaissance vocale. Alors, qu’attendez-vous ? Choisissez l’un des jeux de données couverts dans la section <a href="choosing_dataset">Choisir un jeu de données</a> ou sélectionnez un jeu de données de votre choix, et voyez si vous pouvez obtenir des performances de pointe ! Le classement vous attend…`,_l,bs,Wl,gs,$l;return w=new j({props:{title:"Comment finetuner un système de reconnaissance automatique de la parole avec l’API Trainer",local:"comment-finetuner-un-système-de-reconnaissance-automatique-de-la-parole-avec-lapi-trainer",headingTag:"h1"}}),C=new j({props:{title:"Préparer l’environnement",local:"préparer-lenvironnement",headingTag:"h2"}}),$=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),G=new y({props:{code:"TG9naW4lMjBzdWNjZXNzZnVsJTBBWW91ciUyMHRva2VuJTIwaGFzJTIwYmVlbiUyMHNhdmVkJTIwdG8lMjAlMkZyb290JTJGLmh1Z2dpbmdmYWNlJTJGdG9rZW4=",highlighted:`Login successful
Your token has been saved to /root/.huggingface/token`,wrap:!1}}),x=new j({props:{title:"Charger le jeu de données",local:"charger-le-jeu-de-données",headingTag:"h2"}}),X=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwRGF0YXNldERpY3QlMEElMEFjb21tb25fdm9pY2UlMjAlM0QlMjBEYXRhc2V0RGljdCgpJTBBJTBBY29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMjAlMjJkdiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMkJ2YWxpZGF0aW9uJTIyJTBBKSUwQWNvbW1vbl92b2ljZSU1QiUyMnRlc3QlMjIlNUQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMjAlMjJkdiUyMiUyQyUyMHNwbGl0JTNEJTIydGVzdCUyMiUwQSklMEElMEFwcmludChjb21tb25fdm9pY2Up",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, DatasetDict

common_voice = DatasetDict()

common_voice[<span class="hljs-string">&quot;train&quot;</span>] = load_dataset(
    <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>, <span class="hljs-string">&quot;dv&quot;</span>, split=<span class="hljs-string">&quot;train+validation&quot;</span>
)
common_voice[<span class="hljs-string">&quot;test&quot;</span>] = load_dataset(
    <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>, <span class="hljs-string">&quot;dv&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>
)

<span class="hljs-built_in">print</span>(common_voice)`,wrap:!1}}),V=new y({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ2NsaWVudF9pZCclMkMlMjAncGF0aCclMkMlMjAnYXVkaW8nJTJDJTIwJ3NlbnRlbmNlJyUyQyUyMCd1cF92b3RlcyclMkMlMjAnZG93bl92b3RlcyclMkMlMjAnYWdlJyUyQyUyMCdnZW5kZXInJTJDJTIwJ2FjY2VudCclMkMlMjAnbG9jYWxlJyUyQyUyMCdzZWdtZW50JyUyQyUyMCd2YXJpYW50JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNDkwNCUwQSUyMCUyMCUyMCUyMCU3RCklMEElMjAlMjAlMjAlMjB0ZXN0JTNBJTIwRGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidjbGllbnRfaWQnJTJDJTIwJ3BhdGgnJTJDJTIwJ2F1ZGlvJyUyQyUyMCdzZW50ZW5jZSclMkMlMjAndXBfdm90ZXMnJTJDJTIwJ2Rvd25fdm90ZXMnJTJDJTIwJ2FnZSclMkMlMjAnZ2VuZGVyJyUyQyUyMCdhY2NlbnQnJTJDJTIwJ2xvY2FsZSclMkMlMjAnc2VnbWVudCclMkMlMjAndmFyaWFudCclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDIyMTIlMEElMjAlMjAlMjAlMjAlN0QpJTBBJTdEKQ==",highlighted:`DatasetDict({
    train: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;client_id&#x27;</span>, <span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;sentence&#x27;</span>, <span class="hljs-string">&#x27;up_votes&#x27;</span>, <span class="hljs-string">&#x27;down_votes&#x27;</span>, <span class="hljs-string">&#x27;age&#x27;</span>, <span class="hljs-string">&#x27;gender&#x27;</span>, <span class="hljs-string">&#x27;accent&#x27;</span>, <span class="hljs-string">&#x27;locale&#x27;</span>, <span class="hljs-string">&#x27;segment&#x27;</span>, <span class="hljs-string">&#x27;variant&#x27;</span>],
        num_rows: <span class="hljs-number">4904</span>
    })
    test: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;client_id&#x27;</span>, <span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;sentence&#x27;</span>, <span class="hljs-string">&#x27;up_votes&#x27;</span>, <span class="hljs-string">&#x27;down_votes&#x27;</span>, <span class="hljs-string">&#x27;age&#x27;</span>, <span class="hljs-string">&#x27;gender&#x27;</span>, <span class="hljs-string">&#x27;accent&#x27;</span>, <span class="hljs-string">&#x27;locale&#x27;</span>, <span class="hljs-string">&#x27;segment&#x27;</span>, <span class="hljs-string">&#x27;variant&#x27;</span>],
        num_rows: <span class="hljs-number">2212</span>
    })
})`,wrap:!1}}),h=new Dn({props:{$$slots:{default:[ra]},$$scope:{ctx:vs}}}),H=new y({props:{code:"Y29tbW9uX3ZvaWNlJTIwJTNEJTIwY29tbW9uX3ZvaWNlLnNlbGVjdF9jb2x1bW5zKCU1QiUyMmF1ZGlvJTIyJTJDJTIwJTIyc2VudGVuY2UlMjIlNUQp",highlighted:'common_voice = common_voice.select_columns([<span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;sentence&quot;</span>])',wrap:!1}}),A=new j({props:{title:"Extracteur de caractéristiques, tokeniser et processeur",local:"extracteur-de-caractéristiques-tokeniser-et-processeur",headingTag:"h2"}}),S=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMud2hpc3Blci50b2tlbml6YXRpb25fd2hpc3BlciUyMGltcG9ydCUyMFRPX0xBTkdVQUdFX0NPREUlMEElMEFUT19MQU5HVUFHRV9DT0RF",highlighted:`<span class="hljs-keyword">from</span> transformers.models.whisper.tokenization_whisper <span class="hljs-keyword">import</span> TO_LANGUAGE_CODE

TO_LANGUAGE_CODE`,wrap:!1}}),O=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBXaGlzcGVyUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyJTJDJTIwbGFuZ3VhZ2UlM0QlMjJzaW5oYWxlc2UlMjIlMkMlMjB0YXNrJTNEJTIydHJhbnNjcmliZSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperProcessor

processor = WhisperProcessor.from_pretrained(
    <span class="hljs-string">&quot;openai/whisper-small&quot;</span>, language=<span class="hljs-string">&quot;sinhalese&quot;</span>, task=<span class="hljs-string">&quot;transcribe&quot;</span>
)`,wrap:!1}}),se=new j({props:{title:"Prétraitement des données",local:"prétraitement-des-données",headingTag:"h2"}}),le=new y({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQuZmVhdHVyZXM=",highlighted:'common_voice[<span class="hljs-string">&quot;train&quot;</span>].features',wrap:!1}}),ae=new y({props:{code:"JTdCJ2F1ZGlvJyUzQSUyMEF1ZGlvKHNhbXBsaW5nX3JhdGUlM0Q0ODAwMCUyQyUyMG1vbm8lM0RUcnVlJTJDJTIwZGVjb2RlJTNEVHJ1ZSUyQyUyMGlkJTNETm9uZSklMkMlMEElMjAnc2VudGVuY2UnJTNBJTIwVmFsdWUoZHR5cGUlM0Qnc3RyaW5nJyUyQyUyMGlkJTNETm9uZSklN0Q=",highlighted:`{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(<span class="hljs-attribute">sampling_rate</span>=48000, <span class="hljs-attribute">mono</span>=<span class="hljs-literal">True</span>, <span class="hljs-attribute">decode</span>=<span class="hljs-literal">True</span>, <span class="hljs-attribute">id</span>=None),
 <span class="hljs-string">&#x27;sentence&#x27;</span>: Value(<span class="hljs-attribute">dtype</span>=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-attribute">id</span>=None)}`,wrap:!1}}),oe=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwcHJvY2Vzc29yLmZlYXR1cmVfZXh0cmFjdG9yLnNhbXBsaW5nX3JhdGUlMEFjb21tb25fdm9pY2UlMjAlM0QlMjBjb21tb25fdm9pY2UuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

sampling_rate = processor.feature_extractor.sampling_rate
common_voice = common_voice.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=sampling_rate))`,wrap:!1}}),ce=new y({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZXh0JTNEZXhhbXBsZSU1QiUyMnNlbnRlbmNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGNvbXB1dGUlMjBpbnB1dCUyMGxlbmd0aCUyMG9mJTIwYXVkaW8lMjBzYW1wbGUlMjBpbiUyMHNlY29uZHMlMEElMjAlMjAlMjAlMjBleGFtcGxlJTVCJTIyaW5wdXRfbGVuZ3RoJTIyJTVEJTIwJTNEJTIwbGVuKGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQpJTIwJTJGJTIwYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        audio=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        text=example[<span class="hljs-string">&quot;sentence&quot;</span>],
    )

    <span class="hljs-comment"># compute input length of audio sample in seconds</span>
    example[<span class="hljs-string">&quot;input_length&quot;</span>] = <span class="hljs-built_in">len</span>(audio[<span class="hljs-string">&quot;array&quot;</span>]) / audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>]

    <span class="hljs-keyword">return</span> example`,wrap:!1}}),de=new y({props:{code:"Y29tbW9uX3ZvaWNlJTIwJTNEJTIwY29tbW9uX3ZvaWNlLm1hcCglMEElMjAlMjAlMjAlMjBwcmVwYXJlX2RhdGFzZXQlMkMlMjByZW1vdmVfY29sdW1ucyUzRGNvbW1vbl92b2ljZS5jb2x1bW5fbmFtZXMlNUIlMjJ0cmFpbiUyMiU1RCUyQyUyMG51bV9wcm9jJTNEMSUwQSk=",highlighted:`common_voice = common_voice.<span class="hljs-built_in">map</span>(
    prepare_dataset, remove_columns=common_voice.column_names[<span class="hljs-string">&quot;train&quot;</span>], num_proc=<span class="hljs-number">1</span>
)`,wrap:!1}}),ye=new y({props:{code:"bWF4X2lucHV0X2xlbmd0aCUyMCUzRCUyMDMwLjAlMEElMEElMEFkZWYlMjBpc19hdWRpb19pbl9sZW5ndGhfcmFuZ2UobGVuZ3RoKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGxlbmd0aCUyMCUzQyUyMG1heF9pbnB1dF9sZW5ndGg=",highlighted:`max_input_length = <span class="hljs-number">30.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_in_length_range</span>(<span class="hljs-params">length</span>):
    <span class="hljs-keyword">return</span> length &lt; max_input_length`,wrap:!1}}),Te=new y({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBjb21tb25fdm9pY2UlNUIlMjJ0cmFpbiUyMiU1RC5maWx0ZXIoJTBBJTIwJTIwJTIwJTIwaXNfYXVkaW9faW5fbGVuZ3RoX3JhbmdlJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRfY29sdW1ucyUzRCU1QiUyMmlucHV0X2xlbmd0aCUyMiU1RCUyQyUwQSk=",highlighted:`common_voice[<span class="hljs-string">&quot;train&quot;</span>] = common_voice[<span class="hljs-string">&quot;train&quot;</span>].<span class="hljs-built_in">filter</span>(
    is_audio_in_length_range,
    input_columns=[<span class="hljs-string">&quot;input_length&quot;</span>],
)`,wrap:!1}}),Ue=new y({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQ=",highlighted:'common_voice[<span class="hljs-string">&quot;train&quot;</span>]',wrap:!1}}),fe=new y({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidpbnB1dF9mZWF0dXJlcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdpbnB1dF9sZW5ndGgnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA0OTA0JTBBJTdEKQ==",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;input_features&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>, <span class="hljs-string">&#x27;input_length&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">4904</span>
})`,wrap:!1}}),be=new j({props:{title:"Entraînement et évaluation",local:"entraînement-et-évaluation",headingTag:"h2"}}),Ce=new j({props:{title:"Définir un assembleur de données",local:"définir-un-assembleur-de-données",headingTag:"h3"}}),qe=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">DataCollatorSpeechSeq2SeqWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        <span class="hljs-comment"># diviser les entrées et les étiquettes car elles doivent être de longueurs différentes et nécessitent des méthodes de remplissage différentes</span>
        <span class="hljs-comment"># traiter d&#x27;abord les entrées audio en renvoyant simplement des tenseurs Torch</span>
        input_features = [
            {<span class="hljs-string">&quot;input_features&quot;</span>: feature[<span class="hljs-string">&quot;input_features&quot;</span>][<span class="hljs-number">0</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features
        ]
        batch = self.processor.feature_extractor.pad(input_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

        <span class="hljs-comment"># obtenir les séquences d&#x27;étiquettes tokenisées</span>
        label_features = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        <span class="hljs-comment"># rembourrer les étiquettes à la longueur maximale</span>
        labels_batch = self.processor.tokenizer.pad(label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

        <span class="hljs-comment"># remplacer le remplissage par -100 pour ignorer correctement les pertes</span>
        labels = labels_batch[<span class="hljs-string">&quot;input_ids&quot;</span>].masked_fill(
            labels_batch.attention_mask.ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># si le token bos est ajouté lors de l&#x27;étape de tokenisation précédente, couper le token bos ici puisqu&#x27;il sera de toute façon ajouté plus tard</span>
        <span class="hljs-keyword">if</span> (labels[:, <span class="hljs-number">0</span>] == self.processor.tokenizer.bos_token_id).<span class="hljs-built_in">all</span>().cpu().item():
            labels = labels[:, <span class="hljs-number">1</span>:]

        batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),xe=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvclNwZWVjaFNlcTJTZXFXaXRoUGFkZGluZyhwcm9jZXNzb3IlM0Rwcm9jZXNzb3Ip",highlighted:"data_collator = DataCollatorSpeechSeq2SeqWithPadding(processor=processor)",wrap:!1}}),ke=new j({props:{title:"Métriques d’évaluation",local:"métriques-dévaluation",headingTag:"h3"}}),Ve=new y({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMndlciUyMik=",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;wer&quot;</span>)`,wrap:!1}}),He=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers.models.whisper.english_normalizer <span class="hljs-keyword">import</span> BasicTextNormalizer

normalizer = BasicTextNormalizer()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">pred</span>):
    pred_ids = pred.predictions
    label_ids = pred.label_ids

    <span class="hljs-comment"># remplacer -100 par pad_token_id</span>
    label_ids[label_ids == -<span class="hljs-number">100</span>] = processor.tokenizer.pad_token_id

    <span class="hljs-comment"># nous ne voulons pas grouper les *tokens* lors du calcul des métriques</span>
    pred_str = processor.batch_decode(pred_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
    label_str = processor.batch_decode(label_ids, skip_special_tokens=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># calculer le Wer orthographique</span>
    wer_ortho = <span class="hljs-number">100</span> * metric.compute(predictions=pred_str, references=label_str)

    <span class="hljs-comment"># calculer le WER normalisé</span>
    pred_str_norm = [normalizer(pred) <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> pred_str]
    label_str_norm = [normalizer(label) <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> label_str]
    <span class="hljs-comment"># afin de n&#x27;évaluer que les échantillons correspondant à des références non nulles</span>
    pred_str_norm = [
        pred_str_norm[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(pred_str_norm)) <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(label_str_norm[i]) &gt; <span class="hljs-number">0</span>
    ]
    label_str_norm = [
        label_str_norm[i]
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(label_str_norm))
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(label_str_norm[i]) &gt; <span class="hljs-number">0</span>
    ]

    wer = <span class="hljs-number">100</span> * metric.compute(predictions=pred_str_norm, references=label_str_norm)

    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;wer_ortho&quot;</span>: wer_ortho, <span class="hljs-string">&quot;wer&quot;</span>: wer}`,wrap:!1}}),Ae=new j({props:{title:"Charger un checkpoint pré-entraîné",local:"charger-un-checkpoint-pré-entraîné",headingTag:"h3"}}),Re=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRndoaXNwZXItc21hbGwlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperForConditionalGeneration

model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),Ye=new y({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjBkJUMzJUE5c2FjdGl2ZXIlMjBsZSUyMGNhY2hlJTIwcGVuZGFudCUyMGwnZW50cmElQzMlQUVuZW1lbnQlMjBjYXIlMjBpbCUyMGVzdCUyMGluY29tcGF0aWJsZSUyMGF2ZWMlMjBsZSUyMGNoZWNrcG9pbnRpbmclMjBkdSUyMGdyYWRpZW50JTBBbW9kZWwuY29uZmlnLnVzZV9jYWNoZSUyMCUzRCUyMEZhbHNlJTBBJTBBJTIzJTIwZCVDMyVBOWZpbmlyJTIwbGElMjBsYW5ndWUlMjBldCUyMGxhJTIwdCVDMyVBMmNoZSUyMHBvdXIlMjBsYSUyMGclQzMlQTluJUMzJUE5cmF0aW9uJTIwZXQlMjByJUMzJUE5YWN0aXZlciUyMGxlJTIwY2FjaGUlMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwoJTBBJTIwJTIwJTIwJTIwbW9kZWwuZ2VuZXJhdGUlMkMlMjBsYW5ndWFnZSUzRCUyMnNpbmhhbGVzZSUyMiUyQyUyMHRhc2slM0QlMjJ0cmFuc2NyaWJlJTIyJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># désactiver le cache pendant l&#x27;entraînement car il est incompatible avec le checkpointing du gradient</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># définir la langue et la tâche pour la génération et réactiver le cache</span>
model.generate = partial(
    model.generate, language=<span class="hljs-string">&quot;sinhalese&quot;</span>, task=<span class="hljs-string">&quot;transcribe&quot;</span>, use_cache=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Fe=new j({props:{title:"Définir la configuration de l’entraînement",local:"définir-la-configuration-de-lentraînement",headingTag:"h2"}}),Le=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMi4lMkZ3aGlzcGVyLXNtYWxsLWR2JTIyJTJDJTIwJTIwJTIzJTIwbm9tJTIwc3VyJTIwbGUlMjBIdWIlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDElMkMlMjAlMjAlMjMlMjAlQzMlQTAlMjB4MiUyMCUyMHBvdXIlMjBjaGFxdWUlMjBkaW1pbnV0aW9uJTIwZGUlMjAyeCUyMGRlJTIwbGElMjB0YWlsbGUlMjBkdSUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjBscl9zY2hlZHVsZXJfdHlwZSUzRCUyMmNvbnN0YW50X3dpdGhfd2FybXVwJTIyJTJDJTBBJTIwJTIwJTIwJTIwd2FybXVwX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q1MDAlMkMlMjAlMjAlMjMlMjBhdWdtZW50ZXIlMjBqdXNxdSclQzMlQTAlMjA0MDAwJTIwc2klMjB2b3VzJTIwZGlzcG9zZXolMjBkZSUyMHZvdHJlJTIwcHJvcHJlJTIwR1BVJTIwb3UlMjBkJ3VuJTIwcGxhbiUyMENvbGFiJTIwcGF5YW50JTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGZwMTZfZnVsbF9ldmFsJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBwcmVkaWN0X3dpdGhfZ2VuZXJhdGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGlvbl9tYXhfbGVuZ3RoJTNEMjI1JTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV9zdGVwcyUzRDUwMCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlNUIlMjJ0ZW5zb3Jib2FyZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljX2Zvcl9iZXN0X21vZGVsJTNEJTIyd2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZ3JlYXRlcl9pc19iZXR0ZXIlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;./whisper-small-dv&quot;</span>,  <span class="hljs-comment"># nom sur le Hub</span>
    per_device_train_batch_size=<span class="hljs-number">16</span>,
    gradient_accumulation_steps=<span class="hljs-number">1</span>,  <span class="hljs-comment"># à x2  pour chaque diminution de 2x de la taille du batch</span>
    learning_rate=<span class="hljs-number">1e-5</span>,
    lr_scheduler_type=<span class="hljs-string">&quot;constant_with_warmup&quot;</span>,
    warmup_steps=<span class="hljs-number">50</span>,
    max_steps=<span class="hljs-number">500</span>,  <span class="hljs-comment"># augmenter jusqu&#x27;à 4000 si vous disposez de votre propre GPU ou d&#x27;un plan Colab payant</span>
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    fp16_full_eval=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">16</span>,
    predict_with_generate=<span class="hljs-literal">True</span>,
    generation_max_length=<span class="hljs-number">225</span>,
    save_steps=<span class="hljs-number">500</span>,
    eval_steps=<span class="hljs-number">500</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    metric_for_best_model=<span class="hljs-string">&quot;wer&quot;</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),f=new Dn({props:{$$slots:{default:[oa]},$$scope:{ctx:vs}}}),De=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0Rjb21tb25fdm9pY2UlNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGNvbW1vbl92b2ljZSU1QiUyMnRlc3QlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEZGF0YV9jb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3NvciUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=common_voice[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=common_voice[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    compute_metrics=compute_metrics,
    tokenizer=processor,
)`,wrap:!1}}),Oe=new j({props:{title:"Entraînement",local:"entraînement",headingTag:"h4"}}),ss=new y({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),ps=new y({props:{code:"a3dhcmdzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZGF0YXNldF90YWdzJTIyJTNBJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJkYXRhc2V0JTIyJTNBJTIwJTIyQ29tbW9uJTIwVm9pY2UlMjAxMyUyMiUyQyUyMCUyMCUyMyUyMGElMjAncHJldHR5JyUyMG5hbWUlMjBmb3IlMjB0aGUlMjB0cmFpbmluZyUyMGRhdGFzZXQlMEElMjAlMjAlMjAlMjAlMjJsYW5ndWFnZSUyMiUzQSUyMCUyMmR2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIybW9kZWxfbmFtZSUyMiUzQSUyMCUyMldoaXNwZXIlMjBTbWFsbCUyMER2JTIwLSUyMFNhbmNoaXQlMjBHYW5kaGklMjIlMkMlMjAlMjAlMjMlMjBhJTIwJ3ByZXR0eSclMjBuYW1lJTIwZm9yJTIweW91ciUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwJTIyZmluZXR1bmVkX2Zyb20lMjIlM0ElMjAlMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGFza3MlMjIlM0ElMjAlMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTBBJTdE",highlighted:`kwargs = {
    <span class="hljs-string">&quot;dataset_tags&quot;</span>: <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>,
    <span class="hljs-string">&quot;dataset&quot;</span>: <span class="hljs-string">&quot;Common Voice 13&quot;</span>,  <span class="hljs-comment"># a &#x27;pretty&#x27; name for the training dataset</span>
    <span class="hljs-string">&quot;language&quot;</span>: <span class="hljs-string">&quot;dv&quot;</span>,
    <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;Whisper Small Dv - Sanchit Gandhi&quot;</span>,  <span class="hljs-comment"># a &#x27;pretty&#x27; name for your model</span>
    <span class="hljs-string">&quot;finetuned_from&quot;</span>: <span class="hljs-string">&quot;openai/whisper-small&quot;</span>,
    <span class="hljs-string">&quot;tasks&quot;</span>: <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
}`,wrap:!1}}),ms=new y({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1YigqKmt3YXJncyk=",highlighted:"trainer.push_to_hub(**kwargs)",wrap:!1}}),Ts=new j({props:{title:"Partager votre modèle",local:"partager-votre-modèle",headingTag:"h2"}}),Us=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNhbmNoaXQtZ2FuZGhpJTJGd2hpc3Blci1zbWFsbC1kdiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;sanchit-gandhi/whisper-small-dv&quot;</span>)`,wrap:!1}}),hs=new j({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),bs=new ia({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/fr/chapter5/fine-tuning.mdx"}}),{c(){J=i("meta"),T=n(),U=i("p"),Is=n(),u(w.$$.fragment),Cs=n(),b=i("p"),b.innerHTML=ql,Zs=n(),v=i("p"),v.textContent=Gl,_s=n(),g=i("p"),g.innerHTML=xl,Ws=n(),I=i("p"),I.innerHTML=Bl,$s=n(),u(C.$$.fragment),qs=n(),Z=i("p"),Z.innerHTML=kl,Gs=n(),_=i("ul"),_.innerHTML=Xl,xs=n(),W=i("p"),W.innerHTML=zl,Bs=n(),u($.$$.fragment),ks=n(),q=i("p"),q.innerHTML=Vl,Xs=n(),u(G.$$.fragment),zs=n(),u(x.$$.fragment),Vs=n(),B=i("p"),B.innerHTML=Nl,Ns=n(),k=i("p"),k.innerHTML=Hl,Hs=n(),u(X.$$.fragment),As=n(),z=i("p"),z.innerHTML=Al,Es=n(),u(V.$$.fragment),Rs=n(),u(h.$$.fragment),Qs=n(),N=i("p"),N.innerHTML=El,Ys=n(),u(H.$$.fragment),Fs=n(),u(A.$$.fragment),Ss=n(),E=i("p"),E.textContent=Rl,Ls=n(),R=i("ol"),R.innerHTML=Ql,Ps=n(),Q=i("p"),Q.innerHTML=Yl,Ds=n(),Y=i("p"),Y.innerHTML=Fl,Ks=n(),F=i("p"),F.textContent=Sl,Os=n(),u(S.$$.fragment),et=n(),L=i("p"),L.innerHTML=Ll,st=n(),P=i("p"),P.innerHTML=Pl,tt=n(),D=i("p"),D.innerHTML=Dl,lt=n(),K=i("p"),K.innerHTML=Kl,nt=n(),u(O.$$.fragment),at=n(),ee=i("p"),ee.innerHTML=Ol,it=n(),u(se.$$.fragment),rt=n(),te=i("p"),te.innerHTML=en,ot=n(),u(le.$$.fragment),ut=n(),ne=i("p"),ne.innerHTML=sn,pt=n(),u(ae.$$.fragment),ct=n(),ie=i("p"),ie.textContent=tn,mt=n(),re=i("p"),re.innerHTML=ln,dt=n(),u(oe.$$.fragment),Mt=n(),ue=i("p"),ue.textContent=nn,yt=n(),pe=i("ol"),pe.innerHTML=an,Jt=n(),u(ce.$$.fragment),Tt=n(),me=i("p"),me.innerHTML=rn,jt=n(),u(de.$$.fragment),Ut=n(),Me=i("p"),Me.innerHTML=on,ht=n(),u(ye.$$.fragment),ft=n(),Je=i("p"),Je.innerHTML=un,wt=n(),u(Te.$$.fragment),bt=n(),je=i("p"),je.textContent=pn,vt=n(),u(Ue.$$.fragment),gt=n(),he=i("p"),he.innerHTML=cn,It=n(),u(fe.$$.fragment),Ct=n(),we=i("p"),we.innerHTML=mn,Zt=n(),u(be.$$.fragment),_t=n(),ve=i("p"),ve.innerHTML=dn,Wt=n(),ge=i("ul"),ge.innerHTML=Mn,$t=n(),Ie=i("p"),Ie.innerHTML=yn,qt=n(),u(Ce.$$.fragment),Gt=n(),Ze=i("p"),Ze.innerHTML=Jn,xt=n(),_e=i("p"),_e.innerHTML=Tn,Bt=n(),We=i("p"),We.innerHTML=jn,kt=n(),$e=i("p"),$e.innerHTML=Un,Xt=n(),u(qe.$$.fragment),zt=n(),Ge=i("p"),Ge.textContent=hn,Vt=n(),u(xe.$$.fragment),Nt=n(),Be=i("p"),Be.textContent=fn,Ht=n(),u(ke.$$.fragment),At=n(),Xe=i("p"),Xe.innerHTML=wn,Et=n(),ze=i("p"),ze.innerHTML=bn,Rt=n(),u(Ve.$$.fragment),Qt=n(),Ne=i("p"),Ne.innerHTML=vn,Yt=n(),u(He.$$.fragment),Ft=n(),u(Ae.$$.fragment),St=n(),Ee=i("p"),Ee.innerHTML=gn,Lt=n(),u(Re.$$.fragment),Pt=n(),Qe=i("p"),Qe.innerHTML=In,Dt=n(),u(Ye.$$.fragment),Kt=n(),u(Fe.$$.fragment),Ot=n(),Se=i("p"),Se.innerHTML=Cn,el=n(),u(Le.$$.fragment),sl=n(),u(f.$$.fragment),tl=n(),Pe=i("p"),Pe.innerHTML=Zn,ll=n(),u(De.$$.fragment),nl=n(),Ke=i("p"),Ke.textContent=_n,al=n(),u(Oe.$$.fragment),il=n(),es=i("p"),es.textContent=Wn,rl=n(),u(ss.$$.fragment),ol=n(),ts=i("p"),ts.innerHTML=$n,ul=n(),ls=i("p"),ls.innerHTML=qn,pl=n(),ns=i("table"),ns.innerHTML=Gn,cl=n(),as=i("p"),as.innerHTML=xn,ml=n(),is=i("p"),is.innerHTML=Bn,dl=n(),rs=i("p"),rs.innerHTML=kn,Ml=n(),os=i("p"),os.innerHTML=Xn,yl=n(),us=i("p"),us.innerHTML=zn,Jl=n(),u(ps.$$.fragment),Tl=n(),cs=i("p"),cs.innerHTML=Vn,jl=n(),u(ms.$$.fragment),Ul=n(),ds=i("p"),ds.innerHTML=Nn,hl=n(),Ms=i("p"),Ms.innerHTML=Hn,fl=n(),ys=i("p"),ys.innerHTML=An,wl=n(),Js=i("p"),Js.innerHTML=En,bl=n(),u(Ts.$$.fragment),vl=n(),js=i("p"),js.innerHTML=Rn,gl=n(),u(Us.$$.fragment),Il=n(),u(hs.$$.fragment),Cl=n(),fs=i("p"),fs.innerHTML=Qn,Zl=n(),ws=i("p"),ws.innerHTML=Yn,_l=n(),u(bs.$$.fragment),Wl=n(),gs=i("p"),this.h()},l(e){const s=na("svelte-u9bgzb",document.head);J=r(s,"META",{name:!0,content:!0}),s.forEach(t),T=a(e),U=r(e,"P",{}),Ln(U).forEach(t),Is=a(e),p(w.$$.fragment,e),Cs=a(e),b=r(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-7xhodp"&&(b.innerHTML=ql),Zs=a(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-4imhws"&&(v.textContent=Gl),_s=a(e),g=r(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-311mw7"&&(g.innerHTML=xl),Ws=a(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-2difxl"&&(I.innerHTML=Bl),$s=a(e),p(C.$$.fragment,e),qs=a(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1utckd2"&&(Z.innerHTML=kl),Gs=a(e),_=r(e,"UL",{"data-svelte-h":!0}),o(_)!=="svelte-1j0por"&&(_.innerHTML=Xl),xs=a(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-x9ppr7"&&(W.innerHTML=zl),Bs=a(e),p($.$$.fragment,e),ks=a(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-dbzevp"&&(q.innerHTML=Vl),Xs=a(e),p(G.$$.fragment,e),zs=a(e),p(x.$$.fragment,e),Vs=a(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-71vyw5"&&(B.innerHTML=Nl),Ns=a(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-12unh11"&&(k.innerHTML=Hl),Hs=a(e),p(X.$$.fragment,e),As=a(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-dbzevp"&&(z.innerHTML=Al),Es=a(e),p(V.$$.fragment,e),Rs=a(e),p(h.$$.fragment,e),Qs=a(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-ybamg3"&&(N.innerHTML=El),Ys=a(e),p(H.$$.fragment,e),Fs=a(e),p(A.$$.fragment,e),Ss=a(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-qk6exq"&&(E.textContent=Rl),Ls=a(e),R=r(e,"OL",{"data-svelte-h":!0}),o(R)!=="svelte-1yr2wae"&&(R.innerHTML=Ql),Ps=a(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-coa99w"&&(Q.innerHTML=Yl),Ds=a(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-p9miuc"&&(Y.innerHTML=Fl),Ks=a(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-101xqap"&&(F.textContent=Sl),Os=a(e),p(S.$$.fragment,e),et=a(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-mv87b3"&&(L.innerHTML=Ll),st=a(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-ftdzgz"&&(P.innerHTML=Pl),tt=a(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-32kddc"&&(D.innerHTML=Dl),lt=a(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1bhj23r"&&(K.innerHTML=Kl),nt=a(e),p(O.$$.fragment,e),at=a(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1vetgq4"&&(ee.innerHTML=Ol),it=a(e),p(se.$$.fragment,e),rt=a(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1s88cms"&&(te.innerHTML=en),ot=a(e),p(le.$$.fragment,e),ut=a(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-dbzevp"&&(ne.innerHTML=sn),pt=a(e),p(ae.$$.fragment,e),ct=a(e),ie=r(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-bhbzlh"&&(ie.textContent=tn),mt=a(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1c9l05"&&(re.innerHTML=ln),dt=a(e),p(oe.$$.fragment,e),Mt=a(e),ue=r(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-kma8yf"&&(ue.textContent=nn),yt=a(e),pe=r(e,"OL",{"data-svelte-h":!0}),o(pe)!=="svelte-l386lk"&&(pe.innerHTML=an),Jt=a(e),p(ce.$$.fragment,e),Tt=a(e),me=r(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-p7ipd6"&&(me.innerHTML=rn),jt=a(e),p(de.$$.fragment,e),Ut=a(e),Me=r(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1qc8iml"&&(Me.innerHTML=on),ht=a(e),p(ye.$$.fragment,e),ft=a(e),Je=r(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-gzokzm"&&(Je.innerHTML=un),wt=a(e),p(Te.$$.fragment,e),bt=a(e),je=r(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1astr79"&&(je.textContent=pn),vt=a(e),p(Ue.$$.fragment,e),gt=a(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-dbzevp"&&(he.innerHTML=cn),It=a(e),p(fe.$$.fragment,e),Ct=a(e),we=r(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-p7jukp"&&(we.innerHTML=mn),Zt=a(e),p(be.$$.fragment,e),_t=a(e),ve=r(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1mq6oan"&&(ve.innerHTML=dn),Wt=a(e),ge=r(e,"UL",{"data-svelte-h":!0}),o(ge)!=="svelte-sqta85"&&(ge.innerHTML=Mn),$t=a(e),Ie=r(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-2uwoqk"&&(Ie.innerHTML=yn),qt=a(e),p(Ce.$$.fragment,e),Gt=a(e),Ze=r(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1k53otr"&&(Ze.innerHTML=Jn),xt=a(e),_e=r(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-enj5n1"&&(_e.innerHTML=Tn),Bt=a(e),We=r(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1g4czpk"&&(We.innerHTML=jn),kt=a(e),$e=r(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-i0n36t"&&($e.innerHTML=Un),Xt=a(e),p(qe.$$.fragment,e),zt=a(e),Ge=r(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-cc0sp7"&&(Ge.textContent=hn),Vt=a(e),p(xe.$$.fragment,e),Nt=a(e),Be=r(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-nyz60k"&&(Be.textContent=fn),Ht=a(e),p(ke.$$.fragment,e),At=a(e),Xe=r(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-3hsyij"&&(Xe.innerHTML=wn),Et=a(e),ze=r(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-c52gbi"&&(ze.innerHTML=bn),Rt=a(e),p(Ve.$$.fragment,e),Qt=a(e),Ne=r(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1j3exdi"&&(Ne.innerHTML=vn),Yt=a(e),p(He.$$.fragment,e),Ft=a(e),p(Ae.$$.fragment,e),St=a(e),Ee=r(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-db0asr"&&(Ee.innerHTML=gn),Lt=a(e),p(Re.$$.fragment,e),Pt=a(e),Qe=r(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-17vn05i"&&(Qe.innerHTML=In),Dt=a(e),p(Ye.$$.fragment,e),Kt=a(e),p(Fe.$$.fragment,e),Ot=a(e),Se=r(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-1gc8mk7"&&(Se.innerHTML=Cn),el=a(e),p(Le.$$.fragment,e),sl=a(e),p(f.$$.fragment,e),tl=a(e),Pe=r(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-1hcg6it"&&(Pe.innerHTML=Zn),ll=a(e),p(De.$$.fragment,e),nl=a(e),Ke=r(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-iy6ynd"&&(Ke.textContent=_n),al=a(e),p(Oe.$$.fragment,e),il=a(e),es=r(e,"P",{"data-svelte-h":!0}),o(es)!=="svelte-v8wedd"&&(es.textContent=Wn),rl=a(e),p(ss.$$.fragment,e),ol=a(e),ts=r(e,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-igzv0v"&&(ts.innerHTML=$n),ul=a(e),ls=r(e,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-dbzevp"&&(ls.innerHTML=qn),pl=a(e),ns=r(e,"TABLE",{"data-svelte-h":!0}),o(ns)!=="svelte-10vryw9"&&(ns.innerHTML=Gn),cl=a(e),as=r(e,"P",{"data-svelte-h":!0}),o(as)!=="svelte-189evyt"&&(as.innerHTML=xn),ml=a(e),is=r(e,"P",{"data-svelte-h":!0}),o(is)!=="svelte-c68dny"&&(is.innerHTML=Bn),dl=a(e),rs=r(e,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-1i7i3ab"&&(rs.innerHTML=kn),Ml=a(e),os=r(e,"P",{"data-svelte-h":!0}),o(os)!=="svelte-e0goyt"&&(os.innerHTML=Xn),yl=a(e),us=r(e,"P",{"data-svelte-h":!0}),o(us)!=="svelte-10v9yjn"&&(us.innerHTML=zn),Jl=a(e),p(ps.$$.fragment,e),Tl=a(e),cs=r(e,"P",{"data-svelte-h":!0}),o(cs)!=="svelte-8qq12z"&&(cs.innerHTML=Vn),jl=a(e),p(ms.$$.fragment,e),Ul=a(e),ds=r(e,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-1n05g3i"&&(ds.innerHTML=Nn),hl=a(e),Ms=r(e,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-jftxq6"&&(Ms.innerHTML=Hn),fl=a(e),ys=r(e,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-muxy92"&&(ys.innerHTML=An),wl=a(e),Js=r(e,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-15dfq0u"&&(Js.innerHTML=En),bl=a(e),p(Ts.$$.fragment,e),vl=a(e),js=r(e,"P",{"data-svelte-h":!0}),o(js)!=="svelte-1ecvei2"&&(js.innerHTML=Rn),gl=a(e),p(Us.$$.fragment,e),Il=a(e),p(hs.$$.fragment,e),Cl=a(e),fs=r(e,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-7weori"&&(fs.innerHTML=Qn),Zl=a(e),ws=r(e,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-1a2cjs"&&(ws.innerHTML=Yn),_l=a(e),p(bs.$$.fragment,e),Wl=a(e),gs=r(e,"P",{}),Ln(gs).forEach(t),this.h()},h(){Pn(J,"name","hf:doc:metadata"),Pn(J,"content",pa)},m(e,s){aa(document.head,J),l(e,T,s),l(e,U,s),l(e,Is,s),c(w,e,s),l(e,Cs,s),l(e,b,s),l(e,Zs,s),l(e,v,s),l(e,_s,s),l(e,g,s),l(e,Ws,s),l(e,I,s),l(e,$s,s),c(C,e,s),l(e,qs,s),l(e,Z,s),l(e,Gs,s),l(e,_,s),l(e,xs,s),l(e,W,s),l(e,Bs,s),c($,e,s),l(e,ks,s),l(e,q,s),l(e,Xs,s),c(G,e,s),l(e,zs,s),c(x,e,s),l(e,Vs,s),l(e,B,s),l(e,Ns,s),l(e,k,s),l(e,Hs,s),c(X,e,s),l(e,As,s),l(e,z,s),l(e,Es,s),c(V,e,s),l(e,Rs,s),c(h,e,s),l(e,Qs,s),l(e,N,s),l(e,Ys,s),c(H,e,s),l(e,Fs,s),c(A,e,s),l(e,Ss,s),l(e,E,s),l(e,Ls,s),l(e,R,s),l(e,Ps,s),l(e,Q,s),l(e,Ds,s),l(e,Y,s),l(e,Ks,s),l(e,F,s),l(e,Os,s),c(S,e,s),l(e,et,s),l(e,L,s),l(e,st,s),l(e,P,s),l(e,tt,s),l(e,D,s),l(e,lt,s),l(e,K,s),l(e,nt,s),c(O,e,s),l(e,at,s),l(e,ee,s),l(e,it,s),c(se,e,s),l(e,rt,s),l(e,te,s),l(e,ot,s),c(le,e,s),l(e,ut,s),l(e,ne,s),l(e,pt,s),c(ae,e,s),l(e,ct,s),l(e,ie,s),l(e,mt,s),l(e,re,s),l(e,dt,s),c(oe,e,s),l(e,Mt,s),l(e,ue,s),l(e,yt,s),l(e,pe,s),l(e,Jt,s),c(ce,e,s),l(e,Tt,s),l(e,me,s),l(e,jt,s),c(de,e,s),l(e,Ut,s),l(e,Me,s),l(e,ht,s),c(ye,e,s),l(e,ft,s),l(e,Je,s),l(e,wt,s),c(Te,e,s),l(e,bt,s),l(e,je,s),l(e,vt,s),c(Ue,e,s),l(e,gt,s),l(e,he,s),l(e,It,s),c(fe,e,s),l(e,Ct,s),l(e,we,s),l(e,Zt,s),c(be,e,s),l(e,_t,s),l(e,ve,s),l(e,Wt,s),l(e,ge,s),l(e,$t,s),l(e,Ie,s),l(e,qt,s),c(Ce,e,s),l(e,Gt,s),l(e,Ze,s),l(e,xt,s),l(e,_e,s),l(e,Bt,s),l(e,We,s),l(e,kt,s),l(e,$e,s),l(e,Xt,s),c(qe,e,s),l(e,zt,s),l(e,Ge,s),l(e,Vt,s),c(xe,e,s),l(e,Nt,s),l(e,Be,s),l(e,Ht,s),c(ke,e,s),l(e,At,s),l(e,Xe,s),l(e,Et,s),l(e,ze,s),l(e,Rt,s),c(Ve,e,s),l(e,Qt,s),l(e,Ne,s),l(e,Yt,s),c(He,e,s),l(e,Ft,s),c(Ae,e,s),l(e,St,s),l(e,Ee,s),l(e,Lt,s),c(Re,e,s),l(e,Pt,s),l(e,Qe,s),l(e,Dt,s),c(Ye,e,s),l(e,Kt,s),c(Fe,e,s),l(e,Ot,s),l(e,Se,s),l(e,el,s),c(Le,e,s),l(e,sl,s),c(f,e,s),l(e,tl,s),l(e,Pe,s),l(e,ll,s),c(De,e,s),l(e,nl,s),l(e,Ke,s),l(e,al,s),c(Oe,e,s),l(e,il,s),l(e,es,s),l(e,rl,s),c(ss,e,s),l(e,ol,s),l(e,ts,s),l(e,ul,s),l(e,ls,s),l(e,pl,s),l(e,ns,s),l(e,cl,s),l(e,as,s),l(e,ml,s),l(e,is,s),l(e,dl,s),l(e,rs,s),l(e,Ml,s),l(e,os,s),l(e,yl,s),l(e,us,s),l(e,Jl,s),c(ps,e,s),l(e,Tl,s),l(e,cs,s),l(e,jl,s),c(ms,e,s),l(e,Ul,s),l(e,ds,s),l(e,hl,s),l(e,Ms,s),l(e,fl,s),l(e,ys,s),l(e,wl,s),l(e,Js,s),l(e,bl,s),c(Ts,e,s),l(e,vl,s),l(e,js,s),l(e,gl,s),c(Us,e,s),l(e,Il,s),c(hs,e,s),l(e,Cl,s),l(e,fs,s),l(e,Zl,s),l(e,ws,s),l(e,_l,s),c(bs,e,s),l(e,Wl,s),l(e,gs,s),$l=!0},p(e,[s]){const Fn={};s&2&&(Fn.$$scope={dirty:s,ctx:e}),h.$set(Fn);const Sn={};s&2&&(Sn.$$scope={dirty:s,ctx:e}),f.$set(Sn)},i(e){$l||(m(w.$$.fragment,e),m(C.$$.fragment,e),m($.$$.fragment,e),m(G.$$.fragment,e),m(x.$$.fragment,e),m(X.$$.fragment,e),m(V.$$.fragment,e),m(h.$$.fragment,e),m(H.$$.fragment,e),m(A.$$.fragment,e),m(S.$$.fragment,e),m(O.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(ae.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(de.$$.fragment,e),m(ye.$$.fragment,e),m(Te.$$.fragment,e),m(Ue.$$.fragment,e),m(fe.$$.fragment,e),m(be.$$.fragment,e),m(Ce.$$.fragment,e),m(qe.$$.fragment,e),m(xe.$$.fragment,e),m(ke.$$.fragment,e),m(Ve.$$.fragment,e),m(He.$$.fragment,e),m(Ae.$$.fragment,e),m(Re.$$.fragment,e),m(Ye.$$.fragment,e),m(Fe.$$.fragment,e),m(Le.$$.fragment,e),m(f.$$.fragment,e),m(De.$$.fragment,e),m(Oe.$$.fragment,e),m(ss.$$.fragment,e),m(ps.$$.fragment,e),m(ms.$$.fragment,e),m(Ts.$$.fragment,e),m(Us.$$.fragment,e),m(hs.$$.fragment,e),m(bs.$$.fragment,e),$l=!0)},o(e){d(w.$$.fragment,e),d(C.$$.fragment,e),d($.$$.fragment,e),d(G.$$.fragment,e),d(x.$$.fragment,e),d(X.$$.fragment,e),d(V.$$.fragment,e),d(h.$$.fragment,e),d(H.$$.fragment,e),d(A.$$.fragment,e),d(S.$$.fragment,e),d(O.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(oe.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(ye.$$.fragment,e),d(Te.$$.fragment,e),d(Ue.$$.fragment,e),d(fe.$$.fragment,e),d(be.$$.fragment,e),d(Ce.$$.fragment,e),d(qe.$$.fragment,e),d(xe.$$.fragment,e),d(ke.$$.fragment,e),d(Ve.$$.fragment,e),d(He.$$.fragment,e),d(Ae.$$.fragment,e),d(Re.$$.fragment,e),d(Ye.$$.fragment,e),d(Fe.$$.fragment,e),d(Le.$$.fragment,e),d(f.$$.fragment,e),d(De.$$.fragment,e),d(Oe.$$.fragment,e),d(ss.$$.fragment,e),d(ps.$$.fragment,e),d(ms.$$.fragment,e),d(Ts.$$.fragment,e),d(Us.$$.fragment,e),d(hs.$$.fragment,e),d(bs.$$.fragment,e),$l=!1},d(e){e&&(t(T),t(U),t(Is),t(Cs),t(b),t(Zs),t(v),t(_s),t(g),t(Ws),t(I),t($s),t(qs),t(Z),t(Gs),t(_),t(xs),t(W),t(Bs),t(ks),t(q),t(Xs),t(zs),t(Vs),t(B),t(Ns),t(k),t(Hs),t(As),t(z),t(Es),t(Rs),t(Qs),t(N),t(Ys),t(Fs),t(Ss),t(E),t(Ls),t(R),t(Ps),t(Q),t(Ds),t(Y),t(Ks),t(F),t(Os),t(et),t(L),t(st),t(P),t(tt),t(D),t(lt),t(K),t(nt),t(at),t(ee),t(it),t(rt),t(te),t(ot),t(ut),t(ne),t(pt),t(ct),t(ie),t(mt),t(re),t(dt),t(Mt),t(ue),t(yt),t(pe),t(Jt),t(Tt),t(me),t(jt),t(Ut),t(Me),t(ht),t(ft),t(Je),t(wt),t(bt),t(je),t(vt),t(gt),t(he),t(It),t(Ct),t(we),t(Zt),t(_t),t(ve),t(Wt),t(ge),t($t),t(Ie),t(qt),t(Gt),t(Ze),t(xt),t(_e),t(Bt),t(We),t(kt),t($e),t(Xt),t(zt),t(Ge),t(Vt),t(Nt),t(Be),t(Ht),t(At),t(Xe),t(Et),t(ze),t(Rt),t(Qt),t(Ne),t(Yt),t(Ft),t(St),t(Ee),t(Lt),t(Pt),t(Qe),t(Dt),t(Kt),t(Ot),t(Se),t(el),t(sl),t(tl),t(Pe),t(ll),t(nl),t(Ke),t(al),t(il),t(es),t(rl),t(ol),t(ts),t(ul),t(ls),t(pl),t(ns),t(cl),t(as),t(ml),t(is),t(dl),t(rs),t(Ml),t(os),t(yl),t(us),t(Jl),t(Tl),t(cs),t(jl),t(Ul),t(ds),t(hl),t(Ms),t(fl),t(ys),t(wl),t(Js),t(bl),t(vl),t(js),t(gl),t(Il),t(Cl),t(fs),t(Zl),t(ws),t(_l),t(Wl),t(gs)),t(J),M(w,e),M(C,e),M($,e),M(G,e),M(x,e),M(X,e),M(V,e),M(h,e),M(H,e),M(A,e),M(S,e),M(O,e),M(se,e),M(le,e),M(ae,e),M(oe,e),M(ce,e),M(de,e),M(ye,e),M(Te,e),M(Ue,e),M(fe,e),M(be,e),M(Ce,e),M(qe,e),M(xe,e),M(ke,e),M(Ve,e),M(He,e),M(Ae,e),M(Re,e),M(Ye,e),M(Fe,e),M(Le,e),M(f,e),M(De,e),M(Oe,e),M(ss,e),M(ps,e),M(ms,e),M(Ts,e),M(Us,e),M(hs,e),M(bs,e)}}}const pa='{"title":"Comment finetuner un système de reconnaissance automatique de la parole avec l’API Trainer","local":"comment-finetuner-un-système-de-reconnaissance-automatique-de-la-parole-avec-lapi-trainer","sections":[{"title":"Préparer l’environnement","local":"préparer-lenvironnement","sections":[],"depth":2},{"title":"Charger le jeu de données","local":"charger-le-jeu-de-données","sections":[],"depth":2},{"title":"Extracteur de caractéristiques, tokeniser et processeur","local":"extracteur-de-caractéristiques-tokeniser-et-processeur","sections":[],"depth":2},{"title":"Prétraitement des données","local":"prétraitement-des-données","sections":[],"depth":2},{"title":"Entraînement et évaluation","local":"entraînement-et-évaluation","sections":[{"title":"Définir un assembleur de données","local":"définir-un-assembleur-de-données","sections":[],"depth":3},{"title":"Métriques d’évaluation","local":"métriques-dévaluation","sections":[],"depth":3},{"title":"Charger un checkpoint pré-entraîné","local":"charger-un-checkpoint-pré-entraîné","sections":[],"depth":3}],"depth":2},{"title":"Définir la configuration de l’entraînement","local":"définir-la-configuration-de-lentraînement","sections":[{"title":"Entraînement","local":"entraînement","sections":[],"depth":4}],"depth":2},{"title":"Partager votre modèle","local":"partager-votre-modèle","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function ca(vs){return sa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ta extends ta{constructor(J){super(),la(this,J,ca,ua,ea,{})}}export{Ta as component};
