import{s as xl,o as Hl,n as ql}from"../chunks/scheduler.65852ee5.js";import{S as Yl,i as Xl,g as o,s,r as i,A as zl,h as m,f as l,c as a,j as _l,u as d,x as j,k as Sl,y as Fl,a as n,v as p,d as r,t as M,w as c}from"../chunks/index.aa74147d.js";import{T as Ll}from"../chunks/Tip.bb8ccac8.js";import{D as Dl,C as u}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as h,E as Pl}from"../chunks/EditOnGithub.4eda6a96.js";function Kl(_t){let g,T="You may need to email us for access to some architectures.";return{c(){g=o("p"),g.textContent=T},l(y){g=m(y,"P",{"data-svelte-h":!0}),j(g)!=="svelte-1bp4u19"&&(g.textContent=T)},m(y,Qt){n(y,g,Qt)},p:ql,d(y){y&&l(g)}}}function Ol(_t){let g,T,y,Qt,f,St,U,xt,J,il='<em>Authored by: <a href="https://huggingface.co/derek-thomas" rel="nofollow">Derek Thomas</a></em>',Ht,b,qt,I,dl="I have a dataset I want to embed for semantic search (or QA, or RAG), I want the easiest way to do embed this and put it in a new dataset.",Yt,$,Xt,A,pl='I’m using a dataset from my favorite subreddit <a href="https://www.reddit.com/r/bestofredditorupdates/" rel="nofollow">r/bestofredditorupdates</a>. Because it has long entries, I will use the new <a href="https://huggingface.co/jinaai/jina-embeddings-v2-base-en" rel="nofollow">jinaai/jina-embeddings-v2-base-en</a> since it has an 8k context length. I will deploy this using <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Inference Endpoint</a> to save time and money. To follow this tutorial, you will need to <strong>have already added a payment method</strong>. If you haven’t, you can add one here in <a href="https://huggingface.co/docs/hub/billing#billing" rel="nofollow">billing</a>. To make it even easier, I’ll make this fully API based.',zt,B,rl='To make this MUCH faster I will use the <a href="https://github.com/huggingface/text-embeddings-inference" rel="nofollow">Text Embeddings Inference</a> image. This has many benefits like:',Ft,C,Ml="<li>No model graph compilation step</li> <li>Small docker images and fast boot times. Get ready for true serverless!</li> <li>Token based dynamic batching</li> <li>Optimized transformers code for inference using Flash Attention, Candle and cuBLASLt</li> <li>Safetensors weight loading</li> <li>Production ready (distributed tracing with Open Telemetry, Prometheus metrics)</li>",Lt,G,cl='<img src="https://media.githubusercontent.com/media/huggingface/text-embeddings-inference/main/assets/bs1-tp.png" alt="img"/>',Dt,k,Pt,W,Kt,Z,Ot,R,te,E,ee,v,ol=`<code>DATASET_IN</code> is where your text data is
<code>DATASET_OUT</code> is where your embeddings will be stored`,le,N,ml="Note I used 5 for the <code>MAX_WORKERS</code> since <code>jina-embeddings-v2</code> are quite memory hungry.",ne,Q,se,V,jl='Inference Endpoints offers a number of GPUs that you can choose from. Check the <a href="https://huggingface.co/docs/inference-endpoints/en/pricing#gpu-instances" rel="nofollow">documentation</a> for GPU and alternative accelerators for information.',ae,w,ie,_,ul='<thead><tr><th align="center">Provider</th> <th align="center">Instance Type</th> <th align="center">Instance Size</th> <th align="center">Hourly rate</th> <th align="center">GPUs</th> <th align="center">Memory</th> <th align="center">Architecture</th></tr></thead> <tbody><tr><td align="center">aws</td> <td align="center">nvidia-a10g</td> <td align="center">x1</td> <td align="center">$1</td> <td align="center">1</td> <td align="center">24GB</td> <td align="center">NVIDIA A10G</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-t4</td> <td align="center">x1</td> <td align="center">$0.5</td> <td align="center">1</td> <td align="center">14GB</td> <td align="center">NVIDIA T4</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-t4</td> <td align="center">x4</td> <td align="center">$3</td> <td align="center">4</td> <td align="center">56GB</td> <td align="center">NVIDIA T4</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-l4</td> <td align="center">x1</td> <td align="center">$0.8</td> <td align="center">1</td> <td align="center">24GB</td> <td align="center">NVIDIA L4</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-l4</td> <td align="center">x4</td> <td align="center">$3.8</td> <td align="center">4</td> <td align="center">96GB</td> <td align="center">NVIDIA L4</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-a100</td> <td align="center">x1</td> <td align="center">$4</td> <td align="center">1</td> <td align="center">80GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-a10g</td> <td align="center">x4</td> <td align="center">$5</td> <td align="center">4</td> <td align="center">96GB</td> <td align="center">NVIDIA A10G</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-a100</td> <td align="center">x2</td> <td align="center">$8</td> <td align="center">2</td> <td align="center">160GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-a100</td> <td align="center">x4</td> <td align="center">$16</td> <td align="center">4</td> <td align="center">320GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">aws</td> <td align="center">nvidia-a100</td> <td align="center">x8</td> <td align="center">$32</td> <td align="center">8</td> <td align="center">640GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-t4</td> <td align="center">x1</td> <td align="center">$0.5</td> <td align="center">1</td> <td align="center">16GB</td> <td align="center">NVIDIA T4</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-l4</td> <td align="center">x1</td> <td align="center">$1</td> <td align="center">1</td> <td align="center">24GB</td> <td align="center">NVIDIA L4</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-l4</td> <td align="center">x4</td> <td align="center">$5</td> <td align="center">4</td> <td align="center">96GB</td> <td align="center">NVIDIA L4</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-a100</td> <td align="center">x1</td> <td align="center">$6</td> <td align="center">1</td> <td align="center">80 GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-a100</td> <td align="center">x2</td> <td align="center">$12</td> <td align="center">2</td> <td align="center">160 GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-a100</td> <td align="center">x4</td> <td align="center">$24</td> <td align="center">4</td> <td align="center">320 GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-a100</td> <td align="center">x8</td> <td align="center">$48</td> <td align="center">8</td> <td align="center">640 GB</td> <td align="center">NVIDIA A100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-h100</td> <td align="center">x1</td> <td align="center">$12.5</td> <td align="center">1</td> <td align="center">80 GB</td> <td align="center">NVIDIA H100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-h100</td> <td align="center">x2</td> <td align="center">$25</td> <td align="center">2</td> <td align="center">160 GB</td> <td align="center">NVIDIA H100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-h100</td> <td align="center">x4</td> <td align="center">$50</td> <td align="center">4</td> <td align="center">320 GB</td> <td align="center">NVIDIA H100</td></tr> <tr><td align="center">gcp</td> <td align="center">nvidia-h100</td> <td align="center">x8</td> <td align="center">$100</td> <td align="center">8</td> <td align="center">640 GB</td> <td align="center">NVIDIA H100</td></tr> <tr><td align="center">aws</td> <td align="center">inf2</td> <td align="center">x1</td> <td align="center">$0.75</td> <td align="center">1</td> <td align="center">32GB</td> <td align="center">AWS Inferentia2</td></tr> <tr><td align="center">aws</td> <td align="center">inf2</td> <td align="center">x12</td> <td align="center">$12</td> <td align="center">12</td> <td align="center">384GB</td> <td align="center">AWS Inferentia2</td></tr></tbody>',de,S,pe,x,re,H,gl="Some users might have payment registered in an organization. This allows you to connect to an organization (that you are a member of) with a payment method.",Me,q,hl="Leave it blank is you want to use your username.",ce,Y,oe,X,me,z,je,F,ue,L,ge,D,he,P,yl='We are going to use the <a href="https://huggingface.co/docs/inference-endpoints/api_reference" rel="nofollow">API</a> to create an <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Inference Endpoint</a>. This should provide a few main benefits:',ye,K,wl="<li>It’s convenient (No clicking)</li> <li>It’s repeatable (We have the code to run it easily)</li> <li>It’s cheaper (No time spent waiting for it to load, and automatically shut it down)</li>",we,O,Te,tt,Tl="There are a few design choices here:",fe,et,fl='<li>As discussed before we are using <code>jinaai/jina-embeddings-v2-base-en</code> as our model. <ul><li>For reproducibility we are pinning it to a specific revision.</li></ul></li> <li>If you are interested in more models, check out the supported list <a href="https://huggingface.co/docs/text-embeddings-inference/supported_models" rel="nofollow">here</a>. <ul><li>Note that most embedding models are based on the BERT architecture.</li></ul></li> <li><code>MAX_BATCH_TOKENS</code> is chosen based on our number of workers and the context window of our embedding model.</li> <li><code>type=&quot;protected&quot;</code> utilized the security from Inference Endpoints detailed here.</li> <li>I’m using <strong>1x Nvidia A10</strong> since <code>jina-embeddings-v2</code> is memory hungry (remember the 8k context length).</li> <li>You should consider further tuning <code>MAX_BATCH_TOKENS</code> and <code>MAX_CONCURRENT_REQUESTS</code> if you have high workloads</li>',Ue,lt,Je,nt,be,st,Ul=`CPU times: user 48.1 ms, sys: 15.7 ms, total: 63.8 ms
Wall time: 52.6 s
`,Ie,at,Jl="When we use <code>endpoint.client.post</code> we get a bytes string back. This is a little tedious because we need to convert this to an <code>np.array</code>, but it’s just a couple quick lines in python.",$e,it,Ae,dt,bl="You may have inputs that exceed the context. In such scenarios, it’s up to you to handle them. In my case, I’d like to truncate rather than have an error. Let’s test that it works.",Be,pt,Ce,rt,Il=`The length of the embedding_input is: 300000
`,Ge,Mt,ke,ct,$l="Here I send a document, update it with the embedding, and return it. This happens in parallel with <code>MAX_WORKERS</code>.",We,ot,Ze,mt,Re,jt,Al=`Embeddings = 100 documents = 100
0 min 21.33 sec
`,Ee,ut,ve,gt,Bl="Now that we have finished, let’s pause the endpoint so we don’t incur any extra charges, this will also allow us to analyze the cost.",Ne,ht,Qe,yt,Cl=`Endpoint Status: paused
`,Ve,wt,_e,Tt,Gl="We now have our documents updated with the embeddings we wanted. First we need to convert it back to a <code>Dataset</code> format. I find it easiest to go from list of dicts -&gt; <code>pd.DataFrame</code> -&gt; <code>Dataset</code>",Se,ft,xe,Ut,kl="I’m uploading it to the user’s account by default (as opposed to uploading to an organization) but feel free to push to wherever you want by setting the user in the <code>repo_id</code> or in the config by setting <code>DATASET_OUT</code>",He,Jt,qe,bt,Ye,It,Wl=`Dataset is at https://huggingface.co/datasets/derek-thomas/processed-subset-bestofredditorupdates
`,Xe,$t,ze,At,Zl="<li>Go to your <code>dashboard_url</code> printed below</li> <li>Click on the Usage &amp; Cost tab</li> <li>See how much you have spent</li>",Fe,Bt,Le,Ct,Rl=`https://ui.endpoints.huggingface.co/HF-test-lab/endpoints/boru-jina-embeddings-demo-ie
`,De,Gt,Pe,kt,El="We can see that it only took <code>$0.04</code> to pay for this!",Ke,Wt,Oe,Zt,vl="Now that we are done, we don’t need our endpoint anymore. We can delete our endpoint programmatically.",tl,Rt,Nl='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/automatic_embedding_tei_inference_endpoints.png" alt="Cost"/>',el,Et,ll,vt,Ql=`Endpoint deleted successfully
`,nl,Nt,sl,Vt,al;return f=new Dl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/patch-1/notebooks/en/automatic_embedding_tei_inference_endpoints.ipynb"}]}}),U=new h({props:{title:"How to use Inference Endpoints to Embed Documents",local:"how-to-use-inference-endpoints-to-embed-documents",headingTag:"h1"}}),b=new h({props:{title:"Goal",local:"goal",headingTag:"h2"}}),$=new h({props:{title:"Approach",local:"approach",headingTag:"h2"}}),k=new h({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),W=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGFpb2h0dHAlM0QlM0QzLjguMyUyMGRhdGFzZXRzJTNEJTNEMi4xNC42JTIwcGFuZGFzJTNEJTNEMS41LjMlMjByZXF1ZXN0cyUzRCUzRDIuMzEuMCUyMHRxZG0lM0QlM0Q0LjY2LjElMjBodWdnaW5nZmFjZS1odWIlM0UlM0QwLjIw",highlighted:'!pip install -q aiohttp==<span class="hljs-number">3.8</span><span class="hljs-number">.3</span> datasets==<span class="hljs-number">2.14</span><span class="hljs-number">.6</span> pandas==<span class="hljs-number">1.5</span><span class="hljs-number">.3</span> requests==<span class="hljs-number">2.31</span><span class="hljs-number">.0</span> tqdm==<span class="hljs-number">4.66</span><span class="hljs-number">.1</span> huggingface-hub&gt;=<span class="hljs-number">0.20</span>',wrap:!1}}),Z=new h({props:{title:"Imports",local:"imports",headingTag:"h2"}}),R=new u({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBnZXRwYXNzJTIwaW1wb3J0JTIwZ2V0cGFzcyUwQWltcG9ydCUyMGpzb24lMEFmcm9tJTIwcGF0aGxpYiUyMGltcG9ydCUyMFBhdGglMEFpbXBvcnQlMjB0aW1lJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyME9wdGlvbmFsJTBBJTBBZnJvbSUyMGFpb2h0dHAlMjBpbXBvcnQlMjBDbGllbnRTZXNzaW9uJTJDJTIwQ2xpZW50VGltZW91dCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUyQyUyMERhdGFzZXQlMkMlMjBEYXRhc2V0RGljdCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBub3RlYm9va19sb2dpbiUyQyUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMkMlMjBsaXN0X2luZmVyZW5jZV9lbmRwb2ludHMlMkMlMjB3aG9hbWklMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHFkbS5hdXRvJTIwaW1wb3J0JTIwdHFkbQ==",highlighted:`<span class="hljs-keyword">import</span> asyncio
<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">from</span> aiohttp <span class="hljs-keyword">import</span> ClientSession, ClientTimeout
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Dataset, DatasetDict
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login, create_inference_endpoint, list_inference_endpoints, whoami
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm`,wrap:!1}}),E=new h({props:{title:"Config",local:"config",headingTag:"h2"}}),Q=new u({props:{code:"REFUQVNFVF9JTiUyMCUzRCUyMCUyMmRlcmVrLXRob21hcyUyRmRhdGFzZXQtY3JlYXRvci1yZWRkaXQtYmVzdG9mcmVkZGl0b3J1cGRhdGVzJTIyJTBBREFUQVNFVF9PVVQlMjAlM0QlMjAlMjJwcm9jZXNzZWQtc3Vic2V0LWJlc3RvZnJlZGRpdG9ydXBkYXRlcyUyMiUwQUVORFBPSU5UX05BTUUlMjAlM0QlMjAlMjJib3J1LWppbmEtZW1iZWRkaW5ncy1kZW1vLWllJTIyJTBBJTBBTUFYX1dPUktFUlMlMjAlM0QlMjA1JTIwJTIwJTIzJTIwVGhpcyUyMGlzJTIwZm9yJTIwaG93JTIwbWFueSUyMGFzeW5jJTIwd29ya2VycyUyMHlvdSUyMHdhbnQuJTIwQ2hvb3NlJTIwYmFzZWQlMjBvbiUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwaGFyZHdhcmUlMEFST1dfQ09VTlQlMjAlM0QlMjAxMDAlMjAlMjAlMjMlMjBDaG9vc2UlMjBOb25lJTIwdG8lMjB1c2UlMjBhbGwlMjByb3dzJTJDJTIwSW0lMjB1c2luZyUyMDEwMCUyMGp1c3QlMjBmb3IlMjBhJTIwZGVtbw==",highlighted:`DATASET_IN = <span class="hljs-string">&quot;derek-thomas/dataset-creator-reddit-bestofredditorupdates&quot;</span>
DATASET_OUT = <span class="hljs-string">&quot;processed-subset-bestofredditorupdates&quot;</span>
ENDPOINT_NAME = <span class="hljs-string">&quot;boru-jina-embeddings-demo-ie&quot;</span>

MAX_WORKERS = <span class="hljs-number">5</span>  <span class="hljs-comment"># This is for how many async workers you want. Choose based on the model and hardware</span>
ROW_COUNT = <span class="hljs-number">100</span>  <span class="hljs-comment"># Choose None to use all rows, Im using 100 just for a demo</span>`,wrap:!1}}),w=new Ll({props:{warning:!1,$$slots:{default:[Kl]},$$scope:{ctx:_t}}}),S=new u({props:{code:"JTIzJTIwR1BVJTIwQ2hvaWNlJTBBVkVORE9SJTIwJTNEJTIwJTIyYXdzJTIyJTBBUkVHSU9OJTIwJTNEJTIwJTIydXMtZWFzdC0xJTIyJTBBSU5TVEFOQ0VfU0laRSUyMCUzRCUyMCUyMngxJTIyJTBBSU5TVEFOQ0VfVFlQRSUyMCUzRCUyMCUyMm52aWRpYS1hMTBnJTIy",highlighted:`<span class="hljs-comment"># GPU Choice</span>
VENDOR = <span class="hljs-string">&quot;aws&quot;</span>
REGION = <span class="hljs-string">&quot;us-east-1&quot;</span>
INSTANCE_SIZE = <span class="hljs-string">&quot;x1&quot;</span>
INSTANCE_TYPE = <span class="hljs-string">&quot;nvidia-a10g&quot;</span>`,wrap:!1}}),x=new u({props:{code:"bm90ZWJvb2tfbG9naW4oKQ==",highlighted:"notebook_login()",wrap:!1}}),Y=new u({props:{code:"d2hvJTIwJTNEJTIwd2hvYW1pKCklMEFvcmdhbml6YXRpb24lMjAlM0QlMjBnZXRwYXNzKHByb21wdCUzRCUyMldoYXQlMjBpcyUyMHlvdXIlMjBIdWdnaW5nJTIwRmFjZSUyMCVGMCU5RiVBNCU5NyUyMHVzZXJuYW1lJTIwb3IlMjBvcmdhbml6YXRpb24lM0YlMjAod2l0aCUyMGFuJTIwYWRkZWQlMjBwYXltZW50JTIwbWV0aG9kKSUyMiklMEElMEFuYW1lc3BhY2UlMjAlM0QlMjBvcmdhbml6YXRpb24lMjBvciUyMHdobyU1QiUyMm5hbWUlMjIlNUQ=",highlighted:`who = whoami()
organization = getpass(prompt=<span class="hljs-string">&quot;What is your Hugging Face 🤗 username or organization? (with an added payment method)&quot;</span>)

namespace = organization <span class="hljs-keyword">or</span> who[<span class="hljs-string">&quot;name&quot;</span>]`,wrap:!1}}),X=new h({props:{title:"Get Dataset",local:"get-dataset",headingTag:"h2"}}),z=new u({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldChEQVRBU0VUX0lOKSUwQWRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RA==",highlighted:`dataset = load_dataset(DATASET_IN)
dataset[<span class="hljs-string">&quot;train&quot;</span>]`,wrap:!1}}),F=new u({props:{code:"ZG9jdW1lbnRzJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRyYWluJTIyJTVELnRvX3BhbmRhcygpLnRvX2RpY3QoJTIycmVjb3JkcyUyMiklNUIlM0FST1dfQ09VTlQlNUQlMEFsZW4oZG9jdW1lbnRzKSUyQyUyMGRvY3VtZW50cyU1QjAlNUQ=",highlighted:`documents = dataset[<span class="hljs-string">&quot;train&quot;</span>].to_pandas().to_dict(<span class="hljs-string">&quot;records&quot;</span>)[:ROW_COUNT]
<span class="hljs-built_in">len</span>(documents), documents[<span class="hljs-number">0</span>]`,wrap:!1}}),L=new h({props:{title:"Inference Endpoints",local:"inference-endpoints",headingTag:"h1"}}),D=new h({props:{title:"Create Inference Endpoint",local:"create-inference-endpoint",headingTag:"h2"}}),O=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">try</span>:
    endpoint = create_inference_endpoint(
        ENDPOINT_NAME,
        repository=<span class="hljs-string">&quot;jinaai/jina-embeddings-v2-base-en&quot;</span>,
        revision=<span class="hljs-string">&quot;7302ac470bed880590f9344bfeee32ff8722d0e5&quot;</span>,
        task=<span class="hljs-string">&quot;sentence-embeddings&quot;</span>,
        framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
        accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
        instance_size=INSTANCE_SIZE,
        instance_type=INSTANCE_TYPE,
        region=REGION,
        vendor=VENDOR,
        namespace=namespace,
        custom_image={
            <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
            <span class="hljs-string">&quot;env&quot;</span>: {
                <span class="hljs-string">&quot;MAX_BATCH_TOKENS&quot;</span>: <span class="hljs-built_in">str</span>(MAX_WORKERS * <span class="hljs-number">2048</span>),
                <span class="hljs-string">&quot;MAX_CONCURRENT_REQUESTS&quot;</span>: <span class="hljs-string">&quot;512&quot;</span>,
                <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>,
            },
            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-embeddings-inference:0.5.0&quot;</span>,
        },
        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
    )
<span class="hljs-keyword">except</span>:
    endpoint = [ie <span class="hljs-keyword">for</span> ie <span class="hljs-keyword">in</span> list_inference_endpoints(namespace=namespace) <span class="hljs-keyword">if</span> ie.name == ENDPOINT_NAME][<span class="hljs-number">0</span>]
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loaded endpoint&quot;</span>)`,wrap:!1}}),lt=new h({props:{title:"Wait until it’s running",local:"wait-until-its-running",headingTag:"h2"}}),nt=new u({props:{code:"JTI1JTI1dGltZSUwQWVuZHBvaW50LndhaXQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>%%time
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()`,wrap:!1}}),it=new u({props:{code:"cmVzcG9uc2UlMjAlM0QlMjBlbmRwb2ludC5jbGllbnQucG9zdCglMEElMjAlMjAlMjAlMjBqc29uJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzZW5lcnklMjBpbiUyMHlvdXIlMjBtaW5kJTIwc28lMjB3ZWxsJTIwSSUyMHdvdWxkJTIwcmVjb21lbmQlMjBpdCUyMGV2ZW4lMjB0byUyMHBlb3BsZSUyMHdobyUyMGhhdGUlMjB2aWQuJTIwZ2FtZSUyMG11c2ljISUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRydW5jYXRlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMEEpJTBBcmVzcG9uc2UlMjAlM0QlMjBucC5hcnJheShqc29uLmxvYWRzKHJlc3BvbnNlLmRlY29kZSgpKSklMEFyZXNwb25zZSU1QjAlNUQlNUIlM0EyMCU1RA==",highlighted:`response = endpoint.client.post(
    json={
        <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;This sound track was beautiful! It paints the senery in your mind so well I would recomend it even to people who hate vid. game music!&quot;</span>,
        <span class="hljs-string">&quot;truncate&quot;</span>: <span class="hljs-literal">True</span>,
    },
    task=<span class="hljs-string">&quot;feature-extraction&quot;</span>,
)
response = np.array(json.loads(response.decode()))
response[<span class="hljs-number">0</span>][:<span class="hljs-number">20</span>]`,wrap:!1}}),pt=new u({props:{code:"ZW1iZWRkaW5nX2lucHV0JTIwJTNEJTIwJTIyVGhpcyUyMGlucHV0JTIwd2lsbCUyMGdldCUyMG11bHRpcGxpZWQlMjIlMjAqJTIwMTAwMDAlMEFwcmludChmJTIyVGhlJTIwbGVuZ3RoJTIwb2YlMjB0aGUlMjBlbWJlZGRpbmdfaW5wdXQlMjBpcyUzQSUyMCU3QmxlbihlbWJlZGRpbmdfaW5wdXQpJTdEJTIyKSUwQXJlc3BvbnNlJTIwJTNEJTIwZW5kcG9pbnQuY2xpZW50LnBvc3QoanNvbiUzRCU3QiUyMmlucHV0cyUyMiUzQSUyMGVtYmVkZGluZ19pbnB1dCUyQyUyMCUyMnRydW5jYXRlJTIyJTNBJTIwVHJ1ZSU3RCUyQyUyMHRhc2slM0QlMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIpJTBBcmVzcG9uc2UlMjAlM0QlMjBucC5hcnJheShqc29uLmxvYWRzKHJlc3BvbnNlLmRlY29kZSgpKSklMEFyZXNwb25zZSU1QjAlNUQlNUIlM0EyMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>embedding_input = <span class="hljs-string">&quot;This input will get multiplied&quot;</span> * <span class="hljs-number">10000</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;The length of the embedding_input is: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(embedding_input)}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = endpoint.client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: embedding_input, <span class="hljs-string">&quot;truncate&quot;</span>: <span class="hljs-literal">True</span>}, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = np.array(json.loads(response.decode()))
<span class="hljs-meta">&gt;&gt;&gt; </span>response[<span class="hljs-number">0</span>][:<span class="hljs-number">20</span>]`,wrap:!1}}),Mt=new h({props:{title:"Get Embeddings",local:"get-embeddings",headingTag:"h1"}}),ot=new u({props:{code:"YXN5bmMlMjBkZWYlMjByZXF1ZXN0KGRvY3VtZW50JTJDJTIwc2VtYXBob3JlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFNlbWFwaG9yZSUyMGd1YXJkJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjB3aXRoJTIwc2VtYXBob3JlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBlbmRwb2ludC5hc3luY19jbGllbnQucG9zdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwZG9jdW1lbnQlNUIlMjJjb250ZW50JTIyJTVEJTJDJTIwJTIydHJ1bmNhdGUlMjIlM0ElMjBUcnVlJTdEJTJDJTIwdGFzayUzRCUyMmZlYXR1cmUtZXh0cmFjdGlvbiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjBucC5hcnJheShqc29uLmxvYWRzKHJlc3VsdC5kZWNvZGUoKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9jdW1lbnQlNUIlMjJlbWJlZGRpbmclMjIlNUQlMjAlM0QlMjByZXN1bHQlNUIwJTVEJTIwJTIwJTIzJTIwQXNzdW1pbmclMjB0aGUlMjBBUEkncyUyMG91dHB1dCUyMGNhbiUyMGJlJTIwZGlyZWN0bHklMjBhc3NpZ25lZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGRvY3VtZW50JTBBJTBBJTBBYXN5bmMlMjBkZWYlMjBtYWluKGRvY3VtZW50cyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBTZW1hcGhvcmUlMjB0byUyMGxpbWl0JTIwY29uY3VycmVudCUyMHJlcXVlc3RzLiUyMEFkanVzdCUyMHRoZSUyMG51bWJlciUyMGFzJTIwbmVlZGVkLiUwQSUyMCUyMCUyMCUyMHNlbWFwaG9yZSUyMCUzRCUyMGFzeW5jaW8uQm91bmRlZFNlbWFwaG9yZShNQVhfV09SS0VSUyklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBDcmVhdGluZyUyMGElMjBsaXN0JTIwb2YlMjB0YXNrcyUwQSUyMCUyMCUyMCUyMHRhc2tzJTIwJTNEJTIwJTVCcmVxdWVzdChkb2N1bWVudCUyQyUyMHNlbWFwaG9yZSklMjBmb3IlMjBkb2N1bWVudCUyMGluJTIwZG9jdW1lbnRzJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXNpbmclMjB0cWRtJTIwdG8lMjBzaG93JTIwcHJvZ3Jlc3MuJTIwSXQncyUyMGJlZW4lMjBpbnRlZ3JhdGVkJTIwaW50byUyMHRoZSUyMGFzeW5jJTIwbG9vcC4lMEElMjAlMjAlMjAlMjBmb3IlMjBmJTIwaW4lMjB0cWRtKGFzeW5jaW8uYXNfY29tcGxldGVkKHRhc2tzKSUyQyUyMHRvdGFsJTNEbGVuKGRvY3VtZW50cykpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXdhaXQlMjBm",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">request</span>(<span class="hljs-params">document, semaphore</span>):
    <span class="hljs-comment"># Semaphore guard</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">with</span> semaphore:
        result = <span class="hljs-keyword">await</span> endpoint.async_client.post(
            json={<span class="hljs-string">&quot;inputs&quot;</span>: document[<span class="hljs-string">&quot;content&quot;</span>], <span class="hljs-string">&quot;truncate&quot;</span>: <span class="hljs-literal">True</span>}, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>
        )
        result = np.array(json.loads(result.decode()))
        document[<span class="hljs-string">&quot;embedding&quot;</span>] = result[<span class="hljs-number">0</span>]  <span class="hljs-comment"># Assuming the API&#x27;s output can be directly assigned</span>
        <span class="hljs-keyword">return</span> document


<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>(<span class="hljs-params">documents</span>):
    <span class="hljs-comment"># Semaphore to limit concurrent requests. Adjust the number as needed.</span>
    semaphore = asyncio.BoundedSemaphore(MAX_WORKERS)

    <span class="hljs-comment"># Creating a list of tasks</span>
    tasks = [request(document, semaphore) <span class="hljs-keyword">for</span> document <span class="hljs-keyword">in</span> documents]

    <span class="hljs-comment"># Using tqdm to show progress. It&#x27;s been integrated into the async loop.</span>
    <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> tqdm(asyncio.as_completed(tasks), total=<span class="hljs-built_in">len</span>(documents)):
        <span class="hljs-keyword">await</span> f`,wrap:!1}}),mt=new u({props:{code:"c3RhcnQlMjAlM0QlMjB0aW1lLnBlcmZfY291bnRlcigpJTBBJTBBJTIzJTIwR2V0JTIwZW1iZWRkaW5ncyUwQWF3YWl0JTIwbWFpbihkb2N1bWVudHMpJTBBJTBBJTIzJTIwTWFrZSUyMHN1cmUlMjB3ZSUyMGdvdCUyMGl0JTIwYWxsJTBBY291bnQlMjAlM0QlMjAwJTBBZm9yJTIwZG9jdW1lbnQlMjBpbiUyMGRvY3VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwJTIyZW1iZWRkaW5nJTIyJTIwaW4lMjBkb2N1bWVudC5rZXlzKCklMjBhbmQlMjBsZW4oZG9jdW1lbnQlNUIlMjJlbWJlZGRpbmclMjIlNUQpJTIwJTNEJTNEJTIwNzY4JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY291bnQlMjAlMkIlM0QlMjAxJTBBcHJpbnQoZiUyMkVtYmVkZGluZ3MlMjAlM0QlMjAlN0Jjb3VudCU3RCUyMGRvY3VtZW50cyUyMCUzRCUyMCU3Qmxlbihkb2N1bWVudHMpJTdEJTIyKSUwQSUwQSUwQSUyMyUyMFByaW50JTIwZWxhcHNlZCUyMHRpbWUlMEFlbGFwc2VkX3RpbWUlMjAlM0QlMjB0aW1lLnBlcmZfY291bnRlcigpJTIwLSUyMHN0YXJ0JTBBbWludXRlcyUyQyUyMHNlY29uZHMlMjAlM0QlMjBkaXZtb2QoZWxhcHNlZF90aW1lJTJDJTIwNjApJTBBcHJpbnQoZiUyMiU3QmludChtaW51dGVzKSU3RCUyMG1pbiUyMCU3QnNlY29uZHMlM0EuMmYlN0QlMjBzZWMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>start = time.perf_counter()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get embeddings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> main(documents)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Make sure we got it all</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>count = <span class="hljs-number">0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> document <span class="hljs-keyword">in</span> documents:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;embedding&quot;</span> <span class="hljs-keyword">in</span> document.keys() <span class="hljs-keyword">and</span> <span class="hljs-built_in">len</span>(document[<span class="hljs-string">&quot;embedding&quot;</span>]) == <span class="hljs-number">768</span>:
<span class="hljs-meta">... </span>        count += <span class="hljs-number">1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Embeddings = <span class="hljs-subst">{count}</span> documents = <span class="hljs-subst">{<span class="hljs-built_in">len</span>(documents)}</span>&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print elapsed time</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>elapsed_time = time.perf_counter() - start
<span class="hljs-meta">&gt;&gt;&gt; </span>minutes, seconds = <span class="hljs-built_in">divmod</span>(elapsed_time, <span class="hljs-number">60</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">int</span>(minutes)}</span> min <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> sec&quot;</span>)`,wrap:!1}}),ut=new h({props:{title:"Pause Inference Endpoint",local:"pause-inference-endpoint",headingTag:"h2"}}),ht=new u({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBlbmRwb2ludC5wYXVzZSgpJTBBJTBBcHJpbnQoZiUyMkVuZHBvaW50JTIwU3RhdHVzJTNBJTIwJTdCZW5kcG9pbnQuc3RhdHVzJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = endpoint.pause()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Endpoint Status: <span class="hljs-subst">{endpoint.status}</span>&quot;</span>)`,wrap:!1}}),wt=new h({props:{title:"Push updated dataset to Hub",local:"push-updated-dataset-to-hub",headingTag:"h1"}}),ft=new u({props:{code:"ZGYlMjAlM0QlMjBwZC5EYXRhRnJhbWUoZG9jdW1lbnRzKSUwQWRkJTIwJTNEJTIwRGF0YXNldERpY3QoJTdCJTIydHJhaW4lMjIlM0ElMjBEYXRhc2V0LmZyb21fcGFuZGFzKGRmKSU3RCk=",highlighted:`df = pd.DataFrame(documents)
dd = DatasetDict({<span class="hljs-string">&quot;train&quot;</span>: Dataset.from_pandas(df)})`,wrap:!1}}),Jt=new u({props:{code:"ZGQucHVzaF90b19odWIocmVwb19pZCUzRERBVEFTRVRfT1VUKQ==",highlighted:"dd.push_to_hub(repo_id=DATASET_OUT)",wrap:!1}}),bt=new u({props:{code:"cHJpbnQoZidEYXRhc2V0JTIwaXMlMjBhdCUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRiU3QndobyU1QiUyMm5hbWUlMjIlNUQlN0QlMkYlN0JEQVRBU0VUX09VVCU3RCcp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Dataset is at https://huggingface.co/datasets/<span class="hljs-subst">{who[<span class="hljs-string">&quot;name&quot;</span>]}</span>/<span class="hljs-subst">{DATASET_OUT}</span>&#x27;</span>)',wrap:!1}}),$t=new h({props:{title:"Analyze Usage",local:"analyze-usage",headingTag:"h1"}}),Bt=new u({props:{code:"ZGFzaGJvYXJkX3VybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRnVpLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbyUyRiU3Qm5hbWVzcGFjZSU3RCUyRmVuZHBvaW50cyUyRiU3QkVORFBPSU5UX05BTUUlN0QlMjIlMEFwcmludChkYXNoYm9hcmRfdXJsKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dashboard_url = <span class="hljs-string">f&quot;https://ui.endpoints.huggingface.co/<span class="hljs-subst">{namespace}</span>/endpoints/<span class="hljs-subst">{ENDPOINT_NAME}</span>&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dashboard_url)`,wrap:!1}}),Gt=new u({props:{code:"aW5wdXQoJTIySGl0JTIwZW50ZXIlMjB0byUyMGNvbnRpbnVlJTIwd2l0aCUyMHRoZSUyMG5vdGVib29rJTIyKQ==",highlighted:'<span class="hljs-built_in">input</span>(<span class="hljs-string">&quot;Hit enter to continue with the notebook&quot;</span>)',wrap:!1}}),Wt=new h({props:{title:"Delete Endpoint",local:"delete-endpoint",headingTag:"h1"}}),Et=new u({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBlbmRwb2ludC5kZWxldGUoKSUwQSUwQWlmJTIwbm90JTIwZW5kcG9pbnQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJFbmRwb2ludCUyMGRlbGV0ZWQlMjBzdWNjZXNzZnVsbHklMjIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkRlbGV0ZSUyMEVuZHBvaW50JTIwaW4lMjBtYW51YWxseSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = endpoint.delete()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> endpoint:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Endpoint deleted successfully&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Delete Endpoint in manually&quot;</span>)`,wrap:!1}}),Nt=new Pl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/automatic_embedding_tei_inference_endpoints.md"}}),{c(){g=o("meta"),T=s(),y=o("p"),Qt=s(),i(f.$$.fragment),St=s(),i(U.$$.fragment),xt=s(),J=o("p"),J.innerHTML=il,Ht=s(),i(b.$$.fragment),qt=s(),I=o("p"),I.textContent=dl,Yt=s(),i($.$$.fragment),Xt=s(),A=o("p"),A.innerHTML=pl,zt=s(),B=o("p"),B.innerHTML=rl,Ft=s(),C=o("ul"),C.innerHTML=Ml,Lt=s(),G=o("p"),G.innerHTML=cl,Dt=s(),i(k.$$.fragment),Pt=s(),i(W.$$.fragment),Kt=s(),i(Z.$$.fragment),Ot=s(),i(R.$$.fragment),te=s(),i(E.$$.fragment),ee=s(),v=o("p"),v.innerHTML=ol,le=s(),N=o("p"),N.innerHTML=ml,ne=s(),i(Q.$$.fragment),se=s(),V=o("p"),V.innerHTML=jl,ae=s(),i(w.$$.fragment),ie=s(),_=o("table"),_.innerHTML=ul,de=s(),i(S.$$.fragment),pe=s(),i(x.$$.fragment),re=s(),H=o("p"),H.textContent=gl,Me=s(),q=o("p"),q.textContent=hl,ce=s(),i(Y.$$.fragment),oe=s(),i(X.$$.fragment),me=s(),i(z.$$.fragment),je=s(),i(F.$$.fragment),ue=s(),i(L.$$.fragment),ge=s(),i(D.$$.fragment),he=s(),P=o("p"),P.innerHTML=yl,ye=s(),K=o("ul"),K.innerHTML=wl,we=s(),i(O.$$.fragment),Te=s(),tt=o("p"),tt.textContent=Tl,fe=s(),et=o("ul"),et.innerHTML=fl,Ue=s(),i(lt.$$.fragment),Je=s(),i(nt.$$.fragment),be=s(),st=o("pre"),st.textContent=Ul,Ie=s(),at=o("p"),at.innerHTML=Jl,$e=s(),i(it.$$.fragment),Ae=s(),dt=o("p"),dt.textContent=bl,Be=s(),i(pt.$$.fragment),Ce=s(),rt=o("pre"),rt.textContent=Il,Ge=s(),i(Mt.$$.fragment),ke=s(),ct=o("p"),ct.innerHTML=$l,We=s(),i(ot.$$.fragment),Ze=s(),i(mt.$$.fragment),Re=s(),jt=o("pre"),jt.textContent=Al,Ee=s(),i(ut.$$.fragment),ve=s(),gt=o("p"),gt.textContent=Bl,Ne=s(),i(ht.$$.fragment),Qe=s(),yt=o("pre"),yt.textContent=Cl,Ve=s(),i(wt.$$.fragment),_e=s(),Tt=o("p"),Tt.innerHTML=Gl,Se=s(),i(ft.$$.fragment),xe=s(),Ut=o("p"),Ut.innerHTML=kl,He=s(),i(Jt.$$.fragment),qe=s(),i(bt.$$.fragment),Ye=s(),It=o("pre"),It.textContent=Wl,Xe=s(),i($t.$$.fragment),ze=s(),At=o("ol"),At.innerHTML=Zl,Fe=s(),i(Bt.$$.fragment),Le=s(),Ct=o("pre"),Ct.textContent=Rl,De=s(),i(Gt.$$.fragment),Pe=s(),kt=o("p"),kt.innerHTML=El,Ke=s(),i(Wt.$$.fragment),Oe=s(),Zt=o("p"),Zt.textContent=vl,tl=s(),Rt=o("p"),Rt.innerHTML=Nl,el=s(),i(Et.$$.fragment),ll=s(),vt=o("pre"),vt.textContent=Ql,nl=s(),i(Nt.$$.fragment),sl=s(),Vt=o("p"),this.h()},l(t){const e=zl("svelte-u9bgzb",document.head);g=m(e,"META",{name:!0,content:!0}),e.forEach(l),T=a(t),y=m(t,"P",{}),_l(y).forEach(l),Qt=a(t),d(f.$$.fragment,t),St=a(t),d(U.$$.fragment,t),xt=a(t),J=m(t,"P",{"data-svelte-h":!0}),j(J)!=="svelte-kkdsiw"&&(J.innerHTML=il),Ht=a(t),d(b.$$.fragment,t),qt=a(t),I=m(t,"P",{"data-svelte-h":!0}),j(I)!=="svelte-1qwdsg4"&&(I.textContent=dl),Yt=a(t),d($.$$.fragment,t),Xt=a(t),A=m(t,"P",{"data-svelte-h":!0}),j(A)!=="svelte-cznpu6"&&(A.innerHTML=pl),zt=a(t),B=m(t,"P",{"data-svelte-h":!0}),j(B)!=="svelte-1bpd7g5"&&(B.innerHTML=rl),Ft=a(t),C=m(t,"UL",{"data-svelte-h":!0}),j(C)!=="svelte-amjqu"&&(C.innerHTML=Ml),Lt=a(t),G=m(t,"P",{"data-svelte-h":!0}),j(G)!=="svelte-12ly3c2"&&(G.innerHTML=cl),Dt=a(t),d(k.$$.fragment,t),Pt=a(t),d(W.$$.fragment,t),Kt=a(t),d(Z.$$.fragment,t),Ot=a(t),d(R.$$.fragment,t),te=a(t),d(E.$$.fragment,t),ee=a(t),v=m(t,"P",{"data-svelte-h":!0}),j(v)!=="svelte-roo1xs"&&(v.innerHTML=ol),le=a(t),N=m(t,"P",{"data-svelte-h":!0}),j(N)!=="svelte-10xqojr"&&(N.innerHTML=ml),ne=a(t),d(Q.$$.fragment,t),se=a(t),V=m(t,"P",{"data-svelte-h":!0}),j(V)!=="svelte-i0fwvi"&&(V.innerHTML=jl),ae=a(t),d(w.$$.fragment,t),ie=a(t),_=m(t,"TABLE",{"data-svelte-h":!0}),j(_)!=="svelte-oy37zl"&&(_.innerHTML=ul),de=a(t),d(S.$$.fragment,t),pe=a(t),d(x.$$.fragment,t),re=a(t),H=m(t,"P",{"data-svelte-h":!0}),j(H)!=="svelte-1oubx8o"&&(H.textContent=gl),Me=a(t),q=m(t,"P",{"data-svelte-h":!0}),j(q)!=="svelte-13so4pe"&&(q.textContent=hl),ce=a(t),d(Y.$$.fragment,t),oe=a(t),d(X.$$.fragment,t),me=a(t),d(z.$$.fragment,t),je=a(t),d(F.$$.fragment,t),ue=a(t),d(L.$$.fragment,t),ge=a(t),d(D.$$.fragment,t),he=a(t),P=m(t,"P",{"data-svelte-h":!0}),j(P)!=="svelte-8d5fhe"&&(P.innerHTML=yl),ye=a(t),K=m(t,"UL",{"data-svelte-h":!0}),j(K)!=="svelte-16ejamp"&&(K.innerHTML=wl),we=a(t),d(O.$$.fragment,t),Te=a(t),tt=m(t,"P",{"data-svelte-h":!0}),j(tt)!=="svelte-1whwkpr"&&(tt.textContent=Tl),fe=a(t),et=m(t,"UL",{"data-svelte-h":!0}),j(et)!=="svelte-9i31ws"&&(et.innerHTML=fl),Ue=a(t),d(lt.$$.fragment,t),Je=a(t),d(nt.$$.fragment,t),be=a(t),st=m(t,"PRE",{"data-svelte-h":!0}),j(st)!=="svelte-19liytu"&&(st.textContent=Ul),Ie=a(t),at=m(t,"P",{"data-svelte-h":!0}),j(at)!=="svelte-il5t0k"&&(at.innerHTML=Jl),$e=a(t),d(it.$$.fragment,t),Ae=a(t),dt=m(t,"P",{"data-svelte-h":!0}),j(dt)!=="svelte-16s019k"&&(dt.textContent=bl),Be=a(t),d(pt.$$.fragment,t),Ce=a(t),rt=m(t,"PRE",{"data-svelte-h":!0}),j(rt)!=="svelte-11ebe9s"&&(rt.textContent=Il),Ge=a(t),d(Mt.$$.fragment,t),ke=a(t),ct=m(t,"P",{"data-svelte-h":!0}),j(ct)!=="svelte-iwjedl"&&(ct.innerHTML=$l),We=a(t),d(ot.$$.fragment,t),Ze=a(t),d(mt.$$.fragment,t),Re=a(t),jt=m(t,"PRE",{"data-svelte-h":!0}),j(jt)!=="svelte-ff4u6w"&&(jt.textContent=Al),Ee=a(t),d(ut.$$.fragment,t),ve=a(t),gt=m(t,"P",{"data-svelte-h":!0}),j(gt)!=="svelte-80w8ff"&&(gt.textContent=Bl),Ne=a(t),d(ht.$$.fragment,t),Qe=a(t),yt=m(t,"PRE",{"data-svelte-h":!0}),j(yt)!=="svelte-v5xolv"&&(yt.textContent=Cl),Ve=a(t),d(wt.$$.fragment,t),_e=a(t),Tt=m(t,"P",{"data-svelte-h":!0}),j(Tt)!=="svelte-13ozgsg"&&(Tt.innerHTML=Gl),Se=a(t),d(ft.$$.fragment,t),xe=a(t),Ut=m(t,"P",{"data-svelte-h":!0}),j(Ut)!=="svelte-1t2e8el"&&(Ut.innerHTML=kl),He=a(t),d(Jt.$$.fragment,t),qe=a(t),d(bt.$$.fragment,t),Ye=a(t),It=m(t,"PRE",{"data-svelte-h":!0}),j(It)!=="svelte-dj57zs"&&(It.textContent=Wl),Xe=a(t),d($t.$$.fragment,t),ze=a(t),At=m(t,"OL",{"data-svelte-h":!0}),j(At)!=="svelte-seqler"&&(At.innerHTML=Zl),Fe=a(t),d(Bt.$$.fragment,t),Le=a(t),Ct=m(t,"PRE",{"data-svelte-h":!0}),j(Ct)!=="svelte-109618w"&&(Ct.textContent=Rl),De=a(t),d(Gt.$$.fragment,t),Pe=a(t),kt=m(t,"P",{"data-svelte-h":!0}),j(kt)!=="svelte-1ga4kzi"&&(kt.innerHTML=El),Ke=a(t),d(Wt.$$.fragment,t),Oe=a(t),Zt=m(t,"P",{"data-svelte-h":!0}),j(Zt)!=="svelte-3kjw6t"&&(Zt.textContent=vl),tl=a(t),Rt=m(t,"P",{"data-svelte-h":!0}),j(Rt)!=="svelte-1124toy"&&(Rt.innerHTML=Nl),el=a(t),d(Et.$$.fragment,t),ll=a(t),vt=m(t,"PRE",{"data-svelte-h":!0}),j(vt)!=="svelte-ulyp9n"&&(vt.textContent=Ql),nl=a(t),d(Nt.$$.fragment,t),sl=a(t),Vt=m(t,"P",{}),_l(Vt).forEach(l),this.h()},h(){Sl(g,"name","hf:doc:metadata"),Sl(g,"content",tn)},m(t,e){Fl(document.head,g),n(t,T,e),n(t,y,e),n(t,Qt,e),p(f,t,e),n(t,St,e),p(U,t,e),n(t,xt,e),n(t,J,e),n(t,Ht,e),p(b,t,e),n(t,qt,e),n(t,I,e),n(t,Yt,e),p($,t,e),n(t,Xt,e),n(t,A,e),n(t,zt,e),n(t,B,e),n(t,Ft,e),n(t,C,e),n(t,Lt,e),n(t,G,e),n(t,Dt,e),p(k,t,e),n(t,Pt,e),p(W,t,e),n(t,Kt,e),p(Z,t,e),n(t,Ot,e),p(R,t,e),n(t,te,e),p(E,t,e),n(t,ee,e),n(t,v,e),n(t,le,e),n(t,N,e),n(t,ne,e),p(Q,t,e),n(t,se,e),n(t,V,e),n(t,ae,e),p(w,t,e),n(t,ie,e),n(t,_,e),n(t,de,e),p(S,t,e),n(t,pe,e),p(x,t,e),n(t,re,e),n(t,H,e),n(t,Me,e),n(t,q,e),n(t,ce,e),p(Y,t,e),n(t,oe,e),p(X,t,e),n(t,me,e),p(z,t,e),n(t,je,e),p(F,t,e),n(t,ue,e),p(L,t,e),n(t,ge,e),p(D,t,e),n(t,he,e),n(t,P,e),n(t,ye,e),n(t,K,e),n(t,we,e),p(O,t,e),n(t,Te,e),n(t,tt,e),n(t,fe,e),n(t,et,e),n(t,Ue,e),p(lt,t,e),n(t,Je,e),p(nt,t,e),n(t,be,e),n(t,st,e),n(t,Ie,e),n(t,at,e),n(t,$e,e),p(it,t,e),n(t,Ae,e),n(t,dt,e),n(t,Be,e),p(pt,t,e),n(t,Ce,e),n(t,rt,e),n(t,Ge,e),p(Mt,t,e),n(t,ke,e),n(t,ct,e),n(t,We,e),p(ot,t,e),n(t,Ze,e),p(mt,t,e),n(t,Re,e),n(t,jt,e),n(t,Ee,e),p(ut,t,e),n(t,ve,e),n(t,gt,e),n(t,Ne,e),p(ht,t,e),n(t,Qe,e),n(t,yt,e),n(t,Ve,e),p(wt,t,e),n(t,_e,e),n(t,Tt,e),n(t,Se,e),p(ft,t,e),n(t,xe,e),n(t,Ut,e),n(t,He,e),p(Jt,t,e),n(t,qe,e),p(bt,t,e),n(t,Ye,e),n(t,It,e),n(t,Xe,e),p($t,t,e),n(t,ze,e),n(t,At,e),n(t,Fe,e),p(Bt,t,e),n(t,Le,e),n(t,Ct,e),n(t,De,e),p(Gt,t,e),n(t,Pe,e),n(t,kt,e),n(t,Ke,e),p(Wt,t,e),n(t,Oe,e),n(t,Zt,e),n(t,tl,e),n(t,Rt,e),n(t,el,e),p(Et,t,e),n(t,ll,e),n(t,vt,e),n(t,nl,e),p(Nt,t,e),n(t,sl,e),n(t,Vt,e),al=!0},p(t,[e]){const Vl={};e&2&&(Vl.$$scope={dirty:e,ctx:t}),w.$set(Vl)},i(t){al||(r(f.$$.fragment,t),r(U.$$.fragment,t),r(b.$$.fragment,t),r($.$$.fragment,t),r(k.$$.fragment,t),r(W.$$.fragment,t),r(Z.$$.fragment,t),r(R.$$.fragment,t),r(E.$$.fragment,t),r(Q.$$.fragment,t),r(w.$$.fragment,t),r(S.$$.fragment,t),r(x.$$.fragment,t),r(Y.$$.fragment,t),r(X.$$.fragment,t),r(z.$$.fragment,t),r(F.$$.fragment,t),r(L.$$.fragment,t),r(D.$$.fragment,t),r(O.$$.fragment,t),r(lt.$$.fragment,t),r(nt.$$.fragment,t),r(it.$$.fragment,t),r(pt.$$.fragment,t),r(Mt.$$.fragment,t),r(ot.$$.fragment,t),r(mt.$$.fragment,t),r(ut.$$.fragment,t),r(ht.$$.fragment,t),r(wt.$$.fragment,t),r(ft.$$.fragment,t),r(Jt.$$.fragment,t),r(bt.$$.fragment,t),r($t.$$.fragment,t),r(Bt.$$.fragment,t),r(Gt.$$.fragment,t),r(Wt.$$.fragment,t),r(Et.$$.fragment,t),r(Nt.$$.fragment,t),al=!0)},o(t){M(f.$$.fragment,t),M(U.$$.fragment,t),M(b.$$.fragment,t),M($.$$.fragment,t),M(k.$$.fragment,t),M(W.$$.fragment,t),M(Z.$$.fragment,t),M(R.$$.fragment,t),M(E.$$.fragment,t),M(Q.$$.fragment,t),M(w.$$.fragment,t),M(S.$$.fragment,t),M(x.$$.fragment,t),M(Y.$$.fragment,t),M(X.$$.fragment,t),M(z.$$.fragment,t),M(F.$$.fragment,t),M(L.$$.fragment,t),M(D.$$.fragment,t),M(O.$$.fragment,t),M(lt.$$.fragment,t),M(nt.$$.fragment,t),M(it.$$.fragment,t),M(pt.$$.fragment,t),M(Mt.$$.fragment,t),M(ot.$$.fragment,t),M(mt.$$.fragment,t),M(ut.$$.fragment,t),M(ht.$$.fragment,t),M(wt.$$.fragment,t),M(ft.$$.fragment,t),M(Jt.$$.fragment,t),M(bt.$$.fragment,t),M($t.$$.fragment,t),M(Bt.$$.fragment,t),M(Gt.$$.fragment,t),M(Wt.$$.fragment,t),M(Et.$$.fragment,t),M(Nt.$$.fragment,t),al=!1},d(t){t&&(l(T),l(y),l(Qt),l(St),l(xt),l(J),l(Ht),l(qt),l(I),l(Yt),l(Xt),l(A),l(zt),l(B),l(Ft),l(C),l(Lt),l(G),l(Dt),l(Pt),l(Kt),l(Ot),l(te),l(ee),l(v),l(le),l(N),l(ne),l(se),l(V),l(ae),l(ie),l(_),l(de),l(pe),l(re),l(H),l(Me),l(q),l(ce),l(oe),l(me),l(je),l(ue),l(ge),l(he),l(P),l(ye),l(K),l(we),l(Te),l(tt),l(fe),l(et),l(Ue),l(Je),l(be),l(st),l(Ie),l(at),l($e),l(Ae),l(dt),l(Be),l(Ce),l(rt),l(Ge),l(ke),l(ct),l(We),l(Ze),l(Re),l(jt),l(Ee),l(ve),l(gt),l(Ne),l(Qe),l(yt),l(Ve),l(_e),l(Tt),l(Se),l(xe),l(Ut),l(He),l(qe),l(Ye),l(It),l(Xe),l(ze),l(At),l(Fe),l(Le),l(Ct),l(De),l(Pe),l(kt),l(Ke),l(Oe),l(Zt),l(tl),l(Rt),l(el),l(ll),l(vt),l(nl),l(sl),l(Vt)),l(g),c(f,t),c(U,t),c(b,t),c($,t),c(k,t),c(W,t),c(Z,t),c(R,t),c(E,t),c(Q,t),c(w,t),c(S,t),c(x,t),c(Y,t),c(X,t),c(z,t),c(F,t),c(L,t),c(D,t),c(O,t),c(lt,t),c(nt,t),c(it,t),c(pt,t),c(Mt,t),c(ot,t),c(mt,t),c(ut,t),c(ht,t),c(wt,t),c(ft,t),c(Jt,t),c(bt,t),c($t,t),c(Bt,t),c(Gt,t),c(Wt,t),c(Et,t),c(Nt,t)}}}const tn='{"title":"How to use Inference Endpoints to Embed Documents","local":"how-to-use-inference-endpoints-to-embed-documents","sections":[{"title":"Goal","local":"goal","sections":[],"depth":2},{"title":"Approach","local":"approach","sections":[],"depth":2},{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Imports","local":"imports","sections":[],"depth":2},{"title":"Config","local":"config","sections":[],"depth":2},{"title":"Get Dataset","local":"get-dataset","sections":[],"depth":2}],"depth":1}';function en(_t){return Hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pn extends Yl{constructor(g){super(),Xl(this,g,en,Ol,xl,{})}}export{pn as component};
