import{s as le,n as se,o as ee}from"../chunks/scheduler.65852ee5.js";import{S as te,i as ae,g as M,s as a,r as i,A as ne,h as o,f as e,c as n,j as Ks,u as y,x as p,k as Ps,y as Me,a as t,v as c,d as J,t as r,w as u}from"../chunks/index.aa74147d.js";import{D as oe,C as T}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as Os,E as pe}from"../chunks/EditOnGithub.4eda6a96.js";function ie(Us){let U,Ul,ul,dl,d,wl,w,jl,j,ds='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',ml,m,ws='<p>This tutorial is advanced. You should have notions from <a href="advanced_rag">this other cookbook</a> first!</p>',hl,h,js="<p>Reminder: Retrieval-Augmented-Generation (RAG) is “using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base”. It has many advantages over using a vanilla or fine-tuned LLM: to name a few, it allows to ground the answer on true facts and reduce confabulations, it allows to provide the LLM with domain-specific knowledge, and it allows fine-grained control of access to information from the knowledge base.</p>",bl,b,ms="But vanilla RAG has limitations, most importantly these two:",Il,I,hs="<li>It <strong>performs only one retrieval step</strong>: if the results are bad, the generation in turn will be bad.</li> <li><strong>Semantic similarity is computed with the <em>user query</em> as a reference</strong>, which might be suboptimal: for instance, the user query will often be a question and the document containing the true answer will be in affirmative voice, so its similarity score will be downgraded compared to other source documents in the interrogative form, leading to a risk of missing the relevant information.</li>",gl,g,bs="But we can alleviate these problems by making a <strong>RAG agent: very simply, an agent armed with a retriever tool!</strong>",Zl,Z,Is="This agent will: ✅ Formulate the query itself and ✅ Critique to re-retrieve if needed.",Cl,C,gs="So it should naively recover some advanced RAG techniques!",Bl,B,Zs='<li>Instead of directly using the user query as the reference in semantic search, the agent formulates itself a reference sentence that can be closer to the targeted documents, as in <a href="https://huggingface.co/papers/2212.10496" rel="nofollow">HyDE</a></li> <li>The agent can the generated snippets and re-retrieve if needed, as in <a href="https://docs.llamaindex.ai/en/stable/examples/evaluation/RetryQuery/" rel="nofollow">Self-Query</a></li>',fl,f,Cs="Let’s build this system. 🛠️",Gl,G,Bs="Run the line below to install required dependencies:",Nl,N,Vl,V,fs="We first load a knowledge base on which we want to perform RAG: this dataset is a compilation of the documentation pages for many <code>huggingface</code> packages, stored as markdown.",Wl,W,vl,v,Gs="Now we prepare the knowledge base by processing the dataset and storing it into a vector database to be used by the retriever.",Rl,R,Ns=`We use <a href="https://python.langchain.com/" rel="nofollow">LangChain</a> for its excellent vector database utilities.
For the embedding model, we use <a href="https://huggingface.co/thenlper/gte-small" rel="nofollow">thenlper/gte-small</a> since it performed well in our <code>RAG_evaluation</code> cookbook.`,Ql,Q,kl,k,Vs=`Splitting documents...
`,El,E,Ws="Now the database is ready: let’s build our agentic RAG system!",Xl,X,vs="👉 We only need a <code>RetrieverTool</code> that our agent can leverage to retrieve information from the knowledge base.",_l,_,ql,q,Rs="Now it’s straightforward to create an agent that leverages this tool!",Yl,Y,Qs="The agent will need these arguments upon initialization:",Hl,H,ks="<li><em><code>tools</code></em>: a list of tools that the agent will be able to call.</li> <li><em><code>llm_engine</code></em>: the LLM that powers the agent.</li>",Al,A,Es='Our <code>llm_engine</code> must be a callable that takes as input a list of <a href="https://huggingface.co/docs/transformers/main/chat_templating" rel="nofollow">messages</a> and returns text. It also needs to accept a <code>stop_sequences</code> argument that indicates when to stop its generation. For convenience, we directly use the <code>HfEngine</code> class provided in the package to get a LLM engine that calls our <a href="https://huggingface.co/docs/api-inference/en/index" rel="nofollow">Inference API</a>.',Sl,S,Xs='And we use <a href="https://huggingface.co/CohereForAI/c4ai-command-r-plus" rel="nofollow">CohereForAI/c4ai-command-r-plus</a> as the llm engine because:',xl,x,_s="<li>It has a long 128k context, which is helpful for processing long source documents</li> <li>It is served for free at all times on HF’s Inference API!</li>",zl,z,Fl,F,qs="Since we initialized the agent as a <code>ReactJsonAgent</code>, it has been automatically given a default system prompt that tells the LLM engine to process step-by-step and generate tool calls as JSON blobs (you could replace this prompt template with your own as needed).",$l,$,Ys="Then when its <code>.run()</code> method is launched, the agent takes care of calling the LLM engine, parsing the tool call JSON blobs and executing these tool calls, all in a loop that ends only when the final answer is provided.",Ll,L,Dl,D,Hs=`Final output:
There are multiple ways to push a model to the Hub. Here are a few examples using different libraries and functions:

Using the \`api\`:
python
api.upload_folder(
    repo_id=repo_id,
    folder_path=repo_local_path,
    path_in_repo='.',
)

print('Your model is pushed to the Hub. You can view your model here:', repo_url)


With Transformers:
python
from transformers import PushToHubCallback

# Initialize the callback with the output directory,
tokenizer, and your Hub username and model name
push_to_hub_callback = PushToHubCallback(
    output_dir='./your_model_save_path',
    tokenizer=tokenizer,
    hub_model_id='your-username/my-awesome-model'
)

# Assuming \`trainer\` is your Trainer object
trainer.add_callback(push_to_hub_callback)


Using \`timm\`:
python
from timm.models.hub import push_to_hf_hub

# Assuming \`model\` is your fine-tuned model
model_cfg = &#123;'labels': ['a', 'b', 'c', 'd']}
push_to_hf_hub(model, 'resnet18-random', model_config=model_cfg)


For computer vision models, you can also use \`push_to_hub\`:
python
processor.push_to_hub(hub_model_id)
trainer.push_to_hub(**kwargs)


You can also manually push a model with \`model.push_to_hub()\`:
python
model.push_to_hub()


Additionally, you can opt to push your model to the Hub at the end of training by specifying \`push_to_hub=True\` in the training configuration. Don't forget to have git-lfs installed and be logged into your Hugging Face account.
`,Kl,K,Pl,P,As="Does the agent setup make a better RAG system? Well, let’s comapre it to a standard RAG system using LLM Judge!",Ol,O,Ss='We will use <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3-70B-Instruct</a> for evaluation since it’s one of the strongest OS models we tested for LLM judge use cases.',ls,ll,ss,sl,xs="Before running the test let’s make the agent less verbose.",es,el,ts,tl,as,al,ns,nl,zs='The evaluation prompt follows some of the best principles shown in <a href="llm_judge">our llm_judge cookbook</a>: it follows a small integer Likert scale, has clear criteria, and a description for each score.',Ms,Ml,os,ol,ps,pl,is,il,Fs=`Average score for agentic RAG: 78.5%
`,ys,yl,$s="<strong>Let us recap: the Agent setup improves scores by 8.5% compared to a standard RAG!</strong> (from 70.0% to 78.5%)",cs,cl,Ls="This is a great improvement, with a very simple setup 🚀",Js,Jl,Ds="(For a baseline, using Llama-3-70B without the knowledge base got 36%)",rs,rl,us,Tl,Ts;return d=new oe({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/update_i18n/notebooks/en/agent_rag.ipynb"}]}}),w=new Os({props:{title:"Agentic RAG: turbocharge your RAG with query reformulation and self-query! 🚀",local:"agentic-rag-turbocharge-your-rag-with-query-reformulation-and-self-query-",headingTag:"h1"}}),N=new T({props:{code:"IXBpcCUyMGluc3RhbGwlMjBwYW5kYXMlMjBsYW5nY2hhaW4lMjBsYW5nY2hhaW4tY29tbXVuaXR5JTIwc2VudGVuY2UtdHJhbnNmb3JtZXJzJTIwZmFpc3MtY3B1JTIwJTIydHJhbnNmb3JtZXJzJTVCYWdlbnRzJTVEJTIy",highlighted:'!pip install pandas langchain langchain-community sentence-transformers faiss-cpu <span class="hljs-string">&quot;transformers[agents]&quot;</span>',wrap:!1}}),W=new T({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),Q=new T({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain_community.vectorstores.utils <span class="hljs-keyword">import</span> DistanceStrategy
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>source_docs = [
<span class="hljs-meta">... </span>    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>text_splitter = RecursiveCharacterTextSplitter.from_huggingface_tokenizer(
<span class="hljs-meta">... </span>    AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>),
<span class="hljs-meta">... </span>    chunk_size=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    chunk_overlap=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    add_start_index=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    strip_whitespace=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Split docs and keep only unique ones</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Splitting documents...&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>docs_processed = []
<span class="hljs-meta">&gt;&gt;&gt; </span>unique_texts = {}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(source_docs):
<span class="hljs-meta">... </span>    new_docs = text_splitter.split_documents([doc])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> new_doc <span class="hljs-keyword">in</span> new_docs:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> new_doc.page_content <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> unique_texts:
<span class="hljs-meta">... </span>            unique_texts[new_doc.page_content] = <span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>            docs_processed.append(new_doc)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Embedding documents... This should take a few minutes (5 minutes on MacBook with M1 Pro)&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vectordb = FAISS.from_documents(
<span class="hljs-meta">... </span>    documents=docs_processed,
<span class="hljs-meta">... </span>    embedding=embedding_model,
<span class="hljs-meta">... </span>    distance_strategy=DistanceStrategy.COSINE,
<span class="hljs-meta">... </span>)`,wrap:!1}}),_=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;Using semantic similarity, retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;text&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        docs = self.vectordb.similarity_search(
            query,
            k=<span class="hljs-number">7</span>,
        )

        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved documents:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [<span class="hljs-string">f&quot;===== Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)]
        )`,wrap:!1}}),z=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkVuZ2luZSUyQyUyMFJlYWN0SnNvbkFnZW50JTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmRW5naW5lKCUyMkNvaGVyZUZvckFJJTJGYzRhaS1jb21tYW5kLXItcGx1cyUyMiklMEElMEFyZXRyaWV2ZXJfdG9vbCUyMCUzRCUyMFJldHJpZXZlclRvb2wodmVjdG9yZGIpJTBBYWdlbnQlMjAlM0QlMjBSZWFjdEpzb25BZ2VudCh0b29scyUzRCU1QnJldHJpZXZlcl90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUlMkMlMjBtYXhfaXRlcmF0aW9ucyUzRDQlMkMlMjB2ZXJib3NlJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfEngine, ReactJsonAgent

llm_engine = HfEngine(<span class="hljs-string">&quot;CohereForAI/c4ai-command-r-plus&quot;</span>)

retriever_tool = RetrieverTool(vectordb)
agent = ReactJsonAgent(tools=[retriever_tool], llm_engine=llm_engine, max_iterations=<span class="hljs-number">4</span>, verbose=<span class="hljs-number">2</span>)`,wrap:!1}}),L=new T({props:{code:"YWdlbnRfb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKCUyMkhvdyUyMGNhbiUyMEklMjBwdXNoJTIwYSUyMG1vZGVsJTIwdG8lMjB0aGUlMjBIdWIlM0YlMjIpJTBBJTBBcHJpbnQoJTIyRmluYWwlMjBvdXRwdXQlM0ElMjIpJTBBcHJpbnQoYWdlbnRfb3V0cHV0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>agent_output = agent.run(<span class="hljs-string">&quot;How can I push a model to the Hub?&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),K=new Os({props:{title:"Agentic RAG vs. standard RAG",local:"agentic-rag-vs-standard-rag",headingTag:"h2"}}),ll=new T({props:{code:"ZXZhbF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMm0tcmljJTJGaHVnZ2luZ2ZhY2VfZG9jX3FhX2V2YWwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:'eval_dataset = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc_qa_eval&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)',wrap:!1}}),el=new T({props:{code:"aW1wb3J0JTIwbG9nZ2luZyUwQSUwQWFnZW50LmxvZ2dlci5zZXRMZXZlbChsb2dnaW5nLldBUk5JTkcp",highlighted:`<span class="hljs-keyword">import</span> logging

agent.logger.setLevel(logging.WARNING)`,wrap:!1}}),tl=new T({props:{code:"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",highlighted:`outputs_agentic_rag = []

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> tqdm(eval_dataset):
    question = example[<span class="hljs-string">&quot;question&quot;</span>]

    enhanced_question = <span class="hljs-string">f&quot;&quot;&quot;Using the information contained in your knowledge base, which you can access with the &#x27;retriever&#x27; tool,
give a comprehensive answer to the question below.
Respond only to the question asked, response should be concise and relevant to the question.
If you cannot find information, do not give up and try calling your retriever again with different arguments!
Make sure to have covered the question completely by calling the retriever tool several times with semantically different queries.
Your queries should not be questions but affirmative form sentences: e.g. rather than &quot;How do I load a model from the Hub in bf16?&quot;, query should be &quot;load a model from the Hub bf16 weights&quot;.

Question:
<span class="hljs-subst">{question}</span>&quot;&quot;&quot;</span>
    answer = agent.run(enhanced_question)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=======================================================&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer: <span class="hljs-subst">{answer}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;True answer: <span class="hljs-subst">{example[<span class="hljs-string">&quot;answer&quot;</span>]}</span>&#x27;</span>)

    results_agentic = {
        <span class="hljs-string">&quot;question&quot;</span>: question,
        <span class="hljs-string">&quot;true_answer&quot;</span>: example[<span class="hljs-string">&quot;answer&quot;</span>],
        <span class="hljs-string">&quot;source_doc&quot;</span>: example[<span class="hljs-string">&quot;source_doc&quot;</span>],
        <span class="hljs-string">&quot;generated_answer&quot;</span>: answer,
    }
    outputs_agentic_rag.append(results_agentic)`,wrap:!1}}),al=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

reader_llm = InferenceClient(<span class="hljs-string">&quot;CohereForAI/c4ai-command-r-plus&quot;</span>)

outputs_standard_rag = []

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> tqdm(eval_dataset):
    question = example[<span class="hljs-string">&quot;question&quot;</span>]
    context = retriever_tool(question)

    prompt = <span class="hljs-string">f&quot;&quot;&quot;Given the question and supporting documents below, give a comprehensive answer to the question.
Respond only to the question asked, response should be concise and relevant to the question.
Provide the number of the source document when relevant.
If you cannot find information, do not give up and try calling your retriever again with different arguments!

Question:
<span class="hljs-subst">{question}</span>

<span class="hljs-subst">{context}</span>
&quot;&quot;&quot;</span>
    messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}]
    answer = reader_llm.chat_completion(messages).choices[<span class="hljs-number">0</span>].message.content

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=======================================================&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer: <span class="hljs-subst">{answer}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;True answer: <span class="hljs-subst">{example[<span class="hljs-string">&quot;answer&quot;</span>]}</span>&#x27;</span>)

    results_agentic = {
        <span class="hljs-string">&quot;question&quot;</span>: question,
        <span class="hljs-string">&quot;true_answer&quot;</span>: example[<span class="hljs-string">&quot;answer&quot;</span>],
        <span class="hljs-string">&quot;source_doc&quot;</span>: example[<span class="hljs-string">&quot;source_doc&quot;</span>],
        <span class="hljs-string">&quot;generated_answer&quot;</span>: answer,
    }
    outputs_standard_rag.append(results_agentic)`,wrap:!1}}),Ml=new T({props:{code:"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",highlighted:`EVALUATION_PROMPT = <span class="hljs-string">&quot;&quot;&quot;You are a fair evaluator language model.

You will be given an instruction, a response to evaluate, a reference answer that gets a score of 3, and a score rubric representing a evaluation criteria are given.
1. Write a detailed feedback that assess the quality of the response strictly based on the given score rubric, not evaluating in general.
2. After writing a feedback, write a score that is an integer between 1 and 3. You should refer to the score rubric.
3. The output format should look as follows: \\&quot;Feedback: {{write a feedback for criteria}} [RESULT] {{an integer number between 1 and 3}}\\&quot;
4. Please do not generate any other opening, closing, and explanations. Be sure to include [RESULT] in your output.
5. Do not score conciseness: a correct answer that covers the question should receive max score, even if it contains additional useless information.

The instruction to evaluate:
{instruction}

Response to evaluate:
{response}

Reference Answer (Score 3):
{reference_answer}

Score Rubrics:
[Is the response complete, accurate, and factual based on the reference answer?]
Score 1: The response is completely incomplete, inaccurate, and/or not factual.
Score 2: The response is somewhat complete, accurate, and/or factual.
Score 3: The response is completely complete, accurate, and/or factual.

Feedback:&quot;&quot;&quot;</span>`,wrap:!1}}),ol=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWV2YWx1YXRpb25fY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtNzBCLUluc3RydWN0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

evaluation_client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)`,wrap:!1}}),pl=new T({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> <span class="hljs-built_in">type</span>, outputs <span class="hljs-keyword">in</span> [
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;agentic&quot;</span>, outputs_agentic_rag),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;standard&quot;</span>, outputs_standard_rag),
<span class="hljs-meta">... </span>]:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> experiment <span class="hljs-keyword">in</span> tqdm(outputs):
<span class="hljs-meta">... </span>        eval_prompt = EVALUATION_PROMPT.<span class="hljs-built_in">format</span>(
<span class="hljs-meta">... </span>            instruction=experiment[<span class="hljs-string">&quot;question&quot;</span>],
<span class="hljs-meta">... </span>            response=experiment[<span class="hljs-string">&quot;generated_answer&quot;</span>],
<span class="hljs-meta">... </span>            reference_answer=experiment[<span class="hljs-string">&quot;true_answer&quot;</span>],
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        messages = [
<span class="hljs-meta">... </span>            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a fair evaluator language model.&quot;</span>},
<span class="hljs-meta">... </span>            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: eval_prompt},
<span class="hljs-meta">... </span>        ]

<span class="hljs-meta">... </span>        eval_result = evaluation_client.text_generation(eval_prompt, max_new_tokens=<span class="hljs-number">1000</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>            feedback, score = [item.strip() <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> eval_result.split(<span class="hljs-string">&quot;[RESULT]&quot;</span>)]
<span class="hljs-meta">... </span>            experiment[<span class="hljs-string">&quot;eval_score_LLM_judge&quot;</span>] = score
<span class="hljs-meta">... </span>            experiment[<span class="hljs-string">&quot;eval_feedback_LLM_judge&quot;</span>] = feedback
<span class="hljs-meta">... </span>        <span class="hljs-keyword">except</span>:
<span class="hljs-meta">... </span>            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Parsing failed - output was: <span class="hljs-subst">{eval_result}</span>&quot;</span>)

<span class="hljs-meta">... </span>    results = pd.DataFrame.from_dict(outputs)
<span class="hljs-meta">... </span>    results = results.loc[~results[<span class="hljs-string">&quot;generated_answer&quot;</span>].<span class="hljs-built_in">str</span>.contains(<span class="hljs-string">&quot;Error&quot;</span>)]
<span class="hljs-meta">... </span>    results[<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] = results[<span class="hljs-string">&quot;eval_score_LLM_judge&quot;</span>].fillna(<span class="hljs-number">1</span>).apply(<span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">int</span>(x))
<span class="hljs-meta">... </span>    results[<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] = (results[<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] - <span class="hljs-number">1</span>) / <span class="hljs-number">2</span>

<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Average score for <span class="hljs-subst">{<span class="hljs-built_in">type</span>}</span> RAG: <span class="hljs-subst">{results[<span class="hljs-string">&#x27;eval_score_LLM_judge_int&#x27;</span>].mean()*<span class="hljs-number">100</span>:<span class="hljs-number">.1</span>f}</span>%&quot;</span>)`,wrap:!1}}),rl=new pe({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agent_rag.md"}}),{c(){U=M("meta"),Ul=a(),ul=M("p"),dl=a(),i(d.$$.fragment),wl=a(),i(w.$$.fragment),jl=a(),j=M("p"),j.innerHTML=ds,ml=a(),m=M("blockquote"),m.innerHTML=ws,hl=a(),h=M("blockquote"),h.innerHTML=js,bl=a(),b=M("p"),b.textContent=ms,Il=a(),I=M("ul"),I.innerHTML=hs,gl=a(),g=M("p"),g.innerHTML=bs,Zl=a(),Z=M("p"),Z.textContent=Is,Cl=a(),C=M("p"),C.textContent=gs,Bl=a(),B=M("ul"),B.innerHTML=Zs,fl=a(),f=M("p"),f.textContent=Cs,Gl=a(),G=M("p"),G.textContent=Bs,Nl=a(),i(N.$$.fragment),Vl=a(),V=M("p"),V.innerHTML=fs,Wl=a(),i(W.$$.fragment),vl=a(),v=M("p"),v.textContent=Gs,Rl=a(),R=M("p"),R.innerHTML=Ns,Ql=a(),i(Q.$$.fragment),kl=a(),k=M("pre"),k.textContent=Vs,El=a(),E=M("p"),E.textContent=Ws,Xl=a(),X=M("p"),X.innerHTML=vs,_l=a(),i(_.$$.fragment),ql=a(),q=M("p"),q.textContent=Rs,Yl=a(),Y=M("p"),Y.textContent=Qs,Hl=a(),H=M("ul"),H.innerHTML=ks,Al=a(),A=M("p"),A.innerHTML=Es,Sl=a(),S=M("p"),S.innerHTML=Xs,xl=a(),x=M("ul"),x.innerHTML=_s,zl=a(),i(z.$$.fragment),Fl=a(),F=M("p"),F.innerHTML=qs,$l=a(),$=M("p"),$.innerHTML=Ys,Ll=a(),i(L.$$.fragment),Dl=a(),D=M("pre"),D.textContent=Hs,Kl=a(),i(K.$$.fragment),Pl=a(),P=M("p"),P.textContent=As,Ol=a(),O=M("p"),O.innerHTML=Ss,ls=a(),i(ll.$$.fragment),ss=a(),sl=M("p"),sl.textContent=xs,es=a(),i(el.$$.fragment),ts=a(),i(tl.$$.fragment),as=a(),i(al.$$.fragment),ns=a(),nl=M("p"),nl.innerHTML=zs,Ms=a(),i(Ml.$$.fragment),os=a(),i(ol.$$.fragment),ps=a(),i(pl.$$.fragment),is=a(),il=M("pre"),il.textContent=Fs,ys=a(),yl=M("p"),yl.innerHTML=$s,cs=a(),cl=M("p"),cl.textContent=Ls,Js=a(),Jl=M("p"),Jl.textContent=Ds,rs=a(),i(rl.$$.fragment),us=a(),Tl=M("p"),this.h()},l(l){const s=ne("svelte-u9bgzb",document.head);U=o(s,"META",{name:!0,content:!0}),s.forEach(e),Ul=n(l),ul=o(l,"P",{}),Ks(ul).forEach(e),dl=n(l),y(d.$$.fragment,l),wl=n(l),y(w.$$.fragment,l),jl=n(l),j=o(l,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1xlqnsv"&&(j.innerHTML=ds),ml=n(l),m=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),p(m)!=="svelte-ut7thx"&&(m.innerHTML=ws),hl=n(l),h=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),p(h)!=="svelte-1uj6u2q"&&(h.innerHTML=js),bl=n(l),b=o(l,"P",{"data-svelte-h":!0}),p(b)!=="svelte-le6dse"&&(b.textContent=ms),Il=n(l),I=o(l,"UL",{"data-svelte-h":!0}),p(I)!=="svelte-1tet28w"&&(I.innerHTML=hs),gl=n(l),g=o(l,"P",{"data-svelte-h":!0}),p(g)!=="svelte-zgftoz"&&(g.innerHTML=bs),Zl=n(l),Z=o(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1oxrjf8"&&(Z.textContent=Is),Cl=n(l),C=o(l,"P",{"data-svelte-h":!0}),p(C)!=="svelte-i3m4dm"&&(C.textContent=gs),Bl=n(l),B=o(l,"UL",{"data-svelte-h":!0}),p(B)!=="svelte-16julm3"&&(B.innerHTML=Zs),fl=n(l),f=o(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-18mh92s"&&(f.textContent=Cs),Gl=n(l),G=o(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-16cuoal"&&(G.textContent=Bs),Nl=n(l),y(N.$$.fragment,l),Vl=n(l),V=o(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-zy8yuo"&&(V.innerHTML=fs),Wl=n(l),y(W.$$.fragment,l),vl=n(l),v=o(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-11htfoc"&&(v.textContent=Gs),Rl=n(l),R=o(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-pr8fqf"&&(R.innerHTML=Ns),Ql=n(l),y(Q.$$.fragment,l),kl=n(l),k=o(l,"PRE",{"data-svelte-h":!0}),p(k)!=="svelte-bkjqrc"&&(k.textContent=Vs),El=n(l),E=o(l,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1tpog71"&&(E.textContent=Ws),Xl=n(l),X=o(l,"P",{"data-svelte-h":!0}),p(X)!=="svelte-675szm"&&(X.innerHTML=vs),_l=n(l),y(_.$$.fragment,l),ql=n(l),q=o(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1ma3u1b"&&(q.textContent=Rs),Yl=n(l),Y=o(l,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-14g5yev"&&(Y.textContent=Qs),Hl=n(l),H=o(l,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-1pv35c6"&&(H.innerHTML=ks),Al=n(l),A=o(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-kqzwq2"&&(A.innerHTML=Es),Sl=n(l),S=o(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-z1y5zp"&&(S.innerHTML=Xs),xl=n(l),x=o(l,"UL",{"data-svelte-h":!0}),p(x)!=="svelte-38rh7n"&&(x.innerHTML=_s),zl=n(l),y(z.$$.fragment,l),Fl=n(l),F=o(l,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1dmyh52"&&(F.innerHTML=qs),$l=n(l),$=o(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-143bxk3"&&($.innerHTML=Ys),Ll=n(l),y(L.$$.fragment,l),Dl=n(l),D=o(l,"PRE",{"data-svelte-h":!0}),p(D)!=="svelte-aexpmm"&&(D.textContent=Hs),Kl=n(l),y(K.$$.fragment,l),Pl=n(l),P=o(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-ch3cxl"&&(P.textContent=As),Ol=n(l),O=o(l,"P",{"data-svelte-h":!0}),p(O)!=="svelte-yr66ap"&&(O.innerHTML=Ss),ls=n(l),y(ll.$$.fragment,l),ss=n(l),sl=o(l,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-708yv1"&&(sl.textContent=xs),es=n(l),y(el.$$.fragment,l),ts=n(l),y(tl.$$.fragment,l),as=n(l),y(al.$$.fragment,l),ns=n(l),nl=o(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-lt6qr6"&&(nl.innerHTML=zs),Ms=n(l),y(Ml.$$.fragment,l),os=n(l),y(ol.$$.fragment,l),ps=n(l),y(pl.$$.fragment,l),is=n(l),il=o(l,"PRE",{"data-svelte-h":!0}),p(il)!=="svelte-mnmczc"&&(il.textContent=Fs),ys=n(l),yl=o(l,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-19t4l39"&&(yl.innerHTML=$s),cs=n(l),cl=o(l,"P",{"data-svelte-h":!0}),p(cl)!=="svelte-1fi7cw9"&&(cl.textContent=Ls),Js=n(l),Jl=o(l,"P",{"data-svelte-h":!0}),p(Jl)!=="svelte-1y4e8t1"&&(Jl.textContent=Ds),rs=n(l),y(rl.$$.fragment,l),us=n(l),Tl=o(l,"P",{}),Ks(Tl).forEach(e),this.h()},h(){Ps(U,"name","hf:doc:metadata"),Ps(U,"content",ye)},m(l,s){Me(document.head,U),t(l,Ul,s),t(l,ul,s),t(l,dl,s),c(d,l,s),t(l,wl,s),c(w,l,s),t(l,jl,s),t(l,j,s),t(l,ml,s),t(l,m,s),t(l,hl,s),t(l,h,s),t(l,bl,s),t(l,b,s),t(l,Il,s),t(l,I,s),t(l,gl,s),t(l,g,s),t(l,Zl,s),t(l,Z,s),t(l,Cl,s),t(l,C,s),t(l,Bl,s),t(l,B,s),t(l,fl,s),t(l,f,s),t(l,Gl,s),t(l,G,s),t(l,Nl,s),c(N,l,s),t(l,Vl,s),t(l,V,s),t(l,Wl,s),c(W,l,s),t(l,vl,s),t(l,v,s),t(l,Rl,s),t(l,R,s),t(l,Ql,s),c(Q,l,s),t(l,kl,s),t(l,k,s),t(l,El,s),t(l,E,s),t(l,Xl,s),t(l,X,s),t(l,_l,s),c(_,l,s),t(l,ql,s),t(l,q,s),t(l,Yl,s),t(l,Y,s),t(l,Hl,s),t(l,H,s),t(l,Al,s),t(l,A,s),t(l,Sl,s),t(l,S,s),t(l,xl,s),t(l,x,s),t(l,zl,s),c(z,l,s),t(l,Fl,s),t(l,F,s),t(l,$l,s),t(l,$,s),t(l,Ll,s),c(L,l,s),t(l,Dl,s),t(l,D,s),t(l,Kl,s),c(K,l,s),t(l,Pl,s),t(l,P,s),t(l,Ol,s),t(l,O,s),t(l,ls,s),c(ll,l,s),t(l,ss,s),t(l,sl,s),t(l,es,s),c(el,l,s),t(l,ts,s),c(tl,l,s),t(l,as,s),c(al,l,s),t(l,ns,s),t(l,nl,s),t(l,Ms,s),c(Ml,l,s),t(l,os,s),c(ol,l,s),t(l,ps,s),c(pl,l,s),t(l,is,s),t(l,il,s),t(l,ys,s),t(l,yl,s),t(l,cs,s),t(l,cl,s),t(l,Js,s),t(l,Jl,s),t(l,rs,s),c(rl,l,s),t(l,us,s),t(l,Tl,s),Ts=!0},p:se,i(l){Ts||(J(d.$$.fragment,l),J(w.$$.fragment,l),J(N.$$.fragment,l),J(W.$$.fragment,l),J(Q.$$.fragment,l),J(_.$$.fragment,l),J(z.$$.fragment,l),J(L.$$.fragment,l),J(K.$$.fragment,l),J(ll.$$.fragment,l),J(el.$$.fragment,l),J(tl.$$.fragment,l),J(al.$$.fragment,l),J(Ml.$$.fragment,l),J(ol.$$.fragment,l),J(pl.$$.fragment,l),J(rl.$$.fragment,l),Ts=!0)},o(l){r(d.$$.fragment,l),r(w.$$.fragment,l),r(N.$$.fragment,l),r(W.$$.fragment,l),r(Q.$$.fragment,l),r(_.$$.fragment,l),r(z.$$.fragment,l),r(L.$$.fragment,l),r(K.$$.fragment,l),r(ll.$$.fragment,l),r(el.$$.fragment,l),r(tl.$$.fragment,l),r(al.$$.fragment,l),r(Ml.$$.fragment,l),r(ol.$$.fragment,l),r(pl.$$.fragment,l),r(rl.$$.fragment,l),Ts=!1},d(l){l&&(e(Ul),e(ul),e(dl),e(wl),e(jl),e(j),e(ml),e(m),e(hl),e(h),e(bl),e(b),e(Il),e(I),e(gl),e(g),e(Zl),e(Z),e(Cl),e(C),e(Bl),e(B),e(fl),e(f),e(Gl),e(G),e(Nl),e(Vl),e(V),e(Wl),e(vl),e(v),e(Rl),e(R),e(Ql),e(kl),e(k),e(El),e(E),e(Xl),e(X),e(_l),e(ql),e(q),e(Yl),e(Y),e(Hl),e(H),e(Al),e(A),e(Sl),e(S),e(xl),e(x),e(zl),e(Fl),e(F),e($l),e($),e(Ll),e(Dl),e(D),e(Kl),e(Pl),e(P),e(Ol),e(O),e(ls),e(ss),e(sl),e(es),e(ts),e(as),e(ns),e(nl),e(Ms),e(os),e(ps),e(is),e(il),e(ys),e(yl),e(cs),e(cl),e(Js),e(Jl),e(rs),e(us),e(Tl)),e(U),u(d,l),u(w,l),u(N,l),u(W,l),u(Q,l),u(_,l),u(z,l),u(L,l),u(K,l),u(ll,l),u(el,l),u(tl,l),u(al,l),u(Ml,l),u(ol,l),u(pl,l),u(rl,l)}}}const ye='{"title":"Agentic RAG: turbocharge your RAG with query reformulation and self-query! 🚀","local":"agentic-rag-turbocharge-your-rag-with-query-reformulation-and-self-query-","sections":[{"title":"Agentic RAG vs. standard RAG","local":"agentic-rag-vs-standard-rag","sections":[],"depth":2}],"depth":1}';function ce(Us){return ee(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ue extends te{constructor(U){super(),ae(this,U,ce,ie,le,{})}}export{Ue as component};
