import{s as Kl,n as Ol,o as ls}from"../chunks/scheduler.65852ee5.js";import{S as ss,i as es,g as a,s as n,r as o,A as ts,h as y,f as e,c as M,j as Pl,u as c,x as p,k as Dl,y as ns,a as t,v as i,d as j,t as U,w as J}from"../chunks/index.aa74147d.js";import{D as Ms,C as P}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as L,E as as}from"../chunks/EditOnGithub.4eda6a96.js";function ys(Bl){let T,D,F,K,w,O,r,ll,m,El='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',sl,u,Vl='<p>This tutorial builds upon agent knowledge: to know more about agents, you can start with <a href="agents">this introductory notebook</a></p>',el,I,kl='<a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow">Transformers Agents</a> is a library to build agents, using an LLM to power it in the <code>llm_engine</code> argument. This argument was designed to leave the user maximal freedom to choose any LLM.',tl,C,Wl="Let’s see how to build this <code>llm_engine</code> from the APIs of a few leading providers.",nl,d,Ml,h,Gl="Transformers agents provides a built-in <code>HfEngine</code> class that lets you use any model on the Hub via the Serverless API or your own dedicated Endpoint. This is the preferred way to use HF agents.",al,b,yl,A,zl=`['unicodedata', 're', 'math', 'collections', 'queue', 'itertools', 'random', 'time', 'stat', 'statistics']
`,pl,f,Xl="The <code>llm_engine</code> initialization arg of the agent could be a simple callable such as:",ol,g,cl,Z,vl="This callable is the heart of the llm engine. It should respect these requirements:",il,_,Ql='<li>takes as input a list of messages in <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">chat template</a> format and outputs a <code>str</code>.</li> <li>accepts a <code>stop_sequences</code> argument where the agent system will pass it sequences where it should stop generation.</li>',jl,N,Sl="Let’s take a closer look at the code for the <code>HfEngine</code> that we used:",Ul,B,Jl,E,Rl="Here the engine is not a function, but a class with a <code>__call__</code> method, which adds the possibility to store attributes such as the client.",Tl,V,$l=`We also use <code>get_clean_message_list()</code> utility to concatenate successive messages to the same role
This method takes a <code>role_conversions</code> arg to convert the range of roles supported in Transformers Agents to only the ones accepted by your LLM.`,wl,k,Hl="This recipe can be adapted for any LLM! Let’s look at other examples.",rl,W,ml,G,Yl=`Using the above recipe, you can use any LLM inference source as your <code>llm_engine</code>.
Just keep in mind the two main constraints:`,ul,z,xl='<li><code>llm_engine</code> is a callable that takes as input a list of messages in <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">chat template</a> format and outputs a <code>str</code>.</li> <li>It accepts a <code>stop_sequences</code> argument.</li>',Il,X,Cl,v,dl,Q,hl,S,bl,R,Al,$,Ll="Go on and implement your <code>llm_engine</code> for <code>transformers.agents</code> with your own LLM inference provider!",fl,H,Fl="Then to use this shiny new <code>llm_engine</code>, check out these use cases:",gl,Y,ql='<li><a href="agent_rag">Agentic RAG: turbocharge your RAG with query reformulation and self-query</a></li> <li><a href="agent_text_to_sql">Agent for text-to-SQL with automatic error correction</a></li>',Zl,x,_l,q,Nl;return w=new Ms({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/enterprise-cookbook-gradio-fixes/notebooks/en/agent_change_llm.ipynb"}]}}),r=new L({props:{title:"Create a Transformers Agent from any LLM inference provider",local:"create-a-transformers-agent-from-any-llm-inference-provider",headingTag:"h1"}}),d=new L({props:{title:"HuggingFace Serverless API and Dedicated Endpoints",local:"huggingface-serverless-api-and-dedicated-endpoints",headingTag:"h2"}}),b=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkVuZ2luZSUyQyUyMFJlYWN0Q29kZUFnZW50JTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMEFlbmRwb2ludF91cmwlMjAlM0QlMjAlMjJ5b3VyX2VuZHBvaW50X3VybCUyMiUwQSUwQWxsbV9lbmdpbmUlMjAlM0QlMjBIZkVuZ2luZShtb2RlbCUzRHJlcG9faWQpJTIwJTIwJTIzJTIweW91JTIwY291bGQlMjB1c2UlMjBtb2RlbCUzRGVuZHBvaW50X3VybCUyMGhlcmUlMEElMEFhZ2VudCUyMCUzRCUyMFJlYWN0Q29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUpJTBBJTBBYWdlbnQucnVuKCUyMldoYXQncyUyMHRoZSUyMDEwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfEngine, ReactCodeAgent

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint_url = <span class="hljs-string">&quot;your_endpoint_url&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>llm_engine = HfEngine(model=repo_id)  <span class="hljs-comment"># you could use model=endpoint_url here</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>agent = ReactCodeAgent(tools=[], llm_engine=llm_engine)

<span class="hljs-meta">&gt;&gt;&gt; </span>agent.run(<span class="hljs-string">&quot;What&#x27;s the 10th Fibonacci number?&quot;</span>)`,wrap:!1}}),g=new P({props:{code:"ZGVmJTIwbGxtX2VuZ2luZShtZXNzYWdlcyUyQyUyMHN0b3Bfc2VxdWVuY2VzJTNEJTVCJTVEKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXNwb25zZShtZXNzYWdlcyk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">llm_engine</span>(<span class="hljs-params">messages, stop_sequences=[]</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-keyword">return</span> response(messages)`,wrap:!1}}),B=new P({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, <span class="hljs-type">Dict</span>
<span class="hljs-keyword">from</span> transformers.agents.llm_engine <span class="hljs-keyword">import</span> MessageRole, get_clean_message_list
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

llama_role_conversions = {
    MessageRole.TOOL_RESPONSE: MessageRole.USER,
}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">HfEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span></span>):
        self.model = model
        self.client = InferenceClient(model=self.model, timeout=<span class="hljs-number">120</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">str</span>]], stop_sequences=[]</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-comment"># Get clean message list</span>
        messages = get_clean_message_list(messages, role_conversions=llama_role_conversions)

        <span class="hljs-comment"># Get LLM output</span>
        response = self.client.chat_completion(messages, stop=stop_sequences, max_tokens=<span class="hljs-number">1500</span>)
        response = response.choices[<span class="hljs-number">0</span>].message.content

        <span class="hljs-comment"># Remove stop sequences from LLM output</span>
        <span class="hljs-keyword">for</span> stop_seq <span class="hljs-keyword">in</span> stop_sequences:
            <span class="hljs-keyword">if</span> response[-<span class="hljs-built_in">len</span>(stop_seq) :] == stop_seq:
                response = response[: -<span class="hljs-built_in">len</span>(stop_seq)]
        <span class="hljs-keyword">return</span> response`,wrap:!1}}),W=new L({props:{title:"Adapting the recipe for any LLM",local:"adapting-the-recipe-for-any-llm",headingTag:"h2"}}),X=new L({props:{title:"OpenAI",local:"openai",headingTag:"h3"}}),v=new P({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwT3BlbkFJJTBBJTBBb3BlbmFpX3JvbGVfY29udmVyc2lvbnMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjBNZXNzYWdlUm9sZS5UT09MX1JFU1BPTlNFJTNBJTIwTWVzc2FnZVJvbGUuVVNFUiUyQyUwQSU3RCUwQSUwQSUwQWNsYXNzJTIwT3BlbkFJRW5naW5lJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMG1vZGVsX25hbWUlM0QlMjJncHQtNG8lMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbF9uYW1lJTIwJTNEJTIwbW9kZWxfbmFtZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2xpZW50JTIwJTNEJTIwT3BlbkFJKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFwaV9rZXklM0Rvcy5nZXRlbnYoJTIyT1BFTkFJX0FQSV9LRVklMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYlMkMlMjBtZXNzYWdlcyUyQyUyMHN0b3Bfc2VxdWVuY2VzJTNEJTVCJTVEKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTIwJTNEJTIwZ2V0X2NsZWFuX21lc3NhZ2VfbGlzdChtZXNzYWdlcyUyQyUyMHJvbGVfY29udmVyc2lvbnMlM0RvcGVuYWlfcm9sZV9jb252ZXJzaW9ucyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHNlbGYuY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEc2VsZi5tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0RtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0b3AlM0RzdG9wX3NlcXVlbmNlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNEMC41JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3BvbnNlLmNob2ljZXMlNUIwJTVELm1lc3NhZ2UuY29udGVudA==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

openai_role_conversions = {
    MessageRole.TOOL_RESPONSE: MessageRole.USER,
}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">OpenAIEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;gpt-4o&quot;</span></span>):
        self.model_name = model_name
        self.client = OpenAI(
            api_key=os.getenv(<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages, stop_sequences=[]</span>):
        messages = get_clean_message_list(messages, role_conversions=openai_role_conversions)

        response = self.client.chat.completions.create(
            model=self.model_name,
            messages=messages,
            stop=stop_sequences,
            temperature=<span class="hljs-number">0.5</span>,
        )
        <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content`,wrap:!1}}),Q=new L({props:{title:"Anthropic",local:"anthropic",headingTag:"h3"}}),S=new P({props:{code:"ZnJvbSUyMGFudGhyb3BpYyUyMGltcG9ydCUyMEFudGhyb3BpYyUyQyUyMEFudGhyb3BpY0JlZHJvY2slMEElMEElMEElMjMlMjBDZiUyMHRoaXMlMjBwYWdlJTIwZm9yJTIwdXNpbmclMjBBbnRocm9waWMlMjBmcm9tJTIwQmVkcm9jayUzQSUyMGh0dHBzJTNBJTJGJTJGZG9jcy5hbnRocm9waWMuY29tJTJGZW4lMkZhcGklMkZjbGF1ZGUtb24tYW1hem9uLWJlZHJvY2slMEFjbGFzcyUyMEFudGhyb3BpY0VuZ2luZSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBtb2RlbF9uYW1lJTNEJTIyY2xhdWRlLTMtNS1zb25uZXQtMjAyNDA2MjAlMjIlMkMlMjB1c2VfYmVkcm9jayUzREZhbHNlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWxfbmFtZSUyMCUzRCUyMG1vZGVsX25hbWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHVzZV9iZWRyb2NrJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbF9uYW1lJTIwJTNEJTIwJTIyYW50aHJvcGljLmNsYXVkZS0zLTUtc29ubmV0LTIwMjQwNjIwLXYxJTNBMCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2xpZW50JTIwJTNEJTIwQW50aHJvcGljQmVkcm9jayglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhd3NfYWNjZXNzX2tleSUzRG9zLmdldGVudiglMjJBV1NfQkVEUk9DS19JRCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhd3Nfc2VjcmV0X2tleSUzRG9zLmdldGVudiglMjJBV1NfQkVEUk9DS19LRVklMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXdzX3JlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5jbGllbnQlMjAlM0QlMjBBbnRocm9waWMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXBpX2tleSUzRG9zLmdldGVudiglMjJBTlRIUk9QSUNfQVBJX0tFWSUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMG1lc3NhZ2VzJTJDJTIwc3RvcF9zZXF1ZW5jZXMlM0QlNUIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWVzc2FnZXMlMjAlM0QlMjBnZXRfY2xlYW5fbWVzc2FnZV9saXN0KG1lc3NhZ2VzJTJDJTIwcm9sZV9jb252ZXJzaW9ucyUzRG9wZW5haV9yb2xlX2NvbnZlcnNpb25zKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluZGV4X3N5c3RlbV9tZXNzYWdlJTJDJTIwc3lzdGVtX3Byb21wdCUyMCUzRCUyME5vbmUlMkMlMjBOb25lJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwaW5kZXglMkMlMjBtZXNzYWdlJTIwaW4lMjBlbnVtZXJhdGUobWVzc2FnZXMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBtZXNzYWdlJTVCJTIycm9sZSUyMiU1RCUyMCUzRCUzRCUyME1lc3NhZ2VSb2xlLlNZU1RFTSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluZGV4X3N5c3RlbV9tZXNzYWdlJTIwJTNEJTIwaW5kZXglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzeXN0ZW1fcHJvbXB0JTIwJTNEJTIwbWVzc2FnZSU1QiUyMmNvbnRlbnQlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHN5c3RlbV9wcm9tcHQlMjBpcyUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYWlzZSUyMEV4Y2VwdGlvbiglMjJObyUyMHN5c3RlbSUyMHByb21wdCUyMGZvdW5kISUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaWx0ZXJlZF9tZXNzYWdlcyUyMCUzRCUyMCU1Qm1lc3NhZ2UlMjBmb3IlMjBpJTJDJTIwbWVzc2FnZSUyMGluJTIwZW51bWVyYXRlKG1lc3NhZ2VzKSUyMGlmJTIwaSUyMCElM0QlMjBpbmRleF9zeXN0ZW1fbWVzc2FnZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKGZpbHRlcmVkX21lc3NhZ2VzKSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCglMjJFcnJvciUyQyUyMG5vJTIwdXNlciUyMG1lc3NhZ2UlM0ElMjIlMkMlMjBtZXNzYWdlcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhc3NlcnQlMjBGYWxzZSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwc2VsZi5jbGllbnQubWVzc2FnZXMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEc2VsZi5tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3lzdGVtJTNEc3lzdGVtX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEZmlsdGVyZWRfbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdG9wX3NlcXVlbmNlcyUzRHN0b3Bfc2VxdWVuY2VzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfdG9rZW5zJTNEMjAwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmdWxsX3Jlc3BvbnNlX3RleHQlMjAlM0QlMjAlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBjb250ZW50X2Jsb2NrJTIwaW4lMjByZXNwb25zZS5jb250ZW50JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBjb250ZW50X2Jsb2NrLnR5cGUlMjAlM0QlM0QlMjAlMjJ0ZXh0JTIyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZnVsbF9yZXNwb25zZV90ZXh0JTIwJTJCJTNEJTIwY29udGVudF9ibG9jay50ZXh0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZnVsbF9yZXNwb25zZV90ZXh0",highlighted:`<span class="hljs-keyword">from</span> anthropic <span class="hljs-keyword">import</span> Anthropic, AnthropicBedrock


<span class="hljs-comment"># Cf this page for using Anthropic from Bedrock: https://docs.anthropic.com/en/api/claude-on-amazon-bedrock</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">AnthropicEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;claude-3-5-sonnet-20240620&quot;</span>, use_bedrock=<span class="hljs-literal">False</span></span>):
        self.model_name = model_name
        <span class="hljs-keyword">if</span> use_bedrock:
            self.model_name = <span class="hljs-string">&quot;anthropic.claude-3-5-sonnet-20240620-v1:0&quot;</span>
            self.client = AnthropicBedrock(
                aws_access_key=os.getenv(<span class="hljs-string">&quot;AWS_BEDROCK_ID&quot;</span>),
                aws_secret_key=os.getenv(<span class="hljs-string">&quot;AWS_BEDROCK_KEY&quot;</span>),
                aws_region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
            )
        <span class="hljs-keyword">else</span>:
            self.client = Anthropic(
                api_key=os.getenv(<span class="hljs-string">&quot;ANTHROPIC_API_KEY&quot;</span>),
            )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages, stop_sequences=[]</span>):
        messages = get_clean_message_list(messages, role_conversions=openai_role_conversions)
        index_system_message, system_prompt = <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>
        <span class="hljs-keyword">for</span> index, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
            <span class="hljs-keyword">if</span> message[<span class="hljs-string">&quot;role&quot;</span>] == MessageRole.SYSTEM:
                index_system_message = index
                system_prompt = message[<span class="hljs-string">&quot;content&quot;</span>]
        <span class="hljs-keyword">if</span> system_prompt <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            <span class="hljs-keyword">raise</span> Exception(<span class="hljs-string">&quot;No system prompt found!&quot;</span>)

        filtered_messages = [message <span class="hljs-keyword">for</span> i, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages) <span class="hljs-keyword">if</span> i != index_system_message]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(filtered_messages) == <span class="hljs-number">0</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Error, no user message:&quot;</span>, messages)
            <span class="hljs-keyword">assert</span> <span class="hljs-literal">False</span>

        response = self.client.messages.create(
            model=self.model_name,
            system=system_prompt,
            messages=filtered_messages,
            stop_sequences=stop_sequences,
            temperature=<span class="hljs-number">0.5</span>,
            max_tokens=<span class="hljs-number">2000</span>,
        )
        full_response_text = <span class="hljs-string">&quot;&quot;</span>
        <span class="hljs-keyword">for</span> content_block <span class="hljs-keyword">in</span> response.content:
            <span class="hljs-keyword">if</span> content_block.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;text&quot;</span>:
                full_response_text += content_block.text
        <span class="hljs-keyword">return</span> full_response_text`,wrap:!1}}),R=new L({props:{title:"Next steps",local:"next-steps",headingTag:"h3"}}),x=new as({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agent_change_llm.md"}}),{c(){T=a("meta"),D=n(),F=a("p"),K=n(),o(w.$$.fragment),O=n(),o(r.$$.fragment),ll=n(),m=a("p"),m.innerHTML=El,sl=n(),u=a("blockquote"),u.innerHTML=Vl,el=n(),I=a("p"),I.innerHTML=kl,tl=n(),C=a("p"),C.innerHTML=Wl,nl=n(),o(d.$$.fragment),Ml=n(),h=a("p"),h.innerHTML=Gl,al=n(),o(b.$$.fragment),yl=n(),A=a("pre"),A.textContent=zl,pl=n(),f=a("p"),f.innerHTML=Xl,ol=n(),o(g.$$.fragment),cl=n(),Z=a("p"),Z.textContent=vl,il=n(),_=a("ul"),_.innerHTML=Ql,jl=n(),N=a("p"),N.innerHTML=Sl,Ul=n(),o(B.$$.fragment),Jl=n(),E=a("p"),E.innerHTML=Rl,Tl=n(),V=a("p"),V.innerHTML=$l,wl=n(),k=a("p"),k.textContent=Hl,rl=n(),o(W.$$.fragment),ml=n(),G=a("p"),G.innerHTML=Yl,ul=n(),z=a("ul"),z.innerHTML=xl,Il=n(),o(X.$$.fragment),Cl=n(),o(v.$$.fragment),dl=n(),o(Q.$$.fragment),hl=n(),o(S.$$.fragment),bl=n(),o(R.$$.fragment),Al=n(),$=a("p"),$.innerHTML=Ll,fl=n(),H=a("p"),H.innerHTML=Fl,gl=n(),Y=a("ul"),Y.innerHTML=ql,Zl=n(),o(x.$$.fragment),_l=n(),q=a("p"),this.h()},l(l){const s=ts("svelte-u9bgzb",document.head);T=y(s,"META",{name:!0,content:!0}),s.forEach(e),D=M(l),F=y(l,"P",{}),Pl(F).forEach(e),K=M(l),c(w.$$.fragment,l),O=M(l),c(r.$$.fragment,l),ll=M(l),m=y(l,"P",{"data-svelte-h":!0}),p(m)!=="svelte-1xlqnsv"&&(m.innerHTML=El),sl=M(l),u=y(l,"BLOCKQUOTE",{"data-svelte-h":!0}),p(u)!=="svelte-e9c7ci"&&(u.innerHTML=Vl),el=M(l),I=y(l,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1ltjt5h"&&(I.innerHTML=kl),tl=M(l),C=y(l,"P",{"data-svelte-h":!0}),p(C)!=="svelte-yf816"&&(C.innerHTML=Wl),nl=M(l),c(d.$$.fragment,l),Ml=M(l),h=y(l,"P",{"data-svelte-h":!0}),p(h)!=="svelte-mten7z"&&(h.innerHTML=Gl),al=M(l),c(b.$$.fragment,l),yl=M(l),A=y(l,"PRE",{"data-svelte-h":!0}),p(A)!=="svelte-e1jlhm"&&(A.textContent=zl),pl=M(l),f=y(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-11qe1k7"&&(f.innerHTML=Xl),ol=M(l),c(g.$$.fragment,l),cl=M(l),Z=y(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-6rr6cb"&&(Z.textContent=vl),il=M(l),_=y(l,"UL",{"data-svelte-h":!0}),p(_)!=="svelte-1nt75bg"&&(_.innerHTML=Ql),jl=M(l),N=y(l,"P",{"data-svelte-h":!0}),p(N)!=="svelte-9ekoxy"&&(N.innerHTML=Sl),Ul=M(l),c(B.$$.fragment,l),Jl=M(l),E=y(l,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1tebd3j"&&(E.innerHTML=Rl),Tl=M(l),V=y(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1fzzy0z"&&(V.innerHTML=$l),wl=M(l),k=y(l,"P",{"data-svelte-h":!0}),p(k)!=="svelte-gyhx71"&&(k.textContent=Hl),rl=M(l),c(W.$$.fragment,l),ml=M(l),G=y(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1uswkmp"&&(G.innerHTML=Yl),ul=M(l),z=y(l,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-tdu1zn"&&(z.innerHTML=xl),Il=M(l),c(X.$$.fragment,l),Cl=M(l),c(v.$$.fragment,l),dl=M(l),c(Q.$$.fragment,l),hl=M(l),c(S.$$.fragment,l),bl=M(l),c(R.$$.fragment,l),Al=M(l),$=y(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-1b1f0uu"&&($.innerHTML=Ll),fl=M(l),H=y(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-10vua1y"&&(H.innerHTML=Fl),gl=M(l),Y=y(l,"UL",{"data-svelte-h":!0}),p(Y)!=="svelte-1s2n21i"&&(Y.innerHTML=ql),Zl=M(l),c(x.$$.fragment,l),_l=M(l),q=y(l,"P",{}),Pl(q).forEach(e),this.h()},h(){Dl(T,"name","hf:doc:metadata"),Dl(T,"content",ps)},m(l,s){ns(document.head,T),t(l,D,s),t(l,F,s),t(l,K,s),i(w,l,s),t(l,O,s),i(r,l,s),t(l,ll,s),t(l,m,s),t(l,sl,s),t(l,u,s),t(l,el,s),t(l,I,s),t(l,tl,s),t(l,C,s),t(l,nl,s),i(d,l,s),t(l,Ml,s),t(l,h,s),t(l,al,s),i(b,l,s),t(l,yl,s),t(l,A,s),t(l,pl,s),t(l,f,s),t(l,ol,s),i(g,l,s),t(l,cl,s),t(l,Z,s),t(l,il,s),t(l,_,s),t(l,jl,s),t(l,N,s),t(l,Ul,s),i(B,l,s),t(l,Jl,s),t(l,E,s),t(l,Tl,s),t(l,V,s),t(l,wl,s),t(l,k,s),t(l,rl,s),i(W,l,s),t(l,ml,s),t(l,G,s),t(l,ul,s),t(l,z,s),t(l,Il,s),i(X,l,s),t(l,Cl,s),i(v,l,s),t(l,dl,s),i(Q,l,s),t(l,hl,s),i(S,l,s),t(l,bl,s),i(R,l,s),t(l,Al,s),t(l,$,s),t(l,fl,s),t(l,H,s),t(l,gl,s),t(l,Y,s),t(l,Zl,s),i(x,l,s),t(l,_l,s),t(l,q,s),Nl=!0},p:Ol,i(l){Nl||(j(w.$$.fragment,l),j(r.$$.fragment,l),j(d.$$.fragment,l),j(b.$$.fragment,l),j(g.$$.fragment,l),j(B.$$.fragment,l),j(W.$$.fragment,l),j(X.$$.fragment,l),j(v.$$.fragment,l),j(Q.$$.fragment,l),j(S.$$.fragment,l),j(R.$$.fragment,l),j(x.$$.fragment,l),Nl=!0)},o(l){U(w.$$.fragment,l),U(r.$$.fragment,l),U(d.$$.fragment,l),U(b.$$.fragment,l),U(g.$$.fragment,l),U(B.$$.fragment,l),U(W.$$.fragment,l),U(X.$$.fragment,l),U(v.$$.fragment,l),U(Q.$$.fragment,l),U(S.$$.fragment,l),U(R.$$.fragment,l),U(x.$$.fragment,l),Nl=!1},d(l){l&&(e(D),e(F),e(K),e(O),e(ll),e(m),e(sl),e(u),e(el),e(I),e(tl),e(C),e(nl),e(Ml),e(h),e(al),e(yl),e(A),e(pl),e(f),e(ol),e(cl),e(Z),e(il),e(_),e(jl),e(N),e(Ul),e(Jl),e(E),e(Tl),e(V),e(wl),e(k),e(rl),e(ml),e(G),e(ul),e(z),e(Il),e(Cl),e(dl),e(hl),e(bl),e(Al),e($),e(fl),e(H),e(gl),e(Y),e(Zl),e(_l),e(q)),e(T),J(w,l),J(r,l),J(d,l),J(b,l),J(g,l),J(B,l),J(W,l),J(X,l),J(v,l),J(Q,l),J(S,l),J(R,l),J(x,l)}}}const ps='{"title":"Create a Transformers Agent from any LLM inference provider","local":"create-a-transformers-agent-from-any-llm-inference-provider","sections":[{"title":"HuggingFace Serverless API and Dedicated Endpoints","local":"huggingface-serverless-api-and-dedicated-endpoints","sections":[],"depth":2},{"title":"Adapting the recipe for any LLM","local":"adapting-the-recipe-for-any-llm","sections":[{"title":"OpenAI","local":"openai","sections":[],"depth":3},{"title":"Anthropic","local":"anthropic","sections":[],"depth":3},{"title":"Next steps","local":"next-steps","sections":[],"depth":3}],"depth":2}],"depth":1}';function os(Bl){return ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Js extends ss{constructor(T){super(),es(this,T,os,ys,Kl,{})}}export{Js as component};
