import{s as za,n as Ha,o as Ea}from"../chunks/scheduler.85c25b89.js";import{S as La,i as Sa,g as i,s,r as p,A as $a,h as r,f as a,c as n,j as Fe,u as c,x as o,k as Ae,l as R,y as u,a as t,v as m,d,t as M,w as h}from"../chunks/index.c9bcf812.js";import{D as la}from"../chunks/Docstring.46c9d080.js";import{C as U}from"../chunks/CodeBlock.94efc595.js";import{H as T,E as Qa}from"../chunks/EditOnGithub.ec73e7c7.js";function Da(aa){let _,Be,ke,xe,N,ze,G,ta="TRL supports custom reward modeling for anyone to perform reward modeling on their dataset and model.",He,V,Ee,W,sa='The <a href="/docs/trl/pr_1646/en/trainer#trl.RewardTrainer">RewardTrainer</a> expects a very specific format for the dataset since the model will be trained on pairs of examples to predict which of the two is preferred. We usually preprocess the dataset to have <code>chosen</code> and <code>rejected</code> examples using <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">Hugging Face’s chat template</a>. Here are some examples:',Le,k,na='<li><a href="https://huggingface.co/datasets/trl-internal-testing/sentiment-trl-style" rel="nofollow">trl-internal-testing/sentiment-trl-style</a></li> <li><a href="https://huggingface.co/datasets/trl-internal-testing/descriptiveness-trl-style" rel="nofollow">trl-internal-testing/descriptiveness-trl-style</a></li> <li><a href="https://huggingface.co/datasets/trl-internal-testing/tldr-preference-trl-style" rel="nofollow">trl-internal-testing/tldr-preference-trl-style</a></li> <li><a href="https://huggingface.co/datasets/trl-internal-testing/hh-rlhf-trl-style" rel="nofollow">trl-internal-testing/hh-rlhf-trl-style</a></li> <li><a href="https://huggingface.co/datasets/HuggingFaceH4/ultrafeedback_binarized" rel="nofollow">HuggingFaceH4/ultrafeedback_binarized</a></li>',Se,Y,ia="The dataset format roughly looks like the following:",$e,b,ra='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/hh-rlhf-helpful-base-trl-style%20.png?download=true" ,="" width="80%"/>',Qe,F,oa='The script to create these datasets can be found at <a href="https://github.com/huggingface/trl/tree/main/examples/datasets" rel="nofollow">https://github.com/huggingface/trl/tree/main/examples/datasets</a>',De,A,qe,B,pa='Here is a command to train a simple reward model on the sentiment dataset taken from <a href="https://arxiv.org/abs/1909.08593" rel="nofollow">https://arxiv.org/abs/1909.08593</a> using the <code>pythia-1b-deduped</code> model. The training should take for a few minutes on a single GPU.',Oe,x,Pe,z,Ke,H,ca=`You can use the <a href="/docs/trl/pr_1646/en/trainer#trl.RewardTrainer">RewardTrainer</a> in the same way as the <code>Trainer</code> class from 🤗 Transformers.
You should pass an <code>AutoModelForSequenceClassification</code> model to the <a href="/docs/trl/pr_1646/en/trainer#trl.RewardTrainer">RewardTrainer</a>, along with a <a href="/docs/trl/pr_1646/en/trainer#trl.RewardConfig">RewardConfig</a> which configures the hyperparameters of the training.`,el,E,ll,L,ma="Ultimately, the <code>RewardTrainer</code> takes tokenized data as inputs: the post-processed dataset object should contain the following entries",al,S,da="<li><code>input_ids_chosen</code></li> <li><code>attention_mask_chosen</code></li> <li><code>input_ids_rejected</code></li> <li><code>attention_mask_rejected</code></li>",tl,$,Ma="To make data processing easier, we typically deal with chat-style dataset. For example, a chosen or rejected chat message would look like the following <code>chat</code> variable. We can set the <code>tokenizer.chat_template</code> to a template string that will be used to tokenize the chat, then call <code>tokenizer.apply_chat_template</code> to tokenize the chat, like demonstrated below:",sl,Q,nl,D,ha="To make sure the tokenization process is as transparent as possible. We provide a <code>DatasetProcessor</code> class that can be used to tokenize the dataset and visualize the tokenization process. Here is an example of how to use it:",il,q,rl,O,ya="The <code>visualize_token</code> will output the following colored tokens:",ol,g,ua='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/Visualize token.png?download=true" ,="" width="80%"/>',pl,P,Ta="The <code>dataset_processor.get_token_length_visualization</code> will output the visualization on the token length for the <code>chosen</code>, <code>rejected</code> and <code>prompt</code> in <code>tmp.png</code>.",cl,j,Ja='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/token_length_visualization.png?download=true" ,="" width="80%"/>',ml,K,dl,ee,wa='The logged metrics are as follows. Here is an example <a href="https://wandb.ai/huggingface/trl/runs/7m41xyvm" rel="nofollow">tracked run at Weights and Biases</a>:',Ml,le,_a="<li><code>eval/accuracy</code>: The accuracy of the model on the evaluation dataset.</li> <li><code>eval/loss</code>: The loss of the model on a batch of the evaluation dataset.</li> <li><code>eval/runtime</code>: The runtime of the evaluation.</li> <li><code>eval/samples_per_second</code>: The number of samples processed per second during evaluation.</li> <li><code>eval/steps_per_second</code>: The number of steps processed per second during evaluation.</li> <li><code>total_flos</code>: The total number of floating operations done by the model since the beginning of training.</li> <li><code>train/epoch</code>: The epoch number throughout training (e.g., 3.3 means 3 epochs and 30% of the 4th epoch).</li> <li><code>train/global_step</code>: The step number throughout training.</li> <li><code>train/grad_norm</code>: The norm of the gradients.</li> <li><code>train/learning_rate</code>: The learning rate used during training.</li> <li><code>train/loss</code>: The loss of the model on a batch of the training dataset.</li>",hl,ae,yl,te,Ua='To help you understand what your model is doing, we periodically log some the produced reward logits of the trained model. Here is an example of a completion. In an <a href="https://wandb.ai/huggingface/trl/runs/7m41xyvm" rel="nofollow">example tracked run at Weights and Biases</a>, it looks like the following, allowing you to see the model’s reward logits at different stages of training. You can tune the frequency of the logging with the <code>--eval_strategy steps</code> and <code>--eval_steps=100</code> options.',ul,f,ba='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/rewardtrainer.gif?download=true" ,="" width="80%"/>',Tl,se,Jl,ne,ga="<li>Debugging TIP: <code>eval/accuracy</code>: this is the ultimate evaluation of the reward model training. Ideally it should keep going up.</li> <li>Debugging TIP: <code>train/loss</code>: this is the loss of the reward model’s objective, and it should keep going down.</li> <li>Debugging TIP: Always look into the dataset and the output reward logits which are logged in weights and biases to understand what the model is doing.</li> <li>Memory TIP: If you are running out of memory, you can try to reduce the <code>--per_device_train_batch_size</code> or increase the <code>--gradient_accumulation_steps</code> to reduce the memory footprint.</li> <li>Memory TIP: If you have multiple GPUs, you can also run training with DeepSpeed stage 3 to reduce the memory footprint <code>accelerate launch --config_file examples/accelerate_configs/deepspeed_zero3.yaml</code>.</li> <li>Usage TIP: Make sure you understand the dataset by looking the tokenized inputs: do something like <code>print(train_dataset[0][INPUT_IDS_CHOSEN_KEY])</code> and <code>print(tokenizer.decode(train_dataset[0][INPUT_IDS_CHOSEN_KEY]))</code>. You should also see the token length distribution by running <code>dataset_processor.get_token_length_visualization</code>. Make sure nothing weird happens like the token length being too long or too short. You can customize by tweaking the <code>max_token_length=1024</code> and <code>max_prompt_token_lenth=1024</code> options.</li>",wl,ie,_l,re,ja="To validate the RM implementation works, we ran some experimetns on TRL-style preference datasets.",Ul,oe,bl,pe,fa='<li><a href="https://huggingface.co/trl-internal-testing/rm_sentiment_1b" rel="nofollow">🤗 Trained model</a></li> <li><a href="https://wandb.ai/huggingface/trl/runs/kkboirll" rel="nofollow">🐝 Tracked experiment</a></li>',gl,v,va='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/benchmark/trl/pr-1646/rm_sentiment_1b.png?download=true"/>',jl,ce,fl,me,Za='<li><a href="https://huggingface.co/trl-internal-testing/rm_descriptiveness_1b" rel="nofollow">🤗 Trained model</a></li> <li><a href="https://wandb.ai/huggingface/trl/runs/g312ymwj" rel="nofollow">🐝 Tracked experiment</a></li>',vl,Z,Ia='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/benchmark/trl/pr-1646/rm_descriptiveness_1b.png?download=true"/>',Zl,de,Il,Me,Ca='<li><a href="https://huggingface.co/trl-internal-testing/rm_hh_1b" rel="nofollow">🤗 Trained model</a></li> <li><a href="https://wandb.ai/huggingface/trl/runs/g7pb8ooc" rel="nofollow">🐝 Tracked experiment</a></li>',Cl,I,Xa='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/benchmark/trl/pr-1646/rm_hh_1b.png?download=true"/>',Xl,he,Rl,ye,Ra='<li><a href="https://huggingface.co/trl-internal-testing/rm_tldr_1b" rel="nofollow">🤗 Trained model</a></li> <li><a href="https://wandb.ai/huggingface/trl/runs/o75i0ori" rel="nofollow">🐝 Tracked experiment</a></li>',Nl,C,Na='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/benchmark/trl/pr-1646/rm_tldr_1b.png?download=true"/>',Gl,ue,Vl,Te,Ga='Just pass a <code>peft_config</code> in the keyword arguments of <a href="/docs/trl/pr_1646/en/trainer#trl.RewardTrainer">RewardTrainer</a>, and the trainer should automatically take care of converting the model into a PEFT model!',Wl,Je,kl,we,Yl,_e,Va='As in the <a href="https://huggingface.co/papers/2307.09288" rel="nofollow">Llama 2 paper</a>, you can add a margin to the loss by adding a <code>margin</code> column to the dataset. The reward collator will automatically pass it through and the loss will be computed accordingly.',Fl,Ue,Al,be,Bl,w,ge,$l,Ie,Wa='RewardConfig collects all training arguments related to the <a href="/docs/trl/pr_1646/en/trainer#trl.RewardTrainer">RewardTrainer</a> class.',Ql,Ce,ka=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,xl,je,zl,y,fe,Dl,Xe,Ya=`The RewardTrainer can be used to train your custom Reward Model. It is a subclass of the
<code>transformers.Trainer</code> class and inherits all of its attributes and methods. It is recommended to use
an <code>AutoModelForSequenceClassification</code> as the reward model. The reward model should be trained on a dataset
of paired examples, where each example is a tuple of two sequences. The reward model should be trained to
predict which example in the pair is more relevant to the task at hand.`,ql,Re,Fa=`The reward trainer expects a very specific format for the dataset. The dataset should contain two 4 entries at least
if you don’t use the default <code>RewardDataCollatorWithPadding</code> data collator. The entries should be named`,Ol,Ne,Aa="<li><code>input_ids_chosen</code></li> <li><code>attention_mask_chosen</code></li> <li><code>input_ids_rejected</code></li> <li><code>attention_mask_rejected</code></li>",Pl,Ge,Ba=`Optionally, you can also pass a <code>margin</code> entry to the dataset. This entry should contain the margin used to modulate the
loss of the reward model as outlined in <a href="https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/" rel="nofollow">https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/</a>.
If you don’t pass a margin, no margin will be used.`,Kl,X,ve,ea,Ve,xa="Visualize the reward model logits prediction",Hl,Ze,El,Ye,Ll;return N=new T({props:{title:"Reward Modeling",local:"reward-modeling",headingTag:"h1"}}),V=new T({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),A=new T({props:{title:"Get started",local:"get-started",headingTag:"h2"}}),x=new U({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGcm0lMkZybS5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTIwdHJsLWludGVybmFsLXRlc3RpbmclMkZzZW50aW1lbnQtdHJsLXN0eWxlJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X3RyYWluX3NwbGl0JTIwdHJhaW4lMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXRfZXZhbF9zcGxpdCUyMHRlc3QlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1vZGVsX25hbWVfb3JfcGF0aCUyMEVsZXV0aGVyQUklMkZweXRoaWEtMWItZGVkdXBlZCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY2hhdF90ZW1wbGF0ZSUyMHNpbXBsZV9jb25jYXRfd2l0aF9zcGFjZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUyMDNlLTYlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDMyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUyMDMyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sb2dnaW5nX3N0ZXBzJTIwMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZXZhbF9zdHJhdGVneSUyMHN0ZXBzJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tYXhfdG9rZW5fbGVuZ3RoJTIwMTAyNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4X3Byb21wdF90b2tlbl9sZW50aCUyMDEwMjQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlbW92ZV91bnVzZWRfY29sdW1ucyUyMEZhbHNlJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1udW1fdHJhaW5fZXBvY2hzJTIwMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZXZhbF9zdGVwcyUzRDEwMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMG1vZGVscyUyRm1pbmltYWwlMkZybV9zZW50aW1lbnRfMWIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXB1c2hfdG9faHVi",highlighted:`python examples/scripts/rm/rm.py \\
    --dataset_name trl-internal-testing/sentiment-trl-style \\
    --dataset_train_split train \\
    --dataset_eval_split <span class="hljs-built_in">test</span> \\
    --model_name_or_path EleutherAI/pythia-1b-deduped \\
    --chat_template simple_concat_with_space \\
    --learning_rate 3e-6 \\
    --per_device_train_batch_size 32 \\
    --per_device_eval_batch_size 32 \\
    --gradient_accumulation_steps 1 \\
    --logging_steps 1 \\
    --eval_strategy steps \\
    --max_token_length 1024 \\
    --max_prompt_token_lenth 1024 \\
    --remove_unused_columns False \\
    --num_train_epochs 1 \\
    --eval_steps=100 \\
    --output_dir models/minimal/rm_sentiment_1b \\
    --push_to_hub`,wrap:!1}}),z=new T({props:{title:"How does it work?",local:"how-does-it-work",headingTag:"h2"}}),E=new T({props:{title:"Tokenization",local:"tokenization",headingTag:"h3"}}),Q=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFjaGF0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMGNhbiUyMEklMjBzdG9yZSUyMGZvb2QlMjBpZiUyMEklMjBkb24ndCUyMGhhdmUlMjBhJTIwcGFudHJ5JTNGJTIyJTJDJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwY291bGQlMjBzdG9yZSUyMHRoZSUyMGZvb2QlMjBpbiUyMGElMjByZWZyaWdlcmF0b3IlMkMlMjB0aGUlMjB0b3AlMjBjdXBib2FyZHMlMjBpbiUyMHlvdXIlMjBraXRjaGVuJTJDJTIwdGhlJTIwZnJlZXplciUyQyUyMG9yJTIwZXZlbiUyMGluJTIwYSUyMGhvbGUlMjBpbiUyMHRoZSUyMGdyb3VuZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTVEJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMCUyMiU3QiUyNSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTdCJTdCJyU1Q24lNUNuJyUyMGlmJTIwbm90JTIwbG9vcC5maXJzdCUyMGVsc2UlMjAnJyU3RCU3RCU3QiU3Qm1lc3NhZ2UlNUIncm9sZSclNUQlN0NjYXBpdGFsaXplJTIwJTJCJTIwJyUzQSUyMCclMjAlMkJtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTdCZW9zX3Rva2VuJTdEJTdEJTIyJTBBcHJpbnQodG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdCUyQyUyMHRva2VuaXplJTNERmFsc2UpKSUwQSUyMyUyMFVzZXIlM0ElMjBIb3clMjBjYW4lMjBJJTIwc3RvcmUlMjBmb29kJTIwaWYlMjBJJTIwZG9uJ3QlMjBoYXZlJTIwYSUyMHBhbnRyeSUzRiUwQSUyMyUwQSUyMyUyMEFzc2lzdGFudCUzQSUyMFlvdSUyMGNvdWxkJTIwc3RvcmUlMjB0aGUlMjBmb29kJTIwaW4lMjBhJTIwcmVmcmlnZXJhdG9yJTJDJTIwdGhlJTIwdG9wJTIwY3VwYm9hcmRzJTIwaW4lMjB5b3VyJTIwa2l0Y2hlbiUyQyUyMHRoZSUyMGZyZWV6ZXIlMkMlMjBvciUyMGV2ZW4lMjBpbiUyMGElMjBob2xlJTIwaW4lMjB0aGUlMjBncm91bmQuJTNDJTdDZW5kb2Z0ZXh0JTdDJTNF",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
chat = [
    {<span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How can I store food if I don&#x27;t have a pantry?&quot;</span>, <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>},
    {
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You could store the food in a refrigerator, the top cupboards in your kitchen, the freezer, or even in a hole in the ground.&quot;</span>,
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
    },
]
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
tokenizer.chat_template = <span class="hljs-string">&quot;{% for message in messages %}{{&#x27;\\n\\n&#x27; if not loop.first else &#x27;&#x27;}}{{message[&#x27;role&#x27;]|capitalize + &#x27;: &#x27; +message[&#x27;content&#x27;]}}{% endfor %}{{eos_token}}&quot;</span>
<span class="hljs-built_in">print</span>(tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>))
<span class="hljs-comment"># User: How can I store food if I don&#x27;t have a pantry?</span>
<span class="hljs-comment">#</span>
<span class="hljs-comment"># Assistant: You could store the food in a refrigerator, the top cupboards in your kitchen, the freezer, or even in a hole in the ground.&lt;|endoftext|&gt;</span>`,wrap:!1}}),q=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFmcm9tJTIwdHJsLmRhdGFzZXRfcHJvY2Vzc29yJTIwaW1wb3J0JTIwKCUwQSUyMCUyMCUyMCUyMENIQVRfVEVNUExBVEVTJTJDJTBBJTIwJTIwJTIwJTIwSU5QVVRfSURTX0NIT1NFTl9LRVklMkMlMEElMjAlMjAlMjAlMjBEYXRhc2V0Q29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwUHJlZmVyZW5jZURhdGFzZXRQcm9jZXNzb3IlMkMlMEElMjAlMjAlMjAlMjB2aXN1YWxpemVfdG9rZW4lMkMlMEEpJTBBZGF0YXNldF9jb25maWclMjAlM0QlMjBEYXRhc2V0Q29uZmlnKCUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfbmFtZSUzRCUyMnRybC1pbnRlcm5hbC10ZXN0aW5nJTJGc2VudGltZW50LXRybC1zdHlsZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGNoYXRfdGVtcGxhdGUlM0QlMjJzaW1wbGVfY2hhdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbl9sZW5ndGglM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Byb21wdF90b2tlbl9sZW50aCUzRDEwMjQlMkMlMEEpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMENIQVRfVEVNUExBVEVTJTVCJTIyc2ltcGxlX2NoYXQlMjIlNUQlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KGRhdGFzZXRfY29uZmlnLmRhdGFzZXRfbmFtZSklMEFkYXRhc2V0X3Byb2Nlc3NvciUyMCUzRCUyMFByZWZlcmVuY2VEYXRhc2V0UHJvY2Vzc29yKHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMGNvbmZpZyUzRGRhdGFzZXRfY29uZmlnKSUwQWRhdGFzZXRfcHJvY2Vzc29yLnNhbml0eV9jaGVja18oZGF0YXNldCklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldF9wcm9jZXNzb3IudG9rZW5pemUoZGF0YXNldCklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldF9wcm9jZXNzb3IuZmlsdGVyKGRhdGFzZXQpJTBBZGF0YXNldF9wcm9jZXNzb3IuZ2V0X3Rva2VuX2xlbmd0aF92aXN1YWxpemF0aW9uKGRhdGFzZXQlMkMlMjBzYXZlX3BhdGglM0QlMjJ0bXAucG5nJTIyKSUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0JTVCZGF0YXNldF9jb25maWcuZGF0YXNldF90cmFpbl9zcGxpdCU1RCUwQWV2YWxfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQlNUJkYXRhc2V0X2NvbmZpZy5kYXRhc2V0X2V2YWxfc3BsaXQlNUQlMEF2aXN1YWxpemVfdG9rZW4odHJhaW5fZGF0YXNldCU1QjAlNUQlNUJJTlBVVF9JRFNfQ0hPU0VOX0tFWSU1RCUyQyUyMHRva2VuaXplcik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl.dataset_processor <span class="hljs-keyword">import</span> (
    CHAT_TEMPLATES,
    INPUT_IDS_CHOSEN_KEY,
    DatasetConfig,
    PreferenceDatasetProcessor,
    visualize_token,
)
dataset_config = DatasetConfig(
    dataset_name=<span class="hljs-string">&quot;trl-internal-testing/sentiment-trl-style&quot;</span>,
    chat_template=<span class="hljs-string">&quot;simple_chat&quot;</span>,
    max_token_length=<span class="hljs-number">1024</span>,
    max_prompt_token_lenth=<span class="hljs-number">1024</span>,
)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
tokenizer.chat_template = CHAT_TEMPLATES[<span class="hljs-string">&quot;simple_chat&quot;</span>]
dataset = load_dataset(dataset_config.dataset_name)
dataset_processor = PreferenceDatasetProcessor(tokenizer=tokenizer, config=dataset_config)
dataset_processor.sanity_check_(dataset)
dataset = dataset_processor.tokenize(dataset)
dataset = dataset_processor.<span class="hljs-built_in">filter</span>(dataset)
dataset_processor.get_token_length_visualization(dataset, save_path=<span class="hljs-string">&quot;tmp.png&quot;</span>)
train_dataset = dataset[dataset_config.dataset_train_split]
eval_dataset = dataset[dataset_config.dataset_eval_split]
visualize_token(train_dataset[<span class="hljs-number">0</span>][INPUT_IDS_CHOSEN_KEY], tokenizer)`,wrap:!1}}),K=new T({props:{title:"Explanation of logged metrics",local:"explanation-of-logged-metrics",headingTag:"h2"}}),ae=new T({props:{title:"What is my model doing exactly?",local:"what-is-my-model-doing-exactly",headingTag:"h2"}}),se=new T({props:{title:"Cookbook",local:"cookbook",headingTag:"h2"}}),ie=new T({props:{title:"Benchmark experiments",local:"benchmark-experiments",headingTag:"h2"}}),oe=new U({props:{code:"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",highlighted:`python examples/scripts/rm/rm.py <span class="hljs-string">\\</span>
    --dataset_name trl-internal-testing/sentiment-trl-style <span class="hljs-string">\\</span>
    --dataset_train_split train <span class="hljs-string">\\</span>
    --dataset_eval_split test <span class="hljs-string">\\</span>
    --model_name_or_path EleutherAI/pythia-<span class="hljs-number">1b</span>-deduped <span class="hljs-string">\\</span>
    --chat_template simple_concat_with_space <span class="hljs-string">\\</span>
    --learning_rate <span class="hljs-number">3e-6</span> <span class="hljs-string">\\</span>
    --per_device_train_batch_size <span class="hljs-number">32</span> <span class="hljs-string">\\</span>
    --per_device_eval_batch_size <span class="hljs-number">32</span> <span class="hljs-string">\\</span>
    --gradient_accumulation_steps <span class="hljs-number">1</span> <span class="hljs-string">\\</span>
    --logging_steps <span class="hljs-number">1</span> <span class="hljs-string">\\</span>
    --eval_strategy steps <span class="hljs-string">\\</span>
    --max_token_length <span class="hljs-number">1024</span> <span class="hljs-string">\\</span>
    --max_prompt_token_lenth <span class="hljs-number">1024</span> <span class="hljs-string">\\</span>
    --remove_unused_columns False <span class="hljs-string">\\</span>
    --num_train_epochs <span class="hljs-number">1</span> <span class="hljs-string">\\</span>
    --eval_steps=<span class="hljs-number">100</span> <span class="hljs-string">\\</span>
    --output_dir models/rm/rm_sentiment_1b <span class="hljs-string">\\</span>
    --push_to_hub <span class="hljs-string">\\</span>
    --hub_model_id trl-internal-testing/rm_sentiment_1b

<span class="hljs-comment"># plot</span>
<span class="hljs-comment"># pip install openrlbenchmark==0.2.1a5</span>
python -m openrlbenchmark.rlops_multi_metrics <span class="hljs-string">\\</span>
    --filters <span class="hljs-string">&#x27;?we=huggingface&amp;wpn=trl&amp;xaxis=train/epoch&amp;ceik=output_dir&amp;cen=output_dir&amp;metrics=train/loss&amp;metrics=eval/accuracy&amp;metrics=eval/loss&amp;metrics=train/grad_norm&amp;metrics=train/learning_rate&amp;metrics=eval/runtime&amp;metrics=eval/samples_per_second&amp;metrics=eval/steps_per_second&#x27;</span> <span class="hljs-string">\\</span>
        <span class="hljs-string">&quot;models/rm/rm_sentiment_1b?tag=pr-1646&quot;</span> <span class="hljs-string">\\</span>
    --env-ids models/rm/rm_sentiment_1b <span class="hljs-string">\\</span>
    --pc.ncols <span class="hljs-number">4</span> <span class="hljs-string">\\</span>
    --pc.ncols-legend <span class="hljs-number">1</span> <span class="hljs-string">\\</span>
    --pc.xlabel <span class="hljs-string">&quot;Epoch&quot;</span> <span class="hljs-string">\\</span>
    --output-filename benchmark/trl/pr-<span class="hljs-number">1646</span>/rm_sentiment_1b <span class="hljs-string">\\</span>
    --scan-history`,wrap:!1}}),ce=new U({props:{code:"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",highlighted:`python examples/scripts/rm/rm.py <span class="hljs-string">\\</span>
    --dataset_name trl-internal-testing/descriptiveness-trl-style <span class="hljs-string">\\</span>
    --dataset_train_split train <span class="hljs-string">\\</span>
    --dataset_eval_split test <span class="hljs-string">\\</span>
    --model_name_or_path EleutherAI/pythia-<span class="hljs-number">1b</span>-deduped <span class="hljs-string">\\</span>
    --chat_template simple_concat_with_space <span class="hljs-string">\\</span>
    --learning_rate <span class="hljs-number">3e-6</span> <span class="hljs-string">\\</span>
    --per_device_train_batch_size <span class="hljs-number">32</span> <span class="hljs-string">\\</span>
    --per_device_eval_batch_size <span class="hljs-number">32</span> <span class="hljs-string">\\</span>
    --gradient_accumulation_steps <span class="hljs-number">1</span> <span class="hljs-string">\\</span>
    --logging_steps <span class="hljs-number">1</span> <span class="hljs-string">\\</span>
    --eval_strategy steps <span class="hljs-string">\\</span>
    --max_token_length <span class="hljs-number">1024</span> <span class="hljs-string">\\</span>
    --max_prompt_token_lenth <span class="hljs-number">1024</span> <span class="hljs-string">\\</span>
    --remove_unused_columns False <span class="hljs-string">\\</span>
    --num_train_epochs <span class="hljs-number">1</span> <span class="hljs-string">\\</span>
    --eval_steps=<span class="hljs-number">100</span> <span class="hljs-string">\\</span>
    --output_dir models/rm/rm_descriptiveness_1b <span class="hljs-string">\\</span>
    --push_to_hub <span class="hljs-string">\\</span>
    --hub_model_id trl-internal-testing/rm_descriptiveness_1b

<span class="hljs-comment"># plot</span>
<span class="hljs-comment"># pip install openrlbenchmark==0.2.1a5</span>
python -m openrlbenchmark.rlops_multi_metrics <span class="hljs-string">\\</span>
    --filters <span class="hljs-string">&#x27;?we=huggingface&amp;wpn=trl&amp;xaxis=train/epoch&amp;ceik=output_dir&amp;cen=output_dir&amp;metrics=train/loss&amp;metrics=eval/accuracy&amp;metrics=eval/loss&amp;metrics=train/grad_norm&amp;metrics=train/learning_rate&amp;metrics=eval/runtime&amp;metrics=eval/samples_per_second&amp;metrics=eval/steps_per_second&#x27;</span> <span class="hljs-string">\\</span>
        <span class="hljs-string">&quot;models/rm/rm_descriptiveness_1b?tag=pr-1646&quot;</span> <span class="hljs-string">\\</span>
    --env-ids models/rm/rm_descriptiveness_1b <span class="hljs-string">\\</span>
    --pc.ncols <span class="hljs-number">4</span> <span class="hljs-string">\\</span>
    --pc.ncols-legend <span class="hljs-number">1</span> <span class="hljs-string">\\</span>
    --pc.xlabel <span class="hljs-string">&quot;Epoch&quot;</span> <span class="hljs-string">\\</span>
    --output-filename benchmark/trl/pr-<span class="hljs-number">1646</span>/rm_descriptiveness_1b <span class="hljs-string">\\</span>
    --scan-history`,wrap:!1}}),de=new U({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tY29uZmlnX2ZpbGUlMjBleGFtcGxlcyUyRmFjY2VsZXJhdGVfY29uZmlncyUyRmRlZXBzcGVlZF96ZXJvMi55YW1sJTIwJTVDJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGcm0lMkZybS5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTIwdHJsLWludGVybmFsLXRlc3RpbmclMkZoaC1ybGhmLXRybC1zdHlsZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF90cmFpbl9zcGxpdCUyMHRyYWluJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X2V2YWxfc3BsaXQlMjB0ZXN0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBFbGV1dGhlckFJJTJGcHl0aGlhLTFiLWRlZHVwZWQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWNoYXRfdGVtcGxhdGUlMjBzaW1wbGVfY2hhdCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUyMDNlLTYlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDglMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTIwOCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIwNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbG9nZ2luZ19zdGVwcyUyMDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWV2YWxfc3RyYXRlZ3klMjBzdGVwcyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4X3Rva2VuX2xlbmd0aCUyMDEyODAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF9wcm9tcHRfdG9rZW5fbGVudGglMjAxMDI0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZW1vdmVfdW51c2VkX2NvbHVtbnMlMjBGYWxzZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWV2YWxfc3RlcHMlM0QzMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWJmMTYlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW91dHB1dF9kaXIlMjBtb2RlbHMlMkZybSUyRnJtX2hoXzFiJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wdXNoX3RvX2h1YiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0taHViX21vZGVsX2lkJTIwdHJsLWludGVybmFsLXRlc3RpbmclMkZybV9oaF8xYiUwQSUwQSUyMyUyMHBsb3QlMEElMjMlMjBwaXAlMjBpbnN0YWxsJTIwb3BlbnJsYmVuY2htYXJrJTNEJTNEMC4yLjFhNSUwQXB5dGhvbiUyMC1tJTIwb3BlbnJsYmVuY2htYXJrLnJsb3BzX211bHRpX21ldHJpY3MlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWZpbHRlcnMlMjAnJTNGd2UlM0RodWdnaW5nZmFjZSUyNndwbiUzRHRybCUyNnhheGlzJTNEdHJhaW4lMkZlcG9jaCUyNmNlaWslM0RvdXRwdXRfZGlyJTI2Y2VuJTNEb3V0cHV0X2RpciUyNm1ldHJpY3MlM0R0cmFpbiUyRmxvc3MlMjZtZXRyaWNzJTNEZXZhbCUyRmFjY3VyYWN5JTI2bWV0cmljcyUzRGV2YWwlMkZsb3NzJTI2bWV0cmljcyUzRHRyYWluJTJGZ3JhZF9ub3JtJTI2bWV0cmljcyUzRHRyYWluJTJGbGVhcm5pbmdfcmF0ZSUyNm1ldHJpY3MlM0RldmFsJTJGcnVudGltZSUyNm1ldHJpY3MlM0RldmFsJTJGc2FtcGxlc19wZXJfc2Vjb25kJTI2bWV0cmljcyUzRGV2YWwlMkZzdGVwc19wZXJfc2Vjb25kJyUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1vZGVscyUyRnJtJTJGcm1faGhfMWIlM0Z0YWclM0Rwci0xNjQ2JTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1lbnYtaWRzJTIwbW9kZWxzJTJGcm0lMkZybV9oaF8xYiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcGMubmNvbHMlMjA0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wYy5uY29scy1sZWdlbmQlMjAxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wYy54bGFiZWwlMjAlMjJFcG9jaCUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0LWZpbGVuYW1lJTIwYmVuY2htYXJrJTJGdHJsJTJGcHItMTY0NiUyRnJtX2hoXzFiJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1zY2FuLWhpc3Rvcnk=",highlighted:`accelerate launch --config_file examples/accelerate_configs/deepspeed_zero2.yaml <span class="hljs-string">\\</span>
    examples/scripts/rm/rm.py <span class="hljs-string">\\</span>
    --dataset_name trl-internal-testing/hh-rlhf-trl-style <span class="hljs-string">\\</span>
    --dataset_train_split train <span class="hljs-string">\\</span>
    --dataset_eval_split test <span class="hljs-string">\\</span>
    --model_name_or_path EleutherAI/pythia-<span class="hljs-number">1b</span>-deduped <span class="hljs-string">\\</span>
    --chat_template simple_chat <span class="hljs-string">\\</span>
    --learning_rate <span class="hljs-number">3e-6</span> <span class="hljs-string">\\</span>
    --per_device_train_batch_size <span class="hljs-number">8</span> <span class="hljs-string">\\</span>
    --per_device_eval_batch_size <span class="hljs-number">8</span> <span class="hljs-string">\\</span>
    --gradient_accumulation_steps <span class="hljs-number">4</span> <span class="hljs-string">\\</span>
    --logging_steps <span class="hljs-number">1</span> <span class="hljs-string">\\</span>
    --eval_strategy steps <span class="hljs-string">\\</span>
    --max_token_length <span class="hljs-number">1280</span> <span class="hljs-string">\\</span>
    --max_prompt_token_lenth <span class="hljs-number">1024</span> <span class="hljs-string">\\</span>
    --remove_unused_columns False <span class="hljs-string">\\</span>
    --num_train_epochs <span class="hljs-number">1</span> <span class="hljs-string">\\</span>
    --eval_steps=<span class="hljs-number">300</span> <span class="hljs-string">\\</span>
    --bf16 <span class="hljs-string">\\</span>
    --output_dir models/rm/rm_hh_1b <span class="hljs-string">\\</span>
    --push_to_hub <span class="hljs-string">\\</span>
    --hub_model_id trl-internal-testing/rm_hh_1b

<span class="hljs-comment"># plot</span>
<span class="hljs-comment"># pip install openrlbenchmark==0.2.1a5</span>
python -m openrlbenchmark.rlops_multi_metrics <span class="hljs-string">\\</span>
    --filters <span class="hljs-string">&#x27;?we=huggingface&amp;wpn=trl&amp;xaxis=train/epoch&amp;ceik=output_dir&amp;cen=output_dir&amp;metrics=train/loss&amp;metrics=eval/accuracy&amp;metrics=eval/loss&amp;metrics=train/grad_norm&amp;metrics=train/learning_rate&amp;metrics=eval/runtime&amp;metrics=eval/samples_per_second&amp;metrics=eval/steps_per_second&#x27;</span> <span class="hljs-string">\\</span>
        <span class="hljs-string">&quot;models/rm/rm_hh_1b?tag=pr-1646&quot;</span> <span class="hljs-string">\\</span>
    --env-ids models/rm/rm_hh_1b <span class="hljs-string">\\</span>
    --pc.ncols <span class="hljs-number">4</span> <span class="hljs-string">\\</span>
    --pc.ncols-legend <span class="hljs-number">1</span> <span class="hljs-string">\\</span>
    --pc.xlabel <span class="hljs-string">&quot;Epoch&quot;</span> <span class="hljs-string">\\</span>
    --output-filename benchmark/trl/pr-<span class="hljs-number">1646</span>/rm_hh_1b <span class="hljs-string">\\</span>
    --scan-history`,wrap:!1}}),he=new U({props:{code:"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",highlighted:`accelerate launch --config_file examples/accelerate_configs/deepspeed_zero2.yaml <span class="hljs-string">\\</span>
    examples/scripts/rm/rm.py <span class="hljs-string">\\</span>
    --dataset_name trl-internal-testing/tldr-preference-trl-style <span class="hljs-string">\\</span>
    --dataset_train_split train <span class="hljs-string">\\</span>
    --dataset_eval_split validation <span class="hljs-string">\\</span>
    --model_name_or_path EleutherAI/pythia-<span class="hljs-number">1b</span>-deduped <span class="hljs-string">\\</span>
    --chat_template simple_concat_with_space <span class="hljs-string">\\</span>
    --learning_rate <span class="hljs-number">3e-6</span> <span class="hljs-string">\\</span>
    --per_device_train_batch_size <span class="hljs-number">8</span> <span class="hljs-string">\\</span>
    --per_device_eval_batch_size <span class="hljs-number">8</span> <span class="hljs-string">\\</span>
    --gradient_accumulation_steps <span class="hljs-number">4</span> <span class="hljs-string">\\</span>
    --logging_steps <span class="hljs-number">1</span> <span class="hljs-string">\\</span>
    --eval_strategy steps <span class="hljs-string">\\</span>
    --max_token_length <span class="hljs-number">1280</span> <span class="hljs-string">\\</span>
    --max_prompt_token_lenth <span class="hljs-number">1024</span> <span class="hljs-string">\\</span>
    --remove_unused_columns False <span class="hljs-string">\\</span>
    --num_train_epochs <span class="hljs-number">1</span> <span class="hljs-string">\\</span>
    --eval_steps=<span class="hljs-number">300</span> <span class="hljs-string">\\</span>
    --bf16 <span class="hljs-string">\\</span>
    --output_dir models/rm/rm_tldr_1b <span class="hljs-string">\\</span>
    --push_to_hub <span class="hljs-string">\\</span>
    --hub_model_id trl-internal-testing/rm_tldr_1b

<span class="hljs-comment"># plot</span>
<span class="hljs-comment"># pip install openrlbenchmark==0.2.1a5</span>
python -m openrlbenchmark.rlops_multi_metrics <span class="hljs-string">\\</span>
    --filters <span class="hljs-string">&#x27;?we=huggingface&amp;wpn=trl&amp;xaxis=train/epoch&amp;ceik=output_dir&amp;cen=output_dir&amp;metrics=train/loss&amp;metrics=eval/accuracy&amp;metrics=eval/loss&amp;metrics=train/grad_norm&amp;metrics=train/learning_rate&amp;metrics=eval/runtime&amp;metrics=eval/samples_per_second&amp;metrics=eval/steps_per_second&#x27;</span> <span class="hljs-string">\\</span>
        <span class="hljs-string">&quot;models/rm/rm_tldr_1b?tag=pr-1646&quot;</span> <span class="hljs-string">\\</span>
    --env-ids models/rm/rm_tldr_1b <span class="hljs-string">\\</span>
    --pc.ncols <span class="hljs-number">4</span> <span class="hljs-string">\\</span>
    --pc.ncols-legend <span class="hljs-number">1</span> <span class="hljs-string">\\</span>
    --pc.xlabel <span class="hljs-string">&quot;Epoch&quot;</span> <span class="hljs-string">\\</span>
    --output-filename benchmark/trl/pr-<span class="hljs-number">1646</span>/rm_tldr_1b <span class="hljs-string">\\</span>
    --scan-history`,wrap:!1}}),ue=new T({props:{title:"Leveraging 🤗 PEFT to train a reward model",local:"leveraging--peft-to-train-a-reward-model",headingTag:"h2"}}),Je=new U({props:{code:"JTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, TaskType
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> RewardTrainer, RewardConfig

model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
peft_config = LoraConfig(
    task_type=TaskType.SEQ_CLS,
    inference_mode=<span class="hljs-literal">False</span>,
    r=<span class="hljs-number">8</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
)

...

trainer = RewardTrainer(
    model=model,
    args=training_args,
    tokenizer=tokenizer,
    train_dataset=dataset,
    peft_config=peft_config,
)

trainer.train()
`,wrap:!1}}),we=new T({props:{title:"Adding a margin to the loss",local:"adding-a-margin-to-the-loss",headingTag:"h3"}}),Ue=new U({props:{code:"ZGVmJTIwYWRkX21hcmdpbihyb3cpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQXNzdW1lJTIweW91JTIwaGF2ZSUyMGElMjBzY29yZV9jaG9zZW4lMjBhbmQlMjBzY29yZV9yZWplY3RlZCUyMGNvbHVtbnMlMjB0aGF0JTIweW91JTIwd2FudCUyMHRvJTIwdXNlJTIwdG8lMjBjb21wdXRlJTIwdGhlJTIwbWFyZ2luJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJ21hcmdpbiclM0ElMjByb3clNUInc2NvcmVfY2hvc2VuJyU1RCUyMC0lMjByb3clNUInc2NvcmVfcmVqZWN0ZWQnJTVEJTdEJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGFkZF9tYXJnaW4p",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">add_margin</span>(<span class="hljs-params">row</span>):
    <span class="hljs-comment"># Assume you have a score_chosen and score_rejected columns that you want to use to compute the margin</span>
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&#x27;margin&#x27;</span>: row[<span class="hljs-string">&#x27;score_chosen&#x27;</span>] - row[<span class="hljs-string">&#x27;score_rejected&#x27;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(add_margin)`,wrap:!1}}),be=new T({props:{title:"RewardConfig",local:"trl.RewardConfig",headingTag:"h2"}}),ge=new la({props:{name:"class trl.RewardConfig",anchor:"trl.RewardConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"trl.RewardConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.RewardConfig.gradient_checkpointing",description:`<strong>gradient_checkpointing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If True, use gradient checkpointing to save memory at the expense of slower backward pass.`,name:"gradient_checkpointing"}],source:"https://github.com/huggingface/trl/blob/vr_1646/trl/trainer/reward_config.py#L21"}}),je=new T({props:{title:"RewardTrainer",local:"trl.RewardTrainer",headingTag:"h2"}}),fe=new la({props:{name:"class trl.RewardTrainer",anchor:"trl.RewardTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/vr_1646/trl/trainer/reward_trainer.py#L48"}}),ve=new la({props:{name:"visualize_samples",anchor:"trl.RewardTrainer.visualize_samples",parameters:[{name:"num_print_samples",val:": int"}],parametersDescription:[{anchor:"trl.RewardTrainer.visualize_samples.num_print_samples",description:`<strong>num_print_samples</strong> (<code>int</code>, defaults to <code>4</code>) &#x2014;
The number of samples to print. Set to <code>-1</code> to print all samples.`,name:"num_print_samples"}],source:"https://github.com/huggingface/trl/blob/vr_1646/trl/trainer/reward_trainer.py#L282"}}),Ze=new Qa({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/reward_trainer.md"}}),{c(){_=i("meta"),Be=s(),ke=i("p"),xe=s(),p(N.$$.fragment),ze=s(),G=i("p"),G.textContent=ta,He=s(),p(V.$$.fragment),Ee=s(),W=i("p"),W.innerHTML=sa,Le=s(),k=i("ul"),k.innerHTML=na,Se=s(),Y=i("p"),Y.textContent=ia,$e=s(),b=i("div"),b.innerHTML=ra,Qe=s(),F=i("p"),F.innerHTML=oa,De=s(),p(A.$$.fragment),qe=s(),B=i("p"),B.innerHTML=pa,Oe=s(),p(x.$$.fragment),Pe=s(),p(z.$$.fragment),Ke=s(),H=i("p"),H.innerHTML=ca,el=s(),p(E.$$.fragment),ll=s(),L=i("p"),L.innerHTML=ma,al=s(),S=i("ul"),S.innerHTML=da,tl=s(),$=i("p"),$.innerHTML=Ma,sl=s(),p(Q.$$.fragment),nl=s(),D=i("p"),D.innerHTML=ha,il=s(),p(q.$$.fragment),rl=s(),O=i("p"),O.innerHTML=ya,ol=s(),g=i("div"),g.innerHTML=ua,pl=s(),P=i("p"),P.innerHTML=Ta,cl=s(),j=i("div"),j.innerHTML=Ja,ml=s(),p(K.$$.fragment),dl=s(),ee=i("p"),ee.innerHTML=wa,Ml=s(),le=i("ul"),le.innerHTML=_a,hl=s(),p(ae.$$.fragment),yl=s(),te=i("p"),te.innerHTML=Ua,ul=s(),f=i("div"),f.innerHTML=ba,Tl=s(),p(se.$$.fragment),Jl=s(),ne=i("ul"),ne.innerHTML=ga,wl=s(),p(ie.$$.fragment),_l=s(),re=i("p"),re.textContent=ja,Ul=s(),p(oe.$$.fragment),bl=s(),pe=i("ul"),pe.innerHTML=fa,gl=s(),v=i("div"),v.innerHTML=va,jl=s(),p(ce.$$.fragment),fl=s(),me=i("ul"),me.innerHTML=Za,vl=s(),Z=i("div"),Z.innerHTML=Ia,Zl=s(),p(de.$$.fragment),Il=s(),Me=i("ul"),Me.innerHTML=Ca,Cl=s(),I=i("div"),I.innerHTML=Xa,Xl=s(),p(he.$$.fragment),Rl=s(),ye=i("ul"),ye.innerHTML=Ra,Nl=s(),C=i("div"),C.innerHTML=Na,Gl=s(),p(ue.$$.fragment),Vl=s(),Te=i("p"),Te.innerHTML=Ga,Wl=s(),p(Je.$$.fragment),kl=s(),p(we.$$.fragment),Yl=s(),_e=i("p"),_e.innerHTML=Va,Fl=s(),p(Ue.$$.fragment),Al=s(),p(be.$$.fragment),Bl=s(),w=i("div"),p(ge.$$.fragment),$l=s(),Ie=i("p"),Ie.innerHTML=Wa,Ql=s(),Ce=i("p"),Ce.innerHTML=ka,xl=s(),p(je.$$.fragment),zl=s(),y=i("div"),p(fe.$$.fragment),Dl=s(),Xe=i("p"),Xe.innerHTML=Ya,ql=s(),Re=i("p"),Re.innerHTML=Fa,Ol=s(),Ne=i("ul"),Ne.innerHTML=Aa,Pl=s(),Ge=i("p"),Ge.innerHTML=Ba,Kl=s(),X=i("div"),p(ve.$$.fragment),ea=s(),Ve=i("p"),Ve.textContent=xa,Hl=s(),p(Ze.$$.fragment),El=s(),Ye=i("p"),this.h()},l(e){const l=$a("svelte-u9bgzb",document.head);_=r(l,"META",{name:!0,content:!0}),l.forEach(a),Be=n(e),ke=r(e,"P",{}),Fe(ke).forEach(a),xe=n(e),c(N.$$.fragment,e),ze=n(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-wgcft"&&(G.textContent=ta),He=n(e),c(V.$$.fragment,e),Ee=n(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-n5vh3"&&(W.innerHTML=sa),Le=n(e),k=r(e,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-1ld9qbc"&&(k.innerHTML=na),Se=n(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1nw9wf9"&&(Y.textContent=ia),$e=n(e),b=r(e,"DIV",{style:!0,"data-svelte-h":!0}),o(b)!=="svelte-1knzbsa"&&(b.innerHTML=ra),Qe=n(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1p8snqs"&&(F.innerHTML=oa),De=n(e),c(A.$$.fragment,e),qe=n(e),B=r(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1vux3hh"&&(B.innerHTML=pa),Oe=n(e),c(x.$$.fragment,e),Pe=n(e),c(z.$$.fragment,e),Ke=n(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1qw9wq9"&&(H.innerHTML=ca),el=n(e),c(E.$$.fragment,e),ll=n(e),L=r(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-17cjs0g"&&(L.innerHTML=ma),al=n(e),S=r(e,"UL",{"data-svelte-h":!0}),o(S)!=="svelte-1ytuxgw"&&(S.innerHTML=da),tl=n(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1jpacfj"&&($.innerHTML=Ma),sl=n(e),c(Q.$$.fragment,e),nl=n(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-pmn5qc"&&(D.innerHTML=ha),il=n(e),c(q.$$.fragment,e),rl=n(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1fj5tmn"&&(O.innerHTML=ya),ol=n(e),g=r(e,"DIV",{style:!0,"data-svelte-h":!0}),o(g)!=="svelte-148toa3"&&(g.innerHTML=ua),pl=n(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-19kbvmc"&&(P.innerHTML=Ta),cl=n(e),j=r(e,"DIV",{style:!0,"data-svelte-h":!0}),o(j)!=="svelte-c8k3od"&&(j.innerHTML=Ja),ml=n(e),c(K.$$.fragment,e),dl=n(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1bfmukj"&&(ee.innerHTML=wa),Ml=n(e),le=r(e,"UL",{"data-svelte-h":!0}),o(le)!=="svelte-1uevnk"&&(le.innerHTML=_a),hl=n(e),c(ae.$$.fragment,e),yl=n(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-a144ir"&&(te.innerHTML=Ua),ul=n(e),f=r(e,"DIV",{style:!0,"data-svelte-h":!0}),o(f)!=="svelte-1gl73ol"&&(f.innerHTML=ba),Tl=n(e),c(se.$$.fragment,e),Jl=n(e),ne=r(e,"UL",{"data-svelte-h":!0}),o(ne)!=="svelte-1ks91gm"&&(ne.innerHTML=ga),wl=n(e),c(ie.$$.fragment,e),_l=n(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1craqpv"&&(re.textContent=ja),Ul=n(e),c(oe.$$.fragment,e),bl=n(e),pe=r(e,"UL",{"data-svelte-h":!0}),o(pe)!=="svelte-uxdlqm"&&(pe.innerHTML=fa),gl=n(e),v=r(e,"DIV",{style:!0,"data-svelte-h":!0}),o(v)!=="svelte-lt5sg4"&&(v.innerHTML=va),jl=n(e),c(ce.$$.fragment,e),fl=n(e),me=r(e,"UL",{"data-svelte-h":!0}),o(me)!=="svelte-jb4s8e"&&(me.innerHTML=Za),vl=n(e),Z=r(e,"DIV",{style:!0,"data-svelte-h":!0}),o(Z)!=="svelte-1kr3l24"&&(Z.innerHTML=Ia),Zl=n(e),c(de.$$.fragment,e),Il=n(e),Me=r(e,"UL",{"data-svelte-h":!0}),o(Me)!=="svelte-z0cd5g"&&(Me.innerHTML=Ca),Cl=n(e),I=r(e,"DIV",{style:!0,"data-svelte-h":!0}),o(I)!=="svelte-1ee3a37"&&(I.innerHTML=Xa),Xl=n(e),c(he.$$.fragment,e),Rl=n(e),ye=r(e,"UL",{"data-svelte-h":!0}),o(ye)!=="svelte-1ywjuaj"&&(ye.innerHTML=Ra),Nl=n(e),C=r(e,"DIV",{style:!0,"data-svelte-h":!0}),o(C)!=="svelte-1vln7sh"&&(C.innerHTML=Na),Gl=n(e),c(ue.$$.fragment,e),Vl=n(e),Te=r(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-pnhwey"&&(Te.innerHTML=Ga),Wl=n(e),c(Je.$$.fragment,e),kl=n(e),c(we.$$.fragment,e),Yl=n(e),_e=r(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-175anp9"&&(_e.innerHTML=Va),Fl=n(e),c(Ue.$$.fragment,e),Al=n(e),c(be.$$.fragment,e),Bl=n(e),w=r(e,"DIV",{class:!0});var We=Fe(w);c(ge.$$.fragment,We),$l=n(We),Ie=r(We,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-4o497o"&&(Ie.innerHTML=Wa),Ql=n(We),Ce=r(We,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1xl7jqc"&&(Ce.innerHTML=ka),We.forEach(a),xl=n(e),c(je.$$.fragment,e),zl=n(e),y=r(e,"DIV",{class:!0});var J=Fe(y);c(fe.$$.fragment,J),Dl=n(J),Xe=r(J,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-qafafj"&&(Xe.innerHTML=Ya),ql=n(J),Re=r(J,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-bkmbwh"&&(Re.innerHTML=Fa),Ol=n(J),Ne=r(J,"UL",{"data-svelte-h":!0}),o(Ne)!=="svelte-1ytuxgw"&&(Ne.innerHTML=Aa),Pl=n(J),Ge=r(J,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-18tbp4c"&&(Ge.innerHTML=Ba),Kl=n(J),X=r(J,"DIV",{class:!0});var Sl=Fe(X);c(ve.$$.fragment,Sl),ea=n(Sl),Ve=r(Sl,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-1g38ldc"&&(Ve.textContent=xa),Sl.forEach(a),J.forEach(a),Hl=n(e),c(Ze.$$.fragment,e),El=n(e),Ye=r(e,"P",{}),Fe(Ye).forEach(a),this.h()},h(){Ae(_,"name","hf:doc:metadata"),Ae(_,"content",qa),R(b,"text-align","center"),R(g,"text-align","center"),R(j,"text-align","center"),R(f,"text-align","center"),R(v,"text-align","center"),R(Z,"text-align","center"),R(I,"text-align","center"),R(C,"text-align","center"),Ae(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Ae(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Ae(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){u(document.head,_),t(e,Be,l),t(e,ke,l),t(e,xe,l),m(N,e,l),t(e,ze,l),t(e,G,l),t(e,He,l),m(V,e,l),t(e,Ee,l),t(e,W,l),t(e,Le,l),t(e,k,l),t(e,Se,l),t(e,Y,l),t(e,$e,l),t(e,b,l),t(e,Qe,l),t(e,F,l),t(e,De,l),m(A,e,l),t(e,qe,l),t(e,B,l),t(e,Oe,l),m(x,e,l),t(e,Pe,l),m(z,e,l),t(e,Ke,l),t(e,H,l),t(e,el,l),m(E,e,l),t(e,ll,l),t(e,L,l),t(e,al,l),t(e,S,l),t(e,tl,l),t(e,$,l),t(e,sl,l),m(Q,e,l),t(e,nl,l),t(e,D,l),t(e,il,l),m(q,e,l),t(e,rl,l),t(e,O,l),t(e,ol,l),t(e,g,l),t(e,pl,l),t(e,P,l),t(e,cl,l),t(e,j,l),t(e,ml,l),m(K,e,l),t(e,dl,l),t(e,ee,l),t(e,Ml,l),t(e,le,l),t(e,hl,l),m(ae,e,l),t(e,yl,l),t(e,te,l),t(e,ul,l),t(e,f,l),t(e,Tl,l),m(se,e,l),t(e,Jl,l),t(e,ne,l),t(e,wl,l),m(ie,e,l),t(e,_l,l),t(e,re,l),t(e,Ul,l),m(oe,e,l),t(e,bl,l),t(e,pe,l),t(e,gl,l),t(e,v,l),t(e,jl,l),m(ce,e,l),t(e,fl,l),t(e,me,l),t(e,vl,l),t(e,Z,l),t(e,Zl,l),m(de,e,l),t(e,Il,l),t(e,Me,l),t(e,Cl,l),t(e,I,l),t(e,Xl,l),m(he,e,l),t(e,Rl,l),t(e,ye,l),t(e,Nl,l),t(e,C,l),t(e,Gl,l),m(ue,e,l),t(e,Vl,l),t(e,Te,l),t(e,Wl,l),m(Je,e,l),t(e,kl,l),m(we,e,l),t(e,Yl,l),t(e,_e,l),t(e,Fl,l),m(Ue,e,l),t(e,Al,l),m(be,e,l),t(e,Bl,l),t(e,w,l),m(ge,w,null),u(w,$l),u(w,Ie),u(w,Ql),u(w,Ce),t(e,xl,l),m(je,e,l),t(e,zl,l),t(e,y,l),m(fe,y,null),u(y,Dl),u(y,Xe),u(y,ql),u(y,Re),u(y,Ol),u(y,Ne),u(y,Pl),u(y,Ge),u(y,Kl),u(y,X),m(ve,X,null),u(X,ea),u(X,Ve),t(e,Hl,l),m(Ze,e,l),t(e,El,l),t(e,Ye,l),Ll=!0},p:Ha,i(e){Ll||(d(N.$$.fragment,e),d(V.$$.fragment,e),d(A.$$.fragment,e),d(x.$$.fragment,e),d(z.$$.fragment,e),d(E.$$.fragment,e),d(Q.$$.fragment,e),d(q.$$.fragment,e),d(K.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(he.$$.fragment,e),d(ue.$$.fragment,e),d(Je.$$.fragment,e),d(we.$$.fragment,e),d(Ue.$$.fragment,e),d(be.$$.fragment,e),d(ge.$$.fragment,e),d(je.$$.fragment,e),d(fe.$$.fragment,e),d(ve.$$.fragment,e),d(Ze.$$.fragment,e),Ll=!0)},o(e){M(N.$$.fragment,e),M(V.$$.fragment,e),M(A.$$.fragment,e),M(x.$$.fragment,e),M(z.$$.fragment,e),M(E.$$.fragment,e),M(Q.$$.fragment,e),M(q.$$.fragment,e),M(K.$$.fragment,e),M(ae.$$.fragment,e),M(se.$$.fragment,e),M(ie.$$.fragment,e),M(oe.$$.fragment,e),M(ce.$$.fragment,e),M(de.$$.fragment,e),M(he.$$.fragment,e),M(ue.$$.fragment,e),M(Je.$$.fragment,e),M(we.$$.fragment,e),M(Ue.$$.fragment,e),M(be.$$.fragment,e),M(ge.$$.fragment,e),M(je.$$.fragment,e),M(fe.$$.fragment,e),M(ve.$$.fragment,e),M(Ze.$$.fragment,e),Ll=!1},d(e){e&&(a(Be),a(ke),a(xe),a(ze),a(G),a(He),a(Ee),a(W),a(Le),a(k),a(Se),a(Y),a($e),a(b),a(Qe),a(F),a(De),a(qe),a(B),a(Oe),a(Pe),a(Ke),a(H),a(el),a(ll),a(L),a(al),a(S),a(tl),a($),a(sl),a(nl),a(D),a(il),a(rl),a(O),a(ol),a(g),a(pl),a(P),a(cl),a(j),a(ml),a(dl),a(ee),a(Ml),a(le),a(hl),a(yl),a(te),a(ul),a(f),a(Tl),a(Jl),a(ne),a(wl),a(_l),a(re),a(Ul),a(bl),a(pe),a(gl),a(v),a(jl),a(fl),a(me),a(vl),a(Z),a(Zl),a(Il),a(Me),a(Cl),a(I),a(Xl),a(Rl),a(ye),a(Nl),a(C),a(Gl),a(Vl),a(Te),a(Wl),a(kl),a(Yl),a(_e),a(Fl),a(Al),a(Bl),a(w),a(xl),a(zl),a(y),a(Hl),a(El),a(Ye)),a(_),h(N,e),h(V,e),h(A,e),h(x,e),h(z,e),h(E,e),h(Q,e),h(q,e),h(K,e),h(ae,e),h(se,e),h(ie,e),h(oe,e),h(ce,e),h(de,e),h(he,e),h(ue,e),h(Je,e),h(we,e),h(Ue,e),h(be,e),h(ge),h(je,e),h(fe),h(ve),h(Ze,e)}}}const qa='{"title":"Reward Modeling","local":"reward-modeling","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Get started","local":"get-started","sections":[],"depth":2},{"title":"How does it work?","local":"how-does-it-work","sections":[{"title":"Tokenization","local":"tokenization","sections":[],"depth":3}],"depth":2},{"title":"Explanation of logged metrics","local":"explanation-of-logged-metrics","sections":[],"depth":2},{"title":"What is my model doing exactly?","local":"what-is-my-model-doing-exactly","sections":[],"depth":2},{"title":"Cookbook","local":"cookbook","sections":[],"depth":2},{"title":"Benchmark experiments","local":"benchmark-experiments","sections":[],"depth":2},{"title":"Leveraging 🤗 PEFT to train a reward model","local":"leveraging--peft-to-train-a-reward-model","sections":[{"title":"Adding a margin to the loss","local":"adding-a-margin-to-the-loss","sections":[],"depth":3}],"depth":2},{"title":"RewardConfig","local":"trl.RewardConfig","sections":[],"depth":2},{"title":"RewardTrainer","local":"trl.RewardTrainer","sections":[],"depth":2}],"depth":1}';function Oa(aa){return Ea(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tt extends La{constructor(_){super(),Sa(this,_,Oa,Da,za,{})}}export{tt as component};
