import{s as Jn,o as yn,n as ne}from"../chunks/scheduler.f7e1785c.js";import{S as wn,i as Cn,g as c,s as l,r as T,A as $n,h as M,f as s,c as a,j as hn,u as m,x as j,k as fn,y as gn,a as n,v as J,d as y,t as w,w as C}from"../chunks/index.d8354395.js";import{T as Tn}from"../chunks/Tip.d2769a7f.js";import{C as E}from"../chunks/CodeBlock.191e5103.js";import{H as v,E as Un}from"../chunks/getInferenceSnippets.0844f5df.js";import{H as mn,a as $s}from"../chunks/HfOption.05895b59.js";function In(b){let i,g="In this page we’re going to show examples of how to set up MCP Clients in a few different ways using the JSON notation. For now, we will use <em>examples</em> like <code>path/to/server.py</code> to represent the path to the MCP Server. In the next unit, we’ll implement this with real MCP Servers.",r,f,o="For now, focus on understanding the MCP Client notation. We’ll implement the MCP Servers in the next unit.";return{c(){i=c("p"),i.innerHTML=g,r=l(),f=c("p"),f.textContent=o},l(p){i=M(p,"P",{"data-svelte-h":!0}),j(i)!=="svelte-1y1jtrn"&&(i.innerHTML=g),r=a(p),f=M(p,"P",{"data-svelte-h":!0}),j(f)!=="svelte-f7tivu"&&(f.textContent=o)},m(p,$){n(p,i,$),n(p,r,$),n(p,f,$)},p:ne,d(p){p&&(s(i),s(r),s(f))}}}function dn(b){let i,g="The MCP specification is still evolving, so the configuration methods are subject to evolution. We’ll focus on the current best practices for configuration.";return{c(){i=c("p"),i.textContent=g},l(r){i=M(r,"P",{"data-svelte-h":!0}),j(i)!=="svelte-n56el2"&&(i.textContent=g)},m(r,f){n(r,i,f)},p:ne,d(r){r&&s(i)}}}function vn(b){let i,g="In Python, we use the <code>os</code> module to access environment variables:",r,f,o;return f=new E({props:{code:"aW1wb3J0JTIwb3MlMEElMEElMjMlMjBBY2Nlc3MlMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlcyUwQWdpdGh1Yl90b2tlbiUyMCUzRCUyMG9zLmVudmlyb24uZ2V0KCUyMkdJVEhVQl9UT0tFTiUyMiklMEFpZiUyMG5vdCUyMGdpdGh1Yl90b2tlbiUzQSUwQSUyMCUyMCUyMCUyMHJhaXNlJTIwVmFsdWVFcnJvciglMjJHSVRIVUJfVE9LRU4lMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTIwaXMlMjByZXF1aXJlZCUyMiklMEElMEElMjMlMjBVc2UlMjB0aGUlMjB0b2tlbiUyMGluJTIweW91ciUyMHNlcnZlciUyMGNvZGUlMEFkZWYlMjBtYWtlX2dpdGh1Yl9yZXF1ZXN0KCklM0ElMEElMjAlMjAlMjAlMjBoZWFkZXJzJTIwJTNEJTIwJTdCJTIyQXV0aG9yaXphdGlvbiUyMiUzQSUyMGYlMjJCZWFyZXIlMjAlN0JnaXRodWJfdG9rZW4lN0QlMjIlN0QlMEElMjAlMjAlMjAlMjAlMjMlMjAuLi4lMjByZXN0JTIwb2YlMjB5b3VyJTIwY29kZQ==",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Access environment variables</span>
github_token = os.environ.get(<span class="hljs-string">&quot;GITHUB_TOKEN&quot;</span>)
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> github_token:
    <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;GITHUB_TOKEN environment variable is required&quot;</span>)

<span class="hljs-comment"># Use the token in your server code</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_github_request</span>():
    headers = {<span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;Bearer <span class="hljs-subst">{github_token}</span>&quot;</span>}
    <span class="hljs-comment"># ... rest of your code</span>`,wrap:!1}}),{c(){i=c("p"),i.innerHTML=g,r=l(),T(f.$$.fragment)},l(p){i=M(p,"P",{"data-svelte-h":!0}),j(i)!=="svelte-8jwuh1"&&(i.innerHTML=g),r=a(p),m(f.$$.fragment,p)},m(p,$){n(p,i,$),n(p,r,$),J(f,p,$),o=!0},p:ne,i(p){o||(y(f.$$.fragment,p),o=!0)},o(p){w(f.$$.fragment,p),o=!1},d(p){p&&(s(i),s(r)),C(f,p)}}}function An(b){let i,g="In JavaScript, we use the <code>process.env</code> object to access environment variables:",r,f,o;return f=new E({props:{code:"JTJGJTJGJTIwQWNjZXNzJTIwZW52aXJvbm1lbnQlMjB2YXJpYWJsZXMlMEFjb25zdCUyMGdpdGh1YlRva2VuJTIwJTNEJTIwcHJvY2Vzcy5lbnYuR0lUSFVCX1RPS0VOJTNCJTBBaWYlMjAoIWdpdGh1YlRva2VuKSUyMCU3QiUwQSUyMCUyMCUyMCUyMHRocm93JTIwbmV3JTIwRXJyb3IoJTIyR0lUSFVCX1RPS0VOJTIwZW52aXJvbm1lbnQlMjB2YXJpYWJsZSUyMGlzJTIwcmVxdWlyZWQlMjIpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwVXNlJTIwdGhlJTIwdG9rZW4lMjBpbiUyMHlvdXIlMjBzZXJ2ZXIlMjBjb2RlJTBBZnVuY3Rpb24lMjBtYWtlR2l0aHViUmVxdWVzdCgpJTIwJTdCJTBBJTIwJTIwJTIwJTIwY29uc3QlMjBoZWFkZXJzJTIwJTNEJTIwJTdCJTIwJTIyQXV0aG9yaXphdGlvbiUyMiUzQSUyMCU2MEJlYXJlciUyMCUyNCU3QmdpdGh1YlRva2VuJTdEJTYwJTIwJTdEJTNCJTBBJTIwJTIwJTIwJTIwJTJGJTJGJTIwLi4uJTIwcmVzdCUyMG9mJTIweW91ciUyMGNvZGUlMEElN0Q=",highlighted:`<span class="hljs-comment">// Access environment variables</span>
<span class="hljs-keyword">const</span> githubToken = process.<span class="hljs-property">env</span>.<span class="hljs-property">GITHUB_TOKEN</span>;
<span class="hljs-keyword">if</span> (!githubToken) {
    <span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;GITHUB_TOKEN environment variable is required&quot;</span>);
}

<span class="hljs-comment">// Use the token in your server code</span>
<span class="hljs-keyword">function</span> <span class="hljs-title function_">makeGithubRequest</span>(<span class="hljs-params"></span>) {
    <span class="hljs-keyword">const</span> headers = { <span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">\`Bearer <span class="hljs-subst">\${githubToken}</span>\`</span> };
    <span class="hljs-comment">// ... rest of your code</span>
}`,wrap:!1}}),{c(){i=c("p"),i.innerHTML=g,r=l(),T(f.$$.fragment)},l(p){i=M(p,"P",{"data-svelte-h":!0}),j(i)!=="svelte-1554qq7"&&(i.innerHTML=g),r=a(p),m(f.$$.fragment,p)},m(p,$){n(p,i,$),n(p,r,$),J(f,p,$),o=!0},p:ne,i(p){o||(y(f.$$.fragment,p),o=!0)},o(p){w(f.$$.fragment,p),o=!1},d(p){p&&(s(i),s(r)),C(f,p)}}}function bn(b){let i,g,r,f;return i=new $s({props:{id:"env-variables",option:"python",$$slots:{default:[vn]},$$scope:{ctx:b}}}),r=new $s({props:{id:"env-variables",option:"javascript",$$slots:{default:[An]},$$scope:{ctx:b}}}),{c(){T(i.$$.fragment),g=l(),T(r.$$.fragment)},l(o){m(i.$$.fragment,o),g=a(o),m(r.$$.fragment,o)},m(o,p){J(i,o,p),n(o,g,p),J(r,o,p),f=!0},p(o,p){const $={};p&2&&($.$$scope={dirty:p,ctx:o}),i.$set($);const U={};p&2&&(U.$$scope={dirty:p,ctx:o}),r.$set(U)},i(o){f||(y(i.$$.fragment,o),y(r.$$.fragment,o),f=!0)},o(o){w(i.$$.fragment,o),w(r.$$.fragment,o),f=!1},d(o){o&&s(g),C(i,o),C(r,o)}}}function xn(b){let i,g,r,f="Now, let’s create an agent configuration file <code>agent.json</code>.",o,p,$,U,S="In this configuration, we are using the <code>@playwright/mcp</code> MCP server. This is an MCP server that can control a browser with Playwright.",q,x,Q="Now you can run the agent:",I,P,k;return i=new v({props:{title:"Connecting to MCP Servers",local:"connecting-to-mcp-servers",headingTag:"h3"}}),p=new E({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIybW9kZWwlMjIlM0ElMjAlMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJwcm92aWRlciUyMiUzQSUyMCUyMm5lYml1cyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnNlcnZlcnMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3RkaW8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb25maWclMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb21tYW5kJTIyJTNBJTIwJTIybnB4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJncyUyMiUzQSUyMCU1QiUyMiU0MHBsYXl3cmlnaHQlMkZtY3AlNDBsYXRlc3QlMjIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlNUQlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;model&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;provider&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;nebius&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;stdio&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;config&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;npx&quot;</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;@playwright/mcp@latest&quot;</span><span class="hljs-punctuation">]</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),P=new E({props:{code:"dGlueS1hZ2VudHMlMjBydW4lMjBhZ2VudC5qc29u",highlighted:"tiny-agents run agent.json",wrap:!1}}),{c(){T(i.$$.fragment),g=l(),r=c("p"),r.innerHTML=f,o=l(),T(p.$$.fragment),$=l(),U=c("p"),U.innerHTML=S,q=l(),x=c("p"),x.textContent=Q,I=l(),T(P.$$.fragment)},l(h){m(i.$$.fragment,h),g=a(h),r=M(h,"P",{"data-svelte-h":!0}),j(r)!=="svelte-1chp0yb"&&(r.innerHTML=f),o=a(h),m(p.$$.fragment,h),$=a(h),U=M(h,"P",{"data-svelte-h":!0}),j(U)!=="svelte-xndd4g"&&(U.innerHTML=S),q=a(h),x=M(h,"P",{"data-svelte-h":!0}),j(x)!=="svelte-djbew8"&&(x.textContent=Q),I=a(h),m(P.$$.fragment,h)},m(h,A){J(i,h,A),n(h,g,A),n(h,r,A),n(h,o,A),J(p,h,A),n(h,$,A),n(h,U,A),n(h,q,A),n(h,x,A),n(h,I,A),J(P,h,A),k=!0},p:ne,i(h){k||(y(i.$$.fragment,h),y(p.$$.fragment,h),y(P.$$.fragment,h),k=!0)},o(h){w(i.$$.fragment,h),w(p.$$.fragment,h),w(P.$$.fragment,h),k=!1},d(h){h&&(s(g),s(r),s(o),s($),s(U),s(q),s(x),s(I)),C(i,h),C(p,h),C(P,h)}}}function qn(b){let i,g='First, install the tiny agents package with <a href="https://docs.npmjs.com/downloading-and-installing-node-js-and-npm" rel="nofollow">npm</a>.',r,f,o,p,$,U,S="Make an agent project directory and create an <code>agent.json</code> file.",q,x,Q,I,P="Create an agent configuration file at <code>my-agent/agent.json</code>:",k,h,A,_,H="Now you can run the agent:",N,B,Z;return f=new E({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGdGlueS1hZ2VudHM=",highlighted:"npm install @huggingface/tiny-agents",wrap:!1}}),p=new v({props:{title:"Connecting to MCP Servers",local:"connecting-to-mcp-servers",headingTag:"h3"}}),x=new E({props:{code:"bWtkaXIlMjBteS1hZ2VudCUwQXRvdWNoJTIwbXktYWdlbnQlMkZhZ2VudC5qc29u",highlighted:`<span class="hljs-built_in">mkdir</span> my-agent
<span class="hljs-built_in">touch</span> my-agent/agent.json`,wrap:!1}}),h=new E({props:{code:"JTdCJTBBJTA5JTIybW9kZWwlMjIlM0ElMjAlMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjIlMkMlMEElMDklMjJwcm92aWRlciUyMiUzQSUyMCUyMm5lYml1cyUyMiUyQyUwQSUwOSUyMnNlcnZlcnMlMjIlM0ElMjAlNUIlMEElMDklMDklN0IlMEElMDklMDklMDklMjJ0eXBlJTIyJTNBJTIwJTIyc3RkaW8lMjIlMkMlMEElMDklMDklMDklMjJjb25maWclMjIlM0ElMjAlN0IlMEElMDklMDklMDklMDklMjJjb21tYW5kJTIyJTNBJTIwJTIybnB4JTIyJTJDJTBBJTA5JTA5JTA5JTA5JTIyYXJncyUyMiUzQSUyMCU1QiUyMiU0MHBsYXl3cmlnaHQlMkZtY3AlNDBsYXRlc3QlMjIlNUQlMEElMDklMDklMDklN0QlMEElMDklMDklN0QlMEElMDklNUQlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
	<span class="hljs-attr">&quot;model&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;provider&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;nebius&quot;</span><span class="hljs-punctuation">,</span>
	<span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
		<span class="hljs-punctuation">{</span>
			<span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;stdio&quot;</span><span class="hljs-punctuation">,</span>
			<span class="hljs-attr">&quot;config&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
				<span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;npx&quot;</span><span class="hljs-punctuation">,</span>
				<span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;@playwright/mcp@latest&quot;</span><span class="hljs-punctuation">]</span>
			<span class="hljs-punctuation">}</span>
		<span class="hljs-punctuation">}</span>
	<span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),B=new E({props:{code:"bnB4JTIwJTQwaHVnZ2luZ2ZhY2UlMkZ0aW55LWFnZW50cyUyMHJ1biUyMC4lMkZteS1hZ2VudA==",highlighted:"npx @huggingface/tiny-agents run ./my-agent",wrap:!1}}),{c(){i=c("p"),i.innerHTML=g,r=l(),T(f.$$.fragment),o=l(),T(p.$$.fragment),$=l(),U=c("p"),U.innerHTML=S,q=l(),T(x.$$.fragment),Q=l(),I=c("p"),I.innerHTML=P,k=l(),T(h.$$.fragment),A=l(),_=c("p"),_.textContent=H,N=l(),T(B.$$.fragment)},l(u){i=M(u,"P",{"data-svelte-h":!0}),j(i)!=="svelte-12y2k8v"&&(i.innerHTML=g),r=a(u),m(f.$$.fragment,u),o=a(u),m(p.$$.fragment,u),$=a(u),U=M(u,"P",{"data-svelte-h":!0}),j(U)!=="svelte-xxekw8"&&(U.innerHTML=S),q=a(u),m(x.$$.fragment,u),Q=a(u),I=M(u,"P",{"data-svelte-h":!0}),j(I)!=="svelte-1cg7l8c"&&(I.innerHTML=P),k=a(u),m(h.$$.fragment,u),A=a(u),_=M(u,"P",{"data-svelte-h":!0}),j(_)!=="svelte-djbew8"&&(_.textContent=H),N=a(u),m(B.$$.fragment,u)},m(u,d){n(u,i,d),n(u,r,d),J(f,u,d),n(u,o,d),J(p,u,d),n(u,$,d),n(u,U,d),n(u,q,d),J(x,u,d),n(u,Q,d),n(u,I,d),n(u,k,d),J(h,u,d),n(u,A,d),n(u,_,d),n(u,N,d),J(B,u,d),Z=!0},p:ne,i(u){Z||(y(f.$$.fragment,u),y(p.$$.fragment,u),y(x.$$.fragment,u),y(h.$$.fragment,u),y(B.$$.fragment,u),Z=!0)},o(u){w(f.$$.fragment,u),w(p.$$.fragment,u),w(x.$$.fragment,u),w(h.$$.fragment,u),w(B.$$.fragment,u),Z=!1},d(u){u&&(s(i),s(r),s(o),s($),s(U),s(q),s(Q),s(I),s(k),s(A),s(_),s(N)),C(f,u),C(p,u),C(x,u),C(h,u),C(B,u)}}}function En(b){let i,g,r,f;return i=new $s({props:{id:"language",option:"python",$$slots:{default:[xn]},$$scope:{ctx:b}}}),r=new $s({props:{id:"language",option:"javascript",$$slots:{default:[qn]},$$scope:{ctx:b}}}),{c(){T(i.$$.fragment),g=l(),T(r.$$.fragment)},l(o){m(i.$$.fragment,o),g=a(o),m(r.$$.fragment,o)},m(o,p){J(i,o,p),n(o,g,p),J(r,o,p),f=!0},p(o,p){const $={};p&2&&($.$$scope={dirty:p,ctx:o}),i.$set($);const U={};p&2&&(U.$$scope={dirty:p,ctx:o}),r.$set(U)},i(o){f||(y(i.$$.fragment,o),y(r.$$.fragment,o),f=!0)},o(o){w(i.$$.fragment,o),w(r.$$.fragment,o),f=!1},d(o){o&&s(g),C(i,o),C(r,o)}}}function Bn(b){let i,g,r,f,o,p,$,U="Now that we have a basic understanding of the Model Context Protocol, we can explore the essential role of MCP Clients in the Model Context Protocol ecosystem.",S,q,x="In this part of Unit 1, we’ll explore the essential role of MCP Clients in the Model Context Protocol ecosystem.",Q,I,P="In this section, you will:",k,h,A="<li>Understand what MCP Clients are and their role in the MCP architecture</li> <li>Learn about the key responsibilities of MCP Clients</li> <li>Explore the major MCP Client implementations</li> <li>Discover how to connect to the Hugging Face MCP Server and built-in tools</li> <li>See practical examples of MCP Client usage</li>",_,H,N,B,Z,u,d="MCP Clients are crucial components that act as the bridge between AI applications (Hosts) and external capabilities provided by MCP Servers. Think of the Host as your main application (like an AI assistant or IDE) and the Client as a specialized module within that Host responsible for handling MCP communications.",ae,L,pe,Y,gs="Let’s start by exploring the user interface clients that are available for the MCP.",ie,z,oe,R,Us="<li>Claude Desktop (Anthropic)</li>",ue,F,ce,D,Is="<li>VS Code extensions with MCP (e.g., Continue)</li> <li>Cursor IDE (built-in MCP client)</li> <li>Zed editor</li>",Me,O,ds="These clients support connecting to multiple MCP servers and real-time tool invocation.",re,K,je,tt,vs="Hugging Face provides a hosted MCP server with built-in tools for exploring models, datasets, Spaces, and papers.",he,et,As='<li>Visit <a href="https://huggingface.co/settings/mcp" rel="nofollow">https://huggingface.co/settings/mcp</a> while logged in.</li> <li>Select your MCP-compatible client (e.g., VS Code, Cursor, Zed, Claude Desktop).</li> <li>Copy the generated configuration snippet into your client’s MCP config.</li> <li>Restart or reload your client. You should see “Hugging Face” connected.</li>',fe,st,bs="Tip: Prefer the generated snippet over hand-written config; it’s tailored per client.",Te,nt,me,lt,xs="Now that we’ve covered the core of the MCP protocol, let’s look at how to configure your MCP servers and clients.",Je,at,qs="Effective deployment of MCP servers and clients requires proper configuration.",ye,V,we,pt,Ce,it,Es="MCP hosts use configuration files to manage server connections. These files define which servers are available and how to connect to them.",$e,ot,Bs="Fortunately, the configuration files are very simple, easy to understand, and consistent across major MCP hosts.",ge,ut,Ue,ct,ks="The standard configuration file for MCP is named <code>mcp.json</code>. Here’s the basic structure:",Ie,Mt,Ps="This is the basic structure of the <code>mcp.json</code> can be passed to applications like Claude Desktop, Cursor, or VS Code.",de,rt,ve,jt,Qs="In this example, we have a single server with a name and a transport type. The transport type is either <code>stdio</code> or <code>sse</code>.",Ae,ht,be,ft,_s="For local servers using stdio transport, the configuration includes the command and arguments to launch the server process:",xe,Tt,qe,mt,Hs="Here, we have a server called “File Explorer” that is a local script.",Ee,Jt,Be,yt,Ss="For remote servers using HTTP+SSE transport, the configuration includes the server URL:",ke,wt,Pe,Ct,Qe,$t,Gs="Environment variables can be passed to server processes using the <code>env</code> field. Here’s how to access them in your server code:",_e,W,He,gt,Ns="The corresponding configuration in <code>mcp.json</code> would look like this:",Se,Ut,Ge,It,Ne,dt,Zs="Let’s look at some real-world configuration scenarios:",Ze,vt,Ve,At,Vs="In this scenario, we have a local server that is a Python script which could be a file explorer or a code editor.",We,bt,Xe,xt,Le,qt,Ws="In this scenario, we have a remote server that is a weather API.",Ye,Et,ze,Bt,Xs="Proper configuration is essential for successfully deploying MCP integrations. By understanding these aspects, you can create robust and reliable connections between AI applications and external capabilities.",Re,kt,Ls="In the next section, we’ll explore the ecosystem of MCP servers available on Hugging Face Hub and how to publish your own servers there.",Fe,Pt,De,Qt,Ys="Now, let’s explore how to use MCP Clients within code.",Oe,_t,zs="You can also use tiny agents as MCP Clients to connect directly to MCP servers from your code. Tiny agents provide a simple way to create AI agents that can use tools from MCP servers.",Ke,Ht,Rs="Tiny Agent can run MCP servers with a command line environment. To do this, we will need to install <code>npm</code> and run the server with <code>npx</code>. <strong>We’ll need these for both Python and JavaScript.</strong>",ts,St,Fs='Let’s install <code>npx</code> with <code>npm</code>. If you don’t have <code>npm</code> installed, check out the <a href="https://docs.npmjs.com/downloading-and-installing-node-js-and-npm" rel="nofollow">npm documentation</a>.',es,Gt,ss,Nt,Ds="First, we will need to install <code>npx</code> if you don’t have it installed. You can do this with the following command:",ns,Zt,ls,Vt,Os="Then, we will need to install the huggingface_hub package with the MCP support. This will allow us to run MCP servers and clients.",as,Wt,ps,Xt,Ks='Then, we will need to log in to the Hugging Face Hub to access the MCP servers. You can do this with the <code>huggingface-cli</code> command line tool. You will need a <a href="https://huggingface.co/docs/huggingface_hub/v0.32.3/en/quick-start#authentication" rel="nofollow">login token</a> to do this.',is,Lt,os,X,us,Yt,tn="In the video below, we run the agent and ask it to open a new tab in the browser.",cs,zt,en='The following example shows a web-browsing agent configured to use the <a href="https://huggingface.co/Qwen/Qwen2.5-72B-Instruct" rel="nofollow">Qwen/Qwen2.5-72B-Instruct</a> model via Nebius inference provider, and it comes equipped with a playwright MCP server, which lets it use a web browser! The agent config is loaded specifying <a href="https://huggingface.co/datasets/tiny-agents/tiny-agents/tree/main/celinah/web-browser" rel="nofollow">its path in the <code>tiny-agents/tiny-agents</code></a> Hugging Face dataset.',Ms,G,sn='<source src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/python-tiny-agents/web_browser_agent.mp4" type="video/mp4"/>',rs,Rt,nn="When you run the agent, you’ll see it load, listing the tools it has discovered from its connected MCP servers. Then, it’s ready for your prompts!",js,Ft,ln="Prompt used in this demo:",hs,Dt,an="<p>do a Web Search for HF inference providers on Brave Search and open the first result and then give me the list of the inference providers supported on Hugging Face</p>",fs,Ot,Ts,Kt,pn="Now that you understand MCP Clients, you’re ready to:",ms,te,on="<li>Explore specific MCP Server implementations</li> <li>Learn about creating custom MCP Clients</li> <li>Dive into advanced MCP integration patterns</li>",Js,ee,un="Let’s continue our journey into the world of Model Context Protocol!",ys,se,ws,le,Cs;return o=new v({props:{title:"MCP Clients",local:"mcp-clients",headingTag:"h1"}}),H=new Tn({props:{$$slots:{default:[In]},$$scope:{ctx:b}}}),B=new v({props:{title:"Understanding MCP Clients",local:"understanding-mcp-clients",headingTag:"h2"}}),L=new v({props:{title:"User Interface Client",local:"user-interface-client",headingTag:"h2"}}),z=new v({props:{title:"Chat Interface Clients",local:"chat-interface-clients",headingTag:"h3"}}),F=new v({props:{title:"Interactive Development Clients",local:"interactive-development-clients",headingTag:"h3"}}),K=new v({props:{title:"Quick connect to Hugging Face MCP Server",local:"quick-connect-to-hugging-face-mcp-server",headingTag:"h2"}}),nt=new v({props:{title:"Configuring MCP Clients",local:"configuring-mcp-clients",headingTag:"h2"}}),V=new Tn({props:{$$slots:{default:[dn]},$$scope:{ctx:b}}}),pt=new v({props:{title:"MCP Configuration Files",local:"mcp-configuration-files",headingTag:"h3"}}),ut=new v({props:{title:"mcp.json Structure",local:"mcpjson-structure",headingTag:"h4"}}),rt=new E({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJTZXJ2ZXIlMjBOYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIydHJhbnNwb3J0JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0ZGlvJTdDc3NlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTJGJTJGJTIwVHJhbnNwb3J0LXNwZWNpZmljJTIwY29uZmlndXJhdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Server Name&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;stdio|sse&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-comment">// Transport-specific configuration</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ht=new v({props:{title:"Configuration for stdio Transport",local:"configuration-for-stdio-transport",headingTag:"h4"}}),Tt=new E({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJGaWxlJTIwRXhwbG9yZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFuc3BvcnQlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3RkaW8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb21tYW5kJTIyJTNBJTIwJTIycHl0aG9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJncyUyMiUzQSUyMCU1QiUyMiUyRnBhdGglMkZ0byUyRmZpbGVfZXhwbG9yZXJfc2VydmVyLnB5JTIyJTVEJTIwJTJGJTJGJTIwVGhpcyUyMGlzJTIwYW4lMjBleGFtcGxlJTJDJTIwd2UnbGwlMjB1c2UlMjBhJTIwcmVhbCUyMHNlcnZlciUyMGluJTIwdGhlJTIwbmV4dCUyMHVuaXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlNUQlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;File Explorer&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;stdio&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;python&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;/path/to/file_explorer_server.py&quot;</span><span class="hljs-punctuation">]</span> <span class="hljs-comment">// This is an example, we&#x27;ll use a real server in the next unit</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Jt=new v({props:{title:"Configuration for HTTP+SSE Transport",local:"configuration-for-httpsse-transport",headingTag:"h4"}}),wt=new E({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJSZW1vdGUlMjBBUEklMjBTZXJ2ZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFuc3BvcnQlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3NlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZleGFtcGxlLmNvbSUyRm1jcC1zZXJ2ZXIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlNUQlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Remote API Server&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;sse&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;url&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;https://example.com/mcp-server&quot;</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ct=new v({props:{title:"Environment Variables in Configuration",local:"environment-variables-in-configuration",headingTag:"h4"}}),W=new mn({props:{id:"env-variables",options:["python","javascript"],$$slots:{default:[bn]},$$scope:{ctx:b}}}),Ut=new E({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJHaXRIdWIlMjBBUEklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFuc3BvcnQlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3RkaW8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb21tYW5kJTIyJTNBJTIwJTIycHl0aG9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJncyUyMiUzQSUyMCU1QiUyMiUyRnBhdGglMkZ0byUyRmdpdGh1Yl9zZXJ2ZXIucHklMjIlNUQlMkMlMjAlMkYlMkYlMjBUaGlzJTIwaXMlMjBhbiUyMGV4YW1wbGUlMkMlMjB3ZSdsbCUyMHVzZSUyMGElMjByZWFsJTIwc2VydmVyJTIwaW4lMjB0aGUlMjBuZXh0JTIwdW5pdCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVudiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkdJVEhVQl9UT0tFTiUyMiUzQSUyMCUyMnlvdXJfZ2l0aHViX3Rva2VuJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;GitHub API&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;stdio&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;python&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;/path/to/github_server.py&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// This is an example, we&#x27;ll use a real server in the next unit</span>
        <span class="hljs-attr">&quot;env&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;GITHUB_TOKEN&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;your_github_token&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),It=new v({props:{title:"Configuration Examples",local:"configuration-examples",headingTag:"h3"}}),vt=new v({props:{title:"Scenario 1: Local Server Configuration",local:"scenario-1-local-server-configuration",headingTag:"h4"}}),bt=new E({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJGaWxlJTIwRXhwbG9yZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFuc3BvcnQlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3RkaW8lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb21tYW5kJTIyJTNBJTIwJTIycHl0aG9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJncyUyMiUzQSUyMCU1QiUyMiUyRnBhdGglMkZ0byUyRmZpbGVfZXhwbG9yZXJfc2VydmVyLnB5JTIyJTVEJTIwJTJGJTJGJTIwVGhpcyUyMGlzJTIwYW4lMjBleGFtcGxlJTJDJTIwd2UnbGwlMjB1c2UlMjBhJTIwcmVhbCUyMHNlcnZlciUyMGluJTIwdGhlJTIwbmV4dCUyMHVuaXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlNUQlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;File Explorer&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;stdio&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;command&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;python&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;args&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;/path/to/file_explorer_server.py&quot;</span><span class="hljs-punctuation">]</span> <span class="hljs-comment">// This is an example, we&#x27;ll use a real server in the next unit</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),xt=new v({props:{title:"Scenario 2: Remote Server Configuration",local:"scenario-2-remote-server-configuration",headingTag:"h4"}}),Et=new E({props:{code:"JTdCJTBBJTIwJTIwJTIyc2VydmVycyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJXZWF0aGVyJTIwQVBJJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIydHJhbnNwb3J0JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnNzZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmh0dHBzJTNBJTJGJTJGZXhhbXBsZS5jb20lMkZtY3Atc2VydmVyJTIyJTIwJTJGJTJGJTIwVGhpcyUyMGlzJTIwYW4lMjBleGFtcGxlJTJDJTIwd2UnbGwlMjB1c2UlMjBhJTIwcmVhbCUyMHNlcnZlciUyMGluJTIwdGhlJTIwbmV4dCUyMHVuaXQlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlNUQlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;servers&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Weather API&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;transport&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;sse&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;url&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;https://example.com/mcp-server&quot;</span> <span class="hljs-comment">// This is an example, we&#x27;ll use a real server in the next unit</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Pt=new v({props:{title:"Tiny Agents Clients",local:"tiny-agents-clients",headingTag:"h2"}}),Gt=new v({props:{title:"Setup",local:"setup",headingTag:"h3"}}),Zt=new E({props:{code:"JTIzJTIwaW5zdGFsbCUyMG5weCUwQW5wbSUyMGluc3RhbGwlMjAtZyUyMG5weA==",highlighted:`<span class="hljs-comment"># install npx</span>
npm install -g npx`,wrap:!1}}),Wt=new E({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMmh1Z2dpbmdmYWNlX2h1YiU1Qm1jcCU1RCUzRSUzRDAuMzIuMCUyMg==",highlighted:'pip install <span class="hljs-string">&quot;huggingface_hub[mcp]&gt;=0.32.0&quot;</span>',wrap:!1}}),Lt=new E({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),X=new mn({props:{id:"language",options:["python","javascript"],$$slots:{default:[En]},$$scope:{ctx:b}}}),Ot=new v({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),se=new Un({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit1/mcp-clients.mdx"}}),{c(){i=c("meta"),g=l(),r=c("p"),f=l(),T(o.$$.fragment),p=l(),$=c("p"),$.textContent=U,S=l(),q=c("p"),q.textContent=x,Q=l(),I=c("p"),I.textContent=P,k=l(),h=c("ul"),h.innerHTML=A,_=l(),T(H.$$.fragment),N=l(),T(B.$$.fragment),Z=l(),u=c("p"),u.textContent=d,ae=l(),T(L.$$.fragment),pe=l(),Y=c("p"),Y.textContent=gs,ie=l(),T(z.$$.fragment),oe=l(),R=c("ul"),R.innerHTML=Us,ue=l(),T(F.$$.fragment),ce=l(),D=c("ul"),D.innerHTML=Is,Me=l(),O=c("p"),O.textContent=ds,re=l(),T(K.$$.fragment),je=l(),tt=c("p"),tt.textContent=vs,he=l(),et=c("ol"),et.innerHTML=As,fe=l(),st=c("p"),st.textContent=bs,Te=l(),T(nt.$$.fragment),me=l(),lt=c("p"),lt.textContent=xs,Je=l(),at=c("p"),at.textContent=qs,ye=l(),T(V.$$.fragment),we=l(),T(pt.$$.fragment),Ce=l(),it=c("p"),it.textContent=Es,$e=l(),ot=c("p"),ot.textContent=Bs,ge=l(),T(ut.$$.fragment),Ue=l(),ct=c("p"),ct.innerHTML=ks,Ie=l(),Mt=c("p"),Mt.innerHTML=Ps,de=l(),T(rt.$$.fragment),ve=l(),jt=c("p"),jt.innerHTML=Qs,Ae=l(),T(ht.$$.fragment),be=l(),ft=c("p"),ft.textContent=_s,xe=l(),T(Tt.$$.fragment),qe=l(),mt=c("p"),mt.textContent=Hs,Ee=l(),T(Jt.$$.fragment),Be=l(),yt=c("p"),yt.textContent=Ss,ke=l(),T(wt.$$.fragment),Pe=l(),T(Ct.$$.fragment),Qe=l(),$t=c("p"),$t.innerHTML=Gs,_e=l(),T(W.$$.fragment),He=l(),gt=c("p"),gt.innerHTML=Ns,Se=l(),T(Ut.$$.fragment),Ge=l(),T(It.$$.fragment),Ne=l(),dt=c("p"),dt.textContent=Zs,Ze=l(),T(vt.$$.fragment),Ve=l(),At=c("p"),At.textContent=Vs,We=l(),T(bt.$$.fragment),Xe=l(),T(xt.$$.fragment),Le=l(),qt=c("p"),qt.textContent=Ws,Ye=l(),T(Et.$$.fragment),ze=l(),Bt=c("p"),Bt.textContent=Xs,Re=l(),kt=c("p"),kt.textContent=Ls,Fe=l(),T(Pt.$$.fragment),De=l(),Qt=c("p"),Qt.textContent=Ys,Oe=l(),_t=c("p"),_t.textContent=zs,Ke=l(),Ht=c("p"),Ht.innerHTML=Rs,ts=l(),St=c("p"),St.innerHTML=Fs,es=l(),T(Gt.$$.fragment),ss=l(),Nt=c("p"),Nt.innerHTML=Ds,ns=l(),T(Zt.$$.fragment),ls=l(),Vt=c("p"),Vt.textContent=Os,as=l(),T(Wt.$$.fragment),ps=l(),Xt=c("p"),Xt.innerHTML=Ks,is=l(),T(Lt.$$.fragment),os=l(),T(X.$$.fragment),us=l(),Yt=c("p"),Yt.textContent=tn,cs=l(),zt=c("p"),zt.innerHTML=en,Ms=l(),G=c("video"),G.innerHTML=sn,rs=l(),Rt=c("p"),Rt.textContent=nn,js=l(),Ft=c("p"),Ft.textContent=ln,hs=l(),Dt=c("blockquote"),Dt.innerHTML=an,fs=l(),T(Ot.$$.fragment),Ts=l(),Kt=c("p"),Kt.textContent=pn,ms=l(),te=c("ul"),te.innerHTML=on,Js=l(),ee=c("p"),ee.textContent=un,ys=l(),T(se.$$.fragment),ws=l(),le=c("p"),this.h()},l(t){const e=$n("svelte-u9bgzb",document.head);i=M(e,"META",{name:!0,content:!0}),e.forEach(s),g=a(t),r=M(t,"P",{}),hn(r).forEach(s),f=a(t),m(o.$$.fragment,t),p=a(t),$=M(t,"P",{"data-svelte-h":!0}),j($)!=="svelte-bq1glt"&&($.textContent=U),S=a(t),q=M(t,"P",{"data-svelte-h":!0}),j(q)!=="svelte-3v3t4i"&&(q.textContent=x),Q=a(t),I=M(t,"P",{"data-svelte-h":!0}),j(I)!=="svelte-37whj1"&&(I.textContent=P),k=a(t),h=M(t,"UL",{"data-svelte-h":!0}),j(h)!=="svelte-19awr3v"&&(h.innerHTML=A),_=a(t),m(H.$$.fragment,t),N=a(t),m(B.$$.fragment,t),Z=a(t),u=M(t,"P",{"data-svelte-h":!0}),j(u)!=="svelte-s96fp3"&&(u.textContent=d),ae=a(t),m(L.$$.fragment,t),pe=a(t),Y=M(t,"P",{"data-svelte-h":!0}),j(Y)!=="svelte-38oyrl"&&(Y.textContent=gs),ie=a(t),m(z.$$.fragment,t),oe=a(t),R=M(t,"UL",{"data-svelte-h":!0}),j(R)!=="svelte-1v59zks"&&(R.innerHTML=Us),ue=a(t),m(F.$$.fragment,t),ce=a(t),D=M(t,"UL",{"data-svelte-h":!0}),j(D)!=="svelte-1ryprd7"&&(D.innerHTML=Is),Me=a(t),O=M(t,"P",{"data-svelte-h":!0}),j(O)!=="svelte-cwbz68"&&(O.textContent=ds),re=a(t),m(K.$$.fragment,t),je=a(t),tt=M(t,"P",{"data-svelte-h":!0}),j(tt)!=="svelte-hdja3t"&&(tt.textContent=vs),he=a(t),et=M(t,"OL",{"data-svelte-h":!0}),j(et)!=="svelte-1oe4cph"&&(et.innerHTML=As),fe=a(t),st=M(t,"P",{"data-svelte-h":!0}),j(st)!=="svelte-1vh662p"&&(st.textContent=bs),Te=a(t),m(nt.$$.fragment,t),me=a(t),lt=M(t,"P",{"data-svelte-h":!0}),j(lt)!=="svelte-1t8u4wf"&&(lt.textContent=xs),Je=a(t),at=M(t,"P",{"data-svelte-h":!0}),j(at)!=="svelte-1h6qe5q"&&(at.textContent=qs),ye=a(t),m(V.$$.fragment,t),we=a(t),m(pt.$$.fragment,t),Ce=a(t),it=M(t,"P",{"data-svelte-h":!0}),j(it)!=="svelte-1ycrnux"&&(it.textContent=Es),$e=a(t),ot=M(t,"P",{"data-svelte-h":!0}),j(ot)!=="svelte-z7yl0u"&&(ot.textContent=Bs),ge=a(t),m(ut.$$.fragment,t),Ue=a(t),ct=M(t,"P",{"data-svelte-h":!0}),j(ct)!=="svelte-upbqy5"&&(ct.innerHTML=ks),Ie=a(t),Mt=M(t,"P",{"data-svelte-h":!0}),j(Mt)!=="svelte-817fk"&&(Mt.innerHTML=Ps),de=a(t),m(rt.$$.fragment,t),ve=a(t),jt=M(t,"P",{"data-svelte-h":!0}),j(jt)!=="svelte-1xnp18o"&&(jt.innerHTML=Qs),Ae=a(t),m(ht.$$.fragment,t),be=a(t),ft=M(t,"P",{"data-svelte-h":!0}),j(ft)!=="svelte-eoeyze"&&(ft.textContent=_s),xe=a(t),m(Tt.$$.fragment,t),qe=a(t),mt=M(t,"P",{"data-svelte-h":!0}),j(mt)!=="svelte-443kp7"&&(mt.textContent=Hs),Ee=a(t),m(Jt.$$.fragment,t),Be=a(t),yt=M(t,"P",{"data-svelte-h":!0}),j(yt)!=="svelte-1jwz8f7"&&(yt.textContent=Ss),ke=a(t),m(wt.$$.fragment,t),Pe=a(t),m(Ct.$$.fragment,t),Qe=a(t),$t=M(t,"P",{"data-svelte-h":!0}),j($t)!=="svelte-1c7z0qi"&&($t.innerHTML=Gs),_e=a(t),m(W.$$.fragment,t),He=a(t),gt=M(t,"P",{"data-svelte-h":!0}),j(gt)!=="svelte-1oqx78f"&&(gt.innerHTML=Ns),Se=a(t),m(Ut.$$.fragment,t),Ge=a(t),m(It.$$.fragment,t),Ne=a(t),dt=M(t,"P",{"data-svelte-h":!0}),j(dt)!=="svelte-fnutrr"&&(dt.textContent=Zs),Ze=a(t),m(vt.$$.fragment,t),Ve=a(t),At=M(t,"P",{"data-svelte-h":!0}),j(At)!=="svelte-i95sbi"&&(At.textContent=Vs),We=a(t),m(bt.$$.fragment,t),Xe=a(t),m(xt.$$.fragment,t),Le=a(t),qt=M(t,"P",{"data-svelte-h":!0}),j(qt)!=="svelte-1d51v8x"&&(qt.textContent=Ws),Ye=a(t),m(Et.$$.fragment,t),ze=a(t),Bt=M(t,"P",{"data-svelte-h":!0}),j(Bt)!=="svelte-146ggji"&&(Bt.textContent=Xs),Re=a(t),kt=M(t,"P",{"data-svelte-h":!0}),j(kt)!=="svelte-k8z1tj"&&(kt.textContent=Ls),Fe=a(t),m(Pt.$$.fragment,t),De=a(t),Qt=M(t,"P",{"data-svelte-h":!0}),j(Qt)!=="svelte-1dfdkfc"&&(Qt.textContent=Ys),Oe=a(t),_t=M(t,"P",{"data-svelte-h":!0}),j(_t)!=="svelte-14qiw7w"&&(_t.textContent=zs),Ke=a(t),Ht=M(t,"P",{"data-svelte-h":!0}),j(Ht)!=="svelte-cm95y3"&&(Ht.innerHTML=Rs),ts=a(t),St=M(t,"P",{"data-svelte-h":!0}),j(St)!=="svelte-fmiuqb"&&(St.innerHTML=Fs),es=a(t),m(Gt.$$.fragment,t),ss=a(t),Nt=M(t,"P",{"data-svelte-h":!0}),j(Nt)!=="svelte-1k7gxs3"&&(Nt.innerHTML=Ds),ns=a(t),m(Zt.$$.fragment,t),ls=a(t),Vt=M(t,"P",{"data-svelte-h":!0}),j(Vt)!=="svelte-97l3dy"&&(Vt.textContent=Os),as=a(t),m(Wt.$$.fragment,t),ps=a(t),Xt=M(t,"P",{"data-svelte-h":!0}),j(Xt)!=="svelte-1y7cgeg"&&(Xt.innerHTML=Ks),is=a(t),m(Lt.$$.fragment,t),os=a(t),m(X.$$.fragment,t),us=a(t),Yt=M(t,"P",{"data-svelte-h":!0}),j(Yt)!=="svelte-1p62eql"&&(Yt.textContent=tn),cs=a(t),zt=M(t,"P",{"data-svelte-h":!0}),j(zt)!=="svelte-1ob91jc"&&(zt.innerHTML=en),Ms=a(t),G=M(t,"VIDEO",{"data-svelte-h":!0}),j(G)!=="svelte-czqfe0"&&(G.innerHTML=sn),rs=a(t),Rt=M(t,"P",{"data-svelte-h":!0}),j(Rt)!=="svelte-5v1ktd"&&(Rt.textContent=nn),js=a(t),Ft=M(t,"P",{"data-svelte-h":!0}),j(Ft)!=="svelte-57oxa9"&&(Ft.textContent=ln),hs=a(t),Dt=M(t,"BLOCKQUOTE",{"data-svelte-h":!0}),j(Dt)!=="svelte-mkoavr"&&(Dt.innerHTML=an),fs=a(t),m(Ot.$$.fragment,t),Ts=a(t),Kt=M(t,"P",{"data-svelte-h":!0}),j(Kt)!=="svelte-jrhgb1"&&(Kt.textContent=pn),ms=a(t),te=M(t,"UL",{"data-svelte-h":!0}),j(te)!=="svelte-1ypqei0"&&(te.innerHTML=on),Js=a(t),ee=M(t,"P",{"data-svelte-h":!0}),j(ee)!=="svelte-crczat"&&(ee.textContent=un),ys=a(t),m(se.$$.fragment,t),ws=a(t),le=M(t,"P",{}),hn(le).forEach(s),this.h()},h(){fn(i,"name","hf:doc:metadata"),fn(i,"content",kn),G.controls="",G.autoplay="",G.loop=""},m(t,e){gn(document.head,i),n(t,g,e),n(t,r,e),n(t,f,e),J(o,t,e),n(t,p,e),n(t,$,e),n(t,S,e),n(t,q,e),n(t,Q,e),n(t,I,e),n(t,k,e),n(t,h,e),n(t,_,e),J(H,t,e),n(t,N,e),J(B,t,e),n(t,Z,e),n(t,u,e),n(t,ae,e),J(L,t,e),n(t,pe,e),n(t,Y,e),n(t,ie,e),J(z,t,e),n(t,oe,e),n(t,R,e),n(t,ue,e),J(F,t,e),n(t,ce,e),n(t,D,e),n(t,Me,e),n(t,O,e),n(t,re,e),J(K,t,e),n(t,je,e),n(t,tt,e),n(t,he,e),n(t,et,e),n(t,fe,e),n(t,st,e),n(t,Te,e),J(nt,t,e),n(t,me,e),n(t,lt,e),n(t,Je,e),n(t,at,e),n(t,ye,e),J(V,t,e),n(t,we,e),J(pt,t,e),n(t,Ce,e),n(t,it,e),n(t,$e,e),n(t,ot,e),n(t,ge,e),J(ut,t,e),n(t,Ue,e),n(t,ct,e),n(t,Ie,e),n(t,Mt,e),n(t,de,e),J(rt,t,e),n(t,ve,e),n(t,jt,e),n(t,Ae,e),J(ht,t,e),n(t,be,e),n(t,ft,e),n(t,xe,e),J(Tt,t,e),n(t,qe,e),n(t,mt,e),n(t,Ee,e),J(Jt,t,e),n(t,Be,e),n(t,yt,e),n(t,ke,e),J(wt,t,e),n(t,Pe,e),J(Ct,t,e),n(t,Qe,e),n(t,$t,e),n(t,_e,e),J(W,t,e),n(t,He,e),n(t,gt,e),n(t,Se,e),J(Ut,t,e),n(t,Ge,e),J(It,t,e),n(t,Ne,e),n(t,dt,e),n(t,Ze,e),J(vt,t,e),n(t,Ve,e),n(t,At,e),n(t,We,e),J(bt,t,e),n(t,Xe,e),J(xt,t,e),n(t,Le,e),n(t,qt,e),n(t,Ye,e),J(Et,t,e),n(t,ze,e),n(t,Bt,e),n(t,Re,e),n(t,kt,e),n(t,Fe,e),J(Pt,t,e),n(t,De,e),n(t,Qt,e),n(t,Oe,e),n(t,_t,e),n(t,Ke,e),n(t,Ht,e),n(t,ts,e),n(t,St,e),n(t,es,e),J(Gt,t,e),n(t,ss,e),n(t,Nt,e),n(t,ns,e),J(Zt,t,e),n(t,ls,e),n(t,Vt,e),n(t,as,e),J(Wt,t,e),n(t,ps,e),n(t,Xt,e),n(t,is,e),J(Lt,t,e),n(t,os,e),J(X,t,e),n(t,us,e),n(t,Yt,e),n(t,cs,e),n(t,zt,e),n(t,Ms,e),n(t,G,e),n(t,rs,e),n(t,Rt,e),n(t,js,e),n(t,Ft,e),n(t,hs,e),n(t,Dt,e),n(t,fs,e),J(Ot,t,e),n(t,Ts,e),n(t,Kt,e),n(t,ms,e),n(t,te,e),n(t,Js,e),n(t,ee,e),n(t,ys,e),J(se,t,e),n(t,ws,e),n(t,le,e),Cs=!0},p(t,[e]){const cn={};e&2&&(cn.$$scope={dirty:e,ctx:t}),H.$set(cn);const Mn={};e&2&&(Mn.$$scope={dirty:e,ctx:t}),V.$set(Mn);const rn={};e&2&&(rn.$$scope={dirty:e,ctx:t}),W.$set(rn);const jn={};e&2&&(jn.$$scope={dirty:e,ctx:t}),X.$set(jn)},i(t){Cs||(y(o.$$.fragment,t),y(H.$$.fragment,t),y(B.$$.fragment,t),y(L.$$.fragment,t),y(z.$$.fragment,t),y(F.$$.fragment,t),y(K.$$.fragment,t),y(nt.$$.fragment,t),y(V.$$.fragment,t),y(pt.$$.fragment,t),y(ut.$$.fragment,t),y(rt.$$.fragment,t),y(ht.$$.fragment,t),y(Tt.$$.fragment,t),y(Jt.$$.fragment,t),y(wt.$$.fragment,t),y(Ct.$$.fragment,t),y(W.$$.fragment,t),y(Ut.$$.fragment,t),y(It.$$.fragment,t),y(vt.$$.fragment,t),y(bt.$$.fragment,t),y(xt.$$.fragment,t),y(Et.$$.fragment,t),y(Pt.$$.fragment,t),y(Gt.$$.fragment,t),y(Zt.$$.fragment,t),y(Wt.$$.fragment,t),y(Lt.$$.fragment,t),y(X.$$.fragment,t),y(Ot.$$.fragment,t),y(se.$$.fragment,t),Cs=!0)},o(t){w(o.$$.fragment,t),w(H.$$.fragment,t),w(B.$$.fragment,t),w(L.$$.fragment,t),w(z.$$.fragment,t),w(F.$$.fragment,t),w(K.$$.fragment,t),w(nt.$$.fragment,t),w(V.$$.fragment,t),w(pt.$$.fragment,t),w(ut.$$.fragment,t),w(rt.$$.fragment,t),w(ht.$$.fragment,t),w(Tt.$$.fragment,t),w(Jt.$$.fragment,t),w(wt.$$.fragment,t),w(Ct.$$.fragment,t),w(W.$$.fragment,t),w(Ut.$$.fragment,t),w(It.$$.fragment,t),w(vt.$$.fragment,t),w(bt.$$.fragment,t),w(xt.$$.fragment,t),w(Et.$$.fragment,t),w(Pt.$$.fragment,t),w(Gt.$$.fragment,t),w(Zt.$$.fragment,t),w(Wt.$$.fragment,t),w(Lt.$$.fragment,t),w(X.$$.fragment,t),w(Ot.$$.fragment,t),w(se.$$.fragment,t),Cs=!1},d(t){t&&(s(g),s(r),s(f),s(p),s($),s(S),s(q),s(Q),s(I),s(k),s(h),s(_),s(N),s(Z),s(u),s(ae),s(pe),s(Y),s(ie),s(oe),s(R),s(ue),s(ce),s(D),s(Me),s(O),s(re),s(je),s(tt),s(he),s(et),s(fe),s(st),s(Te),s(me),s(lt),s(Je),s(at),s(ye),s(we),s(Ce),s(it),s($e),s(ot),s(ge),s(Ue),s(ct),s(Ie),s(Mt),s(de),s(ve),s(jt),s(Ae),s(be),s(ft),s(xe),s(qe),s(mt),s(Ee),s(Be),s(yt),s(ke),s(Pe),s(Qe),s($t),s(_e),s(He),s(gt),s(Se),s(Ge),s(Ne),s(dt),s(Ze),s(Ve),s(At),s(We),s(Xe),s(Le),s(qt),s(Ye),s(ze),s(Bt),s(Re),s(kt),s(Fe),s(De),s(Qt),s(Oe),s(_t),s(Ke),s(Ht),s(ts),s(St),s(es),s(ss),s(Nt),s(ns),s(ls),s(Vt),s(as),s(ps),s(Xt),s(is),s(os),s(us),s(Yt),s(cs),s(zt),s(Ms),s(G),s(rs),s(Rt),s(js),s(Ft),s(hs),s(Dt),s(fs),s(Ts),s(Kt),s(ms),s(te),s(Js),s(ee),s(ys),s(ws),s(le)),s(i),C(o,t),C(H,t),C(B,t),C(L,t),C(z,t),C(F,t),C(K,t),C(nt,t),C(V,t),C(pt,t),C(ut,t),C(rt,t),C(ht,t),C(Tt,t),C(Jt,t),C(wt,t),C(Ct,t),C(W,t),C(Ut,t),C(It,t),C(vt,t),C(bt,t),C(xt,t),C(Et,t),C(Pt,t),C(Gt,t),C(Zt,t),C(Wt,t),C(Lt,t),C(X,t),C(Ot,t),C(se,t)}}}const kn='{"title":"MCP Clients","local":"mcp-clients","sections":[{"title":"Understanding MCP Clients","local":"understanding-mcp-clients","sections":[],"depth":2},{"title":"User Interface Client","local":"user-interface-client","sections":[{"title":"Chat Interface Clients","local":"chat-interface-clients","sections":[],"depth":3},{"title":"Interactive Development Clients","local":"interactive-development-clients","sections":[],"depth":3}],"depth":2},{"title":"Quick connect to Hugging Face MCP Server","local":"quick-connect-to-hugging-face-mcp-server","sections":[],"depth":2},{"title":"Configuring MCP Clients","local":"configuring-mcp-clients","sections":[{"title":"MCP Configuration Files","local":"mcp-configuration-files","sections":[{"title":"mcp.json Structure","local":"mcpjson-structure","sections":[],"depth":4},{"title":"Configuration for stdio Transport","local":"configuration-for-stdio-transport","sections":[],"depth":4},{"title":"Configuration for HTTP+SSE Transport","local":"configuration-for-httpsse-transport","sections":[],"depth":4},{"title":"Environment Variables in Configuration","local":"environment-variables-in-configuration","sections":[],"depth":4}],"depth":3},{"title":"Configuration Examples","local":"configuration-examples","sections":[{"title":"Scenario 1: Local Server Configuration","local":"scenario-1-local-server-configuration","sections":[],"depth":4},{"title":"Scenario 2: Remote Server Configuration","local":"scenario-2-remote-server-configuration","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Tiny Agents Clients","local":"tiny-agents-clients","sections":[{"title":"Setup","local":"setup","sections":[],"depth":3},{"title":"Connecting to MCP Servers","local":"connecting-to-mcp-servers","sections":[],"depth":3},{"title":"Connecting to MCP Servers","local":"connecting-to-mcp-servers","sections":[],"depth":3}],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Pn(b){return yn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zn extends wn{constructor(i){super(),Cn(this,i,Pn,Bn,Jn,{})}}export{Zn as component};
