import{s as _a,n as $a,o as Ba}from"../chunks/scheduler.3a17fb72.js";import{S as Za,i as Qa,e as j,s as n,c as e,h as va,a as h,d as l,b as p,f as qa,g as u,j as r,k as Aa,l as Ea,m as t,n as i,t as o,o as M,p as c}from"../chunks/index.093f8863.js";import{C as ka,H as y,E as Wa}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.67b2012e.js";import{C as os}from"../chunks/CodeBlock.28d44382.js";function Na(ua){let T,js,Ms,hs,J,rs,U,ys,m,ia="Lighteval provides comprehensive logging and result management through the <code>EvaluationTracker</code> class. This system allows you to save results locally and optionally push them to various platforms for collaboration and analysis.",Ts,d,Js,w,oa=`Lighteval automatically saves results and evaluation details in the
directory specified with the <code>--output-dir</code> option. The results are saved in
<code>{output_dir}/results/{model_name}/results_{timestamp}.json</code>. <a href="#example-of-a-result-file">Here is an
example of a result file</a>. The output path can be
any <a href="https://filesystem-spec.readthedocs.io/en/latest/index.html" rel="nofollow">fsspec</a>
compliant path (local, S3, Hugging Face Hub, Google Drive, FTP, etc.).`,Us,I,Ma=`To save detailed evaluation information, you can use the <code>--save-details</code>
option. The details are saved in Parquet files at
<code>{output_dir}/details/{model_name}/{timestamp}/details_{task}_{timestamp}.parquet</code>.`,ms,g,ca=`If you want results to be saved in a custom path structure, you can set the <code>results-path-template</code> option.
This allows you to specify a string template for the path. The template must contain the following
variables: <code>output_dir</code>, <code>model_name</code>, <code>org</code>. For example:
<code>{output_dir}/{org}_{model}</code>. The template will be used to create the path for the results file.`,ds,f,ws,C,ja=`You can push results and evaluation details to the Hugging Face Hub. To do
so, you need to set the <code>--push-to-hub</code> option as well as the <code>--results-org</code>
option. The results are saved in a dataset with the name
<code>{results_org}/{model_org}/{model_name}</code>. To push the details, you need to set
the <code>--save-details</code> option.`,Is,b,ha=`The dataset created will be private by default. You can make it public by
setting the <code>--public-run</code> option.`,gs,q,fs,A,ra=`You can push results to TensorBoard by setting <code>--push-to-tensorboard</code>.
This creates a TensorBoard dashboard in a Hugging Face organization specified with the <code>--results-org</code>
option.`,Cs,_,bs,$,ya=`You can push results to Weights &amp; Biases by setting <code>--wandb</code>. This initializes a W&amp;B
run and logs the results.`,qs,B,Ta="W&B arguments need to be set in your environment variables:",As,Z,_s,Q,Ja='You can find a complete list of variables in the <a href="https://docs.wandb.ai/guides/track/environment-variables/" rel="nofollow">W&amp;B documentation</a>.',$s,v,Ua=`If Trackio is available in your environment (<code>pip install lighteval[trackio]</code>), it will be used to log and push results to a
Hugging Face dataset. Choose the dataset name and organization with:`,Bs,E,Zs,k,Qs,W,vs,N,Es,z,ks,X,Ws,G,Ns,R,ma="The detail file contains the following columns:",zs,F,da="<li><strong><code>__doc__</code></strong>: The document used for evaluation, containing the gold reference, few-shot examples, and other hyperparameters used for the task.</li> <li><strong><code>__model_response__</code></strong>: Contains model generations, log probabilities, and the input that was sent to the model.</li> <li><strong><code>__metric__</code></strong>: The value of the metrics for this sample.</li>",Xs,S,Gs,V,wa="The <code>EvaluationTracker</code> class provides several configuration options for customizing how results are saved and pushed:",Rs,x,Fs,Y,Ss,H,Vs,D,xs,L,Ys,P,Ia="<li><strong><code>output_dir</code></strong>: Local directory to save evaluation results and logs</li> <li><strong><code>results_path_template</code></strong>: Template for results directory structure</li> <li><strong><code>save_details</code></strong>: Whether to save detailed evaluation records (default: True)</li> <li><strong><code>push_to_hub</code></strong>: Whether to push results to Hugging Face Hub (default: False)</li> <li><strong><code>push_to_tensorboard</code></strong>: Whether to push metrics to TensorBoard (default: False)</li> <li><strong><code>hub_results_org</code></strong>: Hugging Face Hub organization to push results to</li> <li><strong><code>tensorboard_metric_prefix</code></strong>: Prefix for TensorBoard metrics (default: “eval”)</li> <li><strong><code>public</code></strong>: Whether to make Hub datasets public (default: False)</li> <li><strong><code>use_wandb</code></strong>: Whether to log to Weights &amp; Biases or Trackio (default: False)</li>",Hs,O,Ds,K,ga="The main results file contains several sections:",Ls,ss,Ps,as,fa="<li><strong><code>config_general</code></strong>: Overall evaluation configuration including model information, timing, and system details</li> <li><strong><code>summary_general</code></strong>: General statistics about the evaluation run</li>",Os,ls,Ks,ts,Ca="<li><strong><code>config_tasks</code></strong>: Configuration details for each evaluated task</li> <li><strong><code>summary_tasks</code></strong>: Task-specific statistics and metadata</li> <li><strong><code>versions</code></strong>: Version information for tasks and datasets</li>",sa,ns,aa,ps,ba="<li><strong><code>results</code></strong>: Actual evaluation metrics and scores for each task</li>",la,es,ta,us,na,is,pa,cs,ea;return J=new ka({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new y({props:{title:"Saving and Reading Results",local:"saving-and-reading-results",headingTag:"h1"}}),d=new y({props:{title:"Saving Results Locally",local:"saving-results-locally",headingTag:"h2"}}),f=new y({props:{title:"Pushing Results to the Hugging Face Hub",local:"pushing-results-to-the-hugging-face-hub",headingTag:"h2"}}),q=new y({props:{title:"Pushing Results to TensorBoard",local:"pushing-results-to-tensorboard",headingTag:"h2"}}),_=new y({props:{title:"Pushing Results to Weights & Biases or Trackio",local:"pushing-results-to-weights--biases-or-trackio",headingTag:"h2"}}),Z=new os({props:{code:"ZXhwb3J0JTIwV0FOREJfUFJPSkVDVCUzRCUyMmxpZ2h0ZXZhbCUyMg==",highlighted:'<span class="hljs-built_in">export</span> WANDB_PROJECT=<span class="hljs-string">&quot;lighteval&quot;</span>',wrap:!1}}),E=new os({props:{code:"ZXhwb3J0JTIwV0FOREJfU1BBQ0VfSUQlM0QlMjJvcmclMkZuYW1lJTIy",highlighted:'<span class="hljs-built_in">export</span> WANDB_SPACE_ID=<span class="hljs-string">&quot;org/name&quot;</span>',wrap:!1}}),k=new y({props:{title:"How to Load and Investigate Details",local:"how-to-load-and-investigate-details",headingTag:"h2"}}),W=new y({props:{title:"Loading from Local Detail Files",local:"loading-from-local-detail-files",headingTag:"h3"}}),N=new os({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwb3MlMEFpbXBvcnQlMjBnbG9iJTBBJTBBb3V0cHV0X2RpciUyMCUzRCUyMCUyMmV2YWxzX2RvYyUyMiUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0aW1lc3RhbXAlMjAlM0QlMjAlMjJsYXRlc3QlMjIlMEF0YXNrJTIwJTNEJTIwJTIyZ3NtOGslMjIlMEElMEFpZiUyMHRpbWVzdGFtcCUyMCUzRCUzRCUyMCUyMmxhdGVzdCUyMiUzQSUwQSUyMCUyMCUyMCUyMHBhdGglMjAlM0QlMjBmJTIyJTdCb3V0cHV0X2RpciU3RCUyRmRldGFpbHMlMkYlN0Jtb2RlbF9uYW1lJTdEJTJGKiUyRiUyMiUwQSUyMCUyMCUyMCUyMHRpbWVzdGFtcHMlMjAlM0QlMjBnbG9iLmdsb2IocGF0aCklMEElMjAlMjAlMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjBzb3J0ZWQodGltZXN0YW1wcyklNUItMSU1RC5zcGxpdCglMjIlMkYlMjIpJTVCLTIlNUQlMEElMjAlMjAlMjAlMjBwcmludChmJTIyTGF0ZXN0JTIwdGltZXN0YW1wJTNBJTIwJTdCdGltZXN0YW1wJTdEJTIyKSUwQSUwQWRldGFpbHNfcGF0aCUyMCUzRCUyMGYlMjIlN0JvdXRwdXRfZGlyJTdEJTJGZGV0YWlscyUyRiU3Qm1vZGVsX25hbWUlN0QlMkYlN0J0aW1lc3RhbXAlN0QlMkZkZXRhaWxzXyU3QnRhc2slN0RfJTdCdGltZXN0YW1wJTdELnBhcnF1ZXQlMjIlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwZGV0YWlscyUwQWRldGFpbHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIycGFycXVldCUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkZXRhaWxzX3BhdGglMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQWZvciUyMGRldGFpbCUyMGluJTIwZGV0YWlscyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGRldGFpbCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> glob

output_dir = <span class="hljs-string">&quot;evals_doc&quot;</span>
model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
timestamp = <span class="hljs-string">&quot;latest&quot;</span>
task = <span class="hljs-string">&quot;gsm8k&quot;</span>

<span class="hljs-keyword">if</span> timestamp == <span class="hljs-string">&quot;latest&quot;</span>:
    path = <span class="hljs-string">f&quot;<span class="hljs-subst">{output_dir}</span>/details/<span class="hljs-subst">{model_name}</span>/*/&quot;</span>
    timestamps = glob.glob(path)
    timestamp = <span class="hljs-built_in">sorted</span>(timestamps)[-<span class="hljs-number">1</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">2</span>]
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Latest timestamp: <span class="hljs-subst">{timestamp}</span>&quot;</span>)

details_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{output_dir}</span>/details/<span class="hljs-subst">{model_name}</span>/<span class="hljs-subst">{timestamp}</span>/details_<span class="hljs-subst">{task}</span>_<span class="hljs-subst">{timestamp}</span>.parquet&quot;</span>

<span class="hljs-comment"># Load the details</span>
details = load_dataset(<span class="hljs-string">&quot;parquet&quot;</span>, data_files=details_path, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-keyword">for</span> detail <span class="hljs-keyword">in</span> details:
    <span class="hljs-built_in">print</span>(detail)`,wrap:!1}}),z=new y({props:{title:"Loading from the Hugging Face Hub",local:"loading-from-the-hugging-face-hub",headingTag:"h3"}}),X=new os({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcmVzdWx0c19vcmclMjAlM0QlMjAlMjJTYXlsb3JUd2lmdCUyMiUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEFzYW5pdGl6ZWRfbW9kZWxfbmFtZSUyMCUzRCUyMG1vZGVsX25hbWUucmVwbGFjZSglMjIlMkYlMjIlMkMlMjAlMjJfXyUyMiklMEF0YXNrJTIwJTNEJTIwJTIyZ3NtOGslMjIlMEFwdWJsaWNfcnVuJTIwJTNEJTIwRmFsc2UlMEElMEFkYXRhc2V0X3BhdGglMjAlM0QlMjBmJTIyJTdCcmVzdWx0c19vcmclN0QlMkZkZXRhaWxzXyU3QnNhbml0aXplZF9tb2RlbF9uYW1lJTdEJTdCJ19wcml2YXRlJyUyMGlmJTIwbm90JTIwcHVibGljX3J1biUyMGVsc2UlMjAnJyU3RCUyMiUwQWRldGFpbHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoZGF0YXNldF9wYXRoJTJDJTIwdGFzay5yZXBsYWNlKCUyMiU3QyUyMiUyQyUyMCUyMl8lMjIpJTJDJTIwc3BsaXQlM0QlMjJsYXRlc3QlMjIpJTBBJTBBZm9yJTIwZGV0YWlsJTIwaW4lMjBkZXRhaWxzJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZGV0YWlsKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

results_org = <span class="hljs-string">&quot;SaylorTwift&quot;</span>
model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
sanitized_model_name = model_name.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;__&quot;</span>)
task = <span class="hljs-string">&quot;gsm8k&quot;</span>
public_run = <span class="hljs-literal">False</span>

dataset_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{results_org}</span>/details_<span class="hljs-subst">{sanitized_model_name}</span><span class="hljs-subst">{<span class="hljs-string">&#x27;_private&#x27;</span> <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> public_run <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;&#x27;</span>}</span>&quot;</span>
details = load_dataset(dataset_path, task.replace(<span class="hljs-string">&quot;|&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>), split=<span class="hljs-string">&quot;latest&quot;</span>)

<span class="hljs-keyword">for</span> detail <span class="hljs-keyword">in</span> details:
    <span class="hljs-built_in">print</span>(detail)`,wrap:!1}}),G=new y({props:{title:"Detail File Structure",local:"detail-file-structure",headingTag:"h2"}}),S=new y({props:{title:"EvaluationTracker Configuration",local:"evaluationtracker-configuration",headingTag:"h2"}}),x=new y({props:{title:"Basic Configuration",local:"basic-configuration",headingTag:"h3"}}),Y=new os({props:{code:"ZnJvbSUyMGxpZ2h0ZXZhbC5sb2dnaW5nLmV2YWx1YXRpb25fdHJhY2tlciUyMGltcG9ydCUyMEV2YWx1YXRpb25UcmFja2VyJTBBJTBBdHJhY2tlciUyMCUzRCUyMEV2YWx1YXRpb25UcmFja2VyKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjIuJTJGcmVzdWx0cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfZGV0YWlscyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBodWJfcmVzdWx0c19vcmclM0QlMjJ5b3VyX3VzZXJuYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwcHVibGljJTNERmFsc2UlMEEp",highlighted:`<span class="hljs-keyword">from</span> lighteval.logging.evaluation_tracker <span class="hljs-keyword">import</span> EvaluationTracker

tracker = EvaluationTracker(
    output_dir=<span class="hljs-string">&quot;./results&quot;</span>,
    save_details=<span class="hljs-literal">True</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    hub_results_org=<span class="hljs-string">&quot;your_username&quot;</span>,
    public=<span class="hljs-literal">False</span>
)`,wrap:!1}}),H=new y({props:{title:"Advanced Configuration",local:"advanced-configuration",headingTag:"h3"}}),D=new os({props:{code:"dHJhY2tlciUyMCUzRCUyMEV2YWx1YXRpb25UcmFja2VyKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjIuJTJGcmVzdWx0cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlc3VsdHNfcGF0aF90ZW1wbGF0ZSUzRCUyMiU3Qm91dHB1dF9kaXIlN0QlMkZjdXN0b20lMkYlN0JvcmclN0RfJTdCbW9kZWwlN0QlMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX2RldGFpbHMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b190ZW5zb3Jib2FyZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBodWJfcmVzdWx0c19vcmclM0QlMjJteS1vcmclMjIlMkMlMEElMjAlMjAlMjAlMjB0ZW5zb3Jib2FyZF9tZXRyaWNfcHJlZml4JTNEJTIyZXZhbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHB1YmxpYyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB1c2Vfd2FuZGIlM0RUcnVlJTBBKQ==",highlighted:`tracker = EvaluationTracker(
    output_dir=<span class="hljs-string">&quot;./results&quot;</span>,
    results_path_template=<span class="hljs-string">&quot;{output_dir}/custom/{org}_{model}&quot;</span>,
    save_details=<span class="hljs-literal">True</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    push_to_tensorboard=<span class="hljs-literal">True</span>,
    hub_results_org=<span class="hljs-string">&quot;my-org&quot;</span>,
    tensorboard_metric_prefix=<span class="hljs-string">&quot;eval&quot;</span>,
    public=<span class="hljs-literal">True</span>,
    use_wandb=<span class="hljs-literal">True</span>
)`,wrap:!1}}),L=new y({props:{title:"Key Parameters",local:"key-parameters",headingTag:"h3"}}),O=new y({props:{title:"Result File Structure",local:"result-file-structure",headingTag:"h2"}}),ss=new y({props:{title:"General Configuration",local:"general-configuration",headingTag:"h3"}}),ls=new y({props:{title:"Task-Specific Information",local:"task-specific-information",headingTag:"h3"}}),ns=new y({props:{title:"Results",local:"results",headingTag:"h3"}}),es=new y({props:{title:"Example of a Result File",local:"example-of-a-result-file",headingTag:"h2"}}),us=new os({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;config_general&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval_sha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;203045a8431bc9b77245c9998e05fc54509ea07f&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_fewshot_seeds&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;max_samples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;job_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;start_time&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">620979.879320166</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;end_time&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">621004.632108041</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;total_evaluation_time_secondes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;24.752787875011563&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gpt2&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_sha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;607a30d783dfa663caf39e06633721c8d4cfcd7e&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_dtype&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;476.2 MB&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;results&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;em&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;em_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;all&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;em&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;em_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;versions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;config_tasks&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;prompt_function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_repo&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_subset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;main&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;metric&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;metric_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;em&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;higher_is_better&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;category&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;3&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;use_case&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;sample_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;compute&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;corpus_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mean&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;metric_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;maj@8&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;higher_is_better&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;category&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;use_case&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;sample_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;compute&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;corpus_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mean&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_avail_splits&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;train&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-string">&quot;test&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;evaluation_splits&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;test&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;few_shots_split&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;few_shots_select&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;random_sampling_from_train&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;generation_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">256</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;generation_grammar&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;stop_sequence&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;Question=&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;num_samples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;suite&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;lighteval&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;original_num_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1319</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;effective_num_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;must_remove_duplicate_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;summary_tasks&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;hashes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;hash_examples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;8517d5bf7e880086&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_full_prompts&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;8517d5bf7e880086&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_input_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;29916e7afe5cb51d&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_cont_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;37f91ce23ef6d435&quot;</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;non_padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;effective_few_shots&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;summary_general&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;hashes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;hash_examples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5f383c395f01096e&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_full_prompts&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5f383c395f01096e&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_input_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;ac933feb14f96d7b&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_cont_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;9d03fb26f8da7277&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;non_padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),is=new Wa({props:{source:"https://github.com/huggingface/lighteval/blob/main/docs/source/saving-and-reading-results.mdx"}}),{c(){T=j("meta"),js=n(),Ms=j("p"),hs=n(),e(J.$$.fragment),rs=n(),e(U.$$.fragment),ys=n(),m=j("p"),m.innerHTML=ia,Ts=n(),e(d.$$.fragment),Js=n(),w=j("p"),w.innerHTML=oa,Us=n(),I=j("p"),I.innerHTML=Ma,ms=n(),g=j("p"),g.innerHTML=ca,ds=n(),e(f.$$.fragment),ws=n(),C=j("p"),C.innerHTML=ja,Is=n(),b=j("p"),b.innerHTML=ha,gs=n(),e(q.$$.fragment),fs=n(),A=j("p"),A.innerHTML=ra,Cs=n(),e(_.$$.fragment),bs=n(),$=j("p"),$.innerHTML=ya,qs=n(),B=j("p"),B.textContent=Ta,As=n(),e(Z.$$.fragment),_s=n(),Q=j("p"),Q.innerHTML=Ja,$s=n(),v=j("p"),v.innerHTML=Ua,Bs=n(),e(E.$$.fragment),Zs=n(),e(k.$$.fragment),Qs=n(),e(W.$$.fragment),vs=n(),e(N.$$.fragment),Es=n(),e(z.$$.fragment),ks=n(),e(X.$$.fragment),Ws=n(),e(G.$$.fragment),Ns=n(),R=j("p"),R.textContent=ma,zs=n(),F=j("ul"),F.innerHTML=da,Xs=n(),e(S.$$.fragment),Gs=n(),V=j("p"),V.innerHTML=wa,Rs=n(),e(x.$$.fragment),Fs=n(),e(Y.$$.fragment),Ss=n(),e(H.$$.fragment),Vs=n(),e(D.$$.fragment),xs=n(),e(L.$$.fragment),Ys=n(),P=j("ul"),P.innerHTML=Ia,Hs=n(),e(O.$$.fragment),Ds=n(),K=j("p"),K.textContent=ga,Ls=n(),e(ss.$$.fragment),Ps=n(),as=j("ul"),as.innerHTML=fa,Os=n(),e(ls.$$.fragment),Ks=n(),ts=j("ul"),ts.innerHTML=Ca,sa=n(),e(ns.$$.fragment),aa=n(),ps=j("ul"),ps.innerHTML=ba,la=n(),e(es.$$.fragment),ta=n(),e(us.$$.fragment),na=n(),e(is.$$.fragment),pa=n(),cs=j("p"),this.h()},l(s){const a=va("svelte-u9bgzb",document.head);T=h(a,"META",{name:!0,content:!0}),a.forEach(l),js=p(s),Ms=h(s,"P",{}),qa(Ms).forEach(l),hs=p(s),u(J.$$.fragment,s),rs=p(s),u(U.$$.fragment,s),ys=p(s),m=h(s,"P",{"data-svelte-h":!0}),r(m)!=="svelte-9aqcbu"&&(m.innerHTML=ia),Ts=p(s),u(d.$$.fragment,s),Js=p(s),w=h(s,"P",{"data-svelte-h":!0}),r(w)!=="svelte-nzo4lv"&&(w.innerHTML=oa),Us=p(s),I=h(s,"P",{"data-svelte-h":!0}),r(I)!=="svelte-103anxe"&&(I.innerHTML=Ma),ms=p(s),g=h(s,"P",{"data-svelte-h":!0}),r(g)!=="svelte-h64e6b"&&(g.innerHTML=ca),ds=p(s),u(f.$$.fragment,s),ws=p(s),C=h(s,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1cjd5zg"&&(C.innerHTML=ja),Is=p(s),b=h(s,"P",{"data-svelte-h":!0}),r(b)!=="svelte-icxxh7"&&(b.innerHTML=ha),gs=p(s),u(q.$$.fragment,s),fs=p(s),A=h(s,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1bci1gp"&&(A.innerHTML=ra),Cs=p(s),u(_.$$.fragment,s),bs=p(s),$=h(s,"P",{"data-svelte-h":!0}),r($)!=="svelte-17ozben"&&($.innerHTML=ya),qs=p(s),B=h(s,"P",{"data-svelte-h":!0}),r(B)!=="svelte-qmfp1v"&&(B.textContent=Ta),As=p(s),u(Z.$$.fragment,s),_s=p(s),Q=h(s,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-407scl"&&(Q.innerHTML=Ja),$s=p(s),v=h(s,"P",{"data-svelte-h":!0}),r(v)!=="svelte-174dmv1"&&(v.innerHTML=Ua),Bs=p(s),u(E.$$.fragment,s),Zs=p(s),u(k.$$.fragment,s),Qs=p(s),u(W.$$.fragment,s),vs=p(s),u(N.$$.fragment,s),Es=p(s),u(z.$$.fragment,s),ks=p(s),u(X.$$.fragment,s),Ws=p(s),u(G.$$.fragment,s),Ns=p(s),R=h(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1w33ibm"&&(R.textContent=ma),zs=p(s),F=h(s,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-1wz4paq"&&(F.innerHTML=da),Xs=p(s),u(S.$$.fragment,s),Gs=p(s),V=h(s,"P",{"data-svelte-h":!0}),r(V)!=="svelte-vgm6ps"&&(V.innerHTML=wa),Rs=p(s),u(x.$$.fragment,s),Fs=p(s),u(Y.$$.fragment,s),Ss=p(s),u(H.$$.fragment,s),Vs=p(s),u(D.$$.fragment,s),xs=p(s),u(L.$$.fragment,s),Ys=p(s),P=h(s,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-n2g9hd"&&(P.innerHTML=Ia),Hs=p(s),u(O.$$.fragment,s),Ds=p(s),K=h(s,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1ieqcct"&&(K.textContent=ga),Ls=p(s),u(ss.$$.fragment,s),Ps=p(s),as=h(s,"UL",{"data-svelte-h":!0}),r(as)!=="svelte-r2q4i7"&&(as.innerHTML=fa),Os=p(s),u(ls.$$.fragment,s),Ks=p(s),ts=h(s,"UL",{"data-svelte-h":!0}),r(ts)!=="svelte-a95mdm"&&(ts.innerHTML=Ca),sa=p(s),u(ns.$$.fragment,s),aa=p(s),ps=h(s,"UL",{"data-svelte-h":!0}),r(ps)!=="svelte-1iqqkon"&&(ps.innerHTML=ba),la=p(s),u(es.$$.fragment,s),ta=p(s),u(us.$$.fragment,s),na=p(s),u(is.$$.fragment,s),pa=p(s),cs=h(s,"P",{}),qa(cs).forEach(l),this.h()},h(){Aa(T,"name","hf:doc:metadata"),Aa(T,"content",za)},m(s,a){Ea(document.head,T),t(s,js,a),t(s,Ms,a),t(s,hs,a),i(J,s,a),t(s,rs,a),i(U,s,a),t(s,ys,a),t(s,m,a),t(s,Ts,a),i(d,s,a),t(s,Js,a),t(s,w,a),t(s,Us,a),t(s,I,a),t(s,ms,a),t(s,g,a),t(s,ds,a),i(f,s,a),t(s,ws,a),t(s,C,a),t(s,Is,a),t(s,b,a),t(s,gs,a),i(q,s,a),t(s,fs,a),t(s,A,a),t(s,Cs,a),i(_,s,a),t(s,bs,a),t(s,$,a),t(s,qs,a),t(s,B,a),t(s,As,a),i(Z,s,a),t(s,_s,a),t(s,Q,a),t(s,$s,a),t(s,v,a),t(s,Bs,a),i(E,s,a),t(s,Zs,a),i(k,s,a),t(s,Qs,a),i(W,s,a),t(s,vs,a),i(N,s,a),t(s,Es,a),i(z,s,a),t(s,ks,a),i(X,s,a),t(s,Ws,a),i(G,s,a),t(s,Ns,a),t(s,R,a),t(s,zs,a),t(s,F,a),t(s,Xs,a),i(S,s,a),t(s,Gs,a),t(s,V,a),t(s,Rs,a),i(x,s,a),t(s,Fs,a),i(Y,s,a),t(s,Ss,a),i(H,s,a),t(s,Vs,a),i(D,s,a),t(s,xs,a),i(L,s,a),t(s,Ys,a),t(s,P,a),t(s,Hs,a),i(O,s,a),t(s,Ds,a),t(s,K,a),t(s,Ls,a),i(ss,s,a),t(s,Ps,a),t(s,as,a),t(s,Os,a),i(ls,s,a),t(s,Ks,a),t(s,ts,a),t(s,sa,a),i(ns,s,a),t(s,aa,a),t(s,ps,a),t(s,la,a),i(es,s,a),t(s,ta,a),i(us,s,a),t(s,na,a),i(is,s,a),t(s,pa,a),t(s,cs,a),ea=!0},p:$a,i(s){ea||(o(J.$$.fragment,s),o(U.$$.fragment,s),o(d.$$.fragment,s),o(f.$$.fragment,s),o(q.$$.fragment,s),o(_.$$.fragment,s),o(Z.$$.fragment,s),o(E.$$.fragment,s),o(k.$$.fragment,s),o(W.$$.fragment,s),o(N.$$.fragment,s),o(z.$$.fragment,s),o(X.$$.fragment,s),o(G.$$.fragment,s),o(S.$$.fragment,s),o(x.$$.fragment,s),o(Y.$$.fragment,s),o(H.$$.fragment,s),o(D.$$.fragment,s),o(L.$$.fragment,s),o(O.$$.fragment,s),o(ss.$$.fragment,s),o(ls.$$.fragment,s),o(ns.$$.fragment,s),o(es.$$.fragment,s),o(us.$$.fragment,s),o(is.$$.fragment,s),ea=!0)},o(s){M(J.$$.fragment,s),M(U.$$.fragment,s),M(d.$$.fragment,s),M(f.$$.fragment,s),M(q.$$.fragment,s),M(_.$$.fragment,s),M(Z.$$.fragment,s),M(E.$$.fragment,s),M(k.$$.fragment,s),M(W.$$.fragment,s),M(N.$$.fragment,s),M(z.$$.fragment,s),M(X.$$.fragment,s),M(G.$$.fragment,s),M(S.$$.fragment,s),M(x.$$.fragment,s),M(Y.$$.fragment,s),M(H.$$.fragment,s),M(D.$$.fragment,s),M(L.$$.fragment,s),M(O.$$.fragment,s),M(ss.$$.fragment,s),M(ls.$$.fragment,s),M(ns.$$.fragment,s),M(es.$$.fragment,s),M(us.$$.fragment,s),M(is.$$.fragment,s),ea=!1},d(s){s&&(l(js),l(Ms),l(hs),l(rs),l(ys),l(m),l(Ts),l(Js),l(w),l(Us),l(I),l(ms),l(g),l(ds),l(ws),l(C),l(Is),l(b),l(gs),l(fs),l(A),l(Cs),l(bs),l($),l(qs),l(B),l(As),l(_s),l(Q),l($s),l(v),l(Bs),l(Zs),l(Qs),l(vs),l(Es),l(ks),l(Ws),l(Ns),l(R),l(zs),l(F),l(Xs),l(Gs),l(V),l(Rs),l(Fs),l(Ss),l(Vs),l(xs),l(Ys),l(P),l(Hs),l(Ds),l(K),l(Ls),l(Ps),l(as),l(Os),l(Ks),l(ts),l(sa),l(aa),l(ps),l(la),l(ta),l(na),l(pa),l(cs)),l(T),c(J,s),c(U,s),c(d,s),c(f,s),c(q,s),c(_,s),c(Z,s),c(E,s),c(k,s),c(W,s),c(N,s),c(z,s),c(X,s),c(G,s),c(S,s),c(x,s),c(Y,s),c(H,s),c(D,s),c(L,s),c(O,s),c(ss,s),c(ls,s),c(ns,s),c(es,s),c(us,s),c(is,s)}}}const za='{"title":"Saving and Reading Results","local":"saving-and-reading-results","sections":[{"title":"Saving Results Locally","local":"saving-results-locally","sections":[],"depth":2},{"title":"Pushing Results to the Hugging Face Hub","local":"pushing-results-to-the-hugging-face-hub","sections":[],"depth":2},{"title":"Pushing Results to TensorBoard","local":"pushing-results-to-tensorboard","sections":[],"depth":2},{"title":"Pushing Results to Weights & Biases or Trackio","local":"pushing-results-to-weights--biases-or-trackio","sections":[],"depth":2},{"title":"How to Load and Investigate Details","local":"how-to-load-and-investigate-details","sections":[{"title":"Loading from Local Detail Files","local":"loading-from-local-detail-files","sections":[],"depth":3},{"title":"Loading from the Hugging Face Hub","local":"loading-from-the-hugging-face-hub","sections":[],"depth":3}],"depth":2},{"title":"Detail File Structure","local":"detail-file-structure","sections":[],"depth":2},{"title":"EvaluationTracker Configuration","local":"evaluationtracker-configuration","sections":[{"title":"Basic Configuration","local":"basic-configuration","sections":[],"depth":3},{"title":"Advanced Configuration","local":"advanced-configuration","sections":[],"depth":3},{"title":"Key Parameters","local":"key-parameters","sections":[],"depth":3}],"depth":2},{"title":"Result File Structure","local":"result-file-structure","sections":[{"title":"General Configuration","local":"general-configuration","sections":[],"depth":3},{"title":"Task-Specific Information","local":"task-specific-information","sections":[],"depth":3},{"title":"Results","local":"results","sections":[],"depth":3}],"depth":2},{"title":"Example of a Result File","local":"example-of-a-result-file","sections":[],"depth":2}],"depth":1}';function Xa(ua){return Ba(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Va extends Za{constructor(T){super(),Qa(this,T,Xa,Na,_a,{})}}export{Va as component};
