# Раздел 4. Разработка классификатора музыкальных жанров

## Чему вы научитесь и что вы сможете создать

Классификация звука - одно из наиболее распространенных применений трансформеров в обработке звука и речи. Как и другие
задачи классификации в машинном обучении, эта задача предполагает присвоение одной или нескольких меток аудиозаписи на основе
ее содержания. Например, в случае с речью мы можем захотеть обнаружить, когда произносится фраза-пробуждение вроде "Привет, Siri",
или определить ключевое слово вроде "температура" из произнесенного запроса "Какая сегодня погода?". Другим примером могут служить
звуки окружающей среды, когда мы хотим автоматически различать такие звуки, как "автомобильный гудок", "сирена", "лай собаки" и т.д.

В этом разделе мы рассмотрим, как предварительно обученные звуковые трансформеры могут применяться в различных задачах классификации звука.
Затем мы произведем дообучение модели-трансформера на задаче классификации музыки, классифицируя песни по жанрам, таким как "поп" и "рок".
Это важная составляющая таких музыкальных стриминговых сервисов, как [Spotify](https://en.wikipedia.org/wiki/Spotify), которые
рекомендуют песни, похожие на те, что слушает пользователь.

К концу этого раздела вы узнаете, как:

* Найти подходящие предварительно обученные модели для задачи классификации звука
* Использовать библиотеку 🤗 Datasets и Hugging Face Hub для выбора наборов данных для классификации звука
* Производить дообучение предварительно обученной модели для классификации песен по жанрам
* Создание демо-версии Gradio, позволяющей классифицировать собственные песни

<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/ru/chapter4/introduction.mdx" />