import{s as Qa,n as Va,o as Ra}from"../chunks/scheduler.cd324960.js";import{S as ga,i as ka,e as p,s as a,c as i,q as I,H as it,h as va,a as M,d as s,b as n,f as rt,g as U,j as J,r as b,u as Ut,k as ye,l as j,m as t,n as y,t as T,o as w,p as m}from"../chunks/index.d5c3adcc.js";import{C as Ga,H as Te,E as $a}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.4fcff51e.js";import{C as r}from"../chunks/CodeBlock.075f5775.js";function Fa(ht){let c,we,ie,me,f,re,C,he,E,ot=`В этом разделе мы рассмотрим, как с помощью <code>pipeline()</code> использовать предварительно обученные модели для распознавания речи.
В <a href="../chapter2/asr_pipeline">Разделе 2</a> мы представили <code>pipeline()</code> как простой способ выполнения задач распознавания речи с предварительной
и последующей обработкой “под капотом” и возможностью быстро экспериментировать с любой предварительно обученной контрольной точкой модели на Hugging Face Hub.
В этом разделе мы углубимся в изучение различных характеристик моделей распознавания речи и рассмотрим, как их можно использовать для решения различных задач.`,oe,S,jt="Как подробно описано в Разделе 3, модели распознавания речи в целом относятся к одной из двух категорий:",je,x,ct="<li>Connectionist Temporal Classification (CTC) или Коннекционистская Временная Классификация: модели состящие только из энкодера, с головой линейного классификатора в вершине модели.</li> <li>Sequence-to-sequence (Seq2Seq) или последовательность-в-последовательность: модели включающие в себя как энкодер, так и декодер с механизмом перекрестного внимания между ними (cross-attention).</li>",ce,B,dt=`До 2022 года более популярной из двух архитектур была CTC, а такие модели, работающие только с энкодером, как Wav2Vec2, HuBERT и XLSR, совершили прорыв в парадигме
предварительного обучения/дообучения в задачах с речью. Крупные корпорации, такие как Meta и Microsoft, предварительно обучали энкодер на огромных объемах
неразмеченных аудиоданных в течение многих дней или недель. Затем пользователи могли взять предварительно обученную контрольную точку и дообучить ее с помощью
головы CTC всего на <strong>10 минутах</strong> размеченных речевых данных для достижения высоких результатов в последующей задаче распознавания речи.`,de,Q,ut=`Однако модели CTC имеют свои недостатки. Присоединение простого линейного слоя к кодирующему устройству дает небольшую и быструю модель в целом, но она может
быть подвержена фонетическим ошибкам в написании. Ниже мы продемонстрируем это на примере модели Wav2Vec2.`,ue,V,Ie,R,It=`Загрузим небольшой фрагмент набора данных <a href="hf-internal-testing/librispeech_asr_dummy">LibriSpeech ASR</a> чтобы продемонстрировать возможности Wav2Vec2
по транскрибации речи:`,be,g,fe,k,bt="<strong>Output:</strong>",Ce,v,Ee,G,ft="Мы можем выбрать один из 73 аудиообразцов и просмотреть его, а также транскрипцию:",Se,$,xe,F,Ct="<strong>Output:</strong>",Be,H,Qe,W,Et=`Хорошо! Рождество и запеченная в духовке говядина, звучит здорово! 🎄 Сформировав выборку данных, мы теперь загружаем
дообученную контрольную точку в <code>pipeline()</code>. Для этого мы будем использовать официальную контрольную точку <a href="facebook/wav2vec2-base-100h">Wav2Vec2 base</a>
дообученную на 100 часах данных LibriSpeech:`,Ve,Z,Re,N,St=`Далее мы возьмем пример из набора данных и передадим его исходные данные в конвейер. Поскольку <code>pipeline</code> <em>поглощает</em> любой словарь, который мы ему
передаем (то есть его нельзя использовать повторно), мы будем передавать копию данных. Таким образом, мы можем безопасно повторно использовать один
и тот же аудиообразец в следующих примерах:`,ge,_,ke,Y,xt="<strong>Output:</strong>",ve,A,Ge,L,Bt=`Видно, что модель Wav2Vec2 неплохо справляется с транскрибацией данного образца - на первый взгляд, все выглядит в целом корректно.
Давайте поставим целевое значение (target) и прогноз/предсказание модели (prediction) рядом и выделим различия:`,$e,z,Fe,X,Qt="Сравнивая целевой текст с предсказанной транскрибацией, мы видим, что все слова <em>звучат</em> правильно, но некоторые написаны не совсем точно. Например:",He,q,Vt="<li><em>CHRISTMAUS</em> vs. <em>CHRISTMAS</em></li> <li><em>ROSE</em> vs. <em>ROAST</em></li> <li><em>SIMALYIS</em> vs. <em>SIMILES</em></li>",We,D,Rt=`Это подчеркивает недостаток модели CTC. Модель CTC - это, по сути, “только акустическая” модель: она состоит из энкодера, который формирует представления
скрытых состояний из аудиовходов, и линейного слоя, который отображает скрытые состояния в символы:`,Ze,O,gt=`Это означает, что система практически полностью основывает свое предсказание на акустических данных (фонетических звуках аудиозаписи) и поэтому склонна
транскрибировать аудиозапись фонетическим способом (например, <em>CHRISTMAUS</em>). В нем меньше внимания уделяется языковому моделирующему контексту предыдущих
и последующих букв, поэтому он склонен к фонетическим ошибкам в написании. Более интеллектуальная модель определила бы, что <em>CHRISTMAUS</em> не является
правильным словом в английском словаре, и исправила бы его на <em>CHRISTMAS</em>, когда делала бы свои предсказания. Кроме того, в нашем прогнозировании отсутствуют
два важных признака - регистр и пунктуация, что ограничивает полезность транскрибации модели для реальных приложений.`,Ne,P,_e,K,kt=`Модели Seq2Seq! Как было описано в Разделе 3, модели Seq2Seq состоят из энкодера и декодера, связанных между собой механизмом перекрестного внимания.
Энкодер играет ту же роль, что и раньше, вычисляя представления скрытых состояний аудиовходов, а декодер - роль <strong>языковой модели</strong>. Декодер обрабатывает
всю последовательность представлений скрытых состояний, полученных от энкодера, и формирует соответствующие текстовые транскрипции. Имея глобальный контекст
входного аудиосигнала, декодер может использовать контекст языкового моделирования при составлении своих прогнозов, исправляя орфографические ошибки
“на лету” и тем самым обходя проблему фонетических прогнозов.`,Ye,ll,vt="У моделей Seq2Seq есть два недостатка:",Ae,el,Gt="<li>Они изначально медленнее декодируют, поскольку процесс декодирования происходит по одному шагу за раз, а не все сразу</li> <li>Они более требовательны к данным, для достижения сходимости им требуется значительно больше обучающих данных</li>",Le,sl,$t=`В частности, узким местом в развитии архитектур Seq2Seq для задач с речью является потребность в больших объемах обучающих данных. Размеченные речевые данные
труднодоступны, самые большие аннотированные базы данных на тот момент составляли всего 10 000 часов. Все изменилось в 2022 году после выхода <strong>Whisper</strong>.
Whisper - это предварительно обученная модель для распознавания речи, опубликованная в <a href="https://openai.com/blog/whisper/" rel="nofollow">Сентябре 2022</a> авторами Alec Radford
и др. из компании OpenAI. В отличие от предшественников CTC, которые обучались исключительно на <strong>неразмеченных</strong> аудиоданных, Whisper предварительно обучен
на огромном количестве <strong>размеченных</strong> данных аудиотранскрипции, а именно на 680 000 часов.`,ze,tl,Ft=`Это на порядок больше данных, чем неразмеченные аудиоданные, использованные для обучения Wav2Vec 2.0 (60 000 часов). Более того, 117 000 часов этих данных,
предназначенных для предварительного обучения, являются мультиязычными (или “не английскими”) данными. В результате контрольные точки могут быть применены
к более чем 96 языкам, многие из которых считаются <em>низкоресурсными</em>, т.е. не имеющими большого корпуса данных, пригодных для обучения.`,Xe,al,Ht=`При масштабировании на 680 000 часов аннотированных данных для предварительного обучения модели Whisper демонстрируют высокую способность к обобщению
на многие наборы данных и области. Предварительно обученные контрольные точки достигают результатов, конкурентоспособных с state-of-the-art pipe systems,
с коэффициентом ошибок в словах (WER) около 3% на подмножестве чистых тестов LibriSpeech и новым рекордом на TED-LIUM с WER 4,7%
(см. табл. 8 <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper paper</a>).`,qe,nl,Wt=`Особое значение имеет способность Whisper работать с длинными аудиообразцами, устойчивость к входным шумам и возможность предсказывать транскрипцию с
использованием падежей и пунктуации. Это делает его перспективным для использования в реальных системах распознавания речи.`,De,pl,Zt=`В оставшейся части этого раздела будет показано, как использовать предварительно обученные модели Whisper для распознавания речи с помощью 🤗 Transformers.
Во многих ситуациях предварительно обученные контрольные точки Whisper обладают высокой производительностью и дают отличные результаты, поэтому мы
рекомендуем вам попробовать использовать предварительно обученные контрольные точки в качестве первого шага к решению любой задачи распознавания речи.
Благодаря дообучению предварительно обученные контрольные точки могут быть адаптированы для конкретных наборов данных и языков с целью дальнейшего
улучшения результатов. Как это сделать, мы продемонстрируем в следующем подразделе, посвященном [дообучению] (fine-tuning).`,Oe,Ml,Nt=`Контрольные точки модели Whisper доступны в пяти конфигурациях с различными размерами модели. Наименьшие по параметрам четыре модели обучаются либо
только на английском, либо на многоязычных данных. Самая большая по параметрам контрольная точка была обучена только на мультиязычных данных.
Все девять предварительно обученных контрольных точек доступны на <a href="https://huggingface.co/models?search=openai/whisper" rel="nofollow">Hugging Face Hub</a>. Контрольные
точки приведены в следующей таблице со ссылками на модели на Hugging Face Hub. “VRAM” обозначает объем памяти GPU, необходимый для работы модели с
минимальным размером пакета = 1. “Rel Speed” - относительная скорость контрольной точки по сравнению с самой большой моделью. На основе этой информации
можно выбрать контрольную точку, наиболее подходящую для вашего оборудования.`,Pe,Jl,_t='<thead><tr><th>Size</th> <th>Parameters</th> <th>VRAM / GB</th> <th>Rel Speed</th> <th>English-only</th> <th>Multilingual</th></tr></thead> <tbody><tr><td>tiny</td> <td>39 M</td> <td>1.4</td> <td>32</td> <td><a href="https://huggingface.co/openai/whisper-tiny.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-tiny" rel="nofollow">✓</a></td></tr> <tr><td>base</td> <td>74 M</td> <td>1.5</td> <td>16</td> <td><a href="https://huggingface.co/openai/whisper-base.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-base" rel="nofollow">✓</a></td></tr> <tr><td>small</td> <td>244 M</td> <td>2.3</td> <td>6</td> <td><a href="https://huggingface.co/openai/whisper-small.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-small" rel="nofollow">✓</a></td></tr> <tr><td>medium</td> <td>769 M</td> <td>4.2</td> <td>2</td> <td><a href="https://huggingface.co/openai/whisper-medium.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-medium" rel="nofollow">✓</a></td></tr> <tr><td>large</td> <td>1550 M</td> <td>7.5</td> <td>1</td> <td>x</td> <td><a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow">✓</a></td></tr></tbody>',Ke,il,Yt=`Загрузим контрольную точку <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a>, которая по размеру сопоставима с контрольной точкой Wav2Vec2, которую
мы использовали ранее. Предваряя наш переход к многоязычному распознаванию речи, загрузим многоязычный вариант базовой контрольной точки. Мы также загрузим
модель на GPU, если он доступен, или на CPU в противном случае. В последствии <code>pipeline()</code> позаботится о перемещении всех входов/выходов с CPU на GPU по мере
необходимости:`,ls,Ul,es,yl,At=`Отлично! Теперь давайте транскрибируем аудиозапись, как и раньше. Единственное изменение - это передача дополнительного аргумента <code>max_new_tokens</code>, который
указывает модели максимальное количество токенов, которые нужно генерировать при предсказании:`,ss,Tl,ts,wl,Lt="<strong>Output:</strong>",as,ml,ns,rl,zt=`Достаточно легко! Первое, на что вы обратите внимание, - это наличие как регистра, так и знаков препинания. Это сразу же делает транскрипцию более удобной для
чтения по сравнению с транскрипцией из Wav2Vec2, не содержащей ни регистра, ни пунктуации. Давайте поместим транскрипцию рядом с целевой меткой:`,ps,hl,Ms,ol,Xt=`Whisper проделал большую работу по исправлению фонетических ошибок, которые мы видели в Wav2Vec2 - и <em>Christmas</em>, и <em>roast</em> написаны правильно.
Мы видим, что модель все еще испытывает трудности с <em>SIMILES</em>, которое неправильно транскрибируется как <em>similarly</em>, но на этот раз предсказание
является правильным словом из английского словаря. Использование контрольной точки Whisper большего размера позволяет еще больше снизить количество
ошибок в транскрибированном тексте, но при этом требует больше вычислений и увеличивает время транскрибации.`,Js,jl,qt=`Нам обещали модель, способную работать с 96 языками, так что оставим пока распознавание английской речи и пойдем по миру 🌎! Набор данных <a href="https://huggingface.co/datasets/facebook/multilingual_librispeech" rel="nofollow">Multilingual LibriSpeech</a>
(MLS) представляет собой многоязычный аналог набора данных LibriSpeech, содержащий размеченные аудиоданные на шести языках. Мы загрузим одну
образец из испанской части набора данных MLS, используя режим <em>streaming</em>, чтобы не загружать весь набор данных:`,is,cl,Us,dl,Dt="Снова посмотрим текстовую транскрипцию и прослушаем аудиофрагмент:",ys,ul,Ts,Il,Ot="<strong>Output:</strong>",ws,bl,ms,fl,Pt=`Это целевой текст, на который мы ориентируемся в нашей транскрипции Whisper. Хотя теперь мы знаем, что, вероятно, можем сделать это лучше,
поскольку наша модель будет предсказывать также пунктуацию и регистр, которые в выводе примера отсутствуют. Передадим образец звука в конвейер для
получения предсказания текста. Следует отметить, что конвейер <em>потребует</em> словарь аудиовходов, который мы вводим, то есть словарь не может
быть использован повторно. Чтобы обойти эту проблему, мы будем передавать <em>копию</em> аудиообразца, что позволит нам повторно использовать тот же самый
аудиообразец в последующих примерах кода:`,rs,Cl,hs,El,Kt="<strong>Output:</strong>",os,Sl,js,xl,la=`Отлично - это очень похоже на наш целевой текст (возможно, даже лучше, поскольку в нем есть пунктуация и регистр!). Обратите внимание, что мы передали
<code>&quot;task&quot;</code> в качестве аргумента <em>генерируемого ключевого слова</em> (generate kwarg). Передача ключу <code>&quot;task&quot;</code> значения <code>&quot;transcribe&quot;</code> заставляет Whisper
выполнять задачу <em>распознавания речи</em>, при которой аудиозапись транскрибируется на том же языке, на котором была произнесена речь. Whisper также
способен выполнять тесно связанную с задачу - <em>перевода речи</em>, когда аудиозапись на испанском языке может быть переведена в текст на английском.
Для этого мы передаем ключу <code>&quot;task&quot;</code> значение <code>&quot;translate&quot;</code>:`,cs,Bl,ds,Ql,ea="<strong>Output:</strong>",us,Vl,Is,Rl,sa=`Теперь, когда мы знаем, что можем переключаться между распознаванием речи и ее переводом, мы можем выбирать задачу в зависимости от наших потребностей.
Либо мы распознаем звук на языке X в текст на том же языке X (например, испанский звук в испанский текст), либо переводим с любого языка X в текст
на английском языке (например, испанский звук в английский текст).`,bs,gl,ta=`Подробнее о том, как аргумент <code>&quot;task&quot;</code> используется для управления свойствами генерируемого текста, см. в <a href="https://huggingface.co/openai/whisper-base#usage" rel="nofollow">карточке модели</a>
для базовой модели Whisper.`,fs,kl,Cs,vl,aa=`Пока мы были сосредоточены на транскрибации коротких аудиофрагментов длительностью менее 30 секунд. Мы уже упоминали, что одной из привлекательных
сторон Whisper является возможность работы с длинными аудиофрагментами. В этой части раздела мы рассмотрим эту задачу!`,Es,Gl,na=`Создадим длинный аудиофайл путем конкатенации последовательных выборок из набора данных MLS. Поскольку набор данных MLS формируется путем разбиения
длинных записей аудиокниг на более короткие сегменты, конкатенация образцов является одним из способов реконструкции более длинных отрывков аудиокниг.
Следовательно, результирующий звук должен быть когерентным по всей выборке.`,Ss,$l,pa="Мы установим целевую длительность звука в 5 минут и прекратим конкатенацию сэмплов, как только достигнем этого значения:",xs,Fl,Bs,Hl,Ma="<strong>Output:</strong>",Qs,Wl,Vs,Zl,Ja=`Отлично! Осталось транскрибировать 5 минут 17 секунд аудиозаписи. При передаче такого длинного аудиофрагмента непосредственно в модель
возникают две проблемы:`,Rs,Nl,ia="<li>Whisper изначально рассчитан на работу с 30-секундными образцами: все, что короче 30 секунд, заполняется тишиной, все, что длиннее 30 секунд, усекается до 30 секунд путем вырезания лишнего звука, поэтому если мы передадим наш звук напрямую, то получим транскрипцию только первых 30 секунд</li> <li>Память в сети трансформера зависит от квадрата длины последовательности: удвоение длины входного сигнала увеличивает потребность в памяти в четыре раза, поэтому передача очень длинных аудиофайлов обязательно приведет к ошибке “вне памяти” (out-of-memory)</li>",gs,_l,Ua=`Длинная транскрибация в 🤗 Transformers осуществляется путем <em>фрагментации</em> (от англ. chunking) входного аудио на более мелкие и управляемые фрагменты.
Каждый фрагмент имеет небольшое наложение с предыдущим. Это позволяет нам точно соединять фрагменты на границах,
так как мы можем найти наложение между фрагментами и соответствующим образом объединить транскрипции:`,ks,d,ya='<img src="https://huggingface.co/blog/assets/49_asr_chunking/Striding.png" alt="🤗 Transformers chunking algorithm. Source: https://huggingface.co/blog/asr-chunking."/>',vs,h,yt,Gs,Ea='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',$s,Fs,Sa='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Hs,Me,Ta="нестационарный",Tt,Ws,xa='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Zs,Ns,Ba='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',_s,Je,wa="пакетировать",wt,u,ma="посте из блога",mt,Ys,Yl,ra=`Для активации длинных транскрипций необходимо добавить один дополнительный аргумент при вызове конвейера. Этот аргумент, <code>chunk_length_s</code>,
определяет длину фрагментов в секундах. Для Whisper оптимальной является 30-секундная длина фрагментов, поскольку она соответствует длине
входного сигнала, ожидаемого Whisper.`,As,Al,ha=`Чтобы активизировать пакетную обработку, необходимо передать конвейеру аргумент <code>batch_size</code>. Если собрать все это воедино,
то транскрибация длинного аудиообразца с использованием чанкинга и батчинга может быть выполнена следующим образом:`,Ls,Ll,zs,zl,oa="<strong>Output:</strong>",Xs,Xl,qs,ql,ja=`Мы не будем приводить здесь весь результат, поскольку он довольно длинный (всего 312 слов)! На графическом процессоре V100
с памятью 16 Гбайт выполнение приведенной выше строки займет примерно 3,45 секунды, что весьма неплохо для 317-секундного аудиообразца.
На CPU ожидается около 30 секунд.`,Ds,Dl,ca=`Whisper также способен предсказывать <em>временные метки</em> на уровне фрагментов для аудиоданных. Эти временные метки указывают на время начала
и окончания короткого отрывка аудиозаписи и особенно полезны для выравнивания транскрипции с входным аудиосигналом. Предположим, мы хотим
создать субтитры для видео - нам нужны эти временные метки, чтобы знать, какая часть транскрипции соответствует определенному
сегменту видео, чтобы отобразить правильную транскрипцию для этого времени.`,Os,Ol,da=`Активировать предсказание временных меток очень просто, достаточно установить аргумент <code>return_timestamps=True</code>. Временные метки совместимы
с методами фрагментирования и пакетирования, которые мы использовали ранее, поэтому мы можем просто добавить аргумент timestamp к нашему
предыдущему вызову:`,Ps,Pl,Ks,Kl,ua="<strong>Output:</strong>",lt,le,et,ee,Ia="И вуаля! У нас есть предсказанный текст и соответствующие временные метки.",st,se,tt,te,ba=`Whisper - это сильная предварительно обученная модель для распознавания и перевода речи. По сравнению с Wav2Vec2, он обладает более
высокой точностью транскрибации, при этом выходные данные содержат знаки препинания и регистр. Он может использоваться для транскрибации
речи на английском и 96 других языках, как на коротких аудиофрагментах, так и на более длинных за счет <em>фрагментирования</em>. Эти качества делают
его подходящей моделью для многих задач распознавания речи и перевода без необходимости дообучения. Метод <code>pipeline()</code> обеспечивает простой
способ выполнения выводов в виде однострочных вызовов API с контролем над генерируемыми предсказаниями.`,at,ae,fa=`В то время как модель Whisper демонстрирует отличные результаты на многих языках с большим количеством ресурсов, она имеет более низкую
точность транскрибации и перевода на языках с малым количеством ресурсов, т.е. на языках с меньшим количеством доступных обучающих данных.
Кроме того, существуют различия в результатах работы с разными акцентами и диалектами некоторых языков, включая более низкую точность для
носителей разных полов, рас, возрастов и других демографических критериев (например, <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper paper</a>).`,nt,ne,Ca=`Для повышения производительности при работе с языками, акцентами или диалектами, не имеющими достаточного количества ресурсов, мы можем взять
предварительно обученную модель Whisper и обучить ее на небольшом корпусе данных, подобранных соответствующим образом, в процессе,
называемом <em>дообучением</em>. Мы покажем, что всего десять часов дополнительных данных позволяют повысить производительность модели Whisper более
чем на 100% на языке с низким уровнем ресурсов. В следующей секции мы рассмотрим процесс выбора набора данных для дообучения модели.`,pt,pe,Mt,Ue,Jt;return f=new Ga({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new Te({props:{title:"Предварительно обученные модели для распознавания речи",local:"предварительно-обученные-модели-для-распознавания-речи",headingTag:"h1"}}),V=new Te({props:{title:"Анализ моделей CTC",local:"анализ-моделей-ctc",headingTag:"h2"}}),g=new r({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMEEpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(
    <span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>
)
dataset`,wrap:!1}}),v=new r({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidmaWxlJyUyQyUyMCdhdWRpbyclMkMlMjAndGV4dCclMkMlMjAnc3BlYWtlcl9pZCclMkMlMjAnY2hhcHRlcl9pZCclMkMlMjAnaWQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA3MyUwQSU3RCk=",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;file&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;speaker_id&#x27;</span>, <span class="hljs-string">&#x27;chapter_id&#x27;</span>, <span class="hljs-string">&#x27;id&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">73</span>
})`,wrap:!1}}),$=new r({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjIlNUQlMEElMEFwcmludChzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEKSUwQUF1ZGlvKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByYXRlJTNEc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sample = dataset[<span class="hljs-number">2</span>]

<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),H=new r({props:{code:"SEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5E",highlighted:'HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND',wrap:!1}}),Z=new r({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS0xMDBoJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;facebook/wav2vec2-base-100h&quot;</span>)`,wrap:!1}}),_=new r({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCkp",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())',wrap:!1}}),A=new r({props:{code:"JTdCJTIydGV4dCUyMiUzQSUyMCUyMkhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMENIUklTVE1BVVMlMjBBTkQlMjBST1NFJTIwQkVFRiUyMExPT01JTkclMjBCRUZPUkUlMjBVUyUyMFNJTUFMWUlTJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQlMjIlN0Q=",highlighted:'<span class="hljs-comment">{&quot;text&quot;: &quot;HE TELLS US THAT AT THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAUS AND ROSE BEEF LOOMING BEFORE US SIMALYIS DRAWN FROM EATING AND ITS RESULTS OCCUR MOST READILY TO THE MIND&quot;}</span>',wrap:!1}}),z=new r({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMCUyMEhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMCoqQ0hSSVNUTUFVUyoqJTIwQU5EJTIwKipST1NFKiolMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwKipTSU1BTFlJUyoqJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQ=",highlighted:`<span class="hljs-symbol">Target:</span>      HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span>  HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH **CHRISTMAUS** <span class="hljs-keyword">AND </span>**ROSE** <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US **SIMALYIS** DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND`,wrap:!1}}),P=new Te({props:{title:"Переход к Seq2Seq",local:"переход-к-seq2seq",headingTag:"h2"}}),Ul=new r({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`,wrap:!1}}),Tl=new r({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>)',wrap:!1}}),ml=new r({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMENocmlzdG1hcyUyMGFuZCUyMHJvYXN0JTIwYmVlZiUyMGxvb21pbmclMjBiZWZvcmUlMjB1cyUyQyUyMHNpbWlsYXJseSUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQuJyU3RA==",highlighted:'{&#x27;<span class="hljs-built_in">text</span>&#x27;: &#x27; He tells us <span class="hljs-keyword">that</span> <span class="hljs-keyword">at</span> this festive season <span class="hljs-keyword">of</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span>, <span class="hljs-keyword">with</span> Christmas <span class="hljs-keyword">and</span> roast beef looming <span class="hljs-keyword">before</span> us, similarly <span class="hljs-keyword">is</span> drawn <span class="hljs-keyword">from</span> eating <span class="hljs-keyword">and</span> <span class="hljs-keyword">its</span> results occur most readily <span class="hljs-keyword">to</span> <span class="hljs-keyword">the</span> mind.&#x27;}',wrap:!1}}),hl=new r({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMCoqQ2hyaXN0bWFzKiolMjBhbmQlMjAqKnJvYXN0KiolMjBiZWVmJTIwbG9vbWluZyUyMGJlZm9yZSUyMHVzJTJDJTIwKipzaW1pbGFybHkqKiUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQu",highlighted:`<span class="hljs-symbol">Target:</span>     HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span> He tells us that <span class="hljs-built_in">at</span> this festive season of the year, with **Christmas** <span class="hljs-keyword">and </span>**roast** <span class="hljs-keyword">beef </span>looming <span class="hljs-keyword">before </span>us, **similarly** is drawn from eating <span class="hljs-keyword">and </span>its results occur most readily to the mind.`,wrap:!1}}),cl=new r({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm11bHRpbGluZ3VhbF9saWJyaXNwZWVjaCUyMiUyQyUyMCUyMnNwYW5pc2glMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTBBKSUwQXNhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSk=",highlighted:`dataset = load_dataset(
    <span class="hljs-string">&quot;facebook/multilingual_librispeech&quot;</span>, <span class="hljs-string">&quot;spanish&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`,wrap:!1}}),ul=new r({props:{code:"cHJpbnQoc2FtcGxlJTVCJTIydGV4dCUyMiU1RCklMEFBdWRpbyhzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmF0ZSUzRHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),bl=new r({props:{code:"ZW50b25jZXMlMjB0ZSUyMGRlbGVsaXRhciVDMyVBMXMlMjBlbiUyMGplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjAlQzMlQTElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwamFjb2IlMjB0dSUyMHBhZHJlJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBqZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRv",highlighted:'entonces <span class="hljs-keyword">te</span> delelitarás <span class="hljs-keyword">en</span> jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré á comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> jehová lo ha hablado',wrap:!1}}),Cl=new r({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1NiUyQyUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMnRhc2slMjIlM0ElMjAlMjJ0cmFuc2NyaWJlJTIyJTdEKQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy(), max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>})',wrap:!1}}),Sl=new r({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUyMGhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4nJTdE",highlighted:'{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> Jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado.&#x27;}',wrap:!1}}),Bl=new r({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zbGF0ZSUyMiU3RCk=",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})',wrap:!1}}),Vl=new r({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMFNvJTIweW91JTIwd2lsbCUyMGNob29zZSUyMGluJTIwSmVob3ZhaCUyMGFuZCUyMEklMjB3aWxsJTIwcmFpc2UlMjB5b3UlMjBvbiUyMHRoZSUyMGhlaWdodHMlMjBvZiUyMHRoZSUyMGVhcnRoJTIwYW5kJTIwSSUyMHdpbGwlMjBnaXZlJTIweW91JTIwdGhlJTIwaG9ub3IlMjBvZiUyMEphY29iJTIwdG8lMjB5b3VyJTIwZmF0aGVyJTIwYmVjYXVzZSUyMHRoZSUyMHZvaWNlJTIwb2YlMjBKZWhvdmFoJTIwaGFzJTIwc3Bva2VuJTIwdG8lMjB5b3UuJyU3RA==",highlighted:'<span class="hljs-comment">{&#x27;text&#x27;: &#x27; So you will choose in Jehovah and I will raise you on the heights of the earth and I will give you the honor of Jacob to your father because the voice of Jehovah has spoken to you.&#x27;}</span>',wrap:!1}}),kl=new Te({props:{title:"Длинноформатная транскрипция и временные метки",local:"длинноформатная-транскрипция-и-временные-метки",headingTag:"h2"}}),Fl=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_length_in_m = <span class="hljs-number">5</span>

<span class="hljs-comment"># преобразование из минут в секунды (* 60) в число выборок (* частота дискретизации)</span>
sampling_rate = pipe.feature_extractor.sampling_rate
target_length_in_samples = target_length_in_m * <span class="hljs-number">60</span> * sampling_rate

<span class="hljs-comment"># итерируемся по нашему потоковому набору данных, конкатенируя выборки до тех пор, пока мы не достигнем нашей цели</span>
long_audio = []
<span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> dataset:
    long_audio.extend(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(long_audio) &gt; target_length_in_samples:
        <span class="hljs-keyword">break</span>

long_audio = np.asarray(long_audio)

<span class="hljs-comment"># что у нас получилось?</span>
seconds = <span class="hljs-built_in">len</span>(long_audio) / <span class="hljs-number">16000</span>
minutes, seconds = <span class="hljs-built_in">divmod</span>(seconds, <span class="hljs-number">60</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Length of audio sample is <span class="hljs-subst">{minutes}</span> minutes <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)`,wrap:!1}}),Wl=new r({props:{code:"TGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwNS4wJTIwbWludXRlcyUyMDE3LjIyJTIwc2Vjb25kcw==",highlighted:'<span class="hljs-attribute">Length</span> of audio sample is <span class="hljs-number">5</span>.<span class="hljs-number">0</span> minutes <span class="hljs-number">17</span>.<span class="hljs-number">22</span> seconds',wrap:!1}}),Ll=new r({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
)`,wrap:!1}}),Xl=new r({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTJDJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMkMlMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUwQWhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyQyUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4lMjBub3NvdHJvcyUyMGN1cmFkb3MuJTIwVG9kb3MlMjBub3NvdHJvcyUyMG5vcyUyMGRlc2NhcnJpYW1vcyUwQWNvbW8lMjBiZWphcyUyQyUyMGNhZGElMjBjdWFsJTIwc2UlMjBhcGFydCVDMyVCMyUyMHBvciUyMHN1JTIwY2FtaW5vJTJDJTIwbWFzJTIwSmVob3YlQzMlQTElMjBjYXJnJUMzJUIzJTIwZW4lMjAlQzMlQTlsJTIwZWwlMjBwZWNhZG8lMjBkZSUyMHRvZG9zJTIwbm9zb3Ryb3MuLi4=",highlighted:`{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová, y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra, y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span>
heredad <span class="hljs-keyword">de</span> Jacob tu padre, porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos
como bejas, cada cual <span class="hljs-keyword">se</span> apartó por <span class="hljs-keyword">su</span> camino, mas Jehová cargó <span class="hljs-keyword">en</span> é<span class="hljs-keyword">l</span> el pecado <span class="hljs-keyword">de</span> todos nosotros...`,wrap:!1}}),Pl=new r({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSUyQyUwQSklNUIlMjJjaHVua3MlMjIlNUQ=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
    return_timestamps=<span class="hljs-literal">True</span>,
)[<span class="hljs-string">&quot;chunks&quot;</span>]`,wrap:!1}}),le=new r({props:{code:"JTVCJTdCJ3RpbWVzdGFtcCclM0ElMjAoMC4wJTJDJTIwMjYuNCklMkMlMEElMjAlMjAndGV4dCclM0ElMjAnJTIwRW50b25jZXMlMjB0ZSUyMGRlbGVpdGFyJUMzJUExcyUyMGVuJTIwSmVob3YlQzMlQTElMkMlMjB5JTIweW8lMjB0ZSUyMGhhciVDMyVBOSUyMHN1YmlyJTIwc29icmUlMjBsYXMlMjBhbHR1cmFzJTIwZGUlMjBsYSUyMHRpZXJyYSUyQyUyMHklMjB0ZSUyMGRhciVDMyVBOSUyMGElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwSmFjb2IlMjB0dSUyMHBhZHJlJTJDJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBKZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRvLiUyMG5vc290cm9zJTIwY3VyYWRvcy4lMjBUb2RvcyUyMG5vc290cm9zJTIwbm9zJTIwZGVzY2FycmlhbW9zJTIwY29tbyUyMGJlamFzJTJDJTIwY2FkYSUyMGN1YWwlMjBzZSUyMGFwYXJ0JUMzJUIzJTIwcG9yJTIwc3UlMjBjYW1pbm8lMkMnJTdEJTJDJTBBJTIwJTdCJ3RpbWVzdGFtcCclM0ElMjAoMjYuNCUyQyUyMDMyLjQ4KSUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCclMjBtYXMlMjBKZWhvdiVDMyVBMSUyMGNhcmclQzMlQjMlMjBlbiUyMCVDMyVBOWwlMjBlbCUyMHBlY2FkbyUyMGRlJTIwdG9kb3MlMjBub3NvdHJvcy4lMjBObyUyMGVzJTIwcXVlJTIwcGFydGFzJTIwdHUlMjBwYW4lMjBjb24lMjBlbCclN0QlMkMlMEElMjAlN0IndGltZXN0YW1wJyUzQSUyMCgzMi40OCUyQyUyMDM4LjQpJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyUyMGhhbWJyaWVudG8lMjB5JTIwYSUyMGxvcyUyMGhvbWJyZXMlMjBoZXJyYW50ZXMlMjBtZXRhcyUyMGVuJTIwY2FzYSUyQyUyMHF1ZSUyMGN1YW5kbyUyMHZpZXJlcyUyMGFsJTIwZGVzbnVkbyUyMGxvJTIwY3VicmFzJTIweSUyMG5vJyU3RCUyQyUwQSUyMC4uLg==",highlighted:`[{<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">0.0</span>, <span class="hljs-number">26.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; Entonces te deleitarás en Jehová, y yo te haré subir sobre las alturas de la tierra, y te daré a comer la heredad de Jacob tu padre, porque la boca de Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos como bejas, cada cual se apartó por su camino,&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">26.4</span>, <span class="hljs-number">32.48</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; mas Jehová cargó en él el pecado de todos nosotros. No es que partas tu pan con el&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">32.48</span>, <span class="hljs-number">38.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; hambriento y a los hombres herrantes metas en casa, que cuando vieres al desnudo lo cubras y no&#x27;},
 ...`,wrap:!1}}),se=new Te({props:{title:"Итоги",local:"итоги",headingTag:"h2"}}),pe=new $a({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/ru/chapter5/asr_models.mdx"}}),{c(){c=p("meta"),we=a(),ie=p("p"),me=a(),i(f.$$.fragment),re=a(),i(C.$$.fragment),he=a(),E=p("p"),E.innerHTML=ot,oe=a(),S=p("p"),S.textContent=jt,je=a(),x=p("ol"),x.innerHTML=ct,ce=a(),B=p("p"),B.innerHTML=dt,de=a(),Q=p("p"),Q.textContent=ut,ue=a(),i(V.$$.fragment),Ie=a(),R=p("p"),R.innerHTML=It,be=a(),i(g.$$.fragment),fe=a(),k=p("p"),k.innerHTML=bt,Ce=a(),i(v.$$.fragment),Ee=a(),G=p("p"),G.textContent=ft,Se=a(),i($.$$.fragment),xe=a(),F=p("p"),F.innerHTML=Ct,Be=a(),i(H.$$.fragment),Qe=a(),W=p("p"),W.innerHTML=Et,Ve=a(),i(Z.$$.fragment),Re=a(),N=p("p"),N.innerHTML=St,ge=a(),i(_.$$.fragment),ke=a(),Y=p("p"),Y.innerHTML=xt,ve=a(),i(A.$$.fragment),Ge=a(),L=p("p"),L.textContent=Bt,$e=a(),i(z.$$.fragment),Fe=a(),X=p("p"),X.innerHTML=Qt,He=a(),q=p("ul"),q.innerHTML=Vt,We=a(),D=p("p"),D.textContent=Rt,Ze=a(),O=p("p"),O.innerHTML=gt,Ne=a(),i(P.$$.fragment),_e=a(),K=p("p"),K.innerHTML=kt,Ye=a(),ll=p("p"),ll.textContent=vt,Ae=a(),el=p("ol"),el.innerHTML=Gt,Le=a(),sl=p("p"),sl.innerHTML=$t,ze=a(),tl=p("p"),tl.innerHTML=Ft,Xe=a(),al=p("p"),al.innerHTML=Ht,qe=a(),nl=p("p"),nl.textContent=Wt,De=a(),pl=p("p"),pl.textContent=Zt,Oe=a(),Ml=p("p"),Ml.innerHTML=Nt,Pe=a(),Jl=p("table"),Jl.innerHTML=_t,Ke=a(),il=p("p"),il.innerHTML=Yt,ls=a(),i(Ul.$$.fragment),es=a(),yl=p("p"),yl.innerHTML=At,ss=a(),i(Tl.$$.fragment),ts=a(),wl=p("p"),wl.innerHTML=Lt,as=a(),i(ml.$$.fragment),ns=a(),rl=p("p"),rl.textContent=zt,ps=a(),i(hl.$$.fragment),Ms=a(),ol=p("p"),ol.innerHTML=Xt,Js=a(),jl=p("p"),jl.innerHTML=qt,is=a(),i(cl.$$.fragment),Us=a(),dl=p("p"),dl.textContent=Dt,ys=a(),i(ul.$$.fragment),Ts=a(),Il=p("p"),Il.innerHTML=Ot,ws=a(),i(bl.$$.fragment),ms=a(),fl=p("p"),fl.innerHTML=Pt,rs=a(),i(Cl.$$.fragment),hs=a(),El=p("p"),El.innerHTML=Kt,os=a(),i(Sl.$$.fragment),js=a(),xl=p("p"),xl.innerHTML=la,cs=a(),i(Bl.$$.fragment),ds=a(),Ql=p("p"),Ql.innerHTML=ea,us=a(),i(Vl.$$.fragment),Is=a(),Rl=p("p"),Rl.textContent=sa,bs=a(),gl=p("p"),gl.innerHTML=ta,fs=a(),i(kl.$$.fragment),Cs=a(),vl=p("p"),vl.textContent=aa,Es=a(),Gl=p("p"),Gl.textContent=na,Ss=a(),$l=p("p"),$l.textContent=pa,xs=a(),i(Fl.$$.fragment),Bs=a(),Hl=p("p"),Hl.innerHTML=Ma,Qs=a(),i(Wl.$$.fragment),Vs=a(),Zl=p("p"),Zl.textContent=Ja,Rs=a(),Nl=p("ol"),Nl.innerHTML=ia,gs=a(),_l=p("p"),_l.innerHTML=Ua,ks=a(),d=p("div"),d.innerHTML=ya,vs=a(),h=p("p"),yt=I("Преимущество фрагментирования аудиообразцов на части заключается в том, что нам не нужен результат транскрибации небольшого фрагмента аудиосигнала"),Gs=new it(!1),$s=I(`
для транскрибации последующего фрагмента`),Fs=new it(!1),Hs=I(`. Соединение выполняется после того, как мы
транскрибировали все фрагменты на границах фрагментов, поэтому не имеет значения, в каком порядке мы их транскрибируем. Алгоритм полностью `),Me=p("strong"),Me.textContent=Ta,Tt=I(`,
поэтому мы можем даже обрабатывать фрагмент`),Ws=new it(!1),Zs=I(" одновременно с фрагментом"),Ns=new it(!1),_s=I("! Это позволяет нам "),Je=p("em"),Je.textContent=wa,wt=I(` (от англ. batch) фрагменты
и прогонять их через модель параллельно, обеспечивая значительное ускорение вычислений по сравнению с их последовательной транскрибацией. Более подробно
о фрагментированни в 🤗 Transformers можно прочитать в `),u=p("a"),u.textContent=ma,mt=I("."),Ys=a(),Yl=p("p"),Yl.innerHTML=ra,As=a(),Al=p("p"),Al.innerHTML=ha,Ls=a(),i(Ll.$$.fragment),zs=a(),zl=p("p"),zl.innerHTML=oa,Xs=a(),i(Xl.$$.fragment),qs=a(),ql=p("p"),ql.textContent=ja,Ds=a(),Dl=p("p"),Dl.innerHTML=ca,Os=a(),Ol=p("p"),Ol.innerHTML=da,Ps=a(),i(Pl.$$.fragment),Ks=a(),Kl=p("p"),Kl.innerHTML=ua,lt=a(),i(le.$$.fragment),et=a(),ee=p("p"),ee.textContent=Ia,st=a(),i(se.$$.fragment),tt=a(),te=p("p"),te.innerHTML=ba,at=a(),ae=p("p"),ae.innerHTML=fa,nt=a(),ne=p("p"),ne.innerHTML=Ca,pt=a(),i(pe.$$.fragment),Mt=a(),Ue=p("p"),this.h()},l(l){const e=va("svelte-u9bgzb",document.head);c=M(e,"META",{name:!0,content:!0}),e.forEach(s),we=n(l),ie=M(l,"P",{}),rt(ie).forEach(s),me=n(l),U(f.$$.fragment,l),re=n(l),U(C.$$.fragment,l),he=n(l),E=M(l,"P",{"data-svelte-h":!0}),J(E)!=="svelte-1gtvm8h"&&(E.innerHTML=ot),oe=n(l),S=M(l,"P",{"data-svelte-h":!0}),J(S)!=="svelte-6jcjni"&&(S.textContent=jt),je=n(l),x=M(l,"OL",{"data-svelte-h":!0}),J(x)!=="svelte-bjelpo"&&(x.innerHTML=ct),ce=n(l),B=M(l,"P",{"data-svelte-h":!0}),J(B)!=="svelte-1vky12r"&&(B.innerHTML=dt),de=n(l),Q=M(l,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-1vi57w3"&&(Q.textContent=ut),ue=n(l),U(V.$$.fragment,l),Ie=n(l),R=M(l,"P",{"data-svelte-h":!0}),J(R)!=="svelte-5khewd"&&(R.innerHTML=It),be=n(l),U(g.$$.fragment,l),fe=n(l),k=M(l,"P",{"data-svelte-h":!0}),J(k)!=="svelte-1mvdyro"&&(k.innerHTML=bt),Ce=n(l),U(v.$$.fragment,l),Ee=n(l),G=M(l,"P",{"data-svelte-h":!0}),J(G)!=="svelte-1ibu3ww"&&(G.textContent=ft),Se=n(l),U($.$$.fragment,l),xe=n(l),F=M(l,"P",{"data-svelte-h":!0}),J(F)!=="svelte-1mvdyro"&&(F.innerHTML=Ct),Be=n(l),U(H.$$.fragment,l),Qe=n(l),W=M(l,"P",{"data-svelte-h":!0}),J(W)!=="svelte-aibedu"&&(W.innerHTML=Et),Ve=n(l),U(Z.$$.fragment,l),Re=n(l),N=M(l,"P",{"data-svelte-h":!0}),J(N)!=="svelte-i8aadp"&&(N.innerHTML=St),ge=n(l),U(_.$$.fragment,l),ke=n(l),Y=M(l,"P",{"data-svelte-h":!0}),J(Y)!=="svelte-1mvdyro"&&(Y.innerHTML=xt),ve=n(l),U(A.$$.fragment,l),Ge=n(l),L=M(l,"P",{"data-svelte-h":!0}),J(L)!=="svelte-htuiqs"&&(L.textContent=Bt),$e=n(l),U(z.$$.fragment,l),Fe=n(l),X=M(l,"P",{"data-svelte-h":!0}),J(X)!=="svelte-10h19k1"&&(X.innerHTML=Qt),He=n(l),q=M(l,"UL",{"data-svelte-h":!0}),J(q)!=="svelte-11mc7qy"&&(q.innerHTML=Vt),We=n(l),D=M(l,"P",{"data-svelte-h":!0}),J(D)!=="svelte-qu6mk6"&&(D.textContent=Rt),Ze=n(l),O=M(l,"P",{"data-svelte-h":!0}),J(O)!=="svelte-sq2gy5"&&(O.innerHTML=gt),Ne=n(l),U(P.$$.fragment,l),_e=n(l),K=M(l,"P",{"data-svelte-h":!0}),J(K)!=="svelte-1i2fk02"&&(K.innerHTML=kt),Ye=n(l),ll=M(l,"P",{"data-svelte-h":!0}),J(ll)!=="svelte-1ifxb88"&&(ll.textContent=vt),Ae=n(l),el=M(l,"OL",{"data-svelte-h":!0}),J(el)!=="svelte-71blpy"&&(el.innerHTML=Gt),Le=n(l),sl=M(l,"P",{"data-svelte-h":!0}),J(sl)!=="svelte-1qrj0ya"&&(sl.innerHTML=$t),ze=n(l),tl=M(l,"P",{"data-svelte-h":!0}),J(tl)!=="svelte-15998yu"&&(tl.innerHTML=Ft),Xe=n(l),al=M(l,"P",{"data-svelte-h":!0}),J(al)!=="svelte-1qtehni"&&(al.innerHTML=Ht),qe=n(l),nl=M(l,"P",{"data-svelte-h":!0}),J(nl)!=="svelte-el2qut"&&(nl.textContent=Wt),De=n(l),pl=M(l,"P",{"data-svelte-h":!0}),J(pl)!=="svelte-1j2fp4v"&&(pl.textContent=Zt),Oe=n(l),Ml=M(l,"P",{"data-svelte-h":!0}),J(Ml)!=="svelte-1bqbmak"&&(Ml.innerHTML=Nt),Pe=n(l),Jl=M(l,"TABLE",{"data-svelte-h":!0}),J(Jl)!=="svelte-leifmh"&&(Jl.innerHTML=_t),Ke=n(l),il=M(l,"P",{"data-svelte-h":!0}),J(il)!=="svelte-7zg689"&&(il.innerHTML=Yt),ls=n(l),U(Ul.$$.fragment,l),es=n(l),yl=M(l,"P",{"data-svelte-h":!0}),J(yl)!=="svelte-1ilagb0"&&(yl.innerHTML=At),ss=n(l),U(Tl.$$.fragment,l),ts=n(l),wl=M(l,"P",{"data-svelte-h":!0}),J(wl)!=="svelte-1mvdyro"&&(wl.innerHTML=Lt),as=n(l),U(ml.$$.fragment,l),ns=n(l),rl=M(l,"P",{"data-svelte-h":!0}),J(rl)!=="svelte-cuywh6"&&(rl.textContent=zt),ps=n(l),U(hl.$$.fragment,l),Ms=n(l),ol=M(l,"P",{"data-svelte-h":!0}),J(ol)!=="svelte-18d7cq3"&&(ol.innerHTML=Xt),Js=n(l),jl=M(l,"P",{"data-svelte-h":!0}),J(jl)!=="svelte-1bh6i43"&&(jl.innerHTML=qt),is=n(l),U(cl.$$.fragment,l),Us=n(l),dl=M(l,"P",{"data-svelte-h":!0}),J(dl)!=="svelte-1q4wmmh"&&(dl.textContent=Dt),ys=n(l),U(ul.$$.fragment,l),Ts=n(l),Il=M(l,"P",{"data-svelte-h":!0}),J(Il)!=="svelte-1mvdyro"&&(Il.innerHTML=Ot),ws=n(l),U(bl.$$.fragment,l),ms=n(l),fl=M(l,"P",{"data-svelte-h":!0}),J(fl)!=="svelte-14g7j7g"&&(fl.innerHTML=Pt),rs=n(l),U(Cl.$$.fragment,l),hs=n(l),El=M(l,"P",{"data-svelte-h":!0}),J(El)!=="svelte-1mvdyro"&&(El.innerHTML=Kt),os=n(l),U(Sl.$$.fragment,l),js=n(l),xl=M(l,"P",{"data-svelte-h":!0}),J(xl)!=="svelte-j49oek"&&(xl.innerHTML=la),cs=n(l),U(Bl.$$.fragment,l),ds=n(l),Ql=M(l,"P",{"data-svelte-h":!0}),J(Ql)!=="svelte-1mvdyro"&&(Ql.innerHTML=ea),us=n(l),U(Vl.$$.fragment,l),Is=n(l),Rl=M(l,"P",{"data-svelte-h":!0}),J(Rl)!=="svelte-iwrqcj"&&(Rl.textContent=sa),bs=n(l),gl=M(l,"P",{"data-svelte-h":!0}),J(gl)!=="svelte-17xpsvz"&&(gl.innerHTML=ta),fs=n(l),U(kl.$$.fragment,l),Cs=n(l),vl=M(l,"P",{"data-svelte-h":!0}),J(vl)!=="svelte-z1wxhe"&&(vl.textContent=aa),Es=n(l),Gl=M(l,"P",{"data-svelte-h":!0}),J(Gl)!=="svelte-1dkwyap"&&(Gl.textContent=na),Ss=n(l),$l=M(l,"P",{"data-svelte-h":!0}),J($l)!=="svelte-1tfnh52"&&($l.textContent=pa),xs=n(l),U(Fl.$$.fragment,l),Bs=n(l),Hl=M(l,"P",{"data-svelte-h":!0}),J(Hl)!=="svelte-1mvdyro"&&(Hl.innerHTML=Ma),Qs=n(l),U(Wl.$$.fragment,l),Vs=n(l),Zl=M(l,"P",{"data-svelte-h":!0}),J(Zl)!=="svelte-wptioh"&&(Zl.textContent=Ja),Rs=n(l),Nl=M(l,"OL",{"data-svelte-h":!0}),J(Nl)!=="svelte-1too0g5"&&(Nl.innerHTML=ia),gs=n(l),_l=M(l,"P",{"data-svelte-h":!0}),J(_l)!=="svelte-zc3x59"&&(_l.innerHTML=Ua),ks=n(l),d=M(l,"DIV",{class:!0,"data-svelte-h":!0}),J(d)!=="svelte-dbmn5s"&&(d.innerHTML=ya),vs=n(l),h=M(l,"P",{});var o=rt(h);yt=b(o,"Преимущество фрагментирования аудиообразцов на части заключается в том, что нам не нужен результат транскрибации небольшого фрагмента аудиосигнала"),Gs=Ut(o,!1),$s=b(o,`
для транскрибации последующего фрагмента`),Fs=Ut(o,!1),Hs=b(o,`. Соединение выполняется после того, как мы
транскрибировали все фрагменты на границах фрагментов, поэтому не имеет значения, в каком порядке мы их транскрибируем. Алгоритм полностью `),Me=M(o,"STRONG",{"data-svelte-h":!0}),J(Me)!=="svelte-1n450gz"&&(Me.textContent=Ta),Tt=b(o,`,
поэтому мы можем даже обрабатывать фрагмент`),Ws=Ut(o,!1),Zs=b(o," одновременно с фрагментом"),Ns=Ut(o,!1),_s=b(o,"! Это позволяет нам "),Je=M(o,"EM",{"data-svelte-h":!0}),J(Je)!=="svelte-x1261k"&&(Je.textContent=wa),wt=b(o,` (от англ. batch) фрагменты
и прогонять их через модель параллельно, обеспечивая значительное ускорение вычислений по сравнению с их последовательной транскрибацией. Более подробно
о фрагментированни в 🤗 Transformers можно прочитать в `),u=M(o,"A",{href:!0,rel:!0,"data-svelte-h":!0}),J(u)!=="svelte-vrtp4c"&&(u.textContent=ma),mt=b(o,"."),o.forEach(s),Ys=n(l),Yl=M(l,"P",{"data-svelte-h":!0}),J(Yl)!=="svelte-rnzic7"&&(Yl.innerHTML=ra),As=n(l),Al=M(l,"P",{"data-svelte-h":!0}),J(Al)!=="svelte-575eay"&&(Al.innerHTML=ha),Ls=n(l),U(Ll.$$.fragment,l),zs=n(l),zl=M(l,"P",{"data-svelte-h":!0}),J(zl)!=="svelte-1mvdyro"&&(zl.innerHTML=oa),Xs=n(l),U(Xl.$$.fragment,l),qs=n(l),ql=M(l,"P",{"data-svelte-h":!0}),J(ql)!=="svelte-n1n71v"&&(ql.textContent=ja),Ds=n(l),Dl=M(l,"P",{"data-svelte-h":!0}),J(Dl)!=="svelte-1w5bf9x"&&(Dl.innerHTML=ca),Os=n(l),Ol=M(l,"P",{"data-svelte-h":!0}),J(Ol)!=="svelte-1gr2r2y"&&(Ol.innerHTML=da),Ps=n(l),U(Pl.$$.fragment,l),Ks=n(l),Kl=M(l,"P",{"data-svelte-h":!0}),J(Kl)!=="svelte-1mvdyro"&&(Kl.innerHTML=ua),lt=n(l),U(le.$$.fragment,l),et=n(l),ee=M(l,"P",{"data-svelte-h":!0}),J(ee)!=="svelte-1glad5k"&&(ee.textContent=Ia),st=n(l),U(se.$$.fragment,l),tt=n(l),te=M(l,"P",{"data-svelte-h":!0}),J(te)!=="svelte-z1aoca"&&(te.innerHTML=ba),at=n(l),ae=M(l,"P",{"data-svelte-h":!0}),J(ae)!=="svelte-kz3n2j"&&(ae.innerHTML=fa),nt=n(l),ne=M(l,"P",{"data-svelte-h":!0}),J(ne)!=="svelte-1ciho6b"&&(ne.innerHTML=Ca),pt=n(l),U(pe.$$.fragment,l),Mt=n(l),Ue=M(l,"P",{}),rt(Ue).forEach(s),this.h()},h(){ye(c,"name","hf:doc:metadata"),ye(c,"content",Ha),ye(d,"class","flex justify-center"),Gs.a=$s,Fs.a=Hs,Ws.a=Zs,Ns.a=_s,ye(u,"href","https://huggingface.co/blog/asr-chunking"),ye(u,"rel","nofollow")},m(l,e){j(document.head,c),t(l,we,e),t(l,ie,e),t(l,me,e),y(f,l,e),t(l,re,e),y(C,l,e),t(l,he,e),t(l,E,e),t(l,oe,e),t(l,S,e),t(l,je,e),t(l,x,e),t(l,ce,e),t(l,B,e),t(l,de,e),t(l,Q,e),t(l,ue,e),y(V,l,e),t(l,Ie,e),t(l,R,e),t(l,be,e),y(g,l,e),t(l,fe,e),t(l,k,e),t(l,Ce,e),y(v,l,e),t(l,Ee,e),t(l,G,e),t(l,Se,e),y($,l,e),t(l,xe,e),t(l,F,e),t(l,Be,e),y(H,l,e),t(l,Qe,e),t(l,W,e),t(l,Ve,e),y(Z,l,e),t(l,Re,e),t(l,N,e),t(l,ge,e),y(_,l,e),t(l,ke,e),t(l,Y,e),t(l,ve,e),y(A,l,e),t(l,Ge,e),t(l,L,e),t(l,$e,e),y(z,l,e),t(l,Fe,e),t(l,X,e),t(l,He,e),t(l,q,e),t(l,We,e),t(l,D,e),t(l,Ze,e),t(l,O,e),t(l,Ne,e),y(P,l,e),t(l,_e,e),t(l,K,e),t(l,Ye,e),t(l,ll,e),t(l,Ae,e),t(l,el,e),t(l,Le,e),t(l,sl,e),t(l,ze,e),t(l,tl,e),t(l,Xe,e),t(l,al,e),t(l,qe,e),t(l,nl,e),t(l,De,e),t(l,pl,e),t(l,Oe,e),t(l,Ml,e),t(l,Pe,e),t(l,Jl,e),t(l,Ke,e),t(l,il,e),t(l,ls,e),y(Ul,l,e),t(l,es,e),t(l,yl,e),t(l,ss,e),y(Tl,l,e),t(l,ts,e),t(l,wl,e),t(l,as,e),y(ml,l,e),t(l,ns,e),t(l,rl,e),t(l,ps,e),y(hl,l,e),t(l,Ms,e),t(l,ol,e),t(l,Js,e),t(l,jl,e),t(l,is,e),y(cl,l,e),t(l,Us,e),t(l,dl,e),t(l,ys,e),y(ul,l,e),t(l,Ts,e),t(l,Il,e),t(l,ws,e),y(bl,l,e),t(l,ms,e),t(l,fl,e),t(l,rs,e),y(Cl,l,e),t(l,hs,e),t(l,El,e),t(l,os,e),y(Sl,l,e),t(l,js,e),t(l,xl,e),t(l,cs,e),y(Bl,l,e),t(l,ds,e),t(l,Ql,e),t(l,us,e),y(Vl,l,e),t(l,Is,e),t(l,Rl,e),t(l,bs,e),t(l,gl,e),t(l,fs,e),y(kl,l,e),t(l,Cs,e),t(l,vl,e),t(l,Es,e),t(l,Gl,e),t(l,Ss,e),t(l,$l,e),t(l,xs,e),y(Fl,l,e),t(l,Bs,e),t(l,Hl,e),t(l,Qs,e),y(Wl,l,e),t(l,Vs,e),t(l,Zl,e),t(l,Rs,e),t(l,Nl,e),t(l,gs,e),t(l,_l,e),t(l,ks,e),t(l,d,e),t(l,vs,e),t(l,h,e),j(h,yt),Gs.m(Ea,h),j(h,$s),Fs.m(Sa,h),j(h,Hs),j(h,Me),j(h,Tt),Ws.m(xa,h),j(h,Zs),Ns.m(Ba,h),j(h,_s),j(h,Je),j(h,wt),j(h,u),j(h,mt),t(l,Ys,e),t(l,Yl,e),t(l,As,e),t(l,Al,e),t(l,Ls,e),y(Ll,l,e),t(l,zs,e),t(l,zl,e),t(l,Xs,e),y(Xl,l,e),t(l,qs,e),t(l,ql,e),t(l,Ds,e),t(l,Dl,e),t(l,Os,e),t(l,Ol,e),t(l,Ps,e),y(Pl,l,e),t(l,Ks,e),t(l,Kl,e),t(l,lt,e),y(le,l,e),t(l,et,e),t(l,ee,e),t(l,st,e),y(se,l,e),t(l,tt,e),t(l,te,e),t(l,at,e),t(l,ae,e),t(l,nt,e),t(l,ne,e),t(l,pt,e),y(pe,l,e),t(l,Mt,e),t(l,Ue,e),Jt=!0},p:Va,i(l){Jt||(T(f.$$.fragment,l),T(C.$$.fragment,l),T(V.$$.fragment,l),T(g.$$.fragment,l),T(v.$$.fragment,l),T($.$$.fragment,l),T(H.$$.fragment,l),T(Z.$$.fragment,l),T(_.$$.fragment,l),T(A.$$.fragment,l),T(z.$$.fragment,l),T(P.$$.fragment,l),T(Ul.$$.fragment,l),T(Tl.$$.fragment,l),T(ml.$$.fragment,l),T(hl.$$.fragment,l),T(cl.$$.fragment,l),T(ul.$$.fragment,l),T(bl.$$.fragment,l),T(Cl.$$.fragment,l),T(Sl.$$.fragment,l),T(Bl.$$.fragment,l),T(Vl.$$.fragment,l),T(kl.$$.fragment,l),T(Fl.$$.fragment,l),T(Wl.$$.fragment,l),T(Ll.$$.fragment,l),T(Xl.$$.fragment,l),T(Pl.$$.fragment,l),T(le.$$.fragment,l),T(se.$$.fragment,l),T(pe.$$.fragment,l),Jt=!0)},o(l){w(f.$$.fragment,l),w(C.$$.fragment,l),w(V.$$.fragment,l),w(g.$$.fragment,l),w(v.$$.fragment,l),w($.$$.fragment,l),w(H.$$.fragment,l),w(Z.$$.fragment,l),w(_.$$.fragment,l),w(A.$$.fragment,l),w(z.$$.fragment,l),w(P.$$.fragment,l),w(Ul.$$.fragment,l),w(Tl.$$.fragment,l),w(ml.$$.fragment,l),w(hl.$$.fragment,l),w(cl.$$.fragment,l),w(ul.$$.fragment,l),w(bl.$$.fragment,l),w(Cl.$$.fragment,l),w(Sl.$$.fragment,l),w(Bl.$$.fragment,l),w(Vl.$$.fragment,l),w(kl.$$.fragment,l),w(Fl.$$.fragment,l),w(Wl.$$.fragment,l),w(Ll.$$.fragment,l),w(Xl.$$.fragment,l),w(Pl.$$.fragment,l),w(le.$$.fragment,l),w(se.$$.fragment,l),w(pe.$$.fragment,l),Jt=!1},d(l){l&&(s(we),s(ie),s(me),s(re),s(he),s(E),s(oe),s(S),s(je),s(x),s(ce),s(B),s(de),s(Q),s(ue),s(Ie),s(R),s(be),s(fe),s(k),s(Ce),s(Ee),s(G),s(Se),s(xe),s(F),s(Be),s(Qe),s(W),s(Ve),s(Re),s(N),s(ge),s(ke),s(Y),s(ve),s(Ge),s(L),s($e),s(Fe),s(X),s(He),s(q),s(We),s(D),s(Ze),s(O),s(Ne),s(_e),s(K),s(Ye),s(ll),s(Ae),s(el),s(Le),s(sl),s(ze),s(tl),s(Xe),s(al),s(qe),s(nl),s(De),s(pl),s(Oe),s(Ml),s(Pe),s(Jl),s(Ke),s(il),s(ls),s(es),s(yl),s(ss),s(ts),s(wl),s(as),s(ns),s(rl),s(ps),s(Ms),s(ol),s(Js),s(jl),s(is),s(Us),s(dl),s(ys),s(Ts),s(Il),s(ws),s(ms),s(fl),s(rs),s(hs),s(El),s(os),s(js),s(xl),s(cs),s(ds),s(Ql),s(us),s(Is),s(Rl),s(bs),s(gl),s(fs),s(Cs),s(vl),s(Es),s(Gl),s(Ss),s($l),s(xs),s(Bs),s(Hl),s(Qs),s(Vs),s(Zl),s(Rs),s(Nl),s(gs),s(_l),s(ks),s(d),s(vs),s(h),s(Ys),s(Yl),s(As),s(Al),s(Ls),s(zs),s(zl),s(Xs),s(qs),s(ql),s(Ds),s(Dl),s(Os),s(Ol),s(Ps),s(Ks),s(Kl),s(lt),s(et),s(ee),s(st),s(tt),s(te),s(at),s(ae),s(nt),s(ne),s(pt),s(Mt),s(Ue)),s(c),m(f,l),m(C,l),m(V,l),m(g,l),m(v,l),m($,l),m(H,l),m(Z,l),m(_,l),m(A,l),m(z,l),m(P,l),m(Ul,l),m(Tl,l),m(ml,l),m(hl,l),m(cl,l),m(ul,l),m(bl,l),m(Cl,l),m(Sl,l),m(Bl,l),m(Vl,l),m(kl,l),m(Fl,l),m(Wl,l),m(Ll,l),m(Xl,l),m(Pl,l),m(le,l),m(se,l),m(pe,l)}}}const Ha='{"title":"Предварительно обученные модели для распознавания речи","local":"предварительно-обученные-модели-для-распознавания-речи","sections":[{"title":"Анализ моделей CTC","local":"анализ-моделей-ctc","sections":[],"depth":2},{"title":"Переход к Seq2Seq","local":"переход-к-seq2seq","sections":[],"depth":2},{"title":"Длинноформатная транскрипция и временные метки","local":"длинноформатная-транскрипция-и-временные-метки","sections":[],"depth":2},{"title":"Итоги","local":"итоги","sections":[],"depth":2}],"depth":1}';function Wa(ht){return Ra(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Aa extends ga{constructor(c){super(),ka(this,c,Wa,Fa,Qa,{})}}export{Aa as component};
