# অডিও ডাটাসেটকে লোড এবং বিশ্লেষণ করা

এই কোর্সে আমরা অডিও ডেটাসেটের সাথে কাজ করার জন্য 🤗 ডেটাসেট লাইব্রেরি ব্যবহার করব। 🤗 ডেটাসেট হল একটি ওপেন সোর্স লাইব্রেরি যাতে অডিও সহ সমস্ত
পদ্ধতি থেকে ডেটাসেট ডাউনলোড এবং প্রস্তুত করা যায়। Hugging Face Hub-এ সর্বজনীনভাবে উপলব্ধ মেশিন লার্নিং ডেটাসেটের নির্বাচন করার জন্যে 🤗 ডেটাসেট একটি অতুলনীয় সহজ উপায়।
তাছাড়া, 🤗 ডেটাসেট গবেষক এবং অনুশীলনকারী উভয়ের জন্য এই ধরনের ডেটাসেটের সাথে কাজ করা সহজ করে।

অডিও ডেটাসেটগুলির সাথে কাজ শুরু করতে, নিশ্চিত করুন যে আপনার কাছে 🤗 ডেটাসেট লাইব্রেরি ইনস্টল করা আছে:

```bash
pip install datasets[audio]
```

🤗 ডেটাসেটের মূল বৈশিষ্ট্যগুলির মধ্যে একটি হল `load_dataset()` ফাংশন ব্যবহার করে শুধুমাত্র একটি লাইনে একটি ডেটাসেট ডাউনলোড এবং প্রস্তুত করার ক্ষমতা।

আসুন [MINDS-14](https://huggingface.co/datasets/PolyAI/minds14) নামক অডিও ডেটাসেট লোড এবং অন্বেষণ করি, যার মধ্যে রয়েছে বিভিন্ন ভাষা
এবং উপভাষায় একটি ই-ব্যাংকিং সিস্টেমের প্রশ্ন জিজ্ঞাসা করা লোকেদের রেকর্ডিং।

MINDS-14 ডেটাসেট লোড করার জন্য, আমাদের হাবে (`PolyAI/minds14`) ডেটাসেটের শনাক্তকারী কপি করে পাস করতে হবে `লোড_ডেটাসেট` ফাংশনে। আমরা
এটাও উল্লেখ করব যে আমরা শুধুমাত্র অস্ট্রেলিয়ান সাবসেটে (`en-AU`) আগ্রহী, এবং train বিভাজনে সীমাবদ্ধ করুন:


```py
from datasets import load_dataset

minds = load_dataset("PolyAI/minds14", name="en-AU", split="train")
minds
```

**আউটপুট:**
```out
Dataset(
    {
        features: [
            "path",
            "audio",
            "transcription",
            "english_transcription",
            "intent_class",
            "lang_id",
        ],
        num_rows: 654,
    }
)
```

ডেটাসেটে ৬৫৪ টি অডিও ফাইল রয়েছে, যার প্রতিটির সাথে একটি ট্রান্সক্রিপশন, একটি ইংরেজি অনুবাদ এবং একটি লেবেল রয়েছে
ব্যক্তির প্রশ্নের পিছনে অভিপ্রায় ইঙ্গিত. অডিও কলামে কাঁচা অডিও ডেটা থাকে। এর একটি ঘনিষ্ঠভাবে কটাক্ষপাত করা যাক
উদাহরণগুলির একটিতে:

```py
example = minds[0]
example
```

**আউটপুট:**
```out
{
    "path": "/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav",
    "audio": {
        "path": "/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav",
        "array": array(
            [0.0, 0.00024414, -0.00024414, ..., -0.00024414, 0.00024414, 0.0012207],
            dtype=float32,
        ),
        "sampling_rate": 8000,
    },
    "transcription": "I would like to pay my electricity bill using my card can you please assist",
    "english_transcription": "I would like to pay my electricity bill using my card can you please assist",
    "intent_class": 13,
    "lang_id": 2,
}
```

আপনি লক্ষ্য করতে পারেন যে অডিও কলামে বেশ কয়েকটি বৈশিষ্ট্য রয়েছে। এখানে তারা কি:
* `path`: অডিও ফাইলের পথ (এই ক্ষেত্রে `*.wav`)।
* `array`: ডিকোড করা অডিও ডেটা, একটি 1-মাত্রিক NumPy অ্যারে হিসাবে উপস্থাপিত।
* `sampling_rate`। অডিও ফাইলের sampling_rate (এই উদাহরণে ৮,০০০ Hz)।

'intent_class' হল অডিও রেকর্ডিংয়ের একটি শ্রেণীবিভাগ। এই সংখ্যাটিকে একটি অর্থপূর্ণ স্ট্রিংয়ে রূপান্তর করতে,
আমরা `int2str()` পদ্ধতি ব্যবহার করতে পারি:

```py
id2label = minds.features["intent_class"].int2str
id2label(example["intent_class"])
```

**আউটপুট:**
```out
"pay_bill"
```

আপনি যদি ট্রান্সক্রিপশন বৈশিষ্ট্যটি দেখেন তবে আপনি দেখতে পাবেন যে অডিও ফাইলটি প্রকৃতপক্ষে একজন ব্যক্তিকে একটি প্রশ্ন জিজ্ঞাসা করে রেকর্ড করেছে
বিল পরিশোধ সম্পর্কে।

আপনি যদি ডেটার এই উপসেটে একটি audio classifier কে train করার পরিকল্পনা করেন, তাহলে আপনার সমস্ত বৈশিষ্ট্যের প্রয়োজন নাও হতে পারে। উদাহরণ স্বরূপ,
সব উদাহরণের জন্য `lang_id`-এর মান একই হবে এবং কাজে লাগবে না। `english_transcription` সম্ভবত হবে
এই উপসেটে `transcription` নকল করুন, যাতে আমরা নিরাপদে সেগুলি সরাতে পারি।

আপনি 🤗 ডেটাসেটগুলির `remove_columns` পদ্ধতি ব্যবহার করে সহজেই অপ্রাসঙ্গিক বৈশিষ্ট্যগুলি সরাতে পারেন:

```py
columns_to_remove = ["lang_id", "english_transcription"]
minds = minds.remove_columns(columns_to_remove)
minds
```

**আউটপুট:**
```out
Dataset({features: ["path", "audio", "transcription", "intent_class"], num_rows: 654})
```

এখন যেহেতু আমরা ডেটাসেটের কাঁচা বিষয়বস্তু লোড এবং পরিদর্শন করেছি, আসুন কয়েকটি উদাহরণ শুনি! আমরা 'Gradio' থেকে 'Blocks' এবং 'Audio' ব্যবহার করব
ডেটাসেট থেকে কয়েকটি নমুনা ডিকোড করতে।

```py
import gradio as gr


def generate_audio():
    example = minds.shuffle()[0]
    audio = example["audio"]
    return (
        audio["sampling_rate"],
        audio["array"],
    ), id2label(example["intent_class"])


with gr.Blocks() as demo:
    with gr.Column():
        for _ in range(4):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=True)
```

আপনি যদি চান, আপনি কিছু উদাহরণও পর্যবেক্ষণ করতে পারেন। প্রথম উদাহরণের তরঙ্গরূপ প্লট করা যাক।

```py
import librosa
import matplotlib.pyplot as plt
import librosa.display

array = example["audio"]["array"]
sampling_rate = example["audio"]["sampling_rate"]

plt.figure().set_figwidth(12)
librosa.display.waveshow(array, sr=sampling_rate)
```

<div class="flex justify-center">
    <img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Waveform plot">
</div>

এখন নিজে চেষ্টা করুন! MINDS-14 ডেটাসেটের অন্য একটি উপভাষা বা ভাষা ডাউনলোড করুন, উপলব্ধি করতে কিছু উদাহরণ শুনুন এবং পর্যবেক্ষণ করুন। আপনি
[এখানে](https://huggingface.co/datasets/PolyAI/minds14) উপলব্ধ ভাষার সম্পূর্ণ তালিকা পেতে পারেন।


<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/bn/chapter1/load_and_explore.mdx" />