import{s as tt,n as Mt,o as st}from"../chunks/scheduler.25b97de1.js";import{S as nt,i as at,g as a,s,r as o,A as it,h as i,f as t,c as n,j as lt,u as U,x as y,k as et,y as yt,a as M,v as j,d as C,t as p,w}from"../chunks/index.d9030fc9.js";import{C as T}from"../chunks/CodeBlock.e6cd0d95.js";import{H as m,E as ot}from"../chunks/EditOnGithub.91d95064.js";function Ut(fe){let r,Jl,Tl,cl,d,fl,J,Ae='<code>transformers</code> is an opinionated framework; our philosophy is defined in the following <a href="./philosophy">conceptual guide</a>.',Al,c,he=`The core of that philosophy is exemplified by the <a href="https://huggingface.co/blog/transformers-design-philosophy" rel="nofollow">single model, single file</a>
aspect of the library. This component’s downside is that it limits the inheritance and importability of components from
files to others in the toolkit.`,hl,f,Ie=`As a result, model components tend to be repeated across many files. There are as many attention layers defined
in <code>transformers</code> as there are models, and a significant number of those are identical to each other.
The unfortunate consequence is that independent implementations tend to diverge as fixes and changes get applied
to specific parts of the code.`,Il,A,ue=`In order to balance this issue, we introduced the concept of “copies” across the library. By adding a comment indicating
that code is a copy of another, we can enforce through CI and local commands that copies do not diverge. However,
while the complexity is low, this is often quite tedious to do.`,ul,h,be=`And, finally, this contributes to adding a significant overhead to contributing models which we would like to remove.
This approach often requires model contributions to add modeling code (~1k lines), processor (~500 lines), tests, docs,
etc. Model contribution PRs rarely add less than 3-5k lines of code, with much of this code being boilerplate.`,bl,I,_e=`This raises the bar for contributions, and with Modular Transformers, we’re aiming to lower the bar to a much more
acceptable point.`,_l,u,Ze=`If you plan to add a model to <code>transformers</code> make sure you read <a href="https://huggingface.co/docs/transformers/add_new_model" rel="nofollow">How to add a model to 🤗 Transformers?</a>.
For any kind of contributions, see <a href="https://github.com/huggingface/transformers/blob/main/CONTRIBUTING.md" rel="nofollow">CONTRIBUTING.md</a>.`,Zl,b,gl,_,ge=`Modular Transformers introduces the concept of a “modular” file to a model folder. This modular file accepts code
that isn’t typically accepted in modeling/processing files, as it allows importing from neighbouring models as well
as inheritance from classes to others.`,kl,Z,ke=`This modular file defines models, processors, and the configuration class that would otherwise be defined in their
respective modules.`,vl,g,ve=`Finally, this feature introduces a new <code>linter</code> which will “unravel” the modular file into the “single model, single
file” directory structure. These files will get auto-generated every time the script is run; reducing the required
contributions to the modular file, and therefore only to the changes between the contributed model and others.`,$l,k,$e=`Model users will end up importing and using the single-file interface, so no change is expected here. Doing this, we
hope to combine the best of both worlds: enabling simple contributions while sticking to our philosophy.`,Wl,v,We=`This is therefore a replacement for the <code># Copied from</code> markers, and previously contributed models can be expected to
be moved to the new Modular Transformers format in the coming months.`,Bl,$,Gl,W,Be="To generate a single file from the modular file, run the following command.",Rl,B,xl,G,Ge=`The “linter”, which unravels the inheritance and creates all single-files from the modular file, will flatten the
inheritance while trying to be invisible to Python users. At this time, the linter flattens a <strong>single</strong> level of
inheritance.`,Vl,R,Re="For example:",Xl,x,xe=`<li>If a configuration class inherits from another and adds/deletes an argument, the generated file will either directly
reference it (in case of addition) or completely remove it (in case of deletion).</li> <li>If a class inherits from another, for example: class GemmaModel(LlamaModel):, dependencies are automatically
inferred. All submodules will be automatically inferred from the superclass.</li> <li>If you define new functions in the <code>modular</code> and use them inside classes, the linter will automatically infer the</li>`,El,V,Ve=`You should be able to write everything (the tokenizer, the image processor, the model, the config) in this <code>modular</code>
file, and the corresponding files will be created for you.`,Nl,X,Yl,E,Xe="Run the command below to ensure the generated content matches <code>modular_&lt;your_model&gt;.py</code>",Hl,N,zl,Y,Ql,H,Ee=`Here is a quick example with BERT and RoBERTa. The two models are intimately related: their modeling implementation
differs solely by a change in the embedding layer.`,Sl,z,Ne=`Instead of redefining the model entirely, here is what the <code>modular_roberta.py</code> file looks like for the modeling &amp;
configuration classes (for the sake of the example, the tokenizer is ignored at this time as very different).`,Ll,Q,Fl,S,Ye="Note that if you do not use the dependency that you defined, you will have the following error:",Pl,L,Kl,F,He="Additionally, you may find a list of examples here:",Dl,P,ql,K,ze="It is not a replacement for the modeling code (yet?), and if your model is not based on anything else that ever existed, then you can add a <code>modeling</code> file as usual.",Ol,D,le,q,ee,O,Qe="To remove attributes that are not used in your modular model, and that you don’t want to see in the unravelled modeling:",te,ll,Me,el,Se="If you check the original <code>LlamaModel</code>, it has a <code>embed_tokens</code> which was removed here (as you would expect!)",se,tl,Le="Removing a function is pretty similar, you just need to write it with a <code>raise ValueError(&quot;&quot;)</code> to mimick the behaviour you actually want when you remove a parent function in python.",ne,Ml,ae,sl,ie,nl,Fe="If you define a new function in the <code>modular</code> file to be used inside a class, say",ye,al,oe,il,Pe=`the <code>my_new_function</code> function (and, recursively, any other new functions called in its body) will be automatically copy-pasted
in the file where it is used.`,Ue,yl,je,ol,Ke="We recently shipped a few features that allow you to go from:",Ce,Ul,pe,jl,De="This is useful want you <strong>don’t</strong> want to unravel the call to <code>super()</code>, and you want to differentiate which super init call you are doing!",we,Cl,me,pl,qe="We now also support special cases like",re,wl,Te,ml,Oe="where the name of your class <code>GemmaVision</code> is not the same as the modular <code>Gemma</code>. This is super useful for composite models.",de,rl,Je,dl,ce;return d=new m({props:{title:"Modular transformers",local:"modular-transformers",headingTag:"h1"}}),b=new m({props:{title:"What is it?",local:"what-is-it",headingTag:"h2"}}),$=new m({props:{title:"Details",local:"details",headingTag:"h3"}}),B=new T({props:{code:"cHl0aG9uJTIwdXRpbHMlMkZtb2R1bGFyX21vZGVsX2NvbnZlcnRlci5weSUyMC0tZmlsZXMtdG8tcGFyc2UlMjBzcmMlMkZ0cmFuc2Zvcm1lcnMlMkZtb2RlbHMlMkYlM0N5b3VyX21vZGVsJTNFJTJGbW9kdWxhcl8lM0N5b3VyX21vZGVsJTNFLnB5",highlighted:"python utils/modular_model_converter.py --files-to-parse src/transformers/models/&lt;your_model&gt;/modular_&lt;your_model&gt;.py",wrap:!1}}),X=new m({props:{title:"Enforcement",local:"enforcement",headingTag:"h3"}}),N=new T({props:{code:"cHl0aG9uJTIwdXRpbHMlMkZjaGVja19tb2R1bGFyX2NvbnZlcnNpb24ucHklMjAtLWZpbGVzJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGJTNDeW91cl9tb2RlbCUzRSUyRm1vZHVsYXJfJTNDeW91cl9tb2RlbCUzRS5weQ==",highlighted:"python utils/check_modular_conversion.py --files src/transformers/models/&lt;your_model&gt;/modular_&lt;your_model&gt;.py",wrap:!1}}),Y=new m({props:{title:"Examples",local:"examples",headingTag:"h3"}}),Q=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> ..bert.configuration_bert <span class="hljs-keyword">import</span> BertConfig
<span class="hljs-keyword">from</span> ..bert.modeling_bert <span class="hljs-keyword">import</span> (
    BertModel,
    BertEmbeddings,
    BertForMaskedLM
)

<span class="hljs-comment"># The RoBERTa config is identical to BERT&#x27;s config</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaConfig</span>(<span class="hljs-title class_ inherited__">BertConfig</span>):
  model_type = <span class="hljs-string">&#x27;roberta&#x27;</span>

<span class="hljs-comment"># We redefine the embeddings here to highlight the padding ID difference, and we redefine the position embeddings</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaEmbeddings</span>(<span class="hljs-title class_ inherited__">BertEmbeddings</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config())

        self.padding_idx = config.pad_token_id
        self.position_embeddings = nn.Embedding(
            config.max_position_embeddings, config.hidden_size, padding_idx=self.padding_idx
        )

<span class="hljs-comment"># The RoBERTa model is identical to the BERT model, except for the embedding layer. </span>
<span class="hljs-comment"># We redefine the embeddings above, so here there is no need to do additional work</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaModel</span>(<span class="hljs-title class_ inherited__">BertModel</span>):
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    self.embeddings = RobertaEmbeddings(config)

      
<span class="hljs-comment"># The heads now only need to redefine the model inside to the correct \`RobertaModel\`</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaForMaskedLM</span>(<span class="hljs-title class_ inherited__">BertForMaskedLM</span>):
  <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
    <span class="hljs-built_in">super</span>().__init__(config)
    self.model = RobertaModel(config)`,wrap:!1}}),L=new T({props:{code:"VmFsdWVFcnJvciUzQSUyMFlvdSUyMGRlZmluZWQlMjAlNjBSb2JlcnRhRW1iZWRkaW5ncyU2MCUyMGluJTIwdGhlJTIwbW9kdWxhcl9yb2JlcnRhLnB5JTJDJTIwaXQlMjBzaG91bGQlMjBiZSUyMHVzZWQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGVuJTIweW91JTIwZGVmaW5lJTIwJTYwQmVydE1vZGVsJTYwJTJDJTIwYXMlMjBpdCUyMGlzJTIwb25lJTIwb2YlMjBpdCdzJTIwZGlyZWN0JTIwZGVwZW5kZW5jaWVzLiUyME1ha2UlMjBzdXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweW91JTIwdXNlJTIwaXQlMjBpbiUyMHRoZSUyMCU2MF9faW5pdF9fJTYwJTIwZnVuY3Rpb24u",highlighted:'ValueError: You defined `RobertaEmbeddings` <span class="hljs-keyword">in</span> the modular_roberta.py, it should be used\n                                    when you define `BertModel`, as it is one of it<span class="hljs-string">&#x27;s direct dependencies. Make sure\n                                    you use it in the `__init__` function.</span>',wrap:!1}}),P=new m({props:{title:"What it is not",local:"what-it-is-not",headingTag:"h2"}}),D=new m({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),q=new m({props:{title:"Removing attributes and functions",local:"removing-attributes-and-functions",headingTag:"h3"}}),ll=new T({props:{code:"Y2xhc3MlMjBHZW1tYU1vZGVsKExsYW1hTW9kZWwpJTNBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2xhc3MlMjBHZW1tYU1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBjb25maWcpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXyhzZWxmJTJDJTIwZW9zX3Rva2VuKSUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlbCUyMHNlbGYuZW1iZWRfdG9rZW5zJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5wYWRkaW5nX2lkeCUyMCUzRCUyMGNvbmZpZy5wYWRfdG9rZW5faWQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnZvY2FiX3NpemUlMjAlM0QlMjBjb25maWcudm9jYWJfc2l6ZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGF5ZXJzJTIwJTNEJTIwbm4uTW9kdWxlTGlzdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUJMbGFtYURlY29kZXJMYXllcihjb25maWclMkMlMjBsYXllcl9pZHgpJTIwZm9yJTIwbGF5ZXJfaWR4JTIwaW4lMjByYW5nZShjb25maWcubnVtX2hpZGRlbl9sYXllcnMpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubm9ybSUyMCUzRCUyMExsYW1hUk1TTm9ybShjb25maWcuaGlkZGVuX3NpemUlMkMlMjBlcHMlM0Rjb25maWcucm1zX25vcm1fZXBzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYucm90YXJ5X2VtYiUyMCUzRCUyMExsYW1hUm90YXJ5RW1iZWRkaW5nKGNvbmZpZyUzRGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlM0QlMjBGYWxzZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEluaXRpYWxpemUlMjB3ZWlnaHRzJTIwYW5kJTIwYXBwbHklMjBmaW5hbCUyMHByb2Nlc3NpbmclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnBvc3RfaW5pdCgp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">GemmaModel</span>(<span class="hljs-title class_ inherited__">LlamaModel</span>):                 |           <span class="hljs-keyword">class</span> <span class="hljs-title class_">GemmaModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):               |              <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(self, eos_token)     |                 <span class="hljs-built_in">super</span>().__init__(config)
        <span class="hljs-keyword">del</span> self.embed_tokens                 |                 self.padding_idx = config.pad_token_id
                                              |                 self.vocab_size = config.vocab_size
                                              |
                                              |                 self.layers = nn.ModuleList(
                                              |                     [LlamaDecoderLayer(config, layer_idx) <span class="hljs-keyword">for</span> layer_idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(config.num_hidden_layers)]
                                              |                 )
                                              |                 self.norm = LlamaRMSNorm(config.hidden_size, eps=config.rms_norm_eps)
                                              |                 self.rotary_emb = LlamaRotaryEmbedding(config=config)
                                              |                 self.gradient_checkpointing = <span class="hljs-literal">False</span>
                                              |                 
                                              |                 <span class="hljs-comment"># Initialize weights and apply final processing</span>
                                              |                 self.post_init()`,wrap:!1}}),Ml=new T({props:{code:"Y2xhc3MlMjBHZW1tYVRva2VuaXplcihMbGFtYVRva2VuaXplciklM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMEElMjAlMjAlMjAlMjBkZWYlMjBnZXRfc3BtX3Byb2Nlc3NvcihzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwQXR0cmlidXRlRXJyb3IoJTIyTm90JTIwbmVlZGVkJTIwZm9yJTIwR2VtbWElMjIpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwdW5rX3Rva2VuX2xlbmd0aChzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwQXR0cmlidXRlRXJyb3IoJTIyTm90JTIwbmVlZGVkJTIwZm9yJTIwR2VtbWElMjIp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">GemmaTokenizer</span>(<span class="hljs-title class_ inherited__">LlamaTokenizer</span>):
    ...

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_spm_processor</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">raise</span> AttributeError(<span class="hljs-string">&quot;Not needed for Gemma&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">unk_token_length</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">raise</span> AttributeError(<span class="hljs-string">&quot;Not needed for Gemma&quot;</span>)`,wrap:!1}}),sl=new m({props:{title:"Define new functions",local:"define-new-functions",headingTag:"h3"}}),al=new T({props:{code:"ZGVmJTIwbXlfbmV3X2Z1bmN0aW9uKCphcmdzJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIzJTIwRG8lMjBzb21ldGhpbmclMjBoZXJlJTBBJTIwJTIwcGFzcyUwQSUwQWNsYXNzJTIwR2VtbWFNb2RlbChMbGFtYU1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoKmFyZ3MlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBDYWxsJTIwdGhlJTIwZnVuY3Rpb24lMEElMjAlMjAlMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbXlfbmV3X2Z1bmN0aW9uKCphcmdzJTJDJTIwKiprd2FyZ3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwY29udGludWUlMjBoZXJl",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_new_function</span>(<span class="hljs-params">*args, **kwargs</span>):
  <span class="hljs-comment"># Do something here</span>
  <span class="hljs-keyword">pass</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">GemmaModel</span>(<span class="hljs-title class_ inherited__">LlamaModel</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">*args, **kwargs</span>):
      <span class="hljs-comment"># Call the function</span>
      example = my_new_function(*args, **kwargs)
      <span class="hljs-comment"># continue here</span>`,wrap:!1}}),yl=new m({props:{title:"Calling super()",local:"calling-super",headingTag:"h3"}}),Ul=new T({props:{code:"Y2xhc3MlMjBHZW1tYVRva2VuaXplcihMbGFtYVRva2VuaXplciUyQyUyMFByZXRyYWluZWRUb2tlbml6ZXJGYXN0KSUzQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNsYXNzJTIwR2VtbWFNb2RlbChubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGVvc190b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIpJTNBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlb3NfdG9rZW4lMjAlM0QlMjBBZGRlZFRva2VuKGVvc190b2tlbiklMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlb3NfdG9rZW4lMjAlM0QlMjBBZGRlZFRva2VuKGVvc190b2tlbiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBQcmV0cmFpbmVkVG9rZW5pemVyRmFzdC5fX2luaXRfXyhzZWxmJTJDJTIwZW9zX3Rva2VuKSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oZW9zX3Rva2VuKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">GemmaTokenizer</span>(LlamaTokenizer, PretrainedTokenizerFast):         |           <span class="hljs-keyword">class</span> <span class="hljs-title class_">GemmaModel</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, eos_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span></span>):                              |             <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        eos_token = AddedToken(eos_token)                              |                eos_token = AddedToken(eos_token)
        PretrainedTokenizerFast.__init__(self, eos_token)              |                <span class="hljs-built_in">super</span>().__init__(eos_token)`,wrap:!1}}),Cl=new m({props:{title:"Special naming",local:"special-naming",headingTag:"h3"}}),wl=new T({props:{code:"Y2xhc3MlMjBHZW1tYVZpc2lvbk1vZGVsKENMSVBNb2RlbCklM0ElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">GemmaVisionModel</span>(<span class="hljs-title class_ inherited__">CLIPModel</span>):                                 
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),rl=new ot({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/modular_transformers.md"}}),{c(){r=a("meta"),Jl=s(),Tl=a("p"),cl=s(),o(d.$$.fragment),fl=s(),J=a("p"),J.innerHTML=Ae,Al=s(),c=a("p"),c.innerHTML=he,hl=s(),f=a("p"),f.innerHTML=Ie,Il=s(),A=a("p"),A.textContent=ue,ul=s(),h=a("p"),h.textContent=be,bl=s(),I=a("p"),I.textContent=_e,_l=s(),u=a("p"),u.innerHTML=Ze,Zl=s(),o(b.$$.fragment),gl=s(),_=a("p"),_.textContent=ge,kl=s(),Z=a("p"),Z.textContent=ke,vl=s(),g=a("p"),g.innerHTML=ve,$l=s(),k=a("p"),k.textContent=$e,Wl=s(),v=a("p"),v.innerHTML=We,Bl=s(),o($.$$.fragment),Gl=s(),W=a("p"),W.textContent=Be,Rl=s(),o(B.$$.fragment),xl=s(),G=a("p"),G.innerHTML=Ge,Vl=s(),R=a("p"),R.textContent=Re,Xl=s(),x=a("ul"),x.innerHTML=xe,El=s(),V=a("p"),V.innerHTML=Ve,Nl=s(),o(X.$$.fragment),Yl=s(),E=a("p"),E.innerHTML=Xe,Hl=s(),o(N.$$.fragment),zl=s(),o(Y.$$.fragment),Ql=s(),H=a("p"),H.textContent=Ee,Sl=s(),z=a("p"),z.innerHTML=Ne,Ll=s(),o(Q.$$.fragment),Fl=s(),S=a("p"),S.textContent=Ye,Pl=s(),o(L.$$.fragment),Kl=s(),F=a("p"),F.textContent=He,Dl=s(),o(P.$$.fragment),ql=s(),K=a("p"),K.innerHTML=ze,Ol=s(),o(D.$$.fragment),le=s(),o(q.$$.fragment),ee=s(),O=a("p"),O.textContent=Qe,te=s(),o(ll.$$.fragment),Me=s(),el=a("p"),el.innerHTML=Se,se=s(),tl=a("p"),tl.innerHTML=Le,ne=s(),o(Ml.$$.fragment),ae=s(),o(sl.$$.fragment),ie=s(),nl=a("p"),nl.innerHTML=Fe,ye=s(),o(al.$$.fragment),oe=s(),il=a("p"),il.innerHTML=Pe,Ue=s(),o(yl.$$.fragment),je=s(),ol=a("p"),ol.textContent=Ke,Ce=s(),o(Ul.$$.fragment),pe=s(),jl=a("p"),jl.innerHTML=De,we=s(),o(Cl.$$.fragment),me=s(),pl=a("p"),pl.textContent=qe,re=s(),o(wl.$$.fragment),Te=s(),ml=a("p"),ml.innerHTML=Oe,de=s(),o(rl.$$.fragment),Je=s(),dl=a("p"),this.h()},l(l){const e=it("svelte-u9bgzb",document.head);r=i(e,"META",{name:!0,content:!0}),e.forEach(t),Jl=n(l),Tl=i(l,"P",{}),lt(Tl).forEach(t),cl=n(l),U(d.$$.fragment,l),fl=n(l),J=i(l,"P",{"data-svelte-h":!0}),y(J)!=="svelte-1qsl2az"&&(J.innerHTML=Ae),Al=n(l),c=i(l,"P",{"data-svelte-h":!0}),y(c)!=="svelte-1qcwnc7"&&(c.innerHTML=he),hl=n(l),f=i(l,"P",{"data-svelte-h":!0}),y(f)!=="svelte-hcbv0p"&&(f.innerHTML=Ie),Il=n(l),A=i(l,"P",{"data-svelte-h":!0}),y(A)!=="svelte-14lpvvv"&&(A.textContent=ue),ul=n(l),h=i(l,"P",{"data-svelte-h":!0}),y(h)!=="svelte-1tehds2"&&(h.textContent=be),bl=n(l),I=i(l,"P",{"data-svelte-h":!0}),y(I)!=="svelte-5u9x31"&&(I.textContent=_e),_l=n(l),u=i(l,"P",{"data-svelte-h":!0}),y(u)!=="svelte-c0230n"&&(u.innerHTML=Ze),Zl=n(l),U(b.$$.fragment,l),gl=n(l),_=i(l,"P",{"data-svelte-h":!0}),y(_)!=="svelte-1qqnnub"&&(_.textContent=ge),kl=n(l),Z=i(l,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-huwsbv"&&(Z.textContent=ke),vl=n(l),g=i(l,"P",{"data-svelte-h":!0}),y(g)!=="svelte-dk7wye"&&(g.innerHTML=ve),$l=n(l),k=i(l,"P",{"data-svelte-h":!0}),y(k)!=="svelte-12pm85e"&&(k.textContent=$e),Wl=n(l),v=i(l,"P",{"data-svelte-h":!0}),y(v)!=="svelte-ah1dr9"&&(v.innerHTML=We),Bl=n(l),U($.$$.fragment,l),Gl=n(l),W=i(l,"P",{"data-svelte-h":!0}),y(W)!=="svelte-11y95xa"&&(W.textContent=Be),Rl=n(l),U(B.$$.fragment,l),xl=n(l),G=i(l,"P",{"data-svelte-h":!0}),y(G)!=="svelte-xkvkhs"&&(G.innerHTML=Ge),Vl=n(l),R=i(l,"P",{"data-svelte-h":!0}),y(R)!=="svelte-1gkqha7"&&(R.textContent=Re),Xl=n(l),x=i(l,"UL",{"data-svelte-h":!0}),y(x)!=="svelte-wnqir2"&&(x.innerHTML=xe),El=n(l),V=i(l,"P",{"data-svelte-h":!0}),y(V)!=="svelte-12b6859"&&(V.innerHTML=Ve),Nl=n(l),U(X.$$.fragment,l),Yl=n(l),E=i(l,"P",{"data-svelte-h":!0}),y(E)!=="svelte-1jju20g"&&(E.innerHTML=Xe),Hl=n(l),U(N.$$.fragment,l),zl=n(l),U(Y.$$.fragment,l),Ql=n(l),H=i(l,"P",{"data-svelte-h":!0}),y(H)!=="svelte-1o8u693"&&(H.textContent=Ee),Sl=n(l),z=i(l,"P",{"data-svelte-h":!0}),y(z)!=="svelte-si4m91"&&(z.innerHTML=Ne),Ll=n(l),U(Q.$$.fragment,l),Fl=n(l),S=i(l,"P",{"data-svelte-h":!0}),y(S)!=="svelte-tpa7s6"&&(S.textContent=Ye),Pl=n(l),U(L.$$.fragment,l),Kl=n(l),F=i(l,"P",{"data-svelte-h":!0}),y(F)!=="svelte-834mi0"&&(F.textContent=He),Dl=n(l),U(P.$$.fragment,l),ql=n(l),K=i(l,"P",{"data-svelte-h":!0}),y(K)!=="svelte-1cj74u8"&&(K.innerHTML=ze),Ol=n(l),U(D.$$.fragment,l),le=n(l),U(q.$$.fragment,l),ee=n(l),O=i(l,"P",{"data-svelte-h":!0}),y(O)!=="svelte-1iowufa"&&(O.textContent=Qe),te=n(l),U(ll.$$.fragment,l),Me=n(l),el=i(l,"P",{"data-svelte-h":!0}),y(el)!=="svelte-py9in9"&&(el.innerHTML=Se),se=n(l),tl=i(l,"P",{"data-svelte-h":!0}),y(tl)!=="svelte-m2hnwf"&&(tl.innerHTML=Le),ne=n(l),U(Ml.$$.fragment,l),ae=n(l),U(sl.$$.fragment,l),ie=n(l),nl=i(l,"P",{"data-svelte-h":!0}),y(nl)!=="svelte-6t8mis"&&(nl.innerHTML=Fe),ye=n(l),U(al.$$.fragment,l),oe=n(l),il=i(l,"P",{"data-svelte-h":!0}),y(il)!=="svelte-9rp4ko"&&(il.innerHTML=Pe),Ue=n(l),U(yl.$$.fragment,l),je=n(l),ol=i(l,"P",{"data-svelte-h":!0}),y(ol)!=="svelte-twcsb7"&&(ol.textContent=Ke),Ce=n(l),U(Ul.$$.fragment,l),pe=n(l),jl=i(l,"P",{"data-svelte-h":!0}),y(jl)!=="svelte-1aokivf"&&(jl.innerHTML=De),we=n(l),U(Cl.$$.fragment,l),me=n(l),pl=i(l,"P",{"data-svelte-h":!0}),y(pl)!=="svelte-m0n5a3"&&(pl.textContent=qe),re=n(l),U(wl.$$.fragment,l),Te=n(l),ml=i(l,"P",{"data-svelte-h":!0}),y(ml)!=="svelte-zxzljf"&&(ml.innerHTML=Oe),de=n(l),U(rl.$$.fragment,l),Je=n(l),dl=i(l,"P",{}),lt(dl).forEach(t),this.h()},h(){et(r,"name","hf:doc:metadata"),et(r,"content",jt)},m(l,e){yt(document.head,r),M(l,Jl,e),M(l,Tl,e),M(l,cl,e),j(d,l,e),M(l,fl,e),M(l,J,e),M(l,Al,e),M(l,c,e),M(l,hl,e),M(l,f,e),M(l,Il,e),M(l,A,e),M(l,ul,e),M(l,h,e),M(l,bl,e),M(l,I,e),M(l,_l,e),M(l,u,e),M(l,Zl,e),j(b,l,e),M(l,gl,e),M(l,_,e),M(l,kl,e),M(l,Z,e),M(l,vl,e),M(l,g,e),M(l,$l,e),M(l,k,e),M(l,Wl,e),M(l,v,e),M(l,Bl,e),j($,l,e),M(l,Gl,e),M(l,W,e),M(l,Rl,e),j(B,l,e),M(l,xl,e),M(l,G,e),M(l,Vl,e),M(l,R,e),M(l,Xl,e),M(l,x,e),M(l,El,e),M(l,V,e),M(l,Nl,e),j(X,l,e),M(l,Yl,e),M(l,E,e),M(l,Hl,e),j(N,l,e),M(l,zl,e),j(Y,l,e),M(l,Ql,e),M(l,H,e),M(l,Sl,e),M(l,z,e),M(l,Ll,e),j(Q,l,e),M(l,Fl,e),M(l,S,e),M(l,Pl,e),j(L,l,e),M(l,Kl,e),M(l,F,e),M(l,Dl,e),j(P,l,e),M(l,ql,e),M(l,K,e),M(l,Ol,e),j(D,l,e),M(l,le,e),j(q,l,e),M(l,ee,e),M(l,O,e),M(l,te,e),j(ll,l,e),M(l,Me,e),M(l,el,e),M(l,se,e),M(l,tl,e),M(l,ne,e),j(Ml,l,e),M(l,ae,e),j(sl,l,e),M(l,ie,e),M(l,nl,e),M(l,ye,e),j(al,l,e),M(l,oe,e),M(l,il,e),M(l,Ue,e),j(yl,l,e),M(l,je,e),M(l,ol,e),M(l,Ce,e),j(Ul,l,e),M(l,pe,e),M(l,jl,e),M(l,we,e),j(Cl,l,e),M(l,me,e),M(l,pl,e),M(l,re,e),j(wl,l,e),M(l,Te,e),M(l,ml,e),M(l,de,e),j(rl,l,e),M(l,Je,e),M(l,dl,e),ce=!0},p:Mt,i(l){ce||(C(d.$$.fragment,l),C(b.$$.fragment,l),C($.$$.fragment,l),C(B.$$.fragment,l),C(X.$$.fragment,l),C(N.$$.fragment,l),C(Y.$$.fragment,l),C(Q.$$.fragment,l),C(L.$$.fragment,l),C(P.$$.fragment,l),C(D.$$.fragment,l),C(q.$$.fragment,l),C(ll.$$.fragment,l),C(Ml.$$.fragment,l),C(sl.$$.fragment,l),C(al.$$.fragment,l),C(yl.$$.fragment,l),C(Ul.$$.fragment,l),C(Cl.$$.fragment,l),C(wl.$$.fragment,l),C(rl.$$.fragment,l),ce=!0)},o(l){p(d.$$.fragment,l),p(b.$$.fragment,l),p($.$$.fragment,l),p(B.$$.fragment,l),p(X.$$.fragment,l),p(N.$$.fragment,l),p(Y.$$.fragment,l),p(Q.$$.fragment,l),p(L.$$.fragment,l),p(P.$$.fragment,l),p(D.$$.fragment,l),p(q.$$.fragment,l),p(ll.$$.fragment,l),p(Ml.$$.fragment,l),p(sl.$$.fragment,l),p(al.$$.fragment,l),p(yl.$$.fragment,l),p(Ul.$$.fragment,l),p(Cl.$$.fragment,l),p(wl.$$.fragment,l),p(rl.$$.fragment,l),ce=!1},d(l){l&&(t(Jl),t(Tl),t(cl),t(fl),t(J),t(Al),t(c),t(hl),t(f),t(Il),t(A),t(ul),t(h),t(bl),t(I),t(_l),t(u),t(Zl),t(gl),t(_),t(kl),t(Z),t(vl),t(g),t($l),t(k),t(Wl),t(v),t(Bl),t(Gl),t(W),t(Rl),t(xl),t(G),t(Vl),t(R),t(Xl),t(x),t(El),t(V),t(Nl),t(Yl),t(E),t(Hl),t(zl),t(Ql),t(H),t(Sl),t(z),t(Ll),t(Fl),t(S),t(Pl),t(Kl),t(F),t(Dl),t(ql),t(K),t(Ol),t(le),t(ee),t(O),t(te),t(Me),t(el),t(se),t(tl),t(ne),t(ae),t(ie),t(nl),t(ye),t(oe),t(il),t(Ue),t(je),t(ol),t(Ce),t(pe),t(jl),t(we),t(me),t(pl),t(re),t(Te),t(ml),t(de),t(Je),t(dl)),t(r),w(d,l),w(b,l),w($,l),w(B,l),w(X,l),w(N,l),w(Y,l),w(Q,l),w(L,l),w(P,l),w(D,l),w(q,l),w(ll,l),w(Ml,l),w(sl,l),w(al,l),w(yl,l),w(Ul,l),w(Cl,l),w(wl,l),w(rl,l)}}}const jt='{"title":"Modular transformers","local":"modular-transformers","sections":[{"title":"What is it?","local":"what-is-it","sections":[{"title":"Details","local":"details","sections":[],"depth":3},{"title":"Enforcement","local":"enforcement","sections":[],"depth":3},{"title":"Examples","local":"examples","sections":[],"depth":3}],"depth":2},{"title":"What it is not","local":"what-it-is-not","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Removing attributes and functions","local":"removing-attributes-and-functions","sections":[],"depth":3},{"title":"Define new functions","local":"define-new-functions","sections":[],"depth":3},{"title":"Calling super()","local":"calling-super","sections":[],"depth":3},{"title":"Special naming","local":"special-naming","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ct(fe){return st(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tt extends nt{constructor(r){super(),at(this,r,Ct,Ut,tt,{})}}export{Tt as component};
