import{s as Bs,f as ml,n as xs,o as _s}from"../chunks/scheduler.f6b352c8.js";import{S as Hs,i as Gs,g as i,s as n,r as p,A as Ws,h as o,f as l,c as a,j as hl,u as w,x as M,k as c,y as Il,a as s,v as u,d as r,t as T,w as y}from"../chunks/index.7f38e934.js";import{C as j}from"../chunks/CodeBlock.2a338b68.js";import{H as St}from"../chunks/Heading.333929c4.js";import{E as Ls}from"../chunks/EditOnGithub.c3245a01.js";function ks(dl){let J,Qt,Yt,Xt,h,qt,I,Ul,Vt,d,fl="One crucial aspect of AI Agents is their ability to take <strong>actions</strong>. As we saw, this happens through the use of <strong>Tools</strong>.",Nt,U,Cl="In this section, we’ll learn what Tools are, how to design them effectively, and how to integrate them into your Agent via the System Message.",Ft,f,Al="By giving your Agent the right Tools—and clearly describing how those Tools work—you can dramatically increase what your AI can accomplish. Let’s dive in!",Pt,C,Kt,A,bl="A <strong>Tool is a function given to the LLM</strong>. This function should fulfill a <strong>clear objective</strong>",Dt,b,vl="Here are some commonly used tools in AI agents :",Ot,v,gl="<thead><tr><th>Tool</th> <th>Description</th></tr></thead> <tbody><tr><td>Web Search</td> <td>Allows the agent to fetch up-to-date information from the internet.</td></tr> <tr><td>Image Generation</td> <td>Creates images based on text descriptions.</td></tr> <tr><td>Retrieval</td> <td>Retrieves information from an external source.</td></tr> <tr><td>API Interface</td> <td>Interacts with an external API (GitHub, YouTube, Spotify, etc.).</td></tr></tbody>",te,g,Bl="Those are only examples, as you can in fact create a tool for any use case!",ee,B,xl="A good tool should be something that <strong>complements the power of an LLM</strong>.",le,x,_l="For instance, if you need to perform arithmetic, giving a <strong>calculator tool</strong> to your LLM will provide better result than relying on the native capacities of the model.",se,_,Hl="Furthermore, <strong>LLMs predict the completion of a prompt based on their training data</strong>. Which means that their internal knowledge only includes events prior to their training. Therefore, if your agent needs up-to-data data you must provide it through some tool.",ne,H,Gl="For instance, if you ask an LLM directly (without a search tool) for today’s weather, the LLM will potentially hallucinate random weather.",ae,G,Wl,ie,W,Ll="<li><p>A Tool should contain:</p> <ul><li>A <strong>textual description of what the function does</strong>.</li> <li>A <em>Callable</em> (something to perform an action).</li> <li><em>Arguments</em> with typings.</li> <li>(Optional) Outputs with typings.</li></ul></li>",oe,L,Me,k,kl="LLMs, as we saw, can only receive text inputs and generate text outputs. They have no way to call tools on their own. What we mean when we talk about <em>providing tools to an Agent</em>, is that we <strong>teach</strong> the LLM about the existence of tools, and ask the model to generate text that will invoke tools when it needs to. For example, if we provide a tool to check the weather at a location from the Internet, and then ask the LLM about the weather in Paris, the LLM will recognize that question as a relevant opportunity to use the “weather” tool we taught it about. The LLM will generate <em>text</em>, in the form of code, to invoke that tool. It is the responsibility of the <strong>Agent</strong> to parse the LLM’s output, recognize that a tool call is required, and invoke the tool on the LLM’s behalf. The output from the tool will then be sent back to the LLM, which will compose its final response for the user.",pe,$,$l="The output from a tool call is another type of message in the conversation. Tool calling steps are typically not shown to the user: the Agent retrieves the conversation, calls the tool(s), gets the outputs, adds them as a new conversation message, and sends the updated conversation to the LLM again. From the user’s point of view, it’s like the LLM had used the tool, but in fact it was our application code (the <strong>Agent</strong>) who did it.",we,Z,Zl="We’ll talk a lot more about this process in future sessions.",ue,E,re,R,El="The complete answer may seem overwhelming, but we essentially use the system prompt to provide textual descriptions of available tools to the model:",Te,S,Rl,ye,Y,Sl="For this to work, we have to be very precise and accurate about:",ce,z,Yl="<li><strong>What the tool does</strong></li> <li><strong>What exact inputs it expects</strong></li>",Je,Q,zl="This is the reason why tool descriptions are usually provided using expressive but precise structures, such as computer languages or JSON. It’s not <em>necessary</em> to do it like that, any precise and coherent format would work.",me,X,Ql="If this seems too theoretical, let’s understand it through a concrete example.",je,q,Xl="We will implement a simplified <strong>calculator</strong> tool that will just multiply two integers. This could be our Python implementation:",he,V,Ie,N,ql="So our tool is called <code>calculator</code>, it <strong>multiplies two integers</strong>, and it requires the following inputs:",de,F,Vl="<li><strong><code>a</code></strong> (<em>int</em>): An integer.</li> <li><strong><code>b</code></strong> (<em>int</em>): An integer.</li>",Ue,P,Nl="The output of the tool is another integer number that we can describe like this:",fe,K,Fl="<li>(<em>int</em>): The product of <code>a</code> and <code>b</code>.</li>",Ce,D,Pl="All of these details are important. Let’s put them together in a text string that describes our tool for the LLM to understand.",Ae,O,be,tt,Kl="<p><strong>Reminder:</strong> This textual description is <em>what we want the LLM to know about the tool</em>.</p>",ve,et,Dl="When we pass the previous string as part of the input to the LLM, the model will recognize it as a tool, and will know what it needs to pass as inputs and what to expect from the output.",ge,lt,Ol="If you want to provide additional tools, you have to be consistent and always use the same format. The process can be fragile and we may forget some details.",Be,st,ts="Is there a better way?",xe,nt,_e,at,es="Our tool was written in Python, and the implementation already provides everything we need:",He,it,ls="<li>A descriptive name of what it does: <code>calculator</code></li> <li>A longer description, provided by the function’s docstring comment: <code>Multiply two integers.</code></li> <li>The inputs and their type: the function clearly expects two <code>int</code>s.</li> <li>The type of the output.</li>",Ge,ot,ss="There’s a reason people use programming languages: they are expressive, concise, and precise.",We,Mt,ns="We could provide the Python source code as the <em>specification</em> of the tool for the LLM, but the way the tool is implemented does not matter. All that matters is its name, what it does, the inputs it expects and the output it provides.",Le,pt,as="We will leverage Python’s introspection features to leverage the source code and build a tool description automatically for us. All we need is that the tool implementation uses type hints, docstrings, and sensible function names. We will write some code to extract the relevant portions from the source code.",ke,wt,is="After we are done, we’ll only need to use a Python decorator to indicate that the <code>calculator</code> function is a tool:",$e,ut,Ze,rt,os="Note the <code>@tool</code> decorator before the function definition.",Ee,Tt,Ms="With the implementation we’ll see next, we will be able to retrieve the following text automatically from the source code:",Re,yt,Se,ct,ps="As you can see, it’s the same thing we wrote manually before!",Ye,Jt,ze,mt,ws="We create a generic <code>Tool</code> class that we can reuse whenever we need to use a tool.",Qe,jt,us="<p><strong>Disclaimer:</strong> This example implementation is fictional but closely resembles real implementations in most libraries.</p>",Xe,ht,qe,It,rs="It may seem complicated, but if we go slowly through it we can see what it does. We define a <strong><code>Tool</code></strong> class that includes:",Ve,dt,Ts="<li><strong><code>name</code></strong> (<em>str</em>): The name of the tool.</li> <li><strong><code>description</code></strong> (<em>str</em>): A brief description of what the tool does.</li> <li><strong><code>function</code></strong> (<em>callable</em>): The function the tool executes.</li> <li><strong><code>input_arguments</code></strong> (<em>list</em>): The expected input parameters.</li> <li><strong><code>outputs</code></strong> (<em>str</em> or <em>list</em>): The expected outputs of the tool.</li> <li><strong><code>__call__()</code></strong>: Calls the function when the tool instance is invoked.</li> <li><strong><code>to_string()</code></strong>: Converts the tool’s attributes into a textual representation.</li>",Ne,Ut,ys="We could create a Tool with this class using code like the following:",Fe,ft,Pe,Ct,cs="But we can also use Python’s <code>inspect</code> module to retrieve all the information for us! This is what the <code>@tool</code> decorator does.",Ke,At,Js="<p>If you are interested, you can disclose the following section to look at the decorator implementation.</p>",De,m,Rt,ms="decorator code",jl,bt,Oe,vt,js="Just to reiterate, with this decorator in place we can implement our tool like this:",tl,gt,el,Bt,hs="And we can use the tools’s <code>to_string</code> method to automatically retrieve a text suitable to be used as a tool description for an LLM:",ll,xt,Is="Tool Name: calculator, Description: Multiply two integers., Arguments: a: int, b: int, Outputs: int",sl,_t,ds="The description is <strong>injected</strong> in the system prompt. Taking the example with which we started this section, here is how it would look like after replacing the <code>tools_description</code>:",nl,Ht,Us,al,Gt,fs='In the <a href="actions">Actions</a> section, we will learn more about how an Agent can *<em>Call</em> this tool we just created.',il,ol,Ml,Wt,Cs="Tools play a crucial role in enhancing the capabilities of AI agents.",pl,Lt,As="To summarize, we learned:",wl,kt,bs="<li><p><em>What Tools Are</em>: Functions that give LLMs extra capabilities, such as performing calculations or accessing external data.</p></li> <li><p><em>How to Define a Tool</em>: By providing a clear textual description, inputs, outputs, and a callable function.</p></li> <li><p><em>Why Tools Are Essential</em>: They enable Agents to overcome the limitations of static model training, handle real-time tasks, and perform specialized actions.</p></li>",ul,$t,vs='Now, we can move on to the <a href="agent-steps-and-structure">Agent Workflow</a> where you’ll see how an Agent observes, thinks, and acts. This <strong>brings together everything we’ve covered so far</strong> and sets the stage for creating your own fully functional AI Agent.',rl,Zt,gs="But first, it’s time for another short quiz!",Tl,Et,yl,zt,cl;return h=new St({props:{title:"What are Tools?",local:"what-are-tools",headingTag:"h1"}}),C=new St({props:{title:"What are AI Tools?",local:"what-are-ai-tools",headingTag:"h2"}}),L=new St({props:{title:"How do tools work?",local:"how-do-tools-work",headingTag:"h2"}}),E=new St({props:{title:"How do we give tools to an LLM?",local:"how-do-we-give-tools-to-an-llm",headingTag:"h2"}}),V=new j({props:{code:"ZGVmJTIwY2FsY3VsYXRvcihhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwaW50JTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyTXVsdGlwbHklMjB0d28lMjBpbnRlZ2Vycy4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwKiUyMGIlMEElMEFwcmludChjYWxjdWxhdG9yLnRvX3N0cmluZygpKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),O=new j({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:'Tool Name: calculator, <span class="hljs-keyword">Description</span>: <span class="hljs-keyword">Multiply</span> two integers., Arguments: a: <span class="hljs-keyword">int</span>, b: <span class="hljs-keyword">int</span>, Outputs: <span class="hljs-keyword">int</span>',wrap:!1}}),nt=new St({props:{title:"Auto-formatting Tool sections",local:"auto-formatting-tool-sections",headingTag:"h3"}}),ut=new j({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),yt=new j({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:'Tool Name: calculator, <span class="hljs-keyword">Description</span>: <span class="hljs-keyword">Multiply</span> two integers., Arguments: a: <span class="hljs-keyword">int</span>, b: <span class="hljs-keyword">int</span>, Outputs: <span class="hljs-keyword">int</span>',wrap:!1}}),Jt=new St({props:{title:"Generic Tool implementation",local:"generic-tool-implementation",headingTag:"h3"}}),ht=new j({props:{code:"Y2xhc3MlMjBUb29sJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwQSUyMGNsYXNzJTIwcmVwcmVzZW50aW5nJTIwYSUyMHJldXNhYmxlJTIwcGllY2UlMjBvZiUyMGNvZGUlMjAoVG9vbCkuJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwQXR0cmlidXRlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5hbWUlMjAoc3RyKSUzQSUyME5hbWUlMjBvZiUyMHRoZSUyMHRvb2wuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAoc3RyKSUzQSUyMEElMjB0ZXh0dWFsJTIwZGVzY3JpcHRpb24lMjBvZiUyMHdoYXQlMjB0aGUlMjB0b29sJTIwZG9lcy4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmdW5jJTIwKGNhbGxhYmxlKSUzQSUyMFRoZSUyMGZ1bmN0aW9uJTIwdGhpcyUyMHRvb2wlMjB3cmFwcy4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmd1bWVudHMlMjAobGlzdCklM0ElMjBBJTIwbGlzdCUyMG9mJTIwYXJndW1lbnQuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMChzdHIlMjBvciUyMGxpc3QpJTNBJTIwVGhlJTIwcmV0dXJuJTIwdHlwZShzKSUyMG9mJTIwdGhlJTIwd3JhcHBlZCUyMGZ1bmN0aW9uLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNBJTIwc3RyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0ElMjBzdHIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmdW5jJTNBJTIwY2FsbGFibGUlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmd1bWVudHMlM0ElMjBsaXN0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm5hbWUlMjAlM0QlMjBuYW1lJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5kZXNjcmlwdGlvbiUyMCUzRCUyMGRlc2NyaXB0aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5mdW5jJTIwJTNEJTIwZnVuYyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYXJndW1lbnRzJTIwJTNEJTIwYXJndW1lbnRzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5vdXRwdXRzJTIwJTNEJTIwb3V0cHV0cyUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHRvX3N0cmluZyhzZWxmKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSZXR1cm4lMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMHRvb2wlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbmNsdWRpbmclMjBpdHMlMjBuYW1lJTJDJTIwZGVzY3JpcHRpb24lMkMlMjBhcmd1bWVudHMlMkMlMjBhbmQlMjBvdXRwdXRzLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFyZ3Nfc3RyJTIwJTNEJTIwJTIyJTJDJTIwJTIyLmpvaW4oJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMiU3QmFyZ19uYW1lJTdEJTNBJTIwJTdCYXJnX3R5cGUlN0QlMjIlMjBmb3IlMjBhcmdfbmFtZSUyQyUyMGFyZ190eXBlJTIwaW4lMjBzZWxmLmFyZ3VtZW50cyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMlRvb2wlMjBOYW1lJTNBJTIwJTdCc2VsZi5uYW1lJTdEJTJDJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMiUyMERlc2NyaXB0aW9uJTNBJTIwJTdCc2VsZi5kZXNjcmlwdGlvbiU3RCUyQyUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjIlMjBBcmd1bWVudHMlM0ElMjAlN0JhcmdzX3N0ciU3RCUyQyUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjIlMjBPdXRwdXRzJTNBJTIwJTdCc2VsZi5vdXRwdXRzJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYlMkMlMjAqYXJncyUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEludm9rZSUyMHRoZSUyMHVuZGVybHlpbmclMjBmdW5jdGlvbiUyMChjYWxsYWJsZSklMjB3aXRoJTIwcHJvdmlkZWQlMjBhcmd1bWVudHMuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2VsZi5mdW5jKCphcmdzJTJDJTIwKiprd2FyZ3Mp",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Tool</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    A class representing a reusable piece of code (Tool).
    
    Attributes:
        name (str): Name of the tool.
        description (str): A textual description of what the tool does.
        func (callable): The function this tool wraps.
        arguments (list): A list of argument.
        outputs (str or list): The return type(s) of the wrapped function.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, 
                 name: <span class="hljs-built_in">str</span>, 
                 description: <span class="hljs-built_in">str</span>, 
                 func: <span class="hljs-built_in">callable</span>, 
                 arguments: <span class="hljs-built_in">list</span>,
                 outputs: <span class="hljs-built_in">str</span></span>):
        self.name = name
        self.description = description
        self.func = func
        self.arguments = arguments
        self.outputs = outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_string</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return a string representation of the tool, 
        including its name, description, arguments, and outputs.
        &quot;&quot;&quot;</span>
        args_str = <span class="hljs-string">&quot;, &quot;</span>.join([
            <span class="hljs-string">f&quot;<span class="hljs-subst">{arg_name}</span>: <span class="hljs-subst">{arg_type}</span>&quot;</span> <span class="hljs-keyword">for</span> arg_name, arg_type <span class="hljs-keyword">in</span> self.arguments
        ])
        
        <span class="hljs-keyword">return</span> (
            <span class="hljs-string">f&quot;Tool Name: <span class="hljs-subst">{self.name}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Description: <span class="hljs-subst">{self.description}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Arguments: <span class="hljs-subst">{args_str}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Outputs: <span class="hljs-subst">{self.outputs}</span>&quot;</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, *args, **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Invoke the underlying function (callable) with provided arguments.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> self.func(*args, **kwargs)`,wrap:!1}}),ft=new j({props:{code:"Y2FsY3VsYXRvcl90b29sJTIwJTNEJTIwVG9vbCglMEElMjAlMjAlMjAlMjAlMjJjYWxjdWxhdG9yJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbmFtZSUwQSUyMCUyMCUyMCUyMCUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZGVzY3JpcHRpb24lMEElMjAlMjAlMjAlMjBjYWxjdWxhdG9yJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZnVuY3Rpb24lMjB0byUyMGNhbGwlMEElMjAlMjAlMjAlMjAlNUIoJTIyYSUyMiUzQSUyMCUyMmludCUyMiklMkMlMjAoJTIyYiUyMiUzQSUyMCUyMmludCUyMiklNUQlMkMlMjAlMjAlMjAlMjMlMjBpbnB1dHMlMjAobmFtZXMlMjBhbmQlMjB0eXBlcyklMEElMjAlMjAlMjAlMjAlMjJpbnQlMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBvdXRwdXQlMEEp",highlighted:`calculator_tool = Tool(
    <span class="hljs-string">&quot;calculator&quot;</span>,                   <span class="hljs-comment"># name</span>
    <span class="hljs-string">&quot;Multiply two integers.&quot;</span>,       <span class="hljs-comment"># description</span>
    calculator,                     <span class="hljs-comment"># function to call</span>
    [(<span class="hljs-string">&quot;a&quot;</span>: <span class="hljs-string">&quot;int&quot;</span>), (<span class="hljs-string">&quot;b&quot;</span>: <span class="hljs-string">&quot;int&quot;</span>)],   <span class="hljs-comment"># inputs (names and types)</span>
    <span class="hljs-string">&quot;int&quot;</span>,                          <span class="hljs-comment"># output</span>
)`,wrap:!1}}),bt=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tool</span>(<span class="hljs-params">func</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A decorator that creates a Tool instance from the given function.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Get the function signature</span>
    signature = inspect.signature(func)
    
    <span class="hljs-comment"># Extract (param_name, param_annotation) pairs for inputs</span>
    arguments = []
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> signature.parameters.values():
        annotation_name = (
            param.annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(param.annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(param.annotation)
        )
        arguments.append((param.name, annotation_name))
    
    <span class="hljs-comment"># Determine the return annotation</span>
    return_annotation = signature.return_annotation
    <span class="hljs-keyword">if</span> return_annotation <span class="hljs-keyword">is</span> inspect._empty:
        outputs = <span class="hljs-string">&quot;No return annotation&quot;</span>
    <span class="hljs-keyword">else</span>:
        outputs = (
            return_annotation.__name__ 
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(return_annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>) 
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(return_annotation)
        )
    
    <span class="hljs-comment"># Use the function&#x27;s docstring as the description (default if None)</span>
    description = func.__doc__ <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;No description provided.&quot;</span>
    
    <span class="hljs-comment"># The function name becomes the Tool name</span>
    name = func.__name__
    
    <span class="hljs-comment"># Return a new Tool instance</span>
    <span class="hljs-keyword">return</span> Tool(
        name=name, 
        description=description, 
        func=func, 
        arguments=arguments, 
        outputs=outputs
    )`,wrap:!1}}),gt=new j({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),Et=new Ls({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/tools.mdx"}}),{c(){J=i("meta"),Qt=n(),Yt=i("p"),Xt=n(),p(h.$$.fragment),qt=n(),I=i("img"),Vt=n(),d=i("p"),d.innerHTML=fl,Nt=n(),U=i("p"),U.textContent=Cl,Ft=n(),f=i("p"),f.textContent=Al,Pt=n(),p(C.$$.fragment),Kt=n(),A=i("p"),A.innerHTML=bl,Dt=n(),b=i("p"),b.textContent=vl,Ot=n(),v=i("table"),v.innerHTML=gl,te=n(),g=i("p"),g.textContent=Bl,ee=n(),B=i("p"),B.innerHTML=xl,le=n(),x=i("p"),x.innerHTML=_l,se=n(),_=i("p"),_.innerHTML=Hl,ne=n(),H=i("p"),H.textContent=Gl,ae=n(),G=i("img"),ie=n(),W=i("ul"),W.innerHTML=Ll,oe=n(),p(L.$$.fragment),Me=n(),k=i("p"),k.innerHTML=kl,pe=n(),$=i("p"),$.innerHTML=$l,we=n(),Z=i("p"),Z.textContent=Zl,ue=n(),p(E.$$.fragment),re=n(),R=i("p"),R.textContent=El,Te=n(),S=i("img"),ye=n(),Y=i("p"),Y.textContent=Sl,ce=n(),z=i("ol"),z.innerHTML=Yl,Je=n(),Q=i("p"),Q.innerHTML=zl,me=n(),X=i("p"),X.textContent=Ql,je=n(),q=i("p"),q.innerHTML=Xl,he=n(),p(V.$$.fragment),Ie=n(),N=i("p"),N.innerHTML=ql,de=n(),F=i("ul"),F.innerHTML=Vl,Ue=n(),P=i("p"),P.textContent=Nl,fe=n(),K=i("ul"),K.innerHTML=Fl,Ce=n(),D=i("p"),D.textContent=Pl,Ae=n(),p(O.$$.fragment),be=n(),tt=i("blockquote"),tt.innerHTML=Kl,ve=n(),et=i("p"),et.textContent=Dl,ge=n(),lt=i("p"),lt.textContent=Ol,Be=n(),st=i("p"),st.textContent=ts,xe=n(),p(nt.$$.fragment),_e=n(),at=i("p"),at.textContent=es,He=n(),it=i("ul"),it.innerHTML=ls,Ge=n(),ot=i("p"),ot.textContent=ss,We=n(),Mt=i("p"),Mt.innerHTML=ns,Le=n(),pt=i("p"),pt.textContent=as,ke=n(),wt=i("p"),wt.innerHTML=is,$e=n(),p(ut.$$.fragment),Ze=n(),rt=i("p"),rt.innerHTML=os,Ee=n(),Tt=i("p"),Tt.textContent=Ms,Re=n(),p(yt.$$.fragment),Se=n(),ct=i("p"),ct.textContent=ps,Ye=n(),p(Jt.$$.fragment),ze=n(),mt=i("p"),mt.innerHTML=ws,Qe=n(),jt=i("blockquote"),jt.innerHTML=us,Xe=n(),p(ht.$$.fragment),qe=n(),It=i("p"),It.innerHTML=rs,Ve=n(),dt=i("ul"),dt.innerHTML=Ts,Ne=n(),Ut=i("p"),Ut.textContent=ys,Fe=n(),p(ft.$$.fragment),Pe=n(),Ct=i("p"),Ct.innerHTML=cs,Ke=n(),At=i("blockquote"),At.innerHTML=Js,De=n(),m=i("details"),Rt=i("summary"),Rt.textContent=ms,jl=n(),p(bt.$$.fragment),Oe=n(),vt=i("p"),vt.textContent=js,tl=n(),p(gt.$$.fragment),el=n(),Bt=i("p"),Bt.innerHTML=hs,ll=n(),xt=i("p"),xt.textContent=Is,sl=n(),_t=i("p"),_t.innerHTML=ds,nl=n(),Ht=i("img"),al=n(),Gt=i("p"),Gt.innerHTML=fs,il=n(),ol=i("hr"),Ml=n(),Wt=i("p"),Wt.textContent=Cs,pl=n(),Lt=i("p"),Lt.textContent=As,wl=n(),kt=i("ul"),kt.innerHTML=bs,ul=n(),$t=i("p"),$t.innerHTML=vs,rl=n(),Zt=i("p"),Zt.textContent=gs,Tl=n(),p(Et.$$.fragment),yl=n(),zt=i("p"),this.h()},l(t){const e=Ws("svelte-u9bgzb",document.head);J=o(e,"META",{name:!0,content:!0}),e.forEach(l),Qt=a(t),Yt=o(t,"P",{}),hl(Yt).forEach(l),Xt=a(t),w(h.$$.fragment,t),qt=a(t),I=o(t,"IMG",{src:!0,alt:!0}),Vt=a(t),d=o(t,"P",{"data-svelte-h":!0}),M(d)!=="svelte-12q0l6c"&&(d.innerHTML=fl),Nt=a(t),U=o(t,"P",{"data-svelte-h":!0}),M(U)!=="svelte-vccz0n"&&(U.textContent=Cl),Ft=a(t),f=o(t,"P",{"data-svelte-h":!0}),M(f)!=="svelte-g748wk"&&(f.textContent=Al),Pt=a(t),w(C.$$.fragment,t),Kt=a(t),A=o(t,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1dqb7wc"&&(A.innerHTML=bl),Dt=a(t),b=o(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1uce65n"&&(b.textContent=vl),Ot=a(t),v=o(t,"TABLE",{"data-svelte-h":!0}),M(v)!=="svelte-1r7ovsn"&&(v.innerHTML=gl),te=a(t),g=o(t,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1fuccdy"&&(g.textContent=Bl),ee=a(t),B=o(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1eopnbk"&&(B.innerHTML=xl),le=a(t),x=o(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-urr3zs"&&(x.innerHTML=_l),se=a(t),_=o(t,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1t9wdv7"&&(_.innerHTML=Hl),ne=a(t),H=o(t,"P",{"data-svelte-h":!0}),M(H)!=="svelte-mz2far"&&(H.textContent=Gl),ae=a(t),G=o(t,"IMG",{src:!0,alt:!0}),ie=a(t),W=o(t,"UL",{"data-svelte-h":!0}),M(W)!=="svelte-gj3em1"&&(W.innerHTML=Ll),oe=a(t),w(L.$$.fragment,t),Me=a(t),k=o(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-bf3q0z"&&(k.innerHTML=kl),pe=a(t),$=o(t,"P",{"data-svelte-h":!0}),M($)!=="svelte-19cyzqu"&&($.innerHTML=$l),we=a(t),Z=o(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1gym7on"&&(Z.textContent=Zl),ue=a(t),w(E.$$.fragment,t),re=a(t),R=o(t,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1m76tol"&&(R.textContent=El),Te=a(t),S=o(t,"IMG",{src:!0,alt:!0}),ye=a(t),Y=o(t,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-e466s4"&&(Y.textContent=Sl),ce=a(t),z=o(t,"OL",{"data-svelte-h":!0}),M(z)!=="svelte-12vrnnv"&&(z.innerHTML=Yl),Je=a(t),Q=o(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1lxlzbg"&&(Q.innerHTML=zl),me=a(t),X=o(t,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1p033lp"&&(X.textContent=Ql),je=a(t),q=o(t,"P",{"data-svelte-h":!0}),M(q)!=="svelte-1if40sb"&&(q.innerHTML=Xl),he=a(t),w(V.$$.fragment,t),Ie=a(t),N=o(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-somofk"&&(N.innerHTML=ql),de=a(t),F=o(t,"UL",{"data-svelte-h":!0}),M(F)!=="svelte-1qi2vj"&&(F.innerHTML=Vl),Ue=a(t),P=o(t,"P",{"data-svelte-h":!0}),M(P)!=="svelte-z90coj"&&(P.textContent=Nl),fe=a(t),K=o(t,"UL",{"data-svelte-h":!0}),M(K)!=="svelte-1rd1o27"&&(K.innerHTML=Fl),Ce=a(t),D=o(t,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1gl47rm"&&(D.textContent=Pl),Ae=a(t),w(O.$$.fragment,t),be=a(t),tt=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(tt)!=="svelte-jn5onw"&&(tt.innerHTML=Kl),ve=a(t),et=o(t,"P",{"data-svelte-h":!0}),M(et)!=="svelte-dd2uu2"&&(et.textContent=Dl),ge=a(t),lt=o(t,"P",{"data-svelte-h":!0}),M(lt)!=="svelte-1aodaey"&&(lt.textContent=Ol),Be=a(t),st=o(t,"P",{"data-svelte-h":!0}),M(st)!=="svelte-xhigt1"&&(st.textContent=ts),xe=a(t),w(nt.$$.fragment,t),_e=a(t),at=o(t,"P",{"data-svelte-h":!0}),M(at)!=="svelte-xwh6nk"&&(at.textContent=es),He=a(t),it=o(t,"UL",{"data-svelte-h":!0}),M(it)!=="svelte-1mufwba"&&(it.innerHTML=ls),Ge=a(t),ot=o(t,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-6ogn9l"&&(ot.textContent=ss),We=a(t),Mt=o(t,"P",{"data-svelte-h":!0}),M(Mt)!=="svelte-2908e6"&&(Mt.innerHTML=ns),Le=a(t),pt=o(t,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-1nshzlk"&&(pt.textContent=as),ke=a(t),wt=o(t,"P",{"data-svelte-h":!0}),M(wt)!=="svelte-1iag2er"&&(wt.innerHTML=is),$e=a(t),w(ut.$$.fragment,t),Ze=a(t),rt=o(t,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-1xfdhk0"&&(rt.innerHTML=os),Ee=a(t),Tt=o(t,"P",{"data-svelte-h":!0}),M(Tt)!=="svelte-i0wjh"&&(Tt.textContent=Ms),Re=a(t),w(yt.$$.fragment,t),Se=a(t),ct=o(t,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-ah55dy"&&(ct.textContent=ps),Ye=a(t),w(Jt.$$.fragment,t),ze=a(t),mt=o(t,"P",{"data-svelte-h":!0}),M(mt)!=="svelte-1g4lbet"&&(mt.innerHTML=ws),Qe=a(t),jt=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(jt)!=="svelte-17jlnyo"&&(jt.innerHTML=us),Xe=a(t),w(ht.$$.fragment,t),qe=a(t),It=o(t,"P",{"data-svelte-h":!0}),M(It)!=="svelte-1m24zfs"&&(It.innerHTML=rs),Ve=a(t),dt=o(t,"UL",{"data-svelte-h":!0}),M(dt)!=="svelte-1cnrr36"&&(dt.innerHTML=Ts),Ne=a(t),Ut=o(t,"P",{"data-svelte-h":!0}),M(Ut)!=="svelte-9jg0w0"&&(Ut.textContent=ys),Fe=a(t),w(ft.$$.fragment,t),Pe=a(t),Ct=o(t,"P",{"data-svelte-h":!0}),M(Ct)!=="svelte-imjo5d"&&(Ct.innerHTML=cs),Ke=a(t),At=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(At)!=="svelte-5gslq7"&&(At.innerHTML=Js),De=a(t),m=o(t,"DETAILS",{});var Jl=hl(m);Rt=o(Jl,"SUMMARY",{"data-svelte-h":!0}),M(Rt)!=="svelte-14wmf42"&&(Rt.textContent=ms),jl=a(Jl),w(bt.$$.fragment,Jl),Jl.forEach(l),Oe=a(t),vt=o(t,"P",{"data-svelte-h":!0}),M(vt)!=="svelte-1pxgdsn"&&(vt.textContent=js),tl=a(t),w(gt.$$.fragment,t),el=a(t),Bt=o(t,"P",{"data-svelte-h":!0}),M(Bt)!=="svelte-woxxxh"&&(Bt.innerHTML=hs),ll=a(t),xt=o(t,"P",{"data-svelte-h":!0}),M(xt)!=="svelte-rhyxjc"&&(xt.textContent=Is),sl=a(t),_t=o(t,"P",{"data-svelte-h":!0}),M(_t)!=="svelte-1gsasw4"&&(_t.innerHTML=ds),nl=a(t),Ht=o(t,"IMG",{src:!0,alt:!0}),al=a(t),Gt=o(t,"P",{"data-svelte-h":!0}),M(Gt)!=="svelte-xsxm7p"&&(Gt.innerHTML=fs),il=a(t),ol=o(t,"HR",{}),Ml=a(t),Wt=o(t,"P",{"data-svelte-h":!0}),M(Wt)!=="svelte-yaz9vn"&&(Wt.textContent=Cs),pl=a(t),Lt=o(t,"P",{"data-svelte-h":!0}),M(Lt)!=="svelte-1mncb1b"&&(Lt.textContent=As),wl=a(t),kt=o(t,"UL",{"data-svelte-h":!0}),M(kt)!=="svelte-1lbaznq"&&(kt.innerHTML=bs),ul=a(t),$t=o(t,"P",{"data-svelte-h":!0}),M($t)!=="svelte-16mxhlc"&&($t.innerHTML=vs),rl=a(t),Zt=o(t,"P",{"data-svelte-h":!0}),M(Zt)!=="svelte-1w2njod"&&(Zt.textContent=gs),Tl=a(t),w(Et.$$.fragment,t),yl=a(t),zt=o(t,"P",{}),hl(zt).forEach(l),this.h()},h(){c(J,"name","hf:doc:metadata"),c(J,"content",$s),ml(I.src,Ul="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-2.jpg")||c(I,"src",Ul),c(I,"alt","Unit 1 planning"),ml(G.src,Wl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/weather.jpg")||c(G,"src",Wl),c(G,"alt","Weather"),ml(S.src,Rl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt.png")||c(S,"src",Rl),c(S,"alt","System prompt for tools"),ml(Ht.src,Us="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt_tools.png")||c(Ht,"src",Us),c(Ht,"alt","System prompt for tools")},m(t,e){Il(document.head,J),s(t,Qt,e),s(t,Yt,e),s(t,Xt,e),u(h,t,e),s(t,qt,e),s(t,I,e),s(t,Vt,e),s(t,d,e),s(t,Nt,e),s(t,U,e),s(t,Ft,e),s(t,f,e),s(t,Pt,e),u(C,t,e),s(t,Kt,e),s(t,A,e),s(t,Dt,e),s(t,b,e),s(t,Ot,e),s(t,v,e),s(t,te,e),s(t,g,e),s(t,ee,e),s(t,B,e),s(t,le,e),s(t,x,e),s(t,se,e),s(t,_,e),s(t,ne,e),s(t,H,e),s(t,ae,e),s(t,G,e),s(t,ie,e),s(t,W,e),s(t,oe,e),u(L,t,e),s(t,Me,e),s(t,k,e),s(t,pe,e),s(t,$,e),s(t,we,e),s(t,Z,e),s(t,ue,e),u(E,t,e),s(t,re,e),s(t,R,e),s(t,Te,e),s(t,S,e),s(t,ye,e),s(t,Y,e),s(t,ce,e),s(t,z,e),s(t,Je,e),s(t,Q,e),s(t,me,e),s(t,X,e),s(t,je,e),s(t,q,e),s(t,he,e),u(V,t,e),s(t,Ie,e),s(t,N,e),s(t,de,e),s(t,F,e),s(t,Ue,e),s(t,P,e),s(t,fe,e),s(t,K,e),s(t,Ce,e),s(t,D,e),s(t,Ae,e),u(O,t,e),s(t,be,e),s(t,tt,e),s(t,ve,e),s(t,et,e),s(t,ge,e),s(t,lt,e),s(t,Be,e),s(t,st,e),s(t,xe,e),u(nt,t,e),s(t,_e,e),s(t,at,e),s(t,He,e),s(t,it,e),s(t,Ge,e),s(t,ot,e),s(t,We,e),s(t,Mt,e),s(t,Le,e),s(t,pt,e),s(t,ke,e),s(t,wt,e),s(t,$e,e),u(ut,t,e),s(t,Ze,e),s(t,rt,e),s(t,Ee,e),s(t,Tt,e),s(t,Re,e),u(yt,t,e),s(t,Se,e),s(t,ct,e),s(t,Ye,e),u(Jt,t,e),s(t,ze,e),s(t,mt,e),s(t,Qe,e),s(t,jt,e),s(t,Xe,e),u(ht,t,e),s(t,qe,e),s(t,It,e),s(t,Ve,e),s(t,dt,e),s(t,Ne,e),s(t,Ut,e),s(t,Fe,e),u(ft,t,e),s(t,Pe,e),s(t,Ct,e),s(t,Ke,e),s(t,At,e),s(t,De,e),s(t,m,e),Il(m,Rt),Il(m,jl),u(bt,m,null),s(t,Oe,e),s(t,vt,e),s(t,tl,e),u(gt,t,e),s(t,el,e),s(t,Bt,e),s(t,ll,e),s(t,xt,e),s(t,sl,e),s(t,_t,e),s(t,nl,e),s(t,Ht,e),s(t,al,e),s(t,Gt,e),s(t,il,e),s(t,ol,e),s(t,Ml,e),s(t,Wt,e),s(t,pl,e),s(t,Lt,e),s(t,wl,e),s(t,kt,e),s(t,ul,e),s(t,$t,e),s(t,rl,e),s(t,Zt,e),s(t,Tl,e),u(Et,t,e),s(t,yl,e),s(t,zt,e),cl=!0},p:xs,i(t){cl||(r(h.$$.fragment,t),r(C.$$.fragment,t),r(L.$$.fragment,t),r(E.$$.fragment,t),r(V.$$.fragment,t),r(O.$$.fragment,t),r(nt.$$.fragment,t),r(ut.$$.fragment,t),r(yt.$$.fragment,t),r(Jt.$$.fragment,t),r(ht.$$.fragment,t),r(ft.$$.fragment,t),r(bt.$$.fragment,t),r(gt.$$.fragment,t),r(Et.$$.fragment,t),cl=!0)},o(t){T(h.$$.fragment,t),T(C.$$.fragment,t),T(L.$$.fragment,t),T(E.$$.fragment,t),T(V.$$.fragment,t),T(O.$$.fragment,t),T(nt.$$.fragment,t),T(ut.$$.fragment,t),T(yt.$$.fragment,t),T(Jt.$$.fragment,t),T(ht.$$.fragment,t),T(ft.$$.fragment,t),T(bt.$$.fragment,t),T(gt.$$.fragment,t),T(Et.$$.fragment,t),cl=!1},d(t){t&&(l(Qt),l(Yt),l(Xt),l(qt),l(I),l(Vt),l(d),l(Nt),l(U),l(Ft),l(f),l(Pt),l(Kt),l(A),l(Dt),l(b),l(Ot),l(v),l(te),l(g),l(ee),l(B),l(le),l(x),l(se),l(_),l(ne),l(H),l(ae),l(G),l(ie),l(W),l(oe),l(Me),l(k),l(pe),l($),l(we),l(Z),l(ue),l(re),l(R),l(Te),l(S),l(ye),l(Y),l(ce),l(z),l(Je),l(Q),l(me),l(X),l(je),l(q),l(he),l(Ie),l(N),l(de),l(F),l(Ue),l(P),l(fe),l(K),l(Ce),l(D),l(Ae),l(be),l(tt),l(ve),l(et),l(ge),l(lt),l(Be),l(st),l(xe),l(_e),l(at),l(He),l(it),l(Ge),l(ot),l(We),l(Mt),l(Le),l(pt),l(ke),l(wt),l($e),l(Ze),l(rt),l(Ee),l(Tt),l(Re),l(Se),l(ct),l(Ye),l(ze),l(mt),l(Qe),l(jt),l(Xe),l(qe),l(It),l(Ve),l(dt),l(Ne),l(Ut),l(Fe),l(Pe),l(Ct),l(Ke),l(At),l(De),l(m),l(Oe),l(vt),l(tl),l(el),l(Bt),l(ll),l(xt),l(sl),l(_t),l(nl),l(Ht),l(al),l(Gt),l(il),l(ol),l(Ml),l(Wt),l(pl),l(Lt),l(wl),l(kt),l(ul),l($t),l(rl),l(Zt),l(Tl),l(yl),l(zt)),l(J),y(h,t),y(C,t),y(L,t),y(E,t),y(V,t),y(O,t),y(nt,t),y(ut,t),y(yt,t),y(Jt,t),y(ht,t),y(ft,t),y(bt),y(gt,t),y(Et,t)}}}const $s='{"title":"What are Tools?","local":"what-are-tools","sections":[{"title":"What are AI Tools?","local":"what-are-ai-tools","sections":[],"depth":2},{"title":"How do tools work?","local":"how-do-tools-work","sections":[],"depth":2},{"title":"How do we give tools to an LLM?","local":"how-do-we-give-tools-to-an-llm","sections":[{"title":"Auto-formatting Tool sections","local":"auto-formatting-tool-sections","sections":[],"depth":3},{"title":"Generic Tool implementation","local":"generic-tool-implementation","sections":[],"depth":3}],"depth":2}],"depth":1}';function Zs(dl){return _s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qs extends Hs{constructor(J){super(),Gs(this,J,Zs,ks,Bs,{})}}export{Qs as component};
