import{s as sn,n as ln,o as dn}from"../chunks/scheduler.85c25b89.js";import{S as cn,i as pn,g as s,s as n,r as p,A as mn,h as l,f as o,c as a,j as T,u as m,x as d,k as b,l as gn,y as i,a as r,v as g,d as h,t as u,w as f}from"../chunks/index.c142fe32.js";import{D as w}from"../chunks/Docstring.d3e0bcd1.js";import{C as P}from"../chunks/CodeBlock.a5e95a57.js";import{H as F,E as hn}from"../chunks/EditOnGithub.a592e7aa.js";function un(Mo){let v,De,Se,Ye,Z,Ke,B,Jo='TRL supports the <a href="https://huggingface.co/papers/1707.06347" rel="nofollow">PPO</a> Trainer for training language models on any reward signal with RL. The reward signal can come from a handcrafted rule, a metric or from preference data using a Reward Model. For a full example have a look at <a href="https://github.com/lvwerra/trl/blob/main/examples/notebooks/gpt2-sentiment.ipynb" rel="nofollow"><code>examples/notebooks/gpt2-sentiment.ipynb</code></a>. The trainer is heavily inspired by the original <a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">OpenAI learning to summarize work</a>.',et,L,xo='The first step is to train your SFT model (see the <a href="sft_trainer">SFTTrainer</a>), to ensure the data we train on is in-distribution for the PPO algorithm. In addition we need to train a Reward model (see <a href="reward_trainer">RewardTrainer</a>) which will be used to optimize the SFT model using the PPO algorithm.',tt,N,ot,H,Co="Fine-tuning a language model via PPO consists of roughly three steps:",nt,W,$o="<li><strong>Rollout</strong>: The language model generates a response or continuation based on query which could be the start of a sentence.</li> <li><strong>Evaluation</strong>: The query and response are evaluated with a function, model, human feedback or some combination of them. The important thing is that this process should yield a scalar value for each query/response pair.</li> <li><strong>Optimization</strong>: This is the most complex part. In the optimisation step the query/response pairs are used to calculate the log-probabilities of the tokens in the sequences. This is done with the model that is trained and a reference model, which is usually the pre-trained model before fine-tuning. The KL-divergence between the two outputs is used as an additional reward signal to make sure the generated responses don’t deviate too far from the reference language model. The active language model is then trained with PPO.</li>",at,G,Io="This process is illustrated in the sketch below:",rt,M,ko='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl_overview.png" width="800"/> <p style="text-align: center;"><b>Figure:</b> Sketch of the workflow.</p>',st,R,lt,V,Uo="The <code>PPOTrainer</code> expects to align a generated response with a query given the rewards obtained from the Reward model. During each step of the PPO algorithm we sample a batch of prompts from the dataset, we then use these prompts to generate the a responses from the SFT model. Next, the Reward model is used to compute the rewards for the generated response. Finally, these rewards are used to optimize the SFT model using the PPO algorithm.",it,A,jo="Therefore the dataset should contain a text column which we can rename to <code>query</code>. Each of the other data-points required to optimize the SFT model are obtained during the training loop.",dt,E,Oo='Here is an example with the <a href="https://huggingface.co/datasets/HuggingFaceH4/cherry_picked_prompts" rel="nofollow">HuggingFaceH4/cherry_picked_prompts</a> dataset:',ct,X,pt,S,zo="Resulting in the following subset of the dataset:",mt,Q,gt,D,ht,Y,qo='For a detailed example have a look at the <a href="https://github.com/lvwerra/trl/blob/main/examples/notebooks/gpt2-sentiment.ipynb" rel="nofollow"><code>examples/notebooks/gpt2-sentiment.ipynb</code></a> notebook. At a high level we need to initialize the <code>PPOTrainer</code> with a <code>model</code> we wish to train. Additionally, we require a reference <code>reward_model</code> which we will use to rate the generated response.',ut,K,ft,ee,Fo="The <code>PPOConfig</code> dataclass controls all the hyperparameters and settings for the PPO algorithm and trainer.",_t,te,Tt,oe,Zo="Now we can initialize our model. Note that PPO also requires a reference model, but this model is generated by the ‘PPOTrainer` automatically. The model can be initialized as follows:",bt,ne,wt,ae,Bo="As mentioned above, the reward can be generated using any function that returns a single value for a string, be it a simple rule (e.g. length of string), a metric (e.g. BLEU), or a reward model based on human preferences. In this example we use a reward model and initialize it using <code>transformers.pipeline</code> for ease of use.",yt,re,vt,se,Lo="Lastly, we pretokenize our dataset using the <code>tokenizer</code> to ensure we can efficiently generate responses during the training loop:",Pt,le,Mt,ie,No="Now we are ready to initialize the <code>PPOTrainer</code> using the defined config, datasets, and model.",Jt,de,xt,ce,Ct,pe,Ho="Because the <code>PPOTrainer</code> needs an active <code>reward</code> per execution step, we need to define a method to get rewards during each step of the PPO algorithm. In this example we will be using the sentiment <code>reward_model</code> initialized above.",$t,me,Wo='To guide the generation process we use the <code>generation_kwargs</code> which are passed to the <code>model.generate</code> method for the SFT-model during each step. A more detailed example can be found over <a href="how_to_train#how-to-generate-text-for-training">here</a>.',It,ge,kt,he,Go="We can then loop over all examples in the dataset and generate a response for each query. We then calculate the reward for each generated response using the <code>reward_model</code> and pass these rewards to the <code>ppo_trainer.step</code> method. The <code>ppo_trainer.step</code> method will then optimize the SFT model using the PPO algorithm.",Ut,ue,jt,fe,Ot,_e,Ro="While training and evaluating we log the following metrics:",zt,Te,Vo="<li><code>stats</code>: The statistics of the PPO algorithm, including the loss, entropy, etc.</li> <li><code>batch</code>: The batch of data used to train the SFT model.</li> <li><code>rewards</code>: The rewards obtained from the Reward model.</li>",qt,be,Ft,c,we,Yt,ze,Ao=`The PPOTrainer uses Proximal Policy Optimization to optimise language models.
Note, this trainer is heavily inspired by the original OpenAI learning to summarize work here:
<a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">https://github.com/openai/summarize-from-feedback</a>`,Kt,J,ye,eo,qe,Eo="Calculate model outputs in multiple batches.",to,x,ve,oo,Fe,Xo="Compute per token rewards from scores and KL-penalty.",no,C,Pe,ao,Ze,So="Creates and saves a model card for a TRL model.",ro,$,Me,so,Be,Qo="Gather stats from all processes. Useful in the context of distributed training.",lo,I,Je,io,Le,Do=`Generate response with the model given the query tensor.
call the <code>generate</code> method of the model.`,co,k,xe,po,Ne,Yo="A function that logs all the training stats. Call it at the end of each epoch.",mo,U,Ce,go,He,Ko="Calculate policy and value losses.",ho,j,$e,uo,We,en="Prepare the dataloader for training.",fo,O,Ie,_o,Ge,tn="Record training step statistics.",To,z,ke,bo,Re,on="Run a PPO optimisation step given a list of queries, model responses, and rewards.",wo,q,Ue,yo,Ve,nn="Train one PPO minibatch",Zt,y,je,vo,Ae,an='Configuration class for the <a href="/docs/trl/main/en/ppo_trainer#trl.PPOTrainer">PPOTrainer</a>.',Po,Ee,rn=`Using <a href="https://huggingface.co/docs/transformers/main/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Bt,Oe,Lt,Qe,Nt;return Z=new F({props:{title:"PPO Trainer",local:"ppo-trainer",headingTag:"h1"}}),N=new F({props:{title:"How PPO works",local:"how-ppo-works",headingTag:"h2"}}),R=new F({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),X=new P({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJIdWdnaW5nRmFjZUg0JTJGY2hlcnJ5X3BpY2tlZF9wcm9tcHRzJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5yZW5hbWVfY29sdW1uKCUyMnByb21wdCUyMiUyQyUyMCUyMnF1ZXJ5JTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCU1QiUyMm1ldGElMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceH4/cherry_picked_prompts&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
dataset = dataset.rename_column(<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;query&quot;</span>)
dataset = dataset.remove_columns([<span class="hljs-string">&quot;meta&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>])`,wrap:!1}}),Q=new P({props:{code:"cHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnF1ZXJ5JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRXhwbGFpbiUyMHRoZSUyMG1vb24lMjBsYW5kaW5nJTIwdG8lMjBhJTIwNiUyMHllYXIlMjBvbGQlMjBpbiUyMGElMjBmZXclMjBzZW50ZW5jZXMuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2h5JTIwYXJlbiVFMiU4MCU5OXQlMjBiaXJkcyUyMHJlYWwlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaGFwcGVucyUyMGlmJTIweW91JTIwZmlyZSUyMGElMjBjYW5ub25iYWxsJTIwZGlyZWN0bHklMjBhdCUyMGElMjBwdW1wa2luJTIwYXQlMjBoaWdoJTIwc3BlZWRzJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySG93JTIwY2FuJTIwSSUyMHN0ZWFsJTIwZnJvbSUyMGElMjBncm9jZXJ5JTIwc3RvcmUlMjB3aXRob3V0JTIwZ2V0dGluZyUyMGNhdWdodCUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoeSUyMGlzJTIwaXQlMjBpbXBvcnRhbnQlMjB0byUyMGVhdCUyMHNvY2tzJTIwYWZ0ZXIlMjBtZWRpdGF0aW5nJTNGJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTVEJTBBJTdE",highlighted:`ppo_dataset_dict = {
    <span class="hljs-string">&quot;query&quot;</span>: [
        <span class="hljs-string">&quot;Explain the moon landing to a 6 year old in a few sentences.&quot;</span>,
        <span class="hljs-string">&quot;Why aren’t birds real?&quot;</span>,
        <span class="hljs-string">&quot;What happens if you fire a cannonball directly at a pumpkin at high speeds?&quot;</span>,
        <span class="hljs-string">&quot;How can I steal from a grocery store without getting caught?&quot;</span>,
        <span class="hljs-string">&quot;Why is it important to eat socks after meditating? &quot;</span>
    ]
}`,wrap:!1}}),D=new F({props:{title:"Using the PPOTrainer",local:"using-the-ppotrainer",headingTag:"h2"}}),K=new F({props:{title:"Initializing the PPOTrainer",local:"initializing-the-ppotrainer",headingTag:"h3"}}),te=new P({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFBQT0NvbmZpZyUwQSUwQWNvbmZpZyUyMCUzRCUyMFBQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTNEJTIyZ3B0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxLjQxZS01JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOConfig

config = PPOConfig(
    model_name=<span class="hljs-string">&quot;gpt2&quot;</span>,
    learning_rate=<span class="hljs-number">1.41e-5</span>,
)`,wrap:!1}}),ne=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkJTJDJTIwUFBPQ29uZmlnJTJDJTIwUFBPVHJhaW5lciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkLmZyb21fcHJldHJhaW5lZChjb25maWcubW9kZWxfbmFtZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjb25maWcubW9kZWxfbmFtZSklMEElMEF0b2tlbml6ZXIucGFkX3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyLmVvc190b2tlbg==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> AutoModelForCausalLMWithValueHead, PPOConfig, PPOTrainer

model = AutoModelForCausalLMWithValueHead.from_pretrained(config.model_name)
tokenizer = AutoTokenizer.from_pretrained(config.model_name)

tokenizer.pad_token = tokenizer.eos_token`,wrap:!1}}),re=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcmV3YXJkX21vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIybHZ3ZXJyYSUyRmRpc3RpbGJlcnQtaW1kYiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

reward_model = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>)`,wrap:!1}}),le=new P({props:{code:"ZGVmJTIwdG9rZW5pemUoc2FtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSU1QiUyMmlucHV0X2lkcyUyMiU1RCUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUoc2FtcGxlJTVCJTIycXVlcnklMjIlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2FtcGxlJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHRva2VuaXplJTJDJTIwYmF0Y2hlZCUzREZhbHNlKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">sample</span>):
    sample[<span class="hljs-string">&quot;input_ids&quot;</span>] = tokenizer.encode(sample[<span class="hljs-string">&quot;query&quot;</span>])
    <span class="hljs-keyword">return</span> sample

dataset = dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">False</span>)`,wrap:!1}}),de=new P({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFBQT1RyYWluZXIlMEElMEFwcG9fdHJhaW5lciUyMCUzRCUyMFBQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGNvbmZpZyUzRGNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOTrainer

ppo_trainer = PPOTrainer(
    model=model,
    config=config,
    dataset=dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),ce=new F({props:{title:"Starting the training loop",local:"starting-the-training-loop",headingTag:"h3"}}),ge=new P({props:{code:"Z2VuZXJhdGlvbl9rd2FyZ3MlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJtaW5fbGVuZ3RoJTIyJTNBJTIwLTElMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3BfayUyMiUzQSUyMDAuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRvcF9wJTIyJTNBJTIwMS4wJTJDJTBBJTIwJTIwJTIwJTIwJTIyZG9fc2FtcGxlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhZF90b2tlbl9pZCUyMiUzQSUyMHRva2VuaXplci5lb3NfdG9rZW5faWQlMkMlMEElN0Q=",highlighted:`generation_kwargs = {
    <span class="hljs-string">&quot;min_length&quot;</span>: -<span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;top_k&quot;</span>: <span class="hljs-number">0.0</span>,
    <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">1.0</span>,
    <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;pad_token_id&quot;</span>: tokenizer.eos_token_id,
}`,wrap:!1}}),ue=new P({props:{code:"ZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBJTBBJTBBZXBvY2hzJTIwJTNEJTIwMTAlMEFmb3IlMjBlcG9jaCUyMGluJTIwdHFkbShyYW5nZShlcG9jaHMpJTJDJTIwJTIyZXBvY2glM0ElMjAlMjIpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRxZG0ocHBvX3RyYWluZXIuZGF0YWxvYWRlciklM0ElMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVyeV90ZW5zb3JzJTIwJTNEJTIwYmF0Y2glNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjMlMjMlMjMlMjBHZXQlMjByZXNwb25zZSUyMGZyb20lMjBTRlRNb2RlbCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlX3RlbnNvcnMlMjAlM0QlMjBwcG9fdHJhaW5lci5nZW5lcmF0ZShxdWVyeV90ZW5zb3JzJTJDJTIwKipnZW5lcmF0aW9uX2t3YXJncyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnJlc3BvbnNlJTIyJTVEJTIwJTNEJTIwJTVCdG9rZW5pemVyLmRlY29kZShyLnNxdWVlemUoKSklMjBmb3IlMjByJTIwaW4lMjByZXNwb25zZV90ZW5zb3JzJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIzJTIzJTIwQ29tcHV0ZSUyMHJld2FyZCUyMHNjb3JlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dHMlMjAlM0QlMjAlNUJxJTIwJTJCJTIwciUyMGZvciUyMHElMkMlMjByJTIwaW4lMjB6aXAoYmF0Y2glNUIlMjJxdWVyeSUyMiU1RCUyQyUyMGJhdGNoJTVCJTIycmVzcG9uc2UlMjIlNUQpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGlwZV9vdXRwdXRzJTIwJTNEJTIwcmV3YXJkX21vZGVsKHRleHRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJld2FyZHMlMjAlM0QlMjAlNUJ0b3JjaC50ZW5zb3Iob3V0cHV0JTVCMSU1RCU1QiUyMnNjb3JlJTIyJTVEKSUyMGZvciUyMG91dHB1dCUyMGluJTIwcGlwZV9vdXRwdXRzJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIzJTIzJTIzJTIwUnVuJTIwUFBPJTIwc3RlcCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRzJTIwJTNEJTIwcHBvX3RyYWluZXIuc3RlcChxdWVyeV90ZW5zb3JzJTJDJTIwcmVzcG9uc2VfdGVuc29ycyUyQyUyMHJld2FyZHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHBvX3RyYWluZXIubG9nX3N0YXRzKHN0YXRzJTJDJTIwYmF0Y2glMkMlMjByZXdhcmRzKSUwQSUwQSUyMyUyMyUyMyUyMyUyMFNhdmUlMjBtb2RlbCUwQXBwb190cmFpbmVyLnNhdmVfcHJldHJhaW5lZCglMjJteV9wcG9fbW9kZWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm


epochs = <span class="hljs-number">10</span>
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">range</span>(epochs), <span class="hljs-string">&quot;epoch: &quot;</span>):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> tqdm(ppo_trainer.dataloader): 
        query_tensors = batch[<span class="hljs-string">&quot;input_ids&quot;</span>]
    
        <span class="hljs-comment">#### Get response from SFTModel</span>
        response_tensors = ppo_trainer.generate(query_tensors, **generation_kwargs)
        batch[<span class="hljs-string">&quot;response&quot;</span>] = [tokenizer.decode(r.squeeze()) <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> response_tensors]
    
        <span class="hljs-comment">#### Compute reward score</span>
        texts = [q + r <span class="hljs-keyword">for</span> q, r <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(batch[<span class="hljs-string">&quot;query&quot;</span>], batch[<span class="hljs-string">&quot;response&quot;</span>])]
        pipe_outputs = reward_model(texts)
        rewards = [torch.tensor(output[<span class="hljs-number">1</span>][<span class="hljs-string">&quot;score&quot;</span>]) <span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> pipe_outputs]
    
        <span class="hljs-comment">#### Run PPO step</span>
        stats = ppo_trainer.step(query_tensors, response_tensors, rewards)
        ppo_trainer.log_stats(stats, batch, rewards)

<span class="hljs-comment">#### Save model</span>
ppo_trainer.save_pretrained(<span class="hljs-string">&quot;my_ppo_model&quot;</span>)`,wrap:!1}}),fe=new F({props:{title:"Logging",local:"logging",headingTag:"h2"}}),be=new F({props:{title:"PPOTrainer",local:"trl.PPOTrainer",headingTag:"h2"}}),we=new w({props:{name:"class trl.PPOTrainer",anchor:"trl.PPOTrainer",parameters:[{name:"config",val:": Optional = None"},{name:"model",val:": Optional = None"},{name:"ref_model",val:": Optional = None"},{name:"tokenizer",val:": Optional = None"},{name:"dataset",val:": Union = None"},{name:"optimizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"num_shared_layers",val:": Optional = None"},{name:"lr_scheduler",val:": Optional = None"},{name:"training_data_collator",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>PPOConfig</code>) &#x2014; Configuration object for PPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.PPOTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModelWrapper</code>) &#x2014; Model to be optimized, Hugging Face transformer model with a value head. &#x2014;
Check the documentation of <code>PreTrainedModelWrapper</code> for more details.`,name:"*model**"},{anchor:"trl.PPOTrainer.*ref_model**",description:`*<strong>*ref_model**</strong> (<code>PreTrainedModelWrapper</code>, <em>optional</em>) &#x2014; Reference model to be used for KL penalty, Hugging Face &#x2014;
transformer model with a casual language modelling head. Check the documentation of <code>PreTrainedModelWrapper</code>
for more details. If no reference model is provided, the trainer will create a reference model with the same
architecture as the model to be optimized with shared layers.`,name:"*ref_model**"},{anchor:"trl.PPOTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.PPOTrainer.*dataset**",description:`*<strong>*dataset**</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>], <em>optional</em>) &#x2014; PyTorch dataset or Hugging &#x2014;
Face dataset. This is used to create a PyTorch dataloader. If no dataset is provided, the dataloader must be
created outside the trainer users needs to design their own dataloader and make sure the batch
size that is used is the same as the one specified in the configuration object.`,name:"*dataset**"},{anchor:"trl.PPOTrainer.*optimizer**",description:`*<strong>*optimizer**</strong> (<code>torch.optim.Optimizer</code>, <em>optional</em>) &#x2014; Optimizer to be used for training. If no optimizer is &#x2014;
provided, the trainer will create an Adam optimizer with the learning rate specified in the configuration
object.`,name:"*optimizer**"},{anchor:"trl.PPOTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (DataCollatorForLanguageModeling, <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader`,name:"*data_collator**"},{anchor:"trl.PPOTrainer.*num_shared_layers**",description:`*<strong>*num_shared_layers**</strong> (int, <em>optional</em>) &#x2014; Number of layers to be shared between the model and the reference &#x2014;
model, if no reference model is passed. If no number is provided, all the layers will be shared.`,name:"*num_shared_layers**"},{anchor:"trl.PPOTrainer.*lr_scheduler**",description:"*<strong>*lr_scheduler**</strong> (<code>torch.optim.lr_scheduler</code>, <em>optional</em>) &#x2014; Learning rate scheduler to be used for training. &#x2014;",name:"*lr_scheduler**"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L115"}}),ye=new w({props:{name:"batched_forward_pass",anchor:"trl.PPOTrainer.batched_forward_pass",parameters:[{name:"model",val:": PreTrainedModelWrapper"},{name:"queries",val:": Tensor"},{name:"responses",val:": Tensor"},{name:"model_inputs",val:": dict"},{name:"return_logits",val:": bool = False"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.batched_forward_pass.queries",description:`<strong>queries</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries, shape (<code>batch_size</code>, <code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.batched_forward_pass.responses",description:`<strong>responses</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.batched_forward_pass.return_logits",description:`<strong>return_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return all_logits. Set to <code>False</code> if logits are not needed to reduce memory consumption.`,name:"return_logits"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L976",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>all_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_ref_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_values (<code>torch.FloatTensor</code>): Values of the responses, shape (<code>batch_size</code>, <code>response_length</code>)</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(tuple)</p>
`}}),ve=new w({props:{name:"compute_rewards",anchor:"trl.PPOTrainer.compute_rewards",parameters:[{name:"scores",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"ref_logprobs",val:": FloatTensor"},{name:"masks",val:": LongTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.compute_rewards.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code>) &#x2014;
Scores from the reward model, shape (<code>batch_size</code>)`,name:"scores"},{anchor:"trl.PPOTrainer.compute_rewards.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"},{anchor:"trl.PPOTrainer.compute_rewards.ref_logprobs",description:`<strong>ref_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the reference model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"ref_logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1110",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Per token rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: Non score rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: KL penalty, shape (<code>batch_size</code>, <code>response_length</code>)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),Pe=new w({props:{name:"create_model_card",anchor:"trl.PPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": Optional = 'TRL Model'"}],parametersDescription:[{anchor:"trl.PPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.PPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1418"}}),Me=new w({props:{name:"gather_stats",anchor:"trl.PPOTrainer.gather_stats",parameters:[{name:"stats",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.gather_stats.stats",description:"<strong>stats</strong> (dict[str, Any]) &#x2014;",name:"stats"},{anchor:"trl.PPOTrainer.gather_stats.a",description:"<strong>a</strong> dictionary of stats to be gathered. The stats should contain torch tensors. &#x2014;",name:"a"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L932",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary of stats with the tensors gathered.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Je=new w({props:{name:"generate",anchor:"trl.PPOTrainer.generate",parameters:[{name:"query_tensor",val:": Union"},{name:"length_sampler",val:": Optional = None"},{name:"batch_size",val:": int = 4"},{name:"return_prompt",val:": bool = True"},{name:"generate_ref_response",val:": bool = False"},{name:"**generation_kwargs",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.generate.query_tensor",description:`<strong>query_tensor</strong> (<code>torch.LongTensor</code>) &#x2014;
A tensor of shape (<code>seq_len</code>) containing query tokens or a list of tensors of shape (<code>seq_len</code>).`,name:"query_tensor"},{anchor:"trl.PPOTrainer.generate.length_sampler",description:`<strong>length_sampler</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Callable that returns the number of newly generated tokens.`,name:"length_sampler"},{anchor:"trl.PPOTrainer.generate.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, *optional) &#x2014;
Batch size used for generation, defaults to <code>4</code>.`,name:"batch_size"},{anchor:"trl.PPOTrainer.generate.return_prompt",description:`<strong>return_prompt</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>False</code> the prompt is not returned but only the newly generated tokens, defaults to <code>True</code>.`,name:"return_prompt"},{anchor:"trl.PPOTrainer.generate.generate_ref_response",description:`<strong>generate_ref_response</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code> the reference response is also generated, defaults to <code>False</code>.`,name:"generate_ref_response"},{anchor:"trl.PPOTrainer.generate.generation_kwargs",description:`<strong>generation_kwargs</strong> (dict[str, Any]) &#x2014;
Keyword arguments for generation.`,name:"generation_kwargs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L460",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (<code>batch_size</code>, <code>gen_len</code>) containing response tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code></p>
`}}),xe=new w({props:{name:"log_stats",anchor:"trl.PPOTrainer.log_stats",parameters:[{name:"stats",val:": dict"},{name:"batch",val:": dict"},{name:"rewards",val:": List"},{name:"columns_to_log",val:": Iterable = ('query', 'response')"}],parametersDescription:[{anchor:"trl.PPOTrainer.log_stats.stats",description:`<strong>stats</strong> (dict[str, Any]) &#x2014;
A dictionary of training stats.`,name:"stats"},{anchor:"trl.PPOTrainer.log_stats.batch",description:`<strong>batch</strong> (dict[str, Any]) &#x2014;
A dictionary of batch data, this contains the queries and responses.`,name:"batch"},{anchor:"trl.PPOTrainer.log_stats.rewards",description:`<strong>rewards</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
A tensor of rewards.`,name:"rewards"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1345"}}),Ce=new w({props:{name:"loss",anchor:"trl.PPOTrainer.loss",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.loss.old_logprobs",description:`<strong>old_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"old_logprobs"},{anchor:"trl.PPOTrainer.loss.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"values"},{anchor:"trl.PPOTrainer.loss.rewards",description:`<strong>rewards</strong> (<code>torch.FloatTensor</code>) &#x2014;
Rewards from the reward model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"rewards"},{anchor:"trl.PPOTrainer.loss.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
Logits of the model, shape (<code>batch_size</code>, <code>response_length</code>, <code>vocab_size</code>)`,name:"logits"},{anchor:"trl.PPOTrainer.loss.v_pred",description:`<strong>v_pred</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"v_pred"},{anchor:"trl.PPOTrainer.loss.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1192"}}),$e=new w({props:{name:"prepare_dataloader",anchor:"trl.PPOTrainer.prepare_dataloader",parameters:[{name:"dataset",val:": Union"},{name:"data_collator",val:" = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.prepare_dataloader.dataset",description:`<strong>dataset</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>]) &#x2014;
PyTorch dataset or Hugging Face dataset. If a Hugging Face dataset is passed, the dataset
will be preprocessed by removing the columns that are not used by the model.`,name:"dataset"},{anchor:"trl.PPOTrainer.prepare_dataloader.data_collator",description:`<strong>data_collator</strong> (Optional[function]) &#x2014;
Data collator function.`,name:"data_collator"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L405",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>PyTorch dataloader</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.utils.data.DataLoader</code></p>
`}}),Ie=new w({props:{name:"record_step_stats",anchor:"trl.PPOTrainer.record_step_stats",parameters:[{name:"kl_coef",val:": float"},{name:"**data",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.record_step_stats.kl_coef",description:`<strong>kl_coef</strong> (<code>float</code>) &#x2014;
KL coefficient`,name:"kl_coef"},{anchor:"trl.PPOTrainer.record_step_stats.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
Dictionary of training step data`,name:"data"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1281",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training step statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stats (<code>dict</code>)</p>
`}}),ke=new w({props:{name:"step",anchor:"trl.PPOTrainer.step",parameters:[{name:"queries",val:": List"},{name:"responses",val:": List"},{name:"scores",val:": List"},{name:"response_masks",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.step.queries",description:`<strong>queries</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries of shape (<code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.step.responses",description:`<strong>responses</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses of shape (<code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.step.scores",description:`<strong>scores</strong> (List<code>torch.FloatTensor</code>) &#x2014;
List of tensors containing the scores.`,name:"scores"},{anchor:"trl.PPOTrainer.step.response_masks",description:`<strong>response_masks</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>)) &#x2014;
List of tensors containing masks of the response tokens.`,name:"response_masks"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L652",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Ue=new w({props:{name:"train_minibatch",anchor:"trl.PPOTrainer.train_minibatch",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.train_minibatch.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape [mini_batch_size, response_length]`,name:"logprobs"},{anchor:"trl.PPOTrainer.train_minibatch.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape [mini_batch_size, response_length]`,name:"values"},{anchor:"trl.PPOTrainer.train_minibatch.query",description:`<strong>query</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded queries, shape [mini_batch_size, query_length]`,name:"query"},{anchor:"trl.PPOTrainer.train_minibatch.response",description:`<strong>response</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded responses, shape [mini_batch_size, response_length]`,name:"response"},{anchor:"trl.PPOTrainer.train_minibatch.model_input",description:`<strong>model_input</strong> (<code>torch.LongTensor</code>) &#x2014;
Concatenated queries and responses, shape [mini_batch_size, query_length+response_length]`,name:"model_input"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1064",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>train_stats (dict[str, <code>torch.Tensor</code>])</p>
`}}),je=new w({props:{name:"class trl.PPOConfig",anchor:"trl.PPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"seed",val:": int = 0"},{name:"log_with",val:": Optional = None"},{name:"task_name",val:": Optional = None"},{name:"model_name",val:": str = 'gpt2'"},{name:"query_dataset",val:": str = 'stanfordnlp/imdb'"},{name:"reward_model",val:": str = 'sentiment-analysis:lvwerra/distilbert-imdb'"},{name:"remove_unused_columns",val:": bool = True"},{name:"tracker_kwargs",val:": Annotated = <factory>"},{name:"accelerator_kwargs",val:": Annotated = <factory>"},{name:"project_kwargs",val:": Annotated = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"push_to_hub_if_best_kwargs",val:": Annotated = <factory>"},{name:"steps",val:": int = 20000"},{name:"learning_rate",val:": float = 1.41e-05"},{name:"adap_kl_ctrl",val:": bool = True"},{name:"init_kl_coef",val:": float = 0.2"},{name:"kl_penalty",val:": Literal = 'kl'"},{name:"target",val:": float = 6.0"},{name:"horizon",val:": float = 10000.0"},{name:"gamma",val:": float = 1.0"},{name:"lam",val:": float = 0.95"},{name:"cliprange",val:": float = 0.2"},{name:"cliprange_value",val:": float = 0.2"},{name:"vf_coef",val:": float = 0.1"},{name:"batch_size",val:": int = 128"},{name:"forward_batch_size",val:": Optional = None"},{name:"mini_batch_size",val:": int = 128"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"world_size",val:": Annotated = None"},{name:"ppo_epochs",val:": int = 4"},{name:"max_grad_norm",val:": Optional = None"},{name:"optimize_cuda_cache",val:": Optional = None"},{name:"optimize_device_cache",val:": bool = False"},{name:"early_stopping",val:": bool = False"},{name:"target_kl",val:": float = 1.0"},{name:"compare_steps",val:": int = 1"},{name:"ratio_threshold",val:": float = 10.0"},{name:"use_score_scaling",val:": bool = False"},{name:"use_score_norm",val:": bool = False"},{name:"score_clip",val:": Optional = None"},{name:"whiten_rewards",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"is_peft_model",val:": Optional = None"},{name:"backward_batch_size",val:": Annotated = None"},{name:"global_backward_batch_size",val:": Optional = None"},{name:"global_batch_size",val:": Annotated = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.PPOConfig.exp_name",description:`<strong>exp_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>os.path.basename(__file__)[ -- -len(&quot;.py&quot;)]</code>):
Name of this experiment.`,name:"exp_name"},{anchor:"trl.PPOConfig.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
Random seed.`,name:"seed"},{anchor:"trl.PPOConfig.log_with",description:`<strong>log_with</strong> (<code>Optional[Literal[&quot;wandb&quot;, &quot;tensorboard&quot;]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Log with either <code>&quot;wandb&quot;</code> or <code>&quot;tensorboard&quot;</code>. Check
<a href="https://huggingface.co/docs/accelerate/usage_guides/tracking" rel="nofollow">tracking</a> for more details.`,name:"log_with"},{anchor:"trl.PPOConfig.task_name",description:`<strong>task_name</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of task to use - used only for tracking purposes.`,name:"task_name"},{anchor:"trl.PPOConfig.model_name",description:`<strong>model_name</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>&quot;gpt2&quot;</code>) &#x2014;
Name of model to use - used only for tracking purposes.`,name:"model_name"},{anchor:"trl.PPOConfig.query_dataset",description:`<strong>query_dataset</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>&quot;imdb&quot;</code>) &#x2014;
Name of dataset to query - used only for tracking purposes.`,name:"query_dataset"},{anchor:"trl.PPOConfig.reward_model",description:`<strong>reward_model</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>&quot;sentiment-analysis --lvwerra/distilbert-imdb&quot;</code>):
Reward model to use - used only for tracking purposes.`,name:"reward_model"},{anchor:"trl.PPOConfig.remove_unused_columns",description:`<strong>remove_unused_columns</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Remove unused columns from the dataset.`,name:"remove_unused_columns"},{anchor:"trl.PPOConfig.tracker_kwargs",description:`<strong>tracker_kwargs</strong> (<code>JSONDict</code>, <em>optional</em>, defaults to <code>{}</code>) &#x2014;
Keyword arguments for the tracker (e.g. <code>python ppo.py --tracker_kwargs=&apos;{&quot;wandb&quot;: {&quot;entity&quot;: &quot;my_wandb_entity&quot;, &quot;name&quot;: &quot;my_exp_name&quot;}&#x200C;}&apos;</code>.`,name:"tracker_kwargs"},{anchor:"trl.PPOConfig.accelerator_kwargs",description:`<strong>accelerator_kwargs</strong> (<code>JSONDict</code>, <em>optional</em>, defaults to <code>{}</code>) &#x2014;
Keyword arguments for the accelerator.`,name:"accelerator_kwargs"},{anchor:"trl.PPOConfig.project_kwargs",description:`<strong>project_kwargs</strong> (<code>JSONDict</code>, <em>optional</em>, defaults to <code>{}</code>) &#x2014;
Keyword arguments for the accelerator project config (e.g. <code>logging_dir</code>).`,name:"project_kwargs"},{anchor:"trl.PPOConfig.tracker_project_name",description:`<strong>tracker_project_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;trl&quot;</code>) &#x2014;
Name of project to use for tracking.`,name:"tracker_project_name"},{anchor:"trl.PPOConfig.push_to_hub_if_best_kwargs",description:`<strong>push_to_hub_if_best_kwargs</strong> (<code>JSONDict</code>, <em>optional</em>, defaults to <code>{}</code>) &#x2014;
Keyword arguments for pushing model to the hub during training (e.g. repo_id).`,name:"push_to_hub_if_best_kwargs"},{anchor:"trl.PPOConfig.steps",description:`<strong>steps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>20000</code>) &#x2014;
Number of training steps.`,name:"steps"},{anchor:"trl.PPOConfig.learning_rate",description:`<strong>learning_rate</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.41e-5</code>) &#x2014;
Learning rate for the optimizer.`,name:"learning_rate"},{anchor:"trl.PPOConfig.adap_kl_ctrl",description:`<strong>adap_kl_ctrl</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Use adaptive KL control, otherwise linear.`,name:"adap_kl_ctrl"},{anchor:"trl.PPOConfig.init_kl_coef",description:`<strong>init_kl_coef</strong> (<code>Optional[float]</code>, <em>optional</em>, defaults to <code>0.2</code>) &#x2014;
Initial KL penalty coefficient (used for adaptive and linear control).`,name:"init_kl_coef"},{anchor:"trl.PPOConfig.kl_penalty",description:`<strong>kl_penalty</strong> (<code>Literal[&quot;kl&quot;, &quot;abs&quot;, &quot;mse&quot;, &quot;full&quot;]</code>, <em>optional</em>, defaults to <code>&quot;kl&quot;</code>) &#x2014;
kl penalty options. Possible values are:</p>
<ul>
<li><code>&quot;kl&quot;</code>: model_logp - ref_logp</li>
<li><code>&quot;abs&quot;</code>: abs(kl)</li>
<li><code>&quot;mse&quot;</code>: mean squared error mse(kl)</li>
<li><code>&quot;full&quot;</code>: the actual kl for all tokens in the distribution.</li>
</ul>`,name:"kl_penalty"},{anchor:"trl.PPOConfig.target",description:`<strong>target</strong> (<code>float</code>, <em>optional</em>, defaults to <code>6.0</code>) &#x2014;
Target KL value for adaptive KL control.`,name:"target"},{anchor:"trl.PPOConfig.horizon",description:`<strong>horizon</strong> (<code>float</code>, <em>optional</em>, defaults to <code>10000.0</code>) &#x2014;
Horizon for adaptive KL control.`,name:"horizon"},{anchor:"trl.PPOConfig.gamma",description:`<strong>gamma</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
Gamma parameter for advantage calculation.`,name:"gamma"},{anchor:"trl.PPOConfig.lam",description:`<strong>lam</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.95</code>) &#x2014;
Lambda parameter for advantage calculation.`,name:"lam"},{anchor:"trl.PPOConfig.cliprange",description:`<strong>cliprange</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.2</code>) &#x2014;
Range for clipping in PPO policy gradient loss.`,name:"cliprange"},{anchor:"trl.PPOConfig.cliprange_value",description:`<strong>cliprange_value</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.2</code>) &#x2014;
Range for clipping values in loss calculation.`,name:"cliprange_value"},{anchor:"trl.PPOConfig.vf_coef",description:`<strong>vf_coef</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.1</code>) &#x2014;
Scaling factor for value loss.`,name:"vf_coef"},{anchor:"trl.PPOConfig.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>128</code>) &#x2014;
Number of samples per optimisation step.`,name:"batch_size"},{anchor:"trl.PPOConfig.forward_batch_size",description:`<strong>forward_batch_size</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
DEPRECATED: use <code>mini_batch_size</code> instead, which does the same thing.`,name:"forward_batch_size"},{anchor:"trl.PPOConfig.mini_batch_size",description:`<strong>mini_batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>128</code>) &#x2014;
Number of samples optimized in each mini batch.`,name:"mini_batch_size"},{anchor:"trl.PPOConfig.gradient_accumulation_steps",description:`<strong>gradient_accumulation_steps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Number of gradient accumulation steps.`,name:"gradient_accumulation_steps"},{anchor:"trl.PPOConfig.world_size",description:`<strong>world_size</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes to use for distributed training.`,name:"world_size"},{anchor:"trl.PPOConfig.ppo_epochs",description:`<strong>ppo_epochs</strong> (<code>int</code>, <em>optional</em>, defaults to <code>4</code>) &#x2014;
Number of optimisation epochs per batch of samples.`,name:"ppo_epochs"},{anchor:"trl.PPOConfig.optimize_device_cache",description:`<strong>optimize_device_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Optimize device cache for slightly more memory-efficient training.`,name:"optimize_device_cache"},{anchor:"trl.PPOConfig.early_stopping",description:`<strong>early_stopping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to stop the PPO optimization loop early is the KL too high.`,name:"early_stopping"},{anchor:"trl.PPOConfig.target_kl",description:`<strong>target_kl</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
Stop early if we exceed this value by over 50%.`,name:"target_kl"},{anchor:"trl.PPOConfig.compare_steps",description:`<strong>compare_steps</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Compare the current step with the previous <code>compare_steps</code> steps.`,name:"compare_steps"},{anchor:"trl.PPOConfig.ratio_threshold",description:`<strong>ratio_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to <code>10.0</code>) &#x2014;
Skip mini-batches with high PPO ratios that can cause loss spikes.`,name:"ratio_threshold"},{anchor:"trl.PPOConfig.use_score_scaling",description:`<strong>use_score_scaling</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Use score scaling.`,name:"use_score_scaling"},{anchor:"trl.PPOConfig.use_score_norm",description:`<strong>use_score_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Use score normalization. Only applicable if <code>use_score_scaling</code> is True.`,name:"use_score_norm"},{anchor:"trl.PPOConfig.score_clip",description:`<strong>score_clip</strong> (<code>Optional[float]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Score clipping.`,name:"score_clip"},{anchor:"trl.PPOConfig.whiten_rewards",description:`<strong>whiten_rewards</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whiten the rewards before computing advantages.`,name:"whiten_rewards"},{anchor:"trl.PPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
When using the <code>model_init</code> argument (callable) to instantiate the model instead of the <code>model</code> argument,
you need to specify if the model returned by the callable is an encoder-decoder model.`,name:"is_encoder_decoder"},{anchor:"trl.PPOConfig.is_peft_model",description:`<strong>is_peft_model</strong> (<code>Optional[bool]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether the model is a PEFT model.`,name:"is_peft_model"},{anchor:"trl.PPOConfig.backward_batch_size",description:`<strong>backward_batch_size</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of samples optimized in an <code>optimizer.step()</code> call.`,name:"backward_batch_size"},{anchor:"trl.PPOConfig.global_backward_batch_size",description:`<strong>global_backward_batch_size</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Effective <code>backward_batch_size</code> across all processes.`,name:"global_backward_batch_size"},{anchor:"trl.PPOConfig.global_batch_size",description:`<strong>global_batch_size</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Effective <code>batch_size</code> across all processes.`,name:"global_batch_size"},{anchor:"trl.PPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes to use for processing the dataset.`,name:"dataset_num_proc"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_config.py#L34"}}),Oe=new hn({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/ppo_trainer.mdx"}}),{c(){v=s("meta"),De=n(),Se=s("p"),Ye=n(),p(Z.$$.fragment),Ke=n(),B=s("p"),B.innerHTML=Jo,et=n(),L=s("p"),L.innerHTML=xo,tt=n(),p(N.$$.fragment),ot=n(),H=s("p"),H.textContent=Co,nt=n(),W=s("ol"),W.innerHTML=$o,at=n(),G=s("p"),G.textContent=Io,rt=n(),M=s("div"),M.innerHTML=ko,st=n(),p(R.$$.fragment),lt=n(),V=s("p"),V.innerHTML=Uo,it=n(),A=s("p"),A.innerHTML=jo,dt=n(),E=s("p"),E.innerHTML=Oo,ct=n(),p(X.$$.fragment),pt=n(),S=s("p"),S.textContent=zo,mt=n(),p(Q.$$.fragment),gt=n(),p(D.$$.fragment),ht=n(),Y=s("p"),Y.innerHTML=qo,ut=n(),p(K.$$.fragment),ft=n(),ee=s("p"),ee.innerHTML=Fo,_t=n(),p(te.$$.fragment),Tt=n(),oe=s("p"),oe.textContent=Zo,bt=n(),p(ne.$$.fragment),wt=n(),ae=s("p"),ae.innerHTML=Bo,yt=n(),p(re.$$.fragment),vt=n(),se=s("p"),se.innerHTML=Lo,Pt=n(),p(le.$$.fragment),Mt=n(),ie=s("p"),ie.innerHTML=No,Jt=n(),p(de.$$.fragment),xt=n(),p(ce.$$.fragment),Ct=n(),pe=s("p"),pe.innerHTML=Ho,$t=n(),me=s("p"),me.innerHTML=Wo,It=n(),p(ge.$$.fragment),kt=n(),he=s("p"),he.innerHTML=Go,Ut=n(),p(ue.$$.fragment),jt=n(),p(fe.$$.fragment),Ot=n(),_e=s("p"),_e.textContent=Ro,zt=n(),Te=s("ul"),Te.innerHTML=Vo,qt=n(),p(be.$$.fragment),Ft=n(),c=s("div"),p(we.$$.fragment),Yt=n(),ze=s("p"),ze.innerHTML=Ao,Kt=n(),J=s("div"),p(ye.$$.fragment),eo=n(),qe=s("p"),qe.textContent=Eo,to=n(),x=s("div"),p(ve.$$.fragment),oo=n(),Fe=s("p"),Fe.textContent=Xo,no=n(),C=s("div"),p(Pe.$$.fragment),ao=n(),Ze=s("p"),Ze.textContent=So,ro=n(),$=s("div"),p(Me.$$.fragment),so=n(),Be=s("p"),Be.textContent=Qo,lo=n(),I=s("div"),p(Je.$$.fragment),io=n(),Le=s("p"),Le.innerHTML=Do,co=n(),k=s("div"),p(xe.$$.fragment),po=n(),Ne=s("p"),Ne.textContent=Yo,mo=n(),U=s("div"),p(Ce.$$.fragment),go=n(),He=s("p"),He.textContent=Ko,ho=n(),j=s("div"),p($e.$$.fragment),uo=n(),We=s("p"),We.textContent=en,fo=n(),O=s("div"),p(Ie.$$.fragment),_o=n(),Ge=s("p"),Ge.textContent=tn,To=n(),z=s("div"),p(ke.$$.fragment),bo=n(),Re=s("p"),Re.textContent=on,wo=n(),q=s("div"),p(Ue.$$.fragment),yo=n(),Ve=s("p"),Ve.textContent=nn,Zt=n(),y=s("div"),p(je.$$.fragment),vo=n(),Ae=s("p"),Ae.innerHTML=an,Po=n(),Ee=s("p"),Ee.innerHTML=rn,Bt=n(),p(Oe.$$.fragment),Lt=n(),Qe=s("p"),this.h()},l(e){const t=mn("svelte-u9bgzb",document.head);v=l(t,"META",{name:!0,content:!0}),t.forEach(o),De=a(e),Se=l(e,"P",{}),T(Se).forEach(o),Ye=a(e),m(Z.$$.fragment,e),Ke=a(e),B=l(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-l12a2w"&&(B.innerHTML=Jo),et=a(e),L=l(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1c2evbn"&&(L.innerHTML=xo),tt=a(e),m(N.$$.fragment,e),ot=a(e),H=l(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-79li59"&&(H.textContent=Co),nt=a(e),W=l(e,"OL",{"data-svelte-h":!0}),d(W)!=="svelte-19gvbbs"&&(W.innerHTML=$o),at=a(e),G=l(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-11407q1"&&(G.textContent=Io),rt=a(e),M=l(e,"DIV",{style:!0,"data-svelte-h":!0}),d(M)!=="svelte-7jo56"&&(M.innerHTML=ko),st=a(e),m(R.$$.fragment,e),lt=a(e),V=l(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-r47fon"&&(V.innerHTML=Uo),it=a(e),A=l(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-nw9p0e"&&(A.innerHTML=jo),dt=a(e),E=l(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-ew3j45"&&(E.innerHTML=Oo),ct=a(e),m(X.$$.fragment,e),pt=a(e),S=l(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-1lutirw"&&(S.textContent=zo),mt=a(e),m(Q.$$.fragment,e),gt=a(e),m(D.$$.fragment,e),ht=a(e),Y=l(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-kuth75"&&(Y.innerHTML=qo),ut=a(e),m(K.$$.fragment,e),ft=a(e),ee=l(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-15i9f61"&&(ee.innerHTML=Fo),_t=a(e),m(te.$$.fragment,e),Tt=a(e),oe=l(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-ft92fq"&&(oe.textContent=Zo),bt=a(e),m(ne.$$.fragment,e),wt=a(e),ae=l(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-5saaij"&&(ae.innerHTML=Bo),yt=a(e),m(re.$$.fragment,e),vt=a(e),se=l(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-1tdshp6"&&(se.innerHTML=Lo),Pt=a(e),m(le.$$.fragment,e),Mt=a(e),ie=l(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1dqo05b"&&(ie.innerHTML=No),Jt=a(e),m(de.$$.fragment,e),xt=a(e),m(ce.$$.fragment,e),Ct=a(e),pe=l(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1gfcgdl"&&(pe.innerHTML=Ho),$t=a(e),me=l(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-xqje4x"&&(me.innerHTML=Wo),It=a(e),m(ge.$$.fragment,e),kt=a(e),he=l(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-jd50df"&&(he.innerHTML=Go),Ut=a(e),m(ue.$$.fragment,e),jt=a(e),m(fe.$$.fragment,e),Ot=a(e),_e=l(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-1jybr47"&&(_e.textContent=Ro),zt=a(e),Te=l(e,"UL",{"data-svelte-h":!0}),d(Te)!=="svelte-1qs2o7q"&&(Te.innerHTML=Vo),qt=a(e),m(be.$$.fragment,e),Ft=a(e),c=l(e,"DIV",{class:!0});var _=T(c);m(we.$$.fragment,_),Yt=a(_),ze=l(_,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-hys9rl"&&(ze.innerHTML=Ao),Kt=a(_),J=l(_,"DIV",{class:!0});var Ht=T(J);m(ye.$$.fragment,Ht),eo=a(Ht),qe=l(Ht,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-185nst0"&&(qe.textContent=Eo),Ht.forEach(o),to=a(_),x=l(_,"DIV",{class:!0});var Wt=T(x);m(ve.$$.fragment,Wt),oo=a(Wt),Fe=l(Wt,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-3nt516"&&(Fe.textContent=Xo),Wt.forEach(o),no=a(_),C=l(_,"DIV",{class:!0});var Gt=T(C);m(Pe.$$.fragment,Gt),ao=a(Gt),Ze=l(Gt,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-3jfrz9"&&(Ze.textContent=So),Gt.forEach(o),ro=a(_),$=l(_,"DIV",{class:!0});var Rt=T($);m(Me.$$.fragment,Rt),so=a(Rt),Be=l(Rt,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-lcc1u3"&&(Be.textContent=Qo),Rt.forEach(o),lo=a(_),I=l(_,"DIV",{class:!0});var Vt=T(I);m(Je.$$.fragment,Vt),io=a(Vt),Le=l(Vt,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-1gqqzmu"&&(Le.innerHTML=Do),Vt.forEach(o),co=a(_),k=l(_,"DIV",{class:!0});var At=T(k);m(xe.$$.fragment,At),po=a(At),Ne=l(At,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-ffqz5"&&(Ne.textContent=Yo),At.forEach(o),mo=a(_),U=l(_,"DIV",{class:!0});var Et=T(U);m(Ce.$$.fragment,Et),go=a(Et),He=l(Et,"P",{"data-svelte-h":!0}),d(He)!=="svelte-febvhf"&&(He.textContent=Ko),Et.forEach(o),ho=a(_),j=l(_,"DIV",{class:!0});var Xt=T(j);m($e.$$.fragment,Xt),uo=a(Xt),We=l(Xt,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1hbodkw"&&(We.textContent=en),Xt.forEach(o),fo=a(_),O=l(_,"DIV",{class:!0});var St=T(O);m(Ie.$$.fragment,St),_o=a(St),Ge=l(St,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-1hfgx92"&&(Ge.textContent=tn),St.forEach(o),To=a(_),z=l(_,"DIV",{class:!0});var Qt=T(z);m(ke.$$.fragment,Qt),bo=a(Qt),Re=l(Qt,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-yrsdu6"&&(Re.textContent=on),Qt.forEach(o),wo=a(_),q=l(_,"DIV",{class:!0});var Dt=T(q);m(Ue.$$.fragment,Dt),yo=a(Dt),Ve=l(Dt,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-3k7k5e"&&(Ve.textContent=nn),Dt.forEach(o),_.forEach(o),Zt=a(e),y=l(e,"DIV",{class:!0});var Xe=T(y);m(je.$$.fragment,Xe),vo=a(Xe),Ae=l(Xe,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1s1x0if"&&(Ae.innerHTML=an),Po=a(Xe),Ee=l(Xe,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-ekuf1t"&&(Ee.innerHTML=rn),Xe.forEach(o),Bt=a(e),m(Oe.$$.fragment,e),Lt=a(e),Qe=l(e,"P",{}),T(Qe).forEach(o),this.h()},h(){b(v,"name","hf:doc:metadata"),b(v,"content",fn),gn(M,"text-align","center"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,v),r(e,De,t),r(e,Se,t),r(e,Ye,t),g(Z,e,t),r(e,Ke,t),r(e,B,t),r(e,et,t),r(e,L,t),r(e,tt,t),g(N,e,t),r(e,ot,t),r(e,H,t),r(e,nt,t),r(e,W,t),r(e,at,t),r(e,G,t),r(e,rt,t),r(e,M,t),r(e,st,t),g(R,e,t),r(e,lt,t),r(e,V,t),r(e,it,t),r(e,A,t),r(e,dt,t),r(e,E,t),r(e,ct,t),g(X,e,t),r(e,pt,t),r(e,S,t),r(e,mt,t),g(Q,e,t),r(e,gt,t),g(D,e,t),r(e,ht,t),r(e,Y,t),r(e,ut,t),g(K,e,t),r(e,ft,t),r(e,ee,t),r(e,_t,t),g(te,e,t),r(e,Tt,t),r(e,oe,t),r(e,bt,t),g(ne,e,t),r(e,wt,t),r(e,ae,t),r(e,yt,t),g(re,e,t),r(e,vt,t),r(e,se,t),r(e,Pt,t),g(le,e,t),r(e,Mt,t),r(e,ie,t),r(e,Jt,t),g(de,e,t),r(e,xt,t),g(ce,e,t),r(e,Ct,t),r(e,pe,t),r(e,$t,t),r(e,me,t),r(e,It,t),g(ge,e,t),r(e,kt,t),r(e,he,t),r(e,Ut,t),g(ue,e,t),r(e,jt,t),g(fe,e,t),r(e,Ot,t),r(e,_e,t),r(e,zt,t),r(e,Te,t),r(e,qt,t),g(be,e,t),r(e,Ft,t),r(e,c,t),g(we,c,null),i(c,Yt),i(c,ze),i(c,Kt),i(c,J),g(ye,J,null),i(J,eo),i(J,qe),i(c,to),i(c,x),g(ve,x,null),i(x,oo),i(x,Fe),i(c,no),i(c,C),g(Pe,C,null),i(C,ao),i(C,Ze),i(c,ro),i(c,$),g(Me,$,null),i($,so),i($,Be),i(c,lo),i(c,I),g(Je,I,null),i(I,io),i(I,Le),i(c,co),i(c,k),g(xe,k,null),i(k,po),i(k,Ne),i(c,mo),i(c,U),g(Ce,U,null),i(U,go),i(U,He),i(c,ho),i(c,j),g($e,j,null),i(j,uo),i(j,We),i(c,fo),i(c,O),g(Ie,O,null),i(O,_o),i(O,Ge),i(c,To),i(c,z),g(ke,z,null),i(z,bo),i(z,Re),i(c,wo),i(c,q),g(Ue,q,null),i(q,yo),i(q,Ve),r(e,Zt,t),r(e,y,t),g(je,y,null),i(y,vo),i(y,Ae),i(y,Po),i(y,Ee),r(e,Bt,t),g(Oe,e,t),r(e,Lt,t),r(e,Qe,t),Nt=!0},p:ln,i(e){Nt||(h(Z.$$.fragment,e),h(N.$$.fragment,e),h(R.$$.fragment,e),h(X.$$.fragment,e),h(Q.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(re.$$.fragment,e),h(le.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(ge.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(be.$$.fragment,e),h(we.$$.fragment,e),h(ye.$$.fragment,e),h(ve.$$.fragment,e),h(Pe.$$.fragment,e),h(Me.$$.fragment,e),h(Je.$$.fragment,e),h(xe.$$.fragment,e),h(Ce.$$.fragment,e),h($e.$$.fragment,e),h(Ie.$$.fragment,e),h(ke.$$.fragment,e),h(Ue.$$.fragment,e),h(je.$$.fragment,e),h(Oe.$$.fragment,e),Nt=!0)},o(e){u(Z.$$.fragment,e),u(N.$$.fragment,e),u(R.$$.fragment,e),u(X.$$.fragment,e),u(Q.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(re.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(ge.$$.fragment,e),u(ue.$$.fragment,e),u(fe.$$.fragment,e),u(be.$$.fragment,e),u(we.$$.fragment,e),u(ye.$$.fragment,e),u(ve.$$.fragment,e),u(Pe.$$.fragment,e),u(Me.$$.fragment,e),u(Je.$$.fragment,e),u(xe.$$.fragment,e),u(Ce.$$.fragment,e),u($e.$$.fragment,e),u(Ie.$$.fragment,e),u(ke.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),u(Oe.$$.fragment,e),Nt=!1},d(e){e&&(o(De),o(Se),o(Ye),o(Ke),o(B),o(et),o(L),o(tt),o(ot),o(H),o(nt),o(W),o(at),o(G),o(rt),o(M),o(st),o(lt),o(V),o(it),o(A),o(dt),o(E),o(ct),o(pt),o(S),o(mt),o(gt),o(ht),o(Y),o(ut),o(ft),o(ee),o(_t),o(Tt),o(oe),o(bt),o(wt),o(ae),o(yt),o(vt),o(se),o(Pt),o(Mt),o(ie),o(Jt),o(xt),o(Ct),o(pe),o($t),o(me),o(It),o(kt),o(he),o(Ut),o(jt),o(Ot),o(_e),o(zt),o(Te),o(qt),o(Ft),o(c),o(Zt),o(y),o(Bt),o(Lt),o(Qe)),o(v),f(Z,e),f(N,e),f(R,e),f(X,e),f(Q,e),f(D,e),f(K,e),f(te,e),f(ne,e),f(re,e),f(le,e),f(de,e),f(ce,e),f(ge,e),f(ue,e),f(fe,e),f(be,e),f(we),f(ye),f(ve),f(Pe),f(Me),f(Je),f(xe),f(Ce),f($e),f(Ie),f(ke),f(Ue),f(je),f(Oe,e)}}}const fn='{"title":"PPO Trainer","local":"ppo-trainer","sections":[{"title":"How PPO works","local":"how-ppo-works","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Using the PPOTrainer","local":"using-the-ppotrainer","sections":[{"title":"Initializing the PPOTrainer","local":"initializing-the-ppotrainer","sections":[],"depth":3},{"title":"Starting the training loop","local":"starting-the-training-loop","sections":[],"depth":3}],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"PPOTrainer","local":"trl.PPOTrainer","sections":[],"depth":2}],"depth":1}';function _n(Mo){return dn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pn extends cn{constructor(v){super(),pn(this,v,_n,un,sn,{})}}export{Pn as component};
