import{s as Js,o as js,n as vs}from"../chunks/scheduler.25b97de1.js";import{S as $s,i as xs,g as o,s as a,r as d,m as Ms,A as Us,h as r,f as n,c as l,j as I,u as m,x as p,n as Ts,k as C,l as zs,y as i,a as s,v as u,d as g,t as h,w as f}from"../chunks/index.d9030fc9.js";import{D as We}from"../chunks/Docstring.ffac8efa.js";import{C as Z}from"../chunks/CodeBlock.e6cd0d95.js";import{E as ws}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as $,E as qs}from"../chunks/EditOnGithub.91d95064.js";function Ns(Ve){let b,z="Examples:",w,_,M;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME5sbGJUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBObGxiVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbmdfTGF0biUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJhX0xhdG4lMjIlMEEpJTBBZXhhbXBsZV9lbmdsaXNoX3BocmFzZSUyMCUzRCUyMCUyMiUyMFVOJTIwQ2hpZWYlMjBTYXlzJTIwVGhlcmUlMjBJcyUyME5vJTIwTWlsaXRhcnklMjBTb2x1dGlvbiUyMGluJTIwU3lyaWElMjIlMEFleHBlY3RlZF90cmFuc2xhdGlvbl9mcmVuY2glMjAlM0QlMjAlMjJMZSUyMGNoZWYlMjBkZSUyMGwnT05VJTIwYWZmaXJtZSUyMHF1J2lsJTIwbid5JTIwYSUyMHBhcyUyMGRlJTIwc29sdXRpb24lMjBtaWxpdGFpcmUlMjBlbiUyMFN5cmllLiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihleGFtcGxlX2VuZ2xpc2hfcGhyYXNlJTJDJTIwdGV4dF90YXJnZXQlM0RleHBlY3RlZF90cmFuc2xhdGlvbl9mcmVuY2glMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> NllbTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = NllbTokenizer.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>, src_lang=<span class="hljs-string">&quot;eng_Latn&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fra_Latn&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>example_english_phrase = <span class="hljs-string">&quot; UN Chief Says There Is No Military Solution in Syria&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>expected_translation_french = <span class="hljs-string">&quot;Le chef de l&#x27;ONU affirme qu&#x27;il n&#x27;y a pas de solution militaire en Syrie.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(example_english_phrase, text_target=expected_translation_french, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),{c(){b=o("p"),b.textContent=z,w=a(),d(_.$$.fragment)},l(c){b=r(c,"P",{"data-svelte-h":!0}),p(b)!=="svelte-kvfsh7"&&(b.textContent=z),w=l(c),m(_.$$.fragment,c)},m(c,v){s(c,b,v),s(c,w,v),u(_,c,v),M=!0},p:vs,i(c){M||(g(_.$$.fragment,c),M=!0)},o(c){h(_.$$.fragment,c),M=!1},d(c){c&&(n(b),n(w)),f(_,c)}}}function Gs(Ve){let b,z="Examples:",w,_,M;return _=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME5sbGJUb2tlbml6ZXJGYXN0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwTmxsYlRva2VuaXplckZhc3QuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGbmxsYi0yMDAtZGlzdGlsbGVkLTYwME0lMjIlMkMlMjBzcmNfbGFuZyUzRCUyMmVuZ19MYXRuJTIyJTJDJTIwdGd0X2xhbmclM0QlMjJmcmFfTGF0biUyMiUwQSklMEFleGFtcGxlX2VuZ2xpc2hfcGhyYXNlJTIwJTNEJTIwJTIyJTIwVU4lMjBDaGllZiUyMFNheXMlMjBUaGVyZSUyMElzJTIwTm8lMjBNaWxpdGFyeSUyMFNvbHV0aW9uJTIwaW4lMjBTeXJpYSUyMiUwQWV4cGVjdGVkX3RyYW5zbGF0aW9uX2ZyZW5jaCUyMCUzRCUyMCUyMkxlJTIwY2hlZiUyMGRlJTIwbCdPTlUlMjBhZmZpcm1lJTIwcXUnaWwlMjBuJ3klMjBhJTIwcGFzJTIwZGUlMjBzb2x1dGlvbiUyMG1pbGl0YWlyZSUyMGVuJTIwU3lyaWUuJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGV4YW1wbGVfZW5nbGlzaF9waHJhc2UlMkMlMjB0ZXh0X3RhcmdldCUzRGV4cGVjdGVkX3RyYW5zbGF0aW9uX2ZyZW5jaCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> NllbTokenizerFast

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = NllbTokenizerFast.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>, src_lang=<span class="hljs-string">&quot;eng_Latn&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fra_Latn&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>example_english_phrase = <span class="hljs-string">&quot; UN Chief Says There Is No Military Solution in Syria&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>expected_translation_french = <span class="hljs-string">&quot;Le chef de l&#x27;ONU affirme qu&#x27;il n&#x27;y a pas de solution militaire en Syrie.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(example_english_phrase, text_target=expected_translation_french, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),{c(){b=o("p"),b.textContent=z,w=a(),d(_.$$.fragment)},l(c){b=r(c,"P",{"data-svelte-h":!0}),p(b)!=="svelte-kvfsh7"&&(b.textContent=z),w=l(c),m(_.$$.fragment,c)},m(c,v){s(c,b,v),s(c,w,v),u(_,c,v),M=!0},p:vs,i(c){M||(g(_.$$.fragment,c),M=!0)},o(c){h(_.$$.fragment,c),M=!1},d(c){c&&(n(b),n(w)),f(_,c)}}}function Zs(Ve){let b,z,w,_,M,c,v,it,F,qn=`<strong>DISCLAIMER:</strong> The default behaviour for the tokenizer was fixed and thus changed in April 2023.
The previous version adds <code>[self.eos_token_id, self.cur_lang_code]</code> at the end of the token sequence for both target and source tokenization. This is wrong as the NLLB paper mentions (page 48, 6.1.1. Model Architecture) :`,pt,B,Nn=`<em>Note that we prefix the source sequence with the source language, as opposed to the target
language as previously done in several works (Arivazhagan et al., 2019; Johnson et al.,
2017). This is primarily because we prioritize optimizing zero-shot performance of our
model on any pair of 200 languages at a minor cost to supervised performance.</em>`,ct,X,Gn="Previous behaviour:",dt,H,mt,E,Zn="New behaviour",ut,S,gt,A,In="Enabling the old behaviour can be done as follows:",ht,Y,ft,D,Cn='For more details, feel free to check the linked <a href="https://github.com/huggingface/transformers/pull/22313" rel="nofollow">PR</a> and <a href="https://github.com/huggingface/transformers/issues/19943" rel="nofollow">Issue</a>.',bt,P,kt,Q,Ln=`The NLLB model was presented in <a href="https://arxiv.org/abs/2207.04672" rel="nofollow">No Language Left Behind: Scaling Human-Centered Machine Translation</a> by Marta R. Costa-jussà, James Cross, Onur Çelebi,
Maha Elbayad, Kenneth Heafield, Kevin Heffernan, Elahe Kalbassi, Janice Lam, Daniel Licht, Jean Maillard, Anna Sun, Skyler Wang, Guillaume Wenzek, Al Youngblood, Bapi Akula,
Loic Barrault, Gabriel Mejia Gonzalez, Prangthip Hansanti, John Hoffman, Semarley Jarrett, Kaushik Ram Sadagopan, Dirk Rowe, Shannon Spruit, Chau Tran, Pierre Andrews,
Necip Fazil Ayan, Shruti Bhosale, Sergey Edunov, Angela Fan, Cynthia Gao, Vedanuj Goswami, Francisco Guzmán, Philipp Koehn, Alexandre Mourachko, Christophe Ropers,
Safiyyah Saleem, Holger Schwenk, and Jeff Wang.`,_t,K,Rn="The abstract of the paper is the following:",yt,O,Wn=`<em>Driven by the goal of eradicating language barriers on a global scale, machine translation has solidified itself as a key focus of artificial intelligence research today.
However, such efforts have coalesced around a small subset of languages, leaving behind the vast majority of mostly low-resource languages. What does it take to break the
200 language barrier while ensuring safe, high quality results, all while keeping ethical considerations in mind? In No Language Left Behind, we took on this challenge by
first contextualizing the need for low-resource language translation support through exploratory interviews with native speakers. Then, we created datasets and models aimed
at narrowing the performance gap between low and high-resource languages. More specifically, we developed a conditional compute model based on Sparsely Gated Mixture of
Experts that is trained on data obtained with novel and effective data mining techniques tailored for low-resource languages. We propose multiple architectural and training
improvements to counteract overfitting while training on thousands of tasks. Critically, we evaluated the performance of over 40,000 different translation directions using
a human-translated benchmark, Flores-200, and combined human evaluation with a novel toxicity benchmark covering all languages in Flores-200 to assess translation safety.
Our model achieves an improvement of 44% BLEU relative to the previous state-of-the-art, laying important groundwork towards realizing a universal translation system.</em>`,Mt,ee,Vn="This implementation contains the dense models available on release.",Tt,te,Fn='<strong>The sparse model NLLB-MoE (Mixture of Expert) is now available! More details <a href="nllb-moe">here</a></strong>',wt,ne,Bn='This model was contributed by <a href="https://huggingface.co/lysandre" rel="nofollow">Lysandre</a>. The authors’ code can be found <a href="https://github.com/facebookresearch/fairseq/tree/nllb" rel="nofollow">here</a>.',vt,se,Jt,ae,Xn=`While generating the target text set the <code>forced_bos_token_id</code> to the target language id. The following
example shows how to translate English to French using the <em>facebook/nllb-200-distilled-600M</em> model.`,jt,le,Hn=`Note that we’re using the BCP-47 code for French <code>fra_Latn</code>. See <a href="https://github.com/facebookresearch/flores/blob/main/flores200/README.md#languages-in-flores-200" rel="nofollow">here</a>
for the list of all BCP-47 in the Flores 200 dataset.`,$t,oe,xt,re,Ut,ie,En=`English (<code>eng_Latn</code>) is set as the default language from which to translate. In order to specify that you’d like to translate from a different language,
you should specify the BCP-47 code in the <code>src_lang</code> keyword argument of the tokenizer initialization.`,zt,pe,Sn="See example below for a translation from romanian to german:",qt,ce,Nt,de,Gt,me,An='<li><a href="../tasks/translation">Translation task guide</a></li> <li><a href="../tasks/summarization">Summarization task guide</a></li>',Zt,ue,It,T,ge,ln,Fe,Yn="Construct an NLLB tokenizer.",on,Be,Dn=`Adapted from <a href="/docs/transformers/pr_29886/en/model_doc/roberta#transformers.RobertaTokenizer">RobertaTokenizer</a> and <a href="/docs/transformers/pr_29886/en/model_doc/xlnet#transformers.XLNetTokenizer">XLNetTokenizer</a>. Based on
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a>.`,rn,Xe,Pn="The tokenization method is <code>&lt;tokens&gt; &lt;eos&gt; &lt;language code&gt;</code> for source language documents, and `&lt;language code&gt;",pn,L,cn,x,he,dn,He,Qn=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. An NLLB sequence has the following format, where <code>X</code> represents the sequence:`,mn,Ee,Kn="<li><code>input_ids</code> (for encoder) <code>X [eos, src_lang_code]</code></li> <li><code>decoder_input_ids</code>: (for decoder) <code>X [eos, tgt_lang_code]</code></li>",un,Se,On=`BOS is never used. Pairs of sequences are not the expected use case, but they will be handled without a
separator.`,Ct,fe,Lt,k,be,gn,Ae,es=`Construct a “fast” NLLB tokenizer (backed by HuggingFace’s <em>tokenizers</em> library). Based on
<a href="https://huggingface.co/docs/tokenizers/python/latest/components.html?highlight=BPE#models" rel="nofollow">BPE</a>.`,hn,Ye,ts=`This tokenizer inherits from <a href="/docs/transformers/pr_29886/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,fn,De,ns="The tokenization method is <code>&lt;tokens&gt; &lt;eos&gt; &lt;language code&gt;</code> for source language documents, and `&lt;language code&gt;",bn,R,kn,j,ke,_n,Pe,ss=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. The special tokens depend on calling set_lang.`,yn,Qe,as="An NLLB sequence has the following format, where <code>X</code> represents the sequence:",Mn,Ke,ls="<li><code>input_ids</code> (for encoder) <code>X [eos, src_lang_code]</code></li> <li><code>decoder_input_ids</code>: (for decoder) <code>X [eos, tgt_lang_code]</code></li>",Tn,Oe,os=`BOS is never used. Pairs of sequences are not the expected use case, but they will be handled without a
separator.`,wn,W,_e,vn,et,rs=`Create a mask from the two sequences passed to be used in a sequence-pair classification task. nllb does not
make use of token type ids, therefore a list of zeros is returned.`,Jn,q,ye,jn,tt,is="Reset the special tokens to the source lang setting.",$n,nt,ps="<li>In legacy mode: No prefix and suffix=[eos, src_lang_code].</li> <li>In default mode: Prefix=[src_lang_code], suffix = [eos]</li>",xn,N,Me,Un,st,cs="Reset the special tokens to the target lang setting.",zn,at,ds="<li>In legacy mode: No prefix and suffix=[eos, tgt_lang_code].</li> <li>In default mode: Prefix=[tgt_lang_code], suffix = [eos]</li>",Rt,Te,Wt,we,ms="Flash Attention 2 is a faster, optimized version of the attention scores computation which relies on <code>cuda</code> kernels.",Vt,ve,Ft,Je,us='First, check whether your hardware is compatible with Flash Attention 2. The latest list of compatible hardware can be found in the <a href="https://github.com/Dao-AILab/flash-attention#installation-and-features" rel="nofollow">official documentation</a>.',Bt,je,gs='Next, <a href="https://github.com/Dao-AILab/flash-attention#installation-and-features" rel="nofollow">install</a> the latest version of Flash Attention 2:',Xt,$e,Ht,xe,Et,Ue,hs='To load a model using Flash Attention 2, we can pass the argument <code>attn_implementation=&quot;flash_attention_2&quot;</code> to <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained" rel="nofollow"><code>.from_pretrained</code></a>. You can use either <code>torch.float16</code> or <code>torch.bfloat16</code> precision.',St,ze,At,qe,Yt,Ne,fs="Below is an expected speedup diagram that compares pure inference time between the native implementation and the Flash Attention 2.",Dt,V,bs='<img src="https://huggingface.co/datasets/visheratin/documentation-images/resolve/main/nllb-speedup.webp"/>',Pt,Ge,Qt,Ze,ks=`PyTorch includes a native scaled dot-product attention (SDPA) operator as part of <code>torch.nn.functional</code>. This function
encompasses several implementations that can be applied depending on the inputs and the hardware in use. See the
<a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">official documentation</a>
or the <a href="https://huggingface.co/docs/transformers/main/en/perf_infer_gpu_one#pytorch-scaled-dot-product-attention" rel="nofollow">GPU Inference</a>
page for more information.`,Kt,Ie,_s=`SDPA is used by default for <code>torch&gt;=2.1.1</code> when an implementation is available, but you may also set
<code>attn_implementation=&quot;sdpa&quot;</code> in <code>from_pretrained()</code> to explicitly request SDPA to be used.`,Ot,Ce,en,Le,ys="For the best speedups, we recommend loading the model in half-precision (e.g. <code>torch.float16</code> or <code>torch.bfloat16</code>).",tn,Re,nn,rt,sn;return M=new $({props:{title:"NLLB",local:"nllb",headingTag:"h1"}}),v=new $({props:{title:"Updated tokenizer behavior",local:"transformers.NllbTokenizer",headingTag:"h2"}}),H=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME5sbGJUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBObGxiVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyKSUwQXRva2VuaXplciglMjJIb3clMjB3YXMlMjB5b3VyJTIwZGF5JTNGJTIyKS5pbnB1dF9pZHMlMEElMEElMjMlMjAyJTNBJTIwJyUzQyUyRnMlM0UnJTBBJTIzJTIwMjU2MDQ3JTIwJTNBJTIwJ2VuZ19MYXRuJw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> NllbTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = NllbTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer(<span class="hljs-string">&quot;How was your day?&quot;</span>).input_ids
[<span class="hljs-number">13374</span>, <span class="hljs-number">1398</span>, <span class="hljs-number">4260</span>, <span class="hljs-number">4039</span>, <span class="hljs-number">248130</span>, <span class="hljs-number">2</span>, <span class="hljs-number">256047</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 2: &#x27;&lt;/s&gt;&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 256047 : &#x27;eng_Latn&#x27;</span>`,wrap:!1}}),S=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME5sbGJUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBObGxiVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyKSUwQXRva2VuaXplciglMjJIb3clMjB3YXMlMjB5b3VyJTIwZGF5JTNGJTIyKS5pbnB1dF9pZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> NllbTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = NllbTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer(<span class="hljs-string">&quot;How was your day?&quot;</span>).input_ids
[<span class="hljs-number">256047</span>, <span class="hljs-number">13374</span>, <span class="hljs-number">1398</span>, <span class="hljs-number">4260</span>, <span class="hljs-number">4039</span>, <span class="hljs-number">248130</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),Y=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME5sbGJUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBObGxiVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyJTJDJTIwbGVnYWN5X2JlaGF2aW91ciUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> NllbTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = NllbTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>, legacy_behaviour=<span class="hljs-literal">True</span>)`,wrap:!1}}),P=new $({props:{title:"Overview",local:"overview",headingTag:"h2"}}),se=new $({props:{title:"Generating with NLLB",local:"generating-with-nllb",headingTag:"h2"}}),oe=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyKSUwQSUwQWFydGljbGUlMjAlM0QlMjAlMjJVTiUyMENoaWVmJTIwc2F5cyUyMHRoZXJlJTIwaXMlMjBubyUyMG1pbGl0YXJ5JTIwc29sdXRpb24lMjBpbiUyMFN5cmlhJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGFydGljbGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXRyYW5zbGF0ZWRfdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMjBmb3JjZWRfYm9zX3Rva2VuX2lkJTNEdG9rZW5pemVyLmNvbnZlcnRfdG9rZW5zX3RvX2lkcyglMjJmcmFfTGF0biUyMiklMkMlMjBtYXhfbGVuZ3RoJTNEMzAlMEEpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZSh0cmFuc2xhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;UN Chief says there is no military solution in Syria&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>translated_tokens = model.generate(
<span class="hljs-meta">... </span>    **inputs, forced_bos_token_id=tokenizer.convert_tokens_to_ids(<span class="hljs-string">&quot;fra_Latn&quot;</span>), max_length=<span class="hljs-number">30</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(translated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
Le chef de l<span class="hljs-string">&#x27;ONU dit qu&#x27;</span>il n<span class="hljs-string">&#x27;y a pas de solution militaire en Syrie</span>`,wrap:!1}}),re=new $({props:{title:"Generating from any other language than English",local:"generating-from-any-other-language-than-english",headingTag:"h3"}}),ce=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyJTJDJTIwdG9rZW4lM0RUcnVlJTJDJTIwc3JjX2xhbmclM0QlMjJyb25fTGF0biUyMiUwQSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZubGxiLTIwMC1kaXN0aWxsZWQtNjAwTSUyMiUyQyUyMHRva2VuJTNEVHJ1ZSklMEElMEFhcnRpY2xlJTIwJTNEJTIwJTIyJUM1JTlFZWZ1bCUyME9OVSUyMHNwdW5lJTIwYyVDNCU4MyUyMG51JTIwZXhpc3QlQzQlODMlMjBvJTIwc29sdSVDNSVBM2llJTIwbWlsaXRhciVDNCU4MyUyMCVDMyVBRW4lMjBTaXJpYSUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihhcnRpY2xlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF0cmFuc2xhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMCoqaW5wdXRzJTJDJTIwZm9yY2VkX2Jvc190b2tlbl9pZCUzRHRva2VuaXplci5jb252ZXJ0X3Rva2Vuc190b19pZHMoJTIyZGV1X0xhdG4lMjIpJTJDJTIwbWF4X2xlbmd0aCUzRDMwJTBBKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUodHJhbnNsYXRlZF90b2tlbnMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>, token=<span class="hljs-literal">True</span>, src_lang=<span class="hljs-string">&quot;ron_Latn&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>, token=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;Şeful ONU spune că nu există o soluţie militară în Siria&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>translated_tokens = model.generate(
<span class="hljs-meta">... </span>    **inputs, forced_bos_token_id=tokenizer.convert_tokens_to_ids(<span class="hljs-string">&quot;deu_Latn&quot;</span>), max_length=<span class="hljs-number">30</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(translated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
UN-Chef sagt, es gibt keine militärische Lösung <span class="hljs-keyword">in</span> Syrien`,wrap:!1}}),de=new $({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ue=new $({props:{title:"NllbTokenizer",local:"nllbtokenizer",headingTag:"h2"}}),ge=new We({props:{name:"class transformers.NllbTokenizer",anchor:"transformers.NllbTokenizer",parameters:[{name:"vocab_file",val:""},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"sep_token",val:" = '</s>'"},{name:"cls_token",val:" = '<s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"mask_token",val:" = '<mask>'"},{name:"tokenizer_file",val:" = None"},{name:"src_lang",val:" = None"},{name:"tgt_lang",val:" = None"},{name:"sp_model_kwargs",val:": Optional = None"},{name:"additional_special_tokens",val:" = None"},{name:"legacy_behaviour",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.NllbTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.NllbTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.NllbTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.NllbTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.NllbTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.NllbTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.NllbTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.NllbTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;mask&gt;&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.NllbTokenizer.tokenizer_file",description:`<strong>tokenizer_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The path to a tokenizer file to use instead of the vocab file.`,name:"tokenizer_file"},{anchor:"transformers.NllbTokenizer.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The language to use as source language for translation.`,name:"src_lang"},{anchor:"transformers.NllbTokenizer.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The language to use as target language for translation.`,name:"tgt_lang"},{anchor:"transformers.NllbTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>Dict[str, str]</code>) &#x2014;
Additional keyword arguments to pass to the model initialization.`,name:"sp_model_kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/nllb/tokenization_nllb.py#L36"}}),L=new ws({props:{anchor:"transformers.NllbTokenizer.example",$$slots:{default:[Ns]},$$scope:{ctx:Ve}}}),he=new We({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.NllbTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.NllbTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.NllbTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/nllb/tokenization_nllb.py#L243",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),fe=new $({props:{title:"NllbTokenizerFast",local:"nllbtokenizerfast",headingTag:"h2"}}),be=new We({props:{name:"class transformers.NllbTokenizerFast",anchor:"transformers.NllbTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"sep_token",val:" = '</s>'"},{name:"cls_token",val:" = '<s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"mask_token",val:" = '<mask>'"},{name:"src_lang",val:" = None"},{name:"tgt_lang",val:" = None"},{name:"additional_special_tokens",val:" = None"},{name:"legacy_behaviour",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.NllbTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.NllbTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.NllbTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.NllbTokenizerFast.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.NllbTokenizerFast.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.NllbTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.NllbTokenizerFast.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.NllbTokenizerFast.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;mask&gt;&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.NllbTokenizerFast.tokenizer_file",description:`<strong>tokenizer_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The path to a tokenizer file to use instead of the vocab file.`,name:"tokenizer_file"},{anchor:"transformers.NllbTokenizerFast.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The language to use as source language for translation.`,name:"src_lang"},{anchor:"transformers.NllbTokenizerFast.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The language to use as target language for translation.`,name:"tgt_lang"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/nllb/tokenization_nllb_fast.py#L42"}}),R=new ws({props:{anchor:"transformers.NllbTokenizerFast.example",$$slots:{default:[Gs]},$$scope:{ctx:Ve}}}),ke=new We({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.NllbTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.NllbTokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.NllbTokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/nllb/tokenization_nllb_fast.py#L182",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),_e=new We({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.NllbTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": List"},{name:"token_ids_1",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.NllbTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.NllbTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/nllb/tokenization_nllb_fast.py#L211",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of zeros.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ye=new We({props:{name:"set_src_lang_special_tokens",anchor:"transformers.NllbTokenizerFast.set_src_lang_special_tokens",parameters:[{name:"src_lang",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/nllb/tokenization_nllb_fast.py#L266"}}),Me=new We({props:{name:"set_tgt_lang_special_tokens",anchor:"transformers.NllbTokenizerFast.set_tgt_lang_special_tokens",parameters:[{name:"lang",val:": str"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/nllb/tokenization_nllb_fast.py#L289"}}),Te=new $({props:{title:"Using Flash Attention 2",local:"using-flash-attention-2",headingTag:"h2"}}),ve=new $({props:{title:"Installation",local:"installation",headingTag:"h3"}}),$e=new Z({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),xe=new $({props:{title:"Usage",local:"usage",headingTag:"h3"}}),ze=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyKS50byglMjJjdWRhJTIyKS5ldmFsKCklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyKSUwQSUwQWFydGljbGUlMjAlM0QlMjAlMjIlQzUlOUVlZnVsJTIwT05VJTIwc3B1bmUlMjBjJUM0JTgzJTIwbnUlMjBleGlzdCVDNCU4MyUyMG8lMjBzb2x1JUM1JUEzaWUlMjBtaWxpdGFyJUM0JTgzJTIwJUMzJUFFbiUyMFNpcmlhJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGFydGljbGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQSUwQXRyYW5zbGF0ZWRfdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMjBmb3JjZWRfYm9zX3Rva2VuX2lkJTNEdG9rZW5pemVyLmNvbnZlcnRfdG9rZW5zX3RvX2lkcyglMjJkZXVfTGF0biUyMiklMkMlMjBtYXhfbGVuZ3RoJTNEMzAlMEEpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZSh0cmFuc2xhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>, torch_dtype=torch.float16, attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>).<span class="hljs-built_in">eval</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>article = <span class="hljs-string">&quot;Şeful ONU spune că nu există o soluţie militară în Siria&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(article, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>translated_tokens = model.generate(
<span class="hljs-meta">... </span>    **inputs, forced_bos_token_id=tokenizer.convert_tokens_to_ids(<span class="hljs-string">&quot;deu_Latn&quot;</span>), max_length=<span class="hljs-number">30</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(translated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;UN-Chef sagt, es gibt keine militärische Lösung in Syrien&quot;</span>`,wrap:!1}}),qe=new $({props:{title:"Expected speedups",local:"expected-speedups",headingTag:"h3"}}),Ge=new $({props:{title:"Using Scaled Dot Product Attention (SDPA)",local:"using-scaled-dot-product-attention-sdpa",headingTag:"h2"}}),Ce=new Z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMnNkcGElMjIpJTBBLi4u",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM
model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/nllb-200-distilled-600M&quot;</span>, torch_dtype=torch.float16, attn_implementation=<span class="hljs-string">&quot;sdpa&quot;</span>)
...`,wrap:!1}}),Re=new qs({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/nllb.md"}}),{c(){b=o("meta"),z=a(),w=o("p"),_=a(),d(M.$$.fragment),c=a(),d(v.$$.fragment),it=a(),F=o("p"),F.innerHTML=qn,pt=a(),B=o("p"),B.innerHTML=Nn,ct=a(),X=o("p"),X.textContent=Gn,dt=a(),d(H.$$.fragment),mt=a(),E=o("p"),E.textContent=Zn,ut=a(),d(S.$$.fragment),gt=a(),A=o("p"),A.textContent=In,ht=a(),d(Y.$$.fragment),ft=a(),D=o("p"),D.innerHTML=Cn,bt=a(),d(P.$$.fragment),kt=a(),Q=o("p"),Q.innerHTML=Ln,_t=a(),K=o("p"),K.textContent=Rn,yt=a(),O=o("p"),O.innerHTML=Wn,Mt=a(),ee=o("p"),ee.textContent=Vn,Tt=a(),te=o("p"),te.innerHTML=Fn,wt=a(),ne=o("p"),ne.innerHTML=Bn,vt=a(),d(se.$$.fragment),Jt=a(),ae=o("p"),ae.innerHTML=Xn,jt=a(),le=o("p"),le.innerHTML=Hn,$t=a(),d(oe.$$.fragment),xt=a(),d(re.$$.fragment),Ut=a(),ie=o("p"),ie.innerHTML=En,zt=a(),pe=o("p"),pe.textContent=Sn,qt=a(),d(ce.$$.fragment),Nt=a(),d(de.$$.fragment),Gt=a(),me=o("ul"),me.innerHTML=An,Zt=a(),d(ue.$$.fragment),It=a(),T=o("div"),d(ge.$$.fragment),ln=a(),Fe=o("p"),Fe.textContent=Yn,on=a(),Be=o("p"),Be.innerHTML=Dn,rn=a(),Xe=o("p"),Xe.innerHTML=Pn,pn=Ms(`
<tokens> <eos>\` for target language documents.
`),d(L.$$.fragment),cn=a(),x=o("div"),d(he.$$.fragment),dn=a(),He=o("p"),He.innerHTML=Qn,mn=a(),Ee=o("ul"),Ee.innerHTML=Kn,un=a(),Se=o("p"),Se.textContent=On,Ct=a(),d(fe.$$.fragment),Lt=a(),k=o("div"),d(be.$$.fragment),gn=a(),Ae=o("p"),Ae.innerHTML=es,hn=a(),Ye=o("p"),Ye.innerHTML=ts,fn=a(),De=o("p"),De.innerHTML=ns,bn=Ms(`
<tokens> <eos>\` for target language documents.
`),d(R.$$.fragment),kn=a(),j=o("div"),d(ke.$$.fragment),_n=a(),Pe=o("p"),Pe.textContent=ss,yn=a(),Qe=o("p"),Qe.innerHTML=as,Mn=a(),Ke=o("ul"),Ke.innerHTML=ls,Tn=a(),Oe=o("p"),Oe.textContent=os,wn=a(),W=o("div"),d(_e.$$.fragment),vn=a(),et=o("p"),et.textContent=rs,Jn=a(),q=o("div"),d(ye.$$.fragment),jn=a(),tt=o("p"),tt.textContent=is,$n=a(),nt=o("ul"),nt.innerHTML=ps,xn=a(),N=o("div"),d(Me.$$.fragment),Un=a(),st=o("p"),st.textContent=cs,zn=a(),at=o("ul"),at.innerHTML=ds,Rt=a(),d(Te.$$.fragment),Wt=a(),we=o("p"),we.innerHTML=ms,Vt=a(),d(ve.$$.fragment),Ft=a(),Je=o("p"),Je.innerHTML=us,Bt=a(),je=o("p"),je.innerHTML=gs,Xt=a(),d($e.$$.fragment),Ht=a(),d(xe.$$.fragment),Et=a(),Ue=o("p"),Ue.innerHTML=hs,St=a(),d(ze.$$.fragment),At=a(),d(qe.$$.fragment),Yt=a(),Ne=o("p"),Ne.textContent=fs,Dt=a(),V=o("div"),V.innerHTML=bs,Pt=a(),d(Ge.$$.fragment),Qt=a(),Ze=o("p"),Ze.innerHTML=ks,Kt=a(),Ie=o("p"),Ie.innerHTML=_s,Ot=a(),d(Ce.$$.fragment),en=a(),Le=o("p"),Le.innerHTML=ys,tn=a(),d(Re.$$.fragment),nn=a(),rt=o("p"),this.h()},l(e){const t=Us("svelte-u9bgzb",document.head);b=r(t,"META",{name:!0,content:!0}),t.forEach(n),z=l(e),w=r(e,"P",{}),I(w).forEach(n),_=l(e),m(M.$$.fragment,e),c=l(e),m(v.$$.fragment,e),it=l(e),F=r(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1bqcebz"&&(F.innerHTML=qn),pt=l(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-vrv0c7"&&(B.innerHTML=Nn),ct=l(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-vmuleo"&&(X.textContent=Gn),dt=l(e),m(H.$$.fragment,e),mt=l(e),E=r(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1qx2sah"&&(E.textContent=Zn),ut=l(e),m(S.$$.fragment,e),gt=l(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-obd9iw"&&(A.textContent=In),ht=l(e),m(Y.$$.fragment,e),ft=l(e),D=r(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-ib1bh"&&(D.innerHTML=Cn),bt=l(e),m(P.$$.fragment,e),kt=l(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-12x4cpm"&&(Q.innerHTML=Ln),_t=l(e),K=r(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-wu27l3"&&(K.textContent=Rn),yt=l(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1j7uypk"&&(O.innerHTML=Wn),Mt=l(e),ee=r(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1ayd4bm"&&(ee.textContent=Vn),Tt=l(e),te=r(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-qp2ubt"&&(te.innerHTML=Fn),wt=l(e),ne=r(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-ywl52z"&&(ne.innerHTML=Bn),vt=l(e),m(se.$$.fragment,e),Jt=l(e),ae=r(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-gz9jek"&&(ae.innerHTML=Xn),jt=l(e),le=r(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-c2ujwv"&&(le.innerHTML=Hn),$t=l(e),m(oe.$$.fragment,e),xt=l(e),m(re.$$.fragment,e),Ut=l(e),ie=r(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-ets0jr"&&(ie.innerHTML=En),zt=l(e),pe=r(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-14hvt1f"&&(pe.textContent=Sn),qt=l(e),m(ce.$$.fragment,e),Nt=l(e),m(de.$$.fragment,e),Gt=l(e),me=r(e,"UL",{"data-svelte-h":!0}),p(me)!=="svelte-6ej6p2"&&(me.innerHTML=An),Zt=l(e),m(ue.$$.fragment,e),It=l(e),T=r(e,"DIV",{class:!0});var J=I(T);m(ge.$$.fragment,J),ln=l(J),Fe=r(J,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-7mmiyn"&&(Fe.textContent=Yn),on=l(J),Be=r(J,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1bqmpmr"&&(Be.innerHTML=Dn),rn=l(J),Xe=r(J,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-1i8rh37"&&(Xe.innerHTML=Pn),pn=Ts(J,`
<tokens> <eos>\` for target language documents.
`),m(L.$$.fragment,J),cn=l(J),x=r(J,"DIV",{class:!0});var U=I(x);m(he.$$.fragment,U),dn=l(U),He=r(U,"P",{"data-svelte-h":!0}),p(He)!=="svelte-nkpot4"&&(He.innerHTML=Qn),mn=l(U),Ee=r(U,"UL",{"data-svelte-h":!0}),p(Ee)!=="svelte-mlrsks"&&(Ee.innerHTML=Kn),un=l(U),Se=r(U,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-46aam0"&&(Se.textContent=On),U.forEach(n),J.forEach(n),Ct=l(e),m(fe.$$.fragment,e),Lt=l(e),k=r(e,"DIV",{class:!0});var y=I(k);m(be.$$.fragment,y),gn=l(y),Ae=r(y,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-g5z8ln"&&(Ae.innerHTML=es),hn=l(y),Ye=r(y,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1k53u1r"&&(Ye.innerHTML=ts),fn=l(y),De=r(y,"P",{"data-svelte-h":!0}),p(De)!=="svelte-1i8rh37"&&(De.innerHTML=ns),bn=Ts(y,`
<tokens> <eos>\` for target language documents.
`),m(R.$$.fragment,y),kn=l(y),j=r(y,"DIV",{class:!0});var G=I(j);m(ke.$$.fragment,G),_n=l(G),Pe=r(G,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-1vll0v2"&&(Pe.textContent=ss),yn=l(G),Qe=r(G,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-90np8u"&&(Qe.innerHTML=as),Mn=l(G),Ke=r(G,"UL",{"data-svelte-h":!0}),p(Ke)!=="svelte-mlrsks"&&(Ke.innerHTML=ls),Tn=l(G),Oe=r(G,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-46aam0"&&(Oe.textContent=os),G.forEach(n),wn=l(y),W=r(y,"DIV",{class:!0});var an=I(W);m(_e.$$.fragment,an),vn=l(an),et=r(an,"P",{"data-svelte-h":!0}),p(et)!=="svelte-1bcwf97"&&(et.textContent=rs),an.forEach(n),Jn=l(y),q=r(y,"DIV",{class:!0});var lt=I(q);m(ye.$$.fragment,lt),jn=l(lt),tt=r(lt,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-1euodjq"&&(tt.textContent=is),$n=l(lt),nt=r(lt,"UL",{"data-svelte-h":!0}),p(nt)!=="svelte-rrgzfj"&&(nt.innerHTML=ps),lt.forEach(n),xn=l(y),N=r(y,"DIV",{class:!0});var ot=I(N);m(Me.$$.fragment,ot),Un=l(ot),st=r(ot,"P",{"data-svelte-h":!0}),p(st)!=="svelte-1i6tlcm"&&(st.textContent=cs),zn=l(ot),at=r(ot,"UL",{"data-svelte-h":!0}),p(at)!=="svelte-1durotj"&&(at.innerHTML=ds),ot.forEach(n),y.forEach(n),Rt=l(e),m(Te.$$.fragment,e),Wt=l(e),we=r(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1oyivwb"&&(we.innerHTML=ms),Vt=l(e),m(ve.$$.fragment,e),Ft=l(e),Je=r(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-3ltiwn"&&(Je.innerHTML=us),Bt=l(e),je=r(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1pp3dkd"&&(je.innerHTML=gs),Xt=l(e),m($e.$$.fragment,e),Ht=l(e),m(xe.$$.fragment,e),Et=l(e),Ue=r(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1djrqq6"&&(Ue.innerHTML=hs),St=l(e),m(ze.$$.fragment,e),At=l(e),m(qe.$$.fragment,e),Yt=l(e),Ne=r(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-bjnkty"&&(Ne.textContent=fs),Dt=l(e),V=r(e,"DIV",{style:!0,"data-svelte-h":!0}),p(V)!=="svelte-1obt1wq"&&(V.innerHTML=bs),Pt=l(e),m(Ge.$$.fragment,e),Qt=l(e),Ze=r(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1cid2pe"&&(Ze.innerHTML=ks),Kt=l(e),Ie=r(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1x11lxg"&&(Ie.innerHTML=_s),Ot=l(e),m(Ce.$$.fragment,e),en=l(e),Le=r(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-djb2w0"&&(Le.innerHTML=ys),tn=l(e),m(Re.$$.fragment,e),nn=l(e),rt=r(e,"P",{}),I(rt).forEach(n),this.h()},h(){C(b,"name","hf:doc:metadata"),C(b,"content",Is),C(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),C(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),zs(V,"text-align","center")},m(e,t){i(document.head,b),s(e,z,t),s(e,w,t),s(e,_,t),u(M,e,t),s(e,c,t),u(v,e,t),s(e,it,t),s(e,F,t),s(e,pt,t),s(e,B,t),s(e,ct,t),s(e,X,t),s(e,dt,t),u(H,e,t),s(e,mt,t),s(e,E,t),s(e,ut,t),u(S,e,t),s(e,gt,t),s(e,A,t),s(e,ht,t),u(Y,e,t),s(e,ft,t),s(e,D,t),s(e,bt,t),u(P,e,t),s(e,kt,t),s(e,Q,t),s(e,_t,t),s(e,K,t),s(e,yt,t),s(e,O,t),s(e,Mt,t),s(e,ee,t),s(e,Tt,t),s(e,te,t),s(e,wt,t),s(e,ne,t),s(e,vt,t),u(se,e,t),s(e,Jt,t),s(e,ae,t),s(e,jt,t),s(e,le,t),s(e,$t,t),u(oe,e,t),s(e,xt,t),u(re,e,t),s(e,Ut,t),s(e,ie,t),s(e,zt,t),s(e,pe,t),s(e,qt,t),u(ce,e,t),s(e,Nt,t),u(de,e,t),s(e,Gt,t),s(e,me,t),s(e,Zt,t),u(ue,e,t),s(e,It,t),s(e,T,t),u(ge,T,null),i(T,ln),i(T,Fe),i(T,on),i(T,Be),i(T,rn),i(T,Xe),i(T,pn),u(L,T,null),i(T,cn),i(T,x),u(he,x,null),i(x,dn),i(x,He),i(x,mn),i(x,Ee),i(x,un),i(x,Se),s(e,Ct,t),u(fe,e,t),s(e,Lt,t),s(e,k,t),u(be,k,null),i(k,gn),i(k,Ae),i(k,hn),i(k,Ye),i(k,fn),i(k,De),i(k,bn),u(R,k,null),i(k,kn),i(k,j),u(ke,j,null),i(j,_n),i(j,Pe),i(j,yn),i(j,Qe),i(j,Mn),i(j,Ke),i(j,Tn),i(j,Oe),i(k,wn),i(k,W),u(_e,W,null),i(W,vn),i(W,et),i(k,Jn),i(k,q),u(ye,q,null),i(q,jn),i(q,tt),i(q,$n),i(q,nt),i(k,xn),i(k,N),u(Me,N,null),i(N,Un),i(N,st),i(N,zn),i(N,at),s(e,Rt,t),u(Te,e,t),s(e,Wt,t),s(e,we,t),s(e,Vt,t),u(ve,e,t),s(e,Ft,t),s(e,Je,t),s(e,Bt,t),s(e,je,t),s(e,Xt,t),u($e,e,t),s(e,Ht,t),u(xe,e,t),s(e,Et,t),s(e,Ue,t),s(e,St,t),u(ze,e,t),s(e,At,t),u(qe,e,t),s(e,Yt,t),s(e,Ne,t),s(e,Dt,t),s(e,V,t),s(e,Pt,t),u(Ge,e,t),s(e,Qt,t),s(e,Ze,t),s(e,Kt,t),s(e,Ie,t),s(e,Ot,t),u(Ce,e,t),s(e,en,t),s(e,Le,t),s(e,tn,t),u(Re,e,t),s(e,nn,t),s(e,rt,t),sn=!0},p(e,[t]){const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),L.$set(J);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),R.$set(U)},i(e){sn||(g(M.$$.fragment,e),g(v.$$.fragment,e),g(H.$$.fragment,e),g(S.$$.fragment,e),g(Y.$$.fragment,e),g(P.$$.fragment,e),g(se.$$.fragment,e),g(oe.$$.fragment,e),g(re.$$.fragment,e),g(ce.$$.fragment,e),g(de.$$.fragment,e),g(ue.$$.fragment,e),g(ge.$$.fragment,e),g(L.$$.fragment,e),g(he.$$.fragment,e),g(fe.$$.fragment,e),g(be.$$.fragment,e),g(R.$$.fragment,e),g(ke.$$.fragment,e),g(_e.$$.fragment,e),g(ye.$$.fragment,e),g(Me.$$.fragment,e),g(Te.$$.fragment,e),g(ve.$$.fragment,e),g($e.$$.fragment,e),g(xe.$$.fragment,e),g(ze.$$.fragment,e),g(qe.$$.fragment,e),g(Ge.$$.fragment,e),g(Ce.$$.fragment,e),g(Re.$$.fragment,e),sn=!0)},o(e){h(M.$$.fragment,e),h(v.$$.fragment,e),h(H.$$.fragment,e),h(S.$$.fragment,e),h(Y.$$.fragment,e),h(P.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(de.$$.fragment,e),h(ue.$$.fragment,e),h(ge.$$.fragment,e),h(L.$$.fragment,e),h(he.$$.fragment,e),h(fe.$$.fragment,e),h(be.$$.fragment,e),h(R.$$.fragment,e),h(ke.$$.fragment,e),h(_e.$$.fragment,e),h(ye.$$.fragment,e),h(Me.$$.fragment,e),h(Te.$$.fragment,e),h(ve.$$.fragment,e),h($e.$$.fragment,e),h(xe.$$.fragment,e),h(ze.$$.fragment,e),h(qe.$$.fragment,e),h(Ge.$$.fragment,e),h(Ce.$$.fragment,e),h(Re.$$.fragment,e),sn=!1},d(e){e&&(n(z),n(w),n(_),n(c),n(it),n(F),n(pt),n(B),n(ct),n(X),n(dt),n(mt),n(E),n(ut),n(gt),n(A),n(ht),n(ft),n(D),n(bt),n(kt),n(Q),n(_t),n(K),n(yt),n(O),n(Mt),n(ee),n(Tt),n(te),n(wt),n(ne),n(vt),n(Jt),n(ae),n(jt),n(le),n($t),n(xt),n(Ut),n(ie),n(zt),n(pe),n(qt),n(Nt),n(Gt),n(me),n(Zt),n(It),n(T),n(Ct),n(Lt),n(k),n(Rt),n(Wt),n(we),n(Vt),n(Ft),n(Je),n(Bt),n(je),n(Xt),n(Ht),n(Et),n(Ue),n(St),n(At),n(Yt),n(Ne),n(Dt),n(V),n(Pt),n(Qt),n(Ze),n(Kt),n(Ie),n(Ot),n(en),n(Le),n(tn),n(nn),n(rt)),n(b),f(M,e),f(v,e),f(H,e),f(S,e),f(Y,e),f(P,e),f(se,e),f(oe,e),f(re,e),f(ce,e),f(de,e),f(ue,e),f(ge),f(L),f(he),f(fe,e),f(be),f(R),f(ke),f(_e),f(ye),f(Me),f(Te,e),f(ve,e),f($e,e),f(xe,e),f(ze,e),f(qe,e),f(Ge,e),f(Ce,e),f(Re,e)}}}const Is='{"title":"NLLB","local":"nllb","sections":[{"title":"Updated tokenizer behavior","local":"transformers.NllbTokenizer","sections":[],"depth":2},{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Generating with NLLB","local":"generating-with-nllb","sections":[{"title":"Generating from any other language than English","local":"generating-from-any-other-language-than-english","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"NllbTokenizer","local":"nllbtokenizer","sections":[],"depth":2},{"title":"NllbTokenizerFast","local":"nllbtokenizerfast","sections":[],"depth":2},{"title":"Using Flash Attention 2","local":"using-flash-attention-2","sections":[{"title":"Installation","local":"installation","sections":[],"depth":3},{"title":"Usage","local":"usage","sections":[],"depth":3},{"title":"Expected speedups","local":"expected-speedups","sections":[],"depth":3}],"depth":2},{"title":"Using Scaled Dot Product Attention (SDPA)","local":"using-scaled-dot-product-attention-sdpa","sections":[],"depth":2}],"depth":1}';function Cs(Ve){return js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xs extends $s{constructor(b){super(),xs(this,b,Cs,Zs,Js,{})}}export{Xs as component};
