import{s as mt,o as dt,n as Mt}from"../chunks/scheduler.3e4cb221.js";import{S as ct,i as ft,g as i,s as n,r as m,A as ut,h as o,f as l,c as s,j as rt,u as d,x as r,k as pt,y as ht,a,v as M,d as c,t as f,w as u}from"../chunks/index.bc693fcb.js";import{H as y,T as yt,E as wt}from"../chunks/getInferenceSnippets.65765a9b.js";import{C as ae}from"../chunks/CodeBlock.4d312707.js";function Tt(ne){let p,T="When implementing PEFT methods, start with small rank values (4-8) for LoRA and monitor training loss. Use validation sets to prevent overfitting and compare results with full fine-tuning baselines when possible. The effectiveness of different methods can vary by task, so experimentation is key.";return{c(){p=i("p"),p.textContent=T},l(h){p=o(h,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1co8mut"&&(p.textContent=T)},m(h,te){a(h,p,te)},p:Mt,d(h){h&&l(p)}}}function gt(ne){let p,T,h,te,g,se,b,Qe="Parameter-Efficient Fine-Tuning (PEFT) lets you adapt large models by training a small number of additional parameters while keeping the base model frozen. The most widely used PEFT method is LoRA (Low-Rank Adaptation), which injects trainable low-rank updates into linear layers. This often reduces trainable parameters by ~90% while preserving performance.",ie,J,oe,U,Xe="<li>You have limited compute or memory budget</li> <li>You need to quickly adapt a base model to multiple tasks/domains</li> <li>You want fast iteration and small artifacts (adapter weights are usually a few MB)</li>",re,j,pe,$,qe="LoRA has become the most widely adopted PEFT method. It works by adding small rank decomposition matrices to the attention weights, typically reducing trainable parameters by about 90%.",me,v,Se='LoRA (Low-Rank Adaptation) is a parameter-efficient fine-tuning technique that freezes the pre-trained model weights and injects trainable rank decomposition matrices into the model’s layers. Instead of training all model parameters during fine-tuning, LoRA decomposes the weight updates into smaller matrices through low-rank decomposition, significantly reducing the number of trainable parameters while maintaining model performance. For example, when applied to GPT-3 175B, LoRA reduced trainable parameters by 10,000x and GPU memory requirements by 3x compared to full fine-tuning. You can read more about LoRA in the <a href="https://arxiv.org/pdf/2106.09685" rel="nofollow">LoRA paper</a>.',de,Z,He="LoRA works by adding pairs of rank decomposition matrices to transformer layers, typically focusing on attention weights. During inference, these adapter weights can be merged with the base model, resulting in no additional latency overhead. LoRA is particularly useful for adapting large language models to specific tasks or domains while keeping resource requirements manageable.",Me,C,ce,R,Ye="Adapters can be loaded onto a pretrained model with load_adapter(), which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the set_adapter() function. To return the base model, you could use unload() to unload all of the LoRA modules. This makes it easy to switch between different task-specific weights.",fe,k,ue,B,Pe='<img src="./images/lora_adapter.png" alt="lora_load_adapter"/>',he,I,ye,F,ze="After training with LoRA, you might want to merge the adapter weights back into the base model for easier deployment. This creates a single model with the combined weights, eliminating the need to load adapters separately during inference.",we,_,Ne="The merging process requires attention to memory management and precision. Since you’ll need to load both the base model and adapter weights simultaneously, ensure sufficient GPU/CPU memory is available. Using <code>device_map=&quot;auto&quot;</code> in <code>transformers</code> will help with automatic memory management. Maintain consistent precision (e.g., float16) throughout the process, matching the precision used during training and saving the merged model in the same format for deployment. Before deploying, always validate the merged model by comparing its outputs and performance metrics with the adapter-based version.",Te,E,De="Adapters are also be convenient for switching between different tasks or domains. You can load the base model and adapter weights separately. This allows for quick switching between different task-specific weights.",ge,w,be,L,Je,W,Ke='<a href="https://arxiv.org/abs/2406.01775" rel="nofollow">OLoRA</a> utilizes QR decomposition to initialize the LoRA adapters. OLoRA translates the base weights of the model by a factor of their QR decompositions, i.e., it mutates the weights before performing any training on them. This approach significantly improves stability, accelerates convergence speed, and ultimately achieves superior performance.',Ue,A,je,G,Oe="PEFT methods can be combined with TRL (Transformers Reinforcement Learning) for efficient fine-tuning. This integration is particularly useful for RLHF (Reinforcement Learning from Human Feedback) as it reduces memory requirements.",$e,V,ve,x,et="Above, we used <code>device_map=&quot;auto&quot;</code> to automatically assign the model to the correct device. You can also manually assign the model to a specific device using <code>device_map={&quot;&quot;: device_index}</code>. You could also scale training across multiple GPUs while keeping memory usage efficient.",Ze,Q,Ce,X,tt="After training a LoRA adapter, you can merge the adapter weights back into the base model. Here’s how to do it:",Re,q,ke,S,lt="If you encounter size discrepancies in the saved model, ensure you’re also saving the tokenizer:",Be,H,Ie,Y,Fe,P,at="The TRL <code>SFTTrainer</code> integrates natively with PEFT. Define a <code>LoraConfig</code>, pass it to the trainer, and train only the adapter weights.",_e,z,Ee,N,nt="After training, you can either:",Le,D,st="<li>Load adapters at inference time alongside the base model, or</li> <li>Merge adapters into the base model for simplified deployment.</li>",We,K,Ae,O,it='<li><a href="https://huggingface.co/papers/2106.09685" rel="nofollow">LoRA: Low-Rank Adaptation of Large Language Models</a></li> <li><a href="https://huggingface.co/docs/peft" rel="nofollow">PEFT Documentation</a></li> <li><a href="https://huggingface.co/blog/peft" rel="nofollow">Hugging Face blog post on PEFT</a></li>',Ge,ee,Ve,le,xe;return g=new y({props:{title:"LoRA and PEFT: Efficient Fine-Tuning",local:"lora-and-peft-efficient-fine-tuning",headingTag:"h1"}}),J=new y({props:{title:"When to use PEFT",local:"when-to-use-peft",headingTag:"h2"}}),j=new y({props:{title:"Understanding LoRA",local:"understanding-lora",headingTag:"h2"}}),C=new y({props:{title:"Loading LoRA Adapters",local:"loading-lora-adapters",headingTag:"h2"}}),k=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMiUzQ2Jhc2VfbW9kZWxfbmFtZSUzRSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyJTNDcGVmdF9hZGFwdGVyX2lkJTNFJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;&lt;base_model_name&gt;&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;&lt;peft_adapter_id&gt;&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),I=new y({props:{title:"Merging LoRA Adapters",local:"merging-lora-adapters",headingTag:"h2"}}),w=new yt({props:{$$slots:{default:[Tt]},$$scope:{ctx:ne}}}),L=new y({props:{title:"OLoRA",local:"olora",headingTag:"h2"}}),A=new y({props:{title:"Using TRL with PEFT",local:"using-trl-with-peft",headingTag:"h2"}}),V=new ae({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBJTIzJTIwTG9hZCUyMG1vZGVsJTIwd2l0aCUyMFBFRlQlMjBjb25maWclMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwciUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9hbHBoYSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKSUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMG9uJTIwc3BlY2lmaWMlMjBkZXZpY2UlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJ5b3VyLW1vZGVsLW5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTIwJTIwJTIzJTIwT3B0aW9uYWwlM0ElMjB1c2UlMjA4LWJpdCUyMHByZWNpc2lvbiUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0Rsb3JhX2NvbmZpZyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-comment"># Load model with PEFT config</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

<span class="hljs-comment"># Load model on specific device</span>
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;your-model-name&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Optional: use 8-bit precision</span>
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    peft_config=lora_config
)`,wrap:!1}}),Q=new y({props:{title:"Basic Merging Implementation",local:"basic-merging-implementation",headingTag:"h2"}}),q=new ae({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMFBlZnRNb2RlbCUwQSUwQSUyMyUyMDEuJTIwTG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmFzZV9tb2RlbF9uYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTBBKSUwQSUwQSUyMyUyMDIuJTIwTG9hZCUyMHRoZSUyMFBFRlQlMjBtb2RlbCUyMHdpdGglMjBhZGFwdGVyJTBBcGVmdF9tb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwYmFzZV9tb2RlbCUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhdGglMkZ0byUyRmFkYXB0ZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBkdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQSUyMyUyMDMuJTIwTWVyZ2UlMjBhZGFwdGVyJTIwd2VpZ2h0cyUyMHdpdGglMjBiYXNlJTIwbW9kZWwlMEF0cnklM0ElMEElMjAlMjAlMjAlMjBtZXJnZWRfbW9kZWwlMjAlM0QlMjBwZWZ0X21vZGVsLm1lcmdlX2FuZF91bmxvYWQoKSUwQWV4Y2VwdCUyMFJ1bnRpbWVFcnJvciUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJNZXJnaW5nJTIwZmFpbGVkJTNBJTIwJTdCZSU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjMlMjBJbXBsZW1lbnQlMjBmYWxsYmFjayUyMHN0cmF0ZWd5JTIwb3IlMjBtZW1vcnklMjBvcHRpbWl6YXRpb24lMEElMEElMjMlMjA0LiUyMFNhdmUlMjB0aGUlMjBtZXJnZWQlMjBtb2RlbCUwQW1lcmdlZF9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIycGF0aCUyRnRvJTJGc2F2ZSUyRm1lcmdlZF9tb2RlbCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

<span class="hljs-comment"># 1. Load the base model</span>
base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;base_model_name&quot;</span>,
    dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)

<span class="hljs-comment"># 2. Load the PEFT model with adapter</span>
peft_model = PeftModel.from_pretrained(
    base_model,
    <span class="hljs-string">&quot;path/to/adapter&quot;</span>,
    dtype=torch.bfloat16
)

<span class="hljs-comment"># 3. Merge adapter weights with base model</span>
<span class="hljs-keyword">try</span>:
    merged_model = peft_model.merge_and_unload()
<span class="hljs-keyword">except</span> RuntimeError <span class="hljs-keyword">as</span> e:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Merging failed: <span class="hljs-subst">{e}</span>&quot;</span>)
    <span class="hljs-comment"># Implement fallback strategy or memory optimization</span>

<span class="hljs-comment"># 4. Save the merged model</span>
merged_model.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)`,wrap:!1}}),H=new ae({props:{code:"JTIzJTIwU2F2ZSUyMGJvdGglMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJhc2VfbW9kZWxfbmFtZSUyMiklMEFtZXJnZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMnBhdGglMkZ0byUyRnNhdmUlMkZtZXJnZWRfbW9kZWwlMjIpJTBBdG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZzYXZlJTJGbWVyZ2VkX21vZGVsJTIyKQ==",highlighted:`<span class="hljs-comment"># Save both model and tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;base_model_name&quot;</span>)
merged_model.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;path/to/save/merged_model&quot;</span>)`,wrap:!1}}),Y=new y({props:{title:"Quick start with TRL + LoRA",local:"quick-start-with-trl--lora",headingTag:"h2"}}),z=new ae({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMkMlMjBTRlRDb25maWclMEElMEElMjMlMjAxKSUyMENvbmZpZ3VyZSUyMExvUkElMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwciUzRDglMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBJTIzJTIwMiklMjBDcmVhdGUlMjB0cmFpbmVyJTIwKGV4YW1wbGUpJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RTRlRDb25maWcob3V0cHV0X2RpciUzRCUyMmxvcmEtYWRhcHRlciUyMiUyQyUyMG51bV90cmFpbl9lcG9jaHMlM0QxJTJDJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEMiklMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCU1QiUyMnRyYWluJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0RwZWZ0X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHBhY2tpbmclM0RUcnVlJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, SFTConfig

<span class="hljs-comment"># 1) Configure LoRA</span>
peft_config = LoraConfig(
    r=<span class="hljs-number">8</span>,
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

<span class="hljs-comment"># 2) Create trainer (example)</span>
trainer = SFTTrainer(
    model=model,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;lora-adapter&quot;</span>, num_train_epochs=<span class="hljs-number">1</span>, per_device_train_batch_size=<span class="hljs-number">2</span>),
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    tokenizer=tokenizer,
    peft_config=peft_config,
    packing=<span class="hljs-literal">True</span>,
)
trainer.train()`,wrap:!1}}),K=new y({props:{title:"Resources",local:"resources",headingTag:"h1"}}),ee=new wt({props:{source:"https://github.com/huggingface/smol-course/blob/main/units/en/unit1/3a.md"}}),{c(){p=i("meta"),T=n(),h=i("p"),te=n(),m(g.$$.fragment),se=n(),b=i("p"),b.textContent=Qe,ie=n(),m(J.$$.fragment),oe=n(),U=i("ul"),U.innerHTML=Xe,re=n(),m(j.$$.fragment),pe=n(),$=i("p"),$.textContent=qe,me=n(),v=i("p"),v.innerHTML=Se,de=n(),Z=i("p"),Z.textContent=He,Me=n(),m(C.$$.fragment),ce=n(),R=i("p"),R.textContent=Ye,fe=n(),m(k.$$.fragment),ue=n(),B=i("p"),B.innerHTML=Pe,he=n(),m(I.$$.fragment),ye=n(),F=i("p"),F.textContent=ze,we=n(),_=i("p"),_.innerHTML=Ne,Te=n(),E=i("p"),E.textContent=De,ge=n(),m(w.$$.fragment),be=n(),m(L.$$.fragment),Je=n(),W=i("p"),W.innerHTML=Ke,Ue=n(),m(A.$$.fragment),je=n(),G=i("p"),G.textContent=Oe,$e=n(),m(V.$$.fragment),ve=n(),x=i("p"),x.innerHTML=et,Ze=n(),m(Q.$$.fragment),Ce=n(),X=i("p"),X.textContent=tt,Re=n(),m(q.$$.fragment),ke=n(),S=i("p"),S.textContent=lt,Be=n(),m(H.$$.fragment),Ie=n(),m(Y.$$.fragment),Fe=n(),P=i("p"),P.innerHTML=at,_e=n(),m(z.$$.fragment),Ee=n(),N=i("p"),N.textContent=nt,Le=n(),D=i("ul"),D.innerHTML=st,We=n(),m(K.$$.fragment),Ae=n(),O=i("ul"),O.innerHTML=it,Ge=n(),m(ee.$$.fragment),Ve=n(),le=i("p"),this.h()},l(e){const t=ut("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),T=s(e),h=o(e,"P",{}),rt(h).forEach(l),te=s(e),d(g.$$.fragment,e),se=s(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-dj8rbr"&&(b.textContent=Qe),ie=s(e),d(J.$$.fragment,e),oe=s(e),U=o(e,"UL",{"data-svelte-h":!0}),r(U)!=="svelte-1mvsu7l"&&(U.innerHTML=Xe),re=s(e),d(j.$$.fragment,e),pe=s(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-jvnjlq"&&($.textContent=qe),me=s(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1nturj5"&&(v.innerHTML=Se),de=s(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1ore9lv"&&(Z.textContent=He),Me=s(e),d(C.$$.fragment,e),ce=s(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-ykjqgo"&&(R.textContent=Ye),fe=s(e),d(k.$$.fragment,e),ue=s(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ljdidi"&&(B.innerHTML=Pe),he=s(e),d(I.$$.fragment,e),ye=s(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-159k8bc"&&(F.textContent=ze),we=s(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-8mb6ny"&&(_.innerHTML=Ne),Te=s(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-q31ewq"&&(E.textContent=De),ge=s(e),d(w.$$.fragment,e),be=s(e),d(L.$$.fragment,e),Je=s(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-17kc0j8"&&(W.innerHTML=Ke),Ue=s(e),d(A.$$.fragment,e),je=s(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-6e2mqf"&&(G.textContent=Oe),$e=s(e),d(V.$$.fragment,e),ve=s(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-w79t4p"&&(x.innerHTML=et),Ze=s(e),d(Q.$$.fragment,e),Ce=s(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1h2v14z"&&(X.textContent=tt),Re=s(e),d(q.$$.fragment,e),ke=s(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-j2a68t"&&(S.textContent=lt),Be=s(e),d(H.$$.fragment,e),Ie=s(e),d(Y.$$.fragment,e),Fe=s(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1o3osh"&&(P.innerHTML=at),_e=s(e),d(z.$$.fragment,e),Ee=s(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-lzynm4"&&(N.textContent=nt),Le=s(e),D=o(e,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-9cs1te"&&(D.innerHTML=st),We=s(e),d(K.$$.fragment,e),Ae=s(e),O=o(e,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-1pr7vnp"&&(O.innerHTML=it),Ge=s(e),d(ee.$$.fragment,e),Ve=s(e),le=o(e,"P",{}),rt(le).forEach(l),this.h()},h(){pt(p,"name","hf:doc:metadata"),pt(p,"content",bt)},m(e,t){ht(document.head,p),a(e,T,t),a(e,h,t),a(e,te,t),M(g,e,t),a(e,se,t),a(e,b,t),a(e,ie,t),M(J,e,t),a(e,oe,t),a(e,U,t),a(e,re,t),M(j,e,t),a(e,pe,t),a(e,$,t),a(e,me,t),a(e,v,t),a(e,de,t),a(e,Z,t),a(e,Me,t),M(C,e,t),a(e,ce,t),a(e,R,t),a(e,fe,t),M(k,e,t),a(e,ue,t),a(e,B,t),a(e,he,t),M(I,e,t),a(e,ye,t),a(e,F,t),a(e,we,t),a(e,_,t),a(e,Te,t),a(e,E,t),a(e,ge,t),M(w,e,t),a(e,be,t),M(L,e,t),a(e,Je,t),a(e,W,t),a(e,Ue,t),M(A,e,t),a(e,je,t),a(e,G,t),a(e,$e,t),M(V,e,t),a(e,ve,t),a(e,x,t),a(e,Ze,t),M(Q,e,t),a(e,Ce,t),a(e,X,t),a(e,Re,t),M(q,e,t),a(e,ke,t),a(e,S,t),a(e,Be,t),M(H,e,t),a(e,Ie,t),M(Y,e,t),a(e,Fe,t),a(e,P,t),a(e,_e,t),M(z,e,t),a(e,Ee,t),a(e,N,t),a(e,Le,t),a(e,D,t),a(e,We,t),M(K,e,t),a(e,Ae,t),a(e,O,t),a(e,Ge,t),M(ee,e,t),a(e,Ve,t),a(e,le,t),xe=!0},p(e,[t]){const ot={};t&2&&(ot.$$scope={dirty:t,ctx:e}),w.$set(ot)},i(e){xe||(c(g.$$.fragment,e),c(J.$$.fragment,e),c(j.$$.fragment,e),c(C.$$.fragment,e),c(k.$$.fragment,e),c(I.$$.fragment,e),c(w.$$.fragment,e),c(L.$$.fragment,e),c(A.$$.fragment,e),c(V.$$.fragment,e),c(Q.$$.fragment,e),c(q.$$.fragment,e),c(H.$$.fragment,e),c(Y.$$.fragment,e),c(z.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),xe=!0)},o(e){f(g.$$.fragment,e),f(J.$$.fragment,e),f(j.$$.fragment,e),f(C.$$.fragment,e),f(k.$$.fragment,e),f(I.$$.fragment,e),f(w.$$.fragment,e),f(L.$$.fragment,e),f(A.$$.fragment,e),f(V.$$.fragment,e),f(Q.$$.fragment,e),f(q.$$.fragment,e),f(H.$$.fragment,e),f(Y.$$.fragment,e),f(z.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),xe=!1},d(e){e&&(l(T),l(h),l(te),l(se),l(b),l(ie),l(oe),l(U),l(re),l(pe),l($),l(me),l(v),l(de),l(Z),l(Me),l(ce),l(R),l(fe),l(ue),l(B),l(he),l(ye),l(F),l(we),l(_),l(Te),l(E),l(ge),l(be),l(Je),l(W),l(Ue),l(je),l(G),l($e),l(ve),l(x),l(Ze),l(Ce),l(X),l(Re),l(ke),l(S),l(Be),l(Ie),l(Fe),l(P),l(_e),l(Ee),l(N),l(Le),l(D),l(We),l(Ae),l(O),l(Ge),l(Ve),l(le)),l(p),u(g,e),u(J,e),u(j,e),u(C,e),u(k,e),u(I,e),u(w,e),u(L,e),u(A,e),u(V,e),u(Q,e),u(q,e),u(H,e),u(Y,e),u(z,e),u(K,e),u(ee,e)}}}const bt='{"title":"LoRA and PEFT: Efficient Fine-Tuning","local":"lora-and-peft-efficient-fine-tuning","sections":[{"title":"When to use PEFT","local":"when-to-use-peft","sections":[],"depth":2},{"title":"Understanding LoRA","local":"understanding-lora","sections":[],"depth":2},{"title":"Loading LoRA Adapters","local":"loading-lora-adapters","sections":[],"depth":2},{"title":"Merging LoRA Adapters","local":"merging-lora-adapters","sections":[],"depth":2},{"title":"OLoRA","local":"olora","sections":[],"depth":2},{"title":"Using TRL with PEFT","local":"using-trl-with-peft","sections":[],"depth":2},{"title":"Basic Merging Implementation","local":"basic-merging-implementation","sections":[],"depth":2},{"title":"Quick start with TRL + LoRA","local":"quick-start-with-trl--lora","sections":[],"depth":2}],"depth":1}';function Jt(ne){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zt extends ct{constructor(p){super(),ft(this,p,Jt,gt,mt,{})}}export{Zt as component};
