import{s as mn,o as Tn,n as jn}from"../chunks/scheduler.f7e1785c.js";import{S as wn,i as cn,g as p,s as a,r as i,A as Un,h as M,f as t,c as n,j as Jn,u as J,x as y,k as Ks,y as rn,a as s,v as m,d as T,t as j,w}from"../chunks/index.9f8f0838.js";import{T as un}from"../chunks/Tip.4575d9cf.js";import{C as c}from"../chunks/CodeBlock.4baef5d7.js";import{H as u,E as hn}from"../chunks/getInferenceSnippets.ad8e59bc.js";function dn(Ge){let U,f=`В нашем примере мы будем использовать около 40 часов обучающих данных. Если вы хотите повторить этот процесс, используя бесплатный тарифный план Google Colab,
необходимо уменьшить объем обучающих данных примерно до 10-15 часов и сократить количество шагов обучения.`;return{c(){U=p("p"),U.textContent=f},l(r){U=M(r,"P",{"data-svelte-h":!0}),y(U)!=="svelte-1ywpoki"&&(U.textContent=f)},m(r,Ve){s(r,U,Ve)},p:jn,d(r){r&&t(U)}}}function on(Ge){let U,f,r,Ve,b,Be,C,Os=`Теперь, когда вы знакомы с задачей преобразования текста в речь и внутренним устройством модели SpeechT5, которая была предварительно обучена
на англоязычных данных, давайте посмотрим, как мы можем дообучить ее для другого языка.`,We,I,ve,$,la="Если вы хотите воспроизвести этот пример, убедитесь, что у вас есть графический процессор. В блокноте это можно проверить с помощью следующей команды:",Xe,Z,Ee,h,Ye,k,ea="Вам также понадобятся некоторые дополнительные зависимости:",Ne,R,De,x,ta="Наконец, не забудьте войти в свою учетную запись Hugging Face, чтобы загрузить свою модель и поделиться ею с сообществом:",ze,A,Fe,Q,He,g,sa=`В данном примере мы возьмем подмножество голландского (<code>nl</code>) языка из датасета <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a>.
<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> - это обширный многоязычный речевой корпус, состоящий из данных,
полученных из записей мероприятий Европейского парламента 2009-2020 гг. Он содержит маркированные данные аудио-транскрипций для 15 европейских языков.
Хотя мы будем использовать подмножество голландского языка, вы можете выбрать другое подмножество.`,qe,V,aa=`Это набор данных автоматического распознавания речи (ASR), поэтому, как уже говорилось, он не является наиболее подходящим
вариантом для обучения TTS-моделей. Однако для данного упражнения этого будет вполне достаточно.`,Se,_,na="Давайте загрузим данные:",Le,G,Pe,B,pa="<strong>Output:</strong>",Ke,W,Oe,v,Ma=`20968 примеров должно быть достаточно для дообучения. Для SpeechT5 требуется, чтобы частота дискретизации аудиоданных составляла 16 кГц, поэтому
убедимся, что примеры в наборе данных соответствуют этому требованию:`,lt,X,et,E,tt,Y,ya=`Начнем с определения используемой контрольной точки модели и загрузки соответствующего процессора, содержащего как токенизатор,
так и экстрактор признаков, которые понадобятся нам для подготовки данных к обучению:`,st,N,at,D,nt,z,ia="Во-первых, для подготовки текста нам понадобится часть процессора - токенизатор, поэтому возьмем его:",pt,F,Mt,H,Ja="Рассмотрим пример:",yt,q,it,S,ma="<strong>Output:</strong>",Jt,L,mt,P,Ta=`Можно заметить, что примеры из датасета содержат признаки <code>raw_text</code> и <code>normalized_text</code>. При выборе признака
в качестве входного текста важно знать, что в токенизаторе SpeechT5 нет токенов для чисел. В <code>normalized_text</code>
числа записываются в виде текста. Таким образом, он лучше подходит, и в качестве входного текста следует использовать <code>normalized_text</code>.`,Tt,K,ja=`Поскольку SpeechT5 обучалась на английском языке, она может не распознать некоторые символы в голландском наборе данных. Если
оставить все как есть, то эти символы будут преобразованы в токены <code>&lt;unk&gt;</code>. Однако в голландском языке некоторые символы, например <code>à</code>, используются
для выделения слогов. Чтобы сохранить смысл текста, можно заменить этот символ на обычное <code>a</code>.`,jt,O,wa=`Чтобы выявить неподдерживаемые токены, извлечем все уникальные символы из датасета с помощью <code>SpeechT5Tokenizer</code>, который
работает с символами как с токенами. Для этого напишем функцию отображения <code>extract_all_chars</code>, которая объединяет
транскрипции из всех примеров в одну строку и преобразует ее в набор символов. [NL]
Обязательно задайте <code>batched=True</code> и <code>batch_size=-1</code> в <code>dataset.map()</code>, чтобы все транскрипции были доступны сразу для
функции отображения.`,wt,ll,ct,el,ca=`Теперь у вас есть два набора символов: один со словарем из датасета, другой - со словарем из токенизатора.
Для выявления неподдерживаемых символов в наборе данных можно взять разность между этими двумя наборами. Полученный набор
будет содержать символы, которые есть в наборе данных, но отсутствуют в токенизаторе.`,Ut,tl,rt,sl,Ua="<strong>Output:</strong>",ut,al,ht,nl,ra=`Для работы с неподдерживаемыми символами, выявленными на предыдущем этапе, можно определить функцию, которая сопоставляет эти символы с допустимыми токенами.
Заметим, что пробелы уже заменены на <code>▁</code> в токенизаторе и не нуждаются в отдельной обработке.`,dt,pl,ot,Ml,ua="Теперь, когда мы разобрались со специальными символами в тексте, пришло время переключить внимание на аудио данные.",ft,yl,bt,il,ha=`Набор данных VoxPopuli включает речь нескольких дикторов, но сколько дикторов представлено в наборе? Чтобы
определить это, мы можем подсчитать количество уникальных дикторов и количество примеров, которые каждый диктор вносит в набор данных.
Учитывая, что всего в наборе данных 20 968 примеров, эта информация позволит нам лучше понять распределение
дикторов и примеров в данных.`,Ct,Jl,It,ml,da="Построив гистограмму, можно получить представление о том, сколько данных имеется для каждого диктора.",$t,Tl,Zt,d,oa='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',kt,jl,fa=`Гистограмма показывает, что примерно треть дикторов в наборе данных имеет менее 100 примеров, в то время как
около десяти дикторов имеют более 500 примеров. Чтобы повысить эффективность обучения и сбалансировать набор данных, мы можем ограничить
данные дикторами, имеющими от 100 до 400 примеров.`,Rt,wl,xt,cl,ba="Проверим, сколько осталось дикторов:",At,Ul,Qt,rl,Ca="<strong>Output:</strong>",gt,ul,Vt,hl,Ia="Посмотрим, сколько осталось примеров:",_t,dl,Gt,ol,$a="<strong>Output:</strong>",Bt,fl,Wt,bl,Za="В результате вы получаете чуть менее 10 000 примеров из примерно 40 уникальных дикторов, что должно быть вполне достаточно.",vt,Cl,ka=`Отметим, что некоторые дикторы с небольшим количеством примеров могут иметь больше аудиофайлов, если примеры длинные. Однако
определение общего объема аудиозаписей для каждого диктора требует сканирования всего датасета, что является
трудоемким процессом, включающим загрузку и декодирование каждого аудиофайла. Поэтому в данном случае мы решили пропустить этот этап.`,Xt,Il,Et,$l,Ra=`Для того чтобы модель TTS могла различать несколько дикторов, необходимо создать эмбеддинги диктора для каждого примера.
Эмбеддинги дикторов - это дополнительный вход для модели, который фиксирует характеристики голоса конкретного диктора.
Для создания эмбеддингов диктора используется предварительно обученная модель <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a>
от SpeechBrain.`,Yt,Zl,xa=`Создадим функцию <code>create_speaker_embedding()</code>, которая принимает входную волновую форму звука и выдает 512-элементный вектор,
содержащий соответствующие эмбеддинги диктора.`,Nt,kl,Dt,Rl,Aa=`Важно отметить, что модель <code>speechbrain/spkrec-xvect-voxceleb</code> была обучена на английской речи из датасета VoxCeleb,
в то время как учебные примеры в данном руководстве представлены на голландском языке. Хотя мы считаем, что данная модель все равно будет генерировать разумные эмбеддинги диктора
для нашего голландского датасета, это предположение может быть справедливо не во всех случаях.`,zt,xl,Qa=`Для получения оптимальных результатов необходимо сначала обучить модель X-вектора на целевой речи. Это позволит модели
лучше улавливать уникальные речевые особенности, присущие голландскому языку. Если вы хотите обучить свою собственную X-векторную модель,
то в качестве примера можно использовать <a href="https://huggingface.co/mechanicalsea/speecht5-vc/blob/main/manifest/utils/prep_cmu_arctic_spkemb.py" rel="nofollow">этот скрипт</a>.`,Ft,Al,Ht,Ql,ga=`Наконец, обработаем данные в тот формат, который ожидает модель. Создадим функцию <code>prepare_dataset</code>, которая принимает
один пример и использует объект <code>SpeechT5Processor</code> для токенизации входного текста и загрузки целевого аудио в лог-мел спектрограмму.
Она также должна добавлять эмбеддинги диктора в качестве дополнительного входного сигнала.`,qt,gl,St,Vl,Va="Проверить правильность обработки можно на одном из примеров:",Lt,_l,Pt,Gl,_a="<strong>Output:</strong>",Kt,Bl,Ot,Wl,Ga="Эмбеддинги диктора должны представлять собой 512-элементный вектор:",ls,vl,es,Xl,Ba="<strong>Output:</strong>",ts,El,ss,Yl,Wa="Метки должны представлять собой лог-мел спектрограмму с 80 мел бинами.",as,Nl,ns,o,va='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',ps,Dl,Xa=`Примечание: Если данная спектрограмма кажется вам непонятной, то это может быть связано с тем, что вы привыкли располагать низкие частоты
внизу, а высокие - вверху графика. Однако при построении спектрограмм в виде изображения с помощью библиотеки matplotlib ось y
переворачивается, и спектрограммы выглядят перевернутыми.`,Ms,zl,Ea="Теперь необходимо применить функцию препроцессинга ко всему набору данных. Это займет от 5 до 10 минут.",ys,Fl,is,Hl,Ya=`Появится предупреждение о том, что длина некоторых примеров в датасете превышает максимальную длину входных данных, которую может обработать модель (600 лексем).
Удалите эти примеры из датасета. Здесь мы идем еще дальше и для того, чтобы увеличить размер батча, удаляем все, что превышает 200 токенов.`,Js,ql,ms,Sl,Na="<strong>Output:</strong>",Ts,Ll,js,Pl,Da="Затем создадим базовое разделение на тренировочную и тестовую части:",ws,Kl,cs,Ol,Us,le,za=`Для того чтобы объединить несколько примеров в батч, необходимо определить пользовательский коллатор данных. Этот коллатор будет дополнять более короткие последовательности токенами,
гарантируя, что все примеры будут иметь одинаковую длину. Для меток спектрограммы дополняемая части заменяются на специальное значение <code>-100</code>.
Это специальное значение указывает модели игнорировать эту часть спектрограммы при расчете потерь спектрограммы.`,rs,ee,us,te,Fa=`В SpeechT5 входная информация для декодера уменьшается в 2 раза. Другими словами, отбрасывается каждый второй
временной шаг из целевой последовательности.Затем декодер предсказывает последовательность, которая в два раза длиннее. Поскольку исходная длина
целевой последовательности [NL] может быть нечетной, коллатор данных обязательно округляет максимальную длину батча до значения [NL], кратного 2.`,hs,se,ds,ae,os,ne,Ha="Загрузите предварительно обученную модель из той же контрольной точки, которая использовалась для загрузки процессора:",fs,pe,bs,Me,qa=`Опция <code>use_cache=True</code> несовместима с использованием градиентных контрольных точек. Отключите ее для обучения и снова включите кэш для генерации,
чтобы ускорить  инференс:`,Cs,ye,Is,ie,Sa=`Определим аргументы обучения. Здесь мы не вычисляем никаких оценочных метрик в процессе обучения,
мы поговорим об оценке позже в этой главе. Вместо этого мы будем рассматривать только потери:`,$s,Je,Zs,me,La="Инстанцируем объект <code>Trainer</code> и передаем ему модель, набор данных и коллатор данных.",ks,Te,Rs,je,Pa=`И с этим мы готовы приступить к обучению! Обучение займет несколько часов. В зависимости от используемого GPU
возможно, что при начале обучения возникнет ошибка CUDA “out-of-memory”. В этом случае можно уменьшить
размер <code>per_device_train_batch_size</code> постепенно в 2 раза и увеличить <code>gradient_accumulation_steps</code> в 2 раза, чтобы компенсировать это.`,xs,we,As,ce,Ka="Push the final model to the 🤗 Hub:",Qs,Ue,gs,re,Vs,ue,Oa=`После того как модель дообучена, ее можно использовать для инференса! Загрузите модель из 🤗 Hub (убедитесь, что в
следующем фрагменте кода используется имя вашей учетной записи):`,_s,he,Gs,de,ln="Выберем пример, здесь мы возьмем пример из тестового набора данных. Получаем эмбеддинги диктора.",Bs,oe,Ws,fe,en="Определим некоторый входной текст и токенизируем его.",vs,be,Xs,Ce,tn="Выполним препроцессинг входного текста:",Es,Ie,Ys,$e,sn="Инстанцируем вокодер и сгенерируем речь:",Ns,Ze,Ds,ke,an="Готовы послушать результат?",zs,Re,Fs,xe,nn=`Получение удовлетворительных результатов с помощью этой модели на новом языке может оказаться непростой задачей. Качество эмбеддингов диктора
может быть существенным фактором. Поскольку SpeechT5 была предварительно обучена на английских x-векторах, она показывает наилучшие результаты
при использовании эмбеддингов английских дикторов. Если синтезированная речь звучит плохо, попробуйте использовать другие эмбеддинги диктора.`,Hs,Ae,pn=`Увеличение продолжительности обучения, вероятно, также повысит качество результатов. Несмотря на это, речь явно голландская, а не английская, и в ней
передаются особенности голоса говорящего (сравните с оригинальным аудио в примере).
Еще один момент, с которым можно поэкспериментировать, - это настройка модели. Например, попробуйте использовать <code>config.reduction_factor = 1</code>, чтобы
посмотреть, улучшит ли это результаты.`,qs,Qe,Mn="В следующем разделе мы расскажем о том, как мы оцениваем модели преобразования текста в речь.",Ss,ge,Ls,_e,Ps;return b=new u({props:{title:"Дообучение SpeechT5",local:"дообучение-speecht5",headingTag:"h1"}}),I=new u({props:{title:"House-keeping",local:"house-keeping",headingTag:"h2"}}),Z=new c({props:{code:"bnZpZGlhLXNtaQ==",highlighted:"nvidia-smi",wrap:!1}}),h=new un({props:{warning:!0,$$slots:{default:[dn]},$$scope:{ctx:Ge}}}),R=new c({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install transformers datasets soundfile speechbrain accelerate",wrap:!1}}),A=new c({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Q=new u({props:{title:"Набор данных",local:"набор-данных",headingTag:"h2"}}),G=new c({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),W=new c({props:{code:"MjA5Njg=",highlighted:"20968",wrap:!1}}),X=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))',wrap:!1}}),E=new u({props:{title:"Препроцессинг данных",local:"препроцессинг-данных",headingTag:"h2"}}),N=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
processor = SpeechT5Processor.from_pretrained(checkpoint)`,wrap:!1}}),D=new u({props:{title:"Очистка текста для токенизации SpeechT5",local:"очистка-текста-для-токенизации-speecht5",headingTag:"h3"}}),F=new c({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:"tokenizer = processor.tokenizer",wrap:!1}}),q=new c({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:'dataset[<span class="hljs-number">0</span>]',wrap:!1}}),L=new c({props:{code:"JTdCJ2F1ZGlvX2lkJyUzQSUyMCcyMDEwMDIxMC0wOTAwLVBMRU5BUlktMy1ubF8yMDEwMDIxMC0wOSUzQTA2JTNBNDNfNCclMkMlMEElMjAnbGFuZ3VhZ2UnJTNBJTIwOSUyQyUwQSUyMCdhdWRpbyclM0ElMjAlN0IncGF0aCclM0ElMjAnJTJGcm9vdCUyRi5jYWNoZSUyRmh1Z2dpbmdmYWNlJTJGZGF0YXNldHMlMkZkb3dubG9hZHMlMkZleHRyYWN0ZWQlMkYwMmVjNmExOWQ1Yjk3YzAzZTEzNzkyNTAzNzg0NTRkYmYzZmEyOTcyOTQzNTA0YTkxYzdkYTUwNDVhYTI2YTg5JTJGdHJhaW5fcGFydF8wJTJGMjAxMDAyMTAtMDkwMC1QTEVOQVJZLTMtbmxfMjAxMDAyMTAtMDklM0EwNiUzQTQzXzQud2F2JyUyQyUwQSUyMCUyMCdhcnJheSclM0ElMjBhcnJheSglNUIlMjA0LjI3MjQ2MDk0ZS0wNCUyQyUyMCUyMDEuMzEyMjU1ODZlLTAzJTJDJTIwJTIwMS4wMzc1OTc2NmUtMDMlMkMlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtOS4xNTUyNzM0NGUtMDUlMkMlMjAlMjA3LjYyOTM5NDUzZS0wNCUyQyUyMC0yLjQ0MTQwNjI1ZS0wNCU1RCklMkMlMEElMjAlMjAnc2FtcGxpbmdfcmF0ZSclM0ElMjAxNjAwMCU3RCUyQyUwQSUyMCdyYXdfdGV4dCclM0ElMjAnRGF0JTIwa2FuJTIwbmFhciUyMG1pam4lMjBnZXZvZWwlMjBhbGxlZW4lMjBtZXQlMjBlZW4lMjBicmVkZSUyMG1lZXJkZXJoZWlkJTIwZGllJTIwd2lqJTIwc2FtZW4lMjB6b2VrZW4uJyUyQyUwQSUyMCdub3JtYWxpemVkX3RleHQnJTNBJTIwJ2RhdCUyMGthbiUyMG5hYXIlMjBtaWpuJTIwZ2V2b2VsJTIwYWxsZWVuJTIwbWV0JTIwZWVuJTIwYnJlZGUlMjBtZWVyZGVyaGVpZCUyMGRpZSUyMHdpaiUyMHNhbWVuJTIwem9la2VuLiclMkMlMEElMjAnZ2VuZGVyJyUzQSUyMCdmZW1hbGUnJTJDJTBBJTIwJ3NwZWFrZXJfaWQnJTNBJTIwJzExMjInJTJDJTBBJTIwJ2lzX2dvbGRfdHJhbnNjcmlwdCclM0ElMjBUcnVlJTJDJTBBJTIwJ2FjY2VudCclM0ElMjAnTm9uZSclN0Q=",highlighted:`{&#x27;audio_id&#x27;: &#x27;<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4&#x27;,
 &#x27;language&#x27;: <span class="hljs-number">9</span>,
 &#x27;audio&#x27;: {&#x27;path&#x27;: &#x27;/root/.cache/huggingface/datasets/downloads/extracted/02ec6a19d5b97c03e<span class="hljs-number">137925037845</span>4dbf3fa<span class="hljs-number">2972943504</span>a91c7da<span class="hljs-number">5045</span>aa26a89/train_part_0/<span class="hljs-number">20100210-0900</span>-PLENARY-3-nl_<span class="hljs-number">20100210-09:06:43</span>_4.wav&#x27;,
  &#x27;array&#x27;: array([ <span class="hljs-number">4.27246094</span>e-<span class="hljs-number">04</span>,  <span class="hljs-number">1.31225586</span>e-<span class="hljs-number">03</span>,  <span class="hljs-number">1.03759766</span>e-<span class="hljs-number">03</span>, ...,
         -<span class="hljs-number">9.15527344</span>e-<span class="hljs-number">05</span>,  <span class="hljs-number">7.62939453</span>e-<span class="hljs-number">04</span>, -<span class="hljs-number">2.44140625</span>e-<span class="hljs-number">04</span>]),
  &#x27;sampling_rate&#x27;: <span class="hljs-number">16000</span>},
 &#x27;raw_text&#x27;: &#x27;Dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;normalized_text&#x27;: &#x27;dat kan naar mijn gevoel alleen met een brede meerderheid die wij samen zoeken.&#x27;,
 &#x27;gender&#x27;: &#x27;female&#x27;,
 &#x27;speaker_id&#x27;: &#x27;<span class="hljs-number">1122</span>&#x27;,
 &#x27;is_gold_transcript&#x27;: True,
 &#x27;accent&#x27;: &#x27;None&#x27;}`,wrap:!1}}),ll=new c({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


vocabs = dataset.<span class="hljs-built_in">map</span>(
    extract_all_chars,
    batched=<span class="hljs-literal">True</span>,
    batch_size=-<span class="hljs-number">1</span>,
    keep_in_memory=<span class="hljs-literal">True</span>,
    remove_columns=dataset.column_names,
)

dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`,wrap:!1}}),tl=new c({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:"dataset_vocab - tokenizer_vocab",wrap:!1}}),al=new c({props:{code:"JTdCJyUyMCclMkMlMjAnJUMzJUEwJyUyQyUyMCclQzMlQTcnJTJDJTIwJyVDMyVBOCclMkMlMjAnJUMzJUFCJyUyQyUyMCclQzMlQUQnJTJDJTIwJyVDMyVBRiclMkMlMjAnJUMzJUI2JyUyQyUyMCclQzMlQkMnJTdE",highlighted:"{&#x27; &#x27;, &#x27;à&#x27;, &#x27;ç&#x27;, &#x27;è&#x27;, &#x27;ë&#x27;, &#x27;í&#x27;, &#x27;ï&#x27;, &#x27;ö&#x27;, &#x27;ü&#x27;}",wrap:!1}}),pl=new c({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`replacements = [
    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
    <span class="hljs-keyword">return</span> inputs


dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`,wrap:!1}}),yl=new u({props:{title:"Дикторы",local:"дикторы",headingTag:"h3"}}),Jl=new c({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`,wrap:!1}}),Tl=new c({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
plt.show()`,wrap:!1}}),wl=new c({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`,wrap:!1}}),Ul=new c({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:'<span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))',wrap:!1}}),ul=new c({props:{code:"NDI=",highlighted:"42",wrap:!1}}),dl=new c({props:{code:"bGVuKGRhdGFzZXQp",highlighted:'<span class="hljs-built_in">len</span>(dataset)',wrap:!1}}),fl=new c({props:{code:"OTk3Mw==",highlighted:'<span class="hljs-number">9973</span>',wrap:!1}}),Il=new u({props:{title:"Эмбеддинги диктора",local:"эмбеддинги-диктора",headingTag:"h3"}}),kl=new c({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5wcmV0cmFpbmVkJTIwaW1wb3J0JTIwRW5jb2RlckNsYXNzaWZpZXIlMEElMEFzcGtfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnNwZWVjaGJyYWluJTJGc3BrcmVjLXh2ZWN0LXZveGNlbGViJTIyJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFzcGVha2VyX21vZGVsJTIwJTNEJTIwRW5jb2RlckNsYXNzaWZpZXIuZnJvbV9ocGFyYW1zKCUwQSUyMCUyMCUyMCUyMHNvdXJjZSUzRHNwa19tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcnVuX29wdHMlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBzYXZlZGlyJTNEb3MucGF0aC5qb2luKCUyMiUyRnRtcCUyMiUyQyUyMHNwa19tb2RlbF9uYW1lKSUyQyUwQSklMEElMEElMEFkZWYlMjBjcmVhdGVfc3BlYWtlcl9lbWJlZGRpbmcod2F2ZWZvcm0pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHNwZWFrZXJfbW9kZWwuZW5jb2RlX2JhdGNoKHRvcmNoLnRlbnNvcih3YXZlZm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5ub3JtYWxpemUoc3BlYWtlcl9lbWJlZGRpbmdzJTJDJTIwZGltJTNEMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX2VtYmVkZGluZ3Muc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVha2VyX2VtYmVkZGluZ3M=",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> speechbrain.pretrained <span class="hljs-keyword">import</span> EncoderClassifier

spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
speaker_model = EncoderClassifier.from_hparams(
    source=spk_model_name,
    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
    <span class="hljs-keyword">with</span> torch.no_grad():
        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
    <span class="hljs-keyword">return</span> speaker_embeddings`,wrap:!1}}),Al=new u({props:{title:"Обработка датасета",local:"обработка-датасета",headingTag:"h3"}}),gl=new c({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBzdHJpcCUyMG9mZiUyMHRoZSUyMGJhdGNoJTIwZGltZW5zaW9uJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGV4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQlNUIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwdXNlJTIwU3BlZWNoQnJhaW4lMjB0byUyMG9idGFpbiUyMHgtdmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        return_attention_mask=<span class="hljs-literal">False</span>,
    )

    <span class="hljs-comment"># strip off the batch dimension</span>
    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

    <span class="hljs-comment"># use SpeechBrain to obtain x-vector</span>
    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

    <span class="hljs-keyword">return</span> example`,wrap:!1}}),_l=new c({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-built_in">list</span>(processed_example.keys())`,wrap:!1}}),Bl=new c({props:{code:"JTVCJ2lucHV0X2lkcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdzdG9wX2xhYmVscyclMkMlMjAnc3BlYWtlcl9lbWJlZGRpbmdzJyU1RA==",highlighted:'[<span class="hljs-symbol">&#x27;input_ids</span>&#x27;, <span class="hljs-symbol">&#x27;labels</span>&#x27;, <span class="hljs-symbol">&#x27;stop_labels</span>&#x27;, <span class="hljs-symbol">&#x27;speaker_embeddings</span>&#x27;]',wrap:!1}}),vl=new c({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:'processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape',wrap:!1}}),El=new c({props:{code:"KDUxMiUyQyk=",highlighted:'(<span class="hljs-number">512</span><span class="hljs-punctuation">,</span>)',wrap:!1}}),Nl=new c({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.figure()
plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
plt.show()`,wrap:!1}}),Fl=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)',wrap:!1}}),ql=new c({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
    input_length = <span class="hljs-built_in">len</span>(input_ids)
    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-built_in">len</span>(dataset)`,wrap:!1}}),Ll=new c({props:{code:"ODI1OQ==",highlighted:'<span class="hljs-number">8259</span>',wrap:!1}}),Kl=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)',wrap:!1}}),Ol=new u({props:{title:"Коллатор данных",local:"коллатор-данных",headingTag:"h3"}}),ee=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

        <span class="hljs-comment"># collate the inputs and targets into a batch</span>
        batch = processor.pad(
            input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
        )

        <span class="hljs-comment"># replace padding with -100 to ignore loss correctly</span>
        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(
            batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># not used during fine-tuning</span>
        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

        <span class="hljs-comment"># round down target lengths to multiple of reduction factor</span>
        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
            target_lengths = torch.tensor(
                [<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features]
            )
            target_lengths = target_lengths.new(
                [
                    length - length % model.config.reduction_factor
                    <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths
                ]
            )
            max_length = <span class="hljs-built_in">max</span>(target_lengths)
            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

        <span class="hljs-comment"># also add in the speaker embeddings</span>
        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),se=new c({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:"data_collator = TTSDataCollatorWithPadding(processor=processor)",wrap:!1}}),ae=new u({props:{title:"Обучение модели",local:"обучение-модели",headingTag:"h2"}}),pe=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`,wrap:!1}}),ye=new c({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjAlRDAlQkUlRDElODIlRDAlQkElRDAlQkIlRDElOEUlRDElODclRDAlQjglRDElODIlRDElOEMlMjAlRDAlQkElRDElOEQlRDElODglMjAlRDAlQjIlRDAlQkUlMjAlRDAlQjIlRDElODAlRDAlQjUlRDAlQkMlRDElOEYlMjAlRDAlQkUlRDAlQjElRDElODMlRDElODclRDAlQjUlRDAlQkQlRDAlQjglRDElOEYlMkMlMjAlRDElODIlRDAlQjAlRDAlQkElMjAlRDAlQkElRDAlQjAlRDAlQkElMjAlRDAlQkUlRDAlQkQlMjAlRDAlQkQlRDAlQjUlRDElODElRDAlQkUlRDAlQjIlRDAlQkMlRDAlQjUlRDElODElRDElODIlRDAlQjglRDAlQkMlMjAlRDElODElMjAlRDAlQjMlRDElODAlRDAlQjAlRDAlQjQlRDAlQjglRDAlQjUlRDAlQkQlRDElODIlRDAlQkQlRDElOEIlRDAlQkMlRDAlQjglMjAlRDAlQkElRDAlQkUlRDAlQkQlRDElODIlRDElODAlRDAlQkUlRDAlQkIlRDElOEMlRDAlQkQlRDElOEIlRDAlQkMlRDAlQjglMjAlRDElODIlRDAlQkUlRDElODclRDAlQkElRDAlQjAlRDAlQkMlRDAlQjglMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjAlRDAlQjclRDAlQjAlRDAlQjQlRDAlQjAlRDAlQkQlRDAlQjglRDAlQkMlMjAlRDElOEYlRDAlQjclRDElOEIlRDAlQkElMjAlRDAlQjglMjAlRDAlQjclRDAlQjAlRDAlQjQlRDAlQjAlRDElODclRDElODMlMjAlRDAlQjQlRDAlQkIlRDElOEYlMjAlRDAlQjMlRDAlQjUlRDAlQkQlRDAlQjUlRDElODAlRDAlQjAlRDElODYlRDAlQjglRDAlQjglMjAlRDAlQjglMjAlRDElODElRDAlQkQlRDAlQkUlRDAlQjIlRDAlQjAlMjAlRDAlQjIlRDAlQkElRDAlQkIlRDElOEUlRDElODclRDAlQjglRDAlQkMlMjAlRDAlQkElRDElOEQlRDElODglMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwobW9kZWwuZ2VuZXJhdGUlMkMlMjB1c2VfY2FjaGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># отключить кэш во время обучения, так как он несовместим с градиентными контрольными точками</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># заданим язык и задачу для генерации и снова включим кэш</span>
model.generate = partial(model.generate, use_cache=<span class="hljs-literal">True</span>)`,wrap:!1}}),Je=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjBjaGFuZ2UlMjB0byUyMGElMjByZXBvJTIwbmFtZSUyMG9mJTIweW91ciUyMGNob2ljZSUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjB3YXJtdXBfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q0MDAwJTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdGVwcyUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlNUIlMjJ0ZW5zb3Jib2FyZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3JlYXRlcl9pc19iZXR0ZXIlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX25hbWVzJTNEJTVCJTIybGFiZWxzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># change to a repo name of your choice</span>
    per_device_train_batch_size=<span class="hljs-number">4</span>,
    gradient_accumulation_steps=<span class="hljs-number">8</span>,
    learning_rate=<span class="hljs-number">1e-5</span>,
    warmup_steps=<span class="hljs-number">500</span>,
    max_steps=<span class="hljs-number">4000</span>,
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">2</span>,
    save_steps=<span class="hljs-number">1000</span>,
    eval_steps=<span class="hljs-number">1000</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
    push_to_hub=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),Te=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    tokenizer=processor,
)`,wrap:!1}}),we=new c({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),Ue=new c({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()",wrap:!1}}),re=new u({props:{title:"Инференс",local:"инференс",headingTag:"h2"}}),he=new c({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyWU9VUl9BQ0NPVU5UJTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMiUwQSk=",highlighted:`model = SpeechT5ForTextToSpeech.from_pretrained(
    <span class="hljs-string">&quot;YOUR_ACCOUNT/speecht5_finetuned_voxpopuli_nl&quot;</span>
)`,wrap:!1}}),oe=new c({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),be=new c({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>',wrap:!1}}),Ie=new c({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),Ze=new c({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1SGlmaUdhbiUwQSUwQXZvY29kZXIlMjAlM0QlMjBTcGVlY2hUNUhpZmlHYW4uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X2hpZmlnYW4lMjIpJTBBc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyQyUyMHZvY29kZXIlM0R2b2NvZGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5HifiGan

vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>)
speech = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings, vocoder=vocoder)`,wrap:!1}}),Re=new c({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),ge=new hn({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/ru/chapter6/fine-tuning.mdx"}}),{c(){U=p("meta"),f=a(),r=p("p"),Ve=a(),i(b.$$.fragment),Be=a(),C=p("p"),C.textContent=Os,We=a(),i(I.$$.fragment),ve=a(),$=p("p"),$.textContent=la,Xe=a(),i(Z.$$.fragment),Ee=a(),i(h.$$.fragment),Ye=a(),k=p("p"),k.textContent=ea,Ne=a(),i(R.$$.fragment),De=a(),x=p("p"),x.textContent=ta,ze=a(),i(A.$$.fragment),Fe=a(),i(Q.$$.fragment),He=a(),g=p("p"),g.innerHTML=sa,qe=a(),V=p("p"),V.textContent=aa,Se=a(),_=p("p"),_.textContent=na,Le=a(),i(G.$$.fragment),Pe=a(),B=p("p"),B.innerHTML=pa,Ke=a(),i(W.$$.fragment),Oe=a(),v=p("p"),v.textContent=Ma,lt=a(),i(X.$$.fragment),et=a(),i(E.$$.fragment),tt=a(),Y=p("p"),Y.textContent=ya,st=a(),i(N.$$.fragment),at=a(),i(D.$$.fragment),nt=a(),z=p("p"),z.textContent=ia,pt=a(),i(F.$$.fragment),Mt=a(),H=p("p"),H.textContent=Ja,yt=a(),i(q.$$.fragment),it=a(),S=p("p"),S.innerHTML=ma,Jt=a(),i(L.$$.fragment),mt=a(),P=p("p"),P.innerHTML=Ta,Tt=a(),K=p("p"),K.innerHTML=ja,jt=a(),O=p("p"),O.innerHTML=wa,wt=a(),i(ll.$$.fragment),ct=a(),el=p("p"),el.textContent=ca,Ut=a(),i(tl.$$.fragment),rt=a(),sl=p("p"),sl.innerHTML=Ua,ut=a(),i(al.$$.fragment),ht=a(),nl=p("p"),nl.innerHTML=ra,dt=a(),i(pl.$$.fragment),ot=a(),Ml=p("p"),Ml.textContent=ua,ft=a(),i(yl.$$.fragment),bt=a(),il=p("p"),il.textContent=ha,Ct=a(),i(Jl.$$.fragment),It=a(),ml=p("p"),ml.textContent=da,$t=a(),i(Tl.$$.fragment),Zt=a(),d=p("div"),d.innerHTML=oa,kt=a(),jl=p("p"),jl.textContent=fa,Rt=a(),i(wl.$$.fragment),xt=a(),cl=p("p"),cl.textContent=ba,At=a(),i(Ul.$$.fragment),Qt=a(),rl=p("p"),rl.innerHTML=Ca,gt=a(),i(ul.$$.fragment),Vt=a(),hl=p("p"),hl.textContent=Ia,_t=a(),i(dl.$$.fragment),Gt=a(),ol=p("p"),ol.innerHTML=$a,Bt=a(),i(fl.$$.fragment),Wt=a(),bl=p("p"),bl.textContent=Za,vt=a(),Cl=p("p"),Cl.textContent=ka,Xt=a(),i(Il.$$.fragment),Et=a(),$l=p("p"),$l.innerHTML=Ra,Yt=a(),Zl=p("p"),Zl.innerHTML=xa,Nt=a(),i(kl.$$.fragment),Dt=a(),Rl=p("p"),Rl.innerHTML=Aa,zt=a(),xl=p("p"),xl.innerHTML=Qa,Ft=a(),i(Al.$$.fragment),Ht=a(),Ql=p("p"),Ql.innerHTML=ga,qt=a(),i(gl.$$.fragment),St=a(),Vl=p("p"),Vl.textContent=Va,Lt=a(),i(_l.$$.fragment),Pt=a(),Gl=p("p"),Gl.innerHTML=_a,Kt=a(),i(Bl.$$.fragment),Ot=a(),Wl=p("p"),Wl.textContent=Ga,ls=a(),i(vl.$$.fragment),es=a(),Xl=p("p"),Xl.innerHTML=Ba,ts=a(),i(El.$$.fragment),ss=a(),Yl=p("p"),Yl.textContent=Wa,as=a(),i(Nl.$$.fragment),ns=a(),o=p("div"),o.innerHTML=va,ps=a(),Dl=p("p"),Dl.textContent=Xa,Ms=a(),zl=p("p"),zl.textContent=Ea,ys=a(),i(Fl.$$.fragment),is=a(),Hl=p("p"),Hl.textContent=Ya,Js=a(),i(ql.$$.fragment),ms=a(),Sl=p("p"),Sl.innerHTML=Na,Ts=a(),i(Ll.$$.fragment),js=a(),Pl=p("p"),Pl.textContent=Da,ws=a(),i(Kl.$$.fragment),cs=a(),i(Ol.$$.fragment),Us=a(),le=p("p"),le.innerHTML=za,rs=a(),i(ee.$$.fragment),us=a(),te=p("p"),te.textContent=Fa,hs=a(),i(se.$$.fragment),ds=a(),i(ae.$$.fragment),os=a(),ne=p("p"),ne.textContent=Ha,fs=a(),i(pe.$$.fragment),bs=a(),Me=p("p"),Me.innerHTML=qa,Cs=a(),i(ye.$$.fragment),Is=a(),ie=p("p"),ie.textContent=Sa,$s=a(),i(Je.$$.fragment),Zs=a(),me=p("p"),me.innerHTML=La,ks=a(),i(Te.$$.fragment),Rs=a(),je=p("p"),je.innerHTML=Pa,xs=a(),i(we.$$.fragment),As=a(),ce=p("p"),ce.textContent=Ka,Qs=a(),i(Ue.$$.fragment),gs=a(),i(re.$$.fragment),Vs=a(),ue=p("p"),ue.textContent=Oa,_s=a(),i(he.$$.fragment),Gs=a(),de=p("p"),de.textContent=ln,Bs=a(),i(oe.$$.fragment),Ws=a(),fe=p("p"),fe.textContent=en,vs=a(),i(be.$$.fragment),Xs=a(),Ce=p("p"),Ce.textContent=tn,Es=a(),i(Ie.$$.fragment),Ys=a(),$e=p("p"),$e.textContent=sn,Ns=a(),i(Ze.$$.fragment),Ds=a(),ke=p("p"),ke.textContent=an,zs=a(),i(Re.$$.fragment),Fs=a(),xe=p("p"),xe.textContent=nn,Hs=a(),Ae=p("p"),Ae.innerHTML=pn,qs=a(),Qe=p("p"),Qe.textContent=Mn,Ss=a(),i(ge.$$.fragment),Ls=a(),_e=p("p"),this.h()},l(l){const e=Un("svelte-u9bgzb",document.head);U=M(e,"META",{name:!0,content:!0}),e.forEach(t),f=n(l),r=M(l,"P",{}),Jn(r).forEach(t),Ve=n(l),J(b.$$.fragment,l),Be=n(l),C=M(l,"P",{"data-svelte-h":!0}),y(C)!=="svelte-8bltl"&&(C.textContent=Os),We=n(l),J(I.$$.fragment,l),ve=n(l),$=M(l,"P",{"data-svelte-h":!0}),y($)!=="svelte-izsfon"&&($.textContent=la),Xe=n(l),J(Z.$$.fragment,l),Ee=n(l),J(h.$$.fragment,l),Ye=n(l),k=M(l,"P",{"data-svelte-h":!0}),y(k)!=="svelte-xcyd0c"&&(k.textContent=ea),Ne=n(l),J(R.$$.fragment,l),De=n(l),x=M(l,"P",{"data-svelte-h":!0}),y(x)!=="svelte-1n5cqib"&&(x.textContent=ta),ze=n(l),J(A.$$.fragment,l),Fe=n(l),J(Q.$$.fragment,l),He=n(l),g=M(l,"P",{"data-svelte-h":!0}),y(g)!=="svelte-1wrmkii"&&(g.innerHTML=sa),qe=n(l),V=M(l,"P",{"data-svelte-h":!0}),y(V)!=="svelte-wlzddh"&&(V.textContent=aa),Se=n(l),_=M(l,"P",{"data-svelte-h":!0}),y(_)!=="svelte-tndgny"&&(_.textContent=na),Le=n(l),J(G.$$.fragment,l),Pe=n(l),B=M(l,"P",{"data-svelte-h":!0}),y(B)!=="svelte-1mvdyro"&&(B.innerHTML=pa),Ke=n(l),J(W.$$.fragment,l),Oe=n(l),v=M(l,"P",{"data-svelte-h":!0}),y(v)!=="svelte-1qhkgx9"&&(v.textContent=Ma),lt=n(l),J(X.$$.fragment,l),et=n(l),J(E.$$.fragment,l),tt=n(l),Y=M(l,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-hacnda"&&(Y.textContent=ya),st=n(l),J(N.$$.fragment,l),at=n(l),J(D.$$.fragment,l),nt=n(l),z=M(l,"P",{"data-svelte-h":!0}),y(z)!=="svelte-pxsz1o"&&(z.textContent=ia),pt=n(l),J(F.$$.fragment,l),Mt=n(l),H=M(l,"P",{"data-svelte-h":!0}),y(H)!=="svelte-hhmg0u"&&(H.textContent=Ja),yt=n(l),J(q.$$.fragment,l),it=n(l),S=M(l,"P",{"data-svelte-h":!0}),y(S)!=="svelte-1mvdyro"&&(S.innerHTML=ma),Jt=n(l),J(L.$$.fragment,l),mt=n(l),P=M(l,"P",{"data-svelte-h":!0}),y(P)!=="svelte-4zb4lk"&&(P.innerHTML=Ta),Tt=n(l),K=M(l,"P",{"data-svelte-h":!0}),y(K)!=="svelte-okgqir"&&(K.innerHTML=ja),jt=n(l),O=M(l,"P",{"data-svelte-h":!0}),y(O)!=="svelte-1ysmakp"&&(O.innerHTML=wa),wt=n(l),J(ll.$$.fragment,l),ct=n(l),el=M(l,"P",{"data-svelte-h":!0}),y(el)!=="svelte-1frt52r"&&(el.textContent=ca),Ut=n(l),J(tl.$$.fragment,l),rt=n(l),sl=M(l,"P",{"data-svelte-h":!0}),y(sl)!=="svelte-1mvdyro"&&(sl.innerHTML=Ua),ut=n(l),J(al.$$.fragment,l),ht=n(l),nl=M(l,"P",{"data-svelte-h":!0}),y(nl)!=="svelte-fg573h"&&(nl.innerHTML=ra),dt=n(l),J(pl.$$.fragment,l),ot=n(l),Ml=M(l,"P",{"data-svelte-h":!0}),y(Ml)!=="svelte-138gm4p"&&(Ml.textContent=ua),ft=n(l),J(yl.$$.fragment,l),bt=n(l),il=M(l,"P",{"data-svelte-h":!0}),y(il)!=="svelte-t1t9qy"&&(il.textContent=ha),Ct=n(l),J(Jl.$$.fragment,l),It=n(l),ml=M(l,"P",{"data-svelte-h":!0}),y(ml)!=="svelte-7t0xxj"&&(ml.textContent=da),$t=n(l),J(Tl.$$.fragment,l),Zt=n(l),d=M(l,"DIV",{class:!0,"data-svelte-h":!0}),y(d)!=="svelte-1uufiik"&&(d.innerHTML=oa),kt=n(l),jl=M(l,"P",{"data-svelte-h":!0}),y(jl)!=="svelte-15je7j5"&&(jl.textContent=fa),Rt=n(l),J(wl.$$.fragment,l),xt=n(l),cl=M(l,"P",{"data-svelte-h":!0}),y(cl)!=="svelte-u7eqkn"&&(cl.textContent=ba),At=n(l),J(Ul.$$.fragment,l),Qt=n(l),rl=M(l,"P",{"data-svelte-h":!0}),y(rl)!=="svelte-1mvdyro"&&(rl.innerHTML=Ca),gt=n(l),J(ul.$$.fragment,l),Vt=n(l),hl=M(l,"P",{"data-svelte-h":!0}),y(hl)!=="svelte-z9bfhb"&&(hl.textContent=Ia),_t=n(l),J(dl.$$.fragment,l),Gt=n(l),ol=M(l,"P",{"data-svelte-h":!0}),y(ol)!=="svelte-1mvdyro"&&(ol.innerHTML=$a),Bt=n(l),J(fl.$$.fragment,l),Wt=n(l),bl=M(l,"P",{"data-svelte-h":!0}),y(bl)!=="svelte-1ps1iiz"&&(bl.textContent=Za),vt=n(l),Cl=M(l,"P",{"data-svelte-h":!0}),y(Cl)!=="svelte-139qbcw"&&(Cl.textContent=ka),Xt=n(l),J(Il.$$.fragment,l),Et=n(l),$l=M(l,"P",{"data-svelte-h":!0}),y($l)!=="svelte-p3m4km"&&($l.innerHTML=Ra),Yt=n(l),Zl=M(l,"P",{"data-svelte-h":!0}),y(Zl)!=="svelte-taqkhq"&&(Zl.innerHTML=xa),Nt=n(l),J(kl.$$.fragment,l),Dt=n(l),Rl=M(l,"P",{"data-svelte-h":!0}),y(Rl)!=="svelte-e3airu"&&(Rl.innerHTML=Aa),zt=n(l),xl=M(l,"P",{"data-svelte-h":!0}),y(xl)!=="svelte-1i0w5jk"&&(xl.innerHTML=Qa),Ft=n(l),J(Al.$$.fragment,l),Ht=n(l),Ql=M(l,"P",{"data-svelte-h":!0}),y(Ql)!=="svelte-12dg9zu"&&(Ql.innerHTML=ga),qt=n(l),J(gl.$$.fragment,l),St=n(l),Vl=M(l,"P",{"data-svelte-h":!0}),y(Vl)!=="svelte-vyoyt2"&&(Vl.textContent=Va),Lt=n(l),J(_l.$$.fragment,l),Pt=n(l),Gl=M(l,"P",{"data-svelte-h":!0}),y(Gl)!=="svelte-1mvdyro"&&(Gl.innerHTML=_a),Kt=n(l),J(Bl.$$.fragment,l),Ot=n(l),Wl=M(l,"P",{"data-svelte-h":!0}),y(Wl)!=="svelte-2nvf42"&&(Wl.textContent=Ga),ls=n(l),J(vl.$$.fragment,l),es=n(l),Xl=M(l,"P",{"data-svelte-h":!0}),y(Xl)!=="svelte-1mvdyro"&&(Xl.innerHTML=Ba),ts=n(l),J(El.$$.fragment,l),ss=n(l),Yl=M(l,"P",{"data-svelte-h":!0}),y(Yl)!=="svelte-1ycajx1"&&(Yl.textContent=Wa),as=n(l),J(Nl.$$.fragment,l),ns=n(l),o=M(l,"DIV",{class:!0,"data-svelte-h":!0}),y(o)!=="svelte-j4o1b8"&&(o.innerHTML=va),ps=n(l),Dl=M(l,"P",{"data-svelte-h":!0}),y(Dl)!=="svelte-12yxndm"&&(Dl.textContent=Xa),Ms=n(l),zl=M(l,"P",{"data-svelte-h":!0}),y(zl)!=="svelte-1cx65z4"&&(zl.textContent=Ea),ys=n(l),J(Fl.$$.fragment,l),is=n(l),Hl=M(l,"P",{"data-svelte-h":!0}),y(Hl)!=="svelte-4c0nlh"&&(Hl.textContent=Ya),Js=n(l),J(ql.$$.fragment,l),ms=n(l),Sl=M(l,"P",{"data-svelte-h":!0}),y(Sl)!=="svelte-1mvdyro"&&(Sl.innerHTML=Na),Ts=n(l),J(Ll.$$.fragment,l),js=n(l),Pl=M(l,"P",{"data-svelte-h":!0}),y(Pl)!=="svelte-12kqf3u"&&(Pl.textContent=Da),ws=n(l),J(Kl.$$.fragment,l),cs=n(l),J(Ol.$$.fragment,l),Us=n(l),le=M(l,"P",{"data-svelte-h":!0}),y(le)!=="svelte-av8zr0"&&(le.innerHTML=za),rs=n(l),J(ee.$$.fragment,l),us=n(l),te=M(l,"P",{"data-svelte-h":!0}),y(te)!=="svelte-100fe39"&&(te.textContent=Fa),hs=n(l),J(se.$$.fragment,l),ds=n(l),J(ae.$$.fragment,l),os=n(l),ne=M(l,"P",{"data-svelte-h":!0}),y(ne)!=="svelte-1xuk540"&&(ne.textContent=Ha),fs=n(l),J(pe.$$.fragment,l),bs=n(l),Me=M(l,"P",{"data-svelte-h":!0}),y(Me)!=="svelte-1tqkg0a"&&(Me.innerHTML=qa),Cs=n(l),J(ye.$$.fragment,l),Is=n(l),ie=M(l,"P",{"data-svelte-h":!0}),y(ie)!=="svelte-1haaffx"&&(ie.textContent=Sa),$s=n(l),J(Je.$$.fragment,l),Zs=n(l),me=M(l,"P",{"data-svelte-h":!0}),y(me)!=="svelte-1pvbr9r"&&(me.innerHTML=La),ks=n(l),J(Te.$$.fragment,l),Rs=n(l),je=M(l,"P",{"data-svelte-h":!0}),y(je)!=="svelte-1uviv04"&&(je.innerHTML=Pa),xs=n(l),J(we.$$.fragment,l),As=n(l),ce=M(l,"P",{"data-svelte-h":!0}),y(ce)!=="svelte-hefgo2"&&(ce.textContent=Ka),Qs=n(l),J(Ue.$$.fragment,l),gs=n(l),J(re.$$.fragment,l),Vs=n(l),ue=M(l,"P",{"data-svelte-h":!0}),y(ue)!=="svelte-jls05p"&&(ue.textContent=Oa),_s=n(l),J(he.$$.fragment,l),Gs=n(l),de=M(l,"P",{"data-svelte-h":!0}),y(de)!=="svelte-18xrhu4"&&(de.textContent=ln),Bs=n(l),J(oe.$$.fragment,l),Ws=n(l),fe=M(l,"P",{"data-svelte-h":!0}),y(fe)!=="svelte-1vadpfy"&&(fe.textContent=en),vs=n(l),J(be.$$.fragment,l),Xs=n(l),Ce=M(l,"P",{"data-svelte-h":!0}),y(Ce)!=="svelte-sfvde1"&&(Ce.textContent=tn),Es=n(l),J(Ie.$$.fragment,l),Ys=n(l),$e=M(l,"P",{"data-svelte-h":!0}),y($e)!=="svelte-1otseb5"&&($e.textContent=sn),Ns=n(l),J(Ze.$$.fragment,l),Ds=n(l),ke=M(l,"P",{"data-svelte-h":!0}),y(ke)!=="svelte-eothhd"&&(ke.textContent=an),zs=n(l),J(Re.$$.fragment,l),Fs=n(l),xe=M(l,"P",{"data-svelte-h":!0}),y(xe)!=="svelte-188hwef"&&(xe.textContent=nn),Hs=n(l),Ae=M(l,"P",{"data-svelte-h":!0}),y(Ae)!=="svelte-ygi586"&&(Ae.innerHTML=pn),qs=n(l),Qe=M(l,"P",{"data-svelte-h":!0}),y(Qe)!=="svelte-s2kks0"&&(Qe.textContent=Mn),Ss=n(l),J(ge.$$.fragment,l),Ls=n(l),_e=M(l,"P",{}),Jn(_e).forEach(t),this.h()},h(){Ks(U,"name","hf:doc:metadata"),Ks(U,"content",fn),Ks(d,"class","flex justify-center"),Ks(o,"class","flex justify-center")},m(l,e){rn(document.head,U),s(l,f,e),s(l,r,e),s(l,Ve,e),m(b,l,e),s(l,Be,e),s(l,C,e),s(l,We,e),m(I,l,e),s(l,ve,e),s(l,$,e),s(l,Xe,e),m(Z,l,e),s(l,Ee,e),m(h,l,e),s(l,Ye,e),s(l,k,e),s(l,Ne,e),m(R,l,e),s(l,De,e),s(l,x,e),s(l,ze,e),m(A,l,e),s(l,Fe,e),m(Q,l,e),s(l,He,e),s(l,g,e),s(l,qe,e),s(l,V,e),s(l,Se,e),s(l,_,e),s(l,Le,e),m(G,l,e),s(l,Pe,e),s(l,B,e),s(l,Ke,e),m(W,l,e),s(l,Oe,e),s(l,v,e),s(l,lt,e),m(X,l,e),s(l,et,e),m(E,l,e),s(l,tt,e),s(l,Y,e),s(l,st,e),m(N,l,e),s(l,at,e),m(D,l,e),s(l,nt,e),s(l,z,e),s(l,pt,e),m(F,l,e),s(l,Mt,e),s(l,H,e),s(l,yt,e),m(q,l,e),s(l,it,e),s(l,S,e),s(l,Jt,e),m(L,l,e),s(l,mt,e),s(l,P,e),s(l,Tt,e),s(l,K,e),s(l,jt,e),s(l,O,e),s(l,wt,e),m(ll,l,e),s(l,ct,e),s(l,el,e),s(l,Ut,e),m(tl,l,e),s(l,rt,e),s(l,sl,e),s(l,ut,e),m(al,l,e),s(l,ht,e),s(l,nl,e),s(l,dt,e),m(pl,l,e),s(l,ot,e),s(l,Ml,e),s(l,ft,e),m(yl,l,e),s(l,bt,e),s(l,il,e),s(l,Ct,e),m(Jl,l,e),s(l,It,e),s(l,ml,e),s(l,$t,e),m(Tl,l,e),s(l,Zt,e),s(l,d,e),s(l,kt,e),s(l,jl,e),s(l,Rt,e),m(wl,l,e),s(l,xt,e),s(l,cl,e),s(l,At,e),m(Ul,l,e),s(l,Qt,e),s(l,rl,e),s(l,gt,e),m(ul,l,e),s(l,Vt,e),s(l,hl,e),s(l,_t,e),m(dl,l,e),s(l,Gt,e),s(l,ol,e),s(l,Bt,e),m(fl,l,e),s(l,Wt,e),s(l,bl,e),s(l,vt,e),s(l,Cl,e),s(l,Xt,e),m(Il,l,e),s(l,Et,e),s(l,$l,e),s(l,Yt,e),s(l,Zl,e),s(l,Nt,e),m(kl,l,e),s(l,Dt,e),s(l,Rl,e),s(l,zt,e),s(l,xl,e),s(l,Ft,e),m(Al,l,e),s(l,Ht,e),s(l,Ql,e),s(l,qt,e),m(gl,l,e),s(l,St,e),s(l,Vl,e),s(l,Lt,e),m(_l,l,e),s(l,Pt,e),s(l,Gl,e),s(l,Kt,e),m(Bl,l,e),s(l,Ot,e),s(l,Wl,e),s(l,ls,e),m(vl,l,e),s(l,es,e),s(l,Xl,e),s(l,ts,e),m(El,l,e),s(l,ss,e),s(l,Yl,e),s(l,as,e),m(Nl,l,e),s(l,ns,e),s(l,o,e),s(l,ps,e),s(l,Dl,e),s(l,Ms,e),s(l,zl,e),s(l,ys,e),m(Fl,l,e),s(l,is,e),s(l,Hl,e),s(l,Js,e),m(ql,l,e),s(l,ms,e),s(l,Sl,e),s(l,Ts,e),m(Ll,l,e),s(l,js,e),s(l,Pl,e),s(l,ws,e),m(Kl,l,e),s(l,cs,e),m(Ol,l,e),s(l,Us,e),s(l,le,e),s(l,rs,e),m(ee,l,e),s(l,us,e),s(l,te,e),s(l,hs,e),m(se,l,e),s(l,ds,e),m(ae,l,e),s(l,os,e),s(l,ne,e),s(l,fs,e),m(pe,l,e),s(l,bs,e),s(l,Me,e),s(l,Cs,e),m(ye,l,e),s(l,Is,e),s(l,ie,e),s(l,$s,e),m(Je,l,e),s(l,Zs,e),s(l,me,e),s(l,ks,e),m(Te,l,e),s(l,Rs,e),s(l,je,e),s(l,xs,e),m(we,l,e),s(l,As,e),s(l,ce,e),s(l,Qs,e),m(Ue,l,e),s(l,gs,e),m(re,l,e),s(l,Vs,e),s(l,ue,e),s(l,_s,e),m(he,l,e),s(l,Gs,e),s(l,de,e),s(l,Bs,e),m(oe,l,e),s(l,Ws,e),s(l,fe,e),s(l,vs,e),m(be,l,e),s(l,Xs,e),s(l,Ce,e),s(l,Es,e),m(Ie,l,e),s(l,Ys,e),s(l,$e,e),s(l,Ns,e),m(Ze,l,e),s(l,Ds,e),s(l,ke,e),s(l,zs,e),m(Re,l,e),s(l,Fs,e),s(l,xe,e),s(l,Hs,e),s(l,Ae,e),s(l,qs,e),s(l,Qe,e),s(l,Ss,e),m(ge,l,e),s(l,Ls,e),s(l,_e,e),Ps=!0},p(l,[e]){const yn={};e&2&&(yn.$$scope={dirty:e,ctx:l}),h.$set(yn)},i(l){Ps||(T(b.$$.fragment,l),T(I.$$.fragment,l),T(Z.$$.fragment,l),T(h.$$.fragment,l),T(R.$$.fragment,l),T(A.$$.fragment,l),T(Q.$$.fragment,l),T(G.$$.fragment,l),T(W.$$.fragment,l),T(X.$$.fragment,l),T(E.$$.fragment,l),T(N.$$.fragment,l),T(D.$$.fragment,l),T(F.$$.fragment,l),T(q.$$.fragment,l),T(L.$$.fragment,l),T(ll.$$.fragment,l),T(tl.$$.fragment,l),T(al.$$.fragment,l),T(pl.$$.fragment,l),T(yl.$$.fragment,l),T(Jl.$$.fragment,l),T(Tl.$$.fragment,l),T(wl.$$.fragment,l),T(Ul.$$.fragment,l),T(ul.$$.fragment,l),T(dl.$$.fragment,l),T(fl.$$.fragment,l),T(Il.$$.fragment,l),T(kl.$$.fragment,l),T(Al.$$.fragment,l),T(gl.$$.fragment,l),T(_l.$$.fragment,l),T(Bl.$$.fragment,l),T(vl.$$.fragment,l),T(El.$$.fragment,l),T(Nl.$$.fragment,l),T(Fl.$$.fragment,l),T(ql.$$.fragment,l),T(Ll.$$.fragment,l),T(Kl.$$.fragment,l),T(Ol.$$.fragment,l),T(ee.$$.fragment,l),T(se.$$.fragment,l),T(ae.$$.fragment,l),T(pe.$$.fragment,l),T(ye.$$.fragment,l),T(Je.$$.fragment,l),T(Te.$$.fragment,l),T(we.$$.fragment,l),T(Ue.$$.fragment,l),T(re.$$.fragment,l),T(he.$$.fragment,l),T(oe.$$.fragment,l),T(be.$$.fragment,l),T(Ie.$$.fragment,l),T(Ze.$$.fragment,l),T(Re.$$.fragment,l),T(ge.$$.fragment,l),Ps=!0)},o(l){j(b.$$.fragment,l),j(I.$$.fragment,l),j(Z.$$.fragment,l),j(h.$$.fragment,l),j(R.$$.fragment,l),j(A.$$.fragment,l),j(Q.$$.fragment,l),j(G.$$.fragment,l),j(W.$$.fragment,l),j(X.$$.fragment,l),j(E.$$.fragment,l),j(N.$$.fragment,l),j(D.$$.fragment,l),j(F.$$.fragment,l),j(q.$$.fragment,l),j(L.$$.fragment,l),j(ll.$$.fragment,l),j(tl.$$.fragment,l),j(al.$$.fragment,l),j(pl.$$.fragment,l),j(yl.$$.fragment,l),j(Jl.$$.fragment,l),j(Tl.$$.fragment,l),j(wl.$$.fragment,l),j(Ul.$$.fragment,l),j(ul.$$.fragment,l),j(dl.$$.fragment,l),j(fl.$$.fragment,l),j(Il.$$.fragment,l),j(kl.$$.fragment,l),j(Al.$$.fragment,l),j(gl.$$.fragment,l),j(_l.$$.fragment,l),j(Bl.$$.fragment,l),j(vl.$$.fragment,l),j(El.$$.fragment,l),j(Nl.$$.fragment,l),j(Fl.$$.fragment,l),j(ql.$$.fragment,l),j(Ll.$$.fragment,l),j(Kl.$$.fragment,l),j(Ol.$$.fragment,l),j(ee.$$.fragment,l),j(se.$$.fragment,l),j(ae.$$.fragment,l),j(pe.$$.fragment,l),j(ye.$$.fragment,l),j(Je.$$.fragment,l),j(Te.$$.fragment,l),j(we.$$.fragment,l),j(Ue.$$.fragment,l),j(re.$$.fragment,l),j(he.$$.fragment,l),j(oe.$$.fragment,l),j(be.$$.fragment,l),j(Ie.$$.fragment,l),j(Ze.$$.fragment,l),j(Re.$$.fragment,l),j(ge.$$.fragment,l),Ps=!1},d(l){l&&(t(f),t(r),t(Ve),t(Be),t(C),t(We),t(ve),t($),t(Xe),t(Ee),t(Ye),t(k),t(Ne),t(De),t(x),t(ze),t(Fe),t(He),t(g),t(qe),t(V),t(Se),t(_),t(Le),t(Pe),t(B),t(Ke),t(Oe),t(v),t(lt),t(et),t(tt),t(Y),t(st),t(at),t(nt),t(z),t(pt),t(Mt),t(H),t(yt),t(it),t(S),t(Jt),t(mt),t(P),t(Tt),t(K),t(jt),t(O),t(wt),t(ct),t(el),t(Ut),t(rt),t(sl),t(ut),t(ht),t(nl),t(dt),t(ot),t(Ml),t(ft),t(bt),t(il),t(Ct),t(It),t(ml),t($t),t(Zt),t(d),t(kt),t(jl),t(Rt),t(xt),t(cl),t(At),t(Qt),t(rl),t(gt),t(Vt),t(hl),t(_t),t(Gt),t(ol),t(Bt),t(Wt),t(bl),t(vt),t(Cl),t(Xt),t(Et),t($l),t(Yt),t(Zl),t(Nt),t(Dt),t(Rl),t(zt),t(xl),t(Ft),t(Ht),t(Ql),t(qt),t(St),t(Vl),t(Lt),t(Pt),t(Gl),t(Kt),t(Ot),t(Wl),t(ls),t(es),t(Xl),t(ts),t(ss),t(Yl),t(as),t(ns),t(o),t(ps),t(Dl),t(Ms),t(zl),t(ys),t(is),t(Hl),t(Js),t(ms),t(Sl),t(Ts),t(js),t(Pl),t(ws),t(cs),t(Us),t(le),t(rs),t(us),t(te),t(hs),t(ds),t(os),t(ne),t(fs),t(bs),t(Me),t(Cs),t(Is),t(ie),t($s),t(Zs),t(me),t(ks),t(Rs),t(je),t(xs),t(As),t(ce),t(Qs),t(gs),t(Vs),t(ue),t(_s),t(Gs),t(de),t(Bs),t(Ws),t(fe),t(vs),t(Xs),t(Ce),t(Es),t(Ys),t($e),t(Ns),t(Ds),t(ke),t(zs),t(Fs),t(xe),t(Hs),t(Ae),t(qs),t(Qe),t(Ss),t(Ls),t(_e)),t(U),w(b,l),w(I,l),w(Z,l),w(h,l),w(R,l),w(A,l),w(Q,l),w(G,l),w(W,l),w(X,l),w(E,l),w(N,l),w(D,l),w(F,l),w(q,l),w(L,l),w(ll,l),w(tl,l),w(al,l),w(pl,l),w(yl,l),w(Jl,l),w(Tl,l),w(wl,l),w(Ul,l),w(ul,l),w(dl,l),w(fl,l),w(Il,l),w(kl,l),w(Al,l),w(gl,l),w(_l,l),w(Bl,l),w(vl,l),w(El,l),w(Nl,l),w(Fl,l),w(ql,l),w(Ll,l),w(Kl,l),w(Ol,l),w(ee,l),w(se,l),w(ae,l),w(pe,l),w(ye,l),w(Je,l),w(Te,l),w(we,l),w(Ue,l),w(re,l),w(he,l),w(oe,l),w(be,l),w(Ie,l),w(Ze,l),w(Re,l),w(ge,l)}}}const fn='{"title":"Дообучение SpeechT5","local":"дообучение-speecht5","sections":[{"title":"House-keeping","local":"house-keeping","sections":[],"depth":2},{"title":"Набор данных","local":"набор-данных","sections":[],"depth":2},{"title":"Препроцессинг данных","local":"препроцессинг-данных","sections":[{"title":"Очистка текста для токенизации SpeechT5","local":"очистка-текста-для-токенизации-speecht5","sections":[],"depth":3},{"title":"Дикторы","local":"дикторы","sections":[],"depth":3},{"title":"Эмбеддинги диктора","local":"эмбеддинги-диктора","sections":[],"depth":3},{"title":"Обработка датасета","local":"обработка-датасета","sections":[],"depth":3},{"title":"Коллатор данных","local":"коллатор-данных","sections":[],"depth":3}],"depth":2},{"title":"Обучение модели","local":"обучение-модели","sections":[],"depth":2},{"title":"Инференс","local":"инференс","sections":[],"depth":2}],"depth":1}';function bn(Ge){return Tn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rn extends wn{constructor(U){super(),cn(this,U,bn,on,mn,{})}}export{Rn as component};
