import{s as xa,n as Ba,o as Qa}from"../chunks/scheduler.f7e1785c.js";import{S as Va,i as Ra,g as p,s as a,r as i,m as I,H as Mt,A as ga,h as M,f as e,c as n,j as wt,u as U,x as J,n as b,E as Jt,k as Us,y as j,a as t,v as y,d as T,t as w,w as m}from"../chunks/index.9f8f0838.js";import{C as r}from"../chunks/CodeBlock.4baef5d7.js";import{H as ys,E as ka}from"../chunks/getInferenceSnippets.ad8e59bc.js";function va(mt){let c,Ts,Js,ws,f,ms,C,rt=`В этом разделе мы рассмотрим, как с помощью <code>pipeline()</code> использовать предварительно обученные модели для распознавания речи.
В <a href="../chapter2/asr_pipeline">Разделе 2</a> мы представили <code>pipeline()</code> как простой способ выполнения задач распознавания речи с предварительной
и последующей обработкой “под капотом” и возможностью быстро экспериментировать с любой предварительно обученной контрольной точкой модели на Hugging Face Hub.
В этом разделе мы углубимся в изучение различных характеристик моделей распознавания речи и рассмотрим, как их можно использовать для решения различных задач.`,rs,E,ht="Как подробно описано в Разделе 3, модели распознавания речи в целом относятся к одной из двух категорий:",hs,S,ot="<li>Connectionist Temporal Classification (CTC) или Коннекционистская Временная Классификация: модели состящие только из энкодера, с головой линейного классификатора в вершине модели.</li> <li>Sequence-to-sequence (Seq2Seq) или последовательность-в-последовательность: модели включающие в себя как энкодер, так и декодер с механизмом перекрестного внимания между ними (cross-attention).</li>",os,x,jt=`До 2022 года более популярной из двух архитектур была CTC, а такие модели, работающие только с энкодером, как Wav2Vec2, HuBERT и XLSR, совершили прорыв в парадигме
предварительного обучения/дообучения в задачах с речью. Крупные корпорации, такие как Meta и Microsoft, предварительно обучали энкодер на огромных объемах
неразмеченных аудиоданных в течение многих дней или недель. Затем пользователи могли взять предварительно обученную контрольную точку и дообучить ее с помощью
головы CTC всего на <strong>10 минутах</strong> размеченных речевых данных для достижения высоких результатов в последующей задаче распознавания речи.`,js,B,ct=`Однако модели CTC имеют свои недостатки. Присоединение простого линейного слоя к кодирующему устройству дает небольшую и быструю модель в целом, но она может
быть подвержена фонетическим ошибкам в написании. Ниже мы продемонстрируем это на примере модели Wav2Vec2.`,cs,Q,ds,V,dt=`Загрузим небольшой фрагмент набора данных <a href="hf-internal-testing/librispeech_asr_dummy">LibriSpeech ASR</a> чтобы продемонстрировать возможности Wav2Vec2
по транскрибации речи:`,us,R,Is,g,ut="<strong>Output:</strong>",bs,k,fs,v,It="Мы можем выбрать один из 73 аудиообразцов и просмотреть его, а также транскрипцию:",Cs,G,Es,$,bt="<strong>Output:</strong>",Ss,F,xs,H,ft=`Хорошо! Рождество и запеченная в духовке говядина, звучит здорово! 🎄 Сформировав выборку данных, мы теперь загружаем
дообученную контрольную точку в <code>pipeline()</code>. Для этого мы будем использовать официальную контрольную точку <a href="facebook/wav2vec2-base-100h">Wav2Vec2 base</a>
дообученную на 100 часах данных LibriSpeech:`,Bs,W,Qs,Z,Ct=`Далее мы возьмем пример из набора данных и передадим его исходные данные в конвейер. Поскольку <code>pipeline</code> <em>поглощает</em> любой словарь, который мы ему
передаем (то есть его нельзя использовать повторно), мы будем передавать копию данных. Таким образом, мы можем безопасно повторно использовать один
и тот же аудиообразец в следующих примерах:`,Vs,N,Rs,_,Et="<strong>Output:</strong>",gs,Y,ks,A,St=`Видно, что модель Wav2Vec2 неплохо справляется с транскрибацией данного образца - на первый взгляд, все выглядит в целом корректно.
Давайте поставим целевое значение (target) и прогноз/предсказание модели (prediction) рядом и выделим различия:`,vs,L,Gs,z,xt="Сравнивая целевой текст с предсказанной транскрибацией, мы видим, что все слова <em>звучат</em> правильно, но некоторые написаны не совсем точно. Например:",$s,X,Bt="<li><em>CHRISTMAUS</em> vs. <em>CHRISTMAS</em></li> <li><em>ROSE</em> vs. <em>ROAST</em></li> <li><em>SIMALYIS</em> vs. <em>SIMILES</em></li>",Fs,q,Qt=`Это подчеркивает недостаток модели CTC. Модель CTC - это, по сути, “только акустическая” модель: она состоит из энкодера, который формирует представления
скрытых состояний из аудиовходов, и линейного слоя, который отображает скрытые состояния в символы:`,Hs,D,Vt=`Это означает, что система практически полностью основывает свое предсказание на акустических данных (фонетических звуках аудиозаписи) и поэтому склонна
транскрибировать аудиозапись фонетическим способом (например, <em>CHRISTMAUS</em>). В нем меньше внимания уделяется языковому моделирующему контексту предыдущих
и последующих букв, поэтому он склонен к фонетическим ошибкам в написании. Более интеллектуальная модель определила бы, что <em>CHRISTMAUS</em> не является
правильным словом в английском словаре, и исправила бы его на <em>CHRISTMAS</em>, когда делала бы свои предсказания. Кроме того, в нашем прогнозировании отсутствуют
два важных признака - регистр и пунктуация, что ограничивает полезность транскрибации модели для реальных приложений.`,Ws,O,Zs,P,Rt=`Модели Seq2Seq! Как было описано в Разделе 3, модели Seq2Seq состоят из энкодера и декодера, связанных между собой механизмом перекрестного внимания.
Энкодер играет ту же роль, что и раньше, вычисляя представления скрытых состояний аудиовходов, а декодер - роль <strong>языковой модели</strong>. Декодер обрабатывает
всю последовательность представлений скрытых состояний, полученных от энкодера, и формирует соответствующие текстовые транскрипции. Имея глобальный контекст
входного аудиосигнала, декодер может использовать контекст языкового моделирования при составлении своих прогнозов, исправляя орфографические ошибки
“на лету” и тем самым обходя проблему фонетических прогнозов.`,Ns,K,gt="У моделей Seq2Seq есть два недостатка:",_s,ll,kt="<li>Они изначально медленнее декодируют, поскольку процесс декодирования происходит по одному шагу за раз, а не все сразу</li> <li>Они более требовательны к данным, для достижения сходимости им требуется значительно больше обучающих данных</li>",Ys,sl,vt=`В частности, узким местом в развитии архитектур Seq2Seq для задач с речью является потребность в больших объемах обучающих данных. Размеченные речевые данные
труднодоступны, самые большие аннотированные базы данных на тот момент составляли всего 10 000 часов. Все изменилось в 2022 году после выхода <strong>Whisper</strong>.
Whisper - это предварительно обученная модель для распознавания речи, опубликованная в <a href="https://openai.com/blog/whisper/" rel="nofollow">Сентябре 2022</a> авторами Alec Radford
и др. из компании OpenAI. В отличие от предшественников CTC, которые обучались исключительно на <strong>неразмеченных</strong> аудиоданных, Whisper предварительно обучен
на огромном количестве <strong>размеченных</strong> данных аудиотранскрипции, а именно на 680 000 часов.`,As,el,Gt=`Это на порядок больше данных, чем неразмеченные аудиоданные, использованные для обучения Wav2Vec 2.0 (60 000 часов). Более того, 117 000 часов этих данных,
предназначенных для предварительного обучения, являются мультиязычными (или “не английскими”) данными. В результате контрольные точки могут быть применены
к более чем 96 языкам, многие из которых считаются <em>низкоресурсными</em>, т.е. не имеющими большого корпуса данных, пригодных для обучения.`,Ls,tl,$t=`При масштабировании на 680 000 часов аннотированных данных для предварительного обучения модели Whisper демонстрируют высокую способность к обобщению
на многие наборы данных и области. Предварительно обученные контрольные точки достигают результатов, конкурентоспособных с state-of-the-art pipe systems,
с коэффициентом ошибок в словах (WER) около 3% на подмножестве чистых тестов LibriSpeech и новым рекордом на TED-LIUM с WER 4,7%
(см. табл. 8 <a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper paper</a>).`,zs,al,Ft=`Особое значение имеет способность Whisper работать с длинными аудиообразцами, устойчивость к входным шумам и возможность предсказывать транскрипцию с
использованием падежей и пунктуации. Это делает его перспективным для использования в реальных системах распознавания речи.`,Xs,nl,Ht=`В оставшейся части этого раздела будет показано, как использовать предварительно обученные модели Whisper для распознавания речи с помощью 🤗 Transformers.
Во многих ситуациях предварительно обученные контрольные точки Whisper обладают высокой производительностью и дают отличные результаты, поэтому мы
рекомендуем вам попробовать использовать предварительно обученные контрольные точки в качестве первого шага к решению любой задачи распознавания речи.
Благодаря дообучению предварительно обученные контрольные точки могут быть адаптированы для конкретных наборов данных и языков с целью дальнейшего
улучшения результатов. Как это сделать, мы продемонстрируем в следующем подразделе, посвященном [дообучению] (fine-tuning).`,qs,pl,Wt=`Контрольные точки модели Whisper доступны в пяти конфигурациях с различными размерами модели. Наименьшие по параметрам четыре модели обучаются либо
только на английском, либо на многоязычных данных. Самая большая по параметрам контрольная точка была обучена только на мультиязычных данных.
Все девять предварительно обученных контрольных точек доступны на <a href="https://huggingface.co/models?search=openai/whisper" rel="nofollow">Hugging Face Hub</a>. Контрольные
точки приведены в следующей таблице со ссылками на модели на Hugging Face Hub. “VRAM” обозначает объем памяти GPU, необходимый для работы модели с
минимальным размером пакета = 1. “Rel Speed” - относительная скорость контрольной точки по сравнению с самой большой моделью. На основе этой информации
можно выбрать контрольную точку, наиболее подходящую для вашего оборудования.`,Ds,Ml,Zt='<thead><tr><th>Size</th> <th>Parameters</th> <th>VRAM / GB</th> <th>Rel Speed</th> <th>English-only</th> <th>Multilingual</th></tr></thead> <tbody><tr><td>tiny</td> <td>39 M</td> <td>1.4</td> <td>32</td> <td><a href="https://huggingface.co/openai/whisper-tiny.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-tiny" rel="nofollow">✓</a></td></tr> <tr><td>base</td> <td>74 M</td> <td>1.5</td> <td>16</td> <td><a href="https://huggingface.co/openai/whisper-base.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-base" rel="nofollow">✓</a></td></tr> <tr><td>small</td> <td>244 M</td> <td>2.3</td> <td>6</td> <td><a href="https://huggingface.co/openai/whisper-small.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-small" rel="nofollow">✓</a></td></tr> <tr><td>medium</td> <td>769 M</td> <td>4.2</td> <td>2</td> <td><a href="https://huggingface.co/openai/whisper-medium.en" rel="nofollow">✓</a></td> <td><a href="https://huggingface.co/openai/whisper-medium" rel="nofollow">✓</a></td></tr> <tr><td>large</td> <td>1550 M</td> <td>7.5</td> <td>1</td> <td>x</td> <td><a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow">✓</a></td></tr></tbody>',Os,Jl,Nt=`Загрузим контрольную точку <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a>, которая по размеру сопоставима с контрольной точкой Wav2Vec2, которую
мы использовали ранее. Предваряя наш переход к многоязычному распознаванию речи, загрузим многоязычный вариант базовой контрольной точки. Мы также загрузим
модель на GPU, если он доступен, или на CPU в противном случае. В последствии <code>pipeline()</code> позаботится о перемещении всех входов/выходов с CPU на GPU по мере
необходимости:`,Ps,il,Ks,Ul,_t=`Отлично! Теперь давайте транскрибируем аудиозапись, как и раньше. Единственное изменение - это передача дополнительного аргумента <code>max_new_tokens</code>, который
указывает модели максимальное количество токенов, которые нужно генерировать при предсказании:`,le,yl,se,Tl,Yt="<strong>Output:</strong>",ee,wl,te,ml,At=`Достаточно легко! Первое, на что вы обратите внимание, - это наличие как регистра, так и знаков препинания. Это сразу же делает транскрипцию более удобной для
чтения по сравнению с транскрипцией из Wav2Vec2, не содержащей ни регистра, ни пунктуации. Давайте поместим транскрипцию рядом с целевой меткой:`,ae,rl,ne,hl,Lt=`Whisper проделал большую работу по исправлению фонетических ошибок, которые мы видели в Wav2Vec2 - и <em>Christmas</em>, и <em>roast</em> написаны правильно.
Мы видим, что модель все еще испытывает трудности с <em>SIMILES</em>, которое неправильно транскрибируется как <em>similarly</em>, но на этот раз предсказание
является правильным словом из английского словаря. Использование контрольной точки Whisper большего размера позволяет еще больше снизить количество
ошибок в транскрибированном тексте, но при этом требует больше вычислений и увеличивает время транскрибации.`,pe,ol,zt=`Нам обещали модель, способную работать с 96 языками, так что оставим пока распознавание английской речи и пойдем по миру 🌎! Набор данных <a href="https://huggingface.co/datasets/facebook/multilingual_librispeech" rel="nofollow">Multilingual LibriSpeech</a>
(MLS) представляет собой многоязычный аналог набора данных LibriSpeech, содержащий размеченные аудиоданные на шести языках. Мы загрузим одну
образец из испанской части набора данных MLS, используя режим <em>streaming</em>, чтобы не загружать весь набор данных:`,Me,jl,Je,cl,Xt="Снова посмотрим текстовую транскрипцию и прослушаем аудиофрагмент:",ie,dl,Ue,ul,qt="<strong>Output:</strong>",ye,Il,Te,bl,Dt=`Это целевой текст, на который мы ориентируемся в нашей транскрипции Whisper. Хотя теперь мы знаем, что, вероятно, можем сделать это лучше,
поскольку наша модель будет предсказывать также пунктуацию и регистр, которые в выводе примера отсутствуют. Передадим образец звука в конвейер для
получения предсказания текста. Следует отметить, что конвейер <em>потребует</em> словарь аудиовходов, который мы вводим, то есть словарь не может
быть использован повторно. Чтобы обойти эту проблему, мы будем передавать <em>копию</em> аудиообразца, что позволит нам повторно использовать тот же самый
аудиообразец в последующих примерах кода:`,we,fl,me,Cl,Ot="<strong>Output:</strong>",re,El,he,Sl,Pt=`Отлично - это очень похоже на наш целевой текст (возможно, даже лучше, поскольку в нем есть пунктуация и регистр!). Обратите внимание, что мы передали
<code>&quot;task&quot;</code> в качестве аргумента <em>генерируемого ключевого слова</em> (generate kwarg). Передача ключу <code>&quot;task&quot;</code> значения <code>&quot;transcribe&quot;</code> заставляет Whisper
выполнять задачу <em>распознавания речи</em>, при которой аудиозапись транскрибируется на том же языке, на котором была произнесена речь. Whisper также
способен выполнять тесно связанную с задачу - <em>перевода речи</em>, когда аудиозапись на испанском языке может быть переведена в текст на английском.
Для этого мы передаем ключу <code>&quot;task&quot;</code> значение <code>&quot;translate&quot;</code>:`,oe,xl,je,Bl,Kt="<strong>Output:</strong>",ce,Ql,de,Vl,la=`Теперь, когда мы знаем, что можем переключаться между распознаванием речи и ее переводом, мы можем выбирать задачу в зависимости от наших потребностей.
Либо мы распознаем звук на языке X в текст на том же языке X (например, испанский звук в испанский текст), либо переводим с любого языка X в текст
на английском языке (например, испанский звук в английский текст).`,ue,Rl,sa=`Подробнее о том, как аргумент <code>&quot;task&quot;</code> используется для управления свойствами генерируемого текста, см. в <a href="https://huggingface.co/openai/whisper-base#usage" rel="nofollow">карточке модели</a>
для базовой модели Whisper.`,Ie,gl,be,kl,ea=`Пока мы были сосредоточены на транскрибации коротких аудиофрагментов длительностью менее 30 секунд. Мы уже упоминали, что одной из привлекательных
сторон Whisper является возможность работы с длинными аудиофрагментами. В этой части раздела мы рассмотрим эту задачу!`,fe,vl,ta=`Создадим длинный аудиофайл путем конкатенации последовательных выборок из набора данных MLS. Поскольку набор данных MLS формируется путем разбиения
длинных записей аудиокниг на более короткие сегменты, конкатенация образцов является одним из способов реконструкции более длинных отрывков аудиокниг.
Следовательно, результирующий звук должен быть когерентным по всей выборке.`,Ce,Gl,aa="Мы установим целевую длительность звука в 5 минут и прекратим конкатенацию сэмплов, как только достигнем этого значения:",Ee,$l,Se,Fl,na="<strong>Output:</strong>",xe,Hl,Be,Wl,pa=`Отлично! Осталось транскрибировать 5 минут 17 секунд аудиозаписи. При передаче такого длинного аудиофрагмента непосредственно в модель
возникают две проблемы:`,Qe,Zl,Ma="<li>Whisper изначально рассчитан на работу с 30-секундными образцами: все, что короче 30 секунд, заполняется тишиной, все, что длиннее 30 секунд, усекается до 30 секунд путем вырезания лишнего звука, поэтому если мы передадим наш звук напрямую, то получим транскрипцию только первых 30 секунд</li> <li>Память в сети трансформера зависит от квадрата длины последовательности: удвоение длины входного сигнала увеличивает потребность в памяти в четыре раза, поэтому передача очень длинных аудиофайлов обязательно приведет к ошибке “вне памяти” (out-of-memory)</li>",Ve,Nl,Ja=`Длинная транскрибация в 🤗 Transformers осуществляется путем <em>фрагментации</em> (от англ. chunking) входного аудио на более мелкие и управляемые фрагменты.
Каждый фрагмент имеет небольшое наложение с предыдущим. Это позволяет нам точно соединять фрагменты на границах,
так как мы можем найти наложение между фрагментами и соответствующим образом объединить транскрипции:`,Re,d,ia='<img src="https://huggingface.co/blog/assets/49_asr_chunking/Striding.png" alt="🤗 Transformers chunking algorithm. Source: https://huggingface.co/blog/asr-chunking."/>',ge,h,it,ke,fa='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',ve,Ge,Ca='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',$e,ps,Ua="нестационарный",Ut,Fe,Ea='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> i + 1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',He,We,Sa='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Ze,Ms,ya="пакетировать",yt,u,Ta="посте из блога",Tt,Ne,_l,wa=`Для активации длинных транскрипций необходимо добавить один дополнительный аргумент при вызове конвейера. Этот аргумент, <code>chunk_length_s</code>,
определяет длину фрагментов в секундах. Для Whisper оптимальной является 30-секундная длина фрагментов, поскольку она соответствует длине
входного сигнала, ожидаемого Whisper.`,_e,Yl,ma=`Чтобы активизировать пакетную обработку, необходимо передать конвейеру аргумент <code>batch_size</code>. Если собрать все это воедино,
то транскрибация длинного аудиообразца с использованием чанкинга и батчинга может быть выполнена следующим образом:`,Ye,Al,Ae,Ll,ra="<strong>Output:</strong>",Le,zl,ze,Xl,ha=`Мы не будем приводить здесь весь результат, поскольку он довольно длинный (всего 312 слов)! На графическом процессоре V100
с памятью 16 Гбайт выполнение приведенной выше строки займет примерно 3,45 секунды, что весьма неплохо для 317-секундного аудиообразца.
На CPU ожидается около 30 секунд.`,Xe,ql,oa=`Whisper также способен предсказывать <em>временные метки</em> на уровне фрагментов для аудиоданных. Эти временные метки указывают на время начала
и окончания короткого отрывка аудиозаписи и особенно полезны для выравнивания транскрипции с входным аудиосигналом. Предположим, мы хотим
создать субтитры для видео - нам нужны эти временные метки, чтобы знать, какая часть транскрипции соответствует определенному
сегменту видео, чтобы отобразить правильную транскрипцию для этого времени.`,qe,Dl,ja=`Активировать предсказание временных меток очень просто, достаточно установить аргумент <code>return_timestamps=True</code>. Временные метки совместимы
с методами фрагментирования и пакетирования, которые мы использовали ранее, поэтому мы можем просто добавить аргумент timestamp к нашему
предыдущему вызову:`,De,Ol,Oe,Pl,ca="<strong>Output:</strong>",Pe,Kl,Ke,ls,da="И вуаля! У нас есть предсказанный текст и соответствующие временные метки.",lt,ss,st,es,ua=`Whisper - это сильная предварительно обученная модель для распознавания и перевода речи. По сравнению с Wav2Vec2, он обладает более
высокой точностью транскрибации, при этом выходные данные содержат знаки препинания и регистр. Он может использоваться для транскрибации
речи на английском и 96 других языках, как на коротких аудиофрагментах, так и на более длинных за счет <em>фрагментирования</em>. Эти качества делают
его подходящей моделью для многих задач распознавания речи и перевода без необходимости дообучения. Метод <code>pipeline()</code> обеспечивает простой
способ выполнения выводов в виде однострочных вызовов API с контролем над генерируемыми предсказаниями.`,et,ts,Ia=`В то время как модель Whisper демонстрирует отличные результаты на многих языках с большим количеством ресурсов, она имеет более низкую
точность транскрибации и перевода на языках с малым количеством ресурсов, т.е. на языках с меньшим количеством доступных обучающих данных.
Кроме того, существуют различия в результатах работы с разными акцентами и диалектами некоторых языков, включая более низкую точность для
носителей разных полов, рас, возрастов и других демографических критериев (например, <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper paper</a>).`,tt,as,ba=`Для повышения производительности при работе с языками, акцентами или диалектами, не имеющими достаточного количества ресурсов, мы можем взять
предварительно обученную модель Whisper и обучить ее на небольшом корпусе данных, подобранных соответствующим образом, в процессе,
называемом <em>дообучением</em>. Мы покажем, что всего десять часов дополнительных данных позволяют повысить производительность модели Whisper более
чем на 100% на языке с низким уровнем ресурсов. В следующей секции мы рассмотрим процесс выбора набора данных для дообучения модели.`,at,ns,nt,is,pt;return f=new ys({props:{title:"Предварительно обученные модели для распознавания речи",local:"предварительно-обученные-модели-для-распознавания-речи",headingTag:"h1"}}),Q=new ys({props:{title:"Анализ моделей CTC",local:"анализ-моделей-ctc",headingTag:"h2"}}),R=new r({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMEEpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(
    <span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>
)
dataset`,wrap:!1}}),k=new r({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidmaWxlJyUyQyUyMCdhdWRpbyclMkMlMjAndGV4dCclMkMlMjAnc3BlYWtlcl9pZCclMkMlMjAnY2hhcHRlcl9pZCclMkMlMjAnaWQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA3MyUwQSU3RCk=",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;file&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;speaker_id&#x27;</span>, <span class="hljs-string">&#x27;chapter_id&#x27;</span>, <span class="hljs-string">&#x27;id&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">73</span>
})`,wrap:!1}}),G=new r({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjIlNUQlMEElMEFwcmludChzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEKSUwQUF1ZGlvKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjByYXRlJTNEc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sample = dataset[<span class="hljs-number">2</span>]

<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),F=new r({props:{code:"SEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5E",highlighted:'HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND',wrap:!1}}),W=new r({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItYmFzZS0xMDBoJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;facebook/wav2vec2-base-100h&quot;</span>)`,wrap:!1}}),N=new r({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCkp",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())',wrap:!1}}),Y=new r({props:{code:"JTdCJTIydGV4dCUyMiUzQSUyMCUyMkhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMENIUklTVE1BVVMlMjBBTkQlMjBST1NFJTIwQkVFRiUyMExPT01JTkclMjBCRUZPUkUlMjBVUyUyMFNJTUFMWUlTJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQlMjIlN0Q=",highlighted:'<span class="hljs-comment">{&quot;text&quot;: &quot;HE TELLS US THAT AT THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAUS AND ROSE BEEF LOOMING BEFORE US SIMALYIS DRAWN FROM EATING AND ITS RESULTS OCCUR MOST READILY TO THE MIND&quot;}</span>',wrap:!1}}),L=new r({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMCUyMEhFJTIwVEVMTFMlMjBVUyUyMFRIQVQlMjBBVCUyMFRISVMlMjBGRVNUSVZFJTIwU0VBU09OJTIwT0YlMjBUSEUlMjBZRUFSJTIwV0lUSCUyMCoqQ0hSSVNUTUFVUyoqJTIwQU5EJTIwKipST1NFKiolMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwKipTSU1BTFlJUyoqJTIwRFJBV04lMjBGUk9NJTIwRUFUSU5HJTIwQU5EJTIwSVRTJTIwUkVTVUxUUyUyME9DQ1VSJTIwTU9TVCUyMFJFQURJTFklMjBUTyUyMFRIRSUyME1JTkQ=",highlighted:`<span class="hljs-symbol">Target:</span>      HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span>  HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH **CHRISTMAUS** <span class="hljs-keyword">AND </span>**ROSE** <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US **SIMALYIS** DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND`,wrap:!1}}),O=new ys({props:{title:"Переход к Seq2Seq",local:"переход-к-seq2seq",headingTag:"h2"}}),il=new r({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`,wrap:!1}}),yl=new r({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>)',wrap:!1}}),wl=new r({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMENocmlzdG1hcyUyMGFuZCUyMHJvYXN0JTIwYmVlZiUyMGxvb21pbmclMjBiZWZvcmUlMjB1cyUyQyUyMHNpbWlsYXJseSUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQuJyU3RA==",highlighted:'{&#x27;<span class="hljs-built_in">text</span>&#x27;: &#x27; He tells us <span class="hljs-keyword">that</span> <span class="hljs-keyword">at</span> this festive season <span class="hljs-keyword">of</span> <span class="hljs-keyword">the</span> <span class="hljs-built_in">year</span>, <span class="hljs-keyword">with</span> Christmas <span class="hljs-keyword">and</span> roast beef looming <span class="hljs-keyword">before</span> us, similarly <span class="hljs-keyword">is</span> drawn <span class="hljs-keyword">from</span> eating <span class="hljs-keyword">and</span> <span class="hljs-keyword">its</span> results occur most readily <span class="hljs-keyword">to</span> <span class="hljs-keyword">the</span> mind.&#x27;}',wrap:!1}}),rl=new r({props:{code:"VGFyZ2V0JTNBJTIwJTIwJTIwJTIwJTIwSEUlMjBURUxMUyUyMFVTJTIwVEhBVCUyMEFUJTIwVEhJUyUyMEZFU1RJVkUlMjBTRUFTT04lMjBPRiUyMFRIRSUyMFlFQVIlMjBXSVRIJTIwQ0hSSVNUTUFTJTIwQU5EJTIwUk9BU1QlMjBCRUVGJTIwTE9PTUlORyUyMEJFRk9SRSUyMFVTJTIwU0lNSUxFUyUyMERSQVdOJTIwRlJPTSUyMEVBVElORyUyMEFORCUyMElUUyUyMFJFU1VMVFMlMjBPQ0NVUiUyME1PU1QlMjBSRUFESUxZJTIwVE8lMjBUSEUlMjBNSU5EJTBBUHJlZGljdGlvbiUzQSUyMEhlJTIwdGVsbHMlMjB1cyUyMHRoYXQlMjBhdCUyMHRoaXMlMjBmZXN0aXZlJTIwc2Vhc29uJTIwb2YlMjB0aGUlMjB5ZWFyJTJDJTIwd2l0aCUyMCoqQ2hyaXN0bWFzKiolMjBhbmQlMjAqKnJvYXN0KiolMjBiZWVmJTIwbG9vbWluZyUyMGJlZm9yZSUyMHVzJTJDJTIwKipzaW1pbGFybHkqKiUyMGlzJTIwZHJhd24lMjBmcm9tJTIwZWF0aW5nJTIwYW5kJTIwaXRzJTIwcmVzdWx0cyUyMG9jY3VyJTIwbW9zdCUyMHJlYWRpbHklMjB0byUyMHRoZSUyMG1pbmQu",highlighted:`<span class="hljs-symbol">Target:</span>     HE TELLS US THAT <span class="hljs-built_in">AT</span> THIS FESTIVE SEASON OF THE YEAR WITH CHRISTMAS <span class="hljs-keyword">AND </span>ROAST <span class="hljs-keyword">BEEF </span>LOOMING <span class="hljs-keyword">BEFORE </span>US SIMILES DRAWN FROM EATING <span class="hljs-keyword">AND </span>ITS RESULTS OCCUR MOST READILY TO THE MIND
<span class="hljs-symbol">Prediction:</span> He tells us that <span class="hljs-built_in">at</span> this festive season of the year, with **Christmas** <span class="hljs-keyword">and </span>**roast** <span class="hljs-keyword">beef </span>looming <span class="hljs-keyword">before </span>us, **similarly** is drawn from eating <span class="hljs-keyword">and </span>its results occur most readily to the mind.`,wrap:!1}}),jl=new r({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm11bHRpbGluZ3VhbF9saWJyaXNwZWVjaCUyMiUyQyUyMCUyMnNwYW5pc2glMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTBBKSUwQXNhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSk=",highlighted:`dataset = load_dataset(
    <span class="hljs-string">&quot;facebook/multilingual_librispeech&quot;</span>, <span class="hljs-string">&quot;spanish&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`,wrap:!1}}),dl=new r({props:{code:"cHJpbnQoc2FtcGxlJTVCJTIydGV4dCUyMiU1RCklMEFBdWRpbyhzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmF0ZSUzRHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;text&quot;</span>])
Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),Il=new r({props:{code:"ZW50b25jZXMlMjB0ZSUyMGRlbGVsaXRhciVDMyVBMXMlMjBlbiUyMGplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjAlQzMlQTElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwamFjb2IlMjB0dSUyMHBhZHJlJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBqZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRv",highlighted:'entonces <span class="hljs-keyword">te</span> delelitarás <span class="hljs-keyword">en</span> jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré á comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> jehová lo ha hablado',wrap:!1}}),fl=new r({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RC5jb3B5KCklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1NiUyQyUyMGdlbmVyYXRlX2t3YXJncyUzRCU3QiUyMnRhc2slMjIlM0ElMjAlMjJ0cmFuc2NyaWJlJTIyJTdEKQ==",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy(), max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>})',wrap:!1}}),El=new r({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUyMGhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4nJTdE",highlighted:'{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span> heredad <span class="hljs-keyword">de</span> Jacob tu padre porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado.&#x27;}',wrap:!1}}),xl=new r({props:{code:"cGlwZShzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zbGF0ZSUyMiU3RCk=",highlighted:'pipe(sample[<span class="hljs-string">&quot;audio&quot;</span>], max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})',wrap:!1}}),Ql=new r({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMFNvJTIweW91JTIwd2lsbCUyMGNob29zZSUyMGluJTIwSmVob3ZhaCUyMGFuZCUyMEklMjB3aWxsJTIwcmFpc2UlMjB5b3UlMjBvbiUyMHRoZSUyMGhlaWdodHMlMjBvZiUyMHRoZSUyMGVhcnRoJTIwYW5kJTIwSSUyMHdpbGwlMjBnaXZlJTIweW91JTIwdGhlJTIwaG9ub3IlMjBvZiUyMEphY29iJTIwdG8lMjB5b3VyJTIwZmF0aGVyJTIwYmVjYXVzZSUyMHRoZSUyMHZvaWNlJTIwb2YlMjBKZWhvdmFoJTIwaGFzJTIwc3Bva2VuJTIwdG8lMjB5b3UuJyU3RA==",highlighted:'<span class="hljs-comment">{&#x27;text&#x27;: &#x27; So you will choose in Jehovah and I will raise you on the heights of the earth and I will give you the honor of Jacob to your father because the voice of Jehovah has spoken to you.&#x27;}</span>',wrap:!1}}),gl=new ys({props:{title:"Длинноформатная транскрипция и временные метки",local:"длинноформатная-транскрипция-и-временные-метки",headingTag:"h2"}}),$l=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_length_in_m = <span class="hljs-number">5</span>

<span class="hljs-comment"># преобразование из минут в секунды (* 60) в число выборок (* частота дискретизации)</span>
sampling_rate = pipe.feature_extractor.sampling_rate
target_length_in_samples = target_length_in_m * <span class="hljs-number">60</span> * sampling_rate

<span class="hljs-comment"># итерируемся по нашему потоковому набору данных, конкатенируя выборки до тех пор, пока мы не достигнем нашей цели</span>
long_audio = []
<span class="hljs-keyword">for</span> sample <span class="hljs-keyword">in</span> dataset:
    long_audio.extend(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(long_audio) &gt; target_length_in_samples:
        <span class="hljs-keyword">break</span>

long_audio = np.asarray(long_audio)

<span class="hljs-comment"># что у нас получилось?</span>
seconds = <span class="hljs-built_in">len</span>(long_audio) / <span class="hljs-number">16000</span>
minutes, seconds = <span class="hljs-built_in">divmod</span>(seconds, <span class="hljs-number">60</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Length of audio sample is <span class="hljs-subst">{minutes}</span> minutes <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)`,wrap:!1}}),Hl=new r({props:{code:"TGVuZ3RoJTIwb2YlMjBhdWRpbyUyMHNhbXBsZSUyMGlzJTIwNS4wJTIwbWludXRlcyUyMDE3LjIyJTIwc2Vjb25kcw==",highlighted:'<span class="hljs-attribute">Length</span> of audio sample is <span class="hljs-number">5</span>.<span class="hljs-number">0</span> minutes <span class="hljs-number">17</span>.<span class="hljs-number">22</span> seconds',wrap:!1}}),Al=new r({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
)`,wrap:!1}}),zl=new r({props:{code:"JTdCJ3RleHQnJTNBJTIwJyUyMEVudG9uY2VzJTIwdGUlMjBkZWxlaXRhciVDMyVBMXMlMjBlbiUyMEplaG92JUMzJUExJTJDJTIweSUyMHlvJTIwdGUlMjBoYXIlQzMlQTklMjBzdWJpciUyMHNvYnJlJTIwbGFzJTIwYWx0dXJhcyUyMGRlJTIwbGElMjB0aWVycmElMkMlMjB5JTIwdGUlMjBkYXIlQzMlQTklMjBhJTIwY29tZXIlMjBsYSUwQWhlcmVkYWQlMjBkZSUyMEphY29iJTIwdHUlMjBwYWRyZSUyQyUyMHBvcnF1ZSUyMGxhJTIwYm9jYSUyMGRlJTIwSmVob3YlQzMlQTElMjBsbyUyMGhhJTIwaGFibGFkby4lMjBub3NvdHJvcyUyMGN1cmFkb3MuJTIwVG9kb3MlMjBub3NvdHJvcyUyMG5vcyUyMGRlc2NhcnJpYW1vcyUwQWNvbW8lMjBiZWphcyUyQyUyMGNhZGElMjBjdWFsJTIwc2UlMjBhcGFydCVDMyVCMyUyMHBvciUyMHN1JTIwY2FtaW5vJTJDJTIwbWFzJTIwSmVob3YlQzMlQTElMjBjYXJnJUMzJUIzJTIwZW4lMjAlQzMlQTlsJTIwZWwlMjBwZWNhZG8lMjBkZSUyMHRvZG9zJTIwbm9zb3Ryb3MuLi4=",highlighted:`{&#x27;text&#x27;: &#x27; Entonces <span class="hljs-keyword">te</span> deleitarás <span class="hljs-keyword">en</span> Jehová, y yo <span class="hljs-keyword">te</span> haré subir sobre las alturas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> tierra, y <span class="hljs-keyword">te</span> daré a comer <span class="hljs-keyword">la</span>
heredad <span class="hljs-keyword">de</span> Jacob tu padre, porque <span class="hljs-keyword">la</span> boca <span class="hljs-keyword">de</span> Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos
como bejas, cada cual <span class="hljs-keyword">se</span> apartó por <span class="hljs-keyword">su</span> camino, mas Jehová cargó <span class="hljs-keyword">en</span> é<span class="hljs-keyword">l</span> el pecado <span class="hljs-keyword">de</span> todos nosotros...`,wrap:!1}}),Ol=new r({props:{code:"cGlwZSglMEElMjAlMjAlMjAlMjBsb25nX2F1ZGlvJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNjcmliZSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSUyQyUwQSklNUIlMjJjaHVua3MlMjIlNUQ=",highlighted:`pipe(
    long_audio,
    max_new_tokens=<span class="hljs-number">256</span>,
    generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>},
    chunk_length_s=<span class="hljs-number">30</span>,
    batch_size=<span class="hljs-number">8</span>,
    return_timestamps=<span class="hljs-literal">True</span>,
)[<span class="hljs-string">&quot;chunks&quot;</span>]`,wrap:!1}}),Kl=new r({props:{code:"JTVCJTdCJ3RpbWVzdGFtcCclM0ElMjAoMC4wJTJDJTIwMjYuNCklMkMlMEElMjAlMjAndGV4dCclM0ElMjAnJTIwRW50b25jZXMlMjB0ZSUyMGRlbGVpdGFyJUMzJUExcyUyMGVuJTIwSmVob3YlQzMlQTElMkMlMjB5JTIweW8lMjB0ZSUyMGhhciVDMyVBOSUyMHN1YmlyJTIwc29icmUlMjBsYXMlMjBhbHR1cmFzJTIwZGUlMjBsYSUyMHRpZXJyYSUyQyUyMHklMjB0ZSUyMGRhciVDMyVBOSUyMGElMjBjb21lciUyMGxhJTIwaGVyZWRhZCUyMGRlJTIwSmFjb2IlMjB0dSUyMHBhZHJlJTJDJTIwcG9ycXVlJTIwbGElMjBib2NhJTIwZGUlMjBKZWhvdiVDMyVBMSUyMGxvJTIwaGElMjBoYWJsYWRvLiUyMG5vc290cm9zJTIwY3VyYWRvcy4lMjBUb2RvcyUyMG5vc290cm9zJTIwbm9zJTIwZGVzY2FycmlhbW9zJTIwY29tbyUyMGJlamFzJTJDJTIwY2FkYSUyMGN1YWwlMjBzZSUyMGFwYXJ0JUMzJUIzJTIwcG9yJTIwc3UlMjBjYW1pbm8lMkMnJTdEJTJDJTBBJTIwJTdCJ3RpbWVzdGFtcCclM0ElMjAoMjYuNCUyQyUyMDMyLjQ4KSUyQyUwQSUyMCUyMCd0ZXh0JyUzQSUyMCclMjBtYXMlMjBKZWhvdiVDMyVBMSUyMGNhcmclQzMlQjMlMjBlbiUyMCVDMyVBOWwlMjBlbCUyMHBlY2FkbyUyMGRlJTIwdG9kb3MlMjBub3NvdHJvcy4lMjBObyUyMGVzJTIwcXVlJTIwcGFydGFzJTIwdHUlMjBwYW4lMjBjb24lMjBlbCclN0QlMkMlMEElMjAlN0IndGltZXN0YW1wJyUzQSUyMCgzMi40OCUyQyUyMDM4LjQpJTJDJTBBJTIwJTIwJ3RleHQnJTNBJTIwJyUyMGhhbWJyaWVudG8lMjB5JTIwYSUyMGxvcyUyMGhvbWJyZXMlMjBoZXJyYW50ZXMlMjBtZXRhcyUyMGVuJTIwY2FzYSUyQyUyMHF1ZSUyMGN1YW5kbyUyMHZpZXJlcyUyMGFsJTIwZGVzbnVkbyUyMGxvJTIwY3VicmFzJTIweSUyMG5vJyU3RCUyQyUwQSUyMC4uLg==",highlighted:`[{<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">0.0</span>, <span class="hljs-number">26.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; Entonces te deleitarás en Jehová, y yo te haré subir sobre las alturas de la tierra, y te daré a comer la heredad de Jacob tu padre, porque la boca de Jehová lo ha hablado. nosotros curados. Todos nosotros nos descarriamos como bejas, cada cual se apartó por su camino,&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">26.4</span>, <span class="hljs-number">32.48</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; mas Jehová cargó en él el pecado de todos nosotros. No es que partas tu pan con el&#x27;},
 {<span class="hljs-symbol">&#x27;timestamp</span><span class="hljs-symbol">&#x27;:</span> (<span class="hljs-name">32.48</span>, <span class="hljs-number">38.4</span>),
  <span class="hljs-symbol">&#x27;text</span><span class="hljs-symbol">&#x27;:</span> &#x27; hambriento y a los hombres herrantes metas en casa, que cuando vieres al desnudo lo cubras y no&#x27;},
 ...`,wrap:!1}}),ss=new ys({props:{title:"Итоги",local:"итоги",headingTag:"h2"}}),ns=new ka({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/ru/chapter5/asr_models.mdx"}}),{c(){c=p("meta"),Ts=a(),Js=p("p"),ws=a(),i(f.$$.fragment),ms=a(),C=p("p"),C.innerHTML=rt,rs=a(),E=p("p"),E.textContent=ht,hs=a(),S=p("ol"),S.innerHTML=ot,os=a(),x=p("p"),x.innerHTML=jt,js=a(),B=p("p"),B.textContent=ct,cs=a(),i(Q.$$.fragment),ds=a(),V=p("p"),V.innerHTML=dt,us=a(),i(R.$$.fragment),Is=a(),g=p("p"),g.innerHTML=ut,bs=a(),i(k.$$.fragment),fs=a(),v=p("p"),v.textContent=It,Cs=a(),i(G.$$.fragment),Es=a(),$=p("p"),$.innerHTML=bt,Ss=a(),i(F.$$.fragment),xs=a(),H=p("p"),H.innerHTML=ft,Bs=a(),i(W.$$.fragment),Qs=a(),Z=p("p"),Z.innerHTML=Ct,Vs=a(),i(N.$$.fragment),Rs=a(),_=p("p"),_.innerHTML=Et,gs=a(),i(Y.$$.fragment),ks=a(),A=p("p"),A.textContent=St,vs=a(),i(L.$$.fragment),Gs=a(),z=p("p"),z.innerHTML=xt,$s=a(),X=p("ul"),X.innerHTML=Bt,Fs=a(),q=p("p"),q.textContent=Qt,Hs=a(),D=p("p"),D.innerHTML=Vt,Ws=a(),i(O.$$.fragment),Zs=a(),P=p("p"),P.innerHTML=Rt,Ns=a(),K=p("p"),K.textContent=gt,_s=a(),ll=p("ol"),ll.innerHTML=kt,Ys=a(),sl=p("p"),sl.innerHTML=vt,As=a(),el=p("p"),el.innerHTML=Gt,Ls=a(),tl=p("p"),tl.innerHTML=$t,zs=a(),al=p("p"),al.textContent=Ft,Xs=a(),nl=p("p"),nl.textContent=Ht,qs=a(),pl=p("p"),pl.innerHTML=Wt,Ds=a(),Ml=p("table"),Ml.innerHTML=Zt,Os=a(),Jl=p("p"),Jl.innerHTML=Nt,Ps=a(),i(il.$$.fragment),Ks=a(),Ul=p("p"),Ul.innerHTML=_t,le=a(),i(yl.$$.fragment),se=a(),Tl=p("p"),Tl.innerHTML=Yt,ee=a(),i(wl.$$.fragment),te=a(),ml=p("p"),ml.textContent=At,ae=a(),i(rl.$$.fragment),ne=a(),hl=p("p"),hl.innerHTML=Lt,pe=a(),ol=p("p"),ol.innerHTML=zt,Me=a(),i(jl.$$.fragment),Je=a(),cl=p("p"),cl.textContent=Xt,ie=a(),i(dl.$$.fragment),Ue=a(),ul=p("p"),ul.innerHTML=qt,ye=a(),i(Il.$$.fragment),Te=a(),bl=p("p"),bl.innerHTML=Dt,we=a(),i(fl.$$.fragment),me=a(),Cl=p("p"),Cl.innerHTML=Ot,re=a(),i(El.$$.fragment),he=a(),Sl=p("p"),Sl.innerHTML=Pt,oe=a(),i(xl.$$.fragment),je=a(),Bl=p("p"),Bl.innerHTML=Kt,ce=a(),i(Ql.$$.fragment),de=a(),Vl=p("p"),Vl.textContent=la,ue=a(),Rl=p("p"),Rl.innerHTML=sa,Ie=a(),i(gl.$$.fragment),be=a(),kl=p("p"),kl.textContent=ea,fe=a(),vl=p("p"),vl.textContent=ta,Ce=a(),Gl=p("p"),Gl.textContent=aa,Ee=a(),i($l.$$.fragment),Se=a(),Fl=p("p"),Fl.innerHTML=na,xe=a(),i(Hl.$$.fragment),Be=a(),Wl=p("p"),Wl.textContent=pa,Qe=a(),Zl=p("ol"),Zl.innerHTML=Ma,Ve=a(),Nl=p("p"),Nl.innerHTML=Ja,Re=a(),d=p("div"),d.innerHTML=ia,ge=a(),h=p("p"),it=I("Преимущество фрагментирования аудиообразцов на части заключается в том, что нам не нужен результат транскрибации небольшого фрагмента аудиосигнала"),ke=new Mt(!1),ve=I(`
для транскрибации последующего фрагмента`),Ge=new Mt(!1),$e=I(`. Соединение выполняется после того, как мы
транскрибировали все фрагменты на границах фрагментов, поэтому не имеет значения, в каком порядке мы их транскрибируем. Алгоритм полностью `),ps=p("strong"),ps.textContent=Ua,Ut=I(`,
поэтому мы можем даже обрабатывать фрагмент`),Fe=new Mt(!1),He=I(" одновременно с фрагментом"),We=new Mt(!1),Ze=I("! Это позволяет нам "),Ms=p("em"),Ms.textContent=ya,yt=I(` (от англ. batch) фрагменты
и прогонять их через модель параллельно, обеспечивая значительное ускорение вычислений по сравнению с их последовательной транскрибацией. Более подробно
о фрагментированни в 🤗 Transformers можно прочитать в `),u=p("a"),u.textContent=Ta,Tt=I("."),Ne=a(),_l=p("p"),_l.innerHTML=wa,_e=a(),Yl=p("p"),Yl.innerHTML=ma,Ye=a(),i(Al.$$.fragment),Ae=a(),Ll=p("p"),Ll.innerHTML=ra,Le=a(),i(zl.$$.fragment),ze=a(),Xl=p("p"),Xl.textContent=ha,Xe=a(),ql=p("p"),ql.innerHTML=oa,qe=a(),Dl=p("p"),Dl.innerHTML=ja,De=a(),i(Ol.$$.fragment),Oe=a(),Pl=p("p"),Pl.innerHTML=ca,Pe=a(),i(Kl.$$.fragment),Ke=a(),ls=p("p"),ls.textContent=da,lt=a(),i(ss.$$.fragment),st=a(),es=p("p"),es.innerHTML=ua,et=a(),ts=p("p"),ts.innerHTML=Ia,tt=a(),as=p("p"),as.innerHTML=ba,at=a(),i(ns.$$.fragment),nt=a(),is=p("p"),this.h()},l(l){const s=ga("svelte-u9bgzb",document.head);c=M(s,"META",{name:!0,content:!0}),s.forEach(e),Ts=n(l),Js=M(l,"P",{}),wt(Js).forEach(e),ws=n(l),U(f.$$.fragment,l),ms=n(l),C=M(l,"P",{"data-svelte-h":!0}),J(C)!=="svelte-1gtvm8h"&&(C.innerHTML=rt),rs=n(l),E=M(l,"P",{"data-svelte-h":!0}),J(E)!=="svelte-6jcjni"&&(E.textContent=ht),hs=n(l),S=M(l,"OL",{"data-svelte-h":!0}),J(S)!=="svelte-bjelpo"&&(S.innerHTML=ot),os=n(l),x=M(l,"P",{"data-svelte-h":!0}),J(x)!=="svelte-1vky12r"&&(x.innerHTML=jt),js=n(l),B=M(l,"P",{"data-svelte-h":!0}),J(B)!=="svelte-1vi57w3"&&(B.textContent=ct),cs=n(l),U(Q.$$.fragment,l),ds=n(l),V=M(l,"P",{"data-svelte-h":!0}),J(V)!=="svelte-5khewd"&&(V.innerHTML=dt),us=n(l),U(R.$$.fragment,l),Is=n(l),g=M(l,"P",{"data-svelte-h":!0}),J(g)!=="svelte-1mvdyro"&&(g.innerHTML=ut),bs=n(l),U(k.$$.fragment,l),fs=n(l),v=M(l,"P",{"data-svelte-h":!0}),J(v)!=="svelte-1ibu3ww"&&(v.textContent=It),Cs=n(l),U(G.$$.fragment,l),Es=n(l),$=M(l,"P",{"data-svelte-h":!0}),J($)!=="svelte-1mvdyro"&&($.innerHTML=bt),Ss=n(l),U(F.$$.fragment,l),xs=n(l),H=M(l,"P",{"data-svelte-h":!0}),J(H)!=="svelte-aibedu"&&(H.innerHTML=ft),Bs=n(l),U(W.$$.fragment,l),Qs=n(l),Z=M(l,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-i8aadp"&&(Z.innerHTML=Ct),Vs=n(l),U(N.$$.fragment,l),Rs=n(l),_=M(l,"P",{"data-svelte-h":!0}),J(_)!=="svelte-1mvdyro"&&(_.innerHTML=Et),gs=n(l),U(Y.$$.fragment,l),ks=n(l),A=M(l,"P",{"data-svelte-h":!0}),J(A)!=="svelte-htuiqs"&&(A.textContent=St),vs=n(l),U(L.$$.fragment,l),Gs=n(l),z=M(l,"P",{"data-svelte-h":!0}),J(z)!=="svelte-10h19k1"&&(z.innerHTML=xt),$s=n(l),X=M(l,"UL",{"data-svelte-h":!0}),J(X)!=="svelte-11mc7qy"&&(X.innerHTML=Bt),Fs=n(l),q=M(l,"P",{"data-svelte-h":!0}),J(q)!=="svelte-qu6mk6"&&(q.textContent=Qt),Hs=n(l),D=M(l,"P",{"data-svelte-h":!0}),J(D)!=="svelte-sq2gy5"&&(D.innerHTML=Vt),Ws=n(l),U(O.$$.fragment,l),Zs=n(l),P=M(l,"P",{"data-svelte-h":!0}),J(P)!=="svelte-1i2fk02"&&(P.innerHTML=Rt),Ns=n(l),K=M(l,"P",{"data-svelte-h":!0}),J(K)!=="svelte-1ifxb88"&&(K.textContent=gt),_s=n(l),ll=M(l,"OL",{"data-svelte-h":!0}),J(ll)!=="svelte-71blpy"&&(ll.innerHTML=kt),Ys=n(l),sl=M(l,"P",{"data-svelte-h":!0}),J(sl)!=="svelte-1qrj0ya"&&(sl.innerHTML=vt),As=n(l),el=M(l,"P",{"data-svelte-h":!0}),J(el)!=="svelte-15998yu"&&(el.innerHTML=Gt),Ls=n(l),tl=M(l,"P",{"data-svelte-h":!0}),J(tl)!=="svelte-1qtehni"&&(tl.innerHTML=$t),zs=n(l),al=M(l,"P",{"data-svelte-h":!0}),J(al)!=="svelte-el2qut"&&(al.textContent=Ft),Xs=n(l),nl=M(l,"P",{"data-svelte-h":!0}),J(nl)!=="svelte-1j2fp4v"&&(nl.textContent=Ht),qs=n(l),pl=M(l,"P",{"data-svelte-h":!0}),J(pl)!=="svelte-1bqbmak"&&(pl.innerHTML=Wt),Ds=n(l),Ml=M(l,"TABLE",{"data-svelte-h":!0}),J(Ml)!=="svelte-leifmh"&&(Ml.innerHTML=Zt),Os=n(l),Jl=M(l,"P",{"data-svelte-h":!0}),J(Jl)!=="svelte-7zg689"&&(Jl.innerHTML=Nt),Ps=n(l),U(il.$$.fragment,l),Ks=n(l),Ul=M(l,"P",{"data-svelte-h":!0}),J(Ul)!=="svelte-1ilagb0"&&(Ul.innerHTML=_t),le=n(l),U(yl.$$.fragment,l),se=n(l),Tl=M(l,"P",{"data-svelte-h":!0}),J(Tl)!=="svelte-1mvdyro"&&(Tl.innerHTML=Yt),ee=n(l),U(wl.$$.fragment,l),te=n(l),ml=M(l,"P",{"data-svelte-h":!0}),J(ml)!=="svelte-cuywh6"&&(ml.textContent=At),ae=n(l),U(rl.$$.fragment,l),ne=n(l),hl=M(l,"P",{"data-svelte-h":!0}),J(hl)!=="svelte-18d7cq3"&&(hl.innerHTML=Lt),pe=n(l),ol=M(l,"P",{"data-svelte-h":!0}),J(ol)!=="svelte-1bh6i43"&&(ol.innerHTML=zt),Me=n(l),U(jl.$$.fragment,l),Je=n(l),cl=M(l,"P",{"data-svelte-h":!0}),J(cl)!=="svelte-1q4wmmh"&&(cl.textContent=Xt),ie=n(l),U(dl.$$.fragment,l),Ue=n(l),ul=M(l,"P",{"data-svelte-h":!0}),J(ul)!=="svelte-1mvdyro"&&(ul.innerHTML=qt),ye=n(l),U(Il.$$.fragment,l),Te=n(l),bl=M(l,"P",{"data-svelte-h":!0}),J(bl)!=="svelte-14g7j7g"&&(bl.innerHTML=Dt),we=n(l),U(fl.$$.fragment,l),me=n(l),Cl=M(l,"P",{"data-svelte-h":!0}),J(Cl)!=="svelte-1mvdyro"&&(Cl.innerHTML=Ot),re=n(l),U(El.$$.fragment,l),he=n(l),Sl=M(l,"P",{"data-svelte-h":!0}),J(Sl)!=="svelte-j49oek"&&(Sl.innerHTML=Pt),oe=n(l),U(xl.$$.fragment,l),je=n(l),Bl=M(l,"P",{"data-svelte-h":!0}),J(Bl)!=="svelte-1mvdyro"&&(Bl.innerHTML=Kt),ce=n(l),U(Ql.$$.fragment,l),de=n(l),Vl=M(l,"P",{"data-svelte-h":!0}),J(Vl)!=="svelte-iwrqcj"&&(Vl.textContent=la),ue=n(l),Rl=M(l,"P",{"data-svelte-h":!0}),J(Rl)!=="svelte-17xpsvz"&&(Rl.innerHTML=sa),Ie=n(l),U(gl.$$.fragment,l),be=n(l),kl=M(l,"P",{"data-svelte-h":!0}),J(kl)!=="svelte-z1wxhe"&&(kl.textContent=ea),fe=n(l),vl=M(l,"P",{"data-svelte-h":!0}),J(vl)!=="svelte-1dkwyap"&&(vl.textContent=ta),Ce=n(l),Gl=M(l,"P",{"data-svelte-h":!0}),J(Gl)!=="svelte-1tfnh52"&&(Gl.textContent=aa),Ee=n(l),U($l.$$.fragment,l),Se=n(l),Fl=M(l,"P",{"data-svelte-h":!0}),J(Fl)!=="svelte-1mvdyro"&&(Fl.innerHTML=na),xe=n(l),U(Hl.$$.fragment,l),Be=n(l),Wl=M(l,"P",{"data-svelte-h":!0}),J(Wl)!=="svelte-wptioh"&&(Wl.textContent=pa),Qe=n(l),Zl=M(l,"OL",{"data-svelte-h":!0}),J(Zl)!=="svelte-1too0g5"&&(Zl.innerHTML=Ma),Ve=n(l),Nl=M(l,"P",{"data-svelte-h":!0}),J(Nl)!=="svelte-zc3x59"&&(Nl.innerHTML=Ja),Re=n(l),d=M(l,"DIV",{class:!0,"data-svelte-h":!0}),J(d)!=="svelte-dbmn5s"&&(d.innerHTML=ia),ge=n(l),h=M(l,"P",{});var o=wt(h);it=b(o,"Преимущество фрагментирования аудиообразцов на части заключается в том, что нам не нужен результат транскрибации небольшого фрагмента аудиосигнала"),ke=Jt(o,!1),ve=b(o,`
для транскрибации последующего фрагмента`),Ge=Jt(o,!1),$e=b(o,`. Соединение выполняется после того, как мы
транскрибировали все фрагменты на границах фрагментов, поэтому не имеет значения, в каком порядке мы их транскрибируем. Алгоритм полностью `),ps=M(o,"STRONG",{"data-svelte-h":!0}),J(ps)!=="svelte-1n450gz"&&(ps.textContent=Ua),Ut=b(o,`,
поэтому мы можем даже обрабатывать фрагмент`),Fe=Jt(o,!1),He=b(o," одновременно с фрагментом"),We=Jt(o,!1),Ze=b(o,"! Это позволяет нам "),Ms=M(o,"EM",{"data-svelte-h":!0}),J(Ms)!=="svelte-x1261k"&&(Ms.textContent=ya),yt=b(o,` (от англ. batch) фрагменты
и прогонять их через модель параллельно, обеспечивая значительное ускорение вычислений по сравнению с их последовательной транскрибацией. Более подробно
о фрагментированни в 🤗 Transformers можно прочитать в `),u=M(o,"A",{href:!0,rel:!0,"data-svelte-h":!0}),J(u)!=="svelte-vrtp4c"&&(u.textContent=Ta),Tt=b(o,"."),o.forEach(e),Ne=n(l),_l=M(l,"P",{"data-svelte-h":!0}),J(_l)!=="svelte-rnzic7"&&(_l.innerHTML=wa),_e=n(l),Yl=M(l,"P",{"data-svelte-h":!0}),J(Yl)!=="svelte-575eay"&&(Yl.innerHTML=ma),Ye=n(l),U(Al.$$.fragment,l),Ae=n(l),Ll=M(l,"P",{"data-svelte-h":!0}),J(Ll)!=="svelte-1mvdyro"&&(Ll.innerHTML=ra),Le=n(l),U(zl.$$.fragment,l),ze=n(l),Xl=M(l,"P",{"data-svelte-h":!0}),J(Xl)!=="svelte-n1n71v"&&(Xl.textContent=ha),Xe=n(l),ql=M(l,"P",{"data-svelte-h":!0}),J(ql)!=="svelte-1w5bf9x"&&(ql.innerHTML=oa),qe=n(l),Dl=M(l,"P",{"data-svelte-h":!0}),J(Dl)!=="svelte-1gr2r2y"&&(Dl.innerHTML=ja),De=n(l),U(Ol.$$.fragment,l),Oe=n(l),Pl=M(l,"P",{"data-svelte-h":!0}),J(Pl)!=="svelte-1mvdyro"&&(Pl.innerHTML=ca),Pe=n(l),U(Kl.$$.fragment,l),Ke=n(l),ls=M(l,"P",{"data-svelte-h":!0}),J(ls)!=="svelte-1glad5k"&&(ls.textContent=da),lt=n(l),U(ss.$$.fragment,l),st=n(l),es=M(l,"P",{"data-svelte-h":!0}),J(es)!=="svelte-z1aoca"&&(es.innerHTML=ua),et=n(l),ts=M(l,"P",{"data-svelte-h":!0}),J(ts)!=="svelte-kz3n2j"&&(ts.innerHTML=Ia),tt=n(l),as=M(l,"P",{"data-svelte-h":!0}),J(as)!=="svelte-1ciho6b"&&(as.innerHTML=ba),at=n(l),U(ns.$$.fragment,l),nt=n(l),is=M(l,"P",{}),wt(is).forEach(e),this.h()},h(){Us(c,"name","hf:doc:metadata"),Us(c,"content",Ga),Us(d,"class","flex justify-center"),ke.a=ve,Ge.a=$e,Fe.a=He,We.a=Ze,Us(u,"href","https://huggingface.co/blog/asr-chunking"),Us(u,"rel","nofollow")},m(l,s){j(document.head,c),t(l,Ts,s),t(l,Js,s),t(l,ws,s),y(f,l,s),t(l,ms,s),t(l,C,s),t(l,rs,s),t(l,E,s),t(l,hs,s),t(l,S,s),t(l,os,s),t(l,x,s),t(l,js,s),t(l,B,s),t(l,cs,s),y(Q,l,s),t(l,ds,s),t(l,V,s),t(l,us,s),y(R,l,s),t(l,Is,s),t(l,g,s),t(l,bs,s),y(k,l,s),t(l,fs,s),t(l,v,s),t(l,Cs,s),y(G,l,s),t(l,Es,s),t(l,$,s),t(l,Ss,s),y(F,l,s),t(l,xs,s),t(l,H,s),t(l,Bs,s),y(W,l,s),t(l,Qs,s),t(l,Z,s),t(l,Vs,s),y(N,l,s),t(l,Rs,s),t(l,_,s),t(l,gs,s),y(Y,l,s),t(l,ks,s),t(l,A,s),t(l,vs,s),y(L,l,s),t(l,Gs,s),t(l,z,s),t(l,$s,s),t(l,X,s),t(l,Fs,s),t(l,q,s),t(l,Hs,s),t(l,D,s),t(l,Ws,s),y(O,l,s),t(l,Zs,s),t(l,P,s),t(l,Ns,s),t(l,K,s),t(l,_s,s),t(l,ll,s),t(l,Ys,s),t(l,sl,s),t(l,As,s),t(l,el,s),t(l,Ls,s),t(l,tl,s),t(l,zs,s),t(l,al,s),t(l,Xs,s),t(l,nl,s),t(l,qs,s),t(l,pl,s),t(l,Ds,s),t(l,Ml,s),t(l,Os,s),t(l,Jl,s),t(l,Ps,s),y(il,l,s),t(l,Ks,s),t(l,Ul,s),t(l,le,s),y(yl,l,s),t(l,se,s),t(l,Tl,s),t(l,ee,s),y(wl,l,s),t(l,te,s),t(l,ml,s),t(l,ae,s),y(rl,l,s),t(l,ne,s),t(l,hl,s),t(l,pe,s),t(l,ol,s),t(l,Me,s),y(jl,l,s),t(l,Je,s),t(l,cl,s),t(l,ie,s),y(dl,l,s),t(l,Ue,s),t(l,ul,s),t(l,ye,s),y(Il,l,s),t(l,Te,s),t(l,bl,s),t(l,we,s),y(fl,l,s),t(l,me,s),t(l,Cl,s),t(l,re,s),y(El,l,s),t(l,he,s),t(l,Sl,s),t(l,oe,s),y(xl,l,s),t(l,je,s),t(l,Bl,s),t(l,ce,s),y(Ql,l,s),t(l,de,s),t(l,Vl,s),t(l,ue,s),t(l,Rl,s),t(l,Ie,s),y(gl,l,s),t(l,be,s),t(l,kl,s),t(l,fe,s),t(l,vl,s),t(l,Ce,s),t(l,Gl,s),t(l,Ee,s),y($l,l,s),t(l,Se,s),t(l,Fl,s),t(l,xe,s),y(Hl,l,s),t(l,Be,s),t(l,Wl,s),t(l,Qe,s),t(l,Zl,s),t(l,Ve,s),t(l,Nl,s),t(l,Re,s),t(l,d,s),t(l,ge,s),t(l,h,s),j(h,it),ke.m(fa,h),j(h,ve),Ge.m(Ca,h),j(h,$e),j(h,ps),j(h,Ut),Fe.m(Ea,h),j(h,He),We.m(Sa,h),j(h,Ze),j(h,Ms),j(h,yt),j(h,u),j(h,Tt),t(l,Ne,s),t(l,_l,s),t(l,_e,s),t(l,Yl,s),t(l,Ye,s),y(Al,l,s),t(l,Ae,s),t(l,Ll,s),t(l,Le,s),y(zl,l,s),t(l,ze,s),t(l,Xl,s),t(l,Xe,s),t(l,ql,s),t(l,qe,s),t(l,Dl,s),t(l,De,s),y(Ol,l,s),t(l,Oe,s),t(l,Pl,s),t(l,Pe,s),y(Kl,l,s),t(l,Ke,s),t(l,ls,s),t(l,lt,s),y(ss,l,s),t(l,st,s),t(l,es,s),t(l,et,s),t(l,ts,s),t(l,tt,s),t(l,as,s),t(l,at,s),y(ns,l,s),t(l,nt,s),t(l,is,s),pt=!0},p:Ba,i(l){pt||(T(f.$$.fragment,l),T(Q.$$.fragment,l),T(R.$$.fragment,l),T(k.$$.fragment,l),T(G.$$.fragment,l),T(F.$$.fragment,l),T(W.$$.fragment,l),T(N.$$.fragment,l),T(Y.$$.fragment,l),T(L.$$.fragment,l),T(O.$$.fragment,l),T(il.$$.fragment,l),T(yl.$$.fragment,l),T(wl.$$.fragment,l),T(rl.$$.fragment,l),T(jl.$$.fragment,l),T(dl.$$.fragment,l),T(Il.$$.fragment,l),T(fl.$$.fragment,l),T(El.$$.fragment,l),T(xl.$$.fragment,l),T(Ql.$$.fragment,l),T(gl.$$.fragment,l),T($l.$$.fragment,l),T(Hl.$$.fragment,l),T(Al.$$.fragment,l),T(zl.$$.fragment,l),T(Ol.$$.fragment,l),T(Kl.$$.fragment,l),T(ss.$$.fragment,l),T(ns.$$.fragment,l),pt=!0)},o(l){w(f.$$.fragment,l),w(Q.$$.fragment,l),w(R.$$.fragment,l),w(k.$$.fragment,l),w(G.$$.fragment,l),w(F.$$.fragment,l),w(W.$$.fragment,l),w(N.$$.fragment,l),w(Y.$$.fragment,l),w(L.$$.fragment,l),w(O.$$.fragment,l),w(il.$$.fragment,l),w(yl.$$.fragment,l),w(wl.$$.fragment,l),w(rl.$$.fragment,l),w(jl.$$.fragment,l),w(dl.$$.fragment,l),w(Il.$$.fragment,l),w(fl.$$.fragment,l),w(El.$$.fragment,l),w(xl.$$.fragment,l),w(Ql.$$.fragment,l),w(gl.$$.fragment,l),w($l.$$.fragment,l),w(Hl.$$.fragment,l),w(Al.$$.fragment,l),w(zl.$$.fragment,l),w(Ol.$$.fragment,l),w(Kl.$$.fragment,l),w(ss.$$.fragment,l),w(ns.$$.fragment,l),pt=!1},d(l){l&&(e(Ts),e(Js),e(ws),e(ms),e(C),e(rs),e(E),e(hs),e(S),e(os),e(x),e(js),e(B),e(cs),e(ds),e(V),e(us),e(Is),e(g),e(bs),e(fs),e(v),e(Cs),e(Es),e($),e(Ss),e(xs),e(H),e(Bs),e(Qs),e(Z),e(Vs),e(Rs),e(_),e(gs),e(ks),e(A),e(vs),e(Gs),e(z),e($s),e(X),e(Fs),e(q),e(Hs),e(D),e(Ws),e(Zs),e(P),e(Ns),e(K),e(_s),e(ll),e(Ys),e(sl),e(As),e(el),e(Ls),e(tl),e(zs),e(al),e(Xs),e(nl),e(qs),e(pl),e(Ds),e(Ml),e(Os),e(Jl),e(Ps),e(Ks),e(Ul),e(le),e(se),e(Tl),e(ee),e(te),e(ml),e(ae),e(ne),e(hl),e(pe),e(ol),e(Me),e(Je),e(cl),e(ie),e(Ue),e(ul),e(ye),e(Te),e(bl),e(we),e(me),e(Cl),e(re),e(he),e(Sl),e(oe),e(je),e(Bl),e(ce),e(de),e(Vl),e(ue),e(Rl),e(Ie),e(be),e(kl),e(fe),e(vl),e(Ce),e(Gl),e(Ee),e(Se),e(Fl),e(xe),e(Be),e(Wl),e(Qe),e(Zl),e(Ve),e(Nl),e(Re),e(d),e(ge),e(h),e(Ne),e(_l),e(_e),e(Yl),e(Ye),e(Ae),e(Ll),e(Le),e(ze),e(Xl),e(Xe),e(ql),e(qe),e(Dl),e(De),e(Oe),e(Pl),e(Pe),e(Ke),e(ls),e(lt),e(st),e(es),e(et),e(ts),e(tt),e(as),e(at),e(nt),e(is)),e(c),m(f,l),m(Q,l),m(R,l),m(k,l),m(G,l),m(F,l),m(W,l),m(N,l),m(Y,l),m(L,l),m(O,l),m(il,l),m(yl,l),m(wl,l),m(rl,l),m(jl,l),m(dl,l),m(Il,l),m(fl,l),m(El,l),m(xl,l),m(Ql,l),m(gl,l),m($l,l),m(Hl,l),m(Al,l),m(zl,l),m(Ol,l),m(Kl,l),m(ss,l),m(ns,l)}}}const Ga='{"title":"Предварительно обученные модели для распознавания речи","local":"предварительно-обученные-модели-для-распознавания-речи","sections":[{"title":"Анализ моделей CTC","local":"анализ-моделей-ctc","sections":[],"depth":2},{"title":"Переход к Seq2Seq","local":"переход-к-seq2seq","sections":[],"depth":2},{"title":"Длинноформатная транскрипция и временные метки","local":"длинноформатная-транскрипция-и-временные-метки","sections":[],"depth":2},{"title":"Итоги","local":"итоги","sections":[],"depth":2}],"depth":1}';function $a(mt){return Qa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Na extends Va{constructor(c){super(),Ra(this,c,$a,va,xa,{})}}export{Na as component};
