import{s as el,n as tl,o as nl}from"../chunks/scheduler.f6b352c8.js";import{S as Ml,i as ol,g as M,s as t,r as p,A as il,h as o,f as a,c as n,j as al,u,x as i,k as Zs,y as pl,a as e,v as r,d,t as m,w as c}from"../chunks/index.7f38e934.js";import{C as j}from"../chunks/CodeBlock.3ee8293b.js";import{H as ul,E as rl}from"../chunks/getInferenceSnippets.3c61f4ba.js";function dl(Bs){let y,O,D,K,J,ss,T,Es="Neste curso, utilizaremos a biblioteca 🤗 Datasets (Hugging Face Datasets) para trabalhar com datasets de áudio. 🤗 Datasets é uma biblioteca open source para baixar e preparar datasets de todas as modalidades, incluindo áudio. A biblioteca oferece fácil acesso a uma seleção única de datasets de machine learning disponíveis publicamente no Hugging Face Hub. Além disso, 🤗 Datasets inclui várias funcionalidades adaptadas para datasets de áudio que simplificam o trabalho tanto para pesquisadores quanto para praticantes.",ls,w,_s="Para começar a trabalhar com datasets de áudio certifique-se de ter a biblioteca 🤗 Datasets instalada:",as,h,es,b,Qs="Uma das principais características da 🤗 Datasets é a capacidade de baixar e preparar um dataset com apenas uma linha de código Python usando a função <code>load_dataset()</code>.",ts,f,Ws='Vamos carregar e explorar um dataset de áudio chamado <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>, que contém gravações de pessoas fazendo perguntas a um sistema de e-banking em vários idiomas e dialetos.',ns,A,Rs="Para carregar o dataset MINDS-14, precisamos copiar o identificador do dataset no Hub (<code>PolyAI/minds14</code>) e passá-lo para a função <code>load_dataset</code>. Também especificaremos que estamos interessados apenas no subconjunto Australiano dos dados, e limitá-lo ao traning split (a parte dos dados somente para treino):",Ms,C,os,I,zs="<strong>Saída:</strong>",is,g,ps,v,Fs="O dataset contém 654 arquivos de áudio, cada um possui os seguintes campos (features): transcrição, uma tradução para o inglês e um rótulo indicando o motivo da pergunta da pessoa. A coluna audio contém os dados brutos do áudio (sem processamento). Vamos dar uma olhada mais de perto em um dos exemplos:",us,$,rs,G,Ss="<strong>Saída:</strong>",ds,q,ms,k,Ys="Note que a coluna audio contém várias features (campos ou características). Aqui está uma descrição delas:",cs,x,Hs="<li><code>path</code>: o caminho para o arquivo de áudio (<code>*.wav</code> neste caso).</li> <li><code>array</code>: Os dados de áudio decodificados, representados como um array unidimensional NumPy.</li> <li><code>sampling_rate</code>: A taxa de amostragem do arquivo de áudio (8.000 Hz neste exemplo).</li>",js,Z,Ns="O <code>intent_class</code> é uma categoria para classificar a gravação de áudio. Para converter este número em algo mais significativo, podemos usar o método <code>int2str()</code>:",ys,B,Us,E,Xs="<strong>Saída:</strong>",Js,_,Ts,Q,Vs="Se você olhar o campo transcription (em inglês), vai ver que o arquivo de áudio de fato gravou uma pessoa fazendo uma pergunta sobre o pagamento de uma conta.",ws,W,Ls="Se você planeja treinar um classificador de áudio com este subconjunto dos dados, você não vai precisar, necessariamente, de todos os campos. Por exemplo, o <code>lang_id</code> vai ter o mesmo valor para todos os exemplos, e não tem utilidade. A coluna <code>english_transcription</code> provavelmente será uma cópia de <code>transcription</code> neste subconjunto, então podemos removê-las tranquilamente.",hs,R,Ds="Você pode facilmente remover campos (features) irrelevantes usando o método <code>remove_columns</code> da 🤗 Datasets:",bs,z,fs,F,Ps="<strong>Saída:</strong>",As,S,Cs,Y,Os="Agora que carregamos e inspecionamos o conteúdo bruto do dataset, vamos ouvir alguns exemplos! Usaremos as propriedades <code>Blocks</code> e <code>Audio</code> do <code>Gradio</code> para decodificar algumas amostras aleatórias:",Is,H,gs,N,Ks="Se você quiser, também pode visualizar alguns dos exemplos. Vamos plotar a forma de onda para o primeiro exemplo.",vs,X,$s,U,sl='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Plot da forma de onda"/>',Gs,V,ll='Sua vez de tentar! Baixe outro dialeto ou idioma do dataset MINDS-14, ouça e visualize alguns exemplos para ter uma noção da variedade do dataset inteiro. Você pode encontrar a lista completa de idiomas disponíveis <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">aqui</a>.',qs,L,ks,P,xs;return J=new ul({props:{title:"Carregue e explore um dataset de áudio",local:"carregue-e-explore-um-dataset-de-áudio",headingTag:"h1"}}),h=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]",wrap:!1}}),C=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`,wrap:!1}}),g=new j({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),$=new j({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`,wrap:!1}}),q=new j({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`,wrap:!1}}),B=new j({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`,wrap:!1}}),_=new j({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>',wrap:!1}}),z=new j({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`,wrap:!1}}),S=new j({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>',wrap:!1}}),H=new j({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),X=new j({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`,wrap:!1}}),L=new rl({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/pt-BR/chapter1/load_and_explore.mdx"}}),{c(){y=M("meta"),O=t(),D=M("p"),K=t(),p(J.$$.fragment),ss=t(),T=M("p"),T.textContent=Es,ls=t(),w=M("p"),w.textContent=_s,as=t(),p(h.$$.fragment),es=t(),b=M("p"),b.innerHTML=Qs,ts=t(),f=M("p"),f.innerHTML=Ws,ns=t(),A=M("p"),A.innerHTML=Rs,Ms=t(),p(C.$$.fragment),os=t(),I=M("p"),I.innerHTML=zs,is=t(),p(g.$$.fragment),ps=t(),v=M("p"),v.textContent=Fs,us=t(),p($.$$.fragment),rs=t(),G=M("p"),G.innerHTML=Ss,ds=t(),p(q.$$.fragment),ms=t(),k=M("p"),k.textContent=Ys,cs=t(),x=M("ul"),x.innerHTML=Hs,js=t(),Z=M("p"),Z.innerHTML=Ns,ys=t(),p(B.$$.fragment),Us=t(),E=M("p"),E.innerHTML=Xs,Js=t(),p(_.$$.fragment),Ts=t(),Q=M("p"),Q.textContent=Vs,ws=t(),W=M("p"),W.innerHTML=Ls,hs=t(),R=M("p"),R.innerHTML=Ds,bs=t(),p(z.$$.fragment),fs=t(),F=M("p"),F.innerHTML=Ps,As=t(),p(S.$$.fragment),Cs=t(),Y=M("p"),Y.innerHTML=Os,Is=t(),p(H.$$.fragment),gs=t(),N=M("p"),N.textContent=Ks,vs=t(),p(X.$$.fragment),$s=t(),U=M("div"),U.innerHTML=sl,Gs=t(),V=M("p"),V.innerHTML=ll,qs=t(),p(L.$$.fragment),ks=t(),P=M("p"),this.h()},l(s){const l=il("svelte-u9bgzb",document.head);y=o(l,"META",{name:!0,content:!0}),l.forEach(a),O=n(s),D=o(s,"P",{}),al(D).forEach(a),K=n(s),u(J.$$.fragment,s),ss=n(s),T=o(s,"P",{"data-svelte-h":!0}),i(T)!=="svelte-1ky7sxl"&&(T.textContent=Es),ls=n(s),w=o(s,"P",{"data-svelte-h":!0}),i(w)!=="svelte-m9beht"&&(w.textContent=_s),as=n(s),u(h.$$.fragment,s),es=n(s),b=o(s,"P",{"data-svelte-h":!0}),i(b)!=="svelte-o4pqli"&&(b.innerHTML=Qs),ts=n(s),f=o(s,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1le1gjj"&&(f.innerHTML=Ws),ns=n(s),A=o(s,"P",{"data-svelte-h":!0}),i(A)!=="svelte-psvjfq"&&(A.innerHTML=Rs),Ms=n(s),u(C.$$.fragment,s),os=n(s),I=o(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1usoza3"&&(I.innerHTML=zs),is=n(s),u(g.$$.fragment,s),ps=n(s),v=o(s,"P",{"data-svelte-h":!0}),i(v)!=="svelte-iazcgz"&&(v.textContent=Fs),us=n(s),u($.$$.fragment,s),rs=n(s),G=o(s,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1usoza3"&&(G.innerHTML=Ss),ds=n(s),u(q.$$.fragment,s),ms=n(s),k=o(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1nrwzy4"&&(k.textContent=Ys),cs=n(s),x=o(s,"UL",{"data-svelte-h":!0}),i(x)!=="svelte-6fp0e4"&&(x.innerHTML=Hs),js=n(s),Z=o(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-qembgb"&&(Z.innerHTML=Ns),ys=n(s),u(B.$$.fragment,s),Us=n(s),E=o(s,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1usoza3"&&(E.innerHTML=Xs),Js=n(s),u(_.$$.fragment,s),Ts=n(s),Q=o(s,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1vdn62s"&&(Q.textContent=Vs),ws=n(s),W=o(s,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1l3vz3m"&&(W.innerHTML=Ls),hs=n(s),R=o(s,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1rehfyu"&&(R.innerHTML=Ds),bs=n(s),u(z.$$.fragment,s),fs=n(s),F=o(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1usoza3"&&(F.innerHTML=Ps),As=n(s),u(S.$$.fragment,s),Cs=n(s),Y=o(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1adojnt"&&(Y.innerHTML=Os),Is=n(s),u(H.$$.fragment,s),gs=n(s),N=o(s,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1c6fg8j"&&(N.textContent=Ks),vs=n(s),u(X.$$.fragment,s),$s=n(s),U=o(s,"DIV",{class:!0,"data-svelte-h":!0}),i(U)!=="svelte-1i56ixc"&&(U.innerHTML=sl),Gs=n(s),V=o(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-lejzh7"&&(V.innerHTML=ll),qs=n(s),u(L.$$.fragment,s),ks=n(s),P=o(s,"P",{}),al(P).forEach(a),this.h()},h(){Zs(y,"name","hf:doc:metadata"),Zs(y,"content",ml),Zs(U,"class","flex justify-center")},m(s,l){pl(document.head,y),e(s,O,l),e(s,D,l),e(s,K,l),r(J,s,l),e(s,ss,l),e(s,T,l),e(s,ls,l),e(s,w,l),e(s,as,l),r(h,s,l),e(s,es,l),e(s,b,l),e(s,ts,l),e(s,f,l),e(s,ns,l),e(s,A,l),e(s,Ms,l),r(C,s,l),e(s,os,l),e(s,I,l),e(s,is,l),r(g,s,l),e(s,ps,l),e(s,v,l),e(s,us,l),r($,s,l),e(s,rs,l),e(s,G,l),e(s,ds,l),r(q,s,l),e(s,ms,l),e(s,k,l),e(s,cs,l),e(s,x,l),e(s,js,l),e(s,Z,l),e(s,ys,l),r(B,s,l),e(s,Us,l),e(s,E,l),e(s,Js,l),r(_,s,l),e(s,Ts,l),e(s,Q,l),e(s,ws,l),e(s,W,l),e(s,hs,l),e(s,R,l),e(s,bs,l),r(z,s,l),e(s,fs,l),e(s,F,l),e(s,As,l),r(S,s,l),e(s,Cs,l),e(s,Y,l),e(s,Is,l),r(H,s,l),e(s,gs,l),e(s,N,l),e(s,vs,l),r(X,s,l),e(s,$s,l),e(s,U,l),e(s,Gs,l),e(s,V,l),e(s,qs,l),r(L,s,l),e(s,ks,l),e(s,P,l),xs=!0},p:tl,i(s){xs||(d(J.$$.fragment,s),d(h.$$.fragment,s),d(C.$$.fragment,s),d(g.$$.fragment,s),d($.$$.fragment,s),d(q.$$.fragment,s),d(B.$$.fragment,s),d(_.$$.fragment,s),d(z.$$.fragment,s),d(S.$$.fragment,s),d(H.$$.fragment,s),d(X.$$.fragment,s),d(L.$$.fragment,s),xs=!0)},o(s){m(J.$$.fragment,s),m(h.$$.fragment,s),m(C.$$.fragment,s),m(g.$$.fragment,s),m($.$$.fragment,s),m(q.$$.fragment,s),m(B.$$.fragment,s),m(_.$$.fragment,s),m(z.$$.fragment,s),m(S.$$.fragment,s),m(H.$$.fragment,s),m(X.$$.fragment,s),m(L.$$.fragment,s),xs=!1},d(s){s&&(a(O),a(D),a(K),a(ss),a(T),a(ls),a(w),a(as),a(es),a(b),a(ts),a(f),a(ns),a(A),a(Ms),a(os),a(I),a(is),a(ps),a(v),a(us),a(rs),a(G),a(ds),a(ms),a(k),a(cs),a(x),a(js),a(Z),a(ys),a(Us),a(E),a(Js),a(Ts),a(Q),a(ws),a(W),a(hs),a(R),a(bs),a(fs),a(F),a(As),a(Cs),a(Y),a(Is),a(gs),a(N),a(vs),a($s),a(U),a(Gs),a(V),a(qs),a(ks),a(P)),a(y),c(J,s),c(h,s),c(C,s),c(g,s),c($,s),c(q,s),c(B,s),c(_,s),c(z,s),c(S,s),c(H,s),c(X,s),c(L,s)}}}const ml='{"title":"Carregue e explore um dataset de áudio","local":"carregue-e-explore-um-dataset-de-áudio","sections":[],"depth":1}';function cl(Bs){return nl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tl extends Ml{constructor(y){super(),ol(this,y,cl,dl,el,{})}}export{Tl as component};
