import{s as Na,o as Qa,n as x}from"../chunks/scheduler.8c3d61f6.js";import{S as Aa,i as Ea,g as r,s as n,r as y,A as za,h as o,f as l,c as i,j as Ha,u as h,x as d,k as V,y as Sa,a,v as f,d as g,t as J,w as Z}from"../chunks/index.da70eac4.js";import{T as dt}from"../chunks/Tip.1d9b8c37.js";import{C as v}from"../chunks/CodeBlock.00a903b3.js";import{H as C,E as qa}from"../chunks/EditOnGithub.1e64e623.js";import{H as La,a as Nl}from"../chunks/HfOption.c1483eb1.js";function Pa(R){let p,w='Learn how to load an IP-Adapter in the <a href="../using-diffusers/loading_adapters#ip-adapter">Load adapters</a> guide, and make sure you check out the <a href="../using-diffusers/loading_adapters#ip-adapter-plus">IP-Adapter Plus</a> section which requires manually loading the image encoder.';return{c(){p=r("p"),p.innerHTML=w},l(m){p=o(m,"P",{"data-svelte-h":!0}),d(p)!=="svelte-1lc7m22"&&(p.innerHTML=w)},m(m,M){a(m,p,M)},p:x,d(m){m&&l(p)}}}function Da(R){let p,w='In the examples below, try adding <code>low_cpu_mem_usage=True</code> to the <a href="/docs/diffusers/pr_10119/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method to speed up the loading time.';return{c(){p=r("p"),p.innerHTML=w},l(m){p=o(m,"P",{"data-svelte-h":!0}),d(p)!=="svelte-16jkx40"&&(p.innerHTML=w)},m(m,M){a(m,p,M)},p:x,d(m){m&&l(p)}}}function Ka(R){let p,w="Crafting the precise text prompt to generate the image you want can be difficult because it may not always capture what you’d like to express. Adding an image alongside the text prompt helps the model better understand what it should generate and can lead to more accurate results.",m,M,G='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/pr_10119/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',_,b,I,c,T="Create a text prompt and load an image prompt before passing them to the pipeline to generate an image.",X,j,k,W,B='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner_2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',u;return b=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyaXAtYWRhcHRlcl9zZHhsLmJpbiUyMiklMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),j=new v({props:{code:"aW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfZGluZXIucG5nJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYSUyMHBvbGFyJTIwYmVhciUyMHNpdHRpbmclMjBpbiUyMGElMjBjaGFpciUyMGRyaW5raW5nJTIwYSUyMG1pbGtzaGFrZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmRlZm9ybWVkJTJDJTIwdWdseSUyQyUyMHdyb25nJTIwcHJvcG9ydGlvbiUyQyUyMGxvdyUyMHJlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){p=r("p"),p.textContent=w,m=n(),M=r("p"),M.innerHTML=G,_=n(),y(b.$$.fragment),I=n(),c=r("p"),c.textContent=T,X=n(),y(j.$$.fragment),k=n(),W=r("div"),W.innerHTML=B,this.h()},l(s){p=o(s,"P",{"data-svelte-h":!0}),d(p)!=="svelte-1kuilfu"&&(p.textContent=w),m=i(s),M=o(s,"P",{"data-svelte-h":!0}),d(M)!=="svelte-1ybiiss"&&(M.innerHTML=G),_=i(s),h(b.$$.fragment,s),I=i(s),c=o(s,"P",{"data-svelte-h":!0}),d(c)!=="svelte-yvbljp"&&(c.textContent=T),X=i(s),h(j.$$.fragment,s),k=i(s),W=o(s,"DIV",{class:!0,"data-svelte-h":!0}),d(W)!=="svelte-4jgjc0"&&(W.innerHTML=B),this.h()},h(){V(W,"class","flex flex-row gap-4")},m(s,U){a(s,p,U),a(s,m,U),a(s,M,U),a(s,_,U),f(b,s,U),a(s,I,U),a(s,c,U),a(s,X,U),f(j,s,U),a(s,k,U),a(s,W,U),u=!0},p:x,i(s){u||(g(b.$$.fragment,s),g(j.$$.fragment,s),u=!0)},o(s){J(b.$$.fragment,s),J(j.$$.fragment,s),u=!1},d(s){s&&(l(p),l(m),l(M),l(_),l(I),l(c),l(X),l(k),l(W)),Z(b,s),Z(j,s)}}}function Oa(R){let p,w="IP-Adapter can also help with image-to-image by guiding the model to generate an image that resembles the original image and the image prompt.",m,M,G='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/pr_10119/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',_,b,I,c,T="Pass the original image and the IP-Adapter image prompt to the pipeline to generate an image. Providing a text prompt to the pipeline is optional, but in this example, a text prompt is used to increase image quality.",X,j,k,W,B='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_3.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',u;return b=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),j=new v({props:{code:"aW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfYmVhcl8xLnBuZyUyMiklMEFpcF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9iZWFyXzIucG5nJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDQpJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaXBfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBzdHJlbmd0aCUzRDAuNiUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png&quot;</span>)
ip_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_2.png&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">4</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;best quality, high quality&quot;</span>,
    image=image,
    ip_adapter_image=ip_image,
    generator=generator,
    strength=<span class="hljs-number">0.6</span>,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){p=r("p"),p.textContent=w,m=n(),M=r("p"),M.innerHTML=G,_=n(),y(b.$$.fragment),I=n(),c=r("p"),c.textContent=T,X=n(),y(j.$$.fragment),k=n(),W=r("div"),W.innerHTML=B,this.h()},l(s){p=o(s,"P",{"data-svelte-h":!0}),d(p)!=="svelte-avn1rr"&&(p.textContent=w),m=i(s),M=o(s,"P",{"data-svelte-h":!0}),d(M)!=="svelte-1ybiiss"&&(M.innerHTML=G),_=i(s),h(b.$$.fragment,s),I=i(s),c=o(s,"P",{"data-svelte-h":!0}),d(c)!=="svelte-10sbd9g"&&(c.textContent=T),X=i(s),h(j.$$.fragment,s),k=i(s),W=o(s,"DIV",{class:!0,"data-svelte-h":!0}),d(W)!=="svelte-8bse9r"&&(W.innerHTML=B),this.h()},h(){V(W,"class","flex gap-4")},m(s,U){a(s,p,U),a(s,m,U),a(s,M,U),a(s,_,U),f(b,s,U),a(s,I,U),a(s,c,U),a(s,X,U),f(j,s,U),a(s,k,U),a(s,W,U),u=!0},p:x,i(s){u||(g(b.$$.fragment,s),g(j.$$.fragment,s),u=!0)},o(s){J(b.$$.fragment,s),J(j.$$.fragment,s),u=!1},d(s){s&&(l(p),l(m),l(M),l(_),l(I),l(c),l(X),l(k),l(W)),Z(b,s),Z(j,s)}}}function es(R){let p,w="IP-Adapter is also useful for inpainting because the image prompt allows you to be much more specific about what you’d like to generate.",m,M,G='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/pr_10119/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',_,b,I,c,T="Pass a prompt, the original image, mask image, and the IP-Adapter image prompt to the pipeline to generate an image.",X,j,k,W,B='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',u;return b=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMjJkaWZmdXNlcnMlMkZzdGFibGUtZGlmZnVzaW9uLXhsLTEuMC1pbnBhaW50aW5nLTAuMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForInpainting.from_pretrained(<span class="hljs-string">&quot;diffusers/stable-diffusion-xl-1.0-inpainting-0.1&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),j=new v({props:{code:"bWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9tYXNrLnBuZyUyMiklMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9iZWFyXzEucG5nJTIyKSUwQWlwX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9hZGFwdGVyX2d1bW15LnBuZyUyMiklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCg0KSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBjdXRlJTIwZ3VtbXklMjBiZWFyJTIwd2F2aW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_mask.png&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png&quot;</span>)
ip_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">4</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a cute gummy bear waving&quot;</span>,
    image=image,
    mask_image=mask_image,
    ip_adapter_image=ip_image,
    generator=generator,
    num_inference_steps=<span class="hljs-number">100</span>,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){p=r("p"),p.textContent=w,m=n(),M=r("p"),M.innerHTML=G,_=n(),y(b.$$.fragment),I=n(),c=r("p"),c.textContent=T,X=n(),y(j.$$.fragment),k=n(),W=r("div"),W.innerHTML=B,this.h()},l(s){p=o(s,"P",{"data-svelte-h":!0}),d(p)!=="svelte-11wjoqr"&&(p.textContent=w),m=i(s),M=o(s,"P",{"data-svelte-h":!0}),d(M)!=="svelte-1ybiiss"&&(M.innerHTML=G),_=i(s),h(b.$$.fragment,s),I=i(s),c=o(s,"P",{"data-svelte-h":!0}),d(c)!=="svelte-1wfeic0"&&(c.textContent=T),X=i(s),h(j.$$.fragment,s),k=i(s),W=o(s,"DIV",{class:!0,"data-svelte-h":!0}),d(W)!=="svelte-5iola2"&&(W.innerHTML=B),this.h()},h(){V(W,"class","flex gap-4")},m(s,U){a(s,p,U),a(s,m,U),a(s,M,U),a(s,_,U),f(b,s,U),a(s,I,U),a(s,c,U),a(s,X,U),f(j,s,U),a(s,k,U),a(s,W,U),u=!0},p:x,i(s){u||(g(b.$$.fragment,s),g(j.$$.fragment,s),u=!0)},o(s){J(b.$$.fragment,s),J(j.$$.fragment,s),u=!1},d(s){s&&(l(p),l(m),l(M),l(_),l(I),l(c),l(X),l(k),l(W)),Z(b,s),Z(j,s)}}}function ts(R){let p,w='If you’re planning on offloading the model to the CPU, make sure you run it after you’ve loaded the IP-Adapter. When you call <a href="/docs/diffusers/pr_10119/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> before loading the IP-Adapter, it offloads the image encoder module to the CPU and it’ll return an error when you try to run the pipeline.';return{c(){p=r("p"),p.innerHTML=w},l(m){p=o(m,"P",{"data-svelte-h":!0}),d(p)!=="svelte-clmae3"&&(p.innerHTML=w)},m(m,M){a(m,p,M)},p:x,d(m){m&&l(p)}}}function ls(R){let p,w='IP-Adapter can also help you generate videos that are more aligned with your text prompt. For example, let’s load <a href="../api/pipelines/animatediff">AnimateDiff</a> with its motion adapter and insert an IP-Adapter into the model with the <a href="/docs/diffusers/pr_10119/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method.',m,M,G,_,b,I,c="Pass a prompt and an image prompt to the pipeline to generate a short video.",T,X,j,k,W='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gummy_bear.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated video</figcaption></div>',B;return M=new dt({props:{warning:!0,$$slots:{default:[ts]},$$scope:{ctx:R}}}),_=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQW5pbWF0ZURpZmZQaXBlbGluZSUyQyUyMERESU1TY2hlZHVsZXIlMkMlMjBNb3Rpb25BZGFwdGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tYWRhcHRlci12MS01LTIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZWxpbmUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlciUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFzY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfc2FtcGxlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjB0aW1lc3RlcF9zcGFjaW5nJTNEJTIybGluc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBiZXRhX3NjaGVkdWxlJTNEJTIybGluZWFyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3RlcHNfb2Zmc2V0JTNEMSUyQyUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBzY2hlZHVsZXIlMEFwaXBlbGluZS5lbmFibGVfdmFlX3NsaWNpbmcoKSUwQSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
pipeline = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>, motion_adapter=adapter, torch_dtype=torch.float16)
scheduler = DDIMScheduler.from_pretrained(
    <span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipeline.scheduler = scheduler
pipeline.enable_vae_slicing()

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),X=new v({props:{code:"aXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9pbnBhaW50LnBuZyUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJBJTIwY3V0ZSUyMGd1bW15JTIwYmVhciUyMHdhdmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmJhZCUyMHF1YWxpdHklMkMlMjB3b3JzZSUyMHF1YWxpdHklMkMlMjBsb3clMjByZXNvbHV0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2FkYXB0ZXJfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuNSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTJDJTBBKSUwQWZyYW1lcyUyMCUzRCUyMG91dHB1dC5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX2dpZihmcmFtZXMlMkMlMjAlMjJndW1teV9iZWFyLmdpZiUyMik=",highlighted:`ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png&quot;</span>)

output = pipeline(
    prompt=<span class="hljs-string">&quot;A cute gummy bear waving&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality, low resolution&quot;</span>,
    ip_adapter_image=ip_adapter_image,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;gummy_bear.gif&quot;</span>)`,wrap:!1}}),{c(){p=r("p"),p.innerHTML=w,m=n(),y(M.$$.fragment),G=n(),y(_.$$.fragment),b=n(),I=r("p"),I.textContent=c,T=n(),y(X.$$.fragment),j=n(),k=r("div"),k.innerHTML=W,this.h()},l(u){p=o(u,"P",{"data-svelte-h":!0}),d(p)!=="svelte-g728o8"&&(p.innerHTML=w),m=i(u),h(M.$$.fragment,u),G=i(u),h(_.$$.fragment,u),b=i(u),I=o(u,"P",{"data-svelte-h":!0}),d(I)!=="svelte-a6opnh"&&(I.textContent=c),T=i(u),h(X.$$.fragment,u),j=i(u),k=o(u,"DIV",{class:!0,"data-svelte-h":!0}),d(k)!=="svelte-ihoum9"&&(k.innerHTML=W),this.h()},h(){V(k,"class","flex flex-row gap-4")},m(u,s){a(u,p,s),a(u,m,s),f(M,u,s),a(u,G,s),f(_,u,s),a(u,b,s),a(u,I,s),a(u,T,s),f(X,u,s),a(u,j,s),a(u,k,s),B=!0},p(u,s){const U={};s&2&&(U.$$scope={dirty:s,ctx:u}),M.$set(U)},i(u){B||(g(M.$$.fragment,u),g(_.$$.fragment,u),g(X.$$.fragment,u),B=!0)},o(u){J(M.$$.fragment,u),J(_.$$.fragment,u),J(X.$$.fragment,u),B=!1},d(u){u&&(l(p),l(m),l(G),l(b),l(I),l(T),l(j),l(k)),Z(M,u),Z(_,u),Z(X,u)}}}function as(R){let p,w,m,M,G,_,b,I;return p=new Nl({props:{id:"tasks",option:"Text-to-image",$$slots:{default:[Ka]},$$scope:{ctx:R}}}),m=new Nl({props:{id:"tasks",option:"Image-to-image",$$slots:{default:[Oa]},$$scope:{ctx:R}}}),G=new Nl({props:{id:"tasks",option:"Inpainting",$$slots:{default:[es]},$$scope:{ctx:R}}}),b=new Nl({props:{id:"tasks",option:"Video",$$slots:{default:[ls]},$$scope:{ctx:R}}}),{c(){y(p.$$.fragment),w=n(),y(m.$$.fragment),M=n(),y(G.$$.fragment),_=n(),y(b.$$.fragment)},l(c){h(p.$$.fragment,c),w=i(c),h(m.$$.fragment,c),M=i(c),h(G.$$.fragment,c),_=i(c),h(b.$$.fragment,c)},m(c,T){f(p,c,T),a(c,w,T),f(m,c,T),a(c,M,T),f(G,c,T),a(c,_,T),f(b,c,T),I=!0},p(c,T){const X={};T&2&&(X.$$scope={dirty:T,ctx:c}),p.$set(X);const j={};T&2&&(j.$$scope={dirty:T,ctx:c}),m.$set(j);const k={};T&2&&(k.$$scope={dirty:T,ctx:c}),G.$set(k);const W={};T&2&&(W.$$scope={dirty:T,ctx:c}),b.$set(W)},i(c){I||(g(p.$$.fragment,c),g(m.$$.fragment,c),g(G.$$.fragment,c),g(b.$$.fragment,c),I=!0)},o(c){J(p.$$.fragment,c),J(m.$$.fragment,c),J(G.$$.fragment,c),J(b.$$.fragment,c),I=!1},d(c){c&&(l(w),l(M),l(_)),Z(p,c),Z(m,c),Z(G,c),Z(b,c)}}}function ss(R){let p,w="This parameter also gives you the flexibility to load embeddings from other sources. For example, ComfyUI image embeddings for IP-Adapters are compatible with Diffusers and should work ouf-of-the-box!";return{c(){p=r("p"),p.textContent=w},l(m){p=o(m,"P",{"data-svelte-h":!0}),d(p)!=="svelte-1rk1t7q"&&(p.textContent=w)},m(m,M){a(m,p,M)},p:x,d(m){m&&l(p)}}}function ns(R){let p,w="If you’re using IP-Adapter with <code>ip_adapter_image_embedding</code> instead of <code>ip_adapter_image</code>’, you can set <code>load_ip_adapter(image_encoder_folder=None,...)</code> because you don’t need to load an encoder to generate the image embeddings.";return{c(){p=r("p"),p.innerHTML=w},l(m){p=o(m,"P",{"data-svelte-h":!0}),d(p)!=="svelte-h0lw9v"&&(p.innerHTML=w)},m(m,M){a(m,p,M)},p:x,d(m){m&&l(p)}}}function is(R){let p,w='Read the <a href="../using-diffusers/loading_adapters#ip-adapter-plus">IP-Adapter Plus</a> section to learn why you need to manually load the image encoder.';return{c(){p=r("p"),p.innerHTML=w},l(m){p=o(m,"P",{"data-svelte-h":!0}),d(p)!=="svelte-apa7ha"&&(p.innerHTML=w)},m(m,M){a(m,p,M)},p:x,d(m){m&&l(p)}}}function ps(R){let p,w,m,M,G,_,b,I='<a href="https://hf.co/papers/2308.06721" rel="nofollow">IP-Adapter</a> is an image prompt adapter that can be plugged into diffusion models to enable image prompting without any changes to the underlying model. Furthermore, this adapter can be reused with other models finetuned from the same base model and it can be combined with other adapters like <a href="../using-diffusers/controlnet">ControlNet</a>. The key idea behind IP-Adapter is the <em>decoupled cross-attention</em> mechanism which adds a separate cross-attention layer just for image features instead of using the same cross-attention layer for both text and image features. This allows the model to learn more image-specific features.',c,T,X,j,k="This guide will walk you through using IP-Adapter for various tasks and use cases.",W,B,u,s,U='Let’s take a look at how to use IP-Adapter’s image prompting capabilities with the <a href="/docs/diffusers/pr_10119/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> for tasks like text-to-image, image-to-image, and inpainting. We also encourage you to try out other pipelines such as Stable Diffusion, LCM-LoRA, ControlNet, T2I-Adapter, or AnimateDiff!',ut,ee,Ql='In all the following examples, you’ll see the <a href="/docs/diffusers/pr_10119/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.set_ip_adapter_scale">set_ip_adapter_scale()</a> method. This method controls the amount of text or image conditioning to apply to the model. A value of <code>1.0</code> means the model is only conditioned on the image prompt. Lowering this value encourages the model to produce more diverse images, but they may not be as aligned with the image prompt. Typically, a value of <code>0.5</code> achieves a good balance between the two prompt types and produces good results.',Mt,Y,yt,F,ht,te,ft,le,Al="There are a couple of IP-Adapter parameters that are useful to know about and can help you with your image generation tasks. These parameters can make your workflow more efficient or give you more control over image generation.",gt,ae,Jt,se,El='IP-Adapter enabled pipelines provide the <code>ip_adapter_image_embeds</code> parameter to accept precomputed image embeddings. This is particularly useful in scenarios where you need to run the IP-Adapter pipeline multiple times because you have more than one image. For example, <a href="#multi-ip-adapter">multi IP-Adapter</a> is a specific use case where you provide multiple styling images to generate a specific image in a specific style. Loading and encoding multiple images each time you use the pipeline would be inefficient. Instead, you can precompute and save the image embeddings to disk (which can save a lot of space if you’re using high-quality images) and load them when you need them.',Zt,$,bt,ne,zl="Call the <code>prepare_ip_adapter_image_embeds()</code> method to encode and generate the image embeddings. Then you can save them to disk with <code>torch.save</code>.",Ut,H,wt,ie,Tt,pe,Sl="Now load the image embeddings by passing them to the <code>ip_adapter_image_embeds</code> parameter.",jt,re,Wt,oe,_t,me,ql="Binary masks specify which portion of the output image should be assigned to an IP-Adapter. This is useful for composing more than one IP-Adapter image. For each input IP-Adapter image, you must provide a binary mask.",Gt,de,Ll="To start, preprocess the input IP-Adapter images with the <code>~image_processor.IPAdapterMaskProcessor.preprocess()</code> to generate their masks. For optimal results, provide the output height and width to <code>~image_processor.IPAdapterMaskProcessor.preprocess()</code>. This ensures masks with different aspect ratios are appropriately stretched. If the input masks already match the aspect ratio of the generated image, you don’t have to set the <code>height</code> and <code>width</code>.",It,ce,Xt,N,Pl='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask one</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask two</figcaption></div>',kt,ue,Dl="When there is more than one input IP-Adapter image, load them as a list and provide the IP-Adapter scale list. Each of the input IP-Adapter images here corresponds to one of the masks generated above.",vt,Me,Rt,Q,Kl='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image one</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image two</figcaption></div>',Bt,ye,Ol="Now pass the preprocessed masks to <code>cross_attention_kwargs</code> in the pipeline call.",Vt,he,Ct,A,ea='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_attention_mask_result_seed_0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter masking applied</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_no_attention_mask_result_seed_0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">no IP-Adapter masking applied</figcaption></div>',xt,fe,Yt,ge,ta="IP-Adapter’s image prompting and compatibility with other adapters and models makes it a versatile tool for a variety of use cases. This section covers some of the more popular applications of IP-Adapter, and we can’t wait to see what you come up with!",Ft,Je,$t,Ze,la='Generating accurate faces is challenging because they are complex and nuanced. Diffusers supports two IP-Adapter checkpoints specifically trained to generate faces from the <a href="https://huggingface.co/h94/IP-Adapter" rel="nofollow">h94/IP-Adapter</a> repository:',Ht,be,aa='<li><a href="https://huggingface.co/h94/IP-Adapter/blob/main/models/ip-adapter-full-face_sd15.safetensors" rel="nofollow">ip-adapter-full-face_sd15.safetensors</a> is conditioned with images of cropped faces and removed backgrounds</li> <li><a href="https://huggingface.co/h94/IP-Adapter/blob/main/models/ip-adapter-plus-face_sd15.safetensors" rel="nofollow">ip-adapter-plus-face_sd15.safetensors</a> uses patch embeddings and is conditioned with images of cropped faces</li>',Nt,Ue,sa='Additionally, Diffusers supports all IP-Adapter checkpoints trained with face embeddings extracted by <code>insightface</code> face models. Supported models are from the <a href="https://huggingface.co/h94/IP-Adapter-FaceID" rel="nofollow">h94/IP-Adapter-FaceID</a> repository.',Qt,we,na='For face models, use the <a href="https://huggingface.co/h94/IP-Adapter" rel="nofollow">h94/IP-Adapter</a> checkpoint. It is also recommended to use <a href="/docs/diffusers/pr_10119/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> or <a href="/docs/diffusers/pr_10119/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> for face models.',At,Te,Et,E,ia='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein_base.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',zt,je,pa="To use IP-Adapter FaceID models, first extract face embeddings with <code>insightface</code>. Then pass the list of tensors to the pipeline as <code>ip_adapter_image_embeds</code>.",St,We,qt,_e,ra="Both IP-Adapter FaceID Plus and Plus v2 models require CLIP image embeddings. You can prepare face embeddings as shown previously, then you can extract and pass CLIP embeddings to the hidden image projection layers.",Lt,Ge,Pt,Ie,Dt,Xe,oa="More than one IP-Adapter can be used at the same time to generate specific images in more diverse styles. For example, you can use IP-Adapter-Face to generate consistent faces and characters, and IP-Adapter Plus to generate those faces in a specific style.",Kt,z,Ot,ke,ma='Load the image encoder with <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModelWithProjection" rel="nofollow">CLIPVisionModelWithProjection</a>.',el,ve,tl,Re,da="Next, you’ll load a base model, scheduler, and the IP-Adapters. The IP-Adapters to use are passed as a list to the <code>weight_name</code> parameter:",ll,Be,ca='<li><a href="https://huggingface.co/h94/IP-Adapter#ip-adapter-for-sdxl-10" rel="nofollow">ip-adapter-plus_sdxl_vit-h</a> uses patch embeddings and a ViT-H image encoder</li> <li><a href="https://huggingface.co/h94/IP-Adapter#ip-adapter-for-sdxl-10" rel="nofollow">ip-adapter-plus-face_sdxl_vit-h</a> has the same architecture but it is conditioned with images of cropped faces</li>',al,Ve,sl,Ce,ua="Load an image prompt and a folder containing images of a certain style you want to use.",nl,xe,il,S,Ma='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/women_input.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image of face</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_style_grid.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter style images</figcaption></div>',pl,Ye,ya="Pass the image prompt and style images as a list to the <code>ip_adapter_image</code> parameter, and run the pipeline!",rl,Fe,ol,q,ha='    <img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_multi_out.png"/>',ml,$e,dl,He,fa='<a href="../using-diffusers/inference_with_lcm_lora">Latent Consistency Models (LCM)</a> are diffusion models that can generate images in as little as 4 steps compared to other diffusion models like SDXL that typically require way more steps. This is why image generation with an LCM feels “instantaneous”. IP-Adapters can be plugged into an LCM-LoRA model to instantly generate images with an image prompt.',cl,Ne,ga='The IP-Adapter weights need to be loaded first, then you can use <a href="/docs/diffusers/pr_10119/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> to load the LoRA style and weight you want to apply to your image.',ul,Qe,Ml,Ae,Ja='Try using with a lower IP-Adapter scale to condition image generation more on the <a href="https://huggingface.co/sd-dreambooth-library/herge-style" rel="nofollow">herge_style</a> checkpoint, and remember to use the special token <code>herge_style</code> in your prompt to trigger and apply the style.',yl,Ee,hl,L,Za='    <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_herge.png"/>',fl,ze,gl,Se,ba='To control image generation to an even greater degree, you can combine IP-Adapter with a model like <a href="../using-diffusers/controlnet">ControlNet</a>. A ControlNet is also an adapter that can be inserted into a diffusion model to allow for conditioning on an additional control image. The control image can be depth maps, edge maps, pose estimations, and more.',Jl,qe,Ua='Load a <a href="/docs/diffusers/pr_10119/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> checkpoint conditioned on depth maps, insert it into a diffusion model, and load the IP-Adapter.',Zl,Le,bl,Pe,wa="Now load the IP-Adapter image and depth map.",Ul,De,wl,P,Ta='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/statue.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/depth.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">depth map</figcaption></div>',Tl,Ke,ja="Pass the depth map and IP-Adapter image to the pipeline to generate an image.",jl,Oe,Wl,D,Wa='    <img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ipa-controlnet-out.png"/>',_l,et,Gl,tt,_a='<a href="https://arxiv.org/abs/2404.02733" rel="nofollow">InstantStyle</a> is a plug-and-play method on top of IP-Adapter, which disentangles style and layout from image prompt to control image generation. This way, you can generate images following only the style or layout from image prompt, with significantly improved diversity. This is achieved by only activating IP-Adapters to specific parts of the model.',Il,lt,Ga='By default IP-Adapters are inserted to all layers of the model. Use the <a href="/docs/diffusers/pr_10119/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.set_ip_adapter_scale">set_ip_adapter_scale()</a> method with a dictionary to assign scales to IP-Adapter at different layers.',Xl,at,kl,st,Ia="This will activate IP-Adapter at the second layer in the model’s down-part block 2 and up-part block 0. The former is the layer where IP-Adapter injects layout information and the latter injects style. Inserting IP-Adapter to these two layers you can generate images following both the style and layout from image prompt, but with contents more aligned to text prompt.",vl,nt,Rl,K,Xa='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/0052a70beed5bf71b92610a43a52df6d286cd5f3/diffusers/rabbit.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/cat_style_layout.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Bl,it,ka="In contrast, inserting IP-Adapter to all layers will often generate images that overly focus on image prompt and diminish diversity.",Vl,pt,va="Activate IP-Adapter only in the style layer and then call the pipeline again.",Cl,rt,xl,O,Ra='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/cat_style_only.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter only in style layer</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/cat_ip_adapter.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter in all layers</figcaption></div>',Yl,ot,Ba="Note that you don’t have to specify all layers in the dictionary. Those not included in the dictionary will be set to scale 0 which means disable IP-Adapter by default.",Fl,mt,$l,ct,Hl;return G=new C({props:{title:"IP-Adapter",local:"ip-adapter",headingTag:"h1"}}),T=new dt({props:{warning:!1,$$slots:{default:[Pa]},$$scope:{ctx:R}}}),B=new C({props:{title:"General tasks",local:"general-tasks",headingTag:"h2"}}),Y=new dt({props:{warning:!1,$$slots:{default:[Da]},$$scope:{ctx:R}}}),F=new La({props:{id:"tasks",options:["Text-to-image","Image-to-image","Inpainting","Video"],$$slots:{default:[as]},$$scope:{ctx:R}}}),te=new C({props:{title:"Configure parameters",local:"configure-parameters",headingTag:"h2"}}),ae=new C({props:{title:"Image embeddings",local:"image-embeddings",headingTag:"h3"}}),$=new dt({props:{warning:!1,$$slots:{default:[ss]},$$scope:{ctx:R}}}),H=new dt({props:{warning:!1,$$slots:{default:[ns]},$$scope:{ctx:R}}}),ie=new v({props:{code:"aW1hZ2VfZW1iZWRzJTIwJTNEJTIwcGlwZWxpbmUucHJlcGFyZV9pcF9hZGFwdGVyX2ltYWdlX2VtYmVkcyglMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlX2VtYmVkcyUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2UlM0QlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMSUyQyUwQSUyMCUyMCUyMCUyMGRvX2NsYXNzaWZpZXJfZnJlZV9ndWlkYW5jZSUzRFRydWUlMkMlMEEpJTBBJTBBdG9yY2guc2F2ZShpbWFnZV9lbWJlZHMlMkMlMjAlMjJpbWFnZV9lbWJlZHMuaXBhZHB0JTIyKQ==",highlighted:`image_embeds = pipeline.prepare_ip_adapter_image_embeds(
    ip_adapter_image=image,
    ip_adapter_image_embeds=<span class="hljs-literal">None</span>,
    device=<span class="hljs-string">&quot;cuda&quot;</span>,
    num_images_per_prompt=<span class="hljs-number">1</span>,
    do_classifier_free_guidance=<span class="hljs-literal">True</span>,
)

torch.save(image_embeds, <span class="hljs-string">&quot;image_embeds.ipadpt&quot;</span>)`,wrap:!1}}),re=new v({props:{code:"aW1hZ2VfZW1iZWRzJTIwJTNEJTIwdG9yY2gubG9hZCglMjJpbWFnZV9lbWJlZHMuaXBhZHB0JTIyKSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwb2xhciUyMGJlYXIlMjBzaXR0aW5nJTIwaW4lMjBhJTIwY2hhaXIlMjBkcmlua2luZyUyMGElMjBtaWxrc2hha2UlMjIlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlX2VtYmVkcyUzRGltYWdlX2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmRlZm9ybWVkJTJDJTIwdWdseSUyQyUyMHdyb25nJTIwcHJvcG9ydGlvbiUyQyUyMGxvdyUyMHJlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2Vz",highlighted:`image_embeds = torch.load(<span class="hljs-string">&quot;image_embeds.ipadpt&quot;</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image_embeds=image_embeds,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images`,wrap:!1}}),oe=new C({props:{title:"IP-Adapter masking",local:"ip-adapter-masking",headingTag:"h3"}}),ce=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5pbWFnZV9wcm9jZXNzb3IlMjBpbXBvcnQlMjBJUEFkYXB0ZXJNYXNrUHJvY2Vzc29yJTBBJTBBbWFzazElMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX21hc2tfbWFzazEucG5nJTIyKSUwQW1hc2syJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9tYXNrX21hc2syLnBuZyUyMiklMEElMEFvdXRwdXRfaGVpZ2h0JTIwJTNEJTIwMTAyNCUwQW91dHB1dF93aWR0aCUyMCUzRCUyMDEwMjQlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBJUEFkYXB0ZXJNYXNrUHJvY2Vzc29yKCklMEFtYXNrcyUyMCUzRCUyMHByb2Nlc3Nvci5wcmVwcm9jZXNzKCU1Qm1hc2sxJTJDJTIwbWFzazIlNUQlMkMlMjBoZWlnaHQlM0RvdXRwdXRfaGVpZ2h0JTJDJTIwd2lkdGglM0RvdXRwdXRfd2lkdGgp",highlighted:`<span class="hljs-keyword">from</span> diffusers.image_processor <span class="hljs-keyword">import</span> IPAdapterMaskProcessor

mask1 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_mask1.png&quot;</span>)
mask2 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_mask2.png&quot;</span>)

output_height = <span class="hljs-number">1024</span>
output_width = <span class="hljs-number">1024</span>

processor = IPAdapterMaskProcessor()
masks = processor.preprocess([mask1, mask2], height=output_height, width=output_width)`,wrap:!1}}),Me=new v({props:{code:"cGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTVCJTIyaXAtYWRhcHRlci1wbHVzLWZhY2Vfc2R4bF92aXQtaC5zYWZldGVuc29ycyUyMiU1RCklMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZSglNUIlNUIwLjclMkMlMjAwLjclNUQlNUQpJTIwJTIwJTIzJTIwb25lJTIwc2NhbGUlMjBmb3IlMjBlYWNoJTIwaW1hZ2UtbWFzayUyMHBhaXIlMEElMEFmYWNlX2ltYWdlMSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfbWFza19naXJsMS5wbmclMjIpJTBBZmFjZV9pbWFnZTIlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX21hc2tfZ2lybDIucG5nJTIyKSUwQSUwQWlwX2ltYWdlcyUyMCUzRCUyMCU1QiU1QmZhY2VfaW1hZ2UxJTJDJTIwZmFjZV9pbWFnZTIlNUQlNUQlMEElMEFtYXNrcyUyMCUzRCUyMCU1Qm1hc2tzLnJlc2hhcGUoMSUyQyUyMG1hc2tzLnNoYXBlJTVCMCU1RCUyQyUyMG1hc2tzLnNoYXBlJTVCMiU1RCUyQyUyMG1hc2tzLnNoYXBlJTVCMyU1RCklNUQ=",highlighted:`pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=[<span class="hljs-string">&quot;ip-adapter-plus-face_sdxl_vit-h.safetensors&quot;</span>])
pipeline.set_ip_adapter_scale([[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.7</span>]])  <span class="hljs-comment"># one scale for each image-mask pair</span>

face_image1 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_girl1.png&quot;</span>)
face_image2 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_girl2.png&quot;</span>)

ip_images = [[face_image1, face_image2]]

masks = [masks.reshape(<span class="hljs-number">1</span>, masks.shape[<span class="hljs-number">0</span>], masks.shape[<span class="hljs-number">2</span>], masks.shape[<span class="hljs-number">3</span>])]`,wrap:!1}}),he=new v({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEFudW1faW1hZ2VzJTIwJTNEJTIwMSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyMiUyMGdpcmxzJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2ltYWdlcyUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMm1vbm9jaHJvbWUlMkMlMjBsb3dyZXMlMkMlMjBiYWQlMjBhbmF0b215JTJDJTIwd29yc3QlMjBxdWFsaXR5JTJDJTIwbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRG51bV9pbWFnZXMlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBjcm9zc19hdHRlbnRpb25fa3dhcmdzJTNEJTdCJTIyaXBfYWRhcHRlcl9tYXNrcyUyMiUzQSUyMG1hc2tzJTdEJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
num_images = <span class="hljs-number">1</span>

image = pipeline(
    prompt=<span class="hljs-string">&quot;2 girls&quot;</span>,
    ip_adapter_image=ip_images,
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">20</span>,
    num_images_per_prompt=num_images,
    generator=generator,
    cross_attention_kwargs={<span class="hljs-string">&quot;ip_adapter_masks&quot;</span>: masks}
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),fe=new C({props:{title:"Specific use cases",local:"specific-use-cases",headingTag:"h2"}}),Je=new C({props:{title:"Face model",local:"face-model",headingTag:"h3"}}),Te=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyLWZ1bGwtZmFjZV9zZDE1LmJpbiUyMiklMEElMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjUpJTBBJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfZWluc3RlaW5fYmFzZS5wbmclMjIpJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMjYpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJBJTIwcGhvdG8lMjBvZiUyMEVpbnN0ZWluJTIwYXMlMjBhJTIwY2hlZiUyQyUyMHdlYXJpbmclMjBhbiUyMGFwcm9uJTJDJTIwY29va2luZyUyMGluJTIwYSUyMEZyZW5jaCUyMHJlc3RhdXJhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJsb3dyZXMlMkMlMjBiYWQlMjBhbmF0b215JTJDJTIwd29yc3QlMjBxdWFsaXR5JTJDJTIwbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxMDAlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter-full-face_sd15.bin&quot;</span>)

pipeline.set_ip_adapter_scale(<span class="hljs-number">0.5</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein_base.png&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">26</span>)

image = pipeline(
    prompt=<span class="hljs-string">&quot;A photo of Einstein as a chef, wearing an apron, cooking in a French restaurant&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),We=new v({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> insightface.app <span class="hljs-keyword">import</span> FaceAnalysis

pipeline = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter-FaceID&quot;</span>, subfolder=<span class="hljs-literal">None</span>, weight_name=<span class="hljs-string">&quot;ip-adapter-faceid_sd15.bin&quot;</span>, image_encoder_folder=<span class="hljs-literal">None</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_girl1.png&quot;</span>)

ref_images_embeds = []
app = FaceAnalysis(name=<span class="hljs-string">&quot;buffalo_l&quot;</span>, providers=[<span class="hljs-string">&#x27;CUDAExecutionProvider&#x27;</span>, <span class="hljs-string">&#x27;CPUExecutionProvider&#x27;</span>])
app.prepare(ctx_id=<span class="hljs-number">0</span>, det_size=(<span class="hljs-number">640</span>, <span class="hljs-number">640</span>))
image = cv2.cvtColor(np.asarray(image), cv2.COLOR_BGR2RGB)
faces = app.get(image)
image = torch.from_numpy(faces[<span class="hljs-number">0</span>].normed_embedding)
ref_images_embeds.append(image.unsqueeze(<span class="hljs-number">0</span>))
ref_images_embeds = torch.stack(ref_images_embeds, dim=<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)
neg_ref_images_embeds = torch.zeros_like(ref_images_embeds)
id_embeds = torch.cat([neg_ref_images_embeds, ref_images_embeds]).to(dtype=torch.float16, device=<span class="hljs-string">&quot;cuda&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>)

images = pipeline(
    prompt=<span class="hljs-string">&quot;A photo of a girl&quot;</span>,
    ip_adapter_image_embeds=[id_embeds],
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">20</span>, num_images_per_prompt=<span class="hljs-number">1</span>,
    generator=generator
).images`,wrap:!1}}),Ge=new v({props:{code:"ZnJvbSUyMGluc2lnaHRmYWNlLnV0aWxzJTIwaW1wb3J0JTIwZmFjZV9hbGlnbiUwQSUwQXJlZl9pbWFnZXNfZW1iZWRzJTIwJTNEJTIwJTVCJTVEJTBBaXBfYWRhcHRlcl9pbWFnZXMlMjAlM0QlMjAlNUIlNUQlMEFhcHAlMjAlM0QlMjBGYWNlQW5hbHlzaXMobmFtZSUzRCUyMmJ1ZmZhbG9fbCUyMiUyQyUyMHByb3ZpZGVycyUzRCU1QidDVURBRXhlY3V0aW9uUHJvdmlkZXInJTJDJTIwJ0NQVUV4ZWN1dGlvblByb3ZpZGVyJyU1RCklMEFhcHAucHJlcGFyZShjdHhfaWQlM0QwJTJDJTIwZGV0X3NpemUlM0QoNjQwJTJDJTIwNjQwKSklMEFpbWFnZSUyMCUzRCUyMGN2Mi5jdnRDb2xvcihucC5hc2FycmF5KGltYWdlKSUyQyUyMGN2Mi5DT0xPUl9CR1IyUkdCKSUwQWZhY2VzJTIwJTNEJTIwYXBwLmdldChpbWFnZSklMEFpcF9hZGFwdGVyX2ltYWdlcy5hcHBlbmQoZmFjZV9hbGlnbi5ub3JtX2Nyb3AoaW1hZ2UlMkMlMjBsYW5kbWFyayUzRGZhY2VzJTVCMCU1RC5rcHMlMkMlMjBpbWFnZV9zaXplJTNEMjI0KSklMEFpbWFnZSUyMCUzRCUyMHRvcmNoLmZyb21fbnVtcHkoZmFjZXMlNUIwJTVELm5vcm1lZF9lbWJlZGRpbmcpJTBBcmVmX2ltYWdlc19lbWJlZHMuYXBwZW5kKGltYWdlLnVuc3F1ZWV6ZSgwKSklMEFyZWZfaW1hZ2VzX2VtYmVkcyUyMCUzRCUyMHRvcmNoLnN0YWNrKHJlZl9pbWFnZXNfZW1iZWRzJTJDJTIwZGltJTNEMCkudW5zcXVlZXplKDApJTBBbmVnX3JlZl9pbWFnZXNfZW1iZWRzJTIwJTNEJTIwdG9yY2guemVyb3NfbGlrZShyZWZfaW1hZ2VzX2VtYmVkcyklMEFpZF9lbWJlZHMlMjAlM0QlMjB0b3JjaC5jYXQoJTVCbmVnX3JlZl9pbWFnZXNfZW1iZWRzJTJDJTIwcmVmX2ltYWdlc19lbWJlZHMlNUQpLnRvKGR0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIpJTBBJTBBY2xpcF9lbWJlZHMlMjAlM0QlMjBwaXBlbGluZS5wcmVwYXJlX2lwX2FkYXB0ZXJfaW1hZ2VfZW1iZWRzKCUwQSUyMCUyMCU1QmlwX2FkYXB0ZXJfaW1hZ2VzJTVEJTJDJTIwTm9uZSUyQyUyMHRvcmNoLmRldmljZSglMjJjdWRhJTIyKSUyQyUyMG51bV9pbWFnZXMlMkMlMjBUcnVlKSU1QjAlNUQlMEElMEFwaXBlbGluZS51bmV0LmVuY29kZXJfaGlkX3Byb2ouaW1hZ2VfcHJvamVjdGlvbl9sYXllcnMlNUIwJTVELmNsaXBfZW1iZWRzJTIwJTNEJTIwY2xpcF9lbWJlZHMudG8oZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lLnVuZXQuZW5jb2Rlcl9oaWRfcHJvai5pbWFnZV9wcm9qZWN0aW9uX2xheWVycyU1QjAlNUQuc2hvcnRjdXQlMjAlM0QlMjBGYWxzZSUyMCUyMyUyMFRydWUlMjBpZiUyMFBsdXMlMjB2Mg==",highlighted:`<span class="hljs-keyword">from</span> insightface.utils <span class="hljs-keyword">import</span> face_align

ref_images_embeds = []
ip_adapter_images = []
app = FaceAnalysis(name=<span class="hljs-string">&quot;buffalo_l&quot;</span>, providers=[<span class="hljs-string">&#x27;CUDAExecutionProvider&#x27;</span>, <span class="hljs-string">&#x27;CPUExecutionProvider&#x27;</span>])
app.prepare(ctx_id=<span class="hljs-number">0</span>, det_size=(<span class="hljs-number">640</span>, <span class="hljs-number">640</span>))
image = cv2.cvtColor(np.asarray(image), cv2.COLOR_BGR2RGB)
faces = app.get(image)
ip_adapter_images.append(face_align.norm_crop(image, landmark=faces[<span class="hljs-number">0</span>].kps, image_size=<span class="hljs-number">224</span>))
image = torch.from_numpy(faces[<span class="hljs-number">0</span>].normed_embedding)
ref_images_embeds.append(image.unsqueeze(<span class="hljs-number">0</span>))
ref_images_embeds = torch.stack(ref_images_embeds, dim=<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)
neg_ref_images_embeds = torch.zeros_like(ref_images_embeds)
id_embeds = torch.cat([neg_ref_images_embeds, ref_images_embeds]).to(dtype=torch.float16, device=<span class="hljs-string">&quot;cuda&quot;</span>)

clip_embeds = pipeline.prepare_ip_adapter_image_embeds(
  [ip_adapter_images], <span class="hljs-literal">None</span>, torch.device(<span class="hljs-string">&quot;cuda&quot;</span>), num_images, <span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]

pipeline.unet.encoder_hid_proj.image_projection_layers[<span class="hljs-number">0</span>].clip_embeds = clip_embeds.to(dtype=torch.float16)
pipeline.unet.encoder_hid_proj.image_projection_layers[<span class="hljs-number">0</span>].shortcut = <span class="hljs-literal">False</span> <span class="hljs-comment"># True if Plus v2</span>`,wrap:!1}}),Ie=new C({props:{title:"Multi IP-Adapter",local:"multi-ip-adapter",headingTag:"h3"}}),z=new dt({props:{warning:!1,$$slots:{default:[is]},$$scope:{ctx:R}}}),ve=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUyQyUyMERESU1TY2hlZHVsZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFZpc2lvbk1vZGVsV2l0aFByb2plY3Rpb24lMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltYWdlX2VuY29kZXIlMjAlM0QlMjBDTElQVmlzaW9uTW9kZWxXaXRoUHJvamVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMm1vZGVscyUyRmltYWdlX2VuY29kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, DDIMScheduler
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPVisionModelWithProjection
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

image_encoder = CLIPVisionModelWithProjection.from_pretrained(
    <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
    subfolder=<span class="hljs-string">&quot;models/image_encoder&quot;</span>,
    torch_dtype=torch.float16,
)`,wrap:!1}}),Ve=new v({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBpbWFnZV9lbmNvZGVyJTNEaW1hZ2VfZW5jb2RlciUyQyUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUwQSUyMCUyMCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMEElMjAlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUwQSUyMCUyMHdlaWdodF9uYW1lJTNEJTVCJTIyaXAtYWRhcHRlci1wbHVzX3NkeGxfdml0LWguc2FmZXRlbnNvcnMlMjIlMkMlMjAlMjJpcC1hZGFwdGVyLXBsdXMtZmFjZV9zZHhsX3ZpdC1oLnNhZmV0ZW5zb3JzJTIyJTVEJTBBKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKCU1QjAuNyUyQyUyMDAuMyU1RCklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    image_encoder=image_encoder,
)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>,
  weight_name=[<span class="hljs-string">&quot;ip-adapter-plus_sdxl_vit-h.safetensors&quot;</span>, <span class="hljs-string">&quot;ip-adapter-plus-face_sdxl_vit-h.safetensors&quot;</span>]
)
pipeline.set_ip_adapter_scale([<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>])
pipeline.enable_model_cpu_offload()`,wrap:!1}}),xe=new v({props:{code:"ZmFjZV9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRndvbWVuX2lucHV0LnBuZyUyMiklMEFzdHlsZV9mb2xkZXIlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc3R5bGVfemlnZ3klMjIlMEFzdHlsZV9pbWFnZXMlMjAlM0QlMjAlNUJsb2FkX2ltYWdlKGYlMjIlN0JzdHlsZV9mb2xkZXIlN0QlMkZpbWclN0JpJTdELnBuZyUyMiklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMCklNUQ=",highlighted:`face_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/women_input.png&quot;</span>)
style_folder = <span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/style_ziggy&quot;</span>
style_images = [load_image(<span class="hljs-string">f&quot;<span class="hljs-subst">{style_folder}</span>/img<span class="hljs-subst">{i}</span>.png&quot;</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>)]`,wrap:!1}}),Fe=new v({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMndvbmRlcndvbWFuJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRCU1QnN0eWxlX2ltYWdlcyUyQyUyMGZhY2VfaW1hZ2UlNUQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJtb25vY2hyb21lJTJDJTIwbG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

image = pipeline(
    prompt=<span class="hljs-string">&quot;wonderwoman&quot;</span>,
    ip_adapter_image=[style_images, face_image],
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">50</span>, num_images_per_prompt=<span class="hljs-number">1</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),$e=new C({props:{title:"Instant generation",local:"instant-generation",headingTag:"h3"}}),Qe=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwTENNU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc2QtZHJlYW1ib290aC1saWJyYXJ5JTJGaGVyZ2Utc3R5bGUlMjIlMEFsY21fbG9yYV9pZCUyMCUzRCUyMCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkdjEtNSUyMiUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVsaW5lLmxvYWRfbG9yYV93ZWlnaHRzKGxjbV9sb3JhX2lkKSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, LCMScheduler
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

model_id = <span class="hljs-string">&quot;sd-dreambooth-library/herge-style&quot;</span>
lcm_lora_id = <span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>

pipeline = DiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16)

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipeline.load_lora_weights(lcm_lora_id)
pipeline.scheduler = LCMScheduler.from_config(pipeline.scheduler.config)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),Ee=new v({props:{code:"cGlwZWxpbmUuc2V0X2lwX2FkYXB0ZXJfc2NhbGUoMC40KSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmhlcmdlX3N0eWxlJTIwd29tYW4lMjBpbiUyMGFybW9yJTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBJTBBaXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZ1c2VyLWltYWdlcy5naXRodWJ1c2VyY29udGVudC5jb20lMkYyNDczNDE0MiUyRjI2NjQ5Mjg3NS0yZDUwZDIyMy04NDc1LTQ0ZjAtYTdjNi0wOGI1MWNiNTM1NzIucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2FkYXB0ZXJfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMSUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`pipeline.set_ip_adapter_scale(<span class="hljs-number">0.4</span>)

prompt = <span class="hljs-string">&quot;herge_style woman in armor, best quality, high quality&quot;</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

ip_adapter_image = load_image(<span class="hljs-string">&quot;https://user-images.githubusercontent.com/24734142/266492875-2d50d223-8475-44f0-a7c6-08b51cb53572.png&quot;</span>)
image = pipeline(
    prompt=prompt,
    ip_adapter_image=ip_adapter_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">1</span>,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ze=new C({props:{title:"Structural control",local:"structural-control",headingTag:"h3"}}),Le=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFjb250cm9sbmV0X21vZGVsX3BhdGglMjAlM0QlMjAlMjJsbGx5YXN2aWVsJTJGY29udHJvbF92MTFmMXBfc2QxNV9kZXB0aCUyMiUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGNvbnRyb2xuZXRfbW9kZWxfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZWxpbmUudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMm1vZGVscyUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyaXAtYWRhcHRlcl9zZDE1LmJpbiUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

controlnet_model_path = <span class="hljs-string">&quot;lllyasviel/control_v11f1p_sd15_depth&quot;</span>
controlnet = ControlNetModel.from_pretrained(controlnet_model_path, torch_dtype=torch.float16)

pipeline = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)`,wrap:!1}}),De=new v({props:{code:"aXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnN0YXR1ZS5wbmclMjIpJTBBZGVwdGhfbWFwJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGVwdGgucG5nJTIyKQ==",highlighted:`ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/statue.png&quot;</span>)
depth_map = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/depth.png&quot;</span>)`,wrap:!1}}),Oe=new v({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMzMpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJiZXN0JTIwcXVhbGl0eSUyQyUyMGhpZ2glMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RkZXB0aF9tYXAlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaXBfYWRhcHRlcl9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMm1vbm9jaHJvbWUlMkMlMjBsb3dyZXMlMkMlMjBiYWQlMjBhbmF0b215JTJDJTIwd29yc3QlMjBxdWFsaXR5JTJDJTIwbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
image = pipeline(
    prompt=<span class="hljs-string">&quot;best quality, high quality&quot;</span>,
    image=depth_map,
    ip_adapter_image=ip_adapter_image,
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),et=new C({props:{title:"Style & layout control",local:"style--layout-control",headingTag:"h3"}}),at=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyaXAtYWRhcHRlcl9zZHhsLmJpbiUyMiklMEElMEFzY2FsZSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmRvd24lMjIlM0ElMjAlN0IlMjJibG9ja18yJTIyJTNBJTIwJTVCMC4wJTJDJTIwMS4wJTVEJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydXAlMjIlM0ElMjAlN0IlMjJibG9ja18wJTIyJTNBJTIwJTVCMC4wJTJDJTIwMS4wJTJDJTIwMC4wJTVEJTdEJTJDJTBBJTdEJTBBcGlwZWxpbmUuc2V0X2lwX2FkYXB0ZXJfc2NhbGUoc2NhbGUp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)

scale = {
    <span class="hljs-string">&quot;down&quot;</span>: {<span class="hljs-string">&quot;block_2&quot;</span>: [<span class="hljs-number">0.0</span>, <span class="hljs-number">1.0</span>]},
    <span class="hljs-string">&quot;up&quot;</span>: {<span class="hljs-string">&quot;block_0&quot;</span>: [<span class="hljs-number">0.0</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">0.0</span>]},
}
pipeline.set_ip_adapter_scale(scale)`,wrap:!1}}),nt=new v({props:{code:"c3R5bGVfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGMDA1MmE3MGJlZWQ1YmY3MWI5MjYxMGE0M2E1MmRmNmQyODZjZDVmMyUyRmRpZmZ1c2VycyUyRnJhYmJpdC5qcGclMjIpJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMjYpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJhJTIwY2F0JTJDJTIwbWFzdGVycGllY2UlMkMlMjBiZXN0JTIwcXVhbGl0eSUyQyUyMGhpZ2glMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRHN0eWxlX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIydGV4dCUyQyUyMHdhdGVybWFyayUyQyUyMGxvd3JlcyUyQyUyMGxvdyUyMHF1YWxpdHklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBkZWZvcm1lZCUyQyUyMGdsaXRjaCUyQyUyMGxvdyUyMGNvbnRyYXN0JTJDJTIwbm9pc3klMkMlMjBzYXR1cmF0aW9uJTJDJTIwYmx1cnJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q1JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`style_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/0052a70beed5bf71b92610a43a52df6d286cd5f3/diffusers/rabbit.jpg&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">26</span>)
image = pipeline(
    prompt=<span class="hljs-string">&quot;a cat, masterpiece, best quality, high quality&quot;</span>,
    ip_adapter_image=style_image,
    negative_prompt=<span class="hljs-string">&quot;text, watermark, lowres, low quality, worst quality, deformed, glitch, low contrast, noisy, saturation, blurry&quot;</span>,
    guidance_scale=<span class="hljs-number">5</span>,
    num_inference_steps=<span class="hljs-number">30</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),rt=new v({props:{code:"c2NhbGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJ1cCUyMiUzQSUyMCU3QiUyMmJsb2NrXzAlMjIlM0ElMjAlNUIwLjAlMkMlMjAxLjAlMkMlMjAwLjAlNUQlN0QlMkMlMEElN0QlMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZShzY2FsZSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgyNiklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBjYXQlMkMlMjBtYXN0ZXJwaWVjZSUyQyUyMGJlc3QlMjBxdWFsaXR5JTJDJTIwaGlnaCUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEc3R5bGVfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJ0ZXh0JTJDJTIwd2F0ZXJtYXJrJTJDJTIwbG93cmVzJTJDJTIwbG93JTIwcXVhbGl0eSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGRlZm9ybWVkJTJDJTIwZ2xpdGNoJTJDJTIwbG93JTIwY29udHJhc3QlMkMlMjBub2lzeSUyQyUyMHNhdHVyYXRpb24lMkMlMjBibHVycnklMjIlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDUlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`scale = {
    <span class="hljs-string">&quot;up&quot;</span>: {<span class="hljs-string">&quot;block_0&quot;</span>: [<span class="hljs-number">0.0</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">0.0</span>]},
}
pipeline.set_ip_adapter_scale(scale)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">26</span>)
image = pipeline(
    prompt=<span class="hljs-string">&quot;a cat, masterpiece, best quality, high quality&quot;</span>,
    ip_adapter_image=style_image,
    negative_prompt=<span class="hljs-string">&quot;text, watermark, lowres, low quality, worst quality, deformed, glitch, low contrast, noisy, saturation, blurry&quot;</span>,
    guidance_scale=<span class="hljs-number">5</span>,
    num_inference_steps=<span class="hljs-number">30</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),mt=new qa({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/ip_adapter.md"}}),{c(){p=r("meta"),w=n(),m=r("p"),M=n(),y(G.$$.fragment),_=n(),b=r("p"),b.innerHTML=I,c=n(),y(T.$$.fragment),X=n(),j=r("p"),j.textContent=k,W=n(),y(B.$$.fragment),u=n(),s=r("p"),s.innerHTML=U,ut=n(),ee=r("p"),ee.innerHTML=Ql,Mt=n(),y(Y.$$.fragment),yt=n(),y(F.$$.fragment),ht=n(),y(te.$$.fragment),ft=n(),le=r("p"),le.textContent=Al,gt=n(),y(ae.$$.fragment),Jt=n(),se=r("p"),se.innerHTML=El,Zt=n(),y($.$$.fragment),bt=n(),ne=r("p"),ne.innerHTML=zl,Ut=n(),y(H.$$.fragment),wt=n(),y(ie.$$.fragment),Tt=n(),pe=r("p"),pe.innerHTML=Sl,jt=n(),y(re.$$.fragment),Wt=n(),y(oe.$$.fragment),_t=n(),me=r("p"),me.textContent=ql,Gt=n(),de=r("p"),de.innerHTML=Ll,It=n(),y(ce.$$.fragment),Xt=n(),N=r("div"),N.innerHTML=Pl,kt=n(),ue=r("p"),ue.textContent=Dl,vt=n(),y(Me.$$.fragment),Rt=n(),Q=r("div"),Q.innerHTML=Kl,Bt=n(),ye=r("p"),ye.innerHTML=Ol,Vt=n(),y(he.$$.fragment),Ct=n(),A=r("div"),A.innerHTML=ea,xt=n(),y(fe.$$.fragment),Yt=n(),ge=r("p"),ge.textContent=ta,Ft=n(),y(Je.$$.fragment),$t=n(),Ze=r("p"),Ze.innerHTML=la,Ht=n(),be=r("ul"),be.innerHTML=aa,Nt=n(),Ue=r("p"),Ue.innerHTML=sa,Qt=n(),we=r("p"),we.innerHTML=na,At=n(),y(Te.$$.fragment),Et=n(),E=r("div"),E.innerHTML=ia,zt=n(),je=r("p"),je.innerHTML=pa,St=n(),y(We.$$.fragment),qt=n(),_e=r("p"),_e.textContent=ra,Lt=n(),y(Ge.$$.fragment),Pt=n(),y(Ie.$$.fragment),Dt=n(),Xe=r("p"),Xe.textContent=oa,Kt=n(),y(z.$$.fragment),Ot=n(),ke=r("p"),ke.innerHTML=ma,el=n(),y(ve.$$.fragment),tl=n(),Re=r("p"),Re.innerHTML=da,ll=n(),Be=r("ul"),Be.innerHTML=ca,al=n(),y(Ve.$$.fragment),sl=n(),Ce=r("p"),Ce.textContent=ua,nl=n(),y(xe.$$.fragment),il=n(),S=r("div"),S.innerHTML=Ma,pl=n(),Ye=r("p"),Ye.innerHTML=ya,rl=n(),y(Fe.$$.fragment),ol=n(),q=r("div"),q.innerHTML=ha,ml=n(),y($e.$$.fragment),dl=n(),He=r("p"),He.innerHTML=fa,cl=n(),Ne=r("p"),Ne.innerHTML=ga,ul=n(),y(Qe.$$.fragment),Ml=n(),Ae=r("p"),Ae.innerHTML=Ja,yl=n(),y(Ee.$$.fragment),hl=n(),L=r("div"),L.innerHTML=Za,fl=n(),y(ze.$$.fragment),gl=n(),Se=r("p"),Se.innerHTML=ba,Jl=n(),qe=r("p"),qe.innerHTML=Ua,Zl=n(),y(Le.$$.fragment),bl=n(),Pe=r("p"),Pe.textContent=wa,Ul=n(),y(De.$$.fragment),wl=n(),P=r("div"),P.innerHTML=Ta,Tl=n(),Ke=r("p"),Ke.textContent=ja,jl=n(),y(Oe.$$.fragment),Wl=n(),D=r("div"),D.innerHTML=Wa,_l=n(),y(et.$$.fragment),Gl=n(),tt=r("p"),tt.innerHTML=_a,Il=n(),lt=r("p"),lt.innerHTML=Ga,Xl=n(),y(at.$$.fragment),kl=n(),st=r("p"),st.textContent=Ia,vl=n(),y(nt.$$.fragment),Rl=n(),K=r("div"),K.innerHTML=Xa,Bl=n(),it=r("p"),it.textContent=ka,Vl=n(),pt=r("p"),pt.textContent=va,Cl=n(),y(rt.$$.fragment),xl=n(),O=r("div"),O.innerHTML=Ra,Yl=n(),ot=r("p"),ot.textContent=Ba,Fl=n(),y(mt.$$.fragment),$l=n(),ct=r("p"),this.h()},l(e){const t=za("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),w=i(e),m=o(e,"P",{}),Ha(m).forEach(l),M=i(e),h(G.$$.fragment,e),_=i(e),b=o(e,"P",{"data-svelte-h":!0}),d(b)!=="svelte-rd9njz"&&(b.innerHTML=I),c=i(e),h(T.$$.fragment,e),X=i(e),j=o(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-1211s0v"&&(j.textContent=k),W=i(e),h(B.$$.fragment,e),u=i(e),s=o(e,"P",{"data-svelte-h":!0}),d(s)!=="svelte-1yugx20"&&(s.innerHTML=U),ut=i(e),ee=o(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-965c4t"&&(ee.innerHTML=Ql),Mt=i(e),h(Y.$$.fragment,e),yt=i(e),h(F.$$.fragment,e),ht=i(e),h(te.$$.fragment,e),ft=i(e),le=o(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1ytpuar"&&(le.textContent=Al),gt=i(e),h(ae.$$.fragment,e),Jt=i(e),se=o(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-csxost"&&(se.innerHTML=El),Zt=i(e),h($.$$.fragment,e),bt=i(e),ne=o(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1h2tzec"&&(ne.innerHTML=zl),Ut=i(e),h(H.$$.fragment,e),wt=i(e),h(ie.$$.fragment,e),Tt=i(e),pe=o(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1nluq5y"&&(pe.innerHTML=Sl),jt=i(e),h(re.$$.fragment,e),Wt=i(e),h(oe.$$.fragment,e),_t=i(e),me=o(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1jbd2l3"&&(me.textContent=ql),Gt=i(e),de=o(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-ci17qi"&&(de.innerHTML=Ll),It=i(e),h(ce.$$.fragment,e),Xt=i(e),N=o(e,"DIV",{class:!0,"data-svelte-h":!0}),d(N)!=="svelte-eifaa"&&(N.innerHTML=Pl),kt=i(e),ue=o(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-ep1q3l"&&(ue.textContent=Dl),vt=i(e),h(Me.$$.fragment,e),Rt=i(e),Q=o(e,"DIV",{class:!0,"data-svelte-h":!0}),d(Q)!=="svelte-m35a5e"&&(Q.innerHTML=Kl),Bt=i(e),ye=o(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1oy5psd"&&(ye.innerHTML=Ol),Vt=i(e),h(he.$$.fragment,e),Ct=i(e),A=o(e,"DIV",{class:!0,"data-svelte-h":!0}),d(A)!=="svelte-1rjzzk0"&&(A.innerHTML=ea),xt=i(e),h(fe.$$.fragment,e),Yt=i(e),ge=o(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-3uurtn"&&(ge.textContent=ta),Ft=i(e),h(Je.$$.fragment,e),$t=i(e),Ze=o(e,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-1hojnjd"&&(Ze.innerHTML=la),Ht=i(e),be=o(e,"UL",{"data-svelte-h":!0}),d(be)!=="svelte-1a56pqx"&&(be.innerHTML=aa),Nt=i(e),Ue=o(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-1ylc0is"&&(Ue.innerHTML=sa),Qt=i(e),we=o(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1yfgi08"&&(we.innerHTML=na),At=i(e),h(Te.$$.fragment,e),Et=i(e),E=o(e,"DIV",{class:!0,"data-svelte-h":!0}),d(E)!=="svelte-lbwedl"&&(E.innerHTML=ia),zt=i(e),je=o(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-10x245s"&&(je.innerHTML=pa),St=i(e),h(We.$$.fragment,e),qt=i(e),_e=o(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-1mw36co"&&(_e.textContent=ra),Lt=i(e),h(Ge.$$.fragment,e),Pt=i(e),h(Ie.$$.fragment,e),Dt=i(e),Xe=o(e,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-1tk2m7v"&&(Xe.textContent=oa),Kt=i(e),h(z.$$.fragment,e),Ot=i(e),ke=o(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-qgg0iy"&&(ke.innerHTML=ma),el=i(e),h(ve.$$.fragment,e),tl=i(e),Re=o(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-1vw2kqb"&&(Re.innerHTML=da),ll=i(e),Be=o(e,"UL",{"data-svelte-h":!0}),d(Be)!=="svelte-tpz2u9"&&(Be.innerHTML=ca),al=i(e),h(Ve.$$.fragment,e),sl=i(e),Ce=o(e,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-1p6lwr0"&&(Ce.textContent=ua),nl=i(e),h(xe.$$.fragment,e),il=i(e),S=o(e,"DIV",{class:!0,"data-svelte-h":!0}),d(S)!=="svelte-im3du6"&&(S.innerHTML=Ma),pl=i(e),Ye=o(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-1kkzavx"&&(Ye.innerHTML=ya),rl=i(e),h(Fe.$$.fragment,e),ol=i(e),q=o(e,"DIV",{class:!0,"data-svelte-h":!0}),d(q)!=="svelte-1t1eqqe"&&(q.innerHTML=ha),ml=i(e),h($e.$$.fragment,e),dl=i(e),He=o(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-1am74qu"&&(He.innerHTML=fa),cl=i(e),Ne=o(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-s1k0r"&&(Ne.innerHTML=ga),ul=i(e),h(Qe.$$.fragment,e),Ml=i(e),Ae=o(e,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-13u2z8i"&&(Ae.innerHTML=Ja),yl=i(e),h(Ee.$$.fragment,e),hl=i(e),L=o(e,"DIV",{class:!0,"data-svelte-h":!0}),d(L)!=="svelte-1cw2b12"&&(L.innerHTML=Za),fl=i(e),h(ze.$$.fragment,e),gl=i(e),Se=o(e,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-sz8jif"&&(Se.innerHTML=ba),Jl=i(e),qe=o(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1ve6k34"&&(qe.innerHTML=Ua),Zl=i(e),h(Le.$$.fragment,e),bl=i(e),Pe=o(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-77tfin"&&(Pe.textContent=wa),Ul=i(e),h(De.$$.fragment,e),wl=i(e),P=o(e,"DIV",{class:!0,"data-svelte-h":!0}),d(P)!=="svelte-mjuwpp"&&(P.innerHTML=Ta),Tl=i(e),Ke=o(e,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-12fzw16"&&(Ke.textContent=ja),jl=i(e),h(Oe.$$.fragment,e),Wl=i(e),D=o(e,"DIV",{class:!0,"data-svelte-h":!0}),d(D)!=="svelte-kc4794"&&(D.innerHTML=Wa),_l=i(e),h(et.$$.fragment,e),Gl=i(e),tt=o(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-q7o983"&&(tt.innerHTML=_a),Il=i(e),lt=o(e,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-1u86q9j"&&(lt.innerHTML=Ga),Xl=i(e),h(at.$$.fragment,e),kl=i(e),st=o(e,"P",{"data-svelte-h":!0}),d(st)!=="svelte-kr0aol"&&(st.textContent=Ia),vl=i(e),h(nt.$$.fragment,e),Rl=i(e),K=o(e,"DIV",{class:!0,"data-svelte-h":!0}),d(K)!=="svelte-fn5cjg"&&(K.innerHTML=Xa),Bl=i(e),it=o(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-12ccihh"&&(it.textContent=ka),Vl=i(e),pt=o(e,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-18cri0h"&&(pt.textContent=va),Cl=i(e),h(rt.$$.fragment,e),xl=i(e),O=o(e,"DIV",{class:!0,"data-svelte-h":!0}),d(O)!=="svelte-1x2k8r5"&&(O.innerHTML=Ra),Yl=i(e),ot=o(e,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-bmv4p"&&(ot.textContent=Ba),Fl=i(e),h(mt.$$.fragment,e),$l=i(e),ct=o(e,"P",{}),Ha(ct).forEach(l),this.h()},h(){V(p,"name","hf:doc:metadata"),V(p,"content",rs),V(N,"class","flex flex-row gap-4"),V(Q,"class","flex flex-row gap-4"),V(A,"class","flex flex-row gap-4"),V(E,"class","flex flex-row gap-4"),V(S,"class","flex flex-row gap-4"),V(q,"class","flex justify-center"),V(L,"class","flex justify-center"),V(P,"class","flex flex-row gap-4"),V(D,"class","flex justify-center"),V(K,"class","flex flex-row gap-4"),V(O,"class","flex flex-row gap-4")},m(e,t){Sa(document.head,p),a(e,w,t),a(e,m,t),a(e,M,t),f(G,e,t),a(e,_,t),a(e,b,t),a(e,c,t),f(T,e,t),a(e,X,t),a(e,j,t),a(e,W,t),f(B,e,t),a(e,u,t),a(e,s,t),a(e,ut,t),a(e,ee,t),a(e,Mt,t),f(Y,e,t),a(e,yt,t),f(F,e,t),a(e,ht,t),f(te,e,t),a(e,ft,t),a(e,le,t),a(e,gt,t),f(ae,e,t),a(e,Jt,t),a(e,se,t),a(e,Zt,t),f($,e,t),a(e,bt,t),a(e,ne,t),a(e,Ut,t),f(H,e,t),a(e,wt,t),f(ie,e,t),a(e,Tt,t),a(e,pe,t),a(e,jt,t),f(re,e,t),a(e,Wt,t),f(oe,e,t),a(e,_t,t),a(e,me,t),a(e,Gt,t),a(e,de,t),a(e,It,t),f(ce,e,t),a(e,Xt,t),a(e,N,t),a(e,kt,t),a(e,ue,t),a(e,vt,t),f(Me,e,t),a(e,Rt,t),a(e,Q,t),a(e,Bt,t),a(e,ye,t),a(e,Vt,t),f(he,e,t),a(e,Ct,t),a(e,A,t),a(e,xt,t),f(fe,e,t),a(e,Yt,t),a(e,ge,t),a(e,Ft,t),f(Je,e,t),a(e,$t,t),a(e,Ze,t),a(e,Ht,t),a(e,be,t),a(e,Nt,t),a(e,Ue,t),a(e,Qt,t),a(e,we,t),a(e,At,t),f(Te,e,t),a(e,Et,t),a(e,E,t),a(e,zt,t),a(e,je,t),a(e,St,t),f(We,e,t),a(e,qt,t),a(e,_e,t),a(e,Lt,t),f(Ge,e,t),a(e,Pt,t),f(Ie,e,t),a(e,Dt,t),a(e,Xe,t),a(e,Kt,t),f(z,e,t),a(e,Ot,t),a(e,ke,t),a(e,el,t),f(ve,e,t),a(e,tl,t),a(e,Re,t),a(e,ll,t),a(e,Be,t),a(e,al,t),f(Ve,e,t),a(e,sl,t),a(e,Ce,t),a(e,nl,t),f(xe,e,t),a(e,il,t),a(e,S,t),a(e,pl,t),a(e,Ye,t),a(e,rl,t),f(Fe,e,t),a(e,ol,t),a(e,q,t),a(e,ml,t),f($e,e,t),a(e,dl,t),a(e,He,t),a(e,cl,t),a(e,Ne,t),a(e,ul,t),f(Qe,e,t),a(e,Ml,t),a(e,Ae,t),a(e,yl,t),f(Ee,e,t),a(e,hl,t),a(e,L,t),a(e,fl,t),f(ze,e,t),a(e,gl,t),a(e,Se,t),a(e,Jl,t),a(e,qe,t),a(e,Zl,t),f(Le,e,t),a(e,bl,t),a(e,Pe,t),a(e,Ul,t),f(De,e,t),a(e,wl,t),a(e,P,t),a(e,Tl,t),a(e,Ke,t),a(e,jl,t),f(Oe,e,t),a(e,Wl,t),a(e,D,t),a(e,_l,t),f(et,e,t),a(e,Gl,t),a(e,tt,t),a(e,Il,t),a(e,lt,t),a(e,Xl,t),f(at,e,t),a(e,kl,t),a(e,st,t),a(e,vl,t),f(nt,e,t),a(e,Rl,t),a(e,K,t),a(e,Bl,t),a(e,it,t),a(e,Vl,t),a(e,pt,t),a(e,Cl,t),f(rt,e,t),a(e,xl,t),a(e,O,t),a(e,Yl,t),a(e,ot,t),a(e,Fl,t),f(mt,e,t),a(e,$l,t),a(e,ct,t),Hl=!0},p(e,[t]){const Va={};t&2&&(Va.$$scope={dirty:t,ctx:e}),T.$set(Va);const Ca={};t&2&&(Ca.$$scope={dirty:t,ctx:e}),Y.$set(Ca);const xa={};t&2&&(xa.$$scope={dirty:t,ctx:e}),F.$set(xa);const Ya={};t&2&&(Ya.$$scope={dirty:t,ctx:e}),$.$set(Ya);const Fa={};t&2&&(Fa.$$scope={dirty:t,ctx:e}),H.$set(Fa);const $a={};t&2&&($a.$$scope={dirty:t,ctx:e}),z.$set($a)},i(e){Hl||(g(G.$$.fragment,e),g(T.$$.fragment,e),g(B.$$.fragment,e),g(Y.$$.fragment,e),g(F.$$.fragment,e),g(te.$$.fragment,e),g(ae.$$.fragment,e),g($.$$.fragment,e),g(H.$$.fragment,e),g(ie.$$.fragment,e),g(re.$$.fragment,e),g(oe.$$.fragment,e),g(ce.$$.fragment,e),g(Me.$$.fragment,e),g(he.$$.fragment,e),g(fe.$$.fragment,e),g(Je.$$.fragment,e),g(Te.$$.fragment,e),g(We.$$.fragment,e),g(Ge.$$.fragment,e),g(Ie.$$.fragment,e),g(z.$$.fragment,e),g(ve.$$.fragment,e),g(Ve.$$.fragment,e),g(xe.$$.fragment,e),g(Fe.$$.fragment,e),g($e.$$.fragment,e),g(Qe.$$.fragment,e),g(Ee.$$.fragment,e),g(ze.$$.fragment,e),g(Le.$$.fragment,e),g(De.$$.fragment,e),g(Oe.$$.fragment,e),g(et.$$.fragment,e),g(at.$$.fragment,e),g(nt.$$.fragment,e),g(rt.$$.fragment,e),g(mt.$$.fragment,e),Hl=!0)},o(e){J(G.$$.fragment,e),J(T.$$.fragment,e),J(B.$$.fragment,e),J(Y.$$.fragment,e),J(F.$$.fragment,e),J(te.$$.fragment,e),J(ae.$$.fragment,e),J($.$$.fragment,e),J(H.$$.fragment,e),J(ie.$$.fragment,e),J(re.$$.fragment,e),J(oe.$$.fragment,e),J(ce.$$.fragment,e),J(Me.$$.fragment,e),J(he.$$.fragment,e),J(fe.$$.fragment,e),J(Je.$$.fragment,e),J(Te.$$.fragment,e),J(We.$$.fragment,e),J(Ge.$$.fragment,e),J(Ie.$$.fragment,e),J(z.$$.fragment,e),J(ve.$$.fragment,e),J(Ve.$$.fragment,e),J(xe.$$.fragment,e),J(Fe.$$.fragment,e),J($e.$$.fragment,e),J(Qe.$$.fragment,e),J(Ee.$$.fragment,e),J(ze.$$.fragment,e),J(Le.$$.fragment,e),J(De.$$.fragment,e),J(Oe.$$.fragment,e),J(et.$$.fragment,e),J(at.$$.fragment,e),J(nt.$$.fragment,e),J(rt.$$.fragment,e),J(mt.$$.fragment,e),Hl=!1},d(e){e&&(l(w),l(m),l(M),l(_),l(b),l(c),l(X),l(j),l(W),l(u),l(s),l(ut),l(ee),l(Mt),l(yt),l(ht),l(ft),l(le),l(gt),l(Jt),l(se),l(Zt),l(bt),l(ne),l(Ut),l(wt),l(Tt),l(pe),l(jt),l(Wt),l(_t),l(me),l(Gt),l(de),l(It),l(Xt),l(N),l(kt),l(ue),l(vt),l(Rt),l(Q),l(Bt),l(ye),l(Vt),l(Ct),l(A),l(xt),l(Yt),l(ge),l(Ft),l($t),l(Ze),l(Ht),l(be),l(Nt),l(Ue),l(Qt),l(we),l(At),l(Et),l(E),l(zt),l(je),l(St),l(qt),l(_e),l(Lt),l(Pt),l(Dt),l(Xe),l(Kt),l(Ot),l(ke),l(el),l(tl),l(Re),l(ll),l(Be),l(al),l(sl),l(Ce),l(nl),l(il),l(S),l(pl),l(Ye),l(rl),l(ol),l(q),l(ml),l(dl),l(He),l(cl),l(Ne),l(ul),l(Ml),l(Ae),l(yl),l(hl),l(L),l(fl),l(gl),l(Se),l(Jl),l(qe),l(Zl),l(bl),l(Pe),l(Ul),l(wl),l(P),l(Tl),l(Ke),l(jl),l(Wl),l(D),l(_l),l(Gl),l(tt),l(Il),l(lt),l(Xl),l(kl),l(st),l(vl),l(Rl),l(K),l(Bl),l(it),l(Vl),l(pt),l(Cl),l(xl),l(O),l(Yl),l(ot),l(Fl),l($l),l(ct)),l(p),Z(G,e),Z(T,e),Z(B,e),Z(Y,e),Z(F,e),Z(te,e),Z(ae,e),Z($,e),Z(H,e),Z(ie,e),Z(re,e),Z(oe,e),Z(ce,e),Z(Me,e),Z(he,e),Z(fe,e),Z(Je,e),Z(Te,e),Z(We,e),Z(Ge,e),Z(Ie,e),Z(z,e),Z(ve,e),Z(Ve,e),Z(xe,e),Z(Fe,e),Z($e,e),Z(Qe,e),Z(Ee,e),Z(ze,e),Z(Le,e),Z(De,e),Z(Oe,e),Z(et,e),Z(at,e),Z(nt,e),Z(rt,e),Z(mt,e)}}}const rs='{"title":"IP-Adapter","local":"ip-adapter","sections":[{"title":"General tasks","local":"general-tasks","sections":[],"depth":2},{"title":"Configure parameters","local":"configure-parameters","sections":[{"title":"Image embeddings","local":"image-embeddings","sections":[],"depth":3},{"title":"IP-Adapter masking","local":"ip-adapter-masking","sections":[],"depth":3}],"depth":2},{"title":"Specific use cases","local":"specific-use-cases","sections":[{"title":"Face model","local":"face-model","sections":[],"depth":3},{"title":"Multi IP-Adapter","local":"multi-ip-adapter","sections":[],"depth":3},{"title":"Instant generation","local":"instant-generation","sections":[],"depth":3},{"title":"Structural control","local":"structural-control","sections":[],"depth":3},{"title":"Style & layout control","local":"style--layout-control","sections":[],"depth":3}],"depth":2}],"depth":1}';function os(R){return Qa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hs extends Aa{constructor(p){super(),Ea(this,p,os,ps,Na,{})}}export{hs as component};
