# 评估语音合成模型

在训练期间，语音合成模型旨在优化平均平方误差损失（mean-square error loss，简称 MSE）或平均绝对误差（mean absolute error，简称 MAE），
这两者衡量的是预测的频谱图和真正的频谱图之间的差异。MSE 和 MAE 都鼓励模型最小化预测和目标频谱图之间的差异。然而，由于 TTS 是一种一对多映射问题，
即给定文本的输出频谱图有多种可能性，所以评估语音合成模型要比预想的困难得多。

与许多其他可以使用定量指标（如准确率、精确度）客观衡量的计算任务不同，评估 TTS 主要依赖于主观的人类分析。

评估 TTS 系统最常用方法之一是通过平均意见得分（Mean Opinion Scores，简称 MOS）进行定性评估。MOS 是一种主观评分系统，
允许人类评估者对合成语音的感知质量进行评分，评分范围从 1 到 5。这些得分通常通过听力测试收集，参与者听取并评价合成语音样本。

对于 TTS 评估来说，设置客观指标困难的主要原因之一是语音感知的主观性。不同的人类听众对语音的不同方面，包括发音、语调、自然度和清晰度，
有着各自的偏好和敏感度。用单一的数值捕捉这些感知细微差别是一项艰巨的任务。同时，人类评估的主观性使得比较和基准测试不同的 TTS 系统变得困难。

此外，这种评估可能会忽视语音合成的某些重要方面，如自然度、表达力和情感影响。这些质量难以客观量化，但在需要合成语音达到类人的品质和引发适当情感反应的应用中至关重要。

总之，由于缺乏一个真正客观的指标，评估语音合成模型是一项复杂的任务。最常用的评估方法，即平均意见得分（MOS），依赖于主观的人类分析。
尽管 MOS 提供了对合成语音质量的宝贵意见，但它也引入了不确定性和主观性。

