# 实战练习

在本单元中，我们探讨了微调 ASR 模型的挑战，验证了在新语言上微调像 Whisper（即使是小型检查点）模型需要不少时间和资源。
为了提供实践经验，我们设计了一个练习，让您能够在使用较小数据集的情况下，体验微调 ASR 模型的过程。
这个练习的主要目的是让您熟悉过程，而不是取得生产级别的结果。我们故意设置了一个低指标，以确保即使在资源有限的情况下，您也应该能够达到它。

以下是指导说明：

* 使用 `"PolyAI/minds14"` 数据集的美式英语（"en-US"）子集，微调 `"openai/whisper-tiny"` 模型。
* 使用 **前450 个样本**进行训练，其余的用于评估。确保在使用 `.map` 方法预处理数据集时设置 `num_proc=1`（这将确保您的模型正确提交以进行评估）。
* 评估模型时，使用本单元描述的 `wer` 和 `wer_ortho` 指标。但是，*不要* 通过乘以 100 将指标转换为百分比（例如，如果 WER 是 42%，我们将期望在此练习中看到 0.42 的值）。

您微调了一个模型后，请使用以下 `kwargs` 将其上传到 🤗 Hub：

```
kwargs = {
    "dataset_tags": "PolyAI/minds14",
    "finetuned_from": "openai/whisper-tiny",
    "tasks": "automatic-speech-recognition",
}
```

如果您的模型的标准化 WER（`wer`）低于 **0.37**，您将通过这个任务。

请随意构建您的模型 demo，并在 Discord 上分享！如果您有任何问题，欢迎在 #audio-study-group 频道发布。

