# Check your understanding of the course material

### 1. 采样率使用的单位是？

### 2. 使用流式加载模式加载大规模数据集时，何时才能开始使用该数据集？

### 3. 什么是时频谱？

### 4. 下列方法中，最简单的可以将原始音频转化为Whisper模型接受的对数梅尔谱的方法是？

A.
```python
librosa.feature.melspectrogram(audio["array"])
```

B.
```python
feature_extractor = WhisperFeatureExtractor.from_pretrained("openai/whisper-small")
feature_extractor(audio["array"])
```

C.
```python
dataset.feature(audio["array"], model="whisper")
```

### 5. 如何从🤗 Hub加载数据集？

A.
```python
from datasets import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

B.
```python
import librosa

dataset = librosa.load(PATH_TO_DATASET)
```

C.
```python
from transformers import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

### 6. 你的自定义数据集包含了32千赫兹采样率的高清音频。你现在想要训练一个使用16千赫兹采样率的语音识别模型。你应该怎么做？

### 7. 如何将机器学习模型生成的时频谱转化为波形？

