# Kurs materyalini anladığınızı kontrol edin

### 1. Örnekleme hızı hangi birimlerle ölçülür?

### 2. Büyük bir ses veri kümesini aktarırken, onu ne kadar sürede kullanmaya başlayabilirsiniz?

### 3. Spektrogram nedir?

### 4. Ham ses verilerini Whisper'ın beklediği log-mel spektrogramına dönüştürmenin en kolay yolu nedir?

A.
```python
librosa.feature.melspectrogram(audio["array"])
```

B.
```python
feature_extractor = WhisperFeatureExtractor.from_pretrained("openai/whisper-small")
feature_extractor(audio["array"])
```

C.
```python
dataset.feature(audio["array"], model="whisper")
```

### 5. 🤗 Hub'dan veri kümesini nasıl yüklersiniz?

A.
```python
from datasets import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

B.
```python
import librosa

dataset = librosa.load(PATH_TO_DATASET)
```

C.
```python
from transformers import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

### 6. Özel veri kümeniz 32 kHz örnekleme hızına sahip yüksek kaliteli ses içerir. Ses örneklerinin 16 kHz örnekleme hızına sahip olmasını bekleyen bir konuşma tanıma modeli eğitmek istiyorsunuz. Ne yapmalısın?

### 7. Makine öğrenimi modeli tarafından oluşturulan bir spektrogramı dalga biçimine nasıl dönüştürebilirsiniz?

