# Чему вы научитесь и что создадите

В этом разделе мы рассмотрим, как трансформеры могут быть использованы для преобразования устной речи в текст - задача, известная как _распознавание речи_ (_speech recognition_).

    

Распознавание речи, известное также как автоматическое распознавание речи (automatic speech recognition - ASR) или преобразование речи в текст
(speech-to-text - STT), является одной из наиболее популярных и интересных задач обработки устной речи. Она используется в широком спектре приложений,
включая диктовку, голосовые помощники, субтитры к видео и транскрибацию переговоров / совещаний.

Возможно, вы уже не раз пользовались системой распознавания речи, даже не подозревая об этом! Возьмем, к примеру, цифрового ассистента в вашем смартфоне
(Siri, Google Assistant, Alexa). Когда вы пользуетесь такими помощниками, первое, что они делают, - это транскрибируют вашу устную речь в письменный
текст, готовый к использованию для решения последующих задач (например, для поиска прогноза погоды 🌤️).

Попробуйте воспользоваться демонстрацией распознавания речи, приведенной ниже. Вы можете записать себя с помощью микрофона или перетащить в окно образец
звука для расшифровки:

 

Распознавание речи является сложной задачей, поскольку требует совместного знания в области звука и текста. Входной звук может содержать много фоновых
шумов и произноситься дикторами с разным акцентом, что затрудняет выделение произносимой речи. В письменном тексте могут присутствовать символы, не
имеющие акустического звучания, например, знаки препинания, которые трудно определить только по звуку. Все это - препятствия, которые нам приходится
преодолевать при создании эффективных систем распознавания речи!

Теперь, когда мы определились с задачей, можно приступить к более детальному изучению распознавания речи. К концу этого раздела вы будете иметь хорошее
фундаментальное представление о различных доступных предварительно обученных моделях распознавания речи и о том, как использовать их с библиотекой
🤗 Transformers. Вы также узнаете о процедуре тонкой настройки ASR-модели на выбранный домен или язык, что позволит вам построить производительную
систему для решения любой задачи. Вы сможете продемонстрировать свою модель друзьям и близким, создав "живую" демонстрацию, которая воспринимает любую
устную речь и преобразует ее в текст!

В частности, мы рассмотрим:

* [Предварительно обученные модели для распознавания речи](asr_models)
* [Выбор набора данных](choosing_dataset)
* [Оценка и метрики для распознавания речи](evaluation)
* [Как дообучить ASR-систему с помощью Trainer API](fine-tuning)
* [Создание демо](demo)
* [Практическое занятие](hands_on)

