# Практическое занятие

В этом разделе мы изучили сложности дообучения моделей ASR, признавая необходимость времени и ресурсов для дообучения модели, такой как Whisper
(даже с небольшой контрольной точкой), на новом языке. Чтобы предоставить вам практический опыт, мы разработали упражнение, которое поможет вам пройти
через процесс дообучения модели ASR с использованием небольшого набора данных. Основная цель этого упражнения - больше помочь вам ознакомиться с процессом
дообучения, чем стремиться к результатам на уровне продакшн-решений. Мы специально установили низкий показатель метрики, чтобы даже при ограниченных
ресурсах вы могли успешно его достичь.

Инструкции:

* Дообучите модель `”openai/whisper-tiny”`, используя американский английский ("en-US") поднабор набора данных `”PolyAI/minds14”`.
* Используйте первые **450 примеров для обучения**, остальные для оценки. Убедитесь, что вы установили `num_proc=1` при предварительной обработке набора данных с использованием метода `.map` (это обеспечит правильную отправку вашей модели для оценки).
* Для оценки модели используйте метрики `wer` и `wer_ortho`, как описано в данном уроке. Однако *не* преобразуйте метрику в проценты, умножая на 100 (например, если WER равен 42%, мы ожидаем увидеть значение 0.42 в этом упражнении).

После того как вы проведете тонкую настройку модели, убедитесь, что загрузили ее на 🤗 Hugging Face Hub с использованием следующих параметров (`kwargs`):
```
kwargs = {
     "dataset_tags": "PolyAI/minds14",
    "finetuned_from": "openai/whisper-tiny",
    "tasks": "automatic-speech-recognition",
}
```
Вы успешно завершите это задание, если показатель WER (`wer`) вашей нормализованный вашей будет ниже **0.37**.

Не стесняйтесь создать демо вашей модели и поделиться ею в Discord! Если у вас возникнут вопросы, задайте их в канале #audio-study-group.

