# Практическое занятие

Настало время взять в руки несколько Аудио моделей и применить на практике то, чему вы научились.
Это упражнение является одним из четырех практических упражнений, необходимых для получения сертификата об окончании курса.

Вот инструкции.
В этом блоке мы продемонстрировали дообучение модели Hubert на наборе данных `marsyas/gtzan` для классификации музыки. Accuracy нашего примера составила 83%.
Ваша задача - улучшить этот показатель.

Вы можете выбрать любую модель на [🤗 Hugging Face Hub](https://huggingface.co/models), которая, по вашему мнению, подходит для классификации аудио, и использовать
точно такой же набор данных [`marsyas/gtzan`](https://huggingface.co/datasets/marsyas/gtzan) для построения собственного классификатора.

Ваша цель - достичь accuracy 87% на этом наборе данных с помощью вашего классификатора. Вы можете выбрать точно такую же модель, поиграть с гиперпараметрами обучения
или выбрать совершенно другую модель - все зависит от вас!

Чтобы ваш результат был засчитан в сертификат, не забудьте в конце обучения вывести модель на Hub, как это было показано в данном блоке,
со следующими `**kwargs`:

```python
kwargs = {
    "dataset_tags": "marsyas/gtzan",
    "dataset": "GTZAN",
    "model_name": f"{model_name}-finetuned-gtzan",
    "finetuned_from": model_id,
    "tasks": "audio-classification",
}

trainer.push_to_hub(**kwargs)
```

Вот некоторые дополнительные ресурсы, которые могут оказаться полезными при работе над этим упражнением:
* [Руководство по решению задач классификации звука в документации Transformers](https://huggingface.co/docs/transformers/tasks/audio_classification)
* [Документация по модели Hubert](https://huggingface.co/docs/transformers/model_doc/hubert)
* [Документация по модели M-CTC-T](https://huggingface.co/docs/transformers/model_doc/mctct)
* [Документация Audio Spectrogram Transformer](https://huggingface.co/docs/transformers/model_doc/audio-spectrogram-transformer)
* [Документация Wav2Vec2](https://huggingface.co/docs/transformers/model_doc/wav2vec2)

Не стесняйтесь создавать демо-версию своей модели и делиться ею в Discord! Если у вас есть вопросы, задавайте их в канале #audio-study-group.

