# Потоковая передача аудиоданных

Одной из самых больших проблем, возникающих при работе с аудиоданными, является их огромный размер. Одна минута несжатого аудиофайла CD-качества (44,1 кГц, 16 бит)
занимает чуть более 5 МБ памяти. Как правило, набор аудиоданных содержат несколько часов записей.

В предыдущих разделах мы использовали очень небольшое подмножество набора аудиоданных MINDS-14, однако типичные наборы аудиоданных гораздо больше.
Например, `xs` (наименьшая) конфигурация [GigaSpeech от SpeechColab](https://huggingface.co/datasets/speechcolab/gigaspeech)
содержит всего 10 часов обучающих данных, но для их загрузки и подготовки требуется более 13 Гбайт дискового пространства. Что же
произойдет, если мы захотим обучиться на более крупной части набора данных? Полная конфигурация `xl` того же набора данных содержит 10 000 часов
тренировочных данных, что требует более 1 ТБ дискового пространства. Для большинства из нас это значительно превышает характеристики обычного
жесткого диска. Нужно ли нам тратиться на покупку дополнительного хранилища? Или есть способ обучения на этих наборах данных без ограничения дискового пространства?

🤗 Datasets приходит на помощь, предлагая [потоковый режим] (https://huggingface.co/docs/datasets/stream). Потоковая передача позволяет загружать данные постепенно, 
по мере того как мы итерируемся по набору данных. Вместо того чтобы загружать весь набор данных сразу, мы загружаем его по одному образцу за раз.
Мы итеративно обращаемся к набору данных, загружая и подготавливая образцы на лету, когда это необходимо. Таким образом, мы всегда
загружаем только те образцы, которые мы используем, а не те, которые мы не используем!
Закончив работу с образцом, мы продолжаем итерацию по набору данных и загружаем следующий образец.

Потоковый режим имеет три основных преимущества перед загрузкой всего набора данных целиком:

* Дисковое пространство: образцы загружаются в память один за другим по мере итерации по набору данных. Поскольку данные не загружаются
локально, то не требуется дисковое пространство, поэтому можно использовать наборы данных произвольного размера.
* Время загрузки и обработки: аудиоданные имеют большой объем и требуют значительного времени для загрузки и обработки.
При потоковой передаче данных загрузка и обработка выполняются "на лету", то есть вы можете начать использовать набор данных, как только
будет готов первый образец.
* Простота экспериментов: вы можете провести эксперимент на нескольких образцах, чтобы проверить, работает ли ваш скрипт, без необходимости
загружать весь набор данных.

В режиме потоковой передачи данных есть одна оговорка. При загрузке полного набора данных без потоковой передачи как исходные данные, так и обработанные
сохраняются локально на диске. Если мы захотим повторно использовать этот набор данных, мы можем напрямую загрузить обработанные данные с диска,
минуя этапы загрузки и обработки. Следовательно, нам достаточно один раз выполнить операции загрузки и обработки,
после чего мы можем повторно использовать подготовленные данные.

В потоковом режиме данные не загружаются на диск. Таким образом, ни загруженные, ни предварительно обработанные данные не кэшируются.
Если мы хотим повторно использовать набор данных, необходимо повторить шаги потоковой передачи, при этом аудиофайлы должны быть загружены и обработаны на
"на лету" заново. По этой причине рекомендуется загружать наборы данных, которые, скорее всего, будут использоваться многократно.

Как включить потоковый режим? Легко! Просто установите `streaming=True` при загрузке набора данных. Об остальном позаботятся:

```py
gigaspeech = load_dataset("speechcolab/gigaspeech", "xs", streaming=True)
```

Подобно тому, как мы применяли шаги предварительной обработки к загруженному подмножеству MINDS-14, точно так же можно выполнить
ту же самую предварительную обработку с потоковым набором данных.

Единственное отличие заключается в том, что вы больше не можете обращаться к отдельным образцам, используя индексацию Python (т.е. `gigaspeech["train"][sample_idx]`).
Вместо этого приходится выполнять итерации по набору данных. Вот как можно получить доступ к образцу при потоковой передаче набора данных:

```py
next(iter(gigaspeech["train"]))
```

**Output:**
```out
{
    "segment_id": "YOU0000000315_S0000660",
    "speaker": "N/A",
    "text": "AS THEY'RE LEAVING  CAN KASH PULL ZAHRA ASIDE REALLY QUICKLY ",
    "audio": {
        "path": "xs_chunks_0000/YOU0000000315_S0000660.wav",
        "array": array(
            [0.0005188, 0.00085449, 0.00012207, ..., 0.00125122, 0.00076294, 0.00036621]
        ),
        "sampling_rate": 16000,
    },
    "begin_time": 2941.89,
    "end_time": 2945.07,
    "audio_id": "YOU0000000315",
    "title": "Return to Vasselheim | Critical Role: VOX MACHINA | Episode 43",
    "url": "https://www.youtube.com/watch?v=zr2n1fLVasU",
    "source": 2,
    "category": 24,
    "original_full_path": "audio/youtube/P0004/YOU0000000315.opus",
}
```

Если вы хотите ознакомиться с несколькими образцами из большого набора данных, воспользуйтесь функцией `take()` для получения первых n элементов. Возьмем
первые два образца из набора данных gigaspeech:

```py
gigaspeech_head = gigaspeech["train"].take(2)
list(gigaspeech_head)
```

**Output:**
```out
[
    {
        "segment_id": "YOU0000000315_S0000660",
        "speaker": "N/A",
        "text": "AS THEY'RE LEAVING  CAN KASH PULL ZAHRA ASIDE REALLY QUICKLY ",
        "audio": {
            "path": "xs_chunks_0000/YOU0000000315_S0000660.wav",
            "array": array(
                [
                    0.0005188,
                    0.00085449,
                    0.00012207,
                    ...,
                    0.00125122,
                    0.00076294,
                    0.00036621,
                ]
            ),
            "sampling_rate": 16000,
        },
        "begin_time": 2941.89,
        "end_time": 2945.07,
        "audio_id": "YOU0000000315",
        "title": "Return to Vasselheim | Critical Role: VOX MACHINA | Episode 43",
        "url": "https://www.youtube.com/watch?v=zr2n1fLVasU",
        "source": 2,
        "category": 24,
        "original_full_path": "audio/youtube/P0004/YOU0000000315.opus",
    },
    {
        "segment_id": "AUD0000001043_S0000775",
        "speaker": "N/A",
        "text": "SIX TOMATOES ",
        "audio": {
            "path": "xs_chunks_0000/AUD0000001043_S0000775.wav",
            "array": array(
                [
                    1.43432617e-03,
                    1.37329102e-03,
                    1.31225586e-03,
                    ...,
                    -6.10351562e-05,
                    -1.22070312e-04,
                    -1.83105469e-04,
                ]
            ),
            "sampling_rate": 16000,
        },
        "begin_time": 3673.96,
        "end_time": 3675.26,
        "audio_id": "AUD0000001043",
        "title": "Asteroid of Fear",
        "url": "http//www.archive.org/download/asteroid_of_fear_1012_librivox/asteroid_of_fear_1012_librivox_64kb_mp3.zip",
        "source": 0,
        "category": 28,
        "original_full_path": "audio/audiobook/P0011/AUD0000001043.opus",
    },
]
```

Потоковый режим может вывести ваши исследования на новый уровень: вам не только доступны самые большие наборы данных, но вы
можете легко оценивать системы на нескольких наборах данных за один раз, не заботясь о дисковом пространстве. По сравнению с оценкой
на одном наборе данных, оценка на нескольких наборах дает более точную метрику обобщающих способностей 
системы распознавания речи (например, End-to-end Speech Benchmark (ESB)).

